# -*- coding: utf-8 -*-
# Generated by Django 1.11.8 on 2017-12-30 07:06
from __future__ import unicode_literals

import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models

import django_courier.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('contenttypes', '0002_remove_content_type_name'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Contact',
            fields=[
                ('id', models.AutoField(
                    auto_created=True, primary_key=True, serialize=False,
                    verbose_name='ID')),
                ('address', models.CharField(max_length=500)),
                ('backend', models.CharField(max_length=100)),
                ('user', models.ForeignKey(
                    on_delete=django.db.models.deletion.CASCADE,
                    to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'default_permissions': (),
                'verbose_name': 'contact',
            },
        ),
        migrations.CreateModel(
            name='Notification',
            fields=[
                ('id', models.AutoField(
                    auto_created=True, primary_key=True, serialize=False,
                    verbose_name='ID')),
                ('codename', models.CharField(max_length=100,
                                              verbose_name='codename')),
                ('content_type', models.ForeignKey(
                    on_delete=django.db.models.deletion.CASCADE,
                    to='contenttypes.ContentType',
                    verbose_name='content type')),
            ],
            managers=[
                ('objects', django_courier.models.NotificationManager()),
            ],
        ),
        migrations.CreateModel(
            name='Template',
            fields=[
                ('id', models.AutoField(
                    auto_created=True, primary_key=True, serialize=False,
                    verbose_name='ID')),
                ('backend', models.CharField(max_length=100)),
                ('content', models.TextField()),
                ('is_active', models.BooleanField(default=True)),
                ('notification', models.ForeignKey(
                    on_delete=django.db.models.deletion.CASCADE,
                    to='django_courier.Notification',
                    verbose_name='notification')),
            ],
            options={
                'default_permissions': (),
                'verbose_name': 'template',
            },
        ),
        migrations.AlterUniqueTogether(
            name='contact',
            unique_together={('user', 'address', 'backend')},
        ),
        migrations.AddField(
            model_name='notification',
            name='use_sender',
            field=models.BooleanField(),
        ),
        migrations.AddField(
            model_name='notification',
            name='use_recipient',
            field=models.BooleanField(default=True),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name='notification',
            name='description',
            field=models.TextField(default=''),
            preserve_default=False,
        ),
    ]
