"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WafIpRestrictRuleGroup = exports.Scope = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const waf = require("aws-cdk-lib/aws-wafv2");
var Scope;
(function (Scope) {
    Scope["GLOBAL"] = "Global";
    Scope["REGIONAL"] = "Regional";
})(Scope = exports.Scope || (exports.Scope = {}));
class WafIpRestrictRuleGroup extends waf.CfnRuleGroup {
    constructor(scope, id, props) {
        super(scope, id, {
            name: props.name,
            description: 'ip restrict rule group',
            scope: (() => {
                switch (props.scope) {
                    case Scope.GLOBAL:
                        return 'CLOUDFRONT';
                    case Scope.REGIONAL:
                        return 'REGIONAL';
                }
            })(),
            capacity: 10,
            rules: [
                {
                    priority: 0,
                    name: 'allow-ip-rule',
                    action: {
                        allow: {},
                    },
                    visibilityConfig: {
                        cloudWatchMetricsEnabled: true,
                        sampledRequestsEnabled: true,
                        metricName: 'AllowIpRule',
                    },
                    statement: {
                        ipSetReferenceStatement: {
                            arn: props.allowIpSetArn,
                        },
                    },
                },
                {
                    priority: 1,
                    name: 'deny-ip-rule',
                    action: {
                        block: {
                            CustomResponse: {
                                CustomResponseBodyKey: 'ip-restrict',
                                ResponseCode: 403,
                            },
                        },
                    },
                    visibilityConfig: {
                        cloudWatchMetricsEnabled: true,
                        sampledRequestsEnabled: true,
                        metricName: 'DenyIpRule',
                    },
                    statement: {
                        notStatement: {
                            statement: {
                                ipSetReferenceStatement: {
                                    arn: props.allowIpSetArn,
                                },
                            },
                        },
                    },
                },
            ],
            customResponseBodies: {
                ['ip-restrict']: {
                    contentType: 'TEXT_PLAIN',
                    content: 'Sorry, You Are Not Allowed to Access This Service.',
                },
            },
            visibilityConfig: {
                cloudWatchMetricsEnabled: true,
                sampledRequestsEnabled: true,
                metricName: 'IpRestrictRule',
            },
        });
    }
}
_a = JSII_RTTI_SYMBOL_1;
WafIpRestrictRuleGroup[_a] = { fqn: "@gammarer/aws-waf-ip-restriction-rule-group.WafIpRestrictRuleGroup", version: "1.1.2" };
exports.WafIpRestrictRuleGroup = WafIpRestrictRuleGroup;
//# sourceMappingURL=data:application/json;base64,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