# Generated by Django 4.1.2 on 2022-11-30 19:48

from django.db import migrations, models
import django.db.models.deletion
import edc_model_fields.fields.other_charfield


class Migration(migrations.Migration):
    dependencies = [
        ("edc_adverse_event", "0010_auto_20220913_2139"),
        ("meta_ae", "0015_auto_20220907_0157"),
    ]

    operations = [
        migrations.RenameField(
            model_name="aetmg",
            old_name="narrative",
            new_name="investigator_narrative",
        ),
        migrations.RenameField(
            model_name="historicalaetmg",
            old_name="narrative",
            new_name="investigator_narrative",
        ),
        migrations.AddField(
            model_name="aetmg",
            name="investigator_ae_classification",
            field=models.ForeignKey(
                help_text="Only applicable if this investigator does not agree with the original AE report",
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                to="edc_adverse_event.aeclassification",
                verbose_name="Adverse Event (AE) Classification",
            ),
        ),
        migrations.AddField(
            model_name="aetmg",
            name="investigator_ae_classification_agreed",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                default="N/A",
                help_text="If No, select a classification below",
                max_length=15,
                verbose_name="Does this investigator agree with the AE classification on the original AE report?",
            ),
        ),
        migrations.AddField(
            model_name="aetmg",
            name="investigator_ae_classification_other",
            field=edc_model_fields.fields.other_charfield.OtherCharField(
                blank=True,
                max_length=250,
                null=True,
                verbose_name="If other, please specify ...",
            ),
        ),
        migrations.AddField(
            model_name="historicalaetmg",
            name="investigator_ae_classification",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                help_text="Only applicable if this investigator does not agree with the original AE report",
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="edc_adverse_event.aeclassification",
                verbose_name="Adverse Event (AE) Classification",
            ),
        ),
        migrations.AddField(
            model_name="historicalaetmg",
            name="investigator_ae_classification_agreed",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                default="N/A",
                help_text="If No, select a classification below",
                max_length=15,
                verbose_name="Does this investigator agree with the AE classification on the original AE report?",
            ),
        ),
        migrations.AddField(
            model_name="historicalaetmg",
            name="investigator_ae_classification_other",
            field=edc_model_fields.fields.other_charfield.OtherCharField(
                blank=True,
                max_length=250,
                null=True,
                verbose_name="If other, please specify ...",
            ),
        ),
        migrations.AlterField(
            model_name="aefollowup",
            name="outcome",
            field=models.CharField(
                choices=[
                    ("continuing/update", "Continuing/Update"),
                    ("increase_from_g3", "Severity increased from Grade III"),
                    ("recovered", "Recovered/Resolved"),
                    ("recovering", "Recovering/Resolving at end of study"),
                    ("not_recovered", "Not Recovered/Resolved at end of study"),
                    ("LTFU", "Unknown/Lost to follow-up"),
                    ("recovered_with_sequelae", "Recovered with sequelae"),
                    ("dead", "Death"),
                    ("ae_withdrawn", "Adverse event report withdrawn after TMG review"),
                ],
                max_length=25,
            ),
        ),
        migrations.AlterField(
            model_name="historicalaefollowup",
            name="outcome",
            field=models.CharField(
                choices=[
                    ("continuing/update", "Continuing/Update"),
                    ("increase_from_g3", "Severity increased from Grade III"),
                    ("recovered", "Recovered/Resolved"),
                    ("recovering", "Recovering/Resolving at end of study"),
                    ("not_recovered", "Not Recovered/Resolved at end of study"),
                    ("LTFU", "Unknown/Lost to follow-up"),
                    ("recovered_with_sequelae", "Recovered with sequelae"),
                    ("dead", "Death"),
                    ("ae_withdrawn", "Adverse event report withdrawn after TMG review"),
                ],
                max_length=25,
            ),
        ),
    ]
