# Generated by Django 5.2.6 on 2025-09-24 05:45

import django.db.models.deletion
import django.utils.timezone
import django_revision.revision_field
import edc_model.validators.date
import edc_model_fields.fields.date_estimated
import edc_model_fields.fields.other_charfield
import edc_protocol.validators
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ("edc_adverse_event", "0017_alter_aeactionclassification_revision_and_more"),
        ("meta_ae", "0022_historicalhospitalization_hospitalization"),
    ]

    operations = [
        migrations.AlterField(
            model_name="aefollowup",
            name="action_identifier",
            field=models.CharField(blank=True, default="", max_length=50, unique=True),
        ),
        migrations.AlterField(
            model_name="aefollowup",
            name="action_item_reason",
            field=models.TextField(default="", editable=False),
        ),
        migrations.AlterField(
            model_name="aefollowup",
            name="device_created",
            field=models.CharField(
                blank=True, default="", max_length=10, verbose_name="Device created"
            ),
        ),
        migrations.AlterField(
            model_name="aefollowup",
            name="device_modified",
            field=models.CharField(
                blank=True, default="", max_length=10, verbose_name="Device modified"
            ),
        ),
        migrations.AlterField(
            model_name="aefollowup",
            name="locale_created",
            field=models.CharField(
                blank=True,
                default="",
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                verbose_name="Locale created",
            ),
        ),
        migrations.AlterField(
            model_name="aefollowup",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                default="",
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AlterField(
            model_name="aefollowup",
            name="parent_action_identifier",
            field=models.CharField(
                blank=True,
                default="",
                help_text="action identifier that links to parent reference model instance.",
                max_length=30,
            ),
        ),
        migrations.AlterField(
            model_name="aefollowup",
            name="related_action_identifier",
            field=models.CharField(
                blank=True,
                default="",
                help_text="action identifier that links to related reference model instance.",
                max_length=30,
            ),
        ),
        migrations.AlterField(
            model_name="aefollowup",
            name="report_datetime",
            field=models.DateTimeField(
                default=django.utils.timezone.now, verbose_name="Report date and time"
            ),
        ),
        migrations.AlterField(
            model_name="aefollowup",
            name="revision",
            field=django_revision.revision_field.RevisionField(
                blank=True,
                default="",
                editable=False,
                help_text="System field. From git repository (tag:branch:commit), project metadata, project toml, project VERSION, or settings.",
                max_length=75,
                verbose_name="Revision",
            ),
        ),
        migrations.AlterField(
            model_name="aeinitial",
            name="action_identifier",
            field=models.CharField(blank=True, default="", max_length=50, unique=True),
        ),
        migrations.AlterField(
            model_name="aeinitial",
            name="action_item_reason",
            field=models.TextField(default="", editable=False),
        ),
        migrations.AlterField(
            model_name="aeinitial",
            name="ae_awareness_date",
            field=models.DateField(
                default=django.utils.timezone.now,
                validators=[edc_model.validators.date.date_not_future],
                verbose_name="AE Awareness date",
            ),
        ),
        migrations.AlterField(
            model_name="aeinitial",
            name="ae_start_date",
            field=models.DateField(
                default=django.utils.timezone.now,
                validators=[edc_model.validators.date.date_not_future],
                verbose_name="Actual Start Date of AE",
            ),
        ),
        migrations.AlterField(
            model_name="aeinitial",
            name="device_created",
            field=models.CharField(
                blank=True, default="", max_length=10, verbose_name="Device created"
            ),
        ),
        migrations.AlterField(
            model_name="aeinitial",
            name="device_modified",
            field=models.CharField(
                blank=True, default="", max_length=10, verbose_name="Device modified"
            ),
        ),
        migrations.AlterField(
            model_name="aeinitial",
            name="locale_created",
            field=models.CharField(
                blank=True,
                default="",
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                verbose_name="Locale created",
            ),
        ),
        migrations.AlterField(
            model_name="aeinitial",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                default="",
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AlterField(
            model_name="aeinitial",
            name="parent_action_identifier",
            field=models.CharField(
                blank=True,
                default="",
                help_text="action identifier that links to parent reference model instance.",
                max_length=30,
            ),
        ),
        migrations.AlterField(
            model_name="aeinitial",
            name="related_action_identifier",
            field=models.CharField(
                blank=True,
                default="",
                help_text="action identifier that links to related reference model instance.",
                max_length=30,
            ),
        ),
        migrations.AlterField(
            model_name="aeinitial",
            name="report_datetime",
            field=models.DateTimeField(
                default=django.utils.timezone.now, verbose_name="Report Date and Time"
            ),
        ),
        migrations.AlterField(
            model_name="aeinitial",
            name="revision",
            field=django_revision.revision_field.RevisionField(
                blank=True,
                default="",
                editable=False,
                help_text="System field. From git repository (tag:branch:commit), project metadata, project toml, project VERSION, or settings.",
                max_length=75,
                verbose_name="Revision",
            ),
        ),
        migrations.AlterField(
            model_name="aelocalreview",
            name="ae_action_required",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="",
                max_length=25,
                verbose_name="If unexpected, do you believe further action is required?",
            ),
        ),
        migrations.AlterField(
            model_name="aelocalreview",
            name="ae_expected",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="",
                max_length=25,
                verbose_name="Based on the protocol, do you believe this event is expected?",
            ),
        ),
        migrations.AlterField(
            model_name="aelocalreview",
            name="device_created",
            field=models.CharField(
                blank=True, default="", max_length=10, verbose_name="Device created"
            ),
        ),
        migrations.AlterField(
            model_name="aelocalreview",
            name="device_modified",
            field=models.CharField(
                blank=True, default="", max_length=10, verbose_name="Device modified"
            ),
        ),
        migrations.AlterField(
            model_name="aelocalreview",
            name="investigator_comments",
            field=models.TextField(
                blank=True,
                default="",
                verbose_name="This Clinical Reviewer's comments:",
            ),
        ),
        migrations.AlterField(
            model_name="aelocalreview",
            name="locale_created",
            field=models.CharField(
                blank=True,
                default="",
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                verbose_name="Locale created",
            ),
        ),
        migrations.AlterField(
            model_name="aelocalreview",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                default="",
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AlterField(
            model_name="aelocalreview",
            name="narrative",
            field=models.TextField(blank=True, default="", verbose_name="Narrative"),
        ),
        migrations.AlterField(
            model_name="aelocalreview",
            name="original_report_agreed",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="",
                help_text="If No, explain in the narrative below",
                max_length=15,
                verbose_name="Does this Clinical Reviewer agree with the original AE report?",
            ),
        ),
        migrations.AlterField(
            model_name="aelocalreview",
            name="revision",
            field=django_revision.revision_field.RevisionField(
                blank=True,
                default="",
                editable=False,
                help_text="System field. From git repository (tag:branch:commit), project metadata, project toml, project VERSION, or settings.",
                max_length=75,
                verbose_name="Revision",
            ),
        ),
        migrations.AlterField(
            model_name="aelocalreview",
            name="study_drug_relation",
            field=models.CharField(
                choices=[
                    ("not_related", "Not related"),
                    ("unlikely_related", "Unlikely related"),
                    ("possibly_related", "Possibly related"),
                    ("probably_related", "Probably related"),
                    ("definitely_related", "Definitely related"),
                    ("N/A", "Not applicable"),
                ],
                default="",
                max_length=25,
                verbose_name="Relationship to study drug:",
            ),
        ),
        migrations.AlterField(
            model_name="aesponsorreview",
            name="ae_action_required",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="",
                max_length=25,
                verbose_name="If unexpected, do you believe further action is required?",
            ),
        ),
        migrations.AlterField(
            model_name="aesponsorreview",
            name="ae_expected",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="",
                max_length=25,
                verbose_name="Based on the protocol, do you believe this event is expected?",
            ),
        ),
        migrations.AlterField(
            model_name="aesponsorreview",
            name="device_created",
            field=models.CharField(
                blank=True, default="", max_length=10, verbose_name="Device created"
            ),
        ),
        migrations.AlterField(
            model_name="aesponsorreview",
            name="device_modified",
            field=models.CharField(
                blank=True, default="", max_length=10, verbose_name="Device modified"
            ),
        ),
        migrations.AlterField(
            model_name="aesponsorreview",
            name="investigator_comments",
            field=models.TextField(
                blank=True,
                default="",
                verbose_name="This Clinical Reviewer's comments:",
            ),
        ),
        migrations.AlterField(
            model_name="aesponsorreview",
            name="locale_created",
            field=models.CharField(
                blank=True,
                default="",
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                verbose_name="Locale created",
            ),
        ),
        migrations.AlterField(
            model_name="aesponsorreview",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                default="",
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AlterField(
            model_name="aesponsorreview",
            name="narrative",
            field=models.TextField(blank=True, default="", verbose_name="Narrative"),
        ),
        migrations.AlterField(
            model_name="aesponsorreview",
            name="original_report_agreed",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="",
                help_text="If No, explain in the narrative below",
                max_length=15,
                verbose_name="Does this Clinical Reviewer agree with the original AE report?",
            ),
        ),
        migrations.AlterField(
            model_name="aesponsorreview",
            name="revision",
            field=django_revision.revision_field.RevisionField(
                blank=True,
                default="",
                editable=False,
                help_text="System field. From git repository (tag:branch:commit), project metadata, project toml, project VERSION, or settings.",
                max_length=75,
                verbose_name="Revision",
            ),
        ),
        migrations.AlterField(
            model_name="aesponsorreview",
            name="study_drug_relation",
            field=models.CharField(
                choices=[
                    ("not_related", "Not related"),
                    ("unlikely_related", "Unlikely related"),
                    ("possibly_related", "Possibly related"),
                    ("probably_related", "Probably related"),
                    ("definitely_related", "Definitely related"),
                    ("N/A", "Not applicable"),
                ],
                default="",
                max_length=25,
                verbose_name="Relationship to study drug:",
            ),
        ),
        migrations.AlterField(
            model_name="aesusar",
            name="action_identifier",
            field=models.CharField(blank=True, default="", max_length=50, unique=True),
        ),
        migrations.AlterField(
            model_name="aesusar",
            name="action_item_reason",
            field=models.TextField(default="", editable=False),
        ),
        migrations.AlterField(
            model_name="aesusar",
            name="device_created",
            field=models.CharField(
                blank=True, default="", max_length=10, verbose_name="Device created"
            ),
        ),
        migrations.AlterField(
            model_name="aesusar",
            name="device_modified",
            field=models.CharField(
                blank=True, default="", max_length=10, verbose_name="Device modified"
            ),
        ),
        migrations.AlterField(
            model_name="aesusar",
            name="locale_created",
            field=models.CharField(
                blank=True,
                default="",
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                verbose_name="Locale created",
            ),
        ),
        migrations.AlterField(
            model_name="aesusar",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                default="",
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AlterField(
            model_name="aesusar",
            name="parent_action_identifier",
            field=models.CharField(
                blank=True,
                default="",
                help_text="action identifier that links to parent reference model instance.",
                max_length=30,
            ),
        ),
        migrations.AlterField(
            model_name="aesusar",
            name="related_action_identifier",
            field=models.CharField(
                blank=True,
                default="",
                help_text="action identifier that links to related reference model instance.",
                max_length=30,
            ),
        ),
        migrations.AlterField(
            model_name="aesusar",
            name="report_datetime",
            field=models.DateTimeField(
                default=django.utils.timezone.now,
                validators=[edc_model.validators.date.datetime_not_future],
                verbose_name="Report date and time",
            ),
        ),
        migrations.AlterField(
            model_name="aesusar",
            name="revision",
            field=django_revision.revision_field.RevisionField(
                blank=True,
                default="",
                editable=False,
                help_text="System field. From git repository (tag:branch:commit), project metadata, project toml, project VERSION, or settings.",
                max_length=75,
                verbose_name="Revision",
            ),
        ),
        migrations.AlterField(
            model_name="aetmg",
            name="action_identifier",
            field=models.CharField(blank=True, default="", max_length=50, unique=True),
        ),
        migrations.AlterField(
            model_name="aetmg",
            name="action_item_reason",
            field=models.TextField(default="", editable=False),
        ),
        migrations.AlterField(
            model_name="aetmg",
            name="ae_classification",
            field=models.CharField(blank=True, default="", max_length=150),
        ),
        migrations.AlterField(
            model_name="aetmg",
            name="ae_classification_other",
            field=edc_model_fields.fields.other_charfield.OtherCharField(
                blank=True,
                default="",
                max_length=250,
                verbose_name="If other, please specify ...",
            ),
        ),
        migrations.AlterField(
            model_name="aetmg",
            name="ae_description",
            field=models.TextField(
                blank=True, default="", verbose_name="Description of AE:"
            ),
        ),
        migrations.AlterField(
            model_name="aetmg",
            name="device_created",
            field=models.CharField(
                blank=True, default="", max_length=10, verbose_name="Device created"
            ),
        ),
        migrations.AlterField(
            model_name="aetmg",
            name="device_modified",
            field=models.CharField(
                blank=True, default="", max_length=10, verbose_name="Device modified"
            ),
        ),
        migrations.AlterField(
            model_name="aetmg",
            name="investigator_ae_classification_other",
            field=edc_model_fields.fields.other_charfield.OtherCharField(
                blank=True,
                default="",
                max_length=250,
                verbose_name="If other, please specify ...",
            ),
        ),
        migrations.AlterField(
            model_name="aetmg",
            name="investigator_comments",
            field=models.TextField(
                blank=True, default="", verbose_name="This investigator's comments:"
            ),
        ),
        migrations.AlterField(
            model_name="aetmg",
            name="investigator_narrative",
            field=models.TextField(blank=True, default="", verbose_name="Narrative"),
        ),
        migrations.AlterField(
            model_name="aetmg",
            name="locale_created",
            field=models.CharField(
                blank=True,
                default="",
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                verbose_name="Locale created",
            ),
        ),
        migrations.AlterField(
            model_name="aetmg",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                default="",
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AlterField(
            model_name="aetmg",
            name="original_report_agreed",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="",
                help_text="If No, explain in the narrative below",
                max_length=15,
                verbose_name="Does this investigator agree with the original AE report?",
            ),
        ),
        migrations.AlterField(
            model_name="aetmg",
            name="parent_action_identifier",
            field=models.CharField(
                blank=True,
                default="",
                help_text="action identifier that links to parent reference model instance.",
                max_length=30,
            ),
        ),
        migrations.AlterField(
            model_name="aetmg",
            name="related_action_identifier",
            field=models.CharField(
                blank=True,
                default="",
                help_text="action identifier that links to related reference model instance.",
                max_length=30,
            ),
        ),
        migrations.AlterField(
            model_name="aetmg",
            name="report_datetime",
            field=models.DateTimeField(
                default=django.utils.timezone.now,
                validators=[edc_model.validators.date.datetime_not_future],
                verbose_name="Report date and time",
            ),
        ),
        migrations.AlterField(
            model_name="aetmg",
            name="revision",
            field=django_revision.revision_field.RevisionField(
                blank=True,
                default="",
                editable=False,
                help_text="System field. From git repository (tag:branch:commit), project metadata, project toml, project VERSION, or settings.",
                max_length=75,
                verbose_name="Revision",
            ),
        ),
        migrations.AlterField(
            model_name="aetmg",
            name="slug",
            field=models.CharField(
                db_index=True,
                default="",
                editable=False,
                help_text="Hold slug field values for quick search. Excludes encrypted fields",
                max_length=250,
            ),
        ),
        migrations.AlterField(
            model_name="deathreport",
            name="action_identifier",
            field=models.CharField(blank=True, default="", max_length=50, unique=True),
        ),
        migrations.AlterField(
            model_name="deathreport",
            name="action_item_reason",
            field=models.TextField(default="", editable=False),
        ),
        migrations.AlterField(
            model_name="deathreport",
            name="cause_of_death_other",
            field=edc_model_fields.fields.other_charfield.OtherCharField(
                blank=True,
                default="",
                max_length=100,
                verbose_name="If other, please specify ...",
            ),
        ),
        migrations.AlterField(
            model_name="deathreport",
            name="death_as_inpatient",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="",
                max_length=5,
                verbose_name="Death as inpatient",
            ),
        ),
        migrations.AlterField(
            model_name="deathreport",
            name="device_created",
            field=models.CharField(
                blank=True, default="", max_length=10, verbose_name="Device created"
            ),
        ),
        migrations.AlterField(
            model_name="deathreport",
            name="device_modified",
            field=models.CharField(
                blank=True, default="", max_length=10, verbose_name="Device modified"
            ),
        ),
        migrations.AlterField(
            model_name="deathreport",
            name="hospital_name",
            field=models.CharField(
                blank=True,
                default="",
                max_length=150,
                verbose_name="If death occurred at hospital / clinic, please give name of the facility",
            ),
        ),
        migrations.AlterField(
            model_name="deathreport",
            name="locale_created",
            field=models.CharField(
                blank=True,
                default="",
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                verbose_name="Locale created",
            ),
        ),
        migrations.AlterField(
            model_name="deathreport",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                default="",
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AlterField(
            model_name="deathreport",
            name="narrative",
            field=models.TextField(default="", verbose_name="Narrative"),
        ),
        migrations.AlterField(
            model_name="deathreport",
            name="other_informant_relationship",
            field=edc_model_fields.fields.other_charfield.OtherCharField(
                blank=True,
                default="",
                max_length=35,
                verbose_name="If other, please specify ...",
            ),
        ),
        migrations.AlterField(
            model_name="deathreport",
            name="parent_action_identifier",
            field=models.CharField(
                blank=True,
                default="",
                help_text="action identifier that links to parent reference model instance.",
                max_length=30,
            ),
        ),
        migrations.AlterField(
            model_name="deathreport",
            name="related_action_identifier",
            field=models.CharField(
                blank=True,
                default="",
                help_text="action identifier that links to related reference model instance.",
                max_length=30,
            ),
        ),
        migrations.AlterField(
            model_name="deathreport",
            name="report_datetime",
            field=models.DateTimeField(
                default=django.utils.timezone.now,
                validators=[
                    edc_protocol.validators.datetime_not_before_study_start,
                    edc_model.validators.date.datetime_not_future,
                ],
                verbose_name="Report Date",
            ),
        ),
        migrations.AlterField(
            model_name="deathreport",
            name="revision",
            field=django_revision.revision_field.RevisionField(
                blank=True,
                default="",
                editable=False,
                help_text="System field. From git repository (tag:branch:commit), project metadata, project toml, project VERSION, or settings.",
                max_length=75,
                verbose_name="Revision",
            ),
        ),
        migrations.AlterField(
            model_name="deathreport",
            name="secondary_cause_of_death_other",
            field=models.CharField(
                blank=True,
                default="",
                max_length=100,
                verbose_name='If "Other" above, please specify',
            ),
        ),
        migrations.AlterField(
            model_name="deathreporttmg",
            name="action_identifier",
            field=models.CharField(blank=True, default="", max_length=50, unique=True),
        ),
        migrations.AlterField(
            model_name="deathreporttmg",
            name="action_item_reason",
            field=models.TextField(default="", editable=False),
        ),
        migrations.AlterField(
            model_name="deathreporttmg",
            name="cause_of_death",
            field=models.ForeignKey(
                default="",
                help_text="Main cause of death in the opinion of the local study doctor and local PI",
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                to="edc_adverse_event.causeofdeath",
                verbose_name="Main cause of death",
            ),
        ),
        migrations.AlterField(
            model_name="deathreporttmg",
            name="cause_of_death_agreed",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="",
                help_text="If No, explain in the narrative below",
                max_length=15,
                verbose_name="Is the cause of death agreed between study doctor and TMG member?",
            ),
        ),
        migrations.AlterField(
            model_name="deathreporttmg",
            name="cause_of_death_other",
            field=models.CharField(
                blank=True,
                default="",
                max_length=100,
                verbose_name='If "Other" above, please specify',
            ),
        ),
        migrations.AlterField(
            model_name="deathreporttmg",
            name="device_created",
            field=models.CharField(
                blank=True, default="", max_length=10, verbose_name="Device created"
            ),
        ),
        migrations.AlterField(
            model_name="deathreporttmg",
            name="device_modified",
            field=models.CharField(
                blank=True, default="", max_length=10, verbose_name="Device modified"
            ),
        ),
        migrations.AlterField(
            model_name="deathreporttmg",
            name="locale_created",
            field=models.CharField(
                blank=True,
                default="",
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                verbose_name="Locale created",
            ),
        ),
        migrations.AlterField(
            model_name="deathreporttmg",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                default="",
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AlterField(
            model_name="deathreporttmg",
            name="narrative",
            field=models.TextField(blank=True, default="", verbose_name="Narrative"),
        ),
        migrations.AlterField(
            model_name="deathreporttmg",
            name="parent_action_identifier",
            field=models.CharField(
                blank=True,
                default="",
                help_text="action identifier that links to parent reference model instance.",
                max_length=30,
            ),
        ),
        migrations.AlterField(
            model_name="deathreporttmg",
            name="related_action_identifier",
            field=models.CharField(
                blank=True,
                default="",
                help_text="action identifier that links to related reference model instance.",
                max_length=30,
            ),
        ),
        migrations.AlterField(
            model_name="deathreporttmg",
            name="report_datetime",
            field=models.DateTimeField(
                default=django.utils.timezone.now,
                validators=[
                    edc_protocol.validators.datetime_not_before_study_start,
                    edc_model.validators.date.datetime_not_future,
                ],
                verbose_name="Report Date",
            ),
        ),
        migrations.AlterField(
            model_name="deathreporttmg",
            name="revision",
            field=django_revision.revision_field.RevisionField(
                blank=True,
                default="",
                editable=False,
                help_text="System field. From git repository (tag:branch:commit), project metadata, project toml, project VERSION, or settings.",
                max_length=75,
                verbose_name="Revision",
            ),
        ),
        migrations.AlterField(
            model_name="historicalaefollowup",
            name="action_identifier",
            field=models.CharField(
                blank=True, db_index=True, default="", max_length=50
            ),
        ),
        migrations.AlterField(
            model_name="historicalaefollowup",
            name="action_item_reason",
            field=models.TextField(default="", editable=False),
        ),
        migrations.AlterField(
            model_name="historicalaefollowup",
            name="device_created",
            field=models.CharField(
                blank=True, default="", max_length=10, verbose_name="Device created"
            ),
        ),
        migrations.AlterField(
            model_name="historicalaefollowup",
            name="device_modified",
            field=models.CharField(
                blank=True, default="", max_length=10, verbose_name="Device modified"
            ),
        ),
        migrations.AlterField(
            model_name="historicalaefollowup",
            name="locale_created",
            field=models.CharField(
                blank=True,
                default="",
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                verbose_name="Locale created",
            ),
        ),
        migrations.AlterField(
            model_name="historicalaefollowup",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                default="",
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AlterField(
            model_name="historicalaefollowup",
            name="parent_action_identifier",
            field=models.CharField(
                blank=True,
                default="",
                help_text="action identifier that links to parent reference model instance.",
                max_length=30,
            ),
        ),
        migrations.AlterField(
            model_name="historicalaefollowup",
            name="related_action_identifier",
            field=models.CharField(
                blank=True,
                default="",
                help_text="action identifier that links to related reference model instance.",
                max_length=30,
            ),
        ),
        migrations.AlterField(
            model_name="historicalaefollowup",
            name="report_datetime",
            field=models.DateTimeField(
                default=django.utils.timezone.now, verbose_name="Report date and time"
            ),
        ),
        migrations.AlterField(
            model_name="historicalaefollowup",
            name="revision",
            field=django_revision.revision_field.RevisionField(
                blank=True,
                default="",
                editable=False,
                help_text="System field. From git repository (tag:branch:commit), project metadata, project toml, project VERSION, or settings.",
                max_length=75,
                verbose_name="Revision",
            ),
        ),
        migrations.AlterField(
            model_name="historicalaeinitial",
            name="action_identifier",
            field=models.CharField(
                blank=True, db_index=True, default="", max_length=50
            ),
        ),
        migrations.AlterField(
            model_name="historicalaeinitial",
            name="action_item_reason",
            field=models.TextField(default="", editable=False),
        ),
        migrations.AlterField(
            model_name="historicalaeinitial",
            name="ae_awareness_date",
            field=models.DateField(
                default=django.utils.timezone.now,
                validators=[edc_model.validators.date.date_not_future],
                verbose_name="AE Awareness date",
            ),
        ),
        migrations.AlterField(
            model_name="historicalaeinitial",
            name="ae_start_date",
            field=models.DateField(
                default=django.utils.timezone.now,
                validators=[edc_model.validators.date.date_not_future],
                verbose_name="Actual Start Date of AE",
            ),
        ),
        migrations.AlterField(
            model_name="historicalaeinitial",
            name="device_created",
            field=models.CharField(
                blank=True, default="", max_length=10, verbose_name="Device created"
            ),
        ),
        migrations.AlterField(
            model_name="historicalaeinitial",
            name="device_modified",
            field=models.CharField(
                blank=True, default="", max_length=10, verbose_name="Device modified"
            ),
        ),
        migrations.AlterField(
            model_name="historicalaeinitial",
            name="locale_created",
            field=models.CharField(
                blank=True,
                default="",
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                verbose_name="Locale created",
            ),
        ),
        migrations.AlterField(
            model_name="historicalaeinitial",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                default="",
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AlterField(
            model_name="historicalaeinitial",
            name="parent_action_identifier",
            field=models.CharField(
                blank=True,
                default="",
                help_text="action identifier that links to parent reference model instance.",
                max_length=30,
            ),
        ),
        migrations.AlterField(
            model_name="historicalaeinitial",
            name="related_action_identifier",
            field=models.CharField(
                blank=True,
                default="",
                help_text="action identifier that links to related reference model instance.",
                max_length=30,
            ),
        ),
        migrations.AlterField(
            model_name="historicalaeinitial",
            name="report_datetime",
            field=models.DateTimeField(
                default=django.utils.timezone.now, verbose_name="Report Date and Time"
            ),
        ),
        migrations.AlterField(
            model_name="historicalaeinitial",
            name="revision",
            field=django_revision.revision_field.RevisionField(
                blank=True,
                default="",
                editable=False,
                help_text="System field. From git repository (tag:branch:commit), project metadata, project toml, project VERSION, or settings.",
                max_length=75,
                verbose_name="Revision",
            ),
        ),
        migrations.AlterField(
            model_name="historicalaesusar",
            name="action_identifier",
            field=models.CharField(
                blank=True, db_index=True, default="", max_length=50
            ),
        ),
        migrations.AlterField(
            model_name="historicalaesusar",
            name="action_item_reason",
            field=models.TextField(default="", editable=False),
        ),
        migrations.AlterField(
            model_name="historicalaesusar",
            name="device_created",
            field=models.CharField(
                blank=True, default="", max_length=10, verbose_name="Device created"
            ),
        ),
        migrations.AlterField(
            model_name="historicalaesusar",
            name="device_modified",
            field=models.CharField(
                blank=True, default="", max_length=10, verbose_name="Device modified"
            ),
        ),
        migrations.AlterField(
            model_name="historicalaesusar",
            name="locale_created",
            field=models.CharField(
                blank=True,
                default="",
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                verbose_name="Locale created",
            ),
        ),
        migrations.AlterField(
            model_name="historicalaesusar",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                default="",
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AlterField(
            model_name="historicalaesusar",
            name="parent_action_identifier",
            field=models.CharField(
                blank=True,
                default="",
                help_text="action identifier that links to parent reference model instance.",
                max_length=30,
            ),
        ),
        migrations.AlterField(
            model_name="historicalaesusar",
            name="related_action_identifier",
            field=models.CharField(
                blank=True,
                default="",
                help_text="action identifier that links to related reference model instance.",
                max_length=30,
            ),
        ),
        migrations.AlterField(
            model_name="historicalaesusar",
            name="report_datetime",
            field=models.DateTimeField(
                default=django.utils.timezone.now,
                validators=[edc_model.validators.date.datetime_not_future],
                verbose_name="Report date and time",
            ),
        ),
        migrations.AlterField(
            model_name="historicalaesusar",
            name="revision",
            field=django_revision.revision_field.RevisionField(
                blank=True,
                default="",
                editable=False,
                help_text="System field. From git repository (tag:branch:commit), project metadata, project toml, project VERSION, or settings.",
                max_length=75,
                verbose_name="Revision",
            ),
        ),
        migrations.AlterField(
            model_name="historicalaetmg",
            name="action_identifier",
            field=models.CharField(
                blank=True, db_index=True, default="", max_length=50
            ),
        ),
        migrations.AlterField(
            model_name="historicalaetmg",
            name="action_item_reason",
            field=models.TextField(default="", editable=False),
        ),
        migrations.AlterField(
            model_name="historicalaetmg",
            name="ae_classification",
            field=models.CharField(blank=True, default="", max_length=150),
        ),
        migrations.AlterField(
            model_name="historicalaetmg",
            name="ae_classification_other",
            field=edc_model_fields.fields.other_charfield.OtherCharField(
                blank=True,
                default="",
                max_length=250,
                verbose_name="If other, please specify ...",
            ),
        ),
        migrations.AlterField(
            model_name="historicalaetmg",
            name="ae_description",
            field=models.TextField(
                blank=True, default="", verbose_name="Description of AE:"
            ),
        ),
        migrations.AlterField(
            model_name="historicalaetmg",
            name="device_created",
            field=models.CharField(
                blank=True, default="", max_length=10, verbose_name="Device created"
            ),
        ),
        migrations.AlterField(
            model_name="historicalaetmg",
            name="device_modified",
            field=models.CharField(
                blank=True, default="", max_length=10, verbose_name="Device modified"
            ),
        ),
        migrations.AlterField(
            model_name="historicalaetmg",
            name="investigator_ae_classification_other",
            field=edc_model_fields.fields.other_charfield.OtherCharField(
                blank=True,
                default="",
                max_length=250,
                verbose_name="If other, please specify ...",
            ),
        ),
        migrations.AlterField(
            model_name="historicalaetmg",
            name="investigator_comments",
            field=models.TextField(
                blank=True, default="", verbose_name="This investigator's comments:"
            ),
        ),
        migrations.AlterField(
            model_name="historicalaetmg",
            name="investigator_narrative",
            field=models.TextField(blank=True, default="", verbose_name="Narrative"),
        ),
        migrations.AlterField(
            model_name="historicalaetmg",
            name="locale_created",
            field=models.CharField(
                blank=True,
                default="",
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                verbose_name="Locale created",
            ),
        ),
        migrations.AlterField(
            model_name="historicalaetmg",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                default="",
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AlterField(
            model_name="historicalaetmg",
            name="original_report_agreed",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="",
                help_text="If No, explain in the narrative below",
                max_length=15,
                verbose_name="Does this investigator agree with the original AE report?",
            ),
        ),
        migrations.AlterField(
            model_name="historicalaetmg",
            name="parent_action_identifier",
            field=models.CharField(
                blank=True,
                default="",
                help_text="action identifier that links to parent reference model instance.",
                max_length=30,
            ),
        ),
        migrations.AlterField(
            model_name="historicalaetmg",
            name="related_action_identifier",
            field=models.CharField(
                blank=True,
                default="",
                help_text="action identifier that links to related reference model instance.",
                max_length=30,
            ),
        ),
        migrations.AlterField(
            model_name="historicalaetmg",
            name="report_datetime",
            field=models.DateTimeField(
                default=django.utils.timezone.now,
                validators=[edc_model.validators.date.datetime_not_future],
                verbose_name="Report date and time",
            ),
        ),
        migrations.AlterField(
            model_name="historicalaetmg",
            name="revision",
            field=django_revision.revision_field.RevisionField(
                blank=True,
                default="",
                editable=False,
                help_text="System field. From git repository (tag:branch:commit), project metadata, project toml, project VERSION, or settings.",
                max_length=75,
                verbose_name="Revision",
            ),
        ),
        migrations.AlterField(
            model_name="historicalaetmg",
            name="slug",
            field=models.CharField(
                db_index=True,
                default="",
                editable=False,
                help_text="Hold slug field values for quick search. Excludes encrypted fields",
                max_length=250,
            ),
        ),
        migrations.AlterField(
            model_name="historicaldeathreport",
            name="action_identifier",
            field=models.CharField(
                blank=True, db_index=True, default="", max_length=50
            ),
        ),
        migrations.AlterField(
            model_name="historicaldeathreport",
            name="action_item_reason",
            field=models.TextField(default="", editable=False),
        ),
        migrations.AlterField(
            model_name="historicaldeathreport",
            name="cause_of_death_other",
            field=edc_model_fields.fields.other_charfield.OtherCharField(
                blank=True,
                default="",
                max_length=100,
                verbose_name="If other, please specify ...",
            ),
        ),
        migrations.AlterField(
            model_name="historicaldeathreport",
            name="death_as_inpatient",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="",
                max_length=5,
                verbose_name="Death as inpatient",
            ),
        ),
        migrations.AlterField(
            model_name="historicaldeathreport",
            name="device_created",
            field=models.CharField(
                blank=True, default="", max_length=10, verbose_name="Device created"
            ),
        ),
        migrations.AlterField(
            model_name="historicaldeathreport",
            name="device_modified",
            field=models.CharField(
                blank=True, default="", max_length=10, verbose_name="Device modified"
            ),
        ),
        migrations.AlterField(
            model_name="historicaldeathreport",
            name="hospital_name",
            field=models.CharField(
                blank=True,
                default="",
                max_length=150,
                verbose_name="If death occurred at hospital / clinic, please give name of the facility",
            ),
        ),
        migrations.AlterField(
            model_name="historicaldeathreport",
            name="locale_created",
            field=models.CharField(
                blank=True,
                default="",
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                verbose_name="Locale created",
            ),
        ),
        migrations.AlterField(
            model_name="historicaldeathreport",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                default="",
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AlterField(
            model_name="historicaldeathreport",
            name="narrative",
            field=models.TextField(default="", verbose_name="Narrative"),
        ),
        migrations.AlterField(
            model_name="historicaldeathreport",
            name="other_informant_relationship",
            field=edc_model_fields.fields.other_charfield.OtherCharField(
                blank=True,
                default="",
                max_length=35,
                verbose_name="If other, please specify ...",
            ),
        ),
        migrations.AlterField(
            model_name="historicaldeathreport",
            name="parent_action_identifier",
            field=models.CharField(
                blank=True,
                default="",
                help_text="action identifier that links to parent reference model instance.",
                max_length=30,
            ),
        ),
        migrations.AlterField(
            model_name="historicaldeathreport",
            name="related_action_identifier",
            field=models.CharField(
                blank=True,
                default="",
                help_text="action identifier that links to related reference model instance.",
                max_length=30,
            ),
        ),
        migrations.AlterField(
            model_name="historicaldeathreport",
            name="report_datetime",
            field=models.DateTimeField(
                default=django.utils.timezone.now,
                validators=[
                    edc_protocol.validators.datetime_not_before_study_start,
                    edc_model.validators.date.datetime_not_future,
                ],
                verbose_name="Report Date",
            ),
        ),
        migrations.AlterField(
            model_name="historicaldeathreport",
            name="revision",
            field=django_revision.revision_field.RevisionField(
                blank=True,
                default="",
                editable=False,
                help_text="System field. From git repository (tag:branch:commit), project metadata, project toml, project VERSION, or settings.",
                max_length=75,
                verbose_name="Revision",
            ),
        ),
        migrations.AlterField(
            model_name="historicaldeathreport",
            name="secondary_cause_of_death_other",
            field=models.CharField(
                blank=True,
                default="",
                max_length=100,
                verbose_name='If "Other" above, please specify',
            ),
        ),
        migrations.AlterField(
            model_name="historicaldeathreporttmg",
            name="action_identifier",
            field=models.CharField(
                blank=True, db_index=True, default="", max_length=50
            ),
        ),
        migrations.AlterField(
            model_name="historicaldeathreporttmg",
            name="action_item_reason",
            field=models.TextField(default="", editable=False),
        ),
        migrations.AlterField(
            model_name="historicaldeathreporttmg",
            name="cause_of_death",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                default="",
                help_text="Main cause of death in the opinion of the local study doctor and local PI",
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="edc_adverse_event.causeofdeath",
                verbose_name="Main cause of death",
            ),
        ),
        migrations.AlterField(
            model_name="historicaldeathreporttmg",
            name="cause_of_death_agreed",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="",
                help_text="If No, explain in the narrative below",
                max_length=15,
                verbose_name="Is the cause of death agreed between study doctor and TMG member?",
            ),
        ),
        migrations.AlterField(
            model_name="historicaldeathreporttmg",
            name="cause_of_death_other",
            field=models.CharField(
                blank=True,
                default="",
                max_length=100,
                verbose_name='If "Other" above, please specify',
            ),
        ),
        migrations.AlterField(
            model_name="historicaldeathreporttmg",
            name="device_created",
            field=models.CharField(
                blank=True, default="", max_length=10, verbose_name="Device created"
            ),
        ),
        migrations.AlterField(
            model_name="historicaldeathreporttmg",
            name="device_modified",
            field=models.CharField(
                blank=True, default="", max_length=10, verbose_name="Device modified"
            ),
        ),
        migrations.AlterField(
            model_name="historicaldeathreporttmg",
            name="locale_created",
            field=models.CharField(
                blank=True,
                default="",
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                verbose_name="Locale created",
            ),
        ),
        migrations.AlterField(
            model_name="historicaldeathreporttmg",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                default="",
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AlterField(
            model_name="historicaldeathreporttmg",
            name="narrative",
            field=models.TextField(blank=True, default="", verbose_name="Narrative"),
        ),
        migrations.AlterField(
            model_name="historicaldeathreporttmg",
            name="parent_action_identifier",
            field=models.CharField(
                blank=True,
                default="",
                help_text="action identifier that links to parent reference model instance.",
                max_length=30,
            ),
        ),
        migrations.AlterField(
            model_name="historicaldeathreporttmg",
            name="related_action_identifier",
            field=models.CharField(
                blank=True,
                default="",
                help_text="action identifier that links to related reference model instance.",
                max_length=30,
            ),
        ),
        migrations.AlterField(
            model_name="historicaldeathreporttmg",
            name="report_datetime",
            field=models.DateTimeField(
                default=django.utils.timezone.now,
                validators=[
                    edc_protocol.validators.datetime_not_before_study_start,
                    edc_model.validators.date.datetime_not_future,
                ],
                verbose_name="Report Date",
            ),
        ),
        migrations.AlterField(
            model_name="historicaldeathreporttmg",
            name="revision",
            field=django_revision.revision_field.RevisionField(
                blank=True,
                default="",
                editable=False,
                help_text="System field. From git repository (tag:branch:commit), project metadata, project toml, project VERSION, or settings.",
                max_length=75,
                verbose_name="Revision",
            ),
        ),
        migrations.AlterField(
            model_name="historicaldeathreporttmgsecond",
            name="action_identifier",
            field=models.CharField(
                blank=True, db_index=True, default="", max_length=50
            ),
        ),
        migrations.AlterField(
            model_name="historicaldeathreporttmgsecond",
            name="action_item_reason",
            field=models.TextField(default="", editable=False),
        ),
        migrations.AlterField(
            model_name="historicaldeathreporttmgsecond",
            name="cause_of_death",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                default="",
                help_text="Main cause of death in the opinion of the local study doctor and local PI",
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="edc_adverse_event.causeofdeath",
                verbose_name="Main cause of death",
            ),
        ),
        migrations.AlterField(
            model_name="historicaldeathreporttmgsecond",
            name="cause_of_death_agreed",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="",
                help_text="If No, explain in the narrative below",
                max_length=15,
                verbose_name="Is the cause of death agreed between study doctor and TMG member?",
            ),
        ),
        migrations.AlterField(
            model_name="historicaldeathreporttmgsecond",
            name="cause_of_death_other",
            field=models.CharField(
                blank=True,
                default="",
                max_length=100,
                verbose_name='If "Other" above, please specify',
            ),
        ),
        migrations.AlterField(
            model_name="historicaldeathreporttmgsecond",
            name="device_created",
            field=models.CharField(
                blank=True, default="", max_length=10, verbose_name="Device created"
            ),
        ),
        migrations.AlterField(
            model_name="historicaldeathreporttmgsecond",
            name="device_modified",
            field=models.CharField(
                blank=True, default="", max_length=10, verbose_name="Device modified"
            ),
        ),
        migrations.AlterField(
            model_name="historicaldeathreporttmgsecond",
            name="locale_created",
            field=models.CharField(
                blank=True,
                default="",
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                verbose_name="Locale created",
            ),
        ),
        migrations.AlterField(
            model_name="historicaldeathreporttmgsecond",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                default="",
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AlterField(
            model_name="historicaldeathreporttmgsecond",
            name="narrative",
            field=models.TextField(blank=True, default="", verbose_name="Narrative"),
        ),
        migrations.AlterField(
            model_name="historicaldeathreporttmgsecond",
            name="parent_action_identifier",
            field=models.CharField(
                blank=True,
                default="",
                help_text="action identifier that links to parent reference model instance.",
                max_length=30,
            ),
        ),
        migrations.AlterField(
            model_name="historicaldeathreporttmgsecond",
            name="related_action_identifier",
            field=models.CharField(
                blank=True,
                default="",
                help_text="action identifier that links to related reference model instance.",
                max_length=30,
            ),
        ),
        migrations.AlterField(
            model_name="historicaldeathreporttmgsecond",
            name="report_datetime",
            field=models.DateTimeField(
                default=django.utils.timezone.now,
                validators=[
                    edc_protocol.validators.datetime_not_before_study_start,
                    edc_model.validators.date.datetime_not_future,
                ],
                verbose_name="Report Date",
            ),
        ),
        migrations.AlterField(
            model_name="historicaldeathreporttmgsecond",
            name="revision",
            field=django_revision.revision_field.RevisionField(
                blank=True,
                default="",
                editable=False,
                help_text="System field. From git repository (tag:branch:commit), project metadata, project toml, project VERSION, or settings.",
                max_length=75,
                verbose_name="Revision",
            ),
        ),
        migrations.AlterField(
            model_name="historicalhospitalization",
            name="action_identifier",
            field=models.CharField(
                blank=True, db_index=True, default="", max_length=50
            ),
        ),
        migrations.AlterField(
            model_name="historicalhospitalization",
            name="action_item_reason",
            field=models.TextField(default="", editable=False),
        ),
        migrations.AlterField(
            model_name="historicalhospitalization",
            name="admitted_date_estimated",
            field=edc_model_fields.fields.date_estimated.IsDateEstimatedField(
                choices=[
                    ("-", "No"),
                    ("D", "Yes, estimated the Day"),
                    ("MD", "Yes, estimated Month and Day"),
                    ("YMD", "Yes, estimated Year, Month and Day"),
                ],
                help_text="If the exact date is not known, please indicate which part of the date is estimated.",
                max_length=25,
                verbose_name="Is this date estimated?",
            ),
        ),
        migrations.AlterField(
            model_name="historicalhospitalization",
            name="device_created",
            field=models.CharField(
                blank=True, default="", max_length=10, verbose_name="Device created"
            ),
        ),
        migrations.AlterField(
            model_name="historicalhospitalization",
            name="device_modified",
            field=models.CharField(
                blank=True, default="", max_length=10, verbose_name="Device modified"
            ),
        ),
        migrations.AlterField(
            model_name="historicalhospitalization",
            name="locale_created",
            field=models.CharField(
                blank=True,
                default="",
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                verbose_name="Locale created",
            ),
        ),
        migrations.AlterField(
            model_name="historicalhospitalization",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                default="",
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AlterField(
            model_name="historicalhospitalization",
            name="narrative",
            field=models.TextField(
                blank=True, default="", max_length=500, verbose_name="Narrative"
            ),
        ),
        migrations.AlterField(
            model_name="historicalhospitalization",
            name="parent_action_identifier",
            field=models.CharField(
                blank=True,
                default="",
                help_text="action identifier that links to parent reference model instance.",
                max_length=30,
            ),
        ),
        migrations.AlterField(
            model_name="historicalhospitalization",
            name="related_action_identifier",
            field=models.CharField(
                blank=True,
                default="",
                help_text="action identifier that links to related reference model instance.",
                max_length=30,
            ),
        ),
        migrations.AlterField(
            model_name="historicalhospitalization",
            name="report_datetime",
            field=models.DateTimeField(
                default=django.utils.timezone.now,
                validators=[
                    edc_protocol.validators.datetime_not_before_study_start,
                    edc_model.validators.date.datetime_not_future,
                ],
                verbose_name="Report Date",
            ),
        ),
        migrations.AlterField(
            model_name="historicalhospitalization",
            name="revision",
            field=django_revision.revision_field.RevisionField(
                blank=True,
                default="",
                editable=False,
                help_text="System field. From git repository (tag:branch:commit), project metadata, project toml, project VERSION, or settings.",
                max_length=75,
                verbose_name="Revision",
            ),
        ),
        migrations.AlterField(
            model_name="hospitalization",
            name="action_identifier",
            field=models.CharField(blank=True, default="", max_length=50, unique=True),
        ),
        migrations.AlterField(
            model_name="hospitalization",
            name="action_item_reason",
            field=models.TextField(default="", editable=False),
        ),
        migrations.AlterField(
            model_name="hospitalization",
            name="admitted_date_estimated",
            field=edc_model_fields.fields.date_estimated.IsDateEstimatedField(
                choices=[
                    ("-", "No"),
                    ("D", "Yes, estimated the Day"),
                    ("MD", "Yes, estimated Month and Day"),
                    ("YMD", "Yes, estimated Year, Month and Day"),
                ],
                help_text="If the exact date is not known, please indicate which part of the date is estimated.",
                max_length=25,
                verbose_name="Is this date estimated?",
            ),
        ),
        migrations.AlterField(
            model_name="hospitalization",
            name="device_created",
            field=models.CharField(
                blank=True, default="", max_length=10, verbose_name="Device created"
            ),
        ),
        migrations.AlterField(
            model_name="hospitalization",
            name="device_modified",
            field=models.CharField(
                blank=True, default="", max_length=10, verbose_name="Device modified"
            ),
        ),
        migrations.AlterField(
            model_name="hospitalization",
            name="locale_created",
            field=models.CharField(
                blank=True,
                default="",
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                verbose_name="Locale created",
            ),
        ),
        migrations.AlterField(
            model_name="hospitalization",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                default="",
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AlterField(
            model_name="hospitalization",
            name="narrative",
            field=models.TextField(
                blank=True, default="", max_length=500, verbose_name="Narrative"
            ),
        ),
        migrations.AlterField(
            model_name="hospitalization",
            name="parent_action_identifier",
            field=models.CharField(
                blank=True,
                default="",
                help_text="action identifier that links to parent reference model instance.",
                max_length=30,
            ),
        ),
        migrations.AlterField(
            model_name="hospitalization",
            name="related_action_identifier",
            field=models.CharField(
                blank=True,
                default="",
                help_text="action identifier that links to related reference model instance.",
                max_length=30,
            ),
        ),
        migrations.AlterField(
            model_name="hospitalization",
            name="report_datetime",
            field=models.DateTimeField(
                default=django.utils.timezone.now,
                validators=[
                    edc_protocol.validators.datetime_not_before_study_start,
                    edc_model.validators.date.datetime_not_future,
                ],
                verbose_name="Report Date",
            ),
        ),
        migrations.AlterField(
            model_name="hospitalization",
            name="revision",
            field=django_revision.revision_field.RevisionField(
                blank=True,
                default="",
                editable=False,
                help_text="System field. From git repository (tag:branch:commit), project metadata, project toml, project VERSION, or settings.",
                max_length=75,
                verbose_name="Revision",
            ),
        ),
    ]
