# Generated by Django 3.2.13 on 2022-09-14 02:42
from django.db import migrations
from tqdm import tqdm


def update_rs_missing_ethnicity(apps, schema_editor):
    register_subject_model_cls = apps.get_model("edc_registration.registeredsubject")
    subject_consent_model_cls = apps.get_model("meta_consent.subjectconsent")
    total = subject_consent_model_cls.objects.all().count()
    print(" ")
    for subject_consent in tqdm(subject_consent_model_cls.objects.all(), total=total):
        register_subject = register_subject_model_cls.objects.get(
            subject_identifier=subject_consent.subject_identifier
        )
        subject_consent.ethnicity = register_subject.ethnicity
        subject_consent.save_base(update_fields=["ethnicity"])


class Migration(migrations.Migration):
    dependencies = [
        ("meta_consent", "0015_auto_20220914_0542"),
    ]

    operations = [migrations.RunPython(update_rs_missing_ethnicity)]
