# Generated by Django 5.1.2 on 2025-01-15 23:45

import edc_consent.validators
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ("meta_consent", "0027_auto_20250111_0344"),
    ]

    operations = [
        migrations.AddField(
            model_name="historicalsubjectconsentv1ext",
            name="assessment_score",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                help_text="If no, participant is not eligible.",
                max_length=3,
                null=True,
                validators=[edc_consent.validators.eligible_if_yes],
                verbose_name="I have asked the participant questions about this study and the participant has demonstrated understanding",
            ),
        ),
        migrations.AddField(
            model_name="historicalsubjectconsentv1ext",
            name="consent_copy",
            field=models.CharField(
                choices=[
                    ("Yes", "Yes"),
                    ("No", "No"),
                    ("Declined", "Yes, but subject declined copy"),
                ],
                help_text="If declined, return copy with the consent",
                max_length=20,
                null=True,
                validators=[edc_consent.validators.eligible_if_yes_or_declined],
                verbose_name="I have provided the participant with a copy of their signed informed consent",
            ),
        ),
        migrations.AddField(
            model_name="historicalsubjectconsentv1ext",
            name="consent_reviewed",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                help_text="If no, participant is not eligible.",
                max_length=3,
                null=True,
                validators=[edc_consent.validators.eligible_if_yes],
                verbose_name="I have reviewed the consent with the participant",
            ),
        ),
        migrations.AddField(
            model_name="historicalsubjectconsentv1ext",
            name="consent_signature",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                help_text="If no, participant is not eligible.",
                max_length=3,
                null=True,
                validators=[edc_consent.validators.eligible_if_yes],
                verbose_name="I have verified that the participant has signed the consent form",
            ),
        ),
        migrations.AddField(
            model_name="historicalsubjectconsentv1ext",
            name="study_questions",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                help_text="If no, participant is not eligible.",
                max_length=3,
                null=True,
                validators=[edc_consent.validators.eligible_if_yes],
                verbose_name="I have answered all questions the participant had about the study",
            ),
        ),
        migrations.AddField(
            model_name="subjectconsentv1ext",
            name="assessment_score",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                help_text="If no, participant is not eligible.",
                max_length=3,
                null=True,
                validators=[edc_consent.validators.eligible_if_yes],
                verbose_name="I have asked the participant questions about this study and the participant has demonstrated understanding",
            ),
        ),
        migrations.AddField(
            model_name="subjectconsentv1ext",
            name="consent_copy",
            field=models.CharField(
                choices=[
                    ("Yes", "Yes"),
                    ("No", "No"),
                    ("Declined", "Yes, but subject declined copy"),
                ],
                help_text="If declined, return copy with the consent",
                max_length=20,
                null=True,
                validators=[edc_consent.validators.eligible_if_yes_or_declined],
                verbose_name="I have provided the participant with a copy of their signed informed consent",
            ),
        ),
        migrations.AddField(
            model_name="subjectconsentv1ext",
            name="consent_reviewed",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                help_text="If no, participant is not eligible.",
                max_length=3,
                null=True,
                validators=[edc_consent.validators.eligible_if_yes],
                verbose_name="I have reviewed the consent with the participant",
            ),
        ),
        migrations.AddField(
            model_name="subjectconsentv1ext",
            name="consent_signature",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                help_text="If no, participant is not eligible.",
                max_length=3,
                null=True,
                validators=[edc_consent.validators.eligible_if_yes],
                verbose_name="I have verified that the participant has signed the consent form",
            ),
        ),
        migrations.AddField(
            model_name="subjectconsentv1ext",
            name="study_questions",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                help_text="If no, participant is not eligible.",
                max_length=3,
                null=True,
                validators=[edc_consent.validators.eligible_if_yes],
                verbose_name="I have answered all questions the participant had about the study",
            ),
        ),
        migrations.AlterField(
            model_name="historicalsubjectconsentv1ext",
            name="agrees_to_extension",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                help_text="See above for the definition of extended followup.",
                max_length=15,
                verbose_name="Does the participant agree to extend followup as per the protocol amendment?",
            ),
        ),
        migrations.AlterField(
            model_name="subjectconsentv1ext",
            name="agrees_to_extension",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                help_text="See above for the definition of extended followup.",
                max_length=15,
                verbose_name="Does the participant agree to extend followup as per the protocol amendment?",
            ),
        ),
    ]
