# Generated by Django 3.0.6 on 2020-05-28 12:17
from django.core.exceptions import ObjectDoesNotExist
from django.db import migrations
from django.db.migrations import RunPython
from clinicedc_constants import LTFU


def update_ltfu(apps, schema_editor):
    offstudy_reasons = apps.get_model("meta_lists.offstudyreasons")
    try:
        obj = offstudy_reasons.objects.get(name="lost_to_followup")
    except ObjectDoesNotExist:
        pass
    else:
        obj.name = LTFU
        obj.save_base(update_fields=["name"])


class Migration(migrations.Migration):
    dependencies = [
        ("meta_lists", "0007_auto_20200516_2356"),
    ]

    operations = [RunPython(update_ltfu)]
