# Generated by Django 5.2.6 on 2025-09-30 05:07

import _socket
import django.db.models.deletion
import django.db.models.manager
import django.utils.timezone
import django_audit_fields.fields.hostname_modification_field
import django_audit_fields.fields.userfield
import django_audit_fields.fields.uuid_auto_field
import django_revision.revision_field
import edc_sites.managers
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        (
            "meta_rando",
            "0006_alter_historicalrandomizationlist_allocated_user_and_more",
        ),
        ("sites", "0002_alter_domain_unique"),
    ]

    operations = [
        migrations.CreateModel(
            name="SpfqList",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        default="",
                        editable=False,
                        help_text="System field. From git repository (tag:branch:commit), project metadata, project toml, project VERSION, or settings.",
                        max_length=75,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(blank=True, default=django.utils.timezone.now),
                ),
                (
                    "modified",
                    models.DateTimeField(blank=True, default=django.utils.timezone.now),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        default="",
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        default="",
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                        verbose_name="Hostname created",
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        default="",
                        help_text="System field. (modified on every save)",
                        max_length=50,
                        verbose_name="Hostname modified",
                    ),
                ),
                (
                    "device_created",
                    models.CharField(
                        blank=True,
                        default="",
                        max_length=10,
                        verbose_name="Device created",
                    ),
                ),
                (
                    "device_modified",
                    models.CharField(
                        blank=True,
                        default="",
                        max_length=10,
                        verbose_name="Device modified",
                    ),
                ),
                (
                    "locale_created",
                    models.CharField(
                        blank=True,
                        default="",
                        help_text="Auto-updated by Modeladmin",
                        max_length=10,
                        verbose_name="Locale created",
                    ),
                ),
                (
                    "locale_modified",
                    models.CharField(
                        blank=True,
                        default="",
                        help_text="Auto-updated by Modeladmin",
                        max_length=10,
                        verbose_name="Locale modified",
                    ),
                ),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("subject_identifier", models.CharField(max_length=50, unique=True)),
                ("sid", models.IntegerField(unique=True)),
                ("last_visit_code", models.CharField(max_length=25)),
                ("last_appt_datetime", models.DateTimeField()),
                (
                    "gender",
                    models.CharField(
                        choices=[("M", "Male"), ("F", "Female")], max_length=10
                    ),
                ),
                (
                    "weight_bin",
                    models.CharField(
                        choices=[
                            ("lt_35", "<35"),
                            ("gte_35__lte_49", "35-49"),
                            ("gte_50", ">=50"),
                        ],
                        max_length=25,
                    ),
                ),
                ("date_generated", models.DateTimeField()),
                (
                    "site",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
            ],
            options={
                "verbose_name": "SPFQ List",
                "verbose_name_plural": "SPFQ List",
                "abstract": False,
                "default_permissions": (
                    "add",
                    "change",
                    "delete",
                    "view",
                    "export",
                    "import",
                ),
                "default_manager_name": "objects",
                "indexes": [
                    models.Index(
                        fields=["modified", "created"],
                        name="meta_rando__modifie_f4fcd8_idx",
                    ),
                    models.Index(
                        fields=["user_modified", "user_created"],
                        name="meta_rando__user_mo_79b855_idx",
                    ),
                ],
            },
            managers=[
                ("on_site", edc_sites.managers.CurrentSiteManager()),
                ("objects", django.db.models.manager.Manager()),
            ],
        ),
    ]
