# Generated by Django 2.2.6 on 2019-11-06 05:28

import uuid

import _socket
import django.core.validators
import django.db.models.deletion
import django_audit_fields.fields.hostname_modification_field
import django_audit_fields.fields.userfield
import django_audit_fields.fields.uuid_auto_field
import django.utils.timezone
import django_revision.revision_field
import edc_model_fields.fields.other_charfield
import edc_sites.models
import edc_utils.date
import simple_history.models
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):
    dependencies = [
        ("sites", "0002_alter_domain_unique"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("meta_screening", "0009_auto_20191105_0122"),
    ]

    operations = [
        migrations.AlterField(
            model_name="historicalscreeningpartone",
            name="consent_ability",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                max_length=25,
                verbose_name="Participant or legal guardian/representative able and willing to give informed consent.",
            ),
        ),
        migrations.AlterField(
            model_name="historicalscreeningpartone",
            name="continue_part_two",
            field=models.CharField(
                choices=[("Yes", "Yes (default)"), ("No", "No")],
                default="Yes",
                help_text="<B>Important</B>: This response will be be automatically set to YES if:<BR><BR>- the participant meets the eligibility criteria for part one, or;<BR><BR>- the eligibility criteria for part two is already complete.<BR>",
                max_length=15,
                verbose_name="Continue with <U>part two</U> of the screening process?",
            ),
        ),
        migrations.AlterField(
            model_name="historicalscreeningpartone",
            name="creatinine_performed",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="No",
                max_length=15,
                verbose_name="Was the serum creatinine performed?",
            ),
        ),
        migrations.AlterField(
            model_name="historicalscreeningpartone",
            name="dia_blood_pressure",
            field=models.IntegerField(
                blank=True,
                help_text="in Hg. format DIA, e.g. 80",
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(20),
                    django.core.validators.MaxValueValidator(150),
                ],
                verbose_name="Blood pressure: diastolic",
            ),
        ),
        migrations.AlterField(
            model_name="historicalscreeningpartone",
            name="hba1c_performed",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="No",
                max_length=15,
                verbose_name="Was the HbA1c performed?",
            ),
        ),
        migrations.AlterField(
            model_name="historicalscreeningpartone",
            name="height",
            field=models.DecimalField(
                blank=True,
                decimal_places=1,
                help_text="in centimeters",
                max_digits=5,
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(100.0),
                    django.core.validators.MaxValueValidator(230.0),
                ],
            ),
        ),
        migrations.AlterField(
            model_name="historicalscreeningpartone",
            name="sys_blood_pressure",
            field=models.IntegerField(
                blank=True,
                help_text="in mm. format SYS, e.g. 120",
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(50),
                    django.core.validators.MaxValueValidator(220),
                ],
                verbose_name="Blood pressure: systolic",
            ),
        ),
        migrations.AlterField(
            model_name="historicalscreeningpartone",
            name="waist_circumference",
            field=models.DecimalField(
                blank=True,
                decimal_places=1,
                help_text="in centimeters",
                max_digits=5,
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(50.0),
                    django.core.validators.MaxValueValidator(175.0),
                ],
                verbose_name="Waist circumference",
            ),
        ),
        migrations.AlterField(
            model_name="historicalscreeningpartone",
            name="weight",
            field=models.DecimalField(
                blank=True,
                decimal_places=2,
                help_text="in kgs",
                max_digits=8,
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(15),
                    django.core.validators.MaxValueValidator(135),
                ],
            ),
        ),
        migrations.AlterField(
            model_name="historicalscreeningpartthree",
            name="consent_ability",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                max_length=25,
                verbose_name="Participant or legal guardian/representative able and willing to give informed consent.",
            ),
        ),
        migrations.AlterField(
            model_name="historicalscreeningpartthree",
            name="continue_part_two",
            field=models.CharField(
                choices=[("Yes", "Yes (default)"), ("No", "No")],
                default="Yes",
                help_text="<B>Important</B>: This response will be be automatically set to YES if:<BR><BR>- the participant meets the eligibility criteria for part one, or;<BR><BR>- the eligibility criteria for part two is already complete.<BR>",
                max_length=15,
                verbose_name="Continue with <U>part two</U> of the screening process?",
            ),
        ),
        migrations.AlterField(
            model_name="historicalscreeningpartthree",
            name="creatinine_performed",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="No",
                max_length=15,
                verbose_name="Was the serum creatinine performed?",
            ),
        ),
        migrations.AlterField(
            model_name="historicalscreeningpartthree",
            name="dia_blood_pressure",
            field=models.IntegerField(
                blank=True,
                help_text="in Hg. format DIA, e.g. 80",
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(20),
                    django.core.validators.MaxValueValidator(150),
                ],
                verbose_name="Blood pressure: diastolic",
            ),
        ),
        migrations.AlterField(
            model_name="historicalscreeningpartthree",
            name="hba1c_performed",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="No",
                max_length=15,
                verbose_name="Was the HbA1c performed?",
            ),
        ),
        migrations.AlterField(
            model_name="historicalscreeningpartthree",
            name="height",
            field=models.DecimalField(
                blank=True,
                decimal_places=1,
                help_text="in centimeters",
                max_digits=5,
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(100.0),
                    django.core.validators.MaxValueValidator(230.0),
                ],
            ),
        ),
        migrations.AlterField(
            model_name="historicalscreeningpartthree",
            name="sys_blood_pressure",
            field=models.IntegerField(
                blank=True,
                help_text="in mm. format SYS, e.g. 120",
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(50),
                    django.core.validators.MaxValueValidator(220),
                ],
                verbose_name="Blood pressure: systolic",
            ),
        ),
        migrations.AlterField(
            model_name="historicalscreeningpartthree",
            name="waist_circumference",
            field=models.DecimalField(
                blank=True,
                decimal_places=1,
                help_text="in centimeters",
                max_digits=5,
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(50.0),
                    django.core.validators.MaxValueValidator(175.0),
                ],
                verbose_name="Waist circumference",
            ),
        ),
        migrations.AlterField(
            model_name="historicalscreeningpartthree",
            name="weight",
            field=models.DecimalField(
                blank=True,
                decimal_places=2,
                help_text="in kgs",
                max_digits=8,
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(15),
                    django.core.validators.MaxValueValidator(135),
                ],
            ),
        ),
        migrations.AlterField(
            model_name="historicalscreeningparttwo",
            name="consent_ability",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                max_length=25,
                verbose_name="Participant or legal guardian/representative able and willing to give informed consent.",
            ),
        ),
        migrations.AlterField(
            model_name="historicalscreeningparttwo",
            name="continue_part_two",
            field=models.CharField(
                choices=[("Yes", "Yes (default)"), ("No", "No")],
                default="Yes",
                help_text="<B>Important</B>: This response will be be automatically set to YES if:<BR><BR>- the participant meets the eligibility criteria for part one, or;<BR><BR>- the eligibility criteria for part two is already complete.<BR>",
                max_length=15,
                verbose_name="Continue with <U>part two</U> of the screening process?",
            ),
        ),
        migrations.AlterField(
            model_name="historicalscreeningparttwo",
            name="creatinine_performed",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="No",
                max_length=15,
                verbose_name="Was the serum creatinine performed?",
            ),
        ),
        migrations.AlterField(
            model_name="historicalscreeningparttwo",
            name="dia_blood_pressure",
            field=models.IntegerField(
                blank=True,
                help_text="in Hg. format DIA, e.g. 80",
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(20),
                    django.core.validators.MaxValueValidator(150),
                ],
                verbose_name="Blood pressure: diastolic",
            ),
        ),
        migrations.AlterField(
            model_name="historicalscreeningparttwo",
            name="hba1c_performed",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="No",
                max_length=15,
                verbose_name="Was the HbA1c performed?",
            ),
        ),
        migrations.AlterField(
            model_name="historicalscreeningparttwo",
            name="height",
            field=models.DecimalField(
                blank=True,
                decimal_places=1,
                help_text="in centimeters",
                max_digits=5,
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(100.0),
                    django.core.validators.MaxValueValidator(230.0),
                ],
            ),
        ),
        migrations.AlterField(
            model_name="historicalscreeningparttwo",
            name="sys_blood_pressure",
            field=models.IntegerField(
                blank=True,
                help_text="in mm. format SYS, e.g. 120",
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(50),
                    django.core.validators.MaxValueValidator(220),
                ],
                verbose_name="Blood pressure: systolic",
            ),
        ),
        migrations.AlterField(
            model_name="historicalscreeningparttwo",
            name="waist_circumference",
            field=models.DecimalField(
                blank=True,
                decimal_places=1,
                help_text="in centimeters",
                max_digits=5,
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(50.0),
                    django.core.validators.MaxValueValidator(175.0),
                ],
                verbose_name="Waist circumference",
            ),
        ),
        migrations.AlterField(
            model_name="historicalscreeningparttwo",
            name="weight",
            field=models.DecimalField(
                blank=True,
                decimal_places=2,
                help_text="in kgs",
                max_digits=8,
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(15),
                    django.core.validators.MaxValueValidator(135),
                ],
            ),
        ),
        migrations.AlterField(
            model_name="historicalsubjectscreening",
            name="consent_ability",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                max_length=25,
                verbose_name="Participant or legal guardian/representative able and willing to give informed consent.",
            ),
        ),
        migrations.AlterField(
            model_name="historicalsubjectscreening",
            name="continue_part_two",
            field=models.CharField(
                choices=[("Yes", "Yes (default)"), ("No", "No")],
                default="Yes",
                help_text="<B>Important</B>: This response will be be automatically set to YES if:<BR><BR>- the participant meets the eligibility criteria for part one, or;<BR><BR>- the eligibility criteria for part two is already complete.<BR>",
                max_length=15,
                verbose_name="Continue with <U>part two</U> of the screening process?",
            ),
        ),
        migrations.AlterField(
            model_name="historicalsubjectscreening",
            name="creatinine_performed",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="No",
                max_length=15,
                verbose_name="Was the serum creatinine performed?",
            ),
        ),
        migrations.AlterField(
            model_name="historicalsubjectscreening",
            name="dia_blood_pressure",
            field=models.IntegerField(
                blank=True,
                help_text="in Hg. format DIA, e.g. 80",
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(20),
                    django.core.validators.MaxValueValidator(150),
                ],
                verbose_name="Blood pressure: diastolic",
            ),
        ),
        migrations.AlterField(
            model_name="historicalsubjectscreening",
            name="hba1c_performed",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="No",
                max_length=15,
                verbose_name="Was the HbA1c performed?",
            ),
        ),
        migrations.AlterField(
            model_name="historicalsubjectscreening",
            name="height",
            field=models.DecimalField(
                blank=True,
                decimal_places=1,
                help_text="in centimeters",
                max_digits=5,
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(100.0),
                    django.core.validators.MaxValueValidator(230.0),
                ],
            ),
        ),
        migrations.AlterField(
            model_name="historicalsubjectscreening",
            name="sys_blood_pressure",
            field=models.IntegerField(
                blank=True,
                help_text="in mm. format SYS, e.g. 120",
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(50),
                    django.core.validators.MaxValueValidator(220),
                ],
                verbose_name="Blood pressure: systolic",
            ),
        ),
        migrations.AlterField(
            model_name="historicalsubjectscreening",
            name="waist_circumference",
            field=models.DecimalField(
                blank=True,
                decimal_places=1,
                help_text="in centimeters",
                max_digits=5,
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(50.0),
                    django.core.validators.MaxValueValidator(175.0),
                ],
                verbose_name="Waist circumference",
            ),
        ),
        migrations.AlterField(
            model_name="historicalsubjectscreening",
            name="weight",
            field=models.DecimalField(
                blank=True,
                decimal_places=2,
                help_text="in kgs",
                max_digits=8,
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(15),
                    django.core.validators.MaxValueValidator(135),
                ],
            ),
        ),
        migrations.AlterField(
            model_name="subjectscreening",
            name="consent_ability",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                max_length=25,
                verbose_name="Participant or legal guardian/representative able and willing to give informed consent.",
            ),
        ),
        migrations.AlterField(
            model_name="subjectscreening",
            name="continue_part_two",
            field=models.CharField(
                choices=[("Yes", "Yes (default)"), ("No", "No")],
                default="Yes",
                help_text="<B>Important</B>: This response will be be automatically set to YES if:<BR><BR>- the participant meets the eligibility criteria for part one, or;<BR><BR>- the eligibility criteria for part two is already complete.<BR>",
                max_length=15,
                verbose_name="Continue with <U>part two</U> of the screening process?",
            ),
        ),
        migrations.AlterField(
            model_name="subjectscreening",
            name="creatinine_performed",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="No",
                max_length=15,
                verbose_name="Was the serum creatinine performed?",
            ),
        ),
        migrations.AlterField(
            model_name="subjectscreening",
            name="dia_blood_pressure",
            field=models.IntegerField(
                blank=True,
                help_text="in Hg. format DIA, e.g. 80",
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(20),
                    django.core.validators.MaxValueValidator(150),
                ],
                verbose_name="Blood pressure: diastolic",
            ),
        ),
        migrations.AlterField(
            model_name="subjectscreening",
            name="hba1c_performed",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="No",
                max_length=15,
                verbose_name="Was the HbA1c performed?",
            ),
        ),
        migrations.AlterField(
            model_name="subjectscreening",
            name="height",
            field=models.DecimalField(
                blank=True,
                decimal_places=1,
                help_text="in centimeters",
                max_digits=5,
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(100.0),
                    django.core.validators.MaxValueValidator(230.0),
                ],
            ),
        ),
        migrations.AlterField(
            model_name="subjectscreening",
            name="sys_blood_pressure",
            field=models.IntegerField(
                blank=True,
                help_text="in mm. format SYS, e.g. 120",
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(50),
                    django.core.validators.MaxValueValidator(220),
                ],
                verbose_name="Blood pressure: systolic",
            ),
        ),
        migrations.AlterField(
            model_name="subjectscreening",
            name="waist_circumference",
            field=models.DecimalField(
                blank=True,
                decimal_places=1,
                help_text="in centimeters",
                max_digits=5,
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(50.0),
                    django.core.validators.MaxValueValidator(175.0),
                ],
                verbose_name="Waist circumference",
            ),
        ),
        migrations.AlterField(
            model_name="subjectscreening",
            name="weight",
            field=models.DecimalField(
                blank=True,
                decimal_places=2,
                help_text="in kgs",
                max_digits=8,
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(15),
                    django.core.validators.MaxValueValidator(135),
                ],
            ),
        ),
        migrations.CreateModel(
            name="SubjectRefusal",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django.utils.timezone.now,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django.utils.timezone.now,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "subject_identifier_as_pk",
                    models.UUIDField(default=uuid.uuid4, editable=False),
                ),
                (
                    "subject_identifier_aka",
                    models.CharField(
                        editable=False,
                        help_text="track a previously allocated identifier.",
                        max_length=50,
                        null=True,
                        verbose_name="Subject Identifier a.k.a",
                    ),
                ),
                ("subject_identifier", models.CharField(editable=False, max_length=50)),
                (
                    "screening_identifier",
                    models.CharField(editable=False, max_length=50),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        verbose_name="Report Date and Time",
                    ),
                ),
                (
                    "reason",
                    models.CharField(
                        choices=[
                            ("dont_have_time", "I don't have time"),
                            ("must_consult_spouse", "I need to consult my spouse"),
                            (
                                "dont_want_blood_drawn",
                                "I don't want to have the blood drawn",
                            ),
                            ("dont_want_to_join", "I don't want to take part"),
                            (
                                "need_to_think_about_it",
                                "I haven't had a chance to think about it",
                            ),
                            ("OTHER", "Other, please specify"),
                        ],
                        max_length=25,
                        verbose_name="Reason for refusal to join",
                    ),
                ),
                (
                    "other_reason",
                    edc_model_fields.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.Site",
                    ),
                ),
                (
                    "subject_screening",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="meta_screening.SubjectScreening",
                    ),
                ),
            ],
            options={
                "verbose_name": "Subject Refusal",
                "verbose_name_plural": "Subject Refusals",
            },
            managers=[("on_site", edc_sites.models.CurrentSiteManager())],
        ),
        migrations.CreateModel(
            name="HistoricalSubjectRefusal",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django.utils.timezone.now,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django.utils.timezone.now,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "subject_identifier_as_pk",
                    models.UUIDField(default=uuid.uuid4, editable=False),
                ),
                (
                    "subject_identifier_aka",
                    models.CharField(
                        editable=False,
                        help_text="track a previously allocated identifier.",
                        max_length=50,
                        null=True,
                        verbose_name="Subject Identifier a.k.a",
                    ),
                ),
                ("subject_identifier", models.CharField(editable=False, max_length=50)),
                (
                    "screening_identifier",
                    models.CharField(editable=False, max_length=50),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        verbose_name="Report Date and Time",
                    ),
                ),
                (
                    "reason",
                    models.CharField(
                        choices=[
                            ("dont_have_time", "I don't have time"),
                            ("must_consult_spouse", "I need to consult my spouse"),
                            (
                                "dont_want_blood_drawn",
                                "I don't want to have the blood drawn",
                            ),
                            ("dont_want_to_join", "I don't want to take part"),
                            (
                                "need_to_think_about_it",
                                "I haven't had a chance to think about it",
                            ),
                            ("OTHER", "Other, please specify"),
                        ],
                        max_length=25,
                        verbose_name="Reason for refusal to join",
                    ),
                ),
                (
                    "other_reason",
                    edc_model_fields.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.Site",
                    ),
                ),
                (
                    "subject_screening",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="meta_screening.SubjectScreening",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Subject Refusal",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
    ]
