# Generated by Django 4.2.11 on 2024-05-16 00:52
from django.db import migrations
from edc_model.utils import duration_hm_to_timedelta
from tqdm import tqdm


def update_duration(apps, schema_editor):
    model_cls = apps.get_model("meta_screening.subjectscreening")
    qs = model_cls.objects.all()
    total = qs.count()
    for obj in tqdm(qs, total=total):
        if obj.fasting_duration_str:
            tdelta = duration_hm_to_timedelta(obj.fasting_duration_str)
            obj.fasting_duration_delta = tdelta
            obj.save_base(update_fields=["fasting_duration_delta"])
        if obj.repeat_fasting_duration_str:
            tdelta = duration_hm_to_timedelta(obj.repeat_fasting_duration_str)
            obj.repeat_fasting_duration_delta = tdelta
            obj.save_base(update_fields=["repeat_fasting_duration_delta"])


class Migration(migrations.Migration):

    dependencies = [
        (
            "meta_screening",
            "0064_remove_historicalscreeningpartone_fasting_duration_minutes_and_more",
        ),
    ]

    operations = [migrations.RunPython(update_duration)]
