# Generated by Django 3.0.4 on 2020-04-16 19:43

import uuid

import _socket
import django.contrib.sites.managers
import django.core.validators
import django.db.models.deletion
import django_audit_fields.fields.hostname_modification_field
import django_audit_fields.fields.userfield
import django_audit_fields.fields.uuid_auto_field
import django.utils.timezone
import django_revision.revision_field
import edc_model.models.fields.other_charfield
import edc_model.validators.date
import edc_protocol.validators
import edc_utils.date
import edc_visit_tracking.managers
import edc_vitals.models.fields.blood_pressure
import edc_vitals.models.fields.height
import edc_vitals.models.fields.weight
import simple_history.models
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):
    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("sites", "0002_alter_domain_unique"),
        ("meta_subject", "0017_auto_20200325_0901"),
    ]

    operations = [
        migrations.CreateModel(
            name="HistoricalCoronaKap",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django.utils.timezone.now,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django.utils.timezone.now,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                (
                    "consent_model",
                    models.CharField(editable=False, max_length=50, null=True),
                ),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "months_on_art",
                    models.IntegerField(
                        help_text="months",
                        verbose_name="How long has the patient been on antiretroviral therapy?",
                    ),
                ),
                (
                    "dm_aware",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        verbose_name="Does the patient know if he/she has diabetes?",
                    ),
                ),
                ("weight", edc_vitals.models.fields.weight.WeightField()),
                ("height", edc_vitals.models.fields.height.HeightField()),
                (
                    "sys_blood_pressure_r1",
                    edc_vitals.models.fields.blood_pressure.SystolicPressureField(null=True),
                ),
                (
                    "dia_blood_pressure_r1",
                    edc_vitals.models.fields.blood_pressure.DiastolicPressureField(null=True),
                ),
                (
                    "married",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        verbose_name="Married currently?",
                    ),
                ),
                (
                    "employment_status",
                    models.CharField(
                        choices=[
                            ("working_for_pay", "Working for pay"),
                            ("unemployed", "Unemployed"),
                            (
                                "not_working_for_pay",
                                "Not working for pay (housewife, retired...)",
                            ),
                        ],
                        max_length=25,
                        verbose_name="Employment status",
                    ),
                ),
                (
                    "shared_housing_one",
                    models.IntegerField(
                        verbose_name="How many people live together in your dwelling?"
                    ),
                ),
                (
                    "shared_housing_two",
                    models.IntegerField(
                        verbose_name="In a typically month, how many different people spend more than one night at your current dwelling"
                    ),
                ),
                (
                    "profession",
                    models.CharField(
                        choices=[
                            ("professional", "Professional (e.g. office"),
                            ("labourer", "Labourer"),
                            ("housewife_retired", "Housewife, Retired"),
                            ("self_employed", "Small business, self-employed"),
                            ("OTHER", "Other, specify below"),
                        ],
                        max_length=25,
                        verbose_name="Profession / Employment",
                    ),
                ),
                (
                    "other_profession",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "education",
                    models.CharField(
                        choices=[
                            ("primary", "Up to primary"),
                            ("secondary", "Up to high school"),
                            ("tertiary", "University, college"),
                            ("no_education", "No education"),
                        ],
                        max_length=25,
                        verbose_name="Education level",
                    ),
                ),
                (
                    "health_insurance",
                    models.CharField(
                        choices=[
                            ("work_scheme", "Work scheme health insurance"),
                            ("private", "Private health insurance"),
                            ("no_insurance", "No insurance, I pay"),
                            ("OTHER", "Other, please specify below"),
                        ],
                        max_length=25,
                        verbose_name="Health Insurance",
                    ),
                ),
                (
                    "other_health_insurance",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "personal_health_opinion",
                    models.CharField(
                        choices=[
                            ("excellent", "Excellent"),
                            ("good", "Good"),
                            ("fair", "Fair"),
                            ("poor", "Poor"),
                        ],
                        max_length=25,
                        verbose_name="In your opinion, what is your health like?",
                    ),
                ),
                (
                    "perceived_threat",
                    models.IntegerField(
                        help_text="On a scale from 1-10",
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(10),
                        ],
                        verbose_name="How serious of a public health threat is coronavirus",
                    ),
                ),
                (
                    "corona_concern",
                    models.CharField(
                        choices=[
                            ("very", "Very worried"),
                            ("somewhat", "Somewhat worried"),
                            ("a_little", "A little worried"),
                            ("not_at_all", "Not worried at all"),
                        ],
                        max_length=25,
                        verbose_name="How worried are you about getting coronavirus?",
                    ),
                ),
                (
                    "personal_infection_likelihood",
                    models.CharField(
                        choices=[
                            ("very", "Very likely"),
                            ("somewhat", "Somewhat likely"),
                            ("unlikely", "Not very likely, unlikely"),
                            ("not_at_all", "Not at all"),
                        ],
                        max_length=25,
                        verbose_name="Do you think you will get corona virus",
                    ),
                ),
                (
                    "family_infection_likelihood",
                    models.CharField(
                        choices=[
                            ("very", "Very likely"),
                            ("somewhat", "Somewhat likely"),
                            ("unlikely", "Not very likely, unlikely"),
                            ("not_at_all", "Not at all"),
                        ],
                        max_length=25,
                        verbose_name="How likely is that you or someone in your family will get sick from the coronavirus",
                    ),
                ),
                (
                    "perc_die",
                    models.IntegerField(
                        help_text="On a scale from 0-100",
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(100),
                        ],
                        verbose_name="What percentage of people who get coronavirus do you think will die",
                    ),
                ),
                (
                    "perc_mild_symptom",
                    models.IntegerField(
                        help_text="On a scale from 0-100",
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(100),
                        ],
                        verbose_name="What percentage of people who get coronavirus do you think will have only mild symptoms",
                    ),
                ),
                (
                    "spread_droplets",
                    models.CharField(
                        choices=[
                            ("true", "True"),
                            ("false", "False"),
                            ("dont_know", "Don't know"),
                        ],
                        max_length=25,
                        verbose_name="The virus spreads by droplets from cough and sneezes from people infected with coronavirus",
                    ),
                ),
                (
                    "spread_touch",
                    models.CharField(
                        choices=[
                            ("true", "True"),
                            ("false", "False"),
                            ("dont_know", "Don't know"),
                        ],
                        max_length=25,
                        verbose_name="The virus can spread by people touching each other",
                    ),
                ),
                (
                    "spread_sick",
                    models.CharField(
                        choices=[
                            ("true", "True"),
                            ("false", "False"),
                            ("dont_know", "Don't know"),
                        ],
                        max_length=25,
                        verbose_name="People transmit the virus when they are sick ",
                    ),
                ),
                (
                    "spread_asymptomatic",
                    models.CharField(
                        choices=[
                            ("true", "True"),
                            ("false", "False"),
                            ("dont_know", "Don't know"),
                        ],
                        max_length=25,
                        verbose_name="People can transmit the virus even when they do not appear to be sick",
                    ),
                ),
                (
                    "severity_age",
                    models.CharField(
                        choices=[
                            ("true", "True"),
                            ("false", "False"),
                            ("dont_know", "Don't know"),
                        ],
                        max_length=25,
                        verbose_name="The disease is more severe in older people than children",
                    ),
                ),
                (
                    "hot_climate",
                    models.CharField(
                        choices=[
                            ("true", "True"),
                            ("false", "False"),
                            ("dont_know", "Don't know"),
                        ],
                        max_length=25,
                        verbose_name="The virus does not survive in the hot climate",
                    ),
                ),
                (
                    "lives_on_materials",
                    models.CharField(
                        choices=[
                            ("true", "True"),
                            ("false", "False"),
                            ("dont_know", "Don't know"),
                        ],
                        max_length=25,
                        verbose_name="The virus can live on clothes, plastics, cardboard for a day or more",
                    ),
                ),
                (
                    "spread_touch2",
                    models.CharField(
                        choices=[
                            ("true", "True"),
                            ("false", "False"),
                            ("dont_know", "Don't know"),
                        ],
                        max_length=25,
                        verbose_name="You can catch the virus if you touch an infected area and then touch your face or eyes",
                    ),
                ),
                (
                    "symptoms_fever",
                    models.CharField(
                        choices=[
                            ("true", "True"),
                            ("false", "False"),
                            ("dont_know", "Don't know"),
                        ],
                        max_length=25,
                        verbose_name="Fever",
                    ),
                ),
                (
                    "symptoms_headache",
                    models.CharField(
                        choices=[
                            ("true", "True"),
                            ("false", "False"),
                            ("dont_know", "Don't know"),
                        ],
                        max_length=25,
                        verbose_name="Headache",
                    ),
                ),
                (
                    "symptoms_dry_cough",
                    models.CharField(
                        choices=[
                            ("true", "True"),
                            ("false", "False"),
                            ("dont_know", "Don't know"),
                        ],
                        max_length=25,
                        verbose_name="Dry persistant cough",
                    ),
                ),
                (
                    "symptoms_body_aches",
                    models.CharField(
                        choices=[
                            ("true", "True"),
                            ("false", "False"),
                            ("dont_know", "Don't know"),
                        ],
                        max_length=25,
                        verbose_name="Body aches",
                    ),
                ),
                (
                    "symptoms_smell",
                    models.CharField(
                        choices=[
                            ("true", "True"),
                            ("false", "False"),
                            ("dont_know", "Don't know"),
                        ],
                        max_length=25,
                        verbose_name="Loss of taste and smell",
                    ),
                ),
                (
                    "symptoms_breathing",
                    models.CharField(
                        choices=[
                            ("true", "True"),
                            ("false", "False"),
                            ("dont_know", "Don't know"),
                        ],
                        max_length=25,
                        verbose_name="Fast or difficult breathing",
                    ),
                ),
                (
                    "know_other_symptoms",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        verbose_name="Do you know of any other symptoms of a Coronavirus?",
                    ),
                ),
                (
                    "other_symptoms",
                    models.TextField(
                        blank=True,
                        max_length=250,
                        null=True,
                        verbose_name="Please list any other symptoms of a Corona virus infection that you are aware of",
                    ),
                ),
                (
                    "hot_drinks",
                    models.CharField(
                        choices=[
                            ("true", "True"),
                            ("false", "False"),
                            ("dont_know", "Don't know"),
                        ],
                        max_length=25,
                        verbose_name="Drink warm water or hot drinks like tea or coffee",
                    ),
                ),
                (
                    "alcohol",
                    models.CharField(
                        choices=[
                            ("true", "True"),
                            ("false", "False"),
                            ("dont_know", "Don't know"),
                        ],
                        max_length=25,
                        verbose_name="Drink alcohol, spirits, etc",
                    ),
                ),
                (
                    "wash_hands",
                    models.CharField(
                        choices=[
                            ("true", "True"),
                            ("false", "False"),
                            ("dont_know", "Don't know"),
                        ],
                        max_length=25,
                        verbose_name="Wash hands with soap and warm water virus",
                    ),
                ),
                (
                    "hand_sanitizer",
                    models.CharField(
                        choices=[
                            ("true", "True"),
                            ("false", "False"),
                            ("dont_know", "Don't know"),
                        ],
                        max_length=25,
                        verbose_name="Use hand sanitisers with alcohol",
                    ),
                ),
                (
                    "avoid_crowds",
                    models.CharField(
                        choices=[
                            ("true", "True"),
                            ("false", "False"),
                            ("dont_know", "Don't know"),
                        ],
                        max_length=25,
                        verbose_name="Avoid crowded places such as markets and public transport",
                    ),
                ),
                (
                    "face_masks",
                    models.CharField(
                        choices=[
                            ("true", "True"),
                            ("false", "False"),
                            ("dont_know", "Don't know"),
                        ],
                        max_length=25,
                        verbose_name="Wear a face mask",
                    ),
                ),
                (
                    "stay_indoors",
                    models.CharField(
                        choices=[
                            ("true", "True"),
                            ("false", "False"),
                            ("dont_know", "Don't know"),
                        ],
                        max_length=25,
                        verbose_name="Stay indoors",
                    ),
                ),
                (
                    "social_distance",
                    models.CharField(
                        choices=[
                            ("true", "True"),
                            ("false", "False"),
                            ("dont_know", "Don't know"),
                        ],
                        max_length=25,
                        verbose_name="Keep at least a 2 metre distance from people",
                    ),
                ),
                (
                    "stay_home",
                    models.CharField(
                        choices=[
                            ("very", "Very likely"),
                            ("somewhat", "Somewhat likely"),
                            ("unlikely", "Not very likely, unlikely"),
                            ("not_at_all", "Not at all"),
                        ],
                        max_length=25,
                        verbose_name="Stay at home and avoid people",
                    ),
                ),
                (
                    "visit_clinic",
                    models.CharField(
                        choices=[
                            ("very", "Very likely"),
                            ("somewhat", "Somewhat likely"),
                            ("unlikely", "Not very likely, unlikely"),
                            ("not_at_all", "Not at all"),
                        ],
                        max_length=25,
                        verbose_name="Go to the nearest health facility",
                    ),
                ),
                (
                    "call_nurse",
                    models.CharField(
                        choices=[
                            ("very", "Very likely"),
                            ("somewhat", "Somewhat likely"),
                            ("unlikely", "Not very likely, unlikely"),
                            ("not_at_all", "Not at all"),
                        ],
                        max_length=25,
                        verbose_name="Call your nurse and tell them you are sick",
                    ),
                ),
                (
                    "take_meds",
                    models.CharField(
                        choices=[
                            ("very", "Very likely"),
                            ("somewhat", "Somewhat likely"),
                            ("unlikely", "Not very likely, unlikely"),
                            ("not_at_all", "Not at all"),
                        ],
                        max_length=25,
                        verbose_name="Take medicines like chloroquine",
                    ),
                ),
                (
                    "stop_chronic_meds",
                    models.CharField(
                        choices=[
                            ("very", "Very likely"),
                            ("somewhat", "Somewhat likely"),
                            ("unlikely", "Not very likely, unlikely"),
                            ("not_at_all", "Not at all"),
                        ],
                        max_length=25,
                        verbose_name="Stop taking my chronic disease medicines",
                    ),
                ),
                (
                    "visit_religious",
                    models.CharField(
                        choices=[
                            ("very", "Very likely"),
                            ("somewhat", "Somewhat likely"),
                            ("unlikely", "Not very likely, unlikely"),
                            ("not_at_all", "Not at all"),
                        ],
                        max_length=25,
                        verbose_name="Go to a religious leader instead of a doctor",
                    ),
                ),
                (
                    "visit_traditional",
                    models.CharField(
                        choices=[
                            ("very", "Very likely"),
                            ("somewhat", "Somewhat likely"),
                            ("unlikely", "Not very likely, unlikely"),
                            ("not_at_all", "Not at all"),
                        ],
                        max_length=25,
                        verbose_name="Go to a traditional healer instead of a doctor",
                    ),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.Site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="meta_subject.SubjectVisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Corona Knowledge, Attitudes, and Practices",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="CoronaKap",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django.utils.timezone.now,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django.utils.timezone.now,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                (
                    "consent_model",
                    models.CharField(editable=False, max_length=50, null=True),
                ),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "months_on_art",
                    models.IntegerField(
                        help_text="months",
                        verbose_name="How long has the patient been on antiretroviral therapy?",
                    ),
                ),
                (
                    "dm_aware",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        verbose_name="Does the patient know if he/she has diabetes?",
                    ),
                ),
                ("weight", edc_vitals.models.fields.weight.WeightField()),
                ("height", edc_vitals.models.fields.height.HeightField()),
                (
                    "sys_blood_pressure_r1",
                    edc_vitals.models.fields.blood_pressure.SystolicPressureField(null=True),
                ),
                (
                    "dia_blood_pressure_r1",
                    edc_vitals.models.fields.blood_pressure.DiastolicPressureField(null=True),
                ),
                (
                    "married",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        verbose_name="Married currently?",
                    ),
                ),
                (
                    "employment_status",
                    models.CharField(
                        choices=[
                            ("working_for_pay", "Working for pay"),
                            ("unemployed", "Unemployed"),
                            (
                                "not_working_for_pay",
                                "Not working for pay (housewife, retired...)",
                            ),
                        ],
                        max_length=25,
                        verbose_name="Employment status",
                    ),
                ),
                (
                    "shared_housing_one",
                    models.IntegerField(
                        verbose_name="How many people live together in your dwelling?"
                    ),
                ),
                (
                    "shared_housing_two",
                    models.IntegerField(
                        verbose_name="In a typically month, how many different people spend more than one night at your current dwelling"
                    ),
                ),
                (
                    "profession",
                    models.CharField(
                        choices=[
                            ("professional", "Professional (e.g. office"),
                            ("labourer", "Labourer"),
                            ("housewife_retired", "Housewife, Retired"),
                            ("self_employed", "Small business, self-employed"),
                            ("OTHER", "Other, specify below"),
                        ],
                        max_length=25,
                        verbose_name="Profession / Employment",
                    ),
                ),
                (
                    "other_profession",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "education",
                    models.CharField(
                        choices=[
                            ("primary", "Up to primary"),
                            ("secondary", "Up to high school"),
                            ("tertiary", "University, college"),
                            ("no_education", "No education"),
                        ],
                        max_length=25,
                        verbose_name="Education level",
                    ),
                ),
                (
                    "health_insurance",
                    models.CharField(
                        choices=[
                            ("work_scheme", "Work scheme health insurance"),
                            ("private", "Private health insurance"),
                            ("no_insurance", "No insurance, I pay"),
                            ("OTHER", "Other, please specify below"),
                        ],
                        max_length=25,
                        verbose_name="Health Insurance",
                    ),
                ),
                (
                    "other_health_insurance",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "personal_health_opinion",
                    models.CharField(
                        choices=[
                            ("excellent", "Excellent"),
                            ("good", "Good"),
                            ("fair", "Fair"),
                            ("poor", "Poor"),
                        ],
                        max_length=25,
                        verbose_name="In your opinion, what is your health like?",
                    ),
                ),
                (
                    "perceived_threat",
                    models.IntegerField(
                        help_text="On a scale from 1-10",
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(10),
                        ],
                        verbose_name="How serious of a public health threat is coronavirus",
                    ),
                ),
                (
                    "corona_concern",
                    models.CharField(
                        choices=[
                            ("very", "Very worried"),
                            ("somewhat", "Somewhat worried"),
                            ("a_little", "A little worried"),
                            ("not_at_all", "Not worried at all"),
                        ],
                        max_length=25,
                        verbose_name="How worried are you about getting coronavirus?",
                    ),
                ),
                (
                    "personal_infection_likelihood",
                    models.CharField(
                        choices=[
                            ("very", "Very likely"),
                            ("somewhat", "Somewhat likely"),
                            ("unlikely", "Not very likely, unlikely"),
                            ("not_at_all", "Not at all"),
                        ],
                        max_length=25,
                        verbose_name="Do you think you will get corona virus",
                    ),
                ),
                (
                    "family_infection_likelihood",
                    models.CharField(
                        choices=[
                            ("very", "Very likely"),
                            ("somewhat", "Somewhat likely"),
                            ("unlikely", "Not very likely, unlikely"),
                            ("not_at_all", "Not at all"),
                        ],
                        max_length=25,
                        verbose_name="How likely is that you or someone in your family will get sick from the coronavirus",
                    ),
                ),
                (
                    "perc_die",
                    models.IntegerField(
                        help_text="On a scale from 0-100",
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(100),
                        ],
                        verbose_name="What percentage of people who get coronavirus do you think will die",
                    ),
                ),
                (
                    "perc_mild_symptom",
                    models.IntegerField(
                        help_text="On a scale from 0-100",
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(100),
                        ],
                        verbose_name="What percentage of people who get coronavirus do you think will have only mild symptoms",
                    ),
                ),
                (
                    "spread_droplets",
                    models.CharField(
                        choices=[
                            ("true", "True"),
                            ("false", "False"),
                            ("dont_know", "Don't know"),
                        ],
                        max_length=25,
                        verbose_name="The virus spreads by droplets from cough and sneezes from people infected with coronavirus",
                    ),
                ),
                (
                    "spread_touch",
                    models.CharField(
                        choices=[
                            ("true", "True"),
                            ("false", "False"),
                            ("dont_know", "Don't know"),
                        ],
                        max_length=25,
                        verbose_name="The virus can spread by people touching each other",
                    ),
                ),
                (
                    "spread_sick",
                    models.CharField(
                        choices=[
                            ("true", "True"),
                            ("false", "False"),
                            ("dont_know", "Don't know"),
                        ],
                        max_length=25,
                        verbose_name="People transmit the virus when they are sick ",
                    ),
                ),
                (
                    "spread_asymptomatic",
                    models.CharField(
                        choices=[
                            ("true", "True"),
                            ("false", "False"),
                            ("dont_know", "Don't know"),
                        ],
                        max_length=25,
                        verbose_name="People can transmit the virus even when they do not appear to be sick",
                    ),
                ),
                (
                    "severity_age",
                    models.CharField(
                        choices=[
                            ("true", "True"),
                            ("false", "False"),
                            ("dont_know", "Don't know"),
                        ],
                        max_length=25,
                        verbose_name="The disease is more severe in older people than children",
                    ),
                ),
                (
                    "hot_climate",
                    models.CharField(
                        choices=[
                            ("true", "True"),
                            ("false", "False"),
                            ("dont_know", "Don't know"),
                        ],
                        max_length=25,
                        verbose_name="The virus does not survive in the hot climate",
                    ),
                ),
                (
                    "lives_on_materials",
                    models.CharField(
                        choices=[
                            ("true", "True"),
                            ("false", "False"),
                            ("dont_know", "Don't know"),
                        ],
                        max_length=25,
                        verbose_name="The virus can live on clothes, plastics, cardboard for a day or more",
                    ),
                ),
                (
                    "spread_touch2",
                    models.CharField(
                        choices=[
                            ("true", "True"),
                            ("false", "False"),
                            ("dont_know", "Don't know"),
                        ],
                        max_length=25,
                        verbose_name="You can catch the virus if you touch an infected area and then touch your face or eyes",
                    ),
                ),
                (
                    "symptoms_fever",
                    models.CharField(
                        choices=[
                            ("true", "True"),
                            ("false", "False"),
                            ("dont_know", "Don't know"),
                        ],
                        max_length=25,
                        verbose_name="Fever",
                    ),
                ),
                (
                    "symptoms_headache",
                    models.CharField(
                        choices=[
                            ("true", "True"),
                            ("false", "False"),
                            ("dont_know", "Don't know"),
                        ],
                        max_length=25,
                        verbose_name="Headache",
                    ),
                ),
                (
                    "symptoms_dry_cough",
                    models.CharField(
                        choices=[
                            ("true", "True"),
                            ("false", "False"),
                            ("dont_know", "Don't know"),
                        ],
                        max_length=25,
                        verbose_name="Dry persistant cough",
                    ),
                ),
                (
                    "symptoms_body_aches",
                    models.CharField(
                        choices=[
                            ("true", "True"),
                            ("false", "False"),
                            ("dont_know", "Don't know"),
                        ],
                        max_length=25,
                        verbose_name="Body aches",
                    ),
                ),
                (
                    "symptoms_smell",
                    models.CharField(
                        choices=[
                            ("true", "True"),
                            ("false", "False"),
                            ("dont_know", "Don't know"),
                        ],
                        max_length=25,
                        verbose_name="Loss of taste and smell",
                    ),
                ),
                (
                    "symptoms_breathing",
                    models.CharField(
                        choices=[
                            ("true", "True"),
                            ("false", "False"),
                            ("dont_know", "Don't know"),
                        ],
                        max_length=25,
                        verbose_name="Fast or difficult breathing",
                    ),
                ),
                (
                    "know_other_symptoms",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        verbose_name="Do you know of any other symptoms of a Coronavirus?",
                    ),
                ),
                (
                    "other_symptoms",
                    models.TextField(
                        blank=True,
                        max_length=250,
                        null=True,
                        verbose_name="Please list any other symptoms of a Corona virus infection that you are aware of",
                    ),
                ),
                (
                    "hot_drinks",
                    models.CharField(
                        choices=[
                            ("true", "True"),
                            ("false", "False"),
                            ("dont_know", "Don't know"),
                        ],
                        max_length=25,
                        verbose_name="Drink warm water or hot drinks like tea or coffee",
                    ),
                ),
                (
                    "alcohol",
                    models.CharField(
                        choices=[
                            ("true", "True"),
                            ("false", "False"),
                            ("dont_know", "Don't know"),
                        ],
                        max_length=25,
                        verbose_name="Drink alcohol, spirits, etc",
                    ),
                ),
                (
                    "wash_hands",
                    models.CharField(
                        choices=[
                            ("true", "True"),
                            ("false", "False"),
                            ("dont_know", "Don't know"),
                        ],
                        max_length=25,
                        verbose_name="Wash hands with soap and warm water virus",
                    ),
                ),
                (
                    "hand_sanitizer",
                    models.CharField(
                        choices=[
                            ("true", "True"),
                            ("false", "False"),
                            ("dont_know", "Don't know"),
                        ],
                        max_length=25,
                        verbose_name="Use hand sanitisers with alcohol",
                    ),
                ),
                (
                    "avoid_crowds",
                    models.CharField(
                        choices=[
                            ("true", "True"),
                            ("false", "False"),
                            ("dont_know", "Don't know"),
                        ],
                        max_length=25,
                        verbose_name="Avoid crowded places such as markets and public transport",
                    ),
                ),
                (
                    "face_masks",
                    models.CharField(
                        choices=[
                            ("true", "True"),
                            ("false", "False"),
                            ("dont_know", "Don't know"),
                        ],
                        max_length=25,
                        verbose_name="Wear a face mask",
                    ),
                ),
                (
                    "stay_indoors",
                    models.CharField(
                        choices=[
                            ("true", "True"),
                            ("false", "False"),
                            ("dont_know", "Don't know"),
                        ],
                        max_length=25,
                        verbose_name="Stay indoors",
                    ),
                ),
                (
                    "social_distance",
                    models.CharField(
                        choices=[
                            ("true", "True"),
                            ("false", "False"),
                            ("dont_know", "Don't know"),
                        ],
                        max_length=25,
                        verbose_name="Keep at least a 2 metre distance from people",
                    ),
                ),
                (
                    "stay_home",
                    models.CharField(
                        choices=[
                            ("very", "Very likely"),
                            ("somewhat", "Somewhat likely"),
                            ("unlikely", "Not very likely, unlikely"),
                            ("not_at_all", "Not at all"),
                        ],
                        max_length=25,
                        verbose_name="Stay at home and avoid people",
                    ),
                ),
                (
                    "visit_clinic",
                    models.CharField(
                        choices=[
                            ("very", "Very likely"),
                            ("somewhat", "Somewhat likely"),
                            ("unlikely", "Not very likely, unlikely"),
                            ("not_at_all", "Not at all"),
                        ],
                        max_length=25,
                        verbose_name="Go to the nearest health facility",
                    ),
                ),
                (
                    "call_nurse",
                    models.CharField(
                        choices=[
                            ("very", "Very likely"),
                            ("somewhat", "Somewhat likely"),
                            ("unlikely", "Not very likely, unlikely"),
                            ("not_at_all", "Not at all"),
                        ],
                        max_length=25,
                        verbose_name="Call your nurse and tell them you are sick",
                    ),
                ),
                (
                    "take_meds",
                    models.CharField(
                        choices=[
                            ("very", "Very likely"),
                            ("somewhat", "Somewhat likely"),
                            ("unlikely", "Not very likely, unlikely"),
                            ("not_at_all", "Not at all"),
                        ],
                        max_length=25,
                        verbose_name="Take medicines like chloroquine",
                    ),
                ),
                (
                    "stop_chronic_meds",
                    models.CharField(
                        choices=[
                            ("very", "Very likely"),
                            ("somewhat", "Somewhat likely"),
                            ("unlikely", "Not very likely, unlikely"),
                            ("not_at_all", "Not at all"),
                        ],
                        max_length=25,
                        verbose_name="Stop taking my chronic disease medicines",
                    ),
                ),
                (
                    "visit_religious",
                    models.CharField(
                        choices=[
                            ("very", "Very likely"),
                            ("somewhat", "Somewhat likely"),
                            ("unlikely", "Not very likely, unlikely"),
                            ("not_at_all", "Not at all"),
                        ],
                        max_length=25,
                        verbose_name="Go to a religious leader instead of a doctor",
                    ),
                ),
                (
                    "visit_traditional",
                    models.CharField(
                        choices=[
                            ("very", "Very likely"),
                            ("somewhat", "Somewhat likely"),
                            ("unlikely", "Not very likely, unlikely"),
                            ("not_at_all", "Not at all"),
                        ],
                        max_length=25,
                        verbose_name="Go to a traditional healer instead of a doctor",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.Site",
                    ),
                ),
                (
                    "subject_visit",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="meta_subject.SubjectVisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "Corona Knowledge, Attitudes, and Practices",
                "verbose_name_plural": "Corona Knowledge, Attitudes, and Practices",
            },
            managers=[
                ("on_site", django.contrib.sites.managers.CurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
            ],
        ),
    ]
