# Generated by Django 3.0.4 on 2020-04-20 14:32

import django.core.validators
from django.db import migrations, models


class Migration(migrations.Migration):
    dependencies = [
        ("meta_subject", "0027_auto_20200420_1645"),
    ]

    operations = [
        migrations.RemoveField(
            model_name="coronakap",
            name="diabetic_year",
        ),
        migrations.RemoveField(
            model_name="coronakap",
            name="hypertensive_year",
        ),
        migrations.RemoveField(
            model_name="coronakap",
            name="months_on_art",
        ),
        migrations.RemoveField(
            model_name="historicalcoronakap",
            name="diabetic_year",
        ),
        migrations.RemoveField(
            model_name="historicalcoronakap",
            name="hypertensive_year",
        ),
        migrations.RemoveField(
            model_name="historicalcoronakap",
            name="months_on_art",
        ),
        migrations.AddField(
            model_name="coronakap",
            name="diabetic_dx_year",
            field=models.IntegerField(
                blank=True,
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(1950),
                    django.core.validators.MinValueValidator(2020),
                ],
                verbose_name="If Yes, what year did you first learn you had <u>diabetes</u>?",
            ),
        ),
        migrations.AddField(
            model_name="coronakap",
            name="hiv_year_started_art",
            field=models.IntegerField(
                blank=True,
                help_text="in months",
                null=True,
                validators=[django.core.validators.MinValueValidator(0)],
                verbose_name="If Yes, what year did you did you <u>start antiretroviral therapy</u>?",
            ),
        ),
        migrations.AddField(
            model_name="coronakap",
            name="hypertensive_dx_year",
            field=models.IntegerField(
                blank=True,
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(1950),
                    django.core.validators.MinValueValidator(2020),
                ],
                verbose_name="If Yes, what year did you first learn you had <u>hypertension</u>?",
            ),
        ),
        migrations.AddField(
            model_name="historicalcoronakap",
            name="diabetic_dx_year",
            field=models.IntegerField(
                blank=True,
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(1950),
                    django.core.validators.MinValueValidator(2020),
                ],
                verbose_name="If Yes, what year did you first learn you had <u>diabetes</u>?",
            ),
        ),
        migrations.AddField(
            model_name="historicalcoronakap",
            name="hiv_year_started_art",
            field=models.IntegerField(
                blank=True,
                help_text="in months",
                null=True,
                validators=[django.core.validators.MinValueValidator(0)],
                verbose_name="If Yes, what year did you did you <u>start antiretroviral therapy</u>?",
            ),
        ),
        migrations.AddField(
            model_name="historicalcoronakap",
            name="hypertensive_dx_year",
            field=models.IntegerField(
                blank=True,
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(1950),
                    django.core.validators.MinValueValidator(2020),
                ],
                verbose_name="If Yes, what year did you first learn you had <u>hypertension</u>?",
            ),
        ),
        migrations.AlterField(
            model_name="coronakap",
            name="diabetic_on_meds",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                max_length=25,
                verbose_name="If Yes, are you taking medications to control your <u>diabetes</u>?",
            ),
        ),
        migrations.AlterField(
            model_name="coronakap",
            name="hiv_pos_year",
            field=models.IntegerField(
                blank=True,
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(1950),
                    django.core.validators.MinValueValidator(2020),
                ],
                verbose_name="If Yes, what year did you first test positive?",
            ),
        ),
        migrations.AlterField(
            model_name="coronakap",
            name="hypertensive_on_meds",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                max_length=25,
                verbose_name="If Yes, are you taking medications to control your <u>hypertension</u>?",
            ),
        ),
        migrations.AlterField(
            model_name="historicalcoronakap",
            name="diabetic_on_meds",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                max_length=25,
                verbose_name="If Yes, are you taking medications to control your <u>diabetes</u>?",
            ),
        ),
        migrations.AlterField(
            model_name="historicalcoronakap",
            name="hiv_pos_year",
            field=models.IntegerField(
                blank=True,
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(1950),
                    django.core.validators.MinValueValidator(2020),
                ],
                verbose_name="If Yes, what year did you first test positive?",
            ),
        ),
        migrations.AlterField(
            model_name="historicalcoronakap",
            name="hypertensive_on_meds",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                max_length=25,
                verbose_name="If Yes, are you taking medications to control your <u>hypertension</u>?",
            ),
        ),
    ]
