# Generated by Django 3.2.4 on 2021-07-16 05:13

import django.core.validators
import edc_model.validators.date
import edc_vitals.models.fields.weight
from django.db import migrations, models


class Migration(migrations.Migration):
    dependencies = [
        ("meta_subject", "0064_auto_20210715_2336"),
    ]

    operations = [
        migrations.AddField(
            model_name="historicalpatienthistory",
            name="dyslipidaemia_diagnosis",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                max_length=15,
                null=True,
                verbose_name="Has the patient been diagnosed with dyslipidaemia?",
            ),
        ),
        migrations.AddField(
            model_name="historicalpatienthistory",
            name="on_dyslipidaemia_treatment",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                default="N/A",
                max_length=15,
                verbose_name="Is the patient on treatment for dyslipidaemia?",
            ),
        ),
        migrations.AddField(
            model_name="patienthistory",
            name="dyslipidaemia_diagnosis",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                max_length=15,
                null=True,
                verbose_name="Has the patient been diagnosed with dyslipidaemia?",
            ),
        ),
        migrations.AddField(
            model_name="patienthistory",
            name="on_dyslipidaemia_treatment",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                default="N/A",
                max_length=15,
                verbose_name="Is the patient on treatment for dyslipidaemia?",
            ),
        ),
        migrations.AlterField(
            model_name="followupvitals",
            name="weight",
            field=edc_vitals.models.fields.weight.WeightField(null=True),
        ),
        migrations.AlterField(
            model_name="hepatitistest",
            name="hbsag",
            field=models.CharField(
                blank=True,
                choices=[
                    ("POS", "Positive"),
                    ("NEG", "Negative"),
                    ("IND", "Indeterminate"),
                ],
                max_length=15,
                null=True,
                verbose_name="<u>HbSAg</u>",
            ),
        ),
        migrations.AlterField(
            model_name="hepatitistest",
            name="hbsag_date",
            field=models.DateField(
                blank=True,
                help_text="Approximate if not known",
                null=True,
                validators=[
                    edc_model.validators.date.date_is_past,
                    edc_model.validators.date.date_is_not_now,
                ],
                verbose_name="<i>HbSAg date</i>",
            ),
        ),
        migrations.AlterField(
            model_name="hepatitistest",
            name="hbsag_performed",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                help_text="Answer `YES` if `ever` performed and a result is available.",
                max_length=15,
                verbose_name="Was Hepatitis B Surface Antigen test performed?",
            ),
        ),
        migrations.AlterField(
            model_name="hepatitistest",
            name="hcv",
            field=models.CharField(
                blank=True,
                choices=[
                    ("POS", "Positive"),
                    ("NEG", "Negative"),
                    ("IND", "Indeterminate"),
                ],
                max_length=15,
                null=True,
                verbose_name="<u>HCV</u>",
            ),
        ),
        migrations.AlterField(
            model_name="hepatitistest",
            name="hcv_date",
            field=models.DateField(
                blank=True,
                help_text="Approximate if not known",
                null=True,
                validators=[
                    edc_model.validators.date.date_is_past,
                    edc_model.validators.date.date_is_not_now,
                ],
                verbose_name="<i>HCV date</i>",
            ),
        ),
        migrations.AlterField(
            model_name="hepatitistest",
            name="hcv_performed",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                help_text="Answer `YES` if `ever` performed and a result is available.",
                max_length=15,
                verbose_name="Was the patient tested for Hepatitis C?",
            ),
        ),
        migrations.AlterField(
            model_name="historicalfollowupvitals",
            name="weight",
            field=edc_vitals.models.fields.weight.WeightField(null=True),
        ),
        migrations.AlterField(
            model_name="historicalhepatitistest",
            name="hbsag",
            field=models.CharField(
                blank=True,
                choices=[
                    ("POS", "Positive"),
                    ("NEG", "Negative"),
                    ("IND", "Indeterminate"),
                ],
                max_length=15,
                null=True,
                verbose_name="<u>HbSAg</u>",
            ),
        ),
        migrations.AlterField(
            model_name="historicalhepatitistest",
            name="hbsag_date",
            field=models.DateField(
                blank=True,
                help_text="Approximate if not known",
                null=True,
                validators=[
                    edc_model.validators.date.date_is_past,
                    edc_model.validators.date.date_is_not_now,
                ],
                verbose_name="<i>HbSAg date</i>",
            ),
        ),
        migrations.AlterField(
            model_name="historicalhepatitistest",
            name="hbsag_performed",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                help_text="Answer `YES` if `ever` performed and a result is available.",
                max_length=15,
                verbose_name="Was Hepatitis B Surface Antigen test performed?",
            ),
        ),
        migrations.AlterField(
            model_name="historicalhepatitistest",
            name="hcv",
            field=models.CharField(
                blank=True,
                choices=[
                    ("POS", "Positive"),
                    ("NEG", "Negative"),
                    ("IND", "Indeterminate"),
                ],
                max_length=15,
                null=True,
                verbose_name="<u>HCV</u>",
            ),
        ),
        migrations.AlterField(
            model_name="historicalhepatitistest",
            name="hcv_date",
            field=models.DateField(
                blank=True,
                help_text="Approximate if not known",
                null=True,
                validators=[
                    edc_model.validators.date.date_is_past,
                    edc_model.validators.date.date_is_not_now,
                ],
                verbose_name="<i>HCV date</i>",
            ),
        ),
        migrations.AlterField(
            model_name="historicalhepatitistest",
            name="hcv_performed",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                help_text="Answer `YES` if `ever` performed and a result is available.",
                max_length=15,
                verbose_name="Was the patient tested for Hepatitis C?",
            ),
        ),
        migrations.AlterField(
            model_name="historicalpatienthistory",
            name="dyslipidaemia_rx",
            field=models.CharField(
                choices=[
                    ("atorvastatin", "Atorvastatin"),
                    ("rosuvastatin", "Rosuvastatin"),
                    ("N/A", "Not applicable"),
                ],
                default="N/A",
                max_length=25,
                verbose_name="What medication is the patient currently taking for dyslipidaemia?",
            ),
        ),
        migrations.AlterField(
            model_name="historicalphysicalexam",
            name="waist_circumference",
            field=models.DecimalField(
                decimal_places=1,
                help_text="in centimeters",
                max_digits=5,
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(50.0),
                    django.core.validators.MaxValueValidator(175.0),
                ],
                verbose_name="Waist circumference",
            ),
        ),
        migrations.AlterField(
            model_name="historicalphysicalexam",
            name="weight",
            field=edc_vitals.models.fields.weight.WeightField(null=True),
        ),
        migrations.AlterField(
            model_name="patienthistory",
            name="dyslipidaemia_rx",
            field=models.CharField(
                choices=[
                    ("atorvastatin", "Atorvastatin"),
                    ("rosuvastatin", "Rosuvastatin"),
                    ("N/A", "Not applicable"),
                ],
                default="N/A",
                max_length=25,
                verbose_name="What medication is the patient currently taking for dyslipidaemia?",
            ),
        ),
        migrations.AlterField(
            model_name="physicalexam",
            name="waist_circumference",
            field=models.DecimalField(
                decimal_places=1,
                help_text="in centimeters",
                max_digits=5,
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(50.0),
                    django.core.validators.MaxValueValidator(175.0),
                ],
                verbose_name="Waist circumference",
            ),
        ),
        migrations.AlterField(
            model_name="physicalexam",
            name="weight",
            field=edc_vitals.models.fields.weight.WeightField(null=True),
        ),
    ]
