# Generated by Django 3.2.11 on 2022-04-14 21:43
from django.core.exceptions import ObjectDoesNotExist
from django.db import migrations
from django.db.migrations import RunPython
from edc_consent.utils import get_consent_model_name
from edc_pharmacy.prescribe import create_prescription

from meta_edc.meta_version import get_meta_version
from meta_pharmacy.constants import METFORMIN


def func(apps, schema_editor):
    try:
        medication = apps.get_model("edc_pharmacy.medication")._default_manager.get(
            name=METFORMIN
        )
    except ObjectDoesNotExist:
        pass
    else:
        site_model_cls = apps.get_model("sites.site")
        subject_identifiers = [
            tpl[0]
            for tpl in apps.get_model("edc_pharmacy.rx")._default_manager.values_list(
                "subject_identifier"
            )
        ]
        for subject_consent in apps.get_model(
            get_consent_model_name()
        )._default_manager.exclude(subject_identifier__in=subject_identifiers):
            site = site_model_cls.objects.get(id=subject_consent.site.id)
            create_prescription(
                subject_identifier=subject_consent.subject_identifier,
                report_datetime=subject_consent.consent_datetime,
                randomizer_name=get_meta_version(),
                medication_names=[METFORMIN],
                site_id=site.id,
            )
        for obj in apps.get_model("edc_pharmacy.rx")._default_manager.all():
            obj.medications.clear()
            obj.medications.add(medication)


class Migration(migrations.Migration):
    dependencies = [
        ("meta_subject", "0106_auto_20220414_1741"),
    ]

    operations = [RunPython(func)]
