# Generated by Django 5.0.1 on 2024-02-13 03:29

from django.db import migrations, models


class Migration(migrations.Migration):
    dependencies = [
        ("meta_lists", "0017_complications_dmmedications_dmtreatments_and_more"),
        ("meta_subject", "0168_alter_dmreferralfollowup_last_missed_pill_and_more"),
        ("sites", "0002_alter_domain_unique"),
    ]

    operations = [
        migrations.AlterModelOptions(
            name="dmreferralfollowup",
            options={
                "default_manager_name": "objects",
                "default_permissions": ("add", "change", "delete", "view", "export", "import"),
                "verbose_name": "Diabetes referral follow-up",
                "verbose_name_plural": "Diabetes referral follow-up",
            },
        ),
        migrations.AddField(
            model_name="glucose",
            name="endpoint_today",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                default="N/A",
                help_text="Answer yes or no if both the FBG and OGTT are available",
                max_length=25,
                verbose_name="Based on the tests results above, has the participant reached a study endpoint today?",
            ),
        ),
        migrations.AddField(
            model_name="glucose",
            name="repeat_fbg",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="No",
                help_text="FBG needs to be repeated if the above FBG>=7 and OGTT<11.1",
                max_length=25,
                verbose_name="As per protocol, does the FBG need to be repeated?",
            ),
        ),
        migrations.AddField(
            model_name="glucose",
            name="repeat_fbg_date",
            field=models.DateField(
                blank=True, null=True, verbose_name="Date particpant to repeat FBG"
            ),
        ),
        migrations.AddField(
            model_name="historicalglucose",
            name="endpoint_today",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                default="N/A",
                help_text="Answer yes or no if both the FBG and OGTT are available",
                max_length=25,
                verbose_name="Based on the tests results above, has the participant reached a study endpoint today?",
            ),
        ),
        migrations.AddField(
            model_name="historicalglucose",
            name="repeat_fbg",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="No",
                help_text="FBG needs to be repeated if the above FBG>=7 and OGTT<11.1",
                max_length=25,
                verbose_name="As per protocol, does the FBG need to be repeated?",
            ),
        ),
        migrations.AddField(
            model_name="historicalglucose",
            name="repeat_fbg_date",
            field=models.DateField(
                blank=True, null=True, verbose_name="Date particpant to repeat FBG"
            ),
        ),
        migrations.AddIndex(
            model_name="dmreferralfollowup",
            index=models.Index(
                fields=["subject_visit", "site"], name="meta_subjec_subject_cfb7da_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="dmreferralfollowup",
            index=models.Index(
                fields=["subject_visit", "report_datetime"],
                name="meta_subjec_subject_257846_idx",
            ),
        ),
    ]
