# Generated by Django 4.2.11 on 2024-05-15 21:35

from django.db import migrations, models
import edc_model_fields.fields.other_charfield


class Migration(migrations.Migration):

    dependencies = [
        ("meta_subject", "0188_historicaldmdxresult_dmdxresult"),
    ]

    operations = [
        migrations.AlterModelOptions(
            name="dmdxresult",
            options={
                "default_manager_name": "objects",
                "default_permissions": ("add", "change", "delete", "view", "export", "import"),
                "verbose_name": "Diabetes diagnosis: Result",
                "verbose_name_plural": "Diabetes diagnosis: Results",
            },
        ),
        migrations.AlterModelOptions(
            name="historicaldmdxresult",
            options={
                "get_latest_by": ("history_date", "history_id"),
                "ordering": ("-history_date", "-history_id"),
                "verbose_name": "historical Diabetes diagnosis: Result",
                "verbose_name_plural": "historical Diabetes diagnosis: Results",
            },
        ),
        migrations.AddField(
            model_name="dmdiagnosis",
            name="dx_initiated_by_other",
            field=edc_model_fields.fields.other_charfield.OtherCharField(
                blank=True,
                max_length=35,
                null=True,
                verbose_name="If other, please specify ...",
            ),
        ),
        migrations.AddField(
            model_name="historicaldmdiagnosis",
            name="dx_initiated_by_other",
            field=edc_model_fields.fields.other_charfield.OtherCharField(
                blank=True,
                max_length=35,
                null=True,
                verbose_name="If other, please specify ...",
            ),
        ),
        migrations.AlterField(
            model_name="dmdiagnosis",
            name="comments",
            field=models.TextField(blank=True, null=True, verbose_name="Any other comments"),
        ),
        migrations.AlterField(
            model_name="dmdiagnosis",
            name="dx_initiated_by",
            field=models.CharField(
                choices=[
                    ("fbg_confirmed", "Any FBG >= 7.0 mmol/L (confirmed by OGTT)"),
                    ("fbg_unconfirmed", "Any FBG >= 7.0 mmol/L (NOT confirmed by OGTT)"),
                    ("ogtt_annaul", "Annual OGTT >= 11.1 mmol/L"),
                    (
                        "ogtt_unscheduled",
                        "Any OGTT >= 11.1 mmol/L (excluding annual or used in confirmation)",
                    ),
                    ("OTHER", "Other"),
                ],
                max_length=25,
                verbose_name="What initiated the diagnosis",
            ),
        ),
        migrations.AlterField(
            model_name="dmdxresult",
            name="utestid",
            field=models.CharField(
                choices=[("fbg", "FBG"), ("ogtt", "OGTT"), ("hba1c", "HbA1c")],
                max_length=15,
                verbose_name="Test",
            ),
        ),
        migrations.AlterField(
            model_name="historicaldmdiagnosis",
            name="comments",
            field=models.TextField(blank=True, null=True, verbose_name="Any other comments"),
        ),
        migrations.AlterField(
            model_name="historicaldmdiagnosis",
            name="dx_initiated_by",
            field=models.CharField(
                choices=[
                    ("fbg_confirmed", "Any FBG >= 7.0 mmol/L (confirmed by OGTT)"),
                    ("fbg_unconfirmed", "Any FBG >= 7.0 mmol/L (NOT confirmed by OGTT)"),
                    ("ogtt_annaul", "Annual OGTT >= 11.1 mmol/L"),
                    (
                        "ogtt_unscheduled",
                        "Any OGTT >= 11.1 mmol/L (excluding annual or used in confirmation)",
                    ),
                    ("OTHER", "Other"),
                ],
                max_length=25,
                verbose_name="What initiated the diagnosis",
            ),
        ),
        migrations.AlterField(
            model_name="historicaldmdxresult",
            name="utestid",
            field=models.CharField(
                choices=[("fbg", "FBG"), ("ogtt", "OGTT"), ("hba1c", "HbA1c")],
                max_length=15,
                verbose_name="Test",
            ),
        ),
    ]
