# Generated by Django 4.2.11 on 2024-05-15 23:32

import django.core.validators
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ("meta_subject", "0193_alter_glucosefbg_fbg_value_and_more"),
    ]

    operations = [
        migrations.RenameField(
            model_name="glucosefbg",
            old_name="assay_datetime",
            new_name="fbg_datetime",
        ),
        migrations.RenameField(
            model_name="historicalglucosefbg",
            old_name="assay_datetime",
            new_name="fbg_datetime",
        ),
        migrations.AddField(
            model_name="glucosefbg",
            name="fasting_duration_minutes",
            field=models.IntegerField(
                blank=True, help_text="system calculated value", null=True
            ),
        ),
        migrations.AddField(
            model_name="glucosefbg",
            name="fasting_duration_str",
            field=models.CharField(
                blank=True,
                help_text="As reported by patient. Duration of fast. Format is `HHhMMm`. For example 1h23m, 12h7m, etc",
                max_length=8,
                null=True,
                validators=[
                    django.core.validators.RegexValidator(
                        "^([0-9]{1,3}h([0-5]?[0-9]m)?)$",
                        message="Invalid format. Expected something like 1h20m, 11h5m, etc. No spaces allowed.",
                    )
                ],
                verbose_name="How long have they fasted in hours and/or minutes?",
            ),
        ),
        migrations.AddField(
            model_name="historicalglucosefbg",
            name="fasting_duration_minutes",
            field=models.IntegerField(
                blank=True, help_text="system calculated value", null=True
            ),
        ),
        migrations.AddField(
            model_name="historicalglucosefbg",
            name="fasting_duration_str",
            field=models.CharField(
                blank=True,
                help_text="As reported by patient. Duration of fast. Format is `HHhMMm`. For example 1h23m, 12h7m, etc",
                max_length=8,
                null=True,
                validators=[
                    django.core.validators.RegexValidator(
                        "^([0-9]{1,3}h([0-5]?[0-9]m)?)$",
                        message="Invalid format. Expected something like 1h20m, 11h5m, etc. No spaces allowed.",
                    )
                ],
                verbose_name="How long have they fasted in hours and/or minutes?",
            ),
        ),
        migrations.AlterField(
            model_name="glucosefbg",
            name="fasting",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                help_text="As reported by patient",
                max_length=15,
                null=True,
                verbose_name="Has the participant fasted?",
            ),
        ),
        migrations.AlterField(
            model_name="glucosefbg",
            name="fbg_quantifier",
            field=models.CharField(
                choices=[("=", "="), (">", ">"), (">=", ">="), ("<", "<"), ("<=", "<=")],
                default="=",
                max_length=10,
                verbose_name="FBG quantifier",
            ),
        ),
        migrations.AlterField(
            model_name="glucosefbg",
            name="fbg_units",
            field=models.CharField(
                choices=[
                    ("mg/dL", "mg/dL"),
                    ("mmol/L", "mmol/L (millimoles/L)"),
                    ("N/A", "Not applicable"),
                ],
                default="N/A",
                max_length=15,
                verbose_name="FBG units",
            ),
        ),
        migrations.AlterField(
            model_name="glucosefbg",
            name="fbg_value",
            field=models.DecimalField(
                blank=True,
                decimal_places=2,
                help_text="A `HIGH` reading may be entered as 9999.99",
                max_digits=8,
                null=True,
                verbose_name="FBG level",
            ),
        ),
        migrations.AlterField(
            model_name="historicalglucosefbg",
            name="fasting",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                help_text="As reported by patient",
                max_length=15,
                null=True,
                verbose_name="Has the participant fasted?",
            ),
        ),
        migrations.AlterField(
            model_name="historicalglucosefbg",
            name="fbg_quantifier",
            field=models.CharField(
                choices=[("=", "="), (">", ">"), (">=", ">="), ("<", "<"), ("<=", "<=")],
                default="=",
                max_length=10,
                verbose_name="FBG quantifier",
            ),
        ),
        migrations.AlterField(
            model_name="historicalglucosefbg",
            name="fbg_units",
            field=models.CharField(
                choices=[
                    ("mg/dL", "mg/dL"),
                    ("mmol/L", "mmol/L (millimoles/L)"),
                    ("N/A", "Not applicable"),
                ],
                default="N/A",
                max_length=15,
                verbose_name="FBG units",
            ),
        ),
        migrations.AlterField(
            model_name="historicalglucosefbg",
            name="fbg_value",
            field=models.DecimalField(
                blank=True,
                decimal_places=2,
                help_text="A `HIGH` reading may be entered as 9999.99",
                max_digits=8,
                null=True,
                verbose_name="FBG level",
            ),
        ),
    ]
