# Generated by Django 5.2.6 on 2025-09-30 00:41

import _socket
import django.db.models.deletion
import django.utils.timezone
import django_audit_fields.fields.hostname_modification_field
import django_audit_fields.fields.userfield
import django_audit_fields.fields.uuid_auto_field
import django_revision.revision_field
import edc_crf.model_mixins.crf_status_model_mixin
import edc_model.validators.date
import edc_protocol.validators
import edc_visit_tracking.managers
import simple_history.models
import uuid
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ("meta_subject", "0232_alter_patienthistory_concomitant_conditions_and_more"),
        ("sites", "0002_alter_domain_unique"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="HistoricalSpfq",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        default="",
                        editable=False,
                        help_text="System field. From git repository (tag:branch:commit), project metadata, project toml, project VERSION, or settings.",
                        max_length=75,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(blank=True, default=django.utils.timezone.now),
                ),
                (
                    "modified",
                    models.DateTimeField(blank=True, default=django.utils.timezone.now),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        default="",
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        default="",
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                        verbose_name="Hostname created",
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        default="",
                        help_text="System field. (modified on every save)",
                        max_length=50,
                        verbose_name="Hostname modified",
                    ),
                ),
                (
                    "device_created",
                    models.CharField(
                        blank=True,
                        default="",
                        max_length=10,
                        verbose_name="Device created",
                    ),
                ),
                (
                    "device_modified",
                    models.CharField(
                        blank=True,
                        default="",
                        max_length=10,
                        verbose_name="Device modified",
                    ),
                ),
                (
                    "locale_created",
                    models.CharField(
                        blank=True,
                        default="",
                        help_text="Auto-updated by Modeladmin",
                        max_length=10,
                        verbose_name="Locale created",
                    ),
                ),
                (
                    "locale_modified",
                    models.CharField(
                        blank=True,
                        default="",
                        help_text="Auto-updated by Modeladmin",
                        max_length=10,
                        verbose_name="Locale modified",
                    ),
                ),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "consent_model",
                    models.CharField(blank=True, default="", max_length=50),
                ),
                (
                    "consent_version",
                    models.CharField(blank=True, default="", max_length=10),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=django.utils.timezone.now,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default=edc_crf.model_mixins.crf_status_model_mixin.get_crf_status_default,
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        default="",
                        help_text="for example, why some data is still pending",
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "a01",
                    models.CharField(
                        choices=[
                            ("strongly_disagree", "Strongly disagree"),
                            ("disagree", "disagree"),
                            ("neutral", "Neutral"),
                            ("agree", "Agree"),
                            ("strongly_agree", "Strongly agree"),
                        ],
                        help_text="for example: when and how to take or use a treatment",
                        max_length=25,
                        verbose_name="I understood the treatment process in this trial",
                    ),
                ),
                (
                    "a02",
                    models.CharField(
                        choices=[
                            ("strongly_disagree", "Strongly disagree"),
                            ("disagree", "disagree"),
                            ("neutral", "Neutral"),
                            ("agree", "Agree"),
                            ("strongly_agree", "Strongly agree"),
                        ],
                        help_text="for example: visits and procedures, time commitment, who to contact with questions",
                        max_length=25,
                        verbose_name="The information given to me before I joined the trial was everything I wanted to know",
                    ),
                ),
                (
                    "a03",
                    models.CharField(
                        choices=[
                            ("strongly_disagree", "Strongly disagree"),
                            ("disagree", "disagree"),
                            ("neutral", "Neutral"),
                            ("agree", "Agree"),
                            ("strongly_agree", "Strongly agree"),
                        ],
                        help_text="for example: visits and procedures, time commitment, who to contact with questions",
                        max_length=25,
                        verbose_name="The information given to me before I joined the trial was easy for me to understand",
                    ),
                ),
                (
                    "a04",
                    models.CharField(
                        choices=[
                            ("strongly_disagree", "Strongly disagree"),
                            ("disagree", "disagree"),
                            ("neutral", "Neutral"),
                            ("agree", "Agree"),
                            ("strongly_agree", "Strongly agree"),
                        ],
                        max_length=25,
                        verbose_name="I felt comfortable that I could ask any questions before I joined the trial",
                    ),
                ),
                (
                    "b01",
                    models.CharField(
                        choices=[
                            ("strongly_disagree", "Strongly disagree"),
                            ("disagree", "disagree"),
                            ("neutral", "Neutral"),
                            ("agree", "Agree"),
                            ("strongly_agree", "Strongly agree"),
                        ],
                        help_text="for example: comfort and privacy of treatment area, waiting area, parking, ease of access to the site",
                        max_length=25,
                        verbose_name="Overall I was satisfied with the trial site",
                    ),
                ),
                (
                    "b02",
                    models.CharField(
                        choices=[
                            ("strongly_disagree", "Strongly disagree"),
                            ("disagree", "disagree"),
                            ("neutral", "Neutral"),
                            ("agree", "Agree"),
                            ("strongly_agree", "Strongly agree"),
                        ],
                        max_length=25,
                        verbose_name="My trial visits were well organized",
                    ),
                ),
                (
                    "b03",
                    models.CharField(
                        choices=[
                            ("strongly_disagree", "Strongly disagree"),
                            ("disagree", "disagree"),
                            ("neutral", "Neutral"),
                            ("agree", "Agree"),
                            ("strongly_agree", "Strongly agree"),
                        ],
                        max_length=25,
                        verbose_name="My trial visits were scheduled at a convenient time for me",
                    ),
                ),
                (
                    "b04",
                    models.CharField(
                        choices=[
                            ("strongly_disagree", "Strongly disagree"),
                            ("disagree", "disagree"),
                            ("neutral", "Neutral"),
                            ("agree", "Agree"),
                            ("strongly_agree", "Strongly agree"),
                        ],
                        max_length=25,
                        verbose_name="The staff treated me with respect",
                    ),
                ),
                (
                    "b05",
                    models.CharField(
                        choices=[
                            ("strongly_disagree", "Strongly disagree"),
                            ("disagree", "disagree"),
                            ("neutral", "Neutral"),
                            ("agree", "Agree"),
                            ("strongly_agree", "Strongly agree"),
                        ],
                        max_length=25,
                        verbose_name="I felt comfortable that I could ask questions during the trial",
                    ),
                ),
                (
                    "b06",
                    models.CharField(
                        choices=[
                            ("strongly_disagree", "Strongly disagree"),
                            ("disagree", "disagree"),
                            ("neutral", "Neutral"),
                            ("agree", "Agree"),
                            ("strongly_agree", "Strongly agree"),
                        ],
                        max_length=25,
                        verbose_name="I was satisfied with the answers I have received to my questions during the trial",
                    ),
                ),
                (
                    "b07",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="for example: in person visits, questionnaires, forms",
                        max_length=25,
                        verbose_name="The time taken to collect data was acceptable to me",
                    ),
                ),
                (
                    "b08",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="for example: household chores, work commitments, eating",
                        max_length=25,
                        verbose_name="The impact the trial has had on my daily activities is acceptable",
                    ),
                ),
                (
                    "b09",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="for example: in person, online questionnaire, diary, wearable sensors, monitoring machines, technology",
                        max_length=25,
                        verbose_name="The way in which trial data is being collected is acceptable to me",
                    ),
                ),
                (
                    "b10",
                    models.CharField(
                        choices=[
                            ("strongly_disagree", "Strongly disagree"),
                            ("disagree", "disagree"),
                            ("neutral", "Neutral"),
                            ("agree", "Agree"),
                            ("strongly_agree", "Strongly agree"),
                        ],
                        help_text="for example: blood tests, scans etc.",
                        max_length=25,
                        verbose_name="Optional: I am being kept informed of the results of my medical tests done during the trial, including during screening",
                    ),
                ),
                (
                    "c01",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        verbose_name="I was informed when I had completed the trial",
                    ),
                ),
                (
                    "c02",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        verbose_name="I was informed of any future opportunities to access the overall trial results if I wanted to",
                    ),
                ),
                (
                    "c03",
                    models.CharField(
                        choices=[
                            ("very_difficult", "Very difficult"),
                            ("difficult", "Difficult"),
                            ("neutral", "Neutral"),
                            ("easy", "Easy"),
                            ("very_easy", "Very easy"),
                        ],
                        max_length=25,
                        verbose_name="How easy was it to take the medication?",
                    ),
                ),
                (
                    "c04",
                    models.CharField(
                        choices=[
                            ("not_at_all", "Not at all"),
                            ("slight", "Slight"),
                            ("moderate", "Moderate"),
                            ("extreme", "Extreme"),
                            ("severe", "Severe"),
                        ],
                        max_length=25,
                        verbose_name="Did you experience any burden or side effects?",
                    ),
                ),
                (
                    "c05",
                    models.CharField(
                        choices=[
                            ("not_at_all", "Not at all"),
                            ("slightly", "Slightly"),
                            ("moderately", "Moderately"),
                            ("highly", "Highly"),
                            ("very_highly", "Very highly"),
                        ],
                        max_length=25,
                        verbose_name="How acceptable was it to take the drug?",
                    ),
                ),
                (
                    "c06",
                    models.CharField(
                        choices=[
                            ("very_difficult", "Very difficult"),
                            ("difficult", "Difficult"),
                            ("neutral", "Neutral"),
                            ("easy", "Easy"),
                            ("very_easy", "Very easy"),
                        ],
                        max_length=25,
                        verbose_name="How easy was it to fit the medication into your routine?",
                    ),
                ),
                (
                    "c07",
                    models.CharField(
                        choices=[
                            ("not_at_all", "Not at all"),
                            ("slight", "Slight"),
                            ("moderate", "Moderate"),
                            ("extreme", "Extreme"),
                            ("severe", "Severe"),
                        ],
                        max_length=25,
                        verbose_name="How burdensome was taking part in the trial?",
                    ),
                ),
                (
                    "c08",
                    models.CharField(
                        choices=[
                            ("strongly_disagree", "Strongly disagree"),
                            ("disagree", "disagree"),
                            ("neutral", "Neutral"),
                            ("agree", "Agree"),
                            ("strongly_agree", "Strongly agree"),
                        ],
                        help_text="for example: future treatment, follow-up contact details",
                        max_length=25,
                        verbose_name="Overall, I was satisfied with the information I received about future support after the trial",
                    ),
                ),
                (
                    "c09",
                    models.CharField(
                        choices=[
                            ("strongly_disagree", "Strongly disagree"),
                            ("disagree", "disagree"),
                            ("neutral", "Neutral"),
                            ("agree", "Agree"),
                            ("strongly_agree", "Strongly agree"),
                        ],
                        max_length=25,
                        verbose_name="Overall, I was satisfied with my trial experience",
                    ),
                ),
                (
                    "c10",
                    models.CharField(
                        choices=[
                            ("much_less_expected", "Much less than expected"),
                            ("somewhat_less_expected", "Somewhat less than expected"),
                            ("same_as_expected", "Same as expected"),
                            ("somewhat_more_expected", "Somewhat more than expected"),
                            ("much_more_expected", "Much more than expected"),
                        ],
                        max_length=25,
                        verbose_name="Compared to when the trial started, the overall commitment required was similar to what I expected",
                    ),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="meta_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Feedback Questionnaire (SPFQ)",
                "verbose_name_plural": "historical Feedback Questionnaires (SPFQ)",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="Spfq",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        default="",
                        editable=False,
                        help_text="System field. From git repository (tag:branch:commit), project metadata, project toml, project VERSION, or settings.",
                        max_length=75,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(blank=True, default=django.utils.timezone.now),
                ),
                (
                    "modified",
                    models.DateTimeField(blank=True, default=django.utils.timezone.now),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        default="",
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        default="",
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                        verbose_name="Hostname created",
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        default="",
                        help_text="System field. (modified on every save)",
                        max_length=50,
                        verbose_name="Hostname modified",
                    ),
                ),
                (
                    "device_created",
                    models.CharField(
                        blank=True,
                        default="",
                        max_length=10,
                        verbose_name="Device created",
                    ),
                ),
                (
                    "device_modified",
                    models.CharField(
                        blank=True,
                        default="",
                        max_length=10,
                        verbose_name="Device modified",
                    ),
                ),
                (
                    "locale_created",
                    models.CharField(
                        blank=True,
                        default="",
                        help_text="Auto-updated by Modeladmin",
                        max_length=10,
                        verbose_name="Locale created",
                    ),
                ),
                (
                    "locale_modified",
                    models.CharField(
                        blank=True,
                        default="",
                        help_text="Auto-updated by Modeladmin",
                        max_length=10,
                        verbose_name="Locale modified",
                    ),
                ),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "consent_model",
                    models.CharField(blank=True, default="", max_length=50),
                ),
                (
                    "consent_version",
                    models.CharField(blank=True, default="", max_length=10),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=django.utils.timezone.now,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default=edc_crf.model_mixins.crf_status_model_mixin.get_crf_status_default,
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        default="",
                        help_text="for example, why some data is still pending",
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "a01",
                    models.CharField(
                        choices=[
                            ("strongly_disagree", "Strongly disagree"),
                            ("disagree", "disagree"),
                            ("neutral", "Neutral"),
                            ("agree", "Agree"),
                            ("strongly_agree", "Strongly agree"),
                        ],
                        help_text="for example: when and how to take or use a treatment",
                        max_length=25,
                        verbose_name="I understood the treatment process in this trial",
                    ),
                ),
                (
                    "a02",
                    models.CharField(
                        choices=[
                            ("strongly_disagree", "Strongly disagree"),
                            ("disagree", "disagree"),
                            ("neutral", "Neutral"),
                            ("agree", "Agree"),
                            ("strongly_agree", "Strongly agree"),
                        ],
                        help_text="for example: visits and procedures, time commitment, who to contact with questions",
                        max_length=25,
                        verbose_name="The information given to me before I joined the trial was everything I wanted to know",
                    ),
                ),
                (
                    "a03",
                    models.CharField(
                        choices=[
                            ("strongly_disagree", "Strongly disagree"),
                            ("disagree", "disagree"),
                            ("neutral", "Neutral"),
                            ("agree", "Agree"),
                            ("strongly_agree", "Strongly agree"),
                        ],
                        help_text="for example: visits and procedures, time commitment, who to contact with questions",
                        max_length=25,
                        verbose_name="The information given to me before I joined the trial was easy for me to understand",
                    ),
                ),
                (
                    "a04",
                    models.CharField(
                        choices=[
                            ("strongly_disagree", "Strongly disagree"),
                            ("disagree", "disagree"),
                            ("neutral", "Neutral"),
                            ("agree", "Agree"),
                            ("strongly_agree", "Strongly agree"),
                        ],
                        max_length=25,
                        verbose_name="I felt comfortable that I could ask any questions before I joined the trial",
                    ),
                ),
                (
                    "b01",
                    models.CharField(
                        choices=[
                            ("strongly_disagree", "Strongly disagree"),
                            ("disagree", "disagree"),
                            ("neutral", "Neutral"),
                            ("agree", "Agree"),
                            ("strongly_agree", "Strongly agree"),
                        ],
                        help_text="for example: comfort and privacy of treatment area, waiting area, parking, ease of access to the site",
                        max_length=25,
                        verbose_name="Overall I was satisfied with the trial site",
                    ),
                ),
                (
                    "b02",
                    models.CharField(
                        choices=[
                            ("strongly_disagree", "Strongly disagree"),
                            ("disagree", "disagree"),
                            ("neutral", "Neutral"),
                            ("agree", "Agree"),
                            ("strongly_agree", "Strongly agree"),
                        ],
                        max_length=25,
                        verbose_name="My trial visits were well organized",
                    ),
                ),
                (
                    "b03",
                    models.CharField(
                        choices=[
                            ("strongly_disagree", "Strongly disagree"),
                            ("disagree", "disagree"),
                            ("neutral", "Neutral"),
                            ("agree", "Agree"),
                            ("strongly_agree", "Strongly agree"),
                        ],
                        max_length=25,
                        verbose_name="My trial visits were scheduled at a convenient time for me",
                    ),
                ),
                (
                    "b04",
                    models.CharField(
                        choices=[
                            ("strongly_disagree", "Strongly disagree"),
                            ("disagree", "disagree"),
                            ("neutral", "Neutral"),
                            ("agree", "Agree"),
                            ("strongly_agree", "Strongly agree"),
                        ],
                        max_length=25,
                        verbose_name="The staff treated me with respect",
                    ),
                ),
                (
                    "b05",
                    models.CharField(
                        choices=[
                            ("strongly_disagree", "Strongly disagree"),
                            ("disagree", "disagree"),
                            ("neutral", "Neutral"),
                            ("agree", "Agree"),
                            ("strongly_agree", "Strongly agree"),
                        ],
                        max_length=25,
                        verbose_name="I felt comfortable that I could ask questions during the trial",
                    ),
                ),
                (
                    "b06",
                    models.CharField(
                        choices=[
                            ("strongly_disagree", "Strongly disagree"),
                            ("disagree", "disagree"),
                            ("neutral", "Neutral"),
                            ("agree", "Agree"),
                            ("strongly_agree", "Strongly agree"),
                        ],
                        max_length=25,
                        verbose_name="I was satisfied with the answers I have received to my questions during the trial",
                    ),
                ),
                (
                    "b07",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="for example: in person visits, questionnaires, forms",
                        max_length=25,
                        verbose_name="The time taken to collect data was acceptable to me",
                    ),
                ),
                (
                    "b08",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="for example: household chores, work commitments, eating",
                        max_length=25,
                        verbose_name="The impact the trial has had on my daily activities is acceptable",
                    ),
                ),
                (
                    "b09",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="for example: in person, online questionnaire, diary, wearable sensors, monitoring machines, technology",
                        max_length=25,
                        verbose_name="The way in which trial data is being collected is acceptable to me",
                    ),
                ),
                (
                    "b10",
                    models.CharField(
                        choices=[
                            ("strongly_disagree", "Strongly disagree"),
                            ("disagree", "disagree"),
                            ("neutral", "Neutral"),
                            ("agree", "Agree"),
                            ("strongly_agree", "Strongly agree"),
                        ],
                        help_text="for example: blood tests, scans etc.",
                        max_length=25,
                        verbose_name="Optional: I am being kept informed of the results of my medical tests done during the trial, including during screening",
                    ),
                ),
                (
                    "c01",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        verbose_name="I was informed when I had completed the trial",
                    ),
                ),
                (
                    "c02",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        verbose_name="I was informed of any future opportunities to access the overall trial results if I wanted to",
                    ),
                ),
                (
                    "c03",
                    models.CharField(
                        choices=[
                            ("very_difficult", "Very difficult"),
                            ("difficult", "Difficult"),
                            ("neutral", "Neutral"),
                            ("easy", "Easy"),
                            ("very_easy", "Very easy"),
                        ],
                        max_length=25,
                        verbose_name="How easy was it to take the medication?",
                    ),
                ),
                (
                    "c04",
                    models.CharField(
                        choices=[
                            ("not_at_all", "Not at all"),
                            ("slight", "Slight"),
                            ("moderate", "Moderate"),
                            ("extreme", "Extreme"),
                            ("severe", "Severe"),
                        ],
                        max_length=25,
                        verbose_name="Did you experience any burden or side effects?",
                    ),
                ),
                (
                    "c05",
                    models.CharField(
                        choices=[
                            ("not_at_all", "Not at all"),
                            ("slightly", "Slightly"),
                            ("moderately", "Moderately"),
                            ("highly", "Highly"),
                            ("very_highly", "Very highly"),
                        ],
                        max_length=25,
                        verbose_name="How acceptable was it to take the drug?",
                    ),
                ),
                (
                    "c06",
                    models.CharField(
                        choices=[
                            ("very_difficult", "Very difficult"),
                            ("difficult", "Difficult"),
                            ("neutral", "Neutral"),
                            ("easy", "Easy"),
                            ("very_easy", "Very easy"),
                        ],
                        max_length=25,
                        verbose_name="How easy was it to fit the medication into your routine?",
                    ),
                ),
                (
                    "c07",
                    models.CharField(
                        choices=[
                            ("not_at_all", "Not at all"),
                            ("slight", "Slight"),
                            ("moderate", "Moderate"),
                            ("extreme", "Extreme"),
                            ("severe", "Severe"),
                        ],
                        max_length=25,
                        verbose_name="How burdensome was taking part in the trial?",
                    ),
                ),
                (
                    "c08",
                    models.CharField(
                        choices=[
                            ("strongly_disagree", "Strongly disagree"),
                            ("disagree", "disagree"),
                            ("neutral", "Neutral"),
                            ("agree", "Agree"),
                            ("strongly_agree", "Strongly agree"),
                        ],
                        help_text="for example: future treatment, follow-up contact details",
                        max_length=25,
                        verbose_name="Overall, I was satisfied with the information I received about future support after the trial",
                    ),
                ),
                (
                    "c09",
                    models.CharField(
                        choices=[
                            ("strongly_disagree", "Strongly disagree"),
                            ("disagree", "disagree"),
                            ("neutral", "Neutral"),
                            ("agree", "Agree"),
                            ("strongly_agree", "Strongly agree"),
                        ],
                        max_length=25,
                        verbose_name="Overall, I was satisfied with my trial experience",
                    ),
                ),
                (
                    "c10",
                    models.CharField(
                        choices=[
                            ("much_less_expected", "Much less than expected"),
                            ("somewhat_less_expected", "Somewhat less than expected"),
                            ("same_as_expected", "Same as expected"),
                            ("somewhat_more_expected", "Somewhat more than expected"),
                            ("much_more_expected", "Much more than expected"),
                        ],
                        max_length=25,
                        verbose_name="Compared to when the trial started, the overall commitment required was similar to what I expected",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="meta_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "Feedback Questionnaire (SPFQ)",
                "verbose_name_plural": "Feedback Questionnaires (SPFQ)",
                "abstract": False,
                "default_permissions": (
                    "add",
                    "change",
                    "delete",
                    "view",
                    "export",
                    "import",
                ),
                "default_manager_name": "objects",
                "indexes": [
                    models.Index(
                        fields=["subject_visit", "site"],
                        name="meta_subjec_subject_7ecbde_idx",
                    ),
                    models.Index(
                        fields=["subject_visit", "report_datetime"],
                        name="meta_subjec_subject_f51f0f_idx",
                    ),
                ],
            },
            managers=[
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
                ("on_site", edc_visit_tracking.managers.CrfCurrentSiteManager()),
            ],
        ),
    ]
