# Generated by Django 5.2.7 on 2025-10-09 21:31

import _socket
import django.core.validators
import django.db.models.deletion
import django.utils.timezone
import django_audit_fields.fields.hostname_modification_field
import django_audit_fields.fields.userfield
import django_audit_fields.fields.uuid_auto_field
import django_revision.revision_field
import edc_crf.model_mixins.crf_status_model_mixin
import edc_model.models.fields.other_charfield
import edc_model.validators.date
import edc_protocol.validators
import edc_visit_tracking.managers
import simple_history.models
import uuid
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        (
            "meta_lists",
            "0020_alter_abnormalfootappearanceobservations_extra_value_and_more",
        ),
        ("meta_subject", "0234_remove_spfq_site_remove_spfq_subject_visit_and_more"),
        ("sites", "0002_alter_domain_unique"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.AddField(
            model_name="glucosefbg",
            name="endpoint_today",
            field=models.CharField(
                choices=[
                    ("Yes", "Yes"),
                    ("PENDING", "No. A repeat FBG will be scheduled"),
                    ("No", "No"),
                    ("N/A", "Not applicable"),
                ],
                default="N/A",
                help_text="Response is applicable if reporting after 24/11/2023 and both the FBG and OGTT were performed",
                max_length=25,
                verbose_name="Has the participant reached a study endpoint today?",
            ),
        ),
        migrations.AddField(
            model_name="historicalglucosefbg",
            name="endpoint_today",
            field=models.CharField(
                choices=[
                    ("Yes", "Yes"),
                    ("PENDING", "No. A repeat FBG will be scheduled"),
                    ("No", "No"),
                    ("N/A", "Not applicable"),
                ],
                default="N/A",
                help_text="Response is applicable if reporting after 24/11/2023 and both the FBG and OGTT were performed",
                max_length=25,
                verbose_name="Has the participant reached a study endpoint today?",
            ),
        ),
        migrations.CreateModel(
            name="HistoricalHivExitReview",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        default="",
                        editable=False,
                        help_text="System field. From git repository (tag:branch:commit), project metadata, project toml, project VERSION, or settings.",
                        max_length=75,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(blank=True, default=django.utils.timezone.now),
                ),
                (
                    "modified",
                    models.DateTimeField(blank=True, default=django.utils.timezone.now),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        default="",
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        default="",
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                        verbose_name="Hostname created",
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        default="",
                        help_text="System field. (modified on every save)",
                        max_length=50,
                        verbose_name="Hostname modified",
                    ),
                ),
                (
                    "device_created",
                    models.CharField(
                        blank=True,
                        default="",
                        max_length=10,
                        verbose_name="Device created",
                    ),
                ),
                (
                    "device_modified",
                    models.CharField(
                        blank=True,
                        default="",
                        max_length=10,
                        verbose_name="Device modified",
                    ),
                ),
                (
                    "locale_created",
                    models.CharField(
                        blank=True,
                        default="",
                        help_text="Auto-updated by Modeladmin",
                        max_length=10,
                        verbose_name="Locale created",
                    ),
                ),
                (
                    "locale_modified",
                    models.CharField(
                        blank=True,
                        default="",
                        help_text="Auto-updated by Modeladmin",
                        max_length=10,
                        verbose_name="Locale modified",
                    ),
                ),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "consent_model",
                    models.CharField(blank=True, default="", max_length=50),
                ),
                (
                    "consent_version",
                    models.CharField(blank=True, default="", max_length=10),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=django.utils.timezone.now,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default=edc_crf.model_mixins.crf_status_model_mixin.get_crf_status_default,
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        default="",
                        help_text="for example, why some data is still pending",
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "viral_load",
                    models.IntegerField(
                        blank=True,
                        help_text="copies/mL",
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(999999),
                        ],
                        verbose_name="Last viral load",
                    ),
                ),
                (
                    "viral_load_date",
                    models.DateField(
                        blank=True, null=True, verbose_name="Date of last viral load"
                    ),
                ),
                (
                    "cd4",
                    models.IntegerField(
                        blank=True,
                        help_text="cells/mm<sup>3</sup>",
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(3000),
                        ],
                        verbose_name="Last CD4",
                    ),
                ),
                (
                    "cd4_date",
                    models.DateField(
                        blank=True, null=True, verbose_name="Date of last CD4"
                    ),
                ),
                (
                    "other_current_arv_regimen",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "current_arv_regimen_start_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        verbose_name="When did the patient start this current antiretroviral therapy regimen?",
                    ),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "current_arv_regimen",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="meta_lists.arvregimens",
                        verbose_name="Which antiretroviral therapy regimen is the patient currently on?",
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="meta_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical HIV Exit Review",
                "verbose_name_plural": "historical HIV Exit Review",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HivExitReview",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        default="",
                        editable=False,
                        help_text="System field. From git repository (tag:branch:commit), project metadata, project toml, project VERSION, or settings.",
                        max_length=75,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(blank=True, default=django.utils.timezone.now),
                ),
                (
                    "modified",
                    models.DateTimeField(blank=True, default=django.utils.timezone.now),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        default="",
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        default="",
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                        verbose_name="Hostname created",
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        default="",
                        help_text="System field. (modified on every save)",
                        max_length=50,
                        verbose_name="Hostname modified",
                    ),
                ),
                (
                    "device_created",
                    models.CharField(
                        blank=True,
                        default="",
                        max_length=10,
                        verbose_name="Device created",
                    ),
                ),
                (
                    "device_modified",
                    models.CharField(
                        blank=True,
                        default="",
                        max_length=10,
                        verbose_name="Device modified",
                    ),
                ),
                (
                    "locale_created",
                    models.CharField(
                        blank=True,
                        default="",
                        help_text="Auto-updated by Modeladmin",
                        max_length=10,
                        verbose_name="Locale created",
                    ),
                ),
                (
                    "locale_modified",
                    models.CharField(
                        blank=True,
                        default="",
                        help_text="Auto-updated by Modeladmin",
                        max_length=10,
                        verbose_name="Locale modified",
                    ),
                ),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "consent_model",
                    models.CharField(blank=True, default="", max_length=50),
                ),
                (
                    "consent_version",
                    models.CharField(blank=True, default="", max_length=10),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=django.utils.timezone.now,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default=edc_crf.model_mixins.crf_status_model_mixin.get_crf_status_default,
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        default="",
                        help_text="for example, why some data is still pending",
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "viral_load",
                    models.IntegerField(
                        blank=True,
                        help_text="copies/mL",
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(999999),
                        ],
                        verbose_name="Last viral load",
                    ),
                ),
                (
                    "viral_load_date",
                    models.DateField(
                        blank=True, null=True, verbose_name="Date of last viral load"
                    ),
                ),
                (
                    "cd4",
                    models.IntegerField(
                        blank=True,
                        help_text="cells/mm<sup>3</sup>",
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(3000),
                        ],
                        verbose_name="Last CD4",
                    ),
                ),
                (
                    "cd4_date",
                    models.DateField(
                        blank=True, null=True, verbose_name="Date of last CD4"
                    ),
                ),
                (
                    "other_current_arv_regimen",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "current_arv_regimen_start_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        verbose_name="When did the patient start this current antiretroviral therapy regimen?",
                    ),
                ),
                (
                    "current_arv_regimen",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="last_arv_regimen",
                        to="meta_lists.arvregimens",
                        verbose_name="Which antiretroviral therapy regimen is the patient currently on?",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="meta_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "HIV Exit Review",
                "verbose_name_plural": "HIV Exit Review",
                "abstract": False,
                "default_permissions": (
                    "add",
                    "change",
                    "delete",
                    "view",
                    "export",
                    "import",
                ),
                "default_manager_name": "objects",
                "indexes": [
                    models.Index(
                        fields=["subject_visit", "site"],
                        name="meta_subjec_subject_d9ce05_idx",
                    ),
                    models.Index(
                        fields=["subject_visit", "report_datetime"],
                        name="meta_subjec_subject_ae7af9_idx",
                    ),
                ],
            },
            managers=[
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
                ("on_site", edc_visit_tracking.managers.CrfCurrentSiteManager()),
            ],
        ),
    ]
