"Hyper-V virtual disk driver"

import psrp

from .base import HyperVirtualDriver


class HyperVirtualDiskDriver(HyperVirtualDriver):
    """Driver for managing the Hyper-V virtual disk"""

    path: str

    def __init__(self, conn: psrp.ConnectionInfo, path: str) -> None:
        super().__init__(conn)
        self.path = path

    async def resize(self, required_size: int) -> int:
        """Resize the virtual disk"""
        async with self.get_ps() as ps:
            ps.add_command("Resize-VHD")
            ps.add_parameters(Path=self.path, SizeBytes=required_size)
            ps.add_statement()
            ps.add_command("Get-VHD")
            ps.add_parameter("Path", self.path)
            ps.add_command("Select")
            ps.add_parameter("Property", "Size")
            result = await self.exec_ps(ps)
        return result[0].Size
