"Hyper-V snapshot driver"

import psrp

from .base import HyperVirtualDriver


class HyperVirtualSnapshotDriver(HyperVirtualDriver):
    """Driver for managing the Hyper-V snapshot"""

    def __init__(self, conn: psrp.ConnectionInfo, snapshot_id: str) -> None:
        super().__init__(conn)
        self.id = snapshot_id

    async def apply(self) -> None:
        """Apply the snapshot"""
        async with self.get_ps() as ps:
            ps.add_command("Get-VMSnapshot")
            ps.add_parameter("Id", self.id)
            ps.add_command("Restore-VMSnapshot")
            ps.add_parameter("Confirm", False)
            await self.exec_ps(ps)

    async def destroy(self) -> None:
        """Destroy the snapshot"""
        async with self.get_ps() as ps:
            ps.add_command("Get-VMSnapshot")
            ps.add_parameter("Id", self.id)
            ps.add_command("Remove-VMSnapshot")
            ps.add_parameter("Confirm", False)
            await self.exec_ps(ps)
