"KVM virtual disk driver"

import libvirt

from .base import to_async


class KernelVirtualDiskDriver:
    """Driver for managing the KVM virtual disk"""

    domain: libvirt.virDomain
    volume: libvirt.virStorageVol

    def __init__(self, domain: libvirt.virDomain, volume: libvirt.virStorageVol) -> None:
        self.domain = domain
        self.volume = volume

    async def resize(self, required_size: int) -> int:
        """Resize the virtual disk"""
        domain_state = await to_async(self.domain.state)
        if domain_state[0] == libvirt.VIR_DOMAIN_RUNNING:
            await to_async(lambda: self.domain.blockResize(self.volume.path(), required_size))
        else:
            await to_async(self.volume.resize, required_size, libvirt.VIR_STORAGE_VOL_RESIZE_SHRINK)

        return (await to_async(self.volume.info))[1]
