"KVM snapshot driver"

import libvirt

from .base import to_async


class KernelVirtualSnapshotDriver:
    """Driver for managing the KVM snapshot"""

    def __init__(self, domain: libvirt.virDomain, snapshot: libvirt.virDomainSnapshot) -> None:
        self.domain = domain
        self.snapshot = snapshot
        self.id = snapshot.getName()

    async def apply(self) -> None:
        """Apply the snapshot"""
        await to_async(self.domain.revertToSnapshot, self.snapshot)

    async def destroy(self) -> None:
        """Destroy the snapshot"""
        await to_async(self.snapshot.delete)
