---
icon: material/code-braces-box
---

# :material-code-braces-box: API Reference

This section contains the reference detailing the functions and modules
available in EasyDiffraction:

- [core](core.md) – Contains core utilities and foundational objects used across
  the package.
- [crystallography](crystallography.md) – Handles crystallographic calculations,
  space groups, and symmetry operations.
- [utils](utils.md) – Miscellaneous utility functions for formatting,
  decorators, and general helpers.
- [plotting](plotting.md) – Tools for visualizing data and fitting results.
- [project](project.md) – Defines the project and manages its state.
- [sample_models](sample_models.md) – Defines sample models, such as
  crystallographic structures, and manages their properties.
- [experiments](experiments.md) – Manages experimental setups and instrument
  parameters, as well as the associated diffraction data.
- [analysis](analysis.md) – Provides tools for analyzing diffraction data,
  including fitting and minimization.
- [summary](summary.md) – Provides a summary of the project.
