# Glossary

Before guiding you through the use of EasyDiffraction, we define some common
terms and abbreviations used throughout the documentation and tutorials.

## Dictionary Type Labels

The following labels are used to identify different types of CIF dictionaries:

- [coreCIF][1]{:.label-cif} – Core CIF dictionary by the
  [IUCr](https://www.iucr.org).
- [pdCIF][2]{:.label-cif} – Powder CIF dictionary by the
  [IUCr](https://www.iucr.org).
- [easydiffractionCIF][0]{:.label-cif} – Custom CIF dictionary developed for
  EasyDiffraction.

For more information about CIF, see the [Data Format](data-format.md) section.

## Experiment Type Labels

EasyDiffraction supports a variety of experiment types, each with its own set of
parameters. The following labels identify the supported experiment types:

### Neutron Diffraction

- [pd-neut-cwl][0]{:.label-experiment} – Powder neutron diffraction with
  constant wavelength.
- [pd-neut-tof][0]{:.label-experiment} – Powder neutron diffraction with
  time-of-flight.
- [sc-neut-cwl][0]{:.label-experiment} – Single-crystal neutron diffraction with
  constant wavelength.

### X-ray Diffraction

- [pd-xray][0]{:.label-experiment} Powder X-ray diffraction.

<!-- prettier-ignore-start -->
[0]: #
[1]: https://www.iucr.org/resources/cif/dictionaries/browse/cif_core
[2]: https://www.iucr.org/resources/cif/dictionaries/browse/cif_pd
[3]: #experiment-type-labels
<!-- prettier-ignore-end -->
