import sgqlc.types
import sgqlc.types.datetime
import sgqlc.types.relay


nionic_schema = sgqlc.types.Schema()


# Unexport Node/PageInfo, let schema re-declare them
nionic_schema -= sgqlc.types.relay.Node
nionic_schema -= sgqlc.types.relay.PageInfo



########################################################################
# Scalars and Enumerations
########################################################################
class AccessTokenType(sgqlc.types.Enum):
    __schema__ = nionic_schema
    __choices__ = ('MACHINE', 'USER')


class AccountChargesOrderBy(sgqlc.types.Enum):
    __schema__ = nionic_schema
    __choices__ = ('ACCOUNT_STATEMENT_ID_ASC', 'ACCOUNT_STATEMENT_ID_DESC', 'CATEGORY_ASC', 'CATEGORY_DESC', 'CREATED_AT_ASC', 'CREATED_AT_DESC', 'DELETED_AT_ASC', 'DELETED_AT_DESC', 'ID_ASC', 'ID_DESC', 'INTERVAL_END_ASC', 'INTERVAL_END_DESC', 'INTERVAL_START_ASC', 'INTERVAL_START_DESC', 'LABEL_ASC', 'LABEL_DESC', 'LINE_NUMBER_ASC', 'LINE_NUMBER_DESC', 'NATURAL', 'NORMALIZED_VALUE_ASC', 'NORMALIZED_VALUE_DESC', 'OVERRIDE_AT_ASC', 'OVERRIDE_AT_DESC', 'OVERRIDE_LABEL_ASC', 'OVERRIDE_LABEL_DESC', 'OVERRIDE_STATEMENT_MONTH_ASC', 'OVERRIDE_STATEMENT_MONTH_DESC', 'OVERRIDE_STATEMENT_YEAR_ASC', 'OVERRIDE_STATEMENT_YEAR_DESC', 'OVERRIDE_VALUE_ASC', 'OVERRIDE_VALUE_DESC', 'PRIMARY_KEY_ASC', 'PRIMARY_KEY_DESC', 'STATEMENT_DATE_ASC', 'STATEMENT_DATE_DESC', 'UPDATED_AT_ASC', 'UPDATED_AT_DESC', 'VALUE_ASC', 'VALUE_DESC')


class AccountStatementHistoriesOrderBy(sgqlc.types.Enum):
    __schema__ = nionic_schema
    __choices__ = ('ACCOUNT_STATEMENT_ID_ASC', 'ACCOUNT_STATEMENT_ID_DESC', 'CREATED_AT_ASC', 'CREATED_AT_DESC', 'DESCRIPTION_ASC', 'DESCRIPTION_DESC', 'NATURAL')


class AccountStatementPdfsOrderBy(sgqlc.types.Enum):
    __schema__ = nionic_schema
    __choices__ = ('ACCOUNT_STATEMENT_ID_ASC', 'ACCOUNT_STATEMENT_ID_DESC', 'CREATED_AT_ASC', 'CREATED_AT_DESC', 'DELETED_AT_ASC', 'DELETED_AT_DESC', 'FILE_KEY_ASC', 'FILE_KEY_DESC', 'ID_ASC', 'ID_DESC', 'NATURAL', 'PATH_ASC', 'PATH_DESC', 'PRIMARY_KEY_ASC', 'PRIMARY_KEY_DESC', 'UPDATED_AT_ASC', 'UPDATED_AT_DESC')


class AccountStatementsOrderBy(sgqlc.types.Enum):
    __schema__ = nionic_schema
    __choices__ = ('CREATED_AT_ASC', 'CREATED_AT_DESC', 'CURRENCY_CODE_ASC', 'CURRENCY_CODE_DESC', 'DELETED_AT_ASC', 'DELETED_AT_DESC', 'ID_ASC', 'ID_DESC', 'INTEGRATION_ASC', 'INTEGRATION_DESC', 'INTEGRATION_KEY_ASC', 'INTEGRATION_KEY_DESC', 'INTERVAL_END_ASC', 'INTERVAL_END_DESC', 'INTERVAL_START_ASC', 'INTERVAL_START_DESC', 'IS_VALIDATED_ASC', 'IS_VALIDATED_DESC', 'METADATA_ASC', 'METADATA_DESC', 'NATURAL', 'NORMALIZED_CURRENCY_CODE_ASC', 'NORMALIZED_CURRENCY_CODE_DESC', 'OVERRIDE_AT_ASC', 'OVERRIDE_AT_DESC', 'OVERRIDE_CURRENCY_CODE_ASC', 'OVERRIDE_CURRENCY_CODE_DESC', 'PRIMARY_KEY_ASC', 'PRIMARY_KEY_DESC', 'STATEMENT_MONTH_ASC', 'STATEMENT_MONTH_DESC', 'STATEMENT_YEAR_ASC', 'STATEMENT_YEAR_DESC', 'UPDATED_AT_ASC', 'UPDATED_AT_DESC', 'UTILITY_ACCOUNT_ID_ASC', 'UTILITY_ACCOUNT_ID_DESC', 'UTILITY_METER_STATEMENTS_AVERAGE_ACCOUNT_LABEL_ASC', 'UTILITY_METER_STATEMENTS_AVERAGE_ACCOUNT_LABEL_DESC', 'UTILITY_METER_STATEMENTS_AVERAGE_ACCOUNT_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENTS_AVERAGE_ACCOUNT_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENTS_AVERAGE_BILL_ARRIVAL_DATE_ASC', 'UTILITY_METER_STATEMENTS_AVERAGE_BILL_ARRIVAL_DATE_DESC', 'UTILITY_METER_STATEMENTS_AVERAGE_CURRENCY_CODE_ASC', 'UTILITY_METER_STATEMENTS_AVERAGE_CURRENCY_CODE_DESC', 'UTILITY_METER_STATEMENTS_AVERAGE_DAYS_IN_BILL_ASC', 'UTILITY_METER_STATEMENTS_AVERAGE_DAYS_IN_BILL_DESC', 'UTILITY_METER_STATEMENTS_AVERAGE_DEMAND_UNITS_ASC', 'UTILITY_METER_STATEMENTS_AVERAGE_DEMAND_UNITS_DESC', 'UTILITY_METER_STATEMENTS_AVERAGE_END_DATE_ASC', 'UTILITY_METER_STATEMENTS_AVERAGE_END_DATE_DESC', 'UTILITY_METER_STATEMENTS_AVERAGE_EXCLUDE_USAGE_ASC', 'UTILITY_METER_STATEMENTS_AVERAGE_EXCLUDE_USAGE_DESC', 'UTILITY_METER_STATEMENTS_AVERAGE_FACILITY_ID_ASC', 'UTILITY_METER_STATEMENTS_AVERAGE_FACILITY_ID_DESC', 'UTILITY_METER_STATEMENTS_AVERAGE_IS_VALIDATED_ASC', 'UTILITY_METER_STATEMENTS_AVERAGE_IS_VALIDATED_DESC', 'UTILITY_METER_STATEMENTS_AVERAGE_METER_END_DATE_SET_ASC', 'UTILITY_METER_STATEMENTS_AVERAGE_METER_END_DATE_SET_DESC', 'UTILITY_METER_STATEMENTS_AVERAGE_METER_LABEL_ASC', 'UTILITY_METER_STATEMENTS_AVERAGE_METER_LABEL_DESC', 'UTILITY_METER_STATEMENTS_AVERAGE_METER_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENTS_AVERAGE_METER_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENTS_AVERAGE_PROVIDER_ASC', 'UTILITY_METER_STATEMENTS_AVERAGE_PROVIDER_DESC', 'UTILITY_METER_STATEMENTS_AVERAGE_SERVICE_TYPE_ASC', 'UTILITY_METER_STATEMENTS_AVERAGE_SERVICE_TYPE_DESC', 'UTILITY_METER_STATEMENTS_AVERAGE_START_DATE_ASC', 'UTILITY_METER_STATEMENTS_AVERAGE_START_DATE_DESC', 'UTILITY_METER_STATEMENTS_AVERAGE_STATEMENT_MONTH_ASC', 'UTILITY_METER_STATEMENTS_AVERAGE_STATEMENT_MONTH_DESC', 'UTILITY_METER_STATEMENTS_AVERAGE_STATEMENT_YEAR_ASC', 'UTILITY_METER_STATEMENTS_AVERAGE_STATEMENT_YEAR_DESC', 'UTILITY_METER_STATEMENTS_AVERAGE_USAGE_UNITS_ASC', 'UTILITY_METER_STATEMENTS_AVERAGE_USAGE_UNITS_DESC', 'UTILITY_METER_STATEMENTS_AVERAGE_UTILITY_ACCOUNT_ID_ASC', 'UTILITY_METER_STATEMENTS_AVERAGE_UTILITY_ACCOUNT_ID_DESC', 'UTILITY_METER_STATEMENTS_AVERAGE_UTILITY_METER_ID_ASC', 'UTILITY_METER_STATEMENTS_AVERAGE_UTILITY_METER_ID_DESC', 'UTILITY_METER_STATEMENTS_COUNT_ASC', 'UTILITY_METER_STATEMENTS_COUNT_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_ACCOUNT_LABEL_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_ACCOUNT_LABEL_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_ACCOUNT_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_ACCOUNT_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_BILL_ARRIVAL_DATE_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_BILL_ARRIVAL_DATE_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_ACCOUNT_LABEL_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_ACCOUNT_LABEL_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_ACCOUNT_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_ACCOUNT_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_BILL_ARRIVAL_DATE_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_BILL_ARRIVAL_DATE_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_CURRENCY_CODE_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_CURRENCY_CODE_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_DAYS_IN_BILL_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_DAYS_IN_BILL_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_DEMAND_UNITS_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_DEMAND_UNITS_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_END_DATE_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_END_DATE_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_EXCLUDE_USAGE_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_EXCLUDE_USAGE_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_FACILITY_ID_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_FACILITY_ID_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_IS_VALIDATED_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_IS_VALIDATED_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_METER_END_DATE_SET_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_METER_END_DATE_SET_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_METER_LABEL_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_METER_LABEL_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_METER_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_METER_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_PROVIDER_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_PROVIDER_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_SERVICE_TYPE_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_SERVICE_TYPE_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_START_DATE_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_START_DATE_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_STATEMENT_MONTH_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_STATEMENT_MONTH_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_STATEMENT_YEAR_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_STATEMENT_YEAR_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_USAGE_UNITS_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_USAGE_UNITS_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_UTILITY_ACCOUNT_ID_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_UTILITY_ACCOUNT_ID_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_UTILITY_METER_ID_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_UTILITY_METER_ID_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_CURRENCY_CODE_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_CURRENCY_CODE_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_DAYS_IN_BILL_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_DAYS_IN_BILL_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_DEMAND_UNITS_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_DEMAND_UNITS_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_END_DATE_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_END_DATE_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_EXCLUDE_USAGE_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_EXCLUDE_USAGE_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_FACILITY_ID_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_FACILITY_ID_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_IS_VALIDATED_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_IS_VALIDATED_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_METER_END_DATE_SET_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_METER_END_DATE_SET_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_METER_LABEL_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_METER_LABEL_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_METER_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_METER_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_PROVIDER_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_PROVIDER_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_SERVICE_TYPE_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_SERVICE_TYPE_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_START_DATE_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_START_DATE_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_STATEMENT_MONTH_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_STATEMENT_MONTH_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_STATEMENT_YEAR_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_STATEMENT_YEAR_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_USAGE_UNITS_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_USAGE_UNITS_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_UTILITY_ACCOUNT_ID_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_UTILITY_ACCOUNT_ID_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_UTILITY_METER_ID_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_UTILITY_METER_ID_DESC', 'UTILITY_METER_STATEMENTS_MAX_ACCOUNT_LABEL_ASC', 'UTILITY_METER_STATEMENTS_MAX_ACCOUNT_LABEL_DESC', 'UTILITY_METER_STATEMENTS_MAX_ACCOUNT_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENTS_MAX_ACCOUNT_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENTS_MAX_BILL_ARRIVAL_DATE_ASC', 'UTILITY_METER_STATEMENTS_MAX_BILL_ARRIVAL_DATE_DESC', 'UTILITY_METER_STATEMENTS_MAX_CURRENCY_CODE_ASC', 'UTILITY_METER_STATEMENTS_MAX_CURRENCY_CODE_DESC', 'UTILITY_METER_STATEMENTS_MAX_DAYS_IN_BILL_ASC', 'UTILITY_METER_STATEMENTS_MAX_DAYS_IN_BILL_DESC', 'UTILITY_METER_STATEMENTS_MAX_DEMAND_UNITS_ASC', 'UTILITY_METER_STATEMENTS_MAX_DEMAND_UNITS_DESC', 'UTILITY_METER_STATEMENTS_MAX_END_DATE_ASC', 'UTILITY_METER_STATEMENTS_MAX_END_DATE_DESC', 'UTILITY_METER_STATEMENTS_MAX_EXCLUDE_USAGE_ASC', 'UTILITY_METER_STATEMENTS_MAX_EXCLUDE_USAGE_DESC', 'UTILITY_METER_STATEMENTS_MAX_FACILITY_ID_ASC', 'UTILITY_METER_STATEMENTS_MAX_FACILITY_ID_DESC', 'UTILITY_METER_STATEMENTS_MAX_IS_VALIDATED_ASC', 'UTILITY_METER_STATEMENTS_MAX_IS_VALIDATED_DESC', 'UTILITY_METER_STATEMENTS_MAX_METER_END_DATE_SET_ASC', 'UTILITY_METER_STATEMENTS_MAX_METER_END_DATE_SET_DESC', 'UTILITY_METER_STATEMENTS_MAX_METER_LABEL_ASC', 'UTILITY_METER_STATEMENTS_MAX_METER_LABEL_DESC', 'UTILITY_METER_STATEMENTS_MAX_METER_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENTS_MAX_METER_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENTS_MAX_PROVIDER_ASC', 'UTILITY_METER_STATEMENTS_MAX_PROVIDER_DESC', 'UTILITY_METER_STATEMENTS_MAX_SERVICE_TYPE_ASC', 'UTILITY_METER_STATEMENTS_MAX_SERVICE_TYPE_DESC', 'UTILITY_METER_STATEMENTS_MAX_START_DATE_ASC', 'UTILITY_METER_STATEMENTS_MAX_START_DATE_DESC', 'UTILITY_METER_STATEMENTS_MAX_STATEMENT_MONTH_ASC', 'UTILITY_METER_STATEMENTS_MAX_STATEMENT_MONTH_DESC', 'UTILITY_METER_STATEMENTS_MAX_STATEMENT_YEAR_ASC', 'UTILITY_METER_STATEMENTS_MAX_STATEMENT_YEAR_DESC', 'UTILITY_METER_STATEMENTS_MAX_USAGE_UNITS_ASC', 'UTILITY_METER_STATEMENTS_MAX_USAGE_UNITS_DESC', 'UTILITY_METER_STATEMENTS_MAX_UTILITY_ACCOUNT_ID_ASC', 'UTILITY_METER_STATEMENTS_MAX_UTILITY_ACCOUNT_ID_DESC', 'UTILITY_METER_STATEMENTS_MAX_UTILITY_METER_ID_ASC', 'UTILITY_METER_STATEMENTS_MAX_UTILITY_METER_ID_DESC', 'UTILITY_METER_STATEMENTS_MIN_ACCOUNT_LABEL_ASC', 'UTILITY_METER_STATEMENTS_MIN_ACCOUNT_LABEL_DESC', 'UTILITY_METER_STATEMENTS_MIN_ACCOUNT_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENTS_MIN_ACCOUNT_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENTS_MIN_BILL_ARRIVAL_DATE_ASC', 'UTILITY_METER_STATEMENTS_MIN_BILL_ARRIVAL_DATE_DESC', 'UTILITY_METER_STATEMENTS_MIN_CURRENCY_CODE_ASC', 'UTILITY_METER_STATEMENTS_MIN_CURRENCY_CODE_DESC', 'UTILITY_METER_STATEMENTS_MIN_DAYS_IN_BILL_ASC', 'UTILITY_METER_STATEMENTS_MIN_DAYS_IN_BILL_DESC', 'UTILITY_METER_STATEMENTS_MIN_DEMAND_UNITS_ASC', 'UTILITY_METER_STATEMENTS_MIN_DEMAND_UNITS_DESC', 'UTILITY_METER_STATEMENTS_MIN_END_DATE_ASC', 'UTILITY_METER_STATEMENTS_MIN_END_DATE_DESC', 'UTILITY_METER_STATEMENTS_MIN_EXCLUDE_USAGE_ASC', 'UTILITY_METER_STATEMENTS_MIN_EXCLUDE_USAGE_DESC', 'UTILITY_METER_STATEMENTS_MIN_FACILITY_ID_ASC', 'UTILITY_METER_STATEMENTS_MIN_FACILITY_ID_DESC', 'UTILITY_METER_STATEMENTS_MIN_IS_VALIDATED_ASC', 'UTILITY_METER_STATEMENTS_MIN_IS_VALIDATED_DESC', 'UTILITY_METER_STATEMENTS_MIN_METER_END_DATE_SET_ASC', 'UTILITY_METER_STATEMENTS_MIN_METER_END_DATE_SET_DESC', 'UTILITY_METER_STATEMENTS_MIN_METER_LABEL_ASC', 'UTILITY_METER_STATEMENTS_MIN_METER_LABEL_DESC', 'UTILITY_METER_STATEMENTS_MIN_METER_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENTS_MIN_METER_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENTS_MIN_PROVIDER_ASC', 'UTILITY_METER_STATEMENTS_MIN_PROVIDER_DESC', 'UTILITY_METER_STATEMENTS_MIN_SERVICE_TYPE_ASC', 'UTILITY_METER_STATEMENTS_MIN_SERVICE_TYPE_DESC', 'UTILITY_METER_STATEMENTS_MIN_START_DATE_ASC', 'UTILITY_METER_STATEMENTS_MIN_START_DATE_DESC', 'UTILITY_METER_STATEMENTS_MIN_STATEMENT_MONTH_ASC', 'UTILITY_METER_STATEMENTS_MIN_STATEMENT_MONTH_DESC', 'UTILITY_METER_STATEMENTS_MIN_STATEMENT_YEAR_ASC', 'UTILITY_METER_STATEMENTS_MIN_STATEMENT_YEAR_DESC', 'UTILITY_METER_STATEMENTS_MIN_USAGE_UNITS_ASC', 'UTILITY_METER_STATEMENTS_MIN_USAGE_UNITS_DESC', 'UTILITY_METER_STATEMENTS_MIN_UTILITY_ACCOUNT_ID_ASC', 'UTILITY_METER_STATEMENTS_MIN_UTILITY_ACCOUNT_ID_DESC', 'UTILITY_METER_STATEMENTS_MIN_UTILITY_METER_ID_ASC', 'UTILITY_METER_STATEMENTS_MIN_UTILITY_METER_ID_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_ACCOUNT_LABEL_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_ACCOUNT_LABEL_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_ACCOUNT_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_ACCOUNT_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_BILL_ARRIVAL_DATE_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_BILL_ARRIVAL_DATE_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_CURRENCY_CODE_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_CURRENCY_CODE_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_DAYS_IN_BILL_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_DAYS_IN_BILL_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_DEMAND_UNITS_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_DEMAND_UNITS_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_END_DATE_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_END_DATE_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_EXCLUDE_USAGE_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_EXCLUDE_USAGE_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_FACILITY_ID_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_FACILITY_ID_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_IS_VALIDATED_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_IS_VALIDATED_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_METER_END_DATE_SET_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_METER_END_DATE_SET_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_METER_LABEL_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_METER_LABEL_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_METER_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_METER_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_PROVIDER_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_PROVIDER_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_SERVICE_TYPE_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_SERVICE_TYPE_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_START_DATE_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_START_DATE_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_STATEMENT_MONTH_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_STATEMENT_MONTH_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_STATEMENT_YEAR_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_STATEMENT_YEAR_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_USAGE_UNITS_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_USAGE_UNITS_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_UTILITY_ACCOUNT_ID_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_UTILITY_ACCOUNT_ID_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_UTILITY_METER_ID_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_UTILITY_METER_ID_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_ACCOUNT_LABEL_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_ACCOUNT_LABEL_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_ACCOUNT_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_ACCOUNT_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_BILL_ARRIVAL_DATE_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_BILL_ARRIVAL_DATE_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_CURRENCY_CODE_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_CURRENCY_CODE_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_DAYS_IN_BILL_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_DAYS_IN_BILL_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_DEMAND_UNITS_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_DEMAND_UNITS_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_END_DATE_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_END_DATE_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_EXCLUDE_USAGE_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_EXCLUDE_USAGE_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_FACILITY_ID_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_FACILITY_ID_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_IS_VALIDATED_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_IS_VALIDATED_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_METER_END_DATE_SET_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_METER_END_DATE_SET_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_METER_LABEL_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_METER_LABEL_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_METER_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_METER_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_PROVIDER_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_PROVIDER_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_SERVICE_TYPE_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_SERVICE_TYPE_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_START_DATE_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_START_DATE_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_STATEMENT_MONTH_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_STATEMENT_MONTH_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_STATEMENT_YEAR_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_STATEMENT_YEAR_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_USAGE_UNITS_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_USAGE_UNITS_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_UTILITY_ACCOUNT_ID_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_UTILITY_ACCOUNT_ID_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_UTILITY_METER_ID_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_UTILITY_METER_ID_DESC', 'UTILITY_METER_STATEMENTS_SUM_ACCOUNT_LABEL_ASC', 'UTILITY_METER_STATEMENTS_SUM_ACCOUNT_LABEL_DESC', 'UTILITY_METER_STATEMENTS_SUM_ACCOUNT_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENTS_SUM_ACCOUNT_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENTS_SUM_BILL_ARRIVAL_DATE_ASC', 'UTILITY_METER_STATEMENTS_SUM_BILL_ARRIVAL_DATE_DESC', 'UTILITY_METER_STATEMENTS_SUM_CURRENCY_CODE_ASC', 'UTILITY_METER_STATEMENTS_SUM_CURRENCY_CODE_DESC', 'UTILITY_METER_STATEMENTS_SUM_DAYS_IN_BILL_ASC', 'UTILITY_METER_STATEMENTS_SUM_DAYS_IN_BILL_DESC', 'UTILITY_METER_STATEMENTS_SUM_DEMAND_UNITS_ASC', 'UTILITY_METER_STATEMENTS_SUM_DEMAND_UNITS_DESC', 'UTILITY_METER_STATEMENTS_SUM_END_DATE_ASC', 'UTILITY_METER_STATEMENTS_SUM_END_DATE_DESC', 'UTILITY_METER_STATEMENTS_SUM_EXCLUDE_USAGE_ASC', 'UTILITY_METER_STATEMENTS_SUM_EXCLUDE_USAGE_DESC', 'UTILITY_METER_STATEMENTS_SUM_FACILITY_ID_ASC', 'UTILITY_METER_STATEMENTS_SUM_FACILITY_ID_DESC', 'UTILITY_METER_STATEMENTS_SUM_IS_VALIDATED_ASC', 'UTILITY_METER_STATEMENTS_SUM_IS_VALIDATED_DESC', 'UTILITY_METER_STATEMENTS_SUM_METER_END_DATE_SET_ASC', 'UTILITY_METER_STATEMENTS_SUM_METER_END_DATE_SET_DESC', 'UTILITY_METER_STATEMENTS_SUM_METER_LABEL_ASC', 'UTILITY_METER_STATEMENTS_SUM_METER_LABEL_DESC', 'UTILITY_METER_STATEMENTS_SUM_METER_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENTS_SUM_METER_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENTS_SUM_PROVIDER_ASC', 'UTILITY_METER_STATEMENTS_SUM_PROVIDER_DESC', 'UTILITY_METER_STATEMENTS_SUM_SERVICE_TYPE_ASC', 'UTILITY_METER_STATEMENTS_SUM_SERVICE_TYPE_DESC', 'UTILITY_METER_STATEMENTS_SUM_START_DATE_ASC', 'UTILITY_METER_STATEMENTS_SUM_START_DATE_DESC', 'UTILITY_METER_STATEMENTS_SUM_STATEMENT_MONTH_ASC', 'UTILITY_METER_STATEMENTS_SUM_STATEMENT_MONTH_DESC', 'UTILITY_METER_STATEMENTS_SUM_STATEMENT_YEAR_ASC', 'UTILITY_METER_STATEMENTS_SUM_STATEMENT_YEAR_DESC', 'UTILITY_METER_STATEMENTS_SUM_USAGE_UNITS_ASC', 'UTILITY_METER_STATEMENTS_SUM_USAGE_UNITS_DESC', 'UTILITY_METER_STATEMENTS_SUM_UTILITY_ACCOUNT_ID_ASC', 'UTILITY_METER_STATEMENTS_SUM_UTILITY_ACCOUNT_ID_DESC', 'UTILITY_METER_STATEMENTS_SUM_UTILITY_METER_ID_ASC', 'UTILITY_METER_STATEMENTS_SUM_UTILITY_METER_ID_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_ACCOUNT_LABEL_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_ACCOUNT_LABEL_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_ACCOUNT_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_ACCOUNT_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_BILL_ARRIVAL_DATE_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_BILL_ARRIVAL_DATE_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_CURRENCY_CODE_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_CURRENCY_CODE_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_DAYS_IN_BILL_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_DAYS_IN_BILL_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_DEMAND_UNITS_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_DEMAND_UNITS_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_END_DATE_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_END_DATE_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_EXCLUDE_USAGE_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_EXCLUDE_USAGE_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_FACILITY_ID_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_FACILITY_ID_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_IS_VALIDATED_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_IS_VALIDATED_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_METER_END_DATE_SET_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_METER_END_DATE_SET_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_METER_LABEL_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_METER_LABEL_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_METER_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_METER_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_PROVIDER_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_PROVIDER_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_SERVICE_TYPE_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_SERVICE_TYPE_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_START_DATE_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_START_DATE_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_STATEMENT_MONTH_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_STATEMENT_MONTH_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_STATEMENT_YEAR_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_STATEMENT_YEAR_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_USAGE_UNITS_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_USAGE_UNITS_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_UTILITY_ACCOUNT_ID_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_UTILITY_ACCOUNT_ID_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_UTILITY_METER_ID_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_UTILITY_METER_ID_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_ACCOUNT_LABEL_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_ACCOUNT_LABEL_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_ACCOUNT_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_ACCOUNT_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_BILL_ARRIVAL_DATE_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_BILL_ARRIVAL_DATE_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_CURRENCY_CODE_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_CURRENCY_CODE_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_DAYS_IN_BILL_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_DAYS_IN_BILL_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_DEMAND_UNITS_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_DEMAND_UNITS_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_END_DATE_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_END_DATE_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_EXCLUDE_USAGE_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_EXCLUDE_USAGE_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_FACILITY_ID_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_FACILITY_ID_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_IS_VALIDATED_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_IS_VALIDATED_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_METER_END_DATE_SET_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_METER_END_DATE_SET_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_METER_LABEL_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_METER_LABEL_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_METER_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_METER_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_PROVIDER_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_PROVIDER_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_SERVICE_TYPE_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_SERVICE_TYPE_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_START_DATE_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_START_DATE_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_STATEMENT_MONTH_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_STATEMENT_MONTH_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_STATEMENT_YEAR_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_STATEMENT_YEAR_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_USAGE_UNITS_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_USAGE_UNITS_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_UTILITY_ACCOUNT_ID_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_UTILITY_ACCOUNT_ID_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_UTILITY_METER_ID_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_UTILITY_METER_ID_DESC')


class Acknowledgement(sgqlc.types.Enum):
    __schema__ = nionic_schema
    __choices__ = ('ACKNOWLEDGED', 'REJECTED', 'UNACKNOWLEDGED')


class BalancingAuthoritiesOrderBy(sgqlc.types.Enum):
    __schema__ = nionic_schema
    __choices__ = ('CREATED_AT_ASC', 'CREATED_AT_DESC', 'GEOMETRY_ASC', 'GEOMETRY_DESC', 'ID_ASC', 'ID_DESC', 'NAME_ASC', 'NAME_DESC', 'NATURAL', 'PRIMARY_KEY_ASC', 'PRIMARY_KEY_DESC', 'SLUG_ASC', 'SLUG_DESC', 'UPDATED_AT_ASC', 'UPDATED_AT_DESC')


class BigFloat(sgqlc.types.Scalar):
    __schema__ = nionic_schema


class BigInt(sgqlc.types.Scalar):
    __schema__ = nionic_schema


Boolean = sgqlc.types.Boolean

class BuildingAreaTypesOrderBy(sgqlc.types.Enum):
    __schema__ = nionic_schema
    __choices__ = ('DESCRIPTION_ASC', 'DESCRIPTION_DESC', 'METADATA_ASC', 'METADATA_DESC', 'NATURAL', 'PRIMARY_KEY_ASC', 'PRIMARY_KEY_DESC', 'TYPE_ASC', 'TYPE_DESC')


class BuildingAreasOrderBy(sgqlc.types.Enum):
    __schema__ = nionic_schema
    __choices__ = ('BUILDING_AREA_TYPE_ID_ASC', 'BUILDING_AREA_TYPE_ID_DESC', 'CREATED_AT_ASC', 'CREATED_AT_DESC', 'DESCRIPTION_ASC', 'DESCRIPTION_DESC', 'FACILITY_ID_ASC', 'FACILITY_ID_DESC', 'GEOMETRY_ASC', 'GEOMETRY_DESC', 'ID_ASC', 'ID_DESC', 'LABEL_ASC', 'LABEL_DESC', 'NATURAL', 'PRIMARY_KEY_ASC', 'PRIMARY_KEY_DESC', 'UPDATED_AT_ASC', 'UPDATED_AT_DESC')


class ChartsOrderBy(sgqlc.types.Enum):
    __schema__ = nionic_schema
    __choices__ = ('CONFIG_ASC', 'CONFIG_DESC', 'CREATED_AT_ASC', 'CREATED_AT_DESC', 'DESCRIPTION_ASC', 'DESCRIPTION_DESC', 'FACILITY_ID_ASC', 'FACILITY_ID_DESC', 'ID_ASC', 'ID_DESC', 'NAME_ASC', 'NAME_DESC', 'NATURAL', 'PRIMARY_KEY_ASC', 'PRIMARY_KEY_DESC', 'UPDATED_AT_ASC', 'UPDATED_AT_DESC')


class ComponentsOrderBy(sgqlc.types.Enum):
    __schema__ = nionic_schema
    __choices__ = ('ALIAS_ASC', 'ALIAS_DESC', 'CREATED_AT_ASC', 'CREATED_AT_DESC', 'FACILITY_ID_ASC', 'FACILITY_ID_DESC', 'ID_ASC', 'ID_DESC', 'MACHINE_USER_ID_ASC', 'MACHINE_USER_ID_DESC', 'NAME_ASC', 'NAME_DESC', 'NATURAL', 'OUT_OF_SERVICE_ASC', 'OUT_OF_SERVICE_DESC', 'PRIMARY_KEY_ASC', 'PRIMARY_KEY_DESC', 'UPDATED_AT_ASC', 'UPDATED_AT_DESC')


class ControlEventActivityLogsOrderBy(sgqlc.types.Enum):
    __schema__ = nionic_schema
    __choices__ = ('ACTOR_ASC', 'ACTOR_DESC', 'CONTROL_EVENT_ID_ASC', 'CONTROL_EVENT_ID_DESC', 'METADATA_ASC', 'METADATA_DESC', 'NATURAL', 'TIME_ASC', 'TIME_DESC', 'TYPE_ASC', 'TYPE_DESC')


class ControlEventLogsOrderBy(sgqlc.types.Enum):
    __schema__ = nionic_schema
    __choices__ = ('ACTOR_ASC', 'ACTOR_DESC', 'CONTROL_EVENT_ID_ASC', 'CONTROL_EVENT_ID_DESC', 'CREATED_AT_ASC', 'CREATED_AT_DESC', 'ID_ASC', 'ID_DESC', 'MESSAGE_ASC', 'MESSAGE_DESC', 'NATURAL', 'PRIMARY_KEY_ASC', 'PRIMARY_KEY_DESC')


class ControlEventState(sgqlc.types.Enum):
    __schema__ = nionic_schema
    __choices__ = ('CANCELLED', 'CANCEL_REQUESTED', 'COMPLETED', 'FAILED', 'SCHEDULED', 'STARTED')


class ControlEventStateTransitionsOrderBy(sgqlc.types.Enum):
    __schema__ = nionic_schema
    __choices__ = ('ACTOR_ASC', 'ACTOR_DESC', 'CONTROL_EVENT_ID_ASC', 'CONTROL_EVENT_ID_DESC', 'CREATED_AT_ASC', 'CREATED_AT_DESC', 'DESCRIPTION_ASC', 'DESCRIPTION_DESC', 'NATURAL', 'PRIMARY_KEY_ASC', 'PRIMARY_KEY_DESC', 'STATE_ASC', 'STATE_DESC')


class ControlEventsOrderBy(sgqlc.types.Enum):
    __schema__ = nionic_schema
    __choices__ = ('ACKNOWLEDGED_AT_ASC', 'ACKNOWLEDGED_AT_DESC', 'COMPONENT_ID_ASC', 'COMPONENT_ID_DESC', 'CREATED_AT_ASC', 'CREATED_AT_DESC', 'END_TIME_ASC', 'END_TIME_DESC', 'ID_ASC', 'ID_DESC', 'NAME_ASC', 'NAME_DESC', 'NATURAL', 'PRIMARY_KEY_ASC', 'PRIMARY_KEY_DESC', 'REMOTE_METADATA_ASC', 'REMOTE_METADATA_DESC', 'START_TIME_ASC', 'START_TIME_DESC', 'UPDATED_AT_ASC', 'UPDATED_AT_DESC')


class ControlType(sgqlc.types.Enum):
    __schema__ = nionic_schema
    __choices__ = ('AUTOMATIC', 'MANUAL')


class Country(sgqlc.types.Enum):
    __schema__ = nionic_schema
    __choices__ = ('ABW', 'AFG', 'AGO', 'AIA', 'ALA', 'ALB', 'AND', 'ARE', 'ARG', 'ARM', 'ASM', 'ATA', 'ATF', 'ATG', 'AUS', 'AUT', 'AZE', 'BDI', 'BEL', 'BEN', 'BES', 'BFA', 'BGD', 'BGR', 'BHR', 'BHS', 'BIH', 'BLM', 'BLR', 'BLZ', 'BMU', 'BOL', 'BRA', 'BRB', 'BRN', 'BTN', 'BVT', 'BWA', 'CAF', 'CAN', 'CCK', 'CHE', 'CHL', 'CHN', 'CIV', 'CMR', 'COD', 'COG', 'COK', 'COL', 'COM', 'CPV', 'CRI', 'CUB', 'CUW', 'CXR', 'CYM', 'CYP', 'CZE', 'DEU', 'DJI', 'DMA', 'DNK', 'DOM', 'DZA', 'ECU', 'EGY', 'ERI', 'ESH', 'ESP', 'EST', 'ETH', 'FIN', 'FJI', 'FLK', 'FRA', 'FRO', 'FSM', 'GAB', 'GBR', 'GEO', 'GGY', 'GHA', 'GIB', 'GIN', 'GLP', 'GMB', 'GNB', 'GNQ', 'GRC', 'GRD', 'GRL', 'GTM', 'GUF', 'GUM', 'GUY', 'HKG', 'HMD', 'HND', 'HRV', 'HTI', 'HUN', 'IDN', 'IMN', 'IND', 'IOT', 'IRL', 'IRN', 'IRQ', 'ISL', 'ISR', 'ITA', 'JAM', 'JEY', 'JOR', 'JPN', 'KAZ', 'KEN', 'KGZ', 'KHM', 'KIR', 'KNA', 'KOR', 'KWT', 'LAO', 'LBN', 'LBR', 'LBY', 'LCA', 'LIE', 'LKA', 'LSO', 'LTU', 'LUX', 'LVA', 'MAC', 'MAF', 'MAR', 'MCO', 'MDA', 'MDG', 'MDV', 'MEX', 'MHL', 'MKD', 'MLI', 'MLT', 'MMR', 'MNE', 'MNG', 'MNP', 'MOZ', 'MRT', 'MSR', 'MTQ', 'MUS', 'MWI', 'MYS', 'MYT', 'NAM', 'NCL', 'NER', 'NFK', 'NGA', 'NIC', 'NIU', 'NLD', 'NOR', 'NPL', 'NRU', 'NZL', 'OMN', 'PAK', 'PAN', 'PCN', 'PER', 'PHL', 'PLW', 'PNG', 'POL', 'PRI', 'PRK', 'PRT', 'PRY', 'PSE', 'PYF', 'QAT', 'REU', 'ROU', 'RUS', 'RWA', 'SAU', 'SDN', 'SEN', 'SGP', 'SGS', 'SHN', 'SJM', 'SLB', 'SLE', 'SLV', 'SMR', 'SOM', 'SPM', 'SRB', 'SSD', 'STP', 'SUR', 'SVK', 'SVN', 'SWE', 'SWZ', 'SXM', 'SYC', 'SYR', 'TCA', 'TCD', 'TGO', 'THA', 'TJK', 'TKL', 'TKM', 'TLS', 'TON', 'TTO', 'TUN', 'TUR', 'TUV', 'TZA', 'UGA', 'UKR', 'UMI', 'URY', 'USA', 'UZB', 'VAT', 'VCT', 'VEN', 'VGB', 'VIR', 'VNM', 'VUT', 'WLF', 'WSM', 'YEM', 'ZAF', 'ZMB', 'ZWE')


class Cursor(sgqlc.types.Scalar):
    __schema__ = nionic_schema


class DashboardsOrderBy(sgqlc.types.Enum):
    __schema__ = nionic_schema
    __choices__ = ('CONFIG_ASC', 'CONFIG_DESC', 'CREATED_AT_ASC', 'CREATED_AT_DESC', 'DESCRIPTION_ASC', 'DESCRIPTION_DESC', 'FACILITY_ID_ASC', 'FACILITY_ID_DESC', 'ID_ASC', 'ID_DESC', 'NAME_ASC', 'NAME_DESC', 'NATURAL', 'PRIMARY_KEY_ASC', 'PRIMARY_KEY_DESC', 'UPDATED_AT_ASC', 'UPDATED_AT_DESC')


class DataPointTagsOrderBy(sgqlc.types.Enum):
    __schema__ = nionic_schema
    __choices__ = ('CREATED_AT_ASC', 'CREATED_AT_DESC', 'ID_ASC', 'ID_DESC', 'NAME_ASC', 'NAME_DESC', 'NATURAL', 'PRIMARY_KEY_ASC', 'PRIMARY_KEY_DESC', 'UPDATED_AT_ASC', 'UPDATED_AT_DESC')


class DataPointType(sgqlc.types.Enum):
    __schema__ = nionic_schema
    __choices__ = ('COMPOSITE', 'RAW', 'VIRTUAL')


class DataPointsOrderBy(sgqlc.types.Enum):
    __schema__ = nionic_schema
    __choices__ = ('ALIAS_ASC', 'ALIAS_DESC', 'CREATED_AT_ASC', 'CREATED_AT_DESC', 'DATA_SOURCE_NAME_ASC', 'DATA_SOURCE_NAME_DESC', 'DATA_TYPE_ASC', 'DATA_TYPE_DESC', 'DESCRIPTION_ASC', 'DESCRIPTION_DESC', 'EXPRESSION_ASC', 'EXPRESSION_DESC', 'FORMATTED_EXPRESSION_ASC', 'FORMATTED_EXPRESSION_DESC', 'FREQUENCY_ASC', 'FREQUENCY_DESC', 'FRESHNESS_THRESHOLD_SECONDS_ASC', 'FRESHNESS_THRESHOLD_SECONDS_DESC', 'ID_ASC', 'ID_DESC', 'LOCATION_TYPE_ASC', 'LOCATION_TYPE_DESC', 'NAME_ASC', 'NAME_DESC', 'NATURAL', 'PRIMARY_KEY_ASC', 'PRIMARY_KEY_DESC', 'RIGHT_ALIGNED_ASC', 'RIGHT_ALIGNED_DESC', 'TYPE_ASC', 'TYPE_DESC', 'UNITS_ASC', 'UNITS_DESC', 'UPDATED_AT_ASC', 'UPDATED_AT_DESC')


class DataSourcesOrderBy(sgqlc.types.Enum):
    __schema__ = nionic_schema
    __choices__ = ('ALIAS_ASC', 'ALIAS_DESC', 'CREATED_AT_ASC', 'CREATED_AT_DESC', 'CRITICAL_THRESHOLD_ASC', 'CRITICAL_THRESHOLD_DESC', 'DESCRIPTION_ASC', 'DESCRIPTION_DESC', 'DISPLAY_NAME_ASC', 'DISPLAY_NAME_DESC', 'LIVENESS_THRESHOLD_SECONDS_ASC', 'LIVENESS_THRESHOLD_SECONDS_DESC', 'NAME_ASC', 'NAME_DESC', 'NATURAL', 'PRIMARY_KEY_ASC', 'PRIMARY_KEY_DESC', 'UPDATED_AT_ASC', 'UPDATED_AT_DESC')


Date = sgqlc.types.datetime.Date

class Datetime(sgqlc.types.Scalar):
    __schema__ = nionic_schema


class DependenciesOrderBy(sgqlc.types.Enum):
    __schema__ = nionic_schema
    __choices__ = ('ID_ASC', 'ID_DESC', 'NAME_ASC', 'NAME_DESC', 'NATURAL', 'PATH_ASC', 'PATH_DESC', 'PRIMARY_KEY_ASC', 'PRIMARY_KEY_DESC', 'TYPE_ASC', 'TYPE_DESC')


class FacilitiesGroupBy(sgqlc.types.Enum):
    __schema__ = nionic_schema
    __choices__ = ('ADDRESS', 'ADDRESS_DISTINCT', 'BONUS_LTR', 'BONUS_LTR_DISTINCT', 'CITY', 'CITY_DISTINCT', 'COMMODITY', 'COMMODITY_DISTINCT', 'COST_CENTER', 'COST_CENTER_DISTINCT', 'COUNTRY', 'COUNTRY_DISTINCT', 'CREATED_AT', 'CREATED_AT_DISTINCT', 'CREATED_AT_TRUNCATED_TO_DAY', 'CREATED_AT_TRUNCATED_TO_HOUR', 'CUSTOMER_LOCATION_ID', 'CUSTOMER_LOCATION_ID_DISTINCT', 'FACILITY_CONTACTS', 'FACILITY_CONTACTS_DISTINCT', 'GEOMETRY', 'GEOMETRY_DISTINCT', 'GO_LIVE_DATE', 'GO_LIVE_DATE_DISTINCT', 'GO_LIVE_DATE_TRUNCATED_TO_DAY', 'GO_LIVE_DATE_TRUNCATED_TO_HOUR', 'LATITUDE', 'LATITUDE_DISTINCT', 'LINK_ACTIVE', 'LINK_ACTIVE_DISTINCT', 'LONGITUDE', 'LONGITUDE_DISTINCT', 'METRICS_ONE_ACTIVE', 'METRICS_ONE_ACTIVE_DISTINCT', 'NAME', 'NAME_DISTINCT', 'N_SIGHT_2_ACTIVE', 'N_SIGHT_2_ACTIVE_DISTINCT', 'N_SIGHT_ACTIVE', 'N_SIGHT_ACTIVE_DISTINCT', 'PRE_BONUS_EBITDA', 'PRE_BONUS_EBITDA_DISTINCT', 'PRICING_NODE_ID', 'PRICING_NODE_ID_DISTINCT', 'REAL_TIME_ENABLED', 'REAL_TIME_ENABLED_DISTINCT', 'RETIRED_AT', 'RETIRED_AT_DISTINCT', 'RETIRED_AT_TRUNCATED_TO_DAY', 'RETIRED_AT_TRUNCATED_TO_HOUR', 'STATE', 'STATE_DISTINCT', 'SUPPRESSE_FINANCIALS', 'SUPPRESSE_FINANCIALS_DISTINCT', 'TIMEZONE_NAME', 'TIMEZONE_NAME_DISTINCT', 'TYPE', 'TYPE_DISTINCT', 'UNIT_GROUP', 'UNIT_GROUP_DISTINCT', 'UPDATED_AT', 'UPDATED_AT_DISTINCT', 'UPDATED_AT_TRUNCATED_TO_DAY', 'UPDATED_AT_TRUNCATED_TO_HOUR', 'WMS', 'WMS_DISTINCT', 'ZIP', 'ZIP_DISTINCT')


class FacilitiesOrderBy(sgqlc.types.Enum):
    __schema__ = nionic_schema
    __choices__ = ('ADDRESS_ASC', 'ADDRESS_DESC', 'BONUS_LTR_ASC', 'BONUS_LTR_DESC', 'CITY_ASC', 'CITY_DESC', 'COMMODITY_ASC', 'COMMODITY_DESC', 'COST_CENTER_ASC', 'COST_CENTER_DESC', 'COUNTRY_ASC', 'COUNTRY_DESC', 'CREATED_AT_ASC', 'CREATED_AT_DESC', 'CUSTOMER_LOCATION_ID_ASC', 'CUSTOMER_LOCATION_ID_DESC', 'FACILITY_CONTACTS_ASC', 'FACILITY_CONTACTS_DESC', 'GEOMETRY_ASC', 'GEOMETRY_DESC', 'GO_LIVE_DATE_ASC', 'GO_LIVE_DATE_DESC', 'ID_ASC', 'ID_DESC', 'LATITUDE_ASC', 'LATITUDE_DESC', 'LINK_ACTIVE_ASC', 'LINK_ACTIVE_DESC', 'LONGITUDE_ASC', 'LONGITUDE_DESC', 'METRICS_ONE_ACTIVE_ASC', 'METRICS_ONE_ACTIVE_DESC', 'NAME_ASC', 'NAME_DESC', 'NATURAL', 'N_SIGHT_2_ACTIVE_ASC', 'N_SIGHT_2_ACTIVE_DESC', 'N_SIGHT_ACTIVE_ASC', 'N_SIGHT_ACTIVE_DESC', 'PRE_BONUS_EBITDA_ASC', 'PRE_BONUS_EBITDA_DESC', 'PRICING_NODE_ID_ASC', 'PRICING_NODE_ID_DESC', 'PRIMARY_KEY_ASC', 'PRIMARY_KEY_DESC', 'REAL_TIME_ENABLED_ASC', 'REAL_TIME_ENABLED_DESC', 'RETIRED_AT_ASC', 'RETIRED_AT_DESC', 'SLUG_ASC', 'SLUG_DESC', 'STATE_ASC', 'STATE_DESC', 'SUPPRESSE_FINANCIALS_ASC', 'SUPPRESSE_FINANCIALS_DESC', 'TIMEZONE_NAME_ASC', 'TIMEZONE_NAME_DESC', 'TYPE_ASC', 'TYPE_DESC', 'UNIT_GROUP_ASC', 'UNIT_GROUP_DESC', 'UPDATED_AT_ASC', 'UPDATED_AT_DESC', 'UTILITY_BILL_CURRENCY_ASC', 'UTILITY_BILL_CURRENCY_DESC', 'UTILITY_METER_STATEMENTS_AVERAGE_ACCOUNT_LABEL_ASC', 'UTILITY_METER_STATEMENTS_AVERAGE_ACCOUNT_LABEL_DESC', 'UTILITY_METER_STATEMENTS_AVERAGE_ACCOUNT_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENTS_AVERAGE_ACCOUNT_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENTS_AVERAGE_BILL_ARRIVAL_DATE_ASC', 'UTILITY_METER_STATEMENTS_AVERAGE_BILL_ARRIVAL_DATE_DESC', 'UTILITY_METER_STATEMENTS_AVERAGE_CURRENCY_CODE_ASC', 'UTILITY_METER_STATEMENTS_AVERAGE_CURRENCY_CODE_DESC', 'UTILITY_METER_STATEMENTS_AVERAGE_DAYS_IN_BILL_ASC', 'UTILITY_METER_STATEMENTS_AVERAGE_DAYS_IN_BILL_DESC', 'UTILITY_METER_STATEMENTS_AVERAGE_DEMAND_UNITS_ASC', 'UTILITY_METER_STATEMENTS_AVERAGE_DEMAND_UNITS_DESC', 'UTILITY_METER_STATEMENTS_AVERAGE_END_DATE_ASC', 'UTILITY_METER_STATEMENTS_AVERAGE_END_DATE_DESC', 'UTILITY_METER_STATEMENTS_AVERAGE_EXCLUDE_USAGE_ASC', 'UTILITY_METER_STATEMENTS_AVERAGE_EXCLUDE_USAGE_DESC', 'UTILITY_METER_STATEMENTS_AVERAGE_FACILITY_ID_ASC', 'UTILITY_METER_STATEMENTS_AVERAGE_FACILITY_ID_DESC', 'UTILITY_METER_STATEMENTS_AVERAGE_IS_VALIDATED_ASC', 'UTILITY_METER_STATEMENTS_AVERAGE_IS_VALIDATED_DESC', 'UTILITY_METER_STATEMENTS_AVERAGE_METER_END_DATE_SET_ASC', 'UTILITY_METER_STATEMENTS_AVERAGE_METER_END_DATE_SET_DESC', 'UTILITY_METER_STATEMENTS_AVERAGE_METER_LABEL_ASC', 'UTILITY_METER_STATEMENTS_AVERAGE_METER_LABEL_DESC', 'UTILITY_METER_STATEMENTS_AVERAGE_METER_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENTS_AVERAGE_METER_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENTS_AVERAGE_PROVIDER_ASC', 'UTILITY_METER_STATEMENTS_AVERAGE_PROVIDER_DESC', 'UTILITY_METER_STATEMENTS_AVERAGE_SERVICE_TYPE_ASC', 'UTILITY_METER_STATEMENTS_AVERAGE_SERVICE_TYPE_DESC', 'UTILITY_METER_STATEMENTS_AVERAGE_START_DATE_ASC', 'UTILITY_METER_STATEMENTS_AVERAGE_START_DATE_DESC', 'UTILITY_METER_STATEMENTS_AVERAGE_STATEMENT_MONTH_ASC', 'UTILITY_METER_STATEMENTS_AVERAGE_STATEMENT_MONTH_DESC', 'UTILITY_METER_STATEMENTS_AVERAGE_STATEMENT_YEAR_ASC', 'UTILITY_METER_STATEMENTS_AVERAGE_STATEMENT_YEAR_DESC', 'UTILITY_METER_STATEMENTS_AVERAGE_USAGE_UNITS_ASC', 'UTILITY_METER_STATEMENTS_AVERAGE_USAGE_UNITS_DESC', 'UTILITY_METER_STATEMENTS_AVERAGE_UTILITY_ACCOUNT_ID_ASC', 'UTILITY_METER_STATEMENTS_AVERAGE_UTILITY_ACCOUNT_ID_DESC', 'UTILITY_METER_STATEMENTS_AVERAGE_UTILITY_METER_ID_ASC', 'UTILITY_METER_STATEMENTS_AVERAGE_UTILITY_METER_ID_DESC', 'UTILITY_METER_STATEMENTS_COUNT_ASC', 'UTILITY_METER_STATEMENTS_COUNT_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_ACCOUNT_LABEL_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_ACCOUNT_LABEL_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_ACCOUNT_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_ACCOUNT_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_BILL_ARRIVAL_DATE_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_BILL_ARRIVAL_DATE_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_ACCOUNT_LABEL_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_ACCOUNT_LABEL_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_ACCOUNT_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_ACCOUNT_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_BILL_ARRIVAL_DATE_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_BILL_ARRIVAL_DATE_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_CURRENCY_CODE_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_CURRENCY_CODE_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_DAYS_IN_BILL_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_DAYS_IN_BILL_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_DEMAND_UNITS_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_DEMAND_UNITS_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_END_DATE_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_END_DATE_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_EXCLUDE_USAGE_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_EXCLUDE_USAGE_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_FACILITY_ID_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_FACILITY_ID_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_IS_VALIDATED_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_IS_VALIDATED_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_METER_END_DATE_SET_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_METER_END_DATE_SET_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_METER_LABEL_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_METER_LABEL_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_METER_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_METER_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_PROVIDER_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_PROVIDER_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_SERVICE_TYPE_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_SERVICE_TYPE_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_START_DATE_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_START_DATE_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_STATEMENT_MONTH_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_STATEMENT_MONTH_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_STATEMENT_YEAR_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_STATEMENT_YEAR_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_USAGE_UNITS_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_USAGE_UNITS_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_UTILITY_ACCOUNT_ID_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_UTILITY_ACCOUNT_ID_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_UTILITY_METER_ID_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_UTILITY_METER_ID_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_CURRENCY_CODE_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_CURRENCY_CODE_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_DAYS_IN_BILL_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_DAYS_IN_BILL_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_DEMAND_UNITS_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_DEMAND_UNITS_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_END_DATE_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_END_DATE_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_EXCLUDE_USAGE_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_EXCLUDE_USAGE_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_FACILITY_ID_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_FACILITY_ID_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_IS_VALIDATED_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_IS_VALIDATED_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_METER_END_DATE_SET_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_METER_END_DATE_SET_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_METER_LABEL_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_METER_LABEL_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_METER_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_METER_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_PROVIDER_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_PROVIDER_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_SERVICE_TYPE_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_SERVICE_TYPE_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_START_DATE_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_START_DATE_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_STATEMENT_MONTH_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_STATEMENT_MONTH_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_STATEMENT_YEAR_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_STATEMENT_YEAR_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_USAGE_UNITS_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_USAGE_UNITS_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_UTILITY_ACCOUNT_ID_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_UTILITY_ACCOUNT_ID_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_UTILITY_METER_ID_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_UTILITY_METER_ID_DESC', 'UTILITY_METER_STATEMENTS_MAX_ACCOUNT_LABEL_ASC', 'UTILITY_METER_STATEMENTS_MAX_ACCOUNT_LABEL_DESC', 'UTILITY_METER_STATEMENTS_MAX_ACCOUNT_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENTS_MAX_ACCOUNT_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENTS_MAX_BILL_ARRIVAL_DATE_ASC', 'UTILITY_METER_STATEMENTS_MAX_BILL_ARRIVAL_DATE_DESC', 'UTILITY_METER_STATEMENTS_MAX_CURRENCY_CODE_ASC', 'UTILITY_METER_STATEMENTS_MAX_CURRENCY_CODE_DESC', 'UTILITY_METER_STATEMENTS_MAX_DAYS_IN_BILL_ASC', 'UTILITY_METER_STATEMENTS_MAX_DAYS_IN_BILL_DESC', 'UTILITY_METER_STATEMENTS_MAX_DEMAND_UNITS_ASC', 'UTILITY_METER_STATEMENTS_MAX_DEMAND_UNITS_DESC', 'UTILITY_METER_STATEMENTS_MAX_END_DATE_ASC', 'UTILITY_METER_STATEMENTS_MAX_END_DATE_DESC', 'UTILITY_METER_STATEMENTS_MAX_EXCLUDE_USAGE_ASC', 'UTILITY_METER_STATEMENTS_MAX_EXCLUDE_USAGE_DESC', 'UTILITY_METER_STATEMENTS_MAX_FACILITY_ID_ASC', 'UTILITY_METER_STATEMENTS_MAX_FACILITY_ID_DESC', 'UTILITY_METER_STATEMENTS_MAX_IS_VALIDATED_ASC', 'UTILITY_METER_STATEMENTS_MAX_IS_VALIDATED_DESC', 'UTILITY_METER_STATEMENTS_MAX_METER_END_DATE_SET_ASC', 'UTILITY_METER_STATEMENTS_MAX_METER_END_DATE_SET_DESC', 'UTILITY_METER_STATEMENTS_MAX_METER_LABEL_ASC', 'UTILITY_METER_STATEMENTS_MAX_METER_LABEL_DESC', 'UTILITY_METER_STATEMENTS_MAX_METER_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENTS_MAX_METER_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENTS_MAX_PROVIDER_ASC', 'UTILITY_METER_STATEMENTS_MAX_PROVIDER_DESC', 'UTILITY_METER_STATEMENTS_MAX_SERVICE_TYPE_ASC', 'UTILITY_METER_STATEMENTS_MAX_SERVICE_TYPE_DESC', 'UTILITY_METER_STATEMENTS_MAX_START_DATE_ASC', 'UTILITY_METER_STATEMENTS_MAX_START_DATE_DESC', 'UTILITY_METER_STATEMENTS_MAX_STATEMENT_MONTH_ASC', 'UTILITY_METER_STATEMENTS_MAX_STATEMENT_MONTH_DESC', 'UTILITY_METER_STATEMENTS_MAX_STATEMENT_YEAR_ASC', 'UTILITY_METER_STATEMENTS_MAX_STATEMENT_YEAR_DESC', 'UTILITY_METER_STATEMENTS_MAX_USAGE_UNITS_ASC', 'UTILITY_METER_STATEMENTS_MAX_USAGE_UNITS_DESC', 'UTILITY_METER_STATEMENTS_MAX_UTILITY_ACCOUNT_ID_ASC', 'UTILITY_METER_STATEMENTS_MAX_UTILITY_ACCOUNT_ID_DESC', 'UTILITY_METER_STATEMENTS_MAX_UTILITY_METER_ID_ASC', 'UTILITY_METER_STATEMENTS_MAX_UTILITY_METER_ID_DESC', 'UTILITY_METER_STATEMENTS_MIN_ACCOUNT_LABEL_ASC', 'UTILITY_METER_STATEMENTS_MIN_ACCOUNT_LABEL_DESC', 'UTILITY_METER_STATEMENTS_MIN_ACCOUNT_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENTS_MIN_ACCOUNT_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENTS_MIN_BILL_ARRIVAL_DATE_ASC', 'UTILITY_METER_STATEMENTS_MIN_BILL_ARRIVAL_DATE_DESC', 'UTILITY_METER_STATEMENTS_MIN_CURRENCY_CODE_ASC', 'UTILITY_METER_STATEMENTS_MIN_CURRENCY_CODE_DESC', 'UTILITY_METER_STATEMENTS_MIN_DAYS_IN_BILL_ASC', 'UTILITY_METER_STATEMENTS_MIN_DAYS_IN_BILL_DESC', 'UTILITY_METER_STATEMENTS_MIN_DEMAND_UNITS_ASC', 'UTILITY_METER_STATEMENTS_MIN_DEMAND_UNITS_DESC', 'UTILITY_METER_STATEMENTS_MIN_END_DATE_ASC', 'UTILITY_METER_STATEMENTS_MIN_END_DATE_DESC', 'UTILITY_METER_STATEMENTS_MIN_EXCLUDE_USAGE_ASC', 'UTILITY_METER_STATEMENTS_MIN_EXCLUDE_USAGE_DESC', 'UTILITY_METER_STATEMENTS_MIN_FACILITY_ID_ASC', 'UTILITY_METER_STATEMENTS_MIN_FACILITY_ID_DESC', 'UTILITY_METER_STATEMENTS_MIN_IS_VALIDATED_ASC', 'UTILITY_METER_STATEMENTS_MIN_IS_VALIDATED_DESC', 'UTILITY_METER_STATEMENTS_MIN_METER_END_DATE_SET_ASC', 'UTILITY_METER_STATEMENTS_MIN_METER_END_DATE_SET_DESC', 'UTILITY_METER_STATEMENTS_MIN_METER_LABEL_ASC', 'UTILITY_METER_STATEMENTS_MIN_METER_LABEL_DESC', 'UTILITY_METER_STATEMENTS_MIN_METER_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENTS_MIN_METER_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENTS_MIN_PROVIDER_ASC', 'UTILITY_METER_STATEMENTS_MIN_PROVIDER_DESC', 'UTILITY_METER_STATEMENTS_MIN_SERVICE_TYPE_ASC', 'UTILITY_METER_STATEMENTS_MIN_SERVICE_TYPE_DESC', 'UTILITY_METER_STATEMENTS_MIN_START_DATE_ASC', 'UTILITY_METER_STATEMENTS_MIN_START_DATE_DESC', 'UTILITY_METER_STATEMENTS_MIN_STATEMENT_MONTH_ASC', 'UTILITY_METER_STATEMENTS_MIN_STATEMENT_MONTH_DESC', 'UTILITY_METER_STATEMENTS_MIN_STATEMENT_YEAR_ASC', 'UTILITY_METER_STATEMENTS_MIN_STATEMENT_YEAR_DESC', 'UTILITY_METER_STATEMENTS_MIN_USAGE_UNITS_ASC', 'UTILITY_METER_STATEMENTS_MIN_USAGE_UNITS_DESC', 'UTILITY_METER_STATEMENTS_MIN_UTILITY_ACCOUNT_ID_ASC', 'UTILITY_METER_STATEMENTS_MIN_UTILITY_ACCOUNT_ID_DESC', 'UTILITY_METER_STATEMENTS_MIN_UTILITY_METER_ID_ASC', 'UTILITY_METER_STATEMENTS_MIN_UTILITY_METER_ID_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_ACCOUNT_LABEL_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_ACCOUNT_LABEL_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_ACCOUNT_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_ACCOUNT_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_BILL_ARRIVAL_DATE_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_BILL_ARRIVAL_DATE_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_CURRENCY_CODE_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_CURRENCY_CODE_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_DAYS_IN_BILL_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_DAYS_IN_BILL_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_DEMAND_UNITS_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_DEMAND_UNITS_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_END_DATE_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_END_DATE_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_EXCLUDE_USAGE_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_EXCLUDE_USAGE_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_FACILITY_ID_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_FACILITY_ID_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_IS_VALIDATED_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_IS_VALIDATED_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_METER_END_DATE_SET_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_METER_END_DATE_SET_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_METER_LABEL_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_METER_LABEL_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_METER_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_METER_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_PROVIDER_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_PROVIDER_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_SERVICE_TYPE_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_SERVICE_TYPE_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_START_DATE_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_START_DATE_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_STATEMENT_MONTH_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_STATEMENT_MONTH_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_STATEMENT_YEAR_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_STATEMENT_YEAR_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_USAGE_UNITS_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_USAGE_UNITS_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_UTILITY_ACCOUNT_ID_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_UTILITY_ACCOUNT_ID_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_UTILITY_METER_ID_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_UTILITY_METER_ID_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_ACCOUNT_LABEL_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_ACCOUNT_LABEL_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_ACCOUNT_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_ACCOUNT_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_BILL_ARRIVAL_DATE_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_BILL_ARRIVAL_DATE_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_CURRENCY_CODE_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_CURRENCY_CODE_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_DAYS_IN_BILL_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_DAYS_IN_BILL_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_DEMAND_UNITS_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_DEMAND_UNITS_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_END_DATE_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_END_DATE_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_EXCLUDE_USAGE_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_EXCLUDE_USAGE_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_FACILITY_ID_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_FACILITY_ID_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_IS_VALIDATED_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_IS_VALIDATED_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_METER_END_DATE_SET_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_METER_END_DATE_SET_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_METER_LABEL_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_METER_LABEL_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_METER_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_METER_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_PROVIDER_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_PROVIDER_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_SERVICE_TYPE_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_SERVICE_TYPE_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_START_DATE_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_START_DATE_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_STATEMENT_MONTH_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_STATEMENT_MONTH_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_STATEMENT_YEAR_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_STATEMENT_YEAR_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_USAGE_UNITS_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_USAGE_UNITS_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_UTILITY_ACCOUNT_ID_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_UTILITY_ACCOUNT_ID_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_UTILITY_METER_ID_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_UTILITY_METER_ID_DESC', 'UTILITY_METER_STATEMENTS_SUM_ACCOUNT_LABEL_ASC', 'UTILITY_METER_STATEMENTS_SUM_ACCOUNT_LABEL_DESC', 'UTILITY_METER_STATEMENTS_SUM_ACCOUNT_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENTS_SUM_ACCOUNT_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENTS_SUM_BILL_ARRIVAL_DATE_ASC', 'UTILITY_METER_STATEMENTS_SUM_BILL_ARRIVAL_DATE_DESC', 'UTILITY_METER_STATEMENTS_SUM_CURRENCY_CODE_ASC', 'UTILITY_METER_STATEMENTS_SUM_CURRENCY_CODE_DESC', 'UTILITY_METER_STATEMENTS_SUM_DAYS_IN_BILL_ASC', 'UTILITY_METER_STATEMENTS_SUM_DAYS_IN_BILL_DESC', 'UTILITY_METER_STATEMENTS_SUM_DEMAND_UNITS_ASC', 'UTILITY_METER_STATEMENTS_SUM_DEMAND_UNITS_DESC', 'UTILITY_METER_STATEMENTS_SUM_END_DATE_ASC', 'UTILITY_METER_STATEMENTS_SUM_END_DATE_DESC', 'UTILITY_METER_STATEMENTS_SUM_EXCLUDE_USAGE_ASC', 'UTILITY_METER_STATEMENTS_SUM_EXCLUDE_USAGE_DESC', 'UTILITY_METER_STATEMENTS_SUM_FACILITY_ID_ASC', 'UTILITY_METER_STATEMENTS_SUM_FACILITY_ID_DESC', 'UTILITY_METER_STATEMENTS_SUM_IS_VALIDATED_ASC', 'UTILITY_METER_STATEMENTS_SUM_IS_VALIDATED_DESC', 'UTILITY_METER_STATEMENTS_SUM_METER_END_DATE_SET_ASC', 'UTILITY_METER_STATEMENTS_SUM_METER_END_DATE_SET_DESC', 'UTILITY_METER_STATEMENTS_SUM_METER_LABEL_ASC', 'UTILITY_METER_STATEMENTS_SUM_METER_LABEL_DESC', 'UTILITY_METER_STATEMENTS_SUM_METER_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENTS_SUM_METER_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENTS_SUM_PROVIDER_ASC', 'UTILITY_METER_STATEMENTS_SUM_PROVIDER_DESC', 'UTILITY_METER_STATEMENTS_SUM_SERVICE_TYPE_ASC', 'UTILITY_METER_STATEMENTS_SUM_SERVICE_TYPE_DESC', 'UTILITY_METER_STATEMENTS_SUM_START_DATE_ASC', 'UTILITY_METER_STATEMENTS_SUM_START_DATE_DESC', 'UTILITY_METER_STATEMENTS_SUM_STATEMENT_MONTH_ASC', 'UTILITY_METER_STATEMENTS_SUM_STATEMENT_MONTH_DESC', 'UTILITY_METER_STATEMENTS_SUM_STATEMENT_YEAR_ASC', 'UTILITY_METER_STATEMENTS_SUM_STATEMENT_YEAR_DESC', 'UTILITY_METER_STATEMENTS_SUM_USAGE_UNITS_ASC', 'UTILITY_METER_STATEMENTS_SUM_USAGE_UNITS_DESC', 'UTILITY_METER_STATEMENTS_SUM_UTILITY_ACCOUNT_ID_ASC', 'UTILITY_METER_STATEMENTS_SUM_UTILITY_ACCOUNT_ID_DESC', 'UTILITY_METER_STATEMENTS_SUM_UTILITY_METER_ID_ASC', 'UTILITY_METER_STATEMENTS_SUM_UTILITY_METER_ID_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_ACCOUNT_LABEL_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_ACCOUNT_LABEL_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_ACCOUNT_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_ACCOUNT_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_BILL_ARRIVAL_DATE_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_BILL_ARRIVAL_DATE_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_CURRENCY_CODE_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_CURRENCY_CODE_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_DAYS_IN_BILL_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_DAYS_IN_BILL_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_DEMAND_UNITS_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_DEMAND_UNITS_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_END_DATE_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_END_DATE_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_EXCLUDE_USAGE_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_EXCLUDE_USAGE_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_FACILITY_ID_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_FACILITY_ID_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_IS_VALIDATED_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_IS_VALIDATED_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_METER_END_DATE_SET_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_METER_END_DATE_SET_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_METER_LABEL_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_METER_LABEL_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_METER_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_METER_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_PROVIDER_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_PROVIDER_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_SERVICE_TYPE_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_SERVICE_TYPE_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_START_DATE_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_START_DATE_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_STATEMENT_MONTH_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_STATEMENT_MONTH_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_STATEMENT_YEAR_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_STATEMENT_YEAR_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_USAGE_UNITS_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_USAGE_UNITS_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_UTILITY_ACCOUNT_ID_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_UTILITY_ACCOUNT_ID_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_UTILITY_METER_ID_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_UTILITY_METER_ID_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_ACCOUNT_LABEL_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_ACCOUNT_LABEL_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_ACCOUNT_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_ACCOUNT_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_BILL_ARRIVAL_DATE_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_BILL_ARRIVAL_DATE_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_CURRENCY_CODE_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_CURRENCY_CODE_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_DAYS_IN_BILL_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_DAYS_IN_BILL_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_DEMAND_UNITS_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_DEMAND_UNITS_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_END_DATE_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_END_DATE_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_EXCLUDE_USAGE_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_EXCLUDE_USAGE_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_FACILITY_ID_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_FACILITY_ID_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_IS_VALIDATED_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_IS_VALIDATED_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_METER_END_DATE_SET_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_METER_END_DATE_SET_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_METER_LABEL_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_METER_LABEL_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_METER_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_METER_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_PROVIDER_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_PROVIDER_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_SERVICE_TYPE_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_SERVICE_TYPE_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_START_DATE_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_START_DATE_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_STATEMENT_MONTH_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_STATEMENT_MONTH_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_STATEMENT_YEAR_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_STATEMENT_YEAR_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_USAGE_UNITS_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_USAGE_UNITS_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_UTILITY_ACCOUNT_ID_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_UTILITY_ACCOUNT_ID_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_UTILITY_METER_ID_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_UTILITY_METER_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_ACCOUNT_LABEL_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_ACCOUNT_LABEL_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_ACCOUNT_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_ACCOUNT_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_BILL_ARRIVAL_DATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_BILL_ARRIVAL_DATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_BILL_COST_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_BILL_COST_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_BILL_DEMAND_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_BILL_DEMAND_COST_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_BILL_DEMAND_COST_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_BILL_DEMAND_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_BILL_USAGE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_BILL_USAGE_COST_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_BILL_USAGE_COST_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_BILL_USAGE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_BLENDED_RATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_BLENDED_RATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_CREDITS_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_CREDITS_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_CURRENCY_CODE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_CURRENCY_CODE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_DAYS_IN_BILL_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_DAYS_IN_BILL_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_DEMAND_UNITS_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_DEMAND_UNITS_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_END_DATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_END_DATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_FACILITY_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_FACILITY_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_FEES_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_FEES_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_IS_VALIDATED_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_IS_VALIDATED_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_LOAD_FACTOR_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_LOAD_FACTOR_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_METER_END_DATE_SET_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_METER_END_DATE_SET_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_METER_LABEL_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_METER_LABEL_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_METER_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_METER_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_NET_BILL_USAGE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_NET_BILL_USAGE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_PERCENT_CHANGE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_PERCENT_CHANGE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_PROVIDER_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_PROVIDER_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_SERVICE_TYPE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_SERVICE_TYPE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_START_DATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_START_DATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_STATEMENT_MONTH_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_STATEMENT_MONTH_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_STATEMENT_YEAR_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_STATEMENT_YEAR_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_TAXES_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_TAXES_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_USAGE_UNITS_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_USAGE_UNITS_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_UTILITY_ACCOUNT_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_UTILITY_ACCOUNT_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_UTILITY_METER_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_UTILITY_METER_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_COUNT_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_COUNT_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_ACCOUNT_LABEL_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_ACCOUNT_LABEL_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_ACCOUNT_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_ACCOUNT_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_BILL_ARRIVAL_DATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_BILL_ARRIVAL_DATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_BILL_COST_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_BILL_COST_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_BILL_DEMAND_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_BILL_DEMAND_COST_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_BILL_DEMAND_COST_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_BILL_DEMAND_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_BILL_USAGE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_BILL_USAGE_COST_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_BILL_USAGE_COST_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_BILL_USAGE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_BLENDED_RATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_BLENDED_RATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_ACCOUNT_LABEL_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_ACCOUNT_LABEL_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_ACCOUNT_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_ACCOUNT_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_BILL_ARRIVAL_DATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_BILL_ARRIVAL_DATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_BILL_COST_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_BILL_COST_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_BILL_DEMAND_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_BILL_DEMAND_COST_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_BILL_DEMAND_COST_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_BILL_DEMAND_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_BILL_USAGE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_BILL_USAGE_COST_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_BILL_USAGE_COST_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_BILL_USAGE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_BLENDED_RATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_BLENDED_RATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_CREDITS_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_CREDITS_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_CURRENCY_CODE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_CURRENCY_CODE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_DAYS_IN_BILL_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_DAYS_IN_BILL_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_DEMAND_UNITS_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_DEMAND_UNITS_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_END_DATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_END_DATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_FACILITY_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_FACILITY_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_FEES_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_FEES_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_IS_VALIDATED_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_IS_VALIDATED_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_LOAD_FACTOR_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_LOAD_FACTOR_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_METER_END_DATE_SET_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_METER_END_DATE_SET_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_METER_LABEL_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_METER_LABEL_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_METER_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_METER_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_NET_BILL_USAGE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_NET_BILL_USAGE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_PERCENT_CHANGE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_PERCENT_CHANGE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_PROVIDER_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_PROVIDER_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_SERVICE_TYPE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_SERVICE_TYPE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_START_DATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_START_DATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_STATEMENT_MONTH_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_STATEMENT_MONTH_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_STATEMENT_YEAR_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_STATEMENT_YEAR_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_TAXES_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_TAXES_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_USAGE_UNITS_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_USAGE_UNITS_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_UTILITY_ACCOUNT_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_UTILITY_ACCOUNT_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_UTILITY_METER_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_UTILITY_METER_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_CREDITS_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_CREDITS_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_CURRENCY_CODE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_CURRENCY_CODE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_DAYS_IN_BILL_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_DAYS_IN_BILL_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_DEMAND_UNITS_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_DEMAND_UNITS_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_END_DATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_END_DATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_FACILITY_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_FACILITY_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_FEES_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_FEES_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_IS_VALIDATED_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_IS_VALIDATED_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_LOAD_FACTOR_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_LOAD_FACTOR_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_METER_END_DATE_SET_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_METER_END_DATE_SET_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_METER_LABEL_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_METER_LABEL_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_METER_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_METER_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_NET_BILL_USAGE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_NET_BILL_USAGE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_PERCENT_CHANGE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_PERCENT_CHANGE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_PROVIDER_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_PROVIDER_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_SERVICE_TYPE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_SERVICE_TYPE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_START_DATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_START_DATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_STATEMENT_MONTH_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_STATEMENT_MONTH_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_STATEMENT_YEAR_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_STATEMENT_YEAR_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_TAXES_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_TAXES_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_USAGE_UNITS_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_USAGE_UNITS_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_UTILITY_ACCOUNT_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_UTILITY_ACCOUNT_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_UTILITY_METER_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_UTILITY_METER_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_ACCOUNT_LABEL_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_ACCOUNT_LABEL_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_ACCOUNT_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_ACCOUNT_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_BILL_ARRIVAL_DATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_BILL_ARRIVAL_DATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_BILL_COST_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_BILL_COST_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_BILL_DEMAND_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_BILL_DEMAND_COST_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_BILL_DEMAND_COST_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_BILL_DEMAND_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_BILL_USAGE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_BILL_USAGE_COST_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_BILL_USAGE_COST_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_BILL_USAGE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_BLENDED_RATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_BLENDED_RATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_CREDITS_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_CREDITS_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_CURRENCY_CODE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_CURRENCY_CODE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_DAYS_IN_BILL_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_DAYS_IN_BILL_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_DEMAND_UNITS_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_DEMAND_UNITS_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_END_DATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_END_DATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_FACILITY_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_FACILITY_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_FEES_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_FEES_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_IS_VALIDATED_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_IS_VALIDATED_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_LOAD_FACTOR_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_LOAD_FACTOR_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_METER_END_DATE_SET_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_METER_END_DATE_SET_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_METER_LABEL_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_METER_LABEL_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_METER_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_METER_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_NET_BILL_USAGE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_NET_BILL_USAGE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_PERCENT_CHANGE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_PERCENT_CHANGE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_PROVIDER_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_PROVIDER_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_SERVICE_TYPE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_SERVICE_TYPE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_START_DATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_START_DATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_STATEMENT_MONTH_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_STATEMENT_MONTH_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_STATEMENT_YEAR_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_STATEMENT_YEAR_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_TAXES_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_TAXES_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_USAGE_UNITS_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_USAGE_UNITS_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_UTILITY_ACCOUNT_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_UTILITY_ACCOUNT_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_UTILITY_METER_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_UTILITY_METER_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_ACCOUNT_LABEL_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_ACCOUNT_LABEL_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_ACCOUNT_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_ACCOUNT_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_BILL_ARRIVAL_DATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_BILL_ARRIVAL_DATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_BILL_COST_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_BILL_COST_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_BILL_DEMAND_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_BILL_DEMAND_COST_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_BILL_DEMAND_COST_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_BILL_DEMAND_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_BILL_USAGE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_BILL_USAGE_COST_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_BILL_USAGE_COST_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_BILL_USAGE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_BLENDED_RATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_BLENDED_RATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_CREDITS_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_CREDITS_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_CURRENCY_CODE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_CURRENCY_CODE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_DAYS_IN_BILL_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_DAYS_IN_BILL_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_DEMAND_UNITS_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_DEMAND_UNITS_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_END_DATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_END_DATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_FACILITY_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_FACILITY_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_FEES_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_FEES_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_IS_VALIDATED_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_IS_VALIDATED_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_LOAD_FACTOR_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_LOAD_FACTOR_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_METER_END_DATE_SET_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_METER_END_DATE_SET_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_METER_LABEL_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_METER_LABEL_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_METER_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_METER_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_NET_BILL_USAGE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_NET_BILL_USAGE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_PERCENT_CHANGE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_PERCENT_CHANGE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_PROVIDER_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_PROVIDER_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_SERVICE_TYPE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_SERVICE_TYPE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_START_DATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_START_DATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_STATEMENT_MONTH_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_STATEMENT_MONTH_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_STATEMENT_YEAR_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_STATEMENT_YEAR_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_TAXES_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_TAXES_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_USAGE_UNITS_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_USAGE_UNITS_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_UTILITY_ACCOUNT_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_UTILITY_ACCOUNT_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_UTILITY_METER_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_UTILITY_METER_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_ACCOUNT_LABEL_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_ACCOUNT_LABEL_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_ACCOUNT_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_ACCOUNT_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_BILL_ARRIVAL_DATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_BILL_ARRIVAL_DATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_BILL_COST_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_BILL_COST_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_BILL_DEMAND_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_BILL_DEMAND_COST_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_BILL_DEMAND_COST_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_BILL_DEMAND_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_BILL_USAGE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_BILL_USAGE_COST_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_BILL_USAGE_COST_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_BILL_USAGE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_BLENDED_RATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_BLENDED_RATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_CREDITS_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_CREDITS_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_CURRENCY_CODE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_CURRENCY_CODE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_DAYS_IN_BILL_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_DAYS_IN_BILL_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_DEMAND_UNITS_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_DEMAND_UNITS_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_END_DATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_END_DATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_FACILITY_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_FACILITY_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_FEES_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_FEES_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_IS_VALIDATED_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_IS_VALIDATED_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_LOAD_FACTOR_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_LOAD_FACTOR_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_METER_END_DATE_SET_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_METER_END_DATE_SET_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_METER_LABEL_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_METER_LABEL_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_METER_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_METER_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_NET_BILL_USAGE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_NET_BILL_USAGE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_PERCENT_CHANGE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_PERCENT_CHANGE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_PROVIDER_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_PROVIDER_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_SERVICE_TYPE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_SERVICE_TYPE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_START_DATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_START_DATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_STATEMENT_MONTH_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_STATEMENT_MONTH_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_STATEMENT_YEAR_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_STATEMENT_YEAR_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_TAXES_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_TAXES_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_USAGE_UNITS_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_USAGE_UNITS_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_UTILITY_ACCOUNT_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_UTILITY_ACCOUNT_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_UTILITY_METER_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_UTILITY_METER_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_ACCOUNT_LABEL_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_ACCOUNT_LABEL_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_ACCOUNT_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_ACCOUNT_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_BILL_ARRIVAL_DATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_BILL_ARRIVAL_DATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_BILL_COST_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_BILL_COST_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_BILL_DEMAND_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_BILL_DEMAND_COST_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_BILL_DEMAND_COST_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_BILL_DEMAND_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_BILL_USAGE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_BILL_USAGE_COST_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_BILL_USAGE_COST_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_BILL_USAGE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_BLENDED_RATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_BLENDED_RATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_CREDITS_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_CREDITS_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_CURRENCY_CODE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_CURRENCY_CODE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_DAYS_IN_BILL_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_DAYS_IN_BILL_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_DEMAND_UNITS_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_DEMAND_UNITS_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_END_DATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_END_DATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_FACILITY_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_FACILITY_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_FEES_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_FEES_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_IS_VALIDATED_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_IS_VALIDATED_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_LOAD_FACTOR_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_LOAD_FACTOR_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_METER_END_DATE_SET_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_METER_END_DATE_SET_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_METER_LABEL_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_METER_LABEL_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_METER_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_METER_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_NET_BILL_USAGE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_NET_BILL_USAGE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_PERCENT_CHANGE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_PERCENT_CHANGE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_PROVIDER_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_PROVIDER_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_SERVICE_TYPE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_SERVICE_TYPE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_START_DATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_START_DATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_STATEMENT_MONTH_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_STATEMENT_MONTH_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_STATEMENT_YEAR_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_STATEMENT_YEAR_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_TAXES_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_TAXES_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_USAGE_UNITS_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_USAGE_UNITS_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_UTILITY_ACCOUNT_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_UTILITY_ACCOUNT_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_UTILITY_METER_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_UTILITY_METER_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_ACCOUNT_LABEL_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_ACCOUNT_LABEL_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_ACCOUNT_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_ACCOUNT_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_BILL_ARRIVAL_DATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_BILL_ARRIVAL_DATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_BILL_COST_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_BILL_COST_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_BILL_DEMAND_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_BILL_DEMAND_COST_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_BILL_DEMAND_COST_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_BILL_DEMAND_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_BILL_USAGE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_BILL_USAGE_COST_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_BILL_USAGE_COST_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_BILL_USAGE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_BLENDED_RATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_BLENDED_RATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_CREDITS_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_CREDITS_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_CURRENCY_CODE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_CURRENCY_CODE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_DAYS_IN_BILL_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_DAYS_IN_BILL_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_DEMAND_UNITS_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_DEMAND_UNITS_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_END_DATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_END_DATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_FACILITY_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_FACILITY_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_FEES_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_FEES_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_IS_VALIDATED_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_IS_VALIDATED_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_LOAD_FACTOR_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_LOAD_FACTOR_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_METER_END_DATE_SET_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_METER_END_DATE_SET_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_METER_LABEL_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_METER_LABEL_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_METER_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_METER_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_NET_BILL_USAGE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_NET_BILL_USAGE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_PERCENT_CHANGE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_PERCENT_CHANGE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_PROVIDER_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_PROVIDER_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_SERVICE_TYPE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_SERVICE_TYPE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_START_DATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_START_DATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_STATEMENT_MONTH_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_STATEMENT_MONTH_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_STATEMENT_YEAR_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_STATEMENT_YEAR_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_TAXES_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_TAXES_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_USAGE_UNITS_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_USAGE_UNITS_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_UTILITY_ACCOUNT_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_UTILITY_ACCOUNT_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_UTILITY_METER_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_UTILITY_METER_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_ACCOUNT_LABEL_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_ACCOUNT_LABEL_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_ACCOUNT_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_ACCOUNT_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_BILL_ARRIVAL_DATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_BILL_ARRIVAL_DATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_BILL_COST_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_BILL_COST_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_BILL_DEMAND_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_BILL_DEMAND_COST_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_BILL_DEMAND_COST_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_BILL_DEMAND_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_BILL_USAGE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_BILL_USAGE_COST_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_BILL_USAGE_COST_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_BILL_USAGE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_BLENDED_RATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_BLENDED_RATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_CREDITS_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_CREDITS_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_CURRENCY_CODE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_CURRENCY_CODE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_DAYS_IN_BILL_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_DAYS_IN_BILL_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_DEMAND_UNITS_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_DEMAND_UNITS_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_END_DATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_END_DATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_FACILITY_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_FACILITY_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_FEES_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_FEES_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_IS_VALIDATED_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_IS_VALIDATED_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_LOAD_FACTOR_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_LOAD_FACTOR_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_METER_END_DATE_SET_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_METER_END_DATE_SET_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_METER_LABEL_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_METER_LABEL_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_METER_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_METER_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_NET_BILL_USAGE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_NET_BILL_USAGE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_PERCENT_CHANGE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_PERCENT_CHANGE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_PROVIDER_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_PROVIDER_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_SERVICE_TYPE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_SERVICE_TYPE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_START_DATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_START_DATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_STATEMENT_MONTH_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_STATEMENT_MONTH_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_STATEMENT_YEAR_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_STATEMENT_YEAR_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_TAXES_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_TAXES_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_USAGE_UNITS_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_USAGE_UNITS_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_UTILITY_ACCOUNT_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_UTILITY_ACCOUNT_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_UTILITY_METER_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_UTILITY_METER_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_ACCOUNT_LABEL_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_ACCOUNT_LABEL_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_ACCOUNT_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_ACCOUNT_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_BILL_ARRIVAL_DATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_BILL_ARRIVAL_DATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_BILL_COST_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_BILL_COST_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_BILL_DEMAND_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_BILL_DEMAND_COST_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_BILL_DEMAND_COST_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_BILL_DEMAND_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_BILL_USAGE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_BILL_USAGE_COST_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_BILL_USAGE_COST_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_BILL_USAGE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_BLENDED_RATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_BLENDED_RATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_CREDITS_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_CREDITS_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_CURRENCY_CODE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_CURRENCY_CODE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_DAYS_IN_BILL_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_DAYS_IN_BILL_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_DEMAND_UNITS_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_DEMAND_UNITS_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_END_DATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_END_DATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_FACILITY_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_FACILITY_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_FEES_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_FEES_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_IS_VALIDATED_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_IS_VALIDATED_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_LOAD_FACTOR_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_LOAD_FACTOR_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_METER_END_DATE_SET_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_METER_END_DATE_SET_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_METER_LABEL_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_METER_LABEL_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_METER_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_METER_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_NET_BILL_USAGE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_NET_BILL_USAGE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_PERCENT_CHANGE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_PERCENT_CHANGE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_PROVIDER_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_PROVIDER_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_SERVICE_TYPE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_SERVICE_TYPE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_START_DATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_START_DATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_STATEMENT_MONTH_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_STATEMENT_MONTH_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_STATEMENT_YEAR_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_STATEMENT_YEAR_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_TAXES_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_TAXES_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_USAGE_UNITS_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_USAGE_UNITS_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_UTILITY_ACCOUNT_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_UTILITY_ACCOUNT_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_UTILITY_METER_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_UTILITY_METER_ID_DESC', 'WMS_ASC', 'WMS_DESC', 'ZIP_ASC', 'ZIP_DESC')


class FacilityCommunicationsOrderBy(sgqlc.types.Enum):
    __schema__ = nionic_schema
    __choices__ = ('CLEARED_AT_ASC', 'CLEARED_AT_DESC', 'CREATED_AT_ASC', 'CREATED_AT_DESC', 'FACILITY_ID_ASC', 'FACILITY_ID_DESC', 'ID_ASC', 'ID_DESC', 'MESSAGE_ASC', 'MESSAGE_DESC', 'NATURAL', 'PRIMARY_KEY_ASC', 'PRIMARY_KEY_DESC', 'UPDATED_AT_ASC', 'UPDATED_AT_DESC')


class FacilityConfigsOrderBy(sgqlc.types.Enum):
    __schema__ = nionic_schema
    __choices__ = ('CREATED_AT_ASC', 'CREATED_AT_DESC', 'FACILITY_ID_ASC', 'FACILITY_ID_DESC', 'ID_ASC', 'ID_DESC', 'KEY_ASC', 'KEY_DESC', 'NATURAL', 'PRIMARY_KEY_ASC', 'PRIMARY_KEY_DESC', 'UPDATED_AT_ASC', 'UPDATED_AT_DESC', 'VALUE_ASC', 'VALUE_DESC')


class FacilityDataSourcesOrderBy(sgqlc.types.Enum):
    __schema__ = nionic_schema
    __choices__ = ('DATA_SOURCE_NAME_ASC', 'DATA_SOURCE_NAME_DESC', 'FACILITY_ID_ASC', 'FACILITY_ID_DESC', 'NATURAL', 'PRIMARY_KEY_ASC', 'PRIMARY_KEY_DESC')


class FacilityGroupsLinkersOrderBy(sgqlc.types.Enum):
    __schema__ = nionic_schema
    __choices__ = ('FACILITY_GROUPING_ID_ASC', 'FACILITY_GROUPING_ID_DESC', 'FACILITY_ID_ASC', 'FACILITY_ID_DESC', 'NATURAL', 'PRIMARY_KEY_ASC', 'PRIMARY_KEY_DESC')


class FacilityGroupsOrderBy(sgqlc.types.Enum):
    __schema__ = nionic_schema
    __choices__ = ('ID_ASC', 'ID_DESC', 'NAME_ASC', 'NAME_DESC', 'NATURAL', 'PARENT_ID_ASC', 'PARENT_ID_DESC', 'PRIMARY_KEY_ASC', 'PRIMARY_KEY_DESC')


class FacilityTaggedDataPointsOrderBy(sgqlc.types.Enum):
    __schema__ = nionic_schema
    __choices__ = ('CREATED_AT_ASC', 'CREATED_AT_DESC', 'DATA_POINT_ID_ASC', 'DATA_POINT_ID_DESC', 'FACILITY_ID_ASC', 'FACILITY_ID_DESC', 'ID_ASC', 'ID_DESC', 'NAME_ASC', 'NAME_DESC', 'NATURAL', 'PRIMARY_KEY_ASC', 'PRIMARY_KEY_DESC', 'TAG_ID_ASC', 'TAG_ID_DESC', 'UPDATED_AT_ASC', 'UPDATED_AT_DESC')


Float = sgqlc.types.Float

class GeoJSON(sgqlc.types.Scalar):
    __schema__ = nionic_schema


class Geometry(sgqlc.types.Scalar):
    __schema__ = nionic_schema


ID = sgqlc.types.ID

Int = sgqlc.types.Int

class JSON(sgqlc.types.Scalar):
    __schema__ = nionic_schema


class MachineUsersOrderBy(sgqlc.types.Enum):
    __schema__ = nionic_schema
    __choices__ = ('CREATED_AT_ASC', 'CREATED_AT_DESC', 'CREATED_BY_ASC', 'CREATED_BY_DESC', 'DESCRIPTION_ASC', 'DESCRIPTION_DESC', 'ID_ASC', 'ID_DESC', 'NATURAL', 'PRIMARY_KEY_ASC', 'PRIMARY_KEY_DESC', 'UPDATED_AT_ASC', 'UPDATED_AT_DESC')


class MainServicesOrderBy(sgqlc.types.Enum):
    __schema__ = nionic_schema
    __choices__ = ('CREATED_AT_ASC', 'CREATED_AT_DESC', 'DEMAND_DATA_POINT_ID_ASC', 'DEMAND_DATA_POINT_ID_DESC', 'EXCLUDE_CARBON_ASC', 'EXCLUDE_CARBON_DESC', 'FACILITY_ID_ASC', 'FACILITY_ID_DESC', 'GRID_DEMAND_DATA_POINT_ID_ASC', 'GRID_DEMAND_DATA_POINT_ID_DESC', 'GRID_USAGE_DATA_POINT_ID_ASC', 'GRID_USAGE_DATA_POINT_ID_DESC', 'ID_ASC', 'ID_DESC', 'METER_DEMAND_DATA_POINT_ID_ASC', 'METER_DEMAND_DATA_POINT_ID_DESC', 'METER_USAGE_DATA_POINT_ID_ASC', 'METER_USAGE_DATA_POINT_ID_DESC', 'NAME_ASC', 'NAME_DESC', 'NATURAL', 'PRIMARY_KEY_ASC', 'PRIMARY_KEY_DESC', 'TYPE_ASC', 'TYPE_DESC', 'UPDATED_AT_ASC', 'UPDATED_AT_DESC', 'USAGE_DATA_POINT_ID_ASC', 'USAGE_DATA_POINT_ID_DESC')


class MainServicesType(sgqlc.types.Enum):
    __schema__ = nionic_schema
    __choices__ = ('AIRFLOW_ELECTRIC_HIGH', 'AIRFLOW_ELECTRIC_LOW', 'AIRFLOW_HIGH', 'AIRFLOW_LOW', 'ELECTRIC', 'GAS', 'SOLAR', 'WATER')


class MeterChargesOrderBy(sgqlc.types.Enum):
    __schema__ = nionic_schema
    __choices__ = ('CATEGORY_ASC', 'CATEGORY_DESC', 'CREATED_AT_ASC', 'CREATED_AT_DESC', 'DELETED_AT_ASC', 'DELETED_AT_DESC', 'ID_ASC', 'ID_DESC', 'LABEL_ASC', 'LABEL_DESC', 'LINE_NUMBER_ASC', 'LINE_NUMBER_DESC', 'METER_STATEMENT_ID_ASC', 'METER_STATEMENT_ID_DESC', 'NATURAL', 'NORMALIZED_VALUE_ASC', 'NORMALIZED_VALUE_DESC', 'OVERRIDE_AT_ASC', 'OVERRIDE_AT_DESC', 'OVERRIDE_LABEL_ASC', 'OVERRIDE_LABEL_DESC', 'OVERRIDE_VALUE_ASC', 'OVERRIDE_VALUE_DESC', 'PRIMARY_KEY_ASC', 'PRIMARY_KEY_DESC', 'UPDATED_AT_ASC', 'UPDATED_AT_DESC', 'VALUE_ASC', 'VALUE_DESC')


class MeterStatementHistoriesOrderBy(sgqlc.types.Enum):
    __schema__ = nionic_schema
    __choices__ = ('CREATED_AT_ASC', 'CREATED_AT_DESC', 'DESCRIPTION_ASC', 'DESCRIPTION_DESC', 'METER_STATEMENT_ID_ASC', 'METER_STATEMENT_ID_DESC', 'NATURAL')


class MeterStatementsOrderBy(sgqlc.types.Enum):
    __schema__ = nionic_schema
    __choices__ = ('ACCOUNT_STATEMENT_ID_ASC', 'ACCOUNT_STATEMENT_ID_DESC', 'ACCOUNT_STATEMENT_PDF_ID_ASC', 'ACCOUNT_STATEMENT_PDF_ID_DESC', 'CREATED_AT_ASC', 'CREATED_AT_DESC', 'CURRENCY_CODE_ASC', 'CURRENCY_CODE_DESC', 'DELETED_AT_ASC', 'DELETED_AT_DESC', 'ID_ASC', 'ID_DESC', 'INTEGRATION_KEY_ASC', 'INTEGRATION_KEY_DESC', 'INTERVAL_END_ASC', 'INTERVAL_END_DESC', 'INTERVAL_START_ASC', 'INTERVAL_START_DESC', 'IS_ADJUSTMENT_ASC', 'IS_ADJUSTMENT_DESC', 'IS_VALIDATED_ASC', 'IS_VALIDATED_DESC', 'MANUAL_UPLOAD_ASC', 'MANUAL_UPLOAD_DESC', 'METADATA_ASC', 'METADATA_DESC', 'NATURAL', 'NORMALIZED_CURRENCY_CODE_ASC', 'NORMALIZED_CURRENCY_CODE_DESC', 'OVERRIDE_AT_ASC', 'OVERRIDE_AT_DESC', 'OVERRIDE_CURRENCY_CODE_ASC', 'OVERRIDE_CURRENCY_CODE_DESC', 'OVERRIDE_PRIMARY_DEMAND_UNITS_ASC', 'OVERRIDE_PRIMARY_DEMAND_UNITS_DESC', 'OVERRIDE_PRIMARY_USAGE_UNITS_ASC', 'OVERRIDE_PRIMARY_USAGE_UNITS_DESC', 'OVERRIDE_STATEMENT_MONTH_ASC', 'OVERRIDE_STATEMENT_MONTH_DESC', 'OVERRIDE_STATEMENT_YEAR_ASC', 'OVERRIDE_STATEMENT_YEAR_DESC', 'PRIMARY_DEMAND_UNITS_ASC', 'PRIMARY_DEMAND_UNITS_DESC', 'PRIMARY_KEY_ASC', 'PRIMARY_KEY_DESC', 'PRIMARY_USAGE_UNITS_ASC', 'PRIMARY_USAGE_UNITS_DESC', 'STATEMENT_DATE_ASC', 'STATEMENT_DATE_DESC', 'UPDATED_AT_ASC', 'UPDATED_AT_DESC', 'UTILITY_METER_ID_ASC', 'UTILITY_METER_ID_DESC')


class MeterUsagesOrderBy(sgqlc.types.Enum):
    __schema__ = nionic_schema
    __choices__ = ('CATEGORY_ASC', 'CATEGORY_DESC', 'CREATED_AT_ASC', 'CREATED_AT_DESC', 'DELETED_AT_ASC', 'DELETED_AT_DESC', 'ID_ASC', 'ID_DESC', 'LABEL_ASC', 'LABEL_DESC', 'LINE_NUMBER_ASC', 'LINE_NUMBER_DESC', 'METADATA_ASC', 'METADATA_DESC', 'METER_STATEMENT_ID_ASC', 'METER_STATEMENT_ID_DESC', 'NATURAL', 'OVERRIDE_AT_ASC', 'OVERRIDE_AT_DESC', 'OVERRIDE_LABEL_ASC', 'OVERRIDE_LABEL_DESC', 'OVERRIDE_UNITS_ASC', 'OVERRIDE_UNITS_DESC', 'OVERRIDE_VALUE_ASC', 'OVERRIDE_VALUE_DESC', 'PRIMARY_KEY_ASC', 'PRIMARY_KEY_DESC', 'UNITS_ASC', 'UNITS_DESC', 'UPDATED_AT_ASC', 'UPDATED_AT_DESC', 'VALUE_ASC', 'VALUE_DESC')


class MetricDataAggregationMethod(sgqlc.types.Enum):
    __schema__ = nionic_schema
    __choices__ = ('AVG', 'COUNT', 'FIRST', 'LAST', 'MAX', 'MEDIAN', 'MIN', 'SUM')


class MetricDataOrderBy(sgqlc.types.Enum):
    __schema__ = nionic_schema
    __choices__ = ('TIME_ASC', 'TIME_DESC')


class MetricDatatype(sgqlc.types.Enum):
    __schema__ = nionic_schema
    __choices__ = ('BOOLEAN', 'FLOAT', 'INT', 'LONG', 'NUMERIC', 'TEXT')


class MetricMetadataOrderBy(sgqlc.types.Enum):
    __schema__ = nionic_schema
    __choices__ = ('CREATED_AT_ASC', 'CREATED_AT_DESC', 'DATA_TYPE_ASC', 'DATA_TYPE_DESC', 'EXPRESSION_ASC', 'EXPRESSION_DESC', 'HUMAN_LABEL_ASC', 'HUMAN_LABEL_DESC', 'IS_COMPOSITE_ASC', 'IS_COMPOSITE_DESC', 'IS_INTERNAL_ASC', 'IS_INTERNAL_DESC', 'IS_SPARSE_ASC', 'IS_SPARSE_DESC', 'LABEL_ASC', 'LABEL_DESC', 'NATURAL', 'PRIMARY_KEY_ASC', 'PRIMARY_KEY_DESC', 'TABLE_ASC', 'TABLE_DESC', 'UNIT_ASC', 'UNIT_DESC', 'UNIT_DIMENSION_ASC', 'UNIT_DIMENSION_DESC', 'UPDATED_AT_ASC', 'UPDATED_AT_DESC')


class ModuleExtension(sgqlc.types.Enum):
    __schema__ = nionic_schema
    __choices__ = ('etru_core', 'fleet', 'refrigeration', 'warehousing')


class MonitorDataPointsOrderBy(sgqlc.types.Enum):
    __schema__ = nionic_schema
    __choices__ = ('CREATED_AT_ASC', 'CREATED_AT_DESC', 'DATA_POINT_ID_ASC', 'DATA_POINT_ID_DESC', 'MONITOR_ID_ASC', 'MONITOR_ID_DESC', 'NATURAL', 'PRIMARY_KEY_ASC', 'PRIMARY_KEY_DESC')


class MonitorDetectionsGroupBy(sgqlc.types.Enum):
    __schema__ = nionic_schema
    __choices__ = ('CREATED_AT', 'CREATED_AT_DISTINCT', 'CREATED_AT_TRUNCATED_TO_DAY', 'CREATED_AT_TRUNCATED_TO_HOUR', 'END_TIME', 'END_TIME_DISTINCT', 'END_TIME_TRUNCATED_TO_DAY', 'END_TIME_TRUNCATED_TO_HOUR', 'MONITOR_ID', 'MONITOR_ID_DISTINCT', 'START_TIME', 'START_TIME_DISTINCT', 'START_TIME_TRUNCATED_TO_DAY', 'START_TIME_TRUNCATED_TO_HOUR', 'UPDATED_AT', 'UPDATED_AT_DISTINCT', 'UPDATED_AT_TRUNCATED_TO_DAY', 'UPDATED_AT_TRUNCATED_TO_HOUR')


class MonitorDetectionsOrderBy(sgqlc.types.Enum):
    __schema__ = nionic_schema
    __choices__ = ('CREATED_AT_ASC', 'CREATED_AT_DESC', 'END_TIME_ASC', 'END_TIME_DESC', 'ID_ASC', 'ID_DESC', 'MONITOR_ID_ASC', 'MONITOR_ID_DESC', 'NATURAL', 'PRIMARY_KEY_ASC', 'PRIMARY_KEY_DESC', 'START_TIME_ASC', 'START_TIME_DESC', 'UPDATED_AT_ASC', 'UPDATED_AT_DESC')


class MonitorResultOuput(sgqlc.types.Enum):
    __schema__ = nionic_schema
    __choices__ = ('CONDITION_MET', 'FULL_SERIES', 'INFLECTION_POINTS')


class MonitorType(sgqlc.types.Enum):
    __schema__ = nionic_schema
    __choices__ = ('THRESHOLD',)


class MonitorsOrderBy(sgqlc.types.Enum):
    __schema__ = nionic_schema
    __choices__ = ('AGGREGATION_METHOD_ASC', 'AGGREGATION_METHOD_DESC', 'CONDITION_ASC', 'CONDITION_DESC', 'CREATED_AT_ASC', 'CREATED_AT_DESC', 'DESCRIPTION_ASC', 'DESCRIPTION_DESC', 'DETECTIONS_AVERAGE_CREATED_AT_ASC', 'DETECTIONS_AVERAGE_CREATED_AT_DESC', 'DETECTIONS_AVERAGE_END_TIME_ASC', 'DETECTIONS_AVERAGE_END_TIME_DESC', 'DETECTIONS_AVERAGE_ID_ASC', 'DETECTIONS_AVERAGE_ID_DESC', 'DETECTIONS_AVERAGE_MONITOR_ID_ASC', 'DETECTIONS_AVERAGE_MONITOR_ID_DESC', 'DETECTIONS_AVERAGE_START_TIME_ASC', 'DETECTIONS_AVERAGE_START_TIME_DESC', 'DETECTIONS_AVERAGE_UPDATED_AT_ASC', 'DETECTIONS_AVERAGE_UPDATED_AT_DESC', 'DETECTIONS_COUNT_ASC', 'DETECTIONS_COUNT_DESC', 'DETECTIONS_DISTINCT_COUNT_CREATED_AT_ASC', 'DETECTIONS_DISTINCT_COUNT_CREATED_AT_DESC', 'DETECTIONS_DISTINCT_COUNT_END_TIME_ASC', 'DETECTIONS_DISTINCT_COUNT_END_TIME_DESC', 'DETECTIONS_DISTINCT_COUNT_ID_ASC', 'DETECTIONS_DISTINCT_COUNT_ID_DESC', 'DETECTIONS_DISTINCT_COUNT_MONITOR_ID_ASC', 'DETECTIONS_DISTINCT_COUNT_MONITOR_ID_DESC', 'DETECTIONS_DISTINCT_COUNT_START_TIME_ASC', 'DETECTIONS_DISTINCT_COUNT_START_TIME_DESC', 'DETECTIONS_DISTINCT_COUNT_UPDATED_AT_ASC', 'DETECTIONS_DISTINCT_COUNT_UPDATED_AT_DESC', 'DETECTIONS_DISTINCT_CREATED_AT_ASC', 'DETECTIONS_DISTINCT_CREATED_AT_DESC', 'DETECTIONS_DISTINCT_END_TIME_ASC', 'DETECTIONS_DISTINCT_END_TIME_DESC', 'DETECTIONS_DISTINCT_ID_ASC', 'DETECTIONS_DISTINCT_ID_DESC', 'DETECTIONS_DISTINCT_MONITOR_ID_ASC', 'DETECTIONS_DISTINCT_MONITOR_ID_DESC', 'DETECTIONS_DISTINCT_START_TIME_ASC', 'DETECTIONS_DISTINCT_START_TIME_DESC', 'DETECTIONS_DISTINCT_UPDATED_AT_ASC', 'DETECTIONS_DISTINCT_UPDATED_AT_DESC', 'DETECTIONS_MAX_CREATED_AT_ASC', 'DETECTIONS_MAX_CREATED_AT_DESC', 'DETECTIONS_MAX_END_TIME_ASC', 'DETECTIONS_MAX_END_TIME_DESC', 'DETECTIONS_MAX_ID_ASC', 'DETECTIONS_MAX_ID_DESC', 'DETECTIONS_MAX_MONITOR_ID_ASC', 'DETECTIONS_MAX_MONITOR_ID_DESC', 'DETECTIONS_MAX_START_TIME_ASC', 'DETECTIONS_MAX_START_TIME_DESC', 'DETECTIONS_MAX_UPDATED_AT_ASC', 'DETECTIONS_MAX_UPDATED_AT_DESC', 'DETECTIONS_MIN_CREATED_AT_ASC', 'DETECTIONS_MIN_CREATED_AT_DESC', 'DETECTIONS_MIN_END_TIME_ASC', 'DETECTIONS_MIN_END_TIME_DESC', 'DETECTIONS_MIN_ID_ASC', 'DETECTIONS_MIN_ID_DESC', 'DETECTIONS_MIN_MONITOR_ID_ASC', 'DETECTIONS_MIN_MONITOR_ID_DESC', 'DETECTIONS_MIN_START_TIME_ASC', 'DETECTIONS_MIN_START_TIME_DESC', 'DETECTIONS_MIN_UPDATED_AT_ASC', 'DETECTIONS_MIN_UPDATED_AT_DESC', 'DETECTIONS_STDDEV_POPULATION_CREATED_AT_ASC', 'DETECTIONS_STDDEV_POPULATION_CREATED_AT_DESC', 'DETECTIONS_STDDEV_POPULATION_END_TIME_ASC', 'DETECTIONS_STDDEV_POPULATION_END_TIME_DESC', 'DETECTIONS_STDDEV_POPULATION_ID_ASC', 'DETECTIONS_STDDEV_POPULATION_ID_DESC', 'DETECTIONS_STDDEV_POPULATION_MONITOR_ID_ASC', 'DETECTIONS_STDDEV_POPULATION_MONITOR_ID_DESC', 'DETECTIONS_STDDEV_POPULATION_START_TIME_ASC', 'DETECTIONS_STDDEV_POPULATION_START_TIME_DESC', 'DETECTIONS_STDDEV_POPULATION_UPDATED_AT_ASC', 'DETECTIONS_STDDEV_POPULATION_UPDATED_AT_DESC', 'DETECTIONS_STDDEV_SAMPLE_CREATED_AT_ASC', 'DETECTIONS_STDDEV_SAMPLE_CREATED_AT_DESC', 'DETECTIONS_STDDEV_SAMPLE_END_TIME_ASC', 'DETECTIONS_STDDEV_SAMPLE_END_TIME_DESC', 'DETECTIONS_STDDEV_SAMPLE_ID_ASC', 'DETECTIONS_STDDEV_SAMPLE_ID_DESC', 'DETECTIONS_STDDEV_SAMPLE_MONITOR_ID_ASC', 'DETECTIONS_STDDEV_SAMPLE_MONITOR_ID_DESC', 'DETECTIONS_STDDEV_SAMPLE_START_TIME_ASC', 'DETECTIONS_STDDEV_SAMPLE_START_TIME_DESC', 'DETECTIONS_STDDEV_SAMPLE_UPDATED_AT_ASC', 'DETECTIONS_STDDEV_SAMPLE_UPDATED_AT_DESC', 'DETECTIONS_SUM_CREATED_AT_ASC', 'DETECTIONS_SUM_CREATED_AT_DESC', 'DETECTIONS_SUM_END_TIME_ASC', 'DETECTIONS_SUM_END_TIME_DESC', 'DETECTIONS_SUM_ID_ASC', 'DETECTIONS_SUM_ID_DESC', 'DETECTIONS_SUM_MONITOR_ID_ASC', 'DETECTIONS_SUM_MONITOR_ID_DESC', 'DETECTIONS_SUM_START_TIME_ASC', 'DETECTIONS_SUM_START_TIME_DESC', 'DETECTIONS_SUM_UPDATED_AT_ASC', 'DETECTIONS_SUM_UPDATED_AT_DESC', 'DETECTIONS_VARIANCE_POPULATION_CREATED_AT_ASC', 'DETECTIONS_VARIANCE_POPULATION_CREATED_AT_DESC', 'DETECTIONS_VARIANCE_POPULATION_END_TIME_ASC', 'DETECTIONS_VARIANCE_POPULATION_END_TIME_DESC', 'DETECTIONS_VARIANCE_POPULATION_ID_ASC', 'DETECTIONS_VARIANCE_POPULATION_ID_DESC', 'DETECTIONS_VARIANCE_POPULATION_MONITOR_ID_ASC', 'DETECTIONS_VARIANCE_POPULATION_MONITOR_ID_DESC', 'DETECTIONS_VARIANCE_POPULATION_START_TIME_ASC', 'DETECTIONS_VARIANCE_POPULATION_START_TIME_DESC', 'DETECTIONS_VARIANCE_POPULATION_UPDATED_AT_ASC', 'DETECTIONS_VARIANCE_POPULATION_UPDATED_AT_DESC', 'DETECTIONS_VARIANCE_SAMPLE_CREATED_AT_ASC', 'DETECTIONS_VARIANCE_SAMPLE_CREATED_AT_DESC', 'DETECTIONS_VARIANCE_SAMPLE_END_TIME_ASC', 'DETECTIONS_VARIANCE_SAMPLE_END_TIME_DESC', 'DETECTIONS_VARIANCE_SAMPLE_ID_ASC', 'DETECTIONS_VARIANCE_SAMPLE_ID_DESC', 'DETECTIONS_VARIANCE_SAMPLE_MONITOR_ID_ASC', 'DETECTIONS_VARIANCE_SAMPLE_MONITOR_ID_DESC', 'DETECTIONS_VARIANCE_SAMPLE_START_TIME_ASC', 'DETECTIONS_VARIANCE_SAMPLE_START_TIME_DESC', 'DETECTIONS_VARIANCE_SAMPLE_UPDATED_AT_ASC', 'DETECTIONS_VARIANCE_SAMPLE_UPDATED_AT_DESC', 'ID_ASC', 'ID_DESC', 'IS_ENABLED_ASC', 'IS_ENABLED_DESC', 'MONITOR_TYPE_ASC', 'MONITOR_TYPE_DESC', 'NAME_ASC', 'NAME_DESC', 'NATURAL', 'PRIMARY_KEY_ASC', 'PRIMARY_KEY_DESC', 'SAMPLING_WINDOW_ASC', 'SAMPLING_WINDOW_DESC', 'THRESHOLD_DURATION_ASC', 'THRESHOLD_DURATION_DESC', 'THRESHOLD_VALUE_ASC', 'THRESHOLD_VALUE_DESC', 'UPDATED_AT_ASC', 'UPDATED_AT_DESC', 'WINDOW_ASC', 'WINDOW_DESC')


class PlatformAccessTokensOrderBy(sgqlc.types.Enum):
    __schema__ = nionic_schema
    __choices__ = ('CREATED_AT_ASC', 'CREATED_AT_DESC', 'DESCRIPTION_ASC', 'DESCRIPTION_DESC', 'EXPIRES_AT_ASC', 'EXPIRES_AT_DESC', 'ID_ASC', 'ID_DESC', 'NATURAL', 'OWNER_ID_ASC', 'OWNER_ID_DESC', 'TYPE_ASC', 'TYPE_DESC')


class PlatformCapability(sgqlc.types.Enum):
    __schema__ = nionic_schema
    __choices__ = ('BASE', 'ETRU_CORE', 'FLEET', 'IOT', 'METRIC', 'SUGGESTION', 'UTILITY', 'WMS')


class PlatformError(sgqlc.types.Enum):
    __schema__ = nionic_schema
    __choices__ = ('BAD_DATA_ERROR', 'BAD_REQUEST_ERROR', 'DUPLICATE_ENTRY_ERROR', 'FLEET_SMS_ERROR', 'INCOMPATIBLE_DATA_ERROR', 'INTERNAL_ERROR', 'INVALID_INPUT_ERROR', 'INVALID_REPORT_PARAMETERS', 'NOT_FOUND_ERROR', 'REQUEST_LIMIT_ERROR', 'SMS_VALIDATION_ERROR', 'UNAUTHORIZED_ERROR', 'UNKNOWN_ERROR')


class PricingNodesOrderBy(sgqlc.types.Enum):
    __schema__ = nionic_schema
    __choices__ = ('BALANCING_AUTHORITY_ID_ASC', 'BALANCING_AUTHORITY_ID_DESC', 'CREATED_AT_ASC', 'CREATED_AT_DESC', 'FACILITIES_AVERAGE_ADDRESS_ASC', 'FACILITIES_AVERAGE_ADDRESS_DESC', 'FACILITIES_AVERAGE_BONUS_LTR_ASC', 'FACILITIES_AVERAGE_BONUS_LTR_DESC', 'FACILITIES_AVERAGE_CITY_ASC', 'FACILITIES_AVERAGE_CITY_DESC', 'FACILITIES_AVERAGE_COMMODITY_ASC', 'FACILITIES_AVERAGE_COMMODITY_DESC', 'FACILITIES_AVERAGE_COST_CENTER_ASC', 'FACILITIES_AVERAGE_COST_CENTER_DESC', 'FACILITIES_AVERAGE_COUNTRY_ASC', 'FACILITIES_AVERAGE_COUNTRY_DESC', 'FACILITIES_AVERAGE_CREATED_AT_ASC', 'FACILITIES_AVERAGE_CREATED_AT_DESC', 'FACILITIES_AVERAGE_CUSTOMER_LOCATION_ID_ASC', 'FACILITIES_AVERAGE_CUSTOMER_LOCATION_ID_DESC', 'FACILITIES_AVERAGE_FACILITY_CONTACTS_ASC', 'FACILITIES_AVERAGE_FACILITY_CONTACTS_DESC', 'FACILITIES_AVERAGE_GEOMETRY_ASC', 'FACILITIES_AVERAGE_GEOMETRY_DESC', 'FACILITIES_AVERAGE_GO_LIVE_DATE_ASC', 'FACILITIES_AVERAGE_GO_LIVE_DATE_DESC', 'FACILITIES_AVERAGE_ID_ASC', 'FACILITIES_AVERAGE_ID_DESC', 'FACILITIES_AVERAGE_LATITUDE_ASC', 'FACILITIES_AVERAGE_LATITUDE_DESC', 'FACILITIES_AVERAGE_LINK_ACTIVE_ASC', 'FACILITIES_AVERAGE_LINK_ACTIVE_DESC', 'FACILITIES_AVERAGE_LONGITUDE_ASC', 'FACILITIES_AVERAGE_LONGITUDE_DESC', 'FACILITIES_AVERAGE_METRICS_ONE_ACTIVE_ASC', 'FACILITIES_AVERAGE_METRICS_ONE_ACTIVE_DESC', 'FACILITIES_AVERAGE_NAME_ASC', 'FACILITIES_AVERAGE_NAME_DESC', 'FACILITIES_AVERAGE_N_SIGHT_2_ACTIVE_ASC', 'FACILITIES_AVERAGE_N_SIGHT_2_ACTIVE_DESC', 'FACILITIES_AVERAGE_N_SIGHT_ACTIVE_ASC', 'FACILITIES_AVERAGE_N_SIGHT_ACTIVE_DESC', 'FACILITIES_AVERAGE_PRE_BONUS_EBITDA_ASC', 'FACILITIES_AVERAGE_PRE_BONUS_EBITDA_DESC', 'FACILITIES_AVERAGE_PRICING_NODE_ID_ASC', 'FACILITIES_AVERAGE_PRICING_NODE_ID_DESC', 'FACILITIES_AVERAGE_REAL_TIME_ENABLED_ASC', 'FACILITIES_AVERAGE_REAL_TIME_ENABLED_DESC', 'FACILITIES_AVERAGE_RETIRED_AT_ASC', 'FACILITIES_AVERAGE_RETIRED_AT_DESC', 'FACILITIES_AVERAGE_SLUG_ASC', 'FACILITIES_AVERAGE_SLUG_DESC', 'FACILITIES_AVERAGE_STATE_ASC', 'FACILITIES_AVERAGE_STATE_DESC', 'FACILITIES_AVERAGE_SUPPRESSE_FINANCIALS_ASC', 'FACILITIES_AVERAGE_SUPPRESSE_FINANCIALS_DESC', 'FACILITIES_AVERAGE_TIMEZONE_NAME_ASC', 'FACILITIES_AVERAGE_TIMEZONE_NAME_DESC', 'FACILITIES_AVERAGE_TYPE_ASC', 'FACILITIES_AVERAGE_TYPE_DESC', 'FACILITIES_AVERAGE_UNIT_GROUP_ASC', 'FACILITIES_AVERAGE_UNIT_GROUP_DESC', 'FACILITIES_AVERAGE_UPDATED_AT_ASC', 'FACILITIES_AVERAGE_UPDATED_AT_DESC', 'FACILITIES_AVERAGE_WMS_ASC', 'FACILITIES_AVERAGE_WMS_DESC', 'FACILITIES_AVERAGE_ZIP_ASC', 'FACILITIES_AVERAGE_ZIP_DESC', 'FACILITIES_COUNT_ASC', 'FACILITIES_COUNT_DESC', 'FACILITIES_DISTINCT_ADDRESS_ASC', 'FACILITIES_DISTINCT_ADDRESS_DESC', 'FACILITIES_DISTINCT_BONUS_LTR_ASC', 'FACILITIES_DISTINCT_BONUS_LTR_DESC', 'FACILITIES_DISTINCT_CITY_ASC', 'FACILITIES_DISTINCT_CITY_DESC', 'FACILITIES_DISTINCT_COMMODITY_ASC', 'FACILITIES_DISTINCT_COMMODITY_DESC', 'FACILITIES_DISTINCT_COST_CENTER_ASC', 'FACILITIES_DISTINCT_COST_CENTER_DESC', 'FACILITIES_DISTINCT_COUNTRY_ASC', 'FACILITIES_DISTINCT_COUNTRY_DESC', 'FACILITIES_DISTINCT_COUNT_ADDRESS_ASC', 'FACILITIES_DISTINCT_COUNT_ADDRESS_DESC', 'FACILITIES_DISTINCT_COUNT_BONUS_LTR_ASC', 'FACILITIES_DISTINCT_COUNT_BONUS_LTR_DESC', 'FACILITIES_DISTINCT_COUNT_CITY_ASC', 'FACILITIES_DISTINCT_COUNT_CITY_DESC', 'FACILITIES_DISTINCT_COUNT_COMMODITY_ASC', 'FACILITIES_DISTINCT_COUNT_COMMODITY_DESC', 'FACILITIES_DISTINCT_COUNT_COST_CENTER_ASC', 'FACILITIES_DISTINCT_COUNT_COST_CENTER_DESC', 'FACILITIES_DISTINCT_COUNT_COUNTRY_ASC', 'FACILITIES_DISTINCT_COUNT_COUNTRY_DESC', 'FACILITIES_DISTINCT_COUNT_CREATED_AT_ASC', 'FACILITIES_DISTINCT_COUNT_CREATED_AT_DESC', 'FACILITIES_DISTINCT_COUNT_CUSTOMER_LOCATION_ID_ASC', 'FACILITIES_DISTINCT_COUNT_CUSTOMER_LOCATION_ID_DESC', 'FACILITIES_DISTINCT_COUNT_FACILITY_CONTACTS_ASC', 'FACILITIES_DISTINCT_COUNT_FACILITY_CONTACTS_DESC', 'FACILITIES_DISTINCT_COUNT_GEOMETRY_ASC', 'FACILITIES_DISTINCT_COUNT_GEOMETRY_DESC', 'FACILITIES_DISTINCT_COUNT_GO_LIVE_DATE_ASC', 'FACILITIES_DISTINCT_COUNT_GO_LIVE_DATE_DESC', 'FACILITIES_DISTINCT_COUNT_ID_ASC', 'FACILITIES_DISTINCT_COUNT_ID_DESC', 'FACILITIES_DISTINCT_COUNT_LATITUDE_ASC', 'FACILITIES_DISTINCT_COUNT_LATITUDE_DESC', 'FACILITIES_DISTINCT_COUNT_LINK_ACTIVE_ASC', 'FACILITIES_DISTINCT_COUNT_LINK_ACTIVE_DESC', 'FACILITIES_DISTINCT_COUNT_LONGITUDE_ASC', 'FACILITIES_DISTINCT_COUNT_LONGITUDE_DESC', 'FACILITIES_DISTINCT_COUNT_METRICS_ONE_ACTIVE_ASC', 'FACILITIES_DISTINCT_COUNT_METRICS_ONE_ACTIVE_DESC', 'FACILITIES_DISTINCT_COUNT_NAME_ASC', 'FACILITIES_DISTINCT_COUNT_NAME_DESC', 'FACILITIES_DISTINCT_COUNT_N_SIGHT_2_ACTIVE_ASC', 'FACILITIES_DISTINCT_COUNT_N_SIGHT_2_ACTIVE_DESC', 'FACILITIES_DISTINCT_COUNT_N_SIGHT_ACTIVE_ASC', 'FACILITIES_DISTINCT_COUNT_N_SIGHT_ACTIVE_DESC', 'FACILITIES_DISTINCT_COUNT_PRE_BONUS_EBITDA_ASC', 'FACILITIES_DISTINCT_COUNT_PRE_BONUS_EBITDA_DESC', 'FACILITIES_DISTINCT_COUNT_PRICING_NODE_ID_ASC', 'FACILITIES_DISTINCT_COUNT_PRICING_NODE_ID_DESC', 'FACILITIES_DISTINCT_COUNT_REAL_TIME_ENABLED_ASC', 'FACILITIES_DISTINCT_COUNT_REAL_TIME_ENABLED_DESC', 'FACILITIES_DISTINCT_COUNT_RETIRED_AT_ASC', 'FACILITIES_DISTINCT_COUNT_RETIRED_AT_DESC', 'FACILITIES_DISTINCT_COUNT_SLUG_ASC', 'FACILITIES_DISTINCT_COUNT_SLUG_DESC', 'FACILITIES_DISTINCT_COUNT_STATE_ASC', 'FACILITIES_DISTINCT_COUNT_STATE_DESC', 'FACILITIES_DISTINCT_COUNT_SUPPRESSE_FINANCIALS_ASC', 'FACILITIES_DISTINCT_COUNT_SUPPRESSE_FINANCIALS_DESC', 'FACILITIES_DISTINCT_COUNT_TIMEZONE_NAME_ASC', 'FACILITIES_DISTINCT_COUNT_TIMEZONE_NAME_DESC', 'FACILITIES_DISTINCT_COUNT_TYPE_ASC', 'FACILITIES_DISTINCT_COUNT_TYPE_DESC', 'FACILITIES_DISTINCT_COUNT_UNIT_GROUP_ASC', 'FACILITIES_DISTINCT_COUNT_UNIT_GROUP_DESC', 'FACILITIES_DISTINCT_COUNT_UPDATED_AT_ASC', 'FACILITIES_DISTINCT_COUNT_UPDATED_AT_DESC', 'FACILITIES_DISTINCT_COUNT_WMS_ASC', 'FACILITIES_DISTINCT_COUNT_WMS_DESC', 'FACILITIES_DISTINCT_COUNT_ZIP_ASC', 'FACILITIES_DISTINCT_COUNT_ZIP_DESC', 'FACILITIES_DISTINCT_CREATED_AT_ASC', 'FACILITIES_DISTINCT_CREATED_AT_DESC', 'FACILITIES_DISTINCT_CUSTOMER_LOCATION_ID_ASC', 'FACILITIES_DISTINCT_CUSTOMER_LOCATION_ID_DESC', 'FACILITIES_DISTINCT_FACILITY_CONTACTS_ASC', 'FACILITIES_DISTINCT_FACILITY_CONTACTS_DESC', 'FACILITIES_DISTINCT_GEOMETRY_ASC', 'FACILITIES_DISTINCT_GEOMETRY_DESC', 'FACILITIES_DISTINCT_GO_LIVE_DATE_ASC', 'FACILITIES_DISTINCT_GO_LIVE_DATE_DESC', 'FACILITIES_DISTINCT_ID_ASC', 'FACILITIES_DISTINCT_ID_DESC', 'FACILITIES_DISTINCT_LATITUDE_ASC', 'FACILITIES_DISTINCT_LATITUDE_DESC', 'FACILITIES_DISTINCT_LINK_ACTIVE_ASC', 'FACILITIES_DISTINCT_LINK_ACTIVE_DESC', 'FACILITIES_DISTINCT_LONGITUDE_ASC', 'FACILITIES_DISTINCT_LONGITUDE_DESC', 'FACILITIES_DISTINCT_METRICS_ONE_ACTIVE_ASC', 'FACILITIES_DISTINCT_METRICS_ONE_ACTIVE_DESC', 'FACILITIES_DISTINCT_NAME_ASC', 'FACILITIES_DISTINCT_NAME_DESC', 'FACILITIES_DISTINCT_N_SIGHT_2_ACTIVE_ASC', 'FACILITIES_DISTINCT_N_SIGHT_2_ACTIVE_DESC', 'FACILITIES_DISTINCT_N_SIGHT_ACTIVE_ASC', 'FACILITIES_DISTINCT_N_SIGHT_ACTIVE_DESC', 'FACILITIES_DISTINCT_PRE_BONUS_EBITDA_ASC', 'FACILITIES_DISTINCT_PRE_BONUS_EBITDA_DESC', 'FACILITIES_DISTINCT_PRICING_NODE_ID_ASC', 'FACILITIES_DISTINCT_PRICING_NODE_ID_DESC', 'FACILITIES_DISTINCT_REAL_TIME_ENABLED_ASC', 'FACILITIES_DISTINCT_REAL_TIME_ENABLED_DESC', 'FACILITIES_DISTINCT_RETIRED_AT_ASC', 'FACILITIES_DISTINCT_RETIRED_AT_DESC', 'FACILITIES_DISTINCT_SLUG_ASC', 'FACILITIES_DISTINCT_SLUG_DESC', 'FACILITIES_DISTINCT_STATE_ASC', 'FACILITIES_DISTINCT_STATE_DESC', 'FACILITIES_DISTINCT_SUPPRESSE_FINANCIALS_ASC', 'FACILITIES_DISTINCT_SUPPRESSE_FINANCIALS_DESC', 'FACILITIES_DISTINCT_TIMEZONE_NAME_ASC', 'FACILITIES_DISTINCT_TIMEZONE_NAME_DESC', 'FACILITIES_DISTINCT_TYPE_ASC', 'FACILITIES_DISTINCT_TYPE_DESC', 'FACILITIES_DISTINCT_UNIT_GROUP_ASC', 'FACILITIES_DISTINCT_UNIT_GROUP_DESC', 'FACILITIES_DISTINCT_UPDATED_AT_ASC', 'FACILITIES_DISTINCT_UPDATED_AT_DESC', 'FACILITIES_DISTINCT_WMS_ASC', 'FACILITIES_DISTINCT_WMS_DESC', 'FACILITIES_DISTINCT_ZIP_ASC', 'FACILITIES_DISTINCT_ZIP_DESC', 'FACILITIES_MAX_ADDRESS_ASC', 'FACILITIES_MAX_ADDRESS_DESC', 'FACILITIES_MAX_BONUS_LTR_ASC', 'FACILITIES_MAX_BONUS_LTR_DESC', 'FACILITIES_MAX_CITY_ASC', 'FACILITIES_MAX_CITY_DESC', 'FACILITIES_MAX_COMMODITY_ASC', 'FACILITIES_MAX_COMMODITY_DESC', 'FACILITIES_MAX_COST_CENTER_ASC', 'FACILITIES_MAX_COST_CENTER_DESC', 'FACILITIES_MAX_COUNTRY_ASC', 'FACILITIES_MAX_COUNTRY_DESC', 'FACILITIES_MAX_CREATED_AT_ASC', 'FACILITIES_MAX_CREATED_AT_DESC', 'FACILITIES_MAX_CUSTOMER_LOCATION_ID_ASC', 'FACILITIES_MAX_CUSTOMER_LOCATION_ID_DESC', 'FACILITIES_MAX_FACILITY_CONTACTS_ASC', 'FACILITIES_MAX_FACILITY_CONTACTS_DESC', 'FACILITIES_MAX_GEOMETRY_ASC', 'FACILITIES_MAX_GEOMETRY_DESC', 'FACILITIES_MAX_GO_LIVE_DATE_ASC', 'FACILITIES_MAX_GO_LIVE_DATE_DESC', 'FACILITIES_MAX_ID_ASC', 'FACILITIES_MAX_ID_DESC', 'FACILITIES_MAX_LATITUDE_ASC', 'FACILITIES_MAX_LATITUDE_DESC', 'FACILITIES_MAX_LINK_ACTIVE_ASC', 'FACILITIES_MAX_LINK_ACTIVE_DESC', 'FACILITIES_MAX_LONGITUDE_ASC', 'FACILITIES_MAX_LONGITUDE_DESC', 'FACILITIES_MAX_METRICS_ONE_ACTIVE_ASC', 'FACILITIES_MAX_METRICS_ONE_ACTIVE_DESC', 'FACILITIES_MAX_NAME_ASC', 'FACILITIES_MAX_NAME_DESC', 'FACILITIES_MAX_N_SIGHT_2_ACTIVE_ASC', 'FACILITIES_MAX_N_SIGHT_2_ACTIVE_DESC', 'FACILITIES_MAX_N_SIGHT_ACTIVE_ASC', 'FACILITIES_MAX_N_SIGHT_ACTIVE_DESC', 'FACILITIES_MAX_PRE_BONUS_EBITDA_ASC', 'FACILITIES_MAX_PRE_BONUS_EBITDA_DESC', 'FACILITIES_MAX_PRICING_NODE_ID_ASC', 'FACILITIES_MAX_PRICING_NODE_ID_DESC', 'FACILITIES_MAX_REAL_TIME_ENABLED_ASC', 'FACILITIES_MAX_REAL_TIME_ENABLED_DESC', 'FACILITIES_MAX_RETIRED_AT_ASC', 'FACILITIES_MAX_RETIRED_AT_DESC', 'FACILITIES_MAX_SLUG_ASC', 'FACILITIES_MAX_SLUG_DESC', 'FACILITIES_MAX_STATE_ASC', 'FACILITIES_MAX_STATE_DESC', 'FACILITIES_MAX_SUPPRESSE_FINANCIALS_ASC', 'FACILITIES_MAX_SUPPRESSE_FINANCIALS_DESC', 'FACILITIES_MAX_TIMEZONE_NAME_ASC', 'FACILITIES_MAX_TIMEZONE_NAME_DESC', 'FACILITIES_MAX_TYPE_ASC', 'FACILITIES_MAX_TYPE_DESC', 'FACILITIES_MAX_UNIT_GROUP_ASC', 'FACILITIES_MAX_UNIT_GROUP_DESC', 'FACILITIES_MAX_UPDATED_AT_ASC', 'FACILITIES_MAX_UPDATED_AT_DESC', 'FACILITIES_MAX_WMS_ASC', 'FACILITIES_MAX_WMS_DESC', 'FACILITIES_MAX_ZIP_ASC', 'FACILITIES_MAX_ZIP_DESC', 'FACILITIES_MIN_ADDRESS_ASC', 'FACILITIES_MIN_ADDRESS_DESC', 'FACILITIES_MIN_BONUS_LTR_ASC', 'FACILITIES_MIN_BONUS_LTR_DESC', 'FACILITIES_MIN_CITY_ASC', 'FACILITIES_MIN_CITY_DESC', 'FACILITIES_MIN_COMMODITY_ASC', 'FACILITIES_MIN_COMMODITY_DESC', 'FACILITIES_MIN_COST_CENTER_ASC', 'FACILITIES_MIN_COST_CENTER_DESC', 'FACILITIES_MIN_COUNTRY_ASC', 'FACILITIES_MIN_COUNTRY_DESC', 'FACILITIES_MIN_CREATED_AT_ASC', 'FACILITIES_MIN_CREATED_AT_DESC', 'FACILITIES_MIN_CUSTOMER_LOCATION_ID_ASC', 'FACILITIES_MIN_CUSTOMER_LOCATION_ID_DESC', 'FACILITIES_MIN_FACILITY_CONTACTS_ASC', 'FACILITIES_MIN_FACILITY_CONTACTS_DESC', 'FACILITIES_MIN_GEOMETRY_ASC', 'FACILITIES_MIN_GEOMETRY_DESC', 'FACILITIES_MIN_GO_LIVE_DATE_ASC', 'FACILITIES_MIN_GO_LIVE_DATE_DESC', 'FACILITIES_MIN_ID_ASC', 'FACILITIES_MIN_ID_DESC', 'FACILITIES_MIN_LATITUDE_ASC', 'FACILITIES_MIN_LATITUDE_DESC', 'FACILITIES_MIN_LINK_ACTIVE_ASC', 'FACILITIES_MIN_LINK_ACTIVE_DESC', 'FACILITIES_MIN_LONGITUDE_ASC', 'FACILITIES_MIN_LONGITUDE_DESC', 'FACILITIES_MIN_METRICS_ONE_ACTIVE_ASC', 'FACILITIES_MIN_METRICS_ONE_ACTIVE_DESC', 'FACILITIES_MIN_NAME_ASC', 'FACILITIES_MIN_NAME_DESC', 'FACILITIES_MIN_N_SIGHT_2_ACTIVE_ASC', 'FACILITIES_MIN_N_SIGHT_2_ACTIVE_DESC', 'FACILITIES_MIN_N_SIGHT_ACTIVE_ASC', 'FACILITIES_MIN_N_SIGHT_ACTIVE_DESC', 'FACILITIES_MIN_PRE_BONUS_EBITDA_ASC', 'FACILITIES_MIN_PRE_BONUS_EBITDA_DESC', 'FACILITIES_MIN_PRICING_NODE_ID_ASC', 'FACILITIES_MIN_PRICING_NODE_ID_DESC', 'FACILITIES_MIN_REAL_TIME_ENABLED_ASC', 'FACILITIES_MIN_REAL_TIME_ENABLED_DESC', 'FACILITIES_MIN_RETIRED_AT_ASC', 'FACILITIES_MIN_RETIRED_AT_DESC', 'FACILITIES_MIN_SLUG_ASC', 'FACILITIES_MIN_SLUG_DESC', 'FACILITIES_MIN_STATE_ASC', 'FACILITIES_MIN_STATE_DESC', 'FACILITIES_MIN_SUPPRESSE_FINANCIALS_ASC', 'FACILITIES_MIN_SUPPRESSE_FINANCIALS_DESC', 'FACILITIES_MIN_TIMEZONE_NAME_ASC', 'FACILITIES_MIN_TIMEZONE_NAME_DESC', 'FACILITIES_MIN_TYPE_ASC', 'FACILITIES_MIN_TYPE_DESC', 'FACILITIES_MIN_UNIT_GROUP_ASC', 'FACILITIES_MIN_UNIT_GROUP_DESC', 'FACILITIES_MIN_UPDATED_AT_ASC', 'FACILITIES_MIN_UPDATED_AT_DESC', 'FACILITIES_MIN_WMS_ASC', 'FACILITIES_MIN_WMS_DESC', 'FACILITIES_MIN_ZIP_ASC', 'FACILITIES_MIN_ZIP_DESC', 'FACILITIES_STDDEV_POPULATION_ADDRESS_ASC', 'FACILITIES_STDDEV_POPULATION_ADDRESS_DESC', 'FACILITIES_STDDEV_POPULATION_BONUS_LTR_ASC', 'FACILITIES_STDDEV_POPULATION_BONUS_LTR_DESC', 'FACILITIES_STDDEV_POPULATION_CITY_ASC', 'FACILITIES_STDDEV_POPULATION_CITY_DESC', 'FACILITIES_STDDEV_POPULATION_COMMODITY_ASC', 'FACILITIES_STDDEV_POPULATION_COMMODITY_DESC', 'FACILITIES_STDDEV_POPULATION_COST_CENTER_ASC', 'FACILITIES_STDDEV_POPULATION_COST_CENTER_DESC', 'FACILITIES_STDDEV_POPULATION_COUNTRY_ASC', 'FACILITIES_STDDEV_POPULATION_COUNTRY_DESC', 'FACILITIES_STDDEV_POPULATION_CREATED_AT_ASC', 'FACILITIES_STDDEV_POPULATION_CREATED_AT_DESC', 'FACILITIES_STDDEV_POPULATION_CUSTOMER_LOCATION_ID_ASC', 'FACILITIES_STDDEV_POPULATION_CUSTOMER_LOCATION_ID_DESC', 'FACILITIES_STDDEV_POPULATION_FACILITY_CONTACTS_ASC', 'FACILITIES_STDDEV_POPULATION_FACILITY_CONTACTS_DESC', 'FACILITIES_STDDEV_POPULATION_GEOMETRY_ASC', 'FACILITIES_STDDEV_POPULATION_GEOMETRY_DESC', 'FACILITIES_STDDEV_POPULATION_GO_LIVE_DATE_ASC', 'FACILITIES_STDDEV_POPULATION_GO_LIVE_DATE_DESC', 'FACILITIES_STDDEV_POPULATION_ID_ASC', 'FACILITIES_STDDEV_POPULATION_ID_DESC', 'FACILITIES_STDDEV_POPULATION_LATITUDE_ASC', 'FACILITIES_STDDEV_POPULATION_LATITUDE_DESC', 'FACILITIES_STDDEV_POPULATION_LINK_ACTIVE_ASC', 'FACILITIES_STDDEV_POPULATION_LINK_ACTIVE_DESC', 'FACILITIES_STDDEV_POPULATION_LONGITUDE_ASC', 'FACILITIES_STDDEV_POPULATION_LONGITUDE_DESC', 'FACILITIES_STDDEV_POPULATION_METRICS_ONE_ACTIVE_ASC', 'FACILITIES_STDDEV_POPULATION_METRICS_ONE_ACTIVE_DESC', 'FACILITIES_STDDEV_POPULATION_NAME_ASC', 'FACILITIES_STDDEV_POPULATION_NAME_DESC', 'FACILITIES_STDDEV_POPULATION_N_SIGHT_2_ACTIVE_ASC', 'FACILITIES_STDDEV_POPULATION_N_SIGHT_2_ACTIVE_DESC', 'FACILITIES_STDDEV_POPULATION_N_SIGHT_ACTIVE_ASC', 'FACILITIES_STDDEV_POPULATION_N_SIGHT_ACTIVE_DESC', 'FACILITIES_STDDEV_POPULATION_PRE_BONUS_EBITDA_ASC', 'FACILITIES_STDDEV_POPULATION_PRE_BONUS_EBITDA_DESC', 'FACILITIES_STDDEV_POPULATION_PRICING_NODE_ID_ASC', 'FACILITIES_STDDEV_POPULATION_PRICING_NODE_ID_DESC', 'FACILITIES_STDDEV_POPULATION_REAL_TIME_ENABLED_ASC', 'FACILITIES_STDDEV_POPULATION_REAL_TIME_ENABLED_DESC', 'FACILITIES_STDDEV_POPULATION_RETIRED_AT_ASC', 'FACILITIES_STDDEV_POPULATION_RETIRED_AT_DESC', 'FACILITIES_STDDEV_POPULATION_SLUG_ASC', 'FACILITIES_STDDEV_POPULATION_SLUG_DESC', 'FACILITIES_STDDEV_POPULATION_STATE_ASC', 'FACILITIES_STDDEV_POPULATION_STATE_DESC', 'FACILITIES_STDDEV_POPULATION_SUPPRESSE_FINANCIALS_ASC', 'FACILITIES_STDDEV_POPULATION_SUPPRESSE_FINANCIALS_DESC', 'FACILITIES_STDDEV_POPULATION_TIMEZONE_NAME_ASC', 'FACILITIES_STDDEV_POPULATION_TIMEZONE_NAME_DESC', 'FACILITIES_STDDEV_POPULATION_TYPE_ASC', 'FACILITIES_STDDEV_POPULATION_TYPE_DESC', 'FACILITIES_STDDEV_POPULATION_UNIT_GROUP_ASC', 'FACILITIES_STDDEV_POPULATION_UNIT_GROUP_DESC', 'FACILITIES_STDDEV_POPULATION_UPDATED_AT_ASC', 'FACILITIES_STDDEV_POPULATION_UPDATED_AT_DESC', 'FACILITIES_STDDEV_POPULATION_WMS_ASC', 'FACILITIES_STDDEV_POPULATION_WMS_DESC', 'FACILITIES_STDDEV_POPULATION_ZIP_ASC', 'FACILITIES_STDDEV_POPULATION_ZIP_DESC', 'FACILITIES_STDDEV_SAMPLE_ADDRESS_ASC', 'FACILITIES_STDDEV_SAMPLE_ADDRESS_DESC', 'FACILITIES_STDDEV_SAMPLE_BONUS_LTR_ASC', 'FACILITIES_STDDEV_SAMPLE_BONUS_LTR_DESC', 'FACILITIES_STDDEV_SAMPLE_CITY_ASC', 'FACILITIES_STDDEV_SAMPLE_CITY_DESC', 'FACILITIES_STDDEV_SAMPLE_COMMODITY_ASC', 'FACILITIES_STDDEV_SAMPLE_COMMODITY_DESC', 'FACILITIES_STDDEV_SAMPLE_COST_CENTER_ASC', 'FACILITIES_STDDEV_SAMPLE_COST_CENTER_DESC', 'FACILITIES_STDDEV_SAMPLE_COUNTRY_ASC', 'FACILITIES_STDDEV_SAMPLE_COUNTRY_DESC', 'FACILITIES_STDDEV_SAMPLE_CREATED_AT_ASC', 'FACILITIES_STDDEV_SAMPLE_CREATED_AT_DESC', 'FACILITIES_STDDEV_SAMPLE_CUSTOMER_LOCATION_ID_ASC', 'FACILITIES_STDDEV_SAMPLE_CUSTOMER_LOCATION_ID_DESC', 'FACILITIES_STDDEV_SAMPLE_FACILITY_CONTACTS_ASC', 'FACILITIES_STDDEV_SAMPLE_FACILITY_CONTACTS_DESC', 'FACILITIES_STDDEV_SAMPLE_GEOMETRY_ASC', 'FACILITIES_STDDEV_SAMPLE_GEOMETRY_DESC', 'FACILITIES_STDDEV_SAMPLE_GO_LIVE_DATE_ASC', 'FACILITIES_STDDEV_SAMPLE_GO_LIVE_DATE_DESC', 'FACILITIES_STDDEV_SAMPLE_ID_ASC', 'FACILITIES_STDDEV_SAMPLE_ID_DESC', 'FACILITIES_STDDEV_SAMPLE_LATITUDE_ASC', 'FACILITIES_STDDEV_SAMPLE_LATITUDE_DESC', 'FACILITIES_STDDEV_SAMPLE_LINK_ACTIVE_ASC', 'FACILITIES_STDDEV_SAMPLE_LINK_ACTIVE_DESC', 'FACILITIES_STDDEV_SAMPLE_LONGITUDE_ASC', 'FACILITIES_STDDEV_SAMPLE_LONGITUDE_DESC', 'FACILITIES_STDDEV_SAMPLE_METRICS_ONE_ACTIVE_ASC', 'FACILITIES_STDDEV_SAMPLE_METRICS_ONE_ACTIVE_DESC', 'FACILITIES_STDDEV_SAMPLE_NAME_ASC', 'FACILITIES_STDDEV_SAMPLE_NAME_DESC', 'FACILITIES_STDDEV_SAMPLE_N_SIGHT_2_ACTIVE_ASC', 'FACILITIES_STDDEV_SAMPLE_N_SIGHT_2_ACTIVE_DESC', 'FACILITIES_STDDEV_SAMPLE_N_SIGHT_ACTIVE_ASC', 'FACILITIES_STDDEV_SAMPLE_N_SIGHT_ACTIVE_DESC', 'FACILITIES_STDDEV_SAMPLE_PRE_BONUS_EBITDA_ASC', 'FACILITIES_STDDEV_SAMPLE_PRE_BONUS_EBITDA_DESC', 'FACILITIES_STDDEV_SAMPLE_PRICING_NODE_ID_ASC', 'FACILITIES_STDDEV_SAMPLE_PRICING_NODE_ID_DESC', 'FACILITIES_STDDEV_SAMPLE_REAL_TIME_ENABLED_ASC', 'FACILITIES_STDDEV_SAMPLE_REAL_TIME_ENABLED_DESC', 'FACILITIES_STDDEV_SAMPLE_RETIRED_AT_ASC', 'FACILITIES_STDDEV_SAMPLE_RETIRED_AT_DESC', 'FACILITIES_STDDEV_SAMPLE_SLUG_ASC', 'FACILITIES_STDDEV_SAMPLE_SLUG_DESC', 'FACILITIES_STDDEV_SAMPLE_STATE_ASC', 'FACILITIES_STDDEV_SAMPLE_STATE_DESC', 'FACILITIES_STDDEV_SAMPLE_SUPPRESSE_FINANCIALS_ASC', 'FACILITIES_STDDEV_SAMPLE_SUPPRESSE_FINANCIALS_DESC', 'FACILITIES_STDDEV_SAMPLE_TIMEZONE_NAME_ASC', 'FACILITIES_STDDEV_SAMPLE_TIMEZONE_NAME_DESC', 'FACILITIES_STDDEV_SAMPLE_TYPE_ASC', 'FACILITIES_STDDEV_SAMPLE_TYPE_DESC', 'FACILITIES_STDDEV_SAMPLE_UNIT_GROUP_ASC', 'FACILITIES_STDDEV_SAMPLE_UNIT_GROUP_DESC', 'FACILITIES_STDDEV_SAMPLE_UPDATED_AT_ASC', 'FACILITIES_STDDEV_SAMPLE_UPDATED_AT_DESC', 'FACILITIES_STDDEV_SAMPLE_WMS_ASC', 'FACILITIES_STDDEV_SAMPLE_WMS_DESC', 'FACILITIES_STDDEV_SAMPLE_ZIP_ASC', 'FACILITIES_STDDEV_SAMPLE_ZIP_DESC', 'FACILITIES_SUM_ADDRESS_ASC', 'FACILITIES_SUM_ADDRESS_DESC', 'FACILITIES_SUM_BONUS_LTR_ASC', 'FACILITIES_SUM_BONUS_LTR_DESC', 'FACILITIES_SUM_CITY_ASC', 'FACILITIES_SUM_CITY_DESC', 'FACILITIES_SUM_COMMODITY_ASC', 'FACILITIES_SUM_COMMODITY_DESC', 'FACILITIES_SUM_COST_CENTER_ASC', 'FACILITIES_SUM_COST_CENTER_DESC', 'FACILITIES_SUM_COUNTRY_ASC', 'FACILITIES_SUM_COUNTRY_DESC', 'FACILITIES_SUM_CREATED_AT_ASC', 'FACILITIES_SUM_CREATED_AT_DESC', 'FACILITIES_SUM_CUSTOMER_LOCATION_ID_ASC', 'FACILITIES_SUM_CUSTOMER_LOCATION_ID_DESC', 'FACILITIES_SUM_FACILITY_CONTACTS_ASC', 'FACILITIES_SUM_FACILITY_CONTACTS_DESC', 'FACILITIES_SUM_GEOMETRY_ASC', 'FACILITIES_SUM_GEOMETRY_DESC', 'FACILITIES_SUM_GO_LIVE_DATE_ASC', 'FACILITIES_SUM_GO_LIVE_DATE_DESC', 'FACILITIES_SUM_ID_ASC', 'FACILITIES_SUM_ID_DESC', 'FACILITIES_SUM_LATITUDE_ASC', 'FACILITIES_SUM_LATITUDE_DESC', 'FACILITIES_SUM_LINK_ACTIVE_ASC', 'FACILITIES_SUM_LINK_ACTIVE_DESC', 'FACILITIES_SUM_LONGITUDE_ASC', 'FACILITIES_SUM_LONGITUDE_DESC', 'FACILITIES_SUM_METRICS_ONE_ACTIVE_ASC', 'FACILITIES_SUM_METRICS_ONE_ACTIVE_DESC', 'FACILITIES_SUM_NAME_ASC', 'FACILITIES_SUM_NAME_DESC', 'FACILITIES_SUM_N_SIGHT_2_ACTIVE_ASC', 'FACILITIES_SUM_N_SIGHT_2_ACTIVE_DESC', 'FACILITIES_SUM_N_SIGHT_ACTIVE_ASC', 'FACILITIES_SUM_N_SIGHT_ACTIVE_DESC', 'FACILITIES_SUM_PRE_BONUS_EBITDA_ASC', 'FACILITIES_SUM_PRE_BONUS_EBITDA_DESC', 'FACILITIES_SUM_PRICING_NODE_ID_ASC', 'FACILITIES_SUM_PRICING_NODE_ID_DESC', 'FACILITIES_SUM_REAL_TIME_ENABLED_ASC', 'FACILITIES_SUM_REAL_TIME_ENABLED_DESC', 'FACILITIES_SUM_RETIRED_AT_ASC', 'FACILITIES_SUM_RETIRED_AT_DESC', 'FACILITIES_SUM_SLUG_ASC', 'FACILITIES_SUM_SLUG_DESC', 'FACILITIES_SUM_STATE_ASC', 'FACILITIES_SUM_STATE_DESC', 'FACILITIES_SUM_SUPPRESSE_FINANCIALS_ASC', 'FACILITIES_SUM_SUPPRESSE_FINANCIALS_DESC', 'FACILITIES_SUM_TIMEZONE_NAME_ASC', 'FACILITIES_SUM_TIMEZONE_NAME_DESC', 'FACILITIES_SUM_TYPE_ASC', 'FACILITIES_SUM_TYPE_DESC', 'FACILITIES_SUM_UNIT_GROUP_ASC', 'FACILITIES_SUM_UNIT_GROUP_DESC', 'FACILITIES_SUM_UPDATED_AT_ASC', 'FACILITIES_SUM_UPDATED_AT_DESC', 'FACILITIES_SUM_WMS_ASC', 'FACILITIES_SUM_WMS_DESC', 'FACILITIES_SUM_ZIP_ASC', 'FACILITIES_SUM_ZIP_DESC', 'FACILITIES_VARIANCE_POPULATION_ADDRESS_ASC', 'FACILITIES_VARIANCE_POPULATION_ADDRESS_DESC', 'FACILITIES_VARIANCE_POPULATION_BONUS_LTR_ASC', 'FACILITIES_VARIANCE_POPULATION_BONUS_LTR_DESC', 'FACILITIES_VARIANCE_POPULATION_CITY_ASC', 'FACILITIES_VARIANCE_POPULATION_CITY_DESC', 'FACILITIES_VARIANCE_POPULATION_COMMODITY_ASC', 'FACILITIES_VARIANCE_POPULATION_COMMODITY_DESC', 'FACILITIES_VARIANCE_POPULATION_COST_CENTER_ASC', 'FACILITIES_VARIANCE_POPULATION_COST_CENTER_DESC', 'FACILITIES_VARIANCE_POPULATION_COUNTRY_ASC', 'FACILITIES_VARIANCE_POPULATION_COUNTRY_DESC', 'FACILITIES_VARIANCE_POPULATION_CREATED_AT_ASC', 'FACILITIES_VARIANCE_POPULATION_CREATED_AT_DESC', 'FACILITIES_VARIANCE_POPULATION_CUSTOMER_LOCATION_ID_ASC', 'FACILITIES_VARIANCE_POPULATION_CUSTOMER_LOCATION_ID_DESC', 'FACILITIES_VARIANCE_POPULATION_FACILITY_CONTACTS_ASC', 'FACILITIES_VARIANCE_POPULATION_FACILITY_CONTACTS_DESC', 'FACILITIES_VARIANCE_POPULATION_GEOMETRY_ASC', 'FACILITIES_VARIANCE_POPULATION_GEOMETRY_DESC', 'FACILITIES_VARIANCE_POPULATION_GO_LIVE_DATE_ASC', 'FACILITIES_VARIANCE_POPULATION_GO_LIVE_DATE_DESC', 'FACILITIES_VARIANCE_POPULATION_ID_ASC', 'FACILITIES_VARIANCE_POPULATION_ID_DESC', 'FACILITIES_VARIANCE_POPULATION_LATITUDE_ASC', 'FACILITIES_VARIANCE_POPULATION_LATITUDE_DESC', 'FACILITIES_VARIANCE_POPULATION_LINK_ACTIVE_ASC', 'FACILITIES_VARIANCE_POPULATION_LINK_ACTIVE_DESC', 'FACILITIES_VARIANCE_POPULATION_LONGITUDE_ASC', 'FACILITIES_VARIANCE_POPULATION_LONGITUDE_DESC', 'FACILITIES_VARIANCE_POPULATION_METRICS_ONE_ACTIVE_ASC', 'FACILITIES_VARIANCE_POPULATION_METRICS_ONE_ACTIVE_DESC', 'FACILITIES_VARIANCE_POPULATION_NAME_ASC', 'FACILITIES_VARIANCE_POPULATION_NAME_DESC', 'FACILITIES_VARIANCE_POPULATION_N_SIGHT_2_ACTIVE_ASC', 'FACILITIES_VARIANCE_POPULATION_N_SIGHT_2_ACTIVE_DESC', 'FACILITIES_VARIANCE_POPULATION_N_SIGHT_ACTIVE_ASC', 'FACILITIES_VARIANCE_POPULATION_N_SIGHT_ACTIVE_DESC', 'FACILITIES_VARIANCE_POPULATION_PRE_BONUS_EBITDA_ASC', 'FACILITIES_VARIANCE_POPULATION_PRE_BONUS_EBITDA_DESC', 'FACILITIES_VARIANCE_POPULATION_PRICING_NODE_ID_ASC', 'FACILITIES_VARIANCE_POPULATION_PRICING_NODE_ID_DESC', 'FACILITIES_VARIANCE_POPULATION_REAL_TIME_ENABLED_ASC', 'FACILITIES_VARIANCE_POPULATION_REAL_TIME_ENABLED_DESC', 'FACILITIES_VARIANCE_POPULATION_RETIRED_AT_ASC', 'FACILITIES_VARIANCE_POPULATION_RETIRED_AT_DESC', 'FACILITIES_VARIANCE_POPULATION_SLUG_ASC', 'FACILITIES_VARIANCE_POPULATION_SLUG_DESC', 'FACILITIES_VARIANCE_POPULATION_STATE_ASC', 'FACILITIES_VARIANCE_POPULATION_STATE_DESC', 'FACILITIES_VARIANCE_POPULATION_SUPPRESSE_FINANCIALS_ASC', 'FACILITIES_VARIANCE_POPULATION_SUPPRESSE_FINANCIALS_DESC', 'FACILITIES_VARIANCE_POPULATION_TIMEZONE_NAME_ASC', 'FACILITIES_VARIANCE_POPULATION_TIMEZONE_NAME_DESC', 'FACILITIES_VARIANCE_POPULATION_TYPE_ASC', 'FACILITIES_VARIANCE_POPULATION_TYPE_DESC', 'FACILITIES_VARIANCE_POPULATION_UNIT_GROUP_ASC', 'FACILITIES_VARIANCE_POPULATION_UNIT_GROUP_DESC', 'FACILITIES_VARIANCE_POPULATION_UPDATED_AT_ASC', 'FACILITIES_VARIANCE_POPULATION_UPDATED_AT_DESC', 'FACILITIES_VARIANCE_POPULATION_WMS_ASC', 'FACILITIES_VARIANCE_POPULATION_WMS_DESC', 'FACILITIES_VARIANCE_POPULATION_ZIP_ASC', 'FACILITIES_VARIANCE_POPULATION_ZIP_DESC', 'FACILITIES_VARIANCE_SAMPLE_ADDRESS_ASC', 'FACILITIES_VARIANCE_SAMPLE_ADDRESS_DESC', 'FACILITIES_VARIANCE_SAMPLE_BONUS_LTR_ASC', 'FACILITIES_VARIANCE_SAMPLE_BONUS_LTR_DESC', 'FACILITIES_VARIANCE_SAMPLE_CITY_ASC', 'FACILITIES_VARIANCE_SAMPLE_CITY_DESC', 'FACILITIES_VARIANCE_SAMPLE_COMMODITY_ASC', 'FACILITIES_VARIANCE_SAMPLE_COMMODITY_DESC', 'FACILITIES_VARIANCE_SAMPLE_COST_CENTER_ASC', 'FACILITIES_VARIANCE_SAMPLE_COST_CENTER_DESC', 'FACILITIES_VARIANCE_SAMPLE_COUNTRY_ASC', 'FACILITIES_VARIANCE_SAMPLE_COUNTRY_DESC', 'FACILITIES_VARIANCE_SAMPLE_CREATED_AT_ASC', 'FACILITIES_VARIANCE_SAMPLE_CREATED_AT_DESC', 'FACILITIES_VARIANCE_SAMPLE_CUSTOMER_LOCATION_ID_ASC', 'FACILITIES_VARIANCE_SAMPLE_CUSTOMER_LOCATION_ID_DESC', 'FACILITIES_VARIANCE_SAMPLE_FACILITY_CONTACTS_ASC', 'FACILITIES_VARIANCE_SAMPLE_FACILITY_CONTACTS_DESC', 'FACILITIES_VARIANCE_SAMPLE_GEOMETRY_ASC', 'FACILITIES_VARIANCE_SAMPLE_GEOMETRY_DESC', 'FACILITIES_VARIANCE_SAMPLE_GO_LIVE_DATE_ASC', 'FACILITIES_VARIANCE_SAMPLE_GO_LIVE_DATE_DESC', 'FACILITIES_VARIANCE_SAMPLE_ID_ASC', 'FACILITIES_VARIANCE_SAMPLE_ID_DESC', 'FACILITIES_VARIANCE_SAMPLE_LATITUDE_ASC', 'FACILITIES_VARIANCE_SAMPLE_LATITUDE_DESC', 'FACILITIES_VARIANCE_SAMPLE_LINK_ACTIVE_ASC', 'FACILITIES_VARIANCE_SAMPLE_LINK_ACTIVE_DESC', 'FACILITIES_VARIANCE_SAMPLE_LONGITUDE_ASC', 'FACILITIES_VARIANCE_SAMPLE_LONGITUDE_DESC', 'FACILITIES_VARIANCE_SAMPLE_METRICS_ONE_ACTIVE_ASC', 'FACILITIES_VARIANCE_SAMPLE_METRICS_ONE_ACTIVE_DESC', 'FACILITIES_VARIANCE_SAMPLE_NAME_ASC', 'FACILITIES_VARIANCE_SAMPLE_NAME_DESC', 'FACILITIES_VARIANCE_SAMPLE_N_SIGHT_2_ACTIVE_ASC', 'FACILITIES_VARIANCE_SAMPLE_N_SIGHT_2_ACTIVE_DESC', 'FACILITIES_VARIANCE_SAMPLE_N_SIGHT_ACTIVE_ASC', 'FACILITIES_VARIANCE_SAMPLE_N_SIGHT_ACTIVE_DESC', 'FACILITIES_VARIANCE_SAMPLE_PRE_BONUS_EBITDA_ASC', 'FACILITIES_VARIANCE_SAMPLE_PRE_BONUS_EBITDA_DESC', 'FACILITIES_VARIANCE_SAMPLE_PRICING_NODE_ID_ASC', 'FACILITIES_VARIANCE_SAMPLE_PRICING_NODE_ID_DESC', 'FACILITIES_VARIANCE_SAMPLE_REAL_TIME_ENABLED_ASC', 'FACILITIES_VARIANCE_SAMPLE_REAL_TIME_ENABLED_DESC', 'FACILITIES_VARIANCE_SAMPLE_RETIRED_AT_ASC', 'FACILITIES_VARIANCE_SAMPLE_RETIRED_AT_DESC', 'FACILITIES_VARIANCE_SAMPLE_SLUG_ASC', 'FACILITIES_VARIANCE_SAMPLE_SLUG_DESC', 'FACILITIES_VARIANCE_SAMPLE_STATE_ASC', 'FACILITIES_VARIANCE_SAMPLE_STATE_DESC', 'FACILITIES_VARIANCE_SAMPLE_SUPPRESSE_FINANCIALS_ASC', 'FACILITIES_VARIANCE_SAMPLE_SUPPRESSE_FINANCIALS_DESC', 'FACILITIES_VARIANCE_SAMPLE_TIMEZONE_NAME_ASC', 'FACILITIES_VARIANCE_SAMPLE_TIMEZONE_NAME_DESC', 'FACILITIES_VARIANCE_SAMPLE_TYPE_ASC', 'FACILITIES_VARIANCE_SAMPLE_TYPE_DESC', 'FACILITIES_VARIANCE_SAMPLE_UNIT_GROUP_ASC', 'FACILITIES_VARIANCE_SAMPLE_UNIT_GROUP_DESC', 'FACILITIES_VARIANCE_SAMPLE_UPDATED_AT_ASC', 'FACILITIES_VARIANCE_SAMPLE_UPDATED_AT_DESC', 'FACILITIES_VARIANCE_SAMPLE_WMS_ASC', 'FACILITIES_VARIANCE_SAMPLE_WMS_DESC', 'FACILITIES_VARIANCE_SAMPLE_ZIP_ASC', 'FACILITIES_VARIANCE_SAMPLE_ZIP_DESC', 'GEOMETRY_ASC', 'GEOMETRY_DESC', 'ID_ASC', 'ID_DESC', 'NAME_ASC', 'NAME_DESC', 'NATURAL', 'PRIMARY_KEY_ASC', 'PRIMARY_KEY_DESC', 'SLUG_ASC', 'SLUG_DESC', 'UPDATED_AT_ASC', 'UPDATED_AT_DESC')


class ProgramEnrollmentsOrderBy(sgqlc.types.Enum):
    __schema__ = nionic_schema
    __choices__ = ('CREATED_AT_ASC', 'CREATED_AT_DESC', 'END_DATE_ASC', 'END_DATE_DESC', 'ID_ASC', 'ID_DESC', 'NAME_ASC', 'NAME_DESC', 'NATURAL', 'PRIMARY_KEY_ASC', 'PRIMARY_KEY_DESC', 'PROGRAM_ID_ASC', 'PROGRAM_ID_DESC', 'START_DATE_ASC', 'START_DATE_DESC', 'UPDATED_AT_ASC', 'UPDATED_AT_DESC')


class ProgramsOrderBy(sgqlc.types.Enum):
    __schema__ = nionic_schema
    __choices__ = ('CREATED_AT_ASC', 'CREATED_AT_DESC', 'DESCRIPTION_ASC', 'DESCRIPTION_DESC', 'ID_ASC', 'ID_DESC', 'NAME_ASC', 'NAME_DESC', 'NATURAL', 'PRIMARY_KEY_ASC', 'PRIMARY_KEY_DESC', 'PROJECT_TYPE_ID_ASC', 'PROJECT_TYPE_ID_DESC', 'UPDATED_AT_ASC', 'UPDATED_AT_DESC')


class ProjectComponentsOrderBy(sgqlc.types.Enum):
    __schema__ = nionic_schema
    __choices__ = ('COMPONENT_ID_ASC', 'COMPONENT_ID_DESC', 'CONTROL_SCHEME_ASC', 'CONTROL_SCHEME_DESC', 'MAXIMUM_CONTROL_DURATION_ASC', 'MAXIMUM_CONTROL_DURATION_DESC', 'NATURAL', 'PRIMARY_KEY_ASC', 'PRIMARY_KEY_DESC', 'PROJECT_ID_ASC', 'PROJECT_ID_DESC', 'STARTUP_OFFSET_ASC', 'STARTUP_OFFSET_DESC')


class ProjectConfigsOrderBy(sgqlc.types.Enum):
    __schema__ = nionic_schema
    __choices__ = ('CREATED_AT_ASC', 'CREATED_AT_DESC', 'ID_ASC', 'ID_DESC', 'KEY_ASC', 'KEY_DESC', 'NATURAL', 'PRIMARY_KEY_ASC', 'PRIMARY_KEY_DESC', 'PROJECT_ID_ASC', 'PROJECT_ID_DESC', 'UPDATED_AT_ASC', 'UPDATED_AT_DESC', 'VALUE_ASC', 'VALUE_DESC')


class ProjectEnrollmentDataPointGroupsOrderBy(sgqlc.types.Enum):
    __schema__ = nionic_schema
    __choices__ = ('CREATED_AT_ASC', 'CREATED_AT_DESC', 'DESCRIPTION_ASC', 'DESCRIPTION_DESC', 'ID_ASC', 'ID_DESC', 'LABEL_ASC', 'LABEL_DESC', 'NATURAL', 'PRIMARY_KEY_ASC', 'PRIMARY_KEY_DESC', 'UPDATED_AT_ASC', 'UPDATED_AT_DESC')


class ProjectEnrollmentDataPointsOrderBy(sgqlc.types.Enum):
    __schema__ = nionic_schema
    __choices__ = ('ALIAS_ASC', 'ALIAS_DESC', 'CREATED_AT_ASC', 'CREATED_AT_DESC', 'DATA_POINT_ID_ASC', 'DATA_POINT_ID_DESC', 'ID_ASC', 'ID_DESC', 'NATURAL', 'PRIMARY_KEY_ASC', 'PRIMARY_KEY_DESC', 'PROJECT_ENROLLMENT_DATA_POINT_GROUP_ID_ASC', 'PROJECT_ENROLLMENT_DATA_POINT_GROUP_ID_DESC', 'PROJECT_ENROLLMENT_ID_ASC', 'PROJECT_ENROLLMENT_ID_DESC', 'RATE_ASC', 'RATE_DESC', 'TARGET_ASC', 'TARGET_DESC', 'UPDATED_AT_ASC', 'UPDATED_AT_DESC')


class ProjectEnrollmentsOrderBy(sgqlc.types.Enum):
    __schema__ = nionic_schema
    __choices__ = ('CREATED_AT_ASC', 'CREATED_AT_DESC', 'END_DATE_ASC', 'END_DATE_DESC', 'ID_ASC', 'ID_DESC', 'NATURAL', 'PRIMARY_KEY_ASC', 'PRIMARY_KEY_DESC', 'PROGRAM_ENROLLMENT_ID_ASC', 'PROGRAM_ENROLLMENT_ID_DESC', 'PROJECT_ID_ASC', 'PROJECT_ID_DESC', 'START_DATE_ASC', 'START_DATE_DESC', 'UPDATED_AT_ASC', 'UPDATED_AT_DESC')


class ProjectTypesOrderBy(sgqlc.types.Enum):
    __schema__ = nionic_schema
    __choices__ = ('DESCRIPTION_ASC', 'DESCRIPTION_DESC', 'ID_ASC', 'ID_DESC', 'NAME_ASC', 'NAME_DESC', 'NATURAL', 'PRIMARY_KEY_ASC', 'PRIMARY_KEY_DESC')


class ProjectWatchersOrderBy(sgqlc.types.Enum):
    __schema__ = nionic_schema
    __choices__ = ('NATURAL', 'PRIMARY_KEY_ASC', 'PRIMARY_KEY_DESC', 'PROJECT_ID_ASC', 'PROJECT_ID_DESC', 'USER_ID_ASC', 'USER_ID_DESC')


class ProjectsOrderBy(sgqlc.types.Enum):
    __schema__ = nionic_schema
    __choices__ = ('ACKNOWLEDGEMENT_WINDOW_THRESHOLD_ASC', 'ACKNOWLEDGEMENT_WINDOW_THRESHOLD_DESC', 'AUTO_ACKNOWLEDGE_ASC', 'AUTO_ACKNOWLEDGE_DESC', 'CONTROL_TYPE_ASC', 'CONTROL_TYPE_DESC', 'CREATED_AT_ASC', 'CREATED_AT_DESC', 'DESCRIPTION_ASC', 'DESCRIPTION_DESC', 'END_DATE_ASC', 'END_DATE_DESC', 'END_TIMEOUT_ASC', 'END_TIMEOUT_DESC', 'FACILITY_ID_ASC', 'FACILITY_ID_DESC', 'FACILITY_NAME_ASC', 'FACILITY_NAME_DESC', 'ID_ASC', 'ID_DESC', 'IS_WATCHING_ASC', 'IS_WATCHING_DESC', 'NAME_ASC', 'NAME_DESC', 'NATURAL', 'PRIMARY_KEY_ASC', 'PRIMARY_KEY_DESC', 'PROGRAM_ID_ASC', 'PROGRAM_ID_DESC', 'PROGRAM_NAME_ASC', 'PROGRAM_NAME_DESC', 'PROJECT_TYPE_ID_ASC', 'PROJECT_TYPE_ID_DESC', 'PROJECT_TYPE_NAME_ASC', 'PROJECT_TYPE_NAME_DESC', 'START_DATE_ASC', 'START_DATE_DESC', 'START_TIMEOUT_ASC', 'START_TIMEOUT_DESC', 'UPDATED_AT_ASC', 'UPDATED_AT_DESC')


class ReportExecutionsOrderBy(sgqlc.types.Enum):
    __schema__ = nionic_schema
    __choices__ = ('ACTOR_ASC', 'ACTOR_DESC', 'CREATED_AT_ASC', 'CREATED_AT_DESC', 'ERRORS_ASC', 'ERRORS_DESC', 'FILE_PATH_ASC', 'FILE_PATH_DESC', 'ID_ASC', 'ID_DESC', 'NATURAL', 'PRIMARY_KEY_ASC', 'PRIMARY_KEY_DESC', 'REPORT_ID_ASC', 'REPORT_ID_DESC', 'STATUS_ASC', 'STATUS_DESC', 'UPDATED_AT_ASC', 'UPDATED_AT_DESC')


class ReportQueriesOrderBy(sgqlc.types.Enum):
    __schema__ = nionic_schema
    __choices__ = ('CHUNK_DURATION_ASC', 'CHUNK_DURATION_DESC', 'CREATED_AT_ASC', 'CREATED_AT_DESC', 'DB_TYPE_ASC', 'DB_TYPE_DESC', 'DESCRIPTION_ASC', 'DESCRIPTION_DESC', 'EXPANDER_ASC', 'EXPANDER_DESC', 'ID_ASC', 'ID_DESC', 'LABEL_ASC', 'LABEL_DESC', 'NATURAL', 'PRIMARY_KEY_ASC', 'PRIMARY_KEY_DESC', 'QUERY_ASC', 'QUERY_DESC', 'REPORT_ID_ASC', 'REPORT_ID_DESC', 'UPDATED_AT_ASC', 'UPDATED_AT_DESC')


class ReportsOrderBy(sgqlc.types.Enum):
    __schema__ = nionic_schema
    __choices__ = ('CREATED_AT_ASC', 'CREATED_AT_DESC', 'DEFAULT_PARAMS_ASC', 'DEFAULT_PARAMS_CONFIG_ASC', 'DEFAULT_PARAMS_CONFIG_DESC', 'DEFAULT_PARAMS_DESC', 'DESCRIPTION_ASC', 'DESCRIPTION_DESC', 'ID_ASC', 'ID_DESC', 'JSON_SCHEMA_ASC', 'JSON_SCHEMA_DESC', 'LABEL_ASC', 'LABEL_DESC', 'NATURAL', 'PRIMARY_KEY_ASC', 'PRIMARY_KEY_DESC', 'UPDATED_AT_ASC', 'UPDATED_AT_DESC')


class SavingsEventsOrderBy(sgqlc.types.Enum):
    __schema__ = nionic_schema
    __choices__ = ('CREATED_AT_ASC', 'CREATED_AT_DESC', 'END_TIME_ASC', 'END_TIME_DESC', 'ID_ASC', 'ID_DESC', 'METADATA_ASC', 'METADATA_DESC', 'NATURAL', 'PRIMARY_KEY_ASC', 'PRIMARY_KEY_DESC', 'PROJECT_ID_ASC', 'PROJECT_ID_DESC', 'START_TIME_ASC', 'START_TIME_DESC', 'UPDATED_AT_ASC', 'UPDATED_AT_DESC')


String = sgqlc.types.String

class SuggestionActivityLogsOrderBy(sgqlc.types.Enum):
    __schema__ = nionic_schema
    __choices__ = ('ACTOR_ASC', 'ACTOR_DESC', 'CREATED_AT_ASC', 'CREATED_AT_DESC', 'METADATA_ASC', 'METADATA_DESC', 'NATURAL', 'SUGGESTION_ID_ASC', 'SUGGESTION_ID_DESC', 'TYPE_ASC', 'TYPE_DESC')


class SuggestionActivityType(sgqlc.types.Enum):
    __schema__ = nionic_schema
    __choices__ = ('ACKNOWLEDGED', 'REJECTED', 'UPDATED', 'WITHDRAWN')


class SuggestionState(sgqlc.types.Enum):
    __schema__ = nionic_schema
    __choices__ = ('ACTIVE', 'PAST', 'UPCOMING', 'WITHDRAWN')


class SuggestionsOrderBy(sgqlc.types.Enum):
    __schema__ = nionic_schema
    __choices__ = ('ACKNOWLEDGEMENT_STATUS_ASC', 'ACKNOWLEDGEMENT_STATUS_DESC', 'CONTROL_TYPE_ASC', 'CONTROL_TYPE_DESC', 'CREATED_AT_ASC', 'CREATED_AT_DESC', 'DESCRIPTION_ASC', 'DESCRIPTION_DESC', 'EFFECTIVENESS_ASC', 'EFFECTIVENESS_DESC', 'END_TIME_ASC', 'END_TIME_DESC', 'FACILITY_ID_ASC', 'FACILITY_ID_DESC', 'FACILITY_NAME_ASC', 'FACILITY_NAME_DESC', 'ID_ASC', 'ID_DESC', 'IS_WATCHING_ASC', 'IS_WATCHING_DESC', 'METADATA_ASC', 'METADATA_DESC', 'NATURAL', 'PRIMARY_KEY_ASC', 'PRIMARY_KEY_DESC', 'PROJECT_ID_ASC', 'PROJECT_ID_DESC', 'PROJECT_TYPE_ASC', 'PROJECT_TYPE_DESC', 'RELEVANCY_ASC', 'RELEVANCY_DESC', 'START_TIME_ASC', 'START_TIME_DESC', 'STATE_ASC', 'STATE_DESC', 'UPDATED_AT_ASC', 'UPDATED_AT_DESC', 'WITHDRAWN_AT_ASC', 'WITHDRAWN_AT_DESC')


class ThresholdCondition(sgqlc.types.Enum):
    __schema__ = nionic_schema
    __choices__ = ('EQUAL', 'GREATER', 'GREATER_EQUAL', 'LESS', 'LESS_EQUAL', 'NOT_EQUAL')


class TimezonesOrderBy(sgqlc.types.Enum):
    __schema__ = nionic_schema
    __choices__ = ('ABBREVIATION_ASC', 'ABBREVIATION_DESC', 'FACILITIES_BY_TIMEZONE_NAME_AVERAGE_ADDRESS_ASC', 'FACILITIES_BY_TIMEZONE_NAME_AVERAGE_ADDRESS_DESC', 'FACILITIES_BY_TIMEZONE_NAME_AVERAGE_BONUS_LTR_ASC', 'FACILITIES_BY_TIMEZONE_NAME_AVERAGE_BONUS_LTR_DESC', 'FACILITIES_BY_TIMEZONE_NAME_AVERAGE_CITY_ASC', 'FACILITIES_BY_TIMEZONE_NAME_AVERAGE_CITY_DESC', 'FACILITIES_BY_TIMEZONE_NAME_AVERAGE_COMMODITY_ASC', 'FACILITIES_BY_TIMEZONE_NAME_AVERAGE_COMMODITY_DESC', 'FACILITIES_BY_TIMEZONE_NAME_AVERAGE_COST_CENTER_ASC', 'FACILITIES_BY_TIMEZONE_NAME_AVERAGE_COST_CENTER_DESC', 'FACILITIES_BY_TIMEZONE_NAME_AVERAGE_COUNTRY_ASC', 'FACILITIES_BY_TIMEZONE_NAME_AVERAGE_COUNTRY_DESC', 'FACILITIES_BY_TIMEZONE_NAME_AVERAGE_CREATED_AT_ASC', 'FACILITIES_BY_TIMEZONE_NAME_AVERAGE_CREATED_AT_DESC', 'FACILITIES_BY_TIMEZONE_NAME_AVERAGE_CUSTOMER_LOCATION_ID_ASC', 'FACILITIES_BY_TIMEZONE_NAME_AVERAGE_CUSTOMER_LOCATION_ID_DESC', 'FACILITIES_BY_TIMEZONE_NAME_AVERAGE_FACILITY_CONTACTS_ASC', 'FACILITIES_BY_TIMEZONE_NAME_AVERAGE_FACILITY_CONTACTS_DESC', 'FACILITIES_BY_TIMEZONE_NAME_AVERAGE_GEOMETRY_ASC', 'FACILITIES_BY_TIMEZONE_NAME_AVERAGE_GEOMETRY_DESC', 'FACILITIES_BY_TIMEZONE_NAME_AVERAGE_GO_LIVE_DATE_ASC', 'FACILITIES_BY_TIMEZONE_NAME_AVERAGE_GO_LIVE_DATE_DESC', 'FACILITIES_BY_TIMEZONE_NAME_AVERAGE_ID_ASC', 'FACILITIES_BY_TIMEZONE_NAME_AVERAGE_ID_DESC', 'FACILITIES_BY_TIMEZONE_NAME_AVERAGE_LATITUDE_ASC', 'FACILITIES_BY_TIMEZONE_NAME_AVERAGE_LATITUDE_DESC', 'FACILITIES_BY_TIMEZONE_NAME_AVERAGE_LINK_ACTIVE_ASC', 'FACILITIES_BY_TIMEZONE_NAME_AVERAGE_LINK_ACTIVE_DESC', 'FACILITIES_BY_TIMEZONE_NAME_AVERAGE_LONGITUDE_ASC', 'FACILITIES_BY_TIMEZONE_NAME_AVERAGE_LONGITUDE_DESC', 'FACILITIES_BY_TIMEZONE_NAME_AVERAGE_METRICS_ONE_ACTIVE_ASC', 'FACILITIES_BY_TIMEZONE_NAME_AVERAGE_METRICS_ONE_ACTIVE_DESC', 'FACILITIES_BY_TIMEZONE_NAME_AVERAGE_NAME_ASC', 'FACILITIES_BY_TIMEZONE_NAME_AVERAGE_NAME_DESC', 'FACILITIES_BY_TIMEZONE_NAME_AVERAGE_N_SIGHT_2_ACTIVE_ASC', 'FACILITIES_BY_TIMEZONE_NAME_AVERAGE_N_SIGHT_2_ACTIVE_DESC', 'FACILITIES_BY_TIMEZONE_NAME_AVERAGE_N_SIGHT_ACTIVE_ASC', 'FACILITIES_BY_TIMEZONE_NAME_AVERAGE_N_SIGHT_ACTIVE_DESC', 'FACILITIES_BY_TIMEZONE_NAME_AVERAGE_PRE_BONUS_EBITDA_ASC', 'FACILITIES_BY_TIMEZONE_NAME_AVERAGE_PRE_BONUS_EBITDA_DESC', 'FACILITIES_BY_TIMEZONE_NAME_AVERAGE_PRICING_NODE_ID_ASC', 'FACILITIES_BY_TIMEZONE_NAME_AVERAGE_PRICING_NODE_ID_DESC', 'FACILITIES_BY_TIMEZONE_NAME_AVERAGE_REAL_TIME_ENABLED_ASC', 'FACILITIES_BY_TIMEZONE_NAME_AVERAGE_REAL_TIME_ENABLED_DESC', 'FACILITIES_BY_TIMEZONE_NAME_AVERAGE_RETIRED_AT_ASC', 'FACILITIES_BY_TIMEZONE_NAME_AVERAGE_RETIRED_AT_DESC', 'FACILITIES_BY_TIMEZONE_NAME_AVERAGE_SLUG_ASC', 'FACILITIES_BY_TIMEZONE_NAME_AVERAGE_SLUG_DESC', 'FACILITIES_BY_TIMEZONE_NAME_AVERAGE_STATE_ASC', 'FACILITIES_BY_TIMEZONE_NAME_AVERAGE_STATE_DESC', 'FACILITIES_BY_TIMEZONE_NAME_AVERAGE_SUPPRESSE_FINANCIALS_ASC', 'FACILITIES_BY_TIMEZONE_NAME_AVERAGE_SUPPRESSE_FINANCIALS_DESC', 'FACILITIES_BY_TIMEZONE_NAME_AVERAGE_TIMEZONE_NAME_ASC', 'FACILITIES_BY_TIMEZONE_NAME_AVERAGE_TIMEZONE_NAME_DESC', 'FACILITIES_BY_TIMEZONE_NAME_AVERAGE_TYPE_ASC', 'FACILITIES_BY_TIMEZONE_NAME_AVERAGE_TYPE_DESC', 'FACILITIES_BY_TIMEZONE_NAME_AVERAGE_UNIT_GROUP_ASC', 'FACILITIES_BY_TIMEZONE_NAME_AVERAGE_UNIT_GROUP_DESC', 'FACILITIES_BY_TIMEZONE_NAME_AVERAGE_UPDATED_AT_ASC', 'FACILITIES_BY_TIMEZONE_NAME_AVERAGE_UPDATED_AT_DESC', 'FACILITIES_BY_TIMEZONE_NAME_AVERAGE_WMS_ASC', 'FACILITIES_BY_TIMEZONE_NAME_AVERAGE_WMS_DESC', 'FACILITIES_BY_TIMEZONE_NAME_AVERAGE_ZIP_ASC', 'FACILITIES_BY_TIMEZONE_NAME_AVERAGE_ZIP_DESC', 'FACILITIES_BY_TIMEZONE_NAME_COUNT_ASC', 'FACILITIES_BY_TIMEZONE_NAME_COUNT_DESC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_ADDRESS_ASC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_ADDRESS_DESC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_BONUS_LTR_ASC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_BONUS_LTR_DESC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_CITY_ASC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_CITY_DESC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_COMMODITY_ASC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_COMMODITY_DESC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_COST_CENTER_ASC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_COST_CENTER_DESC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_COUNTRY_ASC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_COUNTRY_DESC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_COUNT_ADDRESS_ASC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_COUNT_ADDRESS_DESC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_COUNT_BONUS_LTR_ASC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_COUNT_BONUS_LTR_DESC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_COUNT_CITY_ASC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_COUNT_CITY_DESC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_COUNT_COMMODITY_ASC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_COUNT_COMMODITY_DESC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_COUNT_COST_CENTER_ASC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_COUNT_COST_CENTER_DESC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_COUNT_COUNTRY_ASC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_COUNT_COUNTRY_DESC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_COUNT_CREATED_AT_ASC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_COUNT_CREATED_AT_DESC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_COUNT_CUSTOMER_LOCATION_ID_ASC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_COUNT_CUSTOMER_LOCATION_ID_DESC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_COUNT_FACILITY_CONTACTS_ASC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_COUNT_FACILITY_CONTACTS_DESC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_COUNT_GEOMETRY_ASC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_COUNT_GEOMETRY_DESC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_COUNT_GO_LIVE_DATE_ASC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_COUNT_GO_LIVE_DATE_DESC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_COUNT_ID_ASC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_COUNT_ID_DESC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_COUNT_LATITUDE_ASC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_COUNT_LATITUDE_DESC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_COUNT_LINK_ACTIVE_ASC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_COUNT_LINK_ACTIVE_DESC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_COUNT_LONGITUDE_ASC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_COUNT_LONGITUDE_DESC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_COUNT_METRICS_ONE_ACTIVE_ASC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_COUNT_METRICS_ONE_ACTIVE_DESC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_COUNT_NAME_ASC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_COUNT_NAME_DESC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_COUNT_N_SIGHT_2_ACTIVE_ASC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_COUNT_N_SIGHT_2_ACTIVE_DESC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_COUNT_N_SIGHT_ACTIVE_ASC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_COUNT_N_SIGHT_ACTIVE_DESC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_COUNT_PRE_BONUS_EBITDA_ASC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_COUNT_PRE_BONUS_EBITDA_DESC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_COUNT_PRICING_NODE_ID_ASC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_COUNT_PRICING_NODE_ID_DESC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_COUNT_REAL_TIME_ENABLED_ASC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_COUNT_REAL_TIME_ENABLED_DESC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_COUNT_RETIRED_AT_ASC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_COUNT_RETIRED_AT_DESC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_COUNT_SLUG_ASC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_COUNT_SLUG_DESC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_COUNT_STATE_ASC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_COUNT_STATE_DESC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_COUNT_SUPPRESSE_FINANCIALS_ASC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_COUNT_SUPPRESSE_FINANCIALS_DESC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_COUNT_TIMEZONE_NAME_ASC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_COUNT_TIMEZONE_NAME_DESC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_COUNT_TYPE_ASC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_COUNT_TYPE_DESC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_COUNT_UNIT_GROUP_ASC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_COUNT_UNIT_GROUP_DESC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_COUNT_UPDATED_AT_ASC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_COUNT_UPDATED_AT_DESC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_COUNT_WMS_ASC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_COUNT_WMS_DESC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_COUNT_ZIP_ASC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_COUNT_ZIP_DESC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_CREATED_AT_ASC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_CREATED_AT_DESC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_CUSTOMER_LOCATION_ID_ASC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_CUSTOMER_LOCATION_ID_DESC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_FACILITY_CONTACTS_ASC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_FACILITY_CONTACTS_DESC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_GEOMETRY_ASC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_GEOMETRY_DESC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_GO_LIVE_DATE_ASC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_GO_LIVE_DATE_DESC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_ID_ASC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_ID_DESC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_LATITUDE_ASC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_LATITUDE_DESC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_LINK_ACTIVE_ASC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_LINK_ACTIVE_DESC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_LONGITUDE_ASC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_LONGITUDE_DESC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_METRICS_ONE_ACTIVE_ASC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_METRICS_ONE_ACTIVE_DESC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_NAME_ASC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_NAME_DESC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_N_SIGHT_2_ACTIVE_ASC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_N_SIGHT_2_ACTIVE_DESC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_N_SIGHT_ACTIVE_ASC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_N_SIGHT_ACTIVE_DESC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_PRE_BONUS_EBITDA_ASC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_PRE_BONUS_EBITDA_DESC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_PRICING_NODE_ID_ASC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_PRICING_NODE_ID_DESC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_REAL_TIME_ENABLED_ASC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_REAL_TIME_ENABLED_DESC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_RETIRED_AT_ASC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_RETIRED_AT_DESC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_SLUG_ASC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_SLUG_DESC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_STATE_ASC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_STATE_DESC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_SUPPRESSE_FINANCIALS_ASC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_SUPPRESSE_FINANCIALS_DESC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_TIMEZONE_NAME_ASC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_TIMEZONE_NAME_DESC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_TYPE_ASC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_TYPE_DESC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_UNIT_GROUP_ASC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_UNIT_GROUP_DESC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_UPDATED_AT_ASC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_UPDATED_AT_DESC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_WMS_ASC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_WMS_DESC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_ZIP_ASC', 'FACILITIES_BY_TIMEZONE_NAME_DISTINCT_ZIP_DESC', 'FACILITIES_BY_TIMEZONE_NAME_MAX_ADDRESS_ASC', 'FACILITIES_BY_TIMEZONE_NAME_MAX_ADDRESS_DESC', 'FACILITIES_BY_TIMEZONE_NAME_MAX_BONUS_LTR_ASC', 'FACILITIES_BY_TIMEZONE_NAME_MAX_BONUS_LTR_DESC', 'FACILITIES_BY_TIMEZONE_NAME_MAX_CITY_ASC', 'FACILITIES_BY_TIMEZONE_NAME_MAX_CITY_DESC', 'FACILITIES_BY_TIMEZONE_NAME_MAX_COMMODITY_ASC', 'FACILITIES_BY_TIMEZONE_NAME_MAX_COMMODITY_DESC', 'FACILITIES_BY_TIMEZONE_NAME_MAX_COST_CENTER_ASC', 'FACILITIES_BY_TIMEZONE_NAME_MAX_COST_CENTER_DESC', 'FACILITIES_BY_TIMEZONE_NAME_MAX_COUNTRY_ASC', 'FACILITIES_BY_TIMEZONE_NAME_MAX_COUNTRY_DESC', 'FACILITIES_BY_TIMEZONE_NAME_MAX_CREATED_AT_ASC', 'FACILITIES_BY_TIMEZONE_NAME_MAX_CREATED_AT_DESC', 'FACILITIES_BY_TIMEZONE_NAME_MAX_CUSTOMER_LOCATION_ID_ASC', 'FACILITIES_BY_TIMEZONE_NAME_MAX_CUSTOMER_LOCATION_ID_DESC', 'FACILITIES_BY_TIMEZONE_NAME_MAX_FACILITY_CONTACTS_ASC', 'FACILITIES_BY_TIMEZONE_NAME_MAX_FACILITY_CONTACTS_DESC', 'FACILITIES_BY_TIMEZONE_NAME_MAX_GEOMETRY_ASC', 'FACILITIES_BY_TIMEZONE_NAME_MAX_GEOMETRY_DESC', 'FACILITIES_BY_TIMEZONE_NAME_MAX_GO_LIVE_DATE_ASC', 'FACILITIES_BY_TIMEZONE_NAME_MAX_GO_LIVE_DATE_DESC', 'FACILITIES_BY_TIMEZONE_NAME_MAX_ID_ASC', 'FACILITIES_BY_TIMEZONE_NAME_MAX_ID_DESC', 'FACILITIES_BY_TIMEZONE_NAME_MAX_LATITUDE_ASC', 'FACILITIES_BY_TIMEZONE_NAME_MAX_LATITUDE_DESC', 'FACILITIES_BY_TIMEZONE_NAME_MAX_LINK_ACTIVE_ASC', 'FACILITIES_BY_TIMEZONE_NAME_MAX_LINK_ACTIVE_DESC', 'FACILITIES_BY_TIMEZONE_NAME_MAX_LONGITUDE_ASC', 'FACILITIES_BY_TIMEZONE_NAME_MAX_LONGITUDE_DESC', 'FACILITIES_BY_TIMEZONE_NAME_MAX_METRICS_ONE_ACTIVE_ASC', 'FACILITIES_BY_TIMEZONE_NAME_MAX_METRICS_ONE_ACTIVE_DESC', 'FACILITIES_BY_TIMEZONE_NAME_MAX_NAME_ASC', 'FACILITIES_BY_TIMEZONE_NAME_MAX_NAME_DESC', 'FACILITIES_BY_TIMEZONE_NAME_MAX_N_SIGHT_2_ACTIVE_ASC', 'FACILITIES_BY_TIMEZONE_NAME_MAX_N_SIGHT_2_ACTIVE_DESC', 'FACILITIES_BY_TIMEZONE_NAME_MAX_N_SIGHT_ACTIVE_ASC', 'FACILITIES_BY_TIMEZONE_NAME_MAX_N_SIGHT_ACTIVE_DESC', 'FACILITIES_BY_TIMEZONE_NAME_MAX_PRE_BONUS_EBITDA_ASC', 'FACILITIES_BY_TIMEZONE_NAME_MAX_PRE_BONUS_EBITDA_DESC', 'FACILITIES_BY_TIMEZONE_NAME_MAX_PRICING_NODE_ID_ASC', 'FACILITIES_BY_TIMEZONE_NAME_MAX_PRICING_NODE_ID_DESC', 'FACILITIES_BY_TIMEZONE_NAME_MAX_REAL_TIME_ENABLED_ASC', 'FACILITIES_BY_TIMEZONE_NAME_MAX_REAL_TIME_ENABLED_DESC', 'FACILITIES_BY_TIMEZONE_NAME_MAX_RETIRED_AT_ASC', 'FACILITIES_BY_TIMEZONE_NAME_MAX_RETIRED_AT_DESC', 'FACILITIES_BY_TIMEZONE_NAME_MAX_SLUG_ASC', 'FACILITIES_BY_TIMEZONE_NAME_MAX_SLUG_DESC', 'FACILITIES_BY_TIMEZONE_NAME_MAX_STATE_ASC', 'FACILITIES_BY_TIMEZONE_NAME_MAX_STATE_DESC', 'FACILITIES_BY_TIMEZONE_NAME_MAX_SUPPRESSE_FINANCIALS_ASC', 'FACILITIES_BY_TIMEZONE_NAME_MAX_SUPPRESSE_FINANCIALS_DESC', 'FACILITIES_BY_TIMEZONE_NAME_MAX_TIMEZONE_NAME_ASC', 'FACILITIES_BY_TIMEZONE_NAME_MAX_TIMEZONE_NAME_DESC', 'FACILITIES_BY_TIMEZONE_NAME_MAX_TYPE_ASC', 'FACILITIES_BY_TIMEZONE_NAME_MAX_TYPE_DESC', 'FACILITIES_BY_TIMEZONE_NAME_MAX_UNIT_GROUP_ASC', 'FACILITIES_BY_TIMEZONE_NAME_MAX_UNIT_GROUP_DESC', 'FACILITIES_BY_TIMEZONE_NAME_MAX_UPDATED_AT_ASC', 'FACILITIES_BY_TIMEZONE_NAME_MAX_UPDATED_AT_DESC', 'FACILITIES_BY_TIMEZONE_NAME_MAX_WMS_ASC', 'FACILITIES_BY_TIMEZONE_NAME_MAX_WMS_DESC', 'FACILITIES_BY_TIMEZONE_NAME_MAX_ZIP_ASC', 'FACILITIES_BY_TIMEZONE_NAME_MAX_ZIP_DESC', 'FACILITIES_BY_TIMEZONE_NAME_MIN_ADDRESS_ASC', 'FACILITIES_BY_TIMEZONE_NAME_MIN_ADDRESS_DESC', 'FACILITIES_BY_TIMEZONE_NAME_MIN_BONUS_LTR_ASC', 'FACILITIES_BY_TIMEZONE_NAME_MIN_BONUS_LTR_DESC', 'FACILITIES_BY_TIMEZONE_NAME_MIN_CITY_ASC', 'FACILITIES_BY_TIMEZONE_NAME_MIN_CITY_DESC', 'FACILITIES_BY_TIMEZONE_NAME_MIN_COMMODITY_ASC', 'FACILITIES_BY_TIMEZONE_NAME_MIN_COMMODITY_DESC', 'FACILITIES_BY_TIMEZONE_NAME_MIN_COST_CENTER_ASC', 'FACILITIES_BY_TIMEZONE_NAME_MIN_COST_CENTER_DESC', 'FACILITIES_BY_TIMEZONE_NAME_MIN_COUNTRY_ASC', 'FACILITIES_BY_TIMEZONE_NAME_MIN_COUNTRY_DESC', 'FACILITIES_BY_TIMEZONE_NAME_MIN_CREATED_AT_ASC', 'FACILITIES_BY_TIMEZONE_NAME_MIN_CREATED_AT_DESC', 'FACILITIES_BY_TIMEZONE_NAME_MIN_CUSTOMER_LOCATION_ID_ASC', 'FACILITIES_BY_TIMEZONE_NAME_MIN_CUSTOMER_LOCATION_ID_DESC', 'FACILITIES_BY_TIMEZONE_NAME_MIN_FACILITY_CONTACTS_ASC', 'FACILITIES_BY_TIMEZONE_NAME_MIN_FACILITY_CONTACTS_DESC', 'FACILITIES_BY_TIMEZONE_NAME_MIN_GEOMETRY_ASC', 'FACILITIES_BY_TIMEZONE_NAME_MIN_GEOMETRY_DESC', 'FACILITIES_BY_TIMEZONE_NAME_MIN_GO_LIVE_DATE_ASC', 'FACILITIES_BY_TIMEZONE_NAME_MIN_GO_LIVE_DATE_DESC', 'FACILITIES_BY_TIMEZONE_NAME_MIN_ID_ASC', 'FACILITIES_BY_TIMEZONE_NAME_MIN_ID_DESC', 'FACILITIES_BY_TIMEZONE_NAME_MIN_LATITUDE_ASC', 'FACILITIES_BY_TIMEZONE_NAME_MIN_LATITUDE_DESC', 'FACILITIES_BY_TIMEZONE_NAME_MIN_LINK_ACTIVE_ASC', 'FACILITIES_BY_TIMEZONE_NAME_MIN_LINK_ACTIVE_DESC', 'FACILITIES_BY_TIMEZONE_NAME_MIN_LONGITUDE_ASC', 'FACILITIES_BY_TIMEZONE_NAME_MIN_LONGITUDE_DESC', 'FACILITIES_BY_TIMEZONE_NAME_MIN_METRICS_ONE_ACTIVE_ASC', 'FACILITIES_BY_TIMEZONE_NAME_MIN_METRICS_ONE_ACTIVE_DESC', 'FACILITIES_BY_TIMEZONE_NAME_MIN_NAME_ASC', 'FACILITIES_BY_TIMEZONE_NAME_MIN_NAME_DESC', 'FACILITIES_BY_TIMEZONE_NAME_MIN_N_SIGHT_2_ACTIVE_ASC', 'FACILITIES_BY_TIMEZONE_NAME_MIN_N_SIGHT_2_ACTIVE_DESC', 'FACILITIES_BY_TIMEZONE_NAME_MIN_N_SIGHT_ACTIVE_ASC', 'FACILITIES_BY_TIMEZONE_NAME_MIN_N_SIGHT_ACTIVE_DESC', 'FACILITIES_BY_TIMEZONE_NAME_MIN_PRE_BONUS_EBITDA_ASC', 'FACILITIES_BY_TIMEZONE_NAME_MIN_PRE_BONUS_EBITDA_DESC', 'FACILITIES_BY_TIMEZONE_NAME_MIN_PRICING_NODE_ID_ASC', 'FACILITIES_BY_TIMEZONE_NAME_MIN_PRICING_NODE_ID_DESC', 'FACILITIES_BY_TIMEZONE_NAME_MIN_REAL_TIME_ENABLED_ASC', 'FACILITIES_BY_TIMEZONE_NAME_MIN_REAL_TIME_ENABLED_DESC', 'FACILITIES_BY_TIMEZONE_NAME_MIN_RETIRED_AT_ASC', 'FACILITIES_BY_TIMEZONE_NAME_MIN_RETIRED_AT_DESC', 'FACILITIES_BY_TIMEZONE_NAME_MIN_SLUG_ASC', 'FACILITIES_BY_TIMEZONE_NAME_MIN_SLUG_DESC', 'FACILITIES_BY_TIMEZONE_NAME_MIN_STATE_ASC', 'FACILITIES_BY_TIMEZONE_NAME_MIN_STATE_DESC', 'FACILITIES_BY_TIMEZONE_NAME_MIN_SUPPRESSE_FINANCIALS_ASC', 'FACILITIES_BY_TIMEZONE_NAME_MIN_SUPPRESSE_FINANCIALS_DESC', 'FACILITIES_BY_TIMEZONE_NAME_MIN_TIMEZONE_NAME_ASC', 'FACILITIES_BY_TIMEZONE_NAME_MIN_TIMEZONE_NAME_DESC', 'FACILITIES_BY_TIMEZONE_NAME_MIN_TYPE_ASC', 'FACILITIES_BY_TIMEZONE_NAME_MIN_TYPE_DESC', 'FACILITIES_BY_TIMEZONE_NAME_MIN_UNIT_GROUP_ASC', 'FACILITIES_BY_TIMEZONE_NAME_MIN_UNIT_GROUP_DESC', 'FACILITIES_BY_TIMEZONE_NAME_MIN_UPDATED_AT_ASC', 'FACILITIES_BY_TIMEZONE_NAME_MIN_UPDATED_AT_DESC', 'FACILITIES_BY_TIMEZONE_NAME_MIN_WMS_ASC', 'FACILITIES_BY_TIMEZONE_NAME_MIN_WMS_DESC', 'FACILITIES_BY_TIMEZONE_NAME_MIN_ZIP_ASC', 'FACILITIES_BY_TIMEZONE_NAME_MIN_ZIP_DESC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_POPULATION_ADDRESS_ASC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_POPULATION_ADDRESS_DESC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_POPULATION_BONUS_LTR_ASC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_POPULATION_BONUS_LTR_DESC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_POPULATION_CITY_ASC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_POPULATION_CITY_DESC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_POPULATION_COMMODITY_ASC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_POPULATION_COMMODITY_DESC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_POPULATION_COST_CENTER_ASC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_POPULATION_COST_CENTER_DESC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_POPULATION_COUNTRY_ASC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_POPULATION_COUNTRY_DESC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_POPULATION_CREATED_AT_ASC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_POPULATION_CREATED_AT_DESC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_POPULATION_CUSTOMER_LOCATION_ID_ASC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_POPULATION_CUSTOMER_LOCATION_ID_DESC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_POPULATION_FACILITY_CONTACTS_ASC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_POPULATION_FACILITY_CONTACTS_DESC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_POPULATION_GEOMETRY_ASC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_POPULATION_GEOMETRY_DESC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_POPULATION_GO_LIVE_DATE_ASC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_POPULATION_GO_LIVE_DATE_DESC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_POPULATION_ID_ASC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_POPULATION_ID_DESC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_POPULATION_LATITUDE_ASC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_POPULATION_LATITUDE_DESC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_POPULATION_LINK_ACTIVE_ASC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_POPULATION_LINK_ACTIVE_DESC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_POPULATION_LONGITUDE_ASC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_POPULATION_LONGITUDE_DESC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_POPULATION_METRICS_ONE_ACTIVE_ASC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_POPULATION_METRICS_ONE_ACTIVE_DESC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_POPULATION_NAME_ASC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_POPULATION_NAME_DESC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_POPULATION_N_SIGHT_2_ACTIVE_ASC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_POPULATION_N_SIGHT_2_ACTIVE_DESC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_POPULATION_N_SIGHT_ACTIVE_ASC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_POPULATION_N_SIGHT_ACTIVE_DESC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_POPULATION_PRE_BONUS_EBITDA_ASC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_POPULATION_PRE_BONUS_EBITDA_DESC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_POPULATION_PRICING_NODE_ID_ASC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_POPULATION_PRICING_NODE_ID_DESC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_POPULATION_REAL_TIME_ENABLED_ASC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_POPULATION_REAL_TIME_ENABLED_DESC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_POPULATION_RETIRED_AT_ASC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_POPULATION_RETIRED_AT_DESC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_POPULATION_SLUG_ASC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_POPULATION_SLUG_DESC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_POPULATION_STATE_ASC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_POPULATION_STATE_DESC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_POPULATION_SUPPRESSE_FINANCIALS_ASC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_POPULATION_SUPPRESSE_FINANCIALS_DESC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_POPULATION_TIMEZONE_NAME_ASC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_POPULATION_TIMEZONE_NAME_DESC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_POPULATION_TYPE_ASC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_POPULATION_TYPE_DESC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_POPULATION_UNIT_GROUP_ASC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_POPULATION_UNIT_GROUP_DESC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_POPULATION_UPDATED_AT_ASC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_POPULATION_UPDATED_AT_DESC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_POPULATION_WMS_ASC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_POPULATION_WMS_DESC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_POPULATION_ZIP_ASC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_POPULATION_ZIP_DESC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_SAMPLE_ADDRESS_ASC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_SAMPLE_ADDRESS_DESC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_SAMPLE_BONUS_LTR_ASC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_SAMPLE_BONUS_LTR_DESC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_SAMPLE_CITY_ASC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_SAMPLE_CITY_DESC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_SAMPLE_COMMODITY_ASC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_SAMPLE_COMMODITY_DESC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_SAMPLE_COST_CENTER_ASC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_SAMPLE_COST_CENTER_DESC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_SAMPLE_COUNTRY_ASC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_SAMPLE_COUNTRY_DESC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_SAMPLE_CREATED_AT_ASC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_SAMPLE_CREATED_AT_DESC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_SAMPLE_CUSTOMER_LOCATION_ID_ASC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_SAMPLE_CUSTOMER_LOCATION_ID_DESC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_SAMPLE_FACILITY_CONTACTS_ASC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_SAMPLE_FACILITY_CONTACTS_DESC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_SAMPLE_GEOMETRY_ASC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_SAMPLE_GEOMETRY_DESC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_SAMPLE_GO_LIVE_DATE_ASC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_SAMPLE_GO_LIVE_DATE_DESC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_SAMPLE_ID_ASC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_SAMPLE_ID_DESC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_SAMPLE_LATITUDE_ASC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_SAMPLE_LATITUDE_DESC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_SAMPLE_LINK_ACTIVE_ASC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_SAMPLE_LINK_ACTIVE_DESC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_SAMPLE_LONGITUDE_ASC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_SAMPLE_LONGITUDE_DESC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_SAMPLE_METRICS_ONE_ACTIVE_ASC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_SAMPLE_METRICS_ONE_ACTIVE_DESC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_SAMPLE_NAME_ASC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_SAMPLE_NAME_DESC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_SAMPLE_N_SIGHT_2_ACTIVE_ASC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_SAMPLE_N_SIGHT_2_ACTIVE_DESC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_SAMPLE_N_SIGHT_ACTIVE_ASC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_SAMPLE_N_SIGHT_ACTIVE_DESC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_SAMPLE_PRE_BONUS_EBITDA_ASC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_SAMPLE_PRE_BONUS_EBITDA_DESC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_SAMPLE_PRICING_NODE_ID_ASC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_SAMPLE_PRICING_NODE_ID_DESC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_SAMPLE_REAL_TIME_ENABLED_ASC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_SAMPLE_REAL_TIME_ENABLED_DESC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_SAMPLE_RETIRED_AT_ASC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_SAMPLE_RETIRED_AT_DESC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_SAMPLE_SLUG_ASC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_SAMPLE_SLUG_DESC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_SAMPLE_STATE_ASC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_SAMPLE_STATE_DESC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_SAMPLE_SUPPRESSE_FINANCIALS_ASC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_SAMPLE_SUPPRESSE_FINANCIALS_DESC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_SAMPLE_TIMEZONE_NAME_ASC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_SAMPLE_TIMEZONE_NAME_DESC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_SAMPLE_TYPE_ASC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_SAMPLE_TYPE_DESC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_SAMPLE_UNIT_GROUP_ASC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_SAMPLE_UNIT_GROUP_DESC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_SAMPLE_UPDATED_AT_ASC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_SAMPLE_UPDATED_AT_DESC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_SAMPLE_WMS_ASC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_SAMPLE_WMS_DESC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_SAMPLE_ZIP_ASC', 'FACILITIES_BY_TIMEZONE_NAME_STDDEV_SAMPLE_ZIP_DESC', 'FACILITIES_BY_TIMEZONE_NAME_SUM_ADDRESS_ASC', 'FACILITIES_BY_TIMEZONE_NAME_SUM_ADDRESS_DESC', 'FACILITIES_BY_TIMEZONE_NAME_SUM_BONUS_LTR_ASC', 'FACILITIES_BY_TIMEZONE_NAME_SUM_BONUS_LTR_DESC', 'FACILITIES_BY_TIMEZONE_NAME_SUM_CITY_ASC', 'FACILITIES_BY_TIMEZONE_NAME_SUM_CITY_DESC', 'FACILITIES_BY_TIMEZONE_NAME_SUM_COMMODITY_ASC', 'FACILITIES_BY_TIMEZONE_NAME_SUM_COMMODITY_DESC', 'FACILITIES_BY_TIMEZONE_NAME_SUM_COST_CENTER_ASC', 'FACILITIES_BY_TIMEZONE_NAME_SUM_COST_CENTER_DESC', 'FACILITIES_BY_TIMEZONE_NAME_SUM_COUNTRY_ASC', 'FACILITIES_BY_TIMEZONE_NAME_SUM_COUNTRY_DESC', 'FACILITIES_BY_TIMEZONE_NAME_SUM_CREATED_AT_ASC', 'FACILITIES_BY_TIMEZONE_NAME_SUM_CREATED_AT_DESC', 'FACILITIES_BY_TIMEZONE_NAME_SUM_CUSTOMER_LOCATION_ID_ASC', 'FACILITIES_BY_TIMEZONE_NAME_SUM_CUSTOMER_LOCATION_ID_DESC', 'FACILITIES_BY_TIMEZONE_NAME_SUM_FACILITY_CONTACTS_ASC', 'FACILITIES_BY_TIMEZONE_NAME_SUM_FACILITY_CONTACTS_DESC', 'FACILITIES_BY_TIMEZONE_NAME_SUM_GEOMETRY_ASC', 'FACILITIES_BY_TIMEZONE_NAME_SUM_GEOMETRY_DESC', 'FACILITIES_BY_TIMEZONE_NAME_SUM_GO_LIVE_DATE_ASC', 'FACILITIES_BY_TIMEZONE_NAME_SUM_GO_LIVE_DATE_DESC', 'FACILITIES_BY_TIMEZONE_NAME_SUM_ID_ASC', 'FACILITIES_BY_TIMEZONE_NAME_SUM_ID_DESC', 'FACILITIES_BY_TIMEZONE_NAME_SUM_LATITUDE_ASC', 'FACILITIES_BY_TIMEZONE_NAME_SUM_LATITUDE_DESC', 'FACILITIES_BY_TIMEZONE_NAME_SUM_LINK_ACTIVE_ASC', 'FACILITIES_BY_TIMEZONE_NAME_SUM_LINK_ACTIVE_DESC', 'FACILITIES_BY_TIMEZONE_NAME_SUM_LONGITUDE_ASC', 'FACILITIES_BY_TIMEZONE_NAME_SUM_LONGITUDE_DESC', 'FACILITIES_BY_TIMEZONE_NAME_SUM_METRICS_ONE_ACTIVE_ASC', 'FACILITIES_BY_TIMEZONE_NAME_SUM_METRICS_ONE_ACTIVE_DESC', 'FACILITIES_BY_TIMEZONE_NAME_SUM_NAME_ASC', 'FACILITIES_BY_TIMEZONE_NAME_SUM_NAME_DESC', 'FACILITIES_BY_TIMEZONE_NAME_SUM_N_SIGHT_2_ACTIVE_ASC', 'FACILITIES_BY_TIMEZONE_NAME_SUM_N_SIGHT_2_ACTIVE_DESC', 'FACILITIES_BY_TIMEZONE_NAME_SUM_N_SIGHT_ACTIVE_ASC', 'FACILITIES_BY_TIMEZONE_NAME_SUM_N_SIGHT_ACTIVE_DESC', 'FACILITIES_BY_TIMEZONE_NAME_SUM_PRE_BONUS_EBITDA_ASC', 'FACILITIES_BY_TIMEZONE_NAME_SUM_PRE_BONUS_EBITDA_DESC', 'FACILITIES_BY_TIMEZONE_NAME_SUM_PRICING_NODE_ID_ASC', 'FACILITIES_BY_TIMEZONE_NAME_SUM_PRICING_NODE_ID_DESC', 'FACILITIES_BY_TIMEZONE_NAME_SUM_REAL_TIME_ENABLED_ASC', 'FACILITIES_BY_TIMEZONE_NAME_SUM_REAL_TIME_ENABLED_DESC', 'FACILITIES_BY_TIMEZONE_NAME_SUM_RETIRED_AT_ASC', 'FACILITIES_BY_TIMEZONE_NAME_SUM_RETIRED_AT_DESC', 'FACILITIES_BY_TIMEZONE_NAME_SUM_SLUG_ASC', 'FACILITIES_BY_TIMEZONE_NAME_SUM_SLUG_DESC', 'FACILITIES_BY_TIMEZONE_NAME_SUM_STATE_ASC', 'FACILITIES_BY_TIMEZONE_NAME_SUM_STATE_DESC', 'FACILITIES_BY_TIMEZONE_NAME_SUM_SUPPRESSE_FINANCIALS_ASC', 'FACILITIES_BY_TIMEZONE_NAME_SUM_SUPPRESSE_FINANCIALS_DESC', 'FACILITIES_BY_TIMEZONE_NAME_SUM_TIMEZONE_NAME_ASC', 'FACILITIES_BY_TIMEZONE_NAME_SUM_TIMEZONE_NAME_DESC', 'FACILITIES_BY_TIMEZONE_NAME_SUM_TYPE_ASC', 'FACILITIES_BY_TIMEZONE_NAME_SUM_TYPE_DESC', 'FACILITIES_BY_TIMEZONE_NAME_SUM_UNIT_GROUP_ASC', 'FACILITIES_BY_TIMEZONE_NAME_SUM_UNIT_GROUP_DESC', 'FACILITIES_BY_TIMEZONE_NAME_SUM_UPDATED_AT_ASC', 'FACILITIES_BY_TIMEZONE_NAME_SUM_UPDATED_AT_DESC', 'FACILITIES_BY_TIMEZONE_NAME_SUM_WMS_ASC', 'FACILITIES_BY_TIMEZONE_NAME_SUM_WMS_DESC', 'FACILITIES_BY_TIMEZONE_NAME_SUM_ZIP_ASC', 'FACILITIES_BY_TIMEZONE_NAME_SUM_ZIP_DESC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_POPULATION_ADDRESS_ASC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_POPULATION_ADDRESS_DESC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_POPULATION_BONUS_LTR_ASC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_POPULATION_BONUS_LTR_DESC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_POPULATION_CITY_ASC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_POPULATION_CITY_DESC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_POPULATION_COMMODITY_ASC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_POPULATION_COMMODITY_DESC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_POPULATION_COST_CENTER_ASC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_POPULATION_COST_CENTER_DESC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_POPULATION_COUNTRY_ASC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_POPULATION_COUNTRY_DESC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_POPULATION_CREATED_AT_ASC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_POPULATION_CREATED_AT_DESC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_POPULATION_CUSTOMER_LOCATION_ID_ASC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_POPULATION_CUSTOMER_LOCATION_ID_DESC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_POPULATION_FACILITY_CONTACTS_ASC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_POPULATION_FACILITY_CONTACTS_DESC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_POPULATION_GEOMETRY_ASC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_POPULATION_GEOMETRY_DESC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_POPULATION_GO_LIVE_DATE_ASC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_POPULATION_GO_LIVE_DATE_DESC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_POPULATION_ID_ASC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_POPULATION_ID_DESC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_POPULATION_LATITUDE_ASC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_POPULATION_LATITUDE_DESC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_POPULATION_LINK_ACTIVE_ASC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_POPULATION_LINK_ACTIVE_DESC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_POPULATION_LONGITUDE_ASC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_POPULATION_LONGITUDE_DESC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_POPULATION_METRICS_ONE_ACTIVE_ASC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_POPULATION_METRICS_ONE_ACTIVE_DESC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_POPULATION_NAME_ASC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_POPULATION_NAME_DESC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_POPULATION_N_SIGHT_2_ACTIVE_ASC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_POPULATION_N_SIGHT_2_ACTIVE_DESC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_POPULATION_N_SIGHT_ACTIVE_ASC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_POPULATION_N_SIGHT_ACTIVE_DESC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_POPULATION_PRE_BONUS_EBITDA_ASC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_POPULATION_PRE_BONUS_EBITDA_DESC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_POPULATION_PRICING_NODE_ID_ASC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_POPULATION_PRICING_NODE_ID_DESC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_POPULATION_REAL_TIME_ENABLED_ASC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_POPULATION_REAL_TIME_ENABLED_DESC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_POPULATION_RETIRED_AT_ASC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_POPULATION_RETIRED_AT_DESC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_POPULATION_SLUG_ASC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_POPULATION_SLUG_DESC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_POPULATION_STATE_ASC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_POPULATION_STATE_DESC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_POPULATION_SUPPRESSE_FINANCIALS_ASC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_POPULATION_SUPPRESSE_FINANCIALS_DESC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_POPULATION_TIMEZONE_NAME_ASC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_POPULATION_TIMEZONE_NAME_DESC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_POPULATION_TYPE_ASC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_POPULATION_TYPE_DESC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_POPULATION_UNIT_GROUP_ASC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_POPULATION_UNIT_GROUP_DESC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_POPULATION_UPDATED_AT_ASC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_POPULATION_UPDATED_AT_DESC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_POPULATION_WMS_ASC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_POPULATION_WMS_DESC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_POPULATION_ZIP_ASC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_POPULATION_ZIP_DESC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_SAMPLE_ADDRESS_ASC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_SAMPLE_ADDRESS_DESC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_SAMPLE_BONUS_LTR_ASC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_SAMPLE_BONUS_LTR_DESC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_SAMPLE_CITY_ASC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_SAMPLE_CITY_DESC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_SAMPLE_COMMODITY_ASC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_SAMPLE_COMMODITY_DESC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_SAMPLE_COST_CENTER_ASC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_SAMPLE_COST_CENTER_DESC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_SAMPLE_COUNTRY_ASC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_SAMPLE_COUNTRY_DESC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_SAMPLE_CREATED_AT_ASC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_SAMPLE_CREATED_AT_DESC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_SAMPLE_CUSTOMER_LOCATION_ID_ASC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_SAMPLE_CUSTOMER_LOCATION_ID_DESC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_SAMPLE_FACILITY_CONTACTS_ASC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_SAMPLE_FACILITY_CONTACTS_DESC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_SAMPLE_GEOMETRY_ASC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_SAMPLE_GEOMETRY_DESC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_SAMPLE_GO_LIVE_DATE_ASC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_SAMPLE_GO_LIVE_DATE_DESC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_SAMPLE_ID_ASC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_SAMPLE_ID_DESC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_SAMPLE_LATITUDE_ASC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_SAMPLE_LATITUDE_DESC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_SAMPLE_LINK_ACTIVE_ASC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_SAMPLE_LINK_ACTIVE_DESC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_SAMPLE_LONGITUDE_ASC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_SAMPLE_LONGITUDE_DESC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_SAMPLE_METRICS_ONE_ACTIVE_ASC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_SAMPLE_METRICS_ONE_ACTIVE_DESC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_SAMPLE_NAME_ASC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_SAMPLE_NAME_DESC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_SAMPLE_N_SIGHT_2_ACTIVE_ASC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_SAMPLE_N_SIGHT_2_ACTIVE_DESC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_SAMPLE_N_SIGHT_ACTIVE_ASC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_SAMPLE_N_SIGHT_ACTIVE_DESC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_SAMPLE_PRE_BONUS_EBITDA_ASC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_SAMPLE_PRE_BONUS_EBITDA_DESC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_SAMPLE_PRICING_NODE_ID_ASC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_SAMPLE_PRICING_NODE_ID_DESC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_SAMPLE_REAL_TIME_ENABLED_ASC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_SAMPLE_REAL_TIME_ENABLED_DESC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_SAMPLE_RETIRED_AT_ASC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_SAMPLE_RETIRED_AT_DESC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_SAMPLE_SLUG_ASC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_SAMPLE_SLUG_DESC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_SAMPLE_STATE_ASC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_SAMPLE_STATE_DESC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_SAMPLE_SUPPRESSE_FINANCIALS_ASC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_SAMPLE_SUPPRESSE_FINANCIALS_DESC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_SAMPLE_TIMEZONE_NAME_ASC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_SAMPLE_TIMEZONE_NAME_DESC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_SAMPLE_TYPE_ASC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_SAMPLE_TYPE_DESC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_SAMPLE_UNIT_GROUP_ASC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_SAMPLE_UNIT_GROUP_DESC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_SAMPLE_UPDATED_AT_ASC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_SAMPLE_UPDATED_AT_DESC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_SAMPLE_WMS_ASC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_SAMPLE_WMS_DESC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_SAMPLE_ZIP_ASC', 'FACILITIES_BY_TIMEZONE_NAME_VARIANCE_SAMPLE_ZIP_DESC', 'IS_DST_ASC', 'IS_DST_DESC', 'NAME_ASC', 'NAME_DESC', 'NATURAL', 'PRIMARY_KEY_ASC', 'PRIMARY_KEY_DESC', 'UTC_OFFSET_ASC', 'UTC_OFFSET_DESC')


class UUID(sgqlc.types.Scalar):
    __schema__ = nionic_schema


class UnitDimensionsOrderBy(sgqlc.types.Enum):
    __schema__ = nionic_schema
    __choices__ = ('NAME_ASC', 'NAME_DESC', 'NATURAL', 'PRIMARY_KEY_ASC', 'PRIMARY_KEY_DESC')


class UnitGroupDimensionsOrderBy(sgqlc.types.Enum):
    __schema__ = nionic_schema
    __choices__ = ('CREATED_AT_ASC', 'CREATED_AT_DESC', 'NATURAL', 'PRIMARY_KEY_ASC', 'PRIMARY_KEY_DESC', 'UNIT_ASC', 'UNIT_DESC', 'UNIT_DIMENSION_ASC', 'UNIT_DIMENSION_DESC', 'UNIT_GROUP_ASC', 'UNIT_GROUP_DESC', 'UPDATED_AT_ASC', 'UPDATED_AT_DESC')


class UnitGroupsOrderBy(sgqlc.types.Enum):
    __schema__ = nionic_schema
    __choices__ = ('FACILITIES_BY_UNIT_GROUP_AVERAGE_ADDRESS_ASC', 'FACILITIES_BY_UNIT_GROUP_AVERAGE_ADDRESS_DESC', 'FACILITIES_BY_UNIT_GROUP_AVERAGE_BONUS_LTR_ASC', 'FACILITIES_BY_UNIT_GROUP_AVERAGE_BONUS_LTR_DESC', 'FACILITIES_BY_UNIT_GROUP_AVERAGE_CITY_ASC', 'FACILITIES_BY_UNIT_GROUP_AVERAGE_CITY_DESC', 'FACILITIES_BY_UNIT_GROUP_AVERAGE_COMMODITY_ASC', 'FACILITIES_BY_UNIT_GROUP_AVERAGE_COMMODITY_DESC', 'FACILITIES_BY_UNIT_GROUP_AVERAGE_COST_CENTER_ASC', 'FACILITIES_BY_UNIT_GROUP_AVERAGE_COST_CENTER_DESC', 'FACILITIES_BY_UNIT_GROUP_AVERAGE_COUNTRY_ASC', 'FACILITIES_BY_UNIT_GROUP_AVERAGE_COUNTRY_DESC', 'FACILITIES_BY_UNIT_GROUP_AVERAGE_CREATED_AT_ASC', 'FACILITIES_BY_UNIT_GROUP_AVERAGE_CREATED_AT_DESC', 'FACILITIES_BY_UNIT_GROUP_AVERAGE_CUSTOMER_LOCATION_ID_ASC', 'FACILITIES_BY_UNIT_GROUP_AVERAGE_CUSTOMER_LOCATION_ID_DESC', 'FACILITIES_BY_UNIT_GROUP_AVERAGE_FACILITY_CONTACTS_ASC', 'FACILITIES_BY_UNIT_GROUP_AVERAGE_FACILITY_CONTACTS_DESC', 'FACILITIES_BY_UNIT_GROUP_AVERAGE_GEOMETRY_ASC', 'FACILITIES_BY_UNIT_GROUP_AVERAGE_GEOMETRY_DESC', 'FACILITIES_BY_UNIT_GROUP_AVERAGE_GO_LIVE_DATE_ASC', 'FACILITIES_BY_UNIT_GROUP_AVERAGE_GO_LIVE_DATE_DESC', 'FACILITIES_BY_UNIT_GROUP_AVERAGE_ID_ASC', 'FACILITIES_BY_UNIT_GROUP_AVERAGE_ID_DESC', 'FACILITIES_BY_UNIT_GROUP_AVERAGE_LATITUDE_ASC', 'FACILITIES_BY_UNIT_GROUP_AVERAGE_LATITUDE_DESC', 'FACILITIES_BY_UNIT_GROUP_AVERAGE_LINK_ACTIVE_ASC', 'FACILITIES_BY_UNIT_GROUP_AVERAGE_LINK_ACTIVE_DESC', 'FACILITIES_BY_UNIT_GROUP_AVERAGE_LONGITUDE_ASC', 'FACILITIES_BY_UNIT_GROUP_AVERAGE_LONGITUDE_DESC', 'FACILITIES_BY_UNIT_GROUP_AVERAGE_METRICS_ONE_ACTIVE_ASC', 'FACILITIES_BY_UNIT_GROUP_AVERAGE_METRICS_ONE_ACTIVE_DESC', 'FACILITIES_BY_UNIT_GROUP_AVERAGE_NAME_ASC', 'FACILITIES_BY_UNIT_GROUP_AVERAGE_NAME_DESC', 'FACILITIES_BY_UNIT_GROUP_AVERAGE_N_SIGHT_2_ACTIVE_ASC', 'FACILITIES_BY_UNIT_GROUP_AVERAGE_N_SIGHT_2_ACTIVE_DESC', 'FACILITIES_BY_UNIT_GROUP_AVERAGE_N_SIGHT_ACTIVE_ASC', 'FACILITIES_BY_UNIT_GROUP_AVERAGE_N_SIGHT_ACTIVE_DESC', 'FACILITIES_BY_UNIT_GROUP_AVERAGE_PRE_BONUS_EBITDA_ASC', 'FACILITIES_BY_UNIT_GROUP_AVERAGE_PRE_BONUS_EBITDA_DESC', 'FACILITIES_BY_UNIT_GROUP_AVERAGE_PRICING_NODE_ID_ASC', 'FACILITIES_BY_UNIT_GROUP_AVERAGE_PRICING_NODE_ID_DESC', 'FACILITIES_BY_UNIT_GROUP_AVERAGE_REAL_TIME_ENABLED_ASC', 'FACILITIES_BY_UNIT_GROUP_AVERAGE_REAL_TIME_ENABLED_DESC', 'FACILITIES_BY_UNIT_GROUP_AVERAGE_RETIRED_AT_ASC', 'FACILITIES_BY_UNIT_GROUP_AVERAGE_RETIRED_AT_DESC', 'FACILITIES_BY_UNIT_GROUP_AVERAGE_SLUG_ASC', 'FACILITIES_BY_UNIT_GROUP_AVERAGE_SLUG_DESC', 'FACILITIES_BY_UNIT_GROUP_AVERAGE_STATE_ASC', 'FACILITIES_BY_UNIT_GROUP_AVERAGE_STATE_DESC', 'FACILITIES_BY_UNIT_GROUP_AVERAGE_SUPPRESSE_FINANCIALS_ASC', 'FACILITIES_BY_UNIT_GROUP_AVERAGE_SUPPRESSE_FINANCIALS_DESC', 'FACILITIES_BY_UNIT_GROUP_AVERAGE_TIMEZONE_NAME_ASC', 'FACILITIES_BY_UNIT_GROUP_AVERAGE_TIMEZONE_NAME_DESC', 'FACILITIES_BY_UNIT_GROUP_AVERAGE_TYPE_ASC', 'FACILITIES_BY_UNIT_GROUP_AVERAGE_TYPE_DESC', 'FACILITIES_BY_UNIT_GROUP_AVERAGE_UNIT_GROUP_ASC', 'FACILITIES_BY_UNIT_GROUP_AVERAGE_UNIT_GROUP_DESC', 'FACILITIES_BY_UNIT_GROUP_AVERAGE_UPDATED_AT_ASC', 'FACILITIES_BY_UNIT_GROUP_AVERAGE_UPDATED_AT_DESC', 'FACILITIES_BY_UNIT_GROUP_AVERAGE_WMS_ASC', 'FACILITIES_BY_UNIT_GROUP_AVERAGE_WMS_DESC', 'FACILITIES_BY_UNIT_GROUP_AVERAGE_ZIP_ASC', 'FACILITIES_BY_UNIT_GROUP_AVERAGE_ZIP_DESC', 'FACILITIES_BY_UNIT_GROUP_COUNT_ASC', 'FACILITIES_BY_UNIT_GROUP_COUNT_DESC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_ADDRESS_ASC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_ADDRESS_DESC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_BONUS_LTR_ASC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_BONUS_LTR_DESC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_CITY_ASC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_CITY_DESC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_COMMODITY_ASC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_COMMODITY_DESC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_COST_CENTER_ASC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_COST_CENTER_DESC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_COUNTRY_ASC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_COUNTRY_DESC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_COUNT_ADDRESS_ASC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_COUNT_ADDRESS_DESC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_COUNT_BONUS_LTR_ASC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_COUNT_BONUS_LTR_DESC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_COUNT_CITY_ASC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_COUNT_CITY_DESC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_COUNT_COMMODITY_ASC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_COUNT_COMMODITY_DESC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_COUNT_COST_CENTER_ASC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_COUNT_COST_CENTER_DESC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_COUNT_COUNTRY_ASC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_COUNT_COUNTRY_DESC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_COUNT_CREATED_AT_ASC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_COUNT_CREATED_AT_DESC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_COUNT_CUSTOMER_LOCATION_ID_ASC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_COUNT_CUSTOMER_LOCATION_ID_DESC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_COUNT_FACILITY_CONTACTS_ASC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_COUNT_FACILITY_CONTACTS_DESC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_COUNT_GEOMETRY_ASC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_COUNT_GEOMETRY_DESC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_COUNT_GO_LIVE_DATE_ASC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_COUNT_GO_LIVE_DATE_DESC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_COUNT_ID_ASC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_COUNT_ID_DESC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_COUNT_LATITUDE_ASC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_COUNT_LATITUDE_DESC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_COUNT_LINK_ACTIVE_ASC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_COUNT_LINK_ACTIVE_DESC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_COUNT_LONGITUDE_ASC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_COUNT_LONGITUDE_DESC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_COUNT_METRICS_ONE_ACTIVE_ASC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_COUNT_METRICS_ONE_ACTIVE_DESC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_COUNT_NAME_ASC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_COUNT_NAME_DESC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_COUNT_N_SIGHT_2_ACTIVE_ASC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_COUNT_N_SIGHT_2_ACTIVE_DESC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_COUNT_N_SIGHT_ACTIVE_ASC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_COUNT_N_SIGHT_ACTIVE_DESC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_COUNT_PRE_BONUS_EBITDA_ASC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_COUNT_PRE_BONUS_EBITDA_DESC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_COUNT_PRICING_NODE_ID_ASC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_COUNT_PRICING_NODE_ID_DESC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_COUNT_REAL_TIME_ENABLED_ASC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_COUNT_REAL_TIME_ENABLED_DESC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_COUNT_RETIRED_AT_ASC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_COUNT_RETIRED_AT_DESC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_COUNT_SLUG_ASC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_COUNT_SLUG_DESC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_COUNT_STATE_ASC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_COUNT_STATE_DESC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_COUNT_SUPPRESSE_FINANCIALS_ASC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_COUNT_SUPPRESSE_FINANCIALS_DESC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_COUNT_TIMEZONE_NAME_ASC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_COUNT_TIMEZONE_NAME_DESC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_COUNT_TYPE_ASC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_COUNT_TYPE_DESC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_COUNT_UNIT_GROUP_ASC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_COUNT_UNIT_GROUP_DESC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_COUNT_UPDATED_AT_ASC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_COUNT_UPDATED_AT_DESC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_COUNT_WMS_ASC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_COUNT_WMS_DESC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_COUNT_ZIP_ASC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_COUNT_ZIP_DESC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_CREATED_AT_ASC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_CREATED_AT_DESC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_CUSTOMER_LOCATION_ID_ASC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_CUSTOMER_LOCATION_ID_DESC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_FACILITY_CONTACTS_ASC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_FACILITY_CONTACTS_DESC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_GEOMETRY_ASC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_GEOMETRY_DESC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_GO_LIVE_DATE_ASC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_GO_LIVE_DATE_DESC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_ID_ASC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_ID_DESC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_LATITUDE_ASC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_LATITUDE_DESC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_LINK_ACTIVE_ASC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_LINK_ACTIVE_DESC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_LONGITUDE_ASC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_LONGITUDE_DESC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_METRICS_ONE_ACTIVE_ASC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_METRICS_ONE_ACTIVE_DESC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_NAME_ASC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_NAME_DESC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_N_SIGHT_2_ACTIVE_ASC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_N_SIGHT_2_ACTIVE_DESC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_N_SIGHT_ACTIVE_ASC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_N_SIGHT_ACTIVE_DESC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_PRE_BONUS_EBITDA_ASC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_PRE_BONUS_EBITDA_DESC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_PRICING_NODE_ID_ASC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_PRICING_NODE_ID_DESC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_REAL_TIME_ENABLED_ASC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_REAL_TIME_ENABLED_DESC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_RETIRED_AT_ASC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_RETIRED_AT_DESC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_SLUG_ASC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_SLUG_DESC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_STATE_ASC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_STATE_DESC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_SUPPRESSE_FINANCIALS_ASC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_SUPPRESSE_FINANCIALS_DESC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_TIMEZONE_NAME_ASC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_TIMEZONE_NAME_DESC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_TYPE_ASC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_TYPE_DESC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_UNIT_GROUP_ASC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_UNIT_GROUP_DESC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_UPDATED_AT_ASC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_UPDATED_AT_DESC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_WMS_ASC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_WMS_DESC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_ZIP_ASC', 'FACILITIES_BY_UNIT_GROUP_DISTINCT_ZIP_DESC', 'FACILITIES_BY_UNIT_GROUP_MAX_ADDRESS_ASC', 'FACILITIES_BY_UNIT_GROUP_MAX_ADDRESS_DESC', 'FACILITIES_BY_UNIT_GROUP_MAX_BONUS_LTR_ASC', 'FACILITIES_BY_UNIT_GROUP_MAX_BONUS_LTR_DESC', 'FACILITIES_BY_UNIT_GROUP_MAX_CITY_ASC', 'FACILITIES_BY_UNIT_GROUP_MAX_CITY_DESC', 'FACILITIES_BY_UNIT_GROUP_MAX_COMMODITY_ASC', 'FACILITIES_BY_UNIT_GROUP_MAX_COMMODITY_DESC', 'FACILITIES_BY_UNIT_GROUP_MAX_COST_CENTER_ASC', 'FACILITIES_BY_UNIT_GROUP_MAX_COST_CENTER_DESC', 'FACILITIES_BY_UNIT_GROUP_MAX_COUNTRY_ASC', 'FACILITIES_BY_UNIT_GROUP_MAX_COUNTRY_DESC', 'FACILITIES_BY_UNIT_GROUP_MAX_CREATED_AT_ASC', 'FACILITIES_BY_UNIT_GROUP_MAX_CREATED_AT_DESC', 'FACILITIES_BY_UNIT_GROUP_MAX_CUSTOMER_LOCATION_ID_ASC', 'FACILITIES_BY_UNIT_GROUP_MAX_CUSTOMER_LOCATION_ID_DESC', 'FACILITIES_BY_UNIT_GROUP_MAX_FACILITY_CONTACTS_ASC', 'FACILITIES_BY_UNIT_GROUP_MAX_FACILITY_CONTACTS_DESC', 'FACILITIES_BY_UNIT_GROUP_MAX_GEOMETRY_ASC', 'FACILITIES_BY_UNIT_GROUP_MAX_GEOMETRY_DESC', 'FACILITIES_BY_UNIT_GROUP_MAX_GO_LIVE_DATE_ASC', 'FACILITIES_BY_UNIT_GROUP_MAX_GO_LIVE_DATE_DESC', 'FACILITIES_BY_UNIT_GROUP_MAX_ID_ASC', 'FACILITIES_BY_UNIT_GROUP_MAX_ID_DESC', 'FACILITIES_BY_UNIT_GROUP_MAX_LATITUDE_ASC', 'FACILITIES_BY_UNIT_GROUP_MAX_LATITUDE_DESC', 'FACILITIES_BY_UNIT_GROUP_MAX_LINK_ACTIVE_ASC', 'FACILITIES_BY_UNIT_GROUP_MAX_LINK_ACTIVE_DESC', 'FACILITIES_BY_UNIT_GROUP_MAX_LONGITUDE_ASC', 'FACILITIES_BY_UNIT_GROUP_MAX_LONGITUDE_DESC', 'FACILITIES_BY_UNIT_GROUP_MAX_METRICS_ONE_ACTIVE_ASC', 'FACILITIES_BY_UNIT_GROUP_MAX_METRICS_ONE_ACTIVE_DESC', 'FACILITIES_BY_UNIT_GROUP_MAX_NAME_ASC', 'FACILITIES_BY_UNIT_GROUP_MAX_NAME_DESC', 'FACILITIES_BY_UNIT_GROUP_MAX_N_SIGHT_2_ACTIVE_ASC', 'FACILITIES_BY_UNIT_GROUP_MAX_N_SIGHT_2_ACTIVE_DESC', 'FACILITIES_BY_UNIT_GROUP_MAX_N_SIGHT_ACTIVE_ASC', 'FACILITIES_BY_UNIT_GROUP_MAX_N_SIGHT_ACTIVE_DESC', 'FACILITIES_BY_UNIT_GROUP_MAX_PRE_BONUS_EBITDA_ASC', 'FACILITIES_BY_UNIT_GROUP_MAX_PRE_BONUS_EBITDA_DESC', 'FACILITIES_BY_UNIT_GROUP_MAX_PRICING_NODE_ID_ASC', 'FACILITIES_BY_UNIT_GROUP_MAX_PRICING_NODE_ID_DESC', 'FACILITIES_BY_UNIT_GROUP_MAX_REAL_TIME_ENABLED_ASC', 'FACILITIES_BY_UNIT_GROUP_MAX_REAL_TIME_ENABLED_DESC', 'FACILITIES_BY_UNIT_GROUP_MAX_RETIRED_AT_ASC', 'FACILITIES_BY_UNIT_GROUP_MAX_RETIRED_AT_DESC', 'FACILITIES_BY_UNIT_GROUP_MAX_SLUG_ASC', 'FACILITIES_BY_UNIT_GROUP_MAX_SLUG_DESC', 'FACILITIES_BY_UNIT_GROUP_MAX_STATE_ASC', 'FACILITIES_BY_UNIT_GROUP_MAX_STATE_DESC', 'FACILITIES_BY_UNIT_GROUP_MAX_SUPPRESSE_FINANCIALS_ASC', 'FACILITIES_BY_UNIT_GROUP_MAX_SUPPRESSE_FINANCIALS_DESC', 'FACILITIES_BY_UNIT_GROUP_MAX_TIMEZONE_NAME_ASC', 'FACILITIES_BY_UNIT_GROUP_MAX_TIMEZONE_NAME_DESC', 'FACILITIES_BY_UNIT_GROUP_MAX_TYPE_ASC', 'FACILITIES_BY_UNIT_GROUP_MAX_TYPE_DESC', 'FACILITIES_BY_UNIT_GROUP_MAX_UNIT_GROUP_ASC', 'FACILITIES_BY_UNIT_GROUP_MAX_UNIT_GROUP_DESC', 'FACILITIES_BY_UNIT_GROUP_MAX_UPDATED_AT_ASC', 'FACILITIES_BY_UNIT_GROUP_MAX_UPDATED_AT_DESC', 'FACILITIES_BY_UNIT_GROUP_MAX_WMS_ASC', 'FACILITIES_BY_UNIT_GROUP_MAX_WMS_DESC', 'FACILITIES_BY_UNIT_GROUP_MAX_ZIP_ASC', 'FACILITIES_BY_UNIT_GROUP_MAX_ZIP_DESC', 'FACILITIES_BY_UNIT_GROUP_MIN_ADDRESS_ASC', 'FACILITIES_BY_UNIT_GROUP_MIN_ADDRESS_DESC', 'FACILITIES_BY_UNIT_GROUP_MIN_BONUS_LTR_ASC', 'FACILITIES_BY_UNIT_GROUP_MIN_BONUS_LTR_DESC', 'FACILITIES_BY_UNIT_GROUP_MIN_CITY_ASC', 'FACILITIES_BY_UNIT_GROUP_MIN_CITY_DESC', 'FACILITIES_BY_UNIT_GROUP_MIN_COMMODITY_ASC', 'FACILITIES_BY_UNIT_GROUP_MIN_COMMODITY_DESC', 'FACILITIES_BY_UNIT_GROUP_MIN_COST_CENTER_ASC', 'FACILITIES_BY_UNIT_GROUP_MIN_COST_CENTER_DESC', 'FACILITIES_BY_UNIT_GROUP_MIN_COUNTRY_ASC', 'FACILITIES_BY_UNIT_GROUP_MIN_COUNTRY_DESC', 'FACILITIES_BY_UNIT_GROUP_MIN_CREATED_AT_ASC', 'FACILITIES_BY_UNIT_GROUP_MIN_CREATED_AT_DESC', 'FACILITIES_BY_UNIT_GROUP_MIN_CUSTOMER_LOCATION_ID_ASC', 'FACILITIES_BY_UNIT_GROUP_MIN_CUSTOMER_LOCATION_ID_DESC', 'FACILITIES_BY_UNIT_GROUP_MIN_FACILITY_CONTACTS_ASC', 'FACILITIES_BY_UNIT_GROUP_MIN_FACILITY_CONTACTS_DESC', 'FACILITIES_BY_UNIT_GROUP_MIN_GEOMETRY_ASC', 'FACILITIES_BY_UNIT_GROUP_MIN_GEOMETRY_DESC', 'FACILITIES_BY_UNIT_GROUP_MIN_GO_LIVE_DATE_ASC', 'FACILITIES_BY_UNIT_GROUP_MIN_GO_LIVE_DATE_DESC', 'FACILITIES_BY_UNIT_GROUP_MIN_ID_ASC', 'FACILITIES_BY_UNIT_GROUP_MIN_ID_DESC', 'FACILITIES_BY_UNIT_GROUP_MIN_LATITUDE_ASC', 'FACILITIES_BY_UNIT_GROUP_MIN_LATITUDE_DESC', 'FACILITIES_BY_UNIT_GROUP_MIN_LINK_ACTIVE_ASC', 'FACILITIES_BY_UNIT_GROUP_MIN_LINK_ACTIVE_DESC', 'FACILITIES_BY_UNIT_GROUP_MIN_LONGITUDE_ASC', 'FACILITIES_BY_UNIT_GROUP_MIN_LONGITUDE_DESC', 'FACILITIES_BY_UNIT_GROUP_MIN_METRICS_ONE_ACTIVE_ASC', 'FACILITIES_BY_UNIT_GROUP_MIN_METRICS_ONE_ACTIVE_DESC', 'FACILITIES_BY_UNIT_GROUP_MIN_NAME_ASC', 'FACILITIES_BY_UNIT_GROUP_MIN_NAME_DESC', 'FACILITIES_BY_UNIT_GROUP_MIN_N_SIGHT_2_ACTIVE_ASC', 'FACILITIES_BY_UNIT_GROUP_MIN_N_SIGHT_2_ACTIVE_DESC', 'FACILITIES_BY_UNIT_GROUP_MIN_N_SIGHT_ACTIVE_ASC', 'FACILITIES_BY_UNIT_GROUP_MIN_N_SIGHT_ACTIVE_DESC', 'FACILITIES_BY_UNIT_GROUP_MIN_PRE_BONUS_EBITDA_ASC', 'FACILITIES_BY_UNIT_GROUP_MIN_PRE_BONUS_EBITDA_DESC', 'FACILITIES_BY_UNIT_GROUP_MIN_PRICING_NODE_ID_ASC', 'FACILITIES_BY_UNIT_GROUP_MIN_PRICING_NODE_ID_DESC', 'FACILITIES_BY_UNIT_GROUP_MIN_REAL_TIME_ENABLED_ASC', 'FACILITIES_BY_UNIT_GROUP_MIN_REAL_TIME_ENABLED_DESC', 'FACILITIES_BY_UNIT_GROUP_MIN_RETIRED_AT_ASC', 'FACILITIES_BY_UNIT_GROUP_MIN_RETIRED_AT_DESC', 'FACILITIES_BY_UNIT_GROUP_MIN_SLUG_ASC', 'FACILITIES_BY_UNIT_GROUP_MIN_SLUG_DESC', 'FACILITIES_BY_UNIT_GROUP_MIN_STATE_ASC', 'FACILITIES_BY_UNIT_GROUP_MIN_STATE_DESC', 'FACILITIES_BY_UNIT_GROUP_MIN_SUPPRESSE_FINANCIALS_ASC', 'FACILITIES_BY_UNIT_GROUP_MIN_SUPPRESSE_FINANCIALS_DESC', 'FACILITIES_BY_UNIT_GROUP_MIN_TIMEZONE_NAME_ASC', 'FACILITIES_BY_UNIT_GROUP_MIN_TIMEZONE_NAME_DESC', 'FACILITIES_BY_UNIT_GROUP_MIN_TYPE_ASC', 'FACILITIES_BY_UNIT_GROUP_MIN_TYPE_DESC', 'FACILITIES_BY_UNIT_GROUP_MIN_UNIT_GROUP_ASC', 'FACILITIES_BY_UNIT_GROUP_MIN_UNIT_GROUP_DESC', 'FACILITIES_BY_UNIT_GROUP_MIN_UPDATED_AT_ASC', 'FACILITIES_BY_UNIT_GROUP_MIN_UPDATED_AT_DESC', 'FACILITIES_BY_UNIT_GROUP_MIN_WMS_ASC', 'FACILITIES_BY_UNIT_GROUP_MIN_WMS_DESC', 'FACILITIES_BY_UNIT_GROUP_MIN_ZIP_ASC', 'FACILITIES_BY_UNIT_GROUP_MIN_ZIP_DESC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_POPULATION_ADDRESS_ASC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_POPULATION_ADDRESS_DESC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_POPULATION_BONUS_LTR_ASC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_POPULATION_BONUS_LTR_DESC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_POPULATION_CITY_ASC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_POPULATION_CITY_DESC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_POPULATION_COMMODITY_ASC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_POPULATION_COMMODITY_DESC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_POPULATION_COST_CENTER_ASC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_POPULATION_COST_CENTER_DESC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_POPULATION_COUNTRY_ASC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_POPULATION_COUNTRY_DESC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_POPULATION_CREATED_AT_ASC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_POPULATION_CREATED_AT_DESC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_POPULATION_CUSTOMER_LOCATION_ID_ASC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_POPULATION_CUSTOMER_LOCATION_ID_DESC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_POPULATION_FACILITY_CONTACTS_ASC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_POPULATION_FACILITY_CONTACTS_DESC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_POPULATION_GEOMETRY_ASC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_POPULATION_GEOMETRY_DESC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_POPULATION_GO_LIVE_DATE_ASC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_POPULATION_GO_LIVE_DATE_DESC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_POPULATION_ID_ASC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_POPULATION_ID_DESC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_POPULATION_LATITUDE_ASC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_POPULATION_LATITUDE_DESC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_POPULATION_LINK_ACTIVE_ASC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_POPULATION_LINK_ACTIVE_DESC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_POPULATION_LONGITUDE_ASC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_POPULATION_LONGITUDE_DESC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_POPULATION_METRICS_ONE_ACTIVE_ASC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_POPULATION_METRICS_ONE_ACTIVE_DESC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_POPULATION_NAME_ASC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_POPULATION_NAME_DESC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_POPULATION_N_SIGHT_2_ACTIVE_ASC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_POPULATION_N_SIGHT_2_ACTIVE_DESC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_POPULATION_N_SIGHT_ACTIVE_ASC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_POPULATION_N_SIGHT_ACTIVE_DESC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_POPULATION_PRE_BONUS_EBITDA_ASC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_POPULATION_PRE_BONUS_EBITDA_DESC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_POPULATION_PRICING_NODE_ID_ASC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_POPULATION_PRICING_NODE_ID_DESC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_POPULATION_REAL_TIME_ENABLED_ASC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_POPULATION_REAL_TIME_ENABLED_DESC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_POPULATION_RETIRED_AT_ASC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_POPULATION_RETIRED_AT_DESC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_POPULATION_SLUG_ASC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_POPULATION_SLUG_DESC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_POPULATION_STATE_ASC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_POPULATION_STATE_DESC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_POPULATION_SUPPRESSE_FINANCIALS_ASC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_POPULATION_SUPPRESSE_FINANCIALS_DESC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_POPULATION_TIMEZONE_NAME_ASC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_POPULATION_TIMEZONE_NAME_DESC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_POPULATION_TYPE_ASC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_POPULATION_TYPE_DESC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_POPULATION_UNIT_GROUP_ASC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_POPULATION_UNIT_GROUP_DESC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_POPULATION_UPDATED_AT_ASC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_POPULATION_UPDATED_AT_DESC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_POPULATION_WMS_ASC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_POPULATION_WMS_DESC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_POPULATION_ZIP_ASC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_POPULATION_ZIP_DESC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_SAMPLE_ADDRESS_ASC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_SAMPLE_ADDRESS_DESC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_SAMPLE_BONUS_LTR_ASC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_SAMPLE_BONUS_LTR_DESC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_SAMPLE_CITY_ASC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_SAMPLE_CITY_DESC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_SAMPLE_COMMODITY_ASC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_SAMPLE_COMMODITY_DESC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_SAMPLE_COST_CENTER_ASC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_SAMPLE_COST_CENTER_DESC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_SAMPLE_COUNTRY_ASC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_SAMPLE_COUNTRY_DESC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_SAMPLE_CREATED_AT_ASC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_SAMPLE_CREATED_AT_DESC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_SAMPLE_CUSTOMER_LOCATION_ID_ASC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_SAMPLE_CUSTOMER_LOCATION_ID_DESC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_SAMPLE_FACILITY_CONTACTS_ASC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_SAMPLE_FACILITY_CONTACTS_DESC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_SAMPLE_GEOMETRY_ASC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_SAMPLE_GEOMETRY_DESC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_SAMPLE_GO_LIVE_DATE_ASC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_SAMPLE_GO_LIVE_DATE_DESC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_SAMPLE_ID_ASC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_SAMPLE_ID_DESC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_SAMPLE_LATITUDE_ASC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_SAMPLE_LATITUDE_DESC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_SAMPLE_LINK_ACTIVE_ASC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_SAMPLE_LINK_ACTIVE_DESC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_SAMPLE_LONGITUDE_ASC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_SAMPLE_LONGITUDE_DESC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_SAMPLE_METRICS_ONE_ACTIVE_ASC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_SAMPLE_METRICS_ONE_ACTIVE_DESC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_SAMPLE_NAME_ASC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_SAMPLE_NAME_DESC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_SAMPLE_N_SIGHT_2_ACTIVE_ASC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_SAMPLE_N_SIGHT_2_ACTIVE_DESC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_SAMPLE_N_SIGHT_ACTIVE_ASC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_SAMPLE_N_SIGHT_ACTIVE_DESC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_SAMPLE_PRE_BONUS_EBITDA_ASC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_SAMPLE_PRE_BONUS_EBITDA_DESC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_SAMPLE_PRICING_NODE_ID_ASC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_SAMPLE_PRICING_NODE_ID_DESC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_SAMPLE_REAL_TIME_ENABLED_ASC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_SAMPLE_REAL_TIME_ENABLED_DESC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_SAMPLE_RETIRED_AT_ASC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_SAMPLE_RETIRED_AT_DESC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_SAMPLE_SLUG_ASC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_SAMPLE_SLUG_DESC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_SAMPLE_STATE_ASC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_SAMPLE_STATE_DESC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_SAMPLE_SUPPRESSE_FINANCIALS_ASC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_SAMPLE_SUPPRESSE_FINANCIALS_DESC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_SAMPLE_TIMEZONE_NAME_ASC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_SAMPLE_TIMEZONE_NAME_DESC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_SAMPLE_TYPE_ASC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_SAMPLE_TYPE_DESC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_SAMPLE_UNIT_GROUP_ASC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_SAMPLE_UNIT_GROUP_DESC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_SAMPLE_UPDATED_AT_ASC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_SAMPLE_UPDATED_AT_DESC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_SAMPLE_WMS_ASC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_SAMPLE_WMS_DESC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_SAMPLE_ZIP_ASC', 'FACILITIES_BY_UNIT_GROUP_STDDEV_SAMPLE_ZIP_DESC', 'FACILITIES_BY_UNIT_GROUP_SUM_ADDRESS_ASC', 'FACILITIES_BY_UNIT_GROUP_SUM_ADDRESS_DESC', 'FACILITIES_BY_UNIT_GROUP_SUM_BONUS_LTR_ASC', 'FACILITIES_BY_UNIT_GROUP_SUM_BONUS_LTR_DESC', 'FACILITIES_BY_UNIT_GROUP_SUM_CITY_ASC', 'FACILITIES_BY_UNIT_GROUP_SUM_CITY_DESC', 'FACILITIES_BY_UNIT_GROUP_SUM_COMMODITY_ASC', 'FACILITIES_BY_UNIT_GROUP_SUM_COMMODITY_DESC', 'FACILITIES_BY_UNIT_GROUP_SUM_COST_CENTER_ASC', 'FACILITIES_BY_UNIT_GROUP_SUM_COST_CENTER_DESC', 'FACILITIES_BY_UNIT_GROUP_SUM_COUNTRY_ASC', 'FACILITIES_BY_UNIT_GROUP_SUM_COUNTRY_DESC', 'FACILITIES_BY_UNIT_GROUP_SUM_CREATED_AT_ASC', 'FACILITIES_BY_UNIT_GROUP_SUM_CREATED_AT_DESC', 'FACILITIES_BY_UNIT_GROUP_SUM_CUSTOMER_LOCATION_ID_ASC', 'FACILITIES_BY_UNIT_GROUP_SUM_CUSTOMER_LOCATION_ID_DESC', 'FACILITIES_BY_UNIT_GROUP_SUM_FACILITY_CONTACTS_ASC', 'FACILITIES_BY_UNIT_GROUP_SUM_FACILITY_CONTACTS_DESC', 'FACILITIES_BY_UNIT_GROUP_SUM_GEOMETRY_ASC', 'FACILITIES_BY_UNIT_GROUP_SUM_GEOMETRY_DESC', 'FACILITIES_BY_UNIT_GROUP_SUM_GO_LIVE_DATE_ASC', 'FACILITIES_BY_UNIT_GROUP_SUM_GO_LIVE_DATE_DESC', 'FACILITIES_BY_UNIT_GROUP_SUM_ID_ASC', 'FACILITIES_BY_UNIT_GROUP_SUM_ID_DESC', 'FACILITIES_BY_UNIT_GROUP_SUM_LATITUDE_ASC', 'FACILITIES_BY_UNIT_GROUP_SUM_LATITUDE_DESC', 'FACILITIES_BY_UNIT_GROUP_SUM_LINK_ACTIVE_ASC', 'FACILITIES_BY_UNIT_GROUP_SUM_LINK_ACTIVE_DESC', 'FACILITIES_BY_UNIT_GROUP_SUM_LONGITUDE_ASC', 'FACILITIES_BY_UNIT_GROUP_SUM_LONGITUDE_DESC', 'FACILITIES_BY_UNIT_GROUP_SUM_METRICS_ONE_ACTIVE_ASC', 'FACILITIES_BY_UNIT_GROUP_SUM_METRICS_ONE_ACTIVE_DESC', 'FACILITIES_BY_UNIT_GROUP_SUM_NAME_ASC', 'FACILITIES_BY_UNIT_GROUP_SUM_NAME_DESC', 'FACILITIES_BY_UNIT_GROUP_SUM_N_SIGHT_2_ACTIVE_ASC', 'FACILITIES_BY_UNIT_GROUP_SUM_N_SIGHT_2_ACTIVE_DESC', 'FACILITIES_BY_UNIT_GROUP_SUM_N_SIGHT_ACTIVE_ASC', 'FACILITIES_BY_UNIT_GROUP_SUM_N_SIGHT_ACTIVE_DESC', 'FACILITIES_BY_UNIT_GROUP_SUM_PRE_BONUS_EBITDA_ASC', 'FACILITIES_BY_UNIT_GROUP_SUM_PRE_BONUS_EBITDA_DESC', 'FACILITIES_BY_UNIT_GROUP_SUM_PRICING_NODE_ID_ASC', 'FACILITIES_BY_UNIT_GROUP_SUM_PRICING_NODE_ID_DESC', 'FACILITIES_BY_UNIT_GROUP_SUM_REAL_TIME_ENABLED_ASC', 'FACILITIES_BY_UNIT_GROUP_SUM_REAL_TIME_ENABLED_DESC', 'FACILITIES_BY_UNIT_GROUP_SUM_RETIRED_AT_ASC', 'FACILITIES_BY_UNIT_GROUP_SUM_RETIRED_AT_DESC', 'FACILITIES_BY_UNIT_GROUP_SUM_SLUG_ASC', 'FACILITIES_BY_UNIT_GROUP_SUM_SLUG_DESC', 'FACILITIES_BY_UNIT_GROUP_SUM_STATE_ASC', 'FACILITIES_BY_UNIT_GROUP_SUM_STATE_DESC', 'FACILITIES_BY_UNIT_GROUP_SUM_SUPPRESSE_FINANCIALS_ASC', 'FACILITIES_BY_UNIT_GROUP_SUM_SUPPRESSE_FINANCIALS_DESC', 'FACILITIES_BY_UNIT_GROUP_SUM_TIMEZONE_NAME_ASC', 'FACILITIES_BY_UNIT_GROUP_SUM_TIMEZONE_NAME_DESC', 'FACILITIES_BY_UNIT_GROUP_SUM_TYPE_ASC', 'FACILITIES_BY_UNIT_GROUP_SUM_TYPE_DESC', 'FACILITIES_BY_UNIT_GROUP_SUM_UNIT_GROUP_ASC', 'FACILITIES_BY_UNIT_GROUP_SUM_UNIT_GROUP_DESC', 'FACILITIES_BY_UNIT_GROUP_SUM_UPDATED_AT_ASC', 'FACILITIES_BY_UNIT_GROUP_SUM_UPDATED_AT_DESC', 'FACILITIES_BY_UNIT_GROUP_SUM_WMS_ASC', 'FACILITIES_BY_UNIT_GROUP_SUM_WMS_DESC', 'FACILITIES_BY_UNIT_GROUP_SUM_ZIP_ASC', 'FACILITIES_BY_UNIT_GROUP_SUM_ZIP_DESC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_POPULATION_ADDRESS_ASC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_POPULATION_ADDRESS_DESC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_POPULATION_BONUS_LTR_ASC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_POPULATION_BONUS_LTR_DESC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_POPULATION_CITY_ASC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_POPULATION_CITY_DESC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_POPULATION_COMMODITY_ASC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_POPULATION_COMMODITY_DESC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_POPULATION_COST_CENTER_ASC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_POPULATION_COST_CENTER_DESC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_POPULATION_COUNTRY_ASC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_POPULATION_COUNTRY_DESC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_POPULATION_CREATED_AT_ASC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_POPULATION_CREATED_AT_DESC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_POPULATION_CUSTOMER_LOCATION_ID_ASC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_POPULATION_CUSTOMER_LOCATION_ID_DESC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_POPULATION_FACILITY_CONTACTS_ASC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_POPULATION_FACILITY_CONTACTS_DESC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_POPULATION_GEOMETRY_ASC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_POPULATION_GEOMETRY_DESC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_POPULATION_GO_LIVE_DATE_ASC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_POPULATION_GO_LIVE_DATE_DESC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_POPULATION_ID_ASC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_POPULATION_ID_DESC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_POPULATION_LATITUDE_ASC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_POPULATION_LATITUDE_DESC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_POPULATION_LINK_ACTIVE_ASC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_POPULATION_LINK_ACTIVE_DESC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_POPULATION_LONGITUDE_ASC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_POPULATION_LONGITUDE_DESC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_POPULATION_METRICS_ONE_ACTIVE_ASC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_POPULATION_METRICS_ONE_ACTIVE_DESC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_POPULATION_NAME_ASC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_POPULATION_NAME_DESC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_POPULATION_N_SIGHT_2_ACTIVE_ASC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_POPULATION_N_SIGHT_2_ACTIVE_DESC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_POPULATION_N_SIGHT_ACTIVE_ASC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_POPULATION_N_SIGHT_ACTIVE_DESC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_POPULATION_PRE_BONUS_EBITDA_ASC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_POPULATION_PRE_BONUS_EBITDA_DESC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_POPULATION_PRICING_NODE_ID_ASC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_POPULATION_PRICING_NODE_ID_DESC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_POPULATION_REAL_TIME_ENABLED_ASC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_POPULATION_REAL_TIME_ENABLED_DESC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_POPULATION_RETIRED_AT_ASC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_POPULATION_RETIRED_AT_DESC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_POPULATION_SLUG_ASC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_POPULATION_SLUG_DESC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_POPULATION_STATE_ASC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_POPULATION_STATE_DESC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_POPULATION_SUPPRESSE_FINANCIALS_ASC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_POPULATION_SUPPRESSE_FINANCIALS_DESC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_POPULATION_TIMEZONE_NAME_ASC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_POPULATION_TIMEZONE_NAME_DESC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_POPULATION_TYPE_ASC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_POPULATION_TYPE_DESC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_POPULATION_UNIT_GROUP_ASC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_POPULATION_UNIT_GROUP_DESC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_POPULATION_UPDATED_AT_ASC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_POPULATION_UPDATED_AT_DESC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_POPULATION_WMS_ASC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_POPULATION_WMS_DESC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_POPULATION_ZIP_ASC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_POPULATION_ZIP_DESC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_SAMPLE_ADDRESS_ASC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_SAMPLE_ADDRESS_DESC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_SAMPLE_BONUS_LTR_ASC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_SAMPLE_BONUS_LTR_DESC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_SAMPLE_CITY_ASC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_SAMPLE_CITY_DESC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_SAMPLE_COMMODITY_ASC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_SAMPLE_COMMODITY_DESC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_SAMPLE_COST_CENTER_ASC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_SAMPLE_COST_CENTER_DESC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_SAMPLE_COUNTRY_ASC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_SAMPLE_COUNTRY_DESC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_SAMPLE_CREATED_AT_ASC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_SAMPLE_CREATED_AT_DESC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_SAMPLE_CUSTOMER_LOCATION_ID_ASC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_SAMPLE_CUSTOMER_LOCATION_ID_DESC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_SAMPLE_FACILITY_CONTACTS_ASC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_SAMPLE_FACILITY_CONTACTS_DESC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_SAMPLE_GEOMETRY_ASC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_SAMPLE_GEOMETRY_DESC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_SAMPLE_GO_LIVE_DATE_ASC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_SAMPLE_GO_LIVE_DATE_DESC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_SAMPLE_ID_ASC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_SAMPLE_ID_DESC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_SAMPLE_LATITUDE_ASC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_SAMPLE_LATITUDE_DESC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_SAMPLE_LINK_ACTIVE_ASC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_SAMPLE_LINK_ACTIVE_DESC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_SAMPLE_LONGITUDE_ASC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_SAMPLE_LONGITUDE_DESC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_SAMPLE_METRICS_ONE_ACTIVE_ASC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_SAMPLE_METRICS_ONE_ACTIVE_DESC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_SAMPLE_NAME_ASC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_SAMPLE_NAME_DESC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_SAMPLE_N_SIGHT_2_ACTIVE_ASC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_SAMPLE_N_SIGHT_2_ACTIVE_DESC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_SAMPLE_N_SIGHT_ACTIVE_ASC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_SAMPLE_N_SIGHT_ACTIVE_DESC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_SAMPLE_PRE_BONUS_EBITDA_ASC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_SAMPLE_PRE_BONUS_EBITDA_DESC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_SAMPLE_PRICING_NODE_ID_ASC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_SAMPLE_PRICING_NODE_ID_DESC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_SAMPLE_REAL_TIME_ENABLED_ASC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_SAMPLE_REAL_TIME_ENABLED_DESC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_SAMPLE_RETIRED_AT_ASC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_SAMPLE_RETIRED_AT_DESC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_SAMPLE_SLUG_ASC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_SAMPLE_SLUG_DESC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_SAMPLE_STATE_ASC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_SAMPLE_STATE_DESC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_SAMPLE_SUPPRESSE_FINANCIALS_ASC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_SAMPLE_SUPPRESSE_FINANCIALS_DESC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_SAMPLE_TIMEZONE_NAME_ASC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_SAMPLE_TIMEZONE_NAME_DESC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_SAMPLE_TYPE_ASC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_SAMPLE_TYPE_DESC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_SAMPLE_UNIT_GROUP_ASC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_SAMPLE_UNIT_GROUP_DESC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_SAMPLE_UPDATED_AT_ASC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_SAMPLE_UPDATED_AT_DESC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_SAMPLE_WMS_ASC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_SAMPLE_WMS_DESC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_SAMPLE_ZIP_ASC', 'FACILITIES_BY_UNIT_GROUP_VARIANCE_SAMPLE_ZIP_DESC', 'NAME_ASC', 'NAME_DESC', 'NATURAL', 'PRIMARY_KEY_ASC', 'PRIMARY_KEY_DESC')


class Upload(sgqlc.types.Scalar):
    __schema__ = nionic_schema


class UserSubscriptionChannel(sgqlc.types.Enum):
    __schema__ = nionic_schema
    __choices__ = ('EMAIL', 'SMS')


class UsersOrderBy(sgqlc.types.Enum):
    __schema__ = nionic_schema
    __choices__ = ('CREATED_AT_ASC', 'CREATED_AT_DESC', 'EMAIL_ASC', 'EMAIL_DESC', 'FIRST_NAME_ASC', 'FIRST_NAME_DESC', 'ID_ASC', 'ID_DESC', 'LAST_NAME_ASC', 'LAST_NAME_DESC', 'NATURAL', 'PHONE_NUMBER_ASC', 'PHONE_NUMBER_DESC', 'PHONE_NUMBER_VALIDATED_ASC', 'PHONE_NUMBER_VALIDATED_DESC', 'PREFERRED_LOCALE_ASC', 'PREFERRED_LOCALE_DESC', 'PRIMARY_KEY_ASC', 'PRIMARY_KEY_DESC', 'UPDATED_AT_ASC', 'UPDATED_AT_DESC')


class UtilityAccountChargeCategory(sgqlc.types.Enum):
    __schema__ = nionic_schema
    __choices__ = ('CREDITS', 'DEMAND', 'FEES', 'TAXES', 'USAGE')


class UtilityAccountStatementRollupsGroupBy(sgqlc.types.Enum):
    __schema__ = nionic_schema
    __choices__ = ('ACCOUNT_LABEL', 'ACCOUNT_LABEL_DISTINCT', 'ACCOUNT_STATEMENT_ID', 'ACCOUNT_STATEMENT_ID_DISTINCT', 'BILL_ARRIVAL_DATE', 'BILL_ARRIVAL_DATE_DISTINCT', 'BILL_ARRIVAL_DATE_TRUNCATED_TO_DAY', 'BILL_ARRIVAL_DATE_TRUNCATED_TO_HOUR', 'BILL_COST', 'BILL_COST_DISTINCT', 'BILL_DEMAND_COST', 'BILL_DEMAND_COST_DISTINCT', 'BILL_USAGE_COST', 'BILL_USAGE_COST_DISTINCT', 'CREDITS', 'CREDITS_DISTINCT', 'CURRENCY_CODE', 'CURRENCY_CODE_DISTINCT', 'FEES', 'FEES_DISTINCT', 'INTERVAL_END', 'INTERVAL_END_DISTINCT', 'INTERVAL_START', 'INTERVAL_START_DISTINCT', 'IS_VALIDATED', 'IS_VALIDATED_DISTINCT', 'PERCENT_CHANGE', 'PERCENT_CHANGE_DISTINCT', 'PROVIDER', 'PROVIDER_DISTINCT', 'STATEMENT_MONTH', 'STATEMENT_MONTH_DISTINCT', 'STATEMENT_YEAR', 'STATEMENT_YEAR_DISTINCT', 'TAXES', 'TAXES_DISTINCT', 'UTILITY_ACCOUNT_ID', 'UTILITY_ACCOUNT_ID_DISTINCT')


class UtilityAccountStatementRollupsOrderBy(sgqlc.types.Enum):
    __schema__ = nionic_schema
    __choices__ = ('ACCOUNT_LABEL_ASC', 'ACCOUNT_LABEL_DESC', 'ACCOUNT_STATEMENT_ID_ASC', 'ACCOUNT_STATEMENT_ID_DESC', 'BILL_ARRIVAL_DATE_ASC', 'BILL_ARRIVAL_DATE_DESC', 'BILL_COST_ASC', 'BILL_COST_DESC', 'BILL_DEMAND_COST_ASC', 'BILL_DEMAND_COST_DESC', 'BILL_USAGE_COST_ASC', 'BILL_USAGE_COST_DESC', 'CREDITS_ASC', 'CREDITS_DESC', 'CURRENCY_CODE_ASC', 'CURRENCY_CODE_DESC', 'FEES_ASC', 'FEES_DESC', 'INTERVAL_END_ASC', 'INTERVAL_END_DESC', 'INTERVAL_START_ASC', 'INTERVAL_START_DESC', 'IS_VALIDATED_ASC', 'IS_VALIDATED_DESC', 'NATURAL', 'PERCENT_CHANGE_ASC', 'PERCENT_CHANGE_DESC', 'PRIMARY_KEY_ASC', 'PRIMARY_KEY_DESC', 'PROVIDER_ASC', 'PROVIDER_DESC', 'STATEMENT_MONTH_ASC', 'STATEMENT_MONTH_DESC', 'STATEMENT_YEAR_ASC', 'STATEMENT_YEAR_DESC', 'TAXES_ASC', 'TAXES_DESC', 'UTILITY_ACCOUNT_ID_ASC', 'UTILITY_ACCOUNT_ID_DESC')


class UtilityAccountStatementsGroupBy(sgqlc.types.Enum):
    __schema__ = nionic_schema
    __choices__ = ('ACCOUNT_LABEL', 'ACCOUNT_LABEL_DISTINCT', 'ACCOUNT_STATEMENT_ID', 'ACCOUNT_STATEMENT_ID_DISTINCT', 'BILL_ARRIVAL_DATE', 'BILL_ARRIVAL_DATE_DISTINCT', 'BILL_ARRIVAL_DATE_TRUNCATED_TO_DAY', 'BILL_ARRIVAL_DATE_TRUNCATED_TO_HOUR', 'CURRENCY_CODE', 'CURRENCY_CODE_DISTINCT', 'INTERVAL_END', 'INTERVAL_END_DISTINCT', 'INTERVAL_START', 'INTERVAL_START_DISTINCT', 'IS_VALIDATED', 'IS_VALIDATED_DISTINCT', 'PROVIDER', 'PROVIDER_DISTINCT', 'STATEMENT_MONTH', 'STATEMENT_MONTH_DISTINCT', 'STATEMENT_YEAR', 'STATEMENT_YEAR_DISTINCT', 'UTILITY_ACCOUNT_ID', 'UTILITY_ACCOUNT_ID_DISTINCT')


class UtilityAccountStatementsOrderBy(sgqlc.types.Enum):
    __schema__ = nionic_schema
    __choices__ = ('ACCOUNT_LABEL_ASC', 'ACCOUNT_LABEL_DESC', 'ACCOUNT_STATEMENT_ID_ASC', 'ACCOUNT_STATEMENT_ID_DESC', 'BILL_ARRIVAL_DATE_ASC', 'BILL_ARRIVAL_DATE_DESC', 'CURRENCY_CODE_ASC', 'CURRENCY_CODE_DESC', 'INTERVAL_END_ASC', 'INTERVAL_END_DESC', 'INTERVAL_START_ASC', 'INTERVAL_START_DESC', 'IS_VALIDATED_ASC', 'IS_VALIDATED_DESC', 'NATURAL', 'PRIMARY_KEY_ASC', 'PRIMARY_KEY_DESC', 'PROVIDER_ASC', 'PROVIDER_DESC', 'STATEMENT_MONTH_ASC', 'STATEMENT_MONTH_DESC', 'STATEMENT_YEAR_ASC', 'STATEMENT_YEAR_DESC', 'UTILITY_ACCOUNT_ID_ASC', 'UTILITY_ACCOUNT_ID_DESC')


class UtilityAccountsOrderBy(sgqlc.types.Enum):
    __schema__ = nionic_schema
    __choices__ = ('ACCOUNT_NUMBER_ASC', 'ACCOUNT_NUMBER_DESC', 'CREATED_AT_ASC', 'CREATED_AT_DESC', 'DELETED_AT_ASC', 'DELETED_AT_DESC', 'ID_ASC', 'ID_DESC', 'INTEGRATION_ACCOUNT_KEY_ASC', 'INTEGRATION_ACCOUNT_KEY_DESC', 'INTEGRATION_ASC', 'INTEGRATION_DESC', 'METADATA_ASC', 'METADATA_DESC', 'NAME_ASC', 'NAME_DESC', 'NATURAL', 'PRIMARY_KEY_ASC', 'PRIMARY_KEY_DESC', 'UPDATED_AT_ASC', 'UPDATED_AT_DESC', 'UTILITY_ACCOUNT_STATEMENTS_AVERAGE_ACCOUNT_LABEL_ASC', 'UTILITY_ACCOUNT_STATEMENTS_AVERAGE_ACCOUNT_LABEL_DESC', 'UTILITY_ACCOUNT_STATEMENTS_AVERAGE_ACCOUNT_STATEMENT_ID_ASC', 'UTILITY_ACCOUNT_STATEMENTS_AVERAGE_ACCOUNT_STATEMENT_ID_DESC', 'UTILITY_ACCOUNT_STATEMENTS_AVERAGE_BILL_ARRIVAL_DATE_ASC', 'UTILITY_ACCOUNT_STATEMENTS_AVERAGE_BILL_ARRIVAL_DATE_DESC', 'UTILITY_ACCOUNT_STATEMENTS_AVERAGE_CURRENCY_CODE_ASC', 'UTILITY_ACCOUNT_STATEMENTS_AVERAGE_CURRENCY_CODE_DESC', 'UTILITY_ACCOUNT_STATEMENTS_AVERAGE_INTERVAL_END_ASC', 'UTILITY_ACCOUNT_STATEMENTS_AVERAGE_INTERVAL_END_DESC', 'UTILITY_ACCOUNT_STATEMENTS_AVERAGE_INTERVAL_START_ASC', 'UTILITY_ACCOUNT_STATEMENTS_AVERAGE_INTERVAL_START_DESC', 'UTILITY_ACCOUNT_STATEMENTS_AVERAGE_IS_VALIDATED_ASC', 'UTILITY_ACCOUNT_STATEMENTS_AVERAGE_IS_VALIDATED_DESC', 'UTILITY_ACCOUNT_STATEMENTS_AVERAGE_PROVIDER_ASC', 'UTILITY_ACCOUNT_STATEMENTS_AVERAGE_PROVIDER_DESC', 'UTILITY_ACCOUNT_STATEMENTS_AVERAGE_STATEMENT_MONTH_ASC', 'UTILITY_ACCOUNT_STATEMENTS_AVERAGE_STATEMENT_MONTH_DESC', 'UTILITY_ACCOUNT_STATEMENTS_AVERAGE_STATEMENT_YEAR_ASC', 'UTILITY_ACCOUNT_STATEMENTS_AVERAGE_STATEMENT_YEAR_DESC', 'UTILITY_ACCOUNT_STATEMENTS_AVERAGE_UTILITY_ACCOUNT_ID_ASC', 'UTILITY_ACCOUNT_STATEMENTS_AVERAGE_UTILITY_ACCOUNT_ID_DESC', 'UTILITY_ACCOUNT_STATEMENTS_COUNT_ASC', 'UTILITY_ACCOUNT_STATEMENTS_COUNT_DESC', 'UTILITY_ACCOUNT_STATEMENTS_DISTINCT_ACCOUNT_LABEL_ASC', 'UTILITY_ACCOUNT_STATEMENTS_DISTINCT_ACCOUNT_LABEL_DESC', 'UTILITY_ACCOUNT_STATEMENTS_DISTINCT_ACCOUNT_STATEMENT_ID_ASC', 'UTILITY_ACCOUNT_STATEMENTS_DISTINCT_ACCOUNT_STATEMENT_ID_DESC', 'UTILITY_ACCOUNT_STATEMENTS_DISTINCT_BILL_ARRIVAL_DATE_ASC', 'UTILITY_ACCOUNT_STATEMENTS_DISTINCT_BILL_ARRIVAL_DATE_DESC', 'UTILITY_ACCOUNT_STATEMENTS_DISTINCT_COUNT_ACCOUNT_LABEL_ASC', 'UTILITY_ACCOUNT_STATEMENTS_DISTINCT_COUNT_ACCOUNT_LABEL_DESC', 'UTILITY_ACCOUNT_STATEMENTS_DISTINCT_COUNT_ACCOUNT_STATEMENT_ID_ASC', 'UTILITY_ACCOUNT_STATEMENTS_DISTINCT_COUNT_ACCOUNT_STATEMENT_ID_DESC', 'UTILITY_ACCOUNT_STATEMENTS_DISTINCT_COUNT_BILL_ARRIVAL_DATE_ASC', 'UTILITY_ACCOUNT_STATEMENTS_DISTINCT_COUNT_BILL_ARRIVAL_DATE_DESC', 'UTILITY_ACCOUNT_STATEMENTS_DISTINCT_COUNT_CURRENCY_CODE_ASC', 'UTILITY_ACCOUNT_STATEMENTS_DISTINCT_COUNT_CURRENCY_CODE_DESC', 'UTILITY_ACCOUNT_STATEMENTS_DISTINCT_COUNT_INTERVAL_END_ASC', 'UTILITY_ACCOUNT_STATEMENTS_DISTINCT_COUNT_INTERVAL_END_DESC', 'UTILITY_ACCOUNT_STATEMENTS_DISTINCT_COUNT_INTERVAL_START_ASC', 'UTILITY_ACCOUNT_STATEMENTS_DISTINCT_COUNT_INTERVAL_START_DESC', 'UTILITY_ACCOUNT_STATEMENTS_DISTINCT_COUNT_IS_VALIDATED_ASC', 'UTILITY_ACCOUNT_STATEMENTS_DISTINCT_COUNT_IS_VALIDATED_DESC', 'UTILITY_ACCOUNT_STATEMENTS_DISTINCT_COUNT_PROVIDER_ASC', 'UTILITY_ACCOUNT_STATEMENTS_DISTINCT_COUNT_PROVIDER_DESC', 'UTILITY_ACCOUNT_STATEMENTS_DISTINCT_COUNT_STATEMENT_MONTH_ASC', 'UTILITY_ACCOUNT_STATEMENTS_DISTINCT_COUNT_STATEMENT_MONTH_DESC', 'UTILITY_ACCOUNT_STATEMENTS_DISTINCT_COUNT_STATEMENT_YEAR_ASC', 'UTILITY_ACCOUNT_STATEMENTS_DISTINCT_COUNT_STATEMENT_YEAR_DESC', 'UTILITY_ACCOUNT_STATEMENTS_DISTINCT_COUNT_UTILITY_ACCOUNT_ID_ASC', 'UTILITY_ACCOUNT_STATEMENTS_DISTINCT_COUNT_UTILITY_ACCOUNT_ID_DESC', 'UTILITY_ACCOUNT_STATEMENTS_DISTINCT_CURRENCY_CODE_ASC', 'UTILITY_ACCOUNT_STATEMENTS_DISTINCT_CURRENCY_CODE_DESC', 'UTILITY_ACCOUNT_STATEMENTS_DISTINCT_INTERVAL_END_ASC', 'UTILITY_ACCOUNT_STATEMENTS_DISTINCT_INTERVAL_END_DESC', 'UTILITY_ACCOUNT_STATEMENTS_DISTINCT_INTERVAL_START_ASC', 'UTILITY_ACCOUNT_STATEMENTS_DISTINCT_INTERVAL_START_DESC', 'UTILITY_ACCOUNT_STATEMENTS_DISTINCT_IS_VALIDATED_ASC', 'UTILITY_ACCOUNT_STATEMENTS_DISTINCT_IS_VALIDATED_DESC', 'UTILITY_ACCOUNT_STATEMENTS_DISTINCT_PROVIDER_ASC', 'UTILITY_ACCOUNT_STATEMENTS_DISTINCT_PROVIDER_DESC', 'UTILITY_ACCOUNT_STATEMENTS_DISTINCT_STATEMENT_MONTH_ASC', 'UTILITY_ACCOUNT_STATEMENTS_DISTINCT_STATEMENT_MONTH_DESC', 'UTILITY_ACCOUNT_STATEMENTS_DISTINCT_STATEMENT_YEAR_ASC', 'UTILITY_ACCOUNT_STATEMENTS_DISTINCT_STATEMENT_YEAR_DESC', 'UTILITY_ACCOUNT_STATEMENTS_DISTINCT_UTILITY_ACCOUNT_ID_ASC', 'UTILITY_ACCOUNT_STATEMENTS_DISTINCT_UTILITY_ACCOUNT_ID_DESC', 'UTILITY_ACCOUNT_STATEMENTS_MAX_ACCOUNT_LABEL_ASC', 'UTILITY_ACCOUNT_STATEMENTS_MAX_ACCOUNT_LABEL_DESC', 'UTILITY_ACCOUNT_STATEMENTS_MAX_ACCOUNT_STATEMENT_ID_ASC', 'UTILITY_ACCOUNT_STATEMENTS_MAX_ACCOUNT_STATEMENT_ID_DESC', 'UTILITY_ACCOUNT_STATEMENTS_MAX_BILL_ARRIVAL_DATE_ASC', 'UTILITY_ACCOUNT_STATEMENTS_MAX_BILL_ARRIVAL_DATE_DESC', 'UTILITY_ACCOUNT_STATEMENTS_MAX_CURRENCY_CODE_ASC', 'UTILITY_ACCOUNT_STATEMENTS_MAX_CURRENCY_CODE_DESC', 'UTILITY_ACCOUNT_STATEMENTS_MAX_INTERVAL_END_ASC', 'UTILITY_ACCOUNT_STATEMENTS_MAX_INTERVAL_END_DESC', 'UTILITY_ACCOUNT_STATEMENTS_MAX_INTERVAL_START_ASC', 'UTILITY_ACCOUNT_STATEMENTS_MAX_INTERVAL_START_DESC', 'UTILITY_ACCOUNT_STATEMENTS_MAX_IS_VALIDATED_ASC', 'UTILITY_ACCOUNT_STATEMENTS_MAX_IS_VALIDATED_DESC', 'UTILITY_ACCOUNT_STATEMENTS_MAX_PROVIDER_ASC', 'UTILITY_ACCOUNT_STATEMENTS_MAX_PROVIDER_DESC', 'UTILITY_ACCOUNT_STATEMENTS_MAX_STATEMENT_MONTH_ASC', 'UTILITY_ACCOUNT_STATEMENTS_MAX_STATEMENT_MONTH_DESC', 'UTILITY_ACCOUNT_STATEMENTS_MAX_STATEMENT_YEAR_ASC', 'UTILITY_ACCOUNT_STATEMENTS_MAX_STATEMENT_YEAR_DESC', 'UTILITY_ACCOUNT_STATEMENTS_MAX_UTILITY_ACCOUNT_ID_ASC', 'UTILITY_ACCOUNT_STATEMENTS_MAX_UTILITY_ACCOUNT_ID_DESC', 'UTILITY_ACCOUNT_STATEMENTS_MIN_ACCOUNT_LABEL_ASC', 'UTILITY_ACCOUNT_STATEMENTS_MIN_ACCOUNT_LABEL_DESC', 'UTILITY_ACCOUNT_STATEMENTS_MIN_ACCOUNT_STATEMENT_ID_ASC', 'UTILITY_ACCOUNT_STATEMENTS_MIN_ACCOUNT_STATEMENT_ID_DESC', 'UTILITY_ACCOUNT_STATEMENTS_MIN_BILL_ARRIVAL_DATE_ASC', 'UTILITY_ACCOUNT_STATEMENTS_MIN_BILL_ARRIVAL_DATE_DESC', 'UTILITY_ACCOUNT_STATEMENTS_MIN_CURRENCY_CODE_ASC', 'UTILITY_ACCOUNT_STATEMENTS_MIN_CURRENCY_CODE_DESC', 'UTILITY_ACCOUNT_STATEMENTS_MIN_INTERVAL_END_ASC', 'UTILITY_ACCOUNT_STATEMENTS_MIN_INTERVAL_END_DESC', 'UTILITY_ACCOUNT_STATEMENTS_MIN_INTERVAL_START_ASC', 'UTILITY_ACCOUNT_STATEMENTS_MIN_INTERVAL_START_DESC', 'UTILITY_ACCOUNT_STATEMENTS_MIN_IS_VALIDATED_ASC', 'UTILITY_ACCOUNT_STATEMENTS_MIN_IS_VALIDATED_DESC', 'UTILITY_ACCOUNT_STATEMENTS_MIN_PROVIDER_ASC', 'UTILITY_ACCOUNT_STATEMENTS_MIN_PROVIDER_DESC', 'UTILITY_ACCOUNT_STATEMENTS_MIN_STATEMENT_MONTH_ASC', 'UTILITY_ACCOUNT_STATEMENTS_MIN_STATEMENT_MONTH_DESC', 'UTILITY_ACCOUNT_STATEMENTS_MIN_STATEMENT_YEAR_ASC', 'UTILITY_ACCOUNT_STATEMENTS_MIN_STATEMENT_YEAR_DESC', 'UTILITY_ACCOUNT_STATEMENTS_MIN_UTILITY_ACCOUNT_ID_ASC', 'UTILITY_ACCOUNT_STATEMENTS_MIN_UTILITY_ACCOUNT_ID_DESC', 'UTILITY_ACCOUNT_STATEMENTS_STDDEV_POPULATION_ACCOUNT_LABEL_ASC', 'UTILITY_ACCOUNT_STATEMENTS_STDDEV_POPULATION_ACCOUNT_LABEL_DESC', 'UTILITY_ACCOUNT_STATEMENTS_STDDEV_POPULATION_ACCOUNT_STATEMENT_ID_ASC', 'UTILITY_ACCOUNT_STATEMENTS_STDDEV_POPULATION_ACCOUNT_STATEMENT_ID_DESC', 'UTILITY_ACCOUNT_STATEMENTS_STDDEV_POPULATION_BILL_ARRIVAL_DATE_ASC', 'UTILITY_ACCOUNT_STATEMENTS_STDDEV_POPULATION_BILL_ARRIVAL_DATE_DESC', 'UTILITY_ACCOUNT_STATEMENTS_STDDEV_POPULATION_CURRENCY_CODE_ASC', 'UTILITY_ACCOUNT_STATEMENTS_STDDEV_POPULATION_CURRENCY_CODE_DESC', 'UTILITY_ACCOUNT_STATEMENTS_STDDEV_POPULATION_INTERVAL_END_ASC', 'UTILITY_ACCOUNT_STATEMENTS_STDDEV_POPULATION_INTERVAL_END_DESC', 'UTILITY_ACCOUNT_STATEMENTS_STDDEV_POPULATION_INTERVAL_START_ASC', 'UTILITY_ACCOUNT_STATEMENTS_STDDEV_POPULATION_INTERVAL_START_DESC', 'UTILITY_ACCOUNT_STATEMENTS_STDDEV_POPULATION_IS_VALIDATED_ASC', 'UTILITY_ACCOUNT_STATEMENTS_STDDEV_POPULATION_IS_VALIDATED_DESC', 'UTILITY_ACCOUNT_STATEMENTS_STDDEV_POPULATION_PROVIDER_ASC', 'UTILITY_ACCOUNT_STATEMENTS_STDDEV_POPULATION_PROVIDER_DESC', 'UTILITY_ACCOUNT_STATEMENTS_STDDEV_POPULATION_STATEMENT_MONTH_ASC', 'UTILITY_ACCOUNT_STATEMENTS_STDDEV_POPULATION_STATEMENT_MONTH_DESC', 'UTILITY_ACCOUNT_STATEMENTS_STDDEV_POPULATION_STATEMENT_YEAR_ASC', 'UTILITY_ACCOUNT_STATEMENTS_STDDEV_POPULATION_STATEMENT_YEAR_DESC', 'UTILITY_ACCOUNT_STATEMENTS_STDDEV_POPULATION_UTILITY_ACCOUNT_ID_ASC', 'UTILITY_ACCOUNT_STATEMENTS_STDDEV_POPULATION_UTILITY_ACCOUNT_ID_DESC', 'UTILITY_ACCOUNT_STATEMENTS_STDDEV_SAMPLE_ACCOUNT_LABEL_ASC', 'UTILITY_ACCOUNT_STATEMENTS_STDDEV_SAMPLE_ACCOUNT_LABEL_DESC', 'UTILITY_ACCOUNT_STATEMENTS_STDDEV_SAMPLE_ACCOUNT_STATEMENT_ID_ASC', 'UTILITY_ACCOUNT_STATEMENTS_STDDEV_SAMPLE_ACCOUNT_STATEMENT_ID_DESC', 'UTILITY_ACCOUNT_STATEMENTS_STDDEV_SAMPLE_BILL_ARRIVAL_DATE_ASC', 'UTILITY_ACCOUNT_STATEMENTS_STDDEV_SAMPLE_BILL_ARRIVAL_DATE_DESC', 'UTILITY_ACCOUNT_STATEMENTS_STDDEV_SAMPLE_CURRENCY_CODE_ASC', 'UTILITY_ACCOUNT_STATEMENTS_STDDEV_SAMPLE_CURRENCY_CODE_DESC', 'UTILITY_ACCOUNT_STATEMENTS_STDDEV_SAMPLE_INTERVAL_END_ASC', 'UTILITY_ACCOUNT_STATEMENTS_STDDEV_SAMPLE_INTERVAL_END_DESC', 'UTILITY_ACCOUNT_STATEMENTS_STDDEV_SAMPLE_INTERVAL_START_ASC', 'UTILITY_ACCOUNT_STATEMENTS_STDDEV_SAMPLE_INTERVAL_START_DESC', 'UTILITY_ACCOUNT_STATEMENTS_STDDEV_SAMPLE_IS_VALIDATED_ASC', 'UTILITY_ACCOUNT_STATEMENTS_STDDEV_SAMPLE_IS_VALIDATED_DESC', 'UTILITY_ACCOUNT_STATEMENTS_STDDEV_SAMPLE_PROVIDER_ASC', 'UTILITY_ACCOUNT_STATEMENTS_STDDEV_SAMPLE_PROVIDER_DESC', 'UTILITY_ACCOUNT_STATEMENTS_STDDEV_SAMPLE_STATEMENT_MONTH_ASC', 'UTILITY_ACCOUNT_STATEMENTS_STDDEV_SAMPLE_STATEMENT_MONTH_DESC', 'UTILITY_ACCOUNT_STATEMENTS_STDDEV_SAMPLE_STATEMENT_YEAR_ASC', 'UTILITY_ACCOUNT_STATEMENTS_STDDEV_SAMPLE_STATEMENT_YEAR_DESC', 'UTILITY_ACCOUNT_STATEMENTS_STDDEV_SAMPLE_UTILITY_ACCOUNT_ID_ASC', 'UTILITY_ACCOUNT_STATEMENTS_STDDEV_SAMPLE_UTILITY_ACCOUNT_ID_DESC', 'UTILITY_ACCOUNT_STATEMENTS_SUM_ACCOUNT_LABEL_ASC', 'UTILITY_ACCOUNT_STATEMENTS_SUM_ACCOUNT_LABEL_DESC', 'UTILITY_ACCOUNT_STATEMENTS_SUM_ACCOUNT_STATEMENT_ID_ASC', 'UTILITY_ACCOUNT_STATEMENTS_SUM_ACCOUNT_STATEMENT_ID_DESC', 'UTILITY_ACCOUNT_STATEMENTS_SUM_BILL_ARRIVAL_DATE_ASC', 'UTILITY_ACCOUNT_STATEMENTS_SUM_BILL_ARRIVAL_DATE_DESC', 'UTILITY_ACCOUNT_STATEMENTS_SUM_CURRENCY_CODE_ASC', 'UTILITY_ACCOUNT_STATEMENTS_SUM_CURRENCY_CODE_DESC', 'UTILITY_ACCOUNT_STATEMENTS_SUM_INTERVAL_END_ASC', 'UTILITY_ACCOUNT_STATEMENTS_SUM_INTERVAL_END_DESC', 'UTILITY_ACCOUNT_STATEMENTS_SUM_INTERVAL_START_ASC', 'UTILITY_ACCOUNT_STATEMENTS_SUM_INTERVAL_START_DESC', 'UTILITY_ACCOUNT_STATEMENTS_SUM_IS_VALIDATED_ASC', 'UTILITY_ACCOUNT_STATEMENTS_SUM_IS_VALIDATED_DESC', 'UTILITY_ACCOUNT_STATEMENTS_SUM_PROVIDER_ASC', 'UTILITY_ACCOUNT_STATEMENTS_SUM_PROVIDER_DESC', 'UTILITY_ACCOUNT_STATEMENTS_SUM_STATEMENT_MONTH_ASC', 'UTILITY_ACCOUNT_STATEMENTS_SUM_STATEMENT_MONTH_DESC', 'UTILITY_ACCOUNT_STATEMENTS_SUM_STATEMENT_YEAR_ASC', 'UTILITY_ACCOUNT_STATEMENTS_SUM_STATEMENT_YEAR_DESC', 'UTILITY_ACCOUNT_STATEMENTS_SUM_UTILITY_ACCOUNT_ID_ASC', 'UTILITY_ACCOUNT_STATEMENTS_SUM_UTILITY_ACCOUNT_ID_DESC', 'UTILITY_ACCOUNT_STATEMENTS_VARIANCE_POPULATION_ACCOUNT_LABEL_ASC', 'UTILITY_ACCOUNT_STATEMENTS_VARIANCE_POPULATION_ACCOUNT_LABEL_DESC', 'UTILITY_ACCOUNT_STATEMENTS_VARIANCE_POPULATION_ACCOUNT_STATEMENT_ID_ASC', 'UTILITY_ACCOUNT_STATEMENTS_VARIANCE_POPULATION_ACCOUNT_STATEMENT_ID_DESC', 'UTILITY_ACCOUNT_STATEMENTS_VARIANCE_POPULATION_BILL_ARRIVAL_DATE_ASC', 'UTILITY_ACCOUNT_STATEMENTS_VARIANCE_POPULATION_BILL_ARRIVAL_DATE_DESC', 'UTILITY_ACCOUNT_STATEMENTS_VARIANCE_POPULATION_CURRENCY_CODE_ASC', 'UTILITY_ACCOUNT_STATEMENTS_VARIANCE_POPULATION_CURRENCY_CODE_DESC', 'UTILITY_ACCOUNT_STATEMENTS_VARIANCE_POPULATION_INTERVAL_END_ASC', 'UTILITY_ACCOUNT_STATEMENTS_VARIANCE_POPULATION_INTERVAL_END_DESC', 'UTILITY_ACCOUNT_STATEMENTS_VARIANCE_POPULATION_INTERVAL_START_ASC', 'UTILITY_ACCOUNT_STATEMENTS_VARIANCE_POPULATION_INTERVAL_START_DESC', 'UTILITY_ACCOUNT_STATEMENTS_VARIANCE_POPULATION_IS_VALIDATED_ASC', 'UTILITY_ACCOUNT_STATEMENTS_VARIANCE_POPULATION_IS_VALIDATED_DESC', 'UTILITY_ACCOUNT_STATEMENTS_VARIANCE_POPULATION_PROVIDER_ASC', 'UTILITY_ACCOUNT_STATEMENTS_VARIANCE_POPULATION_PROVIDER_DESC', 'UTILITY_ACCOUNT_STATEMENTS_VARIANCE_POPULATION_STATEMENT_MONTH_ASC', 'UTILITY_ACCOUNT_STATEMENTS_VARIANCE_POPULATION_STATEMENT_MONTH_DESC', 'UTILITY_ACCOUNT_STATEMENTS_VARIANCE_POPULATION_STATEMENT_YEAR_ASC', 'UTILITY_ACCOUNT_STATEMENTS_VARIANCE_POPULATION_STATEMENT_YEAR_DESC', 'UTILITY_ACCOUNT_STATEMENTS_VARIANCE_POPULATION_UTILITY_ACCOUNT_ID_ASC', 'UTILITY_ACCOUNT_STATEMENTS_VARIANCE_POPULATION_UTILITY_ACCOUNT_ID_DESC', 'UTILITY_ACCOUNT_STATEMENTS_VARIANCE_SAMPLE_ACCOUNT_LABEL_ASC', 'UTILITY_ACCOUNT_STATEMENTS_VARIANCE_SAMPLE_ACCOUNT_LABEL_DESC', 'UTILITY_ACCOUNT_STATEMENTS_VARIANCE_SAMPLE_ACCOUNT_STATEMENT_ID_ASC', 'UTILITY_ACCOUNT_STATEMENTS_VARIANCE_SAMPLE_ACCOUNT_STATEMENT_ID_DESC', 'UTILITY_ACCOUNT_STATEMENTS_VARIANCE_SAMPLE_BILL_ARRIVAL_DATE_ASC', 'UTILITY_ACCOUNT_STATEMENTS_VARIANCE_SAMPLE_BILL_ARRIVAL_DATE_DESC', 'UTILITY_ACCOUNT_STATEMENTS_VARIANCE_SAMPLE_CURRENCY_CODE_ASC', 'UTILITY_ACCOUNT_STATEMENTS_VARIANCE_SAMPLE_CURRENCY_CODE_DESC', 'UTILITY_ACCOUNT_STATEMENTS_VARIANCE_SAMPLE_INTERVAL_END_ASC', 'UTILITY_ACCOUNT_STATEMENTS_VARIANCE_SAMPLE_INTERVAL_END_DESC', 'UTILITY_ACCOUNT_STATEMENTS_VARIANCE_SAMPLE_INTERVAL_START_ASC', 'UTILITY_ACCOUNT_STATEMENTS_VARIANCE_SAMPLE_INTERVAL_START_DESC', 'UTILITY_ACCOUNT_STATEMENTS_VARIANCE_SAMPLE_IS_VALIDATED_ASC', 'UTILITY_ACCOUNT_STATEMENTS_VARIANCE_SAMPLE_IS_VALIDATED_DESC', 'UTILITY_ACCOUNT_STATEMENTS_VARIANCE_SAMPLE_PROVIDER_ASC', 'UTILITY_ACCOUNT_STATEMENTS_VARIANCE_SAMPLE_PROVIDER_DESC', 'UTILITY_ACCOUNT_STATEMENTS_VARIANCE_SAMPLE_STATEMENT_MONTH_ASC', 'UTILITY_ACCOUNT_STATEMENTS_VARIANCE_SAMPLE_STATEMENT_MONTH_DESC', 'UTILITY_ACCOUNT_STATEMENTS_VARIANCE_SAMPLE_STATEMENT_YEAR_ASC', 'UTILITY_ACCOUNT_STATEMENTS_VARIANCE_SAMPLE_STATEMENT_YEAR_DESC', 'UTILITY_ACCOUNT_STATEMENTS_VARIANCE_SAMPLE_UTILITY_ACCOUNT_ID_ASC', 'UTILITY_ACCOUNT_STATEMENTS_VARIANCE_SAMPLE_UTILITY_ACCOUNT_ID_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_AVERAGE_ACCOUNT_LABEL_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_AVERAGE_ACCOUNT_LABEL_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_AVERAGE_ACCOUNT_STATEMENT_ID_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_AVERAGE_ACCOUNT_STATEMENT_ID_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_AVERAGE_BILL_ARRIVAL_DATE_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_AVERAGE_BILL_ARRIVAL_DATE_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_AVERAGE_BILL_COST_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_AVERAGE_BILL_COST_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_AVERAGE_BILL_DEMAND_COST_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_AVERAGE_BILL_DEMAND_COST_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_AVERAGE_BILL_USAGE_COST_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_AVERAGE_BILL_USAGE_COST_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_AVERAGE_CREDITS_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_AVERAGE_CREDITS_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_AVERAGE_CURRENCY_CODE_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_AVERAGE_CURRENCY_CODE_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_AVERAGE_FEES_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_AVERAGE_FEES_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_AVERAGE_INTERVAL_END_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_AVERAGE_INTERVAL_END_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_AVERAGE_INTERVAL_START_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_AVERAGE_INTERVAL_START_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_AVERAGE_IS_VALIDATED_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_AVERAGE_IS_VALIDATED_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_AVERAGE_PERCENT_CHANGE_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_AVERAGE_PERCENT_CHANGE_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_AVERAGE_PROVIDER_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_AVERAGE_PROVIDER_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_AVERAGE_STATEMENT_MONTH_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_AVERAGE_STATEMENT_MONTH_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_AVERAGE_STATEMENT_YEAR_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_AVERAGE_STATEMENT_YEAR_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_AVERAGE_TAXES_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_AVERAGE_TAXES_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_AVERAGE_UTILITY_ACCOUNT_ID_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_AVERAGE_UTILITY_ACCOUNT_ID_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_COUNT_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_COUNT_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_DISTINCT_ACCOUNT_LABEL_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_DISTINCT_ACCOUNT_LABEL_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_DISTINCT_ACCOUNT_STATEMENT_ID_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_DISTINCT_ACCOUNT_STATEMENT_ID_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_DISTINCT_BILL_ARRIVAL_DATE_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_DISTINCT_BILL_ARRIVAL_DATE_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_DISTINCT_BILL_COST_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_DISTINCT_BILL_COST_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_DISTINCT_BILL_DEMAND_COST_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_DISTINCT_BILL_DEMAND_COST_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_DISTINCT_BILL_USAGE_COST_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_DISTINCT_BILL_USAGE_COST_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_DISTINCT_COUNT_ACCOUNT_LABEL_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_DISTINCT_COUNT_ACCOUNT_LABEL_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_DISTINCT_COUNT_ACCOUNT_STATEMENT_ID_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_DISTINCT_COUNT_ACCOUNT_STATEMENT_ID_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_DISTINCT_COUNT_BILL_ARRIVAL_DATE_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_DISTINCT_COUNT_BILL_ARRIVAL_DATE_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_DISTINCT_COUNT_BILL_COST_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_DISTINCT_COUNT_BILL_COST_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_DISTINCT_COUNT_BILL_DEMAND_COST_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_DISTINCT_COUNT_BILL_DEMAND_COST_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_DISTINCT_COUNT_BILL_USAGE_COST_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_DISTINCT_COUNT_BILL_USAGE_COST_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_DISTINCT_COUNT_CREDITS_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_DISTINCT_COUNT_CREDITS_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_DISTINCT_COUNT_CURRENCY_CODE_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_DISTINCT_COUNT_CURRENCY_CODE_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_DISTINCT_COUNT_FEES_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_DISTINCT_COUNT_FEES_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_DISTINCT_COUNT_INTERVAL_END_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_DISTINCT_COUNT_INTERVAL_END_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_DISTINCT_COUNT_INTERVAL_START_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_DISTINCT_COUNT_INTERVAL_START_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_DISTINCT_COUNT_IS_VALIDATED_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_DISTINCT_COUNT_IS_VALIDATED_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_DISTINCT_COUNT_PERCENT_CHANGE_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_DISTINCT_COUNT_PERCENT_CHANGE_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_DISTINCT_COUNT_PROVIDER_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_DISTINCT_COUNT_PROVIDER_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_DISTINCT_COUNT_STATEMENT_MONTH_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_DISTINCT_COUNT_STATEMENT_MONTH_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_DISTINCT_COUNT_STATEMENT_YEAR_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_DISTINCT_COUNT_STATEMENT_YEAR_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_DISTINCT_COUNT_TAXES_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_DISTINCT_COUNT_TAXES_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_DISTINCT_COUNT_UTILITY_ACCOUNT_ID_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_DISTINCT_COUNT_UTILITY_ACCOUNT_ID_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_DISTINCT_CREDITS_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_DISTINCT_CREDITS_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_DISTINCT_CURRENCY_CODE_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_DISTINCT_CURRENCY_CODE_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_DISTINCT_FEES_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_DISTINCT_FEES_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_DISTINCT_INTERVAL_END_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_DISTINCT_INTERVAL_END_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_DISTINCT_INTERVAL_START_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_DISTINCT_INTERVAL_START_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_DISTINCT_IS_VALIDATED_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_DISTINCT_IS_VALIDATED_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_DISTINCT_PERCENT_CHANGE_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_DISTINCT_PERCENT_CHANGE_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_DISTINCT_PROVIDER_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_DISTINCT_PROVIDER_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_DISTINCT_STATEMENT_MONTH_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_DISTINCT_STATEMENT_MONTH_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_DISTINCT_STATEMENT_YEAR_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_DISTINCT_STATEMENT_YEAR_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_DISTINCT_TAXES_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_DISTINCT_TAXES_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_DISTINCT_UTILITY_ACCOUNT_ID_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_DISTINCT_UTILITY_ACCOUNT_ID_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_MAX_ACCOUNT_LABEL_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_MAX_ACCOUNT_LABEL_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_MAX_ACCOUNT_STATEMENT_ID_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_MAX_ACCOUNT_STATEMENT_ID_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_MAX_BILL_ARRIVAL_DATE_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_MAX_BILL_ARRIVAL_DATE_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_MAX_BILL_COST_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_MAX_BILL_COST_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_MAX_BILL_DEMAND_COST_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_MAX_BILL_DEMAND_COST_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_MAX_BILL_USAGE_COST_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_MAX_BILL_USAGE_COST_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_MAX_CREDITS_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_MAX_CREDITS_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_MAX_CURRENCY_CODE_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_MAX_CURRENCY_CODE_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_MAX_FEES_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_MAX_FEES_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_MAX_INTERVAL_END_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_MAX_INTERVAL_END_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_MAX_INTERVAL_START_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_MAX_INTERVAL_START_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_MAX_IS_VALIDATED_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_MAX_IS_VALIDATED_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_MAX_PERCENT_CHANGE_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_MAX_PERCENT_CHANGE_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_MAX_PROVIDER_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_MAX_PROVIDER_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_MAX_STATEMENT_MONTH_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_MAX_STATEMENT_MONTH_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_MAX_STATEMENT_YEAR_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_MAX_STATEMENT_YEAR_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_MAX_TAXES_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_MAX_TAXES_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_MAX_UTILITY_ACCOUNT_ID_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_MAX_UTILITY_ACCOUNT_ID_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_MIN_ACCOUNT_LABEL_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_MIN_ACCOUNT_LABEL_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_MIN_ACCOUNT_STATEMENT_ID_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_MIN_ACCOUNT_STATEMENT_ID_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_MIN_BILL_ARRIVAL_DATE_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_MIN_BILL_ARRIVAL_DATE_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_MIN_BILL_COST_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_MIN_BILL_COST_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_MIN_BILL_DEMAND_COST_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_MIN_BILL_DEMAND_COST_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_MIN_BILL_USAGE_COST_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_MIN_BILL_USAGE_COST_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_MIN_CREDITS_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_MIN_CREDITS_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_MIN_CURRENCY_CODE_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_MIN_CURRENCY_CODE_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_MIN_FEES_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_MIN_FEES_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_MIN_INTERVAL_END_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_MIN_INTERVAL_END_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_MIN_INTERVAL_START_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_MIN_INTERVAL_START_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_MIN_IS_VALIDATED_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_MIN_IS_VALIDATED_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_MIN_PERCENT_CHANGE_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_MIN_PERCENT_CHANGE_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_MIN_PROVIDER_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_MIN_PROVIDER_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_MIN_STATEMENT_MONTH_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_MIN_STATEMENT_MONTH_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_MIN_STATEMENT_YEAR_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_MIN_STATEMENT_YEAR_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_MIN_TAXES_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_MIN_TAXES_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_MIN_UTILITY_ACCOUNT_ID_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_MIN_UTILITY_ACCOUNT_ID_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_STDDEV_POPULATION_ACCOUNT_LABEL_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_STDDEV_POPULATION_ACCOUNT_LABEL_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_STDDEV_POPULATION_ACCOUNT_STATEMENT_ID_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_STDDEV_POPULATION_ACCOUNT_STATEMENT_ID_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_STDDEV_POPULATION_BILL_ARRIVAL_DATE_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_STDDEV_POPULATION_BILL_ARRIVAL_DATE_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_STDDEV_POPULATION_BILL_COST_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_STDDEV_POPULATION_BILL_COST_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_STDDEV_POPULATION_BILL_DEMAND_COST_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_STDDEV_POPULATION_BILL_DEMAND_COST_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_STDDEV_POPULATION_BILL_USAGE_COST_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_STDDEV_POPULATION_BILL_USAGE_COST_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_STDDEV_POPULATION_CREDITS_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_STDDEV_POPULATION_CREDITS_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_STDDEV_POPULATION_CURRENCY_CODE_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_STDDEV_POPULATION_CURRENCY_CODE_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_STDDEV_POPULATION_FEES_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_STDDEV_POPULATION_FEES_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_STDDEV_POPULATION_INTERVAL_END_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_STDDEV_POPULATION_INTERVAL_END_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_STDDEV_POPULATION_INTERVAL_START_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_STDDEV_POPULATION_INTERVAL_START_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_STDDEV_POPULATION_IS_VALIDATED_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_STDDEV_POPULATION_IS_VALIDATED_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_STDDEV_POPULATION_PERCENT_CHANGE_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_STDDEV_POPULATION_PERCENT_CHANGE_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_STDDEV_POPULATION_PROVIDER_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_STDDEV_POPULATION_PROVIDER_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_STDDEV_POPULATION_STATEMENT_MONTH_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_STDDEV_POPULATION_STATEMENT_MONTH_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_STDDEV_POPULATION_STATEMENT_YEAR_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_STDDEV_POPULATION_STATEMENT_YEAR_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_STDDEV_POPULATION_TAXES_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_STDDEV_POPULATION_TAXES_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_STDDEV_POPULATION_UTILITY_ACCOUNT_ID_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_STDDEV_POPULATION_UTILITY_ACCOUNT_ID_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_STDDEV_SAMPLE_ACCOUNT_LABEL_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_STDDEV_SAMPLE_ACCOUNT_LABEL_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_STDDEV_SAMPLE_ACCOUNT_STATEMENT_ID_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_STDDEV_SAMPLE_ACCOUNT_STATEMENT_ID_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_STDDEV_SAMPLE_BILL_ARRIVAL_DATE_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_STDDEV_SAMPLE_BILL_ARRIVAL_DATE_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_STDDEV_SAMPLE_BILL_COST_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_STDDEV_SAMPLE_BILL_COST_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_STDDEV_SAMPLE_BILL_DEMAND_COST_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_STDDEV_SAMPLE_BILL_DEMAND_COST_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_STDDEV_SAMPLE_BILL_USAGE_COST_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_STDDEV_SAMPLE_BILL_USAGE_COST_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_STDDEV_SAMPLE_CREDITS_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_STDDEV_SAMPLE_CREDITS_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_STDDEV_SAMPLE_CURRENCY_CODE_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_STDDEV_SAMPLE_CURRENCY_CODE_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_STDDEV_SAMPLE_FEES_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_STDDEV_SAMPLE_FEES_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_STDDEV_SAMPLE_INTERVAL_END_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_STDDEV_SAMPLE_INTERVAL_END_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_STDDEV_SAMPLE_INTERVAL_START_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_STDDEV_SAMPLE_INTERVAL_START_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_STDDEV_SAMPLE_IS_VALIDATED_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_STDDEV_SAMPLE_IS_VALIDATED_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_STDDEV_SAMPLE_PERCENT_CHANGE_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_STDDEV_SAMPLE_PERCENT_CHANGE_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_STDDEV_SAMPLE_PROVIDER_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_STDDEV_SAMPLE_PROVIDER_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_STDDEV_SAMPLE_STATEMENT_MONTH_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_STDDEV_SAMPLE_STATEMENT_MONTH_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_STDDEV_SAMPLE_STATEMENT_YEAR_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_STDDEV_SAMPLE_STATEMENT_YEAR_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_STDDEV_SAMPLE_TAXES_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_STDDEV_SAMPLE_TAXES_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_STDDEV_SAMPLE_UTILITY_ACCOUNT_ID_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_STDDEV_SAMPLE_UTILITY_ACCOUNT_ID_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_SUM_ACCOUNT_LABEL_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_SUM_ACCOUNT_LABEL_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_SUM_ACCOUNT_STATEMENT_ID_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_SUM_ACCOUNT_STATEMENT_ID_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_SUM_BILL_ARRIVAL_DATE_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_SUM_BILL_ARRIVAL_DATE_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_SUM_BILL_COST_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_SUM_BILL_COST_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_SUM_BILL_DEMAND_COST_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_SUM_BILL_DEMAND_COST_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_SUM_BILL_USAGE_COST_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_SUM_BILL_USAGE_COST_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_SUM_CREDITS_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_SUM_CREDITS_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_SUM_CURRENCY_CODE_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_SUM_CURRENCY_CODE_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_SUM_FEES_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_SUM_FEES_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_SUM_INTERVAL_END_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_SUM_INTERVAL_END_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_SUM_INTERVAL_START_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_SUM_INTERVAL_START_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_SUM_IS_VALIDATED_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_SUM_IS_VALIDATED_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_SUM_PERCENT_CHANGE_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_SUM_PERCENT_CHANGE_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_SUM_PROVIDER_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_SUM_PROVIDER_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_SUM_STATEMENT_MONTH_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_SUM_STATEMENT_MONTH_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_SUM_STATEMENT_YEAR_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_SUM_STATEMENT_YEAR_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_SUM_TAXES_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_SUM_TAXES_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_SUM_UTILITY_ACCOUNT_ID_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_SUM_UTILITY_ACCOUNT_ID_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_VARIANCE_POPULATION_ACCOUNT_LABEL_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_VARIANCE_POPULATION_ACCOUNT_LABEL_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_VARIANCE_POPULATION_ACCOUNT_STATEMENT_ID_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_VARIANCE_POPULATION_ACCOUNT_STATEMENT_ID_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_VARIANCE_POPULATION_BILL_ARRIVAL_DATE_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_VARIANCE_POPULATION_BILL_ARRIVAL_DATE_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_VARIANCE_POPULATION_BILL_COST_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_VARIANCE_POPULATION_BILL_COST_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_VARIANCE_POPULATION_BILL_DEMAND_COST_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_VARIANCE_POPULATION_BILL_DEMAND_COST_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_VARIANCE_POPULATION_BILL_USAGE_COST_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_VARIANCE_POPULATION_BILL_USAGE_COST_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_VARIANCE_POPULATION_CREDITS_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_VARIANCE_POPULATION_CREDITS_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_VARIANCE_POPULATION_CURRENCY_CODE_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_VARIANCE_POPULATION_CURRENCY_CODE_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_VARIANCE_POPULATION_FEES_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_VARIANCE_POPULATION_FEES_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_VARIANCE_POPULATION_INTERVAL_END_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_VARIANCE_POPULATION_INTERVAL_END_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_VARIANCE_POPULATION_INTERVAL_START_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_VARIANCE_POPULATION_INTERVAL_START_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_VARIANCE_POPULATION_IS_VALIDATED_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_VARIANCE_POPULATION_IS_VALIDATED_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_VARIANCE_POPULATION_PERCENT_CHANGE_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_VARIANCE_POPULATION_PERCENT_CHANGE_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_VARIANCE_POPULATION_PROVIDER_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_VARIANCE_POPULATION_PROVIDER_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_VARIANCE_POPULATION_STATEMENT_MONTH_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_VARIANCE_POPULATION_STATEMENT_MONTH_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_VARIANCE_POPULATION_STATEMENT_YEAR_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_VARIANCE_POPULATION_STATEMENT_YEAR_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_VARIANCE_POPULATION_TAXES_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_VARIANCE_POPULATION_TAXES_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_VARIANCE_POPULATION_UTILITY_ACCOUNT_ID_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_VARIANCE_POPULATION_UTILITY_ACCOUNT_ID_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_ACCOUNT_LABEL_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_ACCOUNT_LABEL_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_ACCOUNT_STATEMENT_ID_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_ACCOUNT_STATEMENT_ID_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_BILL_ARRIVAL_DATE_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_BILL_ARRIVAL_DATE_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_BILL_COST_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_BILL_COST_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_BILL_DEMAND_COST_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_BILL_DEMAND_COST_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_BILL_USAGE_COST_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_BILL_USAGE_COST_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_CREDITS_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_CREDITS_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_CURRENCY_CODE_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_CURRENCY_CODE_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_FEES_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_FEES_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_INTERVAL_END_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_INTERVAL_END_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_INTERVAL_START_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_INTERVAL_START_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_IS_VALIDATED_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_IS_VALIDATED_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_PERCENT_CHANGE_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_PERCENT_CHANGE_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_PROVIDER_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_PROVIDER_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_STATEMENT_MONTH_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_STATEMENT_MONTH_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_STATEMENT_YEAR_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_STATEMENT_YEAR_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_TAXES_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_TAXES_DESC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_UTILITY_ACCOUNT_ID_ASC', 'UTILITY_ACCOUNT_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_UTILITY_ACCOUNT_ID_DESC', 'UTILITY_METER_STATEMENTS_AVERAGE_ACCOUNT_LABEL_ASC', 'UTILITY_METER_STATEMENTS_AVERAGE_ACCOUNT_LABEL_DESC', 'UTILITY_METER_STATEMENTS_AVERAGE_ACCOUNT_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENTS_AVERAGE_ACCOUNT_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENTS_AVERAGE_BILL_ARRIVAL_DATE_ASC', 'UTILITY_METER_STATEMENTS_AVERAGE_BILL_ARRIVAL_DATE_DESC', 'UTILITY_METER_STATEMENTS_AVERAGE_CURRENCY_CODE_ASC', 'UTILITY_METER_STATEMENTS_AVERAGE_CURRENCY_CODE_DESC', 'UTILITY_METER_STATEMENTS_AVERAGE_DAYS_IN_BILL_ASC', 'UTILITY_METER_STATEMENTS_AVERAGE_DAYS_IN_BILL_DESC', 'UTILITY_METER_STATEMENTS_AVERAGE_DEMAND_UNITS_ASC', 'UTILITY_METER_STATEMENTS_AVERAGE_DEMAND_UNITS_DESC', 'UTILITY_METER_STATEMENTS_AVERAGE_END_DATE_ASC', 'UTILITY_METER_STATEMENTS_AVERAGE_END_DATE_DESC', 'UTILITY_METER_STATEMENTS_AVERAGE_EXCLUDE_USAGE_ASC', 'UTILITY_METER_STATEMENTS_AVERAGE_EXCLUDE_USAGE_DESC', 'UTILITY_METER_STATEMENTS_AVERAGE_FACILITY_ID_ASC', 'UTILITY_METER_STATEMENTS_AVERAGE_FACILITY_ID_DESC', 'UTILITY_METER_STATEMENTS_AVERAGE_IS_VALIDATED_ASC', 'UTILITY_METER_STATEMENTS_AVERAGE_IS_VALIDATED_DESC', 'UTILITY_METER_STATEMENTS_AVERAGE_METER_END_DATE_SET_ASC', 'UTILITY_METER_STATEMENTS_AVERAGE_METER_END_DATE_SET_DESC', 'UTILITY_METER_STATEMENTS_AVERAGE_METER_LABEL_ASC', 'UTILITY_METER_STATEMENTS_AVERAGE_METER_LABEL_DESC', 'UTILITY_METER_STATEMENTS_AVERAGE_METER_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENTS_AVERAGE_METER_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENTS_AVERAGE_PROVIDER_ASC', 'UTILITY_METER_STATEMENTS_AVERAGE_PROVIDER_DESC', 'UTILITY_METER_STATEMENTS_AVERAGE_SERVICE_TYPE_ASC', 'UTILITY_METER_STATEMENTS_AVERAGE_SERVICE_TYPE_DESC', 'UTILITY_METER_STATEMENTS_AVERAGE_START_DATE_ASC', 'UTILITY_METER_STATEMENTS_AVERAGE_START_DATE_DESC', 'UTILITY_METER_STATEMENTS_AVERAGE_STATEMENT_MONTH_ASC', 'UTILITY_METER_STATEMENTS_AVERAGE_STATEMENT_MONTH_DESC', 'UTILITY_METER_STATEMENTS_AVERAGE_STATEMENT_YEAR_ASC', 'UTILITY_METER_STATEMENTS_AVERAGE_STATEMENT_YEAR_DESC', 'UTILITY_METER_STATEMENTS_AVERAGE_USAGE_UNITS_ASC', 'UTILITY_METER_STATEMENTS_AVERAGE_USAGE_UNITS_DESC', 'UTILITY_METER_STATEMENTS_AVERAGE_UTILITY_ACCOUNT_ID_ASC', 'UTILITY_METER_STATEMENTS_AVERAGE_UTILITY_ACCOUNT_ID_DESC', 'UTILITY_METER_STATEMENTS_AVERAGE_UTILITY_METER_ID_ASC', 'UTILITY_METER_STATEMENTS_AVERAGE_UTILITY_METER_ID_DESC', 'UTILITY_METER_STATEMENTS_COUNT_ASC', 'UTILITY_METER_STATEMENTS_COUNT_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_ACCOUNT_LABEL_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_ACCOUNT_LABEL_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_ACCOUNT_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_ACCOUNT_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_BILL_ARRIVAL_DATE_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_BILL_ARRIVAL_DATE_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_ACCOUNT_LABEL_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_ACCOUNT_LABEL_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_ACCOUNT_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_ACCOUNT_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_BILL_ARRIVAL_DATE_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_BILL_ARRIVAL_DATE_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_CURRENCY_CODE_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_CURRENCY_CODE_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_DAYS_IN_BILL_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_DAYS_IN_BILL_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_DEMAND_UNITS_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_DEMAND_UNITS_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_END_DATE_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_END_DATE_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_EXCLUDE_USAGE_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_EXCLUDE_USAGE_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_FACILITY_ID_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_FACILITY_ID_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_IS_VALIDATED_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_IS_VALIDATED_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_METER_END_DATE_SET_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_METER_END_DATE_SET_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_METER_LABEL_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_METER_LABEL_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_METER_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_METER_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_PROVIDER_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_PROVIDER_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_SERVICE_TYPE_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_SERVICE_TYPE_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_START_DATE_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_START_DATE_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_STATEMENT_MONTH_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_STATEMENT_MONTH_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_STATEMENT_YEAR_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_STATEMENT_YEAR_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_USAGE_UNITS_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_USAGE_UNITS_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_UTILITY_ACCOUNT_ID_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_UTILITY_ACCOUNT_ID_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_UTILITY_METER_ID_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_UTILITY_METER_ID_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_CURRENCY_CODE_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_CURRENCY_CODE_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_DAYS_IN_BILL_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_DAYS_IN_BILL_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_DEMAND_UNITS_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_DEMAND_UNITS_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_END_DATE_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_END_DATE_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_EXCLUDE_USAGE_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_EXCLUDE_USAGE_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_FACILITY_ID_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_FACILITY_ID_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_IS_VALIDATED_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_IS_VALIDATED_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_METER_END_DATE_SET_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_METER_END_DATE_SET_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_METER_LABEL_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_METER_LABEL_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_METER_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_METER_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_PROVIDER_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_PROVIDER_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_SERVICE_TYPE_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_SERVICE_TYPE_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_START_DATE_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_START_DATE_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_STATEMENT_MONTH_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_STATEMENT_MONTH_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_STATEMENT_YEAR_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_STATEMENT_YEAR_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_USAGE_UNITS_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_USAGE_UNITS_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_UTILITY_ACCOUNT_ID_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_UTILITY_ACCOUNT_ID_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_UTILITY_METER_ID_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_UTILITY_METER_ID_DESC', 'UTILITY_METER_STATEMENTS_MAX_ACCOUNT_LABEL_ASC', 'UTILITY_METER_STATEMENTS_MAX_ACCOUNT_LABEL_DESC', 'UTILITY_METER_STATEMENTS_MAX_ACCOUNT_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENTS_MAX_ACCOUNT_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENTS_MAX_BILL_ARRIVAL_DATE_ASC', 'UTILITY_METER_STATEMENTS_MAX_BILL_ARRIVAL_DATE_DESC', 'UTILITY_METER_STATEMENTS_MAX_CURRENCY_CODE_ASC', 'UTILITY_METER_STATEMENTS_MAX_CURRENCY_CODE_DESC', 'UTILITY_METER_STATEMENTS_MAX_DAYS_IN_BILL_ASC', 'UTILITY_METER_STATEMENTS_MAX_DAYS_IN_BILL_DESC', 'UTILITY_METER_STATEMENTS_MAX_DEMAND_UNITS_ASC', 'UTILITY_METER_STATEMENTS_MAX_DEMAND_UNITS_DESC', 'UTILITY_METER_STATEMENTS_MAX_END_DATE_ASC', 'UTILITY_METER_STATEMENTS_MAX_END_DATE_DESC', 'UTILITY_METER_STATEMENTS_MAX_EXCLUDE_USAGE_ASC', 'UTILITY_METER_STATEMENTS_MAX_EXCLUDE_USAGE_DESC', 'UTILITY_METER_STATEMENTS_MAX_FACILITY_ID_ASC', 'UTILITY_METER_STATEMENTS_MAX_FACILITY_ID_DESC', 'UTILITY_METER_STATEMENTS_MAX_IS_VALIDATED_ASC', 'UTILITY_METER_STATEMENTS_MAX_IS_VALIDATED_DESC', 'UTILITY_METER_STATEMENTS_MAX_METER_END_DATE_SET_ASC', 'UTILITY_METER_STATEMENTS_MAX_METER_END_DATE_SET_DESC', 'UTILITY_METER_STATEMENTS_MAX_METER_LABEL_ASC', 'UTILITY_METER_STATEMENTS_MAX_METER_LABEL_DESC', 'UTILITY_METER_STATEMENTS_MAX_METER_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENTS_MAX_METER_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENTS_MAX_PROVIDER_ASC', 'UTILITY_METER_STATEMENTS_MAX_PROVIDER_DESC', 'UTILITY_METER_STATEMENTS_MAX_SERVICE_TYPE_ASC', 'UTILITY_METER_STATEMENTS_MAX_SERVICE_TYPE_DESC', 'UTILITY_METER_STATEMENTS_MAX_START_DATE_ASC', 'UTILITY_METER_STATEMENTS_MAX_START_DATE_DESC', 'UTILITY_METER_STATEMENTS_MAX_STATEMENT_MONTH_ASC', 'UTILITY_METER_STATEMENTS_MAX_STATEMENT_MONTH_DESC', 'UTILITY_METER_STATEMENTS_MAX_STATEMENT_YEAR_ASC', 'UTILITY_METER_STATEMENTS_MAX_STATEMENT_YEAR_DESC', 'UTILITY_METER_STATEMENTS_MAX_USAGE_UNITS_ASC', 'UTILITY_METER_STATEMENTS_MAX_USAGE_UNITS_DESC', 'UTILITY_METER_STATEMENTS_MAX_UTILITY_ACCOUNT_ID_ASC', 'UTILITY_METER_STATEMENTS_MAX_UTILITY_ACCOUNT_ID_DESC', 'UTILITY_METER_STATEMENTS_MAX_UTILITY_METER_ID_ASC', 'UTILITY_METER_STATEMENTS_MAX_UTILITY_METER_ID_DESC', 'UTILITY_METER_STATEMENTS_MIN_ACCOUNT_LABEL_ASC', 'UTILITY_METER_STATEMENTS_MIN_ACCOUNT_LABEL_DESC', 'UTILITY_METER_STATEMENTS_MIN_ACCOUNT_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENTS_MIN_ACCOUNT_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENTS_MIN_BILL_ARRIVAL_DATE_ASC', 'UTILITY_METER_STATEMENTS_MIN_BILL_ARRIVAL_DATE_DESC', 'UTILITY_METER_STATEMENTS_MIN_CURRENCY_CODE_ASC', 'UTILITY_METER_STATEMENTS_MIN_CURRENCY_CODE_DESC', 'UTILITY_METER_STATEMENTS_MIN_DAYS_IN_BILL_ASC', 'UTILITY_METER_STATEMENTS_MIN_DAYS_IN_BILL_DESC', 'UTILITY_METER_STATEMENTS_MIN_DEMAND_UNITS_ASC', 'UTILITY_METER_STATEMENTS_MIN_DEMAND_UNITS_DESC', 'UTILITY_METER_STATEMENTS_MIN_END_DATE_ASC', 'UTILITY_METER_STATEMENTS_MIN_END_DATE_DESC', 'UTILITY_METER_STATEMENTS_MIN_EXCLUDE_USAGE_ASC', 'UTILITY_METER_STATEMENTS_MIN_EXCLUDE_USAGE_DESC', 'UTILITY_METER_STATEMENTS_MIN_FACILITY_ID_ASC', 'UTILITY_METER_STATEMENTS_MIN_FACILITY_ID_DESC', 'UTILITY_METER_STATEMENTS_MIN_IS_VALIDATED_ASC', 'UTILITY_METER_STATEMENTS_MIN_IS_VALIDATED_DESC', 'UTILITY_METER_STATEMENTS_MIN_METER_END_DATE_SET_ASC', 'UTILITY_METER_STATEMENTS_MIN_METER_END_DATE_SET_DESC', 'UTILITY_METER_STATEMENTS_MIN_METER_LABEL_ASC', 'UTILITY_METER_STATEMENTS_MIN_METER_LABEL_DESC', 'UTILITY_METER_STATEMENTS_MIN_METER_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENTS_MIN_METER_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENTS_MIN_PROVIDER_ASC', 'UTILITY_METER_STATEMENTS_MIN_PROVIDER_DESC', 'UTILITY_METER_STATEMENTS_MIN_SERVICE_TYPE_ASC', 'UTILITY_METER_STATEMENTS_MIN_SERVICE_TYPE_DESC', 'UTILITY_METER_STATEMENTS_MIN_START_DATE_ASC', 'UTILITY_METER_STATEMENTS_MIN_START_DATE_DESC', 'UTILITY_METER_STATEMENTS_MIN_STATEMENT_MONTH_ASC', 'UTILITY_METER_STATEMENTS_MIN_STATEMENT_MONTH_DESC', 'UTILITY_METER_STATEMENTS_MIN_STATEMENT_YEAR_ASC', 'UTILITY_METER_STATEMENTS_MIN_STATEMENT_YEAR_DESC', 'UTILITY_METER_STATEMENTS_MIN_USAGE_UNITS_ASC', 'UTILITY_METER_STATEMENTS_MIN_USAGE_UNITS_DESC', 'UTILITY_METER_STATEMENTS_MIN_UTILITY_ACCOUNT_ID_ASC', 'UTILITY_METER_STATEMENTS_MIN_UTILITY_ACCOUNT_ID_DESC', 'UTILITY_METER_STATEMENTS_MIN_UTILITY_METER_ID_ASC', 'UTILITY_METER_STATEMENTS_MIN_UTILITY_METER_ID_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_ACCOUNT_LABEL_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_ACCOUNT_LABEL_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_ACCOUNT_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_ACCOUNT_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_BILL_ARRIVAL_DATE_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_BILL_ARRIVAL_DATE_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_CURRENCY_CODE_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_CURRENCY_CODE_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_DAYS_IN_BILL_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_DAYS_IN_BILL_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_DEMAND_UNITS_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_DEMAND_UNITS_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_END_DATE_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_END_DATE_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_EXCLUDE_USAGE_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_EXCLUDE_USAGE_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_FACILITY_ID_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_FACILITY_ID_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_IS_VALIDATED_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_IS_VALIDATED_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_METER_END_DATE_SET_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_METER_END_DATE_SET_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_METER_LABEL_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_METER_LABEL_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_METER_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_METER_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_PROVIDER_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_PROVIDER_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_SERVICE_TYPE_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_SERVICE_TYPE_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_START_DATE_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_START_DATE_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_STATEMENT_MONTH_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_STATEMENT_MONTH_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_STATEMENT_YEAR_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_STATEMENT_YEAR_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_USAGE_UNITS_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_USAGE_UNITS_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_UTILITY_ACCOUNT_ID_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_UTILITY_ACCOUNT_ID_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_UTILITY_METER_ID_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_UTILITY_METER_ID_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_ACCOUNT_LABEL_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_ACCOUNT_LABEL_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_ACCOUNT_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_ACCOUNT_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_BILL_ARRIVAL_DATE_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_BILL_ARRIVAL_DATE_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_CURRENCY_CODE_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_CURRENCY_CODE_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_DAYS_IN_BILL_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_DAYS_IN_BILL_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_DEMAND_UNITS_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_DEMAND_UNITS_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_END_DATE_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_END_DATE_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_EXCLUDE_USAGE_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_EXCLUDE_USAGE_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_FACILITY_ID_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_FACILITY_ID_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_IS_VALIDATED_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_IS_VALIDATED_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_METER_END_DATE_SET_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_METER_END_DATE_SET_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_METER_LABEL_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_METER_LABEL_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_METER_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_METER_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_PROVIDER_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_PROVIDER_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_SERVICE_TYPE_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_SERVICE_TYPE_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_START_DATE_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_START_DATE_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_STATEMENT_MONTH_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_STATEMENT_MONTH_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_STATEMENT_YEAR_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_STATEMENT_YEAR_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_USAGE_UNITS_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_USAGE_UNITS_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_UTILITY_ACCOUNT_ID_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_UTILITY_ACCOUNT_ID_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_UTILITY_METER_ID_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_UTILITY_METER_ID_DESC', 'UTILITY_METER_STATEMENTS_SUM_ACCOUNT_LABEL_ASC', 'UTILITY_METER_STATEMENTS_SUM_ACCOUNT_LABEL_DESC', 'UTILITY_METER_STATEMENTS_SUM_ACCOUNT_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENTS_SUM_ACCOUNT_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENTS_SUM_BILL_ARRIVAL_DATE_ASC', 'UTILITY_METER_STATEMENTS_SUM_BILL_ARRIVAL_DATE_DESC', 'UTILITY_METER_STATEMENTS_SUM_CURRENCY_CODE_ASC', 'UTILITY_METER_STATEMENTS_SUM_CURRENCY_CODE_DESC', 'UTILITY_METER_STATEMENTS_SUM_DAYS_IN_BILL_ASC', 'UTILITY_METER_STATEMENTS_SUM_DAYS_IN_BILL_DESC', 'UTILITY_METER_STATEMENTS_SUM_DEMAND_UNITS_ASC', 'UTILITY_METER_STATEMENTS_SUM_DEMAND_UNITS_DESC', 'UTILITY_METER_STATEMENTS_SUM_END_DATE_ASC', 'UTILITY_METER_STATEMENTS_SUM_END_DATE_DESC', 'UTILITY_METER_STATEMENTS_SUM_EXCLUDE_USAGE_ASC', 'UTILITY_METER_STATEMENTS_SUM_EXCLUDE_USAGE_DESC', 'UTILITY_METER_STATEMENTS_SUM_FACILITY_ID_ASC', 'UTILITY_METER_STATEMENTS_SUM_FACILITY_ID_DESC', 'UTILITY_METER_STATEMENTS_SUM_IS_VALIDATED_ASC', 'UTILITY_METER_STATEMENTS_SUM_IS_VALIDATED_DESC', 'UTILITY_METER_STATEMENTS_SUM_METER_END_DATE_SET_ASC', 'UTILITY_METER_STATEMENTS_SUM_METER_END_DATE_SET_DESC', 'UTILITY_METER_STATEMENTS_SUM_METER_LABEL_ASC', 'UTILITY_METER_STATEMENTS_SUM_METER_LABEL_DESC', 'UTILITY_METER_STATEMENTS_SUM_METER_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENTS_SUM_METER_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENTS_SUM_PROVIDER_ASC', 'UTILITY_METER_STATEMENTS_SUM_PROVIDER_DESC', 'UTILITY_METER_STATEMENTS_SUM_SERVICE_TYPE_ASC', 'UTILITY_METER_STATEMENTS_SUM_SERVICE_TYPE_DESC', 'UTILITY_METER_STATEMENTS_SUM_START_DATE_ASC', 'UTILITY_METER_STATEMENTS_SUM_START_DATE_DESC', 'UTILITY_METER_STATEMENTS_SUM_STATEMENT_MONTH_ASC', 'UTILITY_METER_STATEMENTS_SUM_STATEMENT_MONTH_DESC', 'UTILITY_METER_STATEMENTS_SUM_STATEMENT_YEAR_ASC', 'UTILITY_METER_STATEMENTS_SUM_STATEMENT_YEAR_DESC', 'UTILITY_METER_STATEMENTS_SUM_USAGE_UNITS_ASC', 'UTILITY_METER_STATEMENTS_SUM_USAGE_UNITS_DESC', 'UTILITY_METER_STATEMENTS_SUM_UTILITY_ACCOUNT_ID_ASC', 'UTILITY_METER_STATEMENTS_SUM_UTILITY_ACCOUNT_ID_DESC', 'UTILITY_METER_STATEMENTS_SUM_UTILITY_METER_ID_ASC', 'UTILITY_METER_STATEMENTS_SUM_UTILITY_METER_ID_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_ACCOUNT_LABEL_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_ACCOUNT_LABEL_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_ACCOUNT_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_ACCOUNT_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_BILL_ARRIVAL_DATE_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_BILL_ARRIVAL_DATE_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_CURRENCY_CODE_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_CURRENCY_CODE_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_DAYS_IN_BILL_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_DAYS_IN_BILL_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_DEMAND_UNITS_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_DEMAND_UNITS_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_END_DATE_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_END_DATE_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_EXCLUDE_USAGE_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_EXCLUDE_USAGE_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_FACILITY_ID_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_FACILITY_ID_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_IS_VALIDATED_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_IS_VALIDATED_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_METER_END_DATE_SET_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_METER_END_DATE_SET_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_METER_LABEL_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_METER_LABEL_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_METER_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_METER_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_PROVIDER_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_PROVIDER_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_SERVICE_TYPE_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_SERVICE_TYPE_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_START_DATE_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_START_DATE_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_STATEMENT_MONTH_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_STATEMENT_MONTH_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_STATEMENT_YEAR_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_STATEMENT_YEAR_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_USAGE_UNITS_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_USAGE_UNITS_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_UTILITY_ACCOUNT_ID_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_UTILITY_ACCOUNT_ID_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_UTILITY_METER_ID_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_UTILITY_METER_ID_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_ACCOUNT_LABEL_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_ACCOUNT_LABEL_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_ACCOUNT_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_ACCOUNT_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_BILL_ARRIVAL_DATE_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_BILL_ARRIVAL_DATE_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_CURRENCY_CODE_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_CURRENCY_CODE_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_DAYS_IN_BILL_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_DAYS_IN_BILL_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_DEMAND_UNITS_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_DEMAND_UNITS_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_END_DATE_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_END_DATE_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_EXCLUDE_USAGE_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_EXCLUDE_USAGE_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_FACILITY_ID_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_FACILITY_ID_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_IS_VALIDATED_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_IS_VALIDATED_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_METER_END_DATE_SET_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_METER_END_DATE_SET_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_METER_LABEL_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_METER_LABEL_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_METER_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_METER_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_PROVIDER_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_PROVIDER_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_SERVICE_TYPE_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_SERVICE_TYPE_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_START_DATE_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_START_DATE_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_STATEMENT_MONTH_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_STATEMENT_MONTH_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_STATEMENT_YEAR_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_STATEMENT_YEAR_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_USAGE_UNITS_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_USAGE_UNITS_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_UTILITY_ACCOUNT_ID_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_UTILITY_ACCOUNT_ID_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_UTILITY_METER_ID_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_UTILITY_METER_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_ACCOUNT_LABEL_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_ACCOUNT_LABEL_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_ACCOUNT_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_ACCOUNT_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_BILL_ARRIVAL_DATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_BILL_ARRIVAL_DATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_BILL_COST_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_BILL_COST_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_BILL_DEMAND_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_BILL_DEMAND_COST_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_BILL_DEMAND_COST_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_BILL_DEMAND_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_BILL_USAGE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_BILL_USAGE_COST_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_BILL_USAGE_COST_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_BILL_USAGE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_BLENDED_RATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_BLENDED_RATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_CREDITS_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_CREDITS_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_CURRENCY_CODE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_CURRENCY_CODE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_DAYS_IN_BILL_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_DAYS_IN_BILL_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_DEMAND_UNITS_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_DEMAND_UNITS_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_END_DATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_END_DATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_FACILITY_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_FACILITY_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_FEES_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_FEES_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_IS_VALIDATED_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_IS_VALIDATED_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_LOAD_FACTOR_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_LOAD_FACTOR_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_METER_END_DATE_SET_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_METER_END_DATE_SET_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_METER_LABEL_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_METER_LABEL_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_METER_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_METER_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_NET_BILL_USAGE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_NET_BILL_USAGE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_PERCENT_CHANGE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_PERCENT_CHANGE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_PROVIDER_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_PROVIDER_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_SERVICE_TYPE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_SERVICE_TYPE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_START_DATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_START_DATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_STATEMENT_MONTH_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_STATEMENT_MONTH_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_STATEMENT_YEAR_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_STATEMENT_YEAR_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_TAXES_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_TAXES_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_USAGE_UNITS_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_USAGE_UNITS_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_UTILITY_ACCOUNT_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_UTILITY_ACCOUNT_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_UTILITY_METER_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_UTILITY_METER_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_COUNT_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_COUNT_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_ACCOUNT_LABEL_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_ACCOUNT_LABEL_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_ACCOUNT_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_ACCOUNT_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_BILL_ARRIVAL_DATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_BILL_ARRIVAL_DATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_BILL_COST_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_BILL_COST_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_BILL_DEMAND_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_BILL_DEMAND_COST_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_BILL_DEMAND_COST_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_BILL_DEMAND_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_BILL_USAGE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_BILL_USAGE_COST_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_BILL_USAGE_COST_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_BILL_USAGE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_BLENDED_RATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_BLENDED_RATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_ACCOUNT_LABEL_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_ACCOUNT_LABEL_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_ACCOUNT_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_ACCOUNT_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_BILL_ARRIVAL_DATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_BILL_ARRIVAL_DATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_BILL_COST_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_BILL_COST_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_BILL_DEMAND_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_BILL_DEMAND_COST_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_BILL_DEMAND_COST_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_BILL_DEMAND_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_BILL_USAGE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_BILL_USAGE_COST_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_BILL_USAGE_COST_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_BILL_USAGE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_BLENDED_RATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_BLENDED_RATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_CREDITS_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_CREDITS_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_CURRENCY_CODE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_CURRENCY_CODE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_DAYS_IN_BILL_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_DAYS_IN_BILL_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_DEMAND_UNITS_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_DEMAND_UNITS_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_END_DATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_END_DATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_FACILITY_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_FACILITY_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_FEES_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_FEES_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_IS_VALIDATED_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_IS_VALIDATED_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_LOAD_FACTOR_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_LOAD_FACTOR_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_METER_END_DATE_SET_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_METER_END_DATE_SET_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_METER_LABEL_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_METER_LABEL_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_METER_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_METER_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_NET_BILL_USAGE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_NET_BILL_USAGE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_PERCENT_CHANGE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_PERCENT_CHANGE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_PROVIDER_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_PROVIDER_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_SERVICE_TYPE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_SERVICE_TYPE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_START_DATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_START_DATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_STATEMENT_MONTH_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_STATEMENT_MONTH_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_STATEMENT_YEAR_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_STATEMENT_YEAR_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_TAXES_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_TAXES_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_USAGE_UNITS_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_USAGE_UNITS_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_UTILITY_ACCOUNT_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_UTILITY_ACCOUNT_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_UTILITY_METER_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_UTILITY_METER_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_CREDITS_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_CREDITS_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_CURRENCY_CODE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_CURRENCY_CODE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_DAYS_IN_BILL_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_DAYS_IN_BILL_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_DEMAND_UNITS_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_DEMAND_UNITS_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_END_DATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_END_DATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_FACILITY_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_FACILITY_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_FEES_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_FEES_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_IS_VALIDATED_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_IS_VALIDATED_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_LOAD_FACTOR_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_LOAD_FACTOR_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_METER_END_DATE_SET_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_METER_END_DATE_SET_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_METER_LABEL_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_METER_LABEL_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_METER_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_METER_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_NET_BILL_USAGE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_NET_BILL_USAGE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_PERCENT_CHANGE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_PERCENT_CHANGE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_PROVIDER_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_PROVIDER_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_SERVICE_TYPE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_SERVICE_TYPE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_START_DATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_START_DATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_STATEMENT_MONTH_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_STATEMENT_MONTH_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_STATEMENT_YEAR_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_STATEMENT_YEAR_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_TAXES_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_TAXES_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_USAGE_UNITS_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_USAGE_UNITS_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_UTILITY_ACCOUNT_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_UTILITY_ACCOUNT_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_UTILITY_METER_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_UTILITY_METER_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_ACCOUNT_LABEL_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_ACCOUNT_LABEL_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_ACCOUNT_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_ACCOUNT_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_BILL_ARRIVAL_DATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_BILL_ARRIVAL_DATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_BILL_COST_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_BILL_COST_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_BILL_DEMAND_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_BILL_DEMAND_COST_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_BILL_DEMAND_COST_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_BILL_DEMAND_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_BILL_USAGE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_BILL_USAGE_COST_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_BILL_USAGE_COST_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_BILL_USAGE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_BLENDED_RATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_BLENDED_RATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_CREDITS_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_CREDITS_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_CURRENCY_CODE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_CURRENCY_CODE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_DAYS_IN_BILL_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_DAYS_IN_BILL_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_DEMAND_UNITS_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_DEMAND_UNITS_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_END_DATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_END_DATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_FACILITY_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_FACILITY_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_FEES_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_FEES_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_IS_VALIDATED_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_IS_VALIDATED_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_LOAD_FACTOR_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_LOAD_FACTOR_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_METER_END_DATE_SET_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_METER_END_DATE_SET_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_METER_LABEL_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_METER_LABEL_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_METER_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_METER_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_NET_BILL_USAGE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_NET_BILL_USAGE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_PERCENT_CHANGE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_PERCENT_CHANGE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_PROVIDER_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_PROVIDER_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_SERVICE_TYPE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_SERVICE_TYPE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_START_DATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_START_DATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_STATEMENT_MONTH_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_STATEMENT_MONTH_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_STATEMENT_YEAR_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_STATEMENT_YEAR_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_TAXES_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_TAXES_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_USAGE_UNITS_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_USAGE_UNITS_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_UTILITY_ACCOUNT_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_UTILITY_ACCOUNT_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_UTILITY_METER_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_UTILITY_METER_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_ACCOUNT_LABEL_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_ACCOUNT_LABEL_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_ACCOUNT_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_ACCOUNT_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_BILL_ARRIVAL_DATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_BILL_ARRIVAL_DATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_BILL_COST_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_BILL_COST_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_BILL_DEMAND_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_BILL_DEMAND_COST_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_BILL_DEMAND_COST_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_BILL_DEMAND_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_BILL_USAGE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_BILL_USAGE_COST_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_BILL_USAGE_COST_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_BILL_USAGE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_BLENDED_RATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_BLENDED_RATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_CREDITS_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_CREDITS_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_CURRENCY_CODE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_CURRENCY_CODE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_DAYS_IN_BILL_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_DAYS_IN_BILL_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_DEMAND_UNITS_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_DEMAND_UNITS_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_END_DATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_END_DATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_FACILITY_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_FACILITY_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_FEES_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_FEES_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_IS_VALIDATED_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_IS_VALIDATED_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_LOAD_FACTOR_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_LOAD_FACTOR_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_METER_END_DATE_SET_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_METER_END_DATE_SET_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_METER_LABEL_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_METER_LABEL_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_METER_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_METER_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_NET_BILL_USAGE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_NET_BILL_USAGE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_PERCENT_CHANGE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_PERCENT_CHANGE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_PROVIDER_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_PROVIDER_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_SERVICE_TYPE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_SERVICE_TYPE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_START_DATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_START_DATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_STATEMENT_MONTH_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_STATEMENT_MONTH_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_STATEMENT_YEAR_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_STATEMENT_YEAR_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_TAXES_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_TAXES_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_USAGE_UNITS_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_USAGE_UNITS_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_UTILITY_ACCOUNT_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_UTILITY_ACCOUNT_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_UTILITY_METER_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_UTILITY_METER_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_ACCOUNT_LABEL_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_ACCOUNT_LABEL_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_ACCOUNT_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_ACCOUNT_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_BILL_ARRIVAL_DATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_BILL_ARRIVAL_DATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_BILL_COST_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_BILL_COST_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_BILL_DEMAND_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_BILL_DEMAND_COST_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_BILL_DEMAND_COST_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_BILL_DEMAND_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_BILL_USAGE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_BILL_USAGE_COST_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_BILL_USAGE_COST_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_BILL_USAGE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_BLENDED_RATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_BLENDED_RATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_CREDITS_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_CREDITS_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_CURRENCY_CODE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_CURRENCY_CODE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_DAYS_IN_BILL_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_DAYS_IN_BILL_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_DEMAND_UNITS_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_DEMAND_UNITS_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_END_DATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_END_DATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_FACILITY_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_FACILITY_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_FEES_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_FEES_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_IS_VALIDATED_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_IS_VALIDATED_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_LOAD_FACTOR_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_LOAD_FACTOR_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_METER_END_DATE_SET_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_METER_END_DATE_SET_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_METER_LABEL_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_METER_LABEL_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_METER_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_METER_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_NET_BILL_USAGE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_NET_BILL_USAGE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_PERCENT_CHANGE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_PERCENT_CHANGE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_PROVIDER_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_PROVIDER_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_SERVICE_TYPE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_SERVICE_TYPE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_START_DATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_START_DATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_STATEMENT_MONTH_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_STATEMENT_MONTH_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_STATEMENT_YEAR_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_STATEMENT_YEAR_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_TAXES_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_TAXES_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_USAGE_UNITS_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_USAGE_UNITS_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_UTILITY_ACCOUNT_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_UTILITY_ACCOUNT_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_UTILITY_METER_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_UTILITY_METER_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_ACCOUNT_LABEL_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_ACCOUNT_LABEL_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_ACCOUNT_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_ACCOUNT_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_BILL_ARRIVAL_DATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_BILL_ARRIVAL_DATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_BILL_COST_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_BILL_COST_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_BILL_DEMAND_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_BILL_DEMAND_COST_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_BILL_DEMAND_COST_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_BILL_DEMAND_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_BILL_USAGE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_BILL_USAGE_COST_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_BILL_USAGE_COST_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_BILL_USAGE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_BLENDED_RATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_BLENDED_RATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_CREDITS_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_CREDITS_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_CURRENCY_CODE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_CURRENCY_CODE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_DAYS_IN_BILL_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_DAYS_IN_BILL_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_DEMAND_UNITS_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_DEMAND_UNITS_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_END_DATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_END_DATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_FACILITY_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_FACILITY_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_FEES_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_FEES_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_IS_VALIDATED_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_IS_VALIDATED_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_LOAD_FACTOR_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_LOAD_FACTOR_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_METER_END_DATE_SET_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_METER_END_DATE_SET_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_METER_LABEL_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_METER_LABEL_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_METER_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_METER_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_NET_BILL_USAGE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_NET_BILL_USAGE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_PERCENT_CHANGE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_PERCENT_CHANGE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_PROVIDER_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_PROVIDER_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_SERVICE_TYPE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_SERVICE_TYPE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_START_DATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_START_DATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_STATEMENT_MONTH_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_STATEMENT_MONTH_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_STATEMENT_YEAR_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_STATEMENT_YEAR_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_TAXES_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_TAXES_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_USAGE_UNITS_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_USAGE_UNITS_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_UTILITY_ACCOUNT_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_UTILITY_ACCOUNT_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_UTILITY_METER_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_UTILITY_METER_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_ACCOUNT_LABEL_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_ACCOUNT_LABEL_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_ACCOUNT_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_ACCOUNT_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_BILL_ARRIVAL_DATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_BILL_ARRIVAL_DATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_BILL_COST_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_BILL_COST_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_BILL_DEMAND_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_BILL_DEMAND_COST_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_BILL_DEMAND_COST_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_BILL_DEMAND_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_BILL_USAGE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_BILL_USAGE_COST_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_BILL_USAGE_COST_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_BILL_USAGE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_BLENDED_RATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_BLENDED_RATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_CREDITS_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_CREDITS_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_CURRENCY_CODE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_CURRENCY_CODE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_DAYS_IN_BILL_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_DAYS_IN_BILL_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_DEMAND_UNITS_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_DEMAND_UNITS_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_END_DATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_END_DATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_FACILITY_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_FACILITY_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_FEES_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_FEES_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_IS_VALIDATED_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_IS_VALIDATED_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_LOAD_FACTOR_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_LOAD_FACTOR_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_METER_END_DATE_SET_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_METER_END_DATE_SET_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_METER_LABEL_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_METER_LABEL_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_METER_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_METER_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_NET_BILL_USAGE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_NET_BILL_USAGE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_PERCENT_CHANGE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_PERCENT_CHANGE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_PROVIDER_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_PROVIDER_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_SERVICE_TYPE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_SERVICE_TYPE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_START_DATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_START_DATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_STATEMENT_MONTH_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_STATEMENT_MONTH_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_STATEMENT_YEAR_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_STATEMENT_YEAR_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_TAXES_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_TAXES_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_USAGE_UNITS_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_USAGE_UNITS_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_UTILITY_ACCOUNT_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_UTILITY_ACCOUNT_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_UTILITY_METER_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_UTILITY_METER_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_ACCOUNT_LABEL_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_ACCOUNT_LABEL_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_ACCOUNT_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_ACCOUNT_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_BILL_ARRIVAL_DATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_BILL_ARRIVAL_DATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_BILL_COST_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_BILL_COST_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_BILL_DEMAND_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_BILL_DEMAND_COST_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_BILL_DEMAND_COST_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_BILL_DEMAND_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_BILL_USAGE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_BILL_USAGE_COST_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_BILL_USAGE_COST_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_BILL_USAGE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_BLENDED_RATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_BLENDED_RATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_CREDITS_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_CREDITS_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_CURRENCY_CODE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_CURRENCY_CODE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_DAYS_IN_BILL_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_DAYS_IN_BILL_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_DEMAND_UNITS_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_DEMAND_UNITS_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_END_DATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_END_DATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_FACILITY_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_FACILITY_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_FEES_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_FEES_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_IS_VALIDATED_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_IS_VALIDATED_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_LOAD_FACTOR_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_LOAD_FACTOR_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_METER_END_DATE_SET_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_METER_END_DATE_SET_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_METER_LABEL_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_METER_LABEL_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_METER_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_METER_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_NET_BILL_USAGE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_NET_BILL_USAGE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_PERCENT_CHANGE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_PERCENT_CHANGE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_PROVIDER_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_PROVIDER_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_SERVICE_TYPE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_SERVICE_TYPE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_START_DATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_START_DATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_STATEMENT_MONTH_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_STATEMENT_MONTH_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_STATEMENT_YEAR_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_STATEMENT_YEAR_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_TAXES_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_TAXES_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_USAGE_UNITS_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_USAGE_UNITS_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_UTILITY_ACCOUNT_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_UTILITY_ACCOUNT_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_UTILITY_METER_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_UTILITY_METER_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_ACCOUNT_LABEL_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_ACCOUNT_LABEL_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_ACCOUNT_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_ACCOUNT_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_BILL_ARRIVAL_DATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_BILL_ARRIVAL_DATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_BILL_COST_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_BILL_COST_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_BILL_DEMAND_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_BILL_DEMAND_COST_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_BILL_DEMAND_COST_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_BILL_DEMAND_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_BILL_USAGE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_BILL_USAGE_COST_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_BILL_USAGE_COST_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_BILL_USAGE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_BLENDED_RATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_BLENDED_RATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_CREDITS_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_CREDITS_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_CURRENCY_CODE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_CURRENCY_CODE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_DAYS_IN_BILL_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_DAYS_IN_BILL_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_DEMAND_UNITS_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_DEMAND_UNITS_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_END_DATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_END_DATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_FACILITY_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_FACILITY_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_FEES_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_FEES_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_IS_VALIDATED_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_IS_VALIDATED_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_LOAD_FACTOR_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_LOAD_FACTOR_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_METER_END_DATE_SET_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_METER_END_DATE_SET_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_METER_LABEL_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_METER_LABEL_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_METER_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_METER_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_NET_BILL_USAGE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_NET_BILL_USAGE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_PERCENT_CHANGE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_PERCENT_CHANGE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_PROVIDER_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_PROVIDER_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_SERVICE_TYPE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_SERVICE_TYPE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_START_DATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_START_DATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_STATEMENT_MONTH_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_STATEMENT_MONTH_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_STATEMENT_YEAR_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_STATEMENT_YEAR_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_TAXES_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_TAXES_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_USAGE_UNITS_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_USAGE_UNITS_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_UTILITY_ACCOUNT_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_UTILITY_ACCOUNT_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_UTILITY_METER_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_UTILITY_METER_ID_DESC', 'UTILITY_PROVIDER_ID_ASC', 'UTILITY_PROVIDER_ID_DESC')


class UtilityIntegration(sgqlc.types.Enum):
    __schema__ = nionic_schema
    __choices__ = ('MANUAL', 'URJANET')


class UtilityMeterChargeCategory(sgqlc.types.Enum):
    __schema__ = nionic_schema
    __choices__ = ('CREDITS', 'DEMAND', 'FEES', 'TAXES', 'USAGE')


class UtilityMeterServiceType(sgqlc.types.Enum):
    __schema__ = nionic_schema
    __choices__ = ('ELECTRIC', 'IRRIGATION', 'LIGHTING', 'NATURAL_GAS', 'OTHER', 'PROPANE', 'SANITATION', 'SEWER', 'SOLAR', 'WATER')


class UtilityMeterStatementRollupsGroupBy(sgqlc.types.Enum):
    __schema__ = nionic_schema
    __choices__ = ('ACCOUNT_LABEL', 'ACCOUNT_LABEL_DISTINCT', 'ACCOUNT_STATEMENT_ID', 'ACCOUNT_STATEMENT_ID_DISTINCT', 'BILL_ARRIVAL_DATE', 'BILL_ARRIVAL_DATE_DISTINCT', 'BILL_ARRIVAL_DATE_TRUNCATED_TO_DAY', 'BILL_ARRIVAL_DATE_TRUNCATED_TO_HOUR', 'BILL_COST', 'BILL_COST_DISTINCT', 'BILL_DEMAND', 'BILL_DEMAND_COST', 'BILL_DEMAND_COST_DISTINCT', 'BILL_DEMAND_DISTINCT', 'BILL_USAGE', 'BILL_USAGE_COST', 'BILL_USAGE_COST_DISTINCT', 'BILL_USAGE_DISTINCT', 'BLENDED_RATE', 'BLENDED_RATE_DISTINCT', 'CREDITS', 'CREDITS_DISTINCT', 'CURRENCY_CODE', 'CURRENCY_CODE_DISTINCT', 'DAYS_IN_BILL', 'DAYS_IN_BILL_DISTINCT', 'DEMAND_UNITS', 'DEMAND_UNITS_DISTINCT', 'END_DATE', 'END_DATE_DISTINCT', 'FACILITY_ID', 'FACILITY_ID_DISTINCT', 'FEES', 'FEES_DISTINCT', 'IS_VALIDATED', 'IS_VALIDATED_DISTINCT', 'LOAD_FACTOR', 'LOAD_FACTOR_DISTINCT', 'METER_END_DATE_SET', 'METER_END_DATE_SET_DISTINCT', 'METER_LABEL', 'METER_LABEL_DISTINCT', 'METER_STATEMENT_ID', 'METER_STATEMENT_ID_DISTINCT', 'NET_BILL_USAGE', 'NET_BILL_USAGE_DISTINCT', 'PERCENT_CHANGE', 'PERCENT_CHANGE_DISTINCT', 'PROVIDER', 'PROVIDER_DISTINCT', 'SERVICE_TYPE', 'SERVICE_TYPE_DISTINCT', 'START_DATE', 'START_DATE_DISTINCT', 'STATEMENT_MONTH', 'STATEMENT_MONTH_DISTINCT', 'STATEMENT_YEAR', 'STATEMENT_YEAR_DISTINCT', 'TAXES', 'TAXES_DISTINCT', 'USAGE_UNITS', 'USAGE_UNITS_DISTINCT', 'UTILITY_ACCOUNT_ID', 'UTILITY_ACCOUNT_ID_DISTINCT', 'UTILITY_METER_ID', 'UTILITY_METER_ID_DISTINCT')


class UtilityMeterStatementRollupsOrderBy(sgqlc.types.Enum):
    __schema__ = nionic_schema
    __choices__ = ('ACCOUNT_LABEL_ASC', 'ACCOUNT_LABEL_DESC', 'ACCOUNT_STATEMENT_ID_ASC', 'ACCOUNT_STATEMENT_ID_DESC', 'BILL_ARRIVAL_DATE_ASC', 'BILL_ARRIVAL_DATE_DESC', 'BILL_COST_ASC', 'BILL_COST_DESC', 'BILL_DEMAND_ASC', 'BILL_DEMAND_COST_ASC', 'BILL_DEMAND_COST_DESC', 'BILL_DEMAND_DESC', 'BILL_USAGE_ASC', 'BILL_USAGE_COST_ASC', 'BILL_USAGE_COST_DESC', 'BILL_USAGE_DESC', 'BLENDED_RATE_ASC', 'BLENDED_RATE_DESC', 'CREDITS_ASC', 'CREDITS_DESC', 'CURRENCY_CODE_ASC', 'CURRENCY_CODE_DESC', 'DAYS_IN_BILL_ASC', 'DAYS_IN_BILL_DESC', 'DEMAND_UNITS_ASC', 'DEMAND_UNITS_DESC', 'END_DATE_ASC', 'END_DATE_DESC', 'FACILITY_ID_ASC', 'FACILITY_ID_DESC', 'FACILITY_NAME_ASC', 'FACILITY_NAME_DESC', 'FEES_ASC', 'FEES_DESC', 'IS_VALIDATED_ASC', 'IS_VALIDATED_DESC', 'LOAD_FACTOR_ASC', 'LOAD_FACTOR_DESC', 'METER_END_DATE_SET_ASC', 'METER_END_DATE_SET_DESC', 'METER_LABEL_ASC', 'METER_LABEL_DESC', 'METER_STATEMENT_ID_ASC', 'METER_STATEMENT_ID_DESC', 'NATURAL', 'NET_BILL_USAGE_ASC', 'NET_BILL_USAGE_DESC', 'N_SIGHT2_ACTIVE_ASC', 'N_SIGHT2_ACTIVE_DESC', 'PERCENT_CHANGE_ASC', 'PERCENT_CHANGE_DESC', 'PRIMARY_KEY_ASC', 'PRIMARY_KEY_DESC', 'PROVIDER_ASC', 'PROVIDER_DESC', 'SERVICE_TYPE_ASC', 'SERVICE_TYPE_DESC', 'START_DATE_ASC', 'START_DATE_DESC', 'STATEMENT_DATE_ASC', 'STATEMENT_DATE_DESC', 'STATEMENT_MONTH_ASC', 'STATEMENT_MONTH_DESC', 'STATEMENT_YEAR_ASC', 'STATEMENT_YEAR_DESC', 'TAXES_ASC', 'TAXES_DESC', 'USAGE_UNITS_ASC', 'USAGE_UNITS_DESC', 'UTILITY_ACCOUNT_ID_ASC', 'UTILITY_ACCOUNT_ID_DESC', 'UTILITY_METER_ID_ASC', 'UTILITY_METER_ID_DESC')


class UtilityMeterStatementsGroupBy(sgqlc.types.Enum):
    __schema__ = nionic_schema
    __choices__ = ('ACCOUNT_LABEL', 'ACCOUNT_LABEL_DISTINCT', 'ACCOUNT_STATEMENT_ID', 'ACCOUNT_STATEMENT_ID_DISTINCT', 'BILL_ARRIVAL_DATE', 'BILL_ARRIVAL_DATE_DISTINCT', 'BILL_ARRIVAL_DATE_TRUNCATED_TO_DAY', 'BILL_ARRIVAL_DATE_TRUNCATED_TO_HOUR', 'CURRENCY_CODE', 'CURRENCY_CODE_DISTINCT', 'DAYS_IN_BILL', 'DAYS_IN_BILL_DISTINCT', 'DEMAND_UNITS', 'DEMAND_UNITS_DISTINCT', 'END_DATE', 'END_DATE_DISTINCT', 'EXCLUDE_USAGE', 'EXCLUDE_USAGE_DISTINCT', 'FACILITY_ID', 'FACILITY_ID_DISTINCT', 'IS_VALIDATED', 'IS_VALIDATED_DISTINCT', 'METER_END_DATE_SET', 'METER_END_DATE_SET_DISTINCT', 'METER_LABEL', 'METER_LABEL_DISTINCT', 'METER_STATEMENT_ID', 'METER_STATEMENT_ID_DISTINCT', 'PROVIDER', 'PROVIDER_DISTINCT', 'SERVICE_TYPE', 'SERVICE_TYPE_DISTINCT', 'START_DATE', 'START_DATE_DISTINCT', 'STATEMENT_MONTH', 'STATEMENT_MONTH_DISTINCT', 'STATEMENT_YEAR', 'STATEMENT_YEAR_DISTINCT', 'USAGE_UNITS', 'USAGE_UNITS_DISTINCT', 'UTILITY_ACCOUNT_ID', 'UTILITY_ACCOUNT_ID_DISTINCT', 'UTILITY_METER_ID', 'UTILITY_METER_ID_DISTINCT')


class UtilityMeterStatementsOrderBy(sgqlc.types.Enum):
    __schema__ = nionic_schema
    __choices__ = ('ACCOUNT_LABEL_ASC', 'ACCOUNT_LABEL_DESC', 'ACCOUNT_STATEMENT_ID_ASC', 'ACCOUNT_STATEMENT_ID_DESC', 'BILL_ARRIVAL_DATE_ASC', 'BILL_ARRIVAL_DATE_DESC', 'CURRENCY_CODE_ASC', 'CURRENCY_CODE_DESC', 'DAYS_IN_BILL_ASC', 'DAYS_IN_BILL_DESC', 'DEMAND_UNITS_ASC', 'DEMAND_UNITS_DESC', 'END_DATE_ASC', 'END_DATE_DESC', 'EXCLUDE_USAGE_ASC', 'EXCLUDE_USAGE_DESC', 'FACILITY_ID_ASC', 'FACILITY_ID_DESC', 'IS_VALIDATED_ASC', 'IS_VALIDATED_DESC', 'METER_END_DATE_SET_ASC', 'METER_END_DATE_SET_DESC', 'METER_LABEL_ASC', 'METER_LABEL_DESC', 'METER_STATEMENT_ID_ASC', 'METER_STATEMENT_ID_DESC', 'NATURAL', 'PRIMARY_KEY_ASC', 'PRIMARY_KEY_DESC', 'PROVIDER_ASC', 'PROVIDER_DESC', 'SERVICE_TYPE_ASC', 'SERVICE_TYPE_DESC', 'START_DATE_ASC', 'START_DATE_DESC', 'STATEMENT_MONTH_ASC', 'STATEMENT_MONTH_DESC', 'STATEMENT_YEAR_ASC', 'STATEMENT_YEAR_DESC', 'USAGE_UNITS_ASC', 'USAGE_UNITS_DESC', 'UTILITY_ACCOUNT_ID_ASC', 'UTILITY_ACCOUNT_ID_DESC', 'UTILITY_METER_ID_ASC', 'UTILITY_METER_ID_DESC')


class UtilityMeterUsageCategory(sgqlc.types.Enum):
    __schema__ = nionic_schema
    __choices__ = ('DEMAND', 'USAGE')


class UtilityMetersOrderBy(sgqlc.types.Enum):
    __schema__ = nionic_schema
    __choices__ = ('ACTIVE_END_ASC', 'ACTIVE_END_DESC', 'ACTIVE_START_ASC', 'ACTIVE_START_DESC', 'CREATED_AT_ASC', 'CREATED_AT_DESC', 'DEFAULT_DEMAND_UNITS_ASC', 'DEFAULT_DEMAND_UNITS_DESC', 'DEFAULT_USAGE_UNITS_ASC', 'DEFAULT_USAGE_UNITS_DESC', 'DELETED_AT_ASC', 'DELETED_AT_DESC', 'EXCLUDE_CARBON_ASC', 'EXCLUDE_CARBON_DESC', 'EXCLUDE_USAGE_ASC', 'EXCLUDE_USAGE_DESC', 'FACILITY_ID_ASC', 'FACILITY_ID_DESC', 'ID_ASC', 'ID_DESC', 'INTEGRATION_METER_KEY_ASC', 'INTEGRATION_METER_KEY_DESC', 'METADATA_ASC', 'METADATA_DESC', 'METER_NUMBER_ASC', 'METER_NUMBER_DESC', 'NAME_ASC', 'NAME_DESC', 'NATURAL', 'OVERRIDE_AT_ASC', 'OVERRIDE_AT_DESC', 'OVERRIDE_METER_NUMBER_ASC', 'OVERRIDE_METER_NUMBER_DESC', 'PRIMARY_KEY_ASC', 'PRIMARY_KEY_DESC', 'SERVICE_TYPE_ASC', 'SERVICE_TYPE_DESC', 'UPDATED_AT_ASC', 'UPDATED_AT_DESC', 'UTILITY_ACCOUNT_ID_ASC', 'UTILITY_ACCOUNT_ID_DESC', 'UTILITY_METER_STATEMENTS_AVERAGE_ACCOUNT_LABEL_ASC', 'UTILITY_METER_STATEMENTS_AVERAGE_ACCOUNT_LABEL_DESC', 'UTILITY_METER_STATEMENTS_AVERAGE_ACCOUNT_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENTS_AVERAGE_ACCOUNT_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENTS_AVERAGE_BILL_ARRIVAL_DATE_ASC', 'UTILITY_METER_STATEMENTS_AVERAGE_BILL_ARRIVAL_DATE_DESC', 'UTILITY_METER_STATEMENTS_AVERAGE_CURRENCY_CODE_ASC', 'UTILITY_METER_STATEMENTS_AVERAGE_CURRENCY_CODE_DESC', 'UTILITY_METER_STATEMENTS_AVERAGE_DAYS_IN_BILL_ASC', 'UTILITY_METER_STATEMENTS_AVERAGE_DAYS_IN_BILL_DESC', 'UTILITY_METER_STATEMENTS_AVERAGE_DEMAND_UNITS_ASC', 'UTILITY_METER_STATEMENTS_AVERAGE_DEMAND_UNITS_DESC', 'UTILITY_METER_STATEMENTS_AVERAGE_END_DATE_ASC', 'UTILITY_METER_STATEMENTS_AVERAGE_END_DATE_DESC', 'UTILITY_METER_STATEMENTS_AVERAGE_EXCLUDE_USAGE_ASC', 'UTILITY_METER_STATEMENTS_AVERAGE_EXCLUDE_USAGE_DESC', 'UTILITY_METER_STATEMENTS_AVERAGE_FACILITY_ID_ASC', 'UTILITY_METER_STATEMENTS_AVERAGE_FACILITY_ID_DESC', 'UTILITY_METER_STATEMENTS_AVERAGE_IS_VALIDATED_ASC', 'UTILITY_METER_STATEMENTS_AVERAGE_IS_VALIDATED_DESC', 'UTILITY_METER_STATEMENTS_AVERAGE_METER_END_DATE_SET_ASC', 'UTILITY_METER_STATEMENTS_AVERAGE_METER_END_DATE_SET_DESC', 'UTILITY_METER_STATEMENTS_AVERAGE_METER_LABEL_ASC', 'UTILITY_METER_STATEMENTS_AVERAGE_METER_LABEL_DESC', 'UTILITY_METER_STATEMENTS_AVERAGE_METER_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENTS_AVERAGE_METER_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENTS_AVERAGE_PROVIDER_ASC', 'UTILITY_METER_STATEMENTS_AVERAGE_PROVIDER_DESC', 'UTILITY_METER_STATEMENTS_AVERAGE_SERVICE_TYPE_ASC', 'UTILITY_METER_STATEMENTS_AVERAGE_SERVICE_TYPE_DESC', 'UTILITY_METER_STATEMENTS_AVERAGE_START_DATE_ASC', 'UTILITY_METER_STATEMENTS_AVERAGE_START_DATE_DESC', 'UTILITY_METER_STATEMENTS_AVERAGE_STATEMENT_MONTH_ASC', 'UTILITY_METER_STATEMENTS_AVERAGE_STATEMENT_MONTH_DESC', 'UTILITY_METER_STATEMENTS_AVERAGE_STATEMENT_YEAR_ASC', 'UTILITY_METER_STATEMENTS_AVERAGE_STATEMENT_YEAR_DESC', 'UTILITY_METER_STATEMENTS_AVERAGE_USAGE_UNITS_ASC', 'UTILITY_METER_STATEMENTS_AVERAGE_USAGE_UNITS_DESC', 'UTILITY_METER_STATEMENTS_AVERAGE_UTILITY_ACCOUNT_ID_ASC', 'UTILITY_METER_STATEMENTS_AVERAGE_UTILITY_ACCOUNT_ID_DESC', 'UTILITY_METER_STATEMENTS_AVERAGE_UTILITY_METER_ID_ASC', 'UTILITY_METER_STATEMENTS_AVERAGE_UTILITY_METER_ID_DESC', 'UTILITY_METER_STATEMENTS_COUNT_ASC', 'UTILITY_METER_STATEMENTS_COUNT_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_ACCOUNT_LABEL_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_ACCOUNT_LABEL_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_ACCOUNT_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_ACCOUNT_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_BILL_ARRIVAL_DATE_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_BILL_ARRIVAL_DATE_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_ACCOUNT_LABEL_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_ACCOUNT_LABEL_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_ACCOUNT_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_ACCOUNT_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_BILL_ARRIVAL_DATE_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_BILL_ARRIVAL_DATE_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_CURRENCY_CODE_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_CURRENCY_CODE_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_DAYS_IN_BILL_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_DAYS_IN_BILL_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_DEMAND_UNITS_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_DEMAND_UNITS_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_END_DATE_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_END_DATE_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_EXCLUDE_USAGE_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_EXCLUDE_USAGE_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_FACILITY_ID_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_FACILITY_ID_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_IS_VALIDATED_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_IS_VALIDATED_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_METER_END_DATE_SET_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_METER_END_DATE_SET_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_METER_LABEL_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_METER_LABEL_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_METER_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_METER_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_PROVIDER_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_PROVIDER_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_SERVICE_TYPE_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_SERVICE_TYPE_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_START_DATE_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_START_DATE_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_STATEMENT_MONTH_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_STATEMENT_MONTH_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_STATEMENT_YEAR_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_STATEMENT_YEAR_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_USAGE_UNITS_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_USAGE_UNITS_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_UTILITY_ACCOUNT_ID_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_UTILITY_ACCOUNT_ID_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_UTILITY_METER_ID_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_COUNT_UTILITY_METER_ID_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_CURRENCY_CODE_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_CURRENCY_CODE_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_DAYS_IN_BILL_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_DAYS_IN_BILL_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_DEMAND_UNITS_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_DEMAND_UNITS_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_END_DATE_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_END_DATE_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_EXCLUDE_USAGE_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_EXCLUDE_USAGE_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_FACILITY_ID_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_FACILITY_ID_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_IS_VALIDATED_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_IS_VALIDATED_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_METER_END_DATE_SET_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_METER_END_DATE_SET_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_METER_LABEL_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_METER_LABEL_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_METER_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_METER_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_PROVIDER_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_PROVIDER_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_SERVICE_TYPE_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_SERVICE_TYPE_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_START_DATE_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_START_DATE_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_STATEMENT_MONTH_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_STATEMENT_MONTH_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_STATEMENT_YEAR_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_STATEMENT_YEAR_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_USAGE_UNITS_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_USAGE_UNITS_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_UTILITY_ACCOUNT_ID_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_UTILITY_ACCOUNT_ID_DESC', 'UTILITY_METER_STATEMENTS_DISTINCT_UTILITY_METER_ID_ASC', 'UTILITY_METER_STATEMENTS_DISTINCT_UTILITY_METER_ID_DESC', 'UTILITY_METER_STATEMENTS_MAX_ACCOUNT_LABEL_ASC', 'UTILITY_METER_STATEMENTS_MAX_ACCOUNT_LABEL_DESC', 'UTILITY_METER_STATEMENTS_MAX_ACCOUNT_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENTS_MAX_ACCOUNT_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENTS_MAX_BILL_ARRIVAL_DATE_ASC', 'UTILITY_METER_STATEMENTS_MAX_BILL_ARRIVAL_DATE_DESC', 'UTILITY_METER_STATEMENTS_MAX_CURRENCY_CODE_ASC', 'UTILITY_METER_STATEMENTS_MAX_CURRENCY_CODE_DESC', 'UTILITY_METER_STATEMENTS_MAX_DAYS_IN_BILL_ASC', 'UTILITY_METER_STATEMENTS_MAX_DAYS_IN_BILL_DESC', 'UTILITY_METER_STATEMENTS_MAX_DEMAND_UNITS_ASC', 'UTILITY_METER_STATEMENTS_MAX_DEMAND_UNITS_DESC', 'UTILITY_METER_STATEMENTS_MAX_END_DATE_ASC', 'UTILITY_METER_STATEMENTS_MAX_END_DATE_DESC', 'UTILITY_METER_STATEMENTS_MAX_EXCLUDE_USAGE_ASC', 'UTILITY_METER_STATEMENTS_MAX_EXCLUDE_USAGE_DESC', 'UTILITY_METER_STATEMENTS_MAX_FACILITY_ID_ASC', 'UTILITY_METER_STATEMENTS_MAX_FACILITY_ID_DESC', 'UTILITY_METER_STATEMENTS_MAX_IS_VALIDATED_ASC', 'UTILITY_METER_STATEMENTS_MAX_IS_VALIDATED_DESC', 'UTILITY_METER_STATEMENTS_MAX_METER_END_DATE_SET_ASC', 'UTILITY_METER_STATEMENTS_MAX_METER_END_DATE_SET_DESC', 'UTILITY_METER_STATEMENTS_MAX_METER_LABEL_ASC', 'UTILITY_METER_STATEMENTS_MAX_METER_LABEL_DESC', 'UTILITY_METER_STATEMENTS_MAX_METER_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENTS_MAX_METER_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENTS_MAX_PROVIDER_ASC', 'UTILITY_METER_STATEMENTS_MAX_PROVIDER_DESC', 'UTILITY_METER_STATEMENTS_MAX_SERVICE_TYPE_ASC', 'UTILITY_METER_STATEMENTS_MAX_SERVICE_TYPE_DESC', 'UTILITY_METER_STATEMENTS_MAX_START_DATE_ASC', 'UTILITY_METER_STATEMENTS_MAX_START_DATE_DESC', 'UTILITY_METER_STATEMENTS_MAX_STATEMENT_MONTH_ASC', 'UTILITY_METER_STATEMENTS_MAX_STATEMENT_MONTH_DESC', 'UTILITY_METER_STATEMENTS_MAX_STATEMENT_YEAR_ASC', 'UTILITY_METER_STATEMENTS_MAX_STATEMENT_YEAR_DESC', 'UTILITY_METER_STATEMENTS_MAX_USAGE_UNITS_ASC', 'UTILITY_METER_STATEMENTS_MAX_USAGE_UNITS_DESC', 'UTILITY_METER_STATEMENTS_MAX_UTILITY_ACCOUNT_ID_ASC', 'UTILITY_METER_STATEMENTS_MAX_UTILITY_ACCOUNT_ID_DESC', 'UTILITY_METER_STATEMENTS_MAX_UTILITY_METER_ID_ASC', 'UTILITY_METER_STATEMENTS_MAX_UTILITY_METER_ID_DESC', 'UTILITY_METER_STATEMENTS_MIN_ACCOUNT_LABEL_ASC', 'UTILITY_METER_STATEMENTS_MIN_ACCOUNT_LABEL_DESC', 'UTILITY_METER_STATEMENTS_MIN_ACCOUNT_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENTS_MIN_ACCOUNT_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENTS_MIN_BILL_ARRIVAL_DATE_ASC', 'UTILITY_METER_STATEMENTS_MIN_BILL_ARRIVAL_DATE_DESC', 'UTILITY_METER_STATEMENTS_MIN_CURRENCY_CODE_ASC', 'UTILITY_METER_STATEMENTS_MIN_CURRENCY_CODE_DESC', 'UTILITY_METER_STATEMENTS_MIN_DAYS_IN_BILL_ASC', 'UTILITY_METER_STATEMENTS_MIN_DAYS_IN_BILL_DESC', 'UTILITY_METER_STATEMENTS_MIN_DEMAND_UNITS_ASC', 'UTILITY_METER_STATEMENTS_MIN_DEMAND_UNITS_DESC', 'UTILITY_METER_STATEMENTS_MIN_END_DATE_ASC', 'UTILITY_METER_STATEMENTS_MIN_END_DATE_DESC', 'UTILITY_METER_STATEMENTS_MIN_EXCLUDE_USAGE_ASC', 'UTILITY_METER_STATEMENTS_MIN_EXCLUDE_USAGE_DESC', 'UTILITY_METER_STATEMENTS_MIN_FACILITY_ID_ASC', 'UTILITY_METER_STATEMENTS_MIN_FACILITY_ID_DESC', 'UTILITY_METER_STATEMENTS_MIN_IS_VALIDATED_ASC', 'UTILITY_METER_STATEMENTS_MIN_IS_VALIDATED_DESC', 'UTILITY_METER_STATEMENTS_MIN_METER_END_DATE_SET_ASC', 'UTILITY_METER_STATEMENTS_MIN_METER_END_DATE_SET_DESC', 'UTILITY_METER_STATEMENTS_MIN_METER_LABEL_ASC', 'UTILITY_METER_STATEMENTS_MIN_METER_LABEL_DESC', 'UTILITY_METER_STATEMENTS_MIN_METER_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENTS_MIN_METER_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENTS_MIN_PROVIDER_ASC', 'UTILITY_METER_STATEMENTS_MIN_PROVIDER_DESC', 'UTILITY_METER_STATEMENTS_MIN_SERVICE_TYPE_ASC', 'UTILITY_METER_STATEMENTS_MIN_SERVICE_TYPE_DESC', 'UTILITY_METER_STATEMENTS_MIN_START_DATE_ASC', 'UTILITY_METER_STATEMENTS_MIN_START_DATE_DESC', 'UTILITY_METER_STATEMENTS_MIN_STATEMENT_MONTH_ASC', 'UTILITY_METER_STATEMENTS_MIN_STATEMENT_MONTH_DESC', 'UTILITY_METER_STATEMENTS_MIN_STATEMENT_YEAR_ASC', 'UTILITY_METER_STATEMENTS_MIN_STATEMENT_YEAR_DESC', 'UTILITY_METER_STATEMENTS_MIN_USAGE_UNITS_ASC', 'UTILITY_METER_STATEMENTS_MIN_USAGE_UNITS_DESC', 'UTILITY_METER_STATEMENTS_MIN_UTILITY_ACCOUNT_ID_ASC', 'UTILITY_METER_STATEMENTS_MIN_UTILITY_ACCOUNT_ID_DESC', 'UTILITY_METER_STATEMENTS_MIN_UTILITY_METER_ID_ASC', 'UTILITY_METER_STATEMENTS_MIN_UTILITY_METER_ID_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_ACCOUNT_LABEL_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_ACCOUNT_LABEL_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_ACCOUNT_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_ACCOUNT_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_BILL_ARRIVAL_DATE_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_BILL_ARRIVAL_DATE_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_CURRENCY_CODE_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_CURRENCY_CODE_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_DAYS_IN_BILL_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_DAYS_IN_BILL_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_DEMAND_UNITS_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_DEMAND_UNITS_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_END_DATE_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_END_DATE_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_EXCLUDE_USAGE_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_EXCLUDE_USAGE_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_FACILITY_ID_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_FACILITY_ID_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_IS_VALIDATED_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_IS_VALIDATED_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_METER_END_DATE_SET_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_METER_END_DATE_SET_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_METER_LABEL_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_METER_LABEL_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_METER_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_METER_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_PROVIDER_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_PROVIDER_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_SERVICE_TYPE_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_SERVICE_TYPE_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_START_DATE_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_START_DATE_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_STATEMENT_MONTH_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_STATEMENT_MONTH_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_STATEMENT_YEAR_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_STATEMENT_YEAR_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_USAGE_UNITS_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_USAGE_UNITS_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_UTILITY_ACCOUNT_ID_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_UTILITY_ACCOUNT_ID_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_UTILITY_METER_ID_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_POPULATION_UTILITY_METER_ID_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_ACCOUNT_LABEL_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_ACCOUNT_LABEL_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_ACCOUNT_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_ACCOUNT_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_BILL_ARRIVAL_DATE_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_BILL_ARRIVAL_DATE_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_CURRENCY_CODE_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_CURRENCY_CODE_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_DAYS_IN_BILL_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_DAYS_IN_BILL_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_DEMAND_UNITS_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_DEMAND_UNITS_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_END_DATE_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_END_DATE_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_EXCLUDE_USAGE_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_EXCLUDE_USAGE_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_FACILITY_ID_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_FACILITY_ID_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_IS_VALIDATED_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_IS_VALIDATED_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_METER_END_DATE_SET_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_METER_END_DATE_SET_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_METER_LABEL_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_METER_LABEL_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_METER_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_METER_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_PROVIDER_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_PROVIDER_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_SERVICE_TYPE_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_SERVICE_TYPE_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_START_DATE_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_START_DATE_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_STATEMENT_MONTH_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_STATEMENT_MONTH_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_STATEMENT_YEAR_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_STATEMENT_YEAR_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_USAGE_UNITS_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_USAGE_UNITS_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_UTILITY_ACCOUNT_ID_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_UTILITY_ACCOUNT_ID_DESC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_UTILITY_METER_ID_ASC', 'UTILITY_METER_STATEMENTS_STDDEV_SAMPLE_UTILITY_METER_ID_DESC', 'UTILITY_METER_STATEMENTS_SUM_ACCOUNT_LABEL_ASC', 'UTILITY_METER_STATEMENTS_SUM_ACCOUNT_LABEL_DESC', 'UTILITY_METER_STATEMENTS_SUM_ACCOUNT_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENTS_SUM_ACCOUNT_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENTS_SUM_BILL_ARRIVAL_DATE_ASC', 'UTILITY_METER_STATEMENTS_SUM_BILL_ARRIVAL_DATE_DESC', 'UTILITY_METER_STATEMENTS_SUM_CURRENCY_CODE_ASC', 'UTILITY_METER_STATEMENTS_SUM_CURRENCY_CODE_DESC', 'UTILITY_METER_STATEMENTS_SUM_DAYS_IN_BILL_ASC', 'UTILITY_METER_STATEMENTS_SUM_DAYS_IN_BILL_DESC', 'UTILITY_METER_STATEMENTS_SUM_DEMAND_UNITS_ASC', 'UTILITY_METER_STATEMENTS_SUM_DEMAND_UNITS_DESC', 'UTILITY_METER_STATEMENTS_SUM_END_DATE_ASC', 'UTILITY_METER_STATEMENTS_SUM_END_DATE_DESC', 'UTILITY_METER_STATEMENTS_SUM_EXCLUDE_USAGE_ASC', 'UTILITY_METER_STATEMENTS_SUM_EXCLUDE_USAGE_DESC', 'UTILITY_METER_STATEMENTS_SUM_FACILITY_ID_ASC', 'UTILITY_METER_STATEMENTS_SUM_FACILITY_ID_DESC', 'UTILITY_METER_STATEMENTS_SUM_IS_VALIDATED_ASC', 'UTILITY_METER_STATEMENTS_SUM_IS_VALIDATED_DESC', 'UTILITY_METER_STATEMENTS_SUM_METER_END_DATE_SET_ASC', 'UTILITY_METER_STATEMENTS_SUM_METER_END_DATE_SET_DESC', 'UTILITY_METER_STATEMENTS_SUM_METER_LABEL_ASC', 'UTILITY_METER_STATEMENTS_SUM_METER_LABEL_DESC', 'UTILITY_METER_STATEMENTS_SUM_METER_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENTS_SUM_METER_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENTS_SUM_PROVIDER_ASC', 'UTILITY_METER_STATEMENTS_SUM_PROVIDER_DESC', 'UTILITY_METER_STATEMENTS_SUM_SERVICE_TYPE_ASC', 'UTILITY_METER_STATEMENTS_SUM_SERVICE_TYPE_DESC', 'UTILITY_METER_STATEMENTS_SUM_START_DATE_ASC', 'UTILITY_METER_STATEMENTS_SUM_START_DATE_DESC', 'UTILITY_METER_STATEMENTS_SUM_STATEMENT_MONTH_ASC', 'UTILITY_METER_STATEMENTS_SUM_STATEMENT_MONTH_DESC', 'UTILITY_METER_STATEMENTS_SUM_STATEMENT_YEAR_ASC', 'UTILITY_METER_STATEMENTS_SUM_STATEMENT_YEAR_DESC', 'UTILITY_METER_STATEMENTS_SUM_USAGE_UNITS_ASC', 'UTILITY_METER_STATEMENTS_SUM_USAGE_UNITS_DESC', 'UTILITY_METER_STATEMENTS_SUM_UTILITY_ACCOUNT_ID_ASC', 'UTILITY_METER_STATEMENTS_SUM_UTILITY_ACCOUNT_ID_DESC', 'UTILITY_METER_STATEMENTS_SUM_UTILITY_METER_ID_ASC', 'UTILITY_METER_STATEMENTS_SUM_UTILITY_METER_ID_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_ACCOUNT_LABEL_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_ACCOUNT_LABEL_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_ACCOUNT_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_ACCOUNT_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_BILL_ARRIVAL_DATE_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_BILL_ARRIVAL_DATE_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_CURRENCY_CODE_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_CURRENCY_CODE_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_DAYS_IN_BILL_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_DAYS_IN_BILL_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_DEMAND_UNITS_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_DEMAND_UNITS_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_END_DATE_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_END_DATE_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_EXCLUDE_USAGE_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_EXCLUDE_USAGE_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_FACILITY_ID_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_FACILITY_ID_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_IS_VALIDATED_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_IS_VALIDATED_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_METER_END_DATE_SET_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_METER_END_DATE_SET_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_METER_LABEL_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_METER_LABEL_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_METER_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_METER_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_PROVIDER_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_PROVIDER_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_SERVICE_TYPE_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_SERVICE_TYPE_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_START_DATE_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_START_DATE_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_STATEMENT_MONTH_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_STATEMENT_MONTH_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_STATEMENT_YEAR_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_STATEMENT_YEAR_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_USAGE_UNITS_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_USAGE_UNITS_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_UTILITY_ACCOUNT_ID_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_UTILITY_ACCOUNT_ID_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_UTILITY_METER_ID_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_POPULATION_UTILITY_METER_ID_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_ACCOUNT_LABEL_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_ACCOUNT_LABEL_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_ACCOUNT_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_ACCOUNT_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_BILL_ARRIVAL_DATE_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_BILL_ARRIVAL_DATE_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_CURRENCY_CODE_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_CURRENCY_CODE_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_DAYS_IN_BILL_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_DAYS_IN_BILL_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_DEMAND_UNITS_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_DEMAND_UNITS_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_END_DATE_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_END_DATE_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_EXCLUDE_USAGE_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_EXCLUDE_USAGE_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_FACILITY_ID_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_FACILITY_ID_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_IS_VALIDATED_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_IS_VALIDATED_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_METER_END_DATE_SET_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_METER_END_DATE_SET_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_METER_LABEL_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_METER_LABEL_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_METER_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_METER_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_PROVIDER_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_PROVIDER_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_SERVICE_TYPE_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_SERVICE_TYPE_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_START_DATE_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_START_DATE_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_STATEMENT_MONTH_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_STATEMENT_MONTH_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_STATEMENT_YEAR_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_STATEMENT_YEAR_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_USAGE_UNITS_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_USAGE_UNITS_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_UTILITY_ACCOUNT_ID_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_UTILITY_ACCOUNT_ID_DESC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_UTILITY_METER_ID_ASC', 'UTILITY_METER_STATEMENTS_VARIANCE_SAMPLE_UTILITY_METER_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_ACCOUNT_LABEL_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_ACCOUNT_LABEL_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_ACCOUNT_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_ACCOUNT_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_BILL_ARRIVAL_DATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_BILL_ARRIVAL_DATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_BILL_COST_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_BILL_COST_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_BILL_DEMAND_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_BILL_DEMAND_COST_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_BILL_DEMAND_COST_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_BILL_DEMAND_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_BILL_USAGE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_BILL_USAGE_COST_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_BILL_USAGE_COST_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_BILL_USAGE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_BLENDED_RATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_BLENDED_RATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_CREDITS_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_CREDITS_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_CURRENCY_CODE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_CURRENCY_CODE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_DAYS_IN_BILL_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_DAYS_IN_BILL_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_DEMAND_UNITS_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_DEMAND_UNITS_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_END_DATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_END_DATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_FACILITY_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_FACILITY_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_FEES_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_FEES_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_IS_VALIDATED_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_IS_VALIDATED_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_LOAD_FACTOR_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_LOAD_FACTOR_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_METER_END_DATE_SET_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_METER_END_DATE_SET_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_METER_LABEL_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_METER_LABEL_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_METER_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_METER_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_NET_BILL_USAGE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_NET_BILL_USAGE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_PERCENT_CHANGE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_PERCENT_CHANGE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_PROVIDER_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_PROVIDER_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_SERVICE_TYPE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_SERVICE_TYPE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_START_DATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_START_DATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_STATEMENT_MONTH_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_STATEMENT_MONTH_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_STATEMENT_YEAR_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_STATEMENT_YEAR_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_TAXES_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_TAXES_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_USAGE_UNITS_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_USAGE_UNITS_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_UTILITY_ACCOUNT_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_UTILITY_ACCOUNT_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_UTILITY_METER_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_AVERAGE_UTILITY_METER_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_COUNT_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_COUNT_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_ACCOUNT_LABEL_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_ACCOUNT_LABEL_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_ACCOUNT_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_ACCOUNT_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_BILL_ARRIVAL_DATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_BILL_ARRIVAL_DATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_BILL_COST_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_BILL_COST_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_BILL_DEMAND_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_BILL_DEMAND_COST_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_BILL_DEMAND_COST_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_BILL_DEMAND_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_BILL_USAGE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_BILL_USAGE_COST_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_BILL_USAGE_COST_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_BILL_USAGE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_BLENDED_RATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_BLENDED_RATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_ACCOUNT_LABEL_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_ACCOUNT_LABEL_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_ACCOUNT_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_ACCOUNT_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_BILL_ARRIVAL_DATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_BILL_ARRIVAL_DATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_BILL_COST_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_BILL_COST_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_BILL_DEMAND_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_BILL_DEMAND_COST_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_BILL_DEMAND_COST_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_BILL_DEMAND_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_BILL_USAGE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_BILL_USAGE_COST_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_BILL_USAGE_COST_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_BILL_USAGE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_BLENDED_RATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_BLENDED_RATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_CREDITS_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_CREDITS_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_CURRENCY_CODE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_CURRENCY_CODE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_DAYS_IN_BILL_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_DAYS_IN_BILL_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_DEMAND_UNITS_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_DEMAND_UNITS_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_END_DATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_END_DATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_FACILITY_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_FACILITY_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_FEES_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_FEES_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_IS_VALIDATED_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_IS_VALIDATED_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_LOAD_FACTOR_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_LOAD_FACTOR_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_METER_END_DATE_SET_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_METER_END_DATE_SET_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_METER_LABEL_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_METER_LABEL_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_METER_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_METER_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_NET_BILL_USAGE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_NET_BILL_USAGE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_PERCENT_CHANGE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_PERCENT_CHANGE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_PROVIDER_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_PROVIDER_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_SERVICE_TYPE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_SERVICE_TYPE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_START_DATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_START_DATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_STATEMENT_MONTH_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_STATEMENT_MONTH_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_STATEMENT_YEAR_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_STATEMENT_YEAR_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_TAXES_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_TAXES_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_USAGE_UNITS_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_USAGE_UNITS_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_UTILITY_ACCOUNT_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_UTILITY_ACCOUNT_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_UTILITY_METER_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_COUNT_UTILITY_METER_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_CREDITS_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_CREDITS_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_CURRENCY_CODE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_CURRENCY_CODE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_DAYS_IN_BILL_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_DAYS_IN_BILL_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_DEMAND_UNITS_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_DEMAND_UNITS_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_END_DATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_END_DATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_FACILITY_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_FACILITY_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_FEES_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_FEES_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_IS_VALIDATED_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_IS_VALIDATED_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_LOAD_FACTOR_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_LOAD_FACTOR_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_METER_END_DATE_SET_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_METER_END_DATE_SET_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_METER_LABEL_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_METER_LABEL_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_METER_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_METER_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_NET_BILL_USAGE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_NET_BILL_USAGE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_PERCENT_CHANGE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_PERCENT_CHANGE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_PROVIDER_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_PROVIDER_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_SERVICE_TYPE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_SERVICE_TYPE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_START_DATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_START_DATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_STATEMENT_MONTH_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_STATEMENT_MONTH_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_STATEMENT_YEAR_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_STATEMENT_YEAR_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_TAXES_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_TAXES_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_USAGE_UNITS_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_USAGE_UNITS_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_UTILITY_ACCOUNT_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_UTILITY_ACCOUNT_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_UTILITY_METER_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_DISTINCT_UTILITY_METER_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_ACCOUNT_LABEL_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_ACCOUNT_LABEL_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_ACCOUNT_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_ACCOUNT_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_BILL_ARRIVAL_DATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_BILL_ARRIVAL_DATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_BILL_COST_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_BILL_COST_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_BILL_DEMAND_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_BILL_DEMAND_COST_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_BILL_DEMAND_COST_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_BILL_DEMAND_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_BILL_USAGE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_BILL_USAGE_COST_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_BILL_USAGE_COST_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_BILL_USAGE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_BLENDED_RATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_BLENDED_RATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_CREDITS_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_CREDITS_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_CURRENCY_CODE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_CURRENCY_CODE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_DAYS_IN_BILL_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_DAYS_IN_BILL_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_DEMAND_UNITS_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_DEMAND_UNITS_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_END_DATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_END_DATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_FACILITY_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_FACILITY_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_FEES_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_FEES_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_IS_VALIDATED_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_IS_VALIDATED_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_LOAD_FACTOR_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_LOAD_FACTOR_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_METER_END_DATE_SET_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_METER_END_DATE_SET_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_METER_LABEL_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_METER_LABEL_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_METER_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_METER_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_NET_BILL_USAGE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_NET_BILL_USAGE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_PERCENT_CHANGE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_PERCENT_CHANGE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_PROVIDER_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_PROVIDER_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_SERVICE_TYPE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_SERVICE_TYPE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_START_DATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_START_DATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_STATEMENT_MONTH_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_STATEMENT_MONTH_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_STATEMENT_YEAR_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_STATEMENT_YEAR_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_TAXES_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_TAXES_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_USAGE_UNITS_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_USAGE_UNITS_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_UTILITY_ACCOUNT_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_UTILITY_ACCOUNT_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_UTILITY_METER_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MAX_UTILITY_METER_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_ACCOUNT_LABEL_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_ACCOUNT_LABEL_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_ACCOUNT_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_ACCOUNT_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_BILL_ARRIVAL_DATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_BILL_ARRIVAL_DATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_BILL_COST_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_BILL_COST_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_BILL_DEMAND_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_BILL_DEMAND_COST_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_BILL_DEMAND_COST_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_BILL_DEMAND_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_BILL_USAGE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_BILL_USAGE_COST_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_BILL_USAGE_COST_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_BILL_USAGE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_BLENDED_RATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_BLENDED_RATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_CREDITS_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_CREDITS_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_CURRENCY_CODE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_CURRENCY_CODE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_DAYS_IN_BILL_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_DAYS_IN_BILL_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_DEMAND_UNITS_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_DEMAND_UNITS_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_END_DATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_END_DATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_FACILITY_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_FACILITY_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_FEES_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_FEES_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_IS_VALIDATED_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_IS_VALIDATED_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_LOAD_FACTOR_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_LOAD_FACTOR_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_METER_END_DATE_SET_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_METER_END_DATE_SET_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_METER_LABEL_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_METER_LABEL_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_METER_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_METER_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_NET_BILL_USAGE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_NET_BILL_USAGE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_PERCENT_CHANGE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_PERCENT_CHANGE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_PROVIDER_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_PROVIDER_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_SERVICE_TYPE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_SERVICE_TYPE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_START_DATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_START_DATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_STATEMENT_MONTH_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_STATEMENT_MONTH_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_STATEMENT_YEAR_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_STATEMENT_YEAR_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_TAXES_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_TAXES_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_USAGE_UNITS_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_USAGE_UNITS_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_UTILITY_ACCOUNT_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_UTILITY_ACCOUNT_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_UTILITY_METER_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_MIN_UTILITY_METER_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_ACCOUNT_LABEL_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_ACCOUNT_LABEL_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_ACCOUNT_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_ACCOUNT_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_BILL_ARRIVAL_DATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_BILL_ARRIVAL_DATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_BILL_COST_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_BILL_COST_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_BILL_DEMAND_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_BILL_DEMAND_COST_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_BILL_DEMAND_COST_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_BILL_DEMAND_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_BILL_USAGE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_BILL_USAGE_COST_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_BILL_USAGE_COST_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_BILL_USAGE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_BLENDED_RATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_BLENDED_RATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_CREDITS_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_CREDITS_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_CURRENCY_CODE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_CURRENCY_CODE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_DAYS_IN_BILL_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_DAYS_IN_BILL_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_DEMAND_UNITS_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_DEMAND_UNITS_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_END_DATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_END_DATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_FACILITY_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_FACILITY_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_FEES_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_FEES_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_IS_VALIDATED_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_IS_VALIDATED_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_LOAD_FACTOR_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_LOAD_FACTOR_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_METER_END_DATE_SET_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_METER_END_DATE_SET_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_METER_LABEL_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_METER_LABEL_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_METER_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_METER_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_NET_BILL_USAGE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_NET_BILL_USAGE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_PERCENT_CHANGE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_PERCENT_CHANGE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_PROVIDER_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_PROVIDER_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_SERVICE_TYPE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_SERVICE_TYPE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_START_DATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_START_DATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_STATEMENT_MONTH_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_STATEMENT_MONTH_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_STATEMENT_YEAR_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_STATEMENT_YEAR_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_TAXES_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_TAXES_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_USAGE_UNITS_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_USAGE_UNITS_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_UTILITY_ACCOUNT_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_UTILITY_ACCOUNT_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_UTILITY_METER_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_POPULATION_UTILITY_METER_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_ACCOUNT_LABEL_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_ACCOUNT_LABEL_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_ACCOUNT_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_ACCOUNT_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_BILL_ARRIVAL_DATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_BILL_ARRIVAL_DATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_BILL_COST_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_BILL_COST_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_BILL_DEMAND_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_BILL_DEMAND_COST_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_BILL_DEMAND_COST_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_BILL_DEMAND_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_BILL_USAGE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_BILL_USAGE_COST_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_BILL_USAGE_COST_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_BILL_USAGE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_BLENDED_RATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_BLENDED_RATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_CREDITS_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_CREDITS_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_CURRENCY_CODE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_CURRENCY_CODE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_DAYS_IN_BILL_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_DAYS_IN_BILL_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_DEMAND_UNITS_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_DEMAND_UNITS_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_END_DATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_END_DATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_FACILITY_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_FACILITY_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_FEES_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_FEES_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_IS_VALIDATED_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_IS_VALIDATED_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_LOAD_FACTOR_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_LOAD_FACTOR_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_METER_END_DATE_SET_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_METER_END_DATE_SET_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_METER_LABEL_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_METER_LABEL_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_METER_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_METER_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_NET_BILL_USAGE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_NET_BILL_USAGE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_PERCENT_CHANGE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_PERCENT_CHANGE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_PROVIDER_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_PROVIDER_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_SERVICE_TYPE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_SERVICE_TYPE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_START_DATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_START_DATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_STATEMENT_MONTH_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_STATEMENT_MONTH_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_STATEMENT_YEAR_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_STATEMENT_YEAR_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_TAXES_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_TAXES_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_USAGE_UNITS_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_USAGE_UNITS_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_UTILITY_ACCOUNT_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_UTILITY_ACCOUNT_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_UTILITY_METER_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_STDDEV_SAMPLE_UTILITY_METER_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_ACCOUNT_LABEL_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_ACCOUNT_LABEL_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_ACCOUNT_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_ACCOUNT_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_BILL_ARRIVAL_DATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_BILL_ARRIVAL_DATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_BILL_COST_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_BILL_COST_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_BILL_DEMAND_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_BILL_DEMAND_COST_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_BILL_DEMAND_COST_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_BILL_DEMAND_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_BILL_USAGE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_BILL_USAGE_COST_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_BILL_USAGE_COST_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_BILL_USAGE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_BLENDED_RATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_BLENDED_RATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_CREDITS_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_CREDITS_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_CURRENCY_CODE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_CURRENCY_CODE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_DAYS_IN_BILL_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_DAYS_IN_BILL_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_DEMAND_UNITS_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_DEMAND_UNITS_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_END_DATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_END_DATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_FACILITY_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_FACILITY_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_FEES_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_FEES_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_IS_VALIDATED_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_IS_VALIDATED_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_LOAD_FACTOR_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_LOAD_FACTOR_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_METER_END_DATE_SET_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_METER_END_DATE_SET_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_METER_LABEL_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_METER_LABEL_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_METER_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_METER_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_NET_BILL_USAGE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_NET_BILL_USAGE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_PERCENT_CHANGE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_PERCENT_CHANGE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_PROVIDER_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_PROVIDER_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_SERVICE_TYPE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_SERVICE_TYPE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_START_DATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_START_DATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_STATEMENT_MONTH_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_STATEMENT_MONTH_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_STATEMENT_YEAR_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_STATEMENT_YEAR_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_TAXES_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_TAXES_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_USAGE_UNITS_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_USAGE_UNITS_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_UTILITY_ACCOUNT_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_UTILITY_ACCOUNT_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_UTILITY_METER_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_SUM_UTILITY_METER_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_ACCOUNT_LABEL_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_ACCOUNT_LABEL_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_ACCOUNT_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_ACCOUNT_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_BILL_ARRIVAL_DATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_BILL_ARRIVAL_DATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_BILL_COST_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_BILL_COST_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_BILL_DEMAND_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_BILL_DEMAND_COST_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_BILL_DEMAND_COST_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_BILL_DEMAND_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_BILL_USAGE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_BILL_USAGE_COST_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_BILL_USAGE_COST_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_BILL_USAGE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_BLENDED_RATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_BLENDED_RATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_CREDITS_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_CREDITS_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_CURRENCY_CODE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_CURRENCY_CODE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_DAYS_IN_BILL_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_DAYS_IN_BILL_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_DEMAND_UNITS_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_DEMAND_UNITS_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_END_DATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_END_DATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_FACILITY_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_FACILITY_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_FEES_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_FEES_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_IS_VALIDATED_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_IS_VALIDATED_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_LOAD_FACTOR_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_LOAD_FACTOR_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_METER_END_DATE_SET_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_METER_END_DATE_SET_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_METER_LABEL_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_METER_LABEL_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_METER_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_METER_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_NET_BILL_USAGE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_NET_BILL_USAGE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_PERCENT_CHANGE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_PERCENT_CHANGE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_PROVIDER_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_PROVIDER_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_SERVICE_TYPE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_SERVICE_TYPE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_START_DATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_START_DATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_STATEMENT_MONTH_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_STATEMENT_MONTH_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_STATEMENT_YEAR_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_STATEMENT_YEAR_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_TAXES_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_TAXES_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_USAGE_UNITS_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_USAGE_UNITS_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_UTILITY_ACCOUNT_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_UTILITY_ACCOUNT_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_UTILITY_METER_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_POPULATION_UTILITY_METER_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_ACCOUNT_LABEL_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_ACCOUNT_LABEL_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_ACCOUNT_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_ACCOUNT_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_BILL_ARRIVAL_DATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_BILL_ARRIVAL_DATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_BILL_COST_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_BILL_COST_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_BILL_DEMAND_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_BILL_DEMAND_COST_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_BILL_DEMAND_COST_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_BILL_DEMAND_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_BILL_USAGE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_BILL_USAGE_COST_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_BILL_USAGE_COST_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_BILL_USAGE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_BLENDED_RATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_BLENDED_RATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_CREDITS_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_CREDITS_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_CURRENCY_CODE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_CURRENCY_CODE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_DAYS_IN_BILL_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_DAYS_IN_BILL_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_DEMAND_UNITS_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_DEMAND_UNITS_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_END_DATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_END_DATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_FACILITY_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_FACILITY_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_FEES_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_FEES_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_IS_VALIDATED_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_IS_VALIDATED_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_LOAD_FACTOR_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_LOAD_FACTOR_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_METER_END_DATE_SET_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_METER_END_DATE_SET_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_METER_LABEL_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_METER_LABEL_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_METER_STATEMENT_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_METER_STATEMENT_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_NET_BILL_USAGE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_NET_BILL_USAGE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_PERCENT_CHANGE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_PERCENT_CHANGE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_PROVIDER_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_PROVIDER_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_SERVICE_TYPE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_SERVICE_TYPE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_START_DATE_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_START_DATE_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_STATEMENT_MONTH_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_STATEMENT_MONTH_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_STATEMENT_YEAR_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_STATEMENT_YEAR_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_TAXES_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_TAXES_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_USAGE_UNITS_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_USAGE_UNITS_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_UTILITY_ACCOUNT_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_UTILITY_ACCOUNT_ID_DESC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_UTILITY_METER_ID_ASC', 'UTILITY_METER_STATEMENT_ROLLUPS_VARIANCE_SAMPLE_UTILITY_METER_ID_DESC')


class UtilityProvidersOrderBy(sgqlc.types.Enum):
    __schema__ = nionic_schema
    __choices__ = ('CREATED_AT_ASC', 'CREATED_AT_DESC', 'ID_ASC', 'ID_DESC', 'NAME_ASC', 'NAME_DESC', 'NATURAL', 'PRIMARY_KEY_ASC', 'PRIMARY_KEY_DESC', 'UPDATED_AT_ASC', 'UPDATED_AT_DESC')


class VendorUsersOrderBy(sgqlc.types.Enum):
    __schema__ = nionic_schema
    __choices__ = ('COMPANY_ASC', 'COMPANY_DESC', 'CREATED_AT_ASC', 'CREATED_AT_DESC', 'EMAIL_ASC', 'EMAIL_DESC', 'FIRST_NAME_ASC', 'FIRST_NAME_DESC', 'ID_ASC', 'ID_DESC', 'LAST_NAME_ASC', 'LAST_NAME_DESC', 'NATURAL', 'PRIMARY_KEY_ASC', 'PRIMARY_KEY_DESC', 'UPDATED_AT_ASC', 'UPDATED_AT_DESC')


class VirtualPointIntervalsOrderBy(sgqlc.types.Enum):
    __schema__ = nionic_schema
    __choices__ = ('CHILD_ID_ASC', 'CHILD_ID_DESC', 'END_TIME_ASC', 'END_TIME_DESC', 'NATURAL', 'PARENT_ID_ASC', 'PARENT_ID_DESC', 'PRIMARY_KEY_ASC', 'PRIMARY_KEY_DESC', 'START_TIME_ASC', 'START_TIME_DESC')



########################################################################
# Input Objects
########################################################################
class AccessTokenTypeFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('is_null', 'equal_to', 'not_equal_to', 'distinct_from', 'not_distinct_from', 'in_', 'not_in', 'less_than', 'less_than_or_equal_to', 'greater_than', 'greater_than_or_equal_to')
    is_null = sgqlc.types.Field(Boolean, graphql_name='isNull')
    equal_to = sgqlc.types.Field(AccessTokenType, graphql_name='equalTo')
    not_equal_to = sgqlc.types.Field(AccessTokenType, graphql_name='notEqualTo')
    distinct_from = sgqlc.types.Field(AccessTokenType, graphql_name='distinctFrom')
    not_distinct_from = sgqlc.types.Field(AccessTokenType, graphql_name='notDistinctFrom')
    in_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(AccessTokenType)), graphql_name='in')
    not_in = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(AccessTokenType)), graphql_name='notIn')
    less_than = sgqlc.types.Field(AccessTokenType, graphql_name='lessThan')
    less_than_or_equal_to = sgqlc.types.Field(AccessTokenType, graphql_name='lessThanOrEqualTo')
    greater_than = sgqlc.types.Field(AccessTokenType, graphql_name='greaterThan')
    greater_than_or_equal_to = sgqlc.types.Field(AccessTokenType, graphql_name='greaterThanOrEqualTo')


class AccountChargeCondition(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'account_statement_id', 'category', 'interval_start', 'interval_end', 'statement_date', 'normalized_value', 'override_at', 'line_number', 'created_at', 'updated_at', 'deleted_at', 'override_statement_year', 'override_statement_month')
    id = sgqlc.types.Field(Int, graphql_name='id')
    account_statement_id = sgqlc.types.Field(Int, graphql_name='accountStatementId')
    category = sgqlc.types.Field(UtilityAccountChargeCategory, graphql_name='category')
    interval_start = sgqlc.types.Field(Date, graphql_name='intervalStart')
    interval_end = sgqlc.types.Field(Date, graphql_name='intervalEnd')
    statement_date = sgqlc.types.Field(Date, graphql_name='statementDate')
    normalized_value = sgqlc.types.Field(Float, graphql_name='normalizedValue')
    override_at = sgqlc.types.Field(Datetime, graphql_name='overrideAt')
    line_number = sgqlc.types.Field(Int, graphql_name='lineNumber')
    created_at = sgqlc.types.Field(Datetime, graphql_name='createdAt')
    updated_at = sgqlc.types.Field(Datetime, graphql_name='updatedAt')
    deleted_at = sgqlc.types.Field(Datetime, graphql_name='deletedAt')
    override_statement_year = sgqlc.types.Field(Int, graphql_name='overrideStatementYear')
    override_statement_month = sgqlc.types.Field(Int, graphql_name='overrideStatementMonth')


class AccountChargeFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('label', 'value', 'id', 'account_statement_id', 'category', 'interval_start', 'interval_end', 'statement_date', 'normalized_value', 'override_at', 'line_number', 'created_at', 'updated_at', 'deleted_at', 'override_statement_year', 'override_statement_month', 'statement_month', 'statement_year', 'and_', 'or_', 'not_')
    label = sgqlc.types.Field('StringFilter', graphql_name='label')
    value = sgqlc.types.Field('FloatFilter', graphql_name='value')
    id = sgqlc.types.Field('IntFilter', graphql_name='id')
    account_statement_id = sgqlc.types.Field('IntFilter', graphql_name='accountStatementId')
    category = sgqlc.types.Field('UtilityAccountChargeCategoryFilter', graphql_name='category')
    interval_start = sgqlc.types.Field('DateFilter', graphql_name='intervalStart')
    interval_end = sgqlc.types.Field('DateFilter', graphql_name='intervalEnd')
    statement_date = sgqlc.types.Field('DateFilter', graphql_name='statementDate')
    normalized_value = sgqlc.types.Field('FloatFilter', graphql_name='normalizedValue')
    override_at = sgqlc.types.Field('DatetimeFilter', graphql_name='overrideAt')
    line_number = sgqlc.types.Field('IntFilter', graphql_name='lineNumber')
    created_at = sgqlc.types.Field('DatetimeFilter', graphql_name='createdAt')
    updated_at = sgqlc.types.Field('DatetimeFilter', graphql_name='updatedAt')
    deleted_at = sgqlc.types.Field('DatetimeFilter', graphql_name='deletedAt')
    override_statement_year = sgqlc.types.Field('IntFilter', graphql_name='overrideStatementYear')
    override_statement_month = sgqlc.types.Field('IntFilter', graphql_name='overrideStatementMonth')
    statement_month = sgqlc.types.Field('IntFilter', graphql_name='statementMonth')
    statement_year = sgqlc.types.Field('IntFilter', graphql_name='statementYear')
    and_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('AccountChargeFilter')), graphql_name='and')
    or_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('AccountChargeFilter')), graphql_name='or')
    not_ = sgqlc.types.Field('AccountChargeFilter', graphql_name='not')


class AccountChargeInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'account_statement_id', 'category', 'interval_start', 'interval_end', 'statement_date', 'label', 'value', 'line_number', 'account_statement')
    id = sgqlc.types.Field(Int, graphql_name='id')
    account_statement_id = sgqlc.types.Field(Int, graphql_name='accountStatementId')
    category = sgqlc.types.Field(sgqlc.types.non_null(UtilityAccountChargeCategory), graphql_name='category')
    interval_start = sgqlc.types.Field(sgqlc.types.non_null(Date), graphql_name='intervalStart')
    interval_end = sgqlc.types.Field(sgqlc.types.non_null(Date), graphql_name='intervalEnd')
    statement_date = sgqlc.types.Field(sgqlc.types.non_null(Date), graphql_name='statementDate')
    label = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='label')
    value = sgqlc.types.Field(sgqlc.types.non_null(Float), graphql_name='value')
    line_number = sgqlc.types.Field(Int, graphql_name='lineNumber')
    account_statement = sgqlc.types.Field('AccountStatementInput', graphql_name='accountStatement')


class AccountChargePatch(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('statement_date', 'label', 'value', 'override_statement_year', 'override_statement_month')
    statement_date = sgqlc.types.Field(Date, graphql_name='statementDate')
    label = sgqlc.types.Field(String, graphql_name='label')
    value = sgqlc.types.Field(Float, graphql_name='value')
    override_statement_year = sgqlc.types.Field(Int, graphql_name='overrideStatementYear')
    override_statement_month = sgqlc.types.Field(Int, graphql_name='overrideStatementMonth')


class AccountMissingStatementFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('utility_account_id', 'statement_date', 'statement_year', 'statement_month', 'metadata', 'and_', 'or_', 'not_')
    utility_account_id = sgqlc.types.Field('IntFilter', graphql_name='utilityAccountId')
    statement_date = sgqlc.types.Field('DateFilter', graphql_name='statementDate')
    statement_year = sgqlc.types.Field('IntFilter', graphql_name='statementYear')
    statement_month = sgqlc.types.Field('IntFilter', graphql_name='statementMonth')
    metadata = sgqlc.types.Field('JSONListFilter', graphql_name='metadata')
    and_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('AccountMissingStatementFilter')), graphql_name='and')
    or_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('AccountMissingStatementFilter')), graphql_name='or')
    not_ = sgqlc.types.Field('AccountMissingStatementFilter', graphql_name='not')


class AccountStatementCondition(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'integration', 'integration_key', 'utility_account_id', 'statement_year', 'statement_month', 'normalized_currency_code', 'override_at', 'is_validated', 'metadata', 'created_at', 'updated_at', 'interval_start', 'interval_end')
    id = sgqlc.types.Field(Int, graphql_name='id')
    integration = sgqlc.types.Field(UtilityIntegration, graphql_name='integration')
    integration_key = sgqlc.types.Field(String, graphql_name='integrationKey')
    utility_account_id = sgqlc.types.Field(Int, graphql_name='utilityAccountId')
    statement_year = sgqlc.types.Field(Int, graphql_name='statementYear')
    statement_month = sgqlc.types.Field(Int, graphql_name='statementMonth')
    normalized_currency_code = sgqlc.types.Field(String, graphql_name='normalizedCurrencyCode')
    override_at = sgqlc.types.Field(Datetime, graphql_name='overrideAt')
    is_validated = sgqlc.types.Field(Boolean, graphql_name='isValidated')
    metadata = sgqlc.types.Field(JSON, graphql_name='metadata')
    created_at = sgqlc.types.Field(Datetime, graphql_name='createdAt')
    updated_at = sgqlc.types.Field(Datetime, graphql_name='updatedAt')
    interval_start = sgqlc.types.Field(Date, graphql_name='intervalStart')
    interval_end = sgqlc.types.Field(Date, graphql_name='intervalEnd')


class AccountStatementFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('currency_code', 'id', 'integration', 'integration_key', 'utility_account_id', 'statement_year', 'statement_month', 'normalized_currency_code', 'override_at', 'is_validated', 'metadata', 'created_at', 'updated_at', 'interval_start', 'interval_end', 'deleted_at', 'normalized_total_charges', 'total_charges', 'and_', 'or_', 'not_')
    currency_code = sgqlc.types.Field('StringFilter', graphql_name='currencyCode')
    id = sgqlc.types.Field('IntFilter', graphql_name='id')
    integration = sgqlc.types.Field('UtilityIntegrationFilter', graphql_name='integration')
    integration_key = sgqlc.types.Field('StringFilter', graphql_name='integrationKey')
    utility_account_id = sgqlc.types.Field('IntFilter', graphql_name='utilityAccountId')
    statement_year = sgqlc.types.Field('IntFilter', graphql_name='statementYear')
    statement_month = sgqlc.types.Field('IntFilter', graphql_name='statementMonth')
    normalized_currency_code = sgqlc.types.Field('StringFilter', graphql_name='normalizedCurrencyCode')
    override_at = sgqlc.types.Field('DatetimeFilter', graphql_name='overrideAt')
    is_validated = sgqlc.types.Field('BooleanFilter', graphql_name='isValidated')
    metadata = sgqlc.types.Field('JSONFilter', graphql_name='metadata')
    created_at = sgqlc.types.Field('DatetimeFilter', graphql_name='createdAt')
    updated_at = sgqlc.types.Field('DatetimeFilter', graphql_name='updatedAt')
    interval_start = sgqlc.types.Field('DateFilter', graphql_name='intervalStart')
    interval_end = sgqlc.types.Field('DateFilter', graphql_name='intervalEnd')
    deleted_at = sgqlc.types.Field('DatetimeFilter', graphql_name='deletedAt')
    normalized_total_charges = sgqlc.types.Field('FloatFilter', graphql_name='normalizedTotalCharges')
    total_charges = sgqlc.types.Field('FloatFilter', graphql_name='totalCharges')
    and_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('AccountStatementFilter')), graphql_name='and')
    or_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('AccountStatementFilter')), graphql_name='or')
    not_ = sgqlc.types.Field('AccountStatementFilter', graphql_name='not')


class AccountStatementHistoryCondition(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('account_statement_id', 'description', 'created_at')
    account_statement_id = sgqlc.types.Field(Int, graphql_name='accountStatementId')
    description = sgqlc.types.Field(String, graphql_name='description')
    created_at = sgqlc.types.Field(Datetime, graphql_name='createdAt')


class AccountStatementHistoryFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('account_statement_id', 'description', 'created_at', 'and_', 'or_', 'not_')
    account_statement_id = sgqlc.types.Field('IntFilter', graphql_name='accountStatementId')
    description = sgqlc.types.Field('StringFilter', graphql_name='description')
    created_at = sgqlc.types.Field('DatetimeFilter', graphql_name='createdAt')
    and_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('AccountStatementHistoryFilter')), graphql_name='and')
    or_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('AccountStatementHistoryFilter')), graphql_name='or')
    not_ = sgqlc.types.Field('AccountStatementHistoryFilter', graphql_name='not')


class AccountStatementHistoryInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('account_statement_id', 'description', 'account_statement')
    account_statement_id = sgqlc.types.Field(Int, graphql_name='accountStatementId')
    description = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='description')
    account_statement = sgqlc.types.Field('AccountStatementInput', graphql_name='accountStatement')


class AccountStatementInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'integration', 'integration_key', 'utility_account_id', 'statement_year', 'statement_month', 'currency_code', 'is_validated', 'metadata', 'interval_start', 'interval_end', 'utility_account')
    id = sgqlc.types.Field(Int, graphql_name='id')
    integration = sgqlc.types.Field(sgqlc.types.non_null(UtilityIntegration), graphql_name='integration')
    integration_key = sgqlc.types.Field(String, graphql_name='integrationKey')
    utility_account_id = sgqlc.types.Field(Int, graphql_name='utilityAccountId')
    statement_year = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='statementYear')
    statement_month = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='statementMonth')
    currency_code = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='currencyCode')
    is_validated = sgqlc.types.Field(Boolean, graphql_name='isValidated')
    metadata = sgqlc.types.Field(JSON, graphql_name='metadata')
    interval_start = sgqlc.types.Field(sgqlc.types.non_null(Date), graphql_name='intervalStart')
    interval_end = sgqlc.types.Field(sgqlc.types.non_null(Date), graphql_name='intervalEnd')
    utility_account = sgqlc.types.Field('UtilityAccountInput', graphql_name='utilityAccount')


class AccountStatementPatch(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('statement_year', 'statement_month', 'currency_code', 'is_validated', 'metadata')
    statement_year = sgqlc.types.Field(Int, graphql_name='statementYear')
    statement_month = sgqlc.types.Field(Int, graphql_name='statementMonth')
    currency_code = sgqlc.types.Field(String, graphql_name='currencyCode')
    is_validated = sgqlc.types.Field(Boolean, graphql_name='isValidated')
    metadata = sgqlc.types.Field(JSON, graphql_name='metadata')


class AccountStatementPdfCondition(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'account_statement_id', 'file_key', 'path', 'created_at', 'updated_at', 'deleted_at')
    id = sgqlc.types.Field(Int, graphql_name='id')
    account_statement_id = sgqlc.types.Field(Int, graphql_name='accountStatementId')
    file_key = sgqlc.types.Field(String, graphql_name='fileKey')
    path = sgqlc.types.Field(String, graphql_name='path')
    created_at = sgqlc.types.Field(Datetime, graphql_name='createdAt')
    updated_at = sgqlc.types.Field(Datetime, graphql_name='updatedAt')
    deleted_at = sgqlc.types.Field(Datetime, graphql_name='deletedAt')


class AccountStatementPdfFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'account_statement_id', 'file_key', 'path', 'created_at', 'updated_at', 'deleted_at', 'and_', 'or_', 'not_')
    id = sgqlc.types.Field('IntFilter', graphql_name='id')
    account_statement_id = sgqlc.types.Field('IntFilter', graphql_name='accountStatementId')
    file_key = sgqlc.types.Field('StringFilter', graphql_name='fileKey')
    path = sgqlc.types.Field('StringFilter', graphql_name='path')
    created_at = sgqlc.types.Field('DatetimeFilter', graphql_name='createdAt')
    updated_at = sgqlc.types.Field('DatetimeFilter', graphql_name='updatedAt')
    deleted_at = sgqlc.types.Field('DatetimeFilter', graphql_name='deletedAt')
    and_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('AccountStatementPdfFilter')), graphql_name='and')
    or_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('AccountStatementPdfFilter')), graphql_name='or')
    not_ = sgqlc.types.Field('AccountStatementPdfFilter', graphql_name='not')


class AccountStatementPdfInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('account_statement_id', 'file_key', 'path', 'account_statement')
    account_statement_id = sgqlc.types.Field(Int, graphql_name='accountStatementId')
    file_key = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='fileKey')
    path = sgqlc.types.Field(Upload, graphql_name='path')
    account_statement = sgqlc.types.Field(AccountStatementInput, graphql_name='accountStatement')


class AcknowledgeControlEventInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'control_event_id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    control_event_id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='controlEventId')


class AcknowledgeSuggestionInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'acknowledge')
    id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='id')
    acknowledge = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name='acknowledge')


class AcknowledgementFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('is_null', 'equal_to', 'not_equal_to', 'distinct_from', 'not_distinct_from', 'in_', 'not_in', 'less_than', 'less_than_or_equal_to', 'greater_than', 'greater_than_or_equal_to')
    is_null = sgqlc.types.Field(Boolean, graphql_name='isNull')
    equal_to = sgqlc.types.Field(Acknowledgement, graphql_name='equalTo')
    not_equal_to = sgqlc.types.Field(Acknowledgement, graphql_name='notEqualTo')
    distinct_from = sgqlc.types.Field(Acknowledgement, graphql_name='distinctFrom')
    not_distinct_from = sgqlc.types.Field(Acknowledgement, graphql_name='notDistinctFrom')
    in_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(Acknowledgement)), graphql_name='in')
    not_in = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(Acknowledgement)), graphql_name='notIn')
    less_than = sgqlc.types.Field(Acknowledgement, graphql_name='lessThan')
    less_than_or_equal_to = sgqlc.types.Field(Acknowledgement, graphql_name='lessThanOrEqualTo')
    greater_than = sgqlc.types.Field(Acknowledgement, graphql_name='greaterThan')
    greater_than_or_equal_to = sgqlc.types.Field(Acknowledgement, graphql_name='greaterThanOrEqualTo')


class ActorFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('type', 'display_name', 'id', 'and_', 'or_', 'not_')
    type = sgqlc.types.Field(AccessTokenTypeFilter, graphql_name='type')
    display_name = sgqlc.types.Field('StringFilter', graphql_name='displayName')
    id = sgqlc.types.Field('StringFilter', graphql_name='id')
    and_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('ActorFilter')), graphql_name='and')
    or_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('ActorFilter')), graphql_name='or')
    not_ = sgqlc.types.Field('ActorFilter', graphql_name='not')


class ActorInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('type',)
    type = sgqlc.types.Field(AccessTokenType, graphql_name='type')


class AddFavoriteFacilityInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'facility_id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    facility_id = sgqlc.types.Field(Int, graphql_name='facilityId')


class AddMetricMetadataDependencyInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'parent_metric', 'child_metric')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    parent_metric = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='parentMetric')
    child_metric = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='childMetric')


class AddProjectControllerInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'project_id', 'user_id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    project_id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='projectId')
    user_id = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='userId')


class AddReportManagerInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'report_id', 'user_id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    report_id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='reportId')
    user_id = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='userId')


class BalancingAuthorityCondition(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('slug', 'created_at', 'updated_at', 'id', 'geometry', 'name')
    slug = sgqlc.types.Field(String, graphql_name='slug')
    created_at = sgqlc.types.Field(Datetime, graphql_name='createdAt')
    updated_at = sgqlc.types.Field(Datetime, graphql_name='updatedAt')
    id = sgqlc.types.Field(Int, graphql_name='id')
    geometry = sgqlc.types.Field(GeoJSON, graphql_name='geometry')
    name = sgqlc.types.Field(String, graphql_name='name')


class BalancingAuthorityFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('slug', 'created_at', 'updated_at', 'id', 'name', 'and_', 'or_', 'not_')
    slug = sgqlc.types.Field('StringFilter', graphql_name='slug')
    created_at = sgqlc.types.Field('DatetimeFilter', graphql_name='createdAt')
    updated_at = sgqlc.types.Field('DatetimeFilter', graphql_name='updatedAt')
    id = sgqlc.types.Field('IntFilter', graphql_name='id')
    name = sgqlc.types.Field('StringFilter', graphql_name='name')
    and_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('BalancingAuthorityFilter')), graphql_name='and')
    or_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('BalancingAuthorityFilter')), graphql_name='or')
    not_ = sgqlc.types.Field('BalancingAuthorityFilter', graphql_name='not')


class BalancingAuthorityInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('slug', 'geometry', 'name')
    slug = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='slug')
    geometry = sgqlc.types.Field(GeoJSON, graphql_name='geometry')
    name = sgqlc.types.Field(String, graphql_name='name')


class BalancingAuthorityPatch(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('slug', 'geometry', 'name')
    slug = sgqlc.types.Field(String, graphql_name='slug')
    geometry = sgqlc.types.Field(GeoJSON, graphql_name='geometry')
    name = sgqlc.types.Field(String, graphql_name='name')


class BigFloatFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('is_null', 'equal_to', 'not_equal_to', 'distinct_from', 'not_distinct_from', 'in_', 'not_in', 'less_than', 'less_than_or_equal_to', 'greater_than', 'greater_than_or_equal_to')
    is_null = sgqlc.types.Field(Boolean, graphql_name='isNull')
    equal_to = sgqlc.types.Field(BigFloat, graphql_name='equalTo')
    not_equal_to = sgqlc.types.Field(BigFloat, graphql_name='notEqualTo')
    distinct_from = sgqlc.types.Field(BigFloat, graphql_name='distinctFrom')
    not_distinct_from = sgqlc.types.Field(BigFloat, graphql_name='notDistinctFrom')
    in_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(BigFloat)), graphql_name='in')
    not_in = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(BigFloat)), graphql_name='notIn')
    less_than = sgqlc.types.Field(BigFloat, graphql_name='lessThan')
    less_than_or_equal_to = sgqlc.types.Field(BigFloat, graphql_name='lessThanOrEqualTo')
    greater_than = sgqlc.types.Field(BigFloat, graphql_name='greaterThan')
    greater_than_or_equal_to = sgqlc.types.Field(BigFloat, graphql_name='greaterThanOrEqualTo')


class BigIntFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('is_null', 'equal_to', 'not_equal_to', 'distinct_from', 'not_distinct_from', 'in_', 'not_in', 'less_than', 'less_than_or_equal_to', 'greater_than', 'greater_than_or_equal_to')
    is_null = sgqlc.types.Field(Boolean, graphql_name='isNull')
    equal_to = sgqlc.types.Field(BigInt, graphql_name='equalTo')
    not_equal_to = sgqlc.types.Field(BigInt, graphql_name='notEqualTo')
    distinct_from = sgqlc.types.Field(BigInt, graphql_name='distinctFrom')
    not_distinct_from = sgqlc.types.Field(BigInt, graphql_name='notDistinctFrom')
    in_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(BigInt)), graphql_name='in')
    not_in = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(BigInt)), graphql_name='notIn')
    less_than = sgqlc.types.Field(BigInt, graphql_name='lessThan')
    less_than_or_equal_to = sgqlc.types.Field(BigInt, graphql_name='lessThanOrEqualTo')
    greater_than = sgqlc.types.Field(BigInt, graphql_name='greaterThan')
    greater_than_or_equal_to = sgqlc.types.Field(BigInt, graphql_name='greaterThanOrEqualTo')


class BlastRotationFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'blast_id', 'current_status', 'overall_start_time', 'overall_end_time', 'estimated_refrigeration_end_time', 'planned_freezing_hours', 'created_at', 'updated_at', 'metadata', 'assumed_pallet_count', 'methodology_type', 'and_', 'or_', 'not_')
    id = sgqlc.types.Field('IntFilter', graphql_name='id')
    blast_id = sgqlc.types.Field('IntFilter', graphql_name='blastId')
    current_status = sgqlc.types.Field('StringFilter', graphql_name='currentStatus')
    overall_start_time = sgqlc.types.Field('DatetimeFilter', graphql_name='overallStartTime')
    overall_end_time = sgqlc.types.Field('DatetimeFilter', graphql_name='overallEndTime')
    estimated_refrigeration_end_time = sgqlc.types.Field('DatetimeFilter', graphql_name='estimatedRefrigerationEndTime')
    planned_freezing_hours = sgqlc.types.Field('FloatFilter', graphql_name='plannedFreezingHours')
    created_at = sgqlc.types.Field('DatetimeFilter', graphql_name='createdAt')
    updated_at = sgqlc.types.Field('DatetimeFilter', graphql_name='updatedAt')
    metadata = sgqlc.types.Field('JSONFilter', graphql_name='metadata')
    assumed_pallet_count = sgqlc.types.Field('IntFilter', graphql_name='assumedPalletCount')
    methodology_type = sgqlc.types.Field('StringFilter', graphql_name='methodologyType')
    and_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('BlastRotationFilter')), graphql_name='and')
    or_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('BlastRotationFilter')), graphql_name='or')
    not_ = sgqlc.types.Field('BlastRotationFilter', graphql_name='not')


class BooleanFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('is_null', 'equal_to', 'not_equal_to', 'distinct_from', 'not_distinct_from', 'in_', 'not_in', 'less_than', 'less_than_or_equal_to', 'greater_than', 'greater_than_or_equal_to')
    is_null = sgqlc.types.Field(Boolean, graphql_name='isNull')
    equal_to = sgqlc.types.Field(Boolean, graphql_name='equalTo')
    not_equal_to = sgqlc.types.Field(Boolean, graphql_name='notEqualTo')
    distinct_from = sgqlc.types.Field(Boolean, graphql_name='distinctFrom')
    not_distinct_from = sgqlc.types.Field(Boolean, graphql_name='notDistinctFrom')
    in_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(Boolean)), graphql_name='in')
    not_in = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(Boolean)), graphql_name='notIn')
    less_than = sgqlc.types.Field(Boolean, graphql_name='lessThan')
    less_than_or_equal_to = sgqlc.types.Field(Boolean, graphql_name='lessThanOrEqualTo')
    greater_than = sgqlc.types.Field(Boolean, graphql_name='greaterThan')
    greater_than_or_equal_to = sgqlc.types.Field(Boolean, graphql_name='greaterThanOrEqualTo')


class BuildingAreaCondition(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'building_area_type_id', 'facility_id', 'geometry', 'label', 'description', 'created_at', 'updated_at')
    id = sgqlc.types.Field(Int, graphql_name='id')
    building_area_type_id = sgqlc.types.Field(String, graphql_name='buildingAreaTypeId')
    facility_id = sgqlc.types.Field(Int, graphql_name='facilityId')
    geometry = sgqlc.types.Field(GeoJSON, graphql_name='geometry')
    label = sgqlc.types.Field(String, graphql_name='label')
    description = sgqlc.types.Field(String, graphql_name='description')
    created_at = sgqlc.types.Field(Datetime, graphql_name='createdAt')
    updated_at = sgqlc.types.Field(Datetime, graphql_name='updatedAt')


class BuildingAreaFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'building_area_type_id', 'facility_id', 'label', 'description', 'created_at', 'updated_at', 'and_', 'or_', 'not_')
    id = sgqlc.types.Field('IntFilter', graphql_name='id')
    building_area_type_id = sgqlc.types.Field('StringFilter', graphql_name='buildingAreaTypeId')
    facility_id = sgqlc.types.Field('IntFilter', graphql_name='facilityId')
    label = sgqlc.types.Field('StringFilter', graphql_name='label')
    description = sgqlc.types.Field('StringFilter', graphql_name='description')
    created_at = sgqlc.types.Field('DatetimeFilter', graphql_name='createdAt')
    updated_at = sgqlc.types.Field('DatetimeFilter', graphql_name='updatedAt')
    and_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('BuildingAreaFilter')), graphql_name='and')
    or_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('BuildingAreaFilter')), graphql_name='or')
    not_ = sgqlc.types.Field('BuildingAreaFilter', graphql_name='not')


class BuildingAreaInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('building_area_type_id', 'facility_id', 'geometry', 'label', 'description', 'building_area_type')
    building_area_type_id = sgqlc.types.Field(String, graphql_name='buildingAreaTypeId')
    facility_id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='facilityId')
    geometry = sgqlc.types.Field(GeoJSON, graphql_name='geometry')
    label = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='label')
    description = sgqlc.types.Field(String, graphql_name='description')
    building_area_type = sgqlc.types.Field('BuildingAreaTypeInput', graphql_name='buildingAreaType')


class BuildingAreaPalletHistoryFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'building_area_id', 'pallet_location_id', 'pallet_id', 'in_transaction_id', 'out_transaction_id', 'in_time', 'out_time', 'created_at', 'updated_at', 'deleted_at', 'metadata', 'and_', 'or_', 'not_')
    id = sgqlc.types.Field(BigIntFilter, graphql_name='id')
    building_area_id = sgqlc.types.Field('IntFilter', graphql_name='buildingAreaId')
    pallet_location_id = sgqlc.types.Field(BigIntFilter, graphql_name='palletLocationId')
    pallet_id = sgqlc.types.Field(BigIntFilter, graphql_name='palletId')
    in_transaction_id = sgqlc.types.Field(BigIntFilter, graphql_name='inTransactionId')
    out_transaction_id = sgqlc.types.Field(BigIntFilter, graphql_name='outTransactionId')
    in_time = sgqlc.types.Field('DatetimeFilter', graphql_name='inTime')
    out_time = sgqlc.types.Field('DatetimeFilter', graphql_name='outTime')
    created_at = sgqlc.types.Field('DatetimeFilter', graphql_name='createdAt')
    updated_at = sgqlc.types.Field('DatetimeFilter', graphql_name='updatedAt')
    deleted_at = sgqlc.types.Field('DatetimeFilter', graphql_name='deletedAt')
    metadata = sgqlc.types.Field('JSONFilter', graphql_name='metadata')
    and_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('BuildingAreaPalletHistoryFilter')), graphql_name='and')
    or_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('BuildingAreaPalletHistoryFilter')), graphql_name='or')
    not_ = sgqlc.types.Field('BuildingAreaPalletHistoryFilter', graphql_name='not')


class BuildingAreaPatch(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('building_area_type_id', 'facility_id', 'geometry', 'label', 'description')
    building_area_type_id = sgqlc.types.Field(String, graphql_name='buildingAreaTypeId')
    facility_id = sgqlc.types.Field(Int, graphql_name='facilityId')
    geometry = sgqlc.types.Field(GeoJSON, graphql_name='geometry')
    label = sgqlc.types.Field(String, graphql_name='label')
    description = sgqlc.types.Field(String, graphql_name='description')


class BuildingAreaTypeCondition(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('type', 'description', 'metadata')
    type = sgqlc.types.Field(String, graphql_name='type')
    description = sgqlc.types.Field(String, graphql_name='description')
    metadata = sgqlc.types.Field(JSON, graphql_name='metadata')


class BuildingAreaTypeFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('type', 'description', 'metadata', 'and_', 'or_', 'not_')
    type = sgqlc.types.Field('StringFilter', graphql_name='type')
    description = sgqlc.types.Field('StringFilter', graphql_name='description')
    metadata = sgqlc.types.Field('JSONFilter', graphql_name='metadata')
    and_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('BuildingAreaTypeFilter')), graphql_name='and')
    or_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('BuildingAreaTypeFilter')), graphql_name='or')
    not_ = sgqlc.types.Field('BuildingAreaTypeFilter', graphql_name='not')


class BuildingAreaTypeInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('type', 'description', 'metadata')
    type = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='type')
    description = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='description')
    metadata = sgqlc.types.Field(JSON, graphql_name='metadata')


class BuildingAreaTypePatch(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('type', 'description', 'metadata')
    type = sgqlc.types.Field(String, graphql_name='type')
    description = sgqlc.types.Field(String, graphql_name='description')
    metadata = sgqlc.types.Field(JSON, graphql_name='metadata')


class BulkProjectUser(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('project_id', 'user_id', 'watcher', 'controller', 'email', 'sms')
    project_id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='projectId')
    user_id = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='userId')
    watcher = sgqlc.types.Field(Boolean, graphql_name='watcher')
    controller = sgqlc.types.Field(Boolean, graphql_name='controller')
    email = sgqlc.types.Field(Boolean, graphql_name='email')
    sms = sgqlc.types.Field(Boolean, graphql_name='sms')


class ChartCondition(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'facility_id', 'name', 'description', 'config', 'created_at', 'updated_at')
    id = sgqlc.types.Field(Int, graphql_name='id')
    facility_id = sgqlc.types.Field(Int, graphql_name='facilityId')
    name = sgqlc.types.Field(String, graphql_name='name')
    description = sgqlc.types.Field(String, graphql_name='description')
    config = sgqlc.types.Field(JSON, graphql_name='config')
    created_at = sgqlc.types.Field(Datetime, graphql_name='createdAt')
    updated_at = sgqlc.types.Field(Datetime, graphql_name='updatedAt')


class ChartFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'facility_id', 'name', 'description', 'config', 'created_at', 'updated_at', 'and_', 'or_', 'not_')
    id = sgqlc.types.Field('IntFilter', graphql_name='id')
    facility_id = sgqlc.types.Field('IntFilter', graphql_name='facilityId')
    name = sgqlc.types.Field('StringFilter', graphql_name='name')
    description = sgqlc.types.Field('StringFilter', graphql_name='description')
    config = sgqlc.types.Field('JSONFilter', graphql_name='config')
    created_at = sgqlc.types.Field('DatetimeFilter', graphql_name='createdAt')
    updated_at = sgqlc.types.Field('DatetimeFilter', graphql_name='updatedAt')
    and_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('ChartFilter')), graphql_name='and')
    or_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('ChartFilter')), graphql_name='or')
    not_ = sgqlc.types.Field('ChartFilter', graphql_name='not')


class ChartInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('facility_id', 'name', 'description', 'config')
    facility_id = sgqlc.types.Field(Int, graphql_name='facilityId')
    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='name')
    description = sgqlc.types.Field(String, graphql_name='description')
    config = sgqlc.types.Field(JSON, graphql_name='config')


class ChartPatch(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('facility_id', 'name', 'description', 'config')
    facility_id = sgqlc.types.Field(Int, graphql_name='facilityId')
    name = sgqlc.types.Field(String, graphql_name='name')
    description = sgqlc.types.Field(String, graphql_name='description')
    config = sgqlc.types.Field(JSON, graphql_name='config')


class ClearFacilityCommunicationInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'facility_communication_id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    facility_communication_id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='facilityCommunicationId')


class ComplianceGroupFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'label', 'created_at', 'updated_at', 'track_out_of_specification', 'and_', 'or_', 'not_')
    id = sgqlc.types.Field('IntFilter', graphql_name='id')
    label = sgqlc.types.Field('StringFilter', graphql_name='label')
    created_at = sgqlc.types.Field('DatetimeFilter', graphql_name='createdAt')
    updated_at = sgqlc.types.Field('DatetimeFilter', graphql_name='updatedAt')
    track_out_of_specification = sgqlc.types.Field(BooleanFilter, graphql_name='trackOutOfSpecification')
    and_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('ComplianceGroupFilter')), graphql_name='and')
    or_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('ComplianceGroupFilter')), graphql_name='or')
    not_ = sgqlc.types.Field('ComplianceGroupFilter', graphql_name='not')


class ComponentCondition(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'name', 'machine_user_id', 'facility_id', 'out_of_service', 'created_at', 'updated_at', 'alias')
    id = sgqlc.types.Field(Int, graphql_name='id')
    name = sgqlc.types.Field(String, graphql_name='name')
    machine_user_id = sgqlc.types.Field(BigInt, graphql_name='machineUserId')
    facility_id = sgqlc.types.Field(Int, graphql_name='facilityId')
    out_of_service = sgqlc.types.Field(Boolean, graphql_name='outOfService')
    created_at = sgqlc.types.Field(Datetime, graphql_name='createdAt')
    updated_at = sgqlc.types.Field(Datetime, graphql_name='updatedAt')
    alias = sgqlc.types.Field(String, graphql_name='alias')


class ComponentFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('can_write', 'id', 'name', 'machine_user_id', 'facility_id', 'out_of_service', 'created_at', 'updated_at', 'alias', 'and_', 'or_', 'not_')
    can_write = sgqlc.types.Field('PermissionBooleanFilter', graphql_name='canWrite')
    id = sgqlc.types.Field('IntFilter', graphql_name='id')
    name = sgqlc.types.Field('StringFilter', graphql_name='name')
    machine_user_id = sgqlc.types.Field(BigIntFilter, graphql_name='machineUserId')
    facility_id = sgqlc.types.Field('IntFilter', graphql_name='facilityId')
    out_of_service = sgqlc.types.Field(BooleanFilter, graphql_name='outOfService')
    created_at = sgqlc.types.Field('DatetimeFilter', graphql_name='createdAt')
    updated_at = sgqlc.types.Field('DatetimeFilter', graphql_name='updatedAt')
    alias = sgqlc.types.Field('StringFilter', graphql_name='alias')
    and_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('ComponentFilter')), graphql_name='and')
    or_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('ComponentFilter')), graphql_name='or')
    not_ = sgqlc.types.Field('ComponentFilter', graphql_name='not')


class ComponentInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'name', 'machine_user_id', 'facility_id', 'out_of_service', 'created_at', 'updated_at', 'alias', 'machine_user')
    id = sgqlc.types.Field(Int, graphql_name='id')
    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='name')
    machine_user_id = sgqlc.types.Field(BigInt, graphql_name='machineUserId')
    facility_id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='facilityId')
    out_of_service = sgqlc.types.Field(Boolean, graphql_name='outOfService')
    created_at = sgqlc.types.Field(Datetime, graphql_name='createdAt')
    updated_at = sgqlc.types.Field(Datetime, graphql_name='updatedAt')
    alias = sgqlc.types.Field(String, graphql_name='alias')
    machine_user = sgqlc.types.Field('MachineUserInput', graphql_name='machineUser')


class ComponentPatch(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'name', 'machine_user_id', 'facility_id', 'out_of_service', 'created_at', 'updated_at', 'alias')
    id = sgqlc.types.Field(Int, graphql_name='id')
    name = sgqlc.types.Field(String, graphql_name='name')
    machine_user_id = sgqlc.types.Field(BigInt, graphql_name='machineUserId')
    facility_id = sgqlc.types.Field(Int, graphql_name='facilityId')
    out_of_service = sgqlc.types.Field(Boolean, graphql_name='outOfService')
    created_at = sgqlc.types.Field(Datetime, graphql_name='createdAt')
    updated_at = sgqlc.types.Field(Datetime, graphql_name='updatedAt')
    alias = sgqlc.types.Field(String, graphql_name='alias')


class ControlEventActivityLogCondition(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('control_event_id', 'time', 'type', 'actor', 'metadata')
    control_event_id = sgqlc.types.Field(Int, graphql_name='controlEventId')
    time = sgqlc.types.Field(Datetime, graphql_name='time')
    type = sgqlc.types.Field(String, graphql_name='type')
    actor = sgqlc.types.Field(ActorInput, graphql_name='actor')
    metadata = sgqlc.types.Field(JSON, graphql_name='metadata')


class ControlEventActivityLogFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('control_event_id', 'time', 'type', 'actor', 'and_', 'or_', 'not_')
    control_event_id = sgqlc.types.Field('IntFilter', graphql_name='controlEventId')
    time = sgqlc.types.Field('DatetimeFilter', graphql_name='time')
    type = sgqlc.types.Field('StringFilter', graphql_name='type')
    actor = sgqlc.types.Field(ActorFilter, graphql_name='actor')
    and_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('ControlEventActivityLogFilter')), graphql_name='and')
    or_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('ControlEventActivityLogFilter')), graphql_name='or')
    not_ = sgqlc.types.Field('ControlEventActivityLogFilter', graphql_name='not')


class ControlEventCondition(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'name', 'start_time', 'end_time', 'component_id', 'created_at', 'updated_at', 'acknowledged_at', 'remote_metadata')
    id = sgqlc.types.Field(Int, graphql_name='id')
    name = sgqlc.types.Field(String, graphql_name='name')
    start_time = sgqlc.types.Field(Datetime, graphql_name='startTime')
    end_time = sgqlc.types.Field(Datetime, graphql_name='endTime')
    component_id = sgqlc.types.Field(Int, graphql_name='componentId')
    created_at = sgqlc.types.Field(Datetime, graphql_name='createdAt')
    updated_at = sgqlc.types.Field(Datetime, graphql_name='updatedAt')
    acknowledged_at = sgqlc.types.Field(Datetime, graphql_name='acknowledgedAt')
    remote_metadata = sgqlc.types.Field(JSON, graphql_name='remoteMetadata')


class ControlEventFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('can_write', 'id', 'name', 'start_time', 'end_time', 'component_id', 'created_at', 'updated_at', 'acknowledged_at', 'remote_metadata', 'current_state', 'is_acknowledged', 'and_', 'or_', 'not_')
    can_write = sgqlc.types.Field('PermissionBooleanFilter', graphql_name='canWrite')
    id = sgqlc.types.Field('IntFilter', graphql_name='id')
    name = sgqlc.types.Field('StringFilter', graphql_name='name')
    start_time = sgqlc.types.Field('DatetimeFilter', graphql_name='startTime')
    end_time = sgqlc.types.Field('DatetimeFilter', graphql_name='endTime')
    component_id = sgqlc.types.Field('IntFilter', graphql_name='componentId')
    created_at = sgqlc.types.Field('DatetimeFilter', graphql_name='createdAt')
    updated_at = sgqlc.types.Field('DatetimeFilter', graphql_name='updatedAt')
    acknowledged_at = sgqlc.types.Field('DatetimeFilter', graphql_name='acknowledgedAt')
    remote_metadata = sgqlc.types.Field('JSONFilter', graphql_name='remoteMetadata')
    current_state = sgqlc.types.Field('ControlEventStateFilter', graphql_name='currentState')
    is_acknowledged = sgqlc.types.Field(BooleanFilter, graphql_name='isAcknowledged')
    and_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('ControlEventFilter')), graphql_name='and')
    or_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('ControlEventFilter')), graphql_name='or')
    not_ = sgqlc.types.Field('ControlEventFilter', graphql_name='not')


class ControlEventInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'name', 'start_time', 'end_time', 'component_id', 'created_at', 'updated_at', 'remote_metadata')
    id = sgqlc.types.Field(Int, graphql_name='id')
    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='name')
    start_time = sgqlc.types.Field(sgqlc.types.non_null(Datetime), graphql_name='startTime')
    end_time = sgqlc.types.Field(sgqlc.types.non_null(Datetime), graphql_name='endTime')
    component_id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='componentId')
    created_at = sgqlc.types.Field(Datetime, graphql_name='createdAt')
    updated_at = sgqlc.types.Field(Datetime, graphql_name='updatedAt')
    remote_metadata = sgqlc.types.Field(JSON, graphql_name='remoteMetadata')


class ControlEventLogCondition(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'control_event_id', 'message', 'created_at', 'actor')
    id = sgqlc.types.Field(Int, graphql_name='id')
    control_event_id = sgqlc.types.Field(Int, graphql_name='controlEventId')
    message = sgqlc.types.Field(String, graphql_name='message')
    created_at = sgqlc.types.Field(Datetime, graphql_name='createdAt')
    actor = sgqlc.types.Field(ActorInput, graphql_name='actor')


class ControlEventLogFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'control_event_id', 'message', 'created_at', 'actor', 'and_', 'or_', 'not_')
    id = sgqlc.types.Field('IntFilter', graphql_name='id')
    control_event_id = sgqlc.types.Field('IntFilter', graphql_name='controlEventId')
    message = sgqlc.types.Field('StringFilter', graphql_name='message')
    created_at = sgqlc.types.Field('DatetimeFilter', graphql_name='createdAt')
    actor = sgqlc.types.Field(ActorFilter, graphql_name='actor')
    and_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('ControlEventLogFilter')), graphql_name='and')
    or_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('ControlEventLogFilter')), graphql_name='or')
    not_ = sgqlc.types.Field('ControlEventLogFilter', graphql_name='not')


class ControlEventLogInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('control_event_id', 'message', 'control_event')
    control_event_id = sgqlc.types.Field(Int, graphql_name='controlEventId')
    message = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='message')
    control_event = sgqlc.types.Field(ControlEventInput, graphql_name='controlEvent')


class ControlEventLogPatch(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('control_event_id', 'message')
    control_event_id = sgqlc.types.Field(Int, graphql_name='controlEventId')
    message = sgqlc.types.Field(String, graphql_name='message')


class ControlEventPatch(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'name', 'start_time', 'end_time', 'updated_at', 'remote_metadata')
    id = sgqlc.types.Field(Int, graphql_name='id')
    name = sgqlc.types.Field(String, graphql_name='name')
    start_time = sgqlc.types.Field(Datetime, graphql_name='startTime')
    end_time = sgqlc.types.Field(Datetime, graphql_name='endTime')
    updated_at = sgqlc.types.Field(Datetime, graphql_name='updatedAt')
    remote_metadata = sgqlc.types.Field(JSON, graphql_name='remoteMetadata')


class ControlEventStateFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('is_null', 'equal_to', 'not_equal_to', 'distinct_from', 'not_distinct_from', 'in_', 'not_in', 'less_than', 'less_than_or_equal_to', 'greater_than', 'greater_than_or_equal_to')
    is_null = sgqlc.types.Field(Boolean, graphql_name='isNull')
    equal_to = sgqlc.types.Field(ControlEventState, graphql_name='equalTo')
    not_equal_to = sgqlc.types.Field(ControlEventState, graphql_name='notEqualTo')
    distinct_from = sgqlc.types.Field(ControlEventState, graphql_name='distinctFrom')
    not_distinct_from = sgqlc.types.Field(ControlEventState, graphql_name='notDistinctFrom')
    in_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(ControlEventState)), graphql_name='in')
    not_in = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(ControlEventState)), graphql_name='notIn')
    less_than = sgqlc.types.Field(ControlEventState, graphql_name='lessThan')
    less_than_or_equal_to = sgqlc.types.Field(ControlEventState, graphql_name='lessThanOrEqualTo')
    greater_than = sgqlc.types.Field(ControlEventState, graphql_name='greaterThan')
    greater_than_or_equal_to = sgqlc.types.Field(ControlEventState, graphql_name='greaterThanOrEqualTo')


class ControlEventStateTransitionCondition(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('control_event_id', 'state', 'description', 'created_at', 'actor')
    control_event_id = sgqlc.types.Field(Int, graphql_name='controlEventId')
    state = sgqlc.types.Field(ControlEventState, graphql_name='state')
    description = sgqlc.types.Field(String, graphql_name='description')
    created_at = sgqlc.types.Field(Datetime, graphql_name='createdAt')
    actor = sgqlc.types.Field(ActorInput, graphql_name='actor')


class ControlEventStateTransitionFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('control_event_id', 'state', 'description', 'created_at', 'actor', 'and_', 'or_', 'not_')
    control_event_id = sgqlc.types.Field('IntFilter', graphql_name='controlEventId')
    state = sgqlc.types.Field(ControlEventStateFilter, graphql_name='state')
    description = sgqlc.types.Field('StringFilter', graphql_name='description')
    created_at = sgqlc.types.Field('DatetimeFilter', graphql_name='createdAt')
    actor = sgqlc.types.Field(ActorFilter, graphql_name='actor')
    and_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('ControlEventStateTransitionFilter')), graphql_name='and')
    or_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('ControlEventStateTransitionFilter')), graphql_name='or')
    not_ = sgqlc.types.Field('ControlEventStateTransitionFilter', graphql_name='not')


class ControlTypeFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('is_null', 'equal_to', 'not_equal_to', 'distinct_from', 'not_distinct_from', 'in_', 'not_in', 'less_than', 'less_than_or_equal_to', 'greater_than', 'greater_than_or_equal_to')
    is_null = sgqlc.types.Field(Boolean, graphql_name='isNull')
    equal_to = sgqlc.types.Field(ControlType, graphql_name='equalTo')
    not_equal_to = sgqlc.types.Field(ControlType, graphql_name='notEqualTo')
    distinct_from = sgqlc.types.Field(ControlType, graphql_name='distinctFrom')
    not_distinct_from = sgqlc.types.Field(ControlType, graphql_name='notDistinctFrom')
    in_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(ControlType)), graphql_name='in')
    not_in = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(ControlType)), graphql_name='notIn')
    less_than = sgqlc.types.Field(ControlType, graphql_name='lessThan')
    less_than_or_equal_to = sgqlc.types.Field(ControlType, graphql_name='lessThanOrEqualTo')
    greater_than = sgqlc.types.Field(ControlType, graphql_name='greaterThan')
    greater_than_or_equal_to = sgqlc.types.Field(ControlType, graphql_name='greaterThanOrEqualTo')


class CountryFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('is_null', 'equal_to', 'not_equal_to', 'distinct_from', 'not_distinct_from', 'in_', 'not_in', 'less_than', 'less_than_or_equal_to', 'greater_than', 'greater_than_or_equal_to')
    is_null = sgqlc.types.Field(Boolean, graphql_name='isNull')
    equal_to = sgqlc.types.Field(Country, graphql_name='equalTo')
    not_equal_to = sgqlc.types.Field(Country, graphql_name='notEqualTo')
    distinct_from = sgqlc.types.Field(Country, graphql_name='distinctFrom')
    not_distinct_from = sgqlc.types.Field(Country, graphql_name='notDistinctFrom')
    in_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(Country)), graphql_name='in')
    not_in = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(Country)), graphql_name='notIn')
    less_than = sgqlc.types.Field(Country, graphql_name='lessThan')
    less_than_or_equal_to = sgqlc.types.Field(Country, graphql_name='lessThanOrEqualTo')
    greater_than = sgqlc.types.Field(Country, graphql_name='greaterThan')
    greater_than_or_equal_to = sgqlc.types.Field(Country, graphql_name='greaterThanOrEqualTo')


class CreateAccountChargeInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'account_charge')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    account_charge = sgqlc.types.Field(sgqlc.types.non_null(AccountChargeInput), graphql_name='accountCharge')


class CreateAccountStatementHistoryInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'account_statement_history')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    account_statement_history = sgqlc.types.Field(sgqlc.types.non_null(AccountStatementHistoryInput), graphql_name='accountStatementHistory')


class CreateAccountStatementInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'account_statement')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    account_statement = sgqlc.types.Field(sgqlc.types.non_null(AccountStatementInput), graphql_name='accountStatement')


class CreateAccountStatementPdfInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'account_statement_pdf')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    account_statement_pdf = sgqlc.types.Field(sgqlc.types.non_null(AccountStatementPdfInput), graphql_name='accountStatementPdf')


class CreateBalancingAuthorityInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'balancing_authority')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    balancing_authority = sgqlc.types.Field(sgqlc.types.non_null(BalancingAuthorityInput), graphql_name='balancingAuthority')


class CreateBuildingAreaInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'building_area')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    building_area = sgqlc.types.Field(sgqlc.types.non_null(BuildingAreaInput), graphql_name='buildingArea')


class CreateBuildingAreaTypeInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'building_area_type')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    building_area_type = sgqlc.types.Field(sgqlc.types.non_null(BuildingAreaTypeInput), graphql_name='buildingAreaType')


class CreateChartInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'chart')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    chart = sgqlc.types.Field(sgqlc.types.non_null(ChartInput), graphql_name='chart')


class CreateComponentInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'component')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    component = sgqlc.types.Field(sgqlc.types.non_null(ComponentInput), graphql_name='component')


class CreateControlEventInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'control_event')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    control_event = sgqlc.types.Field(sgqlc.types.non_null(ControlEventInput), graphql_name='controlEvent')


class CreateControlEventLogInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'control_event_log')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    control_event_log = sgqlc.types.Field(sgqlc.types.non_null(ControlEventLogInput), graphql_name='controlEventLog')


class CreateDashboardInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'dashboard')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    dashboard = sgqlc.types.Field(sgqlc.types.non_null('DashboardInput'), graphql_name='dashboard')


class CreateDataPointInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'data_point')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    data_point = sgqlc.types.Field(sgqlc.types.non_null('DataPointInput'), graphql_name='dataPoint')


class CreateDataPointTagInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'data_point_tag')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    data_point_tag = sgqlc.types.Field(sgqlc.types.non_null('DataPointTagInput'), graphql_name='dataPointTag')


class CreateDataSourceInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'data_source')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    data_source = sgqlc.types.Field(sgqlc.types.non_null('DataSourceInput'), graphql_name='dataSource')


class CreateDependencyInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'dependency')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    dependency = sgqlc.types.Field(sgqlc.types.non_null('DependencyInput'), graphql_name='dependency')


class CreateFacilityCommunicationInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'facility_communication')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    facility_communication = sgqlc.types.Field(sgqlc.types.non_null('FacilityCommunicationInput'), graphql_name='facilityCommunication')


class CreateFacilityDataSourceInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'facility_data_source')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    facility_data_source = sgqlc.types.Field(sgqlc.types.non_null('FacilityDataSourceInput'), graphql_name='facilityDataSource')


class CreateFacilityGroupInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'facility_group')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    facility_group = sgqlc.types.Field(sgqlc.types.non_null('FacilityGroupInput'), graphql_name='facilityGroup')


class CreateFacilityGroupsLinkerInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'facility_groups_linker')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    facility_groups_linker = sgqlc.types.Field(sgqlc.types.non_null('FacilityGroupsLinkerInput'), graphql_name='facilityGroupsLinker')


class CreateFacilityInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'facility')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    facility = sgqlc.types.Field(sgqlc.types.non_null('FacilityInput'), graphql_name='facility')


class CreateFacilityTaggedDataPointInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'facility_tagged_data_point')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    facility_tagged_data_point = sgqlc.types.Field(sgqlc.types.non_null('FacilityTaggedDataPointInput'), graphql_name='facilityTaggedDataPoint')


class CreateMachineAccessTokenInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('description', 'expires_at', 'machine_user_id', 'client_mutation_id')
    description = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='description')
    expires_at = sgqlc.types.Field(Datetime, graphql_name='expiresAt')
    machine_user_id = sgqlc.types.Field(sgqlc.types.non_null(BigInt), graphql_name='machineUserId')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')


class CreateMachineUserInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'machine_user')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    machine_user = sgqlc.types.Field(sgqlc.types.non_null('MachineUserInput'), graphql_name='machineUser')


class CreateMainServiceInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'main_service')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    main_service = sgqlc.types.Field(sgqlc.types.non_null('MainServiceInput'), graphql_name='mainService')


class CreateMeterChargeInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'meter_charge')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    meter_charge = sgqlc.types.Field(sgqlc.types.non_null('MeterChargeInput'), graphql_name='meterCharge')


class CreateMeterStatementHistoryInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'meter_statement_history')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    meter_statement_history = sgqlc.types.Field(sgqlc.types.non_null('MeterStatementHistoryInput'), graphql_name='meterStatementHistory')


class CreateMeterStatementInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'meter_statement')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    meter_statement = sgqlc.types.Field(sgqlc.types.non_null('MeterStatementInput'), graphql_name='meterStatement')


class CreateMeterUsageInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'meter_usage')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    meter_usage = sgqlc.types.Field(sgqlc.types.non_null('MeterUsageInput'), graphql_name='meterUsage')


class CreateMonitorDataPointInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'monitor_data_point')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    monitor_data_point = sgqlc.types.Field(sgqlc.types.non_null('MonitorDataPointInput'), graphql_name='monitorDataPoint')


class CreateMonitorDetectionInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'monitor_detection')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    monitor_detection = sgqlc.types.Field(sgqlc.types.non_null('MonitorDetectionInput'), graphql_name='monitorDetection')


class CreateMonitorInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'monitor')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    monitor = sgqlc.types.Field(sgqlc.types.non_null('MonitorInput'), graphql_name='monitor')


class CreatePricingNodeInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'pricing_node')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    pricing_node = sgqlc.types.Field(sgqlc.types.non_null('PricingNodeInput'), graphql_name='pricingNode')


class CreateProgramEnrollmentInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'program_enrollment')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    program_enrollment = sgqlc.types.Field(sgqlc.types.non_null('ProgramEnrollmentInput'), graphql_name='programEnrollment')


class CreateProgramInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'program')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    program = sgqlc.types.Field(sgqlc.types.non_null('ProgramInput'), graphql_name='program')


class CreateProjectComponentInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'project_component')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    project_component = sgqlc.types.Field(sgqlc.types.non_null('ProjectComponentInput'), graphql_name='projectComponent')


class CreateProjectEnrollmentDataPointGroupInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'project_enrollment_data_point_group')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    project_enrollment_data_point_group = sgqlc.types.Field(sgqlc.types.non_null('ProjectEnrollmentDataPointGroupInput'), graphql_name='projectEnrollmentDataPointGroup')


class CreateProjectEnrollmentDataPointInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'project_enrollment_data_point')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    project_enrollment_data_point = sgqlc.types.Field(sgqlc.types.non_null('ProjectEnrollmentDataPointInput'), graphql_name='projectEnrollmentDataPoint')


class CreateProjectEnrollmentInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'project_enrollment')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    project_enrollment = sgqlc.types.Field(sgqlc.types.non_null('ProjectEnrollmentInput'), graphql_name='projectEnrollment')


class CreateProjectInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'project')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    project = sgqlc.types.Field(sgqlc.types.non_null('ProjectInput'), graphql_name='project')


class CreateProjectWatcherInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'project_watcher')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    project_watcher = sgqlc.types.Field(sgqlc.types.non_null('ProjectWatcherInput'), graphql_name='projectWatcher')


class CreateReportExecutionInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'report_execution')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    report_execution = sgqlc.types.Field(sgqlc.types.non_null('ReportExecutionInput'), graphql_name='reportExecution')


class CreateSavingsEventInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'savings_event')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    savings_event = sgqlc.types.Field(sgqlc.types.non_null('SavingsEventInput'), graphql_name='savingsEvent')


class CreateSuggestionActivityLogInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'suggestion_activity_log')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    suggestion_activity_log = sgqlc.types.Field(sgqlc.types.non_null('SuggestionActivityLogInput'), graphql_name='suggestionActivityLog')


class CreateSuggestionControlEventInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'suggestion_control_event')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    suggestion_control_event = sgqlc.types.Field(sgqlc.types.non_null('SuggestionControlEventInput'), graphql_name='suggestionControlEvent')


class CreateSuggestionInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'suggestion')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    suggestion = sgqlc.types.Field(sgqlc.types.non_null('SuggestionInput'), graphql_name='suggestion')


class CreateUserAccessTokenInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('description', 'expires_at', 'client_mutation_id')
    description = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='description')
    expires_at = sgqlc.types.Field(Datetime, graphql_name='expiresAt')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')


class CreateUtilityAccountInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'utility_account')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    utility_account = sgqlc.types.Field(sgqlc.types.non_null('UtilityAccountInput'), graphql_name='utilityAccount')


class CreateUtilityMeterInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'utility_meter')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    utility_meter = sgqlc.types.Field(sgqlc.types.non_null('UtilityMeterInput'), graphql_name='utilityMeter')


class CreateUtilityProviderInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'utility_provider')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    utility_provider = sgqlc.types.Field(sgqlc.types.non_null('UtilityProviderInput'), graphql_name='utilityProvider')


class CreateVendorUserInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'vendor_user')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    vendor_user = sgqlc.types.Field(sgqlc.types.non_null('VendorUserInput'), graphql_name='vendorUser')


class CreateVendorUserMachineUserInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'vendor_user_machine_user')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    vendor_user_machine_user = sgqlc.types.Field(sgqlc.types.non_null('VendorUserMachineUserInput'), graphql_name='vendorUserMachineUser')


class CreateVirtualPointIntervalInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'virtual_point_interval')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    virtual_point_interval = sgqlc.types.Field(sgqlc.types.non_null('VirtualPointIntervalInput'), graphql_name='virtualPointInterval')


class DashboardCondition(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'facility_id', 'name', 'description', 'config', 'created_at', 'updated_at')
    id = sgqlc.types.Field(Int, graphql_name='id')
    facility_id = sgqlc.types.Field(Int, graphql_name='facilityId')
    name = sgqlc.types.Field(String, graphql_name='name')
    description = sgqlc.types.Field(String, graphql_name='description')
    config = sgqlc.types.Field(JSON, graphql_name='config')
    created_at = sgqlc.types.Field(Datetime, graphql_name='createdAt')
    updated_at = sgqlc.types.Field(Datetime, graphql_name='updatedAt')


class DashboardFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'facility_id', 'name', 'description', 'config', 'created_at', 'updated_at', 'and_', 'or_', 'not_')
    id = sgqlc.types.Field('IntFilter', graphql_name='id')
    facility_id = sgqlc.types.Field('IntFilter', graphql_name='facilityId')
    name = sgqlc.types.Field('StringFilter', graphql_name='name')
    description = sgqlc.types.Field('StringFilter', graphql_name='description')
    config = sgqlc.types.Field('JSONFilter', graphql_name='config')
    created_at = sgqlc.types.Field('DatetimeFilter', graphql_name='createdAt')
    updated_at = sgqlc.types.Field('DatetimeFilter', graphql_name='updatedAt')
    and_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('DashboardFilter')), graphql_name='and')
    or_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('DashboardFilter')), graphql_name='or')
    not_ = sgqlc.types.Field('DashboardFilter', graphql_name='not')


class DashboardInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('facility_id', 'name', 'description', 'config')
    facility_id = sgqlc.types.Field(Int, graphql_name='facilityId')
    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='name')
    description = sgqlc.types.Field(String, graphql_name='description')
    config = sgqlc.types.Field(JSON, graphql_name='config')


class DashboardPatch(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('facility_id', 'name', 'description', 'config')
    facility_id = sgqlc.types.Field(Int, graphql_name='facilityId')
    name = sgqlc.types.Field(String, graphql_name='name')
    description = sgqlc.types.Field(String, graphql_name='description')
    config = sgqlc.types.Field(JSON, graphql_name='config')


class DataPointCondition(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'data_source_name', 'name', 'alias', 'description', 'units', 'expression', 'data_type', 'created_at', 'updated_at', 'formatted_expression', 'type', 'frequency', 'location_type', 'right_aligned', 'freshness_threshold_seconds', 'has_alignment_correction')
    id = sgqlc.types.Field(BigInt, graphql_name='id')
    data_source_name = sgqlc.types.Field(String, graphql_name='dataSourceName')
    name = sgqlc.types.Field(String, graphql_name='name')
    alias = sgqlc.types.Field(String, graphql_name='alias')
    description = sgqlc.types.Field(String, graphql_name='description')
    units = sgqlc.types.Field(String, graphql_name='units')
    expression = sgqlc.types.Field(String, graphql_name='expression')
    data_type = sgqlc.types.Field(String, graphql_name='dataType')
    created_at = sgqlc.types.Field(Datetime, graphql_name='createdAt')
    updated_at = sgqlc.types.Field(Datetime, graphql_name='updatedAt')
    formatted_expression = sgqlc.types.Field(String, graphql_name='formattedExpression')
    type = sgqlc.types.Field(DataPointType, graphql_name='type')
    frequency = sgqlc.types.Field(Int, graphql_name='frequency')
    location_type = sgqlc.types.Field(String, graphql_name='locationType')
    right_aligned = sgqlc.types.Field(Boolean, graphql_name='rightAligned')
    freshness_threshold_seconds = sgqlc.types.Field(Int, graphql_name='freshnessThresholdSeconds')
    has_alignment_correction = sgqlc.types.Field(Boolean, graphql_name='hasAlignmentCorrection')


class DataPointFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'data_source_name', 'name', 'alias', 'description', 'units', 'expression', 'data_type', 'created_at', 'updated_at', 'formatted_expression', 'type', 'frequency', 'location_type', 'right_aligned', 'freshness_threshold_seconds', 'data_source_display_name', 'has_alignment_correction', 'is_composite', 'and_', 'or_', 'not_')
    id = sgqlc.types.Field(BigIntFilter, graphql_name='id')
    data_source_name = sgqlc.types.Field('StringFilter', graphql_name='dataSourceName')
    name = sgqlc.types.Field('StringFilter', graphql_name='name')
    alias = sgqlc.types.Field('StringFilter', graphql_name='alias')
    description = sgqlc.types.Field('StringFilter', graphql_name='description')
    units = sgqlc.types.Field('StringFilter', graphql_name='units')
    expression = sgqlc.types.Field('StringFilter', graphql_name='expression')
    data_type = sgqlc.types.Field('StringFilter', graphql_name='dataType')
    created_at = sgqlc.types.Field('DatetimeFilter', graphql_name='createdAt')
    updated_at = sgqlc.types.Field('DatetimeFilter', graphql_name='updatedAt')
    formatted_expression = sgqlc.types.Field('StringFilter', graphql_name='formattedExpression')
    type = sgqlc.types.Field('DataPointTypeFilter', graphql_name='type')
    frequency = sgqlc.types.Field('IntFilter', graphql_name='frequency')
    location_type = sgqlc.types.Field('StringFilter', graphql_name='locationType')
    right_aligned = sgqlc.types.Field(BooleanFilter, graphql_name='rightAligned')
    freshness_threshold_seconds = sgqlc.types.Field('IntFilter', graphql_name='freshnessThresholdSeconds')
    data_source_display_name = sgqlc.types.Field('StringFilter', graphql_name='dataSourceDisplayName')
    has_alignment_correction = sgqlc.types.Field(BooleanFilter, graphql_name='hasAlignmentCorrection')
    is_composite = sgqlc.types.Field(BooleanFilter, graphql_name='isComposite')
    and_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('DataPointFilter')), graphql_name='and')
    or_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('DataPointFilter')), graphql_name='or')
    not_ = sgqlc.types.Field('DataPointFilter', graphql_name='not')


class DataPointInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('data_source_name', 'name', 'alias', 'description', 'units', 'expression', 'data_type', 'type', 'frequency', 'location_type', 'right_aligned', 'freshness_threshold_seconds', 'data_source')
    data_source_name = sgqlc.types.Field(String, graphql_name='dataSourceName')
    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='name')
    alias = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='alias')
    description = sgqlc.types.Field(String, graphql_name='description')
    units = sgqlc.types.Field(String, graphql_name='units')
    expression = sgqlc.types.Field(String, graphql_name='expression')
    data_type = sgqlc.types.Field(String, graphql_name='dataType')
    type = sgqlc.types.Field(DataPointType, graphql_name='type')
    frequency = sgqlc.types.Field(Int, graphql_name='frequency')
    location_type = sgqlc.types.Field(String, graphql_name='locationType')
    right_aligned = sgqlc.types.Field(Boolean, graphql_name='rightAligned')
    freshness_threshold_seconds = sgqlc.types.Field(Int, graphql_name='freshnessThresholdSeconds')
    data_source = sgqlc.types.Field('DataSourceInput', graphql_name='dataSource')


class DataPointPatch(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('alias', 'description', 'units', 'expression', 'data_type', 'type', 'frequency', 'location_type', 'right_aligned', 'freshness_threshold_seconds')
    alias = sgqlc.types.Field(String, graphql_name='alias')
    description = sgqlc.types.Field(String, graphql_name='description')
    units = sgqlc.types.Field(String, graphql_name='units')
    expression = sgqlc.types.Field(String, graphql_name='expression')
    data_type = sgqlc.types.Field(String, graphql_name='dataType')
    type = sgqlc.types.Field(DataPointType, graphql_name='type')
    frequency = sgqlc.types.Field(Int, graphql_name='frequency')
    location_type = sgqlc.types.Field(String, graphql_name='locationType')
    right_aligned = sgqlc.types.Field(Boolean, graphql_name='rightAligned')
    freshness_threshold_seconds = sgqlc.types.Field(Int, graphql_name='freshnessThresholdSeconds')


class DataPointTagCondition(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'name', 'created_at', 'updated_at')
    id = sgqlc.types.Field(Int, graphql_name='id')
    name = sgqlc.types.Field(String, graphql_name='name')
    created_at = sgqlc.types.Field(Datetime, graphql_name='createdAt')
    updated_at = sgqlc.types.Field(Datetime, graphql_name='updatedAt')


class DataPointTagFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'name', 'created_at', 'updated_at', 'and_', 'or_', 'not_')
    id = sgqlc.types.Field('IntFilter', graphql_name='id')
    name = sgqlc.types.Field('StringFilter', graphql_name='name')
    created_at = sgqlc.types.Field('DatetimeFilter', graphql_name='createdAt')
    updated_at = sgqlc.types.Field('DatetimeFilter', graphql_name='updatedAt')
    and_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('DataPointTagFilter')), graphql_name='and')
    or_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('DataPointTagFilter')), graphql_name='or')
    not_ = sgqlc.types.Field('DataPointTagFilter', graphql_name='not')


class DataPointTagInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('name', 'created_at', 'updated_at')
    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='name')
    created_at = sgqlc.types.Field(Datetime, graphql_name='createdAt')
    updated_at = sgqlc.types.Field(Datetime, graphql_name='updatedAt')


class DataPointTypeFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('is_null', 'equal_to', 'not_equal_to', 'distinct_from', 'not_distinct_from', 'in_', 'not_in', 'less_than', 'less_than_or_equal_to', 'greater_than', 'greater_than_or_equal_to')
    is_null = sgqlc.types.Field(Boolean, graphql_name='isNull')
    equal_to = sgqlc.types.Field(DataPointType, graphql_name='equalTo')
    not_equal_to = sgqlc.types.Field(DataPointType, graphql_name='notEqualTo')
    distinct_from = sgqlc.types.Field(DataPointType, graphql_name='distinctFrom')
    not_distinct_from = sgqlc.types.Field(DataPointType, graphql_name='notDistinctFrom')
    in_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(DataPointType)), graphql_name='in')
    not_in = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(DataPointType)), graphql_name='notIn')
    less_than = sgqlc.types.Field(DataPointType, graphql_name='lessThan')
    less_than_or_equal_to = sgqlc.types.Field(DataPointType, graphql_name='lessThanOrEqualTo')
    greater_than = sgqlc.types.Field(DataPointType, graphql_name='greaterThan')
    greater_than_or_equal_to = sgqlc.types.Field(DataPointType, graphql_name='greaterThanOrEqualTo')


class DataSourceCondition(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('name', 'description', 'created_at', 'updated_at', 'alias', 'critical_threshold', 'liveness_threshold_seconds')
    name = sgqlc.types.Field(String, graphql_name='name')
    description = sgqlc.types.Field(String, graphql_name='description')
    created_at = sgqlc.types.Field(Datetime, graphql_name='createdAt')
    updated_at = sgqlc.types.Field(Datetime, graphql_name='updatedAt')
    alias = sgqlc.types.Field(String, graphql_name='alias')
    critical_threshold = sgqlc.types.Field(Float, graphql_name='criticalThreshold')
    liveness_threshold_seconds = sgqlc.types.Field(Int, graphql_name='livenessThresholdSeconds')


class DataSourceFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('name', 'description', 'created_at', 'updated_at', 'alias', 'critical_threshold', 'liveness_threshold_seconds', 'display_name', 'and_', 'or_', 'not_')
    name = sgqlc.types.Field('StringFilter', graphql_name='name')
    description = sgqlc.types.Field('StringFilter', graphql_name='description')
    created_at = sgqlc.types.Field('DatetimeFilter', graphql_name='createdAt')
    updated_at = sgqlc.types.Field('DatetimeFilter', graphql_name='updatedAt')
    alias = sgqlc.types.Field('StringFilter', graphql_name='alias')
    critical_threshold = sgqlc.types.Field('FloatFilter', graphql_name='criticalThreshold')
    liveness_threshold_seconds = sgqlc.types.Field('IntFilter', graphql_name='livenessThresholdSeconds')
    display_name = sgqlc.types.Field('StringFilter', graphql_name='displayName')
    and_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('DataSourceFilter')), graphql_name='and')
    or_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('DataSourceFilter')), graphql_name='or')
    not_ = sgqlc.types.Field('DataSourceFilter', graphql_name='not')


class DataSourceInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('name', 'description', 'alias', 'critical_threshold', 'liveness_threshold_seconds')
    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='name')
    description = sgqlc.types.Field(String, graphql_name='description')
    alias = sgqlc.types.Field(String, graphql_name='alias')
    critical_threshold = sgqlc.types.Field(Float, graphql_name='criticalThreshold')
    liveness_threshold_seconds = sgqlc.types.Field(Int, graphql_name='livenessThresholdSeconds')


class DateFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('is_null', 'equal_to', 'not_equal_to', 'distinct_from', 'not_distinct_from', 'in_', 'not_in', 'less_than', 'less_than_or_equal_to', 'greater_than', 'greater_than_or_equal_to')
    is_null = sgqlc.types.Field(Boolean, graphql_name='isNull')
    equal_to = sgqlc.types.Field(Date, graphql_name='equalTo')
    not_equal_to = sgqlc.types.Field(Date, graphql_name='notEqualTo')
    distinct_from = sgqlc.types.Field(Date, graphql_name='distinctFrom')
    not_distinct_from = sgqlc.types.Field(Date, graphql_name='notDistinctFrom')
    in_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(Date)), graphql_name='in')
    not_in = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(Date)), graphql_name='notIn')
    less_than = sgqlc.types.Field(Date, graphql_name='lessThan')
    less_than_or_equal_to = sgqlc.types.Field(Date, graphql_name='lessThanOrEqualTo')
    greater_than = sgqlc.types.Field(Date, graphql_name='greaterThan')
    greater_than_or_equal_to = sgqlc.types.Field(Date, graphql_name='greaterThanOrEqualTo')


class DatetimeFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('is_null', 'equal_to', 'not_equal_to', 'distinct_from', 'not_distinct_from', 'in_', 'not_in', 'less_than', 'less_than_or_equal_to', 'greater_than', 'greater_than_or_equal_to')
    is_null = sgqlc.types.Field(Boolean, graphql_name='isNull')
    equal_to = sgqlc.types.Field(Datetime, graphql_name='equalTo')
    not_equal_to = sgqlc.types.Field(Datetime, graphql_name='notEqualTo')
    distinct_from = sgqlc.types.Field(Datetime, graphql_name='distinctFrom')
    not_distinct_from = sgqlc.types.Field(Datetime, graphql_name='notDistinctFrom')
    in_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(Datetime)), graphql_name='in')
    not_in = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(Datetime)), graphql_name='notIn')
    less_than = sgqlc.types.Field(Datetime, graphql_name='lessThan')
    less_than_or_equal_to = sgqlc.types.Field(Datetime, graphql_name='lessThanOrEqualTo')
    greater_than = sgqlc.types.Field(Datetime, graphql_name='greaterThan')
    greater_than_or_equal_to = sgqlc.types.Field(Datetime, graphql_name='greaterThanOrEqualTo')


class DeleteAccountChargeInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='id')


class DeleteAccountStatementInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='id')


class DeleteBalancingAuthorityByNodeIdInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'node_id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    node_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name='nodeId')


class DeleteBalancingAuthorityBySlugInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'slug')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    slug = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='slug')


class DeleteBalancingAuthorityInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='id')


class DeleteBuildingAreaByFacilityIdAndLabelInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'facility_id', 'label')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    facility_id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='facilityId')
    label = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='label')


class DeleteBuildingAreaByNodeIdInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'node_id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    node_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name='nodeId')


class DeleteBuildingAreaInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='id')


class DeleteBuildingAreaTypeByNodeIdInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'node_id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    node_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name='nodeId')


class DeleteBuildingAreaTypeInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'type')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    type = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='type')


class DeleteChartByNodeIdInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'node_id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    node_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name='nodeId')


class DeleteChartInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='id')


class DeleteComponentByNodeIdInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'node_id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    node_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name='nodeId')


class DeleteComponentInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='id')


class DeleteControlEventByNodeIdInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'node_id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    node_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name='nodeId')


class DeleteControlEventInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='id')


class DeleteControlEventLogByNodeIdInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'node_id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    node_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name='nodeId')


class DeleteControlEventLogInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='id')


class DeleteDashboardByNodeIdInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'node_id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    node_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name='nodeId')


class DeleteDashboardInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='id')


class DeleteDataPointByDataSourceNameAndNameInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'data_source_name', 'name')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    data_source_name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='dataSourceName')
    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='name')


class DeleteDataPointByNodeIdInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'node_id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    node_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name='nodeId')


class DeleteDataPointInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    id = sgqlc.types.Field(sgqlc.types.non_null(BigInt), graphql_name='id')


class DeleteDataSourceByNodeIdInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'node_id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    node_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name='nodeId')


class DeleteDataSourceInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'name')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='name')


class DeleteDependencyByNodeIdInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'node_id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    node_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name='nodeId')


class DeleteDependencyByPathInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'path')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    path = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='path')


class DeleteDependencyInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    id = sgqlc.types.Field(sgqlc.types.non_null(BigInt), graphql_name='id')


class DeleteFacilityByNodeIdInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'node_id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    node_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name='nodeId')


class DeleteFacilityBySlugInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'slug')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    slug = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='slug')


class DeleteFacilityConfigInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'facility_id', 'key')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    facility_id = sgqlc.types.Field(Int, graphql_name='facilityId')
    key = sgqlc.types.Field(String, graphql_name='key')


class DeleteFacilityDataSourceByNodeIdInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'node_id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    node_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name='nodeId')


class DeleteFacilityDataSourceInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'facility_id', 'data_source_name')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    facility_id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='facilityId')
    data_source_name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='dataSourceName')


class DeleteFacilityGroupByNodeIdInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'node_id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    node_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name='nodeId')


class DeleteFacilityGroupInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    id = sgqlc.types.Field(sgqlc.types.non_null(BigInt), graphql_name='id')


class DeleteFacilityGroupsLinkerByNodeIdInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'node_id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    node_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name='nodeId')


class DeleteFacilityGroupsLinkerInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'facility_id', 'facility_grouping_id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    facility_id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='facilityId')
    facility_grouping_id = sgqlc.types.Field(sgqlc.types.non_null(BigInt), graphql_name='facilityGroupingId')


class DeleteFacilityInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='id')


class DeleteFacilityTaggedDataPointByNodeIdInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'node_id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    node_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name='nodeId')


class DeleteFacilityTaggedDataPointInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='id')


class DeleteMachineUserByNodeIdInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'node_id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    node_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name='nodeId')


class DeleteMachineUserInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    id = sgqlc.types.Field(sgqlc.types.non_null(BigInt), graphql_name='id')


class DeleteMainServiceByFacilityIdAndNameInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'facility_id', 'name')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    facility_id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='facilityId')
    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='name')


class DeleteMainServiceByFacilityIdAndUsageDataPointIdAndDemandDataPointIdInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'facility_id', 'usage_data_point_id', 'demand_data_point_id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    facility_id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='facilityId')
    usage_data_point_id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='usageDataPointId')
    demand_data_point_id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='demandDataPointId')


class DeleteMainServiceByNodeIdInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'node_id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    node_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name='nodeId')


class DeleteMainServiceInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='id')


class DeleteMeterChargeInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='id')


class DeleteMeterStatementInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='id')


class DeleteMeterUsageInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='id')


class DeleteMonitorByNameInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'name')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='name')


class DeleteMonitorByNodeIdInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'node_id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    node_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name='nodeId')


class DeleteMonitorDataPointByNodeIdInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'node_id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    node_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name='nodeId')


class DeleteMonitorDataPointInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'monitor_id', 'data_point_id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    monitor_id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='monitorId')
    data_point_id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='dataPointId')


class DeleteMonitorDetectionByNodeIdInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'node_id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    node_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name='nodeId')


class DeleteMonitorDetectionInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    id = sgqlc.types.Field(sgqlc.types.non_null(BigInt), graphql_name='id')


class DeleteMonitorInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='id')


class DeletePhoneNumberInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id',)
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')


class DeletePricingNodeByNodeIdInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'node_id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    node_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name='nodeId')


class DeletePricingNodeInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='id')


class DeleteProgramByNodeIdInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'node_id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    node_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name='nodeId')


class DeleteProgramByProjectTypeIdAndNameInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'project_type_id', 'name')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    project_type_id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='projectTypeId')
    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='name')


class DeleteProgramEnrollmentByNodeIdInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'node_id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    node_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name='nodeId')


class DeleteProgramEnrollmentByProgramIdAndNameInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'program_id', 'name')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    program_id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='programId')
    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='name')


class DeleteProgramEnrollmentInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='id')


class DeleteProgramInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='id')


class DeleteProjectByFacilityIdAndProgramIdInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'facility_id', 'program_id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    facility_id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='facilityId')
    program_id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='programId')


class DeleteProjectByNodeIdInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'node_id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    node_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name='nodeId')


class DeleteProjectComponentByNodeIdInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'node_id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    node_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name='nodeId')


class DeleteProjectComponentInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'project_id', 'component_id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    project_id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='projectId')
    component_id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='componentId')


class DeleteProjectConfigInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'project_id', 'key')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    project_id = sgqlc.types.Field(Int, graphql_name='projectId')
    key = sgqlc.types.Field(String, graphql_name='key')


class DeleteProjectEnrollmentByNodeIdInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'node_id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    node_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name='nodeId')


class DeleteProjectEnrollmentByProjectIdAndProgramEnrollmentIdInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'project_id', 'program_enrollment_id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    project_id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='projectId')
    program_enrollment_id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='programEnrollmentId')


class DeleteProjectEnrollmentDataPointByNodeIdInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'node_id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    node_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name='nodeId')


class DeleteProjectEnrollmentDataPointByProjectEnrollmentIdAndDataPointIdInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'project_enrollment_id', 'data_point_id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    project_enrollment_id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='projectEnrollmentId')
    data_point_id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='dataPointId')


class DeleteProjectEnrollmentDataPointGroupByNodeIdInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'node_id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    node_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name='nodeId')


class DeleteProjectEnrollmentDataPointGroupInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='id')


class DeleteProjectEnrollmentDataPointInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='id')


class DeleteProjectEnrollmentInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='id')


class DeleteProjectInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='id')


class DeleteProjectWatcherByNodeIdInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'node_id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    node_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name='nodeId')


class DeleteProjectWatcherInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'project_id', 'user_id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    project_id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='projectId')
    user_id = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='userId')


class DeleteReportExecutionByNodeIdInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'node_id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    node_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name='nodeId')


class DeleteReportExecutionInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='id')


class DeleteSavingsEventByNodeIdInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'node_id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    node_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name='nodeId')


class DeleteSavingsEventByProjectIdAndStartTimeAndEndTimeInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'project_id', 'start_time', 'end_time')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    project_id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='projectId')
    start_time = sgqlc.types.Field(sgqlc.types.non_null(Datetime), graphql_name='startTime')
    end_time = sgqlc.types.Field(sgqlc.types.non_null(Datetime), graphql_name='endTime')


class DeleteSavingsEventInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='id')


class DeleteSuggestionControlEventByControlEventIdInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'control_event_id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    control_event_id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='controlEventId')


class DeleteSuggestionControlEventByNodeIdInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'node_id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    node_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name='nodeId')


class DeleteSuggestionControlEventInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'suggestion_id', 'control_event_id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    suggestion_id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='suggestionId')
    control_event_id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='controlEventId')


class DeleteUserByNodeIdInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'node_id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    node_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name='nodeId')


class DeleteUserInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    id = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='id')


class DeleteUtilityAccountInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='id')


class DeleteUtilityMeterInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='id')


class DeleteUtilityProviderByNameInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'name')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='name')


class DeleteUtilityProviderByNodeIdInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'node_id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    node_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name='nodeId')


class DeleteUtilityProviderInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='id')


class DeleteVendorUserByEmailInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'email')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    email = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='email')


class DeleteVendorUserByNodeIdInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'node_id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    node_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name='nodeId')


class DeleteVendorUserInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='id')


class DeleteVendorUserMachineUserByMachineUserIdInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'machine_user_id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    machine_user_id = sgqlc.types.Field(sgqlc.types.non_null(BigInt), graphql_name='machineUserId')


class DeleteVendorUserMachineUserByNodeIdInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'node_id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    node_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name='nodeId')


class DeleteVendorUserMachineUserInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'vendor_user_id', 'machine_user_id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    vendor_user_id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='vendorUserId')
    machine_user_id = sgqlc.types.Field(sgqlc.types.non_null(BigInt), graphql_name='machineUserId')


class DeleteVirtualPointIntervalByNodeIdInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'node_id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    node_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name='nodeId')


class DeleteVirtualPointIntervalInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'parent_id', 'child_id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    parent_id = sgqlc.types.Field(sgqlc.types.non_null(BigInt), graphql_name='parentId')
    child_id = sgqlc.types.Field(sgqlc.types.non_null(BigInt), graphql_name='childId')


class DependencyCondition(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'name', 'type', 'path')
    id = sgqlc.types.Field(BigInt, graphql_name='id')
    name = sgqlc.types.Field(String, graphql_name='name')
    type = sgqlc.types.Field(String, graphql_name='type')
    path = sgqlc.types.Field(String, graphql_name='path')


class DependencyFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'name', 'type', 'and_', 'or_', 'not_')
    id = sgqlc.types.Field(BigIntFilter, graphql_name='id')
    name = sgqlc.types.Field('StringFilter', graphql_name='name')
    type = sgqlc.types.Field('StringFilter', graphql_name='type')
    and_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('DependencyFilter')), graphql_name='and')
    or_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('DependencyFilter')), graphql_name='or')
    not_ = sgqlc.types.Field('DependencyFilter', graphql_name='not')


class DependencyInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('name', 'type', 'path')
    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='name')
    type = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='type')
    path = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='path')


class DependencyPatch(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('name', 'type', 'path')
    name = sgqlc.types.Field(String, graphql_name='name')
    type = sgqlc.types.Field(String, graphql_name='type')
    path = sgqlc.types.Field(String, graphql_name='path')


class FacilitiesHavingAverageFacilitiesActiveMeterDatesCountArgsInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('meter_service_types', 'from_', 'to')
    meter_service_types = sgqlc.types.Field(sgqlc.types.list_of(UtilityMeterServiceType), graphql_name='meterServiceTypes')
    from_ = sgqlc.types.Field(String, graphql_name='from')
    to = sgqlc.types.Field(String, graphql_name='to')


class FacilitiesHavingAverageFacilitiesActiveMeterDatesCountInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('args', 'filter')
    args = sgqlc.types.Field(FacilitiesHavingAverageFacilitiesActiveMeterDatesCountArgsInput, graphql_name='args')
    filter = sgqlc.types.Field('HavingIntFilter', graphql_name='filter')


class FacilitiesHavingAverageInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'created_at', 'updated_at', 'retired_at', 'pricing_node_id', 'go_live_date', 'customer_location_id', 'latitude', 'longitude', 'active_meter_dates_count')
    id = sgqlc.types.Field('HavingIntFilter', graphql_name='id')
    created_at = sgqlc.types.Field('HavingDatetimeFilter', graphql_name='createdAt')
    updated_at = sgqlc.types.Field('HavingDatetimeFilter', graphql_name='updatedAt')
    retired_at = sgqlc.types.Field('HavingDatetimeFilter', graphql_name='retiredAt')
    pricing_node_id = sgqlc.types.Field('HavingIntFilter', graphql_name='pricingNodeId')
    go_live_date = sgqlc.types.Field('HavingDatetimeFilter', graphql_name='goLiveDate')
    customer_location_id = sgqlc.types.Field('HavingIntFilter', graphql_name='customerLocationId')
    latitude = sgqlc.types.Field('HavingFloatFilter', graphql_name='latitude')
    longitude = sgqlc.types.Field('HavingFloatFilter', graphql_name='longitude')
    active_meter_dates_count = sgqlc.types.Field(FacilitiesHavingAverageFacilitiesActiveMeterDatesCountInput, graphql_name='activeMeterDatesCount')


class FacilitiesHavingDistinctCountFacilitiesActiveMeterDatesCountArgsInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('meter_service_types', 'from_', 'to')
    meter_service_types = sgqlc.types.Field(sgqlc.types.list_of(UtilityMeterServiceType), graphql_name='meterServiceTypes')
    from_ = sgqlc.types.Field(String, graphql_name='from')
    to = sgqlc.types.Field(String, graphql_name='to')


class FacilitiesHavingDistinctCountFacilitiesActiveMeterDatesCountInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('args', 'filter')
    args = sgqlc.types.Field(FacilitiesHavingDistinctCountFacilitiesActiveMeterDatesCountArgsInput, graphql_name='args')
    filter = sgqlc.types.Field('HavingIntFilter', graphql_name='filter')


class FacilitiesHavingDistinctCountInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'created_at', 'updated_at', 'retired_at', 'pricing_node_id', 'go_live_date', 'customer_location_id', 'latitude', 'longitude', 'active_meter_dates_count')
    id = sgqlc.types.Field('HavingIntFilter', graphql_name='id')
    created_at = sgqlc.types.Field('HavingDatetimeFilter', graphql_name='createdAt')
    updated_at = sgqlc.types.Field('HavingDatetimeFilter', graphql_name='updatedAt')
    retired_at = sgqlc.types.Field('HavingDatetimeFilter', graphql_name='retiredAt')
    pricing_node_id = sgqlc.types.Field('HavingIntFilter', graphql_name='pricingNodeId')
    go_live_date = sgqlc.types.Field('HavingDatetimeFilter', graphql_name='goLiveDate')
    customer_location_id = sgqlc.types.Field('HavingIntFilter', graphql_name='customerLocationId')
    latitude = sgqlc.types.Field('HavingFloatFilter', graphql_name='latitude')
    longitude = sgqlc.types.Field('HavingFloatFilter', graphql_name='longitude')
    active_meter_dates_count = sgqlc.types.Field(FacilitiesHavingDistinctCountFacilitiesActiveMeterDatesCountInput, graphql_name='activeMeterDatesCount')


class FacilitiesHavingDistinctFacilitiesActiveMeterDatesCountArgsInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('meter_service_types', 'from_', 'to')
    meter_service_types = sgqlc.types.Field(sgqlc.types.list_of(UtilityMeterServiceType), graphql_name='meterServiceTypes')
    from_ = sgqlc.types.Field(String, graphql_name='from')
    to = sgqlc.types.Field(String, graphql_name='to')


class FacilitiesHavingDistinctFacilitiesActiveMeterDatesCountInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('args', 'filter')
    args = sgqlc.types.Field(FacilitiesHavingDistinctFacilitiesActiveMeterDatesCountArgsInput, graphql_name='args')
    filter = sgqlc.types.Field('HavingIntFilter', graphql_name='filter')


class FacilitiesHavingDistinctInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'created_at', 'updated_at', 'retired_at', 'pricing_node_id', 'go_live_date', 'customer_location_id', 'latitude', 'longitude', 'active_meter_dates_count')
    id = sgqlc.types.Field('HavingIntFilter', graphql_name='id')
    created_at = sgqlc.types.Field('HavingDatetimeFilter', graphql_name='createdAt')
    updated_at = sgqlc.types.Field('HavingDatetimeFilter', graphql_name='updatedAt')
    retired_at = sgqlc.types.Field('HavingDatetimeFilter', graphql_name='retiredAt')
    pricing_node_id = sgqlc.types.Field('HavingIntFilter', graphql_name='pricingNodeId')
    go_live_date = sgqlc.types.Field('HavingDatetimeFilter', graphql_name='goLiveDate')
    customer_location_id = sgqlc.types.Field('HavingIntFilter', graphql_name='customerLocationId')
    latitude = sgqlc.types.Field('HavingFloatFilter', graphql_name='latitude')
    longitude = sgqlc.types.Field('HavingFloatFilter', graphql_name='longitude')
    active_meter_dates_count = sgqlc.types.Field(FacilitiesHavingDistinctFacilitiesActiveMeterDatesCountInput, graphql_name='activeMeterDatesCount')


class FacilitiesHavingInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('and_', 'or_', 'sum', 'distinct_count', 'min', 'max', 'average', 'stddev_sample', 'stddev_population', 'variance_sample', 'variance_population', 'distinct')
    and_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('FacilitiesHavingInput')), graphql_name='AND')
    or_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('FacilitiesHavingInput')), graphql_name='OR')
    sum = sgqlc.types.Field('FacilitiesHavingSumInput', graphql_name='sum')
    distinct_count = sgqlc.types.Field(FacilitiesHavingDistinctCountInput, graphql_name='distinctCount')
    min = sgqlc.types.Field('FacilitiesHavingMinInput', graphql_name='min')
    max = sgqlc.types.Field('FacilitiesHavingMaxInput', graphql_name='max')
    average = sgqlc.types.Field(FacilitiesHavingAverageInput, graphql_name='average')
    stddev_sample = sgqlc.types.Field('FacilitiesHavingStddevSampleInput', graphql_name='stddevSample')
    stddev_population = sgqlc.types.Field('FacilitiesHavingStddevPopulationInput', graphql_name='stddevPopulation')
    variance_sample = sgqlc.types.Field('FacilitiesHavingVarianceSampleInput', graphql_name='varianceSample')
    variance_population = sgqlc.types.Field('FacilitiesHavingVariancePopulationInput', graphql_name='variancePopulation')
    distinct = sgqlc.types.Field(FacilitiesHavingDistinctInput, graphql_name='distinct')


class FacilitiesHavingMaxFacilitiesActiveMeterDatesCountArgsInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('meter_service_types', 'from_', 'to')
    meter_service_types = sgqlc.types.Field(sgqlc.types.list_of(UtilityMeterServiceType), graphql_name='meterServiceTypes')
    from_ = sgqlc.types.Field(String, graphql_name='from')
    to = sgqlc.types.Field(String, graphql_name='to')


class FacilitiesHavingMaxFacilitiesActiveMeterDatesCountInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('args', 'filter')
    args = sgqlc.types.Field(FacilitiesHavingMaxFacilitiesActiveMeterDatesCountArgsInput, graphql_name='args')
    filter = sgqlc.types.Field('HavingIntFilter', graphql_name='filter')


class FacilitiesHavingMaxInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'created_at', 'updated_at', 'retired_at', 'pricing_node_id', 'go_live_date', 'customer_location_id', 'latitude', 'longitude', 'active_meter_dates_count')
    id = sgqlc.types.Field('HavingIntFilter', graphql_name='id')
    created_at = sgqlc.types.Field('HavingDatetimeFilter', graphql_name='createdAt')
    updated_at = sgqlc.types.Field('HavingDatetimeFilter', graphql_name='updatedAt')
    retired_at = sgqlc.types.Field('HavingDatetimeFilter', graphql_name='retiredAt')
    pricing_node_id = sgqlc.types.Field('HavingIntFilter', graphql_name='pricingNodeId')
    go_live_date = sgqlc.types.Field('HavingDatetimeFilter', graphql_name='goLiveDate')
    customer_location_id = sgqlc.types.Field('HavingIntFilter', graphql_name='customerLocationId')
    latitude = sgqlc.types.Field('HavingFloatFilter', graphql_name='latitude')
    longitude = sgqlc.types.Field('HavingFloatFilter', graphql_name='longitude')
    active_meter_dates_count = sgqlc.types.Field(FacilitiesHavingMaxFacilitiesActiveMeterDatesCountInput, graphql_name='activeMeterDatesCount')


class FacilitiesHavingMinFacilitiesActiveMeterDatesCountArgsInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('meter_service_types', 'from_', 'to')
    meter_service_types = sgqlc.types.Field(sgqlc.types.list_of(UtilityMeterServiceType), graphql_name='meterServiceTypes')
    from_ = sgqlc.types.Field(String, graphql_name='from')
    to = sgqlc.types.Field(String, graphql_name='to')


class FacilitiesHavingMinFacilitiesActiveMeterDatesCountInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('args', 'filter')
    args = sgqlc.types.Field(FacilitiesHavingMinFacilitiesActiveMeterDatesCountArgsInput, graphql_name='args')
    filter = sgqlc.types.Field('HavingIntFilter', graphql_name='filter')


class FacilitiesHavingMinInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'created_at', 'updated_at', 'retired_at', 'pricing_node_id', 'go_live_date', 'customer_location_id', 'latitude', 'longitude', 'active_meter_dates_count')
    id = sgqlc.types.Field('HavingIntFilter', graphql_name='id')
    created_at = sgqlc.types.Field('HavingDatetimeFilter', graphql_name='createdAt')
    updated_at = sgqlc.types.Field('HavingDatetimeFilter', graphql_name='updatedAt')
    retired_at = sgqlc.types.Field('HavingDatetimeFilter', graphql_name='retiredAt')
    pricing_node_id = sgqlc.types.Field('HavingIntFilter', graphql_name='pricingNodeId')
    go_live_date = sgqlc.types.Field('HavingDatetimeFilter', graphql_name='goLiveDate')
    customer_location_id = sgqlc.types.Field('HavingIntFilter', graphql_name='customerLocationId')
    latitude = sgqlc.types.Field('HavingFloatFilter', graphql_name='latitude')
    longitude = sgqlc.types.Field('HavingFloatFilter', graphql_name='longitude')
    active_meter_dates_count = sgqlc.types.Field(FacilitiesHavingMinFacilitiesActiveMeterDatesCountInput, graphql_name='activeMeterDatesCount')


class FacilitiesHavingStddevPopulationFacilitiesActiveMeterDatesCountArgsInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('meter_service_types', 'from_', 'to')
    meter_service_types = sgqlc.types.Field(sgqlc.types.list_of(UtilityMeterServiceType), graphql_name='meterServiceTypes')
    from_ = sgqlc.types.Field(String, graphql_name='from')
    to = sgqlc.types.Field(String, graphql_name='to')


class FacilitiesHavingStddevPopulationFacilitiesActiveMeterDatesCountInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('args', 'filter')
    args = sgqlc.types.Field(FacilitiesHavingStddevPopulationFacilitiesActiveMeterDatesCountArgsInput, graphql_name='args')
    filter = sgqlc.types.Field('HavingIntFilter', graphql_name='filter')


class FacilitiesHavingStddevPopulationInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'created_at', 'updated_at', 'retired_at', 'pricing_node_id', 'go_live_date', 'customer_location_id', 'latitude', 'longitude', 'active_meter_dates_count')
    id = sgqlc.types.Field('HavingIntFilter', graphql_name='id')
    created_at = sgqlc.types.Field('HavingDatetimeFilter', graphql_name='createdAt')
    updated_at = sgqlc.types.Field('HavingDatetimeFilter', graphql_name='updatedAt')
    retired_at = sgqlc.types.Field('HavingDatetimeFilter', graphql_name='retiredAt')
    pricing_node_id = sgqlc.types.Field('HavingIntFilter', graphql_name='pricingNodeId')
    go_live_date = sgqlc.types.Field('HavingDatetimeFilter', graphql_name='goLiveDate')
    customer_location_id = sgqlc.types.Field('HavingIntFilter', graphql_name='customerLocationId')
    latitude = sgqlc.types.Field('HavingFloatFilter', graphql_name='latitude')
    longitude = sgqlc.types.Field('HavingFloatFilter', graphql_name='longitude')
    active_meter_dates_count = sgqlc.types.Field(FacilitiesHavingStddevPopulationFacilitiesActiveMeterDatesCountInput, graphql_name='activeMeterDatesCount')


class FacilitiesHavingStddevSampleFacilitiesActiveMeterDatesCountArgsInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('meter_service_types', 'from_', 'to')
    meter_service_types = sgqlc.types.Field(sgqlc.types.list_of(UtilityMeterServiceType), graphql_name='meterServiceTypes')
    from_ = sgqlc.types.Field(String, graphql_name='from')
    to = sgqlc.types.Field(String, graphql_name='to')


class FacilitiesHavingStddevSampleFacilitiesActiveMeterDatesCountInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('args', 'filter')
    args = sgqlc.types.Field(FacilitiesHavingStddevSampleFacilitiesActiveMeterDatesCountArgsInput, graphql_name='args')
    filter = sgqlc.types.Field('HavingIntFilter', graphql_name='filter')


class FacilitiesHavingStddevSampleInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'created_at', 'updated_at', 'retired_at', 'pricing_node_id', 'go_live_date', 'customer_location_id', 'latitude', 'longitude', 'active_meter_dates_count')
    id = sgqlc.types.Field('HavingIntFilter', graphql_name='id')
    created_at = sgqlc.types.Field('HavingDatetimeFilter', graphql_name='createdAt')
    updated_at = sgqlc.types.Field('HavingDatetimeFilter', graphql_name='updatedAt')
    retired_at = sgqlc.types.Field('HavingDatetimeFilter', graphql_name='retiredAt')
    pricing_node_id = sgqlc.types.Field('HavingIntFilter', graphql_name='pricingNodeId')
    go_live_date = sgqlc.types.Field('HavingDatetimeFilter', graphql_name='goLiveDate')
    customer_location_id = sgqlc.types.Field('HavingIntFilter', graphql_name='customerLocationId')
    latitude = sgqlc.types.Field('HavingFloatFilter', graphql_name='latitude')
    longitude = sgqlc.types.Field('HavingFloatFilter', graphql_name='longitude')
    active_meter_dates_count = sgqlc.types.Field(FacilitiesHavingStddevSampleFacilitiesActiveMeterDatesCountInput, graphql_name='activeMeterDatesCount')


class FacilitiesHavingSumFacilitiesActiveMeterDatesCountArgsInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('meter_service_types', 'from_', 'to')
    meter_service_types = sgqlc.types.Field(sgqlc.types.list_of(UtilityMeterServiceType), graphql_name='meterServiceTypes')
    from_ = sgqlc.types.Field(String, graphql_name='from')
    to = sgqlc.types.Field(String, graphql_name='to')


class FacilitiesHavingSumFacilitiesActiveMeterDatesCountInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('args', 'filter')
    args = sgqlc.types.Field(FacilitiesHavingSumFacilitiesActiveMeterDatesCountArgsInput, graphql_name='args')
    filter = sgqlc.types.Field('HavingIntFilter', graphql_name='filter')


class FacilitiesHavingSumInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'created_at', 'updated_at', 'retired_at', 'pricing_node_id', 'go_live_date', 'customer_location_id', 'latitude', 'longitude', 'active_meter_dates_count')
    id = sgqlc.types.Field('HavingIntFilter', graphql_name='id')
    created_at = sgqlc.types.Field('HavingDatetimeFilter', graphql_name='createdAt')
    updated_at = sgqlc.types.Field('HavingDatetimeFilter', graphql_name='updatedAt')
    retired_at = sgqlc.types.Field('HavingDatetimeFilter', graphql_name='retiredAt')
    pricing_node_id = sgqlc.types.Field('HavingIntFilter', graphql_name='pricingNodeId')
    go_live_date = sgqlc.types.Field('HavingDatetimeFilter', graphql_name='goLiveDate')
    customer_location_id = sgqlc.types.Field('HavingIntFilter', graphql_name='customerLocationId')
    latitude = sgqlc.types.Field('HavingFloatFilter', graphql_name='latitude')
    longitude = sgqlc.types.Field('HavingFloatFilter', graphql_name='longitude')
    active_meter_dates_count = sgqlc.types.Field(FacilitiesHavingSumFacilitiesActiveMeterDatesCountInput, graphql_name='activeMeterDatesCount')


class FacilitiesHavingVariancePopulationFacilitiesActiveMeterDatesCountArgsInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('meter_service_types', 'from_', 'to')
    meter_service_types = sgqlc.types.Field(sgqlc.types.list_of(UtilityMeterServiceType), graphql_name='meterServiceTypes')
    from_ = sgqlc.types.Field(String, graphql_name='from')
    to = sgqlc.types.Field(String, graphql_name='to')


class FacilitiesHavingVariancePopulationFacilitiesActiveMeterDatesCountInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('args', 'filter')
    args = sgqlc.types.Field(FacilitiesHavingVariancePopulationFacilitiesActiveMeterDatesCountArgsInput, graphql_name='args')
    filter = sgqlc.types.Field('HavingIntFilter', graphql_name='filter')


class FacilitiesHavingVariancePopulationInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'created_at', 'updated_at', 'retired_at', 'pricing_node_id', 'go_live_date', 'customer_location_id', 'latitude', 'longitude', 'active_meter_dates_count')
    id = sgqlc.types.Field('HavingIntFilter', graphql_name='id')
    created_at = sgqlc.types.Field('HavingDatetimeFilter', graphql_name='createdAt')
    updated_at = sgqlc.types.Field('HavingDatetimeFilter', graphql_name='updatedAt')
    retired_at = sgqlc.types.Field('HavingDatetimeFilter', graphql_name='retiredAt')
    pricing_node_id = sgqlc.types.Field('HavingIntFilter', graphql_name='pricingNodeId')
    go_live_date = sgqlc.types.Field('HavingDatetimeFilter', graphql_name='goLiveDate')
    customer_location_id = sgqlc.types.Field('HavingIntFilter', graphql_name='customerLocationId')
    latitude = sgqlc.types.Field('HavingFloatFilter', graphql_name='latitude')
    longitude = sgqlc.types.Field('HavingFloatFilter', graphql_name='longitude')
    active_meter_dates_count = sgqlc.types.Field(FacilitiesHavingVariancePopulationFacilitiesActiveMeterDatesCountInput, graphql_name='activeMeterDatesCount')


class FacilitiesHavingVarianceSampleFacilitiesActiveMeterDatesCountArgsInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('meter_service_types', 'from_', 'to')
    meter_service_types = sgqlc.types.Field(sgqlc.types.list_of(UtilityMeterServiceType), graphql_name='meterServiceTypes')
    from_ = sgqlc.types.Field(String, graphql_name='from')
    to = sgqlc.types.Field(String, graphql_name='to')


class FacilitiesHavingVarianceSampleFacilitiesActiveMeterDatesCountInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('args', 'filter')
    args = sgqlc.types.Field(FacilitiesHavingVarianceSampleFacilitiesActiveMeterDatesCountArgsInput, graphql_name='args')
    filter = sgqlc.types.Field('HavingIntFilter', graphql_name='filter')


class FacilitiesHavingVarianceSampleInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'created_at', 'updated_at', 'retired_at', 'pricing_node_id', 'go_live_date', 'customer_location_id', 'latitude', 'longitude', 'active_meter_dates_count')
    id = sgqlc.types.Field('HavingIntFilter', graphql_name='id')
    created_at = sgqlc.types.Field('HavingDatetimeFilter', graphql_name='createdAt')
    updated_at = sgqlc.types.Field('HavingDatetimeFilter', graphql_name='updatedAt')
    retired_at = sgqlc.types.Field('HavingDatetimeFilter', graphql_name='retiredAt')
    pricing_node_id = sgqlc.types.Field('HavingIntFilter', graphql_name='pricingNodeId')
    go_live_date = sgqlc.types.Field('HavingDatetimeFilter', graphql_name='goLiveDate')
    customer_location_id = sgqlc.types.Field('HavingIntFilter', graphql_name='customerLocationId')
    latitude = sgqlc.types.Field('HavingFloatFilter', graphql_name='latitude')
    longitude = sgqlc.types.Field('HavingFloatFilter', graphql_name='longitude')
    active_meter_dates_count = sgqlc.types.Field(FacilitiesHavingVarianceSampleFacilitiesActiveMeterDatesCountInput, graphql_name='activeMeterDatesCount')


class FacilityCommunicationCondition(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'facility_id', 'message', 'cleared_at', 'created_at', 'updated_at')
    id = sgqlc.types.Field(Int, graphql_name='id')
    facility_id = sgqlc.types.Field(Int, graphql_name='facilityId')
    message = sgqlc.types.Field(String, graphql_name='message')
    cleared_at = sgqlc.types.Field(Datetime, graphql_name='clearedAt')
    created_at = sgqlc.types.Field(Datetime, graphql_name='createdAt')
    updated_at = sgqlc.types.Field(Datetime, graphql_name='updatedAt')


class FacilityCommunicationFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'facility_id', 'message', 'cleared_at', 'created_at', 'updated_at', 'is_cleared', 'and_', 'or_', 'not_')
    id = sgqlc.types.Field('IntFilter', graphql_name='id')
    facility_id = sgqlc.types.Field('IntFilter', graphql_name='facilityId')
    message = sgqlc.types.Field('StringFilter', graphql_name='message')
    cleared_at = sgqlc.types.Field(DatetimeFilter, graphql_name='clearedAt')
    created_at = sgqlc.types.Field(DatetimeFilter, graphql_name='createdAt')
    updated_at = sgqlc.types.Field(DatetimeFilter, graphql_name='updatedAt')
    is_cleared = sgqlc.types.Field(BooleanFilter, graphql_name='isCleared')
    and_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('FacilityCommunicationFilter')), graphql_name='and')
    or_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('FacilityCommunicationFilter')), graphql_name='or')
    not_ = sgqlc.types.Field('FacilityCommunicationFilter', graphql_name='not')


class FacilityCommunicationInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'facility_id', 'message')
    id = sgqlc.types.Field(Int, graphql_name='id')
    facility_id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='facilityId')
    message = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='message')


class FacilityCondition(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'name', 'slug', 'address', 'city', 'state', 'zip', 'created_at', 'updated_at', 'timezone_name', 'unit_group', 'country', 'geometry', 'retired_at', 'pricing_node_id', 'bonus_ltr', 'commodity', 'go_live_date', 'link_active', 'metrics_one_active', 'pre_bonus_ebitda', 'suppresse_financials', 'type', 'wms', 'cost_center', 'customer_location_id', 'facility_contacts', 'latitude', 'longitude', 'n_sight2_active', 'n_sight_active', 'real_time_enabled', 'config', 'has_solar')
    id = sgqlc.types.Field(Int, graphql_name='id')
    name = sgqlc.types.Field(String, graphql_name='name')
    slug = sgqlc.types.Field(String, graphql_name='slug')
    address = sgqlc.types.Field(String, graphql_name='address')
    city = sgqlc.types.Field(String, graphql_name='city')
    state = sgqlc.types.Field(String, graphql_name='state')
    zip = sgqlc.types.Field(String, graphql_name='zip')
    created_at = sgqlc.types.Field(Datetime, graphql_name='createdAt')
    updated_at = sgqlc.types.Field(Datetime, graphql_name='updatedAt')
    timezone_name = sgqlc.types.Field(String, graphql_name='timezoneName')
    unit_group = sgqlc.types.Field(String, graphql_name='unitGroup')
    country = sgqlc.types.Field(Country, graphql_name='country')
    geometry = sgqlc.types.Field(GeoJSON, graphql_name='geometry')
    retired_at = sgqlc.types.Field(Datetime, graphql_name='retiredAt')
    pricing_node_id = sgqlc.types.Field(Int, graphql_name='pricingNodeId')
    bonus_ltr = sgqlc.types.Field(Boolean, graphql_name='bonusLtr')
    commodity = sgqlc.types.Field(String, graphql_name='commodity')
    go_live_date = sgqlc.types.Field(Datetime, graphql_name='goLiveDate')
    link_active = sgqlc.types.Field(Boolean, graphql_name='linkActive')
    metrics_one_active = sgqlc.types.Field(Boolean, graphql_name='metricsOneActive')
    pre_bonus_ebitda = sgqlc.types.Field(Boolean, graphql_name='preBonusEbitda')
    suppresse_financials = sgqlc.types.Field(Boolean, graphql_name='suppresseFinancials')
    type = sgqlc.types.Field(String, graphql_name='type')
    wms = sgqlc.types.Field(String, graphql_name='wms')
    cost_center = sgqlc.types.Field(String, graphql_name='costCenter')
    customer_location_id = sgqlc.types.Field(Int, graphql_name='customerLocationId')
    facility_contacts = sgqlc.types.Field(String, graphql_name='facilityContacts')
    latitude = sgqlc.types.Field(Float, graphql_name='latitude')
    longitude = sgqlc.types.Field(Float, graphql_name='longitude')
    n_sight2_active = sgqlc.types.Field(Boolean, graphql_name='nSight2Active')
    n_sight_active = sgqlc.types.Field(Boolean, graphql_name='nSightActive')
    real_time_enabled = sgqlc.types.Field(Boolean, graphql_name='realTimeEnabled')
    config = sgqlc.types.Field(JSON, graphql_name='config')
    has_solar = sgqlc.types.Field(Boolean, graphql_name='hasSolar')


class FacilityConfigCondition(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'facility_id', 'key', 'value', 'created_at', 'updated_at')
    id = sgqlc.types.Field(Int, graphql_name='id')
    facility_id = sgqlc.types.Field(Int, graphql_name='facilityId')
    key = sgqlc.types.Field(String, graphql_name='key')
    value = sgqlc.types.Field(JSON, graphql_name='value')
    created_at = sgqlc.types.Field(Datetime, graphql_name='createdAt')
    updated_at = sgqlc.types.Field(Datetime, graphql_name='updatedAt')


class FacilityConfigFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'facility_id', 'key', 'value', 'created_at', 'updated_at', 'and_', 'or_', 'not_')
    id = sgqlc.types.Field('IntFilter', graphql_name='id')
    facility_id = sgqlc.types.Field('IntFilter', graphql_name='facilityId')
    key = sgqlc.types.Field('StringFilter', graphql_name='key')
    value = sgqlc.types.Field('JSONFilter', graphql_name='value')
    created_at = sgqlc.types.Field(DatetimeFilter, graphql_name='createdAt')
    updated_at = sgqlc.types.Field(DatetimeFilter, graphql_name='updatedAt')
    and_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('FacilityConfigFilter')), graphql_name='and')
    or_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('FacilityConfigFilter')), graphql_name='or')
    not_ = sgqlc.types.Field('FacilityConfigFilter', graphql_name='not')


class FacilityDataSourceCondition(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('facility_id', 'data_source_name')
    facility_id = sgqlc.types.Field(Int, graphql_name='facilityId')
    data_source_name = sgqlc.types.Field(String, graphql_name='dataSourceName')


class FacilityDataSourceFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('facility_id', 'data_source_name', 'and_', 'or_', 'not_')
    facility_id = sgqlc.types.Field('IntFilter', graphql_name='facilityId')
    data_source_name = sgqlc.types.Field('StringFilter', graphql_name='dataSourceName')
    and_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('FacilityDataSourceFilter')), graphql_name='and')
    or_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('FacilityDataSourceFilter')), graphql_name='or')
    not_ = sgqlc.types.Field('FacilityDataSourceFilter', graphql_name='not')


class FacilityDataSourceInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('facility_id', 'data_source_name', 'data_source')
    facility_id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='facilityId')
    data_source_name = sgqlc.types.Field(String, graphql_name='dataSourceName')
    data_source = sgqlc.types.Field(DataSourceInput, graphql_name='dataSource')


class FacilityFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'name', 'slug', 'address', 'city', 'state', 'zip', 'created_at', 'updated_at', 'timezone_name', 'unit_group', 'country', 'retired_at', 'pricing_node_id', 'bonus_ltr', 'commodity', 'go_live_date', 'link_active', 'metrics_one_active', 'pre_bonus_ebitda', 'suppresse_financials', 'type', 'wms', 'cost_center', 'customer_location_id', 'facility_contacts', 'latitude', 'longitude', 'n_sight2_active', 'n_sight_active', 'real_time_enabled', 'config', 'has_solar', 'utility_bill_currency', 'utility_meter_service_types', 'and_', 'or_', 'not_')
    id = sgqlc.types.Field('IntFilter', graphql_name='id')
    name = sgqlc.types.Field('StringFilter', graphql_name='name')
    slug = sgqlc.types.Field('StringFilter', graphql_name='slug')
    address = sgqlc.types.Field('StringFilter', graphql_name='address')
    city = sgqlc.types.Field('StringFilter', graphql_name='city')
    state = sgqlc.types.Field('StringFilter', graphql_name='state')
    zip = sgqlc.types.Field('StringFilter', graphql_name='zip')
    created_at = sgqlc.types.Field(DatetimeFilter, graphql_name='createdAt')
    updated_at = sgqlc.types.Field(DatetimeFilter, graphql_name='updatedAt')
    timezone_name = sgqlc.types.Field('StringFilter', graphql_name='timezoneName')
    unit_group = sgqlc.types.Field('StringFilter', graphql_name='unitGroup')
    country = sgqlc.types.Field(CountryFilter, graphql_name='country')
    retired_at = sgqlc.types.Field(DatetimeFilter, graphql_name='retiredAt')
    pricing_node_id = sgqlc.types.Field('IntFilter', graphql_name='pricingNodeId')
    bonus_ltr = sgqlc.types.Field(BooleanFilter, graphql_name='bonusLtr')
    commodity = sgqlc.types.Field('StringFilter', graphql_name='commodity')
    go_live_date = sgqlc.types.Field(DatetimeFilter, graphql_name='goLiveDate')
    link_active = sgqlc.types.Field(BooleanFilter, graphql_name='linkActive')
    metrics_one_active = sgqlc.types.Field(BooleanFilter, graphql_name='metricsOneActive')
    pre_bonus_ebitda = sgqlc.types.Field(BooleanFilter, graphql_name='preBonusEbitda')
    suppresse_financials = sgqlc.types.Field(BooleanFilter, graphql_name='suppresseFinancials')
    type = sgqlc.types.Field('StringFilter', graphql_name='type')
    wms = sgqlc.types.Field('StringFilter', graphql_name='wms')
    cost_center = sgqlc.types.Field('StringFilter', graphql_name='costCenter')
    customer_location_id = sgqlc.types.Field('IntFilter', graphql_name='customerLocationId')
    facility_contacts = sgqlc.types.Field('StringFilter', graphql_name='facilityContacts')
    latitude = sgqlc.types.Field('FloatFilter', graphql_name='latitude')
    longitude = sgqlc.types.Field('FloatFilter', graphql_name='longitude')
    n_sight2_active = sgqlc.types.Field(BooleanFilter, graphql_name='nSight2Active')
    n_sight_active = sgqlc.types.Field(BooleanFilter, graphql_name='nSightActive')
    real_time_enabled = sgqlc.types.Field(BooleanFilter, graphql_name='realTimeEnabled')
    config = sgqlc.types.Field('JSONFilter', graphql_name='config')
    has_solar = sgqlc.types.Field(BooleanFilter, graphql_name='hasSolar')
    utility_bill_currency = sgqlc.types.Field('StringFilter', graphql_name='utilityBillCurrency')
    utility_meter_service_types = sgqlc.types.Field('UtilityMeterServiceTypeListFilter', graphql_name='utilityMeterServiceTypes')
    and_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('FacilityFilter')), graphql_name='and')
    or_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('FacilityFilter')), graphql_name='or')
    not_ = sgqlc.types.Field('FacilityFilter', graphql_name='not')


class FacilityGroupCondition(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'name', 'parent_id')
    id = sgqlc.types.Field(BigInt, graphql_name='id')
    name = sgqlc.types.Field(String, graphql_name='name')
    parent_id = sgqlc.types.Field(BigInt, graphql_name='parentId')


class FacilityGroupFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'name', 'parent_id', 'and_', 'or_', 'not_')
    id = sgqlc.types.Field(BigIntFilter, graphql_name='id')
    name = sgqlc.types.Field('StringFilter', graphql_name='name')
    parent_id = sgqlc.types.Field(BigIntFilter, graphql_name='parentId')
    and_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('FacilityGroupFilter')), graphql_name='and')
    or_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('FacilityGroupFilter')), graphql_name='or')
    not_ = sgqlc.types.Field('FacilityGroupFilter', graphql_name='not')


class FacilityGroupInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('name', 'parent_id')
    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='name')
    parent_id = sgqlc.types.Field(BigInt, graphql_name='parentId')


class FacilityGroupPatch(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('name', 'parent_id')
    name = sgqlc.types.Field(String, graphql_name='name')
    parent_id = sgqlc.types.Field(BigInt, graphql_name='parentId')


class FacilityGroupsLinkerCondition(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('facility_id', 'facility_grouping_id')
    facility_id = sgqlc.types.Field(Int, graphql_name='facilityId')
    facility_grouping_id = sgqlc.types.Field(BigInt, graphql_name='facilityGroupingId')


class FacilityGroupsLinkerFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('facility_id', 'facility_grouping_id', 'and_', 'or_', 'not_')
    facility_id = sgqlc.types.Field('IntFilter', graphql_name='facilityId')
    facility_grouping_id = sgqlc.types.Field(BigIntFilter, graphql_name='facilityGroupingId')
    and_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('FacilityGroupsLinkerFilter')), graphql_name='and')
    or_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('FacilityGroupsLinkerFilter')), graphql_name='or')
    not_ = sgqlc.types.Field('FacilityGroupsLinkerFilter', graphql_name='not')


class FacilityGroupsLinkerInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('facility_id', 'facility_grouping_id', 'facility_group')
    facility_id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='facilityId')
    facility_grouping_id = sgqlc.types.Field(BigInt, graphql_name='facilityGroupingId')
    facility_group = sgqlc.types.Field(FacilityGroupInput, graphql_name='facilityGroup')


class FacilityGroupsLinkerPatch(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('facility_id', 'facility_grouping_id')
    facility_id = sgqlc.types.Field(Int, graphql_name='facilityId')
    facility_grouping_id = sgqlc.types.Field(BigInt, graphql_name='facilityGroupingId')


class FacilityInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'name', 'slug', 'address', 'city', 'state', 'zip', 'created_at', 'updated_at', 'timezone_name', 'unit_group', 'country', 'geometry', 'retired_at', 'pricing_node_id', 'bonus_ltr', 'commodity', 'go_live_date', 'link_active', 'metrics_one_active', 'pre_bonus_ebitda', 'suppresse_financials', 'type', 'wms', 'cost_center', 'customer_location_id', 'facility_contacts', 'latitude', 'longitude', 'n_sight2_active', 'n_sight_active', 'real_time_enabled', 'pricing_node')
    id = sgqlc.types.Field(Int, graphql_name='id')
    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='name')
    slug = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='slug')
    address = sgqlc.types.Field(String, graphql_name='address')
    city = sgqlc.types.Field(String, graphql_name='city')
    state = sgqlc.types.Field(String, graphql_name='state')
    zip = sgqlc.types.Field(String, graphql_name='zip')
    created_at = sgqlc.types.Field(Datetime, graphql_name='createdAt')
    updated_at = sgqlc.types.Field(Datetime, graphql_name='updatedAt')
    timezone_name = sgqlc.types.Field(String, graphql_name='timezoneName')
    unit_group = sgqlc.types.Field(String, graphql_name='unitGroup')
    country = sgqlc.types.Field(sgqlc.types.non_null(Country), graphql_name='country')
    geometry = sgqlc.types.Field(GeoJSON, graphql_name='geometry')
    retired_at = sgqlc.types.Field(Datetime, graphql_name='retiredAt')
    pricing_node_id = sgqlc.types.Field(Int, graphql_name='pricingNodeId')
    bonus_ltr = sgqlc.types.Field(Boolean, graphql_name='bonusLtr')
    commodity = sgqlc.types.Field(String, graphql_name='commodity')
    go_live_date = sgqlc.types.Field(Datetime, graphql_name='goLiveDate')
    link_active = sgqlc.types.Field(Boolean, graphql_name='linkActive')
    metrics_one_active = sgqlc.types.Field(Boolean, graphql_name='metricsOneActive')
    pre_bonus_ebitda = sgqlc.types.Field(Boolean, graphql_name='preBonusEbitda')
    suppresse_financials = sgqlc.types.Field(Boolean, graphql_name='suppresseFinancials')
    type = sgqlc.types.Field(String, graphql_name='type')
    wms = sgqlc.types.Field(String, graphql_name='wms')
    cost_center = sgqlc.types.Field(String, graphql_name='costCenter')
    customer_location_id = sgqlc.types.Field(Int, graphql_name='customerLocationId')
    facility_contacts = sgqlc.types.Field(String, graphql_name='facilityContacts')
    latitude = sgqlc.types.Field(Float, graphql_name='latitude')
    longitude = sgqlc.types.Field(Float, graphql_name='longitude')
    n_sight2_active = sgqlc.types.Field(Boolean, graphql_name='nSight2Active')
    n_sight_active = sgqlc.types.Field(Boolean, graphql_name='nSightActive')
    real_time_enabled = sgqlc.types.Field(Boolean, graphql_name='realTimeEnabled')
    pricing_node = sgqlc.types.Field('PricingNodeInput', graphql_name='pricingNode')


class FacilityPatch(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'name', 'slug', 'address', 'city', 'state', 'zip', 'created_at', 'updated_at', 'timezone_name', 'unit_group', 'country', 'geometry', 'retired_at', 'pricing_node_id', 'bonus_ltr', 'commodity', 'go_live_date', 'link_active', 'metrics_one_active', 'pre_bonus_ebitda', 'suppresse_financials', 'type', 'wms', 'cost_center', 'customer_location_id', 'facility_contacts', 'latitude', 'longitude', 'n_sight2_active', 'n_sight_active', 'real_time_enabled')
    id = sgqlc.types.Field(Int, graphql_name='id')
    name = sgqlc.types.Field(String, graphql_name='name')
    slug = sgqlc.types.Field(String, graphql_name='slug')
    address = sgqlc.types.Field(String, graphql_name='address')
    city = sgqlc.types.Field(String, graphql_name='city')
    state = sgqlc.types.Field(String, graphql_name='state')
    zip = sgqlc.types.Field(String, graphql_name='zip')
    created_at = sgqlc.types.Field(Datetime, graphql_name='createdAt')
    updated_at = sgqlc.types.Field(Datetime, graphql_name='updatedAt')
    timezone_name = sgqlc.types.Field(String, graphql_name='timezoneName')
    unit_group = sgqlc.types.Field(String, graphql_name='unitGroup')
    country = sgqlc.types.Field(Country, graphql_name='country')
    geometry = sgqlc.types.Field(GeoJSON, graphql_name='geometry')
    retired_at = sgqlc.types.Field(Datetime, graphql_name='retiredAt')
    pricing_node_id = sgqlc.types.Field(Int, graphql_name='pricingNodeId')
    bonus_ltr = sgqlc.types.Field(Boolean, graphql_name='bonusLtr')
    commodity = sgqlc.types.Field(String, graphql_name='commodity')
    go_live_date = sgqlc.types.Field(Datetime, graphql_name='goLiveDate')
    link_active = sgqlc.types.Field(Boolean, graphql_name='linkActive')
    metrics_one_active = sgqlc.types.Field(Boolean, graphql_name='metricsOneActive')
    pre_bonus_ebitda = sgqlc.types.Field(Boolean, graphql_name='preBonusEbitda')
    suppresse_financials = sgqlc.types.Field(Boolean, graphql_name='suppresseFinancials')
    type = sgqlc.types.Field(String, graphql_name='type')
    wms = sgqlc.types.Field(String, graphql_name='wms')
    cost_center = sgqlc.types.Field(String, graphql_name='costCenter')
    customer_location_id = sgqlc.types.Field(Int, graphql_name='customerLocationId')
    facility_contacts = sgqlc.types.Field(String, graphql_name='facilityContacts')
    latitude = sgqlc.types.Field(Float, graphql_name='latitude')
    longitude = sgqlc.types.Field(Float, graphql_name='longitude')
    n_sight2_active = sgqlc.types.Field(Boolean, graphql_name='nSight2Active')
    n_sight_active = sgqlc.types.Field(Boolean, graphql_name='nSightActive')
    real_time_enabled = sgqlc.types.Field(Boolean, graphql_name='realTimeEnabled')


class FacilityTaggedDataPointCondition(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'name', 'facility_id', 'data_point_id', 'tag_id', 'created_at', 'updated_at', 'tag_name')
    id = sgqlc.types.Field(Int, graphql_name='id')
    name = sgqlc.types.Field(String, graphql_name='name')
    facility_id = sgqlc.types.Field(Int, graphql_name='facilityId')
    data_point_id = sgqlc.types.Field(BigInt, graphql_name='dataPointId')
    tag_id = sgqlc.types.Field(Int, graphql_name='tagId')
    created_at = sgqlc.types.Field(Datetime, graphql_name='createdAt')
    updated_at = sgqlc.types.Field(Datetime, graphql_name='updatedAt')
    tag_name = sgqlc.types.Field(String, graphql_name='tagName')


class FacilityTaggedDataPointFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'name', 'facility_id', 'data_point_id', 'tag_id', 'created_at', 'updated_at', 'tag_name', 'and_', 'or_', 'not_')
    id = sgqlc.types.Field('IntFilter', graphql_name='id')
    name = sgqlc.types.Field('StringFilter', graphql_name='name')
    facility_id = sgqlc.types.Field('IntFilter', graphql_name='facilityId')
    data_point_id = sgqlc.types.Field(BigIntFilter, graphql_name='dataPointId')
    tag_id = sgqlc.types.Field('IntFilter', graphql_name='tagId')
    created_at = sgqlc.types.Field(DatetimeFilter, graphql_name='createdAt')
    updated_at = sgqlc.types.Field(DatetimeFilter, graphql_name='updatedAt')
    tag_name = sgqlc.types.Field('StringFilter', graphql_name='tagName')
    and_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('FacilityTaggedDataPointFilter')), graphql_name='and')
    or_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('FacilityTaggedDataPointFilter')), graphql_name='or')
    not_ = sgqlc.types.Field('FacilityTaggedDataPointFilter', graphql_name='not')


class FacilityTaggedDataPointInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('name', 'facility_id', 'data_point_id', 'tag_id', 'created_at', 'updated_at', 'data_point', 'data_point_tag')
    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='name')
    facility_id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='facilityId')
    data_point_id = sgqlc.types.Field(BigInt, graphql_name='dataPointId')
    tag_id = sgqlc.types.Field(Int, graphql_name='tagId')
    created_at = sgqlc.types.Field(Datetime, graphql_name='createdAt')
    updated_at = sgqlc.types.Field(Datetime, graphql_name='updatedAt')
    data_point = sgqlc.types.Field(DataPointInput, graphql_name='dataPoint')
    data_point_tag = sgqlc.types.Field(DataPointTagInput, graphql_name='dataPointTag')


class FacilityTaggedDataPointPatch(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('name', 'facility_id', 'data_point_id', 'tag_id')
    name = sgqlc.types.Field(String, graphql_name='name')
    facility_id = sgqlc.types.Field(Int, graphql_name='facilityId')
    data_point_id = sgqlc.types.Field(BigInt, graphql_name='dataPointId')
    tag_id = sgqlc.types.Field(Int, graphql_name='tagId')


class FloatFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('is_null', 'equal_to', 'not_equal_to', 'distinct_from', 'not_distinct_from', 'in_', 'not_in', 'less_than', 'less_than_or_equal_to', 'greater_than', 'greater_than_or_equal_to')
    is_null = sgqlc.types.Field(Boolean, graphql_name='isNull')
    equal_to = sgqlc.types.Field(Float, graphql_name='equalTo')
    not_equal_to = sgqlc.types.Field(Float, graphql_name='notEqualTo')
    distinct_from = sgqlc.types.Field(Float, graphql_name='distinctFrom')
    not_distinct_from = sgqlc.types.Field(Float, graphql_name='notDistinctFrom')
    in_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(Float)), graphql_name='in')
    not_in = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(Float)), graphql_name='notIn')
    less_than = sgqlc.types.Field(Float, graphql_name='lessThan')
    less_than_or_equal_to = sgqlc.types.Field(Float, graphql_name='lessThanOrEqualTo')
    greater_than = sgqlc.types.Field(Float, graphql_name='greaterThan')
    greater_than_or_equal_to = sgqlc.types.Field(Float, graphql_name='greaterThanOrEqualTo')


class HavingBigintFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('equal_to', 'not_equal_to', 'greater_than', 'greater_than_or_equal_to', 'less_than', 'less_than_or_equal_to')
    equal_to = sgqlc.types.Field(BigInt, graphql_name='equalTo')
    not_equal_to = sgqlc.types.Field(BigInt, graphql_name='notEqualTo')
    greater_than = sgqlc.types.Field(BigInt, graphql_name='greaterThan')
    greater_than_or_equal_to = sgqlc.types.Field(BigInt, graphql_name='greaterThanOrEqualTo')
    less_than = sgqlc.types.Field(BigInt, graphql_name='lessThan')
    less_than_or_equal_to = sgqlc.types.Field(BigInt, graphql_name='lessThanOrEqualTo')


class HavingDatetimeFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('equal_to', 'not_equal_to', 'greater_than', 'greater_than_or_equal_to', 'less_than', 'less_than_or_equal_to')
    equal_to = sgqlc.types.Field(Datetime, graphql_name='equalTo')
    not_equal_to = sgqlc.types.Field(Datetime, graphql_name='notEqualTo')
    greater_than = sgqlc.types.Field(Datetime, graphql_name='greaterThan')
    greater_than_or_equal_to = sgqlc.types.Field(Datetime, graphql_name='greaterThanOrEqualTo')
    less_than = sgqlc.types.Field(Datetime, graphql_name='lessThan')
    less_than_or_equal_to = sgqlc.types.Field(Datetime, graphql_name='lessThanOrEqualTo')


class HavingFloatFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('equal_to', 'not_equal_to', 'greater_than', 'greater_than_or_equal_to', 'less_than', 'less_than_or_equal_to')
    equal_to = sgqlc.types.Field(Float, graphql_name='equalTo')
    not_equal_to = sgqlc.types.Field(Float, graphql_name='notEqualTo')
    greater_than = sgqlc.types.Field(Float, graphql_name='greaterThan')
    greater_than_or_equal_to = sgqlc.types.Field(Float, graphql_name='greaterThanOrEqualTo')
    less_than = sgqlc.types.Field(Float, graphql_name='lessThan')
    less_than_or_equal_to = sgqlc.types.Field(Float, graphql_name='lessThanOrEqualTo')


class HavingIntFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('equal_to', 'not_equal_to', 'greater_than', 'greater_than_or_equal_to', 'less_than', 'less_than_or_equal_to')
    equal_to = sgqlc.types.Field(Int, graphql_name='equalTo')
    not_equal_to = sgqlc.types.Field(Int, graphql_name='notEqualTo')
    greater_than = sgqlc.types.Field(Int, graphql_name='greaterThan')
    greater_than_or_equal_to = sgqlc.types.Field(Int, graphql_name='greaterThanOrEqualTo')
    less_than = sgqlc.types.Field(Int, graphql_name='lessThan')
    less_than_or_equal_to = sgqlc.types.Field(Int, graphql_name='lessThanOrEqualTo')


class InputFacilityMetricData(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('time', 'facility_id', 'label', 'data', 'metadata')
    time = sgqlc.types.Field(sgqlc.types.non_null(Datetime), graphql_name='time')
    facility_id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='facilityId')
    label = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='label')
    data = sgqlc.types.Field(sgqlc.types.non_null(JSON), graphql_name='data')
    metadata = sgqlc.types.Field(JSON, graphql_name='metadata')


class InputMetricData(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('time', 'source_id', 'label', 'data', 'metadata')
    time = sgqlc.types.Field(sgqlc.types.non_null(Datetime), graphql_name='time')
    source_id = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='sourceId')
    label = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='label')
    data = sgqlc.types.Field(sgqlc.types.non_null(JSON), graphql_name='data')
    metadata = sgqlc.types.Field(JSON, graphql_name='metadata')


class IntFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('is_null', 'equal_to', 'not_equal_to', 'distinct_from', 'not_distinct_from', 'in_', 'not_in', 'less_than', 'less_than_or_equal_to', 'greater_than', 'greater_than_or_equal_to')
    is_null = sgqlc.types.Field(Boolean, graphql_name='isNull')
    equal_to = sgqlc.types.Field(Int, graphql_name='equalTo')
    not_equal_to = sgqlc.types.Field(Int, graphql_name='notEqualTo')
    distinct_from = sgqlc.types.Field(Int, graphql_name='distinctFrom')
    not_distinct_from = sgqlc.types.Field(Int, graphql_name='notDistinctFrom')
    in_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(Int)), graphql_name='in')
    not_in = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(Int)), graphql_name='notIn')
    less_than = sgqlc.types.Field(Int, graphql_name='lessThan')
    less_than_or_equal_to = sgqlc.types.Field(Int, graphql_name='lessThanOrEqualTo')
    greater_than = sgqlc.types.Field(Int, graphql_name='greaterThan')
    greater_than_or_equal_to = sgqlc.types.Field(Int, graphql_name='greaterThanOrEqualTo')


class IntListFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('is_null', 'equal_to', 'not_equal_to', 'distinct_from', 'not_distinct_from', 'less_than', 'less_than_or_equal_to', 'greater_than', 'greater_than_or_equal_to', 'contains', 'contained_by', 'overlaps', 'any_equal_to', 'any_not_equal_to', 'any_less_than', 'any_less_than_or_equal_to', 'any_greater_than', 'any_greater_than_or_equal_to')
    is_null = sgqlc.types.Field(Boolean, graphql_name='isNull')
    equal_to = sgqlc.types.Field(sgqlc.types.list_of(Int), graphql_name='equalTo')
    not_equal_to = sgqlc.types.Field(sgqlc.types.list_of(Int), graphql_name='notEqualTo')
    distinct_from = sgqlc.types.Field(sgqlc.types.list_of(Int), graphql_name='distinctFrom')
    not_distinct_from = sgqlc.types.Field(sgqlc.types.list_of(Int), graphql_name='notDistinctFrom')
    less_than = sgqlc.types.Field(sgqlc.types.list_of(Int), graphql_name='lessThan')
    less_than_or_equal_to = sgqlc.types.Field(sgqlc.types.list_of(Int), graphql_name='lessThanOrEqualTo')
    greater_than = sgqlc.types.Field(sgqlc.types.list_of(Int), graphql_name='greaterThan')
    greater_than_or_equal_to = sgqlc.types.Field(sgqlc.types.list_of(Int), graphql_name='greaterThanOrEqualTo')
    contains = sgqlc.types.Field(sgqlc.types.list_of(Int), graphql_name='contains')
    contained_by = sgqlc.types.Field(sgqlc.types.list_of(Int), graphql_name='containedBy')
    overlaps = sgqlc.types.Field(sgqlc.types.list_of(Int), graphql_name='overlaps')
    any_equal_to = sgqlc.types.Field(Int, graphql_name='anyEqualTo')
    any_not_equal_to = sgqlc.types.Field(Int, graphql_name='anyNotEqualTo')
    any_less_than = sgqlc.types.Field(Int, graphql_name='anyLessThan')
    any_less_than_or_equal_to = sgqlc.types.Field(Int, graphql_name='anyLessThanOrEqualTo')
    any_greater_than = sgqlc.types.Field(Int, graphql_name='anyGreaterThan')
    any_greater_than_or_equal_to = sgqlc.types.Field(Int, graphql_name='anyGreaterThanOrEqualTo')


class IntervalFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('is_null', 'equal_to', 'not_equal_to', 'distinct_from', 'not_distinct_from', 'in_', 'not_in', 'less_than', 'less_than_or_equal_to', 'greater_than', 'greater_than_or_equal_to')
    is_null = sgqlc.types.Field(Boolean, graphql_name='isNull')
    equal_to = sgqlc.types.Field('IntervalInput', graphql_name='equalTo')
    not_equal_to = sgqlc.types.Field('IntervalInput', graphql_name='notEqualTo')
    distinct_from = sgqlc.types.Field('IntervalInput', graphql_name='distinctFrom')
    not_distinct_from = sgqlc.types.Field('IntervalInput', graphql_name='notDistinctFrom')
    in_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('IntervalInput')), graphql_name='in')
    not_in = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('IntervalInput')), graphql_name='notIn')
    less_than = sgqlc.types.Field('IntervalInput', graphql_name='lessThan')
    less_than_or_equal_to = sgqlc.types.Field('IntervalInput', graphql_name='lessThanOrEqualTo')
    greater_than = sgqlc.types.Field('IntervalInput', graphql_name='greaterThan')
    greater_than_or_equal_to = sgqlc.types.Field('IntervalInput', graphql_name='greaterThanOrEqualTo')


class IntervalInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('seconds', 'minutes', 'hours', 'days', 'months', 'years')
    seconds = sgqlc.types.Field(Float, graphql_name='seconds')
    minutes = sgqlc.types.Field(Int, graphql_name='minutes')
    hours = sgqlc.types.Field(Int, graphql_name='hours')
    days = sgqlc.types.Field(Int, graphql_name='days')
    months = sgqlc.types.Field(Int, graphql_name='months')
    years = sgqlc.types.Field(Int, graphql_name='years')


class JSONFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('is_null', 'equal_to', 'not_equal_to', 'distinct_from', 'not_distinct_from', 'in_', 'not_in', 'less_than', 'less_than_or_equal_to', 'greater_than', 'greater_than_or_equal_to', 'contains', 'contains_key', 'contains_all_keys', 'contains_any_keys', 'contained_by')
    is_null = sgqlc.types.Field(Boolean, graphql_name='isNull')
    equal_to = sgqlc.types.Field(JSON, graphql_name='equalTo')
    not_equal_to = sgqlc.types.Field(JSON, graphql_name='notEqualTo')
    distinct_from = sgqlc.types.Field(JSON, graphql_name='distinctFrom')
    not_distinct_from = sgqlc.types.Field(JSON, graphql_name='notDistinctFrom')
    in_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(JSON)), graphql_name='in')
    not_in = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(JSON)), graphql_name='notIn')
    less_than = sgqlc.types.Field(JSON, graphql_name='lessThan')
    less_than_or_equal_to = sgqlc.types.Field(JSON, graphql_name='lessThanOrEqualTo')
    greater_than = sgqlc.types.Field(JSON, graphql_name='greaterThan')
    greater_than_or_equal_to = sgqlc.types.Field(JSON, graphql_name='greaterThanOrEqualTo')
    contains = sgqlc.types.Field(JSON, graphql_name='contains')
    contains_key = sgqlc.types.Field(String, graphql_name='containsKey')
    contains_all_keys = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(String)), graphql_name='containsAllKeys')
    contains_any_keys = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(String)), graphql_name='containsAnyKeys')
    contained_by = sgqlc.types.Field(JSON, graphql_name='containedBy')


class JSONListFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('is_null', 'equal_to', 'not_equal_to', 'distinct_from', 'not_distinct_from', 'less_than', 'less_than_or_equal_to', 'greater_than', 'greater_than_or_equal_to', 'contains', 'contained_by', 'overlaps', 'any_equal_to', 'any_not_equal_to', 'any_less_than', 'any_less_than_or_equal_to', 'any_greater_than', 'any_greater_than_or_equal_to')
    is_null = sgqlc.types.Field(Boolean, graphql_name='isNull')
    equal_to = sgqlc.types.Field(sgqlc.types.list_of(JSON), graphql_name='equalTo')
    not_equal_to = sgqlc.types.Field(sgqlc.types.list_of(JSON), graphql_name='notEqualTo')
    distinct_from = sgqlc.types.Field(sgqlc.types.list_of(JSON), graphql_name='distinctFrom')
    not_distinct_from = sgqlc.types.Field(sgqlc.types.list_of(JSON), graphql_name='notDistinctFrom')
    less_than = sgqlc.types.Field(sgqlc.types.list_of(JSON), graphql_name='lessThan')
    less_than_or_equal_to = sgqlc.types.Field(sgqlc.types.list_of(JSON), graphql_name='lessThanOrEqualTo')
    greater_than = sgqlc.types.Field(sgqlc.types.list_of(JSON), graphql_name='greaterThan')
    greater_than_or_equal_to = sgqlc.types.Field(sgqlc.types.list_of(JSON), graphql_name='greaterThanOrEqualTo')
    contains = sgqlc.types.Field(sgqlc.types.list_of(JSON), graphql_name='contains')
    contained_by = sgqlc.types.Field(sgqlc.types.list_of(JSON), graphql_name='containedBy')
    overlaps = sgqlc.types.Field(sgqlc.types.list_of(JSON), graphql_name='overlaps')
    any_equal_to = sgqlc.types.Field(JSON, graphql_name='anyEqualTo')
    any_not_equal_to = sgqlc.types.Field(JSON, graphql_name='anyNotEqualTo')
    any_less_than = sgqlc.types.Field(JSON, graphql_name='anyLessThan')
    any_less_than_or_equal_to = sgqlc.types.Field(JSON, graphql_name='anyLessThanOrEqualTo')
    any_greater_than = sgqlc.types.Field(JSON, graphql_name='anyGreaterThan')
    any_greater_than_or_equal_to = sgqlc.types.Field(JSON, graphql_name='anyGreaterThanOrEqualTo')


class MachineUserCondition(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'description', 'created_by', 'created_at', 'updated_at')
    id = sgqlc.types.Field(BigInt, graphql_name='id')
    description = sgqlc.types.Field(String, graphql_name='description')
    created_by = sgqlc.types.Field(String, graphql_name='createdBy')
    created_at = sgqlc.types.Field(Datetime, graphql_name='createdAt')
    updated_at = sgqlc.types.Field(Datetime, graphql_name='updatedAt')


class MachineUserFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('can_write', 'id', 'description', 'created_by', 'created_at', 'updated_at', 'and_', 'or_', 'not_')
    can_write = sgqlc.types.Field('PermissionBooleanFilter', graphql_name='canWrite')
    id = sgqlc.types.Field(BigIntFilter, graphql_name='id')
    description = sgqlc.types.Field('StringFilter', graphql_name='description')
    created_by = sgqlc.types.Field('StringFilter', graphql_name='createdBy')
    created_at = sgqlc.types.Field(DatetimeFilter, graphql_name='createdAt')
    updated_at = sgqlc.types.Field(DatetimeFilter, graphql_name='updatedAt')
    and_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('MachineUserFilter')), graphql_name='and')
    or_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('MachineUserFilter')), graphql_name='or')
    not_ = sgqlc.types.Field('MachineUserFilter', graphql_name='not')


class MachineUserInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('description', 'created_by', 'created_at', 'updated_at')
    description = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='description')
    created_by = sgqlc.types.Field(String, graphql_name='createdBy')
    created_at = sgqlc.types.Field(Datetime, graphql_name='createdAt')
    updated_at = sgqlc.types.Field(Datetime, graphql_name='updatedAt')


class MachineUserPatch(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('description', 'created_by', 'created_at', 'updated_at')
    description = sgqlc.types.Field(String, graphql_name='description')
    created_by = sgqlc.types.Field(String, graphql_name='createdBy')
    created_at = sgqlc.types.Field(Datetime, graphql_name='createdAt')
    updated_at = sgqlc.types.Field(Datetime, graphql_name='updatedAt')


class MainServiceCondition(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'type', 'facility_id', 'name', 'usage_data_point_id', 'demand_data_point_id', 'created_at', 'updated_at', 'exclude_carbon', 'meter_usage_data_point_id', 'meter_demand_data_point_id', 'grid_usage_data_point_id', 'grid_demand_data_point_id')
    id = sgqlc.types.Field(Int, graphql_name='id')
    type = sgqlc.types.Field(MainServicesType, graphql_name='type')
    facility_id = sgqlc.types.Field(Int, graphql_name='facilityId')
    name = sgqlc.types.Field(String, graphql_name='name')
    usage_data_point_id = sgqlc.types.Field(Int, graphql_name='usageDataPointId')
    demand_data_point_id = sgqlc.types.Field(Int, graphql_name='demandDataPointId')
    created_at = sgqlc.types.Field(Datetime, graphql_name='createdAt')
    updated_at = sgqlc.types.Field(Datetime, graphql_name='updatedAt')
    exclude_carbon = sgqlc.types.Field(Boolean, graphql_name='excludeCarbon')
    meter_usage_data_point_id = sgqlc.types.Field(Int, graphql_name='meterUsageDataPointId')
    meter_demand_data_point_id = sgqlc.types.Field(Int, graphql_name='meterDemandDataPointId')
    grid_usage_data_point_id = sgqlc.types.Field(Int, graphql_name='gridUsageDataPointId')
    grid_demand_data_point_id = sgqlc.types.Field(Int, graphql_name='gridDemandDataPointId')


class MainServiceFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'type', 'facility_id', 'name', 'usage_data_point_id', 'demand_data_point_id', 'created_at', 'updated_at', 'exclude_carbon', 'meter_usage_data_point_id', 'meter_demand_data_point_id', 'grid_usage_data_point_id', 'grid_demand_data_point_id', 'and_', 'or_', 'not_')
    id = sgqlc.types.Field(IntFilter, graphql_name='id')
    type = sgqlc.types.Field('MainServicesTypeFilter', graphql_name='type')
    facility_id = sgqlc.types.Field(IntFilter, graphql_name='facilityId')
    name = sgqlc.types.Field('StringFilter', graphql_name='name')
    usage_data_point_id = sgqlc.types.Field(IntFilter, graphql_name='usageDataPointId')
    demand_data_point_id = sgqlc.types.Field(IntFilter, graphql_name='demandDataPointId')
    created_at = sgqlc.types.Field(DatetimeFilter, graphql_name='createdAt')
    updated_at = sgqlc.types.Field(DatetimeFilter, graphql_name='updatedAt')
    exclude_carbon = sgqlc.types.Field(BooleanFilter, graphql_name='excludeCarbon')
    meter_usage_data_point_id = sgqlc.types.Field(IntFilter, graphql_name='meterUsageDataPointId')
    meter_demand_data_point_id = sgqlc.types.Field(IntFilter, graphql_name='meterDemandDataPointId')
    grid_usage_data_point_id = sgqlc.types.Field(IntFilter, graphql_name='gridUsageDataPointId')
    grid_demand_data_point_id = sgqlc.types.Field(IntFilter, graphql_name='gridDemandDataPointId')
    and_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('MainServiceFilter')), graphql_name='and')
    or_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('MainServiceFilter')), graphql_name='or')
    not_ = sgqlc.types.Field('MainServiceFilter', graphql_name='not')


class MainServiceInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('type', 'facility_id', 'name', 'usage_data_point_id', 'demand_data_point_id', 'exclude_carbon', 'meter_usage_data_point_id', 'meter_demand_data_point_id', 'grid_usage_data_point_id', 'grid_demand_data_point_id', 'data_point')
    type = sgqlc.types.Field(sgqlc.types.non_null(MainServicesType), graphql_name='type')
    facility_id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='facilityId')
    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='name')
    usage_data_point_id = sgqlc.types.Field(Int, graphql_name='usageDataPointId')
    demand_data_point_id = sgqlc.types.Field(Int, graphql_name='demandDataPointId')
    exclude_carbon = sgqlc.types.Field(Boolean, graphql_name='excludeCarbon')
    meter_usage_data_point_id = sgqlc.types.Field(Int, graphql_name='meterUsageDataPointId')
    meter_demand_data_point_id = sgqlc.types.Field(Int, graphql_name='meterDemandDataPointId')
    grid_usage_data_point_id = sgqlc.types.Field(Int, graphql_name='gridUsageDataPointId')
    grid_demand_data_point_id = sgqlc.types.Field(Int, graphql_name='gridDemandDataPointId')
    data_point = sgqlc.types.Field(DataPointInput, graphql_name='dataPoint')


class MainServicePatch(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('type', 'facility_id', 'name', 'usage_data_point_id', 'demand_data_point_id', 'exclude_carbon', 'meter_usage_data_point_id', 'meter_demand_data_point_id', 'grid_usage_data_point_id', 'grid_demand_data_point_id')
    type = sgqlc.types.Field(MainServicesType, graphql_name='type')
    facility_id = sgqlc.types.Field(Int, graphql_name='facilityId')
    name = sgqlc.types.Field(String, graphql_name='name')
    usage_data_point_id = sgqlc.types.Field(Int, graphql_name='usageDataPointId')
    demand_data_point_id = sgqlc.types.Field(Int, graphql_name='demandDataPointId')
    exclude_carbon = sgqlc.types.Field(Boolean, graphql_name='excludeCarbon')
    meter_usage_data_point_id = sgqlc.types.Field(Int, graphql_name='meterUsageDataPointId')
    meter_demand_data_point_id = sgqlc.types.Field(Int, graphql_name='meterDemandDataPointId')
    grid_usage_data_point_id = sgqlc.types.Field(Int, graphql_name='gridUsageDataPointId')
    grid_demand_data_point_id = sgqlc.types.Field(Int, graphql_name='gridDemandDataPointId')


class MainServicesTypeFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('is_null', 'equal_to', 'not_equal_to', 'distinct_from', 'not_distinct_from', 'in_', 'not_in', 'less_than', 'less_than_or_equal_to', 'greater_than', 'greater_than_or_equal_to')
    is_null = sgqlc.types.Field(Boolean, graphql_name='isNull')
    equal_to = sgqlc.types.Field(MainServicesType, graphql_name='equalTo')
    not_equal_to = sgqlc.types.Field(MainServicesType, graphql_name='notEqualTo')
    distinct_from = sgqlc.types.Field(MainServicesType, graphql_name='distinctFrom')
    not_distinct_from = sgqlc.types.Field(MainServicesType, graphql_name='notDistinctFrom')
    in_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(MainServicesType)), graphql_name='in')
    not_in = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(MainServicesType)), graphql_name='notIn')
    less_than = sgqlc.types.Field(MainServicesType, graphql_name='lessThan')
    less_than_or_equal_to = sgqlc.types.Field(MainServicesType, graphql_name='lessThanOrEqualTo')
    greater_than = sgqlc.types.Field(MainServicesType, graphql_name='greaterThan')
    greater_than_or_equal_to = sgqlc.types.Field(MainServicesType, graphql_name='greaterThanOrEqualTo')


class MeterChargeCondition(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'meter_statement_id', 'category', 'normalized_value', 'override_at', 'line_number', 'created_at', 'updated_at', 'deleted_at')
    id = sgqlc.types.Field(Int, graphql_name='id')
    meter_statement_id = sgqlc.types.Field(Int, graphql_name='meterStatementId')
    category = sgqlc.types.Field(UtilityMeterChargeCategory, graphql_name='category')
    normalized_value = sgqlc.types.Field(Float, graphql_name='normalizedValue')
    override_at = sgqlc.types.Field(Datetime, graphql_name='overrideAt')
    line_number = sgqlc.types.Field(Int, graphql_name='lineNumber')
    created_at = sgqlc.types.Field(Datetime, graphql_name='createdAt')
    updated_at = sgqlc.types.Field(Datetime, graphql_name='updatedAt')
    deleted_at = sgqlc.types.Field(Datetime, graphql_name='deletedAt')


class MeterChargeFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('label', 'value', 'id', 'meter_statement_id', 'category', 'normalized_value', 'override_at', 'line_number', 'created_at', 'updated_at', 'deleted_at', 'and_', 'or_', 'not_')
    label = sgqlc.types.Field('StringFilter', graphql_name='label')
    value = sgqlc.types.Field(FloatFilter, graphql_name='value')
    id = sgqlc.types.Field(IntFilter, graphql_name='id')
    meter_statement_id = sgqlc.types.Field(IntFilter, graphql_name='meterStatementId')
    category = sgqlc.types.Field('UtilityMeterChargeCategoryFilter', graphql_name='category')
    normalized_value = sgqlc.types.Field(FloatFilter, graphql_name='normalizedValue')
    override_at = sgqlc.types.Field(DatetimeFilter, graphql_name='overrideAt')
    line_number = sgqlc.types.Field(IntFilter, graphql_name='lineNumber')
    created_at = sgqlc.types.Field(DatetimeFilter, graphql_name='createdAt')
    updated_at = sgqlc.types.Field(DatetimeFilter, graphql_name='updatedAt')
    deleted_at = sgqlc.types.Field(DatetimeFilter, graphql_name='deletedAt')
    and_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('MeterChargeFilter')), graphql_name='and')
    or_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('MeterChargeFilter')), graphql_name='or')
    not_ = sgqlc.types.Field('MeterChargeFilter', graphql_name='not')


class MeterChargeInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'meter_statement_id', 'category', 'label', 'value', 'line_number', 'meter_statement')
    id = sgqlc.types.Field(Int, graphql_name='id')
    meter_statement_id = sgqlc.types.Field(Int, graphql_name='meterStatementId')
    category = sgqlc.types.Field(sgqlc.types.non_null(UtilityMeterChargeCategory), graphql_name='category')
    label = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='label')
    value = sgqlc.types.Field(sgqlc.types.non_null(Float), graphql_name='value')
    line_number = sgqlc.types.Field(Int, graphql_name='lineNumber')
    meter_statement = sgqlc.types.Field('MeterStatementInput', graphql_name='meterStatement')


class MeterChargePatch(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('label', 'value')
    label = sgqlc.types.Field(String, graphql_name='label')
    value = sgqlc.types.Field(Float, graphql_name='value')


class MeterStatementCondition(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'utility_meter_id', 'account_statement_id', 'interval_start', 'interval_end', 'statement_date', 'integration_key', 'is_validated', 'normalized_currency_code', 'override_at', 'metadata', 'manual_upload', 'is_adjustment', 'created_at', 'updated_at', 'override_statement_year', 'override_statement_month', 'account_statement_pdf_id')
    id = sgqlc.types.Field(Int, graphql_name='id')
    utility_meter_id = sgqlc.types.Field(Int, graphql_name='utilityMeterId')
    account_statement_id = sgqlc.types.Field(Int, graphql_name='accountStatementId')
    interval_start = sgqlc.types.Field(Date, graphql_name='intervalStart')
    interval_end = sgqlc.types.Field(Date, graphql_name='intervalEnd')
    statement_date = sgqlc.types.Field(Date, graphql_name='statementDate')
    integration_key = sgqlc.types.Field(String, graphql_name='integrationKey')
    is_validated = sgqlc.types.Field(Boolean, graphql_name='isValidated')
    normalized_currency_code = sgqlc.types.Field(String, graphql_name='normalizedCurrencyCode')
    override_at = sgqlc.types.Field(Datetime, graphql_name='overrideAt')
    metadata = sgqlc.types.Field(JSON, graphql_name='metadata')
    manual_upload = sgqlc.types.Field(Boolean, graphql_name='manualUpload')
    is_adjustment = sgqlc.types.Field(Boolean, graphql_name='isAdjustment')
    created_at = sgqlc.types.Field(Datetime, graphql_name='createdAt')
    updated_at = sgqlc.types.Field(Datetime, graphql_name='updatedAt')
    override_statement_year = sgqlc.types.Field(Int, graphql_name='overrideStatementYear')
    override_statement_month = sgqlc.types.Field(Int, graphql_name='overrideStatementMonth')
    account_statement_pdf_id = sgqlc.types.Field(Int, graphql_name='accountStatementPdfId')


class MeterStatementFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('currency_code', 'primary_usage_units', 'primary_demand_units', 'id', 'utility_meter_id', 'account_statement_id', 'interval_start', 'interval_end', 'statement_date', 'integration_key', 'is_validated', 'normalized_currency_code', 'override_at', 'metadata', 'manual_upload', 'is_adjustment', 'created_at', 'updated_at', 'override_statement_year', 'override_statement_month', 'account_statement_pdf_id', 'deleted_at', 'max_demand', 'normalized_total_charges', 'statement_month', 'statement_year', 'statement_year_month', 'total_charges', 'total_usage', 'and_', 'or_', 'not_')
    currency_code = sgqlc.types.Field('StringFilter', graphql_name='currencyCode')
    primary_usage_units = sgqlc.types.Field('StringFilter', graphql_name='primaryUsageUnits')
    primary_demand_units = sgqlc.types.Field('StringFilter', graphql_name='primaryDemandUnits')
    id = sgqlc.types.Field(IntFilter, graphql_name='id')
    utility_meter_id = sgqlc.types.Field(IntFilter, graphql_name='utilityMeterId')
    account_statement_id = sgqlc.types.Field(IntFilter, graphql_name='accountStatementId')
    interval_start = sgqlc.types.Field(DateFilter, graphql_name='intervalStart')
    interval_end = sgqlc.types.Field(DateFilter, graphql_name='intervalEnd')
    statement_date = sgqlc.types.Field(DateFilter, graphql_name='statementDate')
    integration_key = sgqlc.types.Field('StringFilter', graphql_name='integrationKey')
    is_validated = sgqlc.types.Field(BooleanFilter, graphql_name='isValidated')
    normalized_currency_code = sgqlc.types.Field('StringFilter', graphql_name='normalizedCurrencyCode')
    override_at = sgqlc.types.Field(DatetimeFilter, graphql_name='overrideAt')
    metadata = sgqlc.types.Field(JSONFilter, graphql_name='metadata')
    manual_upload = sgqlc.types.Field(BooleanFilter, graphql_name='manualUpload')
    is_adjustment = sgqlc.types.Field(BooleanFilter, graphql_name='isAdjustment')
    created_at = sgqlc.types.Field(DatetimeFilter, graphql_name='createdAt')
    updated_at = sgqlc.types.Field(DatetimeFilter, graphql_name='updatedAt')
    override_statement_year = sgqlc.types.Field(IntFilter, graphql_name='overrideStatementYear')
    override_statement_month = sgqlc.types.Field(IntFilter, graphql_name='overrideStatementMonth')
    account_statement_pdf_id = sgqlc.types.Field(IntFilter, graphql_name='accountStatementPdfId')
    deleted_at = sgqlc.types.Field(DatetimeFilter, graphql_name='deletedAt')
    max_demand = sgqlc.types.Field(FloatFilter, graphql_name='maxDemand')
    normalized_total_charges = sgqlc.types.Field(FloatFilter, graphql_name='normalizedTotalCharges')
    statement_month = sgqlc.types.Field(IntFilter, graphql_name='statementMonth')
    statement_year = sgqlc.types.Field(IntFilter, graphql_name='statementYear')
    statement_year_month = sgqlc.types.Field(DateFilter, graphql_name='statementYearMonth')
    total_charges = sgqlc.types.Field(FloatFilter, graphql_name='totalCharges')
    total_usage = sgqlc.types.Field(FloatFilter, graphql_name='totalUsage')
    and_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('MeterStatementFilter')), graphql_name='and')
    or_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('MeterStatementFilter')), graphql_name='or')
    not_ = sgqlc.types.Field('MeterStatementFilter', graphql_name='not')


class MeterStatementHistoryCondition(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('meter_statement_id', 'description', 'created_at')
    meter_statement_id = sgqlc.types.Field(Int, graphql_name='meterStatementId')
    description = sgqlc.types.Field(String, graphql_name='description')
    created_at = sgqlc.types.Field(Datetime, graphql_name='createdAt')


class MeterStatementHistoryFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('meter_statement_id', 'description', 'created_at', 'and_', 'or_', 'not_')
    meter_statement_id = sgqlc.types.Field(IntFilter, graphql_name='meterStatementId')
    description = sgqlc.types.Field('StringFilter', graphql_name='description')
    created_at = sgqlc.types.Field(DatetimeFilter, graphql_name='createdAt')
    and_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('MeterStatementHistoryFilter')), graphql_name='and')
    or_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('MeterStatementHistoryFilter')), graphql_name='or')
    not_ = sgqlc.types.Field('MeterStatementHistoryFilter', graphql_name='not')


class MeterStatementHistoryInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('meter_statement_id', 'description', 'meter_statement')
    meter_statement_id = sgqlc.types.Field(Int, graphql_name='meterStatementId')
    description = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='description')
    meter_statement = sgqlc.types.Field('MeterStatementInput', graphql_name='meterStatement')


class MeterStatementInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'utility_meter_id', 'account_statement_id', 'interval_start', 'interval_end', 'statement_date', 'integration_key', 'is_validated', 'currency_code', 'primary_usage_units', 'primary_demand_units', 'metadata', 'manual_upload', 'is_adjustment', 'account_statement_pdf_id', 'utility_meter', 'account_statement', 'account_statement_pdf')
    id = sgqlc.types.Field(Int, graphql_name='id')
    utility_meter_id = sgqlc.types.Field(Int, graphql_name='utilityMeterId')
    account_statement_id = sgqlc.types.Field(Int, graphql_name='accountStatementId')
    interval_start = sgqlc.types.Field(sgqlc.types.non_null(Date), graphql_name='intervalStart')
    interval_end = sgqlc.types.Field(sgqlc.types.non_null(Date), graphql_name='intervalEnd')
    statement_date = sgqlc.types.Field(sgqlc.types.non_null(Date), graphql_name='statementDate')
    integration_key = sgqlc.types.Field(String, graphql_name='integrationKey')
    is_validated = sgqlc.types.Field(Boolean, graphql_name='isValidated')
    currency_code = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='currencyCode')
    primary_usage_units = sgqlc.types.Field(String, graphql_name='primaryUsageUnits')
    primary_demand_units = sgqlc.types.Field(String, graphql_name='primaryDemandUnits')
    metadata = sgqlc.types.Field(JSON, graphql_name='metadata')
    manual_upload = sgqlc.types.Field(Boolean, graphql_name='manualUpload')
    is_adjustment = sgqlc.types.Field(Boolean, graphql_name='isAdjustment')
    account_statement_pdf_id = sgqlc.types.Field(Int, graphql_name='accountStatementPdfId')
    utility_meter = sgqlc.types.Field('UtilityMeterInput', graphql_name='utilityMeter')
    account_statement = sgqlc.types.Field(AccountStatementInput, graphql_name='accountStatement')
    account_statement_pdf = sgqlc.types.Field(AccountStatementPdfInput, graphql_name='accountStatementPdf')


class MeterStatementPatch(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('utility_meter_id', 'interval_start', 'interval_end', 'is_validated', 'currency_code', 'primary_usage_units', 'primary_demand_units', 'metadata', 'manual_upload', 'is_adjustment', 'override_statement_year', 'override_statement_month', 'account_statement_pdf_id')
    utility_meter_id = sgqlc.types.Field(Int, graphql_name='utilityMeterId')
    interval_start = sgqlc.types.Field(Date, graphql_name='intervalStart')
    interval_end = sgqlc.types.Field(Date, graphql_name='intervalEnd')
    is_validated = sgqlc.types.Field(Boolean, graphql_name='isValidated')
    currency_code = sgqlc.types.Field(String, graphql_name='currencyCode')
    primary_usage_units = sgqlc.types.Field(String, graphql_name='primaryUsageUnits')
    primary_demand_units = sgqlc.types.Field(String, graphql_name='primaryDemandUnits')
    metadata = sgqlc.types.Field(JSON, graphql_name='metadata')
    manual_upload = sgqlc.types.Field(Boolean, graphql_name='manualUpload')
    is_adjustment = sgqlc.types.Field(Boolean, graphql_name='isAdjustment')
    override_statement_year = sgqlc.types.Field(Int, graphql_name='overrideStatementYear')
    override_statement_month = sgqlc.types.Field(Int, graphql_name='overrideStatementMonth')
    account_statement_pdf_id = sgqlc.types.Field(Int, graphql_name='accountStatementPdfId')


class MeterStatementsChargesRecordFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('category', 'value', 'and_', 'or_', 'not_')
    category = sgqlc.types.Field('UtilityMeterChargeCategoryFilter', graphql_name='category')
    value = sgqlc.types.Field(FloatFilter, graphql_name='value')
    and_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('MeterStatementsChargesRecordFilter')), graphql_name='and')
    or_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('MeterStatementsChargesRecordFilter')), graphql_name='or')
    not_ = sgqlc.types.Field('MeterStatementsChargesRecordFilter', graphql_name='not')


class MeterStatementsNormalizedChargesRecordFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('category', 'value', 'and_', 'or_', 'not_')
    category = sgqlc.types.Field('UtilityMeterChargeCategoryFilter', graphql_name='category')
    value = sgqlc.types.Field(FloatFilter, graphql_name='value')
    and_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('MeterStatementsNormalizedChargesRecordFilter')), graphql_name='and')
    or_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('MeterStatementsNormalizedChargesRecordFilter')), graphql_name='or')
    not_ = sgqlc.types.Field('MeterStatementsNormalizedChargesRecordFilter', graphql_name='not')


class MeterUsageCondition(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'meter_statement_id', 'category', 'override_at', 'line_number', 'created_at', 'updated_at', 'deleted_at', 'metadata')
    id = sgqlc.types.Field(Int, graphql_name='id')
    meter_statement_id = sgqlc.types.Field(Int, graphql_name='meterStatementId')
    category = sgqlc.types.Field(UtilityMeterUsageCategory, graphql_name='category')
    override_at = sgqlc.types.Field(Datetime, graphql_name='overrideAt')
    line_number = sgqlc.types.Field(Int, graphql_name='lineNumber')
    created_at = sgqlc.types.Field(Datetime, graphql_name='createdAt')
    updated_at = sgqlc.types.Field(Datetime, graphql_name='updatedAt')
    deleted_at = sgqlc.types.Field(Datetime, graphql_name='deletedAt')
    metadata = sgqlc.types.Field(JSON, graphql_name='metadata')


class MeterUsageFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('label', 'value', 'units', 'id', 'meter_statement_id', 'category', 'override_at', 'line_number', 'created_at', 'updated_at', 'deleted_at', 'metadata', 'and_', 'or_', 'not_')
    label = sgqlc.types.Field('StringFilter', graphql_name='label')
    value = sgqlc.types.Field(FloatFilter, graphql_name='value')
    units = sgqlc.types.Field('StringFilter', graphql_name='units')
    id = sgqlc.types.Field(IntFilter, graphql_name='id')
    meter_statement_id = sgqlc.types.Field(IntFilter, graphql_name='meterStatementId')
    category = sgqlc.types.Field('UtilityMeterUsageCategoryFilter', graphql_name='category')
    override_at = sgqlc.types.Field(DatetimeFilter, graphql_name='overrideAt')
    line_number = sgqlc.types.Field(IntFilter, graphql_name='lineNumber')
    created_at = sgqlc.types.Field(DatetimeFilter, graphql_name='createdAt')
    updated_at = sgqlc.types.Field(DatetimeFilter, graphql_name='updatedAt')
    deleted_at = sgqlc.types.Field(DatetimeFilter, graphql_name='deletedAt')
    metadata = sgqlc.types.Field(JSONFilter, graphql_name='metadata')
    and_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('MeterUsageFilter')), graphql_name='and')
    or_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('MeterUsageFilter')), graphql_name='or')
    not_ = sgqlc.types.Field('MeterUsageFilter', graphql_name='not')


class MeterUsageInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'meter_statement_id', 'category', 'label', 'value', 'units', 'line_number', 'metadata', 'meter_statement')
    id = sgqlc.types.Field(Int, graphql_name='id')
    meter_statement_id = sgqlc.types.Field(Int, graphql_name='meterStatementId')
    category = sgqlc.types.Field(sgqlc.types.non_null(UtilityMeterUsageCategory), graphql_name='category')
    label = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='label')
    value = sgqlc.types.Field(sgqlc.types.non_null(Float), graphql_name='value')
    units = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='units')
    line_number = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='lineNumber')
    metadata = sgqlc.types.Field(JSON, graphql_name='metadata')
    meter_statement = sgqlc.types.Field(MeterStatementInput, graphql_name='meterStatement')


class MeterUsagePatch(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('label', 'value', 'units', 'metadata')
    label = sgqlc.types.Field(String, graphql_name='label')
    value = sgqlc.types.Field(Float, graphql_name='value')
    units = sgqlc.types.Field(String, graphql_name='units')
    metadata = sgqlc.types.Field(JSON, graphql_name='metadata')


class MetricDatatypeFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('is_null', 'equal_to', 'not_equal_to', 'distinct_from', 'not_distinct_from', 'in_', 'not_in', 'less_than', 'less_than_or_equal_to', 'greater_than', 'greater_than_or_equal_to')
    is_null = sgqlc.types.Field(Boolean, graphql_name='isNull')
    equal_to = sgqlc.types.Field(MetricDatatype, graphql_name='equalTo')
    not_equal_to = sgqlc.types.Field(MetricDatatype, graphql_name='notEqualTo')
    distinct_from = sgqlc.types.Field(MetricDatatype, graphql_name='distinctFrom')
    not_distinct_from = sgqlc.types.Field(MetricDatatype, graphql_name='notDistinctFrom')
    in_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(MetricDatatype)), graphql_name='in')
    not_in = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(MetricDatatype)), graphql_name='notIn')
    less_than = sgqlc.types.Field(MetricDatatype, graphql_name='lessThan')
    less_than_or_equal_to = sgqlc.types.Field(MetricDatatype, graphql_name='lessThanOrEqualTo')
    greater_than = sgqlc.types.Field(MetricDatatype, graphql_name='greaterThan')
    greater_than_or_equal_to = sgqlc.types.Field(MetricDatatype, graphql_name='greaterThanOrEqualTo')


class MetricMetadatumCondition(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('label', 'human_label', 'is_composite', 'is_sparse', 'is_internal', 'data_type', 'table', 'unit_dimension', 'unit', 'created_at', 'updated_at', 'expression')
    label = sgqlc.types.Field(String, graphql_name='label')
    human_label = sgqlc.types.Field(String, graphql_name='humanLabel')
    is_composite = sgqlc.types.Field(Boolean, graphql_name='isComposite')
    is_sparse = sgqlc.types.Field(Boolean, graphql_name='isSparse')
    is_internal = sgqlc.types.Field(Boolean, graphql_name='isInternal')
    data_type = sgqlc.types.Field(MetricDatatype, graphql_name='dataType')
    table = sgqlc.types.Field(String, graphql_name='table')
    unit_dimension = sgqlc.types.Field(String, graphql_name='unitDimension')
    unit = sgqlc.types.Field(String, graphql_name='unit')
    created_at = sgqlc.types.Field(Datetime, graphql_name='createdAt')
    updated_at = sgqlc.types.Field(Datetime, graphql_name='updatedAt')
    expression = sgqlc.types.Field(String, graphql_name='expression')


class MetricMetadatumFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('label', 'human_label', 'is_composite', 'is_sparse', 'is_internal', 'data_type', 'table', 'unit_dimension', 'unit', 'created_at', 'updated_at', 'expression', 'dependency_list', 'dependents_list', 'and_', 'or_', 'not_')
    label = sgqlc.types.Field('StringFilter', graphql_name='label')
    human_label = sgqlc.types.Field('StringFilter', graphql_name='humanLabel')
    is_composite = sgqlc.types.Field(BooleanFilter, graphql_name='isComposite')
    is_sparse = sgqlc.types.Field(BooleanFilter, graphql_name='isSparse')
    is_internal = sgqlc.types.Field(BooleanFilter, graphql_name='isInternal')
    data_type = sgqlc.types.Field(MetricDatatypeFilter, graphql_name='dataType')
    table = sgqlc.types.Field('StringFilter', graphql_name='table')
    unit_dimension = sgqlc.types.Field('StringFilter', graphql_name='unitDimension')
    unit = sgqlc.types.Field('StringFilter', graphql_name='unit')
    created_at = sgqlc.types.Field(DatetimeFilter, graphql_name='createdAt')
    updated_at = sgqlc.types.Field(DatetimeFilter, graphql_name='updatedAt')
    expression = sgqlc.types.Field('StringFilter', graphql_name='expression')
    dependency_list = sgqlc.types.Field('StringListFilter', graphql_name='dependencyList')
    dependents_list = sgqlc.types.Field('StringListFilter', graphql_name='dependentsList')
    and_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('MetricMetadatumFilter')), graphql_name='and')
    or_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('MetricMetadatumFilter')), graphql_name='or')
    not_ = sgqlc.types.Field('MetricMetadatumFilter', graphql_name='not')


class MonitorCondition(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'name', 'description', 'monitor_type', 'sampling_window', 'window', 'aggregation_method', 'condition', 'threshold_value', 'threshold_duration', 'is_enabled', 'created_at', 'updated_at')
    id = sgqlc.types.Field(Int, graphql_name='id')
    name = sgqlc.types.Field(String, graphql_name='name')
    description = sgqlc.types.Field(String, graphql_name='description')
    monitor_type = sgqlc.types.Field(MonitorType, graphql_name='monitorType')
    sampling_window = sgqlc.types.Field(IntervalInput, graphql_name='samplingWindow')
    window = sgqlc.types.Field(IntervalInput, graphql_name='window')
    aggregation_method = sgqlc.types.Field(String, graphql_name='aggregationMethod')
    condition = sgqlc.types.Field(ThresholdCondition, graphql_name='condition')
    threshold_value = sgqlc.types.Field(JSON, graphql_name='thresholdValue')
    threshold_duration = sgqlc.types.Field(IntervalInput, graphql_name='thresholdDuration')
    is_enabled = sgqlc.types.Field(Boolean, graphql_name='isEnabled')
    created_at = sgqlc.types.Field(Datetime, graphql_name='createdAt')
    updated_at = sgqlc.types.Field(Datetime, graphql_name='updatedAt')


class MonitorDataPointCondition(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('monitor_id', 'data_point_id', 'created_at')
    monitor_id = sgqlc.types.Field(Int, graphql_name='monitorId')
    data_point_id = sgqlc.types.Field(Int, graphql_name='dataPointId')
    created_at = sgqlc.types.Field(Datetime, graphql_name='createdAt')


class MonitorDataPointFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('monitor_id', 'data_point_id', 'created_at', 'and_', 'or_', 'not_')
    monitor_id = sgqlc.types.Field(IntFilter, graphql_name='monitorId')
    data_point_id = sgqlc.types.Field(IntFilter, graphql_name='dataPointId')
    created_at = sgqlc.types.Field(DatetimeFilter, graphql_name='createdAt')
    and_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('MonitorDataPointFilter')), graphql_name='and')
    or_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('MonitorDataPointFilter')), graphql_name='or')
    not_ = sgqlc.types.Field('MonitorDataPointFilter', graphql_name='not')


class MonitorDataPointInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('monitor_id', 'data_point_id', 'monitor', 'data_point')
    monitor_id = sgqlc.types.Field(Int, graphql_name='monitorId')
    data_point_id = sgqlc.types.Field(Int, graphql_name='dataPointId')
    monitor = sgqlc.types.Field('MonitorInput', graphql_name='monitor')
    data_point = sgqlc.types.Field(DataPointInput, graphql_name='dataPoint')


class MonitorDataPointPatch(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('monitor_id', 'data_point_id')
    monitor_id = sgqlc.types.Field(Int, graphql_name='monitorId')
    data_point_id = sgqlc.types.Field(Int, graphql_name='dataPointId')


class MonitorDetectionCondition(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'monitor_id', 'start_time', 'end_time', 'created_at', 'updated_at')
    id = sgqlc.types.Field(BigInt, graphql_name='id')
    monitor_id = sgqlc.types.Field(Int, graphql_name='monitorId')
    start_time = sgqlc.types.Field(Datetime, graphql_name='startTime')
    end_time = sgqlc.types.Field(Datetime, graphql_name='endTime')
    created_at = sgqlc.types.Field(Datetime, graphql_name='createdAt')
    updated_at = sgqlc.types.Field(Datetime, graphql_name='updatedAt')


class MonitorDetectionFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'monitor_id', 'start_time', 'end_time', 'created_at', 'updated_at', 'duration_seconds', 'and_', 'or_', 'not_')
    id = sgqlc.types.Field(BigIntFilter, graphql_name='id')
    monitor_id = sgqlc.types.Field(IntFilter, graphql_name='monitorId')
    start_time = sgqlc.types.Field(DatetimeFilter, graphql_name='startTime')
    end_time = sgqlc.types.Field(DatetimeFilter, graphql_name='endTime')
    created_at = sgqlc.types.Field(DatetimeFilter, graphql_name='createdAt')
    updated_at = sgqlc.types.Field(DatetimeFilter, graphql_name='updatedAt')
    duration_seconds = sgqlc.types.Field(IntFilter, graphql_name='durationSeconds')
    and_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('MonitorDetectionFilter')), graphql_name='and')
    or_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('MonitorDetectionFilter')), graphql_name='or')
    not_ = sgqlc.types.Field('MonitorDetectionFilter', graphql_name='not')


class MonitorDetectionInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('monitor_id', 'start_time', 'end_time', 'monitor')
    monitor_id = sgqlc.types.Field(Int, graphql_name='monitorId')
    start_time = sgqlc.types.Field(sgqlc.types.non_null(Datetime), graphql_name='startTime')
    end_time = sgqlc.types.Field(Datetime, graphql_name='endTime')
    monitor = sgqlc.types.Field('MonitorInput', graphql_name='monitor')


class MonitorDetectionPatch(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('monitor_id', 'start_time', 'end_time')
    monitor_id = sgqlc.types.Field(Int, graphql_name='monitorId')
    start_time = sgqlc.types.Field(Datetime, graphql_name='startTime')
    end_time = sgqlc.types.Field(Datetime, graphql_name='endTime')


class MonitorDetectionsHavingAverageInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'monitor_id', 'start_time', 'end_time', 'created_at', 'updated_at', 'duration_seconds')
    id = sgqlc.types.Field(HavingBigintFilter, graphql_name='id')
    monitor_id = sgqlc.types.Field(HavingIntFilter, graphql_name='monitorId')
    start_time = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='startTime')
    end_time = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='endTime')
    created_at = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='createdAt')
    updated_at = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='updatedAt')
    duration_seconds = sgqlc.types.Field('MonitorDetectionsHavingAverageMonitorDetectionsDurationSecondsInput', graphql_name='durationSeconds')


class MonitorDetectionsHavingAverageMonitorDetectionsDurationSecondsInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingIntFilter, graphql_name='filter')


class MonitorDetectionsHavingDistinctCountInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'monitor_id', 'start_time', 'end_time', 'created_at', 'updated_at', 'duration_seconds')
    id = sgqlc.types.Field(HavingBigintFilter, graphql_name='id')
    monitor_id = sgqlc.types.Field(HavingIntFilter, graphql_name='monitorId')
    start_time = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='startTime')
    end_time = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='endTime')
    created_at = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='createdAt')
    updated_at = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='updatedAt')
    duration_seconds = sgqlc.types.Field('MonitorDetectionsHavingDistinctCountMonitorDetectionsDurationSecondsInput', graphql_name='durationSeconds')


class MonitorDetectionsHavingDistinctCountMonitorDetectionsDurationSecondsInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingIntFilter, graphql_name='filter')


class MonitorDetectionsHavingDistinctInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'monitor_id', 'start_time', 'end_time', 'created_at', 'updated_at', 'duration_seconds')
    id = sgqlc.types.Field(HavingBigintFilter, graphql_name='id')
    monitor_id = sgqlc.types.Field(HavingIntFilter, graphql_name='monitorId')
    start_time = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='startTime')
    end_time = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='endTime')
    created_at = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='createdAt')
    updated_at = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='updatedAt')
    duration_seconds = sgqlc.types.Field('MonitorDetectionsHavingDistinctMonitorDetectionsDurationSecondsInput', graphql_name='durationSeconds')


class MonitorDetectionsHavingDistinctMonitorDetectionsDurationSecondsInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingIntFilter, graphql_name='filter')


class MonitorDetectionsHavingInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('and_', 'or_', 'sum', 'distinct_count', 'min', 'max', 'average', 'stddev_sample', 'stddev_population', 'variance_sample', 'variance_population', 'distinct')
    and_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('MonitorDetectionsHavingInput')), graphql_name='AND')
    or_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('MonitorDetectionsHavingInput')), graphql_name='OR')
    sum = sgqlc.types.Field('MonitorDetectionsHavingSumInput', graphql_name='sum')
    distinct_count = sgqlc.types.Field(MonitorDetectionsHavingDistinctCountInput, graphql_name='distinctCount')
    min = sgqlc.types.Field('MonitorDetectionsHavingMinInput', graphql_name='min')
    max = sgqlc.types.Field('MonitorDetectionsHavingMaxInput', graphql_name='max')
    average = sgqlc.types.Field(MonitorDetectionsHavingAverageInput, graphql_name='average')
    stddev_sample = sgqlc.types.Field('MonitorDetectionsHavingStddevSampleInput', graphql_name='stddevSample')
    stddev_population = sgqlc.types.Field('MonitorDetectionsHavingStddevPopulationInput', graphql_name='stddevPopulation')
    variance_sample = sgqlc.types.Field('MonitorDetectionsHavingVarianceSampleInput', graphql_name='varianceSample')
    variance_population = sgqlc.types.Field('MonitorDetectionsHavingVariancePopulationInput', graphql_name='variancePopulation')
    distinct = sgqlc.types.Field(MonitorDetectionsHavingDistinctInput, graphql_name='distinct')


class MonitorDetectionsHavingMaxInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'monitor_id', 'start_time', 'end_time', 'created_at', 'updated_at', 'duration_seconds')
    id = sgqlc.types.Field(HavingBigintFilter, graphql_name='id')
    monitor_id = sgqlc.types.Field(HavingIntFilter, graphql_name='monitorId')
    start_time = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='startTime')
    end_time = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='endTime')
    created_at = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='createdAt')
    updated_at = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='updatedAt')
    duration_seconds = sgqlc.types.Field('MonitorDetectionsHavingMaxMonitorDetectionsDurationSecondsInput', graphql_name='durationSeconds')


class MonitorDetectionsHavingMaxMonitorDetectionsDurationSecondsInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingIntFilter, graphql_name='filter')


class MonitorDetectionsHavingMinInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'monitor_id', 'start_time', 'end_time', 'created_at', 'updated_at', 'duration_seconds')
    id = sgqlc.types.Field(HavingBigintFilter, graphql_name='id')
    monitor_id = sgqlc.types.Field(HavingIntFilter, graphql_name='monitorId')
    start_time = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='startTime')
    end_time = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='endTime')
    created_at = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='createdAt')
    updated_at = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='updatedAt')
    duration_seconds = sgqlc.types.Field('MonitorDetectionsHavingMinMonitorDetectionsDurationSecondsInput', graphql_name='durationSeconds')


class MonitorDetectionsHavingMinMonitorDetectionsDurationSecondsInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingIntFilter, graphql_name='filter')


class MonitorDetectionsHavingStddevPopulationInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'monitor_id', 'start_time', 'end_time', 'created_at', 'updated_at', 'duration_seconds')
    id = sgqlc.types.Field(HavingBigintFilter, graphql_name='id')
    monitor_id = sgqlc.types.Field(HavingIntFilter, graphql_name='monitorId')
    start_time = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='startTime')
    end_time = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='endTime')
    created_at = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='createdAt')
    updated_at = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='updatedAt')
    duration_seconds = sgqlc.types.Field('MonitorDetectionsHavingStddevPopulationMonitorDetectionsDurationSecondsInput', graphql_name='durationSeconds')


class MonitorDetectionsHavingStddevPopulationMonitorDetectionsDurationSecondsInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingIntFilter, graphql_name='filter')


class MonitorDetectionsHavingStddevSampleInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'monitor_id', 'start_time', 'end_time', 'created_at', 'updated_at', 'duration_seconds')
    id = sgqlc.types.Field(HavingBigintFilter, graphql_name='id')
    monitor_id = sgqlc.types.Field(HavingIntFilter, graphql_name='monitorId')
    start_time = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='startTime')
    end_time = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='endTime')
    created_at = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='createdAt')
    updated_at = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='updatedAt')
    duration_seconds = sgqlc.types.Field('MonitorDetectionsHavingStddevSampleMonitorDetectionsDurationSecondsInput', graphql_name='durationSeconds')


class MonitorDetectionsHavingStddevSampleMonitorDetectionsDurationSecondsInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingIntFilter, graphql_name='filter')


class MonitorDetectionsHavingSumInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'monitor_id', 'start_time', 'end_time', 'created_at', 'updated_at', 'duration_seconds')
    id = sgqlc.types.Field(HavingBigintFilter, graphql_name='id')
    monitor_id = sgqlc.types.Field(HavingIntFilter, graphql_name='monitorId')
    start_time = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='startTime')
    end_time = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='endTime')
    created_at = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='createdAt')
    updated_at = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='updatedAt')
    duration_seconds = sgqlc.types.Field('MonitorDetectionsHavingSumMonitorDetectionsDurationSecondsInput', graphql_name='durationSeconds')


class MonitorDetectionsHavingSumMonitorDetectionsDurationSecondsInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingIntFilter, graphql_name='filter')


class MonitorDetectionsHavingVariancePopulationInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'monitor_id', 'start_time', 'end_time', 'created_at', 'updated_at', 'duration_seconds')
    id = sgqlc.types.Field(HavingBigintFilter, graphql_name='id')
    monitor_id = sgqlc.types.Field(HavingIntFilter, graphql_name='monitorId')
    start_time = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='startTime')
    end_time = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='endTime')
    created_at = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='createdAt')
    updated_at = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='updatedAt')
    duration_seconds = sgqlc.types.Field('MonitorDetectionsHavingVariancePopulationMonitorDetectionsDurationSecondsInput', graphql_name='durationSeconds')


class MonitorDetectionsHavingVariancePopulationMonitorDetectionsDurationSecondsInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingIntFilter, graphql_name='filter')


class MonitorDetectionsHavingVarianceSampleInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'monitor_id', 'start_time', 'end_time', 'created_at', 'updated_at', 'duration_seconds')
    id = sgqlc.types.Field(HavingBigintFilter, graphql_name='id')
    monitor_id = sgqlc.types.Field(HavingIntFilter, graphql_name='monitorId')
    start_time = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='startTime')
    end_time = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='endTime')
    created_at = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='createdAt')
    updated_at = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='updatedAt')
    duration_seconds = sgqlc.types.Field('MonitorDetectionsHavingVarianceSampleMonitorDetectionsDurationSecondsInput', graphql_name='durationSeconds')


class MonitorDetectionsHavingVarianceSampleMonitorDetectionsDurationSecondsInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingIntFilter, graphql_name='filter')


class MonitorFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'name', 'description', 'monitor_type', 'sampling_window', 'window', 'aggregation_method', 'condition', 'threshold_value', 'threshold_duration', 'is_enabled', 'created_at', 'updated_at', 'facility_ids', 'is_monitoring', 'is_triggered', 'and_', 'or_', 'not_')
    id = sgqlc.types.Field(IntFilter, graphql_name='id')
    name = sgqlc.types.Field('StringFilter', graphql_name='name')
    description = sgqlc.types.Field('StringFilter', graphql_name='description')
    monitor_type = sgqlc.types.Field('MonitorTypeFilter', graphql_name='monitorType')
    sampling_window = sgqlc.types.Field(IntervalFilter, graphql_name='samplingWindow')
    window = sgqlc.types.Field(IntervalFilter, graphql_name='window')
    aggregation_method = sgqlc.types.Field('StringFilter', graphql_name='aggregationMethod')
    condition = sgqlc.types.Field('ThresholdConditionFilter', graphql_name='condition')
    threshold_value = sgqlc.types.Field(JSONFilter, graphql_name='thresholdValue')
    threshold_duration = sgqlc.types.Field(IntervalFilter, graphql_name='thresholdDuration')
    is_enabled = sgqlc.types.Field(BooleanFilter, graphql_name='isEnabled')
    created_at = sgqlc.types.Field(DatetimeFilter, graphql_name='createdAt')
    updated_at = sgqlc.types.Field(DatetimeFilter, graphql_name='updatedAt')
    facility_ids = sgqlc.types.Field(IntListFilter, graphql_name='facilityIds')
    is_monitoring = sgqlc.types.Field(BooleanFilter, graphql_name='isMonitoring')
    is_triggered = sgqlc.types.Field(BooleanFilter, graphql_name='isTriggered')
    and_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('MonitorFilter')), graphql_name='and')
    or_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('MonitorFilter')), graphql_name='or')
    not_ = sgqlc.types.Field('MonitorFilter', graphql_name='not')


class MonitorInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('name', 'description', 'sampling_window', 'window', 'aggregation_method', 'condition', 'threshold_value', 'threshold_duration', 'is_enabled', 'data_point_ids')
    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='name')
    description = sgqlc.types.Field(String, graphql_name='description')
    sampling_window = sgqlc.types.Field(IntervalInput, graphql_name='samplingWindow')
    window = sgqlc.types.Field(IntervalInput, graphql_name='window')
    aggregation_method = sgqlc.types.Field(MetricDataAggregationMethod, graphql_name='aggregationMethod')
    condition = sgqlc.types.Field(ThresholdCondition, graphql_name='condition')
    threshold_value = sgqlc.types.Field(sgqlc.types.non_null(JSON), graphql_name='thresholdValue')
    threshold_duration = sgqlc.types.Field(IntervalInput, graphql_name='thresholdDuration')
    is_enabled = sgqlc.types.Field(Boolean, graphql_name='isEnabled')
    data_point_ids = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(BigInt)), graphql_name='dataPointIds')


class MonitorPatch(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('name', 'description', 'sampling_window', 'window', 'aggregation_method', 'condition', 'threshold_value', 'threshold_duration', 'is_enabled', 'data_point_ids')
    name = sgqlc.types.Field(String, graphql_name='name')
    description = sgqlc.types.Field(String, graphql_name='description')
    sampling_window = sgqlc.types.Field(IntervalInput, graphql_name='samplingWindow')
    window = sgqlc.types.Field(IntervalInput, graphql_name='window')
    aggregation_method = sgqlc.types.Field(MetricDataAggregationMethod, graphql_name='aggregationMethod')
    condition = sgqlc.types.Field(ThresholdCondition, graphql_name='condition')
    threshold_value = sgqlc.types.Field(JSON, graphql_name='thresholdValue')
    threshold_duration = sgqlc.types.Field(IntervalInput, graphql_name='thresholdDuration')
    is_enabled = sgqlc.types.Field(Boolean, graphql_name='isEnabled')
    data_point_ids = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(BigInt)), graphql_name='dataPointIds')


class MonitorTypeFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('is_null', 'equal_to', 'not_equal_to', 'distinct_from', 'not_distinct_from', 'in_', 'not_in', 'less_than', 'less_than_or_equal_to', 'greater_than', 'greater_than_or_equal_to')
    is_null = sgqlc.types.Field(Boolean, graphql_name='isNull')
    equal_to = sgqlc.types.Field(MonitorType, graphql_name='equalTo')
    not_equal_to = sgqlc.types.Field(MonitorType, graphql_name='notEqualTo')
    distinct_from = sgqlc.types.Field(MonitorType, graphql_name='distinctFrom')
    not_distinct_from = sgqlc.types.Field(MonitorType, graphql_name='notDistinctFrom')
    in_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(MonitorType)), graphql_name='in')
    not_in = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(MonitorType)), graphql_name='notIn')
    less_than = sgqlc.types.Field(MonitorType, graphql_name='lessThan')
    less_than_or_equal_to = sgqlc.types.Field(MonitorType, graphql_name='lessThanOrEqualTo')
    greater_than = sgqlc.types.Field(MonitorType, graphql_name='greaterThan')
    greater_than_or_equal_to = sgqlc.types.Field(MonitorType, graphql_name='greaterThanOrEqualTo')


class PatchControlEventRemoteMetadataInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'control_event_id', 'patched_metadata')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    control_event_id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='controlEventId')
    patched_metadata = sgqlc.types.Field(sgqlc.types.non_null(JSON), graphql_name='patchedMetadata')


class PermissionBooleanFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('equal_to',)
    equal_to = sgqlc.types.Field(Boolean, graphql_name='equalTo')


class PlatformAccessTokenCondition(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'type', 'description', 'owner_id', 'created_at', 'expires_at')
    id = sgqlc.types.Field(BigInt, graphql_name='id')
    type = sgqlc.types.Field(AccessTokenType, graphql_name='type')
    description = sgqlc.types.Field(String, graphql_name='description')
    owner_id = sgqlc.types.Field(String, graphql_name='ownerId')
    created_at = sgqlc.types.Field(Datetime, graphql_name='createdAt')
    expires_at = sgqlc.types.Field(Datetime, graphql_name='expiresAt')


class PlatformAccessTokenFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'type', 'description', 'owner_id', 'created_at', 'expires_at', 'and_', 'or_', 'not_')
    id = sgqlc.types.Field(BigIntFilter, graphql_name='id')
    type = sgqlc.types.Field(AccessTokenTypeFilter, graphql_name='type')
    description = sgqlc.types.Field('StringFilter', graphql_name='description')
    owner_id = sgqlc.types.Field('StringFilter', graphql_name='ownerId')
    created_at = sgqlc.types.Field(DatetimeFilter, graphql_name='createdAt')
    expires_at = sgqlc.types.Field(DatetimeFilter, graphql_name='expiresAt')
    and_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('PlatformAccessTokenFilter')), graphql_name='and')
    or_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('PlatformAccessTokenFilter')), graphql_name='or')
    not_ = sgqlc.types.Field('PlatformAccessTokenFilter', graphql_name='not')


class PlatformCapabilityAccessDefinition(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('capability', 'enable_read', 'enable_write')
    capability = sgqlc.types.Field(sgqlc.types.non_null(PlatformCapability), graphql_name='capability')
    enable_read = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name='enableRead')
    enable_write = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name='enableWrite')


class PricingNodeCondition(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'balancing_authority_id', 'slug', 'geometry', 'created_at', 'updated_at', 'name')
    id = sgqlc.types.Field(Int, graphql_name='id')
    balancing_authority_id = sgqlc.types.Field(Int, graphql_name='balancingAuthorityId')
    slug = sgqlc.types.Field(String, graphql_name='slug')
    geometry = sgqlc.types.Field(GeoJSON, graphql_name='geometry')
    created_at = sgqlc.types.Field(Datetime, graphql_name='createdAt')
    updated_at = sgqlc.types.Field(Datetime, graphql_name='updatedAt')
    name = sgqlc.types.Field(String, graphql_name='name')


class PricingNodeFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'balancing_authority_id', 'slug', 'created_at', 'updated_at', 'name', 'and_', 'or_', 'not_')
    id = sgqlc.types.Field(IntFilter, graphql_name='id')
    balancing_authority_id = sgqlc.types.Field(IntFilter, graphql_name='balancingAuthorityId')
    slug = sgqlc.types.Field('StringFilter', graphql_name='slug')
    created_at = sgqlc.types.Field(DatetimeFilter, graphql_name='createdAt')
    updated_at = sgqlc.types.Field(DatetimeFilter, graphql_name='updatedAt')
    name = sgqlc.types.Field('StringFilter', graphql_name='name')
    and_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('PricingNodeFilter')), graphql_name='and')
    or_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('PricingNodeFilter')), graphql_name='or')
    not_ = sgqlc.types.Field('PricingNodeFilter', graphql_name='not')


class PricingNodeInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('balancing_authority_id', 'slug', 'geometry', 'name', 'balancing_authority')
    balancing_authority_id = sgqlc.types.Field(Int, graphql_name='balancingAuthorityId')
    slug = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='slug')
    geometry = sgqlc.types.Field(GeoJSON, graphql_name='geometry')
    name = sgqlc.types.Field(String, graphql_name='name')
    balancing_authority = sgqlc.types.Field(BalancingAuthorityInput, graphql_name='balancingAuthority')


class PricingNodePatch(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('balancing_authority_id', 'slug', 'geometry', 'name')
    balancing_authority_id = sgqlc.types.Field(Int, graphql_name='balancingAuthorityId')
    slug = sgqlc.types.Field(String, graphql_name='slug')
    geometry = sgqlc.types.Field(GeoJSON, graphql_name='geometry')
    name = sgqlc.types.Field(String, graphql_name='name')


class ProgramCondition(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'project_type_id', 'name', 'description', 'created_at', 'updated_at')
    id = sgqlc.types.Field(Int, graphql_name='id')
    project_type_id = sgqlc.types.Field(Int, graphql_name='projectTypeId')
    name = sgqlc.types.Field(String, graphql_name='name')
    description = sgqlc.types.Field(String, graphql_name='description')
    created_at = sgqlc.types.Field(Datetime, graphql_name='createdAt')
    updated_at = sgqlc.types.Field(Datetime, graphql_name='updatedAt')


class ProgramEnrollmentCondition(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'program_id', 'name', 'start_date', 'end_date', 'created_at', 'updated_at')
    id = sgqlc.types.Field(Int, graphql_name='id')
    program_id = sgqlc.types.Field(Int, graphql_name='programId')
    name = sgqlc.types.Field(String, graphql_name='name')
    start_date = sgqlc.types.Field(Datetime, graphql_name='startDate')
    end_date = sgqlc.types.Field(Datetime, graphql_name='endDate')
    created_at = sgqlc.types.Field(Datetime, graphql_name='createdAt')
    updated_at = sgqlc.types.Field(Datetime, graphql_name='updatedAt')


class ProgramEnrollmentFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'program_id', 'name', 'start_date', 'end_date', 'created_at', 'updated_at', 'and_', 'or_', 'not_')
    id = sgqlc.types.Field(IntFilter, graphql_name='id')
    program_id = sgqlc.types.Field(IntFilter, graphql_name='programId')
    name = sgqlc.types.Field('StringFilter', graphql_name='name')
    start_date = sgqlc.types.Field(DatetimeFilter, graphql_name='startDate')
    end_date = sgqlc.types.Field(DatetimeFilter, graphql_name='endDate')
    created_at = sgqlc.types.Field(DatetimeFilter, graphql_name='createdAt')
    updated_at = sgqlc.types.Field(DatetimeFilter, graphql_name='updatedAt')
    and_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('ProgramEnrollmentFilter')), graphql_name='and')
    or_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('ProgramEnrollmentFilter')), graphql_name='or')
    not_ = sgqlc.types.Field('ProgramEnrollmentFilter', graphql_name='not')


class ProgramEnrollmentInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('program_id', 'name', 'start_date', 'end_date', 'created_at', 'updated_at', 'program')
    program_id = sgqlc.types.Field(Int, graphql_name='programId')
    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='name')
    start_date = sgqlc.types.Field(sgqlc.types.non_null(Datetime), graphql_name='startDate')
    end_date = sgqlc.types.Field(sgqlc.types.non_null(Datetime), graphql_name='endDate')
    created_at = sgqlc.types.Field(Datetime, graphql_name='createdAt')
    updated_at = sgqlc.types.Field(Datetime, graphql_name='updatedAt')
    program = sgqlc.types.Field('ProgramInput', graphql_name='program')


class ProgramEnrollmentPatch(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('name', 'start_date', 'end_date')
    name = sgqlc.types.Field(String, graphql_name='name')
    start_date = sgqlc.types.Field(Datetime, graphql_name='startDate')
    end_date = sgqlc.types.Field(Datetime, graphql_name='endDate')


class ProgramFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'project_type_id', 'name', 'description', 'created_at', 'updated_at', 'and_', 'or_', 'not_')
    id = sgqlc.types.Field(IntFilter, graphql_name='id')
    project_type_id = sgqlc.types.Field(IntFilter, graphql_name='projectTypeId')
    name = sgqlc.types.Field('StringFilter', graphql_name='name')
    description = sgqlc.types.Field('StringFilter', graphql_name='description')
    created_at = sgqlc.types.Field(DatetimeFilter, graphql_name='createdAt')
    updated_at = sgqlc.types.Field(DatetimeFilter, graphql_name='updatedAt')
    and_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('ProgramFilter')), graphql_name='and')
    or_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('ProgramFilter')), graphql_name='or')
    not_ = sgqlc.types.Field('ProgramFilter', graphql_name='not')


class ProgramInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('project_type_id', 'name', 'description')
    project_type_id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='projectTypeId')
    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='name')
    description = sgqlc.types.Field(String, graphql_name='description')


class ProgramPatch(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('project_type_id', 'name', 'description')
    project_type_id = sgqlc.types.Field(Int, graphql_name='projectTypeId')
    name = sgqlc.types.Field(String, graphql_name='name')
    description = sgqlc.types.Field(String, graphql_name='description')


class ProjectComponentCondition(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('project_id', 'component_id', 'startup_offset', 'maximum_control_duration', 'control_scheme')
    project_id = sgqlc.types.Field(Int, graphql_name='projectId')
    component_id = sgqlc.types.Field(Int, graphql_name='componentId')
    startup_offset = sgqlc.types.Field(Int, graphql_name='startupOffset')
    maximum_control_duration = sgqlc.types.Field(Int, graphql_name='maximumControlDuration')
    control_scheme = sgqlc.types.Field(String, graphql_name='controlScheme')


class ProjectComponentFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('project_id', 'component_id', 'startup_offset', 'maximum_control_duration', 'control_scheme', 'and_', 'or_', 'not_')
    project_id = sgqlc.types.Field(IntFilter, graphql_name='projectId')
    component_id = sgqlc.types.Field(IntFilter, graphql_name='componentId')
    startup_offset = sgqlc.types.Field(IntFilter, graphql_name='startupOffset')
    maximum_control_duration = sgqlc.types.Field(IntFilter, graphql_name='maximumControlDuration')
    control_scheme = sgqlc.types.Field('StringFilter', graphql_name='controlScheme')
    and_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('ProjectComponentFilter')), graphql_name='and')
    or_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('ProjectComponentFilter')), graphql_name='or')
    not_ = sgqlc.types.Field('ProjectComponentFilter', graphql_name='not')


class ProjectComponentInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('project_id', 'component_id', 'startup_offset', 'maximum_control_duration', 'control_scheme')
    project_id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='projectId')
    component_id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='componentId')
    startup_offset = sgqlc.types.Field(Int, graphql_name='startupOffset')
    maximum_control_duration = sgqlc.types.Field(Int, graphql_name='maximumControlDuration')
    control_scheme = sgqlc.types.Field(String, graphql_name='controlScheme')


class ProjectComponentPatch(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('project_id', 'component_id', 'startup_offset', 'maximum_control_duration', 'control_scheme')
    project_id = sgqlc.types.Field(Int, graphql_name='projectId')
    component_id = sgqlc.types.Field(Int, graphql_name='componentId')
    startup_offset = sgqlc.types.Field(Int, graphql_name='startupOffset')
    maximum_control_duration = sgqlc.types.Field(Int, graphql_name='maximumControlDuration')
    control_scheme = sgqlc.types.Field(String, graphql_name='controlScheme')


class ProjectCondition(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'facility_id', 'project_type_id', 'name', 'description', 'auto_acknowledge', 'start_date', 'end_date', 'created_at', 'updated_at', 'acknowledgement_window_threshold', 'start_timeout', 'end_timeout', 'program_id', 'config')
    id = sgqlc.types.Field(Int, graphql_name='id')
    facility_id = sgqlc.types.Field(Int, graphql_name='facilityId')
    project_type_id = sgqlc.types.Field(Int, graphql_name='projectTypeId')
    name = sgqlc.types.Field(String, graphql_name='name')
    description = sgqlc.types.Field(String, graphql_name='description')
    auto_acknowledge = sgqlc.types.Field(Boolean, graphql_name='autoAcknowledge')
    start_date = sgqlc.types.Field(Date, graphql_name='startDate')
    end_date = sgqlc.types.Field(Date, graphql_name='endDate')
    created_at = sgqlc.types.Field(Datetime, graphql_name='createdAt')
    updated_at = sgqlc.types.Field(Datetime, graphql_name='updatedAt')
    acknowledgement_window_threshold = sgqlc.types.Field(Int, graphql_name='acknowledgementWindowThreshold')
    start_timeout = sgqlc.types.Field(Int, graphql_name='startTimeout')
    end_timeout = sgqlc.types.Field(Int, graphql_name='endTimeout')
    program_id = sgqlc.types.Field(Int, graphql_name='programId')
    config = sgqlc.types.Field(JSON, graphql_name='config')


class ProjectConfigCondition(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'project_id', 'key', 'value', 'created_at', 'updated_at')
    id = sgqlc.types.Field(Int, graphql_name='id')
    project_id = sgqlc.types.Field(Int, graphql_name='projectId')
    key = sgqlc.types.Field(String, graphql_name='key')
    value = sgqlc.types.Field(JSON, graphql_name='value')
    created_at = sgqlc.types.Field(Datetime, graphql_name='createdAt')
    updated_at = sgqlc.types.Field(Datetime, graphql_name='updatedAt')


class ProjectConfigFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'project_id', 'key', 'value', 'created_at', 'updated_at', 'and_', 'or_', 'not_')
    id = sgqlc.types.Field(IntFilter, graphql_name='id')
    project_id = sgqlc.types.Field(IntFilter, graphql_name='projectId')
    key = sgqlc.types.Field('StringFilter', graphql_name='key')
    value = sgqlc.types.Field(JSONFilter, graphql_name='value')
    created_at = sgqlc.types.Field(DatetimeFilter, graphql_name='createdAt')
    updated_at = sgqlc.types.Field(DatetimeFilter, graphql_name='updatedAt')
    and_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('ProjectConfigFilter')), graphql_name='and')
    or_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('ProjectConfigFilter')), graphql_name='or')
    not_ = sgqlc.types.Field('ProjectConfigFilter', graphql_name='not')


class ProjectEnrollmentCondition(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'project_id', 'program_enrollment_id', 'created_at', 'updated_at')
    id = sgqlc.types.Field(Int, graphql_name='id')
    project_id = sgqlc.types.Field(Int, graphql_name='projectId')
    program_enrollment_id = sgqlc.types.Field(Int, graphql_name='programEnrollmentId')
    created_at = sgqlc.types.Field(Datetime, graphql_name='createdAt')
    updated_at = sgqlc.types.Field(Datetime, graphql_name='updatedAt')


class ProjectEnrollmentDataPointCondition(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'project_enrollment_id', 'data_point_id', 'project_enrollment_data_point_group_id', 'alias', 'target', 'rate', 'created_at', 'updated_at')
    id = sgqlc.types.Field(Int, graphql_name='id')
    project_enrollment_id = sgqlc.types.Field(Int, graphql_name='projectEnrollmentId')
    data_point_id = sgqlc.types.Field(Int, graphql_name='dataPointId')
    project_enrollment_data_point_group_id = sgqlc.types.Field(Int, graphql_name='projectEnrollmentDataPointGroupId')
    alias = sgqlc.types.Field(String, graphql_name='alias')
    target = sgqlc.types.Field(BigFloat, graphql_name='target')
    rate = sgqlc.types.Field(JSON, graphql_name='rate')
    created_at = sgqlc.types.Field(Datetime, graphql_name='createdAt')
    updated_at = sgqlc.types.Field(Datetime, graphql_name='updatedAt')


class ProjectEnrollmentDataPointFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'project_enrollment_id', 'data_point_id', 'project_enrollment_data_point_group_id', 'alias', 'target', 'rate', 'created_at', 'updated_at', 'and_', 'or_', 'not_')
    id = sgqlc.types.Field(IntFilter, graphql_name='id')
    project_enrollment_id = sgqlc.types.Field(IntFilter, graphql_name='projectEnrollmentId')
    data_point_id = sgqlc.types.Field(IntFilter, graphql_name='dataPointId')
    project_enrollment_data_point_group_id = sgqlc.types.Field(IntFilter, graphql_name='projectEnrollmentDataPointGroupId')
    alias = sgqlc.types.Field('StringFilter', graphql_name='alias')
    target = sgqlc.types.Field(BigFloatFilter, graphql_name='target')
    rate = sgqlc.types.Field(JSONFilter, graphql_name='rate')
    created_at = sgqlc.types.Field(DatetimeFilter, graphql_name='createdAt')
    updated_at = sgqlc.types.Field(DatetimeFilter, graphql_name='updatedAt')
    and_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('ProjectEnrollmentDataPointFilter')), graphql_name='and')
    or_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('ProjectEnrollmentDataPointFilter')), graphql_name='or')
    not_ = sgqlc.types.Field('ProjectEnrollmentDataPointFilter', graphql_name='not')


class ProjectEnrollmentDataPointGroupCondition(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'label', 'description', 'created_at', 'updated_at')
    id = sgqlc.types.Field(Int, graphql_name='id')
    label = sgqlc.types.Field(String, graphql_name='label')
    description = sgqlc.types.Field(String, graphql_name='description')
    created_at = sgqlc.types.Field(Datetime, graphql_name='createdAt')
    updated_at = sgqlc.types.Field(Datetime, graphql_name='updatedAt')


class ProjectEnrollmentDataPointGroupFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'label', 'description', 'created_at', 'updated_at', 'and_', 'or_', 'not_')
    id = sgqlc.types.Field(IntFilter, graphql_name='id')
    label = sgqlc.types.Field('StringFilter', graphql_name='label')
    description = sgqlc.types.Field('StringFilter', graphql_name='description')
    created_at = sgqlc.types.Field(DatetimeFilter, graphql_name='createdAt')
    updated_at = sgqlc.types.Field(DatetimeFilter, graphql_name='updatedAt')
    and_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('ProjectEnrollmentDataPointGroupFilter')), graphql_name='and')
    or_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('ProjectEnrollmentDataPointGroupFilter')), graphql_name='or')
    not_ = sgqlc.types.Field('ProjectEnrollmentDataPointGroupFilter', graphql_name='not')


class ProjectEnrollmentDataPointGroupInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('label', 'description', 'created_at', 'updated_at')
    label = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='label')
    description = sgqlc.types.Field(String, graphql_name='description')
    created_at = sgqlc.types.Field(Datetime, graphql_name='createdAt')
    updated_at = sgqlc.types.Field(Datetime, graphql_name='updatedAt')


class ProjectEnrollmentDataPointGroupPatch(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('label', 'description')
    label = sgqlc.types.Field(String, graphql_name='label')
    description = sgqlc.types.Field(String, graphql_name='description')


class ProjectEnrollmentDataPointInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('project_enrollment_id', 'data_point_id', 'project_enrollment_data_point_group_id', 'alias', 'target', 'rate', 'created_at', 'updated_at', 'project_enrollment', 'data_point', 'project_enrollment_data_point_group')
    project_enrollment_id = sgqlc.types.Field(Int, graphql_name='projectEnrollmentId')
    data_point_id = sgqlc.types.Field(Int, graphql_name='dataPointId')
    project_enrollment_data_point_group_id = sgqlc.types.Field(Int, graphql_name='projectEnrollmentDataPointGroupId')
    alias = sgqlc.types.Field(String, graphql_name='alias')
    target = sgqlc.types.Field(BigFloat, graphql_name='target')
    rate = sgqlc.types.Field(JSON, graphql_name='rate')
    created_at = sgqlc.types.Field(Datetime, graphql_name='createdAt')
    updated_at = sgqlc.types.Field(Datetime, graphql_name='updatedAt')
    project_enrollment = sgqlc.types.Field('ProjectEnrollmentInput', graphql_name='projectEnrollment')
    data_point = sgqlc.types.Field(DataPointInput, graphql_name='dataPoint')
    project_enrollment_data_point_group = sgqlc.types.Field(ProjectEnrollmentDataPointGroupInput, graphql_name='projectEnrollmentDataPointGroup')


class ProjectEnrollmentDataPointPatch(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('alias', 'target', 'rate')
    alias = sgqlc.types.Field(String, graphql_name='alias')
    target = sgqlc.types.Field(BigFloat, graphql_name='target')
    rate = sgqlc.types.Field(JSON, graphql_name='rate')


class ProjectEnrollmentFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'project_id', 'program_enrollment_id', 'created_at', 'updated_at', 'end_date', 'start_date', 'and_', 'or_', 'not_')
    id = sgqlc.types.Field(IntFilter, graphql_name='id')
    project_id = sgqlc.types.Field(IntFilter, graphql_name='projectId')
    program_enrollment_id = sgqlc.types.Field(IntFilter, graphql_name='programEnrollmentId')
    created_at = sgqlc.types.Field(DatetimeFilter, graphql_name='createdAt')
    updated_at = sgqlc.types.Field(DatetimeFilter, graphql_name='updatedAt')
    end_date = sgqlc.types.Field(DatetimeFilter, graphql_name='endDate')
    start_date = sgqlc.types.Field(DatetimeFilter, graphql_name='startDate')
    and_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('ProjectEnrollmentFilter')), graphql_name='and')
    or_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('ProjectEnrollmentFilter')), graphql_name='or')
    not_ = sgqlc.types.Field('ProjectEnrollmentFilter', graphql_name='not')


class ProjectEnrollmentInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('project_id', 'program_enrollment_id', 'created_at', 'updated_at', 'program_enrollment')
    project_id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='projectId')
    program_enrollment_id = sgqlc.types.Field(Int, graphql_name='programEnrollmentId')
    created_at = sgqlc.types.Field(Datetime, graphql_name='createdAt')
    updated_at = sgqlc.types.Field(Datetime, graphql_name='updatedAt')
    program_enrollment = sgqlc.types.Field(ProgramEnrollmentInput, graphql_name='programEnrollment')


class ProjectFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('can_control', 'id', 'facility_id', 'project_type_id', 'name', 'description', 'auto_acknowledge', 'start_date', 'end_date', 'created_at', 'updated_at', 'acknowledgement_window_threshold', 'start_timeout', 'end_timeout', 'program_id', 'config', 'control_type', 'facility_name', 'is_watching', 'program_name', 'project_type_name', 'subscribed_channels', 'and_', 'or_', 'not_')
    can_control = sgqlc.types.Field(PermissionBooleanFilter, graphql_name='canControl')
    id = sgqlc.types.Field(IntFilter, graphql_name='id')
    facility_id = sgqlc.types.Field(IntFilter, graphql_name='facilityId')
    project_type_id = sgqlc.types.Field(IntFilter, graphql_name='projectTypeId')
    name = sgqlc.types.Field('StringFilter', graphql_name='name')
    description = sgqlc.types.Field('StringFilter', graphql_name='description')
    auto_acknowledge = sgqlc.types.Field(BooleanFilter, graphql_name='autoAcknowledge')
    start_date = sgqlc.types.Field(DateFilter, graphql_name='startDate')
    end_date = sgqlc.types.Field(DateFilter, graphql_name='endDate')
    created_at = sgqlc.types.Field(DatetimeFilter, graphql_name='createdAt')
    updated_at = sgqlc.types.Field(DatetimeFilter, graphql_name='updatedAt')
    acknowledgement_window_threshold = sgqlc.types.Field(IntFilter, graphql_name='acknowledgementWindowThreshold')
    start_timeout = sgqlc.types.Field(IntFilter, graphql_name='startTimeout')
    end_timeout = sgqlc.types.Field(IntFilter, graphql_name='endTimeout')
    program_id = sgqlc.types.Field(IntFilter, graphql_name='programId')
    config = sgqlc.types.Field(JSONFilter, graphql_name='config')
    control_type = sgqlc.types.Field(ControlTypeFilter, graphql_name='controlType')
    facility_name = sgqlc.types.Field('StringFilter', graphql_name='facilityName')
    is_watching = sgqlc.types.Field(BooleanFilter, graphql_name='isWatching')
    program_name = sgqlc.types.Field('StringFilter', graphql_name='programName')
    project_type_name = sgqlc.types.Field('StringFilter', graphql_name='projectTypeName')
    subscribed_channels = sgqlc.types.Field('UserSubscriptionChannelListFilter', graphql_name='subscribedChannels')
    and_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('ProjectFilter')), graphql_name='and')
    or_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('ProjectFilter')), graphql_name='or')
    not_ = sgqlc.types.Field('ProjectFilter', graphql_name='not')


class ProjectInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('facility_id', 'project_type_id', 'name', 'description', 'auto_acknowledge', 'start_date', 'end_date', 'acknowledgement_window_threshold', 'start_timeout', 'end_timeout', 'program_id', 'program')
    facility_id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='facilityId')
    project_type_id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='projectTypeId')
    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='name')
    description = sgqlc.types.Field(String, graphql_name='description')
    auto_acknowledge = sgqlc.types.Field(Boolean, graphql_name='autoAcknowledge')
    start_date = sgqlc.types.Field(Date, graphql_name='startDate')
    end_date = sgqlc.types.Field(Date, graphql_name='endDate')
    acknowledgement_window_threshold = sgqlc.types.Field(Int, graphql_name='acknowledgementWindowThreshold')
    start_timeout = sgqlc.types.Field(Int, graphql_name='startTimeout')
    end_timeout = sgqlc.types.Field(Int, graphql_name='endTimeout')
    program_id = sgqlc.types.Field(Int, graphql_name='programId')
    program = sgqlc.types.Field(ProgramInput, graphql_name='program')


class ProjectPatch(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('facility_id', 'project_type_id', 'name', 'description', 'auto_acknowledge', 'start_date', 'end_date', 'acknowledgement_window_threshold', 'start_timeout', 'end_timeout', 'program_id')
    facility_id = sgqlc.types.Field(Int, graphql_name='facilityId')
    project_type_id = sgqlc.types.Field(Int, graphql_name='projectTypeId')
    name = sgqlc.types.Field(String, graphql_name='name')
    description = sgqlc.types.Field(String, graphql_name='description')
    auto_acknowledge = sgqlc.types.Field(Boolean, graphql_name='autoAcknowledge')
    start_date = sgqlc.types.Field(Date, graphql_name='startDate')
    end_date = sgqlc.types.Field(Date, graphql_name='endDate')
    acknowledgement_window_threshold = sgqlc.types.Field(Int, graphql_name='acknowledgementWindowThreshold')
    start_timeout = sgqlc.types.Field(Int, graphql_name='startTimeout')
    end_timeout = sgqlc.types.Field(Int, graphql_name='endTimeout')
    program_id = sgqlc.types.Field(Int, graphql_name='programId')


class ProjectTypeCondition(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'name', 'description')
    id = sgqlc.types.Field(Int, graphql_name='id')
    name = sgqlc.types.Field(String, graphql_name='name')
    description = sgqlc.types.Field(String, graphql_name='description')


class ProjectTypeFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'name', 'description', 'and_', 'or_', 'not_')
    id = sgqlc.types.Field(IntFilter, graphql_name='id')
    name = sgqlc.types.Field('StringFilter', graphql_name='name')
    description = sgqlc.types.Field('StringFilter', graphql_name='description')
    and_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('ProjectTypeFilter')), graphql_name='and')
    or_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('ProjectTypeFilter')), graphql_name='or')
    not_ = sgqlc.types.Field('ProjectTypeFilter', graphql_name='not')


class ProjectWatcherCondition(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('project_id', 'user_id')
    project_id = sgqlc.types.Field(Int, graphql_name='projectId')
    user_id = sgqlc.types.Field(String, graphql_name='userId')


class ProjectWatcherFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('project_id', 'user_id', 'subscribed_channels', 'and_', 'or_', 'not_')
    project_id = sgqlc.types.Field(IntFilter, graphql_name='projectId')
    user_id = sgqlc.types.Field('StringFilter', graphql_name='userId')
    subscribed_channels = sgqlc.types.Field('UserSubscriptionChannelListFilter', graphql_name='subscribedChannels')
    and_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('ProjectWatcherFilter')), graphql_name='and')
    or_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('ProjectWatcherFilter')), graphql_name='or')
    not_ = sgqlc.types.Field('ProjectWatcherFilter', graphql_name='not')


class ProjectWatcherInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('project_id', 'user_id')
    project_id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='projectId')
    user_id = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='userId')


class ProjectWatcherPatch(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('project_id', 'user_id')
    project_id = sgqlc.types.Field(Int, graphql_name='projectId')
    user_id = sgqlc.types.Field(String, graphql_name='userId')


class RegenerateAccessTokenInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'client_mutation_id')
    id = sgqlc.types.Field(sgqlc.types.non_null(BigInt), graphql_name='id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')


class RegisterProjectUsersInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'force_notify', 'records')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    force_notify = sgqlc.types.Field(Boolean, graphql_name='forceNotify')
    records = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(BulkProjectUser))), graphql_name='records')


class RemoveFavoriteFacilityInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'facility_id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    facility_id = sgqlc.types.Field(Int, graphql_name='facilityId')


class RemoveMetricMetadataDependencyInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'parent_metric', 'child_metric')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    parent_metric = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='parentMetric')
    child_metric = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='childMetric')


class RemoveProjectControllerInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'project_id', 'user_id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    project_id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='projectId')
    user_id = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='userId')


class RemoveReportManagerInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'report_id', 'user_id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    report_id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='reportId')
    user_id = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='userId')


class ReparentMeterStatementInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'meter_statement_id', 'dest_utility_meter_id', 'dest_account_statement_id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    meter_statement_id = sgqlc.types.Field(Int, graphql_name='meterStatementId')
    dest_utility_meter_id = sgqlc.types.Field(Int, graphql_name='destUtilityMeterId')
    dest_account_statement_id = sgqlc.types.Field(Int, graphql_name='destAccountStatementId')


class ReportCondition(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'label', 'description', 'created_at', 'updated_at', 'json_schema', 'default_params_config', 'default_params')
    id = sgqlc.types.Field(Int, graphql_name='id')
    label = sgqlc.types.Field(String, graphql_name='label')
    description = sgqlc.types.Field(String, graphql_name='description')
    created_at = sgqlc.types.Field(Datetime, graphql_name='createdAt')
    updated_at = sgqlc.types.Field(Datetime, graphql_name='updatedAt')
    json_schema = sgqlc.types.Field(JSON, graphql_name='jsonSchema')
    default_params_config = sgqlc.types.Field(JSON, graphql_name='defaultParamsConfig')
    default_params = sgqlc.types.Field(JSON, graphql_name='defaultParams')


class ReportExecutionCondition(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'report_id', 'status', 'file_path', 'errors', 'created_at', 'updated_at', 'actor')
    id = sgqlc.types.Field(Int, graphql_name='id')
    report_id = sgqlc.types.Field(Int, graphql_name='reportId')
    status = sgqlc.types.Field(String, graphql_name='status')
    file_path = sgqlc.types.Field(String, graphql_name='filePath')
    errors = sgqlc.types.Field(JSON, graphql_name='errors')
    created_at = sgqlc.types.Field(Datetime, graphql_name='createdAt')
    updated_at = sgqlc.types.Field(Datetime, graphql_name='updatedAt')
    actor = sgqlc.types.Field(ActorInput, graphql_name='actor')


class ReportExecutionFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('can_write', 'id', 'report_id', 'status', 'file_path', 'errors', 'created_at', 'updated_at', 'actor', 'and_', 'or_', 'not_')
    can_write = sgqlc.types.Field(PermissionBooleanFilter, graphql_name='canWrite')
    id = sgqlc.types.Field(IntFilter, graphql_name='id')
    report_id = sgqlc.types.Field(IntFilter, graphql_name='reportId')
    status = sgqlc.types.Field('StringFilter', graphql_name='status')
    file_path = sgqlc.types.Field('StringFilter', graphql_name='filePath')
    errors = sgqlc.types.Field(JSONFilter, graphql_name='errors')
    created_at = sgqlc.types.Field(DatetimeFilter, graphql_name='createdAt')
    updated_at = sgqlc.types.Field(DatetimeFilter, graphql_name='updatedAt')
    actor = sgqlc.types.Field(ActorFilter, graphql_name='actor')
    and_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('ReportExecutionFilter')), graphql_name='and')
    or_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('ReportExecutionFilter')), graphql_name='or')
    not_ = sgqlc.types.Field('ReportExecutionFilter', graphql_name='not')


class ReportExecutionInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('report_id', 'status', 'file_path', 'errors')
    report_id = sgqlc.types.Field(Int, graphql_name='reportId')
    status = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='status')
    file_path = sgqlc.types.Field(String, graphql_name='filePath')
    errors = sgqlc.types.Field(JSON, graphql_name='errors')


class ReportExecutionPatch(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('report_id', 'status', 'file_path', 'errors')
    report_id = sgqlc.types.Field(Int, graphql_name='reportId')
    status = sgqlc.types.Field(String, graphql_name='status')
    file_path = sgqlc.types.Field(String, graphql_name='filePath')
    errors = sgqlc.types.Field(JSON, graphql_name='errors')


class ReportFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('can_execute', 'id', 'label', 'description', 'created_at', 'updated_at', 'json_schema', 'default_params_config', 'default_params', 'estimated_execution_time', 'and_', 'or_', 'not_')
    can_execute = sgqlc.types.Field(PermissionBooleanFilter, graphql_name='canExecute')
    id = sgqlc.types.Field(IntFilter, graphql_name='id')
    label = sgqlc.types.Field('StringFilter', graphql_name='label')
    description = sgqlc.types.Field('StringFilter', graphql_name='description')
    created_at = sgqlc.types.Field(DatetimeFilter, graphql_name='createdAt')
    updated_at = sgqlc.types.Field(DatetimeFilter, graphql_name='updatedAt')
    json_schema = sgqlc.types.Field(JSONFilter, graphql_name='jsonSchema')
    default_params_config = sgqlc.types.Field(JSONFilter, graphql_name='defaultParamsConfig')
    default_params = sgqlc.types.Field(JSONFilter, graphql_name='defaultParams')
    estimated_execution_time = sgqlc.types.Field(BigFloatFilter, graphql_name='estimatedExecutionTime')
    and_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('ReportFilter')), graphql_name='and')
    or_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('ReportFilter')), graphql_name='or')
    not_ = sgqlc.types.Field('ReportFilter', graphql_name='not')


class ReportQueryCondition(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'report_id', 'label', 'description', 'db_type', 'query', 'created_at', 'updated_at', 'expander', 'chunk_duration')
    id = sgqlc.types.Field(Int, graphql_name='id')
    report_id = sgqlc.types.Field(Int, graphql_name='reportId')
    label = sgqlc.types.Field(String, graphql_name='label')
    description = sgqlc.types.Field(String, graphql_name='description')
    db_type = sgqlc.types.Field(String, graphql_name='dbType')
    query = sgqlc.types.Field(String, graphql_name='query')
    created_at = sgqlc.types.Field(Datetime, graphql_name='createdAt')
    updated_at = sgqlc.types.Field(Datetime, graphql_name='updatedAt')
    expander = sgqlc.types.Field(String, graphql_name='expander')
    chunk_duration = sgqlc.types.Field(String, graphql_name='chunkDuration')


class ReportQueryFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'report_id', 'label', 'description', 'db_type', 'query', 'created_at', 'updated_at', 'expander', 'chunk_duration', 'and_', 'or_', 'not_')
    id = sgqlc.types.Field(IntFilter, graphql_name='id')
    report_id = sgqlc.types.Field(IntFilter, graphql_name='reportId')
    label = sgqlc.types.Field('StringFilter', graphql_name='label')
    description = sgqlc.types.Field('StringFilter', graphql_name='description')
    db_type = sgqlc.types.Field('StringFilter', graphql_name='dbType')
    query = sgqlc.types.Field('StringFilter', graphql_name='query')
    created_at = sgqlc.types.Field(DatetimeFilter, graphql_name='createdAt')
    updated_at = sgqlc.types.Field(DatetimeFilter, graphql_name='updatedAt')
    expander = sgqlc.types.Field('StringFilter', graphql_name='expander')
    chunk_duration = sgqlc.types.Field('StringFilter', graphql_name='chunkDuration')
    and_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('ReportQueryFilter')), graphql_name='and')
    or_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('ReportQueryFilter')), graphql_name='or')
    not_ = sgqlc.types.Field('ReportQueryFilter', graphql_name='not')


class ReportQueryInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('report_id', 'label', 'description', 'db_type', 'query', 'expander', 'chunk_duration')
    report_id = sgqlc.types.Field(Int, graphql_name='reportId')
    label = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='label')
    description = sgqlc.types.Field(String, graphql_name='description')
    db_type = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='dbType')
    query = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='query')
    expander = sgqlc.types.Field(String, graphql_name='expander')
    chunk_duration = sgqlc.types.Field(String, graphql_name='chunkDuration')


class RevokeAccessTokenInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'client_mutation_id')
    id = sgqlc.types.Field(sgqlc.types.non_null(BigInt), graphql_name='id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')


class SavingsEventCondition(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'project_id', 'start_time', 'end_time', 'metadata', 'created_at', 'updated_at')
    id = sgqlc.types.Field(Int, graphql_name='id')
    project_id = sgqlc.types.Field(Int, graphql_name='projectId')
    start_time = sgqlc.types.Field(Datetime, graphql_name='startTime')
    end_time = sgqlc.types.Field(Datetime, graphql_name='endTime')
    metadata = sgqlc.types.Field(JSON, graphql_name='metadata')
    created_at = sgqlc.types.Field(Datetime, graphql_name='createdAt')
    updated_at = sgqlc.types.Field(Datetime, graphql_name='updatedAt')


class SavingsEventFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'project_id', 'start_time', 'end_time', 'metadata', 'created_at', 'updated_at', 'and_', 'or_', 'not_')
    id = sgqlc.types.Field(IntFilter, graphql_name='id')
    project_id = sgqlc.types.Field(IntFilter, graphql_name='projectId')
    start_time = sgqlc.types.Field(DatetimeFilter, graphql_name='startTime')
    end_time = sgqlc.types.Field(DatetimeFilter, graphql_name='endTime')
    metadata = sgqlc.types.Field(JSONFilter, graphql_name='metadata')
    created_at = sgqlc.types.Field(DatetimeFilter, graphql_name='createdAt')
    updated_at = sgqlc.types.Field(DatetimeFilter, graphql_name='updatedAt')
    and_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('SavingsEventFilter')), graphql_name='and')
    or_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('SavingsEventFilter')), graphql_name='or')
    not_ = sgqlc.types.Field('SavingsEventFilter', graphql_name='not')


class SavingsEventInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('project_id', 'start_time', 'end_time', 'metadata')
    project_id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='projectId')
    start_time = sgqlc.types.Field(sgqlc.types.non_null(Datetime), graphql_name='startTime')
    end_time = sgqlc.types.Field(sgqlc.types.non_null(Datetime), graphql_name='endTime')
    metadata = sgqlc.types.Field(JSON, graphql_name='metadata')


class SavingsEventPatch(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('project_id', 'start_time', 'end_time', 'metadata')
    project_id = sgqlc.types.Field(Int, graphql_name='projectId')
    start_time = sgqlc.types.Field(Datetime, graphql_name='startTime')
    end_time = sgqlc.types.Field(Datetime, graphql_name='endTime')
    metadata = sgqlc.types.Field(JSON, graphql_name='metadata')


class SetFacilityConfigInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'facility_id', 'key', 'value')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    facility_id = sgqlc.types.Field(Int, graphql_name='facilityId')
    key = sgqlc.types.Field(String, graphql_name='key')
    value = sgqlc.types.Field(JSON, graphql_name='value')


class SetMachineUserCapabilityInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'machine_user_id', 'capabilities')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    machine_user_id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='machineUserId')
    capabilities = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(PlatformCapabilityAccessDefinition))), graphql_name='capabilities')


class SetProjectConfigInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'project_id', 'key', 'value')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    project_id = sgqlc.types.Field(Int, graphql_name='projectId')
    key = sgqlc.types.Field(String, graphql_name='key')
    value = sgqlc.types.Field(JSON, graphql_name='value')


class StringFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('is_null', 'equal_to', 'not_equal_to', 'distinct_from', 'not_distinct_from', 'in_', 'not_in', 'less_than', 'less_than_or_equal_to', 'greater_than', 'greater_than_or_equal_to', 'includes', 'not_includes', 'includes_insensitive', 'not_includes_insensitive', 'starts_with', 'not_starts_with', 'starts_with_insensitive', 'not_starts_with_insensitive', 'ends_with', 'not_ends_with', 'ends_with_insensitive', 'not_ends_with_insensitive', 'like', 'not_like', 'like_insensitive', 'not_like_insensitive', 'equal_to_insensitive', 'not_equal_to_insensitive', 'distinct_from_insensitive', 'not_distinct_from_insensitive', 'in_insensitive', 'not_in_insensitive', 'less_than_insensitive', 'less_than_or_equal_to_insensitive', 'greater_than_insensitive', 'greater_than_or_equal_to_insensitive')
    is_null = sgqlc.types.Field(Boolean, graphql_name='isNull')
    equal_to = sgqlc.types.Field(String, graphql_name='equalTo')
    not_equal_to = sgqlc.types.Field(String, graphql_name='notEqualTo')
    distinct_from = sgqlc.types.Field(String, graphql_name='distinctFrom')
    not_distinct_from = sgqlc.types.Field(String, graphql_name='notDistinctFrom')
    in_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(String)), graphql_name='in')
    not_in = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(String)), graphql_name='notIn')
    less_than = sgqlc.types.Field(String, graphql_name='lessThan')
    less_than_or_equal_to = sgqlc.types.Field(String, graphql_name='lessThanOrEqualTo')
    greater_than = sgqlc.types.Field(String, graphql_name='greaterThan')
    greater_than_or_equal_to = sgqlc.types.Field(String, graphql_name='greaterThanOrEqualTo')
    includes = sgqlc.types.Field(String, graphql_name='includes')
    not_includes = sgqlc.types.Field(String, graphql_name='notIncludes')
    includes_insensitive = sgqlc.types.Field(String, graphql_name='includesInsensitive')
    not_includes_insensitive = sgqlc.types.Field(String, graphql_name='notIncludesInsensitive')
    starts_with = sgqlc.types.Field(String, graphql_name='startsWith')
    not_starts_with = sgqlc.types.Field(String, graphql_name='notStartsWith')
    starts_with_insensitive = sgqlc.types.Field(String, graphql_name='startsWithInsensitive')
    not_starts_with_insensitive = sgqlc.types.Field(String, graphql_name='notStartsWithInsensitive')
    ends_with = sgqlc.types.Field(String, graphql_name='endsWith')
    not_ends_with = sgqlc.types.Field(String, graphql_name='notEndsWith')
    ends_with_insensitive = sgqlc.types.Field(String, graphql_name='endsWithInsensitive')
    not_ends_with_insensitive = sgqlc.types.Field(String, graphql_name='notEndsWithInsensitive')
    like = sgqlc.types.Field(String, graphql_name='like')
    not_like = sgqlc.types.Field(String, graphql_name='notLike')
    like_insensitive = sgqlc.types.Field(String, graphql_name='likeInsensitive')
    not_like_insensitive = sgqlc.types.Field(String, graphql_name='notLikeInsensitive')
    equal_to_insensitive = sgqlc.types.Field(String, graphql_name='equalToInsensitive')
    not_equal_to_insensitive = sgqlc.types.Field(String, graphql_name='notEqualToInsensitive')
    distinct_from_insensitive = sgqlc.types.Field(String, graphql_name='distinctFromInsensitive')
    not_distinct_from_insensitive = sgqlc.types.Field(String, graphql_name='notDistinctFromInsensitive')
    in_insensitive = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(String)), graphql_name='inInsensitive')
    not_in_insensitive = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(String)), graphql_name='notInInsensitive')
    less_than_insensitive = sgqlc.types.Field(String, graphql_name='lessThanInsensitive')
    less_than_or_equal_to_insensitive = sgqlc.types.Field(String, graphql_name='lessThanOrEqualToInsensitive')
    greater_than_insensitive = sgqlc.types.Field(String, graphql_name='greaterThanInsensitive')
    greater_than_or_equal_to_insensitive = sgqlc.types.Field(String, graphql_name='greaterThanOrEqualToInsensitive')


class StringListFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('is_null', 'equal_to', 'not_equal_to', 'distinct_from', 'not_distinct_from', 'less_than', 'less_than_or_equal_to', 'greater_than', 'greater_than_or_equal_to', 'contains', 'contained_by', 'overlaps', 'any_equal_to', 'any_not_equal_to', 'any_less_than', 'any_less_than_or_equal_to', 'any_greater_than', 'any_greater_than_or_equal_to')
    is_null = sgqlc.types.Field(Boolean, graphql_name='isNull')
    equal_to = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name='equalTo')
    not_equal_to = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name='notEqualTo')
    distinct_from = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name='distinctFrom')
    not_distinct_from = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name='notDistinctFrom')
    less_than = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name='lessThan')
    less_than_or_equal_to = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name='lessThanOrEqualTo')
    greater_than = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name='greaterThan')
    greater_than_or_equal_to = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name='greaterThanOrEqualTo')
    contains = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name='contains')
    contained_by = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name='containedBy')
    overlaps = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name='overlaps')
    any_equal_to = sgqlc.types.Field(String, graphql_name='anyEqualTo')
    any_not_equal_to = sgqlc.types.Field(String, graphql_name='anyNotEqualTo')
    any_less_than = sgqlc.types.Field(String, graphql_name='anyLessThan')
    any_less_than_or_equal_to = sgqlc.types.Field(String, graphql_name='anyLessThanOrEqualTo')
    any_greater_than = sgqlc.types.Field(String, graphql_name='anyGreaterThan')
    any_greater_than_or_equal_to = sgqlc.types.Field(String, graphql_name='anyGreaterThanOrEqualTo')


class SuggestionActivityLogCondition(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('suggestion_id', 'created_at', 'type', 'actor', 'metadata')
    suggestion_id = sgqlc.types.Field(Int, graphql_name='suggestionId')
    created_at = sgqlc.types.Field(Datetime, graphql_name='createdAt')
    type = sgqlc.types.Field(SuggestionActivityType, graphql_name='type')
    actor = sgqlc.types.Field(ActorInput, graphql_name='actor')
    metadata = sgqlc.types.Field(JSON, graphql_name='metadata')


class SuggestionActivityLogFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('suggestion_id', 'created_at', 'type', 'metadata', 'actor', 'and_', 'or_', 'not_')
    suggestion_id = sgqlc.types.Field(IntFilter, graphql_name='suggestionId')
    created_at = sgqlc.types.Field(DatetimeFilter, graphql_name='createdAt')
    type = sgqlc.types.Field('SuggestionActivityTypeFilter', graphql_name='type')
    metadata = sgqlc.types.Field(JSONFilter, graphql_name='metadata')
    actor = sgqlc.types.Field(ActorFilter, graphql_name='actor')
    and_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('SuggestionActivityLogFilter')), graphql_name='and')
    or_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('SuggestionActivityLogFilter')), graphql_name='or')
    not_ = sgqlc.types.Field('SuggestionActivityLogFilter', graphql_name='not')


class SuggestionActivityLogInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('suggestion_id', 'created_at', 'type', 'actor', 'metadata', 'suggestion')
    suggestion_id = sgqlc.types.Field(Int, graphql_name='suggestionId')
    created_at = sgqlc.types.Field(Datetime, graphql_name='createdAt')
    type = sgqlc.types.Field(sgqlc.types.non_null(SuggestionActivityType), graphql_name='type')
    actor = sgqlc.types.Field(ActorInput, graphql_name='actor')
    metadata = sgqlc.types.Field(JSON, graphql_name='metadata')
    suggestion = sgqlc.types.Field('SuggestionInput', graphql_name='suggestion')


class SuggestionActivityTypeFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('is_null', 'equal_to', 'not_equal_to', 'distinct_from', 'not_distinct_from', 'in_', 'not_in', 'less_than', 'less_than_or_equal_to', 'greater_than', 'greater_than_or_equal_to')
    is_null = sgqlc.types.Field(Boolean, graphql_name='isNull')
    equal_to = sgqlc.types.Field(SuggestionActivityType, graphql_name='equalTo')
    not_equal_to = sgqlc.types.Field(SuggestionActivityType, graphql_name='notEqualTo')
    distinct_from = sgqlc.types.Field(SuggestionActivityType, graphql_name='distinctFrom')
    not_distinct_from = sgqlc.types.Field(SuggestionActivityType, graphql_name='notDistinctFrom')
    in_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(SuggestionActivityType)), graphql_name='in')
    not_in = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(SuggestionActivityType)), graphql_name='notIn')
    less_than = sgqlc.types.Field(SuggestionActivityType, graphql_name='lessThan')
    less_than_or_equal_to = sgqlc.types.Field(SuggestionActivityType, graphql_name='lessThanOrEqualTo')
    greater_than = sgqlc.types.Field(SuggestionActivityType, graphql_name='greaterThan')
    greater_than_or_equal_to = sgqlc.types.Field(SuggestionActivityType, graphql_name='greaterThanOrEqualTo')


class SuggestionCondition(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'project_id', 'description', 'start_time', 'end_time', 'metadata', 'created_at', 'updated_at', 'withdrawn_at', 'acknowledgement_status', 'effectiveness')
    id = sgqlc.types.Field(Int, graphql_name='id')
    project_id = sgqlc.types.Field(Int, graphql_name='projectId')
    description = sgqlc.types.Field(String, graphql_name='description')
    start_time = sgqlc.types.Field(Datetime, graphql_name='startTime')
    end_time = sgqlc.types.Field(Datetime, graphql_name='endTime')
    metadata = sgqlc.types.Field(JSON, graphql_name='metadata')
    created_at = sgqlc.types.Field(Datetime, graphql_name='createdAt')
    updated_at = sgqlc.types.Field(Datetime, graphql_name='updatedAt')
    withdrawn_at = sgqlc.types.Field(Datetime, graphql_name='withdrawnAt')
    acknowledgement_status = sgqlc.types.Field(Acknowledgement, graphql_name='acknowledgementStatus')
    effectiveness = sgqlc.types.Field(Float, graphql_name='effectiveness')


class SuggestionControlEventInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('suggestion_id', 'control_event_id', 'control_event')
    suggestion_id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='suggestionId')
    control_event_id = sgqlc.types.Field(Int, graphql_name='controlEventId')
    control_event = sgqlc.types.Field(ControlEventInput, graphql_name='controlEvent')


class SuggestionControlEventPatch(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('suggestion_id', 'control_event_id')
    suggestion_id = sgqlc.types.Field(Int, graphql_name='suggestionId')
    control_event_id = sgqlc.types.Field(Int, graphql_name='controlEventId')


class SuggestionFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('can_control', 'id', 'project_id', 'description', 'start_time', 'end_time', 'metadata', 'created_at', 'updated_at', 'withdrawn_at', 'acknowledgement_status', 'effectiveness', 'acknowledgement_cutoff', 'control_type', 'facility_id', 'facility_name', 'is_acknowledged', 'is_rejected', 'is_watching', 'is_withdrawn', 'program_id', 'project_name', 'project_type', 'state', 'and_', 'or_', 'not_')
    can_control = sgqlc.types.Field(PermissionBooleanFilter, graphql_name='canControl')
    id = sgqlc.types.Field(IntFilter, graphql_name='id')
    project_id = sgqlc.types.Field(IntFilter, graphql_name='projectId')
    description = sgqlc.types.Field(StringFilter, graphql_name='description')
    start_time = sgqlc.types.Field(DatetimeFilter, graphql_name='startTime')
    end_time = sgqlc.types.Field(DatetimeFilter, graphql_name='endTime')
    metadata = sgqlc.types.Field(JSONFilter, graphql_name='metadata')
    created_at = sgqlc.types.Field(DatetimeFilter, graphql_name='createdAt')
    updated_at = sgqlc.types.Field(DatetimeFilter, graphql_name='updatedAt')
    withdrawn_at = sgqlc.types.Field(DatetimeFilter, graphql_name='withdrawnAt')
    acknowledgement_status = sgqlc.types.Field(AcknowledgementFilter, graphql_name='acknowledgementStatus')
    effectiveness = sgqlc.types.Field(FloatFilter, graphql_name='effectiveness')
    acknowledgement_cutoff = sgqlc.types.Field(DatetimeFilter, graphql_name='acknowledgementCutoff')
    control_type = sgqlc.types.Field(ControlTypeFilter, graphql_name='controlType')
    facility_id = sgqlc.types.Field(IntFilter, graphql_name='facilityId')
    facility_name = sgqlc.types.Field(StringFilter, graphql_name='facilityName')
    is_acknowledged = sgqlc.types.Field(BooleanFilter, graphql_name='isAcknowledged')
    is_rejected = sgqlc.types.Field(BooleanFilter, graphql_name='isRejected')
    is_watching = sgqlc.types.Field(BooleanFilter, graphql_name='isWatching')
    is_withdrawn = sgqlc.types.Field(BooleanFilter, graphql_name='isWithdrawn')
    program_id = sgqlc.types.Field(IntFilter, graphql_name='programId')
    project_name = sgqlc.types.Field(StringFilter, graphql_name='projectName')
    project_type = sgqlc.types.Field(StringFilter, graphql_name='projectType')
    state = sgqlc.types.Field('SuggestionStateFilter', graphql_name='state')
    and_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('SuggestionFilter')), graphql_name='and')
    or_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('SuggestionFilter')), graphql_name='or')
    not_ = sgqlc.types.Field('SuggestionFilter', graphql_name='not')


class SuggestionInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('project_id', 'description', 'start_time', 'end_time', 'metadata', 'effectiveness')
    project_id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='projectId')
    description = sgqlc.types.Field(String, graphql_name='description')
    start_time = sgqlc.types.Field(sgqlc.types.non_null(Datetime), graphql_name='startTime')
    end_time = sgqlc.types.Field(Datetime, graphql_name='endTime')
    metadata = sgqlc.types.Field(JSON, graphql_name='metadata')
    effectiveness = sgqlc.types.Field(Float, graphql_name='effectiveness')


class SuggestionPatch(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('project_id', 'description', 'start_time', 'end_time', 'metadata', 'effectiveness')
    project_id = sgqlc.types.Field(Int, graphql_name='projectId')
    description = sgqlc.types.Field(String, graphql_name='description')
    start_time = sgqlc.types.Field(Datetime, graphql_name='startTime')
    end_time = sgqlc.types.Field(Datetime, graphql_name='endTime')
    metadata = sgqlc.types.Field(JSON, graphql_name='metadata')
    effectiveness = sgqlc.types.Field(Float, graphql_name='effectiveness')


class SuggestionStateFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('is_null', 'equal_to', 'not_equal_to', 'distinct_from', 'not_distinct_from', 'in_', 'not_in', 'less_than', 'less_than_or_equal_to', 'greater_than', 'greater_than_or_equal_to')
    is_null = sgqlc.types.Field(Boolean, graphql_name='isNull')
    equal_to = sgqlc.types.Field(SuggestionState, graphql_name='equalTo')
    not_equal_to = sgqlc.types.Field(SuggestionState, graphql_name='notEqualTo')
    distinct_from = sgqlc.types.Field(SuggestionState, graphql_name='distinctFrom')
    not_distinct_from = sgqlc.types.Field(SuggestionState, graphql_name='notDistinctFrom')
    in_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(SuggestionState)), graphql_name='in')
    not_in = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(SuggestionState)), graphql_name='notIn')
    less_than = sgqlc.types.Field(SuggestionState, graphql_name='lessThan')
    less_than_or_equal_to = sgqlc.types.Field(SuggestionState, graphql_name='lessThanOrEqualTo')
    greater_than = sgqlc.types.Field(SuggestionState, graphql_name='greaterThan')
    greater_than_or_equal_to = sgqlc.types.Field(SuggestionState, graphql_name='greaterThanOrEqualTo')


class TemperatureSensorFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'facility_id', 'label', 'metadata', 'short_link', 'battery_id', 'signal_id', 'temperature_id', 'created_at', 'updated_at', 'and_', 'or_', 'not_')
    id = sgqlc.types.Field(IntFilter, graphql_name='id')
    facility_id = sgqlc.types.Field(IntFilter, graphql_name='facilityId')
    label = sgqlc.types.Field(StringFilter, graphql_name='label')
    metadata = sgqlc.types.Field(JSONFilter, graphql_name='metadata')
    short_link = sgqlc.types.Field(StringFilter, graphql_name='shortLink')
    battery_id = sgqlc.types.Field(BigIntFilter, graphql_name='batteryId')
    signal_id = sgqlc.types.Field(BigIntFilter, graphql_name='signalId')
    temperature_id = sgqlc.types.Field(BigIntFilter, graphql_name='temperatureId')
    created_at = sgqlc.types.Field(DatetimeFilter, graphql_name='createdAt')
    updated_at = sgqlc.types.Field(DatetimeFilter, graphql_name='updatedAt')
    and_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('TemperatureSensorFilter')), graphql_name='and')
    or_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('TemperatureSensorFilter')), graphql_name='or')
    not_ = sgqlc.types.Field('TemperatureSensorFilter', graphql_name='not')


class ThresholdConditionFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('is_null', 'equal_to', 'not_equal_to', 'distinct_from', 'not_distinct_from', 'in_', 'not_in', 'less_than', 'less_than_or_equal_to', 'greater_than', 'greater_than_or_equal_to')
    is_null = sgqlc.types.Field(Boolean, graphql_name='isNull')
    equal_to = sgqlc.types.Field(ThresholdCondition, graphql_name='equalTo')
    not_equal_to = sgqlc.types.Field(ThresholdCondition, graphql_name='notEqualTo')
    distinct_from = sgqlc.types.Field(ThresholdCondition, graphql_name='distinctFrom')
    not_distinct_from = sgqlc.types.Field(ThresholdCondition, graphql_name='notDistinctFrom')
    in_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(ThresholdCondition)), graphql_name='in')
    not_in = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(ThresholdCondition)), graphql_name='notIn')
    less_than = sgqlc.types.Field(ThresholdCondition, graphql_name='lessThan')
    less_than_or_equal_to = sgqlc.types.Field(ThresholdCondition, graphql_name='lessThanOrEqualTo')
    greater_than = sgqlc.types.Field(ThresholdCondition, graphql_name='greaterThan')
    greater_than_or_equal_to = sgqlc.types.Field(ThresholdCondition, graphql_name='greaterThanOrEqualTo')


class TimezoneCondition(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('name', 'abbreviation', 'utc_offset', 'is_dst')
    name = sgqlc.types.Field(String, graphql_name='name')
    abbreviation = sgqlc.types.Field(String, graphql_name='abbreviation')
    utc_offset = sgqlc.types.Field(IntervalInput, graphql_name='utcOffset')
    is_dst = sgqlc.types.Field(Boolean, graphql_name='isDst')


class TimezoneFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('name', 'abbreviation', 'utc_offset', 'is_dst', 'and_', 'or_', 'not_')
    name = sgqlc.types.Field(StringFilter, graphql_name='name')
    abbreviation = sgqlc.types.Field(StringFilter, graphql_name='abbreviation')
    utc_offset = sgqlc.types.Field(IntervalFilter, graphql_name='utcOffset')
    is_dst = sgqlc.types.Field(BooleanFilter, graphql_name='isDst')
    and_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('TimezoneFilter')), graphql_name='and')
    or_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('TimezoneFilter')), graphql_name='or')
    not_ = sgqlc.types.Field('TimezoneFilter', graphql_name='not')


class TransitionControlEventInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('control_event_id', 'state', 'description', 'client_mutation_id')
    control_event_id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='controlEventId')
    state = sgqlc.types.Field(sgqlc.types.non_null(ControlEventState), graphql_name='state')
    description = sgqlc.types.Field(String, graphql_name='description')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')


class UnitDimensionCondition(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('name',)
    name = sgqlc.types.Field(String, graphql_name='name')


class UnitDimensionFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('name', 'active_mappings', 'and_', 'or_', 'not_')
    name = sgqlc.types.Field(StringFilter, graphql_name='name')
    active_mappings = sgqlc.types.Field(StringListFilter, graphql_name='activeMappings')
    and_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('UnitDimensionFilter')), graphql_name='and')
    or_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('UnitDimensionFilter')), graphql_name='or')
    not_ = sgqlc.types.Field('UnitDimensionFilter', graphql_name='not')


class UnitGroupCondition(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('name',)
    name = sgqlc.types.Field(String, graphql_name='name')


class UnitGroupDimensionCondition(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('unit_group', 'unit_dimension', 'unit', 'created_at', 'updated_at')
    unit_group = sgqlc.types.Field(String, graphql_name='unitGroup')
    unit_dimension = sgqlc.types.Field(String, graphql_name='unitDimension')
    unit = sgqlc.types.Field(String, graphql_name='unit')
    created_at = sgqlc.types.Field(Datetime, graphql_name='createdAt')
    updated_at = sgqlc.types.Field(Datetime, graphql_name='updatedAt')


class UnitGroupDimensionFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('unit_group', 'unit_dimension', 'unit', 'created_at', 'updated_at', 'and_', 'or_', 'not_')
    unit_group = sgqlc.types.Field(StringFilter, graphql_name='unitGroup')
    unit_dimension = sgqlc.types.Field(StringFilter, graphql_name='unitDimension')
    unit = sgqlc.types.Field(StringFilter, graphql_name='unit')
    created_at = sgqlc.types.Field(DatetimeFilter, graphql_name='createdAt')
    updated_at = sgqlc.types.Field(DatetimeFilter, graphql_name='updatedAt')
    and_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('UnitGroupDimensionFilter')), graphql_name='and')
    or_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('UnitGroupDimensionFilter')), graphql_name='or')
    not_ = sgqlc.types.Field('UnitGroupDimensionFilter', graphql_name='not')


class UnitGroupFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('name', 'and_', 'or_', 'not_')
    name = sgqlc.types.Field(StringFilter, graphql_name='name')
    and_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('UnitGroupFilter')), graphql_name='and')
    or_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('UnitGroupFilter')), graphql_name='or')
    not_ = sgqlc.types.Field('UnitGroupFilter', graphql_name='not')


class UpdateAccountChargeByNodeIdInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'node_id', 'patch')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    node_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name='nodeId')
    patch = sgqlc.types.Field(sgqlc.types.non_null(AccountChargePatch), graphql_name='patch')


class UpdateAccountChargeInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'patch', 'id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    patch = sgqlc.types.Field(sgqlc.types.non_null(AccountChargePatch), graphql_name='patch')
    id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='id')


class UpdateAccountStatementByNodeIdInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'node_id', 'patch')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    node_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name='nodeId')
    patch = sgqlc.types.Field(sgqlc.types.non_null(AccountStatementPatch), graphql_name='patch')


class UpdateAccountStatementInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'patch', 'id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    patch = sgqlc.types.Field(sgqlc.types.non_null(AccountStatementPatch), graphql_name='patch')
    id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='id')


class UpdateBalancingAuthorityByNodeIdInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'node_id', 'patch')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    node_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name='nodeId')
    patch = sgqlc.types.Field(sgqlc.types.non_null(BalancingAuthorityPatch), graphql_name='patch')


class UpdateBalancingAuthorityBySlugInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'patch', 'slug')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    patch = sgqlc.types.Field(sgqlc.types.non_null(BalancingAuthorityPatch), graphql_name='patch')
    slug = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='slug')


class UpdateBalancingAuthorityInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'patch', 'id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    patch = sgqlc.types.Field(sgqlc.types.non_null(BalancingAuthorityPatch), graphql_name='patch')
    id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='id')


class UpdateBuildingAreaByFacilityIdAndLabelInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'patch', 'facility_id', 'label')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    patch = sgqlc.types.Field(sgqlc.types.non_null(BuildingAreaPatch), graphql_name='patch')
    facility_id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='facilityId')
    label = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='label')


class UpdateBuildingAreaByNodeIdInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'node_id', 'patch')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    node_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name='nodeId')
    patch = sgqlc.types.Field(sgqlc.types.non_null(BuildingAreaPatch), graphql_name='patch')


class UpdateBuildingAreaInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'patch', 'id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    patch = sgqlc.types.Field(sgqlc.types.non_null(BuildingAreaPatch), graphql_name='patch')
    id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='id')


class UpdateBuildingAreaTypeByNodeIdInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'node_id', 'patch')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    node_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name='nodeId')
    patch = sgqlc.types.Field(sgqlc.types.non_null(BuildingAreaTypePatch), graphql_name='patch')


class UpdateBuildingAreaTypeInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'patch', 'type')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    patch = sgqlc.types.Field(sgqlc.types.non_null(BuildingAreaTypePatch), graphql_name='patch')
    type = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='type')


class UpdateChartByNodeIdInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'node_id', 'patch')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    node_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name='nodeId')
    patch = sgqlc.types.Field(sgqlc.types.non_null(ChartPatch), graphql_name='patch')


class UpdateChartInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'patch', 'id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    patch = sgqlc.types.Field(sgqlc.types.non_null(ChartPatch), graphql_name='patch')
    id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='id')


class UpdateComponentByNodeIdInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'node_id', 'patch')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    node_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name='nodeId')
    patch = sgqlc.types.Field(sgqlc.types.non_null(ComponentPatch), graphql_name='patch')


class UpdateComponentInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'patch', 'id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    patch = sgqlc.types.Field(sgqlc.types.non_null(ComponentPatch), graphql_name='patch')
    id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='id')


class UpdateControlEventByNodeIdInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'node_id', 'patch')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    node_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name='nodeId')
    patch = sgqlc.types.Field(sgqlc.types.non_null(ControlEventPatch), graphql_name='patch')


class UpdateControlEventInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'patch', 'id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    patch = sgqlc.types.Field(sgqlc.types.non_null(ControlEventPatch), graphql_name='patch')
    id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='id')


class UpdateControlEventLogByNodeIdInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'node_id', 'patch')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    node_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name='nodeId')
    patch = sgqlc.types.Field(sgqlc.types.non_null(ControlEventLogPatch), graphql_name='patch')


class UpdateControlEventLogInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'patch', 'id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    patch = sgqlc.types.Field(sgqlc.types.non_null(ControlEventLogPatch), graphql_name='patch')
    id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='id')


class UpdateDashboardByNodeIdInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'node_id', 'patch')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    node_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name='nodeId')
    patch = sgqlc.types.Field(sgqlc.types.non_null(DashboardPatch), graphql_name='patch')


class UpdateDashboardInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'patch', 'id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    patch = sgqlc.types.Field(sgqlc.types.non_null(DashboardPatch), graphql_name='patch')
    id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='id')


class UpdateDataPointByDataSourceNameAndNameInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'patch', 'data_source_name', 'name')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    patch = sgqlc.types.Field(sgqlc.types.non_null(DataPointPatch), graphql_name='patch')
    data_source_name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='dataSourceName')
    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='name')


class UpdateDataPointByNodeIdInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'node_id', 'patch')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    node_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name='nodeId')
    patch = sgqlc.types.Field(sgqlc.types.non_null(DataPointPatch), graphql_name='patch')


class UpdateDataPointInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'patch', 'id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    patch = sgqlc.types.Field(sgqlc.types.non_null(DataPointPatch), graphql_name='patch')
    id = sgqlc.types.Field(sgqlc.types.non_null(BigInt), graphql_name='id')


class UpdateDependencyByNodeIdInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'node_id', 'patch')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    node_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name='nodeId')
    patch = sgqlc.types.Field(sgqlc.types.non_null(DependencyPatch), graphql_name='patch')


class UpdateDependencyByPathInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'patch', 'path')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    patch = sgqlc.types.Field(sgqlc.types.non_null(DependencyPatch), graphql_name='patch')
    path = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='path')


class UpdateDependencyInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'patch', 'id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    patch = sgqlc.types.Field(sgqlc.types.non_null(DependencyPatch), graphql_name='patch')
    id = sgqlc.types.Field(sgqlc.types.non_null(BigInt), graphql_name='id')


class UpdateFacilityByNodeIdInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'node_id', 'patch')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    node_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name='nodeId')
    patch = sgqlc.types.Field(sgqlc.types.non_null(FacilityPatch), graphql_name='patch')


class UpdateFacilityBySlugInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'patch', 'slug')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    patch = sgqlc.types.Field(sgqlc.types.non_null(FacilityPatch), graphql_name='patch')
    slug = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='slug')


class UpdateFacilityGroupByNodeIdInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'node_id', 'patch')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    node_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name='nodeId')
    patch = sgqlc.types.Field(sgqlc.types.non_null(FacilityGroupPatch), graphql_name='patch')


class UpdateFacilityGroupInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'patch', 'id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    patch = sgqlc.types.Field(sgqlc.types.non_null(FacilityGroupPatch), graphql_name='patch')
    id = sgqlc.types.Field(sgqlc.types.non_null(BigInt), graphql_name='id')


class UpdateFacilityGroupsLinkerByNodeIdInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'node_id', 'patch')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    node_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name='nodeId')
    patch = sgqlc.types.Field(sgqlc.types.non_null(FacilityGroupsLinkerPatch), graphql_name='patch')


class UpdateFacilityGroupsLinkerInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'patch', 'facility_id', 'facility_grouping_id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    patch = sgqlc.types.Field(sgqlc.types.non_null(FacilityGroupsLinkerPatch), graphql_name='patch')
    facility_id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='facilityId')
    facility_grouping_id = sgqlc.types.Field(sgqlc.types.non_null(BigInt), graphql_name='facilityGroupingId')


class UpdateFacilityInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'patch', 'id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    patch = sgqlc.types.Field(sgqlc.types.non_null(FacilityPatch), graphql_name='patch')
    id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='id')


class UpdateFacilityTaggedDataPointByNodeIdInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'node_id', 'patch')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    node_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name='nodeId')
    patch = sgqlc.types.Field(sgqlc.types.non_null(FacilityTaggedDataPointPatch), graphql_name='patch')


class UpdateFacilityTaggedDataPointInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'patch', 'id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    patch = sgqlc.types.Field(sgqlc.types.non_null(FacilityTaggedDataPointPatch), graphql_name='patch')
    id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='id')


class UpdateMachineUserByNodeIdInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'node_id', 'patch')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    node_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name='nodeId')
    patch = sgqlc.types.Field(sgqlc.types.non_null(MachineUserPatch), graphql_name='patch')


class UpdateMachineUserInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'patch', 'id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    patch = sgqlc.types.Field(sgqlc.types.non_null(MachineUserPatch), graphql_name='patch')
    id = sgqlc.types.Field(sgqlc.types.non_null(BigInt), graphql_name='id')


class UpdateMainServiceByFacilityIdAndNameInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'patch', 'facility_id', 'name')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    patch = sgqlc.types.Field(sgqlc.types.non_null(MainServicePatch), graphql_name='patch')
    facility_id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='facilityId')
    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='name')


class UpdateMainServiceByFacilityIdAndUsageDataPointIdAndDemandDataPointIdInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'patch', 'facility_id', 'usage_data_point_id', 'demand_data_point_id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    patch = sgqlc.types.Field(sgqlc.types.non_null(MainServicePatch), graphql_name='patch')
    facility_id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='facilityId')
    usage_data_point_id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='usageDataPointId')
    demand_data_point_id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='demandDataPointId')


class UpdateMainServiceByNodeIdInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'node_id', 'patch')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    node_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name='nodeId')
    patch = sgqlc.types.Field(sgqlc.types.non_null(MainServicePatch), graphql_name='patch')


class UpdateMainServiceInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'patch', 'id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    patch = sgqlc.types.Field(sgqlc.types.non_null(MainServicePatch), graphql_name='patch')
    id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='id')


class UpdateMeterChargeByNodeIdInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'node_id', 'patch')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    node_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name='nodeId')
    patch = sgqlc.types.Field(sgqlc.types.non_null(MeterChargePatch), graphql_name='patch')


class UpdateMeterChargeInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'patch', 'id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    patch = sgqlc.types.Field(sgqlc.types.non_null(MeterChargePatch), graphql_name='patch')
    id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='id')


class UpdateMeterStatementByNodeIdInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'node_id', 'patch')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    node_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name='nodeId')
    patch = sgqlc.types.Field(sgqlc.types.non_null(MeterStatementPatch), graphql_name='patch')


class UpdateMeterStatementInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'patch', 'id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    patch = sgqlc.types.Field(sgqlc.types.non_null(MeterStatementPatch), graphql_name='patch')
    id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='id')


class UpdateMeterUsageByNodeIdInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'node_id', 'patch')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    node_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name='nodeId')
    patch = sgqlc.types.Field(sgqlc.types.non_null(MeterUsagePatch), graphql_name='patch')


class UpdateMeterUsageInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'patch', 'id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    patch = sgqlc.types.Field(sgqlc.types.non_null(MeterUsagePatch), graphql_name='patch')
    id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='id')


class UpdateMonitorByNameInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'patch', 'name')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    patch = sgqlc.types.Field(sgqlc.types.non_null(MonitorPatch), graphql_name='patch')
    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='name')


class UpdateMonitorByNodeIdInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'node_id', 'patch')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    node_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name='nodeId')
    patch = sgqlc.types.Field(sgqlc.types.non_null(MonitorPatch), graphql_name='patch')


class UpdateMonitorDataPointByNodeIdInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'node_id', 'patch')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    node_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name='nodeId')
    patch = sgqlc.types.Field(sgqlc.types.non_null(MonitorDataPointPatch), graphql_name='patch')


class UpdateMonitorDataPointInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'patch', 'monitor_id', 'data_point_id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    patch = sgqlc.types.Field(sgqlc.types.non_null(MonitorDataPointPatch), graphql_name='patch')
    monitor_id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='monitorId')
    data_point_id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='dataPointId')


class UpdateMonitorDetectionByNodeIdInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'node_id', 'patch')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    node_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name='nodeId')
    patch = sgqlc.types.Field(sgqlc.types.non_null(MonitorDetectionPatch), graphql_name='patch')


class UpdateMonitorDetectionInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'patch', 'id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    patch = sgqlc.types.Field(sgqlc.types.non_null(MonitorDetectionPatch), graphql_name='patch')
    id = sgqlc.types.Field(sgqlc.types.non_null(BigInt), graphql_name='id')


class UpdateMonitorInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'patch', 'id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    patch = sgqlc.types.Field(sgqlc.types.non_null(MonitorPatch), graphql_name='patch')
    id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='id')


class UpdatePhoneNumberInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('phone_number', 'verification_code', 'client_mutation_id')
    phone_number = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='phoneNumber')
    verification_code = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='verificationCode')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')


class UpdatePricingNodeByNodeIdInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'node_id', 'patch')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    node_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name='nodeId')
    patch = sgqlc.types.Field(sgqlc.types.non_null(PricingNodePatch), graphql_name='patch')


class UpdatePricingNodeInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'patch', 'id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    patch = sgqlc.types.Field(sgqlc.types.non_null(PricingNodePatch), graphql_name='patch')
    id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='id')


class UpdateProgramByNodeIdInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'node_id', 'patch')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    node_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name='nodeId')
    patch = sgqlc.types.Field(sgqlc.types.non_null(ProgramPatch), graphql_name='patch')


class UpdateProgramByProjectTypeIdAndNameInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'patch', 'project_type_id', 'name')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    patch = sgqlc.types.Field(sgqlc.types.non_null(ProgramPatch), graphql_name='patch')
    project_type_id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='projectTypeId')
    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='name')


class UpdateProgramEnrollmentByNodeIdInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'node_id', 'patch')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    node_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name='nodeId')
    patch = sgqlc.types.Field(sgqlc.types.non_null(ProgramEnrollmentPatch), graphql_name='patch')


class UpdateProgramEnrollmentByProgramIdAndNameInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'patch', 'program_id', 'name')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    patch = sgqlc.types.Field(sgqlc.types.non_null(ProgramEnrollmentPatch), graphql_name='patch')
    program_id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='programId')
    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='name')


class UpdateProgramEnrollmentInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'patch', 'id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    patch = sgqlc.types.Field(sgqlc.types.non_null(ProgramEnrollmentPatch), graphql_name='patch')
    id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='id')


class UpdateProgramInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'patch', 'id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    patch = sgqlc.types.Field(sgqlc.types.non_null(ProgramPatch), graphql_name='patch')
    id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='id')


class UpdateProjectByFacilityIdAndProgramIdInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'patch', 'facility_id', 'program_id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    patch = sgqlc.types.Field(sgqlc.types.non_null(ProjectPatch), graphql_name='patch')
    facility_id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='facilityId')
    program_id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='programId')


class UpdateProjectByNodeIdInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'node_id', 'patch')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    node_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name='nodeId')
    patch = sgqlc.types.Field(sgqlc.types.non_null(ProjectPatch), graphql_name='patch')


class UpdateProjectComponentByNodeIdInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'node_id', 'patch')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    node_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name='nodeId')
    patch = sgqlc.types.Field(sgqlc.types.non_null(ProjectComponentPatch), graphql_name='patch')


class UpdateProjectComponentInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'patch', 'project_id', 'component_id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    patch = sgqlc.types.Field(sgqlc.types.non_null(ProjectComponentPatch), graphql_name='patch')
    project_id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='projectId')
    component_id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='componentId')


class UpdateProjectEnrollmentDataPointByNodeIdInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'node_id', 'patch')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    node_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name='nodeId')
    patch = sgqlc.types.Field(sgqlc.types.non_null(ProjectEnrollmentDataPointPatch), graphql_name='patch')


class UpdateProjectEnrollmentDataPointByProjectEnrollmentIdAndDataPointIdInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'patch', 'project_enrollment_id', 'data_point_id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    patch = sgqlc.types.Field(sgqlc.types.non_null(ProjectEnrollmentDataPointPatch), graphql_name='patch')
    project_enrollment_id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='projectEnrollmentId')
    data_point_id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='dataPointId')


class UpdateProjectEnrollmentDataPointGroupByNodeIdInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'node_id', 'patch')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    node_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name='nodeId')
    patch = sgqlc.types.Field(sgqlc.types.non_null(ProjectEnrollmentDataPointGroupPatch), graphql_name='patch')


class UpdateProjectEnrollmentDataPointGroupInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'patch', 'id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    patch = sgqlc.types.Field(sgqlc.types.non_null(ProjectEnrollmentDataPointGroupPatch), graphql_name='patch')
    id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='id')


class UpdateProjectEnrollmentDataPointInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'patch', 'id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    patch = sgqlc.types.Field(sgqlc.types.non_null(ProjectEnrollmentDataPointPatch), graphql_name='patch')
    id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='id')


class UpdateProjectInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'patch', 'id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    patch = sgqlc.types.Field(sgqlc.types.non_null(ProjectPatch), graphql_name='patch')
    id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='id')


class UpdateProjectWatcherByNodeIdInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'node_id', 'patch')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    node_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name='nodeId')
    patch = sgqlc.types.Field(sgqlc.types.non_null(ProjectWatcherPatch), graphql_name='patch')


class UpdateProjectWatcherInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'patch', 'project_id', 'user_id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    patch = sgqlc.types.Field(sgqlc.types.non_null(ProjectWatcherPatch), graphql_name='patch')
    project_id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='projectId')
    user_id = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='userId')


class UpdateReportExecutionByNodeIdInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'node_id', 'patch')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    node_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name='nodeId')
    patch = sgqlc.types.Field(sgqlc.types.non_null(ReportExecutionPatch), graphql_name='patch')


class UpdateReportExecutionInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'patch', 'id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    patch = sgqlc.types.Field(sgqlc.types.non_null(ReportExecutionPatch), graphql_name='patch')
    id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='id')


class UpdateSavingsEventByNodeIdInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'node_id', 'patch')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    node_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name='nodeId')
    patch = sgqlc.types.Field(sgqlc.types.non_null(SavingsEventPatch), graphql_name='patch')


class UpdateSavingsEventByProjectIdAndStartTimeAndEndTimeInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'patch', 'project_id', 'start_time', 'end_time')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    patch = sgqlc.types.Field(sgqlc.types.non_null(SavingsEventPatch), graphql_name='patch')
    project_id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='projectId')
    start_time = sgqlc.types.Field(sgqlc.types.non_null(Datetime), graphql_name='startTime')
    end_time = sgqlc.types.Field(sgqlc.types.non_null(Datetime), graphql_name='endTime')


class UpdateSavingsEventInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'patch', 'id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    patch = sgqlc.types.Field(sgqlc.types.non_null(SavingsEventPatch), graphql_name='patch')
    id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='id')


class UpdateSuggestionByNodeIdInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'node_id', 'patch')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    node_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name='nodeId')
    patch = sgqlc.types.Field(sgqlc.types.non_null(SuggestionPatch), graphql_name='patch')


class UpdateSuggestionControlEventByControlEventIdInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'patch', 'control_event_id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    patch = sgqlc.types.Field(sgqlc.types.non_null(SuggestionControlEventPatch), graphql_name='patch')
    control_event_id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='controlEventId')


class UpdateSuggestionControlEventByNodeIdInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'node_id', 'patch')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    node_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name='nodeId')
    patch = sgqlc.types.Field(sgqlc.types.non_null(SuggestionControlEventPatch), graphql_name='patch')


class UpdateSuggestionControlEventInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'patch', 'suggestion_id', 'control_event_id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    patch = sgqlc.types.Field(sgqlc.types.non_null(SuggestionControlEventPatch), graphql_name='patch')
    suggestion_id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='suggestionId')
    control_event_id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='controlEventId')


class UpdateSuggestionInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'patch', 'id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    patch = sgqlc.types.Field(sgqlc.types.non_null(SuggestionPatch), graphql_name='patch')
    id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='id')


class UpdateUserByNodeIdInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'node_id', 'patch')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    node_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name='nodeId')
    patch = sgqlc.types.Field(sgqlc.types.non_null('UserPatch'), graphql_name='patch')


class UpdateUserInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'patch', 'id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    patch = sgqlc.types.Field(sgqlc.types.non_null('UserPatch'), graphql_name='patch')
    id = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='id')


class UpdateUtilityAccountByNodeIdInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'node_id', 'patch')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    node_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name='nodeId')
    patch = sgqlc.types.Field(sgqlc.types.non_null('UtilityAccountPatch'), graphql_name='patch')


class UpdateUtilityAccountInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'patch', 'id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    patch = sgqlc.types.Field(sgqlc.types.non_null('UtilityAccountPatch'), graphql_name='patch')
    id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='id')


class UpdateUtilityMeterByNodeIdInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'node_id', 'patch')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    node_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name='nodeId')
    patch = sgqlc.types.Field(sgqlc.types.non_null('UtilityMeterPatch'), graphql_name='patch')


class UpdateUtilityMeterInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'patch', 'id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    patch = sgqlc.types.Field(sgqlc.types.non_null('UtilityMeterPatch'), graphql_name='patch')
    id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='id')


class UpdateUtilityProviderByNameInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'patch', 'name')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    patch = sgqlc.types.Field(sgqlc.types.non_null('UtilityProviderPatch'), graphql_name='patch')
    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='name')


class UpdateUtilityProviderByNodeIdInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'node_id', 'patch')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    node_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name='nodeId')
    patch = sgqlc.types.Field(sgqlc.types.non_null('UtilityProviderPatch'), graphql_name='patch')


class UpdateUtilityProviderInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'patch', 'id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    patch = sgqlc.types.Field(sgqlc.types.non_null('UtilityProviderPatch'), graphql_name='patch')
    id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='id')


class UpdateVendorUserByEmailInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'patch', 'email')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    patch = sgqlc.types.Field(sgqlc.types.non_null('VendorUserPatch'), graphql_name='patch')
    email = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='email')


class UpdateVendorUserByNodeIdInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'node_id', 'patch')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    node_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name='nodeId')
    patch = sgqlc.types.Field(sgqlc.types.non_null('VendorUserPatch'), graphql_name='patch')


class UpdateVendorUserInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'patch', 'id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    patch = sgqlc.types.Field(sgqlc.types.non_null('VendorUserPatch'), graphql_name='patch')
    id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='id')


class UpdateVendorUserMachineUserByMachineUserIdInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'patch', 'machine_user_id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    patch = sgqlc.types.Field(sgqlc.types.non_null('VendorUserMachineUserPatch'), graphql_name='patch')
    machine_user_id = sgqlc.types.Field(sgqlc.types.non_null(BigInt), graphql_name='machineUserId')


class UpdateVendorUserMachineUserByNodeIdInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'node_id', 'patch')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    node_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name='nodeId')
    patch = sgqlc.types.Field(sgqlc.types.non_null('VendorUserMachineUserPatch'), graphql_name='patch')


class UpdateVendorUserMachineUserInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'patch', 'vendor_user_id', 'machine_user_id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    patch = sgqlc.types.Field(sgqlc.types.non_null('VendorUserMachineUserPatch'), graphql_name='patch')
    vendor_user_id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='vendorUserId')
    machine_user_id = sgqlc.types.Field(sgqlc.types.non_null(BigInt), graphql_name='machineUserId')


class UpdateVirtualPointIntervalByNodeIdInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'node_id', 'patch')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    node_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name='nodeId')
    patch = sgqlc.types.Field(sgqlc.types.non_null('VirtualPointIntervalPatch'), graphql_name='patch')


class UpdateVirtualPointIntervalInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'patch', 'parent_id', 'child_id')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    patch = sgqlc.types.Field(sgqlc.types.non_null('VirtualPointIntervalPatch'), graphql_name='patch')
    parent_id = sgqlc.types.Field(sgqlc.types.non_null(BigInt), graphql_name='parentId')
    child_id = sgqlc.types.Field(sgqlc.types.non_null(BigInt), graphql_name='childId')


class UpsertAccountChargeInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'account_charge')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    account_charge = sgqlc.types.Field(sgqlc.types.non_null(AccountChargeInput), graphql_name='accountCharge')


class UpsertAccountChargeWhere(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'account_statement_id', 'category', 'interval_start', 'interval_end', 'label', 'line_number')
    id = sgqlc.types.Field(Int, graphql_name='id')
    account_statement_id = sgqlc.types.Field(Int, graphql_name='accountStatementId')
    category = sgqlc.types.Field(UtilityAccountChargeCategory, graphql_name='category')
    interval_start = sgqlc.types.Field(Date, graphql_name='intervalStart')
    interval_end = sgqlc.types.Field(Date, graphql_name='intervalEnd')
    label = sgqlc.types.Field(String, graphql_name='label')
    line_number = sgqlc.types.Field(Int, graphql_name='lineNumber')


class UpsertAccountStatementInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'account_statement')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    account_statement = sgqlc.types.Field(sgqlc.types.non_null(AccountStatementInput), graphql_name='accountStatement')


class UpsertAccountStatementPdfInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'account_statement_pdf')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    account_statement_pdf = sgqlc.types.Field(sgqlc.types.non_null(AccountStatementPdfInput), graphql_name='accountStatementPdf')


class UpsertAccountStatementPdfWhere(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'account_statement_id', 'file_key')
    id = sgqlc.types.Field(Int, graphql_name='id')
    account_statement_id = sgqlc.types.Field(Int, graphql_name='accountStatementId')
    file_key = sgqlc.types.Field(String, graphql_name='fileKey')


class UpsertAccountStatementWhere(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'integration', 'integration_key')
    id = sgqlc.types.Field(Int, graphql_name='id')
    integration = sgqlc.types.Field(UtilityIntegration, graphql_name='integration')
    integration_key = sgqlc.types.Field(String, graphql_name='integrationKey')


class UpsertBalancingAuthorityInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'balancing_authority')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    balancing_authority = sgqlc.types.Field(sgqlc.types.non_null(BalancingAuthorityInput), graphql_name='balancingAuthority')


class UpsertBalancingAuthorityWhere(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('slug', 'id')
    slug = sgqlc.types.Field(String, graphql_name='slug')
    id = sgqlc.types.Field(Int, graphql_name='id')


class UpsertBuildingAreaInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'building_area')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    building_area = sgqlc.types.Field(sgqlc.types.non_null(BuildingAreaInput), graphql_name='buildingArea')


class UpsertBuildingAreaTypeInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'building_area_type')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    building_area_type = sgqlc.types.Field(sgqlc.types.non_null(BuildingAreaTypeInput), graphql_name='buildingAreaType')


class UpsertBuildingAreaTypeWhere(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('type',)
    type = sgqlc.types.Field(String, graphql_name='type')


class UpsertBuildingAreaWhere(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'facility_id', 'label')
    id = sgqlc.types.Field(Int, graphql_name='id')
    facility_id = sgqlc.types.Field(Int, graphql_name='facilityId')
    label = sgqlc.types.Field(String, graphql_name='label')


class UpsertChartInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'chart')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    chart = sgqlc.types.Field(sgqlc.types.non_null(ChartInput), graphql_name='chart')


class UpsertChartWhere(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id',)
    id = sgqlc.types.Field(Int, graphql_name='id')


class UpsertDashboardInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'dashboard')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    dashboard = sgqlc.types.Field(sgqlc.types.non_null(DashboardInput), graphql_name='dashboard')


class UpsertDashboardWhere(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id',)
    id = sgqlc.types.Field(Int, graphql_name='id')


class UpsertDataPointInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'data_point')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    data_point = sgqlc.types.Field(sgqlc.types.non_null(DataPointInput), graphql_name='dataPoint')


class UpsertDataPointWhere(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'data_source_name', 'name')
    id = sgqlc.types.Field(BigInt, graphql_name='id')
    data_source_name = sgqlc.types.Field(String, graphql_name='dataSourceName')
    name = sgqlc.types.Field(String, graphql_name='name')


class UpsertDependencyInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'dependency')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    dependency = sgqlc.types.Field(sgqlc.types.non_null(DependencyInput), graphql_name='dependency')


class UpsertDependencyWhere(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'path')
    id = sgqlc.types.Field(BigInt, graphql_name='id')
    path = sgqlc.types.Field(String, graphql_name='path')


class UpsertFacilityTaggedDataPointInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'facility_tagged_data_point')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    facility_tagged_data_point = sgqlc.types.Field(sgqlc.types.non_null(FacilityTaggedDataPointInput), graphql_name='facilityTaggedDataPoint')


class UpsertFacilityTaggedDataPointWhere(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'facility_id', 'data_point_id', 'tag_id')
    id = sgqlc.types.Field(Int, graphql_name='id')
    facility_id = sgqlc.types.Field(Int, graphql_name='facilityId')
    data_point_id = sgqlc.types.Field(BigInt, graphql_name='dataPointId')
    tag_id = sgqlc.types.Field(Int, graphql_name='tagId')


class UpsertMachineUserInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'machine_user')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    machine_user = sgqlc.types.Field(sgqlc.types.non_null(MachineUserInput), graphql_name='machineUser')


class UpsertMachineUserWhere(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id',)
    id = sgqlc.types.Field(BigInt, graphql_name='id')


class UpsertMainServiceInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'main_service')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    main_service = sgqlc.types.Field(sgqlc.types.non_null(MainServiceInput), graphql_name='mainService')


class UpsertMainServiceWhere(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'facility_id', 'name', 'usage_data_point_id', 'demand_data_point_id')
    id = sgqlc.types.Field(Int, graphql_name='id')
    facility_id = sgqlc.types.Field(Int, graphql_name='facilityId')
    name = sgqlc.types.Field(String, graphql_name='name')
    usage_data_point_id = sgqlc.types.Field(Int, graphql_name='usageDataPointId')
    demand_data_point_id = sgqlc.types.Field(Int, graphql_name='demandDataPointId')


class UpsertMeterChargeInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'meter_charge')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    meter_charge = sgqlc.types.Field(sgqlc.types.non_null(MeterChargeInput), graphql_name='meterCharge')


class UpsertMeterChargeWhere(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'meter_statement_id', 'category', 'label', 'line_number')
    id = sgqlc.types.Field(Int, graphql_name='id')
    meter_statement_id = sgqlc.types.Field(Int, graphql_name='meterStatementId')
    category = sgqlc.types.Field(UtilityMeterChargeCategory, graphql_name='category')
    label = sgqlc.types.Field(String, graphql_name='label')
    line_number = sgqlc.types.Field(Int, graphql_name='lineNumber')


class UpsertMeterStatementInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'meter_statement')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    meter_statement = sgqlc.types.Field(sgqlc.types.non_null(MeterStatementInput), graphql_name='meterStatement')


class UpsertMeterStatementWhere(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'integration_key', 'statement_date')
    id = sgqlc.types.Field(Int, graphql_name='id')
    integration_key = sgqlc.types.Field(String, graphql_name='integrationKey')
    statement_date = sgqlc.types.Field(Date, graphql_name='statementDate')


class UpsertMeterUsageInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'meter_usage')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    meter_usage = sgqlc.types.Field(sgqlc.types.non_null(MeterUsageInput), graphql_name='meterUsage')


class UpsertMeterUsageWhere(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'meter_statement_id', 'category', 'label', 'units', 'line_number')
    id = sgqlc.types.Field(Int, graphql_name='id')
    meter_statement_id = sgqlc.types.Field(Int, graphql_name='meterStatementId')
    category = sgqlc.types.Field(UtilityMeterUsageCategory, graphql_name='category')
    label = sgqlc.types.Field(String, graphql_name='label')
    units = sgqlc.types.Field(String, graphql_name='units')
    line_number = sgqlc.types.Field(Int, graphql_name='lineNumber')


class UpsertMonitorDataPointInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'monitor_data_point')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    monitor_data_point = sgqlc.types.Field(sgqlc.types.non_null(MonitorDataPointInput), graphql_name='monitorDataPoint')


class UpsertMonitorDataPointWhere(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('monitor_id', 'data_point_id')
    monitor_id = sgqlc.types.Field(Int, graphql_name='monitorId')
    data_point_id = sgqlc.types.Field(Int, graphql_name='dataPointId')


class UpsertPricingNodeInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'pricing_node')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    pricing_node = sgqlc.types.Field(sgqlc.types.non_null(PricingNodeInput), graphql_name='pricingNode')


class UpsertPricingNodeWhere(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id',)
    id = sgqlc.types.Field(Int, graphql_name='id')


class UpsertProgramEnrollmentInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'program_enrollment')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    program_enrollment = sgqlc.types.Field(sgqlc.types.non_null(ProgramEnrollmentInput), graphql_name='programEnrollment')


class UpsertProgramEnrollmentWhere(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'program_id', 'name')
    id = sgqlc.types.Field(Int, graphql_name='id')
    program_id = sgqlc.types.Field(Int, graphql_name='programId')
    name = sgqlc.types.Field(String, graphql_name='name')


class UpsertProgramInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'program')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    program = sgqlc.types.Field(sgqlc.types.non_null(ProgramInput), graphql_name='program')


class UpsertProgramWhere(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'project_type_id', 'name')
    id = sgqlc.types.Field(Int, graphql_name='id')
    project_type_id = sgqlc.types.Field(Int, graphql_name='projectTypeId')
    name = sgqlc.types.Field(String, graphql_name='name')


class UpsertProjectComponentInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'project_component')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    project_component = sgqlc.types.Field(sgqlc.types.non_null(ProjectComponentInput), graphql_name='projectComponent')


class UpsertProjectComponentWhere(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('project_id', 'component_id')
    project_id = sgqlc.types.Field(Int, graphql_name='projectId')
    component_id = sgqlc.types.Field(Int, graphql_name='componentId')


class UpsertProjectEnrollmentDataPointGroupInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'project_enrollment_data_point_group')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    project_enrollment_data_point_group = sgqlc.types.Field(sgqlc.types.non_null(ProjectEnrollmentDataPointGroupInput), graphql_name='projectEnrollmentDataPointGroup')


class UpsertProjectEnrollmentDataPointGroupWhere(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id',)
    id = sgqlc.types.Field(Int, graphql_name='id')


class UpsertProjectEnrollmentDataPointInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'project_enrollment_data_point')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    project_enrollment_data_point = sgqlc.types.Field(sgqlc.types.non_null(ProjectEnrollmentDataPointInput), graphql_name='projectEnrollmentDataPoint')


class UpsertProjectEnrollmentDataPointWhere(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'project_enrollment_id', 'data_point_id')
    id = sgqlc.types.Field(Int, graphql_name='id')
    project_enrollment_id = sgqlc.types.Field(Int, graphql_name='projectEnrollmentId')
    data_point_id = sgqlc.types.Field(Int, graphql_name='dataPointId')


class UpsertProjectEnrollmentInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'project_enrollment')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    project_enrollment = sgqlc.types.Field(sgqlc.types.non_null(ProjectEnrollmentInput), graphql_name='projectEnrollment')


class UpsertProjectEnrollmentWhere(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'project_id', 'program_enrollment_id')
    id = sgqlc.types.Field(Int, graphql_name='id')
    project_id = sgqlc.types.Field(Int, graphql_name='projectId')
    program_enrollment_id = sgqlc.types.Field(Int, graphql_name='programEnrollmentId')


class UpsertProjectSubscriptionInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'project_id', 'channels')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    project_id = sgqlc.types.Field(Int, graphql_name='projectId')
    channels = sgqlc.types.Field(sgqlc.types.list_of(UserSubscriptionChannel), graphql_name='channels')


class UpsertProjectWatcherInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'project_watcher')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    project_watcher = sgqlc.types.Field(sgqlc.types.non_null(ProjectWatcherInput), graphql_name='projectWatcher')


class UpsertProjectWatcherWhere(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('project_id', 'user_id')
    project_id = sgqlc.types.Field(Int, graphql_name='projectId')
    user_id = sgqlc.types.Field(String, graphql_name='userId')


class UpsertReportExecutionInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'report_execution')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    report_execution = sgqlc.types.Field(sgqlc.types.non_null(ReportExecutionInput), graphql_name='reportExecution')


class UpsertReportExecutionWhere(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id',)
    id = sgqlc.types.Field(Int, graphql_name='id')


class UpsertReportQueryInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'report_query')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    report_query = sgqlc.types.Field(sgqlc.types.non_null(ReportQueryInput), graphql_name='reportQuery')


class UpsertReportQueryWhere(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'report_id', 'label')
    id = sgqlc.types.Field(Int, graphql_name='id')
    report_id = sgqlc.types.Field(Int, graphql_name='reportId')
    label = sgqlc.types.Field(String, graphql_name='label')


class UpsertSavingsEventInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'savings_event')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    savings_event = sgqlc.types.Field(sgqlc.types.non_null(SavingsEventInput), graphql_name='savingsEvent')


class UpsertSavingsEventWhere(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'project_id', 'start_time', 'end_time')
    id = sgqlc.types.Field(Int, graphql_name='id')
    project_id = sgqlc.types.Field(Int, graphql_name='projectId')
    start_time = sgqlc.types.Field(Datetime, graphql_name='startTime')
    end_time = sgqlc.types.Field(Datetime, graphql_name='endTime')


class UpsertSuggestionControlEventInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'suggestion_control_event')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    suggestion_control_event = sgqlc.types.Field(sgqlc.types.non_null(SuggestionControlEventInput), graphql_name='suggestionControlEvent')


class UpsertSuggestionControlEventWhere(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('suggestion_id', 'control_event_id')
    suggestion_id = sgqlc.types.Field(Int, graphql_name='suggestionId')
    control_event_id = sgqlc.types.Field(Int, graphql_name='controlEventId')


class UpsertUrjanetUtilityProviderInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'urjanet_slug')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    urjanet_slug = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='urjanetSlug')


class UpsertUtilityAccountInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'utility_account')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    utility_account = sgqlc.types.Field(sgqlc.types.non_null('UtilityAccountInput'), graphql_name='utilityAccount')


class UpsertUtilityAccountWhere(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'integration', 'integration_account_key')
    id = sgqlc.types.Field(Int, graphql_name='id')
    integration = sgqlc.types.Field(UtilityIntegration, graphql_name='integration')
    integration_account_key = sgqlc.types.Field(String, graphql_name='integrationAccountKey')


class UpsertUtilityMeterInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'utility_meter')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    utility_meter = sgqlc.types.Field(sgqlc.types.non_null('UtilityMeterInput'), graphql_name='utilityMeter')


class UpsertUtilityMeterWhere(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'utility_account_id', 'integration_meter_key', 'service_type')
    id = sgqlc.types.Field(Int, graphql_name='id')
    utility_account_id = sgqlc.types.Field(Int, graphql_name='utilityAccountId')
    integration_meter_key = sgqlc.types.Field(String, graphql_name='integrationMeterKey')
    service_type = sgqlc.types.Field(UtilityMeterServiceType, graphql_name='serviceType')


class UpsertUtilityProviderInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'utility_provider')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    utility_provider = sgqlc.types.Field(sgqlc.types.non_null('UtilityProviderInput'), graphql_name='utilityProvider')


class UpsertUtilityProviderWhere(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'name')
    id = sgqlc.types.Field(Int, graphql_name='id')
    name = sgqlc.types.Field(String, graphql_name='name')


class UpsertVendorUserMachineUserInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'vendor_user_machine_user')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    vendor_user_machine_user = sgqlc.types.Field(sgqlc.types.non_null('VendorUserMachineUserInput'), graphql_name='vendorUserMachineUser')


class UpsertVendorUserMachineUserWhere(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('vendor_user_id', 'machine_user_id')
    vendor_user_id = sgqlc.types.Field(Int, graphql_name='vendorUserId')
    machine_user_id = sgqlc.types.Field(BigInt, graphql_name='machineUserId')


class UpsertVirtualPointIntervalInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'virtual_point_interval')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    virtual_point_interval = sgqlc.types.Field(sgqlc.types.non_null('VirtualPointIntervalInput'), graphql_name='virtualPointInterval')


class UpsertVirtualPointIntervalWhere(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('parent_id', 'child_id')
    parent_id = sgqlc.types.Field(BigInt, graphql_name='parentId')
    child_id = sgqlc.types.Field(BigInt, graphql_name='childId')


class UserCondition(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'first_name', 'last_name', 'email', 'phone_number', 'created_at', 'updated_at', 'phone_number_validated', 'preferred_locale')
    id = sgqlc.types.Field(String, graphql_name='id')
    first_name = sgqlc.types.Field(String, graphql_name='firstName')
    last_name = sgqlc.types.Field(String, graphql_name='lastName')
    email = sgqlc.types.Field(String, graphql_name='email')
    phone_number = sgqlc.types.Field(String, graphql_name='phoneNumber')
    created_at = sgqlc.types.Field(Datetime, graphql_name='createdAt')
    updated_at = sgqlc.types.Field(Datetime, graphql_name='updatedAt')
    phone_number_validated = sgqlc.types.Field(Boolean, graphql_name='phoneNumberValidated')
    preferred_locale = sgqlc.types.Field(String, graphql_name='preferredLocale')


class UserFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('can_edit', 'id', 'first_name', 'last_name', 'email', 'phone_number', 'created_at', 'updated_at', 'phone_number_validated', 'preferred_locale', 'and_', 'or_', 'not_')
    can_edit = sgqlc.types.Field(PermissionBooleanFilter, graphql_name='canEdit')
    id = sgqlc.types.Field(StringFilter, graphql_name='id')
    first_name = sgqlc.types.Field(StringFilter, graphql_name='firstName')
    last_name = sgqlc.types.Field(StringFilter, graphql_name='lastName')
    email = sgqlc.types.Field(StringFilter, graphql_name='email')
    phone_number = sgqlc.types.Field(StringFilter, graphql_name='phoneNumber')
    created_at = sgqlc.types.Field(DatetimeFilter, graphql_name='createdAt')
    updated_at = sgqlc.types.Field(DatetimeFilter, graphql_name='updatedAt')
    phone_number_validated = sgqlc.types.Field(BooleanFilter, graphql_name='phoneNumberValidated')
    preferred_locale = sgqlc.types.Field(StringFilter, graphql_name='preferredLocale')
    and_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('UserFilter')), graphql_name='and')
    or_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('UserFilter')), graphql_name='or')
    not_ = sgqlc.types.Field('UserFilter', graphql_name='not')


class UserPatch(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('phone_number_validated', 'preferred_locale')
    phone_number_validated = sgqlc.types.Field(Boolean, graphql_name='phoneNumberValidated')
    preferred_locale = sgqlc.types.Field(String, graphql_name='preferredLocale')


class UserSubscriptionChannelListFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('is_null', 'equal_to', 'not_equal_to', 'distinct_from', 'not_distinct_from', 'less_than', 'less_than_or_equal_to', 'greater_than', 'greater_than_or_equal_to', 'contains', 'contained_by', 'overlaps', 'any_equal_to', 'any_not_equal_to', 'any_less_than', 'any_less_than_or_equal_to', 'any_greater_than', 'any_greater_than_or_equal_to')
    is_null = sgqlc.types.Field(Boolean, graphql_name='isNull')
    equal_to = sgqlc.types.Field(sgqlc.types.list_of(UserSubscriptionChannel), graphql_name='equalTo')
    not_equal_to = sgqlc.types.Field(sgqlc.types.list_of(UserSubscriptionChannel), graphql_name='notEqualTo')
    distinct_from = sgqlc.types.Field(sgqlc.types.list_of(UserSubscriptionChannel), graphql_name='distinctFrom')
    not_distinct_from = sgqlc.types.Field(sgqlc.types.list_of(UserSubscriptionChannel), graphql_name='notDistinctFrom')
    less_than = sgqlc.types.Field(sgqlc.types.list_of(UserSubscriptionChannel), graphql_name='lessThan')
    less_than_or_equal_to = sgqlc.types.Field(sgqlc.types.list_of(UserSubscriptionChannel), graphql_name='lessThanOrEqualTo')
    greater_than = sgqlc.types.Field(sgqlc.types.list_of(UserSubscriptionChannel), graphql_name='greaterThan')
    greater_than_or_equal_to = sgqlc.types.Field(sgqlc.types.list_of(UserSubscriptionChannel), graphql_name='greaterThanOrEqualTo')
    contains = sgqlc.types.Field(sgqlc.types.list_of(UserSubscriptionChannel), graphql_name='contains')
    contained_by = sgqlc.types.Field(sgqlc.types.list_of(UserSubscriptionChannel), graphql_name='containedBy')
    overlaps = sgqlc.types.Field(sgqlc.types.list_of(UserSubscriptionChannel), graphql_name='overlaps')
    any_equal_to = sgqlc.types.Field(UserSubscriptionChannel, graphql_name='anyEqualTo')
    any_not_equal_to = sgqlc.types.Field(UserSubscriptionChannel, graphql_name='anyNotEqualTo')
    any_less_than = sgqlc.types.Field(UserSubscriptionChannel, graphql_name='anyLessThan')
    any_less_than_or_equal_to = sgqlc.types.Field(UserSubscriptionChannel, graphql_name='anyLessThanOrEqualTo')
    any_greater_than = sgqlc.types.Field(UserSubscriptionChannel, graphql_name='anyGreaterThan')
    any_greater_than_or_equal_to = sgqlc.types.Field(UserSubscriptionChannel, graphql_name='anyGreaterThanOrEqualTo')


class UserSubscriptionFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'type', 'action', 'scope', 'channels', 'user_id', 'created_at', 'updated_at', 'and_', 'or_', 'not_')
    id = sgqlc.types.Field(BigIntFilter, graphql_name='id')
    type = sgqlc.types.Field(StringFilter, graphql_name='type')
    action = sgqlc.types.Field(StringFilter, graphql_name='action')
    scope = sgqlc.types.Field(JSONFilter, graphql_name='scope')
    channels = sgqlc.types.Field(JSONFilter, graphql_name='channels')
    user_id = sgqlc.types.Field(StringFilter, graphql_name='userId')
    created_at = sgqlc.types.Field(DatetimeFilter, graphql_name='createdAt')
    updated_at = sgqlc.types.Field(DatetimeFilter, graphql_name='updatedAt')
    and_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('UserSubscriptionFilter')), graphql_name='and')
    or_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('UserSubscriptionFilter')), graphql_name='or')
    not_ = sgqlc.types.Field('UserSubscriptionFilter', graphql_name='not')


class UtilityAccountChargeCategoryFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('is_null', 'equal_to', 'not_equal_to', 'distinct_from', 'not_distinct_from', 'in_', 'not_in', 'less_than', 'less_than_or_equal_to', 'greater_than', 'greater_than_or_equal_to')
    is_null = sgqlc.types.Field(Boolean, graphql_name='isNull')
    equal_to = sgqlc.types.Field(UtilityAccountChargeCategory, graphql_name='equalTo')
    not_equal_to = sgqlc.types.Field(UtilityAccountChargeCategory, graphql_name='notEqualTo')
    distinct_from = sgqlc.types.Field(UtilityAccountChargeCategory, graphql_name='distinctFrom')
    not_distinct_from = sgqlc.types.Field(UtilityAccountChargeCategory, graphql_name='notDistinctFrom')
    in_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(UtilityAccountChargeCategory)), graphql_name='in')
    not_in = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(UtilityAccountChargeCategory)), graphql_name='notIn')
    less_than = sgqlc.types.Field(UtilityAccountChargeCategory, graphql_name='lessThan')
    less_than_or_equal_to = sgqlc.types.Field(UtilityAccountChargeCategory, graphql_name='lessThanOrEqualTo')
    greater_than = sgqlc.types.Field(UtilityAccountChargeCategory, graphql_name='greaterThan')
    greater_than_or_equal_to = sgqlc.types.Field(UtilityAccountChargeCategory, graphql_name='greaterThanOrEqualTo')


class UtilityAccountCondition(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'integration', 'integration_account_key', 'account_number', 'name', 'metadata', 'utility_provider_id', 'created_at', 'updated_at', 'deleted_at')
    id = sgqlc.types.Field(Int, graphql_name='id')
    integration = sgqlc.types.Field(UtilityIntegration, graphql_name='integration')
    integration_account_key = sgqlc.types.Field(String, graphql_name='integrationAccountKey')
    account_number = sgqlc.types.Field(String, graphql_name='accountNumber')
    name = sgqlc.types.Field(String, graphql_name='name')
    metadata = sgqlc.types.Field(JSON, graphql_name='metadata')
    utility_provider_id = sgqlc.types.Field(Int, graphql_name='utilityProviderId')
    created_at = sgqlc.types.Field(Datetime, graphql_name='createdAt')
    updated_at = sgqlc.types.Field(Datetime, graphql_name='updatedAt')
    deleted_at = sgqlc.types.Field(Datetime, graphql_name='deletedAt')


class UtilityAccountFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'integration', 'integration_account_key', 'account_number', 'name', 'metadata', 'utility_provider_id', 'created_at', 'updated_at', 'deleted_at', 'display_name', 'and_', 'or_', 'not_')
    id = sgqlc.types.Field(IntFilter, graphql_name='id')
    integration = sgqlc.types.Field('UtilityIntegrationFilter', graphql_name='integration')
    integration_account_key = sgqlc.types.Field(StringFilter, graphql_name='integrationAccountKey')
    account_number = sgqlc.types.Field(StringFilter, graphql_name='accountNumber')
    name = sgqlc.types.Field(StringFilter, graphql_name='name')
    metadata = sgqlc.types.Field(JSONFilter, graphql_name='metadata')
    utility_provider_id = sgqlc.types.Field(IntFilter, graphql_name='utilityProviderId')
    created_at = sgqlc.types.Field(DatetimeFilter, graphql_name='createdAt')
    updated_at = sgqlc.types.Field(DatetimeFilter, graphql_name='updatedAt')
    deleted_at = sgqlc.types.Field(DatetimeFilter, graphql_name='deletedAt')
    display_name = sgqlc.types.Field(StringFilter, graphql_name='displayName')
    and_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('UtilityAccountFilter')), graphql_name='and')
    or_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('UtilityAccountFilter')), graphql_name='or')
    not_ = sgqlc.types.Field('UtilityAccountFilter', graphql_name='not')


class UtilityAccountInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'integration', 'integration_account_key', 'account_number', 'name', 'metadata', 'utility_provider_id', 'utility_provider')
    id = sgqlc.types.Field(Int, graphql_name='id')
    integration = sgqlc.types.Field(sgqlc.types.non_null(UtilityIntegration), graphql_name='integration')
    integration_account_key = sgqlc.types.Field(String, graphql_name='integrationAccountKey')
    account_number = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='accountNumber')
    name = sgqlc.types.Field(String, graphql_name='name')
    metadata = sgqlc.types.Field(JSON, graphql_name='metadata')
    utility_provider_id = sgqlc.types.Field(Int, graphql_name='utilityProviderId')
    utility_provider = sgqlc.types.Field('UtilityProviderInput', graphql_name='utilityProvider')


class UtilityAccountPatch(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('name', 'metadata', 'utility_provider_id')
    name = sgqlc.types.Field(String, graphql_name='name')
    metadata = sgqlc.types.Field(JSON, graphql_name='metadata')
    utility_provider_id = sgqlc.types.Field(Int, graphql_name='utilityProviderId')


class UtilityAccountStatementCondition(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('utility_account_id', 'account_label', 'provider', 'account_statement_id', 'statement_year', 'statement_month', 'interval_start', 'interval_end', 'is_validated', 'currency_code', 'bill_arrival_date')
    utility_account_id = sgqlc.types.Field(Int, graphql_name='utilityAccountId')
    account_label = sgqlc.types.Field(String, graphql_name='accountLabel')
    provider = sgqlc.types.Field(String, graphql_name='provider')
    account_statement_id = sgqlc.types.Field(Int, graphql_name='accountStatementId')
    statement_year = sgqlc.types.Field(Int, graphql_name='statementYear')
    statement_month = sgqlc.types.Field(Int, graphql_name='statementMonth')
    interval_start = sgqlc.types.Field(Date, graphql_name='intervalStart')
    interval_end = sgqlc.types.Field(Date, graphql_name='intervalEnd')
    is_validated = sgqlc.types.Field(Boolean, graphql_name='isValidated')
    currency_code = sgqlc.types.Field(String, graphql_name='currencyCode')
    bill_arrival_date = sgqlc.types.Field(Datetime, graphql_name='billArrivalDate')


class UtilityAccountStatementFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('utility_account_id', 'account_label', 'provider', 'account_statement_id', 'statement_year', 'statement_month', 'interval_start', 'interval_end', 'is_validated', 'currency_code', 'bill_arrival_date', 'bill_cost', 'credits', 'fees', 'service_types', 'taxes', 'and_', 'or_', 'not_')
    utility_account_id = sgqlc.types.Field(IntFilter, graphql_name='utilityAccountId')
    account_label = sgqlc.types.Field(StringFilter, graphql_name='accountLabel')
    provider = sgqlc.types.Field(StringFilter, graphql_name='provider')
    account_statement_id = sgqlc.types.Field(IntFilter, graphql_name='accountStatementId')
    statement_year = sgqlc.types.Field(IntFilter, graphql_name='statementYear')
    statement_month = sgqlc.types.Field(IntFilter, graphql_name='statementMonth')
    interval_start = sgqlc.types.Field(DateFilter, graphql_name='intervalStart')
    interval_end = sgqlc.types.Field(DateFilter, graphql_name='intervalEnd')
    is_validated = sgqlc.types.Field(BooleanFilter, graphql_name='isValidated')
    currency_code = sgqlc.types.Field(StringFilter, graphql_name='currencyCode')
    bill_arrival_date = sgqlc.types.Field(DatetimeFilter, graphql_name='billArrivalDate')
    bill_cost = sgqlc.types.Field(FloatFilter, graphql_name='billCost')
    credits = sgqlc.types.Field(FloatFilter, graphql_name='credits')
    fees = sgqlc.types.Field(FloatFilter, graphql_name='fees')
    service_types = sgqlc.types.Field('UtilityMeterServiceTypeListFilter', graphql_name='serviceTypes')
    taxes = sgqlc.types.Field(FloatFilter, graphql_name='taxes')
    and_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('UtilityAccountStatementFilter')), graphql_name='and')
    or_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('UtilityAccountStatementFilter')), graphql_name='or')
    not_ = sgqlc.types.Field('UtilityAccountStatementFilter', graphql_name='not')


class UtilityAccountStatementRollupCondition(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('utility_account_id', 'account_label', 'provider', 'account_statement_id', 'is_validated', 'statement_year', 'statement_month', 'interval_start', 'interval_end', 'bill_arrival_date', 'bill_cost', 'bill_usage_cost', 'bill_demand_cost', 'fees', 'taxes', 'credits', 'percent_change', 'currency_code')
    utility_account_id = sgqlc.types.Field(Int, graphql_name='utilityAccountId')
    account_label = sgqlc.types.Field(String, graphql_name='accountLabel')
    provider = sgqlc.types.Field(String, graphql_name='provider')
    account_statement_id = sgqlc.types.Field(Int, graphql_name='accountStatementId')
    is_validated = sgqlc.types.Field(Boolean, graphql_name='isValidated')
    statement_year = sgqlc.types.Field(Int, graphql_name='statementYear')
    statement_month = sgqlc.types.Field(Int, graphql_name='statementMonth')
    interval_start = sgqlc.types.Field(Date, graphql_name='intervalStart')
    interval_end = sgqlc.types.Field(Date, graphql_name='intervalEnd')
    bill_arrival_date = sgqlc.types.Field(Datetime, graphql_name='billArrivalDate')
    bill_cost = sgqlc.types.Field(Float, graphql_name='billCost')
    bill_usage_cost = sgqlc.types.Field(Float, graphql_name='billUsageCost')
    bill_demand_cost = sgqlc.types.Field(Float, graphql_name='billDemandCost')
    fees = sgqlc.types.Field(Float, graphql_name='fees')
    taxes = sgqlc.types.Field(Float, graphql_name='taxes')
    credits = sgqlc.types.Field(Float, graphql_name='credits')
    percent_change = sgqlc.types.Field(Float, graphql_name='percentChange')
    currency_code = sgqlc.types.Field(String, graphql_name='currencyCode')


class UtilityAccountStatementRollupFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('utility_account_id', 'account_label', 'provider', 'account_statement_id', 'is_validated', 'statement_year', 'statement_month', 'interval_start', 'interval_end', 'bill_arrival_date', 'bill_cost', 'bill_usage_cost', 'bill_demand_cost', 'fees', 'taxes', 'credits', 'percent_change', 'currency_code', 'service_types', 'and_', 'or_', 'not_')
    utility_account_id = sgqlc.types.Field(IntFilter, graphql_name='utilityAccountId')
    account_label = sgqlc.types.Field(StringFilter, graphql_name='accountLabel')
    provider = sgqlc.types.Field(StringFilter, graphql_name='provider')
    account_statement_id = sgqlc.types.Field(IntFilter, graphql_name='accountStatementId')
    is_validated = sgqlc.types.Field(BooleanFilter, graphql_name='isValidated')
    statement_year = sgqlc.types.Field(IntFilter, graphql_name='statementYear')
    statement_month = sgqlc.types.Field(IntFilter, graphql_name='statementMonth')
    interval_start = sgqlc.types.Field(DateFilter, graphql_name='intervalStart')
    interval_end = sgqlc.types.Field(DateFilter, graphql_name='intervalEnd')
    bill_arrival_date = sgqlc.types.Field(DatetimeFilter, graphql_name='billArrivalDate')
    bill_cost = sgqlc.types.Field(FloatFilter, graphql_name='billCost')
    bill_usage_cost = sgqlc.types.Field(FloatFilter, graphql_name='billUsageCost')
    bill_demand_cost = sgqlc.types.Field(FloatFilter, graphql_name='billDemandCost')
    fees = sgqlc.types.Field(FloatFilter, graphql_name='fees')
    taxes = sgqlc.types.Field(FloatFilter, graphql_name='taxes')
    credits = sgqlc.types.Field(FloatFilter, graphql_name='credits')
    percent_change = sgqlc.types.Field(FloatFilter, graphql_name='percentChange')
    currency_code = sgqlc.types.Field(StringFilter, graphql_name='currencyCode')
    service_types = sgqlc.types.Field('UtilityMeterServiceTypeListFilter', graphql_name='serviceTypes')
    and_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('UtilityAccountStatementRollupFilter')), graphql_name='and')
    or_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('UtilityAccountStatementRollupFilter')), graphql_name='or')
    not_ = sgqlc.types.Field('UtilityAccountStatementRollupFilter', graphql_name='not')


class UtilityAccountStatementRollupsHavingAverageInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('utility_account_id', 'account_statement_id', 'statement_year', 'statement_month', 'interval_start', 'interval_end', 'bill_arrival_date', 'bill_cost', 'bill_usage_cost', 'bill_demand_cost', 'fees', 'taxes', 'credits', 'percent_change')
    utility_account_id = sgqlc.types.Field(HavingIntFilter, graphql_name='utilityAccountId')
    account_statement_id = sgqlc.types.Field(HavingIntFilter, graphql_name='accountStatementId')
    statement_year = sgqlc.types.Field(HavingIntFilter, graphql_name='statementYear')
    statement_month = sgqlc.types.Field(HavingIntFilter, graphql_name='statementMonth')
    interval_start = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='intervalStart')
    interval_end = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='intervalEnd')
    bill_arrival_date = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='billArrivalDate')
    bill_cost = sgqlc.types.Field(HavingFloatFilter, graphql_name='billCost')
    bill_usage_cost = sgqlc.types.Field(HavingFloatFilter, graphql_name='billUsageCost')
    bill_demand_cost = sgqlc.types.Field(HavingFloatFilter, graphql_name='billDemandCost')
    fees = sgqlc.types.Field(HavingFloatFilter, graphql_name='fees')
    taxes = sgqlc.types.Field(HavingFloatFilter, graphql_name='taxes')
    credits = sgqlc.types.Field(HavingFloatFilter, graphql_name='credits')
    percent_change = sgqlc.types.Field(HavingFloatFilter, graphql_name='percentChange')


class UtilityAccountStatementRollupsHavingDistinctCountInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('utility_account_id', 'account_statement_id', 'statement_year', 'statement_month', 'interval_start', 'interval_end', 'bill_arrival_date', 'bill_cost', 'bill_usage_cost', 'bill_demand_cost', 'fees', 'taxes', 'credits', 'percent_change')
    utility_account_id = sgqlc.types.Field(HavingIntFilter, graphql_name='utilityAccountId')
    account_statement_id = sgqlc.types.Field(HavingIntFilter, graphql_name='accountStatementId')
    statement_year = sgqlc.types.Field(HavingIntFilter, graphql_name='statementYear')
    statement_month = sgqlc.types.Field(HavingIntFilter, graphql_name='statementMonth')
    interval_start = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='intervalStart')
    interval_end = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='intervalEnd')
    bill_arrival_date = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='billArrivalDate')
    bill_cost = sgqlc.types.Field(HavingFloatFilter, graphql_name='billCost')
    bill_usage_cost = sgqlc.types.Field(HavingFloatFilter, graphql_name='billUsageCost')
    bill_demand_cost = sgqlc.types.Field(HavingFloatFilter, graphql_name='billDemandCost')
    fees = sgqlc.types.Field(HavingFloatFilter, graphql_name='fees')
    taxes = sgqlc.types.Field(HavingFloatFilter, graphql_name='taxes')
    credits = sgqlc.types.Field(HavingFloatFilter, graphql_name='credits')
    percent_change = sgqlc.types.Field(HavingFloatFilter, graphql_name='percentChange')


class UtilityAccountStatementRollupsHavingDistinctInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('utility_account_id', 'account_statement_id', 'statement_year', 'statement_month', 'interval_start', 'interval_end', 'bill_arrival_date', 'bill_cost', 'bill_usage_cost', 'bill_demand_cost', 'fees', 'taxes', 'credits', 'percent_change')
    utility_account_id = sgqlc.types.Field(HavingIntFilter, graphql_name='utilityAccountId')
    account_statement_id = sgqlc.types.Field(HavingIntFilter, graphql_name='accountStatementId')
    statement_year = sgqlc.types.Field(HavingIntFilter, graphql_name='statementYear')
    statement_month = sgqlc.types.Field(HavingIntFilter, graphql_name='statementMonth')
    interval_start = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='intervalStart')
    interval_end = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='intervalEnd')
    bill_arrival_date = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='billArrivalDate')
    bill_cost = sgqlc.types.Field(HavingFloatFilter, graphql_name='billCost')
    bill_usage_cost = sgqlc.types.Field(HavingFloatFilter, graphql_name='billUsageCost')
    bill_demand_cost = sgqlc.types.Field(HavingFloatFilter, graphql_name='billDemandCost')
    fees = sgqlc.types.Field(HavingFloatFilter, graphql_name='fees')
    taxes = sgqlc.types.Field(HavingFloatFilter, graphql_name='taxes')
    credits = sgqlc.types.Field(HavingFloatFilter, graphql_name='credits')
    percent_change = sgqlc.types.Field(HavingFloatFilter, graphql_name='percentChange')


class UtilityAccountStatementRollupsHavingInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('and_', 'or_', 'sum', 'distinct_count', 'min', 'max', 'average', 'stddev_sample', 'stddev_population', 'variance_sample', 'variance_population', 'distinct')
    and_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('UtilityAccountStatementRollupsHavingInput')), graphql_name='AND')
    or_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('UtilityAccountStatementRollupsHavingInput')), graphql_name='OR')
    sum = sgqlc.types.Field('UtilityAccountStatementRollupsHavingSumInput', graphql_name='sum')
    distinct_count = sgqlc.types.Field(UtilityAccountStatementRollupsHavingDistinctCountInput, graphql_name='distinctCount')
    min = sgqlc.types.Field('UtilityAccountStatementRollupsHavingMinInput', graphql_name='min')
    max = sgqlc.types.Field('UtilityAccountStatementRollupsHavingMaxInput', graphql_name='max')
    average = sgqlc.types.Field(UtilityAccountStatementRollupsHavingAverageInput, graphql_name='average')
    stddev_sample = sgqlc.types.Field('UtilityAccountStatementRollupsHavingStddevSampleInput', graphql_name='stddevSample')
    stddev_population = sgqlc.types.Field('UtilityAccountStatementRollupsHavingStddevPopulationInput', graphql_name='stddevPopulation')
    variance_sample = sgqlc.types.Field('UtilityAccountStatementRollupsHavingVarianceSampleInput', graphql_name='varianceSample')
    variance_population = sgqlc.types.Field('UtilityAccountStatementRollupsHavingVariancePopulationInput', graphql_name='variancePopulation')
    distinct = sgqlc.types.Field(UtilityAccountStatementRollupsHavingDistinctInput, graphql_name='distinct')


class UtilityAccountStatementRollupsHavingMaxInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('utility_account_id', 'account_statement_id', 'statement_year', 'statement_month', 'interval_start', 'interval_end', 'bill_arrival_date', 'bill_cost', 'bill_usage_cost', 'bill_demand_cost', 'fees', 'taxes', 'credits', 'percent_change')
    utility_account_id = sgqlc.types.Field(HavingIntFilter, graphql_name='utilityAccountId')
    account_statement_id = sgqlc.types.Field(HavingIntFilter, graphql_name='accountStatementId')
    statement_year = sgqlc.types.Field(HavingIntFilter, graphql_name='statementYear')
    statement_month = sgqlc.types.Field(HavingIntFilter, graphql_name='statementMonth')
    interval_start = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='intervalStart')
    interval_end = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='intervalEnd')
    bill_arrival_date = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='billArrivalDate')
    bill_cost = sgqlc.types.Field(HavingFloatFilter, graphql_name='billCost')
    bill_usage_cost = sgqlc.types.Field(HavingFloatFilter, graphql_name='billUsageCost')
    bill_demand_cost = sgqlc.types.Field(HavingFloatFilter, graphql_name='billDemandCost')
    fees = sgqlc.types.Field(HavingFloatFilter, graphql_name='fees')
    taxes = sgqlc.types.Field(HavingFloatFilter, graphql_name='taxes')
    credits = sgqlc.types.Field(HavingFloatFilter, graphql_name='credits')
    percent_change = sgqlc.types.Field(HavingFloatFilter, graphql_name='percentChange')


class UtilityAccountStatementRollupsHavingMinInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('utility_account_id', 'account_statement_id', 'statement_year', 'statement_month', 'interval_start', 'interval_end', 'bill_arrival_date', 'bill_cost', 'bill_usage_cost', 'bill_demand_cost', 'fees', 'taxes', 'credits', 'percent_change')
    utility_account_id = sgqlc.types.Field(HavingIntFilter, graphql_name='utilityAccountId')
    account_statement_id = sgqlc.types.Field(HavingIntFilter, graphql_name='accountStatementId')
    statement_year = sgqlc.types.Field(HavingIntFilter, graphql_name='statementYear')
    statement_month = sgqlc.types.Field(HavingIntFilter, graphql_name='statementMonth')
    interval_start = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='intervalStart')
    interval_end = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='intervalEnd')
    bill_arrival_date = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='billArrivalDate')
    bill_cost = sgqlc.types.Field(HavingFloatFilter, graphql_name='billCost')
    bill_usage_cost = sgqlc.types.Field(HavingFloatFilter, graphql_name='billUsageCost')
    bill_demand_cost = sgqlc.types.Field(HavingFloatFilter, graphql_name='billDemandCost')
    fees = sgqlc.types.Field(HavingFloatFilter, graphql_name='fees')
    taxes = sgqlc.types.Field(HavingFloatFilter, graphql_name='taxes')
    credits = sgqlc.types.Field(HavingFloatFilter, graphql_name='credits')
    percent_change = sgqlc.types.Field(HavingFloatFilter, graphql_name='percentChange')


class UtilityAccountStatementRollupsHavingStddevPopulationInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('utility_account_id', 'account_statement_id', 'statement_year', 'statement_month', 'interval_start', 'interval_end', 'bill_arrival_date', 'bill_cost', 'bill_usage_cost', 'bill_demand_cost', 'fees', 'taxes', 'credits', 'percent_change')
    utility_account_id = sgqlc.types.Field(HavingIntFilter, graphql_name='utilityAccountId')
    account_statement_id = sgqlc.types.Field(HavingIntFilter, graphql_name='accountStatementId')
    statement_year = sgqlc.types.Field(HavingIntFilter, graphql_name='statementYear')
    statement_month = sgqlc.types.Field(HavingIntFilter, graphql_name='statementMonth')
    interval_start = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='intervalStart')
    interval_end = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='intervalEnd')
    bill_arrival_date = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='billArrivalDate')
    bill_cost = sgqlc.types.Field(HavingFloatFilter, graphql_name='billCost')
    bill_usage_cost = sgqlc.types.Field(HavingFloatFilter, graphql_name='billUsageCost')
    bill_demand_cost = sgqlc.types.Field(HavingFloatFilter, graphql_name='billDemandCost')
    fees = sgqlc.types.Field(HavingFloatFilter, graphql_name='fees')
    taxes = sgqlc.types.Field(HavingFloatFilter, graphql_name='taxes')
    credits = sgqlc.types.Field(HavingFloatFilter, graphql_name='credits')
    percent_change = sgqlc.types.Field(HavingFloatFilter, graphql_name='percentChange')


class UtilityAccountStatementRollupsHavingStddevSampleInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('utility_account_id', 'account_statement_id', 'statement_year', 'statement_month', 'interval_start', 'interval_end', 'bill_arrival_date', 'bill_cost', 'bill_usage_cost', 'bill_demand_cost', 'fees', 'taxes', 'credits', 'percent_change')
    utility_account_id = sgqlc.types.Field(HavingIntFilter, graphql_name='utilityAccountId')
    account_statement_id = sgqlc.types.Field(HavingIntFilter, graphql_name='accountStatementId')
    statement_year = sgqlc.types.Field(HavingIntFilter, graphql_name='statementYear')
    statement_month = sgqlc.types.Field(HavingIntFilter, graphql_name='statementMonth')
    interval_start = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='intervalStart')
    interval_end = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='intervalEnd')
    bill_arrival_date = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='billArrivalDate')
    bill_cost = sgqlc.types.Field(HavingFloatFilter, graphql_name='billCost')
    bill_usage_cost = sgqlc.types.Field(HavingFloatFilter, graphql_name='billUsageCost')
    bill_demand_cost = sgqlc.types.Field(HavingFloatFilter, graphql_name='billDemandCost')
    fees = sgqlc.types.Field(HavingFloatFilter, graphql_name='fees')
    taxes = sgqlc.types.Field(HavingFloatFilter, graphql_name='taxes')
    credits = sgqlc.types.Field(HavingFloatFilter, graphql_name='credits')
    percent_change = sgqlc.types.Field(HavingFloatFilter, graphql_name='percentChange')


class UtilityAccountStatementRollupsHavingSumInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('utility_account_id', 'account_statement_id', 'statement_year', 'statement_month', 'interval_start', 'interval_end', 'bill_arrival_date', 'bill_cost', 'bill_usage_cost', 'bill_demand_cost', 'fees', 'taxes', 'credits', 'percent_change')
    utility_account_id = sgqlc.types.Field(HavingIntFilter, graphql_name='utilityAccountId')
    account_statement_id = sgqlc.types.Field(HavingIntFilter, graphql_name='accountStatementId')
    statement_year = sgqlc.types.Field(HavingIntFilter, graphql_name='statementYear')
    statement_month = sgqlc.types.Field(HavingIntFilter, graphql_name='statementMonth')
    interval_start = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='intervalStart')
    interval_end = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='intervalEnd')
    bill_arrival_date = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='billArrivalDate')
    bill_cost = sgqlc.types.Field(HavingFloatFilter, graphql_name='billCost')
    bill_usage_cost = sgqlc.types.Field(HavingFloatFilter, graphql_name='billUsageCost')
    bill_demand_cost = sgqlc.types.Field(HavingFloatFilter, graphql_name='billDemandCost')
    fees = sgqlc.types.Field(HavingFloatFilter, graphql_name='fees')
    taxes = sgqlc.types.Field(HavingFloatFilter, graphql_name='taxes')
    credits = sgqlc.types.Field(HavingFloatFilter, graphql_name='credits')
    percent_change = sgqlc.types.Field(HavingFloatFilter, graphql_name='percentChange')


class UtilityAccountStatementRollupsHavingVariancePopulationInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('utility_account_id', 'account_statement_id', 'statement_year', 'statement_month', 'interval_start', 'interval_end', 'bill_arrival_date', 'bill_cost', 'bill_usage_cost', 'bill_demand_cost', 'fees', 'taxes', 'credits', 'percent_change')
    utility_account_id = sgqlc.types.Field(HavingIntFilter, graphql_name='utilityAccountId')
    account_statement_id = sgqlc.types.Field(HavingIntFilter, graphql_name='accountStatementId')
    statement_year = sgqlc.types.Field(HavingIntFilter, graphql_name='statementYear')
    statement_month = sgqlc.types.Field(HavingIntFilter, graphql_name='statementMonth')
    interval_start = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='intervalStart')
    interval_end = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='intervalEnd')
    bill_arrival_date = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='billArrivalDate')
    bill_cost = sgqlc.types.Field(HavingFloatFilter, graphql_name='billCost')
    bill_usage_cost = sgqlc.types.Field(HavingFloatFilter, graphql_name='billUsageCost')
    bill_demand_cost = sgqlc.types.Field(HavingFloatFilter, graphql_name='billDemandCost')
    fees = sgqlc.types.Field(HavingFloatFilter, graphql_name='fees')
    taxes = sgqlc.types.Field(HavingFloatFilter, graphql_name='taxes')
    credits = sgqlc.types.Field(HavingFloatFilter, graphql_name='credits')
    percent_change = sgqlc.types.Field(HavingFloatFilter, graphql_name='percentChange')


class UtilityAccountStatementRollupsHavingVarianceSampleInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('utility_account_id', 'account_statement_id', 'statement_year', 'statement_month', 'interval_start', 'interval_end', 'bill_arrival_date', 'bill_cost', 'bill_usage_cost', 'bill_demand_cost', 'fees', 'taxes', 'credits', 'percent_change')
    utility_account_id = sgqlc.types.Field(HavingIntFilter, graphql_name='utilityAccountId')
    account_statement_id = sgqlc.types.Field(HavingIntFilter, graphql_name='accountStatementId')
    statement_year = sgqlc.types.Field(HavingIntFilter, graphql_name='statementYear')
    statement_month = sgqlc.types.Field(HavingIntFilter, graphql_name='statementMonth')
    interval_start = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='intervalStart')
    interval_end = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='intervalEnd')
    bill_arrival_date = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='billArrivalDate')
    bill_cost = sgqlc.types.Field(HavingFloatFilter, graphql_name='billCost')
    bill_usage_cost = sgqlc.types.Field(HavingFloatFilter, graphql_name='billUsageCost')
    bill_demand_cost = sgqlc.types.Field(HavingFloatFilter, graphql_name='billDemandCost')
    fees = sgqlc.types.Field(HavingFloatFilter, graphql_name='fees')
    taxes = sgqlc.types.Field(HavingFloatFilter, graphql_name='taxes')
    credits = sgqlc.types.Field(HavingFloatFilter, graphql_name='credits')
    percent_change = sgqlc.types.Field(HavingFloatFilter, graphql_name='percentChange')


class UtilityAccountStatementsHavingAverageInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('utility_account_id', 'account_statement_id', 'statement_year', 'statement_month', 'interval_start', 'interval_end', 'bill_arrival_date', 'bill_cost', 'credits', 'fees', 'taxes')
    utility_account_id = sgqlc.types.Field(HavingIntFilter, graphql_name='utilityAccountId')
    account_statement_id = sgqlc.types.Field(HavingIntFilter, graphql_name='accountStatementId')
    statement_year = sgqlc.types.Field(HavingIntFilter, graphql_name='statementYear')
    statement_month = sgqlc.types.Field(HavingIntFilter, graphql_name='statementMonth')
    interval_start = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='intervalStart')
    interval_end = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='intervalEnd')
    bill_arrival_date = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='billArrivalDate')
    bill_cost = sgqlc.types.Field('UtilityAccountStatementsHavingAverageUtilityAccountStatementsBillCostInput', graphql_name='billCost')
    credits = sgqlc.types.Field('UtilityAccountStatementsHavingAverageUtilityAccountStatementsCreditsInput', graphql_name='credits')
    fees = sgqlc.types.Field('UtilityAccountStatementsHavingAverageUtilityAccountStatementsFeesInput', graphql_name='fees')
    taxes = sgqlc.types.Field('UtilityAccountStatementsHavingAverageUtilityAccountStatementsTaxesInput', graphql_name='taxes')


class UtilityAccountStatementsHavingAverageUtilityAccountStatementsBillCostInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityAccountStatementsHavingAverageUtilityAccountStatementsCreditsInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityAccountStatementsHavingAverageUtilityAccountStatementsFeesInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityAccountStatementsHavingAverageUtilityAccountStatementsTaxesInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityAccountStatementsHavingDistinctCountInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('utility_account_id', 'account_statement_id', 'statement_year', 'statement_month', 'interval_start', 'interval_end', 'bill_arrival_date', 'bill_cost', 'credits', 'fees', 'taxes')
    utility_account_id = sgqlc.types.Field(HavingIntFilter, graphql_name='utilityAccountId')
    account_statement_id = sgqlc.types.Field(HavingIntFilter, graphql_name='accountStatementId')
    statement_year = sgqlc.types.Field(HavingIntFilter, graphql_name='statementYear')
    statement_month = sgqlc.types.Field(HavingIntFilter, graphql_name='statementMonth')
    interval_start = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='intervalStart')
    interval_end = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='intervalEnd')
    bill_arrival_date = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='billArrivalDate')
    bill_cost = sgqlc.types.Field('UtilityAccountStatementsHavingDistinctCountUtilityAccountStatementsBillCostInput', graphql_name='billCost')
    credits = sgqlc.types.Field('UtilityAccountStatementsHavingDistinctCountUtilityAccountStatementsCreditsInput', graphql_name='credits')
    fees = sgqlc.types.Field('UtilityAccountStatementsHavingDistinctCountUtilityAccountStatementsFeesInput', graphql_name='fees')
    taxes = sgqlc.types.Field('UtilityAccountStatementsHavingDistinctCountUtilityAccountStatementsTaxesInput', graphql_name='taxes')


class UtilityAccountStatementsHavingDistinctCountUtilityAccountStatementsBillCostInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityAccountStatementsHavingDistinctCountUtilityAccountStatementsCreditsInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityAccountStatementsHavingDistinctCountUtilityAccountStatementsFeesInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityAccountStatementsHavingDistinctCountUtilityAccountStatementsTaxesInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityAccountStatementsHavingDistinctInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('utility_account_id', 'account_statement_id', 'statement_year', 'statement_month', 'interval_start', 'interval_end', 'bill_arrival_date', 'bill_cost', 'credits', 'fees', 'taxes')
    utility_account_id = sgqlc.types.Field(HavingIntFilter, graphql_name='utilityAccountId')
    account_statement_id = sgqlc.types.Field(HavingIntFilter, graphql_name='accountStatementId')
    statement_year = sgqlc.types.Field(HavingIntFilter, graphql_name='statementYear')
    statement_month = sgqlc.types.Field(HavingIntFilter, graphql_name='statementMonth')
    interval_start = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='intervalStart')
    interval_end = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='intervalEnd')
    bill_arrival_date = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='billArrivalDate')
    bill_cost = sgqlc.types.Field('UtilityAccountStatementsHavingDistinctUtilityAccountStatementsBillCostInput', graphql_name='billCost')
    credits = sgqlc.types.Field('UtilityAccountStatementsHavingDistinctUtilityAccountStatementsCreditsInput', graphql_name='credits')
    fees = sgqlc.types.Field('UtilityAccountStatementsHavingDistinctUtilityAccountStatementsFeesInput', graphql_name='fees')
    taxes = sgqlc.types.Field('UtilityAccountStatementsHavingDistinctUtilityAccountStatementsTaxesInput', graphql_name='taxes')


class UtilityAccountStatementsHavingDistinctUtilityAccountStatementsBillCostInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityAccountStatementsHavingDistinctUtilityAccountStatementsCreditsInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityAccountStatementsHavingDistinctUtilityAccountStatementsFeesInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityAccountStatementsHavingDistinctUtilityAccountStatementsTaxesInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityAccountStatementsHavingInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('and_', 'or_', 'sum', 'distinct_count', 'min', 'max', 'average', 'stddev_sample', 'stddev_population', 'variance_sample', 'variance_population', 'distinct')
    and_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('UtilityAccountStatementsHavingInput')), graphql_name='AND')
    or_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('UtilityAccountStatementsHavingInput')), graphql_name='OR')
    sum = sgqlc.types.Field('UtilityAccountStatementsHavingSumInput', graphql_name='sum')
    distinct_count = sgqlc.types.Field(UtilityAccountStatementsHavingDistinctCountInput, graphql_name='distinctCount')
    min = sgqlc.types.Field('UtilityAccountStatementsHavingMinInput', graphql_name='min')
    max = sgqlc.types.Field('UtilityAccountStatementsHavingMaxInput', graphql_name='max')
    average = sgqlc.types.Field(UtilityAccountStatementsHavingAverageInput, graphql_name='average')
    stddev_sample = sgqlc.types.Field('UtilityAccountStatementsHavingStddevSampleInput', graphql_name='stddevSample')
    stddev_population = sgqlc.types.Field('UtilityAccountStatementsHavingStddevPopulationInput', graphql_name='stddevPopulation')
    variance_sample = sgqlc.types.Field('UtilityAccountStatementsHavingVarianceSampleInput', graphql_name='varianceSample')
    variance_population = sgqlc.types.Field('UtilityAccountStatementsHavingVariancePopulationInput', graphql_name='variancePopulation')
    distinct = sgqlc.types.Field(UtilityAccountStatementsHavingDistinctInput, graphql_name='distinct')


class UtilityAccountStatementsHavingMaxInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('utility_account_id', 'account_statement_id', 'statement_year', 'statement_month', 'interval_start', 'interval_end', 'bill_arrival_date', 'bill_cost', 'credits', 'fees', 'taxes')
    utility_account_id = sgqlc.types.Field(HavingIntFilter, graphql_name='utilityAccountId')
    account_statement_id = sgqlc.types.Field(HavingIntFilter, graphql_name='accountStatementId')
    statement_year = sgqlc.types.Field(HavingIntFilter, graphql_name='statementYear')
    statement_month = sgqlc.types.Field(HavingIntFilter, graphql_name='statementMonth')
    interval_start = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='intervalStart')
    interval_end = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='intervalEnd')
    bill_arrival_date = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='billArrivalDate')
    bill_cost = sgqlc.types.Field('UtilityAccountStatementsHavingMaxUtilityAccountStatementsBillCostInput', graphql_name='billCost')
    credits = sgqlc.types.Field('UtilityAccountStatementsHavingMaxUtilityAccountStatementsCreditsInput', graphql_name='credits')
    fees = sgqlc.types.Field('UtilityAccountStatementsHavingMaxUtilityAccountStatementsFeesInput', graphql_name='fees')
    taxes = sgqlc.types.Field('UtilityAccountStatementsHavingMaxUtilityAccountStatementsTaxesInput', graphql_name='taxes')


class UtilityAccountStatementsHavingMaxUtilityAccountStatementsBillCostInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityAccountStatementsHavingMaxUtilityAccountStatementsCreditsInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityAccountStatementsHavingMaxUtilityAccountStatementsFeesInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityAccountStatementsHavingMaxUtilityAccountStatementsTaxesInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityAccountStatementsHavingMinInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('utility_account_id', 'account_statement_id', 'statement_year', 'statement_month', 'interval_start', 'interval_end', 'bill_arrival_date', 'bill_cost', 'credits', 'fees', 'taxes')
    utility_account_id = sgqlc.types.Field(HavingIntFilter, graphql_name='utilityAccountId')
    account_statement_id = sgqlc.types.Field(HavingIntFilter, graphql_name='accountStatementId')
    statement_year = sgqlc.types.Field(HavingIntFilter, graphql_name='statementYear')
    statement_month = sgqlc.types.Field(HavingIntFilter, graphql_name='statementMonth')
    interval_start = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='intervalStart')
    interval_end = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='intervalEnd')
    bill_arrival_date = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='billArrivalDate')
    bill_cost = sgqlc.types.Field('UtilityAccountStatementsHavingMinUtilityAccountStatementsBillCostInput', graphql_name='billCost')
    credits = sgqlc.types.Field('UtilityAccountStatementsHavingMinUtilityAccountStatementsCreditsInput', graphql_name='credits')
    fees = sgqlc.types.Field('UtilityAccountStatementsHavingMinUtilityAccountStatementsFeesInput', graphql_name='fees')
    taxes = sgqlc.types.Field('UtilityAccountStatementsHavingMinUtilityAccountStatementsTaxesInput', graphql_name='taxes')


class UtilityAccountStatementsHavingMinUtilityAccountStatementsBillCostInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityAccountStatementsHavingMinUtilityAccountStatementsCreditsInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityAccountStatementsHavingMinUtilityAccountStatementsFeesInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityAccountStatementsHavingMinUtilityAccountStatementsTaxesInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityAccountStatementsHavingStddevPopulationInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('utility_account_id', 'account_statement_id', 'statement_year', 'statement_month', 'interval_start', 'interval_end', 'bill_arrival_date', 'bill_cost', 'credits', 'fees', 'taxes')
    utility_account_id = sgqlc.types.Field(HavingIntFilter, graphql_name='utilityAccountId')
    account_statement_id = sgqlc.types.Field(HavingIntFilter, graphql_name='accountStatementId')
    statement_year = sgqlc.types.Field(HavingIntFilter, graphql_name='statementYear')
    statement_month = sgqlc.types.Field(HavingIntFilter, graphql_name='statementMonth')
    interval_start = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='intervalStart')
    interval_end = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='intervalEnd')
    bill_arrival_date = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='billArrivalDate')
    bill_cost = sgqlc.types.Field('UtilityAccountStatementsHavingStddevPopulationUtilityAccountStatementsBillCostInput', graphql_name='billCost')
    credits = sgqlc.types.Field('UtilityAccountStatementsHavingStddevPopulationUtilityAccountStatementsCreditsInput', graphql_name='credits')
    fees = sgqlc.types.Field('UtilityAccountStatementsHavingStddevPopulationUtilityAccountStatementsFeesInput', graphql_name='fees')
    taxes = sgqlc.types.Field('UtilityAccountStatementsHavingStddevPopulationUtilityAccountStatementsTaxesInput', graphql_name='taxes')


class UtilityAccountStatementsHavingStddevPopulationUtilityAccountStatementsBillCostInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityAccountStatementsHavingStddevPopulationUtilityAccountStatementsCreditsInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityAccountStatementsHavingStddevPopulationUtilityAccountStatementsFeesInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityAccountStatementsHavingStddevPopulationUtilityAccountStatementsTaxesInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityAccountStatementsHavingStddevSampleInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('utility_account_id', 'account_statement_id', 'statement_year', 'statement_month', 'interval_start', 'interval_end', 'bill_arrival_date', 'bill_cost', 'credits', 'fees', 'taxes')
    utility_account_id = sgqlc.types.Field(HavingIntFilter, graphql_name='utilityAccountId')
    account_statement_id = sgqlc.types.Field(HavingIntFilter, graphql_name='accountStatementId')
    statement_year = sgqlc.types.Field(HavingIntFilter, graphql_name='statementYear')
    statement_month = sgqlc.types.Field(HavingIntFilter, graphql_name='statementMonth')
    interval_start = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='intervalStart')
    interval_end = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='intervalEnd')
    bill_arrival_date = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='billArrivalDate')
    bill_cost = sgqlc.types.Field('UtilityAccountStatementsHavingStddevSampleUtilityAccountStatementsBillCostInput', graphql_name='billCost')
    credits = sgqlc.types.Field('UtilityAccountStatementsHavingStddevSampleUtilityAccountStatementsCreditsInput', graphql_name='credits')
    fees = sgqlc.types.Field('UtilityAccountStatementsHavingStddevSampleUtilityAccountStatementsFeesInput', graphql_name='fees')
    taxes = sgqlc.types.Field('UtilityAccountStatementsHavingStddevSampleUtilityAccountStatementsTaxesInput', graphql_name='taxes')


class UtilityAccountStatementsHavingStddevSampleUtilityAccountStatementsBillCostInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityAccountStatementsHavingStddevSampleUtilityAccountStatementsCreditsInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityAccountStatementsHavingStddevSampleUtilityAccountStatementsFeesInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityAccountStatementsHavingStddevSampleUtilityAccountStatementsTaxesInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityAccountStatementsHavingSumInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('utility_account_id', 'account_statement_id', 'statement_year', 'statement_month', 'interval_start', 'interval_end', 'bill_arrival_date', 'bill_cost', 'credits', 'fees', 'taxes')
    utility_account_id = sgqlc.types.Field(HavingIntFilter, graphql_name='utilityAccountId')
    account_statement_id = sgqlc.types.Field(HavingIntFilter, graphql_name='accountStatementId')
    statement_year = sgqlc.types.Field(HavingIntFilter, graphql_name='statementYear')
    statement_month = sgqlc.types.Field(HavingIntFilter, graphql_name='statementMonth')
    interval_start = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='intervalStart')
    interval_end = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='intervalEnd')
    bill_arrival_date = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='billArrivalDate')
    bill_cost = sgqlc.types.Field('UtilityAccountStatementsHavingSumUtilityAccountStatementsBillCostInput', graphql_name='billCost')
    credits = sgqlc.types.Field('UtilityAccountStatementsHavingSumUtilityAccountStatementsCreditsInput', graphql_name='credits')
    fees = sgqlc.types.Field('UtilityAccountStatementsHavingSumUtilityAccountStatementsFeesInput', graphql_name='fees')
    taxes = sgqlc.types.Field('UtilityAccountStatementsHavingSumUtilityAccountStatementsTaxesInput', graphql_name='taxes')


class UtilityAccountStatementsHavingSumUtilityAccountStatementsBillCostInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityAccountStatementsHavingSumUtilityAccountStatementsCreditsInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityAccountStatementsHavingSumUtilityAccountStatementsFeesInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityAccountStatementsHavingSumUtilityAccountStatementsTaxesInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityAccountStatementsHavingVariancePopulationInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('utility_account_id', 'account_statement_id', 'statement_year', 'statement_month', 'interval_start', 'interval_end', 'bill_arrival_date', 'bill_cost', 'credits', 'fees', 'taxes')
    utility_account_id = sgqlc.types.Field(HavingIntFilter, graphql_name='utilityAccountId')
    account_statement_id = sgqlc.types.Field(HavingIntFilter, graphql_name='accountStatementId')
    statement_year = sgqlc.types.Field(HavingIntFilter, graphql_name='statementYear')
    statement_month = sgqlc.types.Field(HavingIntFilter, graphql_name='statementMonth')
    interval_start = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='intervalStart')
    interval_end = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='intervalEnd')
    bill_arrival_date = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='billArrivalDate')
    bill_cost = sgqlc.types.Field('UtilityAccountStatementsHavingVariancePopulationUtilityAccountStatementsBillCostInput', graphql_name='billCost')
    credits = sgqlc.types.Field('UtilityAccountStatementsHavingVariancePopulationUtilityAccountStatementsCreditsInput', graphql_name='credits')
    fees = sgqlc.types.Field('UtilityAccountStatementsHavingVariancePopulationUtilityAccountStatementsFeesInput', graphql_name='fees')
    taxes = sgqlc.types.Field('UtilityAccountStatementsHavingVariancePopulationUtilityAccountStatementsTaxesInput', graphql_name='taxes')


class UtilityAccountStatementsHavingVariancePopulationUtilityAccountStatementsBillCostInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityAccountStatementsHavingVariancePopulationUtilityAccountStatementsCreditsInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityAccountStatementsHavingVariancePopulationUtilityAccountStatementsFeesInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityAccountStatementsHavingVariancePopulationUtilityAccountStatementsTaxesInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityAccountStatementsHavingVarianceSampleInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('utility_account_id', 'account_statement_id', 'statement_year', 'statement_month', 'interval_start', 'interval_end', 'bill_arrival_date', 'bill_cost', 'credits', 'fees', 'taxes')
    utility_account_id = sgqlc.types.Field(HavingIntFilter, graphql_name='utilityAccountId')
    account_statement_id = sgqlc.types.Field(HavingIntFilter, graphql_name='accountStatementId')
    statement_year = sgqlc.types.Field(HavingIntFilter, graphql_name='statementYear')
    statement_month = sgqlc.types.Field(HavingIntFilter, graphql_name='statementMonth')
    interval_start = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='intervalStart')
    interval_end = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='intervalEnd')
    bill_arrival_date = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='billArrivalDate')
    bill_cost = sgqlc.types.Field('UtilityAccountStatementsHavingVarianceSampleUtilityAccountStatementsBillCostInput', graphql_name='billCost')
    credits = sgqlc.types.Field('UtilityAccountStatementsHavingVarianceSampleUtilityAccountStatementsCreditsInput', graphql_name='credits')
    fees = sgqlc.types.Field('UtilityAccountStatementsHavingVarianceSampleUtilityAccountStatementsFeesInput', graphql_name='fees')
    taxes = sgqlc.types.Field('UtilityAccountStatementsHavingVarianceSampleUtilityAccountStatementsTaxesInput', graphql_name='taxes')


class UtilityAccountStatementsHavingVarianceSampleUtilityAccountStatementsBillCostInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityAccountStatementsHavingVarianceSampleUtilityAccountStatementsCreditsInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityAccountStatementsHavingVarianceSampleUtilityAccountStatementsFeesInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityAccountStatementsHavingVarianceSampleUtilityAccountStatementsTaxesInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityIntegrationFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('is_null', 'equal_to', 'not_equal_to', 'distinct_from', 'not_distinct_from', 'in_', 'not_in', 'less_than', 'less_than_or_equal_to', 'greater_than', 'greater_than_or_equal_to')
    is_null = sgqlc.types.Field(Boolean, graphql_name='isNull')
    equal_to = sgqlc.types.Field(UtilityIntegration, graphql_name='equalTo')
    not_equal_to = sgqlc.types.Field(UtilityIntegration, graphql_name='notEqualTo')
    distinct_from = sgqlc.types.Field(UtilityIntegration, graphql_name='distinctFrom')
    not_distinct_from = sgqlc.types.Field(UtilityIntegration, graphql_name='notDistinctFrom')
    in_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(UtilityIntegration)), graphql_name='in')
    not_in = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(UtilityIntegration)), graphql_name='notIn')
    less_than = sgqlc.types.Field(UtilityIntegration, graphql_name='lessThan')
    less_than_or_equal_to = sgqlc.types.Field(UtilityIntegration, graphql_name='lessThanOrEqualTo')
    greater_than = sgqlc.types.Field(UtilityIntegration, graphql_name='greaterThan')
    greater_than_or_equal_to = sgqlc.types.Field(UtilityIntegration, graphql_name='greaterThanOrEqualTo')


class UtilityMeterChargeCategoryFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('is_null', 'equal_to', 'not_equal_to', 'distinct_from', 'not_distinct_from', 'in_', 'not_in', 'less_than', 'less_than_or_equal_to', 'greater_than', 'greater_than_or_equal_to')
    is_null = sgqlc.types.Field(Boolean, graphql_name='isNull')
    equal_to = sgqlc.types.Field(UtilityMeterChargeCategory, graphql_name='equalTo')
    not_equal_to = sgqlc.types.Field(UtilityMeterChargeCategory, graphql_name='notEqualTo')
    distinct_from = sgqlc.types.Field(UtilityMeterChargeCategory, graphql_name='distinctFrom')
    not_distinct_from = sgqlc.types.Field(UtilityMeterChargeCategory, graphql_name='notDistinctFrom')
    in_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(UtilityMeterChargeCategory)), graphql_name='in')
    not_in = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(UtilityMeterChargeCategory)), graphql_name='notIn')
    less_than = sgqlc.types.Field(UtilityMeterChargeCategory, graphql_name='lessThan')
    less_than_or_equal_to = sgqlc.types.Field(UtilityMeterChargeCategory, graphql_name='lessThanOrEqualTo')
    greater_than = sgqlc.types.Field(UtilityMeterChargeCategory, graphql_name='greaterThan')
    greater_than_or_equal_to = sgqlc.types.Field(UtilityMeterChargeCategory, graphql_name='greaterThanOrEqualTo')


class UtilityMeterCondition(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'utility_account_id', 'service_type', 'integration_meter_key', 'facility_id', 'name', 'active_start', 'active_end', 'metadata', 'created_at', 'updated_at', 'override_at', 'exclude_usage', 'default_demand_units', 'default_usage_units', 'exclude_carbon')
    id = sgqlc.types.Field(Int, graphql_name='id')
    utility_account_id = sgqlc.types.Field(Int, graphql_name='utilityAccountId')
    service_type = sgqlc.types.Field(UtilityMeterServiceType, graphql_name='serviceType')
    integration_meter_key = sgqlc.types.Field(String, graphql_name='integrationMeterKey')
    facility_id = sgqlc.types.Field(Int, graphql_name='facilityId')
    name = sgqlc.types.Field(String, graphql_name='name')
    active_start = sgqlc.types.Field(Date, graphql_name='activeStart')
    active_end = sgqlc.types.Field(Date, graphql_name='activeEnd')
    metadata = sgqlc.types.Field(JSON, graphql_name='metadata')
    created_at = sgqlc.types.Field(Datetime, graphql_name='createdAt')
    updated_at = sgqlc.types.Field(Datetime, graphql_name='updatedAt')
    override_at = sgqlc.types.Field(Datetime, graphql_name='overrideAt')
    exclude_usage = sgqlc.types.Field(Boolean, graphql_name='excludeUsage')
    default_demand_units = sgqlc.types.Field(String, graphql_name='defaultDemandUnits')
    default_usage_units = sgqlc.types.Field(String, graphql_name='defaultUsageUnits')
    exclude_carbon = sgqlc.types.Field(Boolean, graphql_name='excludeCarbon')


class UtilityMeterFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('meter_number', 'id', 'utility_account_id', 'service_type', 'integration_meter_key', 'facility_id', 'name', 'active_start', 'active_end', 'metadata', 'created_at', 'updated_at', 'override_at', 'exclude_usage', 'default_demand_units', 'default_usage_units', 'exclude_carbon', 'deleted_at', 'and_', 'or_', 'not_')
    meter_number = sgqlc.types.Field(StringFilter, graphql_name='meterNumber')
    id = sgqlc.types.Field(IntFilter, graphql_name='id')
    utility_account_id = sgqlc.types.Field(IntFilter, graphql_name='utilityAccountId')
    service_type = sgqlc.types.Field('UtilityMeterServiceTypeFilter', graphql_name='serviceType')
    integration_meter_key = sgqlc.types.Field(StringFilter, graphql_name='integrationMeterKey')
    facility_id = sgqlc.types.Field(IntFilter, graphql_name='facilityId')
    name = sgqlc.types.Field(StringFilter, graphql_name='name')
    active_start = sgqlc.types.Field(DateFilter, graphql_name='activeStart')
    active_end = sgqlc.types.Field(DateFilter, graphql_name='activeEnd')
    metadata = sgqlc.types.Field(JSONFilter, graphql_name='metadata')
    created_at = sgqlc.types.Field(DatetimeFilter, graphql_name='createdAt')
    updated_at = sgqlc.types.Field(DatetimeFilter, graphql_name='updatedAt')
    override_at = sgqlc.types.Field(DatetimeFilter, graphql_name='overrideAt')
    exclude_usage = sgqlc.types.Field(BooleanFilter, graphql_name='excludeUsage')
    default_demand_units = sgqlc.types.Field(StringFilter, graphql_name='defaultDemandUnits')
    default_usage_units = sgqlc.types.Field(StringFilter, graphql_name='defaultUsageUnits')
    exclude_carbon = sgqlc.types.Field(BooleanFilter, graphql_name='excludeCarbon')
    deleted_at = sgqlc.types.Field(DatetimeFilter, graphql_name='deletedAt')
    and_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('UtilityMeterFilter')), graphql_name='and')
    or_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('UtilityMeterFilter')), graphql_name='or')
    not_ = sgqlc.types.Field('UtilityMeterFilter', graphql_name='not')


class UtilityMeterInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'utility_account_id', 'service_type', 'integration_meter_key', 'facility_id', 'name', 'meter_number', 'active_start', 'active_end', 'metadata', 'override_at', 'exclude_usage', 'default_demand_units', 'default_usage_units', 'exclude_carbon', 'utility_account')
    id = sgqlc.types.Field(Int, graphql_name='id')
    utility_account_id = sgqlc.types.Field(Int, graphql_name='utilityAccountId')
    service_type = sgqlc.types.Field(sgqlc.types.non_null(UtilityMeterServiceType), graphql_name='serviceType')
    integration_meter_key = sgqlc.types.Field(String, graphql_name='integrationMeterKey')
    facility_id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='facilityId')
    name = sgqlc.types.Field(String, graphql_name='name')
    meter_number = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='meterNumber')
    active_start = sgqlc.types.Field(Date, graphql_name='activeStart')
    active_end = sgqlc.types.Field(Date, graphql_name='activeEnd')
    metadata = sgqlc.types.Field(JSON, graphql_name='metadata')
    override_at = sgqlc.types.Field(Datetime, graphql_name='overrideAt')
    exclude_usage = sgqlc.types.Field(Boolean, graphql_name='excludeUsage')
    default_demand_units = sgqlc.types.Field(String, graphql_name='defaultDemandUnits')
    default_usage_units = sgqlc.types.Field(String, graphql_name='defaultUsageUnits')
    exclude_carbon = sgqlc.types.Field(Boolean, graphql_name='excludeCarbon')
    utility_account = sgqlc.types.Field(UtilityAccountInput, graphql_name='utilityAccount')


class UtilityMeterPatch(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('service_type', 'facility_id', 'name', 'active_start', 'active_end', 'metadata', 'meter_number', 'override_at', 'exclude_usage', 'default_demand_units', 'default_usage_units', 'exclude_carbon')
    service_type = sgqlc.types.Field(UtilityMeterServiceType, graphql_name='serviceType')
    facility_id = sgqlc.types.Field(Int, graphql_name='facilityId')
    name = sgqlc.types.Field(String, graphql_name='name')
    active_start = sgqlc.types.Field(Date, graphql_name='activeStart')
    active_end = sgqlc.types.Field(Date, graphql_name='activeEnd')
    metadata = sgqlc.types.Field(JSON, graphql_name='metadata')
    meter_number = sgqlc.types.Field(String, graphql_name='meterNumber')
    override_at = sgqlc.types.Field(Datetime, graphql_name='overrideAt')
    exclude_usage = sgqlc.types.Field(Boolean, graphql_name='excludeUsage')
    default_demand_units = sgqlc.types.Field(String, graphql_name='defaultDemandUnits')
    default_usage_units = sgqlc.types.Field(String, graphql_name='defaultUsageUnits')
    exclude_carbon = sgqlc.types.Field(Boolean, graphql_name='excludeCarbon')


class UtilityMeterServiceTypeFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('is_null', 'equal_to', 'not_equal_to', 'distinct_from', 'not_distinct_from', 'in_', 'not_in', 'less_than', 'less_than_or_equal_to', 'greater_than', 'greater_than_or_equal_to')
    is_null = sgqlc.types.Field(Boolean, graphql_name='isNull')
    equal_to = sgqlc.types.Field(UtilityMeterServiceType, graphql_name='equalTo')
    not_equal_to = sgqlc.types.Field(UtilityMeterServiceType, graphql_name='notEqualTo')
    distinct_from = sgqlc.types.Field(UtilityMeterServiceType, graphql_name='distinctFrom')
    not_distinct_from = sgqlc.types.Field(UtilityMeterServiceType, graphql_name='notDistinctFrom')
    in_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(UtilityMeterServiceType)), graphql_name='in')
    not_in = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(UtilityMeterServiceType)), graphql_name='notIn')
    less_than = sgqlc.types.Field(UtilityMeterServiceType, graphql_name='lessThan')
    less_than_or_equal_to = sgqlc.types.Field(UtilityMeterServiceType, graphql_name='lessThanOrEqualTo')
    greater_than = sgqlc.types.Field(UtilityMeterServiceType, graphql_name='greaterThan')
    greater_than_or_equal_to = sgqlc.types.Field(UtilityMeterServiceType, graphql_name='greaterThanOrEqualTo')


class UtilityMeterServiceTypeListFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('is_null', 'equal_to', 'not_equal_to', 'distinct_from', 'not_distinct_from', 'less_than', 'less_than_or_equal_to', 'greater_than', 'greater_than_or_equal_to', 'contains', 'contained_by', 'overlaps', 'any_equal_to', 'any_not_equal_to', 'any_less_than', 'any_less_than_or_equal_to', 'any_greater_than', 'any_greater_than_or_equal_to')
    is_null = sgqlc.types.Field(Boolean, graphql_name='isNull')
    equal_to = sgqlc.types.Field(sgqlc.types.list_of(UtilityMeterServiceType), graphql_name='equalTo')
    not_equal_to = sgqlc.types.Field(sgqlc.types.list_of(UtilityMeterServiceType), graphql_name='notEqualTo')
    distinct_from = sgqlc.types.Field(sgqlc.types.list_of(UtilityMeterServiceType), graphql_name='distinctFrom')
    not_distinct_from = sgqlc.types.Field(sgqlc.types.list_of(UtilityMeterServiceType), graphql_name='notDistinctFrom')
    less_than = sgqlc.types.Field(sgqlc.types.list_of(UtilityMeterServiceType), graphql_name='lessThan')
    less_than_or_equal_to = sgqlc.types.Field(sgqlc.types.list_of(UtilityMeterServiceType), graphql_name='lessThanOrEqualTo')
    greater_than = sgqlc.types.Field(sgqlc.types.list_of(UtilityMeterServiceType), graphql_name='greaterThan')
    greater_than_or_equal_to = sgqlc.types.Field(sgqlc.types.list_of(UtilityMeterServiceType), graphql_name='greaterThanOrEqualTo')
    contains = sgqlc.types.Field(sgqlc.types.list_of(UtilityMeterServiceType), graphql_name='contains')
    contained_by = sgqlc.types.Field(sgqlc.types.list_of(UtilityMeterServiceType), graphql_name='containedBy')
    overlaps = sgqlc.types.Field(sgqlc.types.list_of(UtilityMeterServiceType), graphql_name='overlaps')
    any_equal_to = sgqlc.types.Field(UtilityMeterServiceType, graphql_name='anyEqualTo')
    any_not_equal_to = sgqlc.types.Field(UtilityMeterServiceType, graphql_name='anyNotEqualTo')
    any_less_than = sgqlc.types.Field(UtilityMeterServiceType, graphql_name='anyLessThan')
    any_less_than_or_equal_to = sgqlc.types.Field(UtilityMeterServiceType, graphql_name='anyLessThanOrEqualTo')
    any_greater_than = sgqlc.types.Field(UtilityMeterServiceType, graphql_name='anyGreaterThan')
    any_greater_than_or_equal_to = sgqlc.types.Field(UtilityMeterServiceType, graphql_name='anyGreaterThanOrEqualTo')


class UtilityMeterStatementCondition(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('facility_id', 'utility_account_id', 'utility_meter_id', 'meter_end_date_set', 'service_type', 'exclude_usage', 'usage_units', 'demand_units', 'meter_statement_id', 'is_validated', 'meter_label', 'provider', 'account_label', 'bill_arrival_date', 'start_date', 'end_date', 'statement_year', 'statement_month', 'currency_code', 'days_in_bill', 'account_statement_id')
    facility_id = sgqlc.types.Field(Int, graphql_name='facilityId')
    utility_account_id = sgqlc.types.Field(Int, graphql_name='utilityAccountId')
    utility_meter_id = sgqlc.types.Field(Int, graphql_name='utilityMeterId')
    meter_end_date_set = sgqlc.types.Field(Boolean, graphql_name='meterEndDateSet')
    service_type = sgqlc.types.Field(UtilityMeterServiceType, graphql_name='serviceType')
    exclude_usage = sgqlc.types.Field(Boolean, graphql_name='excludeUsage')
    usage_units = sgqlc.types.Field(String, graphql_name='usageUnits')
    demand_units = sgqlc.types.Field(String, graphql_name='demandUnits')
    meter_statement_id = sgqlc.types.Field(Int, graphql_name='meterStatementId')
    is_validated = sgqlc.types.Field(Boolean, graphql_name='isValidated')
    meter_label = sgqlc.types.Field(String, graphql_name='meterLabel')
    provider = sgqlc.types.Field(String, graphql_name='provider')
    account_label = sgqlc.types.Field(String, graphql_name='accountLabel')
    bill_arrival_date = sgqlc.types.Field(Datetime, graphql_name='billArrivalDate')
    start_date = sgqlc.types.Field(Date, graphql_name='startDate')
    end_date = sgqlc.types.Field(Date, graphql_name='endDate')
    statement_year = sgqlc.types.Field(Int, graphql_name='statementYear')
    statement_month = sgqlc.types.Field(Int, graphql_name='statementMonth')
    currency_code = sgqlc.types.Field(String, graphql_name='currencyCode')
    days_in_bill = sgqlc.types.Field(Int, graphql_name='daysInBill')
    account_statement_id = sgqlc.types.Field(Int, graphql_name='accountStatementId')


class UtilityMeterStatementFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('facility_id', 'utility_account_id', 'utility_meter_id', 'meter_end_date_set', 'service_type', 'exclude_usage', 'usage_units', 'demand_units', 'meter_statement_id', 'is_validated', 'meter_label', 'provider', 'account_label', 'bill_arrival_date', 'start_date', 'end_date', 'statement_year', 'statement_month', 'currency_code', 'days_in_bill', 'account_statement_id', 'bill_cost', 'bill_demand', 'bill_demand_cost', 'bill_usage', 'bill_usage_cost', 'credits', 'fees', 'taxes', 'and_', 'or_', 'not_')
    facility_id = sgqlc.types.Field(IntFilter, graphql_name='facilityId')
    utility_account_id = sgqlc.types.Field(IntFilter, graphql_name='utilityAccountId')
    utility_meter_id = sgqlc.types.Field(IntFilter, graphql_name='utilityMeterId')
    meter_end_date_set = sgqlc.types.Field(BooleanFilter, graphql_name='meterEndDateSet')
    service_type = sgqlc.types.Field(UtilityMeterServiceTypeFilter, graphql_name='serviceType')
    exclude_usage = sgqlc.types.Field(BooleanFilter, graphql_name='excludeUsage')
    usage_units = sgqlc.types.Field(StringFilter, graphql_name='usageUnits')
    demand_units = sgqlc.types.Field(StringFilter, graphql_name='demandUnits')
    meter_statement_id = sgqlc.types.Field(IntFilter, graphql_name='meterStatementId')
    is_validated = sgqlc.types.Field(BooleanFilter, graphql_name='isValidated')
    meter_label = sgqlc.types.Field(StringFilter, graphql_name='meterLabel')
    provider = sgqlc.types.Field(StringFilter, graphql_name='provider')
    account_label = sgqlc.types.Field(StringFilter, graphql_name='accountLabel')
    bill_arrival_date = sgqlc.types.Field(DatetimeFilter, graphql_name='billArrivalDate')
    start_date = sgqlc.types.Field(DateFilter, graphql_name='startDate')
    end_date = sgqlc.types.Field(DateFilter, graphql_name='endDate')
    statement_year = sgqlc.types.Field(IntFilter, graphql_name='statementYear')
    statement_month = sgqlc.types.Field(IntFilter, graphql_name='statementMonth')
    currency_code = sgqlc.types.Field(StringFilter, graphql_name='currencyCode')
    days_in_bill = sgqlc.types.Field(IntFilter, graphql_name='daysInBill')
    account_statement_id = sgqlc.types.Field(IntFilter, graphql_name='accountStatementId')
    bill_cost = sgqlc.types.Field(FloatFilter, graphql_name='billCost')
    bill_demand = sgqlc.types.Field(FloatFilter, graphql_name='billDemand')
    bill_demand_cost = sgqlc.types.Field(FloatFilter, graphql_name='billDemandCost')
    bill_usage = sgqlc.types.Field(FloatFilter, graphql_name='billUsage')
    bill_usage_cost = sgqlc.types.Field(FloatFilter, graphql_name='billUsageCost')
    credits = sgqlc.types.Field(FloatFilter, graphql_name='credits')
    fees = sgqlc.types.Field(FloatFilter, graphql_name='fees')
    taxes = sgqlc.types.Field(FloatFilter, graphql_name='taxes')
    and_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('UtilityMeterStatementFilter')), graphql_name='and')
    or_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('UtilityMeterStatementFilter')), graphql_name='or')
    not_ = sgqlc.types.Field('UtilityMeterStatementFilter', graphql_name='not')


class UtilityMeterStatementRollupCondition(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('facility_id', 'utility_account_id', 'utility_meter_id', 'meter_end_date_set', 'meter_statement_id', 'is_validated', 'service_type', 'meter_label', 'provider', 'bill_arrival_date', 'start_date', 'end_date', 'account_label', 'statement_year', 'statement_month', 'days_in_bill', 'bill_cost', 'usage_units', 'bill_usage', 'net_bill_usage', 'bill_usage_cost', 'demand_units', 'bill_demand', 'bill_demand_cost', 'fees', 'taxes', 'credits', 'blended_rate', 'load_factor', 'percent_change', 'currency_code', 'account_statement_id')
    facility_id = sgqlc.types.Field(Int, graphql_name='facilityId')
    utility_account_id = sgqlc.types.Field(Int, graphql_name='utilityAccountId')
    utility_meter_id = sgqlc.types.Field(Int, graphql_name='utilityMeterId')
    meter_end_date_set = sgqlc.types.Field(Boolean, graphql_name='meterEndDateSet')
    meter_statement_id = sgqlc.types.Field(Int, graphql_name='meterStatementId')
    is_validated = sgqlc.types.Field(Boolean, graphql_name='isValidated')
    service_type = sgqlc.types.Field(UtilityMeterServiceType, graphql_name='serviceType')
    meter_label = sgqlc.types.Field(String, graphql_name='meterLabel')
    provider = sgqlc.types.Field(String, graphql_name='provider')
    bill_arrival_date = sgqlc.types.Field(Datetime, graphql_name='billArrivalDate')
    start_date = sgqlc.types.Field(Date, graphql_name='startDate')
    end_date = sgqlc.types.Field(Date, graphql_name='endDate')
    account_label = sgqlc.types.Field(String, graphql_name='accountLabel')
    statement_year = sgqlc.types.Field(Int, graphql_name='statementYear')
    statement_month = sgqlc.types.Field(Int, graphql_name='statementMonth')
    days_in_bill = sgqlc.types.Field(Int, graphql_name='daysInBill')
    bill_cost = sgqlc.types.Field(Float, graphql_name='billCost')
    usage_units = sgqlc.types.Field(String, graphql_name='usageUnits')
    bill_usage = sgqlc.types.Field(Float, graphql_name='billUsage')
    net_bill_usage = sgqlc.types.Field(Float, graphql_name='netBillUsage')
    bill_usage_cost = sgqlc.types.Field(Float, graphql_name='billUsageCost')
    demand_units = sgqlc.types.Field(String, graphql_name='demandUnits')
    bill_demand = sgqlc.types.Field(Float, graphql_name='billDemand')
    bill_demand_cost = sgqlc.types.Field(Float, graphql_name='billDemandCost')
    fees = sgqlc.types.Field(Float, graphql_name='fees')
    taxes = sgqlc.types.Field(Float, graphql_name='taxes')
    credits = sgqlc.types.Field(Float, graphql_name='credits')
    blended_rate = sgqlc.types.Field(Float, graphql_name='blendedRate')
    load_factor = sgqlc.types.Field(Float, graphql_name='loadFactor')
    percent_change = sgqlc.types.Field(Float, graphql_name='percentChange')
    currency_code = sgqlc.types.Field(String, graphql_name='currencyCode')
    account_statement_id = sgqlc.types.Field(Int, graphql_name='accountStatementId')


class UtilityMeterStatementRollupFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('facility_id', 'utility_account_id', 'utility_meter_id', 'meter_end_date_set', 'meter_statement_id', 'is_validated', 'service_type', 'meter_label', 'provider', 'bill_arrival_date', 'start_date', 'end_date', 'account_label', 'statement_year', 'statement_month', 'days_in_bill', 'bill_cost', 'usage_units', 'bill_usage', 'net_bill_usage', 'bill_usage_cost', 'demand_units', 'bill_demand', 'bill_demand_cost', 'fees', 'taxes', 'credits', 'blended_rate', 'load_factor', 'percent_change', 'currency_code', 'account_statement_id', 'facility_name', 'n_sight2_active', 'statement_date', 'and_', 'or_', 'not_')
    facility_id = sgqlc.types.Field(IntFilter, graphql_name='facilityId')
    utility_account_id = sgqlc.types.Field(IntFilter, graphql_name='utilityAccountId')
    utility_meter_id = sgqlc.types.Field(IntFilter, graphql_name='utilityMeterId')
    meter_end_date_set = sgqlc.types.Field(BooleanFilter, graphql_name='meterEndDateSet')
    meter_statement_id = sgqlc.types.Field(IntFilter, graphql_name='meterStatementId')
    is_validated = sgqlc.types.Field(BooleanFilter, graphql_name='isValidated')
    service_type = sgqlc.types.Field(UtilityMeterServiceTypeFilter, graphql_name='serviceType')
    meter_label = sgqlc.types.Field(StringFilter, graphql_name='meterLabel')
    provider = sgqlc.types.Field(StringFilter, graphql_name='provider')
    bill_arrival_date = sgqlc.types.Field(DatetimeFilter, graphql_name='billArrivalDate')
    start_date = sgqlc.types.Field(DateFilter, graphql_name='startDate')
    end_date = sgqlc.types.Field(DateFilter, graphql_name='endDate')
    account_label = sgqlc.types.Field(StringFilter, graphql_name='accountLabel')
    statement_year = sgqlc.types.Field(IntFilter, graphql_name='statementYear')
    statement_month = sgqlc.types.Field(IntFilter, graphql_name='statementMonth')
    days_in_bill = sgqlc.types.Field(IntFilter, graphql_name='daysInBill')
    bill_cost = sgqlc.types.Field(FloatFilter, graphql_name='billCost')
    usage_units = sgqlc.types.Field(StringFilter, graphql_name='usageUnits')
    bill_usage = sgqlc.types.Field(FloatFilter, graphql_name='billUsage')
    net_bill_usage = sgqlc.types.Field(FloatFilter, graphql_name='netBillUsage')
    bill_usage_cost = sgqlc.types.Field(FloatFilter, graphql_name='billUsageCost')
    demand_units = sgqlc.types.Field(StringFilter, graphql_name='demandUnits')
    bill_demand = sgqlc.types.Field(FloatFilter, graphql_name='billDemand')
    bill_demand_cost = sgqlc.types.Field(FloatFilter, graphql_name='billDemandCost')
    fees = sgqlc.types.Field(FloatFilter, graphql_name='fees')
    taxes = sgqlc.types.Field(FloatFilter, graphql_name='taxes')
    credits = sgqlc.types.Field(FloatFilter, graphql_name='credits')
    blended_rate = sgqlc.types.Field(FloatFilter, graphql_name='blendedRate')
    load_factor = sgqlc.types.Field(FloatFilter, graphql_name='loadFactor')
    percent_change = sgqlc.types.Field(FloatFilter, graphql_name='percentChange')
    currency_code = sgqlc.types.Field(StringFilter, graphql_name='currencyCode')
    account_statement_id = sgqlc.types.Field(IntFilter, graphql_name='accountStatementId')
    facility_name = sgqlc.types.Field(StringFilter, graphql_name='facilityName')
    n_sight2_active = sgqlc.types.Field(BooleanFilter, graphql_name='nSight2Active')
    statement_date = sgqlc.types.Field(StringFilter, graphql_name='statementDate')
    and_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('UtilityMeterStatementRollupFilter')), graphql_name='and')
    or_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('UtilityMeterStatementRollupFilter')), graphql_name='or')
    not_ = sgqlc.types.Field('UtilityMeterStatementRollupFilter', graphql_name='not')


class UtilityMeterStatementRollupsHavingAverageInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('facility_id', 'utility_account_id', 'utility_meter_id', 'meter_statement_id', 'bill_arrival_date', 'start_date', 'end_date', 'statement_year', 'statement_month', 'days_in_bill', 'bill_cost', 'bill_usage', 'net_bill_usage', 'bill_usage_cost', 'bill_demand', 'bill_demand_cost', 'fees', 'taxes', 'credits', 'blended_rate', 'load_factor', 'percent_change', 'account_statement_id')
    facility_id = sgqlc.types.Field(HavingIntFilter, graphql_name='facilityId')
    utility_account_id = sgqlc.types.Field(HavingIntFilter, graphql_name='utilityAccountId')
    utility_meter_id = sgqlc.types.Field(HavingIntFilter, graphql_name='utilityMeterId')
    meter_statement_id = sgqlc.types.Field(HavingIntFilter, graphql_name='meterStatementId')
    bill_arrival_date = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='billArrivalDate')
    start_date = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='startDate')
    end_date = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='endDate')
    statement_year = sgqlc.types.Field(HavingIntFilter, graphql_name='statementYear')
    statement_month = sgqlc.types.Field(HavingIntFilter, graphql_name='statementMonth')
    days_in_bill = sgqlc.types.Field(HavingIntFilter, graphql_name='daysInBill')
    bill_cost = sgqlc.types.Field(HavingFloatFilter, graphql_name='billCost')
    bill_usage = sgqlc.types.Field(HavingFloatFilter, graphql_name='billUsage')
    net_bill_usage = sgqlc.types.Field(HavingFloatFilter, graphql_name='netBillUsage')
    bill_usage_cost = sgqlc.types.Field(HavingFloatFilter, graphql_name='billUsageCost')
    bill_demand = sgqlc.types.Field(HavingFloatFilter, graphql_name='billDemand')
    bill_demand_cost = sgqlc.types.Field(HavingFloatFilter, graphql_name='billDemandCost')
    fees = sgqlc.types.Field(HavingFloatFilter, graphql_name='fees')
    taxes = sgqlc.types.Field(HavingFloatFilter, graphql_name='taxes')
    credits = sgqlc.types.Field(HavingFloatFilter, graphql_name='credits')
    blended_rate = sgqlc.types.Field(HavingFloatFilter, graphql_name='blendedRate')
    load_factor = sgqlc.types.Field(HavingFloatFilter, graphql_name='loadFactor')
    percent_change = sgqlc.types.Field(HavingFloatFilter, graphql_name='percentChange')
    account_statement_id = sgqlc.types.Field(HavingIntFilter, graphql_name='accountStatementId')


class UtilityMeterStatementRollupsHavingDistinctCountInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('facility_id', 'utility_account_id', 'utility_meter_id', 'meter_statement_id', 'bill_arrival_date', 'start_date', 'end_date', 'statement_year', 'statement_month', 'days_in_bill', 'bill_cost', 'bill_usage', 'net_bill_usage', 'bill_usage_cost', 'bill_demand', 'bill_demand_cost', 'fees', 'taxes', 'credits', 'blended_rate', 'load_factor', 'percent_change', 'account_statement_id')
    facility_id = sgqlc.types.Field(HavingIntFilter, graphql_name='facilityId')
    utility_account_id = sgqlc.types.Field(HavingIntFilter, graphql_name='utilityAccountId')
    utility_meter_id = sgqlc.types.Field(HavingIntFilter, graphql_name='utilityMeterId')
    meter_statement_id = sgqlc.types.Field(HavingIntFilter, graphql_name='meterStatementId')
    bill_arrival_date = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='billArrivalDate')
    start_date = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='startDate')
    end_date = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='endDate')
    statement_year = sgqlc.types.Field(HavingIntFilter, graphql_name='statementYear')
    statement_month = sgqlc.types.Field(HavingIntFilter, graphql_name='statementMonth')
    days_in_bill = sgqlc.types.Field(HavingIntFilter, graphql_name='daysInBill')
    bill_cost = sgqlc.types.Field(HavingFloatFilter, graphql_name='billCost')
    bill_usage = sgqlc.types.Field(HavingFloatFilter, graphql_name='billUsage')
    net_bill_usage = sgqlc.types.Field(HavingFloatFilter, graphql_name='netBillUsage')
    bill_usage_cost = sgqlc.types.Field(HavingFloatFilter, graphql_name='billUsageCost')
    bill_demand = sgqlc.types.Field(HavingFloatFilter, graphql_name='billDemand')
    bill_demand_cost = sgqlc.types.Field(HavingFloatFilter, graphql_name='billDemandCost')
    fees = sgqlc.types.Field(HavingFloatFilter, graphql_name='fees')
    taxes = sgqlc.types.Field(HavingFloatFilter, graphql_name='taxes')
    credits = sgqlc.types.Field(HavingFloatFilter, graphql_name='credits')
    blended_rate = sgqlc.types.Field(HavingFloatFilter, graphql_name='blendedRate')
    load_factor = sgqlc.types.Field(HavingFloatFilter, graphql_name='loadFactor')
    percent_change = sgqlc.types.Field(HavingFloatFilter, graphql_name='percentChange')
    account_statement_id = sgqlc.types.Field(HavingIntFilter, graphql_name='accountStatementId')


class UtilityMeterStatementRollupsHavingDistinctInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('facility_id', 'utility_account_id', 'utility_meter_id', 'meter_statement_id', 'bill_arrival_date', 'start_date', 'end_date', 'statement_year', 'statement_month', 'days_in_bill', 'bill_cost', 'bill_usage', 'net_bill_usage', 'bill_usage_cost', 'bill_demand', 'bill_demand_cost', 'fees', 'taxes', 'credits', 'blended_rate', 'load_factor', 'percent_change', 'account_statement_id')
    facility_id = sgqlc.types.Field(HavingIntFilter, graphql_name='facilityId')
    utility_account_id = sgqlc.types.Field(HavingIntFilter, graphql_name='utilityAccountId')
    utility_meter_id = sgqlc.types.Field(HavingIntFilter, graphql_name='utilityMeterId')
    meter_statement_id = sgqlc.types.Field(HavingIntFilter, graphql_name='meterStatementId')
    bill_arrival_date = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='billArrivalDate')
    start_date = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='startDate')
    end_date = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='endDate')
    statement_year = sgqlc.types.Field(HavingIntFilter, graphql_name='statementYear')
    statement_month = sgqlc.types.Field(HavingIntFilter, graphql_name='statementMonth')
    days_in_bill = sgqlc.types.Field(HavingIntFilter, graphql_name='daysInBill')
    bill_cost = sgqlc.types.Field(HavingFloatFilter, graphql_name='billCost')
    bill_usage = sgqlc.types.Field(HavingFloatFilter, graphql_name='billUsage')
    net_bill_usage = sgqlc.types.Field(HavingFloatFilter, graphql_name='netBillUsage')
    bill_usage_cost = sgqlc.types.Field(HavingFloatFilter, graphql_name='billUsageCost')
    bill_demand = sgqlc.types.Field(HavingFloatFilter, graphql_name='billDemand')
    bill_demand_cost = sgqlc.types.Field(HavingFloatFilter, graphql_name='billDemandCost')
    fees = sgqlc.types.Field(HavingFloatFilter, graphql_name='fees')
    taxes = sgqlc.types.Field(HavingFloatFilter, graphql_name='taxes')
    credits = sgqlc.types.Field(HavingFloatFilter, graphql_name='credits')
    blended_rate = sgqlc.types.Field(HavingFloatFilter, graphql_name='blendedRate')
    load_factor = sgqlc.types.Field(HavingFloatFilter, graphql_name='loadFactor')
    percent_change = sgqlc.types.Field(HavingFloatFilter, graphql_name='percentChange')
    account_statement_id = sgqlc.types.Field(HavingIntFilter, graphql_name='accountStatementId')


class UtilityMeterStatementRollupsHavingInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('and_', 'or_', 'sum', 'distinct_count', 'min', 'max', 'average', 'stddev_sample', 'stddev_population', 'variance_sample', 'variance_population', 'distinct')
    and_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('UtilityMeterStatementRollupsHavingInput')), graphql_name='AND')
    or_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('UtilityMeterStatementRollupsHavingInput')), graphql_name='OR')
    sum = sgqlc.types.Field('UtilityMeterStatementRollupsHavingSumInput', graphql_name='sum')
    distinct_count = sgqlc.types.Field(UtilityMeterStatementRollupsHavingDistinctCountInput, graphql_name='distinctCount')
    min = sgqlc.types.Field('UtilityMeterStatementRollupsHavingMinInput', graphql_name='min')
    max = sgqlc.types.Field('UtilityMeterStatementRollupsHavingMaxInput', graphql_name='max')
    average = sgqlc.types.Field(UtilityMeterStatementRollupsHavingAverageInput, graphql_name='average')
    stddev_sample = sgqlc.types.Field('UtilityMeterStatementRollupsHavingStddevSampleInput', graphql_name='stddevSample')
    stddev_population = sgqlc.types.Field('UtilityMeterStatementRollupsHavingStddevPopulationInput', graphql_name='stddevPopulation')
    variance_sample = sgqlc.types.Field('UtilityMeterStatementRollupsHavingVarianceSampleInput', graphql_name='varianceSample')
    variance_population = sgqlc.types.Field('UtilityMeterStatementRollupsHavingVariancePopulationInput', graphql_name='variancePopulation')
    distinct = sgqlc.types.Field(UtilityMeterStatementRollupsHavingDistinctInput, graphql_name='distinct')


class UtilityMeterStatementRollupsHavingMaxInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('facility_id', 'utility_account_id', 'utility_meter_id', 'meter_statement_id', 'bill_arrival_date', 'start_date', 'end_date', 'statement_year', 'statement_month', 'days_in_bill', 'bill_cost', 'bill_usage', 'net_bill_usage', 'bill_usage_cost', 'bill_demand', 'bill_demand_cost', 'fees', 'taxes', 'credits', 'blended_rate', 'load_factor', 'percent_change', 'account_statement_id')
    facility_id = sgqlc.types.Field(HavingIntFilter, graphql_name='facilityId')
    utility_account_id = sgqlc.types.Field(HavingIntFilter, graphql_name='utilityAccountId')
    utility_meter_id = sgqlc.types.Field(HavingIntFilter, graphql_name='utilityMeterId')
    meter_statement_id = sgqlc.types.Field(HavingIntFilter, graphql_name='meterStatementId')
    bill_arrival_date = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='billArrivalDate')
    start_date = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='startDate')
    end_date = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='endDate')
    statement_year = sgqlc.types.Field(HavingIntFilter, graphql_name='statementYear')
    statement_month = sgqlc.types.Field(HavingIntFilter, graphql_name='statementMonth')
    days_in_bill = sgqlc.types.Field(HavingIntFilter, graphql_name='daysInBill')
    bill_cost = sgqlc.types.Field(HavingFloatFilter, graphql_name='billCost')
    bill_usage = sgqlc.types.Field(HavingFloatFilter, graphql_name='billUsage')
    net_bill_usage = sgqlc.types.Field(HavingFloatFilter, graphql_name='netBillUsage')
    bill_usage_cost = sgqlc.types.Field(HavingFloatFilter, graphql_name='billUsageCost')
    bill_demand = sgqlc.types.Field(HavingFloatFilter, graphql_name='billDemand')
    bill_demand_cost = sgqlc.types.Field(HavingFloatFilter, graphql_name='billDemandCost')
    fees = sgqlc.types.Field(HavingFloatFilter, graphql_name='fees')
    taxes = sgqlc.types.Field(HavingFloatFilter, graphql_name='taxes')
    credits = sgqlc.types.Field(HavingFloatFilter, graphql_name='credits')
    blended_rate = sgqlc.types.Field(HavingFloatFilter, graphql_name='blendedRate')
    load_factor = sgqlc.types.Field(HavingFloatFilter, graphql_name='loadFactor')
    percent_change = sgqlc.types.Field(HavingFloatFilter, graphql_name='percentChange')
    account_statement_id = sgqlc.types.Field(HavingIntFilter, graphql_name='accountStatementId')


class UtilityMeterStatementRollupsHavingMinInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('facility_id', 'utility_account_id', 'utility_meter_id', 'meter_statement_id', 'bill_arrival_date', 'start_date', 'end_date', 'statement_year', 'statement_month', 'days_in_bill', 'bill_cost', 'bill_usage', 'net_bill_usage', 'bill_usage_cost', 'bill_demand', 'bill_demand_cost', 'fees', 'taxes', 'credits', 'blended_rate', 'load_factor', 'percent_change', 'account_statement_id')
    facility_id = sgqlc.types.Field(HavingIntFilter, graphql_name='facilityId')
    utility_account_id = sgqlc.types.Field(HavingIntFilter, graphql_name='utilityAccountId')
    utility_meter_id = sgqlc.types.Field(HavingIntFilter, graphql_name='utilityMeterId')
    meter_statement_id = sgqlc.types.Field(HavingIntFilter, graphql_name='meterStatementId')
    bill_arrival_date = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='billArrivalDate')
    start_date = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='startDate')
    end_date = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='endDate')
    statement_year = sgqlc.types.Field(HavingIntFilter, graphql_name='statementYear')
    statement_month = sgqlc.types.Field(HavingIntFilter, graphql_name='statementMonth')
    days_in_bill = sgqlc.types.Field(HavingIntFilter, graphql_name='daysInBill')
    bill_cost = sgqlc.types.Field(HavingFloatFilter, graphql_name='billCost')
    bill_usage = sgqlc.types.Field(HavingFloatFilter, graphql_name='billUsage')
    net_bill_usage = sgqlc.types.Field(HavingFloatFilter, graphql_name='netBillUsage')
    bill_usage_cost = sgqlc.types.Field(HavingFloatFilter, graphql_name='billUsageCost')
    bill_demand = sgqlc.types.Field(HavingFloatFilter, graphql_name='billDemand')
    bill_demand_cost = sgqlc.types.Field(HavingFloatFilter, graphql_name='billDemandCost')
    fees = sgqlc.types.Field(HavingFloatFilter, graphql_name='fees')
    taxes = sgqlc.types.Field(HavingFloatFilter, graphql_name='taxes')
    credits = sgqlc.types.Field(HavingFloatFilter, graphql_name='credits')
    blended_rate = sgqlc.types.Field(HavingFloatFilter, graphql_name='blendedRate')
    load_factor = sgqlc.types.Field(HavingFloatFilter, graphql_name='loadFactor')
    percent_change = sgqlc.types.Field(HavingFloatFilter, graphql_name='percentChange')
    account_statement_id = sgqlc.types.Field(HavingIntFilter, graphql_name='accountStatementId')


class UtilityMeterStatementRollupsHavingStddevPopulationInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('facility_id', 'utility_account_id', 'utility_meter_id', 'meter_statement_id', 'bill_arrival_date', 'start_date', 'end_date', 'statement_year', 'statement_month', 'days_in_bill', 'bill_cost', 'bill_usage', 'net_bill_usage', 'bill_usage_cost', 'bill_demand', 'bill_demand_cost', 'fees', 'taxes', 'credits', 'blended_rate', 'load_factor', 'percent_change', 'account_statement_id')
    facility_id = sgqlc.types.Field(HavingIntFilter, graphql_name='facilityId')
    utility_account_id = sgqlc.types.Field(HavingIntFilter, graphql_name='utilityAccountId')
    utility_meter_id = sgqlc.types.Field(HavingIntFilter, graphql_name='utilityMeterId')
    meter_statement_id = sgqlc.types.Field(HavingIntFilter, graphql_name='meterStatementId')
    bill_arrival_date = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='billArrivalDate')
    start_date = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='startDate')
    end_date = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='endDate')
    statement_year = sgqlc.types.Field(HavingIntFilter, graphql_name='statementYear')
    statement_month = sgqlc.types.Field(HavingIntFilter, graphql_name='statementMonth')
    days_in_bill = sgqlc.types.Field(HavingIntFilter, graphql_name='daysInBill')
    bill_cost = sgqlc.types.Field(HavingFloatFilter, graphql_name='billCost')
    bill_usage = sgqlc.types.Field(HavingFloatFilter, graphql_name='billUsage')
    net_bill_usage = sgqlc.types.Field(HavingFloatFilter, graphql_name='netBillUsage')
    bill_usage_cost = sgqlc.types.Field(HavingFloatFilter, graphql_name='billUsageCost')
    bill_demand = sgqlc.types.Field(HavingFloatFilter, graphql_name='billDemand')
    bill_demand_cost = sgqlc.types.Field(HavingFloatFilter, graphql_name='billDemandCost')
    fees = sgqlc.types.Field(HavingFloatFilter, graphql_name='fees')
    taxes = sgqlc.types.Field(HavingFloatFilter, graphql_name='taxes')
    credits = sgqlc.types.Field(HavingFloatFilter, graphql_name='credits')
    blended_rate = sgqlc.types.Field(HavingFloatFilter, graphql_name='blendedRate')
    load_factor = sgqlc.types.Field(HavingFloatFilter, graphql_name='loadFactor')
    percent_change = sgqlc.types.Field(HavingFloatFilter, graphql_name='percentChange')
    account_statement_id = sgqlc.types.Field(HavingIntFilter, graphql_name='accountStatementId')


class UtilityMeterStatementRollupsHavingStddevSampleInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('facility_id', 'utility_account_id', 'utility_meter_id', 'meter_statement_id', 'bill_arrival_date', 'start_date', 'end_date', 'statement_year', 'statement_month', 'days_in_bill', 'bill_cost', 'bill_usage', 'net_bill_usage', 'bill_usage_cost', 'bill_demand', 'bill_demand_cost', 'fees', 'taxes', 'credits', 'blended_rate', 'load_factor', 'percent_change', 'account_statement_id')
    facility_id = sgqlc.types.Field(HavingIntFilter, graphql_name='facilityId')
    utility_account_id = sgqlc.types.Field(HavingIntFilter, graphql_name='utilityAccountId')
    utility_meter_id = sgqlc.types.Field(HavingIntFilter, graphql_name='utilityMeterId')
    meter_statement_id = sgqlc.types.Field(HavingIntFilter, graphql_name='meterStatementId')
    bill_arrival_date = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='billArrivalDate')
    start_date = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='startDate')
    end_date = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='endDate')
    statement_year = sgqlc.types.Field(HavingIntFilter, graphql_name='statementYear')
    statement_month = sgqlc.types.Field(HavingIntFilter, graphql_name='statementMonth')
    days_in_bill = sgqlc.types.Field(HavingIntFilter, graphql_name='daysInBill')
    bill_cost = sgqlc.types.Field(HavingFloatFilter, graphql_name='billCost')
    bill_usage = sgqlc.types.Field(HavingFloatFilter, graphql_name='billUsage')
    net_bill_usage = sgqlc.types.Field(HavingFloatFilter, graphql_name='netBillUsage')
    bill_usage_cost = sgqlc.types.Field(HavingFloatFilter, graphql_name='billUsageCost')
    bill_demand = sgqlc.types.Field(HavingFloatFilter, graphql_name='billDemand')
    bill_demand_cost = sgqlc.types.Field(HavingFloatFilter, graphql_name='billDemandCost')
    fees = sgqlc.types.Field(HavingFloatFilter, graphql_name='fees')
    taxes = sgqlc.types.Field(HavingFloatFilter, graphql_name='taxes')
    credits = sgqlc.types.Field(HavingFloatFilter, graphql_name='credits')
    blended_rate = sgqlc.types.Field(HavingFloatFilter, graphql_name='blendedRate')
    load_factor = sgqlc.types.Field(HavingFloatFilter, graphql_name='loadFactor')
    percent_change = sgqlc.types.Field(HavingFloatFilter, graphql_name='percentChange')
    account_statement_id = sgqlc.types.Field(HavingIntFilter, graphql_name='accountStatementId')


class UtilityMeterStatementRollupsHavingSumInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('facility_id', 'utility_account_id', 'utility_meter_id', 'meter_statement_id', 'bill_arrival_date', 'start_date', 'end_date', 'statement_year', 'statement_month', 'days_in_bill', 'bill_cost', 'bill_usage', 'net_bill_usage', 'bill_usage_cost', 'bill_demand', 'bill_demand_cost', 'fees', 'taxes', 'credits', 'blended_rate', 'load_factor', 'percent_change', 'account_statement_id')
    facility_id = sgqlc.types.Field(HavingIntFilter, graphql_name='facilityId')
    utility_account_id = sgqlc.types.Field(HavingIntFilter, graphql_name='utilityAccountId')
    utility_meter_id = sgqlc.types.Field(HavingIntFilter, graphql_name='utilityMeterId')
    meter_statement_id = sgqlc.types.Field(HavingIntFilter, graphql_name='meterStatementId')
    bill_arrival_date = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='billArrivalDate')
    start_date = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='startDate')
    end_date = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='endDate')
    statement_year = sgqlc.types.Field(HavingIntFilter, graphql_name='statementYear')
    statement_month = sgqlc.types.Field(HavingIntFilter, graphql_name='statementMonth')
    days_in_bill = sgqlc.types.Field(HavingIntFilter, graphql_name='daysInBill')
    bill_cost = sgqlc.types.Field(HavingFloatFilter, graphql_name='billCost')
    bill_usage = sgqlc.types.Field(HavingFloatFilter, graphql_name='billUsage')
    net_bill_usage = sgqlc.types.Field(HavingFloatFilter, graphql_name='netBillUsage')
    bill_usage_cost = sgqlc.types.Field(HavingFloatFilter, graphql_name='billUsageCost')
    bill_demand = sgqlc.types.Field(HavingFloatFilter, graphql_name='billDemand')
    bill_demand_cost = sgqlc.types.Field(HavingFloatFilter, graphql_name='billDemandCost')
    fees = sgqlc.types.Field(HavingFloatFilter, graphql_name='fees')
    taxes = sgqlc.types.Field(HavingFloatFilter, graphql_name='taxes')
    credits = sgqlc.types.Field(HavingFloatFilter, graphql_name='credits')
    blended_rate = sgqlc.types.Field(HavingFloatFilter, graphql_name='blendedRate')
    load_factor = sgqlc.types.Field(HavingFloatFilter, graphql_name='loadFactor')
    percent_change = sgqlc.types.Field(HavingFloatFilter, graphql_name='percentChange')
    account_statement_id = sgqlc.types.Field(HavingIntFilter, graphql_name='accountStatementId')


class UtilityMeterStatementRollupsHavingVariancePopulationInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('facility_id', 'utility_account_id', 'utility_meter_id', 'meter_statement_id', 'bill_arrival_date', 'start_date', 'end_date', 'statement_year', 'statement_month', 'days_in_bill', 'bill_cost', 'bill_usage', 'net_bill_usage', 'bill_usage_cost', 'bill_demand', 'bill_demand_cost', 'fees', 'taxes', 'credits', 'blended_rate', 'load_factor', 'percent_change', 'account_statement_id')
    facility_id = sgqlc.types.Field(HavingIntFilter, graphql_name='facilityId')
    utility_account_id = sgqlc.types.Field(HavingIntFilter, graphql_name='utilityAccountId')
    utility_meter_id = sgqlc.types.Field(HavingIntFilter, graphql_name='utilityMeterId')
    meter_statement_id = sgqlc.types.Field(HavingIntFilter, graphql_name='meterStatementId')
    bill_arrival_date = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='billArrivalDate')
    start_date = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='startDate')
    end_date = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='endDate')
    statement_year = sgqlc.types.Field(HavingIntFilter, graphql_name='statementYear')
    statement_month = sgqlc.types.Field(HavingIntFilter, graphql_name='statementMonth')
    days_in_bill = sgqlc.types.Field(HavingIntFilter, graphql_name='daysInBill')
    bill_cost = sgqlc.types.Field(HavingFloatFilter, graphql_name='billCost')
    bill_usage = sgqlc.types.Field(HavingFloatFilter, graphql_name='billUsage')
    net_bill_usage = sgqlc.types.Field(HavingFloatFilter, graphql_name='netBillUsage')
    bill_usage_cost = sgqlc.types.Field(HavingFloatFilter, graphql_name='billUsageCost')
    bill_demand = sgqlc.types.Field(HavingFloatFilter, graphql_name='billDemand')
    bill_demand_cost = sgqlc.types.Field(HavingFloatFilter, graphql_name='billDemandCost')
    fees = sgqlc.types.Field(HavingFloatFilter, graphql_name='fees')
    taxes = sgqlc.types.Field(HavingFloatFilter, graphql_name='taxes')
    credits = sgqlc.types.Field(HavingFloatFilter, graphql_name='credits')
    blended_rate = sgqlc.types.Field(HavingFloatFilter, graphql_name='blendedRate')
    load_factor = sgqlc.types.Field(HavingFloatFilter, graphql_name='loadFactor')
    percent_change = sgqlc.types.Field(HavingFloatFilter, graphql_name='percentChange')
    account_statement_id = sgqlc.types.Field(HavingIntFilter, graphql_name='accountStatementId')


class UtilityMeterStatementRollupsHavingVarianceSampleInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('facility_id', 'utility_account_id', 'utility_meter_id', 'meter_statement_id', 'bill_arrival_date', 'start_date', 'end_date', 'statement_year', 'statement_month', 'days_in_bill', 'bill_cost', 'bill_usage', 'net_bill_usage', 'bill_usage_cost', 'bill_demand', 'bill_demand_cost', 'fees', 'taxes', 'credits', 'blended_rate', 'load_factor', 'percent_change', 'account_statement_id')
    facility_id = sgqlc.types.Field(HavingIntFilter, graphql_name='facilityId')
    utility_account_id = sgqlc.types.Field(HavingIntFilter, graphql_name='utilityAccountId')
    utility_meter_id = sgqlc.types.Field(HavingIntFilter, graphql_name='utilityMeterId')
    meter_statement_id = sgqlc.types.Field(HavingIntFilter, graphql_name='meterStatementId')
    bill_arrival_date = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='billArrivalDate')
    start_date = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='startDate')
    end_date = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='endDate')
    statement_year = sgqlc.types.Field(HavingIntFilter, graphql_name='statementYear')
    statement_month = sgqlc.types.Field(HavingIntFilter, graphql_name='statementMonth')
    days_in_bill = sgqlc.types.Field(HavingIntFilter, graphql_name='daysInBill')
    bill_cost = sgqlc.types.Field(HavingFloatFilter, graphql_name='billCost')
    bill_usage = sgqlc.types.Field(HavingFloatFilter, graphql_name='billUsage')
    net_bill_usage = sgqlc.types.Field(HavingFloatFilter, graphql_name='netBillUsage')
    bill_usage_cost = sgqlc.types.Field(HavingFloatFilter, graphql_name='billUsageCost')
    bill_demand = sgqlc.types.Field(HavingFloatFilter, graphql_name='billDemand')
    bill_demand_cost = sgqlc.types.Field(HavingFloatFilter, graphql_name='billDemandCost')
    fees = sgqlc.types.Field(HavingFloatFilter, graphql_name='fees')
    taxes = sgqlc.types.Field(HavingFloatFilter, graphql_name='taxes')
    credits = sgqlc.types.Field(HavingFloatFilter, graphql_name='credits')
    blended_rate = sgqlc.types.Field(HavingFloatFilter, graphql_name='blendedRate')
    load_factor = sgqlc.types.Field(HavingFloatFilter, graphql_name='loadFactor')
    percent_change = sgqlc.types.Field(HavingFloatFilter, graphql_name='percentChange')
    account_statement_id = sgqlc.types.Field(HavingIntFilter, graphql_name='accountStatementId')


class UtilityMeterStatementsHavingAverageInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('facility_id', 'utility_account_id', 'utility_meter_id', 'meter_statement_id', 'bill_arrival_date', 'start_date', 'end_date', 'statement_year', 'statement_month', 'days_in_bill', 'account_statement_id', 'bill_cost', 'bill_demand', 'bill_demand_cost', 'bill_usage', 'bill_usage_cost', 'credits', 'fees', 'taxes')
    facility_id = sgqlc.types.Field(HavingIntFilter, graphql_name='facilityId')
    utility_account_id = sgqlc.types.Field(HavingIntFilter, graphql_name='utilityAccountId')
    utility_meter_id = sgqlc.types.Field(HavingIntFilter, graphql_name='utilityMeterId')
    meter_statement_id = sgqlc.types.Field(HavingIntFilter, graphql_name='meterStatementId')
    bill_arrival_date = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='billArrivalDate')
    start_date = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='startDate')
    end_date = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='endDate')
    statement_year = sgqlc.types.Field(HavingIntFilter, graphql_name='statementYear')
    statement_month = sgqlc.types.Field(HavingIntFilter, graphql_name='statementMonth')
    days_in_bill = sgqlc.types.Field(HavingIntFilter, graphql_name='daysInBill')
    account_statement_id = sgqlc.types.Field(HavingIntFilter, graphql_name='accountStatementId')
    bill_cost = sgqlc.types.Field('UtilityMeterStatementsHavingAverageUtilityMeterStatementsBillCostInput', graphql_name='billCost')
    bill_demand = sgqlc.types.Field('UtilityMeterStatementsHavingAverageUtilityMeterStatementsBillDemandInput', graphql_name='billDemand')
    bill_demand_cost = sgqlc.types.Field('UtilityMeterStatementsHavingAverageUtilityMeterStatementsBillDemandCostInput', graphql_name='billDemandCost')
    bill_usage = sgqlc.types.Field('UtilityMeterStatementsHavingAverageUtilityMeterStatementsBillUsageInput', graphql_name='billUsage')
    bill_usage_cost = sgqlc.types.Field('UtilityMeterStatementsHavingAverageUtilityMeterStatementsBillUsageCostInput', graphql_name='billUsageCost')
    credits = sgqlc.types.Field('UtilityMeterStatementsHavingAverageUtilityMeterStatementsCreditsInput', graphql_name='credits')
    fees = sgqlc.types.Field('UtilityMeterStatementsHavingAverageUtilityMeterStatementsFeesInput', graphql_name='fees')
    taxes = sgqlc.types.Field('UtilityMeterStatementsHavingAverageUtilityMeterStatementsTaxesInput', graphql_name='taxes')


class UtilityMeterStatementsHavingAverageUtilityMeterStatementsBillCostInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityMeterStatementsHavingAverageUtilityMeterStatementsBillDemandCostInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityMeterStatementsHavingAverageUtilityMeterStatementsBillDemandInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityMeterStatementsHavingAverageUtilityMeterStatementsBillUsageCostInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityMeterStatementsHavingAverageUtilityMeterStatementsBillUsageInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityMeterStatementsHavingAverageUtilityMeterStatementsCreditsInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityMeterStatementsHavingAverageUtilityMeterStatementsFeesInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityMeterStatementsHavingAverageUtilityMeterStatementsTaxesInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityMeterStatementsHavingDistinctCountInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('facility_id', 'utility_account_id', 'utility_meter_id', 'meter_statement_id', 'bill_arrival_date', 'start_date', 'end_date', 'statement_year', 'statement_month', 'days_in_bill', 'account_statement_id', 'bill_cost', 'bill_demand', 'bill_demand_cost', 'bill_usage', 'bill_usage_cost', 'credits', 'fees', 'taxes')
    facility_id = sgqlc.types.Field(HavingIntFilter, graphql_name='facilityId')
    utility_account_id = sgqlc.types.Field(HavingIntFilter, graphql_name='utilityAccountId')
    utility_meter_id = sgqlc.types.Field(HavingIntFilter, graphql_name='utilityMeterId')
    meter_statement_id = sgqlc.types.Field(HavingIntFilter, graphql_name='meterStatementId')
    bill_arrival_date = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='billArrivalDate')
    start_date = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='startDate')
    end_date = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='endDate')
    statement_year = sgqlc.types.Field(HavingIntFilter, graphql_name='statementYear')
    statement_month = sgqlc.types.Field(HavingIntFilter, graphql_name='statementMonth')
    days_in_bill = sgqlc.types.Field(HavingIntFilter, graphql_name='daysInBill')
    account_statement_id = sgqlc.types.Field(HavingIntFilter, graphql_name='accountStatementId')
    bill_cost = sgqlc.types.Field('UtilityMeterStatementsHavingDistinctCountUtilityMeterStatementsBillCostInput', graphql_name='billCost')
    bill_demand = sgqlc.types.Field('UtilityMeterStatementsHavingDistinctCountUtilityMeterStatementsBillDemandInput', graphql_name='billDemand')
    bill_demand_cost = sgqlc.types.Field('UtilityMeterStatementsHavingDistinctCountUtilityMeterStatementsBillDemandCostInput', graphql_name='billDemandCost')
    bill_usage = sgqlc.types.Field('UtilityMeterStatementsHavingDistinctCountUtilityMeterStatementsBillUsageInput', graphql_name='billUsage')
    bill_usage_cost = sgqlc.types.Field('UtilityMeterStatementsHavingDistinctCountUtilityMeterStatementsBillUsageCostInput', graphql_name='billUsageCost')
    credits = sgqlc.types.Field('UtilityMeterStatementsHavingDistinctCountUtilityMeterStatementsCreditsInput', graphql_name='credits')
    fees = sgqlc.types.Field('UtilityMeterStatementsHavingDistinctCountUtilityMeterStatementsFeesInput', graphql_name='fees')
    taxes = sgqlc.types.Field('UtilityMeterStatementsHavingDistinctCountUtilityMeterStatementsTaxesInput', graphql_name='taxes')


class UtilityMeterStatementsHavingDistinctCountUtilityMeterStatementsBillCostInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityMeterStatementsHavingDistinctCountUtilityMeterStatementsBillDemandCostInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityMeterStatementsHavingDistinctCountUtilityMeterStatementsBillDemandInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityMeterStatementsHavingDistinctCountUtilityMeterStatementsBillUsageCostInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityMeterStatementsHavingDistinctCountUtilityMeterStatementsBillUsageInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityMeterStatementsHavingDistinctCountUtilityMeterStatementsCreditsInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityMeterStatementsHavingDistinctCountUtilityMeterStatementsFeesInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityMeterStatementsHavingDistinctCountUtilityMeterStatementsTaxesInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityMeterStatementsHavingDistinctInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('facility_id', 'utility_account_id', 'utility_meter_id', 'meter_statement_id', 'bill_arrival_date', 'start_date', 'end_date', 'statement_year', 'statement_month', 'days_in_bill', 'account_statement_id', 'bill_cost', 'bill_demand', 'bill_demand_cost', 'bill_usage', 'bill_usage_cost', 'credits', 'fees', 'taxes')
    facility_id = sgqlc.types.Field(HavingIntFilter, graphql_name='facilityId')
    utility_account_id = sgqlc.types.Field(HavingIntFilter, graphql_name='utilityAccountId')
    utility_meter_id = sgqlc.types.Field(HavingIntFilter, graphql_name='utilityMeterId')
    meter_statement_id = sgqlc.types.Field(HavingIntFilter, graphql_name='meterStatementId')
    bill_arrival_date = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='billArrivalDate')
    start_date = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='startDate')
    end_date = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='endDate')
    statement_year = sgqlc.types.Field(HavingIntFilter, graphql_name='statementYear')
    statement_month = sgqlc.types.Field(HavingIntFilter, graphql_name='statementMonth')
    days_in_bill = sgqlc.types.Field(HavingIntFilter, graphql_name='daysInBill')
    account_statement_id = sgqlc.types.Field(HavingIntFilter, graphql_name='accountStatementId')
    bill_cost = sgqlc.types.Field('UtilityMeterStatementsHavingDistinctUtilityMeterStatementsBillCostInput', graphql_name='billCost')
    bill_demand = sgqlc.types.Field('UtilityMeterStatementsHavingDistinctUtilityMeterStatementsBillDemandInput', graphql_name='billDemand')
    bill_demand_cost = sgqlc.types.Field('UtilityMeterStatementsHavingDistinctUtilityMeterStatementsBillDemandCostInput', graphql_name='billDemandCost')
    bill_usage = sgqlc.types.Field('UtilityMeterStatementsHavingDistinctUtilityMeterStatementsBillUsageInput', graphql_name='billUsage')
    bill_usage_cost = sgqlc.types.Field('UtilityMeterStatementsHavingDistinctUtilityMeterStatementsBillUsageCostInput', graphql_name='billUsageCost')
    credits = sgqlc.types.Field('UtilityMeterStatementsHavingDistinctUtilityMeterStatementsCreditsInput', graphql_name='credits')
    fees = sgqlc.types.Field('UtilityMeterStatementsHavingDistinctUtilityMeterStatementsFeesInput', graphql_name='fees')
    taxes = sgqlc.types.Field('UtilityMeterStatementsHavingDistinctUtilityMeterStatementsTaxesInput', graphql_name='taxes')


class UtilityMeterStatementsHavingDistinctUtilityMeterStatementsBillCostInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityMeterStatementsHavingDistinctUtilityMeterStatementsBillDemandCostInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityMeterStatementsHavingDistinctUtilityMeterStatementsBillDemandInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityMeterStatementsHavingDistinctUtilityMeterStatementsBillUsageCostInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityMeterStatementsHavingDistinctUtilityMeterStatementsBillUsageInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityMeterStatementsHavingDistinctUtilityMeterStatementsCreditsInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityMeterStatementsHavingDistinctUtilityMeterStatementsFeesInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityMeterStatementsHavingDistinctUtilityMeterStatementsTaxesInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityMeterStatementsHavingInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('and_', 'or_', 'sum', 'distinct_count', 'min', 'max', 'average', 'stddev_sample', 'stddev_population', 'variance_sample', 'variance_population', 'distinct')
    and_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('UtilityMeterStatementsHavingInput')), graphql_name='AND')
    or_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('UtilityMeterStatementsHavingInput')), graphql_name='OR')
    sum = sgqlc.types.Field('UtilityMeterStatementsHavingSumInput', graphql_name='sum')
    distinct_count = sgqlc.types.Field(UtilityMeterStatementsHavingDistinctCountInput, graphql_name='distinctCount')
    min = sgqlc.types.Field('UtilityMeterStatementsHavingMinInput', graphql_name='min')
    max = sgqlc.types.Field('UtilityMeterStatementsHavingMaxInput', graphql_name='max')
    average = sgqlc.types.Field(UtilityMeterStatementsHavingAverageInput, graphql_name='average')
    stddev_sample = sgqlc.types.Field('UtilityMeterStatementsHavingStddevSampleInput', graphql_name='stddevSample')
    stddev_population = sgqlc.types.Field('UtilityMeterStatementsHavingStddevPopulationInput', graphql_name='stddevPopulation')
    variance_sample = sgqlc.types.Field('UtilityMeterStatementsHavingVarianceSampleInput', graphql_name='varianceSample')
    variance_population = sgqlc.types.Field('UtilityMeterStatementsHavingVariancePopulationInput', graphql_name='variancePopulation')
    distinct = sgqlc.types.Field(UtilityMeterStatementsHavingDistinctInput, graphql_name='distinct')


class UtilityMeterStatementsHavingMaxInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('facility_id', 'utility_account_id', 'utility_meter_id', 'meter_statement_id', 'bill_arrival_date', 'start_date', 'end_date', 'statement_year', 'statement_month', 'days_in_bill', 'account_statement_id', 'bill_cost', 'bill_demand', 'bill_demand_cost', 'bill_usage', 'bill_usage_cost', 'credits', 'fees', 'taxes')
    facility_id = sgqlc.types.Field(HavingIntFilter, graphql_name='facilityId')
    utility_account_id = sgqlc.types.Field(HavingIntFilter, graphql_name='utilityAccountId')
    utility_meter_id = sgqlc.types.Field(HavingIntFilter, graphql_name='utilityMeterId')
    meter_statement_id = sgqlc.types.Field(HavingIntFilter, graphql_name='meterStatementId')
    bill_arrival_date = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='billArrivalDate')
    start_date = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='startDate')
    end_date = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='endDate')
    statement_year = sgqlc.types.Field(HavingIntFilter, graphql_name='statementYear')
    statement_month = sgqlc.types.Field(HavingIntFilter, graphql_name='statementMonth')
    days_in_bill = sgqlc.types.Field(HavingIntFilter, graphql_name='daysInBill')
    account_statement_id = sgqlc.types.Field(HavingIntFilter, graphql_name='accountStatementId')
    bill_cost = sgqlc.types.Field('UtilityMeterStatementsHavingMaxUtilityMeterStatementsBillCostInput', graphql_name='billCost')
    bill_demand = sgqlc.types.Field('UtilityMeterStatementsHavingMaxUtilityMeterStatementsBillDemandInput', graphql_name='billDemand')
    bill_demand_cost = sgqlc.types.Field('UtilityMeterStatementsHavingMaxUtilityMeterStatementsBillDemandCostInput', graphql_name='billDemandCost')
    bill_usage = sgqlc.types.Field('UtilityMeterStatementsHavingMaxUtilityMeterStatementsBillUsageInput', graphql_name='billUsage')
    bill_usage_cost = sgqlc.types.Field('UtilityMeterStatementsHavingMaxUtilityMeterStatementsBillUsageCostInput', graphql_name='billUsageCost')
    credits = sgqlc.types.Field('UtilityMeterStatementsHavingMaxUtilityMeterStatementsCreditsInput', graphql_name='credits')
    fees = sgqlc.types.Field('UtilityMeterStatementsHavingMaxUtilityMeterStatementsFeesInput', graphql_name='fees')
    taxes = sgqlc.types.Field('UtilityMeterStatementsHavingMaxUtilityMeterStatementsTaxesInput', graphql_name='taxes')


class UtilityMeterStatementsHavingMaxUtilityMeterStatementsBillCostInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityMeterStatementsHavingMaxUtilityMeterStatementsBillDemandCostInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityMeterStatementsHavingMaxUtilityMeterStatementsBillDemandInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityMeterStatementsHavingMaxUtilityMeterStatementsBillUsageCostInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityMeterStatementsHavingMaxUtilityMeterStatementsBillUsageInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityMeterStatementsHavingMaxUtilityMeterStatementsCreditsInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityMeterStatementsHavingMaxUtilityMeterStatementsFeesInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityMeterStatementsHavingMaxUtilityMeterStatementsTaxesInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityMeterStatementsHavingMinInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('facility_id', 'utility_account_id', 'utility_meter_id', 'meter_statement_id', 'bill_arrival_date', 'start_date', 'end_date', 'statement_year', 'statement_month', 'days_in_bill', 'account_statement_id', 'bill_cost', 'bill_demand', 'bill_demand_cost', 'bill_usage', 'bill_usage_cost', 'credits', 'fees', 'taxes')
    facility_id = sgqlc.types.Field(HavingIntFilter, graphql_name='facilityId')
    utility_account_id = sgqlc.types.Field(HavingIntFilter, graphql_name='utilityAccountId')
    utility_meter_id = sgqlc.types.Field(HavingIntFilter, graphql_name='utilityMeterId')
    meter_statement_id = sgqlc.types.Field(HavingIntFilter, graphql_name='meterStatementId')
    bill_arrival_date = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='billArrivalDate')
    start_date = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='startDate')
    end_date = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='endDate')
    statement_year = sgqlc.types.Field(HavingIntFilter, graphql_name='statementYear')
    statement_month = sgqlc.types.Field(HavingIntFilter, graphql_name='statementMonth')
    days_in_bill = sgqlc.types.Field(HavingIntFilter, graphql_name='daysInBill')
    account_statement_id = sgqlc.types.Field(HavingIntFilter, graphql_name='accountStatementId')
    bill_cost = sgqlc.types.Field('UtilityMeterStatementsHavingMinUtilityMeterStatementsBillCostInput', graphql_name='billCost')
    bill_demand = sgqlc.types.Field('UtilityMeterStatementsHavingMinUtilityMeterStatementsBillDemandInput', graphql_name='billDemand')
    bill_demand_cost = sgqlc.types.Field('UtilityMeterStatementsHavingMinUtilityMeterStatementsBillDemandCostInput', graphql_name='billDemandCost')
    bill_usage = sgqlc.types.Field('UtilityMeterStatementsHavingMinUtilityMeterStatementsBillUsageInput', graphql_name='billUsage')
    bill_usage_cost = sgqlc.types.Field('UtilityMeterStatementsHavingMinUtilityMeterStatementsBillUsageCostInput', graphql_name='billUsageCost')
    credits = sgqlc.types.Field('UtilityMeterStatementsHavingMinUtilityMeterStatementsCreditsInput', graphql_name='credits')
    fees = sgqlc.types.Field('UtilityMeterStatementsHavingMinUtilityMeterStatementsFeesInput', graphql_name='fees')
    taxes = sgqlc.types.Field('UtilityMeterStatementsHavingMinUtilityMeterStatementsTaxesInput', graphql_name='taxes')


class UtilityMeterStatementsHavingMinUtilityMeterStatementsBillCostInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityMeterStatementsHavingMinUtilityMeterStatementsBillDemandCostInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityMeterStatementsHavingMinUtilityMeterStatementsBillDemandInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityMeterStatementsHavingMinUtilityMeterStatementsBillUsageCostInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityMeterStatementsHavingMinUtilityMeterStatementsBillUsageInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityMeterStatementsHavingMinUtilityMeterStatementsCreditsInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityMeterStatementsHavingMinUtilityMeterStatementsFeesInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityMeterStatementsHavingMinUtilityMeterStatementsTaxesInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityMeterStatementsHavingStddevPopulationInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('facility_id', 'utility_account_id', 'utility_meter_id', 'meter_statement_id', 'bill_arrival_date', 'start_date', 'end_date', 'statement_year', 'statement_month', 'days_in_bill', 'account_statement_id', 'bill_cost', 'bill_demand', 'bill_demand_cost', 'bill_usage', 'bill_usage_cost', 'credits', 'fees', 'taxes')
    facility_id = sgqlc.types.Field(HavingIntFilter, graphql_name='facilityId')
    utility_account_id = sgqlc.types.Field(HavingIntFilter, graphql_name='utilityAccountId')
    utility_meter_id = sgqlc.types.Field(HavingIntFilter, graphql_name='utilityMeterId')
    meter_statement_id = sgqlc.types.Field(HavingIntFilter, graphql_name='meterStatementId')
    bill_arrival_date = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='billArrivalDate')
    start_date = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='startDate')
    end_date = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='endDate')
    statement_year = sgqlc.types.Field(HavingIntFilter, graphql_name='statementYear')
    statement_month = sgqlc.types.Field(HavingIntFilter, graphql_name='statementMonth')
    days_in_bill = sgqlc.types.Field(HavingIntFilter, graphql_name='daysInBill')
    account_statement_id = sgqlc.types.Field(HavingIntFilter, graphql_name='accountStatementId')
    bill_cost = sgqlc.types.Field('UtilityMeterStatementsHavingStddevPopulationUtilityMeterStatementsBillCostInput', graphql_name='billCost')
    bill_demand = sgqlc.types.Field('UtilityMeterStatementsHavingStddevPopulationUtilityMeterStatementsBillDemandInput', graphql_name='billDemand')
    bill_demand_cost = sgqlc.types.Field('UtilityMeterStatementsHavingStddevPopulationUtilityMeterStatementsBillDemandCostInput', graphql_name='billDemandCost')
    bill_usage = sgqlc.types.Field('UtilityMeterStatementsHavingStddevPopulationUtilityMeterStatementsBillUsageInput', graphql_name='billUsage')
    bill_usage_cost = sgqlc.types.Field('UtilityMeterStatementsHavingStddevPopulationUtilityMeterStatementsBillUsageCostInput', graphql_name='billUsageCost')
    credits = sgqlc.types.Field('UtilityMeterStatementsHavingStddevPopulationUtilityMeterStatementsCreditsInput', graphql_name='credits')
    fees = sgqlc.types.Field('UtilityMeterStatementsHavingStddevPopulationUtilityMeterStatementsFeesInput', graphql_name='fees')
    taxes = sgqlc.types.Field('UtilityMeterStatementsHavingStddevPopulationUtilityMeterStatementsTaxesInput', graphql_name='taxes')


class UtilityMeterStatementsHavingStddevPopulationUtilityMeterStatementsBillCostInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityMeterStatementsHavingStddevPopulationUtilityMeterStatementsBillDemandCostInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityMeterStatementsHavingStddevPopulationUtilityMeterStatementsBillDemandInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityMeterStatementsHavingStddevPopulationUtilityMeterStatementsBillUsageCostInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityMeterStatementsHavingStddevPopulationUtilityMeterStatementsBillUsageInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityMeterStatementsHavingStddevPopulationUtilityMeterStatementsCreditsInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityMeterStatementsHavingStddevPopulationUtilityMeterStatementsFeesInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityMeterStatementsHavingStddevPopulationUtilityMeterStatementsTaxesInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityMeterStatementsHavingStddevSampleInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('facility_id', 'utility_account_id', 'utility_meter_id', 'meter_statement_id', 'bill_arrival_date', 'start_date', 'end_date', 'statement_year', 'statement_month', 'days_in_bill', 'account_statement_id', 'bill_cost', 'bill_demand', 'bill_demand_cost', 'bill_usage', 'bill_usage_cost', 'credits', 'fees', 'taxes')
    facility_id = sgqlc.types.Field(HavingIntFilter, graphql_name='facilityId')
    utility_account_id = sgqlc.types.Field(HavingIntFilter, graphql_name='utilityAccountId')
    utility_meter_id = sgqlc.types.Field(HavingIntFilter, graphql_name='utilityMeterId')
    meter_statement_id = sgqlc.types.Field(HavingIntFilter, graphql_name='meterStatementId')
    bill_arrival_date = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='billArrivalDate')
    start_date = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='startDate')
    end_date = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='endDate')
    statement_year = sgqlc.types.Field(HavingIntFilter, graphql_name='statementYear')
    statement_month = sgqlc.types.Field(HavingIntFilter, graphql_name='statementMonth')
    days_in_bill = sgqlc.types.Field(HavingIntFilter, graphql_name='daysInBill')
    account_statement_id = sgqlc.types.Field(HavingIntFilter, graphql_name='accountStatementId')
    bill_cost = sgqlc.types.Field('UtilityMeterStatementsHavingStddevSampleUtilityMeterStatementsBillCostInput', graphql_name='billCost')
    bill_demand = sgqlc.types.Field('UtilityMeterStatementsHavingStddevSampleUtilityMeterStatementsBillDemandInput', graphql_name='billDemand')
    bill_demand_cost = sgqlc.types.Field('UtilityMeterStatementsHavingStddevSampleUtilityMeterStatementsBillDemandCostInput', graphql_name='billDemandCost')
    bill_usage = sgqlc.types.Field('UtilityMeterStatementsHavingStddevSampleUtilityMeterStatementsBillUsageInput', graphql_name='billUsage')
    bill_usage_cost = sgqlc.types.Field('UtilityMeterStatementsHavingStddevSampleUtilityMeterStatementsBillUsageCostInput', graphql_name='billUsageCost')
    credits = sgqlc.types.Field('UtilityMeterStatementsHavingStddevSampleUtilityMeterStatementsCreditsInput', graphql_name='credits')
    fees = sgqlc.types.Field('UtilityMeterStatementsHavingStddevSampleUtilityMeterStatementsFeesInput', graphql_name='fees')
    taxes = sgqlc.types.Field('UtilityMeterStatementsHavingStddevSampleUtilityMeterStatementsTaxesInput', graphql_name='taxes')


class UtilityMeterStatementsHavingStddevSampleUtilityMeterStatementsBillCostInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityMeterStatementsHavingStddevSampleUtilityMeterStatementsBillDemandCostInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityMeterStatementsHavingStddevSampleUtilityMeterStatementsBillDemandInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityMeterStatementsHavingStddevSampleUtilityMeterStatementsBillUsageCostInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityMeterStatementsHavingStddevSampleUtilityMeterStatementsBillUsageInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityMeterStatementsHavingStddevSampleUtilityMeterStatementsCreditsInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityMeterStatementsHavingStddevSampleUtilityMeterStatementsFeesInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityMeterStatementsHavingStddevSampleUtilityMeterStatementsTaxesInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityMeterStatementsHavingSumInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('facility_id', 'utility_account_id', 'utility_meter_id', 'meter_statement_id', 'bill_arrival_date', 'start_date', 'end_date', 'statement_year', 'statement_month', 'days_in_bill', 'account_statement_id', 'bill_cost', 'bill_demand', 'bill_demand_cost', 'bill_usage', 'bill_usage_cost', 'credits', 'fees', 'taxes')
    facility_id = sgqlc.types.Field(HavingIntFilter, graphql_name='facilityId')
    utility_account_id = sgqlc.types.Field(HavingIntFilter, graphql_name='utilityAccountId')
    utility_meter_id = sgqlc.types.Field(HavingIntFilter, graphql_name='utilityMeterId')
    meter_statement_id = sgqlc.types.Field(HavingIntFilter, graphql_name='meterStatementId')
    bill_arrival_date = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='billArrivalDate')
    start_date = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='startDate')
    end_date = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='endDate')
    statement_year = sgqlc.types.Field(HavingIntFilter, graphql_name='statementYear')
    statement_month = sgqlc.types.Field(HavingIntFilter, graphql_name='statementMonth')
    days_in_bill = sgqlc.types.Field(HavingIntFilter, graphql_name='daysInBill')
    account_statement_id = sgqlc.types.Field(HavingIntFilter, graphql_name='accountStatementId')
    bill_cost = sgqlc.types.Field('UtilityMeterStatementsHavingSumUtilityMeterStatementsBillCostInput', graphql_name='billCost')
    bill_demand = sgqlc.types.Field('UtilityMeterStatementsHavingSumUtilityMeterStatementsBillDemandInput', graphql_name='billDemand')
    bill_demand_cost = sgqlc.types.Field('UtilityMeterStatementsHavingSumUtilityMeterStatementsBillDemandCostInput', graphql_name='billDemandCost')
    bill_usage = sgqlc.types.Field('UtilityMeterStatementsHavingSumUtilityMeterStatementsBillUsageInput', graphql_name='billUsage')
    bill_usage_cost = sgqlc.types.Field('UtilityMeterStatementsHavingSumUtilityMeterStatementsBillUsageCostInput', graphql_name='billUsageCost')
    credits = sgqlc.types.Field('UtilityMeterStatementsHavingSumUtilityMeterStatementsCreditsInput', graphql_name='credits')
    fees = sgqlc.types.Field('UtilityMeterStatementsHavingSumUtilityMeterStatementsFeesInput', graphql_name='fees')
    taxes = sgqlc.types.Field('UtilityMeterStatementsHavingSumUtilityMeterStatementsTaxesInput', graphql_name='taxes')


class UtilityMeterStatementsHavingSumUtilityMeterStatementsBillCostInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityMeterStatementsHavingSumUtilityMeterStatementsBillDemandCostInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityMeterStatementsHavingSumUtilityMeterStatementsBillDemandInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityMeterStatementsHavingSumUtilityMeterStatementsBillUsageCostInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityMeterStatementsHavingSumUtilityMeterStatementsBillUsageInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityMeterStatementsHavingSumUtilityMeterStatementsCreditsInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityMeterStatementsHavingSumUtilityMeterStatementsFeesInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityMeterStatementsHavingSumUtilityMeterStatementsTaxesInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityMeterStatementsHavingVariancePopulationInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('facility_id', 'utility_account_id', 'utility_meter_id', 'meter_statement_id', 'bill_arrival_date', 'start_date', 'end_date', 'statement_year', 'statement_month', 'days_in_bill', 'account_statement_id', 'bill_cost', 'bill_demand', 'bill_demand_cost', 'bill_usage', 'bill_usage_cost', 'credits', 'fees', 'taxes')
    facility_id = sgqlc.types.Field(HavingIntFilter, graphql_name='facilityId')
    utility_account_id = sgqlc.types.Field(HavingIntFilter, graphql_name='utilityAccountId')
    utility_meter_id = sgqlc.types.Field(HavingIntFilter, graphql_name='utilityMeterId')
    meter_statement_id = sgqlc.types.Field(HavingIntFilter, graphql_name='meterStatementId')
    bill_arrival_date = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='billArrivalDate')
    start_date = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='startDate')
    end_date = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='endDate')
    statement_year = sgqlc.types.Field(HavingIntFilter, graphql_name='statementYear')
    statement_month = sgqlc.types.Field(HavingIntFilter, graphql_name='statementMonth')
    days_in_bill = sgqlc.types.Field(HavingIntFilter, graphql_name='daysInBill')
    account_statement_id = sgqlc.types.Field(HavingIntFilter, graphql_name='accountStatementId')
    bill_cost = sgqlc.types.Field('UtilityMeterStatementsHavingVariancePopulationUtilityMeterStatementsBillCostInput', graphql_name='billCost')
    bill_demand = sgqlc.types.Field('UtilityMeterStatementsHavingVariancePopulationUtilityMeterStatementsBillDemandInput', graphql_name='billDemand')
    bill_demand_cost = sgqlc.types.Field('UtilityMeterStatementsHavingVariancePopulationUtilityMeterStatementsBillDemandCostInput', graphql_name='billDemandCost')
    bill_usage = sgqlc.types.Field('UtilityMeterStatementsHavingVariancePopulationUtilityMeterStatementsBillUsageInput', graphql_name='billUsage')
    bill_usage_cost = sgqlc.types.Field('UtilityMeterStatementsHavingVariancePopulationUtilityMeterStatementsBillUsageCostInput', graphql_name='billUsageCost')
    credits = sgqlc.types.Field('UtilityMeterStatementsHavingVariancePopulationUtilityMeterStatementsCreditsInput', graphql_name='credits')
    fees = sgqlc.types.Field('UtilityMeterStatementsHavingVariancePopulationUtilityMeterStatementsFeesInput', graphql_name='fees')
    taxes = sgqlc.types.Field('UtilityMeterStatementsHavingVariancePopulationUtilityMeterStatementsTaxesInput', graphql_name='taxes')


class UtilityMeterStatementsHavingVariancePopulationUtilityMeterStatementsBillCostInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityMeterStatementsHavingVariancePopulationUtilityMeterStatementsBillDemandCostInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityMeterStatementsHavingVariancePopulationUtilityMeterStatementsBillDemandInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityMeterStatementsHavingVariancePopulationUtilityMeterStatementsBillUsageCostInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityMeterStatementsHavingVariancePopulationUtilityMeterStatementsBillUsageInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityMeterStatementsHavingVariancePopulationUtilityMeterStatementsCreditsInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityMeterStatementsHavingVariancePopulationUtilityMeterStatementsFeesInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityMeterStatementsHavingVariancePopulationUtilityMeterStatementsTaxesInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityMeterStatementsHavingVarianceSampleInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('facility_id', 'utility_account_id', 'utility_meter_id', 'meter_statement_id', 'bill_arrival_date', 'start_date', 'end_date', 'statement_year', 'statement_month', 'days_in_bill', 'account_statement_id', 'bill_cost', 'bill_demand', 'bill_demand_cost', 'bill_usage', 'bill_usage_cost', 'credits', 'fees', 'taxes')
    facility_id = sgqlc.types.Field(HavingIntFilter, graphql_name='facilityId')
    utility_account_id = sgqlc.types.Field(HavingIntFilter, graphql_name='utilityAccountId')
    utility_meter_id = sgqlc.types.Field(HavingIntFilter, graphql_name='utilityMeterId')
    meter_statement_id = sgqlc.types.Field(HavingIntFilter, graphql_name='meterStatementId')
    bill_arrival_date = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='billArrivalDate')
    start_date = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='startDate')
    end_date = sgqlc.types.Field(HavingDatetimeFilter, graphql_name='endDate')
    statement_year = sgqlc.types.Field(HavingIntFilter, graphql_name='statementYear')
    statement_month = sgqlc.types.Field(HavingIntFilter, graphql_name='statementMonth')
    days_in_bill = sgqlc.types.Field(HavingIntFilter, graphql_name='daysInBill')
    account_statement_id = sgqlc.types.Field(HavingIntFilter, graphql_name='accountStatementId')
    bill_cost = sgqlc.types.Field('UtilityMeterStatementsHavingVarianceSampleUtilityMeterStatementsBillCostInput', graphql_name='billCost')
    bill_demand = sgqlc.types.Field('UtilityMeterStatementsHavingVarianceSampleUtilityMeterStatementsBillDemandInput', graphql_name='billDemand')
    bill_demand_cost = sgqlc.types.Field('UtilityMeterStatementsHavingVarianceSampleUtilityMeterStatementsBillDemandCostInput', graphql_name='billDemandCost')
    bill_usage = sgqlc.types.Field('UtilityMeterStatementsHavingVarianceSampleUtilityMeterStatementsBillUsageInput', graphql_name='billUsage')
    bill_usage_cost = sgqlc.types.Field('UtilityMeterStatementsHavingVarianceSampleUtilityMeterStatementsBillUsageCostInput', graphql_name='billUsageCost')
    credits = sgqlc.types.Field('UtilityMeterStatementsHavingVarianceSampleUtilityMeterStatementsCreditsInput', graphql_name='credits')
    fees = sgqlc.types.Field('UtilityMeterStatementsHavingVarianceSampleUtilityMeterStatementsFeesInput', graphql_name='fees')
    taxes = sgqlc.types.Field('UtilityMeterStatementsHavingVarianceSampleUtilityMeterStatementsTaxesInput', graphql_name='taxes')


class UtilityMeterStatementsHavingVarianceSampleUtilityMeterStatementsBillCostInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityMeterStatementsHavingVarianceSampleUtilityMeterStatementsBillDemandCostInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityMeterStatementsHavingVarianceSampleUtilityMeterStatementsBillDemandInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityMeterStatementsHavingVarianceSampleUtilityMeterStatementsBillUsageCostInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityMeterStatementsHavingVarianceSampleUtilityMeterStatementsBillUsageInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityMeterStatementsHavingVarianceSampleUtilityMeterStatementsCreditsInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityMeterStatementsHavingVarianceSampleUtilityMeterStatementsFeesInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityMeterStatementsHavingVarianceSampleUtilityMeterStatementsTaxesInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('filter',)
    filter = sgqlc.types.Field(HavingFloatFilter, graphql_name='filter')


class UtilityMeterUsageCategoryFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('is_null', 'equal_to', 'not_equal_to', 'distinct_from', 'not_distinct_from', 'in_', 'not_in', 'less_than', 'less_than_or_equal_to', 'greater_than', 'greater_than_or_equal_to')
    is_null = sgqlc.types.Field(Boolean, graphql_name='isNull')
    equal_to = sgqlc.types.Field(UtilityMeterUsageCategory, graphql_name='equalTo')
    not_equal_to = sgqlc.types.Field(UtilityMeterUsageCategory, graphql_name='notEqualTo')
    distinct_from = sgqlc.types.Field(UtilityMeterUsageCategory, graphql_name='distinctFrom')
    not_distinct_from = sgqlc.types.Field(UtilityMeterUsageCategory, graphql_name='notDistinctFrom')
    in_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(UtilityMeterUsageCategory)), graphql_name='in')
    not_in = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(UtilityMeterUsageCategory)), graphql_name='notIn')
    less_than = sgqlc.types.Field(UtilityMeterUsageCategory, graphql_name='lessThan')
    less_than_or_equal_to = sgqlc.types.Field(UtilityMeterUsageCategory, graphql_name='lessThanOrEqualTo')
    greater_than = sgqlc.types.Field(UtilityMeterUsageCategory, graphql_name='greaterThan')
    greater_than_or_equal_to = sgqlc.types.Field(UtilityMeterUsageCategory, graphql_name='greaterThanOrEqualTo')


class UtilityMetersMissingStatementsRecordFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('statement_date', 'statement_year', 'statement_month', 'utility_meter_id', 'facility_id', 'and_', 'or_', 'not_')
    statement_date = sgqlc.types.Field(DateFilter, graphql_name='statementDate')
    statement_year = sgqlc.types.Field(IntFilter, graphql_name='statementYear')
    statement_month = sgqlc.types.Field(IntFilter, graphql_name='statementMonth')
    utility_meter_id = sgqlc.types.Field(IntFilter, graphql_name='utilityMeterId')
    facility_id = sgqlc.types.Field(IntFilter, graphql_name='facilityId')
    and_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('UtilityMetersMissingStatementsRecordFilter')), graphql_name='and')
    or_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('UtilityMetersMissingStatementsRecordFilter')), graphql_name='or')
    not_ = sgqlc.types.Field('UtilityMetersMissingStatementsRecordFilter', graphql_name='not')


class UtilityProviderCondition(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'name', 'created_at', 'updated_at')
    id = sgqlc.types.Field(Int, graphql_name='id')
    name = sgqlc.types.Field(String, graphql_name='name')
    created_at = sgqlc.types.Field(Datetime, graphql_name='createdAt')
    updated_at = sgqlc.types.Field(Datetime, graphql_name='updatedAt')


class UtilityProviderFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'name', 'created_at', 'updated_at', 'and_', 'or_', 'not_')
    id = sgqlc.types.Field(IntFilter, graphql_name='id')
    name = sgqlc.types.Field(StringFilter, graphql_name='name')
    created_at = sgqlc.types.Field(DatetimeFilter, graphql_name='createdAt')
    updated_at = sgqlc.types.Field(DatetimeFilter, graphql_name='updatedAt')
    and_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('UtilityProviderFilter')), graphql_name='and')
    or_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('UtilityProviderFilter')), graphql_name='or')
    not_ = sgqlc.types.Field('UtilityProviderFilter', graphql_name='not')


class UtilityProviderInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'name')
    id = sgqlc.types.Field(Int, graphql_name='id')
    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='name')


class UtilityProviderPatch(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('name',)
    name = sgqlc.types.Field(String, graphql_name='name')


class VendorUserCondition(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'email', 'first_name', 'last_name', 'company', 'created_at', 'updated_at')
    id = sgqlc.types.Field(Int, graphql_name='id')
    email = sgqlc.types.Field(String, graphql_name='email')
    first_name = sgqlc.types.Field(String, graphql_name='firstName')
    last_name = sgqlc.types.Field(String, graphql_name='lastName')
    company = sgqlc.types.Field(String, graphql_name='company')
    created_at = sgqlc.types.Field(Datetime, graphql_name='createdAt')
    updated_at = sgqlc.types.Field(Datetime, graphql_name='updatedAt')


class VendorUserFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('can_write', 'id', 'email', 'first_name', 'last_name', 'company', 'created_at', 'updated_at', 'and_', 'or_', 'not_')
    can_write = sgqlc.types.Field(PermissionBooleanFilter, graphql_name='canWrite')
    id = sgqlc.types.Field(IntFilter, graphql_name='id')
    email = sgqlc.types.Field(StringFilter, graphql_name='email')
    first_name = sgqlc.types.Field(StringFilter, graphql_name='firstName')
    last_name = sgqlc.types.Field(StringFilter, graphql_name='lastName')
    company = sgqlc.types.Field(StringFilter, graphql_name='company')
    created_at = sgqlc.types.Field(DatetimeFilter, graphql_name='createdAt')
    updated_at = sgqlc.types.Field(DatetimeFilter, graphql_name='updatedAt')
    and_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('VendorUserFilter')), graphql_name='and')
    or_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('VendorUserFilter')), graphql_name='or')
    not_ = sgqlc.types.Field('VendorUserFilter', graphql_name='not')


class VendorUserInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('email', 'first_name', 'last_name', 'company')
    email = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='email')
    first_name = sgqlc.types.Field(String, graphql_name='firstName')
    last_name = sgqlc.types.Field(String, graphql_name='lastName')
    company = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='company')


class VendorUserMachineUserInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('vendor_user_id', 'machine_user_id')
    vendor_user_id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='vendorUserId')
    machine_user_id = sgqlc.types.Field(sgqlc.types.non_null(BigInt), graphql_name='machineUserId')


class VendorUserMachineUserPatch(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('vendor_user_id', 'machine_user_id')
    vendor_user_id = sgqlc.types.Field(Int, graphql_name='vendorUserId')
    machine_user_id = sgqlc.types.Field(BigInt, graphql_name='machineUserId')


class VendorUserPatch(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('email', 'first_name', 'last_name', 'company')
    email = sgqlc.types.Field(String, graphql_name='email')
    first_name = sgqlc.types.Field(String, graphql_name='firstName')
    last_name = sgqlc.types.Field(String, graphql_name='lastName')
    company = sgqlc.types.Field(String, graphql_name='company')


class VerifyPhoneNumberInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('phone_number', 'client_mutation_id')
    phone_number = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='phoneNumber')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')


class VirtualPointIntervalCondition(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('parent_id', 'child_id', 'start_time', 'end_time')
    parent_id = sgqlc.types.Field(BigInt, graphql_name='parentId')
    child_id = sgqlc.types.Field(BigInt, graphql_name='childId')
    start_time = sgqlc.types.Field(Datetime, graphql_name='startTime')
    end_time = sgqlc.types.Field(Datetime, graphql_name='endTime')


class VirtualPointIntervalFilter(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('parent_id', 'child_id', 'start_time', 'end_time', 'and_', 'or_', 'not_')
    parent_id = sgqlc.types.Field(BigIntFilter, graphql_name='parentId')
    child_id = sgqlc.types.Field(BigIntFilter, graphql_name='childId')
    start_time = sgqlc.types.Field(DatetimeFilter, graphql_name='startTime')
    end_time = sgqlc.types.Field(DatetimeFilter, graphql_name='endTime')
    and_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('VirtualPointIntervalFilter')), graphql_name='and')
    or_ = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('VirtualPointIntervalFilter')), graphql_name='or')
    not_ = sgqlc.types.Field('VirtualPointIntervalFilter', graphql_name='not')


class VirtualPointIntervalInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('parent_id', 'child_id', 'start_time', 'end_time', 'data_point')
    parent_id = sgqlc.types.Field(BigInt, graphql_name='parentId')
    child_id = sgqlc.types.Field(BigInt, graphql_name='childId')
    start_time = sgqlc.types.Field(sgqlc.types.non_null(Datetime), graphql_name='startTime')
    end_time = sgqlc.types.Field(Datetime, graphql_name='endTime')
    data_point = sgqlc.types.Field(DataPointInput, graphql_name='dataPoint')


class VirtualPointIntervalPatch(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('parent_id', 'child_id', 'start_time', 'end_time')
    parent_id = sgqlc.types.Field(BigInt, graphql_name='parentId')
    child_id = sgqlc.types.Field(BigInt, graphql_name='childId')
    start_time = sgqlc.types.Field(Datetime, graphql_name='startTime')
    end_time = sgqlc.types.Field(Datetime, graphql_name='endTime')


class WithdrawSuggestionInput(sgqlc.types.Input):
    __schema__ = nionic_schema
    __field_names__ = ('id',)
    id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='id')



########################################################################
# Output Objects and Interfaces
########################################################################
class Asset(sgqlc.types.Interface):
    __schema__ = nionic_schema
    __field_names__ = ('node_id',)
    node_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name='nodeId')


class CreateAccessTokenPayload(sgqlc.types.Interface):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'access_key', 'token')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    access_key = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='accessKey')
    token = sgqlc.types.Field(sgqlc.types.non_null('PlatformAccessToken'), graphql_name='token')


class GeometryGeometry(sgqlc.types.Interface):
    __schema__ = nionic_schema
    __field_names__ = ('geojson', 'srid')
    geojson = sgqlc.types.Field(GeoJSON, graphql_name='geojson')
    srid = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='srid')


class GeometryGeometryM(sgqlc.types.Interface):
    __schema__ = nionic_schema
    __field_names__ = ('geojson', 'srid')
    geojson = sgqlc.types.Field(GeoJSON, graphql_name='geojson')
    srid = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='srid')


class GeometryGeometryZ(sgqlc.types.Interface):
    __schema__ = nionic_schema
    __field_names__ = ('geojson', 'srid')
    geojson = sgqlc.types.Field(GeoJSON, graphql_name='geojson')
    srid = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='srid')


class GeometryGeometryZM(sgqlc.types.Interface):
    __schema__ = nionic_schema
    __field_names__ = ('geojson', 'srid')
    geojson = sgqlc.types.Field(GeoJSON, graphql_name='geojson')
    srid = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='srid')


class GeometryInterface(sgqlc.types.Interface):
    __schema__ = nionic_schema
    __field_names__ = ('geojson', 'srid')
    geojson = sgqlc.types.Field(GeoJSON, graphql_name='geojson')
    srid = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='srid')


class Identity(sgqlc.types.Interface):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'type', 'authorization_type')
    id = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='id')
    type = sgqlc.types.Field(sgqlc.types.non_null(AccessTokenType), graphql_name='type')
    authorization_type = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='authorizationType')


class Node(sgqlc.types.Interface):
    __schema__ = nionic_schema
    __field_names__ = ('node_id',)
    node_id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name='nodeId')


class AccountChargesConnection(sgqlc.types.relay.Connection):
    __schema__ = nionic_schema
    __field_names__ = ('nodes', 'edges', 'page_info', 'total_count')
    nodes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null('AccountCharge'))), graphql_name='nodes')
    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null('AccountChargesEdge'))), graphql_name='edges')
    page_info = sgqlc.types.Field(sgqlc.types.non_null('PageInfo'), graphql_name='pageInfo')
    total_count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='totalCount')


class AccountChargesEdge(sgqlc.types.Type):
    __schema__ = nionic_schema
    __field_names__ = ('cursor', 'node')
    cursor = sgqlc.types.Field(Cursor, graphql_name='cursor')
    node = sgqlc.types.Field(sgqlc.types.non_null('AccountCharge'), graphql_name='node')


class AccountMissingStatement(sgqlc.types.Type):
    __schema__ = nionic_schema
    __field_names__ = ('utility_account_id', 'statement_date', 'statement_year', 'statement_month', 'metadata', 'utility_meters')
    utility_account_id = sgqlc.types.Field(Int, graphql_name='utilityAccountId')
    statement_date = sgqlc.types.Field(Date, graphql_name='statementDate')
    statement_year = sgqlc.types.Field(Int, graphql_name='statementYear')
    statement_month = sgqlc.types.Field(Int, graphql_name='statementMonth')
    metadata = sgqlc.types.Field(sgqlc.types.list_of(JSON), graphql_name='metadata')
    utility_meters = sgqlc.types.Field(sgqlc.types.non_null('UtilityMetersConnection'), graphql_name='utilityMeters', args=sgqlc.types.ArgDict((
        ('facility_id', sgqlc.types.Arg(Int, graphql_name='facilityId', default=None)),
        ('first', sgqlc.types.Arg(Int, graphql_name='first', default=None)),
        ('last', sgqlc.types.Arg(Int, graphql_name='last', default=None)),
        ('offset', sgqlc.types.Arg(Int, graphql_name='offset', default=None)),
        ('before', sgqlc.types.Arg(Cursor, graphql_name='before', default=None)),
        ('after', sgqlc.types.Arg(Cursor, graphql_name='after', default=None)),
        ('filter', sgqlc.types.Arg(UtilityMeterFilter, graphql_name='filter', default=None)),
))
    )


class AccountMissingStatementsConnection(sgqlc.types.relay.Connection):
    __schema__ = nionic_schema
    __field_names__ = ('nodes', 'edges', 'page_info', 'total_count')
    nodes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(AccountMissingStatement))), graphql_name='nodes')
    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null('AccountMissingStatementsEdge'))), graphql_name='edges')
    page_info = sgqlc.types.Field(sgqlc.types.non_null('PageInfo'), graphql_name='pageInfo')
    total_count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='totalCount')


class AccountMissingStatementsEdge(sgqlc.types.Type):
    __schema__ = nionic_schema
    __field_names__ = ('cursor', 'node')
    cursor = sgqlc.types.Field(Cursor, graphql_name='cursor')
    node = sgqlc.types.Field(sgqlc.types.non_null(AccountMissingStatement), graphql_name='node')


class AccountStatementHistoriesConnection(sgqlc.types.relay.Connection):
    __schema__ = nionic_schema
    __field_names__ = ('nodes', 'edges', 'page_info', 'total_count')
    nodes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null('AccountStatementHistory'))), graphql_name='nodes')
    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null('AccountStatementHistoriesEdge'))), graphql_name='edges')
    page_info = sgqlc.types.Field(sgqlc.types.non_null('PageInfo'), graphql_name='pageInfo')
    total_count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='totalCount')


class AccountStatementHistoriesEdge(sgqlc.types.Type):
    __schema__ = nionic_schema
    __field_names__ = ('cursor', 'node')
    cursor = sgqlc.types.Field(Cursor, graphql_name='cursor')
    node = sgqlc.types.Field(sgqlc.types.non_null('AccountStatementHistory'), graphql_name='node')


class AccountStatementHistory(sgqlc.types.Type):
    __schema__ = nionic_schema
    __field_names__ = ('account_statement_id', 'description', 'created_at', 'account_statement')
    account_statement_id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='accountStatementId')
    description = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='description')
    created_at = sgqlc.types.Field(sgqlc.types.non_null(Datetime), graphql_name='createdAt')
    account_statement = sgqlc.types.Field('AccountStatement', graphql_name='accountStatement')


class AccountStatementPdfsConnection(sgqlc.types.relay.Connection):
    __schema__ = nionic_schema
    __field_names__ = ('nodes', 'edges', 'page_info', 'total_count')
    nodes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null('AccountStatementPdf'))), graphql_name='nodes')
    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null('AccountStatementPdfsEdge'))), graphql_name='edges')
    page_info = sgqlc.types.Field(sgqlc.types.non_null('PageInfo'), graphql_name='pageInfo')
    total_count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='totalCount')


class AccountStatementPdfsEdge(sgqlc.types.Type):
    __schema__ = nionic_schema
    __field_names__ = ('cursor', 'node')
    cursor = sgqlc.types.Field(Cursor, graphql_name='cursor')
    node = sgqlc.types.Field(sgqlc.types.non_null('AccountStatementPdf'), graphql_name='node')


class AccountStatementsConnection(sgqlc.types.relay.Connection):
    __schema__ = nionic_schema
    __field_names__ = ('nodes', 'edges', 'page_info', 'total_count')
    nodes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null('AccountStatement'))), graphql_name='nodes')
    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null('AccountStatementsEdge'))), graphql_name='edges')
    page_info = sgqlc.types.Field(sgqlc.types.non_null('PageInfo'), graphql_name='pageInfo')
    total_count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='totalCount')


class AccountStatementsEdge(sgqlc.types.Type):
    __schema__ = nionic_schema
    __field_names__ = ('cursor', 'node')
    cursor = sgqlc.types.Field(Cursor, graphql_name='cursor')
    node = sgqlc.types.Field(sgqlc.types.non_null('AccountStatement'), graphql_name='node')


class Actor(sgqlc.types.Type):
    __schema__ = nionic_schema
    __field_names__ = ('type', 'display_name', 'id', 'machine_user', 'user')
    type = sgqlc.types.Field(AccessTokenType, graphql_name='type')
    display_name = sgqlc.types.Field(String, graphql_name='displayName')
    id = sgqlc.types.Field(String, graphql_name='id')
    machine_user = sgqlc.types.Field('MachineUser', graphql_name='machineUser')
    user = sgqlc.types.Field('User', graphql_name='user')


class AddFavoriteFacilityPayload(sgqlc.types.Type):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'user', 'query', 'user_edge')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    user = sgqlc.types.Field('User', graphql_name='user')
    query = sgqlc.types.Field('Query', graphql_name='query')
    user_edge = sgqlc.types.Field('UsersEdge', graphql_name='userEdge', args=sgqlc.types.ArgDict((
        ('order_by', sgqlc.types.Arg(sgqlc.types.list_of(sgqlc.types.non_null(UsersOrderBy)), graphql_name='orderBy', default=('PRIMARY_KEY_ASC',))),
))
    )


class AddMetricMetadataDependencyPayload(sgqlc.types.Type):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'metric_metadata', 'query')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    metric_metadata = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('MetricMetadatum')), graphql_name='metricMetadata')
    query = sgqlc.types.Field('Query', graphql_name='query')


class AddProjectControllerPayload(sgqlc.types.Type):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'project', 'user')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    project = sgqlc.types.Field(sgqlc.types.non_null('Project'), graphql_name='project')
    user = sgqlc.types.Field(sgqlc.types.non_null('User'), graphql_name='user')


class AddReportManagerPayload(sgqlc.types.Type):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'report', 'user')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    report = sgqlc.types.Field(sgqlc.types.non_null('Report'), graphql_name='report')
    user = sgqlc.types.Field(sgqlc.types.non_null('User'), graphql_name='user')


class BalancingAuthoritiesConnection(sgqlc.types.relay.Connection):
    __schema__ = nionic_schema
    __field_names__ = ('nodes', 'edges', 'page_info', 'total_count', 'grid_demand')
    nodes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null('BalancingAuthority'))), graphql_name='nodes')
    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null('BalancingAuthoritiesEdge'))), graphql_name='edges')
    page_info = sgqlc.types.Field(sgqlc.types.non_null('PageInfo'), graphql_name='pageInfo')
    total_count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='totalCount')
    grid_demand = sgqlc.types.Field('MetricDataConnection', graphql_name='gridDemand', args=sgqlc.types.ArgDict((
        ('from_', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='from', default=None)),
        ('to', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='to', default=None)),
        ('aggregation', sgqlc.types.Arg(sgqlc.types.non_null(MetricDataAggregationMethod), graphql_name='aggregation', default='AVG')),
        ('window', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='window', default='1 hour')),
        ('sampling_window', sgqlc.types.Arg(String, graphql_name='samplingWindow', default=None)),
        ('after', sgqlc.types.Arg(Cursor, graphql_name='after', default=None)),
        ('before', sgqlc.types.Arg(Cursor, graphql_name='before', default=None)),
        ('first', sgqlc.types.Arg(Int, graphql_name='first', default=None)),
        ('last', sgqlc.types.Arg(Int, graphql_name='last', default=None)),
        ('offset', sgqlc.types.Arg(Int, graphql_name='offset', default=None)),
        ('order_by', sgqlc.types.Arg(sgqlc.types.non_null(MetricDataOrderBy), graphql_name='orderBy', default='TIME_ASC')),
        ('unit', sgqlc.types.Arg(String, graphql_name='unit', default=None)),
        ('unit_group', sgqlc.types.Arg(String, graphql_name='unitGroup', default=None)),
        ('timezone', sgqlc.types.Arg(String, graphql_name='timezone', default='UTC')),
))
    )


class BalancingAuthoritiesEdge(sgqlc.types.Type):
    __schema__ = nionic_schema
    __field_names__ = ('cursor', 'node')
    cursor = sgqlc.types.Field(Cursor, graphql_name='cursor')
    node = sgqlc.types.Field(sgqlc.types.non_null('BalancingAuthority'), graphql_name='node')


class BlastRotation(sgqlc.types.Type):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'blast_id', 'current_status', 'overall_start_time', 'overall_end_time', 'estimated_refrigeration_end_time', 'planned_freezing_hours', 'created_at', 'updated_at', 'metadata', 'assumed_pallet_count', 'methodology_type')
    id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='id')
    blast_id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='blastId')
    current_status = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='currentStatus')
    overall_start_time = sgqlc.types.Field(sgqlc.types.non_null(Datetime), graphql_name='overallStartTime')
    overall_end_time = sgqlc.types.Field(Datetime, graphql_name='overallEndTime')
    estimated_refrigeration_end_time = sgqlc.types.Field(Datetime, graphql_name='estimatedRefrigerationEndTime')
    planned_freezing_hours = sgqlc.types.Field(Float, graphql_name='plannedFreezingHours')
    created_at = sgqlc.types.Field(sgqlc.types.non_null(Datetime), graphql_name='createdAt')
    updated_at = sgqlc.types.Field(sgqlc.types.non_null(Datetime), graphql_name='updatedAt')
    metadata = sgqlc.types.Field(sgqlc.types.non_null(JSON), graphql_name='metadata')
    assumed_pallet_count = sgqlc.types.Field(Int, graphql_name='assumedPalletCount')
    methodology_type = sgqlc.types.Field(String, graphql_name='methodologyType')


class BlastRotationsConnection(sgqlc.types.relay.Connection):
    __schema__ = nionic_schema
    __field_names__ = ('nodes', 'edges', 'page_info', 'total_count')
    nodes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(BlastRotation))), graphql_name='nodes')
    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null('BlastRotationsEdge'))), graphql_name='edges')
    page_info = sgqlc.types.Field(sgqlc.types.non_null('PageInfo'), graphql_name='pageInfo')
    total_count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='totalCount')


class BlastRotationsEdge(sgqlc.types.Type):
    __schema__ = nionic_schema
    __field_names__ = ('cursor', 'node')
    cursor = sgqlc.types.Field(Cursor, graphql_name='cursor')
    node = sgqlc.types.Field(sgqlc.types.non_null(BlastRotation), graphql_name='node')


class BuildingAreaPalletHistoriesConnection(sgqlc.types.relay.Connection):
    __schema__ = nionic_schema
    __field_names__ = ('nodes', 'edges', 'page_info', 'total_count')
    nodes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null('BuildingAreaPalletHistory'))), graphql_name='nodes')
    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null('BuildingAreaPalletHistoriesEdge'))), graphql_name='edges')
    page_info = sgqlc.types.Field(sgqlc.types.non_null('PageInfo'), graphql_name='pageInfo')
    total_count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='totalCount')


class BuildingAreaPalletHistoriesEdge(sgqlc.types.Type):
    __schema__ = nionic_schema
    __field_names__ = ('cursor', 'node')
    cursor = sgqlc.types.Field(Cursor, graphql_name='cursor')
    node = sgqlc.types.Field(sgqlc.types.non_null('BuildingAreaPalletHistory'), graphql_name='node')


class BuildingAreaPalletHistory(sgqlc.types.Type):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'building_area_id', 'pallet_location_id', 'pallet_id', 'in_transaction_id', 'out_transaction_id', 'in_time', 'out_time', 'created_at', 'updated_at', 'deleted_at', 'metadata')
    id = sgqlc.types.Field(sgqlc.types.non_null(BigInt), graphql_name='id')
    building_area_id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='buildingAreaId')
    pallet_location_id = sgqlc.types.Field(BigInt, graphql_name='palletLocationId')
    pallet_id = sgqlc.types.Field(sgqlc.types.non_null(BigInt), graphql_name='palletId')
    in_transaction_id = sgqlc.types.Field(BigInt, graphql_name='inTransactionId')
    out_transaction_id = sgqlc.types.Field(BigInt, graphql_name='outTransactionId')
    in_time = sgqlc.types.Field(sgqlc.types.non_null(Datetime), graphql_name='inTime')
    out_time = sgqlc.types.Field(Datetime, graphql_name='outTime')
    created_at = sgqlc.types.Field(sgqlc.types.non_null(Datetime), graphql_name='createdAt')
    updated_at = sgqlc.types.Field(sgqlc.types.non_null(Datetime), graphql_name='updatedAt')
    deleted_at = sgqlc.types.Field(Datetime, graphql_name='deletedAt')
    metadata = sgqlc.types.Field(JSON, graphql_name='metadata')


class BuildingAreaTypesConnection(sgqlc.types.relay.Connection):
    __schema__ = nionic_schema
    __field_names__ = ('nodes', 'edges', 'page_info', 'total_count')
    nodes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null('BuildingAreaType'))), graphql_name='nodes')
    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null('BuildingAreaTypesEdge'))), graphql_name='edges')
    page_info = sgqlc.types.Field(sgqlc.types.non_null('PageInfo'), graphql_name='pageInfo')
    total_count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='totalCount')


class BuildingAreaTypesEdge(sgqlc.types.Type):
    __schema__ = nionic_schema
    __field_names__ = ('cursor', 'node')
    cursor = sgqlc.types.Field(Cursor, graphql_name='cursor')
    node = sgqlc.types.Field(sgqlc.types.non_null('BuildingAreaType'), graphql_name='node')


class BuildingAreasConnection(sgqlc.types.relay.Connection):
    __schema__ = nionic_schema
    __field_names__ = ('nodes', 'edges', 'page_info', 'total_count')
    nodes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null('BuildingArea'))), graphql_name='nodes')
    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null('BuildingAreasEdge'))), graphql_name='edges')
    page_info = sgqlc.types.Field(sgqlc.types.non_null('PageInfo'), graphql_name='pageInfo')
    total_count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='totalCount')


class BuildingAreasEdge(sgqlc.types.Type):
    __schema__ = nionic_schema
    __field_names__ = ('cursor', 'node')
    cursor = sgqlc.types.Field(Cursor, graphql_name='cursor')
    node = sgqlc.types.Field(sgqlc.types.non_null('BuildingArea'), graphql_name='node')


class ChartsConnection(sgqlc.types.relay.Connection):
    __schema__ = nionic_schema
    __field_names__ = ('nodes', 'edges', 'page_info', 'total_count')
    nodes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null('Chart'))), graphql_name='nodes')
    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null('ChartsEdge'))), graphql_name='edges')
    page_info = sgqlc.types.Field(sgqlc.types.non_null('PageInfo'), graphql_name='pageInfo')
    total_count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='totalCount')


class ChartsEdge(sgqlc.types.Type):
    __schema__ = nionic_schema
    __field_names__ = ('cursor', 'node')
    cursor = sgqlc.types.Field(Cursor, graphql_name='cursor')
    node = sgqlc.types.Field(sgqlc.types.non_null('Chart'), graphql_name='node')


class ClearFacilityCommunicationPayload(sgqlc.types.Type):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'boolean', 'query')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    boolean = sgqlc.types.Field(Boolean, graphql_name='boolean')
    query = sgqlc.types.Field('Query', graphql_name='query')


class ComplianceGroup(sgqlc.types.Type):
    __schema__ = nionic_schema
    __field_names__ = ('id', 'label', 'created_at', 'updated_at', 'track_out_of_specification')
    id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='id')
    label = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='label')
    created_at = sgqlc.types.Field(sgqlc.types.non_null(Datetime), graphql_name='createdAt')
    updated_at = sgqlc.types.Field(sgqlc.types.non_null(Datetime), graphql_name='updatedAt')
    track_out_of_specification = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name='trackOutOfSpecification')


class ComplianceGroupsConnection(sgqlc.types.relay.Connection):
    __schema__ = nionic_schema
    __field_names__ = ('nodes', 'edges', 'page_info', 'total_count')
    nodes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(ComplianceGroup))), graphql_name='nodes')
    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null('ComplianceGroupsEdge'))), graphql_name='edges')
    page_info = sgqlc.types.Field(sgqlc.types.non_null('PageInfo'), graphql_name='pageInfo')
    total_count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='totalCount')


class ComplianceGroupsEdge(sgqlc.types.Type):
    __schema__ = nionic_schema
    __field_names__ = ('cursor', 'node')
    cursor = sgqlc.types.Field(Cursor, graphql_name='cursor')
    node = sgqlc.types.Field(sgqlc.types.non_null(ComplianceGroup), graphql_name='node')


class ComponentPermissions(sgqlc.types.Type):
    __schema__ = nionic_schema
    __field_names__ = ('can_write',)
    can_write = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name='canWrite')


class ComponentsConnection(sgqlc.types.relay.Connection):
    __schema__ = nionic_schema
    __field_names__ = ('nodes', 'edges', 'page_info', 'total_count')
    nodes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null('Component'))), graphql_name='nodes')
    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null('ComponentsEdge'))), graphql_name='edges')
    page_info = sgqlc.types.Field(sgqlc.types.non_null('PageInfo'), graphql_name='pageInfo')
    total_count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='totalCount')


class ComponentsEdge(sgqlc.types.Type):
    __schema__ = nionic_schema
    __field_names__ = ('cursor', 'node')
    cursor = sgqlc.types.Field(Cursor, graphql_name='cursor')
    node = sgqlc.types.Field(sgqlc.types.non_null('Component'), graphql_name='node')


class ControlEventActivityLog(sgqlc.types.Type):
    __schema__ = nionic_schema
    __field_names__ = ('control_event_id', 'time', 'type', 'actor', 'metadata', 'control_event')
    control_event_id = sgqlc.types.Field(Int, graphql_name='controlEventId')
    time = sgqlc.types.Field(Datetime, graphql_name='time')
    type = sgqlc.types.Field(String, graphql_name='type')
    actor = sgqlc.types.Field(Actor, graphql_name='actor')
    metadata = sgqlc.types.Field(JSON, graphql_name='metadata')
    control_event = sgqlc.types.Field('ControlEvent', graphql_name='controlEvent')


class ControlEventActivityLogsConnection(sgqlc.types.relay.Connection):
    __schema__ = nionic_schema
    __field_names__ = ('nodes', 'edges', 'page_info', 'total_count')
    nodes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(ControlEventActivityLog))), graphql_name='nodes')
    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null('ControlEventActivityLogsEdge'))), graphql_name='edges')
    page_info = sgqlc.types.Field(sgqlc.types.non_null('PageInfo'), graphql_name='pageInfo')
    total_count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='totalCount')


class ControlEventActivityLogsEdge(sgqlc.types.Type):
    __schema__ = nionic_schema
    __field_names__ = ('cursor', 'node')
    cursor = sgqlc.types.Field(Cursor, graphql_name='cursor')
    node = sgqlc.types.Field(sgqlc.types.non_null(ControlEventActivityLog), graphql_name='node')


class ControlEventLogsConnection(sgqlc.types.relay.Connection):
    __schema__ = nionic_schema
    __field_names__ = ('nodes', 'edges', 'page_info', 'total_count')
    nodes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null('ControlEventLog'))), graphql_name='nodes')
    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null('ControlEventLogsEdge'))), graphql_name='edges')
    page_info = sgqlc.types.Field(sgqlc.types.non_null('PageInfo'), graphql_name='pageInfo')
    total_count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='totalCount')


class ControlEventLogsEdge(sgqlc.types.Type):
    __schema__ = nionic_schema
    __field_names__ = ('cursor', 'node')
    cursor = sgqlc.types.Field(Cursor, graphql_name='cursor')
    node = sgqlc.types.Field(sgqlc.types.non_null('ControlEventLog'), graphql_name='node')


class ControlEventPermissions(sgqlc.types.Type):
    __schema__ = nionic_schema
    __field_names__ = ('can_write',)
    can_write = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name='canWrite')


class ControlEventStateTransitionsConnection(sgqlc.types.relay.Connection):
    __schema__ = nionic_schema
    __field_names__ = ('nodes', 'edges', 'page_info', 'total_count')
    nodes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null('ControlEventStateTransition'))), graphql_name='nodes')
    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null('ControlEventStateTransitionsEdge'))), graphql_name='edges')
    page_info = sgqlc.types.Field(sgqlc.types.non_null('PageInfo'), graphql_name='pageInfo')
    total_count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='totalCount')


class ControlEventStateTransitionsEdge(sgqlc.types.Type):
    __schema__ = nionic_schema
    __field_names__ = ('cursor', 'node')
    cursor = sgqlc.types.Field(Cursor, graphql_name='cursor')
    node = sgqlc.types.Field(sgqlc.types.non_null('ControlEventStateTransition'), graphql_name='node')


class ControlEventsConnection(sgqlc.types.relay.Connection):
    __schema__ = nionic_schema
    __field_names__ = ('nodes', 'edges', 'page_info', 'total_count')
    nodes = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null('ControlEvent'))), graphql_name='nodes')
    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null('ControlEventsEdge'))), graphql_name='edges')
    page_info = sgqlc.types.Field(sgqlc.types.non_null('PageInfo'), graphql_name='pageInfo')
    total_count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='totalCount')


class ControlEventsEdge(sgqlc.types.Type):
    __schema__ = nionic_schema
    __field_names__ = ('cursor', 'node')
    cursor = sgqlc.types.Field(Cursor, graphql_name='cursor')
    node = sgqlc.types.Field(sgqlc.types.non_null('ControlEvent'), graphql_name='node')


class CreateAccountChargePayload(sgqlc.types.Type):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'account_charge', 'query', 'account_statement', 'account_charge_edge')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    account_charge = sgqlc.types.Field('AccountCharge', graphql_name='accountCharge')
    query = sgqlc.types.Field('Query', graphql_name='query')
    account_statement = sgqlc.types.Field('AccountStatement', graphql_name='accountStatement')
    account_charge_edge = sgqlc.types.Field(AccountChargesEdge, graphql_name='accountChargeEdge', args=sgqlc.types.ArgDict((
        ('order_by', sgqlc.types.Arg(sgqlc.types.list_of(sgqlc.types.non_null(AccountChargesOrderBy)), graphql_name='orderBy', default=('PRIMARY_KEY_ASC',))),
))
    )


class CreateAccountStatementHistoryPayload(sgqlc.types.Type):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'account_statement_history', 'query', 'account_statement', 'account_statement_history_edge')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    account_statement_history = sgqlc.types.Field(AccountStatementHistory, graphql_name='accountStatementHistory')
    query = sgqlc.types.Field('Query', graphql_name='query')
    account_statement = sgqlc.types.Field('AccountStatement', graphql_name='accountStatement')
    account_statement_history_edge = sgqlc.types.Field(AccountStatementHistoriesEdge, graphql_name='accountStatementHistoryEdge', args=sgqlc.types.ArgDict((
        ('order_by', sgqlc.types.Arg(sgqlc.types.list_of(sgqlc.types.non_null(AccountStatementHistoriesOrderBy)), graphql_name='orderBy', default=('NATURAL',))),
))
    )


class CreateAccountStatementPayload(sgqlc.types.Type):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'account_statement', 'query', 'utility_account', 'account_statement_edge')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    account_statement = sgqlc.types.Field('AccountStatement', graphql_name='accountStatement')
    query = sgqlc.types.Field('Query', graphql_name='query')
    utility_account = sgqlc.types.Field('UtilityAccount', graphql_name='utilityAccount')
    account_statement_edge = sgqlc.types.Field(AccountStatementsEdge, graphql_name='accountStatementEdge', args=sgqlc.types.ArgDict((
        ('order_by', sgqlc.types.Arg(sgqlc.types.list_of(sgqlc.types.non_null(AccountStatementsOrderBy)), graphql_name='orderBy', default=('PRIMARY_KEY_ASC',))),
))
    )


class CreateAccountStatementPdfPayload(sgqlc.types.Type):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'account_statement_pdf', 'query', 'account_statement', 'account_statement_pdf_edge')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    account_statement_pdf = sgqlc.types.Field('AccountStatementPdf', graphql_name='accountStatementPdf')
    query = sgqlc.types.Field('Query', graphql_name='query')
    account_statement = sgqlc.types.Field('AccountStatement', graphql_name='accountStatement')
    account_statement_pdf_edge = sgqlc.types.Field(AccountStatementPdfsEdge, graphql_name='accountStatementPdfEdge', args=sgqlc.types.ArgDict((
        ('order_by', sgqlc.types.Arg(sgqlc.types.list_of(sgqlc.types.non_null(AccountStatementPdfsOrderBy)), graphql_name='orderBy', default=('PRIMARY_KEY_ASC',))),
))
    )


class CreateBalancingAuthorityPayload(sgqlc.types.Type):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'balancing_authority', 'query', 'balancing_authority_edge')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    balancing_authority = sgqlc.types.Field('BalancingAuthority', graphql_name='balancingAuthority')
    query = sgqlc.types.Field('Query', graphql_name='query')
    balancing_authority_edge = sgqlc.types.Field(BalancingAuthoritiesEdge, graphql_name='balancingAuthorityEdge', args=sgqlc.types.ArgDict((
        ('order_by', sgqlc.types.Arg(sgqlc.types.list_of(sgqlc.types.non_null(BalancingAuthoritiesOrderBy)), graphql_name='orderBy', default=('PRIMARY_KEY_ASC',))),
))
    )


class CreateBuildingAreaPayload(sgqlc.types.Type):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'building_area', 'query', 'building_area_type', 'facility', 'building_area_edge')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    building_area = sgqlc.types.Field('BuildingArea', graphql_name='buildingArea')
    query = sgqlc.types.Field('Query', graphql_name='query')
    building_area_type = sgqlc.types.Field('BuildingAreaType', graphql_name='buildingAreaType')
    facility = sgqlc.types.Field('Facility', graphql_name='facility')
    building_area_edge = sgqlc.types.Field(BuildingAreasEdge, graphql_name='buildingAreaEdge', args=sgqlc.types.ArgDict((
        ('order_by', sgqlc.types.Arg(sgqlc.types.list_of(sgqlc.types.non_null(BuildingAreasOrderBy)), graphql_name='orderBy', default=('PRIMARY_KEY_ASC',))),
))
    )


class CreateBuildingAreaTypePayload(sgqlc.types.Type):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'building_area_type', 'query', 'building_area_type_edge')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    building_area_type = sgqlc.types.Field('BuildingAreaType', graphql_name='buildingAreaType')
    query = sgqlc.types.Field('Query', graphql_name='query')
    building_area_type_edge = sgqlc.types.Field(BuildingAreaTypesEdge, graphql_name='buildingAreaTypeEdge', args=sgqlc.types.ArgDict((
        ('order_by', sgqlc.types.Arg(sgqlc.types.list_of(sgqlc.types.non_null(BuildingAreaTypesOrderBy)), graphql_name='orderBy', default=('PRIMARY_KEY_ASC',))),
))
    )


class CreateChartPayload(sgqlc.types.Type):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'chart', 'query', 'facility', 'chart_edge')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    chart = sgqlc.types.Field('Chart', graphql_name='chart')
    query = sgqlc.types.Field('Query', graphql_name='query')
    facility = sgqlc.types.Field('Facility', graphql_name='facility')
    chart_edge = sgqlc.types.Field(ChartsEdge, graphql_name='chartEdge', args=sgqlc.types.ArgDict((
        ('order_by', sgqlc.types.Arg(sgqlc.types.list_of(sgqlc.types.non_null(ChartsOrderBy)), graphql_name='orderBy', default=('PRIMARY_KEY_ASC',))),
))
    )


class CreateComponentPayload(sgqlc.types.Type):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'component', 'query', 'machine_user', 'facility', 'component_edge')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    component = sgqlc.types.Field('Component', graphql_name='component')
    query = sgqlc.types.Field('Query', graphql_name='query')
    machine_user = sgqlc.types.Field('MachineUser', graphql_name='machineUser')
    facility = sgqlc.types.Field('Facility', graphql_name='facility')
    component_edge = sgqlc.types.Field(ComponentsEdge, graphql_name='componentEdge', args=sgqlc.types.ArgDict((
        ('order_by', sgqlc.types.Arg(sgqlc.types.list_of(sgqlc.types.non_null(ComponentsOrderBy)), graphql_name='orderBy', default=('PRIMARY_KEY_ASC',))),
))
    )


class CreateControlEventLogPayload(sgqlc.types.Type):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'control_event_log', 'query', 'control_event', 'control_event_log_edge')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    control_event_log = sgqlc.types.Field('ControlEventLog', graphql_name='controlEventLog')
    query = sgqlc.types.Field('Query', graphql_name='query')
    control_event = sgqlc.types.Field('ControlEvent', graphql_name='controlEvent')
    control_event_log_edge = sgqlc.types.Field(ControlEventLogsEdge, graphql_name='controlEventLogEdge', args=sgqlc.types.ArgDict((
        ('order_by', sgqlc.types.Arg(sgqlc.types.list_of(sgqlc.types.non_null(ControlEventLogsOrderBy)), graphql_name='orderBy', default=('PRIMARY_KEY_ASC',))),
))
    )


class CreateControlEventPayload(sgqlc.types.Type):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'control_event', 'query', 'component', 'control_event_edge')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    control_event = sgqlc.types.Field('ControlEvent', graphql_name='controlEvent')
    query = sgqlc.types.Field('Query', graphql_name='query')
    component = sgqlc.types.Field('Component', graphql_name='component')
    control_event_edge = sgqlc.types.Field(ControlEventsEdge, graphql_name='controlEventEdge', args=sgqlc.types.ArgDict((
        ('order_by', sgqlc.types.Arg(sgqlc.types.list_of(sgqlc.types.non_null(ControlEventsOrderBy)), graphql_name='orderBy', default=('PRIMARY_KEY_ASC',))),
))
    )


class CreateDashboardPayload(sgqlc.types.Type):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'dashboard', 'query', 'facility', 'dashboard_edge')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    dashboard = sgqlc.types.Field('Dashboard', graphql_name='dashboard')
    query = sgqlc.types.Field('Query', graphql_name='query')
    facility = sgqlc.types.Field('Facility', graphql_name='facility')
    dashboard_edge = sgqlc.types.Field('DashboardsEdge', graphql_name='dashboardEdge', args=sgqlc.types.ArgDict((
        ('order_by', sgqlc.types.Arg(sgqlc.types.list_of(sgqlc.types.non_null(DashboardsOrderBy)), graphql_name='orderBy', default=('PRIMARY_KEY_ASC',))),
))
    )


class CreateDataPointPayload(sgqlc.types.Type):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'data_point', 'query', 'data_source', 'data_point_edge')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    data_point = sgqlc.types.Field('DataPoint', graphql_name='dataPoint')
    query = sgqlc.types.Field('Query', graphql_name='query')
    data_source = sgqlc.types.Field('DataSource', graphql_name='dataSource')
    data_point_edge = sgqlc.types.Field('DataPointsEdge', graphql_name='dataPointEdge', args=sgqlc.types.ArgDict((
        ('order_by', sgqlc.types.Arg(sgqlc.types.list_of(sgqlc.types.non_null(DataPointsOrderBy)), graphql_name='orderBy', default=('PRIMARY_KEY_ASC',))),
))
    )


class CreateDataPointTagPayload(sgqlc.types.Type):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'data_point_tag', 'query', 'data_point_tag_edge')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    data_point_tag = sgqlc.types.Field('DataPointTag', graphql_name='dataPointTag')
    query = sgqlc.types.Field('Query', graphql_name='query')
    data_point_tag_edge = sgqlc.types.Field('DataPointTagsEdge', graphql_name='dataPointTagEdge', args=sgqlc.types.ArgDict((
        ('order_by', sgqlc.types.Arg(sgqlc.types.list_of(sgqlc.types.non_null(DataPointTagsOrderBy)), graphql_name='orderBy', default=('PRIMARY_KEY_ASC',))),
))
    )


class CreateDataSourcePayload(sgqlc.types.Type):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'data_source', 'query', 'data_source_edge')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    data_source = sgqlc.types.Field('DataSource', graphql_name='dataSource')
    query = sgqlc.types.Field('Query', graphql_name='query')
    data_source_edge = sgqlc.types.Field('DataSourcesEdge', graphql_name='dataSourceEdge', args=sgqlc.types.ArgDict((
        ('order_by', sgqlc.types.Arg(sgqlc.types.list_of(sgqlc.types.non_null(DataSourcesOrderBy)), graphql_name='orderBy', default=('PRIMARY_KEY_ASC',))),
))
    )


class CreateDependencyPayload(sgqlc.types.Type):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'dependency', 'query', 'dependency_edge')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    dependency = sgqlc.types.Field('Dependency', graphql_name='dependency')
    query = sgqlc.types.Field('Query', graphql_name='query')
    dependency_edge = sgqlc.types.Field('DependenciesEdge', graphql_name='dependencyEdge', args=sgqlc.types.ArgDict((
        ('order_by', sgqlc.types.Arg(sgqlc.types.list_of(sgqlc.types.non_null(DependenciesOrderBy)), graphql_name='orderBy', default=('PRIMARY_KEY_ASC',))),
))
    )


class CreateFacilityCommunicationPayload(sgqlc.types.Type):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'facility_communication', 'query', 'facility', 'facility_communication_edge')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    facility_communication = sgqlc.types.Field('FacilityCommunication', graphql_name='facilityCommunication')
    query = sgqlc.types.Field('Query', graphql_name='query')
    facility = sgqlc.types.Field('Facility', graphql_name='facility')
    facility_communication_edge = sgqlc.types.Field('FacilityCommunicationsEdge', graphql_name='facilityCommunicationEdge', args=sgqlc.types.ArgDict((
        ('order_by', sgqlc.types.Arg(sgqlc.types.list_of(sgqlc.types.non_null(FacilityCommunicationsOrderBy)), graphql_name='orderBy', default=('PRIMARY_KEY_ASC',))),
))
    )


class CreateFacilityDataSourcePayload(sgqlc.types.Type):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'facility_data_source', 'query', 'facility', 'data_source_by_data_source_name', 'facility_data_source_edge')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    facility_data_source = sgqlc.types.Field('FacilityDataSource', graphql_name='facilityDataSource')
    query = sgqlc.types.Field('Query', graphql_name='query')
    facility = sgqlc.types.Field('Facility', graphql_name='facility')
    data_source_by_data_source_name = sgqlc.types.Field('DataSource', graphql_name='dataSourceByDataSourceName')
    facility_data_source_edge = sgqlc.types.Field('FacilityDataSourcesEdge', graphql_name='facilityDataSourceEdge', args=sgqlc.types.ArgDict((
        ('order_by', sgqlc.types.Arg(sgqlc.types.list_of(sgqlc.types.non_null(FacilityDataSourcesOrderBy)), graphql_name='orderBy', default=('PRIMARY_KEY_ASC',))),
))
    )


class CreateFacilityGroupPayload(sgqlc.types.Type):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'facility_group', 'query', 'parent', 'facility_group_edge')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    facility_group = sgqlc.types.Field('FacilityGroup', graphql_name='facilityGroup')
    query = sgqlc.types.Field('Query', graphql_name='query')
    parent = sgqlc.types.Field('FacilityGroup', graphql_name='parent')
    facility_group_edge = sgqlc.types.Field('FacilityGroupsEdge', graphql_name='facilityGroupEdge', args=sgqlc.types.ArgDict((
        ('order_by', sgqlc.types.Arg(sgqlc.types.list_of(sgqlc.types.non_null(FacilityGroupsOrderBy)), graphql_name='orderBy', default=('PRIMARY_KEY_ASC',))),
))
    )


class CreateFacilityGroupsLinkerPayload(sgqlc.types.Type):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'facility_groups_linker', 'query', 'facility', 'facility_grouping', 'facility_groups_linker_edge')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    facility_groups_linker = sgqlc.types.Field('FacilityGroupsLinker', graphql_name='facilityGroupsLinker')
    query = sgqlc.types.Field('Query', graphql_name='query')
    facility = sgqlc.types.Field('Facility', graphql_name='facility')
    facility_grouping = sgqlc.types.Field('FacilityGroup', graphql_name='facilityGrouping')
    facility_groups_linker_edge = sgqlc.types.Field('FacilityGroupsLinkersEdge', graphql_name='facilityGroupsLinkerEdge', args=sgqlc.types.ArgDict((
        ('order_by', sgqlc.types.Arg(sgqlc.types.list_of(sgqlc.types.non_null(FacilityGroupsLinkersOrderBy)), graphql_name='orderBy', default=('PRIMARY_KEY_ASC',))),
))
    )


class CreateFacilityPayload(sgqlc.types.Type):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'facility', 'query', 'timezone', 'unit_group_by_unit_group', 'pricing_node', 'facility_edge')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    facility = sgqlc.types.Field('Facility', graphql_name='facility')
    query = sgqlc.types.Field('Query', graphql_name='query')
    timezone = sgqlc.types.Field('Timezone', graphql_name='timezone')
    unit_group_by_unit_group = sgqlc.types.Field('UnitGroup', graphql_name='unitGroupByUnitGroup')
    pricing_node = sgqlc.types.Field('PricingNode', graphql_name='pricingNode')
    facility_edge = sgqlc.types.Field('FacilitiesEdge', graphql_name='facilityEdge', args=sgqlc.types.ArgDict((
        ('order_by', sgqlc.types.Arg(sgqlc.types.list_of(sgqlc.types.non_null(FacilitiesOrderBy)), graphql_name='orderBy', default=('PRIMARY_KEY_ASC',))),
))
    )


class CreateFacilityTaggedDataPointPayload(sgqlc.types.Type):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'facility_tagged_data_point', 'query', 'facility', 'data_point', 'tag', 'facility_tagged_data_point_edge')
    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')
    facility_tagged_data_point = sgqlc.types.Field('FacilityTaggedDataPoint', graphql_name='facilityTaggedDataPoint')
    query = sgqlc.types.Field('Query', graphql_name='query')
    facility = sgqlc.types.Field('Facility', graphql_name='facility')
    data_point = sgqlc.types.Field('DataPoint', graphql_name='dataPoint')
    tag = sgqlc.types.Field('DataPointTag', graphql_name='tag')
    facility_tagged_data_point_edge = sgqlc.types.Field('FacilityTaggedDataPointsEdge', graphql_name='facilityTaggedDataPointEdge', args=sgqlc.types.ArgDict((
        ('order_by', sgqlc.types.Arg(sgqlc.types.list_of(sgqlc.types.non_null(FacilityTaggedDataPointsOrderBy)), graphql_name='orderBy', default=('PRIMARY_KEY_ASC',))),
))
    )


class CreateMachineUserPayload(sgqlc.types.Type):
    __schema__ = nionic_schema
    __field_names__ = ('client_mutation_id', 'machine_user', 'query', 'machine_user_edge'