# Project File Summaries

| File | Summary |
| ---- | ------- |
| [`AGENTS.md`](AGENTS.md)| This file serves as a guide for the ShellForge Python runtime, detailing its structure, coding standards, testing protocols, and integration points. It outlines the organization of the codebase into geometry, construction, production, and adapter modules, emphasizing backend-agnostic modeling and the use of specific formatting and testing practices. |
| [`CONTRIBUTING.md`](CONTRIBUTING.md)| This file provides guidelines for contributing to the shellforgepy project, detailing the development setup, making changes, code style, and testing procedures. It encourages contributions by outlining steps for forking the repository, creating a virtual environment, running tests, and submitting pull requests, while emphasizing the importance of code formatting and testing. |
| [`debug_adapter.py`](debug_adapter.py)| This script is a debugging tool for understanding the behavior of NamedPart reconstruction in the shellforgepy project. It creates a basic box part, wraps it in a NamedPart, and tests the functionality of adapter functions for copying and translating parts, while printing the centers of the original and modified parts. |
| [`debug_base_vector.py`](debug_base_vector.py)| This file tests the functionality of the NamedPart class's translate method using a Base.Vector from FreeCAD. It creates a basic box part, initializes a NamedPart with it, and attempts to translate the part by a specified vector, printing the original and new center positions of the part's bounding box. |
| [`debug_chain.py`](debug_chain.py)| This file demonstrates the use of transformation functions from the 'shellforgepy.simple' module to manipulate a 3D box object. It creates a basic box, applies translation and rotation transformations, and prints the box's center after each transformation. It also showcases chaining transformations for combined effects. |
| [`debug_functional.py`](debug_functional.py)| This file tests the translation of a 3D part using both functional and direct method approaches. It creates a basic box and a named part, then compares the results of translating them using different methods, including handling translations with a vector from FreeCAD. It prints the centers of the parts before and after translation. |
| [`debug_named_part.py`](debug_named_part.py)| This script is a debug tool for analyzing the translation behavior of a NamedPart object in the ShellForgePy project. It creates a basic box and a NamedPart, applies a translation, and prints the original and translated centers of both the part and the named part, along with the name and type of the translated named part. |
| [`debug_translate.py`](debug_translate.py)| This Python script demonstrates the creation and manipulation of geometric parts using the ShellForgePy library. It creates a basic box and a named part, prints their original bounding box centers, applies a translation, and then prints the new centers and the type of the translated named part. |
| [`freecad_python.sh`](freecad_python.sh)| This Bash script serves as a generic runner for executing Python commands within the FreeCAD environment. It allows users to start an interactive REPL, run scripts, or execute modules while managing command-line arguments and setting up the necessary environment for FreeCAD. The script ensures a clean shutdown of the FreeCAD session after execution. |
| [`freecad_python_docker.sh`](freecad_python_docker.sh)| This Bash script facilitates running Python commands within the FreeCAD environment using Docker. It supports various modes such as interactive REPL, script execution, and module running. Key components include environment setup, FreeCAD module availability checks, and argument parsing for different execution modes. |
| [`freecad_python_simple.sh`](freecad_python_simple.sh)| This Bash script is a runner for FreeCAD Python using a Docker image. It sets up a virtual display for headless operation, installs necessary Python dependencies if not already installed, and executes a FreeCAD macro. The script handles command-line arguments for Python execution and ensures a clean environment by removing the Docker container after execution. |
| [`precommit.sh`](precommit.sh)| This Bash script automates code formatting and linting for Python files in the 'src' and 'tests' directories. It uses 'isort' and 'black' for formatting, and 'flake8' for linting, checking for syntax errors and unused imports. The script ensures code quality before committing changes. |
| [`README.md`](README.md)| The file provides an overview of the ShellForgePy project, a Python toolkit for modeling geometry and exporting parts for fabrication using various CAD backends like CadQuery and FreeCAD. It includes installation instructions, a quick start guide, project layout, and contribution guidelines, emphasizing backend-agnostic modeling and alignment-centric construction. |
| [`setup.cfg`](setup.cfg)| This configuration file is for the 'shellforgepy' project, detailing metadata, package options, dependencies, and testing configurations. It specifies project details like name, author, and license, along with required packages and optional dependencies for different functionalities. It also includes settings for testing and code style checks. |
| [`setup.py`](setup.py)| This setup file for the shellforgepy project is generated by PyScaffold and configures the project using setuptools. It includes logic to handle versioning through setuptools_scm and provides error handling for build issues, prompting users to update necessary packages if an error occurs. |
| [`docker/build_docker.sh`](docker/build_docker.sh)| This Bash script builds a Docker image for the FreeCAD Python project. It sets up error handling, determines the project name, calculates a content-based hash for versioning, and builds the Docker image with multiple tags. It also provides a command to test the built image. |
| [`docker/Dockerfile`](docker/Dockerfile)| This Dockerfile sets up a FreeCAD environment by installing necessary system dependencies, copying a FreeCAD Python wrapper, and creating workspace directories. It specifies the working directory and sets the default entrypoint to run the FreeCAD wrapper with the provided macro file. |
| [`docker/freecad_python.FCMacro`](docker/freecad_python.FCMacro)| This script serves as a command-line wrapper for FreeCAD, allowing users to run modules, scripts, or code snippets within the FreeCAD environment. It sets up the necessary Python environment, checks for FreeCAD module availability, and provides an interactive REPL for user commands. |
| [`docker/requirements.txt`](docker/requirements.txt)| This file specifies the core and testing dependencies for the shellforgepy project, including required versions of numpy and scipy for core functionality, and pytest along with pytest-cov for testing purposes. It ensures that the necessary libraries are available for both development and testing. |
| [`examples/filleted_boxes_example.py`](examples/filleted_boxes_example.py)| This script demonstrates the creation of various filleted box configurations for 3D printing, utilizing the `create_filleted_box` function from the `shellforgepy.simple` module. It organizes the boxes on a build plate and exports them as STL files, showcasing different fillet arrangements and dimensions. |
| [`src/shellforgepy/__init__.py`](src/shellforgepy/__init__.py)| This file manages the import of the `version` function and `PackageNotFoundError` exception from the appropriate library based on the Python version. It attempts to retrieve the package version using the package name and sets it to `__version__`, defaulting to 'unknown' if the package is not found. |
| [`src/shellforgepy/adapters/adapter_chooser.py`](src/shellforgepy/adapters/adapter_chooser.py)| This file contains functions to detect the available CAD environment (CadQuery or FreeCAD) and import the corresponding adapter module. It allows for manual override of the detection via an environment variable and caches the adapter for efficiency. The main components include `detect_cad_environment`, `import_adapter_module`, and `get_cad_adapter`. |
| [`src/shellforgepy/adapters/cadquery/cadquery_adapter.py`](src/shellforgepy/adapters/cadquery/cadquery_adapter.py)| This file provides utility functions for working with CadQuery geometry objects, specifically for obtaining bounding box properties, vertex coordinates, and their respective sizes. It includes functions to retrieve minimum, maximum, and center points of bounding boxes, as well as converting results to numpy arrays for easier computation. |
| [`src/shellforgepy/adapters/freecad/freecad_adapter.py`](src/shellforgepy/adapters/freecad/freecad_adapter.py)| This file contains functions for creating solids from face-vertex maps and calculating bounding boxes for geometry objects in FreeCAD. It includes methods to retrieve bounding box dimensions, center, and vertices, utilizing FreeCAD's Part module and numpy for numerical operations. The code is designed to facilitate geometric computations in a CAD environment. |
| [`src/shellforgepy/adapters/simple.py`](src/shellforgepy/adapters/simple.py)| This file imports various functions from the 'adapter_chooser' module to facilitate the creation and manipulation of 3D geometric shapes and solids. It defines a set of functions for creating basic shapes, performing transformations, and exporting solids, making it a key component for 3D modeling operations in the project. |
| [`src/shellforgepy/construct/alignment.py`](src/shellforgepy/construct/alignment.py)| This file defines an enumeration called 'Alignment' representing various alignment options (e.g., LEFT, RIGHT, CENTER) and a dictionary mapping these options to their corresponding sign values. It also dynamically adds a 'sign' attribute to each alignment option based on the dictionary values. |
| [`src/shellforgepy/construct/alignment_operations.py`](src/shellforgepy/construct/alignment_operations.py)| This file defines functions for translating and rotating 3D parts, aligning them based on specified criteria, and chaining multiple transformations. It utilizes adapter functions to ensure framework independence and includes error handling for alignment types. Key components include translation and rotation functions, alignment handling, and utility functions for bounding box calculations. |
| [`src/shellforgepy/construct/bounding_box_helpers.py`](src/shellforgepy/construct/bounding_box_helpers.py)| This file contains functions for calculating various properties of a bounding box, including its center, dimensions (lengths along x, y, z axes), and minimum and maximum coordinates. Each function takes a bounding box defined by minimum and maximum points and returns the respective value. |
| [`src/shellforgepy/construct/construct_utils.py`](src/shellforgepy/construct/construct_utils.py)| This file contains functions for geometric computations, including validation of rigid transformations, triangle area calculations, normal checks, and point-in-triangle tests. It also implements Fibonacci sphere sampling for generating points on a sphere. The main components include functions for triangle manipulation, barycentric coordinates, and edge normalization. |
| [`src/shellforgepy/construct/leaders_followers_cutters_part.py`](src/shellforgepy/construct/leaders_followers_cutters_part.py)| This file defines the `LeaderFollowersCuttersPart` class, which manages a composite of parts including a leader, followers, cutters, and non-production parts. It provides methods for normalization, fusion, translation, rotation, and reconstruction of these parts, utilizing helper functions from the `shellforgepy` library. |
| [`src/shellforgepy/construct/named_part.py`](src/shellforgepy/construct/named_part.py)| This file defines the `NamedPart` class, which represents a part with a name for tracking in assemblies. It includes methods for copying, translating, rotating, reconstructing, and fusing parts, utilizing functions from the `simple` adapter. The class facilitates in-place updates and logging for transformations, enhancing CAD system interactions. |
| [`src/shellforgepy/construct/part_collector.py`](src/shellforgepy/construct/part_collector.py)| This file defines a `PartCollector` class that manages CAD parts, allowing for operations such as fusing and cutting parts together. It utilizes methods to combine or subtract parts, ensuring that operations are performed on valid parts only. |
| [`src/shellforgepy/geometry/face_point_cloud.py`](src/shellforgepy/geometry/face_point_cloud.py)| This file defines parameters and functions for generating 3D facial features using spherical coordinates. It includes methods for converting between azimuthal and Cartesian coordinates, building a grid of facial points based on specified parameters, and ensuring points are not too close together. It utilizes numpy for numerical operations and imports utility functions from the shellforgepy library. |
| [`src/shellforgepy/geometry/higher_order_solids.py`](src/shellforgepy/geometry/higher_order_solids.py)| This file defines functions for creating geometric shapes, specifically a hexagonal prism, a trapezoidal prism, and a directed cylinder in a CAD environment. It utilizes functions from the shellforgepy library to handle geometric transformations and alignments, allowing for flexible shape creation based on specified parameters. |
| [`src/shellforgepy/geometry/mesh_builders.py`](src/shellforgepy/geometry/mesh_builders.py)| This file defines functions to create geometries for various polyhedra, including icosahedron, dodecahedron, cube, tetrahedron, and Fibonacci sphere. Each function returns vertex coordinates and face indices for the respective shapes, allowing for 3D modeling and visualization. The use of NumPy and SciPy facilitates efficient numerical computations and geometric operations. |
| [`src/shellforgepy/geometry/mesh_utils.py`](src/shellforgepy/geometry/mesh_utils.py)| This file implements a minimal binary STL writer in Python, allowing for the merging of 3D mesh data and exporting it in STL format. Key functions include merging meshes with tolerance, writing binary STL files, and converting shell maps into a unified mesh suitable for 3D printing. |
| [`src/shellforgepy/geometry/spherical_tools.py`](src/shellforgepy/geometry/spherical_tools.py)| This file contains functions for converting between spherical and Cartesian coordinates, shrinking triangles, creating shell triangle geometries, and performing ray-triangle intersection tests. It includes mathematical operations for geometric computations, particularly in 3D space, and is likely used in applications involving 3D modeling or simulations. |
| [`src/shellforgepy/geometry/treapezoidal_snake_geometry.py`](src/shellforgepy/geometry/treapezoidal_snake_geometry.py)| This file defines functions for creating 3D geometries based on 2D trapezoidal cross-sections, transforming them into 3D space using specified base points and normals. Key functions include creating snake vertices, local coordinate systems, and transforming cross-sections, facilitating the generation of complex mesh structures for computational geometry applications. |
| [`src/shellforgepy/produce/arrange_and_export.py`](src/shellforgepy/produce/arrange_and_export.py)| This file provides CAD-agnostic helpers for arranging parts and exporting them as STL files. It includes functions for exporting solids, arranging parts in rows based on specified gaps and bed width, and managing production-related constraints. The main components are the `export_solid_to_stl`, `_arrange_parts_in_rows`, and `arrange_and_export_parts` functions. |
| [`src/shellforgepy/produce/production_parts_model.py`](src/shellforgepy/produce/production_parts_model.py)| This file defines a `PartInfo` data class for managing information about production parts and a `PartList` class for handling collections of these parts. It includes methods for adding parts, checking for duplicates, and retrieving part information in a structured format. |
| [`src/shellforgepy/shells/connector_hint.py`](src/shellforgepy/shells/connector_hint.py)| This file defines a data class named `ConnectorHint`, which encapsulates information about connections between two regions in a geometric context. It includes attributes for vertices, normals, edge vectors, and provenance tracking. The class also has a custom string representation for easier debugging and visualization of its state. |
| [`src/shellforgepy/shells/connector_utils.py`](src/shellforgepy/shells/connector_utils.py)| This file defines a function `merge_collinear_connectors` that processes a list of `ConnectorHint` objects, merging those that are collinear based on specified angle and distance tolerances. It utilizes geometric calculations to ensure the integrity of the merged connectors, handling potential edge cases such as degenerate connectors. |
| [`src/shellforgepy/shells/materialized_connectors.py`](src/shellforgepy/shells/materialized_connectors.py)| This file provides CAD-agnostic utilities for generating connectors, including functions for creating geometric shapes like boxes and nuts, performing coordinate transformations, and normalizing vectors. It includes data structures for transformations and a mapping for screw sizes, facilitating the creation of various 3D shapes and components in CAD applications. |
| [`src/shellforgepy/shells/mesh_partition.py`](src/shellforgepy/shells/mesh_partition.py)| This file defines a `MeshPartition` class for managing and analyzing partitionable spheroid triangle meshes. It includes methods for checking point containment in cylinders, collinearity of line segments, and constructing closed paths from vertices. The class utilizes NetworkX for graph operations related to mesh faces and edges. |
| [`src/shellforgepy/shells/partitionable_spheroid_triangle_mesh.py`](src/shellforgepy/shells/partitionable_spheroid_triangle_mesh.py)| This file implements functions for managing 3D mesh triangles, ensuring consistent vertex winding order, and calculating geometric properties. Key components include functions for edge-triangle mapping, breadth-first traversal for winding propagation, and triangle manipulation. It also includes utilities for validating paths and calculating lengths in edge graphs, as well as handling triangle shrinking based on border width. |
| [`src/shellforgepy/shells/region_edge_feature.py`](src/shellforgepy/shells/region_edge_feature.py)| This file defines the `RegionEdgeFeature` data class, which represents a geometric edge in a 3D region. It includes attributes for edge vertices, coordinates, vector, centroid, and associated face information. The class also provides a method to calculate the edge length using NumPy for vector operations. |
| [`src/shellforgepy/shells/transformed_region_view.py`](src/shellforgepy/shells/transformed_region_view.py)| The file defines the `TransformedRegionView` class, which manages a 3D region's transformation in a mesh partition. It includes methods for applying transformations, retrieving transformed vertices and faces, and handling rotations and translations. The class ensures valid transformations and caches results for efficiency. |
| [`src/shellforgepy/simple.py`](src/shellforgepy/simple.py)| This file, part of the shellforgepy package, provides a simplified interface for importing key classes and functions related to alignment, geometry, and CAD operations. It dynamically loads CAD adapter functions and exposes them for easy access, facilitating solid modeling and part arrangement functionalities. |
| [`tests/unit/adapters/cadquery/test_cadquery_arrange_and_export.py`](tests/unit/adapters/cadquery/test_cadquery_arrange_and_export.py)| This file contains unit tests for the `PartCollector` and `NamedPart` classes from the `shellforgepy.simple` module, utilizing the CadQuery library for 3D modeling. It tests functionalities such as part creation, fusion, cutting, translation, rotation, and handling of part lists, ensuring that the classes behave as expected under various conditions. |
| [`tests/unit/adapters/cadquery/test_cadquery_basic_transformations.py`](tests/unit/adapters/cadquery/test_cadquery_basic_transformations.py)| This file contains unit tests for translation and rotation functions using CadQuery in the ShellForgePy project. It tests basic transformations on 3D boxes, ensuring that translations and rotations behave as expected. The tests are conditionally executed based on the availability of the CadQuery library. |
| [`tests/unit/adapters/cadquery/test_cadquery_objects_creation.py`](tests/unit/adapters/cadquery/test_cadquery_objects_creation.py)| This file contains unit tests for geometric shape creation using CadQuery, including basic shapes like boxes, cylinders, and dodecahedrons. It tests the validity and volume calculations of these shapes, as well as bounding box and vertex extraction functions. The tests are conditionally executed based on the availability of the CadQuery library. |
| [`tests/unit/adapters/freecad/test_debug_transforms.py`](tests/unit/adapters/freecad/test_debug_transforms.py)| This file contains test functions for debugging translation and rotation operations on geometric parts using the ShellForgePy library. It verifies the behavior of the NamedPart class and its methods, ensuring that translations and rotations produce expected results. The tests utilize assertions to confirm that the transformations are applied correctly to both native and named parts. |
| [`tests/unit/adapters/freecad/test_freecad_arrange_and_export.py`](tests/unit/adapters/freecad/test_freecad_arrange_and_export.py)| This file contains unit tests for the PartCollector and NamedPart classes in the shellforgepy library, utilizing pytest. It tests functionalities such as fusing parts, cutting, translating, and rotating named parts, as well as managing a list of parts with unique names. The tests ensure that the FreeCAD environment is available before execution. |
| [`tests/unit/adapters/freecad/test_freecad_basic_transformations.py`](tests/unit/adapters/freecad/test_freecad_basic_transformations.py)| This file contains unit tests for basic geometric transformations, specifically translation and rotation of 3D boxes using FreeCAD. It checks the correctness of these transformations by asserting expected outcomes against actual results. The tests are conditionally executed based on the availability of FreeCAD, ensuring compatibility. |
| [`tests/unit/adapters/freecad/test_freecad_objects_creation.py`](tests/unit/adapters/freecad/test_freecad_objects_creation.py)| This file contains unit tests for geometric shape creation in FreeCAD using pytest. It tests the creation of basic shapes like boxes, dodecahedrons, cylinders, spheres, and cones, as well as bounding box utilities and vertex extraction functions. The tests ensure that the shapes are created correctly and validate their properties such as volume and bounding box dimensions. |
| [`tests/unit/construct/test_alignment_operations.py`](tests/unit/construct/test_alignment_operations.py)| This file contains unit tests for geometric transformations, specifically translation and rotation, applied to 3D parts created using the ShellForgePy library. It verifies the correctness of transformations on basic shapes, named parts, and leader-follower structures, ensuring consistent behavior across different object types. |
| [`tests/unit/construct/test_comprehensive_leader_followers_cutters.py`](tests/unit/construct/test_comprehensive_leader_followers_cutters.py)| This file contains unit tests for the rotation and translation of components in a LeaderFollowersCuttersPart group. It verifies that all parts (leader, followers, cutters, non-production parts) are correctly manipulated using geometric transformations, ensuring their dimensions and positions are accurately updated after operations. |
| [`tests/unit/construct/test_leaders_followers_cutters.py`](tests/unit/construct/test_leaders_followers_cutters.py)| This file contains unit tests for the `PartList` and `LeaderFollowersCuttersPart` classes in the `shellforgepy` project. It tests functionalities such as adding parts to a list, handling duplicate names, translating and rotating parts, and fusing leader and follower components. The tests ensure that the parts behave as expected during transformations and combinations. |
| [`tests/unit/construct/test_leaders_followers_cutters_comprehensive.py`](tests/unit/construct/test_leaders_followers_cutters_comprehensive.py)| This file contains unit tests for the `LeaderFollowersCuttersPart` class, testing its creation, copying, translation, and rotation functionalities. It uses the `pytest` framework and includes assertions to verify that the operations behave as expected, ensuring the integrity of the class's methods and properties. |
| [`tests/unit/construct/test_named_part.py`](tests/unit/construct/test_named_part.py)| This file contains unit tests for the NamedPart class in the shellforgepy project. It tests functionalities such as creation, copying, translation, rotation, and consistency of transformations for NamedPart objects. The tests ensure that NamedPart behaves correctly when manipulated using various geometric operations. |
| [`tests/unit/construct_lib/test_connector_utils.py`](tests/unit/construct_lib/test_connector_utils.py)| This file contains a test function for validating the computation of connector hints from a tetrahedron shell map. It defines the tetrahedron's vertices and faces, creates a shell map, and checks that the computed hints are valid instances of ConnectorHint, ensuring they meet specific conditions related to regions and count. |
| [`tests/unit/construct_lib/test_construct_utils.py`](tests/unit/construct_lib/test_construct_utils.py)| This file contains unit tests for the function `split_triangle_topologically`, which splits a triangle into smaller triangles based on specified edge cuts. It verifies the correctness of the splitting process, ensuring that the area is preserved and that the resulting triangles are well-formed. The tests cover various scenarios, including one, two, and three edge splits, as well as no splits. |
| [`tests/unit/construct_lib/test_geometries.py`](tests/unit/construct_lib/test_geometries.py)| This file contains unit tests for various geometry creation functions, including cubes, tetrahedrons, dodecahedrons, icosahedrons, and Fibonacci spheres. Each test checks the number of points and faces generated, ensuring correct geometry and face connectivity. It also verifies that the triangles are correctly oriented for use in a partitionable mesh structure. |
| [`tests/unit/construct_lib/test_mesh_partition.py`](tests/unit/construct_lib/test_mesh_partition.py)| This file contains functions for visualizing 2D projections of mesh edges and testing mesh partitioning and connector merging functionalities. It utilizes geometric constructs like dodecahedrons and employs classes for mesh partitioning and connector hints. The tests ensure the integrity of mesh operations and validate the merging of collinear connectors. |
| [`tests/unit/construct_lib/test_mesh_utils.py`](tests/unit/construct_lib/test_mesh_utils.py)| This file contains unit tests for vector operations and STL binary writing functions used in a 3D geometry processing context. It tests operations like vector subtraction, cross product, normalization, and the writing of STL files for both single and multiple triangles. The tests ensure the correctness of geometric computations and file output formats. |
| [`tests/unit/construct_lib/test_partitionable_spheroid_triangle_mesh.py`](tests/unit/construct_lib/test_partitionable_spheroid_triangle_mesh.py)| This file contains a series of test functions for the `PartitionableSpheroidTriangleMesh` class, focusing on mesh partitioning and vertex manipulation. It includes tests for splitting regions, adding vertices, and perforating meshes along planes, ensuring the integrity of mesh structures and their properties. |
| [`tests/unit/construct_lib/test_spherical_tools.py`](tests/unit/construct_lib/test_spherical_tools.py)| This file contains unit tests for various geometric transformations and intersection functions, including conversions between Cartesian and spherical coordinates, ray-triangle and ray-plane polygon intersections. It also defines classes for representing rotated and translated objects. The tests ensure the correctness of these geometric operations, which are essential for 3D modeling and computational geometry. |
| [`tests/unit/construct_lib/test_transformed_region_view.py`](tests/unit/construct_lib/test_transformed_region_view.py)| This file contains unit tests for geometric transformations and connector hints in a 3D modeling context. It tests functionalities such as creating geometries, partitioning meshes, and computing transformed shell maps and connector hints. The tests ensure the integrity and correctness of the geometric operations and transformations applied to the mesh structures. |
| [`tests/unit/construct_lib/test_trapezoidal_snake_geometry.py`](tests/unit/construct_lib/test_trapezoidal_snake_geometry.py)| This file contains unit tests for geometric operations related to trapezoidal snake geometry, including functions for normalizing vectors, creating local coordinate systems, and transforming 2D cross-sections to 3D. It also includes a function to convert traditional face-vertex maps to STL format. The tests ensure the correctness of these geometric computations. |
| [`tests/unit/geometry/test_higher_order_solids.py`](tests/unit/geometry/test_higher_order_solids.py)| This file contains unit tests for geometric solid creation functions, specifically testing the creation of hexagonal prisms, trapezoids, and directed cylinders. It verifies that the created shapes are not None and checks the volume calculations for directed cylinders against expected values using assertions. |
| [`tests/unit/test_materialized_connectors.py`](tests/unit/test_materialized_connectors.py)| This file contains unit tests for the materialized connectors in the ShellForgePy project. It tests functions that compute transformations, create connector parts, and generate screw connectors using a simple hint structure. The tests ensure that the created objects have valid properties and volumes, verifying the functionality of the connector creation logic. |
| [`tools/container_hash_calculator.py`](tools/container_hash_calculator.py)| This Python script calculates hash values for local container source code, enabling content-based versioning. It identifies relevant files, computes their SHA256 hashes, and provides a command-line interface for users to obtain hashes for specific containers or all containers in a directory. |
| [`tools/fix_imports.py`](tools/fix_imports.py)| This script automates the correction of misplaced imports in Python files using AST-based analysis. It identifies incorrect imports, determines the correct paths, and modifies the files accordingly. Key functions include determining correct imports, fixing invalid imports, and handling both absolute and relative import statements. |
| [`tools/fix_imports_robust.py`](tools/fix_imports_robust.py)| This script automates the correction of misplaced imports in Python files using AST-based analysis. It identifies symbols, their locations, and generates appropriate import specifications while handling special cases for adapter exports. Key functions include discovering symbol locations, extracting used symbols, and generating correct imports for files. |
| [`tools/fix_relative_imports.py`](tools/fix_relative_imports.py)| This script fixes relative imports in Python files by converting them to absolute imports, excluding special 'simple.py' files. It uses the Abstract Syntax Tree (AST) to identify relative imports, resolves them to absolute paths, and rewrites the import statements in the original files. The main components include classes and functions for finding and fixing imports. |
| [`tools/import_fixer.py`](tools/import_fixer.py)| This file analyzes Python files in a project to extract import statements and module exports using the Abstract Syntax Tree (AST) module. It defines an ImportVisitor class to traverse the AST, functions to analyze imports and exports, and a module_paths function to scan source and test directories, collecting import information for each file. |
| [`tools/import_regenerator.py`](tools/import_regenerator.py)| This file provides utilities for managing Python import statements, including validation of file structure, extraction of current imports, and regeneration of import sections. It defines an ImportSpec class for representing imports and includes error handling for exotic import patterns. The main functions facilitate the removal and regeneration of imports in Python files. |
| [`tools/regenerate_imports.py`](tools/regenerate_imports.py)| This file is an advanced import regenerator that analyzes Python files to extract import statements and symbols using the Abstract Syntax Tree (AST). It builds a model of imports, removes existing imports, and regenerates them in a canonical format. Key components include the ImportAnalyzer class, functions for discovering modules, and handling symbol imports. |
