"""
    Setup file for shellforgepy.
    Use setup.cfg to configure your project.

    This file was generated with PyScaffold 4.6.
    PyScaffold helps you to put up the scaffold of your new Python project.
    Learn more under: https://pyscaffold.org/
"""
import os

from setuptools import setup

if __name__ == "__main__":
    try:
        # patched version compared to the one generated by putup
        use_scm = (
            {"use_scm_version": {"version_scheme": "no-guess-dev"}}
            if os.environ.get("DISABLE_SETUPTOOLS_SCM") is None
            else {"version": "0.0.0"}
        )

        setup(**use_scm)
    except:  # noqa
        print(
            "\n\nAn error occurred while building the project, "
            "please ensure you have the most updated version of setuptools, "
            "setuptools_scm and wheel with:\n"
            "   pip install -U setuptools setuptools_scm wheel\n\n"
        )
        raise
