---
Scientific literature using `ngsxfem`
---

### Fictitious domain problems
* C. Lehrenfeld. “A higher order isoparametric fictitious domain method for level set domains”. In S. Bordas, E. Burman, M. Larson, & M. Olshanskii (Eds.), Lecture notes in computational science and engineering (Vol. 121, pp. 65–92). Springer, Cham. doi: [10.1007/978-3-319-71431-8_3](https://doi.org/10.1007/978-3-319-71431-8_3).

* A. Aretaki, E. N. Karatzas, and G. Katsouleas. “Equal Higher Order Analysis of an Unfitted Discontinuous Galerkin Method for Stokes Flow Systems”. In: J. Sci. Comput. 91.2 (Apr. 2022). doi: [10.1007/s10915-022-01823-w](https://doi.org/10.1007/s10915-022-01823-w)

* H. Liu. “Unfitted finite element methods for the Stokes problem using the Scott- Vogelius pair”. PhD thesis. University of Pittsburgh, 2022.

* F. Heimann, C. Lehrenfeld, P. Stocker, and H. von Wahl. “Unfitted Trefftz discontinuous Galerkin methods for elliptic boundary value problems“. In: ESAIM Math. Model. Numer. Anal. 57.5, 2023. doi: [10.1051/m2an/2023064](https://doi.org/10.1051/m2an/2023064)

* C. Lehrenfeld, T. van Beeck, and I. Voulis. “Analysis of divergence-preserving unfitted finite element methods for the mixed Poisson problem“.  June 22, 2023. arXiv: [2306.12722](https://arxiv.org/abs/2306.12722) [math.NA].

* J. Smith-Roberge. “Microcolony Dynamics: Motion from Growth, Order, and Incompressibility“. PhD thesis, University of Waterloo, 2023. 
URI [hdl:10012/19340](http://hdl.handle.net/10012/19340).

### Scalar and Stokes interface problems, such as two-phase flow problems

* C. Lehrenfeld and A. Reusken. “Optimal preconditioners for Nitsche-XFEM discretizations of interface problems”. In: Numer. Math. 135.2 (26th Mar. 2016), pp. 313–332. doi: [10.1007/s00211-016-0801-6](https://doi.org/10.1007/s00211-016-0801-6).

* C. Lehrenfeld. “High order unfitted finite element methods on level set domains using isoparametric mappings”. In: Comput. Methods Appl. Mech. Engrg. 300 (1st Mar. 2016), pp. 716–733. doi: [10.1016/j.cma.2015.12.005](https://doi.org/10.1016/j.cma.2015.12.005).

* C. Lehrenfeld. “Removing the stabilization parameter in fitted and unfitted symmetric Nitsche formulations”. In: Proceedings of the VII European Congress on Computational Methods in Applied Sciences and Engineering (ECCOMAS Congress 2016). Institute of Structural Analysis and Antiseismic Research School of Civil Engineering National Technical University of Athens (NTUA) Greece, 2nd Mar. 2016. doi: [10.7712/100016.1820.4573](https://doi.org/10.7712/100016.1820.4573).

* C. Lehrenfeld and A. Reusken. “L2-error analysis of an isoparametric unfitted finite element method for elliptic interface problems”. In: J. Numer. Math. 27.2 (17th Dec. 2019), pp. 85–99. doi: [10.1515/jnma-2017-0109](https://doi.org/10.1515/jnma-2017-0109).

* P. Lederer, C.-M. Pfeiler, C. Wintersteiger and C. Lehrenfeld. “Higher order unfitted FEM for Stokes interface problems”. In: PAMM. Proc. Appl. Math. Mech. 16.1 (25th Oct. 2016), pp. 7–10. doi: [10.1002/pamm.201610003](https://doi.org/10.1002/pamm.201610003).

* M. Olshanskii, A.Quaini and Q. Sun. An unfitted finite element method for two-phase Stokes problems with slip between phases. J. Sci. Comp. 89, 2021. doi: [10.1007/s10915-021-01658-x](https://doi.org/10.1007/s10915-021-01658-x).

* M. Olshanskii, A.Quaini and Q. Sun. A finite element method for two-phase flow with material viscous interface. Comp. Meth. Appl. Math.  22.2, 2022. doi: [10.1515/cmam-2021-0185](https://doi.org/10.1515/cmam-2021-0185).

* T. Ludescher. “Multilevel preconditioning of stabilized unfitted finite element discretizations”. PhD thesis. RWTH Aachen University, 27th May 2020. doi: [10.18154/RWTH-2020-07305](https://doi.org/10.18154/RWTH-2020-07305.)

* S. Groß, A. Reusken. "Analysis of optimal Preconditioners for CutFEM". 2022. Num. Lin. Alg. w. Appl., 2022. doi: [10.1002/nla.2486](https://doi.org/10.1002/nla.2486).

### Fractured Porous Media

* G. Fu, Y. Yang. "A hybridizable discontinuous Galerkin method on unfitted meshes for single-phase Darcy flow in fractured porous media". Adv. in Water Resources, 2023, doi: [10.1016/j.advwatres.2023.104390](https://doi.org/10.1016/j.advwatres.2023.104390), arXiv: [2209.05445](https://arxiv.org/abs/2209.05445) [math.NA].

### PDEs on moving domains: Space-time methods
* F. Heimann, C. Lehrenfeld and J. Preuß. "Geometrically higher order unfitted space-time methods for PDEs on moving domains". SIAM Journal on Scientific Computing 45.2, 2023, doi: [10.1137/22M1476034](https://doi.org/10.1137/22M1476034).

* A. C. Wendler. "Monolithic Unfitted Space-Time FEM for an Osmotic Cell Swelling Problem". MA thesis. Georg-August Universität Göttingen, Feb. 2022. doi: [10.25625/0KPEON](http://dx.doi.org/10.25625/0KPEON)

* J. Preuß. “Higher order unfitted isoparametric space-time FEM on moving domains”. MA thesis. Georg-August Universität Göttingen, 31st Jan. 2018. doi: [10.25625/UACWXS](http://dx.doi.org/10.25625/UACWXS)

* F. Heimann. “On Discontinuous- and Continuous-In-Time Unfitted Space-Time Methods for PDEs on Moving Domains”. MA thesis. Georg-August Universität Göttingen, Oct. 2020. doi: [10.25625/OIBRT4](http://dx.doi.org/10.25625/OIBRT4).

### PDEs on moving domains: Eulerian time-stepping
* Y. Lou and C. Lehrenfeld. "Isoparametric unfitted BDF -- finite element method for PDEs on evolving domains.", SIAM Journal on Numerical Analysis 60.4, 2022. doi: [10.1137/21M142126X](https://epubs.siam.org/doi/10.1137/21M142126X)

* C. Lehrenfeld and M. A. Olshanskii. “An Eulerian finite element method for PDEs in time-dependent domains”. In: ESAIM Math. Model. Numer. Anal. 53.2 (24th Apr. 2019), pp. 585–614. doi: [10.1051/m2an/2018068](https://doi.org/10.1051/m2an/2018068).

* H. von Wahl, T. Richter and C. Lehrenfeld. “An unfitted Eulerian finite element method for the time-dependent Stokes problem on moving domains”. In: IMA J. Numer. Anal. (2021). doi: [10.1093/imanum/drab044](https://doi.org/10.1093/imanum/drab044).

* H. von Wahl and T. Richter. “Error analysis for a parabolic PDE model problem on a coupled moving domain in a fully Eulerian framework”. In: SIAM J. Num. Anal. 2023. doi: [10.1137/21M1458417](https://doi.org/10.1137/21M1458417).

* H. von Wahl and T. Richter. “An Eulerian time-stepping scheme for a coupled parabolic moving domain problem using equal order unfitted finite elements”. In: Proc. Appl. Math. Mech. 2023. doi: [10.1002/pamm.202200003](https://doi.org/10.1002/pamm.202200003).

* M. Olshanskii and H. von Wahl "A conservative Eulerian finite element method for transport and diffusion in moving domains". 10th April 2024, arXiv: [2404.07130](https://arxiv.org/abs/2404.07130) [math.NA].

### Fluid structure interaction
* M. Kemper. “Pure Eulerian unfitted FEM for Biological Fluid-Structure Interaction Problems”. MA thesis. Georg-August Universität Göttingen, 1st Feb. 2022. doi: [10.25625/DYUGCA](http://dx.doi.org/10.25625/DYUGCA)

* H. von Wahl, T. Richter, S. Frei and T. Hagemeier. “Falling balls in a viscous fluid with contact: Comparing numerical simulations with experimental data”. In: Phys. Fluids 33.3, 033304 (2nd Mar. 2021). doi: [10.1063/5.0037971](https://doi.org/10.1063/5.0037971).

* H. von Wahl and T. Richter. “Using a deep neural network to predict the motion of under-resolved triangular rigid bodies in an incompressible flow”. Int. J. Num. Meth. Fluids, 93.12, 2021. doi: [10.1002/fld.5037](https://doi.org/10.1002/fld.5037).

* H. von Wahl. "Unfitted finite elements for fluid-rigid body interaction problems". PhD Thesis. Otto-von-Guericke-Universität Magdeburg. Oct. 2021, doi: [10.25673/40013](https://doi.org/10.25673/40013).

* H. von Wahl and T. Wick. "A high-accuracy framework for phase-field fracture interface reconstructions with application to Stokes fluid-filled fracture surrounded by an elastic medium". Comput. Methods Appl. Mech. Engrg., 415.116202, 2023. doi: [10.1016/j.cma.2023.116202](https://doi.org/10.1016/j.cma.2023.116202).

###  Surface PDEs

* E. Bachini, P. Brandner, T. Jankuhn, M. Nestler, S. Praetorius, A. Reusken, A. Voigt, "Diffusion of tangential tensor fields: numerical issues and influence of geometric properties". 25 May 2022, arXiv: [2205.12581](https://arxiv.org/abs/2205.12581) [math.NA].

* P. Brandner, T. Jankuhn, S. Praetorius, A. Reusken, A. Voigt, “Finite element discretization methods for velocity-pressure and stream function formulations of surface Stokes equations”. SIAM J. Sci. Comp. 44.4, 2022. doi: [10.1137/21M1403126](https://doi.org/10.1137/21M1403126).

* J. Grande, C. Lehrenfeld and A. Reusken. “Analysis of a High-Order Trace Finite Element Method for PDEs on Level Set Surfaces”. In: SIAM J. Numer. Anal. 56.1 (18th Jan. 2018), pp. 228–255. doi: [10.1137/16m1102203](https://doi.org/10.1137/16m1102203).

 * F. Heimann. “Higher order Discontinuous Galerkin methods for the Laplace-Beltrami problem on unfitted smooth surfaces”. Bachelor’s thesis. GeorgAugust Universität Göttingen, Sept. 2018. doi: [10.25625/OIBRT4](https://doi.org/10.25625/OIBRT4).

 * T. Jankuhn and A. Reusken. “Trace finite element methods for surface vector-Laplace equations”. In: IMA J. Numer. Anal. 41.1 (29th Apr. 2019), pp. 48–83. doi: [10.1093/imanum/drz062](https://doi.org/10.1093/imanum/drz062).

* A. Reusken. Analysis of finite element methods for surface vector-Laplace eigenproblems. Math. Comp. 2022. doi: [10.1090/mcom/3728](https://doi.org/10.1090/mcom/3728).

* T. Jankuhn and A. Reusken. Higher order Trace Finite Element Methods for the Surface Stokes Equation. 18th Sept. 2019. arXiv: [1909.08327](https://arxiv.org/abs/1909.08327) [math.NA].

* P. Brandner and A. Reusken. “Finite element error analysis of surface Stokes equations in stream function formulation”. In: ESAIM Math. Model. Numer. Anal. 54.6 (12th Oct. 2020), pp. 2069–2097. doi: [10.1051/m2an/2020044](https://doi.org/10.1051/m2an/2020044).

* H. Sass and A. Reusken. An Accurate and Robust Eulerian Finite Element Method for Partial Differential Equations on Evolving Surfaces. Dec. 22, 2022. arXiv: [2212.12030](https://arxiv.org/abs/2212.12030) [math.NA].

* P. Brandner. “Numerical Methods for Surface Navier-Stokes Equations in Stream Function Formulation”. PhD thesis. RWTH Aachen University, 2022. doi: [10.18154/RWTH-2022-04531](https://doi.org/10.18154/RWTH-2022-04531).

* S. Lu and X. Xu. “A Geometrically Consistent Trace Finite Element Method For The Laplace-Beltrami Eigenvalue Problem”. 2021. arXiv: [2108.02434](https://arxiv.org/abs/2108.02434) [math.NA]

* E. Schlesinger. "Embedded Trefftz Trace DG Methods for PDEs on unfitted Surfaces". Master's thesis, University of Göttingen, 2023. doi: [10.25625/QTOPWD](https://doi.org/10.25625/QTOPWD).

### Shape optimization
* H.-G. Raumer. “Shape Optimization for Interface Problems using unfitted Finite Elements”. MA thesis. Georg-August Universität Göttingen, 28th Mar. 2018. url: http://cpde.math.uni-goettingen.de/data/Rau18_Ma.pdf.

### Model order reduction and optimal control
* A. Aretaki and E. N. Karatzas. Random geometries for optimal control PDE problems based on fictitious domain FEMs and cut elements. 
Journal of Computational and Appl. Math, 2022, doi: [10.1016/j.cam.2022.114286](https://doi.org/10.1016/j.cam.2022.114286), arXiv: [2003.00352](https://arxiv.org/abs/2003.00352) [math.NA].

* E. N. Karatzas, M. Nonino, F. Ballarin and G. Rozza. A Reduced Order Cut Finite Element method for geometrically parameterized steady and unsteady Navier-Stokes problems. 10th Oct. 2020. arXiv: [2010.04953](https://arxiv.org/abs/2010.04953) [math.NA].

* G. Katsouleas, E. N. Karatzas, and F. Travlopanos. “Discrete empirical interpolation and unfitted mesh FEMs: application in PDE-constrained optimization”. In: Optimization (Feb. 2022), pp. 1–34. doi: [10.1080/02331934.2022.2032697](https://doi.org/10.1080/02331934.2022.2032697).

### Space-time discretisations (fitted FEM in space)
* G. Fu and Z. Xu. High-order space-time finite element methods for the Poisson-Nernst-Planck equations: Positivity and unconditional energy stability. Comp. Meth. Appl. Mech. Eng. 395, 2022. doi: [10.1016/j.cma.2022.115031](https://doi.org/10.1016/j.cma.2022.115031).

### Reproduction Datasets

* H. von Wahl, T. Richter and C. Lehrenfeld. An unfitted Eulerian finite element method for the time-dependent Stokes problem on moving domains. Zenodo repository: Zenodo, 5th Feb. 2020. doi: [10.5281/zenodo.3647571](https://doi.org/10.5281/zenodo.3647571).

* H. von Wahl, T. Richter, S. Frei and T. Hagemeier. Falling balls in a viscous fluid with contact: Comparing numerical simulations with experimental data. Zenodo repository, 17th Nov. 2020. doi: [10.5281/zenodo.3989604](https://doi.org/10.5281/zenodo.3989604).

* H. von Wahl and T. Richter. Error analysis for a parabolic PDE model problem on a coupled moving domain in a fully Eulerian framework - Reproduction Scripts. Zenodo repository: Zenodo, 29th Apr 2022. doi: [10.5281/zenodo.6505243](https://doi.org/10.5281/zenodo.6505243).

* S. Groß. Preconditioner experiments for 2D CutFEM Poisson Interface Problem, Zenodo repository: Zenodo, 25th October 2022. doi: [10.5281/zenodo.7249209](https://doi.org/10.5281/zenodo.7249209)

* H. von Wahl and T. Wick. A high-precision framework for phase-field fracture interface reconstructions with application to Stokes fluid-filled fracture surrounded by an elastic medium - Reproduction code. Zenodo repository, Dec. 15, 2022. doi: [10.5281/zenodo.7443025](https://doi.org/10.5281/zenodo.7443025).

* F. Heimann, C. Lehrenfeld, P. Stocker, and H. von Wahl. Unfitted Trefftz discontinuous Galerkin methods for elliptic boundary value problems - Reproduction scripts. Zenodo repository, Dec. 2022. doi: [10.5281/zenodo.7474688](https://doi.org/10.5281/zenodo.7474688).

* M. Olshanskii and H. von Wahl. A conservative Eulerian finite element method for transport and diffusion in moving domains - Reproduction Scripts. Zenodo repository, April. 2023. doi: [10.5281/zenodo.10951768](https://doi.org/10.5281/zenodo.10951768).
