# 🕷️ Scrapegraph-ai Examples

This directory contains various example implementations of Scrapegraph-ai for different use cases. Each example demonstrates how to leverage the power of Scrapegraph-ai for specific scenarios.

> **Note:** While these examples showcase implementations using OpenAI and Ollama, Scrapegraph-ai supports many other LLM providers! Check out our [documentation](https://docs-oss.scrapegraphai.com/examples) for the full list of supported providers.

## 📚 Available Examples

- 🧠 `smart_scraper/` - Advanced web scraping with intelligent content extraction
- 🔎 `search_graph/` - Web search and data retrieval
- ⚙️ `script_generator_graph/` - Automated script generation
- 🌐 `depth_search_graph/` - Deep web crawling and content exploration
- 📊 `csv_scraper_graph/` - Scraping and processing data into CSV format
- 📑 `xml_scraper_graph/` - XML data extraction and processing
- 🎤 `speech_graph/` - Speech processing and analysis
- 🔄 `omni_scraper_graph/` - Universal web scraping for multiple data types
- 🔍 `omni_search_graph/` - Comprehensive search across multiple sources
- 📄 `document_scraper_graph/` - Document parsing and data extraction
- 🛠️ `custom_graph/` - Custom graph implementation examples
- 💻 `code_generator_graph/` - Code generation utilities
- 📋 `json_scraper_graph/` - JSON data extraction and processing
- 📋 `colab example`:
<a target="_blank" href="https://colab.research.google.com/drive/1sEZBonBMGP44CtO6GQTwAlL0BGJXjtfd?usp=sharing#scrollTo=vGDjka17pqqg">
  <img src="https://colab.research.google.com/assets/colab-badge.svg" alt="Open In Colab"/>
</a>

## 🚀 Getting Started

1. Choose the example that best fits your use case
2. Navigate to the corresponding directory
3. Follow the README instructions in each directory
4. Configure any required environment variables using the provided `.env.example` files

## ⚡ Quick Setup

```bash
pip install scrapegraphai

playwright install

# choose an example
cd examples/smart_scraper_graph/openai

# run the example
python smart_scraper_openai.py
```

## 📋 Requirements

Each example may have its own specific requirements. Please refer to the individual README files in each directory for detailed setup instructions.

## 📚 Additional Resources

- 📖 [Full Documentation](https://docs-oss.scrapegraphai.com/examples)
- 💡 [Examples Repository](https://github.com/ScrapeGraphAI/ScrapegraphLib-Examples)
- 🤝 [Community Support](https://github.com/ScrapeGraphAI/scrapegraph-ai/discussions)

## 🤔 Need Help?

- Check out our [documentation](https://docs-oss.scrapegraphai.com)
- Join our [Discord community](https://discord.gg/scrapegraphai)
- Open an [issue](https://github.com/ScrapeGraphAI/scrapegraph-ai/issues)

---

⭐ Don't forget to star our repository if you find these examples helpful!
