# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
from Tea.model import TeaModel
from typing import List, Dict, Any


class WritingStyleTemplateDefineExample(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        self.key = key
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class WritingStyleTemplateFieldEnums(TeaModel):
    def __init__(
        self,
        cascading_fields: List[str] = None,
        key: str = None,
        name: str = None,
    ):
        self.cascading_fields = cascading_fields
        self.key = key
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cascading_fields is not None:
            result['CascadingFields'] = self.cascading_fields
        if self.key is not None:
            result['Key'] = self.key
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CascadingFields') is not None:
            self.cascading_fields = m.get('CascadingFields')
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class WritingStyleTemplateFieldStyle(TeaModel):
    def __init__(
        self,
        description: str = None,
        format: str = None,
        placeholder: str = None,
        show_time: bool = None,
        suffix: str = None,
        type: str = None,
    ):
        self.description = description
        self.format = format
        self.placeholder = placeholder
        self.show_time = show_time
        self.suffix = suffix
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.format is not None:
            result['Format'] = self.format
        if self.placeholder is not None:
            result['Placeholder'] = self.placeholder
        if self.show_time is not None:
            result['ShowTime'] = self.show_time
        if self.suffix is not None:
            result['Suffix'] = self.suffix
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Format') is not None:
            self.format = m.get('Format')
        if m.get('Placeholder') is not None:
            self.placeholder = m.get('Placeholder')
        if m.get('ShowTime') is not None:
            self.show_time = m.get('ShowTime')
        if m.get('Suffix') is not None:
            self.suffix = m.get('Suffix')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class WritingStyleTemplateField(TeaModel):
    def __init__(
        self,
        build_in: bool = None,
        cascading_fields: List['WritingStyleTemplateField'] = None,
        enums: List[WritingStyleTemplateFieldEnums] = None,
        initial_value: str = None,
        key: str = None,
        max: float = None,
        max_item: int = None,
        max_item_length: int = None,
        max_length: int = None,
        min: float = None,
        min_item_length: int = None,
        min_length: int = None,
        name: str = None,
        required: bool = None,
        style: WritingStyleTemplateFieldStyle = None,
    ):
        self.build_in = build_in
        self.cascading_fields = cascading_fields
        self.enums = enums
        self.initial_value = initial_value
        self.key = key
        self.max = max
        self.max_item = max_item
        self.max_item_length = max_item_length
        self.max_length = max_length
        self.min = min
        self.min_item_length = min_item_length
        self.min_length = min_length
        self.name = name
        self.required = required
        self.style = style

    def validate(self):
        if self.cascading_fields:
            for k in self.cascading_fields:
                if k:
                    k.validate()
        if self.enums:
            for k in self.enums:
                if k:
                    k.validate()
        if self.style:
            self.style.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.build_in is not None:
            result['BuildIn'] = self.build_in
        result['CascadingFields'] = []
        if self.cascading_fields is not None:
            for k in self.cascading_fields:
                result['CascadingFields'].append(k.to_map() if k else None)
        result['Enums'] = []
        if self.enums is not None:
            for k in self.enums:
                result['Enums'].append(k.to_map() if k else None)
        if self.initial_value is not None:
            result['InitialValue'] = self.initial_value
        if self.key is not None:
            result['Key'] = self.key
        if self.max is not None:
            result['Max'] = self.max
        if self.max_item is not None:
            result['MaxItem'] = self.max_item
        if self.max_item_length is not None:
            result['MaxItemLength'] = self.max_item_length
        if self.max_length is not None:
            result['MaxLength'] = self.max_length
        if self.min is not None:
            result['Min'] = self.min
        if self.min_item_length is not None:
            result['MinItemLength'] = self.min_item_length
        if self.min_length is not None:
            result['MinLength'] = self.min_length
        if self.name is not None:
            result['Name'] = self.name
        if self.required is not None:
            result['Required'] = self.required
        if self.style is not None:
            result['Style'] = self.style.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BuildIn') is not None:
            self.build_in = m.get('BuildIn')
        self.cascading_fields = []
        if m.get('CascadingFields') is not None:
            for k in m.get('CascadingFields'):
                temp_model = WritingStyleTemplateField()
                self.cascading_fields.append(temp_model.from_map(k))
        self.enums = []
        if m.get('Enums') is not None:
            for k in m.get('Enums'):
                temp_model = WritingStyleTemplateFieldEnums()
                self.enums.append(temp_model.from_map(k))
        if m.get('InitialValue') is not None:
            self.initial_value = m.get('InitialValue')
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Max') is not None:
            self.max = m.get('Max')
        if m.get('MaxItem') is not None:
            self.max_item = m.get('MaxItem')
        if m.get('MaxItemLength') is not None:
            self.max_item_length = m.get('MaxItemLength')
        if m.get('MaxLength') is not None:
            self.max_length = m.get('MaxLength')
        if m.get('Min') is not None:
            self.min = m.get('Min')
        if m.get('MinItemLength') is not None:
            self.min_item_length = m.get('MinItemLength')
        if m.get('MinLength') is not None:
            self.min_length = m.get('MinLength')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Required') is not None:
            self.required = m.get('Required')
        if m.get('Style') is not None:
            temp_model = WritingStyleTemplateFieldStyle()
            self.style = temp_model.from_map(m['Style'])
        return self


class WritingStyleTemplateDefine(TeaModel):
    def __init__(
        self,
        example: List[WritingStyleTemplateDefineExample] = None,
        fields: List[WritingStyleTemplateField] = None,
    ):
        self.example = example
        self.fields = fields

    def validate(self):
        if self.example:
            for k in self.example:
                if k:
                    k.validate()
        if self.fields:
            for k in self.fields:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Example'] = []
        if self.example is not None:
            for k in self.example:
                result['Example'].append(k.to_map() if k else None)
        result['Fields'] = []
        if self.fields is not None:
            for k in self.fields:
                result['Fields'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.example = []
        if m.get('Example') is not None:
            for k in m.get('Example'):
                temp_model = WritingStyleTemplateDefineExample()
                self.example.append(temp_model.from_map(k))
        self.fields = []
        if m.get('Fields') is not None:
            for k in m.get('Fields'):
                temp_model = WritingStyleTemplateField()
                self.fields.append(temp_model.from_map(k))
        return self


class AddAuditTermsRequest(TeaModel):
    def __init__(
        self,
        exception_word: List[str] = None,
        keyword: str = None,
        suggest_word: str = None,
        terms_desc: str = None,
        workspace_id: str = None,
    ):
        self.exception_word = exception_word
        self.keyword = keyword
        self.suggest_word = suggest_word
        self.terms_desc = terms_desc
        # This parameter is required.
        self.workspace_id = workspace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.exception_word is not None:
            result['ExceptionWord'] = self.exception_word
        if self.keyword is not None:
            result['Keyword'] = self.keyword
        if self.suggest_word is not None:
            result['SuggestWord'] = self.suggest_word
        if self.terms_desc is not None:
            result['TermsDesc'] = self.terms_desc
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExceptionWord') is not None:
            self.exception_word = m.get('ExceptionWord')
        if m.get('Keyword') is not None:
            self.keyword = m.get('Keyword')
        if m.get('SuggestWord') is not None:
            self.suggest_word = m.get('SuggestWord')
        if m.get('TermsDesc') is not None:
            self.terms_desc = m.get('TermsDesc')
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        return self


class AddAuditTermsShrinkRequest(TeaModel):
    def __init__(
        self,
        exception_word_shrink: str = None,
        keyword: str = None,
        suggest_word: str = None,
        terms_desc: str = None,
        workspace_id: str = None,
    ):
        self.exception_word_shrink = exception_word_shrink
        self.keyword = keyword
        self.suggest_word = suggest_word
        self.terms_desc = terms_desc
        # This parameter is required.
        self.workspace_id = workspace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.exception_word_shrink is not None:
            result['ExceptionWord'] = self.exception_word_shrink
        if self.keyword is not None:
            result['Keyword'] = self.keyword
        if self.suggest_word is not None:
            result['SuggestWord'] = self.suggest_word
        if self.terms_desc is not None:
            result['TermsDesc'] = self.terms_desc
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExceptionWord') is not None:
            self.exception_word_shrink = m.get('ExceptionWord')
        if m.get('Keyword') is not None:
            self.keyword = m.get('Keyword')
        if m.get('SuggestWord') is not None:
            self.suggest_word = m.get('SuggestWord')
        if m.get('TermsDesc') is not None:
            self.terms_desc = m.get('TermsDesc')
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        return self


class AddAuditTermsResponseBodyDataV1(TeaModel):
    def __init__(
        self,
        id: int = None,
    ):
        self.id = id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class AddAuditTermsResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: bool = None,
        data_v1: AddAuditTermsResponseBodyDataV1 = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.data_v1 = data_v1
        self.http_status_code = http_status_code
        self.message = message
        # Id of the request
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data_v1:
            self.data_v1.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.data_v1 is not None:
            result['DataV1'] = self.data_v1.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('DataV1') is not None:
            temp_model = AddAuditTermsResponseBodyDataV1()
            self.data_v1 = temp_model.from_map(m['DataV1'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class AddAuditTermsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddAuditTermsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddAuditTermsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddDatasetDocumentRequestDocumentMultimodalMedias(TeaModel):
    def __init__(
        self,
        file_url: str = None,
        media_id: str = None,
        media_type: str = None,
    ):
        self.file_url = file_url
        self.media_id = media_id
        self.media_type = media_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_url is not None:
            result['FileUrl'] = self.file_url
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        if self.media_type is not None:
            result['MediaType'] = self.media_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FileUrl') is not None:
            self.file_url = m.get('FileUrl')
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        if m.get('MediaType') is not None:
            self.media_type = m.get('MediaType')
        return self


class AddDatasetDocumentRequestDocument(TeaModel):
    def __init__(
        self,
        content: str = None,
        disable_handle_multimodal_media: bool = None,
        doc_id: str = None,
        doc_type: str = None,
        doc_uuid: str = None,
        extend_1: str = None,
        extend_2: str = None,
        extend_3: str = None,
        multimodal_index_name: str = None,
        multimodal_medias: List[AddDatasetDocumentRequestDocumentMultimodalMedias] = None,
        pub_time: str = None,
        source_from: str = None,
        summary: str = None,
        title: str = None,
        url: str = None,
    ):
        self.content = content
        self.disable_handle_multimodal_media = disable_handle_multimodal_media
        self.doc_id = doc_id
        self.doc_type = doc_type
        self.doc_uuid = doc_uuid
        self.extend_1 = extend_1
        self.extend_2 = extend_2
        self.extend_3 = extend_3
        self.multimodal_index_name = multimodal_index_name
        self.multimodal_medias = multimodal_medias
        self.pub_time = pub_time
        self.source_from = source_from
        self.summary = summary
        self.title = title
        self.url = url

    def validate(self):
        if self.multimodal_medias:
            for k in self.multimodal_medias:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.disable_handle_multimodal_media is not None:
            result['DisableHandleMultimodalMedia'] = self.disable_handle_multimodal_media
        if self.doc_id is not None:
            result['DocId'] = self.doc_id
        if self.doc_type is not None:
            result['DocType'] = self.doc_type
        if self.doc_uuid is not None:
            result['DocUuid'] = self.doc_uuid
        if self.extend_1 is not None:
            result['Extend1'] = self.extend_1
        if self.extend_2 is not None:
            result['Extend2'] = self.extend_2
        if self.extend_3 is not None:
            result['Extend3'] = self.extend_3
        if self.multimodal_index_name is not None:
            result['MultimodalIndexName'] = self.multimodal_index_name
        result['MultimodalMedias'] = []
        if self.multimodal_medias is not None:
            for k in self.multimodal_medias:
                result['MultimodalMedias'].append(k.to_map() if k else None)
        if self.pub_time is not None:
            result['PubTime'] = self.pub_time
        if self.source_from is not None:
            result['SourceFrom'] = self.source_from
        if self.summary is not None:
            result['Summary'] = self.summary
        if self.title is not None:
            result['Title'] = self.title
        if self.url is not None:
            result['Url'] = self.url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('DisableHandleMultimodalMedia') is not None:
            self.disable_handle_multimodal_media = m.get('DisableHandleMultimodalMedia')
        if m.get('DocId') is not None:
            self.doc_id = m.get('DocId')
        if m.get('DocType') is not None:
            self.doc_type = m.get('DocType')
        if m.get('DocUuid') is not None:
            self.doc_uuid = m.get('DocUuid')
        if m.get('Extend1') is not None:
            self.extend_1 = m.get('Extend1')
        if m.get('Extend2') is not None:
            self.extend_2 = m.get('Extend2')
        if m.get('Extend3') is not None:
            self.extend_3 = m.get('Extend3')
        if m.get('MultimodalIndexName') is not None:
            self.multimodal_index_name = m.get('MultimodalIndexName')
        self.multimodal_medias = []
        if m.get('MultimodalMedias') is not None:
            for k in m.get('MultimodalMedias'):
                temp_model = AddDatasetDocumentRequestDocumentMultimodalMedias()
                self.multimodal_medias.append(temp_model.from_map(k))
        if m.get('PubTime') is not None:
            self.pub_time = m.get('PubTime')
        if m.get('SourceFrom') is not None:
            self.source_from = m.get('SourceFrom')
        if m.get('Summary') is not None:
            self.summary = m.get('Summary')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        return self


class AddDatasetDocumentRequest(TeaModel):
    def __init__(
        self,
        dataset_id: int = None,
        dataset_name: str = None,
        document: AddDatasetDocumentRequestDocument = None,
        workspace_id: str = None,
    ):
        self.dataset_id = dataset_id
        self.dataset_name = dataset_name
        # This parameter is required.
        self.document = document
        # This parameter is required.
        self.workspace_id = workspace_id

    def validate(self):
        if self.document:
            self.document.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dataset_id is not None:
            result['DatasetId'] = self.dataset_id
        if self.dataset_name is not None:
            result['DatasetName'] = self.dataset_name
        if self.document is not None:
            result['Document'] = self.document.to_map()
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DatasetId') is not None:
            self.dataset_id = m.get('DatasetId')
        if m.get('DatasetName') is not None:
            self.dataset_name = m.get('DatasetName')
        if m.get('Document') is not None:
            temp_model = AddDatasetDocumentRequestDocument()
            self.document = temp_model.from_map(m['Document'])
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        return self


class AddDatasetDocumentShrinkRequest(TeaModel):
    def __init__(
        self,
        dataset_id: int = None,
        dataset_name: str = None,
        document_shrink: str = None,
        workspace_id: str = None,
    ):
        self.dataset_id = dataset_id
        self.dataset_name = dataset_name
        # This parameter is required.
        self.document_shrink = document_shrink
        # This parameter is required.
        self.workspace_id = workspace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dataset_id is not None:
            result['DatasetId'] = self.dataset_id
        if self.dataset_name is not None:
            result['DatasetName'] = self.dataset_name
        if self.document_shrink is not None:
            result['Document'] = self.document_shrink
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DatasetId') is not None:
            self.dataset_id = m.get('DatasetId')
        if m.get('DatasetName') is not None:
            self.dataset_name = m.get('DatasetName')
        if m.get('Document') is not None:
            self.document_shrink = m.get('Document')
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        return self


class AddDatasetDocumentResponseBodyData(TeaModel):
    def __init__(
        self,
        doc_id: str = None,
        doc_uuid: str = None,
        error_code: str = None,
        error_message: str = None,
        status: int = None,
    ):
        self.doc_id = doc_id
        self.doc_uuid = doc_uuid
        self.error_code = error_code
        self.error_message = error_message
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.doc_id is not None:
            result['DocId'] = self.doc_id
        if self.doc_uuid is not None:
            result['DocUuid'] = self.doc_uuid
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DocId') is not None:
            self.doc_id = m.get('DocId')
        if m.get('DocUuid') is not None:
            self.doc_uuid = m.get('DocUuid')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class AddDatasetDocumentResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: AddDatasetDocumentResponseBodyData = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = AddDatasetDocumentResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class AddDatasetDocumentResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddDatasetDocumentResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddDatasetDocumentResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AsyncCreateClipsTaskRequestColorWords(TeaModel):
    def __init__(
        self,
        content: str = None,
        effect_color_style: str = None,
        font_size: int = None,
        timeline_in: int = None,
        timeline_out: int = None,
        x: float = None,
        y: float = None,
    ):
        self.content = content
        self.effect_color_style = effect_color_style
        self.font_size = font_size
        self.timeline_in = timeline_in
        self.timeline_out = timeline_out
        self.x = x
        self.y = y

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.effect_color_style is not None:
            result['EffectColorStyle'] = self.effect_color_style
        if self.font_size is not None:
            result['FontSize'] = self.font_size
        if self.timeline_in is not None:
            result['TimelineIn'] = self.timeline_in
        if self.timeline_out is not None:
            result['TimelineOut'] = self.timeline_out
        if self.x is not None:
            result['X'] = self.x
        if self.y is not None:
            result['Y'] = self.y
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('EffectColorStyle') is not None:
            self.effect_color_style = m.get('EffectColorStyle')
        if m.get('FontSize') is not None:
            self.font_size = m.get('FontSize')
        if m.get('TimelineIn') is not None:
            self.timeline_in = m.get('TimelineIn')
        if m.get('TimelineOut') is not None:
            self.timeline_out = m.get('TimelineOut')
        if m.get('X') is not None:
            self.x = m.get('X')
        if m.get('Y') is not None:
            self.y = m.get('Y')
        return self


class AsyncCreateClipsTaskRequest(TeaModel):
    def __init__(
        self,
        color_words: List[AsyncCreateClipsTaskRequestColorWords] = None,
        height: int = None,
        music_url: str = None,
        music_volume: int = None,
        subtitle_font_size: int = None,
        task_id: str = None,
        voice_style: str = None,
        voice_volume: int = None,
        width: int = None,
        workspace_id: str = None,
    ):
        self.color_words = color_words
        self.height = height
        self.music_url = music_url
        self.music_volume = music_volume
        self.subtitle_font_size = subtitle_font_size
        # This parameter is required.
        self.task_id = task_id
        self.voice_style = voice_style
        self.voice_volume = voice_volume
        self.width = width
        # This parameter is required.
        self.workspace_id = workspace_id

    def validate(self):
        if self.color_words:
            for k in self.color_words:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ColorWords'] = []
        if self.color_words is not None:
            for k in self.color_words:
                result['ColorWords'].append(k.to_map() if k else None)
        if self.height is not None:
            result['Height'] = self.height
        if self.music_url is not None:
            result['MusicUrl'] = self.music_url
        if self.music_volume is not None:
            result['MusicVolume'] = self.music_volume
        if self.subtitle_font_size is not None:
            result['SubtitleFontSize'] = self.subtitle_font_size
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.voice_style is not None:
            result['VoiceStyle'] = self.voice_style
        if self.voice_volume is not None:
            result['VoiceVolume'] = self.voice_volume
        if self.width is not None:
            result['Width'] = self.width
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.color_words = []
        if m.get('ColorWords') is not None:
            for k in m.get('ColorWords'):
                temp_model = AsyncCreateClipsTaskRequestColorWords()
                self.color_words.append(temp_model.from_map(k))
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('MusicUrl') is not None:
            self.music_url = m.get('MusicUrl')
        if m.get('MusicVolume') is not None:
            self.music_volume = m.get('MusicVolume')
        if m.get('SubtitleFontSize') is not None:
            self.subtitle_font_size = m.get('SubtitleFontSize')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('VoiceStyle') is not None:
            self.voice_style = m.get('VoiceStyle')
        if m.get('VoiceVolume') is not None:
            self.voice_volume = m.get('VoiceVolume')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        return self


class AsyncCreateClipsTaskShrinkRequest(TeaModel):
    def __init__(
        self,
        color_words_shrink: str = None,
        height: int = None,
        music_url: str = None,
        music_volume: int = None,
        subtitle_font_size: int = None,
        task_id: str = None,
        voice_style: str = None,
        voice_volume: int = None,
        width: int = None,
        workspace_id: str = None,
    ):
        self.color_words_shrink = color_words_shrink
        self.height = height
        self.music_url = music_url
        self.music_volume = music_volume
        self.subtitle_font_size = subtitle_font_size
        # This parameter is required.
        self.task_id = task_id
        self.voice_style = voice_style
        self.voice_volume = voice_volume
        self.width = width
        # This parameter is required.
        self.workspace_id = workspace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.color_words_shrink is not None:
            result['ColorWords'] = self.color_words_shrink
        if self.height is not None:
            result['Height'] = self.height
        if self.music_url is not None:
            result['MusicUrl'] = self.music_url
        if self.music_volume is not None:
            result['MusicVolume'] = self.music_volume
        if self.subtitle_font_size is not None:
            result['SubtitleFontSize'] = self.subtitle_font_size
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.voice_style is not None:
            result['VoiceStyle'] = self.voice_style
        if self.voice_volume is not None:
            result['VoiceVolume'] = self.voice_volume
        if self.width is not None:
            result['Width'] = self.width
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ColorWords') is not None:
            self.color_words_shrink = m.get('ColorWords')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('MusicUrl') is not None:
            self.music_url = m.get('MusicUrl')
        if m.get('MusicVolume') is not None:
            self.music_volume = m.get('MusicVolume')
        if m.get('SubtitleFontSize') is not None:
            self.subtitle_font_size = m.get('SubtitleFontSize')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('VoiceStyle') is not None:
            self.voice_style = m.get('VoiceStyle')
        if m.get('VoiceVolume') is not None:
            self.voice_volume = m.get('VoiceVolume')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        return self


class AsyncCreateClipsTaskResponseBodyData(TeaModel):
    def __init__(
        self,
        task_id: str = None,
    ):
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class AsyncCreateClipsTaskResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: AsyncCreateClipsTaskResponseBodyData = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        # Id of the request
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = AsyncCreateClipsTaskResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class AsyncCreateClipsTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AsyncCreateClipsTaskResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AsyncCreateClipsTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AsyncCreateClipsTimeLineRequest(TeaModel):
    def __init__(
        self,
        additional_content: str = None,
        custom_content: str = None,
        no_ref_video: bool = None,
        process_prompt: str = None,
        task_id: str = None,
        workspace_id: str = None,
    ):
        self.additional_content = additional_content
        self.custom_content = custom_content
        self.no_ref_video = no_ref_video
        self.process_prompt = process_prompt
        # This parameter is required.
        self.task_id = task_id
        # This parameter is required.
        self.workspace_id = workspace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.additional_content is not None:
            result['AdditionalContent'] = self.additional_content
        if self.custom_content is not None:
            result['CustomContent'] = self.custom_content
        if self.no_ref_video is not None:
            result['NoRefVideo'] = self.no_ref_video
        if self.process_prompt is not None:
            result['ProcessPrompt'] = self.process_prompt
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AdditionalContent') is not None:
            self.additional_content = m.get('AdditionalContent')
        if m.get('CustomContent') is not None:
            self.custom_content = m.get('CustomContent')
        if m.get('NoRefVideo') is not None:
            self.no_ref_video = m.get('NoRefVideo')
        if m.get('ProcessPrompt') is not None:
            self.process_prompt = m.get('ProcessPrompt')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        return self


class AsyncCreateClipsTimeLineResponseBodyData(TeaModel):
    def __init__(
        self,
        task_id: str = None,
    ):
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class AsyncCreateClipsTimeLineResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: AsyncCreateClipsTimeLineResponseBodyData = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        # Id of the request
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = AsyncCreateClipsTimeLineResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class AsyncCreateClipsTimeLineResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AsyncCreateClipsTimeLineResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AsyncCreateClipsTimeLineResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AsyncEditTimelineRequestTimelinesClips(TeaModel):
    def __init__(
        self,
        clip_id: str = None,
        content_inner: str = None,
        in_: int = None,
        in_ex: float = None,
        out: int = None,
        out_ex: float = None,
        video_id: str = None,
        video_name: str = None,
    ):
        self.clip_id = clip_id
        self.content_inner = content_inner
        self.in_ = in_
        self.in_ex = in_ex
        self.out = out
        self.out_ex = out_ex
        self.video_id = video_id
        self.video_name = video_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.clip_id is not None:
            result['ClipId'] = self.clip_id
        if self.content_inner is not None:
            result['ContentInner'] = self.content_inner
        if self.in_ is not None:
            result['In'] = self.in_
        if self.in_ex is not None:
            result['InEx'] = self.in_ex
        if self.out is not None:
            result['Out'] = self.out
        if self.out_ex is not None:
            result['OutEx'] = self.out_ex
        if self.video_id is not None:
            result['VideoId'] = self.video_id
        if self.video_name is not None:
            result['VideoName'] = self.video_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClipId') is not None:
            self.clip_id = m.get('ClipId')
        if m.get('ContentInner') is not None:
            self.content_inner = m.get('ContentInner')
        if m.get('In') is not None:
            self.in_ = m.get('In')
        if m.get('InEx') is not None:
            self.in_ex = m.get('InEx')
        if m.get('Out') is not None:
            self.out = m.get('Out')
        if m.get('OutEx') is not None:
            self.out_ex = m.get('OutEx')
        if m.get('VideoId') is not None:
            self.video_id = m.get('VideoId')
        if m.get('VideoName') is not None:
            self.video_name = m.get('VideoName')
        return self


class AsyncEditTimelineRequestTimelines(TeaModel):
    def __init__(
        self,
        clips: List[AsyncEditTimelineRequestTimelinesClips] = None,
        timeline_id: str = None,
    ):
        # This parameter is required.
        self.clips = clips
        self.timeline_id = timeline_id

    def validate(self):
        if self.clips:
            for k in self.clips:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Clips'] = []
        if self.clips is not None:
            for k in self.clips:
                result['Clips'].append(k.to_map() if k else None)
        if self.timeline_id is not None:
            result['TimelineId'] = self.timeline_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.clips = []
        if m.get('Clips') is not None:
            for k in m.get('Clips'):
                temp_model = AsyncEditTimelineRequestTimelinesClips()
                self.clips.append(temp_model.from_map(k))
        if m.get('TimelineId') is not None:
            self.timeline_id = m.get('TimelineId')
        return self


class AsyncEditTimelineRequest(TeaModel):
    def __init__(
        self,
        auto_clips: bool = None,
        task_id: str = None,
        timelines: List[AsyncEditTimelineRequestTimelines] = None,
        workspace_id: str = None,
    ):
        self.auto_clips = auto_clips
        # This parameter is required.
        self.task_id = task_id
        # This parameter is required.
        self.timelines = timelines
        # This parameter is required.
        self.workspace_id = workspace_id

    def validate(self):
        if self.timelines:
            for k in self.timelines:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auto_clips is not None:
            result['AutoClips'] = self.auto_clips
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        result['Timelines'] = []
        if self.timelines is not None:
            for k in self.timelines:
                result['Timelines'].append(k.to_map() if k else None)
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AutoClips') is not None:
            self.auto_clips = m.get('AutoClips')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        self.timelines = []
        if m.get('Timelines') is not None:
            for k in m.get('Timelines'):
                temp_model = AsyncEditTimelineRequestTimelines()
                self.timelines.append(temp_model.from_map(k))
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        return self


class AsyncEditTimelineShrinkRequest(TeaModel):
    def __init__(
        self,
        auto_clips: bool = None,
        task_id: str = None,
        timelines_shrink: str = None,
        workspace_id: str = None,
    ):
        self.auto_clips = auto_clips
        # This parameter is required.
        self.task_id = task_id
        # This parameter is required.
        self.timelines_shrink = timelines_shrink
        # This parameter is required.
        self.workspace_id = workspace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auto_clips is not None:
            result['AutoClips'] = self.auto_clips
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.timelines_shrink is not None:
            result['Timelines'] = self.timelines_shrink
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AutoClips') is not None:
            self.auto_clips = m.get('AutoClips')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('Timelines') is not None:
            self.timelines_shrink = m.get('Timelines')
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        return self


class AsyncEditTimelineResponseBodyData(TeaModel):
    def __init__(
        self,
        message: str = None,
        task_id: str = None,
    ):
        self.message = message
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class AsyncEditTimelineResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: AsyncEditTimelineResponseBodyData = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        # Id of the request
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = AsyncEditTimelineResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class AsyncEditTimelineResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AsyncEditTimelineResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AsyncEditTimelineResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AsyncUploadTenderDocRequest(TeaModel):
    def __init__(
        self,
        file_key: str = None,
        tender_doc_name: str = None,
        workspace_id: str = None,
    ):
        self.file_key = file_key
        self.tender_doc_name = tender_doc_name
        self.workspace_id = workspace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_key is not None:
            result['FileKey'] = self.file_key
        if self.tender_doc_name is not None:
            result['TenderDocName'] = self.tender_doc_name
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FileKey') is not None:
            self.file_key = m.get('FileKey')
        if m.get('TenderDocName') is not None:
            self.tender_doc_name = m.get('TenderDocName')
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        return self


class AsyncUploadTenderDocResponseBodyData(TeaModel):
    def __init__(
        self,
        task_id: str = None,
    ):
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class AsyncUploadTenderDocResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: AsyncUploadTenderDocResponseBodyData = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        # Id of the request
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = AsyncUploadTenderDocResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class AsyncUploadTenderDocResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AsyncUploadTenderDocResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AsyncUploadTenderDocResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AsyncUploadVideoRequestReferenceVideo(TeaModel):
    def __init__(
        self,
        video_extra_info: str = None,
        video_name: str = None,
        video_url: str = None,
    ):
        self.video_extra_info = video_extra_info
        self.video_name = video_name
        self.video_url = video_url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.video_extra_info is not None:
            result['VideoExtraInfo'] = self.video_extra_info
        if self.video_name is not None:
            result['VideoName'] = self.video_name
        if self.video_url is not None:
            result['VideoUrl'] = self.video_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('VideoExtraInfo') is not None:
            self.video_extra_info = m.get('VideoExtraInfo')
        if m.get('VideoName') is not None:
            self.video_name = m.get('VideoName')
        if m.get('VideoUrl') is not None:
            self.video_url = m.get('VideoUrl')
        return self


class AsyncUploadVideoRequestSourceVideos(TeaModel):
    def __init__(
        self,
        video_extra_info: str = None,
        video_name: str = None,
        video_url: str = None,
    ):
        self.video_extra_info = video_extra_info
        # This parameter is required.
        self.video_name = video_name
        # This parameter is required.
        self.video_url = video_url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.video_extra_info is not None:
            result['VideoExtraInfo'] = self.video_extra_info
        if self.video_name is not None:
            result['VideoName'] = self.video_name
        if self.video_url is not None:
            result['VideoUrl'] = self.video_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('VideoExtraInfo') is not None:
            self.video_extra_info = m.get('VideoExtraInfo')
        if m.get('VideoName') is not None:
            self.video_name = m.get('VideoName')
        if m.get('VideoUrl') is not None:
            self.video_url = m.get('VideoUrl')
        return self


class AsyncUploadVideoRequest(TeaModel):
    def __init__(
        self,
        anlysis_prompt: str = None,
        reference_video: AsyncUploadVideoRequestReferenceVideo = None,
        source_videos: List[AsyncUploadVideoRequestSourceVideos] = None,
        split_interval: int = None,
        workspace_id: str = None,
    ):
        self.anlysis_prompt = anlysis_prompt
        self.reference_video = reference_video
        # This parameter is required.
        self.source_videos = source_videos
        self.split_interval = split_interval
        # This parameter is required.
        self.workspace_id = workspace_id

    def validate(self):
        if self.reference_video:
            self.reference_video.validate()
        if self.source_videos:
            for k in self.source_videos:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.anlysis_prompt is not None:
            result['AnlysisPrompt'] = self.anlysis_prompt
        if self.reference_video is not None:
            result['ReferenceVideo'] = self.reference_video.to_map()
        result['SourceVideos'] = []
        if self.source_videos is not None:
            for k in self.source_videos:
                result['SourceVideos'].append(k.to_map() if k else None)
        if self.split_interval is not None:
            result['SplitInterval'] = self.split_interval
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AnlysisPrompt') is not None:
            self.anlysis_prompt = m.get('AnlysisPrompt')
        if m.get('ReferenceVideo') is not None:
            temp_model = AsyncUploadVideoRequestReferenceVideo()
            self.reference_video = temp_model.from_map(m['ReferenceVideo'])
        self.source_videos = []
        if m.get('SourceVideos') is not None:
            for k in m.get('SourceVideos'):
                temp_model = AsyncUploadVideoRequestSourceVideos()
                self.source_videos.append(temp_model.from_map(k))
        if m.get('SplitInterval') is not None:
            self.split_interval = m.get('SplitInterval')
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        return self


class AsyncUploadVideoShrinkRequest(TeaModel):
    def __init__(
        self,
        anlysis_prompt: str = None,
        reference_video_shrink: str = None,
        source_videos_shrink: str = None,
        split_interval: int = None,
        workspace_id: str = None,
    ):
        self.anlysis_prompt = anlysis_prompt
        self.reference_video_shrink = reference_video_shrink
        # This parameter is required.
        self.source_videos_shrink = source_videos_shrink
        self.split_interval = split_interval
        # This parameter is required.
        self.workspace_id = workspace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.anlysis_prompt is not None:
            result['AnlysisPrompt'] = self.anlysis_prompt
        if self.reference_video_shrink is not None:
            result['ReferenceVideo'] = self.reference_video_shrink
        if self.source_videos_shrink is not None:
            result['SourceVideos'] = self.source_videos_shrink
        if self.split_interval is not None:
            result['SplitInterval'] = self.split_interval
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AnlysisPrompt') is not None:
            self.anlysis_prompt = m.get('AnlysisPrompt')
        if m.get('ReferenceVideo') is not None:
            self.reference_video_shrink = m.get('ReferenceVideo')
        if m.get('SourceVideos') is not None:
            self.source_videos_shrink = m.get('SourceVideos')
        if m.get('SplitInterval') is not None:
            self.split_interval = m.get('SplitInterval')
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        return self


class AsyncUploadVideoResponseBodyDataVideoInfos(TeaModel):
    def __init__(
        self,
        video_extra_info: str = None,
        video_id: str = None,
        video_name: str = None,
        video_url: str = None,
    ):
        self.video_extra_info = video_extra_info
        self.video_id = video_id
        self.video_name = video_name
        self.video_url = video_url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.video_extra_info is not None:
            result['VideoExtraInfo'] = self.video_extra_info
        if self.video_id is not None:
            result['VideoId'] = self.video_id
        if self.video_name is not None:
            result['VideoName'] = self.video_name
        if self.video_url is not None:
            result['VideoUrl'] = self.video_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('VideoExtraInfo') is not None:
            self.video_extra_info = m.get('VideoExtraInfo')
        if m.get('VideoId') is not None:
            self.video_id = m.get('VideoId')
        if m.get('VideoName') is not None:
            self.video_name = m.get('VideoName')
        if m.get('VideoUrl') is not None:
            self.video_url = m.get('VideoUrl')
        return self


class AsyncUploadVideoResponseBodyData(TeaModel):
    def __init__(
        self,
        task_id: str = None,
        video_infos: List[AsyncUploadVideoResponseBodyDataVideoInfos] = None,
    ):
        self.task_id = task_id
        self.video_infos = video_infos

    def validate(self):
        if self.video_infos:
            for k in self.video_infos:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        result['VideoInfos'] = []
        if self.video_infos is not None:
            for k in self.video_infos:
                result['VideoInfos'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        self.video_infos = []
        if m.get('VideoInfos') is not None:
            for k in m.get('VideoInfos'):
                temp_model = AsyncUploadVideoResponseBodyDataVideoInfos()
                self.video_infos.append(temp_model.from_map(k))
        return self


class AsyncUploadVideoResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: AsyncUploadVideoResponseBodyData = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        # Id of the request
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = AsyncUploadVideoResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class AsyncUploadVideoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AsyncUploadVideoResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AsyncUploadVideoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AsyncWritingBiddingDocRequest(TeaModel):
    def __init__(
        self,
        company_keyword: str = None,
        prompt: str = None,
        task_id: str = None,
        workspace_id: str = None,
    ):
        self.company_keyword = company_keyword
        self.prompt = prompt
        self.task_id = task_id
        self.workspace_id = workspace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.company_keyword is not None:
            result['CompanyKeyword'] = self.company_keyword
        if self.prompt is not None:
            result['Prompt'] = self.prompt
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CompanyKeyword') is not None:
            self.company_keyword = m.get('CompanyKeyword')
        if m.get('Prompt') is not None:
            self.prompt = m.get('Prompt')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        return self


class AsyncWritingBiddingDocResponseBodyData(TeaModel):
    def __init__(
        self,
        task_id: str = None,
    ):
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class AsyncWritingBiddingDocResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: AsyncWritingBiddingDocResponseBodyData = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        # Id of the request
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = AsyncWritingBiddingDocResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class AsyncWritingBiddingDocResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AsyncWritingBiddingDocResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AsyncWritingBiddingDocResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CancelAsyncTaskRequest(TeaModel):
    def __init__(
        self,
        agent_key: str = None,
        task_id: str = None,
    ):
        # This parameter is required.
        self.agent_key = agent_key
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_key is not None:
            result['AgentKey'] = self.agent_key
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentKey') is not None:
            self.agent_key = m.get('AgentKey')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class CancelAsyncTaskResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: bool = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CancelAsyncTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CancelAsyncTaskResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CancelAsyncTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CancelAuditTaskRequest(TeaModel):
    def __init__(
        self,
        article_id: str = None,
        content_audit_task_id: str = None,
        workspace_id: str = None,
    ):
        self.article_id = article_id
        self.content_audit_task_id = content_audit_task_id
        self.workspace_id = workspace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.article_id is not None:
            result['ArticleId'] = self.article_id
        if self.content_audit_task_id is not None:
            result['ContentAuditTaskId'] = self.content_audit_task_id
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ArticleId') is not None:
            self.article_id = m.get('ArticleId')
        if m.get('ContentAuditTaskId') is not None:
            self.content_audit_task_id = m.get('ContentAuditTaskId')
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        return self


class CancelAuditTaskResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: bool = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        # Id of the request
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CancelAuditTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CancelAuditTaskResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CancelAuditTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CancelDeepWriteTaskRequest(TeaModel):
    def __init__(
        self,
        task_id: str = None,
        workspace_id: str = None,
    ):
        self.task_id = task_id
        self.workspace_id = workspace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        return self


class CancelDeepWriteTaskResponseBodyData(TeaModel):
    def __init__(
        self,
        input: str = None,
        status: str = None,
        task_id: str = None,
    ):
        self.input = input
        self.status = status
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.input is not None:
            result['Input'] = self.input
        if self.status is not None:
            result['Status'] = self.status
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Input') is not None:
            self.input = m.get('Input')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class CancelDeepWriteTaskResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: CancelDeepWriteTaskResponseBodyData = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        # Id of the request
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = CancelDeepWriteTaskResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CancelDeepWriteTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CancelDeepWriteTaskResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CancelDeepWriteTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ClearIntervenesRequest(TeaModel):
    def __init__(
        self,
        agent_key: str = None,
    ):
        # This parameter is required.
        self.agent_key = agent_key

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_key is not None:
            result['AgentKey'] = self.agent_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentKey') is not None:
            self.agent_key = m.get('AgentKey')
        return self


class ClearIntervenesResponseBodyData(TeaModel):
    def __init__(
        self,
        code: int = None,
        fail_id_list: List[str] = None,
        task_id: str = None,
    ):
        self.code = code
        self.fail_id_list = fail_id_list
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.fail_id_list is not None:
            result['FailIdList'] = self.fail_id_list
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('FailIdList') is not None:
            self.fail_id_list = m.get('FailIdList')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class ClearIntervenesResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: ClearIntervenesResponseBodyData = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = ClearIntervenesResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ClearIntervenesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ClearIntervenesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ClearIntervenesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ConfirmAndPostProcessAuditNoteRequest(TeaModel):
    def __init__(
        self,
        task_id: str = None,
        workspace_id: str = None,
    ):
        # This parameter is required.
        self.task_id = task_id
        # This parameter is required.
        self.workspace_id = workspace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        return self


class ConfirmAndPostProcessAuditNoteResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: str = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        # Id of the request
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ConfirmAndPostProcessAuditNoteResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ConfirmAndPostProcessAuditNoteResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ConfirmAndPostProcessAuditNoteResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDatasetRequestDatasetConfigSearchSourceConfigsSearchSourceRequestConfigHeaders(TeaModel):
    def __init__(
        self,
        name: str = None,
        value: str = None,
        value_format: str = None,
        value_type: str = None,
    ):
        self.name = name
        self.value = value
        self.value_format = value_format
        self.value_type = value_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.value is not None:
            result['Value'] = self.value
        if self.value_format is not None:
            result['ValueFormat'] = self.value_format
        if self.value_type is not None:
            result['ValueType'] = self.value_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        if m.get('ValueFormat') is not None:
            self.value_format = m.get('ValueFormat')
        if m.get('ValueType') is not None:
            self.value_type = m.get('ValueType')
        return self


class CreateDatasetRequestDatasetConfigSearchSourceConfigsSearchSourceRequestConfigParams(TeaModel):
    def __init__(
        self,
        name: str = None,
        value: str = None,
        value_format: str = None,
        value_type: str = None,
    ):
        self.name = name
        self.value = value
        self.value_format = value_format
        self.value_type = value_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.value is not None:
            result['Value'] = self.value
        if self.value_format is not None:
            result['ValueFormat'] = self.value_format
        if self.value_type is not None:
            result['ValueType'] = self.value_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        if m.get('ValueFormat') is not None:
            self.value_format = m.get('ValueFormat')
        if m.get('ValueType') is not None:
            self.value_type = m.get('ValueType')
        return self


class CreateDatasetRequestDatasetConfigSearchSourceConfigsSearchSourceRequestConfig(TeaModel):
    def __init__(
        self,
        body: str = None,
        connect_timeout: int = None,
        headers: List[CreateDatasetRequestDatasetConfigSearchSourceConfigsSearchSourceRequestConfigHeaders] = None,
        method: str = None,
        params: List[CreateDatasetRequestDatasetConfigSearchSourceConfigsSearchSourceRequestConfigParams] = None,
        path_params_enable: bool = None,
        socket_timeout: int = None,
        url: str = None,
    ):
        self.body = body
        self.connect_timeout = connect_timeout
        self.headers = headers
        self.method = method
        self.params = params
        self.path_params_enable = path_params_enable
        self.socket_timeout = socket_timeout
        self.url = url

    def validate(self):
        if self.headers:
            for k in self.headers:
                if k:
                    k.validate()
        if self.params:
            for k in self.params:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.body is not None:
            result['Body'] = self.body
        if self.connect_timeout is not None:
            result['ConnectTimeout'] = self.connect_timeout
        result['Headers'] = []
        if self.headers is not None:
            for k in self.headers:
                result['Headers'].append(k.to_map() if k else None)
        if self.method is not None:
            result['Method'] = self.method
        result['Params'] = []
        if self.params is not None:
            for k in self.params:
                result['Params'].append(k.to_map() if k else None)
        if self.path_params_enable is not None:
            result['PathParamsEnable'] = self.path_params_enable
        if self.socket_timeout is not None:
            result['SocketTimeout'] = self.socket_timeout
        if self.url is not None:
            result['Url'] = self.url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Body') is not None:
            self.body = m.get('Body')
        if m.get('ConnectTimeout') is not None:
            self.connect_timeout = m.get('ConnectTimeout')
        self.headers = []
        if m.get('Headers') is not None:
            for k in m.get('Headers'):
                temp_model = CreateDatasetRequestDatasetConfigSearchSourceConfigsSearchSourceRequestConfigHeaders()
                self.headers.append(temp_model.from_map(k))
        if m.get('Method') is not None:
            self.method = m.get('Method')
        self.params = []
        if m.get('Params') is not None:
            for k in m.get('Params'):
                temp_model = CreateDatasetRequestDatasetConfigSearchSourceConfigsSearchSourceRequestConfigParams()
                self.params.append(temp_model.from_map(k))
        if m.get('PathParamsEnable') is not None:
            self.path_params_enable = m.get('PathParamsEnable')
        if m.get('SocketTimeout') is not None:
            self.socket_timeout = m.get('SocketTimeout')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        return self


class CreateDatasetRequestDatasetConfigSearchSourceConfigsSearchSourceResponseConfigJqNodesJqNodesJqNodes(TeaModel):
    def __init__(
        self,
        key: str = None,
        path: str = None,
        type: str = None,
    ):
        self.key = key
        self.path = path
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.path is not None:
            result['Path'] = self.path
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Path') is not None:
            self.path = m.get('Path')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class CreateDatasetRequestDatasetConfigSearchSourceConfigsSearchSourceResponseConfigJqNodesJqNodes(TeaModel):
    def __init__(
        self,
        jq_nodes: List[CreateDatasetRequestDatasetConfigSearchSourceConfigsSearchSourceResponseConfigJqNodesJqNodesJqNodes] = None,
        key: str = None,
        path: str = None,
        type: str = None,
    ):
        self.jq_nodes = jq_nodes
        self.key = key
        self.path = path
        self.type = type

    def validate(self):
        if self.jq_nodes:
            for k in self.jq_nodes:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['JqNodes'] = []
        if self.jq_nodes is not None:
            for k in self.jq_nodes:
                result['JqNodes'].append(k.to_map() if k else None)
        if self.key is not None:
            result['Key'] = self.key
        if self.path is not None:
            result['Path'] = self.path
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.jq_nodes = []
        if m.get('JqNodes') is not None:
            for k in m.get('JqNodes'):
                temp_model = CreateDatasetRequestDatasetConfigSearchSourceConfigsSearchSourceResponseConfigJqNodesJqNodesJqNodes()
                self.jq_nodes.append(temp_model.from_map(k))
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Path') is not None:
            self.path = m.get('Path')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class CreateDatasetRequestDatasetConfigSearchSourceConfigsSearchSourceResponseConfigJqNodes(TeaModel):
    def __init__(
        self,
        jq_nodes: List[CreateDatasetRequestDatasetConfigSearchSourceConfigsSearchSourceResponseConfigJqNodesJqNodes] = None,
        key: str = None,
        path: str = None,
        type: str = None,
    ):
        self.jq_nodes = jq_nodes
        self.key = key
        self.path = path
        self.type = type

    def validate(self):
        if self.jq_nodes:
            for k in self.jq_nodes:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['JqNodes'] = []
        if self.jq_nodes is not None:
            for k in self.jq_nodes:
                result['JqNodes'].append(k.to_map() if k else None)
        if self.key is not None:
            result['Key'] = self.key
        if self.path is not None:
            result['Path'] = self.path
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.jq_nodes = []
        if m.get('JqNodes') is not None:
            for k in m.get('JqNodes'):
                temp_model = CreateDatasetRequestDatasetConfigSearchSourceConfigsSearchSourceResponseConfigJqNodesJqNodes()
                self.jq_nodes.append(temp_model.from_map(k))
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Path') is not None:
            self.path = m.get('Path')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class CreateDatasetRequestDatasetConfigSearchSourceConfigsSearchSourceResponseConfig(TeaModel):
    def __init__(
        self,
        jq_nodes: List[CreateDatasetRequestDatasetConfigSearchSourceConfigsSearchSourceResponseConfigJqNodes] = None,
    ):
        self.jq_nodes = jq_nodes

    def validate(self):
        if self.jq_nodes:
            for k in self.jq_nodes:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['JqNodes'] = []
        if self.jq_nodes is not None:
            for k in self.jq_nodes:
                result['JqNodes'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.jq_nodes = []
        if m.get('JqNodes') is not None:
            for k in m.get('JqNodes'):
                temp_model = CreateDatasetRequestDatasetConfigSearchSourceConfigsSearchSourceResponseConfigJqNodes()
                self.jq_nodes.append(temp_model.from_map(k))
        return self


class CreateDatasetRequestDatasetConfigSearchSourceConfigs(TeaModel):
    def __init__(
        self,
        demo_query: str = None,
        search_source_request_config: CreateDatasetRequestDatasetConfigSearchSourceConfigsSearchSourceRequestConfig = None,
        search_source_response_config: CreateDatasetRequestDatasetConfigSearchSourceConfigsSearchSourceResponseConfig = None,
        size: int = None,
    ):
        self.demo_query = demo_query
        self.search_source_request_config = search_source_request_config
        self.search_source_response_config = search_source_response_config
        self.size = size

    def validate(self):
        if self.search_source_request_config:
            self.search_source_request_config.validate()
        if self.search_source_response_config:
            self.search_source_response_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.demo_query is not None:
            result['DemoQuery'] = self.demo_query
        if self.search_source_request_config is not None:
            result['SearchSourceRequestConfig'] = self.search_source_request_config.to_map()
        if self.search_source_response_config is not None:
            result['SearchSourceResponseConfig'] = self.search_source_response_config.to_map()
        if self.size is not None:
            result['Size'] = self.size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DemoQuery') is not None:
            self.demo_query = m.get('DemoQuery')
        if m.get('SearchSourceRequestConfig') is not None:
            temp_model = CreateDatasetRequestDatasetConfigSearchSourceConfigsSearchSourceRequestConfig()
            self.search_source_request_config = temp_model.from_map(m['SearchSourceRequestConfig'])
        if m.get('SearchSourceResponseConfig') is not None:
            temp_model = CreateDatasetRequestDatasetConfigSearchSourceConfigsSearchSourceResponseConfig()
            self.search_source_response_config = temp_model.from_map(m['SearchSourceResponseConfig'])
        if m.get('Size') is not None:
            self.size = m.get('Size')
        return self


class CreateDatasetRequestDatasetConfig(TeaModel):
    def __init__(
        self,
        search_source_configs: List[CreateDatasetRequestDatasetConfigSearchSourceConfigs] = None,
    ):
        self.search_source_configs = search_source_configs

    def validate(self):
        if self.search_source_configs:
            for k in self.search_source_configs:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['SearchSourceConfigs'] = []
        if self.search_source_configs is not None:
            for k in self.search_source_configs:
                result['SearchSourceConfigs'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.search_source_configs = []
        if m.get('SearchSourceConfigs') is not None:
            for k in m.get('SearchSourceConfigs'):
                temp_model = CreateDatasetRequestDatasetConfigSearchSourceConfigs()
                self.search_source_configs.append(temp_model.from_map(k))
        return self


class CreateDatasetRequestDocumentHandleConfig(TeaModel):
    def __init__(
        self,
        disable_handle_multimodal_media: bool = None,
    ):
        self.disable_handle_multimodal_media = disable_handle_multimodal_media

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.disable_handle_multimodal_media is not None:
            result['DisableHandleMultimodalMedia'] = self.disable_handle_multimodal_media
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DisableHandleMultimodalMedia') is not None:
            self.disable_handle_multimodal_media = m.get('DisableHandleMultimodalMedia')
        return self


class CreateDatasetRequest(TeaModel):
    def __init__(
        self,
        dataset_config: CreateDatasetRequestDatasetConfig = None,
        dataset_description: str = None,
        dataset_name: str = None,
        dataset_type: str = None,
        document_handle_config: CreateDatasetRequestDocumentHandleConfig = None,
        invoke_type: str = None,
        search_dataset_enable: int = None,
        workspace_id: str = None,
    ):
        self.dataset_config = dataset_config
        self.dataset_description = dataset_description
        # This parameter is required.
        self.dataset_name = dataset_name
        self.dataset_type = dataset_type
        self.document_handle_config = document_handle_config
        self.invoke_type = invoke_type
        self.search_dataset_enable = search_dataset_enable
        # This parameter is required.
        self.workspace_id = workspace_id

    def validate(self):
        if self.dataset_config:
            self.dataset_config.validate()
        if self.document_handle_config:
            self.document_handle_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dataset_config is not None:
            result['DatasetConfig'] = self.dataset_config.to_map()
        if self.dataset_description is not None:
            result['DatasetDescription'] = self.dataset_description
        if self.dataset_name is not None:
            result['DatasetName'] = self.dataset_name
        if self.dataset_type is not None:
            result['DatasetType'] = self.dataset_type
        if self.document_handle_config is not None:
            result['DocumentHandleConfig'] = self.document_handle_config.to_map()
        if self.invoke_type is not None:
            result['InvokeType'] = self.invoke_type
        if self.search_dataset_enable is not None:
            result['SearchDatasetEnable'] = self.search_dataset_enable
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DatasetConfig') is not None:
            temp_model = CreateDatasetRequestDatasetConfig()
            self.dataset_config = temp_model.from_map(m['DatasetConfig'])
        if m.get('DatasetDescription') is not None:
            self.dataset_description = m.get('DatasetDescription')
        if m.get('DatasetName') is not None:
            self.dataset_name = m.get('DatasetName')
        if m.get('DatasetType') is not None:
            self.dataset_type = m.get('DatasetType')
        if m.get('DocumentHandleConfig') is not None:
            temp_model = CreateDatasetRequestDocumentHandleConfig()
            self.document_handle_config = temp_model.from_map(m['DocumentHandleConfig'])
        if m.get('InvokeType') is not None:
            self.invoke_type = m.get('InvokeType')
        if m.get('SearchDatasetEnable') is not None:
            self.search_dataset_enable = m.get('SearchDatasetEnable')
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        return self


class CreateDatasetShrinkRequest(TeaModel):
    def __init__(
        self,
        dataset_config_shrink: str = None,
        dataset_description: str = None,
        dataset_name: str = None,
        dataset_type: str = None,
        document_handle_config_shrink: str = None,
        invoke_type: str = None,
        search_dataset_enable: int = None,
        workspace_id: str = None,
    ):
        self.dataset_config_shrink = dataset_config_shrink
        self.dataset_description = dataset_description
        # This parameter is required.
        self.dataset_name = dataset_name
        self.dataset_type = dataset_type
        self.document_handle_config_shrink = document_handle_config_shrink
        self.invoke_type = invoke_type
        self.search_dataset_enable = search_dataset_enable
        # This parameter is required.
        self.workspace_id = workspace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dataset_config_shrink is not None:
            result['DatasetConfig'] = self.dataset_config_shrink
        if self.dataset_description is not None:
            result['DatasetDescription'] = self.dataset_description
        if self.dataset_name is not None:
            result['DatasetName'] = self.dataset_name
        if self.dataset_type is not None:
            result['DatasetType'] = self.dataset_type
        if self.document_handle_config_shrink is not None:
            result['DocumentHandleConfig'] = self.document_handle_config_shrink
        if self.invoke_type is not None:
            result['InvokeType'] = self.invoke_type
        if self.search_dataset_enable is not None:
            result['SearchDatasetEnable'] = self.search_dataset_enable
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DatasetConfig') is not None:
            self.dataset_config_shrink = m.get('DatasetConfig')
        if m.get('DatasetDescription') is not None:
            self.dataset_description = m.get('DatasetDescription')
        if m.get('DatasetName') is not None:
            self.dataset_name = m.get('DatasetName')
        if m.get('DatasetType') is not None:
            self.dataset_type = m.get('DatasetType')
        if m.get('DocumentHandleConfig') is not None:
            self.document_handle_config_shrink = m.get('DocumentHandleConfig')
        if m.get('InvokeType') is not None:
            self.invoke_type = m.get('InvokeType')
        if m.get('SearchDatasetEnable') is not None:
            self.search_dataset_enable = m.get('SearchDatasetEnable')
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        return self


class CreateDatasetResponseBodyData(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        create_user: str = None,
        dataset_description: str = None,
        dataset_id: int = None,
        dataset_name: str = None,
        dataset_type: str = None,
        search_dataset_enable: int = None,
    ):
        self.create_time = create_time
        self.create_user = create_user
        self.dataset_description = dataset_description
        self.dataset_id = dataset_id
        self.dataset_name = dataset_name
        self.dataset_type = dataset_type
        self.search_dataset_enable = search_dataset_enable

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.create_user is not None:
            result['CreateUser'] = self.create_user
        if self.dataset_description is not None:
            result['DatasetDescription'] = self.dataset_description
        if self.dataset_id is not None:
            result['DatasetId'] = self.dataset_id
        if self.dataset_name is not None:
            result['DatasetName'] = self.dataset_name
        if self.dataset_type is not None:
            result['DatasetType'] = self.dataset_type
        if self.search_dataset_enable is not None:
            result['SearchDatasetEnable'] = self.search_dataset_enable
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('CreateUser') is not None:
            self.create_user = m.get('CreateUser')
        if m.get('DatasetDescription') is not None:
            self.dataset_description = m.get('DatasetDescription')
        if m.get('DatasetId') is not None:
            self.dataset_id = m.get('DatasetId')
        if m.get('DatasetName') is not None:
            self.dataset_name = m.get('DatasetName')
        if m.get('DatasetType') is not None:
            self.dataset_type = m.get('DatasetType')
        if m.get('SearchDatasetEnable') is not None:
            self.search_dataset_enable = m.get('SearchDatasetEnable')
        return self


class CreateDatasetResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: CreateDatasetResponseBodyData = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = CreateDatasetResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateDatasetResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateDatasetResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateDatasetResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateGeneratedContentRequest(TeaModel):
    def __init__(
        self,
        agent_key: str = None,
        content: str = None,
        content_domain: str = None,
        content_text: str = None,
        keywords: List[str] = None,
        prompt: str = None,
        task_id: str = None,
        title: str = None,
        uuid: str = None,
    ):
        # This parameter is required.
        self.agent_key = agent_key
        # This parameter is required.
        self.content = content
        self.content_domain = content_domain
        self.content_text = content_text
        self.keywords = keywords
        self.prompt = prompt
        # This parameter is required.
        self.task_id = task_id
        # This parameter is required.
        self.title = title
        self.uuid = uuid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_key is not None:
            result['AgentKey'] = self.agent_key
        if self.content is not None:
            result['Content'] = self.content
        if self.content_domain is not None:
            result['ContentDomain'] = self.content_domain
        if self.content_text is not None:
            result['ContentText'] = self.content_text
        if self.keywords is not None:
            result['Keywords'] = self.keywords
        if self.prompt is not None:
            result['Prompt'] = self.prompt
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.title is not None:
            result['Title'] = self.title
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentKey') is not None:
            self.agent_key = m.get('AgentKey')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('ContentDomain') is not None:
            self.content_domain = m.get('ContentDomain')
        if m.get('ContentText') is not None:
            self.content_text = m.get('ContentText')
        if m.get('Keywords') is not None:
            self.keywords = m.get('Keywords')
        if m.get('Prompt') is not None:
            self.prompt = m.get('Prompt')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class CreateGeneratedContentShrinkRequest(TeaModel):
    def __init__(
        self,
        agent_key: str = None,
        content: str = None,
        content_domain: str = None,
        content_text: str = None,
        keywords_shrink: str = None,
        prompt: str = None,
        task_id: str = None,
        title: str = None,
        uuid: str = None,
    ):
        # This parameter is required.
        self.agent_key = agent_key
        # This parameter is required.
        self.content = content
        self.content_domain = content_domain
        self.content_text = content_text
        self.keywords_shrink = keywords_shrink
        self.prompt = prompt
        # This parameter is required.
        self.task_id = task_id
        # This parameter is required.
        self.title = title
        self.uuid = uuid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_key is not None:
            result['AgentKey'] = self.agent_key
        if self.content is not None:
            result['Content'] = self.content
        if self.content_domain is not None:
            result['ContentDomain'] = self.content_domain
        if self.content_text is not None:
            result['ContentText'] = self.content_text
        if self.keywords_shrink is not None:
            result['Keywords'] = self.keywords_shrink
        if self.prompt is not None:
            result['Prompt'] = self.prompt
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.title is not None:
            result['Title'] = self.title
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentKey') is not None:
            self.agent_key = m.get('AgentKey')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('ContentDomain') is not None:
            self.content_domain = m.get('ContentDomain')
        if m.get('ContentText') is not None:
            self.content_text = m.get('ContentText')
        if m.get('Keywords') is not None:
            self.keywords_shrink = m.get('Keywords')
        if m.get('Prompt') is not None:
            self.prompt = m.get('Prompt')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class CreateGeneratedContentResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: int = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateGeneratedContentResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateGeneratedContentResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateGeneratedContentResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateTokenRequest(TeaModel):
    def __init__(
        self,
        agent_key: str = None,
    ):
        # This parameter is required.
        self.agent_key = agent_key

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_key is not None:
            result['AgentKey'] = self.agent_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentKey') is not None:
            self.agent_key = m.get('AgentKey')
        return self


class CreateTokenResponseBodyData(TeaModel):
    def __init__(
        self,
        expired_time: int = None,
        token: str = None,
    ):
        self.expired_time = expired_time
        self.token = token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.expired_time is not None:
            result['ExpiredTime'] = self.expired_time
        if self.token is not None:
            result['Token'] = self.token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExpiredTime') is not None:
            self.expired_time = m.get('ExpiredTime')
        if m.get('Token') is not None:
            self.token = m.get('Token')
        return self


class CreateTokenResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: CreateTokenResponseBodyData = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = CreateTokenResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateTokenResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateTokenResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateTokenResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteAuditNoteRequest(TeaModel):
    def __init__(
        self,
        workspace_id: str = None,
    ):
        # This parameter is required.
        self.workspace_id = workspace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        return self


class DeleteAuditNoteResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: str = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        # Id of the request
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteAuditNoteResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteAuditNoteResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteAuditNoteResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteAuditTermsRequest(TeaModel):
    def __init__(
        self,
        id_list: List[int] = None,
        workspace_id: str = None,
    ):
        self.id_list = id_list
        # This parameter is required.
        self.workspace_id = workspace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id_list is not None:
            result['IdList'] = self.id_list
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IdList') is not None:
            self.id_list = m.get('IdList')
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        return self


class DeleteAuditTermsShrinkRequest(TeaModel):
    def __init__(
        self,
        id_list_shrink: str = None,
        workspace_id: str = None,
    ):
        self.id_list_shrink = id_list_shrink
        # This parameter is required.
        self.workspace_id = workspace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id_list_shrink is not None:
            result['IdList'] = self.id_list_shrink
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IdList') is not None:
            self.id_list_shrink = m.get('IdList')
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        return self


class DeleteAuditTermsResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: bool = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        # Id of the request
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteAuditTermsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteAuditTermsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteAuditTermsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteCustomTextRequest(TeaModel):
    def __init__(
        self,
        agent_key: str = None,
        commodity_code: str = None,
        id: int = None,
    ):
        # This parameter is required.
        self.agent_key = agent_key
        self.commodity_code = commodity_code
        # This parameter is required.
        self.id = id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_key is not None:
            result['AgentKey'] = self.agent_key
        if self.commodity_code is not None:
            result['CommodityCode'] = self.commodity_code
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentKey') is not None:
            self.agent_key = m.get('AgentKey')
        if m.get('CommodityCode') is not None:
            self.commodity_code = m.get('CommodityCode')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class DeleteCustomTextResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: bool = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteCustomTextResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteCustomTextResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteCustomTextResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteCustomTopicByTopicRequest(TeaModel):
    def __init__(
        self,
        agent_key: str = None,
        topic: str = None,
    ):
        # This parameter is required.
        self.agent_key = agent_key
        # This parameter is required.
        self.topic = topic

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_key is not None:
            result['AgentKey'] = self.agent_key
        if self.topic is not None:
            result['Topic'] = self.topic
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentKey') is not None:
            self.agent_key = m.get('AgentKey')
        if m.get('Topic') is not None:
            self.topic = m.get('Topic')
        return self


class DeleteCustomTopicByTopicResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: int = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteCustomTopicByTopicResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteCustomTopicByTopicResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteCustomTopicByTopicResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteCustomTopicViewPointByIdRequest(TeaModel):
    def __init__(
        self,
        agent_key: str = None,
        custom_view_point_id: str = None,
    ):
        # This parameter is required.
        self.agent_key = agent_key
        # This parameter is required.
        self.custom_view_point_id = custom_view_point_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_key is not None:
            result['AgentKey'] = self.agent_key
        if self.custom_view_point_id is not None:
            result['CustomViewPointId'] = self.custom_view_point_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentKey') is not None:
            self.agent_key = m.get('AgentKey')
        if m.get('CustomViewPointId') is not None:
            self.custom_view_point_id = m.get('CustomViewPointId')
        return self


class DeleteCustomTopicViewPointByIdResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: int = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteCustomTopicViewPointByIdResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteCustomTopicViewPointByIdResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteCustomTopicViewPointByIdResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDatasetRequest(TeaModel):
    def __init__(
        self,
        dataset_id: int = None,
        workspace_id: str = None,
    ):
        # This parameter is required.
        self.dataset_id = dataset_id
        # This parameter is required.
        self.workspace_id = workspace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dataset_id is not None:
            result['DatasetId'] = self.dataset_id
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DatasetId') is not None:
            self.dataset_id = m.get('DatasetId')
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        return self


class DeleteDatasetResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.http_status_code = http_status_code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteDatasetResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteDatasetResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteDatasetResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDatasetDocumentRequest(TeaModel):
    def __init__(
        self,
        dataset_id: int = None,
        dataset_name: str = None,
        doc_id: str = None,
        doc_uuid: str = None,
        workspace_id: str = None,
    ):
        self.dataset_id = dataset_id
        self.dataset_name = dataset_name
        self.doc_id = doc_id
        self.doc_uuid = doc_uuid
        # This parameter is required.
        self.workspace_id = workspace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dataset_id is not None:
            result['DatasetId'] = self.dataset_id
        if self.dataset_name is not None:
            result['DatasetName'] = self.dataset_name
        if self.doc_id is not None:
            result['DocId'] = self.doc_id
        if self.doc_uuid is not None:
            result['DocUuid'] = self.doc_uuid
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DatasetId') is not None:
            self.dataset_id = m.get('DatasetId')
        if m.get('DatasetName') is not None:
            self.dataset_name = m.get('DatasetName')
        if m.get('DocId') is not None:
            self.doc_id = m.get('DocId')
        if m.get('DocUuid') is not None:
            self.doc_uuid = m.get('DocUuid')
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        return self


class DeleteDatasetDocumentResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: List[str] = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteDatasetDocumentResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteDatasetDocumentResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteDatasetDocumentResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDocsRequest(TeaModel):
    def __init__(
        self,
        doc_ids: List[str] = None,
        workspace_id: str = None,
    ):
        # This parameter is required.
        self.doc_ids = doc_ids
        # This parameter is required.
        self.workspace_id = workspace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.doc_ids is not None:
            result['DocIds'] = self.doc_ids
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DocIds') is not None:
            self.doc_ids = m.get('DocIds')
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        return self


class DeleteDocsShrinkRequest(TeaModel):
    def __init__(
        self,
        doc_ids_shrink: str = None,
        workspace_id: str = None,
    ):
        # This parameter is required.
        self.doc_ids_shrink = doc_ids_shrink
        # This parameter is required.
        self.workspace_id = workspace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.doc_ids_shrink is not None:
            result['DocIds'] = self.doc_ids_shrink
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DocIds') is not None:
            self.doc_ids_shrink = m.get('DocIds')
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        return self


class DeleteDocsResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.http_status_code = http_status_code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteDocsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteDocsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteDocsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteFactAuditUrlRequest(TeaModel):
    def __init__(
        self,
        url: str = None,
        workspace_id: str = None,
    ):
        # This parameter is required.
        self.url = url
        # This parameter is required.
        self.workspace_id = workspace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.url is not None:
            result['Url'] = self.url
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Url') is not None:
            self.url = m.get('Url')
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        return self


class DeleteFactAuditUrlResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: str = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        # Id of the request
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteFactAuditUrlResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteFactAuditUrlResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteFactAuditUrlResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteGeneratedContentRequest(TeaModel):
    def __init__(
        self,
        agent_key: str = None,
        id: int = None,
        region_id: str = None,
    ):
        # This parameter is required.
        self.agent_key = agent_key
        # This parameter is required.
        self.id = id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_key is not None:
            result['AgentKey'] = self.agent_key
        if self.id is not None:
            result['Id'] = self.id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentKey') is not None:
            self.agent_key = m.get('AgentKey')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteGeneratedContentResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: bool = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteGeneratedContentResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteGeneratedContentResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteGeneratedContentResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteInterveneRuleRequest(TeaModel):
    def __init__(
        self,
        agent_key: str = None,
        rule_id: int = None,
    ):
        # This parameter is required.
        self.agent_key = agent_key
        self.rule_id = rule_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_key is not None:
            result['AgentKey'] = self.agent_key
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentKey') is not None:
            self.agent_key = m.get('AgentKey')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class DeleteInterveneRuleResponseBodyData(TeaModel):
    def __init__(
        self,
        code: int = None,
        fail_id_list: List[str] = None,
        task_id: str = None,
    ):
        self.code = code
        self.fail_id_list = fail_id_list
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.fail_id_list is not None:
            result['FailIdList'] = self.fail_id_list
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('FailIdList') is not None:
            self.fail_id_list = m.get('FailIdList')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class DeleteInterveneRuleResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: DeleteInterveneRuleResponseBodyData = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = DeleteInterveneRuleResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteInterveneRuleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteInterveneRuleResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteInterveneRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteMaterialByIdRequest(TeaModel):
    def __init__(
        self,
        agent_key: str = None,
        id: int = None,
    ):
        # This parameter is required.
        self.agent_key = agent_key
        # This parameter is required.
        self.id = id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_key is not None:
            result['AgentKey'] = self.agent_key
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentKey') is not None:
            self.agent_key = m.get('AgentKey')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class DeleteMaterialByIdResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: bool = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteMaterialByIdResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteMaterialByIdResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteMaterialByIdResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteStyleLearningResultRequest(TeaModel):
    def __init__(
        self,
        agent_key: str = None,
        id: int = None,
    ):
        # This parameter is required.
        self.agent_key = agent_key
        # This parameter is required.
        self.id = id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_key is not None:
            result['AgentKey'] = self.agent_key
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentKey') is not None:
            self.agent_key = m.get('AgentKey')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class DeleteStyleLearningResultResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: bool = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteStyleLearningResultResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteStyleLearningResultResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteStyleLearningResultResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DocumentExtractionRequest(TeaModel):
    def __init__(
        self,
        agent_key: str = None,
        urls: List[str] = None,
    ):
        # This parameter is required.
        self.agent_key = agent_key
        # This parameter is required.
        self.urls = urls

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_key is not None:
            result['AgentKey'] = self.agent_key
        if self.urls is not None:
            result['Urls'] = self.urls
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentKey') is not None:
            self.agent_key = m.get('AgentKey')
        if m.get('Urls') is not None:
            self.urls = m.get('Urls')
        return self


class DocumentExtractionShrinkRequest(TeaModel):
    def __init__(
        self,
        agent_key: str = None,
        urls_shrink: str = None,
    ):
        # This parameter is required.
        self.agent_key = agent_key
        # This parameter is required.
        self.urls_shrink = urls_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_key is not None:
            result['AgentKey'] = self.agent_key
        if self.urls_shrink is not None:
            result['Urls'] = self.urls_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentKey') is not None:
            self.agent_key = m.get('AgentKey')
        if m.get('Urls') is not None:
            self.urls_shrink = m.get('Urls')
        return self


class DocumentExtractionResponseBodyData(TeaModel):
    def __init__(
        self,
        author: str = None,
        content: str = None,
        doc_id: str = None,
        doc_uuid: str = None,
        pub_time: str = None,
        source: str = None,
        summary: str = None,
        tag: str = None,
        title: str = None,
        url: str = None,
    ):
        self.author = author
        self.content = content
        self.doc_id = doc_id
        self.doc_uuid = doc_uuid
        self.pub_time = pub_time
        self.source = source
        self.summary = summary
        self.tag = tag
        self.title = title
        self.url = url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.author is not None:
            result['Author'] = self.author
        if self.content is not None:
            result['Content'] = self.content
        if self.doc_id is not None:
            result['DocId'] = self.doc_id
        if self.doc_uuid is not None:
            result['DocUuid'] = self.doc_uuid
        if self.pub_time is not None:
            result['PubTime'] = self.pub_time
        if self.source is not None:
            result['Source'] = self.source
        if self.summary is not None:
            result['Summary'] = self.summary
        if self.tag is not None:
            result['Tag'] = self.tag
        if self.title is not None:
            result['Title'] = self.title
        if self.url is not None:
            result['Url'] = self.url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Author') is not None:
            self.author = m.get('Author')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('DocId') is not None:
            self.doc_id = m.get('DocId')
        if m.get('DocUuid') is not None:
            self.doc_uuid = m.get('DocUuid')
        if m.get('PubTime') is not None:
            self.pub_time = m.get('PubTime')
        if m.get('Source') is not None:
            self.source = m.get('Source')
        if m.get('Summary') is not None:
            self.summary = m.get('Summary')
        if m.get('Tag') is not None:
            self.tag = m.get('Tag')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        return self


class DocumentExtractionResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: List[DocumentExtractionResponseBodyData] = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = DocumentExtractionResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DocumentExtractionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DocumentExtractionResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DocumentExtractionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DownloadAuditNoteRequest(TeaModel):
    def __init__(
        self,
        task_id: str = None,
        workspace_id: str = None,
    ):
        self.task_id = task_id
        # This parameter is required.
        self.workspace_id = workspace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        return self


class DownloadAuditNoteResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: str = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        # Id of the request
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DownloadAuditNoteResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DownloadAuditNoteResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DownloadAuditNoteResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DownloadBiddingDocRequest(TeaModel):
    def __init__(
        self,
        task_id: str = None,
        workspace_id: str = None,
    ):
        self.task_id = task_id
        self.workspace_id = workspace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        return self


class DownloadBiddingDocResponseBodyData(TeaModel):
    def __init__(
        self,
        task_id: str = None,
        url: str = None,
    ):
        self.task_id = task_id
        self.url = url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.url is not None:
            result['Url'] = self.url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        return self


class DownloadBiddingDocResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: DownloadBiddingDocResponseBodyData = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        # Id of the request
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = DownloadBiddingDocResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DownloadBiddingDocResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DownloadBiddingDocResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DownloadBiddingDocResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class EditAuditTermsRequest(TeaModel):
    def __init__(
        self,
        exception_word: List[str] = None,
        id: str = None,
        keyword: str = None,
        suggest_word: str = None,
        terms_desc: str = None,
        workspace_id: str = None,
    ):
        self.exception_word = exception_word
        self.id = id
        self.keyword = keyword
        self.suggest_word = suggest_word
        self.terms_desc = terms_desc
        # This parameter is required.
        self.workspace_id = workspace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.exception_word is not None:
            result['ExceptionWord'] = self.exception_word
        if self.id is not None:
            result['Id'] = self.id
        if self.keyword is not None:
            result['Keyword'] = self.keyword
        if self.suggest_word is not None:
            result['SuggestWord'] = self.suggest_word
        if self.terms_desc is not None:
            result['TermsDesc'] = self.terms_desc
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExceptionWord') is not None:
            self.exception_word = m.get('ExceptionWord')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Keyword') is not None:
            self.keyword = m.get('Keyword')
        if m.get('SuggestWord') is not None:
            self.suggest_word = m.get('SuggestWord')
        if m.get('TermsDesc') is not None:
            self.terms_desc = m.get('TermsDesc')
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        return self


class EditAuditTermsShrinkRequest(TeaModel):
    def __init__(
        self,
        exception_word_shrink: str = None,
        id: str = None,
        keyword: str = None,
        suggest_word: str = None,
        terms_desc: str = None,
        workspace_id: str = None,
    ):
        self.exception_word_shrink = exception_word_shrink
        self.id = id
        self.keyword = keyword
        self.suggest_word = suggest_word
        self.terms_desc = terms_desc
        # This parameter is required.
        self.workspace_id = workspace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.exception_word_shrink is not None:
            result['ExceptionWord'] = self.exception_word_shrink
        if self.id is not None:
            result['Id'] = self.id
        if self.keyword is not None:
            result['Keyword'] = self.keyword
        if self.suggest_word is not None:
            result['SuggestWord'] = self.suggest_word
        if self.terms_desc is not None:
            result['TermsDesc'] = self.terms_desc
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExceptionWord') is not None:
            self.exception_word_shrink = m.get('ExceptionWord')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Keyword') is not None:
            self.keyword = m.get('Keyword')
        if m.get('SuggestWord') is not None:
            self.suggest_word = m.get('SuggestWord')
        if m.get('TermsDesc') is not None:
            self.terms_desc = m.get('TermsDesc')
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        return self


class EditAuditTermsResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: bool = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        # Id of the request
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class EditAuditTermsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: EditAuditTermsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = EditAuditTermsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class EditBiddingDocRequest(TeaModel):
    def __init__(
        self,
        content: str = None,
        content_format: str = None,
        content_type: str = None,
        task_id: str = None,
        workspace_id: str = None,
    ):
        self.content = content
        self.content_format = content_format
        self.content_type = content_type
        self.task_id = task_id
        self.workspace_id = workspace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.content_format is not None:
            result['ContentFormat'] = self.content_format
        if self.content_type is not None:
            result['ContentType'] = self.content_type
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('ContentFormat') is not None:
            self.content_format = m.get('ContentFormat')
        if m.get('ContentType') is not None:
            self.content_type = m.get('ContentType')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        return self


class EditBiddingDocResponseBodyData(TeaModel):
    def __init__(
        self,
        task_id: str = None,
    ):
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class EditBiddingDocResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: EditBiddingDocResponseBodyData = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        # Id of the request
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = EditBiddingDocResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class EditBiddingDocResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: EditBiddingDocResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = EditBiddingDocResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ExportAnalysisTagDetailByTaskIdRequest(TeaModel):
    def __init__(
        self,
        categories: List[str] = None,
        task_id: str = None,
        workspace_id: str = None,
    ):
        self.categories = categories
        # This parameter is required.
        self.task_id = task_id
        # This parameter is required.
        self.workspace_id = workspace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.categories is not None:
            result['Categories'] = self.categories
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Categories') is not None:
            self.categories = m.get('Categories')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        return self


class ExportAnalysisTagDetailByTaskIdShrinkRequest(TeaModel):
    def __init__(
        self,
        categories_shrink: str = None,
        task_id: str = None,
        workspace_id: str = None,
    ):
        self.categories_shrink = categories_shrink
        # This parameter is required.
        self.task_id = task_id
        # This parameter is required.
        self.workspace_id = workspace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.categories_shrink is not None:
            result['Categories'] = self.categories_shrink
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Categories') is not None:
            self.categories_shrink = m.get('Categories')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        return self


class ExportAnalysisTagDetailByTaskIdResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: str = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ExportAnalysisTagDetailByTaskIdResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ExportAnalysisTagDetailByTaskIdResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ExportAnalysisTagDetailByTaskIdResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ExportAuditContentResultRequest(TeaModel):
    def __init__(
        self,
        task_id: str = None,
        workspace_id: str = None,
    ):
        self.task_id = task_id
        self.workspace_id = workspace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        return self


class ExportAuditContentResultResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: str = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        # Id of the request
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ExportAuditContentResultResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ExportAuditContentResultResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ExportAuditContentResultResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ExportCustomSourceAnalysisTaskRequest(TeaModel):
    def __init__(
        self,
        task_id: str = None,
        workspace_id: str = None,
    ):
        # This parameter is required.
        self.task_id = task_id
        # This parameter is required.
        self.workspace_id = workspace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        return self


class ExportCustomSourceAnalysisTaskResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: str = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ExportCustomSourceAnalysisTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ExportCustomSourceAnalysisTaskResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ExportCustomSourceAnalysisTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ExportGeneratedContentRequest(TeaModel):
    def __init__(
        self,
        agent_key: str = None,
        id: int = None,
    ):
        # This parameter is required.
        self.agent_key = agent_key
        # This parameter is required.
        self.id = id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_key is not None:
            result['AgentKey'] = self.agent_key
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentKey') is not None:
            self.agent_key = m.get('AgentKey')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class ExportGeneratedContentResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: str = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ExportGeneratedContentResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ExportGeneratedContentResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ExportGeneratedContentResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ExportHotTopicPlanningProposalsRequest(TeaModel):
    def __init__(
        self,
        agent_key: str = None,
        custom_view_point_ids: List[str] = None,
        export_type: str = None,
        titles: List[str] = None,
        topic: str = None,
        topic_source: str = None,
        view_point_type: str = None,
    ):
        # This parameter is required.
        self.agent_key = agent_key
        self.custom_view_point_ids = custom_view_point_ids
        self.export_type = export_type
        self.titles = titles
        # This parameter is required.
        self.topic = topic
        # This parameter is required.
        self.topic_source = topic_source
        self.view_point_type = view_point_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_key is not None:
            result['AgentKey'] = self.agent_key
        if self.custom_view_point_ids is not None:
            result['CustomViewPointIds'] = self.custom_view_point_ids
        if self.export_type is not None:
            result['ExportType'] = self.export_type
        if self.titles is not None:
            result['Titles'] = self.titles
        if self.topic is not None:
            result['Topic'] = self.topic
        if self.topic_source is not None:
            result['TopicSource'] = self.topic_source
        if self.view_point_type is not None:
            result['ViewPointType'] = self.view_point_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentKey') is not None:
            self.agent_key = m.get('AgentKey')
        if m.get('CustomViewPointIds') is not None:
            self.custom_view_point_ids = m.get('CustomViewPointIds')
        if m.get('ExportType') is not None:
            self.export_type = m.get('ExportType')
        if m.get('Titles') is not None:
            self.titles = m.get('Titles')
        if m.get('Topic') is not None:
            self.topic = m.get('Topic')
        if m.get('TopicSource') is not None:
            self.topic_source = m.get('TopicSource')
        if m.get('ViewPointType') is not None:
            self.view_point_type = m.get('ViewPointType')
        return self


class ExportHotTopicPlanningProposalsShrinkRequest(TeaModel):
    def __init__(
        self,
        agent_key: str = None,
        custom_view_point_ids_shrink: str = None,
        export_type: str = None,
        titles_shrink: str = None,
        topic: str = None,
        topic_source: str = None,
        view_point_type: str = None,
    ):
        # This parameter is required.
        self.agent_key = agent_key
        self.custom_view_point_ids_shrink = custom_view_point_ids_shrink
        self.export_type = export_type
        self.titles_shrink = titles_shrink
        # This parameter is required.
        self.topic = topic
        # This parameter is required.
        self.topic_source = topic_source
        self.view_point_type = view_point_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_key is not None:
            result['AgentKey'] = self.agent_key
        if self.custom_view_point_ids_shrink is not None:
            result['CustomViewPointIds'] = self.custom_view_point_ids_shrink
        if self.export_type is not None:
            result['ExportType'] = self.export_type
        if self.titles_shrink is not None:
            result['Titles'] = self.titles_shrink
        if self.topic is not None:
            result['Topic'] = self.topic
        if self.topic_source is not None:
            result['TopicSource'] = self.topic_source
        if self.view_point_type is not None:
            result['ViewPointType'] = self.view_point_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentKey') is not None:
            self.agent_key = m.get('AgentKey')
        if m.get('CustomViewPointIds') is not None:
            self.custom_view_point_ids_shrink = m.get('CustomViewPointIds')
        if m.get('ExportType') is not None:
            self.export_type = m.get('ExportType')
        if m.get('Titles') is not None:
            self.titles_shrink = m.get('Titles')
        if m.get('Topic') is not None:
            self.topic = m.get('Topic')
        if m.get('TopicSource') is not None:
            self.topic_source = m.get('TopicSource')
        if m.get('ViewPointType') is not None:
            self.view_point_type = m.get('ViewPointType')
        return self


class ExportHotTopicPlanningProposalsResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: str = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ExportHotTopicPlanningProposalsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ExportHotTopicPlanningProposalsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ExportHotTopicPlanningProposalsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ExportIntervenesRequest(TeaModel):
    def __init__(
        self,
        agent_key: str = None,
    ):
        # This parameter is required.
        self.agent_key = agent_key

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_key is not None:
            result['AgentKey'] = self.agent_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentKey') is not None:
            self.agent_key = m.get('AgentKey')
        return self


class ExportIntervenesResponseBodyData(TeaModel):
    def __init__(
        self,
        code: int = None,
        file_url: str = None,
    ):
        self.code = code
        self.file_url = file_url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.file_url is not None:
            result['FileUrl'] = self.file_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('FileUrl') is not None:
            self.file_url = m.get('FileUrl')
        return self


class ExportIntervenesResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: ExportIntervenesResponseBodyData = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = ExportIntervenesResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ExportIntervenesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ExportIntervenesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ExportIntervenesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class FeedbackDialogueRequest(TeaModel):
    def __init__(
        self,
        agent_key: str = None,
        customer_response: str = None,
        good_text: str = None,
        modified_response: str = None,
        rating: str = None,
        rating_tags: List[str] = None,
        session_id: str = None,
        task_id: str = None,
    ):
        # This parameter is required.
        self.agent_key = agent_key
        self.customer_response = customer_response
        self.good_text = good_text
        self.modified_response = modified_response
        self.rating = rating
        self.rating_tags = rating_tags
        # This parameter is required.
        self.session_id = session_id
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_key is not None:
            result['AgentKey'] = self.agent_key
        if self.customer_response is not None:
            result['CustomerResponse'] = self.customer_response
        if self.good_text is not None:
            result['GoodText'] = self.good_text
        if self.modified_response is not None:
            result['ModifiedResponse'] = self.modified_response
        if self.rating is not None:
            result['Rating'] = self.rating
        if self.rating_tags is not None:
            result['RatingTags'] = self.rating_tags
        if self.session_id is not None:
            result['SessionId'] = self.session_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentKey') is not None:
            self.agent_key = m.get('AgentKey')
        if m.get('CustomerResponse') is not None:
            self.customer_response = m.get('CustomerResponse')
        if m.get('GoodText') is not None:
            self.good_text = m.get('GoodText')
        if m.get('ModifiedResponse') is not None:
            self.modified_response = m.get('ModifiedResponse')
        if m.get('Rating') is not None:
            self.rating = m.get('Rating')
        if m.get('RatingTags') is not None:
            self.rating_tags = m.get('RatingTags')
        if m.get('SessionId') is not None:
            self.session_id = m.get('SessionId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class FeedbackDialogueShrinkRequest(TeaModel):
    def __init__(
        self,
        agent_key: str = None,
        customer_response: str = None,
        good_text: str = None,
        modified_response: str = None,
        rating: str = None,
        rating_tags_shrink: str = None,
        session_id: str = None,
        task_id: str = None,
    ):
        # This parameter is required.
        self.agent_key = agent_key
        self.customer_response = customer_response
        self.good_text = good_text
        self.modified_response = modified_response
        self.rating = rating
        self.rating_tags_shrink = rating_tags_shrink
        # This parameter is required.
        self.session_id = session_id
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_key is not None:
            result['AgentKey'] = self.agent_key
        if self.customer_response is not None:
            result['CustomerResponse'] = self.customer_response
        if self.good_text is not None:
            result['GoodText'] = self.good_text
        if self.modified_response is not None:
            result['ModifiedResponse'] = self.modified_response
        if self.rating is not None:
            result['Rating'] = self.rating
        if self.rating_tags_shrink is not None:
            result['RatingTags'] = self.rating_tags_shrink
        if self.session_id is not None:
            result['SessionId'] = self.session_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentKey') is not None:
            self.agent_key = m.get('AgentKey')
        if m.get('CustomerResponse') is not None:
            self.customer_response = m.get('CustomerResponse')
        if m.get('GoodText') is not None:
            self.good_text = m.get('GoodText')
        if m.get('ModifiedResponse') is not None:
            self.modified_response = m.get('ModifiedResponse')
        if m.get('Rating') is not None:
            self.rating = m.get('Rating')
        if m.get('RatingTags') is not None:
            self.rating_tags_shrink = m.get('RatingTags')
        if m.get('SessionId') is not None:
            self.session_id = m.get('SessionId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class FeedbackDialogueResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.http_status_code = http_status_code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class FeedbackDialogueResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: FeedbackDialogueResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = FeedbackDialogueResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class FetchExportTermsTaskRequest(TeaModel):
    def __init__(
        self,
        task_id: str = None,
        workspace_id: str = None,
    ):
        # This parameter is required.
        self.task_id = task_id
        # This parameter is required.
        self.workspace_id = workspace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        return self


class FetchExportTermsTaskResponseBodyData(TeaModel):
    def __init__(
        self,
        file_url: str = None,
        status: str = None,
    ):
        self.file_url = file_url
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_url is not None:
            result['FileUrl'] = self.file_url
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FileUrl') is not None:
            self.file_url = m.get('FileUrl')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class FetchExportTermsTaskResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: FetchExportTermsTaskResponseBodyData = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        # Id of the request
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = FetchExportTermsTaskResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class FetchExportTermsTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: FetchExportTermsTaskResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = FetchExportTermsTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class FetchExportWordTaskRequest(TeaModel):
    def __init__(
        self,
        agent_key: str = None,
        task_id: str = None,
    ):
        # This parameter is required.
        self.agent_key = agent_key
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_key is not None:
            result['AgentKey'] = self.agent_key
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentKey') is not None:
            self.agent_key = m.get('AgentKey')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class FetchExportWordTaskResponseBodyData(TeaModel):
    def __init__(
        self,
        file_url: str = None,
        task_stats: str = None,
    ):
        self.file_url = file_url
        self.task_stats = task_stats

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_url is not None:
            result['FileUrl'] = self.file_url
        if self.task_stats is not None:
            result['TaskStats'] = self.task_stats
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FileUrl') is not None:
            self.file_url = m.get('FileUrl')
        if m.get('TaskStats') is not None:
            self.task_stats = m.get('TaskStats')
        return self


class FetchExportWordTaskResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: FetchExportWordTaskResponseBodyData = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = FetchExportWordTaskResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class FetchExportWordTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: FetchExportWordTaskResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = FetchExportWordTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class FetchImageTaskRequest(TeaModel):
    def __init__(
        self,
        agent_key: str = None,
        article_task_id: str = None,
        task_id_list: List[str] = None,
    ):
        # This parameter is required.
        self.agent_key = agent_key
        # This parameter is required.
        self.article_task_id = article_task_id
        # This parameter is required.
        self.task_id_list = task_id_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_key is not None:
            result['AgentKey'] = self.agent_key
        if self.article_task_id is not None:
            result['ArticleTaskId'] = self.article_task_id
        if self.task_id_list is not None:
            result['TaskIdList'] = self.task_id_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentKey') is not None:
            self.agent_key = m.get('AgentKey')
        if m.get('ArticleTaskId') is not None:
            self.article_task_id = m.get('ArticleTaskId')
        if m.get('TaskIdList') is not None:
            self.task_id_list = m.get('TaskIdList')
        return self


class FetchImageTaskShrinkRequest(TeaModel):
    def __init__(
        self,
        agent_key: str = None,
        article_task_id: str = None,
        task_id_list_shrink: str = None,
    ):
        # This parameter is required.
        self.agent_key = agent_key
        # This parameter is required.
        self.article_task_id = article_task_id
        # This parameter is required.
        self.task_id_list_shrink = task_id_list_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_key is not None:
            result['AgentKey'] = self.agent_key
        if self.article_task_id is not None:
            result['ArticleTaskId'] = self.article_task_id
        if self.task_id_list_shrink is not None:
            result['TaskIdList'] = self.task_id_list_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentKey') is not None:
            self.agent_key = m.get('AgentKey')
        if m.get('ArticleTaskId') is not None:
            self.article_task_id = m.get('ArticleTaskId')
        if m.get('TaskIdList') is not None:
            self.task_id_list_shrink = m.get('TaskIdList')
        return self


class FetchImageTaskResponseBodyDataTaskInfoListImageList(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        url: str = None,
    ):
        self.code = code
        self.message = message
        self.url = url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.url is not None:
            result['Url'] = self.url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        return self


class FetchImageTaskResponseBodyDataTaskInfoList(TeaModel):
    def __init__(
        self,
        id: int = None,
        image_list: List[FetchImageTaskResponseBodyDataTaskInfoListImageList] = None,
        task_id: str = None,
        task_status: str = None,
    ):
        self.id = id
        self.image_list = image_list
        self.task_id = task_id
        self.task_status = task_status

    def validate(self):
        if self.image_list:
            for k in self.image_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        result['ImageList'] = []
        if self.image_list is not None:
            for k in self.image_list:
                result['ImageList'].append(k.to_map() if k else None)
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.task_status is not None:
            result['TaskStatus'] = self.task_status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        self.image_list = []
        if m.get('ImageList') is not None:
            for k in m.get('ImageList'):
                temp_model = FetchImageTaskResponseBodyDataTaskInfoListImageList()
                self.image_list.append(temp_model.from_map(k))
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('TaskStatus') is not None:
            self.task_status = m.get('TaskStatus')
        return self


class FetchImageTaskResponseBodyData(TeaModel):
    def __init__(
        self,
        task_info_list: List[FetchImageTaskResponseBodyDataTaskInfoList] = None,
    ):
        self.task_info_list = task_info_list

    def validate(self):
        if self.task_info_list:
            for k in self.task_info_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['TaskInfoList'] = []
        if self.task_info_list is not None:
            for k in self.task_info_list:
                result['TaskInfoList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.task_info_list = []
        if m.get('TaskInfoList') is not None:
            for k in m.get('TaskInfoList'):
                temp_model = FetchImageTaskResponseBodyDataTaskInfoList()
                self.task_info_list.append(temp_model.from_map(k))
        return self


class FetchImageTaskResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: FetchImageTaskResponseBodyData = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = FetchImageTaskResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class FetchImageTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: FetchImageTaskResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = FetchImageTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class FetchImportTermsTaskRequest(TeaModel):
    def __init__(
        self,
        task_id: str = None,
        workspace_id: str = None,
    ):
        # This parameter is required.
        self.task_id = task_id
        # This parameter is required.
        self.workspace_id = workspace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        return self


class FetchImportTermsTaskResponseBodyData(TeaModel):
    def __init__(
        self,
        status: str = None,
    ):
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class FetchImportTermsTaskResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: FetchImportTermsTaskResponseBodyData = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        # Id of the request
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = FetchImportTermsTaskResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class FetchImportTermsTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: FetchImportTermsTaskResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = FetchImportTermsTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GenerateExportWordTaskRequest(TeaModel):
    def __init__(
        self,
        agent_key: str = None,
        generated_content_id: int = None,
    ):
        # This parameter is required.
        self.agent_key = agent_key
        # This parameter is required.
        self.generated_content_id = generated_content_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_key is not None:
            result['AgentKey'] = self.agent_key
        if self.generated_content_id is not None:
            result['GeneratedContentId'] = self.generated_content_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentKey') is not None:
            self.agent_key = m.get('AgentKey')
        if m.get('GeneratedContentId') is not None:
            self.generated_content_id = m.get('GeneratedContentId')
        return self


class GenerateExportWordTaskResponseBodyData(TeaModel):
    def __init__(
        self,
        task_id: str = None,
    ):
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class GenerateExportWordTaskResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GenerateExportWordTaskResponseBodyData = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GenerateExportWordTaskResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GenerateExportWordTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GenerateExportWordTaskResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GenerateExportWordTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GenerateFileUrlByKeyRequest(TeaModel):
    def __init__(
        self,
        agent_key: str = None,
        file_key: str = None,
        file_name: str = None,
    ):
        # This parameter is required.
        self.agent_key = agent_key
        self.file_key = file_key
        self.file_name = file_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_key is not None:
            result['AgentKey'] = self.agent_key
        if self.file_key is not None:
            result['FileKey'] = self.file_key
        if self.file_name is not None:
            result['FileName'] = self.file_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentKey') is not None:
            self.agent_key = m.get('AgentKey')
        if m.get('FileKey') is not None:
            self.file_key = m.get('FileKey')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        return self


class GenerateFileUrlByKeyResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: str = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GenerateFileUrlByKeyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GenerateFileUrlByKeyResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GenerateFileUrlByKeyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GenerateImageTaskRequestParagraphList(TeaModel):
    def __init__(
        self,
        content: str = None,
        id: int = None,
        task_id: str = None,
        task_status: str = None,
    ):
        # This parameter is required.
        self.content = content
        # This parameter is required.
        self.id = id
        self.task_id = task_id
        self.task_status = task_status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.id is not None:
            result['Id'] = self.id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.task_status is not None:
            result['TaskStatus'] = self.task_status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('TaskStatus') is not None:
            self.task_status = m.get('TaskStatus')
        return self


class GenerateImageTaskRequest(TeaModel):
    def __init__(
        self,
        agent_key: str = None,
        article_task_id: str = None,
        paragraph_list: List[GenerateImageTaskRequestParagraphList] = None,
        size: str = None,
        style: str = None,
    ):
        # This parameter is required.
        self.agent_key = agent_key
        # This parameter is required.
        self.article_task_id = article_task_id
        # This parameter is required.
        self.paragraph_list = paragraph_list
        # This parameter is required.
        self.size = size
        # This parameter is required.
        self.style = style

    def validate(self):
        if self.paragraph_list:
            for k in self.paragraph_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_key is not None:
            result['AgentKey'] = self.agent_key
        if self.article_task_id is not None:
            result['ArticleTaskId'] = self.article_task_id
        result['ParagraphList'] = []
        if self.paragraph_list is not None:
            for k in self.paragraph_list:
                result['ParagraphList'].append(k.to_map() if k else None)
        if self.size is not None:
            result['Size'] = self.size
        if self.style is not None:
            result['Style'] = self.style
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentKey') is not None:
            self.agent_key = m.get('AgentKey')
        if m.get('ArticleTaskId') is not None:
            self.article_task_id = m.get('ArticleTaskId')
        self.paragraph_list = []
        if m.get('ParagraphList') is not None:
            for k in m.get('ParagraphList'):
                temp_model = GenerateImageTaskRequestParagraphList()
                self.paragraph_list.append(temp_model.from_map(k))
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('Style') is not None:
            self.style = m.get('Style')
        return self


class GenerateImageTaskShrinkRequest(TeaModel):
    def __init__(
        self,
        agent_key: str = None,
        article_task_id: str = None,
        paragraph_list_shrink: str = None,
        size: str = None,
        style: str = None,
    ):
        # This parameter is required.
        self.agent_key = agent_key
        # This parameter is required.
        self.article_task_id = article_task_id
        # This parameter is required.
        self.paragraph_list_shrink = paragraph_list_shrink
        # This parameter is required.
        self.size = size
        # This parameter is required.
        self.style = style

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_key is not None:
            result['AgentKey'] = self.agent_key
        if self.article_task_id is not None:
            result['ArticleTaskId'] = self.article_task_id
        if self.paragraph_list_shrink is not None:
            result['ParagraphList'] = self.paragraph_list_shrink
        if self.size is not None:
            result['Size'] = self.size
        if self.style is not None:
            result['Style'] = self.style
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentKey') is not None:
            self.agent_key = m.get('AgentKey')
        if m.get('ArticleTaskId') is not None:
            self.article_task_id = m.get('ArticleTaskId')
        if m.get('ParagraphList') is not None:
            self.paragraph_list_shrink = m.get('ParagraphList')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('Style') is not None:
            self.style = m.get('Style')
        return self


class GenerateImageTaskResponseBodyDataTaskList(TeaModel):
    def __init__(
        self,
        content: str = None,
        id: int = None,
        task_id: str = None,
        task_status: str = None,
    ):
        self.content = content
        self.id = id
        self.task_id = task_id
        self.task_status = task_status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.id is not None:
            result['Id'] = self.id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.task_status is not None:
            result['TaskStatus'] = self.task_status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('TaskStatus') is not None:
            self.task_status = m.get('TaskStatus')
        return self


class GenerateImageTaskResponseBodyData(TeaModel):
    def __init__(
        self,
        task_list: List[GenerateImageTaskResponseBodyDataTaskList] = None,
    ):
        self.task_list = task_list

    def validate(self):
        if self.task_list:
            for k in self.task_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['TaskList'] = []
        if self.task_list is not None:
            for k in self.task_list:
                result['TaskList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.task_list = []
        if m.get('TaskList') is not None:
            for k in m.get('TaskList'):
                temp_model = GenerateImageTaskResponseBodyDataTaskList()
                self.task_list.append(temp_model.from_map(k))
        return self


class GenerateImageTaskResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GenerateImageTaskResponseBodyData = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GenerateImageTaskResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GenerateImageTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GenerateImageTaskResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GenerateImageTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GenerateUploadConfigRequest(TeaModel):
    def __init__(
        self,
        agent_key: str = None,
        file_name: str = None,
        parent_dir: str = None,
    ):
        # This parameter is required.
        self.agent_key = agent_key
        self.file_name = file_name
        # This parameter is required.
        self.parent_dir = parent_dir

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_key is not None:
            result['AgentKey'] = self.agent_key
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.parent_dir is not None:
            result['ParentDir'] = self.parent_dir
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentKey') is not None:
            self.agent_key = m.get('AgentKey')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('ParentDir') is not None:
            self.parent_dir = m.get('ParentDir')
        return self


class GenerateUploadConfigResponseBodyData(TeaModel):
    def __init__(
        self,
        file_key: str = None,
        form_datas: Dict[str, str] = None,
        post_url: str = None,
    ):
        self.file_key = file_key
        self.form_datas = form_datas
        self.post_url = post_url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_key is not None:
            result['FileKey'] = self.file_key
        if self.form_datas is not None:
            result['FormDatas'] = self.form_datas
        if self.post_url is not None:
            result['PostUrl'] = self.post_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FileKey') is not None:
            self.file_key = m.get('FileKey')
        if m.get('FormDatas') is not None:
            self.form_datas = m.get('FormDatas')
        if m.get('PostUrl') is not None:
            self.post_url = m.get('PostUrl')
        return self


class GenerateUploadConfigResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GenerateUploadConfigResponseBodyData = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GenerateUploadConfigResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GenerateUploadConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GenerateUploadConfigResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GenerateUploadConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GenerateViewPointRequestReferenceData(TeaModel):
    def __init__(
        self,
        mini_doc: List[str] = None,
    ):
        self.mini_doc = mini_doc

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.mini_doc is not None:
            result['MiniDoc'] = self.mini_doc
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MiniDoc') is not None:
            self.mini_doc = m.get('MiniDoc')
        return self


class GenerateViewPointRequest(TeaModel):
    def __init__(
        self,
        agent_key: str = None,
        reference_data: GenerateViewPointRequestReferenceData = None,
    ):
        # This parameter is required.
        self.agent_key = agent_key
        self.reference_data = reference_data

    def validate(self):
        if self.reference_data:
            self.reference_data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_key is not None:
            result['AgentKey'] = self.agent_key
        if self.reference_data is not None:
            result['ReferenceData'] = self.reference_data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentKey') is not None:
            self.agent_key = m.get('AgentKey')
        if m.get('ReferenceData') is not None:
            temp_model = GenerateViewPointRequestReferenceData()
            self.reference_data = temp_model.from_map(m['ReferenceData'])
        return self


class GenerateViewPointShrinkRequest(TeaModel):
    def __init__(
        self,
        agent_key: str = None,
        reference_data_shrink: str = None,
    ):
        # This parameter is required.
        self.agent_key = agent_key
        self.reference_data_shrink = reference_data_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_key is not None:
            result['AgentKey'] = self.agent_key
        if self.reference_data_shrink is not None:
            result['ReferenceData'] = self.reference_data_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentKey') is not None:
            self.agent_key = m.get('AgentKey')
        if m.get('ReferenceData') is not None:
            self.reference_data_shrink = m.get('ReferenceData')
        return self


class GenerateViewPointResponseBodyData(TeaModel):
    def __init__(
        self,
        point: str = None,
    ):
        self.point = point

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.point is not None:
            result['Point'] = self.point
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Point') is not None:
            self.point = m.get('Point')
        return self


class GenerateViewPointResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: List[GenerateViewPointResponseBodyData] = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = GenerateViewPointResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GenerateViewPointResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GenerateViewPointResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GenerateViewPointResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetAuditNotePostProcessingStatusRequest(TeaModel):
    def __init__(
        self,
        task_id: str = None,
        workspace_id: str = None,
    ):
        # This parameter is required.
        self.task_id = task_id
        # This parameter is required.
        self.workspace_id = workspace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        return self


class GetAuditNotePostProcessingStatusResponseBodyData(TeaModel):
    def __init__(
        self,
        completion_time: str = None,
        create_time: str = None,
        error_message: str = None,
        note_id: str = None,
        processed_lines: int = None,
        status: str = None,
        total_lines: int = None,
    ):
        self.completion_time = completion_time
        self.create_time = create_time
        self.error_message = error_message
        self.note_id = note_id
        self.processed_lines = processed_lines
        self.status = status
        self.total_lines = total_lines

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.completion_time is not None:
            result['CompletionTime'] = self.completion_time
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.note_id is not None:
            result['NoteId'] = self.note_id
        if self.processed_lines is not None:
            result['ProcessedLines'] = self.processed_lines
        if self.status is not None:
            result['Status'] = self.status
        if self.total_lines is not None:
            result['TotalLines'] = self.total_lines
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CompletionTime') is not None:
            self.completion_time = m.get('CompletionTime')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('NoteId') is not None:
            self.note_id = m.get('NoteId')
        if m.get('ProcessedLines') is not None:
            self.processed_lines = m.get('ProcessedLines')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TotalLines') is not None:
            self.total_lines = m.get('TotalLines')
        return self


class GetAuditNotePostProcessingStatusResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GetAuditNotePostProcessingStatusResponseBodyData = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # This parameter is required.
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        # This parameter is required.
        self.message = message
        # Id of the request
        # 
        # This parameter is required.
        self.request_id = request_id
        # This parameter is required.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetAuditNotePostProcessingStatusResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetAuditNotePostProcessingStatusResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetAuditNotePostProcessingStatusResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetAuditNotePostProcessingStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetAuditNoteProcessingStatusRequest(TeaModel):
    def __init__(
        self,
        task_id: str = None,
        workspace_id: str = None,
    ):
        # This parameter is required.
        self.task_id = task_id
        # This parameter is required.
        self.workspace_id = workspace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        return self


class GetAuditNoteProcessingStatusResponseBodyData(TeaModel):
    def __init__(
        self,
        file_key: str = None,
        file_size: int = None,
        note_name: str = None,
        status: str = None,
        task_id: str = None,
        update_time: int = None,
    ):
        self.file_key = file_key
        self.file_size = file_size
        self.note_name = note_name
        self.status = status
        self.task_id = task_id
        self.update_time = update_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_key is not None:
            result['FileKey'] = self.file_key
        if self.file_size is not None:
            result['FileSize'] = self.file_size
        if self.note_name is not None:
            result['NoteName'] = self.note_name
        if self.status is not None:
            result['Status'] = self.status
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FileKey') is not None:
            self.file_key = m.get('FileKey')
        if m.get('FileSize') is not None:
            self.file_size = m.get('FileSize')
        if m.get('NoteName') is not None:
            self.note_name = m.get('NoteName')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        return self


class GetAuditNoteProcessingStatusResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GetAuditNoteProcessingStatusResponseBodyData = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        # Id of the request
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetAuditNoteProcessingStatusResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetAuditNoteProcessingStatusResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetAuditNoteProcessingStatusResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetAuditNoteProcessingStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetAutoClipsTaskInfoRequest(TeaModel):
    def __init__(
        self,
        task_id: str = None,
        workspace_id: str = None,
    ):
        # This parameter is required.
        self.task_id = task_id
        # This parameter is required.
        self.workspace_id = workspace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        return self


class GetAutoClipsTaskInfoResponseBodyDataColorWords(TeaModel):
    def __init__(
        self,
        content: str = None,
        effect_color_style: str = None,
        font_size: int = None,
        timeline_in: int = None,
        timeline_out: int = None,
        x: float = None,
        y: float = None,
    ):
        self.content = content
        self.effect_color_style = effect_color_style
        self.font_size = font_size
        self.timeline_in = timeline_in
        self.timeline_out = timeline_out
        self.x = x
        self.y = y

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.effect_color_style is not None:
            result['EffectColorStyle'] = self.effect_color_style
        if self.font_size is not None:
            result['FontSize'] = self.font_size
        if self.timeline_in is not None:
            result['TimelineIn'] = self.timeline_in
        if self.timeline_out is not None:
            result['TimelineOut'] = self.timeline_out
        if self.x is not None:
            result['X'] = self.x
        if self.y is not None:
            result['Y'] = self.y
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('EffectColorStyle') is not None:
            self.effect_color_style = m.get('EffectColorStyle')
        if m.get('FontSize') is not None:
            self.font_size = m.get('FontSize')
        if m.get('TimelineIn') is not None:
            self.timeline_in = m.get('TimelineIn')
        if m.get('TimelineOut') is not None:
            self.timeline_out = m.get('TimelineOut')
        if m.get('X') is not None:
            self.x = m.get('X')
        if m.get('Y') is not None:
            self.y = m.get('Y')
        return self


class GetAutoClipsTaskInfoResponseBodyDataTimelinesClips(TeaModel):
    def __init__(
        self,
        clip_id: str = None,
        content_inner: str = None,
        in_: int = None,
        in_ex: float = None,
        out: int = None,
        out_ex: float = None,
        video_id: str = None,
        video_name: str = None,
    ):
        self.clip_id = clip_id
        self.content_inner = content_inner
        self.in_ = in_
        self.in_ex = in_ex
        self.out = out
        self.out_ex = out_ex
        self.video_id = video_id
        self.video_name = video_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.clip_id is not None:
            result['ClipId'] = self.clip_id
        if self.content_inner is not None:
            result['ContentInner'] = self.content_inner
        if self.in_ is not None:
            result['In'] = self.in_
        if self.in_ex is not None:
            result['InEx'] = self.in_ex
        if self.out is not None:
            result['Out'] = self.out
        if self.out_ex is not None:
            result['OutEx'] = self.out_ex
        if self.video_id is not None:
            result['VideoId'] = self.video_id
        if self.video_name is not None:
            result['VideoName'] = self.video_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClipId') is not None:
            self.clip_id = m.get('ClipId')
        if m.get('ContentInner') is not None:
            self.content_inner = m.get('ContentInner')
        if m.get('In') is not None:
            self.in_ = m.get('In')
        if m.get('InEx') is not None:
            self.in_ex = m.get('InEx')
        if m.get('Out') is not None:
            self.out = m.get('Out')
        if m.get('OutEx') is not None:
            self.out_ex = m.get('OutEx')
        if m.get('VideoId') is not None:
            self.video_id = m.get('VideoId')
        if m.get('VideoName') is not None:
            self.video_name = m.get('VideoName')
        return self


class GetAutoClipsTaskInfoResponseBodyDataTimelines(TeaModel):
    def __init__(
        self,
        clips: List[GetAutoClipsTaskInfoResponseBodyDataTimelinesClips] = None,
        content: str = None,
        timeline_id: str = None,
    ):
        self.clips = clips
        self.content = content
        self.timeline_id = timeline_id

    def validate(self):
        if self.clips:
            for k in self.clips:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Clips'] = []
        if self.clips is not None:
            for k in self.clips:
                result['Clips'].append(k.to_map() if k else None)
        if self.content is not None:
            result['Content'] = self.content
        if self.timeline_id is not None:
            result['TimelineId'] = self.timeline_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.clips = []
        if m.get('Clips') is not None:
            for k in m.get('Clips'):
                temp_model = GetAutoClipsTaskInfoResponseBodyDataTimelinesClips()
                self.clips.append(temp_model.from_map(k))
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('TimelineId') is not None:
            self.timeline_id = m.get('TimelineId')
        return self


class GetAutoClipsTaskInfoResponseBodyData(TeaModel):
    def __init__(
        self,
        color_words: List[GetAutoClipsTaskInfoResponseBodyDataColorWords] = None,
        content: str = None,
        error_message: str = None,
        media_cloud_timeline: str = None,
        music_style: str = None,
        music_url: str = None,
        music_volume: int = None,
        output_video_url: str = None,
        status: int = None,
        step: str = None,
        subtitle_font_size: int = None,
        task_id: str = None,
        timelines: List[GetAutoClipsTaskInfoResponseBodyDataTimelines] = None,
        voice_style: str = None,
        voice_volume: int = None,
    ):
        self.color_words = color_words
        self.content = content
        self.error_message = error_message
        self.media_cloud_timeline = media_cloud_timeline
        self.music_style = music_style
        self.music_url = music_url
        self.music_volume = music_volume
        self.output_video_url = output_video_url
        self.status = status
        self.step = step
        self.subtitle_font_size = subtitle_font_size
        self.task_id = task_id
        self.timelines = timelines
        self.voice_style = voice_style
        self.voice_volume = voice_volume

    def validate(self):
        if self.color_words:
            for k in self.color_words:
                if k:
                    k.validate()
        if self.timelines:
            for k in self.timelines:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ColorWords'] = []
        if self.color_words is not None:
            for k in self.color_words:
                result['ColorWords'].append(k.to_map() if k else None)
        if self.content is not None:
            result['Content'] = self.content
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.media_cloud_timeline is not None:
            result['MediaCloudTimeline'] = self.media_cloud_timeline
        if self.music_style is not None:
            result['MusicStyle'] = self.music_style
        if self.music_url is not None:
            result['MusicUrl'] = self.music_url
        if self.music_volume is not None:
            result['MusicVolume'] = self.music_volume
        if self.output_video_url is not None:
            result['OutputVideoUrl'] = self.output_video_url
        if self.status is not None:
            result['Status'] = self.status
        if self.step is not None:
            result['Step'] = self.step
        if self.subtitle_font_size is not None:
            result['SubtitleFontSize'] = self.subtitle_font_size
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        result['Timelines'] = []
        if self.timelines is not None:
            for k in self.timelines:
                result['Timelines'].append(k.to_map() if k else None)
        if self.voice_style is not None:
            result['VoiceStyle'] = self.voice_style
        if self.voice_volume is not None:
            result['VoiceVolume'] = self.voice_volume
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.color_words = []
        if m.get('ColorWords') is not None:
            for k in m.get('ColorWords'):
                temp_model = GetAutoClipsTaskInfoResponseBodyDataColorWords()
                self.color_words.append(temp_model.from_map(k))
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('MediaCloudTimeline') is not None:
            self.media_cloud_timeline = m.get('MediaCloudTimeline')
        if m.get('MusicStyle') is not None:
            self.music_style = m.get('MusicStyle')
        if m.get('MusicUrl') is not None:
            self.music_url = m.get('MusicUrl')
        if m.get('MusicVolume') is not None:
            self.music_volume = m.get('MusicVolume')
        if m.get('OutputVideoUrl') is not None:
            self.output_video_url = m.get('OutputVideoUrl')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Step') is not None:
            self.step = m.get('Step')
        if m.get('SubtitleFontSize') is not None:
            self.subtitle_font_size = m.get('SubtitleFontSize')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        self.timelines = []
        if m.get('Timelines') is not None:
            for k in m.get('Timelines'):
                temp_model = GetAutoClipsTaskInfoResponseBodyDataTimelines()
                self.timelines.append(temp_model.from_map(k))
        if m.get('VoiceStyle') is not None:
            self.voice_style = m.get('VoiceStyle')
        if m.get('VoiceVolume') is not None:
            self.voice_volume = m.get('VoiceVolume')
        return self


class GetAutoClipsTaskInfoResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GetAutoClipsTaskInfoResponseBodyData = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        # Id of the request
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetAutoClipsTaskInfoResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetAutoClipsTaskInfoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetAutoClipsTaskInfoResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetAutoClipsTaskInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetAvailableAuditNotesRequest(TeaModel):
    def __init__(
        self,
        workspace_id: str = None,
    ):
        # This parameter is required.
        self.workspace_id = workspace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        return self


class GetAvailableAuditNotesResponseBodyData(TeaModel):
    def __init__(
        self,
        file_size: int = None,
        id: str = None,
        note_id: str = None,
        note_name: str = None,
        update_time: str = None,
    ):
        self.file_size = file_size
        self.id = id
        self.note_id = note_id
        self.note_name = note_name
        self.update_time = update_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_size is not None:
            result['FileSize'] = self.file_size
        if self.id is not None:
            result['Id'] = self.id
        if self.note_id is not None:
            result['NoteId'] = self.note_id
        if self.note_name is not None:
            result['NoteName'] = self.note_name
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FileSize') is not None:
            self.file_size = m.get('FileSize')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('NoteId') is not None:
            self.note_id = m.get('NoteId')
        if m.get('NoteName') is not None:
            self.note_name = m.get('NoteName')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        return self


class GetAvailableAuditNotesResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GetAvailableAuditNotesResponseBodyData = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        # Id of the request
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetAvailableAuditNotesResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetAvailableAuditNotesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetAvailableAuditNotesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetAvailableAuditNotesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetBiddingDocInfoRequest(TeaModel):
    def __init__(
        self,
        task_id: str = None,
        workspace_id: str = None,
    ):
        self.task_id = task_id
        self.workspace_id = workspace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        return self


class GetBiddingDocInfoResponseBodyData(TeaModel):
    def __init__(
        self,
        content: str = None,
        content_format: str = None,
        content_type: str = None,
        status: int = None,
        step: str = None,
        task_id: str = None,
        tender_doc_url: str = None,
        tender_file_type: str = None,
    ):
        self.content = content
        self.content_format = content_format
        self.content_type = content_type
        self.status = status
        self.step = step
        self.task_id = task_id
        self.tender_doc_url = tender_doc_url
        self.tender_file_type = tender_file_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.content_format is not None:
            result['ContentFormat'] = self.content_format
        if self.content_type is not None:
            result['ContentType'] = self.content_type
        if self.status is not None:
            result['Status'] = self.status
        if self.step is not None:
            result['Step'] = self.step
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.tender_doc_url is not None:
            result['TenderDocUrl'] = self.tender_doc_url
        if self.tender_file_type is not None:
            result['TenderFileType'] = self.tender_file_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('ContentFormat') is not None:
            self.content_format = m.get('ContentFormat')
        if m.get('ContentType') is not None:
            self.content_type = m.get('ContentType')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Step') is not None:
            self.step = m.get('Step')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('TenderDocUrl') is not None:
            self.tender_doc_url = m.get('TenderDocUrl')
        if m.get('TenderFileType') is not None:
            self.tender_file_type = m.get('TenderFileType')
        return self


class GetBiddingDocInfoResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GetBiddingDocInfoResponseBodyData = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        # Id of the request
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetBiddingDocInfoResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetBiddingDocInfoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetBiddingDocInfoResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetBiddingDocInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetBiddingRemainLimitNumRequest(TeaModel):
    def __init__(
        self,
        api_name: str = None,
        workspace_id: str = None,
    ):
        self.api_name = api_name
        self.workspace_id = workspace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.api_name is not None:
            result['ApiName'] = self.api_name
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiName') is not None:
            self.api_name = m.get('ApiName')
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        return self


class GetBiddingRemainLimitNumResponseBodyData(TeaModel):
    def __init__(
        self,
        remain_num: int = None,
    ):
        self.remain_num = remain_num

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.remain_num is not None:
            result['RemainNum'] = self.remain_num
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RemainNum') is not None:
            self.remain_num = m.get('RemainNum')
        return self


class GetBiddingRemainLimitNumResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GetBiddingRemainLimitNumResponseBodyData = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        # Id of the request
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetBiddingRemainLimitNumResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetBiddingRemainLimitNumResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetBiddingRemainLimitNumResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetBiddingRemainLimitNumResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetCategoriesByTaskIdRequest(TeaModel):
    def __init__(
        self,
        task_id: str = None,
        workspace_id: str = None,
    ):
        # This parameter is required.
        self.task_id = task_id
        # This parameter is required.
        self.workspace_id = workspace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        return self


class GetCategoriesByTaskIdResponseBodyDataChildren(TeaModel):
    def __init__(
        self,
        category: str = None,
    ):
        self.category = category

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category is not None:
            result['Category'] = self.category
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Category') is not None:
            self.category = m.get('Category')
        return self


class GetCategoriesByTaskIdResponseBodyData(TeaModel):
    def __init__(
        self,
        category: str = None,
        children: List[GetCategoriesByTaskIdResponseBodyDataChildren] = None,
        count: int = None,
    ):
        self.category = category
        self.children = children
        self.count = count

    def validate(self):
        if self.children:
            for k in self.children:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category is not None:
            result['Category'] = self.category
        result['Children'] = []
        if self.children is not None:
            for k in self.children:
                result['Children'].append(k.to_map() if k else None)
        if self.count is not None:
            result['Count'] = self.count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Category') is not None:
            self.category = m.get('Category')
        self.children = []
        if m.get('Children') is not None:
            for k in m.get('Children'):
                temp_model = GetCategoriesByTaskIdResponseBodyDataChildren()
                self.children.append(temp_model.from_map(k))
        if m.get('Count') is not None:
            self.count = m.get('Count')
        return self


class GetCategoriesByTaskIdResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: List[GetCategoriesByTaskIdResponseBodyData] = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = GetCategoriesByTaskIdResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetCategoriesByTaskIdResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetCategoriesByTaskIdResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetCategoriesByTaskIdResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetCustomHotTopicBroadcastJobRequest(TeaModel):
    def __init__(
        self,
        task_id: str = None,
        workspace_id: str = None,
    ):
        # This parameter is required.
        self.task_id = task_id
        # This parameter is required.
        self.workspace_id = workspace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        return self


class GetCustomHotTopicBroadcastJobResponseBodyData(TeaModel):
    def __init__(
        self,
        error_message: str = None,
        hot_topic_version: str = None,
        status: str = None,
    ):
        self.error_message = error_message
        self.hot_topic_version = hot_topic_version
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.hot_topic_version is not None:
            result['HotTopicVersion'] = self.hot_topic_version
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HotTopicVersion') is not None:
            self.hot_topic_version = m.get('HotTopicVersion')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class GetCustomHotTopicBroadcastJobResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GetCustomHotTopicBroadcastJobResponseBodyData = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetCustomHotTopicBroadcastJobResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetCustomHotTopicBroadcastJobResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetCustomHotTopicBroadcastJobResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetCustomHotTopicBroadcastJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetCustomSourceTopicAnalysisTaskRequest(TeaModel):
    def __init__(
        self,
        task_id: str = None,
        workspace_id: str = None,
    ):
        # This parameter is required.
        self.task_id = task_id
        # This parameter is required.
        self.workspace_id = workspace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        return self


class GetCustomSourceTopicAnalysisTaskResponseBodyDataClusterResultsClusterNews(TeaModel):
    def __init__(
        self,
        title: str = None,
        url: str = None,
    ):
        self.title = title
        self.url = url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.title is not None:
            result['Title'] = self.title
        if self.url is not None:
            result['Url'] = self.url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Title') is not None:
            self.title = m.get('Title')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        return self


class GetCustomSourceTopicAnalysisTaskResponseBodyDataClusterResults(TeaModel):
    def __init__(
        self,
        cluster_news: List[GetCustomSourceTopicAnalysisTaskResponseBodyDataClusterResultsClusterNews] = None,
        topic: str = None,
    ):
        self.cluster_news = cluster_news
        self.topic = topic

    def validate(self):
        if self.cluster_news:
            for k in self.cluster_news:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ClusterNews'] = []
        if self.cluster_news is not None:
            for k in self.cluster_news:
                result['ClusterNews'].append(k.to_map() if k else None)
        if self.topic is not None:
            result['Topic'] = self.topic
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.cluster_news = []
        if m.get('ClusterNews') is not None:
            for k in m.get('ClusterNews'):
                temp_model = GetCustomSourceTopicAnalysisTaskResponseBodyDataClusterResultsClusterNews()
                self.cluster_news.append(temp_model.from_map(k))
        if m.get('Topic') is not None:
            self.topic = m.get('Topic')
        return self


class GetCustomSourceTopicAnalysisTaskResponseBodyData(TeaModel):
    def __init__(
        self,
        cluster_count: int = None,
        cluster_results: List[GetCustomSourceTopicAnalysisTaskResponseBodyDataClusterResults] = None,
        error_message: str = None,
        max_clustered_topic_news_size: int = None,
        parsed_news_size: int = None,
        status: str = None,
        rt: int = None,
        usages: Dict[str, int] = None,
    ):
        self.cluster_count = cluster_count
        self.cluster_results = cluster_results
        self.error_message = error_message
        self.max_clustered_topic_news_size = max_clustered_topic_news_size
        self.parsed_news_size = parsed_news_size
        self.status = status
        self.rt = rt
        self.usages = usages

    def validate(self):
        if self.cluster_results:
            for k in self.cluster_results:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_count is not None:
            result['ClusterCount'] = self.cluster_count
        result['ClusterResults'] = []
        if self.cluster_results is not None:
            for k in self.cluster_results:
                result['ClusterResults'].append(k.to_map() if k else None)
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.max_clustered_topic_news_size is not None:
            result['MaxClusteredTopicNewsSize'] = self.max_clustered_topic_news_size
        if self.parsed_news_size is not None:
            result['ParsedNewsSize'] = self.parsed_news_size
        if self.status is not None:
            result['Status'] = self.status
        if self.rt is not None:
            result['rt'] = self.rt
        if self.usages is not None:
            result['usages'] = self.usages
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClusterCount') is not None:
            self.cluster_count = m.get('ClusterCount')
        self.cluster_results = []
        if m.get('ClusterResults') is not None:
            for k in m.get('ClusterResults'):
                temp_model = GetCustomSourceTopicAnalysisTaskResponseBodyDataClusterResults()
                self.cluster_results.append(temp_model.from_map(k))
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('MaxClusteredTopicNewsSize') is not None:
            self.max_clustered_topic_news_size = m.get('MaxClusteredTopicNewsSize')
        if m.get('ParsedNewsSize') is not None:
            self.parsed_news_size = m.get('ParsedNewsSize')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('rt') is not None:
            self.rt = m.get('rt')
        if m.get('usages') is not None:
            self.usages = m.get('usages')
        return self


class GetCustomSourceTopicAnalysisTaskResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GetCustomSourceTopicAnalysisTaskResponseBodyData = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetCustomSourceTopicAnalysisTaskResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetCustomSourceTopicAnalysisTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetCustomSourceTopicAnalysisTaskResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetCustomSourceTopicAnalysisTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetCustomTextRequest(TeaModel):
    def __init__(
        self,
        agent_key: str = None,
        commodity_code: str = None,
        id: int = None,
    ):
        # This parameter is required.
        self.agent_key = agent_key
        self.commodity_code = commodity_code
        # This parameter is required.
        self.id = id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_key is not None:
            result['AgentKey'] = self.agent_key
        if self.commodity_code is not None:
            result['CommodityCode'] = self.commodity_code
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentKey') is not None:
            self.agent_key = m.get('AgentKey')
        if m.get('CommodityCode') is not None:
            self.commodity_code = m.get('CommodityCode')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class GetCustomTextResponseBodyData(TeaModel):
    def __init__(
        self,
        content: str = None,
        create_time: str = None,
        create_user: str = None,
        id: int = None,
        title: str = None,
        update_time: str = None,
        update_user: str = None,
    ):
        self.content = content
        self.create_time = create_time
        self.create_user = create_user
        self.id = id
        self.title = title
        self.update_time = update_time
        self.update_user = update_user

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.create_user is not None:
            result['CreateUser'] = self.create_user
        if self.id is not None:
            result['Id'] = self.id
        if self.title is not None:
            result['Title'] = self.title
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        if self.update_user is not None:
            result['UpdateUser'] = self.update_user
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('CreateUser') is not None:
            self.create_user = m.get('CreateUser')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        if m.get('UpdateUser') is not None:
            self.update_user = m.get('UpdateUser')
        return self


class GetCustomTextResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GetCustomTextResponseBodyData = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetCustomTextResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetCustomTextResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetCustomTextResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetCustomTextResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetCustomTopicSelectionPerspectiveAnalysisTaskRequest(TeaModel):
    def __init__(
        self,
        agent_key: str = None,
        task_id: str = None,
    ):
        # This parameter is required.
        self.agent_key = agent_key
        # This parameter is required.
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_key is not None:
            result['AgentKey'] = self.agent_key
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentKey') is not None:
            self.agent_key = m.get('AgentKey')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class GetCustomTopicSelectionPerspectiveAnalysisTaskResponseBodyDataCustomViewPointsResultAttitudesViewPointsOutlines(TeaModel):
    def __init__(
        self,
        outline: str = None,
        summary: str = None,
    ):
        self.outline = outline
        self.summary = summary

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.outline is not None:
            result['Outline'] = self.outline
        if self.summary is not None:
            result['Summary'] = self.summary
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Outline') is not None:
            self.outline = m.get('Outline')
        if m.get('Summary') is not None:
            self.summary = m.get('Summary')
        return self


class GetCustomTopicSelectionPerspectiveAnalysisTaskResponseBodyDataCustomViewPointsResultAttitudesViewPoints(TeaModel):
    def __init__(
        self,
        outlines: List[GetCustomTopicSelectionPerspectiveAnalysisTaskResponseBodyDataCustomViewPointsResultAttitudesViewPointsOutlines] = None,
        point: str = None,
        summary: str = None,
    ):
        self.outlines = outlines
        self.point = point
        self.summary = summary

    def validate(self):
        if self.outlines:
            for k in self.outlines:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Outlines'] = []
        if self.outlines is not None:
            for k in self.outlines:
                result['Outlines'].append(k.to_map() if k else None)
        if self.point is not None:
            result['Point'] = self.point
        if self.summary is not None:
            result['Summary'] = self.summary
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.outlines = []
        if m.get('Outlines') is not None:
            for k in m.get('Outlines'):
                temp_model = GetCustomTopicSelectionPerspectiveAnalysisTaskResponseBodyDataCustomViewPointsResultAttitudesViewPointsOutlines()
                self.outlines.append(temp_model.from_map(k))
        if m.get('Point') is not None:
            self.point = m.get('Point')
        if m.get('Summary') is not None:
            self.summary = m.get('Summary')
        return self


class GetCustomTopicSelectionPerspectiveAnalysisTaskResponseBodyDataCustomViewPointsResultAttitudes(TeaModel):
    def __init__(
        self,
        attitude: str = None,
        attitude_type: str = None,
        ratio: str = None,
        view_points: List[GetCustomTopicSelectionPerspectiveAnalysisTaskResponseBodyDataCustomViewPointsResultAttitudesViewPoints] = None,
    ):
        self.attitude = attitude
        self.attitude_type = attitude_type
        self.ratio = ratio
        self.view_points = view_points

    def validate(self):
        if self.view_points:
            for k in self.view_points:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.attitude is not None:
            result['Attitude'] = self.attitude
        if self.attitude_type is not None:
            result['AttitudeType'] = self.attitude_type
        if self.ratio is not None:
            result['Ratio'] = self.ratio
        result['ViewPoints'] = []
        if self.view_points is not None:
            for k in self.view_points:
                result['ViewPoints'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Attitude') is not None:
            self.attitude = m.get('Attitude')
        if m.get('AttitudeType') is not None:
            self.attitude_type = m.get('AttitudeType')
        if m.get('Ratio') is not None:
            self.ratio = m.get('Ratio')
        self.view_points = []
        if m.get('ViewPoints') is not None:
            for k in m.get('ViewPoints'):
                temp_model = GetCustomTopicSelectionPerspectiveAnalysisTaskResponseBodyDataCustomViewPointsResultAttitudesViewPoints()
                self.view_points.append(temp_model.from_map(k))
        return self


class GetCustomTopicSelectionPerspectiveAnalysisTaskResponseBodyDataCustomViewPointsResult(TeaModel):
    def __init__(
        self,
        attitudes: List[GetCustomTopicSelectionPerspectiveAnalysisTaskResponseBodyDataCustomViewPointsResultAttitudes] = None,
        topic: str = None,
    ):
        self.attitudes = attitudes
        self.topic = topic

    def validate(self):
        if self.attitudes:
            for k in self.attitudes:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Attitudes'] = []
        if self.attitudes is not None:
            for k in self.attitudes:
                result['Attitudes'].append(k.to_map() if k else None)
        if self.topic is not None:
            result['Topic'] = self.topic
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.attitudes = []
        if m.get('Attitudes') is not None:
            for k in m.get('Attitudes'):
                temp_model = GetCustomTopicSelectionPerspectiveAnalysisTaskResponseBodyDataCustomViewPointsResultAttitudes()
                self.attitudes.append(temp_model.from_map(k))
        if m.get('Topic') is not None:
            self.topic = m.get('Topic')
        return self


class GetCustomTopicSelectionPerspectiveAnalysisTaskResponseBodyData(TeaModel):
    def __init__(
        self,
        custom_view_points_result: GetCustomTopicSelectionPerspectiveAnalysisTaskResponseBodyDataCustomViewPointsResult = None,
        error_message: str = None,
        status: str = None,
    ):
        self.custom_view_points_result = custom_view_points_result
        self.error_message = error_message
        self.status = status

    def validate(self):
        if self.custom_view_points_result:
            self.custom_view_points_result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.custom_view_points_result is not None:
            result['CustomViewPointsResult'] = self.custom_view_points_result.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CustomViewPointsResult') is not None:
            temp_model = GetCustomTopicSelectionPerspectiveAnalysisTaskResponseBodyDataCustomViewPointsResult()
            self.custom_view_points_result = temp_model.from_map(m['CustomViewPointsResult'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class GetCustomTopicSelectionPerspectiveAnalysisTaskResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GetCustomTopicSelectionPerspectiveAnalysisTaskResponseBodyData = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetCustomTopicSelectionPerspectiveAnalysisTaskResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetCustomTopicSelectionPerspectiveAnalysisTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetCustomTopicSelectionPerspectiveAnalysisTaskResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetCustomTopicSelectionPerspectiveAnalysisTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDataSourceOrderConfigRequest(TeaModel):
    def __init__(
        self,
        agent_key: str = None,
        generate_technology: str = None,
        product_code: str = None,
    ):
        # This parameter is required.
        self.agent_key = agent_key
        self.generate_technology = generate_technology
        # This parameter is required.
        self.product_code = product_code

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_key is not None:
            result['AgentKey'] = self.agent_key
        if self.generate_technology is not None:
            result['GenerateTechnology'] = self.generate_technology
        if self.product_code is not None:
            result['ProductCode'] = self.product_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentKey') is not None:
            self.agent_key = m.get('AgentKey')
        if m.get('GenerateTechnology') is not None:
            self.generate_technology = m.get('GenerateTechnology')
        if m.get('ProductCode') is not None:
            self.product_code = m.get('ProductCode')
        return self


class GetDataSourceOrderConfigResponseBodyDataUserConfigDataSourceList(TeaModel):
    def __init__(
        self,
        code: str = None,
        enable: bool = None,
        name: str = None,
        number: int = None,
        type: str = None,
    ):
        self.code = code
        self.enable = enable
        self.name = name
        self.number = number
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.enable is not None:
            result['Enable'] = self.enable
        if self.name is not None:
            result['Name'] = self.name
        if self.number is not None:
            result['Number'] = self.number
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Enable') is not None:
            self.enable = m.get('Enable')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Number') is not None:
            self.number = m.get('Number')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetDataSourceOrderConfigResponseBodyData(TeaModel):
    def __init__(
        self,
        total_doc_size: int = None,
        user_config_data_source_list: List[GetDataSourceOrderConfigResponseBodyDataUserConfigDataSourceList] = None,
    ):
        self.total_doc_size = total_doc_size
        self.user_config_data_source_list = user_config_data_source_list

    def validate(self):
        if self.user_config_data_source_list:
            for k in self.user_config_data_source_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.total_doc_size is not None:
            result['TotalDocSize'] = self.total_doc_size
        result['UserConfigDataSourceList'] = []
        if self.user_config_data_source_list is not None:
            for k in self.user_config_data_source_list:
                result['UserConfigDataSourceList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TotalDocSize') is not None:
            self.total_doc_size = m.get('TotalDocSize')
        self.user_config_data_source_list = []
        if m.get('UserConfigDataSourceList') is not None:
            for k in m.get('UserConfigDataSourceList'):
                temp_model = GetDataSourceOrderConfigResponseBodyDataUserConfigDataSourceList()
                self.user_config_data_source_list.append(temp_model.from_map(k))
        return self


class GetDataSourceOrderConfigResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GetDataSourceOrderConfigResponseBodyData = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetDataSourceOrderConfigResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetDataSourceOrderConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetDataSourceOrderConfigResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetDataSourceOrderConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDatasetRequest(TeaModel):
    def __init__(
        self,
        dataset_id: int = None,
        dataset_name: str = None,
        workspace_id: str = None,
    ):
        self.dataset_id = dataset_id
        self.dataset_name = dataset_name
        # This parameter is required.
        self.workspace_id = workspace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dataset_id is not None:
            result['DatasetId'] = self.dataset_id
        if self.dataset_name is not None:
            result['DatasetName'] = self.dataset_name
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DatasetId') is not None:
            self.dataset_id = m.get('DatasetId')
        if m.get('DatasetName') is not None:
            self.dataset_name = m.get('DatasetName')
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        return self


class GetDatasetResponseBodyDataDatasetConfigSearchSourceConfigsSearchSourceRequestConfigHeaders(TeaModel):
    def __init__(
        self,
        name: str = None,
        value: str = None,
        value_format: str = None,
        value_type: str = None,
    ):
        self.name = name
        self.value = value
        self.value_format = value_format
        self.value_type = value_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.value is not None:
            result['Value'] = self.value
        if self.value_format is not None:
            result['ValueFormat'] = self.value_format
        if self.value_type is not None:
            result['ValueType'] = self.value_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        if m.get('ValueFormat') is not None:
            self.value_format = m.get('ValueFormat')
        if m.get('ValueType') is not None:
            self.value_type = m.get('ValueType')
        return self


class GetDatasetResponseBodyDataDatasetConfigSearchSourceConfigsSearchSourceRequestConfigParams(TeaModel):
    def __init__(
        self,
        name: str = None,
        value: str = None,
        value_format: str = None,
        value_type: str = None,
    ):
        self.name = name
        self.value = value
        self.value_format = value_format
        self.value_type = value_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.value is not None:
            result['Value'] = self.value
        if self.value_format is not None:
            result['ValueFormat'] = self.value_format
        if self.value_type is not None:
            result['ValueType'] = self.value_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        if m.get('ValueFormat') is not None:
            self.value_format = m.get('ValueFormat')
        if m.get('ValueType') is not None:
            self.value_type = m.get('ValueType')
        return self


class GetDatasetResponseBodyDataDatasetConfigSearchSourceConfigsSearchSourceRequestConfig(TeaModel):
    def __init__(
        self,
        body: str = None,
        connect_timeout: int = None,
        headers: List[GetDatasetResponseBodyDataDatasetConfigSearchSourceConfigsSearchSourceRequestConfigHeaders] = None,
        method: str = None,
        params: List[GetDatasetResponseBodyDataDatasetConfigSearchSourceConfigsSearchSourceRequestConfigParams] = None,
        path_params_enable: bool = None,
        socket_timeout: int = None,
        url: str = None,
    ):
        self.body = body
        self.connect_timeout = connect_timeout
        self.headers = headers
        self.method = method
        self.params = params
        self.path_params_enable = path_params_enable
        self.socket_timeout = socket_timeout
        self.url = url

    def validate(self):
        if self.headers:
            for k in self.headers:
                if k:
                    k.validate()
        if self.params:
            for k in self.params:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.body is not None:
            result['Body'] = self.body
        if self.connect_timeout is not None:
            result['ConnectTimeout'] = self.connect_timeout
        result['Headers'] = []
        if self.headers is not None:
            for k in self.headers:
                result['Headers'].append(k.to_map() if k else None)
        if self.method is not None:
            result['Method'] = self.method
        result['Params'] = []
        if self.params is not None:
            for k in self.params:
                result['Params'].append(k.to_map() if k else None)
        if self.path_params_enable is not None:
            result['PathParamsEnable'] = self.path_params_enable
        if self.socket_timeout is not None:
            result['SocketTimeout'] = self.socket_timeout
        if self.url is not None:
            result['Url'] = self.url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Body') is not None:
            self.body = m.get('Body')
        if m.get('ConnectTimeout') is not None:
            self.connect_timeout = m.get('ConnectTimeout')
        self.headers = []
        if m.get('Headers') is not None:
            for k in m.get('Headers'):
                temp_model = GetDatasetResponseBodyDataDatasetConfigSearchSourceConfigsSearchSourceRequestConfigHeaders()
                self.headers.append(temp_model.from_map(k))
        if m.get('Method') is not None:
            self.method = m.get('Method')
        self.params = []
        if m.get('Params') is not None:
            for k in m.get('Params'):
                temp_model = GetDatasetResponseBodyDataDatasetConfigSearchSourceConfigsSearchSourceRequestConfigParams()
                self.params.append(temp_model.from_map(k))
        if m.get('PathParamsEnable') is not None:
            self.path_params_enable = m.get('PathParamsEnable')
        if m.get('SocketTimeout') is not None:
            self.socket_timeout = m.get('SocketTimeout')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        return self


class GetDatasetResponseBodyDataDatasetConfigSearchSourceConfigsSearchSourceResponseConfigJqNodesJqNodesJqNodes(TeaModel):
    def __init__(
        self,
        key: str = None,
        path: str = None,
        type: str = None,
    ):
        self.key = key
        self.path = path
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.path is not None:
            result['Path'] = self.path
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Path') is not None:
            self.path = m.get('Path')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetDatasetResponseBodyDataDatasetConfigSearchSourceConfigsSearchSourceResponseConfigJqNodesJqNodes(TeaModel):
    def __init__(
        self,
        jq_nodes: List[GetDatasetResponseBodyDataDatasetConfigSearchSourceConfigsSearchSourceResponseConfigJqNodesJqNodesJqNodes] = None,
        key: str = None,
        path: str = None,
        type: str = None,
    ):
        self.jq_nodes = jq_nodes
        self.key = key
        self.path = path
        self.type = type

    def validate(self):
        if self.jq_nodes:
            for k in self.jq_nodes:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['JqNodes'] = []
        if self.jq_nodes is not None:
            for k in self.jq_nodes:
                result['JqNodes'].append(k.to_map() if k else None)
        if self.key is not None:
            result['Key'] = self.key
        if self.path is not None:
            result['Path'] = self.path
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.jq_nodes = []
        if m.get('JqNodes') is not None:
            for k in m.get('JqNodes'):
                temp_model = GetDatasetResponseBodyDataDatasetConfigSearchSourceConfigsSearchSourceResponseConfigJqNodesJqNodesJqNodes()
                self.jq_nodes.append(temp_model.from_map(k))
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Path') is not None:
            self.path = m.get('Path')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetDatasetResponseBodyDataDatasetConfigSearchSourceConfigsSearchSourceResponseConfigJqNodes(TeaModel):
    def __init__(
        self,
        jq_nodes: List[GetDatasetResponseBodyDataDatasetConfigSearchSourceConfigsSearchSourceResponseConfigJqNodesJqNodes] = None,
        key: str = None,
        path: str = None,
        type: str = None,
    ):
        self.jq_nodes = jq_nodes
        self.key = key
        self.path = path
        self.type = type

    def validate(self):
        if self.jq_nodes:
            for k in self.jq_nodes:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['JqNodes'] = []
        if self.jq_nodes is not None:
            for k in self.jq_nodes:
                result['JqNodes'].append(k.to_map() if k else None)
        if self.key is not None:
            result['Key'] = self.key
        if self.path is not None:
            result['Path'] = self.path
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.jq_nodes = []
        if m.get('JqNodes') is not None:
            for k in m.get('JqNodes'):
                temp_model = GetDatasetResponseBodyDataDatasetConfigSearchSourceConfigsSearchSourceResponseConfigJqNodesJqNodes()
                self.jq_nodes.append(temp_model.from_map(k))
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Path') is not None:
            self.path = m.get('Path')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetDatasetResponseBodyDataDatasetConfigSearchSourceConfigsSearchSourceResponseConfig(TeaModel):
    def __init__(
        self,
        jq_nodes: List[GetDatasetResponseBodyDataDatasetConfigSearchSourceConfigsSearchSourceResponseConfigJqNodes] = None,
    ):
        self.jq_nodes = jq_nodes

    def validate(self):
        if self.jq_nodes:
            for k in self.jq_nodes:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['JqNodes'] = []
        if self.jq_nodes is not None:
            for k in self.jq_nodes:
                result['JqNodes'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.jq_nodes = []
        if m.get('JqNodes') is not None:
            for k in m.get('JqNodes'):
                temp_model = GetDatasetResponseBodyDataDatasetConfigSearchSourceConfigsSearchSourceResponseConfigJqNodes()
                self.jq_nodes.append(temp_model.from_map(k))
        return self


class GetDatasetResponseBodyDataDatasetConfigSearchSourceConfigs(TeaModel):
    def __init__(
        self,
        demo_query: str = None,
        search_source_request_config: GetDatasetResponseBodyDataDatasetConfigSearchSourceConfigsSearchSourceRequestConfig = None,
        search_source_response_config: GetDatasetResponseBodyDataDatasetConfigSearchSourceConfigsSearchSourceResponseConfig = None,
        size: int = None,
    ):
        self.demo_query = demo_query
        self.search_source_request_config = search_source_request_config
        self.search_source_response_config = search_source_response_config
        self.size = size

    def validate(self):
        if self.search_source_request_config:
            self.search_source_request_config.validate()
        if self.search_source_response_config:
            self.search_source_response_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.demo_query is not None:
            result['DemoQuery'] = self.demo_query
        if self.search_source_request_config is not None:
            result['SearchSourceRequestConfig'] = self.search_source_request_config.to_map()
        if self.search_source_response_config is not None:
            result['SearchSourceResponseConfig'] = self.search_source_response_config.to_map()
        if self.size is not None:
            result['Size'] = self.size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DemoQuery') is not None:
            self.demo_query = m.get('DemoQuery')
        if m.get('SearchSourceRequestConfig') is not None:
            temp_model = GetDatasetResponseBodyDataDatasetConfigSearchSourceConfigsSearchSourceRequestConfig()
            self.search_source_request_config = temp_model.from_map(m['SearchSourceRequestConfig'])
        if m.get('SearchSourceResponseConfig') is not None:
            temp_model = GetDatasetResponseBodyDataDatasetConfigSearchSourceConfigsSearchSourceResponseConfig()
            self.search_source_response_config = temp_model.from_map(m['SearchSourceResponseConfig'])
        if m.get('Size') is not None:
            self.size = m.get('Size')
        return self


class GetDatasetResponseBodyDataDatasetConfig(TeaModel):
    def __init__(
        self,
        search_source_configs: List[GetDatasetResponseBodyDataDatasetConfigSearchSourceConfigs] = None,
    ):
        self.search_source_configs = search_source_configs

    def validate(self):
        if self.search_source_configs:
            for k in self.search_source_configs:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['SearchSourceConfigs'] = []
        if self.search_source_configs is not None:
            for k in self.search_source_configs:
                result['SearchSourceConfigs'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.search_source_configs = []
        if m.get('SearchSourceConfigs') is not None:
            for k in m.get('SearchSourceConfigs'):
                temp_model = GetDatasetResponseBodyDataDatasetConfigSearchSourceConfigs()
                self.search_source_configs.append(temp_model.from_map(k))
        return self


class GetDatasetResponseBodyDataDocumentHandleConfig(TeaModel):
    def __init__(
        self,
        disable_handle_multimodal_media: bool = None,
    ):
        self.disable_handle_multimodal_media = disable_handle_multimodal_media

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.disable_handle_multimodal_media is not None:
            result['DisableHandleMultimodalMedia'] = self.disable_handle_multimodal_media
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DisableHandleMultimodalMedia') is not None:
            self.disable_handle_multimodal_media = m.get('DisableHandleMultimodalMedia')
        return self


class GetDatasetResponseBodyData(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        create_user: str = None,
        dataset_config: GetDatasetResponseBodyDataDatasetConfig = None,
        dataset_description: str = None,
        dataset_id: int = None,
        dataset_name: str = None,
        dataset_type: str = None,
        document_handle_config: GetDatasetResponseBodyDataDocumentHandleConfig = None,
        search_dataset_enable: int = None,
    ):
        self.create_time = create_time
        self.create_user = create_user
        self.dataset_config = dataset_config
        self.dataset_description = dataset_description
        self.dataset_id = dataset_id
        self.dataset_name = dataset_name
        self.dataset_type = dataset_type
        self.document_handle_config = document_handle_config
        self.search_dataset_enable = search_dataset_enable

    def validate(self):
        if self.dataset_config:
            self.dataset_config.validate()
        if self.document_handle_config:
            self.document_handle_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.create_user is not None:
            result['CreateUser'] = self.create_user
        if self.dataset_config is not None:
            result['DatasetConfig'] = self.dataset_config.to_map()
        if self.dataset_description is not None:
            result['DatasetDescription'] = self.dataset_description
        if self.dataset_id is not None:
            result['DatasetId'] = self.dataset_id
        if self.dataset_name is not None:
            result['DatasetName'] = self.dataset_name
        if self.dataset_type is not None:
            result['DatasetType'] = self.dataset_type
        if self.document_handle_config is not None:
            result['DocumentHandleConfig'] = self.document_handle_config.to_map()
        if self.search_dataset_enable is not None:
            result['SearchDatasetEnable'] = self.search_dataset_enable
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('CreateUser') is not None:
            self.create_user = m.get('CreateUser')
        if m.get('DatasetConfig') is not None:
            temp_model = GetDatasetResponseBodyDataDatasetConfig()
            self.dataset_config = temp_model.from_map(m['DatasetConfig'])
        if m.get('DatasetDescription') is not None:
            self.dataset_description = m.get('DatasetDescription')
        if m.get('DatasetId') is not None:
            self.dataset_id = m.get('DatasetId')
        if m.get('DatasetName') is not None:
            self.dataset_name = m.get('DatasetName')
        if m.get('DatasetType') is not None:
            self.dataset_type = m.get('DatasetType')
        if m.get('DocumentHandleConfig') is not None:
            temp_model = GetDatasetResponseBodyDataDocumentHandleConfig()
            self.document_handle_config = temp_model.from_map(m['DocumentHandleConfig'])
        if m.get('SearchDatasetEnable') is not None:
            self.search_dataset_enable = m.get('SearchDatasetEnable')
        return self


class GetDatasetResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GetDatasetResponseBodyData = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetDatasetResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetDatasetResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetDatasetResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetDatasetResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDatasetDocumentRequest(TeaModel):
    def __init__(
        self,
        dataset_id: int = None,
        dataset_name: str = None,
        doc_id: str = None,
        doc_uuid: str = None,
        workspace_id: str = None,
    ):
        self.dataset_id = dataset_id
        self.dataset_name = dataset_name
        self.doc_id = doc_id
        self.doc_uuid = doc_uuid
        # This parameter is required.
        self.workspace_id = workspace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dataset_id is not None:
            result['DatasetId'] = self.dataset_id
        if self.dataset_name is not None:
            result['DatasetName'] = self.dataset_name
        if self.doc_id is not None:
            result['DocId'] = self.doc_id
        if self.doc_uuid is not None:
            result['DocUuid'] = self.doc_uuid
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DatasetId') is not None:
            self.dataset_id = m.get('DatasetId')
        if m.get('DatasetName') is not None:
            self.dataset_name = m.get('DatasetName')
        if m.get('DocId') is not None:
            self.doc_id = m.get('DocId')
        if m.get('DocUuid') is not None:
            self.doc_uuid = m.get('DocUuid')
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        return self


class GetDatasetDocumentResponseBodyData(TeaModel):
    def __init__(
        self,
        content: str = None,
        disable_handle_multimodal_media: bool = None,
        doc_id: str = None,
        doc_uuid: str = None,
        pub_time: str = None,
        source_from: str = None,
        summary: str = None,
        title: str = None,
        url: str = None,
    ):
        self.content = content
        self.disable_handle_multimodal_media = disable_handle_multimodal_media
        self.doc_id = doc_id
        self.doc_uuid = doc_uuid
        self.pub_time = pub_time
        self.source_from = source_from
        self.summary = summary
        self.title = title
        self.url = url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.disable_handle_multimodal_media is not None:
            result['DisableHandleMultimodalMedia'] = self.disable_handle_multimodal_media
        if self.doc_id is not None:
            result['DocId'] = self.doc_id
        if self.doc_uuid is not None:
            result['DocUuid'] = self.doc_uuid
        if self.pub_time is not None:
            result['PubTime'] = self.pub_time
        if self.source_from is not None:
            result['SourceFrom'] = self.source_from
        if self.summary is not None:
            result['Summary'] = self.summary
        if self.title is not None:
            result['Title'] = self.title
        if self.url is not None:
            result['Url'] = self.url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('DisableHandleMultimodalMedia') is not None:
            self.disable_handle_multimodal_media = m.get('DisableHandleMultimodalMedia')
        if m.get('DocId') is not None:
            self.doc_id = m.get('DocId')
        if m.get('DocUuid') is not None:
            self.doc_uuid = m.get('DocUuid')
        if m.get('PubTime') is not None:
            self.pub_time = m.get('PubTime')
        if m.get('SourceFrom') is not None:
            self.source_from = m.get('SourceFrom')
        if m.get('Summary') is not None:
            self.summary = m.get('Summary')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        return self


class GetDatasetDocumentResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GetDatasetDocumentResponseBodyData = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetDatasetDocumentResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetDatasetDocumentResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetDatasetDocumentResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetDatasetDocumentResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDeepWriteTaskRequest(TeaModel):
    def __init__(
        self,
        task_id: str = None,
        workspace_id: str = None,
    ):
        self.task_id = task_id
        self.workspace_id = workspace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        return self


class GetDeepWriteTaskResponseBodyData(TeaModel):
    def __init__(
        self,
        input: str = None,
        status: str = None,
        task_id: str = None,
    ):
        self.input = input
        self.status = status
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.input is not None:
            result['Input'] = self.input
        if self.status is not None:
            result['Status'] = self.status
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Input') is not None:
            self.input = m.get('Input')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class GetDeepWriteTaskResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GetDeepWriteTaskResponseBodyData = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        # Id of the request
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetDeepWriteTaskResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetDeepWriteTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetDeepWriteTaskResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetDeepWriteTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDeepWriteTaskResultRequest(TeaModel):
    def __init__(
        self,
        task_id: str = None,
        workspace_id: str = None,
    ):
        self.task_id = task_id
        self.workspace_id = workspace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        return self


class GetDeepWriteTaskResultResponseBodyData(TeaModel):
    def __init__(
        self,
        artifact_url: str = None,
        task_id: str = None,
    ):
        self.artifact_url = artifact_url
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.artifact_url is not None:
            result['ArtifactUrl'] = self.artifact_url
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ArtifactUrl') is not None:
            self.artifact_url = m.get('ArtifactUrl')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class GetDeepWriteTaskResultResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GetDeepWriteTaskResultResponseBodyData = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        # Id of the request
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetDeepWriteTaskResultResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetDeepWriteTaskResultResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetDeepWriteTaskResultResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetDeepWriteTaskResultResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDocClusterTaskRequest(TeaModel):
    def __init__(
        self,
        agent_key: str = None,
        task_id: str = None,
    ):
        # This parameter is required.
        self.agent_key = agent_key
        # This parameter is required.
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_key is not None:
            result['AgentKey'] = self.agent_key
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentKey') is not None:
            self.agent_key = m.get('AgentKey')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class GetDocClusterTaskResponseBodyDataTopics(TeaModel):
    def __init__(
        self,
        doc_ids: List[str] = None,
        summary: str = None,
        title: str = None,
    ):
        self.doc_ids = doc_ids
        self.summary = summary
        self.title = title

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.doc_ids is not None:
            result['DocIds'] = self.doc_ids
        if self.summary is not None:
            result['Summary'] = self.summary
        if self.title is not None:
            result['Title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DocIds') is not None:
            self.doc_ids = m.get('DocIds')
        if m.get('Summary') is not None:
            self.summary = m.get('Summary')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        return self


class GetDocClusterTaskResponseBodyData(TeaModel):
    def __init__(
        self,
        error_message: str = None,
        status: str = None,
        topics: List[GetDocClusterTaskResponseBodyDataTopics] = None,
    ):
        self.error_message = error_message
        self.status = status
        self.topics = topics

    def validate(self):
        if self.topics:
            for k in self.topics:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.status is not None:
            result['Status'] = self.status
        result['Topics'] = []
        if self.topics is not None:
            for k in self.topics:
                result['Topics'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        self.topics = []
        if m.get('Topics') is not None:
            for k in m.get('Topics'):
                temp_model = GetDocClusterTaskResponseBodyDataTopics()
                self.topics.append(temp_model.from_map(k))
        return self


class GetDocClusterTaskResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GetDocClusterTaskResponseBodyData = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetDocClusterTaskResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetDocClusterTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetDocClusterTaskResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetDocClusterTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDocInfoRequest(TeaModel):
    def __init__(
        self,
        category_id: str = None,
        doc_id: str = None,
        workspace_id: str = None,
    ):
        self.category_id = category_id
        # This parameter is required.
        self.doc_id = doc_id
        # This parameter is required.
        self.workspace_id = workspace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category_id is not None:
            result['CategoryId'] = self.category_id
        if self.doc_id is not None:
            result['DocId'] = self.doc_id
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CategoryId') is not None:
            self.category_id = m.get('CategoryId')
        if m.get('DocId') is not None:
            self.doc_id = m.get('DocId')
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        return self


class GetDocInfoResponseBodyData(TeaModel):
    def __init__(
        self,
        category_id: str = None,
        doc_name: str = None,
        doc_type: str = None,
        file_url: str = None,
        status: int = None,
        status_message: str = None,
        video_contents: List[str] = None,
    ):
        self.category_id = category_id
        self.doc_name = doc_name
        self.doc_type = doc_type
        self.file_url = file_url
        self.status = status
        self.status_message = status_message
        self.video_contents = video_contents

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category_id is not None:
            result['CategoryId'] = self.category_id
        if self.doc_name is not None:
            result['DocName'] = self.doc_name
        if self.doc_type is not None:
            result['DocType'] = self.doc_type
        if self.file_url is not None:
            result['FileUrl'] = self.file_url
        if self.status is not None:
            result['Status'] = self.status
        if self.status_message is not None:
            result['StatusMessage'] = self.status_message
        if self.video_contents is not None:
            result['VideoContents'] = self.video_contents
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CategoryId') is not None:
            self.category_id = m.get('CategoryId')
        if m.get('DocName') is not None:
            self.doc_name = m.get('DocName')
        if m.get('DocType') is not None:
            self.doc_type = m.get('DocType')
        if m.get('FileUrl') is not None:
            self.file_url = m.get('FileUrl')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('StatusMessage') is not None:
            self.status_message = m.get('StatusMessage')
        if m.get('VideoContents') is not None:
            self.video_contents = m.get('VideoContents')
        return self


class GetDocInfoResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GetDocInfoResponseBodyData = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetDocInfoResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetDocInfoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetDocInfoResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetDocInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetEnterpriseVocAnalysisTaskRequest(TeaModel):
    def __init__(
        self,
        task_id: str = None,
        workspace_id: str = None,
    ):
        # This parameter is required.
        self.task_id = task_id
        # This parameter is required.
        self.workspace_id = workspace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        return self


class GetEnterpriseVocAnalysisTaskResponseBodyDataStatisticsOverviewFilterDimensionStatisticsTagValueCountStatistic(TeaModel):
    def __init__(
        self,
        tag_name: str = None,
        tag_task_type: str = None,
        value_count: int = None,
    ):
        self.tag_name = tag_name
        self.tag_task_type = tag_task_type
        self.value_count = value_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag_name is not None:
            result['TagName'] = self.tag_name
        if self.tag_task_type is not None:
            result['TagTaskType'] = self.tag_task_type
        if self.value_count is not None:
            result['ValueCount'] = self.value_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TagName') is not None:
            self.tag_name = m.get('TagName')
        if m.get('TagTaskType') is not None:
            self.tag_task_type = m.get('TagTaskType')
        if m.get('ValueCount') is not None:
            self.value_count = m.get('ValueCount')
        return self


class GetEnterpriseVocAnalysisTaskResponseBodyDataStatisticsOverviewFilterDimensionStatistics(TeaModel):
    def __init__(
        self,
        tag_value_count_statistic: List[GetEnterpriseVocAnalysisTaskResponseBodyDataStatisticsOverviewFilterDimensionStatisticsTagValueCountStatistic] = None,
    ):
        self.tag_value_count_statistic = tag_value_count_statistic

    def validate(self):
        if self.tag_value_count_statistic:
            for k in self.tag_value_count_statistic:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['TagValueCountStatistic'] = []
        if self.tag_value_count_statistic is not None:
            for k in self.tag_value_count_statistic:
                result['TagValueCountStatistic'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.tag_value_count_statistic = []
        if m.get('TagValueCountStatistic') is not None:
            for k in m.get('TagValueCountStatistic'):
                temp_model = GetEnterpriseVocAnalysisTaskResponseBodyDataStatisticsOverviewFilterDimensionStatisticsTagValueCountStatistic()
                self.tag_value_count_statistic.append(temp_model.from_map(k))
        return self


class GetEnterpriseVocAnalysisTaskResponseBodyDataStatisticsOverviewTagDimensionStatisticsTagValueCountStatistic(TeaModel):
    def __init__(
        self,
        tag_name: str = None,
        tag_task_type: str = None,
        value_count: int = None,
    ):
        self.tag_name = tag_name
        self.tag_task_type = tag_task_type
        self.value_count = value_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag_name is not None:
            result['TagName'] = self.tag_name
        if self.tag_task_type is not None:
            result['TagTaskType'] = self.tag_task_type
        if self.value_count is not None:
            result['ValueCount'] = self.value_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TagName') is not None:
            self.tag_name = m.get('TagName')
        if m.get('TagTaskType') is not None:
            self.tag_task_type = m.get('TagTaskType')
        if m.get('ValueCount') is not None:
            self.value_count = m.get('ValueCount')
        return self


class GetEnterpriseVocAnalysisTaskResponseBodyDataStatisticsOverviewTagDimensionStatistics(TeaModel):
    def __init__(
        self,
        tag_value_count_statistic: List[GetEnterpriseVocAnalysisTaskResponseBodyDataStatisticsOverviewTagDimensionStatisticsTagValueCountStatistic] = None,
    ):
        self.tag_value_count_statistic = tag_value_count_statistic

    def validate(self):
        if self.tag_value_count_statistic:
            for k in self.tag_value_count_statistic:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['TagValueCountStatistic'] = []
        if self.tag_value_count_statistic is not None:
            for k in self.tag_value_count_statistic:
                result['TagValueCountStatistic'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.tag_value_count_statistic = []
        if m.get('TagValueCountStatistic') is not None:
            for k in m.get('TagValueCountStatistic'):
                temp_model = GetEnterpriseVocAnalysisTaskResponseBodyDataStatisticsOverviewTagDimensionStatisticsTagValueCountStatistic()
                self.tag_value_count_statistic.append(temp_model.from_map(k))
        return self


class GetEnterpriseVocAnalysisTaskResponseBodyDataStatisticsOverview(TeaModel):
    def __init__(
        self,
        count: int = None,
        filter_dimension_statistics: GetEnterpriseVocAnalysisTaskResponseBodyDataStatisticsOverviewFilterDimensionStatistics = None,
        tag_dimension_statistics: GetEnterpriseVocAnalysisTaskResponseBodyDataStatisticsOverviewTagDimensionStatistics = None,
    ):
        self.count = count
        self.filter_dimension_statistics = filter_dimension_statistics
        self.tag_dimension_statistics = tag_dimension_statistics

    def validate(self):
        if self.filter_dimension_statistics:
            self.filter_dimension_statistics.validate()
        if self.tag_dimension_statistics:
            self.tag_dimension_statistics.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.filter_dimension_statistics is not None:
            result['FilterDimensionStatistics'] = self.filter_dimension_statistics.to_map()
        if self.tag_dimension_statistics is not None:
            result['TagDimensionStatistics'] = self.tag_dimension_statistics.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('FilterDimensionStatistics') is not None:
            temp_model = GetEnterpriseVocAnalysisTaskResponseBodyDataStatisticsOverviewFilterDimensionStatistics()
            self.filter_dimension_statistics = temp_model.from_map(m['FilterDimensionStatistics'])
        if m.get('TagDimensionStatistics') is not None:
            temp_model = GetEnterpriseVocAnalysisTaskResponseBodyDataStatisticsOverviewTagDimensionStatistics()
            self.tag_dimension_statistics = temp_model.from_map(m['TagDimensionStatistics'])
        return self


class GetEnterpriseVocAnalysisTaskResponseBodyDataUsage(TeaModel):
    def __init__(
        self,
        input_tokens: int = None,
        output_tokens: int = None,
    ):
        self.input_tokens = input_tokens
        self.output_tokens = output_tokens

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.input_tokens is not None:
            result['InputTokens'] = self.input_tokens
        if self.output_tokens is not None:
            result['OutputTokens'] = self.output_tokens
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InputTokens') is not None:
            self.input_tokens = m.get('InputTokens')
        if m.get('OutputTokens') is not None:
            self.output_tokens = m.get('OutputTokens')
        return self


class GetEnterpriseVocAnalysisTaskResponseBodyData(TeaModel):
    def __init__(
        self,
        error_message: str = None,
        statistics_overview: GetEnterpriseVocAnalysisTaskResponseBodyDataStatisticsOverview = None,
        status: str = None,
        usage: GetEnterpriseVocAnalysisTaskResponseBodyDataUsage = None,
    ):
        self.error_message = error_message
        self.statistics_overview = statistics_overview
        self.status = status
        self.usage = usage

    def validate(self):
        if self.statistics_overview:
            self.statistics_overview.validate()
        if self.usage:
            self.usage.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.statistics_overview is not None:
            result['StatisticsOverview'] = self.statistics_overview.to_map()
        if self.status is not None:
            result['Status'] = self.status
        if self.usage is not None:
            result['Usage'] = self.usage.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('StatisticsOverview') is not None:
            temp_model = GetEnterpriseVocAnalysisTaskResponseBodyDataStatisticsOverview()
            self.statistics_overview = temp_model.from_map(m['StatisticsOverview'])
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Usage') is not None:
            temp_model = GetEnterpriseVocAnalysisTaskResponseBodyDataUsage()
            self.usage = temp_model.from_map(m['Usage'])
        return self


class GetEnterpriseVocAnalysisTaskResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GetEnterpriseVocAnalysisTaskResponseBodyData = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetEnterpriseVocAnalysisTaskResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetEnterpriseVocAnalysisTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetEnterpriseVocAnalysisTaskResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetEnterpriseVocAnalysisTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetFactAuditUrlRequest(TeaModel):
    def __init__(
        self,
        workspace_id: str = None,
    ):
        # This parameter is required.
        self.workspace_id = workspace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        return self


class GetFactAuditUrlResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: List[str] = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        # This parameter is required.
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        # Id of the request
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetFactAuditUrlResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetFactAuditUrlResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetFactAuditUrlResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetFileContentLengthRequest(TeaModel):
    def __init__(
        self,
        doc_name: str = None,
        file_url: str = None,
        workspace_id: str = None,
    ):
        self.doc_name = doc_name
        self.file_url = file_url
        # This parameter is required.
        self.workspace_id = workspace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.doc_name is not None:
            result['DocName'] = self.doc_name
        if self.file_url is not None:
            result['FileUrl'] = self.file_url
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DocName') is not None:
            self.doc_name = m.get('DocName')
        if m.get('FileUrl') is not None:
            self.file_url = m.get('FileUrl')
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        return self


class GetFileContentLengthResponseBodyData(TeaModel):
    def __init__(
        self,
        word_num: int = None,
    ):
        self.word_num = word_num

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.word_num is not None:
            result['WordNum'] = self.word_num
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('WordNum') is not None:
            self.word_num = m.get('WordNum')
        return self


class GetFileContentLengthResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GetFileContentLengthResponseBodyData = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetFileContentLengthResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetFileContentLengthResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetFileContentLengthResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetFileContentLengthResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetGeneratedContentRequest(TeaModel):
    def __init__(
        self,
        agent_key: str = None,
        id: int = None,
    ):
        # This parameter is required.
        self.agent_key = agent_key
        # This parameter is required.
        self.id = id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_key is not None:
            result['AgentKey'] = self.agent_key
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentKey') is not None:
            self.agent_key = m.get('AgentKey')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class GetGeneratedContentResponseBodyData(TeaModel):
    def __init__(
        self,
        content: str = None,
        content_domain: str = None,
        content_text: str = None,
        create_time: str = None,
        create_user: str = None,
        device_id: str = None,
        id: int = None,
        ignore_content_audit_words: str = None,
        keyword_list: List[str] = None,
        keywords: str = None,
        prompt: str = None,
        task_id: str = None,
        title: str = None,
        update_time: str = None,
        update_user: str = None,
        uuid: str = None,
    ):
        self.content = content
        self.content_domain = content_domain
        self.content_text = content_text
        self.create_time = create_time
        self.create_user = create_user
        self.device_id = device_id
        self.id = id
        self.ignore_content_audit_words = ignore_content_audit_words
        self.keyword_list = keyword_list
        self.keywords = keywords
        self.prompt = prompt
        self.task_id = task_id
        self.title = title
        self.update_time = update_time
        self.update_user = update_user
        self.uuid = uuid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.content_domain is not None:
            result['ContentDomain'] = self.content_domain
        if self.content_text is not None:
            result['ContentText'] = self.content_text
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.create_user is not None:
            result['CreateUser'] = self.create_user
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.id is not None:
            result['Id'] = self.id
        if self.ignore_content_audit_words is not None:
            result['IgnoreContentAuditWords'] = self.ignore_content_audit_words
        if self.keyword_list is not None:
            result['KeywordList'] = self.keyword_list
        if self.keywords is not None:
            result['Keywords'] = self.keywords
        if self.prompt is not None:
            result['Prompt'] = self.prompt
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.title is not None:
            result['Title'] = self.title
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        if self.update_user is not None:
            result['UpdateUser'] = self.update_user
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('ContentDomain') is not None:
            self.content_domain = m.get('ContentDomain')
        if m.get('ContentText') is not None:
            self.content_text = m.get('ContentText')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('CreateUser') is not None:
            self.create_user = m.get('CreateUser')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('IgnoreContentAuditWords') is not None:
            self.ignore_content_audit_words = m.get('IgnoreContentAuditWords')
        if m.get('KeywordList') is not None:
            self.keyword_list = m.get('KeywordList')
        if m.get('Keywords') is not None:
            self.keywords = m.get('Keywords')
        if m.get('Prompt') is not None:
            self.prompt = m.get('Prompt')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        if m.get('UpdateUser') is not None:
            self.update_user = m.get('UpdateUser')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class GetGeneratedContentResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GetGeneratedContentResponseBodyData = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetGeneratedContentResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetGeneratedContentResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetGeneratedContentResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetGeneratedContentResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetHotTopicBroadcastRequestStepForCustomSummaryStyleConfig(TeaModel):
    def __init__(
        self,
        summary_image_count: int = None,
        summary_model: str = None,
        summary_prompt: str = None,
    ):
        self.summary_image_count = summary_image_count
        self.summary_model = summary_model
        self.summary_prompt = summary_prompt

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.summary_image_count is not None:
            result['SummaryImageCount'] = self.summary_image_count
        if self.summary_model is not None:
            result['SummaryModel'] = self.summary_model
        if self.summary_prompt is not None:
            result['SummaryPrompt'] = self.summary_prompt
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SummaryImageCount') is not None:
            self.summary_image_count = m.get('SummaryImageCount')
        if m.get('SummaryModel') is not None:
            self.summary_model = m.get('SummaryModel')
        if m.get('SummaryPrompt') is not None:
            self.summary_prompt = m.get('SummaryPrompt')
        return self


class GetHotTopicBroadcastRequestStepForNewsBroadcastContentConfigCustomHotValueWeights(TeaModel):
    def __init__(
        self,
        dimension: str = None,
        weight: int = None,
    ):
        self.dimension = dimension
        self.weight = weight

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dimension is not None:
            result['Dimension'] = self.dimension
        if self.weight is not None:
            result['Weight'] = self.weight
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Dimension') is not None:
            self.dimension = m.get('Dimension')
        if m.get('Weight') is not None:
            self.weight = m.get('Weight')
        return self


class GetHotTopicBroadcastRequestStepForNewsBroadcastContentConfig(TeaModel):
    def __init__(
        self,
        categories: List[str] = None,
        custom_hot_value_weights: List[GetHotTopicBroadcastRequestStepForNewsBroadcastContentConfigCustomHotValueWeights] = None,
        topic_count: int = None,
    ):
        self.categories = categories
        self.custom_hot_value_weights = custom_hot_value_weights
        self.topic_count = topic_count

    def validate(self):
        if self.custom_hot_value_weights:
            for k in self.custom_hot_value_weights:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.categories is not None:
            result['Categories'] = self.categories
        result['CustomHotValueWeights'] = []
        if self.custom_hot_value_weights is not None:
            for k in self.custom_hot_value_weights:
                result['CustomHotValueWeights'].append(k.to_map() if k else None)
        if self.topic_count is not None:
            result['TopicCount'] = self.topic_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Categories') is not None:
            self.categories = m.get('Categories')
        self.custom_hot_value_weights = []
        if m.get('CustomHotValueWeights') is not None:
            for k in m.get('CustomHotValueWeights'):
                temp_model = GetHotTopicBroadcastRequestStepForNewsBroadcastContentConfigCustomHotValueWeights()
                self.custom_hot_value_weights.append(temp_model.from_map(k))
        if m.get('TopicCount') is not None:
            self.topic_count = m.get('TopicCount')
        return self


class GetHotTopicBroadcastRequest(TeaModel):
    def __init__(
        self,
        calc_total_token: bool = None,
        category: str = None,
        current: int = None,
        hot_topic_version: str = None,
        location_query: str = None,
        locations: List[str] = None,
        query: str = None,
        size: int = None,
        step_for_custom_summary_style_config: GetHotTopicBroadcastRequestStepForCustomSummaryStyleConfig = None,
        step_for_news_broadcast_content_config: GetHotTopicBroadcastRequestStepForNewsBroadcastContentConfig = None,
        topics: List[str] = None,
        workspace_id: str = None,
    ):
        self.calc_total_token = calc_total_token
        self.category = category
        self.current = current
        self.hot_topic_version = hot_topic_version
        self.location_query = location_query
        self.locations = locations
        self.query = query
        self.size = size
        self.step_for_custom_summary_style_config = step_for_custom_summary_style_config
        self.step_for_news_broadcast_content_config = step_for_news_broadcast_content_config
        self.topics = topics
        # This parameter is required.
        self.workspace_id = workspace_id

    def validate(self):
        if self.step_for_custom_summary_style_config:
            self.step_for_custom_summary_style_config.validate()
        if self.step_for_news_broadcast_content_config:
            self.step_for_news_broadcast_content_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.calc_total_token is not None:
            result['CalcTotalToken'] = self.calc_total_token
        if self.category is not None:
            result['Category'] = self.category
        if self.current is not None:
            result['Current'] = self.current
        if self.hot_topic_version is not None:
            result['HotTopicVersion'] = self.hot_topic_version
        if self.location_query is not None:
            result['LocationQuery'] = self.location_query
        if self.locations is not None:
            result['Locations'] = self.locations
        if self.query is not None:
            result['Query'] = self.query
        if self.size is not None:
            result['Size'] = self.size
        if self.step_for_custom_summary_style_config is not None:
            result['StepForCustomSummaryStyleConfig'] = self.step_for_custom_summary_style_config.to_map()
        if self.step_for_news_broadcast_content_config is not None:
            result['StepForNewsBroadcastContentConfig'] = self.step_for_news_broadcast_content_config.to_map()
        if self.topics is not None:
            result['Topics'] = self.topics
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CalcTotalToken') is not None:
            self.calc_total_token = m.get('CalcTotalToken')
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('Current') is not None:
            self.current = m.get('Current')
        if m.get('HotTopicVersion') is not None:
            self.hot_topic_version = m.get('HotTopicVersion')
        if m.get('LocationQuery') is not None:
            self.location_query = m.get('LocationQuery')
        if m.get('Locations') is not None:
            self.locations = m.get('Locations')
        if m.get('Query') is not None:
            self.query = m.get('Query')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('StepForCustomSummaryStyleConfig') is not None:
            temp_model = GetHotTopicBroadcastRequestStepForCustomSummaryStyleConfig()
            self.step_for_custom_summary_style_config = temp_model.from_map(m['StepForCustomSummaryStyleConfig'])
        if m.get('StepForNewsBroadcastContentConfig') is not None:
            temp_model = GetHotTopicBroadcastRequestStepForNewsBroadcastContentConfig()
            self.step_for_news_broadcast_content_config = temp_model.from_map(m['StepForNewsBroadcastContentConfig'])
        if m.get('Topics') is not None:
            self.topics = m.get('Topics')
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        return self


class GetHotTopicBroadcastShrinkRequest(TeaModel):
    def __init__(
        self,
        calc_total_token: bool = None,
        category: str = None,
        current: int = None,
        hot_topic_version: str = None,
        location_query: str = None,
        locations_shrink: str = None,
        query: str = None,
        size: int = None,
        step_for_custom_summary_style_config_shrink: str = None,
        step_for_news_broadcast_content_config_shrink: str = None,
        topics_shrink: str = None,
        workspace_id: str = None,
    ):
        self.calc_total_token = calc_total_token
        self.category = category
        self.current = current
        self.hot_topic_version = hot_topic_version
        self.location_query = location_query
        self.locations_shrink = locations_shrink
        self.query = query
        self.size = size
        self.step_for_custom_summary_style_config_shrink = step_for_custom_summary_style_config_shrink
        self.step_for_news_broadcast_content_config_shrink = step_for_news_broadcast_content_config_shrink
        self.topics_shrink = topics_shrink
        # This parameter is required.
        self.workspace_id = workspace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.calc_total_token is not None:
            result['CalcTotalToken'] = self.calc_total_token
        if self.category is not None:
            result['Category'] = self.category
        if self.current is not None:
            result['Current'] = self.current
        if self.hot_topic_version is not None:
            result['HotTopicVersion'] = self.hot_topic_version
        if self.location_query is not None:
            result['LocationQuery'] = self.location_query
        if self.locations_shrink is not None:
            result['Locations'] = self.locations_shrink
        if self.query is not None:
            result['Query'] = self.query
        if self.size is not None:
            result['Size'] = self.size
        if self.step_for_custom_summary_style_config_shrink is not None:
            result['StepForCustomSummaryStyleConfig'] = self.step_for_custom_summary_style_config_shrink
        if self.step_for_news_broadcast_content_config_shrink is not None:
            result['StepForNewsBroadcastContentConfig'] = self.step_for_news_broadcast_content_config_shrink
        if self.topics_shrink is not None:
            result['Topics'] = self.topics_shrink
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CalcTotalToken') is not None:
            self.calc_total_token = m.get('CalcTotalToken')
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('Current') is not None:
            self.current = m.get('Current')
        if m.get('HotTopicVersion') is not None:
            self.hot_topic_version = m.get('HotTopicVersion')
        if m.get('LocationQuery') is not None:
            self.location_query = m.get('LocationQuery')
        if m.get('Locations') is not None:
            self.locations_shrink = m.get('Locations')
        if m.get('Query') is not None:
            self.query = m.get('Query')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('StepForCustomSummaryStyleConfig') is not None:
            self.step_for_custom_summary_style_config_shrink = m.get('StepForCustomSummaryStyleConfig')
        if m.get('StepForNewsBroadcastContentConfig') is not None:
            self.step_for_news_broadcast_content_config_shrink = m.get('StepForNewsBroadcastContentConfig')
        if m.get('Topics') is not None:
            self.topics_shrink = m.get('Topics')
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        return self


class GetHotTopicBroadcastResponseBodyDataDataImages(TeaModel):
    def __init__(
        self,
        url: str = None,
    ):
        self.url = url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.url is not None:
            result['Url'] = self.url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Url') is not None:
            self.url = m.get('Url')
        return self


class GetHotTopicBroadcastResponseBodyDataDataNewsComments(TeaModel):
    def __init__(
        self,
        text: str = None,
        username: str = None,
    ):
        self.text = text
        self.username = username

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.text is not None:
            result['Text'] = self.text
        if self.username is not None:
            result['Username'] = self.username
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Text') is not None:
            self.text = m.get('Text')
        if m.get('Username') is not None:
            self.username = m.get('Username')
        return self


class GetHotTopicBroadcastResponseBodyDataDataNews(TeaModel):
    def __init__(
        self,
        analysis_category: str = None,
        analysis_topic: str = None,
        author: str = None,
        category: List[str] = None,
        comments: List[GetHotTopicBroadcastResponseBodyDataDataNewsComments] = None,
        content: str = None,
        create_time: str = None,
        domain: str = None,
        dt: str = None,
        hot_topic: str = None,
        img_list: List[str] = None,
        logo: str = None,
        pub_time: str = None,
        summary: str = None,
        title: str = None,
        url: str = None,
        uuid: str = None,
        website: str = None,
    ):
        self.analysis_category = analysis_category
        self.analysis_topic = analysis_topic
        self.author = author
        self.category = category
        self.comments = comments
        self.content = content
        self.create_time = create_time
        self.domain = domain
        self.dt = dt
        self.hot_topic = hot_topic
        self.img_list = img_list
        # logo
        self.logo = logo
        self.pub_time = pub_time
        self.summary = summary
        self.title = title
        self.url = url
        self.uuid = uuid
        self.website = website

    def validate(self):
        if self.comments:
            for k in self.comments:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.analysis_category is not None:
            result['AnalysisCategory'] = self.analysis_category
        if self.analysis_topic is not None:
            result['AnalysisTopic'] = self.analysis_topic
        if self.author is not None:
            result['Author'] = self.author
        if self.category is not None:
            result['Category'] = self.category
        result['Comments'] = []
        if self.comments is not None:
            for k in self.comments:
                result['Comments'].append(k.to_map() if k else None)
        if self.content is not None:
            result['Content'] = self.content
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.domain is not None:
            result['Domain'] = self.domain
        if self.dt is not None:
            result['Dt'] = self.dt
        if self.hot_topic is not None:
            result['HotTopic'] = self.hot_topic
        if self.img_list is not None:
            result['ImgList'] = self.img_list
        if self.logo is not None:
            result['Logo'] = self.logo
        if self.pub_time is not None:
            result['PubTime'] = self.pub_time
        if self.summary is not None:
            result['Summary'] = self.summary
        if self.title is not None:
            result['Title'] = self.title
        if self.url is not None:
            result['Url'] = self.url
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        if self.website is not None:
            result['Website'] = self.website
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AnalysisCategory') is not None:
            self.analysis_category = m.get('AnalysisCategory')
        if m.get('AnalysisTopic') is not None:
            self.analysis_topic = m.get('AnalysisTopic')
        if m.get('Author') is not None:
            self.author = m.get('Author')
        if m.get('Category') is not None:
            self.category = m.get('Category')
        self.comments = []
        if m.get('Comments') is not None:
            for k in m.get('Comments'):
                temp_model = GetHotTopicBroadcastResponseBodyDataDataNewsComments()
                self.comments.append(temp_model.from_map(k))
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Domain') is not None:
            self.domain = m.get('Domain')
        if m.get('Dt') is not None:
            self.dt = m.get('Dt')
        if m.get('HotTopic') is not None:
            self.hot_topic = m.get('HotTopic')
        if m.get('ImgList') is not None:
            self.img_list = m.get('ImgList')
        if m.get('Logo') is not None:
            self.logo = m.get('Logo')
        if m.get('PubTime') is not None:
            self.pub_time = m.get('PubTime')
        if m.get('Summary') is not None:
            self.summary = m.get('Summary')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        if m.get('Website') is not None:
            self.website = m.get('Website')
        return self


class GetHotTopicBroadcastResponseBodyDataDataSummarySummaries(TeaModel):
    def __init__(
        self,
        summary: str = None,
        title: str = None,
    ):
        self.summary = summary
        self.title = title

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.summary is not None:
            result['Summary'] = self.summary
        if self.title is not None:
            result['Title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Summary') is not None:
            self.summary = m.get('Summary')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        return self


class GetHotTopicBroadcastResponseBodyDataDataSummary(TeaModel):
    def __init__(
        self,
        input_token: int = None,
        output_token: int = None,
        summaries: List[GetHotTopicBroadcastResponseBodyDataDataSummarySummaries] = None,
    ):
        self.input_token = input_token
        self.output_token = output_token
        self.summaries = summaries

    def validate(self):
        if self.summaries:
            for k in self.summaries:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.input_token is not None:
            result['InputToken'] = self.input_token
        if self.output_token is not None:
            result['OutputToken'] = self.output_token
        result['Summaries'] = []
        if self.summaries is not None:
            for k in self.summaries:
                result['Summaries'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InputToken') is not None:
            self.input_token = m.get('InputToken')
        if m.get('OutputToken') is not None:
            self.output_token = m.get('OutputToken')
        self.summaries = []
        if m.get('Summaries') is not None:
            for k in m.get('Summaries'):
                temp_model = GetHotTopicBroadcastResponseBodyDataDataSummarySummaries()
                self.summaries.append(temp_model.from_map(k))
        return self


class GetHotTopicBroadcastResponseBodyDataData(TeaModel):
    def __init__(
        self,
        category: str = None,
        create_time: str = None,
        custom_hot_value: float = None,
        custom_text_summary: str = None,
        hot_topic: str = None,
        hot_topic_version: str = None,
        hot_value: float = None,
        id: str = None,
        images: List[GetHotTopicBroadcastResponseBodyDataDataImages] = None,
        input_token: int = None,
        locations: List[str] = None,
        news: List[GetHotTopicBroadcastResponseBodyDataDataNews] = None,
        output_token: int = None,
        pub_time: str = None,
        summary: GetHotTopicBroadcastResponseBodyDataDataSummary = None,
        text_summary: str = None,
        url: str = None,
    ):
        self.category = category
        self.create_time = create_time
        self.custom_hot_value = custom_hot_value
        self.custom_text_summary = custom_text_summary
        self.hot_topic = hot_topic
        self.hot_topic_version = hot_topic_version
        self.hot_value = hot_value
        self.id = id
        self.images = images
        self.input_token = input_token
        self.locations = locations
        self.news = news
        self.output_token = output_token
        self.pub_time = pub_time
        self.summary = summary
        self.text_summary = text_summary
        self.url = url

    def validate(self):
        if self.images:
            for k in self.images:
                if k:
                    k.validate()
        if self.news:
            for k in self.news:
                if k:
                    k.validate()
        if self.summary:
            self.summary.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category is not None:
            result['Category'] = self.category
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.custom_hot_value is not None:
            result['CustomHotValue'] = self.custom_hot_value
        if self.custom_text_summary is not None:
            result['CustomTextSummary'] = self.custom_text_summary
        if self.hot_topic is not None:
            result['HotTopic'] = self.hot_topic
        if self.hot_topic_version is not None:
            result['HotTopicVersion'] = self.hot_topic_version
        if self.hot_value is not None:
            result['HotValue'] = self.hot_value
        if self.id is not None:
            result['Id'] = self.id
        result['Images'] = []
        if self.images is not None:
            for k in self.images:
                result['Images'].append(k.to_map() if k else None)
        if self.input_token is not None:
            result['InputToken'] = self.input_token
        if self.locations is not None:
            result['Locations'] = self.locations
        result['News'] = []
        if self.news is not None:
            for k in self.news:
                result['News'].append(k.to_map() if k else None)
        if self.output_token is not None:
            result['OutputToken'] = self.output_token
        if self.pub_time is not None:
            result['PubTime'] = self.pub_time
        if self.summary is not None:
            result['Summary'] = self.summary.to_map()
        if self.text_summary is not None:
            result['TextSummary'] = self.text_summary
        if self.url is not None:
            result['Url'] = self.url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('CustomHotValue') is not None:
            self.custom_hot_value = m.get('CustomHotValue')
        if m.get('CustomTextSummary') is not None:
            self.custom_text_summary = m.get('CustomTextSummary')
        if m.get('HotTopic') is not None:
            self.hot_topic = m.get('HotTopic')
        if m.get('HotTopicVersion') is not None:
            self.hot_topic_version = m.get('HotTopicVersion')
        if m.get('HotValue') is not None:
            self.hot_value = m.get('HotValue')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        self.images = []
        if m.get('Images') is not None:
            for k in m.get('Images'):
                temp_model = GetHotTopicBroadcastResponseBodyDataDataImages()
                self.images.append(temp_model.from_map(k))
        if m.get('InputToken') is not None:
            self.input_token = m.get('InputToken')
        if m.get('Locations') is not None:
            self.locations = m.get('Locations')
        self.news = []
        if m.get('News') is not None:
            for k in m.get('News'):
                temp_model = GetHotTopicBroadcastResponseBodyDataDataNews()
                self.news.append(temp_model.from_map(k))
        if m.get('OutputToken') is not None:
            self.output_token = m.get('OutputToken')
        if m.get('PubTime') is not None:
            self.pub_time = m.get('PubTime')
        if m.get('Summary') is not None:
            temp_model = GetHotTopicBroadcastResponseBodyDataDataSummary()
            self.summary = temp_model.from_map(m['Summary'])
        if m.get('TextSummary') is not None:
            self.text_summary = m.get('TextSummary')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        return self


class GetHotTopicBroadcastResponseBodyDataTotalTokenInfo(TeaModel):
    def __init__(
        self,
        hot_topic_count: int = None,
        input_tokens: int = None,
        output_tokens: int = None,
        word_count: int = None,
    ):
        self.hot_topic_count = hot_topic_count
        self.input_tokens = input_tokens
        self.output_tokens = output_tokens
        self.word_count = word_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.hot_topic_count is not None:
            result['HotTopicCount'] = self.hot_topic_count
        if self.input_tokens is not None:
            result['InputTokens'] = self.input_tokens
        if self.output_tokens is not None:
            result['OutputTokens'] = self.output_tokens
        if self.word_count is not None:
            result['WordCount'] = self.word_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HotTopicCount') is not None:
            self.hot_topic_count = m.get('HotTopicCount')
        if m.get('InputTokens') is not None:
            self.input_tokens = m.get('InputTokens')
        if m.get('OutputTokens') is not None:
            self.output_tokens = m.get('OutputTokens')
        if m.get('WordCount') is not None:
            self.word_count = m.get('WordCount')
        return self


class GetHotTopicBroadcastResponseBodyData(TeaModel):
    def __init__(
        self,
        data: List[GetHotTopicBroadcastResponseBodyDataData] = None,
        total_count: int = None,
        total_token_info: GetHotTopicBroadcastResponseBodyDataTotalTokenInfo = None,
    ):
        self.data = data
        self.total_count = total_count
        self.total_token_info = total_token_info

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()
        if self.total_token_info:
            self.total_token_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.total_token_info is not None:
            result['TotalTokenInfo'] = self.total_token_info.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = GetHotTopicBroadcastResponseBodyDataData()
                self.data.append(temp_model.from_map(k))
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('TotalTokenInfo') is not None:
            temp_model = GetHotTopicBroadcastResponseBodyDataTotalTokenInfo()
            self.total_token_info = temp_model.from_map(m['TotalTokenInfo'])
        return self


class GetHotTopicBroadcastResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GetHotTopicBroadcastResponseBodyData = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetHotTopicBroadcastResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetHotTopicBroadcastResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetHotTopicBroadcastResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetHotTopicBroadcastResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetInterveneGlobalReplyRequest(TeaModel):
    def __init__(
        self,
        agent_key: str = None,
    ):
        # This parameter is required.
        self.agent_key = agent_key

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_key is not None:
            result['AgentKey'] = self.agent_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentKey') is not None:
            self.agent_key = m.get('AgentKey')
        return self


class GetInterveneGlobalReplyResponseBodyDataReplyMessagList(TeaModel):
    def __init__(
        self,
        message: str = None,
        reply_type: str = None,
    ):
        self.message = message
        self.reply_type = reply_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.reply_type is not None:
            result['ReplyType'] = self.reply_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('ReplyType') is not None:
            self.reply_type = m.get('ReplyType')
        return self


class GetInterveneGlobalReplyResponseBodyData(TeaModel):
    def __init__(
        self,
        code: int = None,
        reply_messag_list: List[GetInterveneGlobalReplyResponseBodyDataReplyMessagList] = None,
    ):
        self.code = code
        self.reply_messag_list = reply_messag_list

    def validate(self):
        if self.reply_messag_list:
            for k in self.reply_messag_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['ReplyMessagList'] = []
        if self.reply_messag_list is not None:
            for k in self.reply_messag_list:
                result['ReplyMessagList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.reply_messag_list = []
        if m.get('ReplyMessagList') is not None:
            for k in m.get('ReplyMessagList'):
                temp_model = GetInterveneGlobalReplyResponseBodyDataReplyMessagList()
                self.reply_messag_list.append(temp_model.from_map(k))
        return self


class GetInterveneGlobalReplyResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GetInterveneGlobalReplyResponseBodyData = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetInterveneGlobalReplyResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetInterveneGlobalReplyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetInterveneGlobalReplyResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetInterveneGlobalReplyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetInterveneImportTaskInfoRequest(TeaModel):
    def __init__(
        self,
        agent_key: str = None,
        task_id: str = None,
    ):
        # This parameter is required.
        self.agent_key = agent_key
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_key is not None:
            result['AgentKey'] = self.agent_key
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentKey') is not None:
            self.agent_key = m.get('AgentKey')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class GetInterveneImportTaskInfoResponseBodyDataStatus(TeaModel):
    def __init__(
        self,
        msg: str = None,
        percentage: int = None,
        status: int = None,
        task_id: str = None,
        task_name: str = None,
    ):
        self.msg = msg
        self.percentage = percentage
        self.status = status
        self.task_id = task_id
        self.task_name = task_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.msg is not None:
            result['Msg'] = self.msg
        if self.percentage is not None:
            result['Percentage'] = self.percentage
        if self.status is not None:
            result['Status'] = self.status
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Msg') is not None:
            self.msg = m.get('Msg')
        if m.get('Percentage') is not None:
            self.percentage = m.get('Percentage')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        return self


class GetInterveneImportTaskInfoResponseBodyData(TeaModel):
    def __init__(
        self,
        code: int = None,
        status: GetInterveneImportTaskInfoResponseBodyDataStatus = None,
    ):
        self.code = code
        self.status = status

    def validate(self):
        if self.status:
            self.status.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.status is not None:
            result['Status'] = self.status.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Status') is not None:
            temp_model = GetInterveneImportTaskInfoResponseBodyDataStatus()
            self.status = temp_model.from_map(m['Status'])
        return self


class GetInterveneImportTaskInfoResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GetInterveneImportTaskInfoResponseBodyData = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetInterveneImportTaskInfoResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetInterveneImportTaskInfoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetInterveneImportTaskInfoResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetInterveneImportTaskInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetInterveneRuleDetailRequest(TeaModel):
    def __init__(
        self,
        agent_key: str = None,
        rule_id: int = None,
    ):
        # This parameter is required.
        self.agent_key = agent_key
        self.rule_id = rule_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_key is not None:
            result['AgentKey'] = self.agent_key
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentKey') is not None:
            self.agent_key = m.get('AgentKey')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class GetInterveneRuleDetailResponseBodyDataInterveneRuleDetailAnswerConfig(TeaModel):
    def __init__(
        self,
        answer_type: int = None,
        message: str = None,
        namespace: str = None,
    ):
        self.answer_type = answer_type
        self.message = message
        self.namespace = namespace

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.answer_type is not None:
            result['AnswerType'] = self.answer_type
        if self.message is not None:
            result['Message'] = self.message
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AnswerType') is not None:
            self.answer_type = m.get('AnswerType')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        return self


class GetInterveneRuleDetailResponseBodyDataInterveneRuleDetailEffectConfig(TeaModel):
    def __init__(
        self,
        effect_type: int = None,
        end_time: str = None,
        start_time: str = None,
    ):
        self.effect_type = effect_type
        self.end_time = end_time
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.effect_type is not None:
            result['EffectType'] = self.effect_type
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EffectType') is not None:
            self.effect_type = m.get('EffectType')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class GetInterveneRuleDetailResponseBodyDataInterveneRuleDetail(TeaModel):
    def __init__(
        self,
        answer_config: List[GetInterveneRuleDetailResponseBodyDataInterveneRuleDetailAnswerConfig] = None,
        effect_config: GetInterveneRuleDetailResponseBodyDataInterveneRuleDetailEffectConfig = None,
        intervene_type: int = None,
        namespace_list: List[str] = None,
        rule_id: int = None,
        rule_name: str = None,
    ):
        self.answer_config = answer_config
        self.effect_config = effect_config
        self.intervene_type = intervene_type
        self.namespace_list = namespace_list
        self.rule_id = rule_id
        self.rule_name = rule_name

    def validate(self):
        if self.answer_config:
            for k in self.answer_config:
                if k:
                    k.validate()
        if self.effect_config:
            self.effect_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AnswerConfig'] = []
        if self.answer_config is not None:
            for k in self.answer_config:
                result['AnswerConfig'].append(k.to_map() if k else None)
        if self.effect_config is not None:
            result['EffectConfig'] = self.effect_config.to_map()
        if self.intervene_type is not None:
            result['InterveneType'] = self.intervene_type
        if self.namespace_list is not None:
            result['NamespaceList'] = self.namespace_list
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.answer_config = []
        if m.get('AnswerConfig') is not None:
            for k in m.get('AnswerConfig'):
                temp_model = GetInterveneRuleDetailResponseBodyDataInterveneRuleDetailAnswerConfig()
                self.answer_config.append(temp_model.from_map(k))
        if m.get('EffectConfig') is not None:
            temp_model = GetInterveneRuleDetailResponseBodyDataInterveneRuleDetailEffectConfig()
            self.effect_config = temp_model.from_map(m['EffectConfig'])
        if m.get('InterveneType') is not None:
            self.intervene_type = m.get('InterveneType')
        if m.get('NamespaceList') is not None:
            self.namespace_list = m.get('NamespaceList')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        return self


class GetInterveneRuleDetailResponseBodyData(TeaModel):
    def __init__(
        self,
        code: int = None,
        intervene_rule_detail: GetInterveneRuleDetailResponseBodyDataInterveneRuleDetail = None,
    ):
        self.code = code
        self.intervene_rule_detail = intervene_rule_detail

    def validate(self):
        if self.intervene_rule_detail:
            self.intervene_rule_detail.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.intervene_rule_detail is not None:
            result['InterveneRuleDetail'] = self.intervene_rule_detail.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('InterveneRuleDetail') is not None:
            temp_model = GetInterveneRuleDetailResponseBodyDataInterveneRuleDetail()
            self.intervene_rule_detail = temp_model.from_map(m['InterveneRuleDetail'])
        return self


class GetInterveneRuleDetailResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GetInterveneRuleDetailResponseBodyData = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetInterveneRuleDetailResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetInterveneRuleDetailResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetInterveneRuleDetailResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetInterveneRuleDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetInterveneTemplateFileUrlRequest(TeaModel):
    def __init__(
        self,
        agent_key: str = None,
    ):
        # This parameter is required.
        self.agent_key = agent_key

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_key is not None:
            result['AgentKey'] = self.agent_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentKey') is not None:
            self.agent_key = m.get('AgentKey')
        return self


class GetInterveneTemplateFileUrlResponseBodyData(TeaModel):
    def __init__(
        self,
        code: int = None,
        file_url: str = None,
    ):
        self.code = code
        self.file_url = file_url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.file_url is not None:
            result['FileUrl'] = self.file_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('FileUrl') is not None:
            self.file_url = m.get('FileUrl')
        return self


class GetInterveneTemplateFileUrlResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GetInterveneTemplateFileUrlResponseBodyData = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetInterveneTemplateFileUrlResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetInterveneTemplateFileUrlResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetInterveneTemplateFileUrlResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetInterveneTemplateFileUrlResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetMaterialByIdRequest(TeaModel):
    def __init__(
        self,
        agent_key: str = None,
        id: int = None,
    ):
        # This parameter is required.
        self.agent_key = agent_key
        # This parameter is required.
        self.id = id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_key is not None:
            result['AgentKey'] = self.agent_key
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentKey') is not None:
            self.agent_key = m.get('AgentKey')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class GetMaterialByIdResponseBodyData(TeaModel):
    def __init__(
        self,
        author: str = None,
        create_time: str = None,
        create_user: str = None,
        doc_keywords: List[str] = None,
        doc_type: str = None,
        external_url: str = None,
        html_content: str = None,
        id: int = None,
        pub_time: str = None,
        public_url: str = None,
        share_attr: int = None,
        src_from: str = None,
        summary: str = None,
        text_content: str = None,
        thumbnail_in_base_64: str = None,
        title: str = None,
        update_time: str = None,
        update_user: str = None,
        url: str = None,
    ):
        self.author = author
        self.create_time = create_time
        self.create_user = create_user
        self.doc_keywords = doc_keywords
        self.doc_type = doc_type
        self.external_url = external_url
        self.html_content = html_content
        self.id = id
        self.pub_time = pub_time
        self.public_url = public_url
        self.share_attr = share_attr
        self.src_from = src_from
        self.summary = summary
        self.text_content = text_content
        self.thumbnail_in_base_64 = thumbnail_in_base_64
        self.title = title
        self.update_time = update_time
        self.update_user = update_user
        self.url = url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.author is not None:
            result['Author'] = self.author
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.create_user is not None:
            result['CreateUser'] = self.create_user
        if self.doc_keywords is not None:
            result['DocKeywords'] = self.doc_keywords
        if self.doc_type is not None:
            result['DocType'] = self.doc_type
        if self.external_url is not None:
            result['ExternalUrl'] = self.external_url
        if self.html_content is not None:
            result['HtmlContent'] = self.html_content
        if self.id is not None:
            result['Id'] = self.id
        if self.pub_time is not None:
            result['PubTime'] = self.pub_time
        if self.public_url is not None:
            result['PublicUrl'] = self.public_url
        if self.share_attr is not None:
            result['ShareAttr'] = self.share_attr
        if self.src_from is not None:
            result['SrcFrom'] = self.src_from
        if self.summary is not None:
            result['Summary'] = self.summary
        if self.text_content is not None:
            result['TextContent'] = self.text_content
        if self.thumbnail_in_base_64 is not None:
            result['ThumbnailInBase64'] = self.thumbnail_in_base_64
        if self.title is not None:
            result['Title'] = self.title
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        if self.update_user is not None:
            result['UpdateUser'] = self.update_user
        if self.url is not None:
            result['Url'] = self.url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Author') is not None:
            self.author = m.get('Author')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('CreateUser') is not None:
            self.create_user = m.get('CreateUser')
        if m.get('DocKeywords') is not None:
            self.doc_keywords = m.get('DocKeywords')
        if m.get('DocType') is not None:
            self.doc_type = m.get('DocType')
        if m.get('ExternalUrl') is not None:
            self.external_url = m.get('ExternalUrl')
        if m.get('HtmlContent') is not None:
            self.html_content = m.get('HtmlContent')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('PubTime') is not None:
            self.pub_time = m.get('PubTime')
        if m.get('PublicUrl') is not None:
            self.public_url = m.get('PublicUrl')
        if m.get('ShareAttr') is not None:
            self.share_attr = m.get('ShareAttr')
        if m.get('SrcFrom') is not None:
            self.src_from = m.get('SrcFrom')
        if m.get('Summary') is not None:
            self.summary = m.get('Summary')
        if m.get('TextContent') is not None:
            self.text_content = m.get('TextContent')
        if m.get('ThumbnailInBase64') is not None:
            self.thumbnail_in_base_64 = m.get('ThumbnailInBase64')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        if m.get('UpdateUser') is not None:
            self.update_user = m.get('UpdateUser')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        return self


class GetMaterialByIdResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GetMaterialByIdResponseBodyData = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetMaterialByIdResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetMaterialByIdResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetMaterialByIdResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetMaterialByIdResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetPropertiesRequest(TeaModel):
    def __init__(
        self,
        agent_key: str = None,
    ):
        # This parameter is required.
        self.agent_key = agent_key

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_key is not None:
            result['AgentKey'] = self.agent_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentKey') is not None:
            self.agent_key = m.get('AgentKey')
        return self


class GetPropertiesResponseBodyDataConsoleConfig(TeaModel):
    def __init__(
        self,
        tip_content: str = None,
        title: str = None,
    ):
        self.tip_content = tip_content
        self.title = title

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tip_content is not None:
            result['TipContent'] = self.tip_content
        if self.title is not None:
            result['Title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TipContent') is not None:
            self.tip_content = m.get('TipContent')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        return self


class GetPropertiesResponseBodyDataIntelligentSearchConfigCopilotPreciseSearchSources(TeaModel):
    def __init__(
        self,
        code: str = None,
        dataset_name: str = None,
        name: str = None,
    ):
        self.code = code
        self.dataset_name = dataset_name
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.dataset_name is not None:
            result['DatasetName'] = self.dataset_name
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('DatasetName') is not None:
            self.dataset_name = m.get('DatasetName')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class GetPropertiesResponseBodyDataIntelligentSearchConfigSearchSamplesArticles(TeaModel):
    def __init__(
        self,
        select: bool = None,
        stared: bool = None,
        title: str = None,
        url: str = None,
    ):
        self.select = select
        self.stared = stared
        self.title = title
        self.url = url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.select is not None:
            result['Select'] = self.select
        if self.stared is not None:
            result['Stared'] = self.stared
        if self.title is not None:
            result['Title'] = self.title
        if self.url is not None:
            result['Url'] = self.url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Select') is not None:
            self.select = m.get('Select')
        if m.get('Stared') is not None:
            self.stared = m.get('Stared')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        return self


class GetPropertiesResponseBodyDataIntelligentSearchConfigSearchSamples(TeaModel):
    def __init__(
        self,
        articles: List[GetPropertiesResponseBodyDataIntelligentSearchConfigSearchSamplesArticles] = None,
        prompt: str = None,
        text: str = None,
    ):
        self.articles = articles
        self.prompt = prompt
        self.text = text

    def validate(self):
        if self.articles:
            for k in self.articles:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Articles'] = []
        if self.articles is not None:
            for k in self.articles:
                result['Articles'].append(k.to_map() if k else None)
        if self.prompt is not None:
            result['Prompt'] = self.prompt
        if self.text is not None:
            result['Text'] = self.text
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.articles = []
        if m.get('Articles') is not None:
            for k in m.get('Articles'):
                temp_model = GetPropertiesResponseBodyDataIntelligentSearchConfigSearchSamplesArticles()
                self.articles.append(temp_model.from_map(k))
        if m.get('Prompt') is not None:
            self.prompt = m.get('Prompt')
        if m.get('Text') is not None:
            self.text = m.get('Text')
        return self


class GetPropertiesResponseBodyDataIntelligentSearchConfigSearchSources(TeaModel):
    def __init__(
        self,
        code: str = None,
        dataset_name: str = None,
        name: str = None,
    ):
        self.code = code
        self.dataset_name = dataset_name
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.dataset_name is not None:
            result['DatasetName'] = self.dataset_name
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('DatasetName') is not None:
            self.dataset_name = m.get('DatasetName')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class GetPropertiesResponseBodyDataIntelligentSearchConfig(TeaModel):
    def __init__(
        self,
        copilot_precise_search_sources: List[GetPropertiesResponseBodyDataIntelligentSearchConfigCopilotPreciseSearchSources] = None,
        product_description: str = None,
        search_samples: List[GetPropertiesResponseBodyDataIntelligentSearchConfigSearchSamples] = None,
        search_sources: List[GetPropertiesResponseBodyDataIntelligentSearchConfigSearchSources] = None,
    ):
        self.copilot_precise_search_sources = copilot_precise_search_sources
        self.product_description = product_description
        self.search_samples = search_samples
        self.search_sources = search_sources

    def validate(self):
        if self.copilot_precise_search_sources:
            for k in self.copilot_precise_search_sources:
                if k:
                    k.validate()
        if self.search_samples:
            for k in self.search_samples:
                if k:
                    k.validate()
        if self.search_sources:
            for k in self.search_sources:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CopilotPreciseSearchSources'] = []
        if self.copilot_precise_search_sources is not None:
            for k in self.copilot_precise_search_sources:
                result['CopilotPreciseSearchSources'].append(k.to_map() if k else None)
        if self.product_description is not None:
            result['ProductDescription'] = self.product_description
        result['SearchSamples'] = []
        if self.search_samples is not None:
            for k in self.search_samples:
                result['SearchSamples'].append(k.to_map() if k else None)
        result['SearchSources'] = []
        if self.search_sources is not None:
            for k in self.search_sources:
                result['SearchSources'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.copilot_precise_search_sources = []
        if m.get('CopilotPreciseSearchSources') is not None:
            for k in m.get('CopilotPreciseSearchSources'):
                temp_model = GetPropertiesResponseBodyDataIntelligentSearchConfigCopilotPreciseSearchSources()
                self.copilot_precise_search_sources.append(temp_model.from_map(k))
        if m.get('ProductDescription') is not None:
            self.product_description = m.get('ProductDescription')
        self.search_samples = []
        if m.get('SearchSamples') is not None:
            for k in m.get('SearchSamples'):
                temp_model = GetPropertiesResponseBodyDataIntelligentSearchConfigSearchSamples()
                self.search_samples.append(temp_model.from_map(k))
        self.search_sources = []
        if m.get('SearchSources') is not None:
            for k in m.get('SearchSources'):
                temp_model = GetPropertiesResponseBodyDataIntelligentSearchConfigSearchSources()
                self.search_sources.append(temp_model.from_map(k))
        return self


class GetPropertiesResponseBodyDataMiaosouConfigModelInfos(TeaModel):
    def __init__(
        self,
        model_id: str = None,
        model_name: str = None,
    ):
        self.model_id = model_id
        self.model_name = model_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.model_id is not None:
            result['ModelId'] = self.model_id
        if self.model_name is not None:
            result['ModelName'] = self.model_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ModelId') is not None:
            self.model_id = m.get('ModelId')
        if m.get('ModelName') is not None:
            self.model_name = m.get('ModelName')
        return self


class GetPropertiesResponseBodyDataMiaosouConfig(TeaModel):
    def __init__(
        self,
        max_doc_size: int = None,
        model_infos: List[GetPropertiesResponseBodyDataMiaosouConfigModelInfos] = None,
        use_doc_size: int = None,
    ):
        self.max_doc_size = max_doc_size
        self.model_infos = model_infos
        self.use_doc_size = use_doc_size

    def validate(self):
        if self.model_infos:
            for k in self.model_infos:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.max_doc_size is not None:
            result['MaxDocSize'] = self.max_doc_size
        result['ModelInfos'] = []
        if self.model_infos is not None:
            for k in self.model_infos:
                result['ModelInfos'].append(k.to_map() if k else None)
        if self.use_doc_size is not None:
            result['UseDocSize'] = self.use_doc_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MaxDocSize') is not None:
            self.max_doc_size = m.get('MaxDocSize')
        self.model_infos = []
        if m.get('ModelInfos') is not None:
            for k in m.get('ModelInfos'):
                temp_model = GetPropertiesResponseBodyDataMiaosouConfigModelInfos()
                self.model_infos.append(temp_model.from_map(k))
        if m.get('UseDocSize') is not None:
            self.use_doc_size = m.get('UseDocSize')
        return self


class GetPropertiesResponseBodyDataSearchSourceList(TeaModel):
    def __init__(
        self,
        code: str = None,
        dataset_name: str = None,
        name: str = None,
    ):
        self.code = code
        self.dataset_name = dataset_name
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.dataset_name is not None:
            result['DatasetName'] = self.dataset_name
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('DatasetName') is not None:
            self.dataset_name = m.get('DatasetName')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class GetPropertiesResponseBodyDataSearchSources(TeaModel):
    def __init__(
        self,
        label: str = None,
        value: str = None,
    ):
        self.label = label
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.label is not None:
            result['Label'] = self.label
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class GetPropertiesResponseBodyDataUserInfo(TeaModel):
    def __init__(
        self,
        agent_id: str = None,
        tenant_id: str = None,
        user_id: str = None,
        username: str = None,
    ):
        self.agent_id = agent_id
        self.tenant_id = tenant_id
        self.user_id = user_id
        self.username = username

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_id is not None:
            result['AgentId'] = self.agent_id
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.username is not None:
            result['Username'] = self.username
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentId') is not None:
            self.agent_id = m.get('AgentId')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('Username') is not None:
            self.username = m.get('Username')
        return self


class GetPropertiesResponseBodyDataWanxiangImageSizeConfig(TeaModel):
    def __init__(
        self,
        name: str = None,
        value: str = None,
    ):
        self.name = name
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class GetPropertiesResponseBodyDataWanxiangImageStyleConfig(TeaModel):
    def __init__(
        self,
        name: str = None,
        pic: str = None,
        value: str = None,
    ):
        self.name = name
        self.pic = pic
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.pic is not None:
            result['Pic'] = self.pic
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Pic') is not None:
            self.pic = m.get('Pic')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class GetPropertiesResponseBodyData(TeaModel):
    def __init__(
        self,
        chat_config: Dict[str, Any] = None,
        console_config: GetPropertiesResponseBodyDataConsoleConfig = None,
        general_config_map: Dict[str, Any] = None,
        intelligent_search_config: GetPropertiesResponseBodyDataIntelligentSearchConfig = None,
        miaosou_config: GetPropertiesResponseBodyDataMiaosouConfig = None,
        search_source_list: List[GetPropertiesResponseBodyDataSearchSourceList] = None,
        search_sources: List[GetPropertiesResponseBodyDataSearchSources] = None,
        slr_authorized: bool = None,
        user_info: GetPropertiesResponseBodyDataUserInfo = None,
        wanxiang_image_size_config: List[GetPropertiesResponseBodyDataWanxiangImageSizeConfig] = None,
        wanxiang_image_style_config: List[GetPropertiesResponseBodyDataWanxiangImageStyleConfig] = None,
    ):
        self.chat_config = chat_config
        self.console_config = console_config
        self.general_config_map = general_config_map
        self.intelligent_search_config = intelligent_search_config
        self.miaosou_config = miaosou_config
        self.search_source_list = search_source_list
        self.search_sources = search_sources
        self.slr_authorized = slr_authorized
        self.user_info = user_info
        self.wanxiang_image_size_config = wanxiang_image_size_config
        self.wanxiang_image_style_config = wanxiang_image_style_config

    def validate(self):
        if self.console_config:
            self.console_config.validate()
        if self.intelligent_search_config:
            self.intelligent_search_config.validate()
        if self.miaosou_config:
            self.miaosou_config.validate()
        if self.search_source_list:
            for k in self.search_source_list:
                if k:
                    k.validate()
        if self.search_sources:
            for k in self.search_sources:
                if k:
                    k.validate()
        if self.user_info:
            self.user_info.validate()
        if self.wanxiang_image_size_config:
            for k in self.wanxiang_image_size_config:
                if k:
                    k.validate()
        if self.wanxiang_image_style_config:
            for k in self.wanxiang_image_style_config:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.chat_config is not None:
            result['ChatConfig'] = self.chat_config
        if self.console_config is not None:
            result['ConsoleConfig'] = self.console_config.to_map()
        if self.general_config_map is not None:
            result['GeneralConfigMap'] = self.general_config_map
        if self.intelligent_search_config is not None:
            result['IntelligentSearchConfig'] = self.intelligent_search_config.to_map()
        if self.miaosou_config is not None:
            result['MiaosouConfig'] = self.miaosou_config.to_map()
        result['SearchSourceList'] = []
        if self.search_source_list is not None:
            for k in self.search_source_list:
                result['SearchSourceList'].append(k.to_map() if k else None)
        result['SearchSources'] = []
        if self.search_sources is not None:
            for k in self.search_sources:
                result['SearchSources'].append(k.to_map() if k else None)
        if self.slr_authorized is not None:
            result['SlrAuthorized'] = self.slr_authorized
        if self.user_info is not None:
            result['UserInfo'] = self.user_info.to_map()
        result['WanxiangImageSizeConfig'] = []
        if self.wanxiang_image_size_config is not None:
            for k in self.wanxiang_image_size_config:
                result['WanxiangImageSizeConfig'].append(k.to_map() if k else None)
        result['WanxiangImageStyleConfig'] = []
        if self.wanxiang_image_style_config is not None:
            for k in self.wanxiang_image_style_config:
                result['WanxiangImageStyleConfig'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ChatConfig') is not None:
            self.chat_config = m.get('ChatConfig')
        if m.get('ConsoleConfig') is not None:
            temp_model = GetPropertiesResponseBodyDataConsoleConfig()
            self.console_config = temp_model.from_map(m['ConsoleConfig'])
        if m.get('GeneralConfigMap') is not None:
            self.general_config_map = m.get('GeneralConfigMap')
        if m.get('IntelligentSearchConfig') is not None:
            temp_model = GetPropertiesResponseBodyDataIntelligentSearchConfig()
            self.intelligent_search_config = temp_model.from_map(m['IntelligentSearchConfig'])
        if m.get('MiaosouConfig') is not None:
            temp_model = GetPropertiesResponseBodyDataMiaosouConfig()
            self.miaosou_config = temp_model.from_map(m['MiaosouConfig'])
        self.search_source_list = []
        if m.get('SearchSourceList') is not None:
            for k in m.get('SearchSourceList'):
                temp_model = GetPropertiesResponseBodyDataSearchSourceList()
                self.search_source_list.append(temp_model.from_map(k))
        self.search_sources = []
        if m.get('SearchSources') is not None:
            for k in m.get('SearchSources'):
                temp_model = GetPropertiesResponseBodyDataSearchSources()
                self.search_sources.append(temp_model.from_map(k))
        if m.get('SlrAuthorized') is not None:
            self.slr_authorized = m.get('SlrAuthorized')
        if m.get('UserInfo') is not None:
            temp_model = GetPropertiesResponseBodyDataUserInfo()
            self.user_info = temp_model.from_map(m['UserInfo'])
        self.wanxiang_image_size_config = []
        if m.get('WanxiangImageSizeConfig') is not None:
            for k in m.get('WanxiangImageSizeConfig'):
                temp_model = GetPropertiesResponseBodyDataWanxiangImageSizeConfig()
                self.wanxiang_image_size_config.append(temp_model.from_map(k))
        self.wanxiang_image_style_config = []
        if m.get('WanxiangImageStyleConfig') is not None:
            for k in m.get('WanxiangImageStyleConfig'):
                temp_model = GetPropertiesResponseBodyDataWanxiangImageStyleConfig()
                self.wanxiang_image_style_config.append(temp_model.from_map(k))
        return self


class GetPropertiesResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GetPropertiesResponseBodyData = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetPropertiesResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetPropertiesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetPropertiesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetPropertiesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetSmartAuditResultRequest(TeaModel):
    def __init__(
        self,
        task_id: str = None,
        workspace_id: str = None,
    ):
        self.task_id = task_id
        self.workspace_id = workspace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        return self


class GetSmartAuditResultResponseBodyDataErrorItemDetails(TeaModel):
    def __init__(
        self,
        check_id: str = None,
        context: str = None,
        context_offset: int = None,
        error_level: int = None,
        error_word: str = None,
        major_code: str = None,
        major_code_desc: str = None,
        offset: int = None,
        reason: str = None,
        right_word: str = None,
        sub_class_code: str = None,
        sub_class_desc: str = None,
        url: str = None,
    ):
        self.check_id = check_id
        self.context = context
        self.context_offset = context_offset
        self.error_level = error_level
        self.error_word = error_word
        self.major_code = major_code
        self.major_code_desc = major_code_desc
        self.offset = offset
        self.reason = reason
        self.right_word = right_word
        self.sub_class_code = sub_class_code
        self.sub_class_desc = sub_class_desc
        self.url = url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.check_id is not None:
            result['CheckId'] = self.check_id
        if self.context is not None:
            result['Context'] = self.context
        if self.context_offset is not None:
            result['ContextOffset'] = self.context_offset
        if self.error_level is not None:
            result['ErrorLevel'] = self.error_level
        if self.error_word is not None:
            result['ErrorWord'] = self.error_word
        if self.major_code is not None:
            result['MajorCode'] = self.major_code
        if self.major_code_desc is not None:
            result['MajorCodeDesc'] = self.major_code_desc
        if self.offset is not None:
            result['Offset'] = self.offset
        if self.reason is not None:
            result['Reason'] = self.reason
        if self.right_word is not None:
            result['RightWord'] = self.right_word
        if self.sub_class_code is not None:
            result['SubClassCode'] = self.sub_class_code
        if self.sub_class_desc is not None:
            result['SubClassDesc'] = self.sub_class_desc
        if self.url is not None:
            result['Url'] = self.url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CheckId') is not None:
            self.check_id = m.get('CheckId')
        if m.get('Context') is not None:
            self.context = m.get('Context')
        if m.get('ContextOffset') is not None:
            self.context_offset = m.get('ContextOffset')
        if m.get('ErrorLevel') is not None:
            self.error_level = m.get('ErrorLevel')
        if m.get('ErrorWord') is not None:
            self.error_word = m.get('ErrorWord')
        if m.get('MajorCode') is not None:
            self.major_code = m.get('MajorCode')
        if m.get('MajorCodeDesc') is not None:
            self.major_code_desc = m.get('MajorCodeDesc')
        if m.get('Offset') is not None:
            self.offset = m.get('Offset')
        if m.get('Reason') is not None:
            self.reason = m.get('Reason')
        if m.get('RightWord') is not None:
            self.right_word = m.get('RightWord')
        if m.get('SubClassCode') is not None:
            self.sub_class_code = m.get('SubClassCode')
        if m.get('SubClassDesc') is not None:
            self.sub_class_desc = m.get('SubClassDesc')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        return self


class GetSmartAuditResultResponseBodyData(TeaModel):
    def __init__(
        self,
        error_item_details: List[GetSmartAuditResultResponseBodyDataErrorItemDetails] = None,
        error_message: str = None,
        status: str = None,
    ):
        self.error_item_details = error_item_details
        self.error_message = error_message
        self.status = status

    def validate(self):
        if self.error_item_details:
            for k in self.error_item_details:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ErrorItemDetails'] = []
        if self.error_item_details is not None:
            for k in self.error_item_details:
                result['ErrorItemDetails'].append(k.to_map() if k else None)
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.error_item_details = []
        if m.get('ErrorItemDetails') is not None:
            for k in m.get('ErrorItemDetails'):
                temp_model = GetSmartAuditResultResponseBodyDataErrorItemDetails()
                self.error_item_details.append(temp_model.from_map(k))
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class GetSmartAuditResultResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GetSmartAuditResultResponseBodyData = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        # Id of the request
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetSmartAuditResultResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetSmartAuditResultResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetSmartAuditResultResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetSmartAuditResultResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetSmartClipTaskRequest(TeaModel):
    def __init__(
        self,
        task_id: str = None,
        workspace_id: str = None,
    ):
        # This parameter is required.
        self.task_id = task_id
        # This parameter is required.
        self.workspace_id = workspace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        return self


class GetSmartClipTaskResponseBodyDataSubJobsFileAttr(TeaModel):
    def __init__(
        self,
        duration: float = None,
        file_length: str = None,
        file_name: str = None,
        height: int = None,
        tmp_url: str = None,
        width: int = None,
    ):
        self.duration = duration
        self.file_length = file_length
        self.file_name = file_name
        self.height = height
        self.tmp_url = tmp_url
        self.width = width

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.file_length is not None:
            result['FileLength'] = self.file_length
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.height is not None:
            result['Height'] = self.height
        if self.tmp_url is not None:
            result['TmpUrl'] = self.tmp_url
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('FileLength') is not None:
            self.file_length = m.get('FileLength')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('TmpUrl') is not None:
            self.tmp_url = m.get('TmpUrl')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class GetSmartClipTaskResponseBodyDataSubJobs(TeaModel):
    def __init__(
        self,
        error_message: str = None,
        file_attr: GetSmartClipTaskResponseBodyDataSubJobsFileAttr = None,
        file_key: str = None,
        status: str = None,
        sub_job_id: str = None,
    ):
        self.error_message = error_message
        self.file_attr = file_attr
        self.file_key = file_key
        self.status = status
        self.sub_job_id = sub_job_id

    def validate(self):
        if self.file_attr:
            self.file_attr.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.file_attr is not None:
            result['FileAttr'] = self.file_attr.to_map()
        if self.file_key is not None:
            result['FileKey'] = self.file_key
        if self.status is not None:
            result['Status'] = self.status
        if self.sub_job_id is not None:
            result['SubJobId'] = self.sub_job_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('FileAttr') is not None:
            temp_model = GetSmartClipTaskResponseBodyDataSubJobsFileAttr()
            self.file_attr = temp_model.from_map(m['FileAttr'])
        if m.get('FileKey') is not None:
            self.file_key = m.get('FileKey')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('SubJobId') is not None:
            self.sub_job_id = m.get('SubJobId')
        return self


class GetSmartClipTaskResponseBodyData(TeaModel):
    def __init__(
        self,
        error_message: str = None,
        status: str = None,
        sub_jobs: List[GetSmartClipTaskResponseBodyDataSubJobs] = None,
    ):
        self.error_message = error_message
        self.status = status
        self.sub_jobs = sub_jobs

    def validate(self):
        if self.sub_jobs:
            for k in self.sub_jobs:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.status is not None:
            result['Status'] = self.status
        result['SubJobs'] = []
        if self.sub_jobs is not None:
            for k in self.sub_jobs:
                result['SubJobs'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        self.sub_jobs = []
        if m.get('SubJobs') is not None:
            for k in m.get('SubJobs'):
                temp_model = GetSmartClipTaskResponseBodyDataSubJobs()
                self.sub_jobs.append(temp_model.from_map(k))
        return self


class GetSmartClipTaskResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GetSmartClipTaskResponseBodyData = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetSmartClipTaskResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetSmartClipTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetSmartClipTaskResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetSmartClipTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetStyleLearningResultRequest(TeaModel):
    def __init__(
        self,
        agent_key: str = None,
        id: int = None,
    ):
        # This parameter is required.
        self.agent_key = agent_key
        # This parameter is required.
        self.id = id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_key is not None:
            result['AgentKey'] = self.agent_key
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentKey') is not None:
            self.agent_key = m.get('AgentKey')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class GetStyleLearningResultResponseBodyDataContentList(TeaModel):
    def __init__(
        self,
        content: str = None,
        create_time: str = None,
        create_user: str = None,
        id: int = None,
        title: str = None,
        update_time: str = None,
        update_user: str = None,
    ):
        self.content = content
        self.create_time = create_time
        self.create_user = create_user
        self.id = id
        self.title = title
        self.update_time = update_time
        self.update_user = update_user

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.create_user is not None:
            result['CreateUser'] = self.create_user
        if self.id is not None:
            result['Id'] = self.id
        if self.title is not None:
            result['Title'] = self.title
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        if self.update_user is not None:
            result['UpdateUser'] = self.update_user
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('CreateUser') is not None:
            self.create_user = m.get('CreateUser')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        if m.get('UpdateUser') is not None:
            self.update_user = m.get('UpdateUser')
        return self


class GetStyleLearningResultResponseBodyDataMaterialInfoList(TeaModel):
    def __init__(
        self,
        author: str = None,
        create_time: str = None,
        create_user: str = None,
        create_user_name: str = None,
        doc_keywords: List[str] = None,
        doc_type: str = None,
        external_url: str = None,
        file_length: int = None,
        html_content: str = None,
        id: int = None,
        pub_time: str = None,
        public_url: str = None,
        share_attr: int = None,
        src_from: str = None,
        summary: str = None,
        text_content: str = None,
        thumbnail_in_base_64: str = None,
        title: str = None,
        update_time: str = None,
        update_user: str = None,
        update_user_name: str = None,
        url: str = None,
    ):
        self.author = author
        self.create_time = create_time
        self.create_user = create_user
        self.create_user_name = create_user_name
        self.doc_keywords = doc_keywords
        self.doc_type = doc_type
        self.external_url = external_url
        self.file_length = file_length
        self.html_content = html_content
        self.id = id
        self.pub_time = pub_time
        self.public_url = public_url
        self.share_attr = share_attr
        self.src_from = src_from
        self.summary = summary
        self.text_content = text_content
        self.thumbnail_in_base_64 = thumbnail_in_base_64
        self.title = title
        self.update_time = update_time
        self.update_user = update_user
        self.update_user_name = update_user_name
        self.url = url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.author is not None:
            result['Author'] = self.author
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.create_user is not None:
            result['CreateUser'] = self.create_user
        if self.create_user_name is not None:
            result['CreateUserName'] = self.create_user_name
        if self.doc_keywords is not None:
            result['DocKeywords'] = self.doc_keywords
        if self.doc_type is not None:
            result['DocType'] = self.doc_type
        if self.external_url is not None:
            result['ExternalUrl'] = self.external_url
        if self.file_length is not None:
            result['FileLength'] = self.file_length
        if self.html_content is not None:
            result['HtmlContent'] = self.html_content
        if self.id is not None:
            result['Id'] = self.id
        if self.pub_time is not None:
            result['PubTime'] = self.pub_time
        if self.public_url is not None:
            result['PublicUrl'] = self.public_url
        if self.share_attr is not None:
            result['ShareAttr'] = self.share_attr
        if self.src_from is not None:
            result['SrcFrom'] = self.src_from
        if self.summary is not None:
            result['Summary'] = self.summary
        if self.text_content is not None:
            result['TextContent'] = self.text_content
        if self.thumbnail_in_base_64 is not None:
            result['ThumbnailInBase64'] = self.thumbnail_in_base_64
        if self.title is not None:
            result['Title'] = self.title
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        if self.update_user is not None:
            result['UpdateUser'] = self.update_user
        if self.update_user_name is not None:
            result['UpdateUserName'] = self.update_user_name
        if self.url is not None:
            result['Url'] = self.url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Author') is not None:
            self.author = m.get('Author')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('CreateUser') is not None:
            self.create_user = m.get('CreateUser')
        if m.get('CreateUserName') is not None:
            self.create_user_name = m.get('CreateUserName')
        if m.get('DocKeywords') is not None:
            self.doc_keywords = m.get('DocKeywords')
        if m.get('DocType') is not None:
            self.doc_type = m.get('DocType')
        if m.get('ExternalUrl') is not None:
            self.external_url = m.get('ExternalUrl')
        if m.get('FileLength') is not None:
            self.file_length = m.get('FileLength')
        if m.get('HtmlContent') is not None:
            self.html_content = m.get('HtmlContent')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('PubTime') is not None:
            self.pub_time = m.get('PubTime')
        if m.get('PublicUrl') is not None:
            self.public_url = m.get('PublicUrl')
        if m.get('ShareAttr') is not None:
            self.share_attr = m.get('ShareAttr')
        if m.get('SrcFrom') is not None:
            self.src_from = m.get('SrcFrom')
        if m.get('Summary') is not None:
            self.summary = m.get('Summary')
        if m.get('TextContent') is not None:
            self.text_content = m.get('TextContent')
        if m.get('ThumbnailInBase64') is not None:
            self.thumbnail_in_base_64 = m.get('ThumbnailInBase64')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        if m.get('UpdateUser') is not None:
            self.update_user = m.get('UpdateUser')
        if m.get('UpdateUserName') is not None:
            self.update_user_name = m.get('UpdateUserName')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        return self


class GetStyleLearningResultResponseBodyData(TeaModel):
    def __init__(
        self,
        aigc_result: str = None,
        content_list: List[GetStyleLearningResultResponseBodyDataContentList] = None,
        custom_text_id_list: List[int] = None,
        id: int = None,
        material_id_list: List[int] = None,
        material_info_list: List[GetStyleLearningResultResponseBodyDataMaterialInfoList] = None,
        rewrite_result: str = None,
        style_name: str = None,
        task_id: str = None,
    ):
        self.aigc_result = aigc_result
        self.content_list = content_list
        self.custom_text_id_list = custom_text_id_list
        self.id = id
        self.material_id_list = material_id_list
        self.material_info_list = material_info_list
        self.rewrite_result = rewrite_result
        self.style_name = style_name
        self.task_id = task_id

    def validate(self):
        if self.content_list:
            for k in self.content_list:
                if k:
                    k.validate()
        if self.material_info_list:
            for k in self.material_info_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aigc_result is not None:
            result['AigcResult'] = self.aigc_result
        result['ContentList'] = []
        if self.content_list is not None:
            for k in self.content_list:
                result['ContentList'].append(k.to_map() if k else None)
        if self.custom_text_id_list is not None:
            result['CustomTextIdList'] = self.custom_text_id_list
        if self.id is not None:
            result['Id'] = self.id
        if self.material_id_list is not None:
            result['MaterialIdList'] = self.material_id_list
        result['MaterialInfoList'] = []
        if self.material_info_list is not None:
            for k in self.material_info_list:
                result['MaterialInfoList'].append(k.to_map() if k else None)
        if self.rewrite_result is not None:
            result['RewriteResult'] = self.rewrite_result
        if self.style_name is not None:
            result['StyleName'] = self.style_name
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AigcResult') is not None:
            self.aigc_result = m.get('AigcResult')
        self.content_list = []
        if m.get('ContentList') is not None:
            for k in m.get('ContentList'):
                temp_model = GetStyleLearningResultResponseBodyDataContentList()
                self.content_list.append(temp_model.from_map(k))
        if m.get('CustomTextIdList') is not None:
            self.custom_text_id_list = m.get('CustomTextIdList')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('MaterialIdList') is not None:
            self.material_id_list = m.get('MaterialIdList')
        self.material_info_list = []
        if m.get('MaterialInfoList') is not None:
            for k in m.get('MaterialInfoList'):
                temp_model = GetStyleLearningResultResponseBodyDataMaterialInfoList()
                self.material_info_list.append(temp_model.from_map(k))
        if m.get('RewriteResult') is not None:
            self.rewrite_result = m.get('RewriteResult')
        if m.get('StyleName') is not None:
            self.style_name = m.get('StyleName')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class GetStyleLearningResultResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GetStyleLearningResultResponseBodyData = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetStyleLearningResultResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetStyleLearningResultResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetStyleLearningResultResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetStyleLearningResultResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetTopicByIdRequest(TeaModel):
    def __init__(
        self,
        agent_key: str = None,
        id: str = None,
    ):
        # This parameter is required.
        self.agent_key = agent_key
        # This parameter is required.
        self.id = id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_key is not None:
            result['AgentKey'] = self.agent_key
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentKey') is not None:
            self.agent_key = m.get('AgentKey')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class GetTopicByIdResponseBodyDataStructureSummaryDocList(TeaModel):
    def __init__(
        self,
        source: str = None,
        title: str = None,
        url: str = None,
    ):
        self.source = source
        self.title = title
        self.url = url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source is not None:
            result['Source'] = self.source
        if self.title is not None:
            result['Title'] = self.title
        if self.url is not None:
            result['Url'] = self.url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Source') is not None:
            self.source = m.get('Source')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        return self


class GetTopicByIdResponseBodyDataStructureSummary(TeaModel):
    def __init__(
        self,
        doc_list: List[GetTopicByIdResponseBodyDataStructureSummaryDocList] = None,
        summary: str = None,
        title: str = None,
    ):
        self.doc_list = doc_list
        self.summary = summary
        self.title = title

    def validate(self):
        if self.doc_list:
            for k in self.doc_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DocList'] = []
        if self.doc_list is not None:
            for k in self.doc_list:
                result['DocList'].append(k.to_map() if k else None)
        if self.summary is not None:
            result['Summary'] = self.summary
        if self.title is not None:
            result['Title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.doc_list = []
        if m.get('DocList') is not None:
            for k in m.get('DocList'):
                temp_model = GetTopicByIdResponseBodyDataStructureSummaryDocList()
                self.doc_list.append(temp_model.from_map(k))
        if m.get('Summary') is not None:
            self.summary = m.get('Summary')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        return self


class GetTopicByIdResponseBodyData(TeaModel):
    def __init__(
        self,
        async_task_id: str = None,
        create_user: str = None,
        hot_value: int = None,
        id: str = None,
        status: str = None,
        structure_summary: List[GetTopicByIdResponseBodyDataStructureSummary] = None,
        summary: str = None,
        task_error_message: str = None,
        task_status: int = None,
        topic: str = None,
        topic_source: str = None,
        version: str = None,
    ):
        self.async_task_id = async_task_id
        self.create_user = create_user
        self.hot_value = hot_value
        self.id = id
        self.status = status
        self.structure_summary = structure_summary
        self.summary = summary
        self.task_error_message = task_error_message
        self.task_status = task_status
        self.topic = topic
        self.topic_source = topic_source
        self.version = version

    def validate(self):
        if self.structure_summary:
            for k in self.structure_summary:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.async_task_id is not None:
            result['AsyncTaskId'] = self.async_task_id
        if self.create_user is not None:
            result['CreateUser'] = self.create_user
        if self.hot_value is not None:
            result['HotValue'] = self.hot_value
        if self.id is not None:
            result['Id'] = self.id
        if self.status is not None:
            result['Status'] = self.status
        result['StructureSummary'] = []
        if self.structure_summary is not None:
            for k in self.structure_summary:
                result['StructureSummary'].append(k.to_map() if k else None)
        if self.summary is not None:
            result['Summary'] = self.summary
        if self.task_error_message is not None:
            result['TaskErrorMessage'] = self.task_error_message
        if self.task_status is not None:
            result['TaskStatus'] = self.task_status
        if self.topic is not None:
            result['Topic'] = self.topic
        if self.topic_source is not None:
            result['TopicSource'] = self.topic_source
        if self.version is not None:
            result['Version'] = self.version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AsyncTaskId') is not None:
            self.async_task_id = m.get('AsyncTaskId')
        if m.get('CreateUser') is not None:
            self.create_user = m.get('CreateUser')
        if m.get('HotValue') is not None:
            self.hot_value = m.get('HotValue')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        self.structure_summary = []
        if m.get('StructureSummary') is not None:
            for k in m.get('StructureSummary'):
                temp_model = GetTopicByIdResponseBodyDataStructureSummary()
                self.structure_summary.append(temp_model.from_map(k))
        if m.get('Summary') is not None:
            self.summary = m.get('Summary')
        if m.get('TaskErrorMessage') is not None:
            self.task_error_message = m.get('TaskErrorMessage')
        if m.get('TaskStatus') is not None:
            self.task_status = m.get('TaskStatus')
        if m.get('Topic') is not None:
            self.topic = m.get('Topic')
        if m.get('TopicSource') is not None:
            self.topic_source = m.get('TopicSource')
        if m.get('Version') is not None:
            self.version = m.get('Version')
        return self


class GetTopicByIdResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GetTopicByIdResponseBodyData = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetTopicByIdResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetTopicByIdResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetTopicByIdResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetTopicByIdResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetTopicSelectionPerspectiveAnalysisTaskRequest(TeaModel):
    def __init__(
        self,
        agent_key: str = None,
        task_id: str = None,
    ):
        # This parameter is required.
        self.agent_key = agent_key
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_key is not None:
            result['AgentKey'] = self.agent_key
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentKey') is not None:
            self.agent_key = m.get('AgentKey')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class GetTopicSelectionPerspectiveAnalysisTaskResponseBodyDataFreshViewPointsResultAttitudesViewPointsOutlines(TeaModel):
    def __init__(
        self,
        outline: str = None,
        summary: str = None,
    ):
        self.outline = outline
        self.summary = summary

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.outline is not None:
            result['Outline'] = self.outline
        if self.summary is not None:
            result['Summary'] = self.summary
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Outline') is not None:
            self.outline = m.get('Outline')
        if m.get('Summary') is not None:
            self.summary = m.get('Summary')
        return self


class GetTopicSelectionPerspectiveAnalysisTaskResponseBodyDataFreshViewPointsResultAttitudesViewPoints(TeaModel):
    def __init__(
        self,
        outlines: List[GetTopicSelectionPerspectiveAnalysisTaskResponseBodyDataFreshViewPointsResultAttitudesViewPointsOutlines] = None,
        point: str = None,
        summary: str = None,
    ):
        self.outlines = outlines
        self.point = point
        self.summary = summary

    def validate(self):
        if self.outlines:
            for k in self.outlines:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Outlines'] = []
        if self.outlines is not None:
            for k in self.outlines:
                result['Outlines'].append(k.to_map() if k else None)
        if self.point is not None:
            result['Point'] = self.point
        if self.summary is not None:
            result['Summary'] = self.summary
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.outlines = []
        if m.get('Outlines') is not None:
            for k in m.get('Outlines'):
                temp_model = GetTopicSelectionPerspectiveAnalysisTaskResponseBodyDataFreshViewPointsResultAttitudesViewPointsOutlines()
                self.outlines.append(temp_model.from_map(k))
        if m.get('Point') is not None:
            self.point = m.get('Point')
        if m.get('Summary') is not None:
            self.summary = m.get('Summary')
        return self


class GetTopicSelectionPerspectiveAnalysisTaskResponseBodyDataFreshViewPointsResultAttitudes(TeaModel):
    def __init__(
        self,
        attitude: str = None,
        attitude_type: str = None,
        ratio: str = None,
        view_points: List[GetTopicSelectionPerspectiveAnalysisTaskResponseBodyDataFreshViewPointsResultAttitudesViewPoints] = None,
    ):
        self.attitude = attitude
        self.attitude_type = attitude_type
        self.ratio = ratio
        self.view_points = view_points

    def validate(self):
        if self.view_points:
            for k in self.view_points:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.attitude is not None:
            result['Attitude'] = self.attitude
        if self.attitude_type is not None:
            result['AttitudeType'] = self.attitude_type
        if self.ratio is not None:
            result['Ratio'] = self.ratio
        result['ViewPoints'] = []
        if self.view_points is not None:
            for k in self.view_points:
                result['ViewPoints'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Attitude') is not None:
            self.attitude = m.get('Attitude')
        if m.get('AttitudeType') is not None:
            self.attitude_type = m.get('AttitudeType')
        if m.get('Ratio') is not None:
            self.ratio = m.get('Ratio')
        self.view_points = []
        if m.get('ViewPoints') is not None:
            for k in m.get('ViewPoints'):
                temp_model = GetTopicSelectionPerspectiveAnalysisTaskResponseBodyDataFreshViewPointsResultAttitudesViewPoints()
                self.view_points.append(temp_model.from_map(k))
        return self


class GetTopicSelectionPerspectiveAnalysisTaskResponseBodyDataFreshViewPointsResult(TeaModel):
    def __init__(
        self,
        attitudes: List[GetTopicSelectionPerspectiveAnalysisTaskResponseBodyDataFreshViewPointsResultAttitudes] = None,
    ):
        self.attitudes = attitudes

    def validate(self):
        if self.attitudes:
            for k in self.attitudes:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Attitudes'] = []
        if self.attitudes is not None:
            for k in self.attitudes:
                result['Attitudes'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.attitudes = []
        if m.get('Attitudes') is not None:
            for k in m.get('Attitudes'):
                temp_model = GetTopicSelectionPerspectiveAnalysisTaskResponseBodyDataFreshViewPointsResultAttitudes()
                self.attitudes.append(temp_model.from_map(k))
        return self


class GetTopicSelectionPerspectiveAnalysisTaskResponseBodyDataHotViewPointsResultAttitudesNews(TeaModel):
    def __init__(
        self,
        content: str = None,
        create_time: str = None,
        doc_id: str = None,
        doc_uuid: str = None,
        image_urls: List[str] = None,
        pub_time: str = None,
        source: str = None,
        summary: str = None,
        tags: List[str] = None,
        title: str = None,
        topic: str = None,
        url: str = None,
    ):
        self.content = content
        self.create_time = create_time
        self.doc_id = doc_id
        self.doc_uuid = doc_uuid
        self.image_urls = image_urls
        self.pub_time = pub_time
        self.source = source
        self.summary = summary
        self.tags = tags
        self.title = title
        self.topic = topic
        self.url = url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.doc_id is not None:
            result['DocId'] = self.doc_id
        if self.doc_uuid is not None:
            result['DocUuid'] = self.doc_uuid
        if self.image_urls is not None:
            result['ImageUrls'] = self.image_urls
        if self.pub_time is not None:
            result['PubTime'] = self.pub_time
        if self.source is not None:
            result['Source'] = self.source
        if self.summary is not None:
            result['Summary'] = self.summary
        if self.tags is not None:
            result['Tags'] = self.tags
        if self.title is not None:
            result['Title'] = self.title
        if self.topic is not None:
            result['Topic'] = self.topic
        if self.url is not None:
            result['Url'] = self.url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('DocId') is not None:
            self.doc_id = m.get('DocId')
        if m.get('DocUuid') is not None:
            self.doc_uuid = m.get('DocUuid')
        if m.get('ImageUrls') is not None:
            self.image_urls = m.get('ImageUrls')
        if m.get('PubTime') is not None:
            self.pub_time = m.get('PubTime')
        if m.get('Source') is not None:
            self.source = m.get('Source')
        if m.get('Summary') is not None:
            self.summary = m.get('Summary')
        if m.get('Tags') is not None:
            self.tags = m.get('Tags')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        if m.get('Topic') is not None:
            self.topic = m.get('Topic')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        return self


class GetTopicSelectionPerspectiveAnalysisTaskResponseBodyDataHotViewPointsResultAttitudesViewPointsOutlines(TeaModel):
    def __init__(
        self,
        outline: str = None,
        summary: str = None,
    ):
        self.outline = outline
        self.summary = summary

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.outline is not None:
            result['Outline'] = self.outline
        if self.summary is not None:
            result['Summary'] = self.summary
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Outline') is not None:
            self.outline = m.get('Outline')
        if m.get('Summary') is not None:
            self.summary = m.get('Summary')
        return self


class GetTopicSelectionPerspectiveAnalysisTaskResponseBodyDataHotViewPointsResultAttitudesViewPoints(TeaModel):
    def __init__(
        self,
        outlines: List[GetTopicSelectionPerspectiveAnalysisTaskResponseBodyDataHotViewPointsResultAttitudesViewPointsOutlines] = None,
        point: str = None,
        summary: str = None,
    ):
        self.outlines = outlines
        self.point = point
        self.summary = summary

    def validate(self):
        if self.outlines:
            for k in self.outlines:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Outlines'] = []
        if self.outlines is not None:
            for k in self.outlines:
                result['Outlines'].append(k.to_map() if k else None)
        if self.point is not None:
            result['Point'] = self.point
        if self.summary is not None:
            result['Summary'] = self.summary
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.outlines = []
        if m.get('Outlines') is not None:
            for k in m.get('Outlines'):
                temp_model = GetTopicSelectionPerspectiveAnalysisTaskResponseBodyDataHotViewPointsResultAttitudesViewPointsOutlines()
                self.outlines.append(temp_model.from_map(k))
        if m.get('Point') is not None:
            self.point = m.get('Point')
        if m.get('Summary') is not None:
            self.summary = m.get('Summary')
        return self


class GetTopicSelectionPerspectiveAnalysisTaskResponseBodyDataHotViewPointsResultAttitudes(TeaModel):
    def __init__(
        self,
        attitude: str = None,
        attitude_type: str = None,
        news: List[GetTopicSelectionPerspectiveAnalysisTaskResponseBodyDataHotViewPointsResultAttitudesNews] = None,
        ratio: str = None,
        view_points: List[GetTopicSelectionPerspectiveAnalysisTaskResponseBodyDataHotViewPointsResultAttitudesViewPoints] = None,
    ):
        self.attitude = attitude
        self.attitude_type = attitude_type
        self.news = news
        self.ratio = ratio
        self.view_points = view_points

    def validate(self):
        if self.news:
            for k in self.news:
                if k:
                    k.validate()
        if self.view_points:
            for k in self.view_points:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.attitude is not None:
            result['Attitude'] = self.attitude
        if self.attitude_type is not None:
            result['AttitudeType'] = self.attitude_type
        result['News'] = []
        if self.news is not None:
            for k in self.news:
                result['News'].append(k.to_map() if k else None)
        if self.ratio is not None:
            result['Ratio'] = self.ratio
        result['ViewPoints'] = []
        if self.view_points is not None:
            for k in self.view_points:
                result['ViewPoints'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Attitude') is not None:
            self.attitude = m.get('Attitude')
        if m.get('AttitudeType') is not None:
            self.attitude_type = m.get('AttitudeType')
        self.news = []
        if m.get('News') is not None:
            for k in m.get('News'):
                temp_model = GetTopicSelectionPerspectiveAnalysisTaskResponseBodyDataHotViewPointsResultAttitudesNews()
                self.news.append(temp_model.from_map(k))
        if m.get('Ratio') is not None:
            self.ratio = m.get('Ratio')
        self.view_points = []
        if m.get('ViewPoints') is not None:
            for k in m.get('ViewPoints'):
                temp_model = GetTopicSelectionPerspectiveAnalysisTaskResponseBodyDataHotViewPointsResultAttitudesViewPoints()
                self.view_points.append(temp_model.from_map(k))
        return self


class GetTopicSelectionPerspectiveAnalysisTaskResponseBodyDataHotViewPointsResult(TeaModel):
    def __init__(
        self,
        attitudes: List[GetTopicSelectionPerspectiveAnalysisTaskResponseBodyDataHotViewPointsResultAttitudes] = None,
    ):
        self.attitudes = attitudes

    def validate(self):
        if self.attitudes:
            for k in self.attitudes:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Attitudes'] = []
        if self.attitudes is not None:
            for k in self.attitudes:
                result['Attitudes'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.attitudes = []
        if m.get('Attitudes') is not None:
            for k in m.get('Attitudes'):
                temp_model = GetTopicSelectionPerspectiveAnalysisTaskResponseBodyDataHotViewPointsResultAttitudes()
                self.attitudes.append(temp_model.from_map(k))
        return self


class GetTopicSelectionPerspectiveAnalysisTaskResponseBodyDataTimedViewPointsResultAttitudesViewPointsOutlines(TeaModel):
    def __init__(
        self,
        outline: str = None,
        summary: str = None,
    ):
        self.outline = outline
        self.summary = summary

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.outline is not None:
            result['Outline'] = self.outline
        if self.summary is not None:
            result['Summary'] = self.summary
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Outline') is not None:
            self.outline = m.get('Outline')
        if m.get('Summary') is not None:
            self.summary = m.get('Summary')
        return self


class GetTopicSelectionPerspectiveAnalysisTaskResponseBodyDataTimedViewPointsResultAttitudesViewPoints(TeaModel):
    def __init__(
        self,
        outlines: List[GetTopicSelectionPerspectiveAnalysisTaskResponseBodyDataTimedViewPointsResultAttitudesViewPointsOutlines] = None,
        point: str = None,
        summary: str = None,
    ):
        self.outlines = outlines
        self.point = point
        self.summary = summary

    def validate(self):
        if self.outlines:
            for k in self.outlines:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Outlines'] = []
        if self.outlines is not None:
            for k in self.outlines:
                result['Outlines'].append(k.to_map() if k else None)
        if self.point is not None:
            result['Point'] = self.point
        if self.summary is not None:
            result['Summary'] = self.summary
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.outlines = []
        if m.get('Outlines') is not None:
            for k in m.get('Outlines'):
                temp_model = GetTopicSelectionPerspectiveAnalysisTaskResponseBodyDataTimedViewPointsResultAttitudesViewPointsOutlines()
                self.outlines.append(temp_model.from_map(k))
        if m.get('Point') is not None:
            self.point = m.get('Point')
        if m.get('Summary') is not None:
            self.summary = m.get('Summary')
        return self


class GetTopicSelectionPerspectiveAnalysisTaskResponseBodyDataTimedViewPointsResultAttitudes(TeaModel):
    def __init__(
        self,
        attitude: str = None,
        attitude_type: str = None,
        pub_time: str = None,
        ratio: str = None,
        source: str = None,
        title: str = None,
        url: str = None,
        view_points: List[GetTopicSelectionPerspectiveAnalysisTaskResponseBodyDataTimedViewPointsResultAttitudesViewPoints] = None,
    ):
        self.attitude = attitude
        self.attitude_type = attitude_type
        self.pub_time = pub_time
        self.ratio = ratio
        self.source = source
        self.title = title
        self.url = url
        self.view_points = view_points

    def validate(self):
        if self.view_points:
            for k in self.view_points:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.attitude is not None:
            result['Attitude'] = self.attitude
        if self.attitude_type is not None:
            result['AttitudeType'] = self.attitude_type
        if self.pub_time is not None:
            result['PubTime'] = self.pub_time
        if self.ratio is not None:
            result['Ratio'] = self.ratio
        if self.source is not None:
            result['Source'] = self.source
        if self.title is not None:
            result['Title'] = self.title
        if self.url is not None:
            result['Url'] = self.url
        result['ViewPoints'] = []
        if self.view_points is not None:
            for k in self.view_points:
                result['ViewPoints'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Attitude') is not None:
            self.attitude = m.get('Attitude')
        if m.get('AttitudeType') is not None:
            self.attitude_type = m.get('AttitudeType')
        if m.get('PubTime') is not None:
            self.pub_time = m.get('PubTime')
        if m.get('Ratio') is not None:
            self.ratio = m.get('Ratio')
        if m.get('Source') is not None:
            self.source = m.get('Source')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        self.view_points = []
        if m.get('ViewPoints') is not None:
            for k in m.get('ViewPoints'):
                temp_model = GetTopicSelectionPerspectiveAnalysisTaskResponseBodyDataTimedViewPointsResultAttitudesViewPoints()
                self.view_points.append(temp_model.from_map(k))
        return self


class GetTopicSelectionPerspectiveAnalysisTaskResponseBodyDataTimedViewPointsResult(TeaModel):
    def __init__(
        self,
        attitudes: List[GetTopicSelectionPerspectiveAnalysisTaskResponseBodyDataTimedViewPointsResultAttitudes] = None,
    ):
        self.attitudes = attitudes

    def validate(self):
        if self.attitudes:
            for k in self.attitudes:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Attitudes'] = []
        if self.attitudes is not None:
            for k in self.attitudes:
                result['Attitudes'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.attitudes = []
        if m.get('Attitudes') is not None:
            for k in m.get('Attitudes'):
                temp_model = GetTopicSelectionPerspectiveAnalysisTaskResponseBodyDataTimedViewPointsResultAttitudes()
                self.attitudes.append(temp_model.from_map(k))
        return self


class GetTopicSelectionPerspectiveAnalysisTaskResponseBodyDataTopicSummaryResultSummariesDocList(TeaModel):
    def __init__(
        self,
        source: str = None,
        title: str = None,
        url: str = None,
    ):
        self.source = source
        self.title = title
        self.url = url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source is not None:
            result['Source'] = self.source
        if self.title is not None:
            result['Title'] = self.title
        if self.url is not None:
            result['Url'] = self.url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Source') is not None:
            self.source = m.get('Source')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        return self


class GetTopicSelectionPerspectiveAnalysisTaskResponseBodyDataTopicSummaryResultSummaries(TeaModel):
    def __init__(
        self,
        doc_list: List[GetTopicSelectionPerspectiveAnalysisTaskResponseBodyDataTopicSummaryResultSummariesDocList] = None,
        summary: str = None,
        title: str = None,
    ):
        self.doc_list = doc_list
        self.summary = summary
        self.title = title

    def validate(self):
        if self.doc_list:
            for k in self.doc_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DocList'] = []
        if self.doc_list is not None:
            for k in self.doc_list:
                result['DocList'].append(k.to_map() if k else None)
        if self.summary is not None:
            result['Summary'] = self.summary
        if self.title is not None:
            result['Title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.doc_list = []
        if m.get('DocList') is not None:
            for k in m.get('DocList'):
                temp_model = GetTopicSelectionPerspectiveAnalysisTaskResponseBodyDataTopicSummaryResultSummariesDocList()
                self.doc_list.append(temp_model.from_map(k))
        if m.get('Summary') is not None:
            self.summary = m.get('Summary')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        return self


class GetTopicSelectionPerspectiveAnalysisTaskResponseBodyDataTopicSummaryResult(TeaModel):
    def __init__(
        self,
        summaries: List[GetTopicSelectionPerspectiveAnalysisTaskResponseBodyDataTopicSummaryResultSummaries] = None,
    ):
        self.summaries = summaries

    def validate(self):
        if self.summaries:
            for k in self.summaries:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Summaries'] = []
        if self.summaries is not None:
            for k in self.summaries:
                result['Summaries'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.summaries = []
        if m.get('Summaries') is not None:
            for k in m.get('Summaries'):
                temp_model = GetTopicSelectionPerspectiveAnalysisTaskResponseBodyDataTopicSummaryResultSummaries()
                self.summaries.append(temp_model.from_map(k))
        return self


class GetTopicSelectionPerspectiveAnalysisTaskResponseBodyDataWebReviewPointsResultAttitudesComments(TeaModel):
    def __init__(
        self,
        source: str = None,
        text: str = None,
        title: str = None,
        url: str = None,
        username: str = None,
    ):
        self.source = source
        self.text = text
        self.title = title
        self.url = url
        self.username = username

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source is not None:
            result['Source'] = self.source
        if self.text is not None:
            result['Text'] = self.text
        if self.title is not None:
            result['Title'] = self.title
        if self.url is not None:
            result['Url'] = self.url
        if self.username is not None:
            result['Username'] = self.username
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Source') is not None:
            self.source = m.get('Source')
        if m.get('Text') is not None:
            self.text = m.get('Text')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        if m.get('Username') is not None:
            self.username = m.get('Username')
        return self


class GetTopicSelectionPerspectiveAnalysisTaskResponseBodyDataWebReviewPointsResultAttitudesViewPointsOutlines(TeaModel):
    def __init__(
        self,
        outline: str = None,
        summary: str = None,
    ):
        self.outline = outline
        self.summary = summary

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.outline is not None:
            result['Outline'] = self.outline
        if self.summary is not None:
            result['Summary'] = self.summary
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Outline') is not None:
            self.outline = m.get('Outline')
        if m.get('Summary') is not None:
            self.summary = m.get('Summary')
        return self


class GetTopicSelectionPerspectiveAnalysisTaskResponseBodyDataWebReviewPointsResultAttitudesViewPoints(TeaModel):
    def __init__(
        self,
        outlines: List[GetTopicSelectionPerspectiveAnalysisTaskResponseBodyDataWebReviewPointsResultAttitudesViewPointsOutlines] = None,
        point: str = None,
        summary: str = None,
    ):
        self.outlines = outlines
        self.point = point
        self.summary = summary

    def validate(self):
        if self.outlines:
            for k in self.outlines:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Outlines'] = []
        if self.outlines is not None:
            for k in self.outlines:
                result['Outlines'].append(k.to_map() if k else None)
        if self.point is not None:
            result['Point'] = self.point
        if self.summary is not None:
            result['Summary'] = self.summary
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.outlines = []
        if m.get('Outlines') is not None:
            for k in m.get('Outlines'):
                temp_model = GetTopicSelectionPerspectiveAnalysisTaskResponseBodyDataWebReviewPointsResultAttitudesViewPointsOutlines()
                self.outlines.append(temp_model.from_map(k))
        if m.get('Point') is not None:
            self.point = m.get('Point')
        if m.get('Summary') is not None:
            self.summary = m.get('Summary')
        return self


class GetTopicSelectionPerspectiveAnalysisTaskResponseBodyDataWebReviewPointsResultAttitudes(TeaModel):
    def __init__(
        self,
        attitude: str = None,
        attitude_type: str = None,
        comments: List[GetTopicSelectionPerspectiveAnalysisTaskResponseBodyDataWebReviewPointsResultAttitudesComments] = None,
        ratio: str = None,
        view_points: List[GetTopicSelectionPerspectiveAnalysisTaskResponseBodyDataWebReviewPointsResultAttitudesViewPoints] = None,
    ):
        self.attitude = attitude
        self.attitude_type = attitude_type
        self.comments = comments
        self.ratio = ratio
        self.view_points = view_points

    def validate(self):
        if self.comments:
            for k in self.comments:
                if k:
                    k.validate()
        if self.view_points:
            for k in self.view_points:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.attitude is not None:
            result['Attitude'] = self.attitude
        if self.attitude_type is not None:
            result['AttitudeType'] = self.attitude_type
        result['Comments'] = []
        if self.comments is not None:
            for k in self.comments:
                result['Comments'].append(k.to_map() if k else None)
        if self.ratio is not None:
            result['Ratio'] = self.ratio
        result['ViewPoints'] = []
        if self.view_points is not None:
            for k in self.view_points:
                result['ViewPoints'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Attitude') is not None:
            self.attitude = m.get('Attitude')
        if m.get('AttitudeType') is not None:
            self.attitude_type = m.get('AttitudeType')
        self.comments = []
        if m.get('Comments') is not None:
            for k in m.get('Comments'):
                temp_model = GetTopicSelectionPerspectiveAnalysisTaskResponseBodyDataWebReviewPointsResultAttitudesComments()
                self.comments.append(temp_model.from_map(k))
        if m.get('Ratio') is not None:
            self.ratio = m.get('Ratio')
        self.view_points = []
        if m.get('ViewPoints') is not None:
            for k in m.get('ViewPoints'):
                temp_model = GetTopicSelectionPerspectiveAnalysisTaskResponseBodyDataWebReviewPointsResultAttitudesViewPoints()
                self.view_points.append(temp_model.from_map(k))
        return self


class GetTopicSelectionPerspectiveAnalysisTaskResponseBodyDataWebReviewPointsResult(TeaModel):
    def __init__(
        self,
        attitudes: List[GetTopicSelectionPerspectiveAnalysisTaskResponseBodyDataWebReviewPointsResultAttitudes] = None,
    ):
        self.attitudes = attitudes

    def validate(self):
        if self.attitudes:
            for k in self.attitudes:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Attitudes'] = []
        if self.attitudes is not None:
            for k in self.attitudes:
                result['Attitudes'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.attitudes = []
        if m.get('Attitudes') is not None:
            for k in m.get('Attitudes'):
                temp_model = GetTopicSelectionPerspectiveAnalysisTaskResponseBodyDataWebReviewPointsResultAttitudes()
                self.attitudes.append(temp_model.from_map(k))
        return self


class GetTopicSelectionPerspectiveAnalysisTaskResponseBodyData(TeaModel):
    def __init__(
        self,
        error_message: str = None,
        fresh_view_points_result: GetTopicSelectionPerspectiveAnalysisTaskResponseBodyDataFreshViewPointsResult = None,
        hot_view_points_result: GetTopicSelectionPerspectiveAnalysisTaskResponseBodyDataHotViewPointsResult = None,
        status: str = None,
        timed_view_points_result: GetTopicSelectionPerspectiveAnalysisTaskResponseBodyDataTimedViewPointsResult = None,
        topic: str = None,
        topic_summary_result: GetTopicSelectionPerspectiveAnalysisTaskResponseBodyDataTopicSummaryResult = None,
        web_review_points_result: GetTopicSelectionPerspectiveAnalysisTaskResponseBodyDataWebReviewPointsResult = None,
    ):
        self.error_message = error_message
        self.fresh_view_points_result = fresh_view_points_result
        self.hot_view_points_result = hot_view_points_result
        self.status = status
        self.timed_view_points_result = timed_view_points_result
        self.topic = topic
        self.topic_summary_result = topic_summary_result
        self.web_review_points_result = web_review_points_result

    def validate(self):
        if self.fresh_view_points_result:
            self.fresh_view_points_result.validate()
        if self.hot_view_points_result:
            self.hot_view_points_result.validate()
        if self.timed_view_points_result:
            self.timed_view_points_result.validate()
        if self.topic_summary_result:
            self.topic_summary_result.validate()
        if self.web_review_points_result:
            self.web_review_points_result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.fresh_view_points_result is not None:
            result['FreshViewPointsResult'] = self.fresh_view_points_result.to_map()
        if self.hot_view_points_result is not None:
            result['HotViewPointsResult'] = self.hot_view_points_result.to_map()
        if self.status is not None:
            result['Status'] = self.status
        if self.timed_view_points_result is not None:
            result['TimedViewPointsResult'] = self.timed_view_points_result.to_map()
        if self.topic is not None:
            result['Topic'] = self.topic
        if self.topic_summary_result is not None:
            result['TopicSummaryResult'] = self.topic_summary_result.to_map()
        if self.web_review_points_result is not None:
            result['WebReviewPointsResult'] = self.web_review_points_result.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('FreshViewPointsResult') is not None:
            temp_model = GetTopicSelectionPerspectiveAnalysisTaskResponseBodyDataFreshViewPointsResult()
            self.fresh_view_points_result = temp_model.from_map(m['FreshViewPointsResult'])
        if m.get('HotViewPointsResult') is not None:
            temp_model = GetTopicSelectionPerspectiveAnalysisTaskResponseBodyDataHotViewPointsResult()
            self.hot_view_points_result = temp_model.from_map(m['HotViewPointsResult'])
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TimedViewPointsResult') is not None:
            temp_model = GetTopicSelectionPerspectiveAnalysisTaskResponseBodyDataTimedViewPointsResult()
            self.timed_view_points_result = temp_model.from_map(m['TimedViewPointsResult'])
        if m.get('Topic') is not None:
            self.topic = m.get('Topic')
        if m.get('TopicSummaryResult') is not None:
            temp_model = GetTopicSelectionPerspectiveAnalysisTaskResponseBodyDataTopicSummaryResult()
            self.topic_summary_result = temp_model.from_map(m['TopicSummaryResult'])
        if m.get('WebReviewPointsResult') is not None:
            temp_model = GetTopicSelectionPerspectiveAnalysisTaskResponseBodyDataWebReviewPointsResult()
            self.web_review_points_result = temp_model.from_map(m['WebReviewPointsResult'])
        return self


class GetTopicSelectionPerspectiveAnalysisTaskResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GetTopicSelectionPerspectiveAnalysisTaskResponseBodyData = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetTopicSelectionPerspectiveAnalysisTaskResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetTopicSelectionPerspectiveAnalysisTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetTopicSelectionPerspectiveAnalysisTaskResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetTopicSelectionPerspectiveAnalysisTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ImportInterveneFileRequest(TeaModel):
    def __init__(
        self,
        agent_key: str = None,
        doc_name: str = None,
        file_key: str = None,
        file_url: str = None,
    ):
        # This parameter is required.
        self.agent_key = agent_key
        self.doc_name = doc_name
        self.file_key = file_key
        self.file_url = file_url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_key is not None:
            result['AgentKey'] = self.agent_key
        if self.doc_name is not None:
            result['DocName'] = self.doc_name
        if self.file_key is not None:
            result['FileKey'] = self.file_key
        if self.file_url is not None:
            result['FileUrl'] = self.file_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentKey') is not None:
            self.agent_key = m.get('AgentKey')
        if m.get('DocName') is not None:
            self.doc_name = m.get('DocName')
        if m.get('FileKey') is not None:
            self.file_key = m.get('FileKey')
        if m.get('FileUrl') is not None:
            self.file_url = m.get('FileUrl')
        return self


class ImportInterveneFileResponseBodyData(TeaModel):
    def __init__(
        self,
        code: int = None,
        fail_id_list: List[str] = None,
        task_id: str = None,
    ):
        self.code = code
        self.fail_id_list = fail_id_list
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.fail_id_list is not None:
            result['FailIdList'] = self.fail_id_list
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('FailIdList') is not None:
            self.fail_id_list = m.get('FailIdList')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class ImportInterveneFileResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: ImportInterveneFileResponseBodyData = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = ImportInterveneFileResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ImportInterveneFileResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ImportInterveneFileResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ImportInterveneFileResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ImportInterveneFileAsyncRequest(TeaModel):
    def __init__(
        self,
        agent_key: str = None,
        doc_name: str = None,
        file_key: str = None,
        file_url: str = None,
    ):
        # This parameter is required.
        self.agent_key = agent_key
        self.doc_name = doc_name
        self.file_key = file_key
        self.file_url = file_url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_key is not None:
            result['AgentKey'] = self.agent_key
        if self.doc_name is not None:
            result['DocName'] = self.doc_name
        if self.file_key is not None:
            result['FileKey'] = self.file_key
        if self.file_url is not None:
            result['FileUrl'] = self.file_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentKey') is not None:
            self.agent_key = m.get('AgentKey')
        if m.get('DocName') is not None:
            self.doc_name = m.get('DocName')
        if m.get('FileKey') is not None:
            self.file_key = m.get('FileKey')
        if m.get('FileUrl') is not None:
            self.file_url = m.get('FileUrl')
        return self


class ImportInterveneFileAsyncResponseBodyData(TeaModel):
    def __init__(
        self,
        code: int = None,
        fail_id_list: List[str] = None,
        task_id: str = None,
    ):
        self.code = code
        self.fail_id_list = fail_id_list
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.fail_id_list is not None:
            result['FailIdList'] = self.fail_id_list
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('FailIdList') is not None:
            self.fail_id_list = m.get('FailIdList')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class ImportInterveneFileAsyncResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: ImportInterveneFileAsyncResponseBodyData = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = ImportInterveneFileAsyncResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ImportInterveneFileAsyncResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ImportInterveneFileAsyncResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ImportInterveneFileAsyncResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class InsertInterveneGlobalReplyRequestReplyMessagList(TeaModel):
    def __init__(
        self,
        message: str = None,
        reply_type: str = None,
    ):
        self.message = message
        self.reply_type = reply_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.reply_type is not None:
            result['ReplyType'] = self.reply_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('ReplyType') is not None:
            self.reply_type = m.get('ReplyType')
        return self


class InsertInterveneGlobalReplyRequest(TeaModel):
    def __init__(
        self,
        agent_key: str = None,
        reply_messag_list: List[InsertInterveneGlobalReplyRequestReplyMessagList] = None,
    ):
        # This parameter is required.
        self.agent_key = agent_key
        self.reply_messag_list = reply_messag_list

    def validate(self):
        if self.reply_messag_list:
            for k in self.reply_messag_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_key is not None:
            result['AgentKey'] = self.agent_key
        result['ReplyMessagList'] = []
        if self.reply_messag_list is not None:
            for k in self.reply_messag_list:
                result['ReplyMessagList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentKey') is not None:
            self.agent_key = m.get('AgentKey')
        self.reply_messag_list = []
        if m.get('ReplyMessagList') is not None:
            for k in m.get('ReplyMessagList'):
                temp_model = InsertInterveneGlobalReplyRequestReplyMessagList()
                self.reply_messag_list.append(temp_model.from_map(k))
        return self


class InsertInterveneGlobalReplyShrinkRequest(TeaModel):
    def __init__(
        self,
        agent_key: str = None,
        reply_messag_list_shrink: str = None,
    ):
        # This parameter is required.
        self.agent_key = agent_key
        self.reply_messag_list_shrink = reply_messag_list_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_key is not None:
            result['AgentKey'] = self.agent_key
        if self.reply_messag_list_shrink is not None:
            result['ReplyMessagList'] = self.reply_messag_list_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentKey') is not None:
            self.agent_key = m.get('AgentKey')
        if m.get('ReplyMessagList') is not None:
            self.reply_messag_list_shrink = m.get('ReplyMessagList')
        return self


class InsertInterveneGlobalReplyResponseBodyData(TeaModel):
    def __init__(
        self,
        code: int = None,
        fail_id_list: List[str] = None,
        task_id: str = None,
    ):
        self.code = code
        self.fail_id_list = fail_id_list
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.fail_id_list is not None:
            result['FailIdList'] = self.fail_id_list
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('FailIdList') is not None:
            self.fail_id_list = m.get('FailIdList')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class InsertInterveneGlobalReplyResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: InsertInterveneGlobalReplyResponseBodyData = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = InsertInterveneGlobalReplyResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class InsertInterveneGlobalReplyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: InsertInterveneGlobalReplyResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = InsertInterveneGlobalReplyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class InsertInterveneRuleRequestInterveneRuleConfigAnswerConfig(TeaModel):
    def __init__(
        self,
        answer_type: int = None,
        message: str = None,
        namespace: str = None,
    ):
        self.answer_type = answer_type
        self.message = message
        self.namespace = namespace

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.answer_type is not None:
            result['AnswerType'] = self.answer_type
        if self.message is not None:
            result['Message'] = self.message
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AnswerType') is not None:
            self.answer_type = m.get('AnswerType')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        return self


class InsertInterveneRuleRequestInterveneRuleConfigEffectConfig(TeaModel):
    def __init__(
        self,
        effect_type: int = None,
        end_time: str = None,
        start_time: str = None,
    ):
        self.effect_type = effect_type
        self.end_time = end_time
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.effect_type is not None:
            result['EffectType'] = self.effect_type
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EffectType') is not None:
            self.effect_type = m.get('EffectType')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class InsertInterveneRuleRequestInterveneRuleConfigInterveneConfigList(TeaModel):
    def __init__(
        self,
        id: str = None,
        operation_type: int = None,
        query: str = None,
    ):
        # id
        self.id = id
        self.operation_type = operation_type
        self.query = query

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.operation_type is not None:
            result['OperationType'] = self.operation_type
        if self.query is not None:
            result['Query'] = self.query
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('OperationType') is not None:
            self.operation_type = m.get('OperationType')
        if m.get('Query') is not None:
            self.query = m.get('Query')
        return self


class InsertInterveneRuleRequestInterveneRuleConfig(TeaModel):
    def __init__(
        self,
        answer_config: List[InsertInterveneRuleRequestInterveneRuleConfigAnswerConfig] = None,
        effect_config: InsertInterveneRuleRequestInterveneRuleConfigEffectConfig = None,
        intervene_config_list: List[InsertInterveneRuleRequestInterveneRuleConfigInterveneConfigList] = None,
        intervene_type: int = None,
        namespace_list: List[str] = None,
        rule_id: int = None,
        rule_name: str = None,
    ):
        self.answer_config = answer_config
        self.effect_config = effect_config
        self.intervene_config_list = intervene_config_list
        self.intervene_type = intervene_type
        self.namespace_list = namespace_list
        self.rule_id = rule_id
        self.rule_name = rule_name

    def validate(self):
        if self.answer_config:
            for k in self.answer_config:
                if k:
                    k.validate()
        if self.effect_config:
            self.effect_config.validate()
        if self.intervene_config_list:
            for k in self.intervene_config_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AnswerConfig'] = []
        if self.answer_config is not None:
            for k in self.answer_config:
                result['AnswerConfig'].append(k.to_map() if k else None)
        if self.effect_config is not None:
            result['EffectConfig'] = self.effect_config.to_map()
        result['InterveneConfigList'] = []
        if self.intervene_config_list is not None:
            for k in self.intervene_config_list:
                result['InterveneConfigList'].append(k.to_map() if k else None)
        if self.intervene_type is not None:
            result['InterveneType'] = self.intervene_type
        if self.namespace_list is not None:
            result['NamespaceList'] = self.namespace_list
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.answer_config = []
        if m.get('AnswerConfig') is not None:
            for k in m.get('AnswerConfig'):
                temp_model = InsertInterveneRuleRequestInterveneRuleConfigAnswerConfig()
                self.answer_config.append(temp_model.from_map(k))
        if m.get('EffectConfig') is not None:
            temp_model = InsertInterveneRuleRequestInterveneRuleConfigEffectConfig()
            self.effect_config = temp_model.from_map(m['EffectConfig'])
        self.intervene_config_list = []
        if m.get('InterveneConfigList') is not None:
            for k in m.get('InterveneConfigList'):
                temp_model = InsertInterveneRuleRequestInterveneRuleConfigInterveneConfigList()
                self.intervene_config_list.append(temp_model.from_map(k))
        if m.get('InterveneType') is not None:
            self.intervene_type = m.get('InterveneType')
        if m.get('NamespaceList') is not None:
            self.namespace_list = m.get('NamespaceList')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        return self


class InsertInterveneRuleRequest(TeaModel):
    def __init__(
        self,
        agent_key: str = None,
        intervene_rule_config: InsertInterveneRuleRequestInterveneRuleConfig = None,
    ):
        # This parameter is required.
        self.agent_key = agent_key
        self.intervene_rule_config = intervene_rule_config

    def validate(self):
        if self.intervene_rule_config:
            self.intervene_rule_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_key is not None:
            result['AgentKey'] = self.agent_key
        if self.intervene_rule_config is not None:
            result['InterveneRuleConfig'] = self.intervene_rule_config.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentKey') is not None:
            self.agent_key = m.get('AgentKey')
        if m.get('InterveneRuleConfig') is not None:
            temp_model = InsertInterveneRuleRequestInterveneRuleConfig()
            self.intervene_rule_config = temp_model.from_map(m['InterveneRuleConfig'])
        return self


class InsertInterveneRuleShrinkRequest(TeaModel):
    def __init__(
        self,
        agent_key: str = None,
        intervene_rule_config_shrink: str = None,
    ):
        # This parameter is required.
        self.agent_key = agent_key
        self.intervene_rule_config_shrink = intervene_rule_config_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_key is not None:
            result['AgentKey'] = self.agent_key
        if self.intervene_rule_config_shrink is not None:
            result['InterveneRuleConfig'] = self.intervene_rule_config_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentKey') is not None:
            self.agent_key = m.get('AgentKey')
        if m.get('InterveneRuleConfig') is not None:
            self.intervene_rule_config_shrink = m.get('InterveneRuleConfig')
        return self


class InsertInterveneRuleResponseBodyData(TeaModel):
    def __init__(
        self,
        code: int = None,
        rule_id: int = None,
    ):
        self.code = code
        self.rule_id = rule_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class InsertInterveneRuleResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: InsertInterveneRuleResponseBodyData = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = InsertInterveneRuleResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class InsertInterveneRuleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: InsertInterveneRuleResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = InsertInterveneRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListAnalysisTagDetailByTaskIdRequest(TeaModel):
    def __init__(
        self,
        categories: List[str] = None,
        current: int = None,
        max_results: int = None,
        next_token: str = None,
        size: int = None,
        task_id: str = None,
        workspace_id: str = None,
    ):
        self.categories = categories
        self.current = current
        self.max_results = max_results
        self.next_token = next_token
        self.size = size
        # This parameter is required.
        self.task_id = task_id
        # This parameter is required.
        self.workspace_id = workspace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.categories is not None:
            result['Categories'] = self.categories
        if self.current is not None:
            result['Current'] = self.current
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.size is not None:
            result['Size'] = self.size
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Categories') is not None:
            self.categories = m.get('Categories')
        if m.get('Current') is not None:
            self.current = m.get('Current')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        return self


class ListAnalysisTagDetailByTaskIdShrinkRequest(TeaModel):
    def __init__(
        self,
        categories_shrink: str = None,
        current: int = None,
        max_results: int = None,
        next_token: str = None,
        size: int = None,
        task_id: str = None,
        workspace_id: str = None,
    ):
        self.categories_shrink = categories_shrink
        self.current = current
        self.max_results = max_results
        self.next_token = next_token
        self.size = size
        # This parameter is required.
        self.task_id = task_id
        # This parameter is required.
        self.workspace_id = workspace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.categories_shrink is not None:
            result['Categories'] = self.categories_shrink
        if self.current is not None:
            result['Current'] = self.current
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.size is not None:
            result['Size'] = self.size
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Categories') is not None:
            self.categories_shrink = m.get('Categories')
        if m.get('Current') is not None:
            self.current = m.get('Current')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        return self


class ListAnalysisTagDetailByTaskIdResponseBodyDataContentTags(TeaModel):
    def __init__(
        self,
        summary_overview: str = None,
        tag_name: str = None,
        tags: List[str] = None,
    ):
        self.summary_overview = summary_overview
        self.tag_name = tag_name
        self.tags = tags

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.summary_overview is not None:
            result['SummaryOverview'] = self.summary_overview
        if self.tag_name is not None:
            result['TagName'] = self.tag_name
        if self.tags is not None:
            result['Tags'] = self.tags
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SummaryOverview') is not None:
            self.summary_overview = m.get('SummaryOverview')
        if m.get('TagName') is not None:
            self.tag_name = m.get('TagName')
        if m.get('Tags') is not None:
            self.tags = m.get('Tags')
        return self


class ListAnalysisTagDetailByTaskIdResponseBodyData(TeaModel):
    def __init__(
        self,
        content: str = None,
        content_tags: List[ListAnalysisTagDetailByTaskIdResponseBodyDataContentTags] = None,
        id: int = None,
        tag_task_type: str = None,
        task_id: str = None,
    ):
        self.content = content
        self.content_tags = content_tags
        self.id = id
        self.tag_task_type = tag_task_type
        self.task_id = task_id

    def validate(self):
        if self.content_tags:
            for k in self.content_tags:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        result['ContentTags'] = []
        if self.content_tags is not None:
            for k in self.content_tags:
                result['ContentTags'].append(k.to_map() if k else None)
        if self.id is not None:
            result['Id'] = self.id
        if self.tag_task_type is not None:
            result['TagTaskType'] = self.tag_task_type
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        self.content_tags = []
        if m.get('ContentTags') is not None:
            for k in m.get('ContentTags'):
                temp_model = ListAnalysisTagDetailByTaskIdResponseBodyDataContentTags()
                self.content_tags.append(temp_model.from_map(k))
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('TagTaskType') is not None:
            self.tag_task_type = m.get('TagTaskType')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class ListAnalysisTagDetailByTaskIdResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: List[ListAnalysisTagDetailByTaskIdResponseBodyData] = None,
        http_status_code: int = None,
        max_results: int = None,
        message: str = None,
        next_token: str = None,
        request_id: str = None,
        success: bool = None,
        total_count: int = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.max_results = max_results
        self.message = message
        self.next_token = next_token
        self.request_id = request_id
        self.success = success
        self.total_count = total_count

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.message is not None:
            result['Message'] = self.message
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ListAnalysisTagDetailByTaskIdResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListAnalysisTagDetailByTaskIdResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListAnalysisTagDetailByTaskIdResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListAnalysisTagDetailByTaskIdResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListAsyncTasksRequest(TeaModel):
    def __init__(
        self,
        agent_key: str = None,
        create_time_end: str = None,
        create_time_start: str = None,
        current: int = None,
        size: int = None,
        task_code: str = None,
        task_name: str = None,
        task_status: int = None,
        task_status_list: List[int] = None,
        task_type: str = None,
        task_type_list: List[str] = None,
    ):
        # This parameter is required.
        self.agent_key = agent_key
        self.create_time_end = create_time_end
        self.create_time_start = create_time_start
        self.current = current
        self.size = size
        self.task_code = task_code
        self.task_name = task_name
        self.task_status = task_status
        self.task_status_list = task_status_list
        self.task_type = task_type
        self.task_type_list = task_type_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_key is not None:
            result['AgentKey'] = self.agent_key
        if self.create_time_end is not None:
            result['CreateTimeEnd'] = self.create_time_end
        if self.create_time_start is not None:
            result['CreateTimeStart'] = self.create_time_start
        if self.current is not None:
            result['Current'] = self.current
        if self.size is not None:
            result['Size'] = self.size
        if self.task_code is not None:
            result['TaskCode'] = self.task_code
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        if self.task_status is not None:
            result['TaskStatus'] = self.task_status
        if self.task_status_list is not None:
            result['TaskStatusList'] = self.task_status_list
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        if self.task_type_list is not None:
            result['TaskTypeList'] = self.task_type_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentKey') is not None:
            self.agent_key = m.get('AgentKey')
        if m.get('CreateTimeEnd') is not None:
            self.create_time_end = m.get('CreateTimeEnd')
        if m.get('CreateTimeStart') is not None:
            self.create_time_start = m.get('CreateTimeStart')
        if m.get('Current') is not None:
            self.current = m.get('Current')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('TaskCode') is not None:
            self.task_code = m.get('TaskCode')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        if m.get('TaskStatus') is not None:
            self.task_status = m.get('TaskStatus')
        if m.get('TaskStatusList') is not None:
            self.task_status_list = m.get('TaskStatusList')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        if m.get('TaskTypeList') is not None:
            self.task_type_list = m.get('TaskTypeList')
        return self


class ListAsyncTasksShrinkRequest(TeaModel):
    def __init__(
        self,
        agent_key: str = None,
        create_time_end: str = None,
        create_time_start: str = None,
        current: int = None,
        size: int = None,
        task_code: str = None,
        task_name: str = None,
        task_status: int = None,
        task_status_list_shrink: str = None,
        task_type: str = None,
        task_type_list_shrink: str = None,
    ):
        # This parameter is required.
        self.agent_key = agent_key
        self.create_time_end = create_time_end
        self.create_time_start = create_time_start
        self.current = current
        self.size = size
        self.task_code = task_code
        self.task_name = task_name
        self.task_status = task_status
        self.task_status_list_shrink = task_status_list_shrink
        self.task_type = task_type
        self.task_type_list_shrink = task_type_list_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_key is not None:
            result['AgentKey'] = self.agent_key
        if self.create_time_end is not None:
            result['CreateTimeEnd'] = self.create_time_end
        if self.create_time_start is not None:
            result['CreateTimeStart'] = self.create_time_start
        if self.current is not None:
            result['Current'] = self.current
        if self.size is not None:
            result['Size'] = self.size
        if self.task_code is not None:
            result['TaskCode'] = self.task_code
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        if self.task_status is not None:
            result['TaskStatus'] = self.task_status
        if self.task_status_list_shrink is not None:
            result['TaskStatusList'] = self.task_status_list_shrink
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        if self.task_type_list_shrink is not None:
            result['TaskTypeList'] = self.task_type_list_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentKey') is not None:
            self.agent_key = m.get('AgentKey')
        if m.get('CreateTimeEnd') is not None:
            self.create_time_end = m.get('CreateTimeEnd')
        if m.get('CreateTimeStart') is not None:
            self.create_time_start = m.get('CreateTimeStart')
        if m.get('Current') is not None:
            self.current = m.get('Current')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('TaskCode') is not None:
            self.task_code = m.get('TaskCode')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        if m.get('TaskStatus') is not None:
            self.task_status = m.get('TaskStatus')
        if m.get('TaskStatusList') is not None:
            self.task_status_list_shrink = m.get('TaskStatusList')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        if m.get('TaskTypeList') is not None:
            self.task_type_list_shrink = m.get('TaskTypeList')
        return self


class ListAsyncTasksResponseBodyData(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        create_user: str = None,
        id: int = None,
        task_code: str = None,
        task_definition: str = None,
        task_end_time: str = None,
        task_error_message: str = None,
        task_execute_time: str = None,
        task_id: str = None,
        task_inner_error_message: str = None,
        task_intermediate_result: str = None,
        task_name: str = None,
        task_param: str = None,
        task_progress_message: str = None,
        task_result: str = None,
        task_retry_count: str = None,
        task_start_time: str = None,
        task_status: int = None,
        task_type: str = None,
        update_time: str = None,
        update_user: str = None,
    ):
        self.create_time = create_time
        self.create_user = create_user
        self.id = id
        self.task_code = task_code
        self.task_definition = task_definition
        self.task_end_time = task_end_time
        self.task_error_message = task_error_message
        self.task_execute_time = task_execute_time
        self.task_id = task_id
        self.task_inner_error_message = task_inner_error_message
        self.task_intermediate_result = task_intermediate_result
        self.task_name = task_name
        self.task_param = task_param
        self.task_progress_message = task_progress_message
        self.task_result = task_result
        self.task_retry_count = task_retry_count
        self.task_start_time = task_start_time
        self.task_status = task_status
        self.task_type = task_type
        self.update_time = update_time
        self.update_user = update_user

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.create_user is not None:
            result['CreateUser'] = self.create_user
        if self.id is not None:
            result['Id'] = self.id
        if self.task_code is not None:
            result['TaskCode'] = self.task_code
        if self.task_definition is not None:
            result['TaskDefinition'] = self.task_definition
        if self.task_end_time is not None:
            result['TaskEndTime'] = self.task_end_time
        if self.task_error_message is not None:
            result['TaskErrorMessage'] = self.task_error_message
        if self.task_execute_time is not None:
            result['TaskExecuteTime'] = self.task_execute_time
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.task_inner_error_message is not None:
            result['TaskInnerErrorMessage'] = self.task_inner_error_message
        if self.task_intermediate_result is not None:
            result['TaskIntermediateResult'] = self.task_intermediate_result
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        if self.task_param is not None:
            result['TaskParam'] = self.task_param
        if self.task_progress_message is not None:
            result['TaskProgressMessage'] = self.task_progress_message
        if self.task_result is not None:
            result['TaskResult'] = self.task_result
        if self.task_retry_count is not None:
            result['TaskRetryCount'] = self.task_retry_count
        if self.task_start_time is not None:
            result['TaskStartTime'] = self.task_start_time
        if self.task_status is not None:
            result['TaskStatus'] = self.task_status
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        if self.update_user is not None:
            result['UpdateUser'] = self.update_user
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('CreateUser') is not None:
            self.create_user = m.get('CreateUser')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('TaskCode') is not None:
            self.task_code = m.get('TaskCode')
        if m.get('TaskDefinition') is not None:
            self.task_definition = m.get('TaskDefinition')
        if m.get('TaskEndTime') is not None:
            self.task_end_time = m.get('TaskEndTime')
        if m.get('TaskErrorMessage') is not None:
            self.task_error_message = m.get('TaskErrorMessage')
        if m.get('TaskExecuteTime') is not None:
            self.task_execute_time = m.get('TaskExecuteTime')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('TaskInnerErrorMessage') is not None:
            self.task_inner_error_message = m.get('TaskInnerErrorMessage')
        if m.get('TaskIntermediateResult') is not None:
            self.task_intermediate_result = m.get('TaskIntermediateResult')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        if m.get('TaskParam') is not None:
            self.task_param = m.get('TaskParam')
        if m.get('TaskProgressMessage') is not None:
            self.task_progress_message = m.get('TaskProgressMessage')
        if m.get('TaskResult') is not None:
            self.task_result = m.get('TaskResult')
        if m.get('TaskRetryCount') is not None:
            self.task_retry_count = m.get('TaskRetryCount')
        if m.get('TaskStartTime') is not None:
            self.task_start_time = m.get('TaskStartTime')
        if m.get('TaskStatus') is not None:
            self.task_status = m.get('TaskStatus')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        if m.get('UpdateUser') is not None:
            self.update_user = m.get('UpdateUser')
        return self


class ListAsyncTasksResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        current: int = None,
        data: List[ListAsyncTasksResponseBodyData] = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        size: int = None,
        success: bool = None,
        total: int = None,
    ):
        self.code = code
        self.current = current
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        self.request_id = request_id
        self.size = size
        self.success = success
        self.total = total

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.current is not None:
            result['Current'] = self.current
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.size is not None:
            result['Size'] = self.size
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Current') is not None:
            self.current = m.get('Current')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ListAsyncTasksResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class ListAsyncTasksResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListAsyncTasksResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListAsyncTasksResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListAuditContentErrorTypesRequest(TeaModel):
    def __init__(
        self,
        max_results: int = None,
        next_token: str = None,
        workspace_id: str = None,
    ):
        self.max_results = max_results
        self.next_token = next_token
        self.workspace_id = workspace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        return self


class ListAuditContentErrorTypesResponseBodyDataSubClasses(TeaModel):
    def __init__(
        self,
        class_code: str = None,
        class_name: str = None,
    ):
        self.class_code = class_code
        self.class_name = class_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.class_code is not None:
            result['ClassCode'] = self.class_code
        if self.class_name is not None:
            result['ClassName'] = self.class_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClassCode') is not None:
            self.class_code = m.get('ClassCode')
        if m.get('ClassName') is not None:
            self.class_name = m.get('ClassName')
        return self


class ListAuditContentErrorTypesResponseBodyData(TeaModel):
    def __init__(
        self,
        major_class_code: str = None,
        major_class_name: str = None,
        sub_classes: List[ListAuditContentErrorTypesResponseBodyDataSubClasses] = None,
    ):
        self.major_class_code = major_class_code
        self.major_class_name = major_class_name
        self.sub_classes = sub_classes

    def validate(self):
        if self.sub_classes:
            for k in self.sub_classes:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.major_class_code is not None:
            result['MajorClassCode'] = self.major_class_code
        if self.major_class_name is not None:
            result['MajorClassName'] = self.major_class_name
        result['SubClasses'] = []
        if self.sub_classes is not None:
            for k in self.sub_classes:
                result['SubClasses'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MajorClassCode') is not None:
            self.major_class_code = m.get('MajorClassCode')
        if m.get('MajorClassName') is not None:
            self.major_class_name = m.get('MajorClassName')
        self.sub_classes = []
        if m.get('SubClasses') is not None:
            for k in m.get('SubClasses'):
                temp_model = ListAuditContentErrorTypesResponseBodyDataSubClasses()
                self.sub_classes.append(temp_model.from_map(k))
        return self


class ListAuditContentErrorTypesResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: List[ListAuditContentErrorTypesResponseBodyData] = None,
        http_status_code: int = None,
        max_results: int = None,
        message: str = None,
        next_token: str = None,
        request_id: str = None,
        success: bool = None,
        total_count: int = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.max_results = max_results
        self.message = message
        self.next_token = next_token
        # Id of the request
        self.request_id = request_id
        self.success = success
        self.total_count = total_count

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.message is not None:
            result['Message'] = self.message
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ListAuditContentErrorTypesResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListAuditContentErrorTypesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListAuditContentErrorTypesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListAuditContentErrorTypesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListAuditTermsRequest(TeaModel):
    def __init__(
        self,
        max_results: int = None,
        next_token: str = None,
        workspace_id: str = None,
    ):
        self.max_results = max_results
        self.next_token = next_token
        # This parameter is required.
        self.workspace_id = workspace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        return self


class ListAuditTermsResponseBodyData(TeaModel):
    def __init__(
        self,
        exception_word: List[str] = None,
        id: str = None,
        keyword: str = None,
        suggest_word: str = None,
        terms_desc: str = None,
    ):
        self.exception_word = exception_word
        self.id = id
        self.keyword = keyword
        self.suggest_word = suggest_word
        self.terms_desc = terms_desc

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.exception_word is not None:
            result['ExceptionWord'] = self.exception_word
        if self.id is not None:
            result['Id'] = self.id
        if self.keyword is not None:
            result['Keyword'] = self.keyword
        if self.suggest_word is not None:
            result['SuggestWord'] = self.suggest_word
        if self.terms_desc is not None:
            result['TermsDesc'] = self.terms_desc
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExceptionWord') is not None:
            self.exception_word = m.get('ExceptionWord')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Keyword') is not None:
            self.keyword = m.get('Keyword')
        if m.get('SuggestWord') is not None:
            self.suggest_word = m.get('SuggestWord')
        if m.get('TermsDesc') is not None:
            self.terms_desc = m.get('TermsDesc')
        return self


class ListAuditTermsResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: List[ListAuditTermsResponseBodyData] = None,
        http_status_code: int = None,
        max_results: int = None,
        message: str = None,
        next_token: str = None,
        request_id: str = None,
        success: bool = None,
        total_count: int = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.max_results = max_results
        self.message = message
        self.next_token = next_token
        # Id of the request
        self.request_id = request_id
        self.success = success
        self.total_count = total_count

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.message is not None:
            result['Message'] = self.message
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ListAuditTermsResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListAuditTermsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListAuditTermsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListAuditTermsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListBiddingDocRequest(TeaModel):
    def __init__(
        self,
        create_time_end: str = None,
        create_time_start: str = None,
        current: int = None,
        max_results: int = None,
        next_token: str = None,
        size: int = None,
        skip: int = None,
        task_name: str = None,
        task_status: int = None,
        workspace_id: str = None,
    ):
        self.create_time_end = create_time_end
        self.create_time_start = create_time_start
        self.current = current
        self.max_results = max_results
        self.next_token = next_token
        self.size = size
        self.skip = skip
        self.task_name = task_name
        self.task_status = task_status
        self.workspace_id = workspace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time_end is not None:
            result['CreateTimeEnd'] = self.create_time_end
        if self.create_time_start is not None:
            result['CreateTimeStart'] = self.create_time_start
        if self.current is not None:
            result['Current'] = self.current
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.size is not None:
            result['Size'] = self.size
        if self.skip is not None:
            result['Skip'] = self.skip
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        if self.task_status is not None:
            result['TaskStatus'] = self.task_status
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTimeEnd') is not None:
            self.create_time_end = m.get('CreateTimeEnd')
        if m.get('CreateTimeStart') is not None:
            self.create_time_start = m.get('CreateTimeStart')
        if m.get('Current') is not None:
            self.current = m.get('Current')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('Skip') is not None:
            self.skip = m.get('Skip')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        if m.get('TaskStatus') is not None:
            self.task_status = m.get('TaskStatus')
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        return self


class ListBiddingDocResponseBodyData(TeaModel):
    def __init__(
        self,
        create_time_start: str = None,
        task_id: str = None,
        task_name: str = None,
        task_status: int = None,
        task_step: str = None,
    ):
        self.create_time_start = create_time_start
        self.task_id = task_id
        self.task_name = task_name
        self.task_status = task_status
        self.task_step = task_step

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time_start is not None:
            result['CreateTimeStart'] = self.create_time_start
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        if self.task_status is not None:
            result['TaskStatus'] = self.task_status
        if self.task_step is not None:
            result['TaskStep'] = self.task_step
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTimeStart') is not None:
            self.create_time_start = m.get('CreateTimeStart')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        if m.get('TaskStatus') is not None:
            self.task_status = m.get('TaskStatus')
        if m.get('TaskStep') is not None:
            self.task_step = m.get('TaskStep')
        return self


class ListBiddingDocResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        current: int = None,
        data: List[ListBiddingDocResponseBodyData] = None,
        http_status_code: int = None,
        max_results: int = None,
        message: str = None,
        next_token: str = None,
        request_id: str = None,
        size: int = None,
        success: bool = None,
        total: int = None,
        total_count: int = None,
    ):
        self.code = code
        self.current = current
        self.data = data
        self.http_status_code = http_status_code
        self.max_results = max_results
        self.message = message
        self.next_token = next_token
        # Id of the request
        self.request_id = request_id
        self.size = size
        self.success = success
        self.total = total
        self.total_count = total_count

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.current is not None:
            result['Current'] = self.current
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.message is not None:
            result['Message'] = self.message
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.size is not None:
            result['Size'] = self.size
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Current') is not None:
            self.current = m.get('Current')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ListBiddingDocResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListBiddingDocResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListBiddingDocResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListBiddingDocResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListBuildConfigsRequest(TeaModel):
    def __init__(
        self,
        agent_key: str = None,
        region_id: str = None,
        type: str = None,
    ):
        # This parameter is required.
        self.agent_key = agent_key
        self.region_id = region_id
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_key is not None:
            result['AgentKey'] = self.agent_key
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentKey') is not None:
            self.agent_key = m.get('AgentKey')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class ListBuildConfigsResponseBodyDataKeywords(TeaModel):
    def __init__(
        self,
        description: str = None,
        key: str = None,
    ):
        self.description = description
        self.key = key

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.key is not None:
            result['Key'] = self.key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Key') is not None:
            self.key = m.get('Key')
        return self


class ListBuildConfigsResponseBodyData(TeaModel):
    def __init__(
        self,
        build_in: bool = None,
        create_time: str = None,
        create_user: str = None,
        id: int = None,
        keywords: List[ListBuildConfigsResponseBodyDataKeywords] = None,
        tag: str = None,
        tag_description: str = None,
        type: str = None,
        update_time: str = None,
        update_user: str = None,
    ):
        self.build_in = build_in
        self.create_time = create_time
        self.create_user = create_user
        self.id = id
        self.keywords = keywords
        self.tag = tag
        self.tag_description = tag_description
        self.type = type
        self.update_time = update_time
        self.update_user = update_user

    def validate(self):
        if self.keywords:
            for k in self.keywords:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.build_in is not None:
            result['BuildIn'] = self.build_in
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.create_user is not None:
            result['CreateUser'] = self.create_user
        if self.id is not None:
            result['Id'] = self.id
        result['Keywords'] = []
        if self.keywords is not None:
            for k in self.keywords:
                result['Keywords'].append(k.to_map() if k else None)
        if self.tag is not None:
            result['Tag'] = self.tag
        if self.tag_description is not None:
            result['TagDescription'] = self.tag_description
        if self.type is not None:
            result['Type'] = self.type
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        if self.update_user is not None:
            result['UpdateUser'] = self.update_user
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BuildIn') is not None:
            self.build_in = m.get('BuildIn')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('CreateUser') is not None:
            self.create_user = m.get('CreateUser')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        self.keywords = []
        if m.get('Keywords') is not None:
            for k in m.get('Keywords'):
                temp_model = ListBuildConfigsResponseBodyDataKeywords()
                self.keywords.append(temp_model.from_map(k))
        if m.get('Tag') is not None:
            self.tag = m.get('Tag')
        if m.get('TagDescription') is not None:
            self.tag_description = m.get('TagDescription')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        if m.get('UpdateUser') is not None:
            self.update_user = m.get('UpdateUser')
        return self


class ListBuildConfigsResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: List[ListBuildConfigsResponseBodyData] = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ListBuildConfigsResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ListBuildConfigsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListBuildConfigsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListBuildConfigsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListCustomTextRequest(TeaModel):
    def __init__(
        self,
        agent_key: str = None,
        commodity_code: str = None,
    ):
        # This parameter is required.
        self.agent_key = agent_key
        self.commodity_code = commodity_code

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_key is not None:
            result['AgentKey'] = self.agent_key
        if self.commodity_code is not None:
            result['CommodityCode'] = self.commodity_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentKey') is not None:
            self.agent_key = m.get('AgentKey')
        if m.get('CommodityCode') is not None:
            self.commodity_code = m.get('CommodityCode')
        return self


class ListCustomTextResponseBodyData(TeaModel):
    def __init__(
        self,
        content: str = None,
        create_time: str = None,
        create_user: str = None,
        id: int = None,
        title: str = None,
        update_time: str = None,
        update_user: str = None,
    ):
        self.content = content
        self.create_time = create_time
        self.create_user = create_user
        self.id = id
        self.title = title
        self.update_time = update_time
        self.update_user = update_user

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.create_user is not None:
            result['CreateUser'] = self.create_user
        if self.id is not None:
            result['Id'] = self.id
        if self.title is not None:
            result['Title'] = self.title
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        if self.update_user is not None:
            result['UpdateUser'] = self.update_user
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('CreateUser') is not None:
            self.create_user = m.get('CreateUser')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        if m.get('UpdateUser') is not None:
            self.update_user = m.get('UpdateUser')
        return self


class ListCustomTextResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: List[ListCustomTextResponseBodyData] = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ListCustomTextResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ListCustomTextResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListCustomTextResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListCustomTextResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListCustomViewPointsRequest(TeaModel):
    def __init__(
        self,
        agent_key: str = None,
        attitude: str = None,
        attitudes: List[str] = None,
        custom_view_point_id: str = None,
        custom_view_point_ids: List[str] = None,
        max_results: int = None,
        next_token: str = None,
        topic: str = None,
        topic_id: str = None,
    ):
        # This parameter is required.
        self.agent_key = agent_key
        self.attitude = attitude
        self.attitudes = attitudes
        self.custom_view_point_id = custom_view_point_id
        self.custom_view_point_ids = custom_view_point_ids
        self.max_results = max_results
        self.next_token = next_token
        self.topic = topic
        self.topic_id = topic_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_key is not None:
            result['AgentKey'] = self.agent_key
        if self.attitude is not None:
            result['Attitude'] = self.attitude
        if self.attitudes is not None:
            result['Attitudes'] = self.attitudes
        if self.custom_view_point_id is not None:
            result['CustomViewPointId'] = self.custom_view_point_id
        if self.custom_view_point_ids is not None:
            result['CustomViewPointIds'] = self.custom_view_point_ids
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.topic is not None:
            result['Topic'] = self.topic
        if self.topic_id is not None:
            result['TopicId'] = self.topic_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentKey') is not None:
            self.agent_key = m.get('AgentKey')
        if m.get('Attitude') is not None:
            self.attitude = m.get('Attitude')
        if m.get('Attitudes') is not None:
            self.attitudes = m.get('Attitudes')
        if m.get('CustomViewPointId') is not None:
            self.custom_view_point_id = m.get('CustomViewPointId')
        if m.get('CustomViewPointIds') is not None:
            self.custom_view_point_ids = m.get('CustomViewPointIds')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('Topic') is not None:
            self.topic = m.get('Topic')
        if m.get('TopicId') is not None:
            self.topic_id = m.get('TopicId')
        return self


class ListCustomViewPointsShrinkRequest(TeaModel):
    def __init__(
        self,
        agent_key: str = None,
        attitude: str = None,
        attitudes_shrink: str = None,
        custom_view_point_id: str = None,
        custom_view_point_ids_shrink: str = None,
        max_results: int = None,
        next_token: str = None,
        topic: str = None,
        topic_id: str = None,
    ):
        # This parameter is required.
        self.agent_key = agent_key
        self.attitude = attitude
        self.attitudes_shrink = attitudes_shrink
        self.custom_view_point_id = custom_view_point_id
        self.custom_view_point_ids_shrink = custom_view_point_ids_shrink
        self.max_results = max_results
        self.next_token = next_token
        self.topic = topic
        self.topic_id = topic_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_key is not None:
            result['AgentKey'] = self.agent_key
        if self.attitude is not None:
            result['Attitude'] = self.attitude
        if self.attitudes_shrink is not None:
            result['Attitudes'] = self.attitudes_shrink
        if self.custom_view_point_id is not None:
            result['CustomViewPointId'] = self.custom_view_point_id
        if self.custom_view_point_ids_shrink is not None:
            result['CustomViewPointIds'] = self.custom_view_point_ids_shrink
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.topic is not None:
            result['Topic'] = self.topic
        if self.topic_id is not None:
            result['TopicId'] = self.topic_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentKey') is not None:
            self.agent_key = m.get('AgentKey')
        if m.get('Attitude') is not None:
            self.attitude = m.get('Attitude')
        if m.get('Attitudes') is not None:
            self.attitudes_shrink = m.get('Attitudes')
        if m.get('CustomViewPointId') is not None:
            self.custom_view_point_id = m.get('CustomViewPointId')
        if m.get('CustomViewPointIds') is not None:
            self.custom_view_point_ids_shrink = m.get('CustomViewPointIds')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('Topic') is not None:
            self.topic = m.get('Topic')
        if m.get('TopicId') is not None:
            self.topic_id = m.get('TopicId')
        return self


class ListCustomViewPointsResponseBodyDataViewPointsOutlines(TeaModel):
    def __init__(
        self,
        outline: str = None,
        summary: str = None,
    ):
        self.outline = outline
        self.summary = summary

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.outline is not None:
            result['Outline'] = self.outline
        if self.summary is not None:
            result['Summary'] = self.summary
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Outline') is not None:
            self.outline = m.get('Outline')
        if m.get('Summary') is not None:
            self.summary = m.get('Summary')
        return self


class ListCustomViewPointsResponseBodyDataViewPoints(TeaModel):
    def __init__(
        self,
        outlines: List[ListCustomViewPointsResponseBodyDataViewPointsOutlines] = None,
        point: str = None,
        summary: str = None,
    ):
        self.outlines = outlines
        self.point = point
        self.summary = summary

    def validate(self):
        if self.outlines:
            for k in self.outlines:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Outlines'] = []
        if self.outlines is not None:
            for k in self.outlines:
                result['Outlines'].append(k.to_map() if k else None)
        if self.point is not None:
            result['Point'] = self.point
        if self.summary is not None:
            result['Summary'] = self.summary
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.outlines = []
        if m.get('Outlines') is not None:
            for k in m.get('Outlines'):
                temp_model = ListCustomViewPointsResponseBodyDataViewPointsOutlines()
                self.outlines.append(temp_model.from_map(k))
        if m.get('Point') is not None:
            self.point = m.get('Point')
        if m.get('Summary') is not None:
            self.summary = m.get('Summary')
        return self


class ListCustomViewPointsResponseBodyData(TeaModel):
    def __init__(
        self,
        async_task_id: str = None,
        attitude: str = None,
        create_time: str = None,
        create_user: str = None,
        id: str = None,
        status: str = None,
        task_error_message: str = None,
        task_status: int = None,
        view_points: List[ListCustomViewPointsResponseBodyDataViewPoints] = None,
    ):
        self.async_task_id = async_task_id
        self.attitude = attitude
        self.create_time = create_time
        self.create_user = create_user
        self.id = id
        self.status = status
        self.task_error_message = task_error_message
        self.task_status = task_status
        self.view_points = view_points

    def validate(self):
        if self.view_points:
            for k in self.view_points:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.async_task_id is not None:
            result['AsyncTaskId'] = self.async_task_id
        if self.attitude is not None:
            result['Attitude'] = self.attitude
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.create_user is not None:
            result['CreateUser'] = self.create_user
        if self.id is not None:
            result['Id'] = self.id
        if self.status is not None:
            result['Status'] = self.status
        if self.task_error_message is not None:
            result['TaskErrorMessage'] = self.task_error_message
        if self.task_status is not None:
            result['TaskStatus'] = self.task_status
        result['ViewPoints'] = []
        if self.view_points is not None:
            for k in self.view_points:
                result['ViewPoints'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AsyncTaskId') is not None:
            self.async_task_id = m.get('AsyncTaskId')
        if m.get('Attitude') is not None:
            self.attitude = m.get('Attitude')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('CreateUser') is not None:
            self.create_user = m.get('CreateUser')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TaskErrorMessage') is not None:
            self.task_error_message = m.get('TaskErrorMessage')
        if m.get('TaskStatus') is not None:
            self.task_status = m.get('TaskStatus')
        self.view_points = []
        if m.get('ViewPoints') is not None:
            for k in m.get('ViewPoints'):
                temp_model = ListCustomViewPointsResponseBodyDataViewPoints()
                self.view_points.append(temp_model.from_map(k))
        return self


class ListCustomViewPointsResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: List[ListCustomViewPointsResponseBodyData] = None,
        http_status_code: int = None,
        max_results: int = None,
        message: str = None,
        next_token: str = None,
        request_id: str = None,
        success: bool = None,
        total_count: int = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.max_results = max_results
        self.message = message
        self.next_token = next_token
        self.request_id = request_id
        self.success = success
        self.total_count = total_count

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.message is not None:
            result['Message'] = self.message
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ListCustomViewPointsResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListCustomViewPointsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListCustomViewPointsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListCustomViewPointsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListDatasetDocumentsRequest(TeaModel):
    def __init__(
        self,
        dataset_description: str = None,
        dataset_id: int = None,
        dataset_name: str = None,
        doc_type: str = None,
        exclude_fields: List[str] = None,
        include_fields: List[str] = None,
        page_number: int = None,
        page_size: int = None,
        query: str = None,
        status: int = None,
        workspace_id: str = None,
    ):
        self.dataset_description = dataset_description
        self.dataset_id = dataset_id
        self.dataset_name = dataset_name
        self.doc_type = doc_type
        self.exclude_fields = exclude_fields
        self.include_fields = include_fields
        self.page_number = page_number
        self.page_size = page_size
        self.query = query
        self.status = status
        # This parameter is required.
        self.workspace_id = workspace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dataset_description is not None:
            result['DatasetDescription'] = self.dataset_description
        if self.dataset_id is not None:
            result['DatasetId'] = self.dataset_id
        if self.dataset_name is not None:
            result['DatasetName'] = self.dataset_name
        if self.doc_type is not None:
            result['DocType'] = self.doc_type
        if self.exclude_fields is not None:
            result['ExcludeFields'] = self.exclude_fields
        if self.include_fields is not None:
            result['IncludeFields'] = self.include_fields
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.query is not None:
            result['Query'] = self.query
        if self.status is not None:
            result['Status'] = self.status
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DatasetDescription') is not None:
            self.dataset_description = m.get('DatasetDescription')
        if m.get('DatasetId') is not None:
            self.dataset_id = m.get('DatasetId')
        if m.get('DatasetName') is not None:
            self.dataset_name = m.get('DatasetName')
        if m.get('DocType') is not None:
            self.doc_type = m.get('DocType')
        if m.get('ExcludeFields') is not None:
            self.exclude_fields = m.get('ExcludeFields')
        if m.get('IncludeFields') is not None:
            self.include_fields = m.get('IncludeFields')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Query') is not None:
            self.query = m.get('Query')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        return self


class ListDatasetDocumentsShrinkRequest(TeaModel):
    def __init__(
        self,
        dataset_description: str = None,
        dataset_id: int = None,
        dataset_name: str = None,
        doc_type: str = None,
        exclude_fields_shrink: str = None,
        include_fields_shrink: str = None,
        page_number: int = None,
        page_size: int = None,
        query: str = None,
        status: int = None,
        workspace_id: str = None,
    ):
        self.dataset_description = dataset_description
        self.dataset_id = dataset_id
        self.dataset_name = dataset_name
        self.doc_type = doc_type
        self.exclude_fields_shrink = exclude_fields_shrink
        self.include_fields_shrink = include_fields_shrink
        self.page_number = page_number
        self.page_size = page_size
        self.query = query
        self.status = status
        # This parameter is required.
        self.workspace_id = workspace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dataset_description is not None:
            result['DatasetDescription'] = self.dataset_description
        if self.dataset_id is not None:
            result['DatasetId'] = self.dataset_id
        if self.dataset_name is not None:
            result['DatasetName'] = self.dataset_name
        if self.doc_type is not None:
            result['DocType'] = self.doc_type
        if self.exclude_fields_shrink is not None:
            result['ExcludeFields'] = self.exclude_fields_shrink
        if self.include_fields_shrink is not None:
            result['IncludeFields'] = self.include_fields_shrink
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.query is not None:
            result['Query'] = self.query
        if self.status is not None:
            result['Status'] = self.status
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DatasetDescription') is not None:
            self.dataset_description = m.get('DatasetDescription')
        if m.get('DatasetId') is not None:
            self.dataset_id = m.get('DatasetId')
        if m.get('DatasetName') is not None:
            self.dataset_name = m.get('DatasetName')
        if m.get('DocType') is not None:
            self.doc_type = m.get('DocType')
        if m.get('ExcludeFields') is not None:
            self.exclude_fields_shrink = m.get('ExcludeFields')
        if m.get('IncludeFields') is not None:
            self.include_fields_shrink = m.get('IncludeFields')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Query') is not None:
            self.query = m.get('Query')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        return self


class ListDatasetDocumentsResponseBodyDataMultimodalMedias(TeaModel):
    def __init__(
        self,
        file_url: str = None,
        media_id: str = None,
        media_type: str = None,
    ):
        self.file_url = file_url
        self.media_id = media_id
        self.media_type = media_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_url is not None:
            result['FileUrl'] = self.file_url
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        if self.media_type is not None:
            result['MediaType'] = self.media_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FileUrl') is not None:
            self.file_url = m.get('FileUrl')
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        if m.get('MediaType') is not None:
            self.media_type = m.get('MediaType')
        return self


class ListDatasetDocumentsResponseBodyData(TeaModel):
    def __init__(
        self,
        category_uuid: str = None,
        content: str = None,
        create_time: str = None,
        disable_handle_multimodal_media: bool = None,
        doc_id: str = None,
        doc_type: str = None,
        doc_uuid: str = None,
        extend_1: str = None,
        extend_2: str = None,
        extend_3: str = None,
        multimodal_medias: List[ListDatasetDocumentsResponseBodyDataMultimodalMedias] = None,
        pub_time: str = None,
        source_from: str = None,
        status: int = None,
        summary: str = None,
        title: str = None,
        update_time: str = None,
        url: str = None,
    ):
        self.category_uuid = category_uuid
        self.content = content
        self.create_time = create_time
        self.disable_handle_multimodal_media = disable_handle_multimodal_media
        self.doc_id = doc_id
        self.doc_type = doc_type
        self.doc_uuid = doc_uuid
        self.extend_1 = extend_1
        self.extend_2 = extend_2
        self.extend_3 = extend_3
        self.multimodal_medias = multimodal_medias
        self.pub_time = pub_time
        self.source_from = source_from
        self.status = status
        self.summary = summary
        self.title = title
        self.update_time = update_time
        # url
        self.url = url

    def validate(self):
        if self.multimodal_medias:
            for k in self.multimodal_medias:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category_uuid is not None:
            result['CategoryUuid'] = self.category_uuid
        if self.content is not None:
            result['Content'] = self.content
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.disable_handle_multimodal_media is not None:
            result['DisableHandleMultimodalMedia'] = self.disable_handle_multimodal_media
        if self.doc_id is not None:
            result['DocId'] = self.doc_id
        if self.doc_type is not None:
            result['DocType'] = self.doc_type
        if self.doc_uuid is not None:
            result['DocUuid'] = self.doc_uuid
        if self.extend_1 is not None:
            result['Extend1'] = self.extend_1
        if self.extend_2 is not None:
            result['Extend2'] = self.extend_2
        if self.extend_3 is not None:
            result['Extend3'] = self.extend_3
        result['MultimodalMedias'] = []
        if self.multimodal_medias is not None:
            for k in self.multimodal_medias:
                result['MultimodalMedias'].append(k.to_map() if k else None)
        if self.pub_time is not None:
            result['PubTime'] = self.pub_time
        if self.source_from is not None:
            result['SourceFrom'] = self.source_from
        if self.status is not None:
            result['Status'] = self.status
        if self.summary is not None:
            result['Summary'] = self.summary
        if self.title is not None:
            result['Title'] = self.title
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        if self.url is not None:
            result['Url'] = self.url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CategoryUuid') is not None:
            self.category_uuid = m.get('CategoryUuid')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('DisableHandleMultimodalMedia') is not None:
            self.disable_handle_multimodal_media = m.get('DisableHandleMultimodalMedia')
        if m.get('DocId') is not None:
            self.doc_id = m.get('DocId')
        if m.get('DocType') is not None:
            self.doc_type = m.get('DocType')
        if m.get('DocUuid') is not None:
            self.doc_uuid = m.get('DocUuid')
        if m.get('Extend1') is not None:
            self.extend_1 = m.get('Extend1')
        if m.get('Extend2') is not None:
            self.extend_2 = m.get('Extend2')
        if m.get('Extend3') is not None:
            self.extend_3 = m.get('Extend3')
        self.multimodal_medias = []
        if m.get('MultimodalMedias') is not None:
            for k in m.get('MultimodalMedias'):
                temp_model = ListDatasetDocumentsResponseBodyDataMultimodalMedias()
                self.multimodal_medias.append(temp_model.from_map(k))
        if m.get('PubTime') is not None:
            self.pub_time = m.get('PubTime')
        if m.get('SourceFrom') is not None:
            self.source_from = m.get('SourceFrom')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Summary') is not None:
            self.summary = m.get('Summary')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        return self


class ListDatasetDocumentsResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: List[ListDatasetDocumentsResponseBodyData] = None,
        http_status_code: int = None,
        message: str = None,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        success: bool = None,
        total_count: int = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        self.page_number = page_number
        self.page_size = page_size
        self.request_id = request_id
        self.success = success
        self.total_count = total_count

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ListDatasetDocumentsResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListDatasetDocumentsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListDatasetDocumentsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListDatasetDocumentsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListDatasetsRequest(TeaModel):
    def __init__(
        self,
        dataset_id: int = None,
        dataset_name: str = None,
        dataset_type: str = None,
        end_time: str = None,
        include_config: bool = None,
        page_number: int = None,
        page_size: str = None,
        search_dataset_enable: int = None,
        start_time: str = None,
        workspace_id: str = None,
    ):
        self.dataset_id = dataset_id
        self.dataset_name = dataset_name
        self.dataset_type = dataset_type
        self.end_time = end_time
        self.include_config = include_config
        self.page_number = page_number
        self.page_size = page_size
        self.search_dataset_enable = search_dataset_enable
        self.start_time = start_time
        # This parameter is required.
        self.workspace_id = workspace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dataset_id is not None:
            result['DatasetId'] = self.dataset_id
        if self.dataset_name is not None:
            result['DatasetName'] = self.dataset_name
        if self.dataset_type is not None:
            result['DatasetType'] = self.dataset_type
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.include_config is not None:
            result['IncludeConfig'] = self.include_config
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.search_dataset_enable is not None:
            result['SearchDatasetEnable'] = self.search_dataset_enable
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DatasetId') is not None:
            self.dataset_id = m.get('DatasetId')
        if m.get('DatasetName') is not None:
            self.dataset_name = m.get('DatasetName')
        if m.get('DatasetType') is not None:
            self.dataset_type = m.get('DatasetType')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('IncludeConfig') is not None:
            self.include_config = m.get('IncludeConfig')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SearchDatasetEnable') is not None:
            self.search_dataset_enable = m.get('SearchDatasetEnable')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        return self


class ListDatasetsResponseBodyCustomSemanticSearchConfig(TeaModel):
    def __init__(
        self,
        dataset_quota: int = None,
        dataset_used_quota: int = None,
        doc_quota: int = None,
        doc_used_quota: int = None,
    ):
        self.dataset_quota = dataset_quota
        self.dataset_used_quota = dataset_used_quota
        self.doc_quota = doc_quota
        self.doc_used_quota = doc_used_quota

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dataset_quota is not None:
            result['DatasetQuota'] = self.dataset_quota
        if self.dataset_used_quota is not None:
            result['DatasetUsedQuota'] = self.dataset_used_quota
        if self.doc_quota is not None:
            result['DocQuota'] = self.doc_quota
        if self.doc_used_quota is not None:
            result['DocUsedQuota'] = self.doc_used_quota
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DatasetQuota') is not None:
            self.dataset_quota = m.get('DatasetQuota')
        if m.get('DatasetUsedQuota') is not None:
            self.dataset_used_quota = m.get('DatasetUsedQuota')
        if m.get('DocQuota') is not None:
            self.doc_quota = m.get('DocQuota')
        if m.get('DocUsedQuota') is not None:
            self.doc_used_quota = m.get('DocUsedQuota')
        return self


class ListDatasetsResponseBodyData(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        create_user: str = None,
        dataset_description: str = None,
        dataset_id: int = None,
        dataset_name: str = None,
        dataset_type: str = None,
        doc_used_quota: int = None,
        search_dataset_enable: int = None,
    ):
        self.create_time = create_time
        self.create_user = create_user
        self.dataset_description = dataset_description
        self.dataset_id = dataset_id
        self.dataset_name = dataset_name
        self.dataset_type = dataset_type
        self.doc_used_quota = doc_used_quota
        self.search_dataset_enable = search_dataset_enable

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.create_user is not None:
            result['CreateUser'] = self.create_user
        if self.dataset_description is not None:
            result['DatasetDescription'] = self.dataset_description
        if self.dataset_id is not None:
            result['DatasetId'] = self.dataset_id
        if self.dataset_name is not None:
            result['DatasetName'] = self.dataset_name
        if self.dataset_type is not None:
            result['DatasetType'] = self.dataset_type
        if self.doc_used_quota is not None:
            result['DocUsedQuota'] = self.doc_used_quota
        if self.search_dataset_enable is not None:
            result['SearchDatasetEnable'] = self.search_dataset_enable
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('CreateUser') is not None:
            self.create_user = m.get('CreateUser')
        if m.get('DatasetDescription') is not None:
            self.dataset_description = m.get('DatasetDescription')
        if m.get('DatasetId') is not None:
            self.dataset_id = m.get('DatasetId')
        if m.get('DatasetName') is not None:
            self.dataset_name = m.get('DatasetName')
        if m.get('DatasetType') is not None:
            self.dataset_type = m.get('DatasetType')
        if m.get('DocUsedQuota') is not None:
            self.doc_used_quota = m.get('DocUsedQuota')
        if m.get('SearchDatasetEnable') is not None:
            self.search_dataset_enable = m.get('SearchDatasetEnable')
        return self


class ListDatasetsResponseBodyThirdSearchConfig(TeaModel):
    def __init__(
        self,
        dataset_quota: int = None,
        dataset_used_quota: int = None,
    ):
        self.dataset_quota = dataset_quota
        self.dataset_used_quota = dataset_used_quota

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dataset_quota is not None:
            result['DatasetQuota'] = self.dataset_quota
        if self.dataset_used_quota is not None:
            result['DatasetUsedQuota'] = self.dataset_used_quota
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DatasetQuota') is not None:
            self.dataset_quota = m.get('DatasetQuota')
        if m.get('DatasetUsedQuota') is not None:
            self.dataset_used_quota = m.get('DatasetUsedQuota')
        return self


class ListDatasetsResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        custom_semantic_search_config: ListDatasetsResponseBodyCustomSemanticSearchConfig = None,
        data: List[ListDatasetsResponseBodyData] = None,
        http_status_code: int = None,
        message: str = None,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        success: bool = None,
        third_search_config: ListDatasetsResponseBodyThirdSearchConfig = None,
        total_count: int = None,
    ):
        self.code = code
        self.custom_semantic_search_config = custom_semantic_search_config
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        self.page_number = page_number
        self.page_size = page_size
        self.request_id = request_id
        self.success = success
        self.third_search_config = third_search_config
        self.total_count = total_count

    def validate(self):
        if self.custom_semantic_search_config:
            self.custom_semantic_search_config.validate()
        if self.data:
            for k in self.data:
                if k:
                    k.validate()
        if self.third_search_config:
            self.third_search_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.custom_semantic_search_config is not None:
            result['CustomSemanticSearchConfig'] = self.custom_semantic_search_config.to_map()
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.third_search_config is not None:
            result['ThirdSearchConfig'] = self.third_search_config.to_map()
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('CustomSemanticSearchConfig') is not None:
            temp_model = ListDatasetsResponseBodyCustomSemanticSearchConfig()
            self.custom_semantic_search_config = temp_model.from_map(m['CustomSemanticSearchConfig'])
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ListDatasetsResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ThirdSearchConfig') is not None:
            temp_model = ListDatasetsResponseBodyThirdSearchConfig()
            self.third_search_config = temp_model.from_map(m['ThirdSearchConfig'])
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListDatasetsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListDatasetsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListDatasetsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListDialoguesRequest(TeaModel):
    def __init__(
        self,
        agent_key: str = None,
        current: int = None,
        dialogue_type: int = None,
        end_time: str = None,
        size: int = None,
        start_time: str = None,
        task_id: str = None,
    ):
        # This parameter is required.
        self.agent_key = agent_key
        self.current = current
        self.dialogue_type = dialogue_type
        self.end_time = end_time
        self.size = size
        self.start_time = start_time
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_key is not None:
            result['AgentKey'] = self.agent_key
        if self.current is not None:
            result['Current'] = self.current
        if self.dialogue_type is not None:
            result['DialogueType'] = self.dialogue_type
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.size is not None:
            result['Size'] = self.size
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentKey') is not None:
            self.agent_key = m.get('AgentKey')
        if m.get('Current') is not None:
            self.current = m.get('Current')
        if m.get('DialogueType') is not None:
            self.dialogue_type = m.get('DialogueType')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class ListDialoguesResponseBodyData(TeaModel):
    def __init__(
        self,
        bot: str = None,
        create_time: str = None,
        create_user: str = None,
        dialogue_type: int = None,
        task_id: str = None,
        user: str = None,
    ):
        self.bot = bot
        self.create_time = create_time
        self.create_user = create_user
        self.dialogue_type = dialogue_type
        self.task_id = task_id
        self.user = user

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bot is not None:
            result['Bot'] = self.bot
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.create_user is not None:
            result['CreateUser'] = self.create_user
        if self.dialogue_type is not None:
            result['DialogueType'] = self.dialogue_type
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.user is not None:
            result['User'] = self.user
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bot') is not None:
            self.bot = m.get('Bot')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('CreateUser') is not None:
            self.create_user = m.get('CreateUser')
        if m.get('DialogueType') is not None:
            self.dialogue_type = m.get('DialogueType')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('User') is not None:
            self.user = m.get('User')
        return self


class ListDialoguesResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        current: int = None,
        data: List[ListDialoguesResponseBodyData] = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        size: int = None,
        success: bool = None,
        total: int = None,
    ):
        self.code = code
        self.current = current
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        self.request_id = request_id
        self.size = size
        self.success = success
        self.total = total

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.current is not None:
            result['Current'] = self.current
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.size is not None:
            result['Size'] = self.size
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Current') is not None:
            self.current = m.get('Current')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ListDialoguesResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class ListDialoguesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListDialoguesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListDialoguesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListDocsRequest(TeaModel):
    def __init__(
        self,
        category_id: str = None,
        doc_name: str = None,
        doc_type: str = None,
        max_results: int = None,
        next_token: str = None,
        skip: int = None,
        statuses: List[int] = None,
        workspace_id: str = None,
    ):
        self.category_id = category_id
        self.doc_name = doc_name
        self.doc_type = doc_type
        self.max_results = max_results
        self.next_token = next_token
        self.skip = skip
        self.statuses = statuses
        # This parameter is required.
        self.workspace_id = workspace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category_id is not None:
            result['CategoryId'] = self.category_id
        if self.doc_name is not None:
            result['DocName'] = self.doc_name
        if self.doc_type is not None:
            result['DocType'] = self.doc_type
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.skip is not None:
            result['Skip'] = self.skip
        if self.statuses is not None:
            result['Statuses'] = self.statuses
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CategoryId') is not None:
            self.category_id = m.get('CategoryId')
        if m.get('DocName') is not None:
            self.doc_name = m.get('DocName')
        if m.get('DocType') is not None:
            self.doc_type = m.get('DocType')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('Skip') is not None:
            self.skip = m.get('Skip')
        if m.get('Statuses') is not None:
            self.statuses = m.get('Statuses')
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        return self


class ListDocsShrinkRequest(TeaModel):
    def __init__(
        self,
        category_id: str = None,
        doc_name: str = None,
        doc_type: str = None,
        max_results: int = None,
        next_token: str = None,
        skip: int = None,
        statuses_shrink: str = None,
        workspace_id: str = None,
    ):
        self.category_id = category_id
        self.doc_name = doc_name
        self.doc_type = doc_type
        self.max_results = max_results
        self.next_token = next_token
        self.skip = skip
        self.statuses_shrink = statuses_shrink
        # This parameter is required.
        self.workspace_id = workspace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category_id is not None:
            result['CategoryId'] = self.category_id
        if self.doc_name is not None:
            result['DocName'] = self.doc_name
        if self.doc_type is not None:
            result['DocType'] = self.doc_type
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.skip is not None:
            result['Skip'] = self.skip
        if self.statuses_shrink is not None:
            result['Statuses'] = self.statuses_shrink
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CategoryId') is not None:
            self.category_id = m.get('CategoryId')
        if m.get('DocName') is not None:
            self.doc_name = m.get('DocName')
        if m.get('DocType') is not None:
            self.doc_type = m.get('DocType')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('Skip') is not None:
            self.skip = m.get('Skip')
        if m.get('Statuses') is not None:
            self.statuses_shrink = m.get('Statuses')
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        return self


class ListDocsResponseBodyData(TeaModel):
    def __init__(
        self,
        category_id: str = None,
        create_time: int = None,
        doc_id: str = None,
        doc_name: str = None,
        doc_type: str = None,
        status: int = None,
        status_message: str = None,
    ):
        self.category_id = category_id
        self.create_time = create_time
        self.doc_id = doc_id
        self.doc_name = doc_name
        self.doc_type = doc_type
        self.status = status
        self.status_message = status_message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category_id is not None:
            result['CategoryId'] = self.category_id
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.doc_id is not None:
            result['DocId'] = self.doc_id
        if self.doc_name is not None:
            result['DocName'] = self.doc_name
        if self.doc_type is not None:
            result['DocType'] = self.doc_type
        if self.status is not None:
            result['Status'] = self.status
        if self.status_message is not None:
            result['StatusMessage'] = self.status_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CategoryId') is not None:
            self.category_id = m.get('CategoryId')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('DocId') is not None:
            self.doc_id = m.get('DocId')
        if m.get('DocName') is not None:
            self.doc_name = m.get('DocName')
        if m.get('DocType') is not None:
            self.doc_type = m.get('DocType')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('StatusMessage') is not None:
            self.status_message = m.get('StatusMessage')
        return self


class ListDocsResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: List[ListDocsResponseBodyData] = None,
        http_status_code: int = None,
        max_results: int = None,
        message: str = None,
        next_token: str = None,
        request_id: str = None,
        success: bool = None,
        total_count: int = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.max_results = max_results
        self.message = message
        self.next_token = next_token
        self.request_id = request_id
        self.success = success
        self.total_count = total_count

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.message is not None:
            result['Message'] = self.message
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ListDocsResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListDocsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListDocsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListDocsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListFreshViewPointsRequest(TeaModel):
    def __init__(
        self,
        agent_key: str = None,
        max_results: int = None,
        next_token: str = None,
        topic: str = None,
        topic_source: str = None,
    ):
        # This parameter is required.
        self.agent_key = agent_key
        self.max_results = max_results
        self.next_token = next_token
        # This parameter is required.
        self.topic = topic
        # This parameter is required.
        self.topic_source = topic_source

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_key is not None:
            result['AgentKey'] = self.agent_key
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.topic is not None:
            result['Topic'] = self.topic
        if self.topic_source is not None:
            result['TopicSource'] = self.topic_source
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentKey') is not None:
            self.agent_key = m.get('AgentKey')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('Topic') is not None:
            self.topic = m.get('Topic')
        if m.get('TopicSource') is not None:
            self.topic_source = m.get('TopicSource')
        return self


class ListFreshViewPointsResponseBodyDataOutlines(TeaModel):
    def __init__(
        self,
        outline: str = None,
        summary: str = None,
    ):
        self.outline = outline
        self.summary = summary

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.outline is not None:
            result['Outline'] = self.outline
        if self.summary is not None:
            result['Summary'] = self.summary
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Outline') is not None:
            self.outline = m.get('Outline')
        if m.get('Summary') is not None:
            self.summary = m.get('Summary')
        return self


class ListFreshViewPointsResponseBodyData(TeaModel):
    def __init__(
        self,
        outlines: List[ListFreshViewPointsResponseBodyDataOutlines] = None,
        point: str = None,
        summary: str = None,
    ):
        self.outlines = outlines
        self.point = point
        self.summary = summary

    def validate(self):
        if self.outlines:
            for k in self.outlines:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Outlines'] = []
        if self.outlines is not None:
            for k in self.outlines:
                result['Outlines'].append(k.to_map() if k else None)
        if self.point is not None:
            result['Point'] = self.point
        if self.summary is not None:
            result['Summary'] = self.summary
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.outlines = []
        if m.get('Outlines') is not None:
            for k in m.get('Outlines'):
                temp_model = ListFreshViewPointsResponseBodyDataOutlines()
                self.outlines.append(temp_model.from_map(k))
        if m.get('Point') is not None:
            self.point = m.get('Point')
        if m.get('Summary') is not None:
            self.summary = m.get('Summary')
        return self


class ListFreshViewPointsResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: List[ListFreshViewPointsResponseBodyData] = None,
        http_status_code: int = None,
        max_results: int = None,
        message: str = None,
        next_token: str = None,
        request_id: str = None,
        success: bool = None,
        total_count: int = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.max_results = max_results
        self.message = message
        self.next_token = next_token
        self.request_id = request_id
        self.success = success
        self.total_count = total_count

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.message is not None:
            result['Message'] = self.message
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ListFreshViewPointsResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListFreshViewPointsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListFreshViewPointsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListFreshViewPointsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListGeneratedContentsRequest(TeaModel):
    def __init__(
        self,
        agent_key: str = None,
        content_domain: str = None,
        current: int = None,
        data_type: str = None,
        end_time: str = None,
        query: str = None,
        size: int = None,
        start_time: str = None,
        task_id: str = None,
        title: str = None,
    ):
        # This parameter is required.
        self.agent_key = agent_key
        self.content_domain = content_domain
        self.current = current
        self.data_type = data_type
        self.end_time = end_time
        self.query = query
        self.size = size
        self.start_time = start_time
        self.task_id = task_id
        self.title = title

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_key is not None:
            result['AgentKey'] = self.agent_key
        if self.content_domain is not None:
            result['ContentDomain'] = self.content_domain
        if self.current is not None:
            result['Current'] = self.current
        if self.data_type is not None:
            result['DataType'] = self.data_type
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.query is not None:
            result['Query'] = self.query
        if self.size is not None:
            result['Size'] = self.size
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.title is not None:
            result['Title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentKey') is not None:
            self.agent_key = m.get('AgentKey')
        if m.get('ContentDomain') is not None:
            self.content_domain = m.get('ContentDomain')
        if m.get('Current') is not None:
            self.current = m.get('Current')
        if m.get('DataType') is not None:
            self.data_type = m.get('DataType')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Query') is not None:
            self.query = m.get('Query')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        return self


class ListGeneratedContentsResponseBodyDataFileAttr(TeaModel):
    def __init__(
        self,
        file_name: str = None,
        height: int = None,
        tmp_url: str = None,
        width: int = None,
    ):
        self.file_name = file_name
        self.height = height
        self.tmp_url = tmp_url
        self.width = width

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.height is not None:
            result['Height'] = self.height
        if self.tmp_url is not None:
            result['TmpUrl'] = self.tmp_url
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('TmpUrl') is not None:
            self.tmp_url = m.get('TmpUrl')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class ListGeneratedContentsResponseBodyData(TeaModel):
    def __init__(
        self,
        content: str = None,
        content_domain: str = None,
        content_text: str = None,
        create_time: str = None,
        create_user: str = None,
        device_id: str = None,
        file_attr: ListGeneratedContentsResponseBodyDataFileAttr = None,
        file_key: str = None,
        id: int = None,
        keyword_list: List[str] = None,
        keywords: str = None,
        prompt: str = None,
        task_id: str = None,
        title: str = None,
        update_time: str = None,
        update_user: str = None,
        uuid: str = None,
    ):
        self.content = content
        self.content_domain = content_domain
        self.content_text = content_text
        self.create_time = create_time
        self.create_user = create_user
        self.device_id = device_id
        self.file_attr = file_attr
        self.file_key = file_key
        self.id = id
        self.keyword_list = keyword_list
        self.keywords = keywords
        self.prompt = prompt
        self.task_id = task_id
        self.title = title
        self.update_time = update_time
        self.update_user = update_user
        self.uuid = uuid

    def validate(self):
        if self.file_attr:
            self.file_attr.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.content_domain is not None:
            result['ContentDomain'] = self.content_domain
        if self.content_text is not None:
            result['ContentText'] = self.content_text
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.create_user is not None:
            result['CreateUser'] = self.create_user
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.file_attr is not None:
            result['FileAttr'] = self.file_attr.to_map()
        if self.file_key is not None:
            result['FileKey'] = self.file_key
        if self.id is not None:
            result['Id'] = self.id
        if self.keyword_list is not None:
            result['KeywordList'] = self.keyword_list
        if self.keywords is not None:
            result['Keywords'] = self.keywords
        if self.prompt is not None:
            result['Prompt'] = self.prompt
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.title is not None:
            result['Title'] = self.title
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        if self.update_user is not None:
            result['UpdateUser'] = self.update_user
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('ContentDomain') is not None:
            self.content_domain = m.get('ContentDomain')
        if m.get('ContentText') is not None:
            self.content_text = m.get('ContentText')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('CreateUser') is not None:
            self.create_user = m.get('CreateUser')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('FileAttr') is not None:
            temp_model = ListGeneratedContentsResponseBodyDataFileAttr()
            self.file_attr = temp_model.from_map(m['FileAttr'])
        if m.get('FileKey') is not None:
            self.file_key = m.get('FileKey')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('KeywordList') is not None:
            self.keyword_list = m.get('KeywordList')
        if m.get('Keywords') is not None:
            self.keywords = m.get('Keywords')
        if m.get('Prompt') is not None:
            self.prompt = m.get('Prompt')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        if m.get('UpdateUser') is not None:
            self.update_user = m.get('UpdateUser')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class ListGeneratedContentsResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        current: int = None,
        data: List[ListGeneratedContentsResponseBodyData] = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        size: int = None,
        success: bool = None,
        total: int = None,
    ):
        self.code = code
        self.current = current
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        self.request_id = request_id
        self.size = size
        self.success = success
        self.total = total

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.current is not None:
            result['Current'] = self.current
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.size is not None:
            result['Size'] = self.size
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Current') is not None:
            self.current = m.get('Current')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ListGeneratedContentsResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class ListGeneratedContentsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListGeneratedContentsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListGeneratedContentsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListHotNewsWithTypeRequest(TeaModel):
    def __init__(
        self,
        agent_key: str = None,
        current: int = None,
        news_type: str = None,
        news_types: List[str] = None,
        size: int = None,
    ):
        # This parameter is required.
        self.agent_key = agent_key
        self.current = current
        self.news_type = news_type
        self.news_types = news_types
        self.size = size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_key is not None:
            result['AgentKey'] = self.agent_key
        if self.current is not None:
            result['Current'] = self.current
        if self.news_type is not None:
            result['NewsType'] = self.news_type
        if self.news_types is not None:
            result['NewsTypes'] = self.news_types
        if self.size is not None:
            result['Size'] = self.size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentKey') is not None:
            self.agent_key = m.get('AgentKey')
        if m.get('Current') is not None:
            self.current = m.get('Current')
        if m.get('NewsType') is not None:
            self.news_type = m.get('NewsType')
        if m.get('NewsTypes') is not None:
            self.news_types = m.get('NewsTypes')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        return self


class ListHotNewsWithTypeShrinkRequest(TeaModel):
    def __init__(
        self,
        agent_key: str = None,
        current: int = None,
        news_type: str = None,
        news_types_shrink: str = None,
        size: int = None,
    ):
        # This parameter is required.
        self.agent_key = agent_key
        self.current = current
        self.news_type = news_type
        self.news_types_shrink = news_types_shrink
        self.size = size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_key is not None:
            result['AgentKey'] = self.agent_key
        if self.current is not None:
            result['Current'] = self.current
        if self.news_type is not None:
            result['NewsType'] = self.news_type
        if self.news_types_shrink is not None:
            result['NewsTypes'] = self.news_types_shrink
        if self.size is not None:
            result['Size'] = self.size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentKey') is not None:
            self.agent_key = m.get('AgentKey')
        if m.get('Current') is not None:
            self.current = m.get('Current')
        if m.get('NewsType') is not None:
            self.news_type = m.get('NewsType')
        if m.get('NewsTypes') is not None:
            self.news_types_shrink = m.get('NewsTypes')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        return self


class ListHotNewsWithTypeResponseBodyDataNews(TeaModel):
    def __init__(
        self,
        author: str = None,
        content: str = None,
        doc_uuid: str = None,
        image_urls: List[str] = None,
        pub_time: str = None,
        search_source: str = None,
        search_source_name: str = None,
        source: str = None,
        summary: str = None,
        tag: str = None,
        title: str = None,
        update_time: str = None,
        url: str = None,
    ):
        self.author = author
        self.content = content
        self.doc_uuid = doc_uuid
        self.image_urls = image_urls
        self.pub_time = pub_time
        self.search_source = search_source
        self.search_source_name = search_source_name
        self.source = source
        self.summary = summary
        self.tag = tag
        self.title = title
        self.update_time = update_time
        self.url = url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.author is not None:
            result['Author'] = self.author
        if self.content is not None:
            result['Content'] = self.content
        if self.doc_uuid is not None:
            result['DocUuid'] = self.doc_uuid
        if self.image_urls is not None:
            result['ImageUrls'] = self.image_urls
        if self.pub_time is not None:
            result['PubTime'] = self.pub_time
        if self.search_source is not None:
            result['SearchSource'] = self.search_source
        if self.search_source_name is not None:
            result['SearchSourceName'] = self.search_source_name
        if self.source is not None:
            result['Source'] = self.source
        if self.summary is not None:
            result['Summary'] = self.summary
        if self.tag is not None:
            result['Tag'] = self.tag
        if self.title is not None:
            result['Title'] = self.title
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        if self.url is not None:
            result['Url'] = self.url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Author') is not None:
            self.author = m.get('Author')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('DocUuid') is not None:
            self.doc_uuid = m.get('DocUuid')
        if m.get('ImageUrls') is not None:
            self.image_urls = m.get('ImageUrls')
        if m.get('PubTime') is not None:
            self.pub_time = m.get('PubTime')
        if m.get('SearchSource') is not None:
            self.search_source = m.get('SearchSource')
        if m.get('SearchSourceName') is not None:
            self.search_source_name = m.get('SearchSourceName')
        if m.get('Source') is not None:
            self.source = m.get('Source')
        if m.get('Summary') is not None:
            self.summary = m.get('Summary')
        if m.get('Tag') is not None:
            self.tag = m.get('Tag')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        return self


class ListHotNewsWithTypeResponseBodyData(TeaModel):
    def __init__(
        self,
        news: List[ListHotNewsWithTypeResponseBodyDataNews] = None,
        news_type: str = None,
        news_type_name: str = None,
        total_pages: int = None,
    ):
        self.news = news
        self.news_type = news_type
        self.news_type_name = news_type_name
        self.total_pages = total_pages

    def validate(self):
        if self.news:
            for k in self.news:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['News'] = []
        if self.news is not None:
            for k in self.news:
                result['News'].append(k.to_map() if k else None)
        if self.news_type is not None:
            result['NewsType'] = self.news_type
        if self.news_type_name is not None:
            result['NewsTypeName'] = self.news_type_name
        if self.total_pages is not None:
            result['TotalPages'] = self.total_pages
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.news = []
        if m.get('News') is not None:
            for k in m.get('News'):
                temp_model = ListHotNewsWithTypeResponseBodyDataNews()
                self.news.append(temp_model.from_map(k))
        if m.get('NewsType') is not None:
            self.news_type = m.get('NewsType')
        if m.get('NewsTypeName') is not None:
            self.news_type_name = m.get('NewsTypeName')
        if m.get('TotalPages') is not None:
            self.total_pages = m.get('TotalPages')
        return self


class ListHotNewsWithTypeResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: List[ListHotNewsWithTypeResponseBodyData] = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ListHotNewsWithTypeResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ListHotNewsWithTypeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListHotNewsWithTypeResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListHotNewsWithTypeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListHotSourcesRequest(TeaModel):
    def __init__(
        self,
        agent_key: str = None,
        max_results: int = None,
        next_token: str = None,
    ):
        # This parameter is required.
        self.agent_key = agent_key
        self.max_results = max_results
        self.next_token = next_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_key is not None:
            result['AgentKey'] = self.agent_key
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentKey') is not None:
            self.agent_key = m.get('AgentKey')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        return self


class ListHotSourcesResponseBodyData(TeaModel):
    def __init__(
        self,
        description: str = None,
        show: bool = None,
        sort: int = None,
        source: str = None,
    ):
        self.description = description
        self.show = show
        self.sort = sort
        self.source = source

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.show is not None:
            result['Show'] = self.show
        if self.sort is not None:
            result['Sort'] = self.sort
        if self.source is not None:
            result['Source'] = self.source
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Show') is not None:
            self.show = m.get('Show')
        if m.get('Sort') is not None:
            self.sort = m.get('Sort')
        if m.get('Source') is not None:
            self.source = m.get('Source')
        return self


class ListHotSourcesResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: List[ListHotSourcesResponseBodyData] = None,
        http_status_code: int = None,
        max_results: int = None,
        message: str = None,
        next_token: str = None,
        request_id: str = None,
        success: bool = None,
        total_count: int = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.max_results = max_results
        self.message = message
        self.next_token = next_token
        self.request_id = request_id
        self.success = success
        self.total_count = total_count

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.message is not None:
            result['Message'] = self.message
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ListHotSourcesResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListHotSourcesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListHotSourcesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListHotSourcesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListHotTopicsRequest(TeaModel):
    def __init__(
        self,
        agent_key: str = None,
        max_results: int = None,
        next_token: str = None,
        topic_ids: List[str] = None,
        topic_query: str = None,
        topic_source: str = None,
        topic_version: str = None,
        topics: List[str] = None,
        with_news: bool = None,
    ):
        # This parameter is required.
        self.agent_key = agent_key
        self.max_results = max_results
        self.next_token = next_token
        self.topic_ids = topic_ids
        self.topic_query = topic_query
        self.topic_source = topic_source
        self.topic_version = topic_version
        self.topics = topics
        self.with_news = with_news

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_key is not None:
            result['AgentKey'] = self.agent_key
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.topic_ids is not None:
            result['TopicIds'] = self.topic_ids
        if self.topic_query is not None:
            result['TopicQuery'] = self.topic_query
        if self.topic_source is not None:
            result['TopicSource'] = self.topic_source
        if self.topic_version is not None:
            result['TopicVersion'] = self.topic_version
        if self.topics is not None:
            result['Topics'] = self.topics
        if self.with_news is not None:
            result['WithNews'] = self.with_news
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentKey') is not None:
            self.agent_key = m.get('AgentKey')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('TopicIds') is not None:
            self.topic_ids = m.get('TopicIds')
        if m.get('TopicQuery') is not None:
            self.topic_query = m.get('TopicQuery')
        if m.get('TopicSource') is not None:
            self.topic_source = m.get('TopicSource')
        if m.get('TopicVersion') is not None:
            self.topic_version = m.get('TopicVersion')
        if m.get('Topics') is not None:
            self.topics = m.get('Topics')
        if m.get('WithNews') is not None:
            self.with_news = m.get('WithNews')
        return self


class ListHotTopicsShrinkRequest(TeaModel):
    def __init__(
        self,
        agent_key: str = None,
        max_results: int = None,
        next_token: str = None,
        topic_ids_shrink: str = None,
        topic_query: str = None,
        topic_source: str = None,
        topic_version: str = None,
        topics_shrink: str = None,
        with_news: bool = None,
    ):
        # This parameter is required.
        self.agent_key = agent_key
        self.max_results = max_results
        self.next_token = next_token
        self.topic_ids_shrink = topic_ids_shrink
        self.topic_query = topic_query
        self.topic_source = topic_source
        self.topic_version = topic_version
        self.topics_shrink = topics_shrink
        self.with_news = with_news

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_key is not None:
            result['AgentKey'] = self.agent_key
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.topic_ids_shrink is not None:
            result['TopicIds'] = self.topic_ids_shrink
        if self.topic_query is not None:
            result['TopicQuery'] = self.topic_query
        if self.topic_source is not None:
            result['TopicSource'] = self.topic_source
        if self.topic_version is not None:
            result['TopicVersion'] = self.topic_version
        if self.topics_shrink is not None:
            result['Topics'] = self.topics_shrink
        if self.with_news is not None:
            result['WithNews'] = self.with_news
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentKey') is not None:
            self.agent_key = m.get('AgentKey')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('TopicIds') is not None:
            self.topic_ids_shrink = m.get('TopicIds')
        if m.get('TopicQuery') is not None:
            self.topic_query = m.get('TopicQuery')
        if m.get('TopicSource') is not None:
            self.topic_source = m.get('TopicSource')
        if m.get('TopicVersion') is not None:
            self.topic_version = m.get('TopicVersion')
        if m.get('Topics') is not None:
            self.topics_shrink = m.get('Topics')
        if m.get('WithNews') is not None:
            self.with_news = m.get('WithNews')
        return self


class ListHotTopicsResponseBodyDataStructureSummaryDocList(TeaModel):
    def __init__(
        self,
        source: str = None,
        title: str = None,
        url: str = None,
    ):
        self.source = source
        self.title = title
        self.url = url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source is not None:
            result['Source'] = self.source
        if self.title is not None:
            result['Title'] = self.title
        if self.url is not None:
            result['Url'] = self.url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Source') is not None:
            self.source = m.get('Source')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        return self


class ListHotTopicsResponseBodyDataStructureSummary(TeaModel):
    def __init__(
        self,
        doc_list: List[ListHotTopicsResponseBodyDataStructureSummaryDocList] = None,
        summary: str = None,
        title: str = None,
    ):
        self.doc_list = doc_list
        self.summary = summary
        self.title = title

    def validate(self):
        if self.doc_list:
            for k in self.doc_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DocList'] = []
        if self.doc_list is not None:
            for k in self.doc_list:
                result['DocList'].append(k.to_map() if k else None)
        if self.summary is not None:
            result['Summary'] = self.summary
        if self.title is not None:
            result['Title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.doc_list = []
        if m.get('DocList') is not None:
            for k in m.get('DocList'):
                temp_model = ListHotTopicsResponseBodyDataStructureSummaryDocList()
                self.doc_list.append(temp_model.from_map(k))
        if m.get('Summary') is not None:
            self.summary = m.get('Summary')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        return self


class ListHotTopicsResponseBodyData(TeaModel):
    def __init__(
        self,
        async_task_id: str = None,
        create_user: str = None,
        hot_value: int = None,
        id: str = None,
        status: str = None,
        structure_summary: List[ListHotTopicsResponseBodyDataStructureSummary] = None,
        summary: str = None,
        task_error_message: str = None,
        task_status: int = None,
        topic: str = None,
        topic_source: str = None,
        version: str = None,
    ):
        self.async_task_id = async_task_id
        self.create_user = create_user
        self.hot_value = hot_value
        self.id = id
        self.status = status
        self.structure_summary = structure_summary
        self.summary = summary
        self.task_error_message = task_error_message
        self.task_status = task_status
        self.topic = topic
        self.topic_source = topic_source
        self.version = version

    def validate(self):
        if self.structure_summary:
            for k in self.structure_summary:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.async_task_id is not None:
            result['AsyncTaskId'] = self.async_task_id
        if self.create_user is not None:
            result['CreateUser'] = self.create_user
        if self.hot_value is not None:
            result['HotValue'] = self.hot_value
        if self.id is not None:
            result['Id'] = self.id
        if self.status is not None:
            result['Status'] = self.status
        result['StructureSummary'] = []
        if self.structure_summary is not None:
            for k in self.structure_summary:
                result['StructureSummary'].append(k.to_map() if k else None)
        if self.summary is not None:
            result['Summary'] = self.summary
        if self.task_error_message is not None:
            result['TaskErrorMessage'] = self.task_error_message
        if self.task_status is not None:
            result['TaskStatus'] = self.task_status
        if self.topic is not None:
            result['Topic'] = self.topic
        if self.topic_source is not None:
            result['TopicSource'] = self.topic_source
        if self.version is not None:
            result['Version'] = self.version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AsyncTaskId') is not None:
            self.async_task_id = m.get('AsyncTaskId')
        if m.get('CreateUser') is not None:
            self.create_user = m.get('CreateUser')
        if m.get('HotValue') is not None:
            self.hot_value = m.get('HotValue')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        self.structure_summary = []
        if m.get('StructureSummary') is not None:
            for k in m.get('StructureSummary'):
                temp_model = ListHotTopicsResponseBodyDataStructureSummary()
                self.structure_summary.append(temp_model.from_map(k))
        if m.get('Summary') is not None:
            self.summary = m.get('Summary')
        if m.get('TaskErrorMessage') is not None:
            self.task_error_message = m.get('TaskErrorMessage')
        if m.get('TaskStatus') is not None:
            self.task_status = m.get('TaskStatus')
        if m.get('Topic') is not None:
            self.topic = m.get('Topic')
        if m.get('TopicSource') is not None:
            self.topic_source = m.get('TopicSource')
        if m.get('Version') is not None:
            self.version = m.get('Version')
        return self


class ListHotTopicsResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: List[ListHotTopicsResponseBodyData] = None,
        http_status_code: int = None,
        max_results: int = None,
        message: str = None,
        next_token: str = None,
        request_id: str = None,
        success: bool = None,
        total_count: int = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.max_results = max_results
        self.message = message
        self.next_token = next_token
        self.request_id = request_id
        self.success = success
        self.total_count = total_count

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.message is not None:
            result['Message'] = self.message
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ListHotTopicsResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListHotTopicsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListHotTopicsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListHotTopicsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListHotViewPointsRequest(TeaModel):
    def __init__(
        self,
        agent_key: str = None,
        max_results: int = None,
        next_token: str = None,
        topic: str = None,
        topic_source: str = None,
    ):
        # This parameter is required.
        self.agent_key = agent_key
        self.max_results = max_results
        self.next_token = next_token
        # This parameter is required.
        self.topic = topic
        # This parameter is required.
        self.topic_source = topic_source

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_key is not None:
            result['AgentKey'] = self.agent_key
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.topic is not None:
            result['Topic'] = self.topic
        if self.topic_source is not None:
            result['TopicSource'] = self.topic_source
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentKey') is not None:
            self.agent_key = m.get('AgentKey')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('Topic') is not None:
            self.topic = m.get('Topic')
        if m.get('TopicSource') is not None:
            self.topic_source = m.get('TopicSource')
        return self


class ListHotViewPointsResponseBodyDataNews(TeaModel):
    def __init__(
        self,
        author: str = None,
        content: str = None,
        doc_id: str = None,
        doc_uuid: str = None,
        image_urls: List[str] = None,
        pub_time: str = None,
        source: str = None,
        summary: str = None,
        tags: List[str] = None,
        title: str = None,
        topic: str = None,
        url: str = None,
    ):
        self.author = author
        self.content = content
        self.doc_id = doc_id
        self.doc_uuid = doc_uuid
        self.image_urls = image_urls
        self.pub_time = pub_time
        self.source = source
        self.summary = summary
        self.tags = tags
        self.title = title
        self.topic = topic
        self.url = url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.author is not None:
            result['Author'] = self.author
        if self.content is not None:
            result['Content'] = self.content
        if self.doc_id is not None:
            result['DocId'] = self.doc_id
        if self.doc_uuid is not None:
            result['DocUuid'] = self.doc_uuid
        if self.image_urls is not None:
            result['ImageUrls'] = self.image_urls
        if self.pub_time is not None:
            result['PubTime'] = self.pub_time
        if self.source is not None:
            result['Source'] = self.source
        if self.summary is not None:
            result['Summary'] = self.summary
        if self.tags is not None:
            result['Tags'] = self.tags
        if self.title is not None:
            result['Title'] = self.title
        if self.topic is not None:
            result['Topic'] = self.topic
        if self.url is not None:
            result['Url'] = self.url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Author') is not None:
            self.author = m.get('Author')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('DocId') is not None:
            self.doc_id = m.get('DocId')
        if m.get('DocUuid') is not None:
            self.doc_uuid = m.get('DocUuid')
        if m.get('ImageUrls') is not None:
            self.image_urls = m.get('ImageUrls')
        if m.get('PubTime') is not None:
            self.pub_time = m.get('PubTime')
        if m.get('Source') is not None:
            self.source = m.get('Source')
        if m.get('Summary') is not None:
            self.summary = m.get('Summary')
        if m.get('Tags') is not None:
            self.tags = m.get('Tags')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        if m.get('Topic') is not None:
            self.topic = m.get('Topic')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        return self


class ListHotViewPointsResponseBodyDataViewPointsOutlines(TeaModel):
    def __init__(
        self,
        outline: str = None,
        summary: str = None,
    ):
        self.outline = outline
        self.summary = summary

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.outline is not None:
            result['Outline'] = self.outline
        if self.summary is not None:
            result['Summary'] = self.summary
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Outline') is not None:
            self.outline = m.get('Outline')
        if m.get('Summary') is not None:
            self.summary = m.get('Summary')
        return self


class ListHotViewPointsResponseBodyDataViewPoints(TeaModel):
    def __init__(
        self,
        outlines: List[ListHotViewPointsResponseBodyDataViewPointsOutlines] = None,
        point: str = None,
        summary: str = None,
    ):
        self.outlines = outlines
        self.point = point
        self.summary = summary

    def validate(self):
        if self.outlines:
            for k in self.outlines:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Outlines'] = []
        if self.outlines is not None:
            for k in self.outlines:
                result['Outlines'].append(k.to_map() if k else None)
        if self.point is not None:
            result['Point'] = self.point
        if self.summary is not None:
            result['Summary'] = self.summary
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.outlines = []
        if m.get('Outlines') is not None:
            for k in m.get('Outlines'):
                temp_model = ListHotViewPointsResponseBodyDataViewPointsOutlines()
                self.outlines.append(temp_model.from_map(k))
        if m.get('Point') is not None:
            self.point = m.get('Point')
        if m.get('Summary') is not None:
            self.summary = m.get('Summary')
        return self


class ListHotViewPointsResponseBodyData(TeaModel):
    def __init__(
        self,
        attitude: str = None,
        attitude_type: str = None,
        news: List[ListHotViewPointsResponseBodyDataNews] = None,
        ratio: str = None,
        view_points: List[ListHotViewPointsResponseBodyDataViewPoints] = None,
    ):
        self.attitude = attitude
        self.attitude_type = attitude_type
        self.news = news
        self.ratio = ratio
        self.view_points = view_points

    def validate(self):
        if self.news:
            for k in self.news:
                if k:
                    k.validate()
        if self.view_points:
            for k in self.view_points:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.attitude is not None:
            result['Attitude'] = self.attitude
        if self.attitude_type is not None:
            result['AttitudeType'] = self.attitude_type
        result['News'] = []
        if self.news is not None:
            for k in self.news:
                result['News'].append(k.to_map() if k else None)
        if self.ratio is not None:
            result['Ratio'] = self.ratio
        result['ViewPoints'] = []
        if self.view_points is not None:
            for k in self.view_points:
                result['ViewPoints'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Attitude') is not None:
            self.attitude = m.get('Attitude')
        if m.get('AttitudeType') is not None:
            self.attitude_type = m.get('AttitudeType')
        self.news = []
        if m.get('News') is not None:
            for k in m.get('News'):
                temp_model = ListHotViewPointsResponseBodyDataNews()
                self.news.append(temp_model.from_map(k))
        if m.get('Ratio') is not None:
            self.ratio = m.get('Ratio')
        self.view_points = []
        if m.get('ViewPoints') is not None:
            for k in m.get('ViewPoints'):
                temp_model = ListHotViewPointsResponseBodyDataViewPoints()
                self.view_points.append(temp_model.from_map(k))
        return self


class ListHotViewPointsResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: List[ListHotViewPointsResponseBodyData] = None,
        http_status_code: int = None,
        max_results: int = None,
        message: str = None,
        next_token: str = None,
        request_id: str = None,
        success: bool = None,
        total_count: int = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.max_results = max_results
        self.message = message
        self.next_token = next_token
        self.request_id = request_id
        self.success = success
        self.total_count = total_count

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.message is not None:
            result['Message'] = self.message
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ListHotViewPointsResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListHotViewPointsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListHotViewPointsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListHotViewPointsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListInterveneCntRequest(TeaModel):
    def __init__(
        self,
        agent_key: str = None,
        page_index: int = None,
        page_size: int = None,
    ):
        # This parameter is required.
        self.agent_key = agent_key
        self.page_index = page_index
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_key is not None:
            result['AgentKey'] = self.agent_key
        if self.page_index is not None:
            result['PageIndex'] = self.page_index
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentKey') is not None:
            self.agent_key = m.get('AgentKey')
        if m.get('PageIndex') is not None:
            self.page_index = m.get('PageIndex')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class ListInterveneCntResponseBodyData(TeaModel):
    def __init__(
        self,
        cnt_list: List[Any] = None,
        code: int = None,
        page_cnt: int = None,
        page_index: int = None,
        page_size: int = None,
    ):
        self.cnt_list = cnt_list
        self.code = code
        self.page_cnt = page_cnt
        self.page_index = page_index
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cnt_list is not None:
            result['CntList'] = self.cnt_list
        if self.code is not None:
            result['Code'] = self.code
        if self.page_cnt is not None:
            result['PageCnt'] = self.page_cnt
        if self.page_index is not None:
            result['PageIndex'] = self.page_index
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CntList') is not None:
            self.cnt_list = m.get('CntList')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('PageCnt') is not None:
            self.page_cnt = m.get('PageCnt')
        if m.get('PageIndex') is not None:
            self.page_index = m.get('PageIndex')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class ListInterveneCntResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: ListInterveneCntResponseBodyData = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = ListInterveneCntResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ListInterveneCntResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListInterveneCntResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListInterveneCntResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListInterveneImportTasksRequest(TeaModel):
    def __init__(
        self,
        agent_key: str = None,
        page_index: int = None,
        page_size: int = None,
    ):
        # This parameter is required.
        self.agent_key = agent_key
        self.page_index = page_index
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_key is not None:
            result['AgentKey'] = self.agent_key
        if self.page_index is not None:
            result['PageIndex'] = self.page_index
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentKey') is not None:
            self.agent_key = m.get('AgentKey')
        if m.get('PageIndex') is not None:
            self.page_index = m.get('PageIndex')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class ListInterveneImportTasksResponseBodyDataStatusList(TeaModel):
    def __init__(
        self,
        msg: str = None,
        percentage: int = None,
        status: int = None,
        task_id: str = None,
        task_name: str = None,
    ):
        self.msg = msg
        self.percentage = percentage
        self.status = status
        self.task_id = task_id
        self.task_name = task_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.msg is not None:
            result['Msg'] = self.msg
        if self.percentage is not None:
            result['Percentage'] = self.percentage
        if self.status is not None:
            result['Status'] = self.status
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Msg') is not None:
            self.msg = m.get('Msg')
        if m.get('Percentage') is not None:
            self.percentage = m.get('Percentage')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        return self


class ListInterveneImportTasksResponseBodyData(TeaModel):
    def __init__(
        self,
        code: int = None,
        page_index: int = None,
        page_size: int = None,
        status_list: List[ListInterveneImportTasksResponseBodyDataStatusList] = None,
        total_size: int = None,
    ):
        self.code = code
        self.page_index = page_index
        self.page_size = page_size
        self.status_list = status_list
        self.total_size = total_size

    def validate(self):
        if self.status_list:
            for k in self.status_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.page_index is not None:
            result['PageIndex'] = self.page_index
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        result['StatusList'] = []
        if self.status_list is not None:
            for k in self.status_list:
                result['StatusList'].append(k.to_map() if k else None)
        if self.total_size is not None:
            result['TotalSize'] = self.total_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('PageIndex') is not None:
            self.page_index = m.get('PageIndex')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        self.status_list = []
        if m.get('StatusList') is not None:
            for k in m.get('StatusList'):
                temp_model = ListInterveneImportTasksResponseBodyDataStatusList()
                self.status_list.append(temp_model.from_map(k))
        if m.get('TotalSize') is not None:
            self.total_size = m.get('TotalSize')
        return self


class ListInterveneImportTasksResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: ListInterveneImportTasksResponseBodyData = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = ListInterveneImportTasksResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ListInterveneImportTasksResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListInterveneImportTasksResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListInterveneImportTasksResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListInterveneRulesRequest(TeaModel):
    def __init__(
        self,
        agent_key: str = None,
        page_index: int = None,
        page_size: int = None,
    ):
        # This parameter is required.
        self.agent_key = agent_key
        self.page_index = page_index
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_key is not None:
            result['AgentKey'] = self.agent_key
        if self.page_index is not None:
            result['PageIndex'] = self.page_index
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentKey') is not None:
            self.agent_key = m.get('AgentKey')
        if m.get('PageIndex') is not None:
            self.page_index = m.get('PageIndex')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class ListInterveneRulesResponseBodyDataInterveneRuleListAnswerConfig(TeaModel):
    def __init__(
        self,
        answer_type: int = None,
        message: str = None,
        namespace: str = None,
    ):
        self.answer_type = answer_type
        self.message = message
        self.namespace = namespace

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.answer_type is not None:
            result['AnswerType'] = self.answer_type
        if self.message is not None:
            result['Message'] = self.message
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AnswerType') is not None:
            self.answer_type = m.get('AnswerType')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        return self


class ListInterveneRulesResponseBodyDataInterveneRuleList(TeaModel):
    def __init__(
        self,
        answer_config: List[ListInterveneRulesResponseBodyDataInterveneRuleListAnswerConfig] = None,
        create_time: str = None,
        effect_time: str = None,
        intervene_type: int = None,
        namespace_list: List[str] = None,
        rule_id: int = None,
        rule_name: str = None,
    ):
        self.answer_config = answer_config
        self.create_time = create_time
        self.effect_time = effect_time
        self.intervene_type = intervene_type
        self.namespace_list = namespace_list
        self.rule_id = rule_id
        self.rule_name = rule_name

    def validate(self):
        if self.answer_config:
            for k in self.answer_config:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AnswerConfig'] = []
        if self.answer_config is not None:
            for k in self.answer_config:
                result['AnswerConfig'].append(k.to_map() if k else None)
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.effect_time is not None:
            result['EffectTime'] = self.effect_time
        if self.intervene_type is not None:
            result['InterveneType'] = self.intervene_type
        if self.namespace_list is not None:
            result['NamespaceList'] = self.namespace_list
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.answer_config = []
        if m.get('AnswerConfig') is not None:
            for k in m.get('AnswerConfig'):
                temp_model = ListInterveneRulesResponseBodyDataInterveneRuleListAnswerConfig()
                self.answer_config.append(temp_model.from_map(k))
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('EffectTime') is not None:
            self.effect_time = m.get('EffectTime')
        if m.get('InterveneType') is not None:
            self.intervene_type = m.get('InterveneType')
        if m.get('NamespaceList') is not None:
            self.namespace_list = m.get('NamespaceList')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        return self


class ListInterveneRulesResponseBodyData(TeaModel):
    def __init__(
        self,
        code: int = None,
        count: int = None,
        intervene_rule_list: List[ListInterveneRulesResponseBodyDataInterveneRuleList] = None,
        page_index: int = None,
        page_size: int = None,
    ):
        self.code = code
        self.count = count
        self.intervene_rule_list = intervene_rule_list
        self.page_index = page_index
        self.page_size = page_size

    def validate(self):
        if self.intervene_rule_list:
            for k in self.intervene_rule_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.count is not None:
            result['Count'] = self.count
        result['InterveneRuleList'] = []
        if self.intervene_rule_list is not None:
            for k in self.intervene_rule_list:
                result['InterveneRuleList'].append(k.to_map() if k else None)
        if self.page_index is not None:
            result['PageIndex'] = self.page_index
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        self.intervene_rule_list = []
        if m.get('InterveneRuleList') is not None:
            for k in m.get('InterveneRuleList'):
                temp_model = ListInterveneRulesResponseBodyDataInterveneRuleList()
                self.intervene_rule_list.append(temp_model.from_map(k))
        if m.get('PageIndex') is not None:
            self.page_index = m.get('PageIndex')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class ListInterveneRulesResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: ListInterveneRulesResponseBodyData = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = ListInterveneRulesResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ListInterveneRulesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListInterveneRulesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListInterveneRulesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListIntervenesRequest(TeaModel):
    def __init__(
        self,
        agent_key: str = None,
        intervene_type: int = None,
        page_index: int = None,
        page_size: int = None,
        query: str = None,
        rule_id: int = None,
    ):
        # This parameter is required.
        self.agent_key = agent_key
        self.intervene_type = intervene_type
        self.page_index = page_index
        self.page_size = page_size
        self.query = query
        self.rule_id = rule_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_key is not None:
            result['AgentKey'] = self.agent_key
        if self.intervene_type is not None:
            result['InterveneType'] = self.intervene_type
        if self.page_index is not None:
            result['PageIndex'] = self.page_index
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.query is not None:
            result['Query'] = self.query
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentKey') is not None:
            self.agent_key = m.get('AgentKey')
        if m.get('InterveneType') is not None:
            self.intervene_type = m.get('InterveneType')
        if m.get('PageIndex') is not None:
            self.page_index = m.get('PageIndex')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Query') is not None:
            self.query = m.get('Query')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class ListIntervenesResponseBodyDataInterveneList(TeaModel):
    def __init__(
        self,
        id: str = None,
        query: str = None,
    ):
        # id
        self.id = id
        self.query = query

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.query is not None:
            result['Query'] = self.query
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Query') is not None:
            self.query = m.get('Query')
        return self


class ListIntervenesResponseBodyData(TeaModel):
    def __init__(
        self,
        code: int = None,
        intervene_list: List[ListIntervenesResponseBodyDataInterveneList] = None,
        page_index: int = None,
        page_size: int = None,
        total_size: int = None,
    ):
        self.code = code
        self.intervene_list = intervene_list
        self.page_index = page_index
        self.page_size = page_size
        self.total_size = total_size

    def validate(self):
        if self.intervene_list:
            for k in self.intervene_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['InterveneList'] = []
        if self.intervene_list is not None:
            for k in self.intervene_list:
                result['InterveneList'].append(k.to_map() if k else None)
        if self.page_index is not None:
            result['PageIndex'] = self.page_index
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_size is not None:
            result['TotalSize'] = self.total_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.intervene_list = []
        if m.get('InterveneList') is not None:
            for k in m.get('InterveneList'):
                temp_model = ListIntervenesResponseBodyDataInterveneList()
                self.intervene_list.append(temp_model.from_map(k))
        if m.get('PageIndex') is not None:
            self.page_index = m.get('PageIndex')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalSize') is not None:
            self.total_size = m.get('TotalSize')
        return self


class ListIntervenesResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: ListIntervenesResponseBodyData = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = ListIntervenesResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ListIntervenesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListIntervenesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListIntervenesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListMaterialDocumentsRequest(TeaModel):
    def __init__(
        self,
        agent_key: str = None,
        content: str = None,
        create_time_end: str = None,
        create_time_start: str = None,
        current: int = None,
        doc_type: str = None,
        doc_type_list: List[str] = None,
        generate_public_url: bool = None,
        id: int = None,
        keywords: List[str] = None,
        query: str = None,
        share_attr: int = None,
        size: int = None,
        title: str = None,
        update_time_end: str = None,
        update_time_start: str = None,
    ):
        # This parameter is required.
        self.agent_key = agent_key
        self.content = content
        self.create_time_end = create_time_end
        self.create_time_start = create_time_start
        self.current = current
        self.doc_type = doc_type
        self.doc_type_list = doc_type_list
        self.generate_public_url = generate_public_url
        self.id = id
        self.keywords = keywords
        self.query = query
        self.share_attr = share_attr
        self.size = size
        self.title = title
        self.update_time_end = update_time_end
        self.update_time_start = update_time_start

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_key is not None:
            result['AgentKey'] = self.agent_key
        if self.content is not None:
            result['Content'] = self.content
        if self.create_time_end is not None:
            result['CreateTimeEnd'] = self.create_time_end
        if self.create_time_start is not None:
            result['CreateTimeStart'] = self.create_time_start
        if self.current is not None:
            result['Current'] = self.current
        if self.doc_type is not None:
            result['DocType'] = self.doc_type
        if self.doc_type_list is not None:
            result['DocTypeList'] = self.doc_type_list
        if self.generate_public_url is not None:
            result['GeneratePublicUrl'] = self.generate_public_url
        if self.id is not None:
            result['Id'] = self.id
        if self.keywords is not None:
            result['Keywords'] = self.keywords
        if self.query is not None:
            result['Query'] = self.query
        if self.share_attr is not None:
            result['ShareAttr'] = self.share_attr
        if self.size is not None:
            result['Size'] = self.size
        if self.title is not None:
            result['Title'] = self.title
        if self.update_time_end is not None:
            result['UpdateTimeEnd'] = self.update_time_end
        if self.update_time_start is not None:
            result['UpdateTimeStart'] = self.update_time_start
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentKey') is not None:
            self.agent_key = m.get('AgentKey')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('CreateTimeEnd') is not None:
            self.create_time_end = m.get('CreateTimeEnd')
        if m.get('CreateTimeStart') is not None:
            self.create_time_start = m.get('CreateTimeStart')
        if m.get('Current') is not None:
            self.current = m.get('Current')
        if m.get('DocType') is not None:
            self.doc_type = m.get('DocType')
        if m.get('DocTypeList') is not None:
            self.doc_type_list = m.get('DocTypeList')
        if m.get('GeneratePublicUrl') is not None:
            self.generate_public_url = m.get('GeneratePublicUrl')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Keywords') is not None:
            self.keywords = m.get('Keywords')
        if m.get('Query') is not None:
            self.query = m.get('Query')
        if m.get('ShareAttr') is not None:
            self.share_attr = m.get('ShareAttr')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        if m.get('UpdateTimeEnd') is not None:
            self.update_time_end = m.get('UpdateTimeEnd')
        if m.get('UpdateTimeStart') is not None:
            self.update_time_start = m.get('UpdateTimeStart')
        return self


class ListMaterialDocumentsShrinkRequest(TeaModel):
    def __init__(
        self,
        agent_key: str = None,
        content: str = None,
        create_time_end: str = None,
        create_time_start: str = None,
        current: int = None,
        doc_type: str = None,
        doc_type_list_shrink: str = None,
        generate_public_url: bool = None,
        id: int = None,
        keywords_shrink: str = None,
        query: str = None,
        share_attr: int = None,
        size: int = None,
        title: str = None,
        update_time_end: str = None,
        update_time_start: str = None,
    ):
        # This parameter is required.
        self.agent_key = agent_key
        self.content = content
        self.create_time_end = create_time_end
        self.create_time_start = create_time_start
        self.current = current
        self.doc_type = doc_type
        self.doc_type_list_shrink = doc_type_list_shrink
        self.generate_public_url = generate_public_url
        self.id = id
        self.keywords_shrink = keywords_shrink
        self.query = query
        self.share_attr = share_attr
        self.size = size
        self.title = title
        self.update_time_end = update_time_end
        self.update_time_start = update_time_start

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_key is not None:
            result['AgentKey'] = self.agent_key
        if self.content is not None:
            result['Content'] = self.content
        if self.create_time_end is not None:
            result['CreateTimeEnd'] = self.create_time_end
        if self.create_time_start is not None:
            result['CreateTimeStart'] = self.create_time_start
        if self.current is not None:
            result['Current'] = self.current
        if self.doc_type is not None:
            result['DocType'] = self.doc_type
        if self.doc_type_list_shrink is not None:
            result['DocTypeList'] = self.doc_type_list_shrink
        if self.generate_public_url is not None:
            result['GeneratePublicUrl'] = self.generate_public_url
        if self.id is not None:
            result['Id'] = self.id
        if self.keywords_shrink is not None:
            result['Keywords'] = self.keywords_shrink
        if self.query is not None:
            result['Query'] = self.query
        if self.share_attr is not None:
            result['ShareAttr'] = self.share_attr
        if self.size is not None:
            result['Size'] = self.size
        if self.title is not None:
            result['Title'] = self.title
        if self.update_time_end is not None:
            result['UpdateTimeEnd'] = self.update_time_end
        if self.update_time_start is not None:
            result['UpdateTimeStart'] = self.update_time_start
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentKey') is not None:
            self.agent_key = m.get('AgentKey')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('CreateTimeEnd') is not None:
            self.create_time_end = m.get('CreateTimeEnd')
        if m.get('CreateTimeStart') is not None:
            self.create_time_start = m.get('CreateTimeStart')
        if m.get('Current') is not None:
            self.current = m.get('Current')
        if m.get('DocType') is not None:
            self.doc_type = m.get('DocType')
        if m.get('DocTypeList') is not None:
            self.doc_type_list_shrink = m.get('DocTypeList')
        if m.get('GeneratePublicUrl') is not None:
            self.generate_public_url = m.get('GeneratePublicUrl')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Keywords') is not None:
            self.keywords_shrink = m.get('Keywords')
        if m.get('Query') is not None:
            self.query = m.get('Query')
        if m.get('ShareAttr') is not None:
            self.share_attr = m.get('ShareAttr')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        if m.get('UpdateTimeEnd') is not None:
            self.update_time_end = m.get('UpdateTimeEnd')
        if m.get('UpdateTimeStart') is not None:
            self.update_time_start = m.get('UpdateTimeStart')
        return self


class ListMaterialDocumentsResponseBodyDataFileAttr(TeaModel):
    def __init__(
        self,
        duration: float = None,
        file_length: int = None,
        file_name: str = None,
        height: int = None,
        mime_type: str = None,
        width: int = None,
    ):
        self.duration = duration
        self.file_length = file_length
        self.file_name = file_name
        self.height = height
        self.mime_type = mime_type
        self.width = width

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.file_length is not None:
            result['FileLength'] = self.file_length
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.height is not None:
            result['Height'] = self.height
        if self.mime_type is not None:
            result['MimeType'] = self.mime_type
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('FileLength') is not None:
            self.file_length = m.get('FileLength')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('MimeType') is not None:
            self.mime_type = m.get('MimeType')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class ListMaterialDocumentsResponseBodyData(TeaModel):
    def __init__(
        self,
        author: str = None,
        create_time: str = None,
        create_user: str = None,
        create_user_name: str = None,
        doc_keywords: List[str] = None,
        doc_type: str = None,
        external_url: str = None,
        file_attr: ListMaterialDocumentsResponseBodyDataFileAttr = None,
        file_key: str = None,
        html_content: str = None,
        id: int = None,
        pub_time: str = None,
        public_url: str = None,
        share_attr: int = None,
        src_from: str = None,
        summary: str = None,
        text_content: str = None,
        thumbnail_in_base_64: str = None,
        title: str = None,
        update_time: str = None,
        update_user: str = None,
        update_user_name: str = None,
        url: str = None,
    ):
        self.author = author
        self.create_time = create_time
        self.create_user = create_user
        self.create_user_name = create_user_name
        self.doc_keywords = doc_keywords
        self.doc_type = doc_type
        self.external_url = external_url
        self.file_attr = file_attr
        self.file_key = file_key
        self.html_content = html_content
        self.id = id
        self.pub_time = pub_time
        self.public_url = public_url
        self.share_attr = share_attr
        self.src_from = src_from
        self.summary = summary
        self.text_content = text_content
        self.thumbnail_in_base_64 = thumbnail_in_base_64
        self.title = title
        self.update_time = update_time
        self.update_user = update_user
        self.update_user_name = update_user_name
        self.url = url

    def validate(self):
        if self.file_attr:
            self.file_attr.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.author is not None:
            result['Author'] = self.author
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.create_user is not None:
            result['CreateUser'] = self.create_user
        if self.create_user_name is not None:
            result['CreateUserName'] = self.create_user_name
        if self.doc_keywords is not None:
            result['DocKeywords'] = self.doc_keywords
        if self.doc_type is not None:
            result['DocType'] = self.doc_type
        if self.external_url is not None:
            result['ExternalUrl'] = self.external_url
        if self.file_attr is not None:
            result['FileAttr'] = self.file_attr.to_map()
        if self.file_key is not None:
            result['FileKey'] = self.file_key
        if self.html_content is not None:
            result['HtmlContent'] = self.html_content
        if self.id is not None:
            result['Id'] = self.id
        if self.pub_time is not None:
            result['PubTime'] = self.pub_time
        if self.public_url is not None:
            result['PublicUrl'] = self.public_url
        if self.share_attr is not None:
            result['ShareAttr'] = self.share_attr
        if self.src_from is not None:
            result['SrcFrom'] = self.src_from
        if self.summary is not None:
            result['Summary'] = self.summary
        if self.text_content is not None:
            result['TextContent'] = self.text_content
        if self.thumbnail_in_base_64 is not None:
            result['ThumbnailInBase64'] = self.thumbnail_in_base_64
        if self.title is not None:
            result['Title'] = self.title
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        if self.update_user is not None:
            result['UpdateUser'] = self.update_user
        if self.update_user_name is not None:
            result['UpdateUserName'] = self.update_user_name
        if self.url is not None:
            result['Url'] = self.url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Author') is not None:
            self.author = m.get('Author')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('CreateUser') is not None:
            self.create_user = m.get('CreateUser')
        if m.get('CreateUserName') is not None:
            self.create_user_name = m.get('CreateUserName')
        if m.get('DocKeywords') is not None:
            self.doc_keywords = m.get('DocKeywords')
        if m.get('DocType') is not None:
            self.doc_type = m.get('DocType')
        if m.get('ExternalUrl') is not None:
            self.external_url = m.get('ExternalUrl')
        if m.get('FileAttr') is not None:
            temp_model = ListMaterialDocumentsResponseBodyDataFileAttr()
            self.file_attr = temp_model.from_map(m['FileAttr'])
        if m.get('FileKey') is not None:
            self.file_key = m.get('FileKey')
        if m.get('HtmlContent') is not None:
            self.html_content = m.get('HtmlContent')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('PubTime') is not None:
            self.pub_time = m.get('PubTime')
        if m.get('PublicUrl') is not None:
            self.public_url = m.get('PublicUrl')
        if m.get('ShareAttr') is not None:
            self.share_attr = m.get('ShareAttr')
        if m.get('SrcFrom') is not None:
            self.src_from = m.get('SrcFrom')
        if m.get('Summary') is not None:
            self.summary = m.get('Summary')
        if m.get('TextContent') is not None:
            self.text_content = m.get('TextContent')
        if m.get('ThumbnailInBase64') is not None:
            self.thumbnail_in_base_64 = m.get('ThumbnailInBase64')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        if m.get('UpdateUser') is not None:
            self.update_user = m.get('UpdateUser')
        if m.get('UpdateUserName') is not None:
            self.update_user_name = m.get('UpdateUserName')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        return self


class ListMaterialDocumentsResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        current: int = None,
        data: List[ListMaterialDocumentsResponseBodyData] = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        size: int = None,
        success: bool = None,
        total: int = None,
    ):
        self.code = code
        self.current = current
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        self.request_id = request_id
        self.size = size
        self.success = success
        self.total = total

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.current is not None:
            result['Current'] = self.current
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.size is not None:
            result['Size'] = self.size
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Current') is not None:
            self.current = m.get('Current')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ListMaterialDocumentsResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class ListMaterialDocumentsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListMaterialDocumentsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListMaterialDocumentsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListPlanningProposalRequest(TeaModel):
    def __init__(
        self,
        agent_key: str = None,
        custom_view_point_id: str = None,
        custom_view_point_ids: List[str] = None,
        max_results: int = None,
        next_token: str = None,
        titles: List[str] = None,
        topic: str = None,
        topic_source: str = None,
        topic_version: str = None,
        view_point_type: str = None,
    ):
        # This parameter is required.
        self.agent_key = agent_key
        self.custom_view_point_id = custom_view_point_id
        self.custom_view_point_ids = custom_view_point_ids
        self.max_results = max_results
        self.next_token = next_token
        self.titles = titles
        # This parameter is required.
        self.topic = topic
        # This parameter is required.
        self.topic_source = topic_source
        self.topic_version = topic_version
        # This parameter is required.
        self.view_point_type = view_point_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_key is not None:
            result['AgentKey'] = self.agent_key
        if self.custom_view_point_id is not None:
            result['CustomViewPointId'] = self.custom_view_point_id
        if self.custom_view_point_ids is not None:
            result['CustomViewPointIds'] = self.custom_view_point_ids
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.titles is not None:
            result['Titles'] = self.titles
        if self.topic is not None:
            result['Topic'] = self.topic
        if self.topic_source is not None:
            result['TopicSource'] = self.topic_source
        if self.topic_version is not None:
            result['TopicVersion'] = self.topic_version
        if self.view_point_type is not None:
            result['ViewPointType'] = self.view_point_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentKey') is not None:
            self.agent_key = m.get('AgentKey')
        if m.get('CustomViewPointId') is not None:
            self.custom_view_point_id = m.get('CustomViewPointId')
        if m.get('CustomViewPointIds') is not None:
            self.custom_view_point_ids = m.get('CustomViewPointIds')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('Titles') is not None:
            self.titles = m.get('Titles')
        if m.get('Topic') is not None:
            self.topic = m.get('Topic')
        if m.get('TopicSource') is not None:
            self.topic_source = m.get('TopicSource')
        if m.get('TopicVersion') is not None:
            self.topic_version = m.get('TopicVersion')
        if m.get('ViewPointType') is not None:
            self.view_point_type = m.get('ViewPointType')
        return self


class ListPlanningProposalShrinkRequest(TeaModel):
    def __init__(
        self,
        agent_key: str = None,
        custom_view_point_id: str = None,
        custom_view_point_ids_shrink: str = None,
        max_results: int = None,
        next_token: str = None,
        titles_shrink: str = None,
        topic: str = None,
        topic_source: str = None,
        topic_version: str = None,
        view_point_type: str = None,
    ):
        # This parameter is required.
        self.agent_key = agent_key
        self.custom_view_point_id = custom_view_point_id
        self.custom_view_point_ids_shrink = custom_view_point_ids_shrink
        self.max_results = max_results
        self.next_token = next_token
        self.titles_shrink = titles_shrink
        # This parameter is required.
        self.topic = topic
        # This parameter is required.
        self.topic_source = topic_source
        self.topic_version = topic_version
        # This parameter is required.
        self.view_point_type = view_point_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_key is not None:
            result['AgentKey'] = self.agent_key
        if self.custom_view_point_id is not None:
            result['CustomViewPointId'] = self.custom_view_point_id
        if self.custom_view_point_ids_shrink is not None:
            result['CustomViewPointIds'] = self.custom_view_point_ids_shrink
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.titles_shrink is not None:
            result['Titles'] = self.titles_shrink
        if self.topic is not None:
            result['Topic'] = self.topic
        if self.topic_source is not None:
            result['TopicSource'] = self.topic_source
        if self.topic_version is not None:
            result['TopicVersion'] = self.topic_version
        if self.view_point_type is not None:
            result['ViewPointType'] = self.view_point_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentKey') is not None:
            self.agent_key = m.get('AgentKey')
        if m.get('CustomViewPointId') is not None:
            self.custom_view_point_id = m.get('CustomViewPointId')
        if m.get('CustomViewPointIds') is not None:
            self.custom_view_point_ids_shrink = m.get('CustomViewPointIds')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('Titles') is not None:
            self.titles_shrink = m.get('Titles')
        if m.get('Topic') is not None:
            self.topic = m.get('Topic')
        if m.get('TopicSource') is not None:
            self.topic_source = m.get('TopicSource')
        if m.get('TopicVersion') is not None:
            self.topic_version = m.get('TopicVersion')
        if m.get('ViewPointType') is not None:
            self.view_point_type = m.get('ViewPointType')
        return self


class ListPlanningProposalResponseBodyDataOutlines(TeaModel):
    def __init__(
        self,
        outline: str = None,
        summary: str = None,
    ):
        self.outline = outline
        self.summary = summary

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.outline is not None:
            result['Outline'] = self.outline
        if self.summary is not None:
            result['Summary'] = self.summary
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Outline') is not None:
            self.outline = m.get('Outline')
        if m.get('Summary') is not None:
            self.summary = m.get('Summary')
        return self


class ListPlanningProposalResponseBodyData(TeaModel):
    def __init__(
        self,
        outlines: List[ListPlanningProposalResponseBodyDataOutlines] = None,
        summary: str = None,
        title: str = None,
    ):
        self.outlines = outlines
        self.summary = summary
        self.title = title

    def validate(self):
        if self.outlines:
            for k in self.outlines:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Outlines'] = []
        if self.outlines is not None:
            for k in self.outlines:
                result['Outlines'].append(k.to_map() if k else None)
        if self.summary is not None:
            result['Summary'] = self.summary
        if self.title is not None:
            result['Title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.outlines = []
        if m.get('Outlines') is not None:
            for k in m.get('Outlines'):
                temp_model = ListPlanningProposalResponseBodyDataOutlines()
                self.outlines.append(temp_model.from_map(k))
        if m.get('Summary') is not None:
            self.summary = m.get('Summary')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        return self


class ListPlanningProposalResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: List[ListPlanningProposalResponseBodyData] = None,
        http_status_code: int = None,
        max_results: int = None,
        message: str = None,
        next_token: str = None,
        request_id: str = None,
        success: bool = None,
        total_count: int = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.max_results = max_results
        self.message = message
        self.next_token = next_token
        self.request_id = request_id
        self.success = success
        self.total_count = total_count

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.message is not None:
            result['Message'] = self.message
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ListPlanningProposalResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListPlanningProposalResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListPlanningProposalResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListPlanningProposalResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListSearchTaskDialogueDatasRequest(TeaModel):
    def __init__(
        self,
        include_content: bool = None,
        multimodal_search_type: str = None,
        original_session_id: str = None,
        page_number: int = None,
        page_size: int = None,
        query: str = None,
        search_model: str = None,
        search_model_data_value: str = None,
        session_id: str = None,
        task_id: str = None,
        workspace_id: str = None,
    ):
        self.include_content = include_content
        self.multimodal_search_type = multimodal_search_type
        self.original_session_id = original_session_id
        self.page_number = page_number
        self.page_size = page_size
        self.query = query
        self.search_model = search_model
        self.search_model_data_value = search_model_data_value
        # This parameter is required.
        self.session_id = session_id
        self.task_id = task_id
        # This parameter is required.
        self.workspace_id = workspace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.include_content is not None:
            result['IncludeContent'] = self.include_content
        if self.multimodal_search_type is not None:
            result['MultimodalSearchType'] = self.multimodal_search_type
        if self.original_session_id is not None:
            result['OriginalSessionId'] = self.original_session_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.query is not None:
            result['Query'] = self.query
        if self.search_model is not None:
            result['SearchModel'] = self.search_model
        if self.search_model_data_value is not None:
            result['SearchModelDataValue'] = self.search_model_data_value
        if self.session_id is not None:
            result['SessionId'] = self.session_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IncludeContent') is not None:
            self.include_content = m.get('IncludeContent')
        if m.get('MultimodalSearchType') is not None:
            self.multimodal_search_type = m.get('MultimodalSearchType')
        if m.get('OriginalSessionId') is not None:
            self.original_session_id = m.get('OriginalSessionId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Query') is not None:
            self.query = m.get('Query')
        if m.get('SearchModel') is not None:
            self.search_model = m.get('SearchModel')
        if m.get('SearchModelDataValue') is not None:
            self.search_model_data_value = m.get('SearchModelDataValue')
        if m.get('SessionId') is not None:
            self.session_id = m.get('SessionId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        return self


class ListSearchTaskDialogueDatasResponseBodyArticlesMultimodalMedias(TeaModel):
    def __init__(
        self,
        file_url: str = None,
        media_id: str = None,
        media_type: str = None,
    ):
        self.file_url = file_url
        self.media_id = media_id
        self.media_type = media_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_url is not None:
            result['FileUrl'] = self.file_url
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        if self.media_type is not None:
            result['MediaType'] = self.media_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FileUrl') is not None:
            self.file_url = m.get('FileUrl')
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        if m.get('MediaType') is not None:
            self.media_type = m.get('MediaType')
        return self


class ListSearchTaskDialogueDatasResponseBodyArticles(TeaModel):
    def __init__(
        self,
        author: str = None,
        category_uuid: str = None,
        content: str = None,
        doc_id: str = None,
        doc_type: str = None,
        doc_uuid: str = None,
        extend_1: str = None,
        extend_2: str = None,
        extend_3: str = None,
        multimodal_medias: List[ListSearchTaskDialogueDatasResponseBodyArticlesMultimodalMedias] = None,
        pub_time: str = None,
        source: str = None,
        summary: str = None,
        title: str = None,
        url: str = None,
    ):
        self.author = author
        self.category_uuid = category_uuid
        self.content = content
        self.doc_id = doc_id
        self.doc_type = doc_type
        self.doc_uuid = doc_uuid
        self.extend_1 = extend_1
        self.extend_2 = extend_2
        self.extend_3 = extend_3
        self.multimodal_medias = multimodal_medias
        self.pub_time = pub_time
        self.source = source
        self.summary = summary
        self.title = title
        self.url = url

    def validate(self):
        if self.multimodal_medias:
            for k in self.multimodal_medias:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.author is not None:
            result['Author'] = self.author
        if self.category_uuid is not None:
            result['CategoryUuid'] = self.category_uuid
        if self.content is not None:
            result['Content'] = self.content
        if self.doc_id is not None:
            result['DocId'] = self.doc_id
        if self.doc_type is not None:
            result['DocType'] = self.doc_type
        if self.doc_uuid is not None:
            result['DocUuid'] = self.doc_uuid
        if self.extend_1 is not None:
            result['Extend1'] = self.extend_1
        if self.extend_2 is not None:
            result['Extend2'] = self.extend_2
        if self.extend_3 is not None:
            result['Extend3'] = self.extend_3
        result['MultimodalMedias'] = []
        if self.multimodal_medias is not None:
            for k in self.multimodal_medias:
                result['MultimodalMedias'].append(k.to_map() if k else None)
        if self.pub_time is not None:
            result['PubTime'] = self.pub_time
        if self.source is not None:
            result['Source'] = self.source
        if self.summary is not None:
            result['Summary'] = self.summary
        if self.title is not None:
            result['Title'] = self.title
        if self.url is not None:
            result['Url'] = self.url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Author') is not None:
            self.author = m.get('Author')
        if m.get('CategoryUuid') is not None:
            self.category_uuid = m.get('CategoryUuid')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('DocId') is not None:
            self.doc_id = m.get('DocId')
        if m.get('DocType') is not None:
            self.doc_type = m.get('DocType')
        if m.get('DocUuid') is not None:
            self.doc_uuid = m.get('DocUuid')
        if m.get('Extend1') is not None:
            self.extend_1 = m.get('Extend1')
        if m.get('Extend2') is not None:
            self.extend_2 = m.get('Extend2')
        if m.get('Extend3') is not None:
            self.extend_3 = m.get('Extend3')
        self.multimodal_medias = []
        if m.get('MultimodalMedias') is not None:
            for k in m.get('MultimodalMedias'):
                temp_model = ListSearchTaskDialogueDatasResponseBodyArticlesMultimodalMedias()
                self.multimodal_medias.append(temp_model.from_map(k))
        if m.get('PubTime') is not None:
            self.pub_time = m.get('PubTime')
        if m.get('Source') is not None:
            self.source = m.get('Source')
        if m.get('Summary') is not None:
            self.summary = m.get('Summary')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        return self


class ListSearchTaskDialogueDatasResponseBodyAudios(TeaModel):
    def __init__(
        self,
        file_url: str = None,
        media_id: str = None,
    ):
        self.file_url = file_url
        self.media_id = media_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_url is not None:
            result['FileUrl'] = self.file_url
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FileUrl') is not None:
            self.file_url = m.get('FileUrl')
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        return self


class ListSearchTaskDialogueDatasResponseBodyImages(TeaModel):
    def __init__(
        self,
        file_url: str = None,
        media_id: str = None,
        media_type: str = None,
    ):
        self.file_url = file_url
        self.media_id = media_id
        self.media_type = media_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_url is not None:
            result['FileUrl'] = self.file_url
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        if self.media_type is not None:
            result['MediaType'] = self.media_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FileUrl') is not None:
            self.file_url = m.get('FileUrl')
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        if m.get('MediaType') is not None:
            self.media_type = m.get('MediaType')
        return self


class ListSearchTaskDialogueDatasResponseBodyVideos(TeaModel):
    def __init__(
        self,
        file_url: str = None,
        media_id: str = None,
        media_type: str = None,
    ):
        self.file_url = file_url
        self.media_id = media_id
        self.media_type = media_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_url is not None:
            result['FileUrl'] = self.file_url
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        if self.media_type is not None:
            result['MediaType'] = self.media_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FileUrl') is not None:
            self.file_url = m.get('FileUrl')
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        if m.get('MediaType') is not None:
            self.media_type = m.get('MediaType')
        return self


class ListSearchTaskDialogueDatasResponseBody(TeaModel):
    def __init__(
        self,
        articles: List[ListSearchTaskDialogueDatasResponseBodyArticles] = None,
        audios: List[ListSearchTaskDialogueDatasResponseBodyAudios] = None,
        code: str = None,
        http_status_code: int = None,
        images: List[ListSearchTaskDialogueDatasResponseBodyImages] = None,
        message: str = None,
        page_number: int = None,
        page_size: int = None,
        realtime_search: bool = None,
        request_id: str = None,
        search_type: str = None,
        success: bool = None,
        total_count: int = None,
        videos: List[ListSearchTaskDialogueDatasResponseBodyVideos] = None,
    ):
        self.articles = articles
        self.audios = audios
        self.code = code
        self.http_status_code = http_status_code
        self.images = images
        self.message = message
        self.page_number = page_number
        self.page_size = page_size
        self.realtime_search = realtime_search
        self.request_id = request_id
        self.search_type = search_type
        self.success = success
        self.total_count = total_count
        self.videos = videos

    def validate(self):
        if self.articles:
            for k in self.articles:
                if k:
                    k.validate()
        if self.audios:
            for k in self.audios:
                if k:
                    k.validate()
        if self.images:
            for k in self.images:
                if k:
                    k.validate()
        if self.videos:
            for k in self.videos:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Articles'] = []
        if self.articles is not None:
            for k in self.articles:
                result['Articles'].append(k.to_map() if k else None)
        result['Audios'] = []
        if self.audios is not None:
            for k in self.audios:
                result['Audios'].append(k.to_map() if k else None)
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        result['Images'] = []
        if self.images is not None:
            for k in self.images:
                result['Images'].append(k.to_map() if k else None)
        if self.message is not None:
            result['Message'] = self.message
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.realtime_search is not None:
            result['RealtimeSearch'] = self.realtime_search
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.search_type is not None:
            result['SearchType'] = self.search_type
        if self.success is not None:
            result['Success'] = self.success
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['Videos'] = []
        if self.videos is not None:
            for k in self.videos:
                result['Videos'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.articles = []
        if m.get('Articles') is not None:
            for k in m.get('Articles'):
                temp_model = ListSearchTaskDialogueDatasResponseBodyArticles()
                self.articles.append(temp_model.from_map(k))
        self.audios = []
        if m.get('Audios') is not None:
            for k in m.get('Audios'):
                temp_model = ListSearchTaskDialogueDatasResponseBodyAudios()
                self.audios.append(temp_model.from_map(k))
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        self.images = []
        if m.get('Images') is not None:
            for k in m.get('Images'):
                temp_model = ListSearchTaskDialogueDatasResponseBodyImages()
                self.images.append(temp_model.from_map(k))
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RealtimeSearch') is not None:
            self.realtime_search = m.get('RealtimeSearch')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SearchType') is not None:
            self.search_type = m.get('SearchType')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.videos = []
        if m.get('Videos') is not None:
            for k in m.get('Videos'):
                temp_model = ListSearchTaskDialogueDatasResponseBodyVideos()
                self.videos.append(temp_model.from_map(k))
        return self


class ListSearchTaskDialogueDatasResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListSearchTaskDialogueDatasResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListSearchTaskDialogueDatasResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListSearchTaskDialoguesRequest(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        task_id: str = None,
        workspace_id: str = None,
    ):
        self.page_number = page_number
        self.page_size = page_size
        self.task_id = task_id
        # This parameter is required.
        self.workspace_id = workspace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        return self


class ListSearchTaskDialoguesResponseBodyDataChatConfigSearchParamSearchSources(TeaModel):
    def __init__(
        self,
        code: str = None,
        dataset_name: str = None,
        name: str = None,
    ):
        self.code = code
        self.dataset_name = dataset_name
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.dataset_name is not None:
            result['DatasetName'] = self.dataset_name
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('DatasetName') is not None:
            self.dataset_name = m.get('DatasetName')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class ListSearchTaskDialoguesResponseBodyDataChatConfigSearchParam(TeaModel):
    def __init__(
        self,
        end_time: str = None,
        multimodal_search_types: List[str] = None,
        search_sources: List[ListSearchTaskDialoguesResponseBodyDataChatConfigSearchParamSearchSources] = None,
        start_time: str = None,
    ):
        self.end_time = end_time
        self.multimodal_search_types = multimodal_search_types
        self.search_sources = search_sources
        self.start_time = start_time

    def validate(self):
        if self.search_sources:
            for k in self.search_sources:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.multimodal_search_types is not None:
            result['MultimodalSearchTypes'] = self.multimodal_search_types
        result['SearchSources'] = []
        if self.search_sources is not None:
            for k in self.search_sources:
                result['SearchSources'].append(k.to_map() if k else None)
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('MultimodalSearchTypes') is not None:
            self.multimodal_search_types = m.get('