# Generated by Django 4.1.8 on 2023-04-17 11:19

import django.db.models.deletion
import django_fsm
from django.db import migrations, models


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        ("wbcore", "0001_initial_squashed_squashed_0010_preset_appliedpreset"),
        ("directory", "0001_initial"),
        ("tags", "0001_initial"),
        ("agenda", "0002_initial"),
    ]

    operations = [
        migrations.CreateModel(
            name="Task",
            fields=[
                ("tag_detail_endpoint", models.CharField(blank=True, max_length=255, null=True)),
                ("tag_representation", models.CharField(blank=True, max_length=512, null=True)),
                ("due_date", models.DateTimeField(blank=True, null=True, verbose_name="Due Date")),
                ("creation_date", models.DateTimeField(auto_now_add=True, verbose_name="Creation Date")),
                ("starting_date", models.DateTimeField(blank=True, null=True, verbose_name="Started at")),
                ("completion_date", models.DateTimeField(blank=True, null=True, verbose_name="Completed at")),
                (
                    "status",
                    django_fsm.FSMField(
                        choices=[("UNSCHEDULED", "Unscheduled"), ("STARTED", "Started"), ("COMPLETED", "Completed")],
                        default="UNSCHEDULED",
                        max_length=50,
                        verbose_name="Status",
                    ),
                ),
                ("description", models.TextField(default="", verbose_name="Description")),
                (
                    "priority",
                    models.CharField(
                        choices=[("LOW", "Low"), ("MEDIUM", "Medium"), ("HIGH", "High")],
                        default="LOW",
                        max_length=16,
                        verbose_name="Priority level",
                    ),
                ),
                ("comment", models.TextField(default="", verbose_name="Comment")),
                ("widget_endpoint", models.CharField(default="", max_length=256, verbose_name="Widget Endpoint")),
                (
                    "tags",
                    models.ManyToManyField(blank=True, related_name="%(app_label)s_%(class)s_items", to="tags.tag"),
                ),
                (
                    "assigned_to",
                    models.ManyToManyField(
                        blank=True,
                        help_text="The list of participants",
                        related_name="participates_tasks",
                        to="directory.person",
                        verbose_name="Participants",
                    ),
                ),
                (
                    "calendaritem_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        default=None,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="agenda.calendaritem",
                    ),
                ),
                (
                    "in_charge",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="in_charge_of_tasks",
                        to="directory.person",
                        verbose_name="In charge",
                    ),
                ),
                (
                    "requester",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="created_tasks",
                        to="directory.person",
                        verbose_name="Requester",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.AlterField(
            model_name="task",
            name="calendaritem_ptr",
            field=models.OneToOneField(
                auto_created=True,
                on_delete=django.db.models.deletion.CASCADE,
                parent_link=True,
                primary_key=True,
                serialize=False,
                to="agenda.calendaritem",
            ),
        ),
    ]
