"""create new runs table and remove legacy tables

Revision ID: 3bc3c031fbe4
Revises: 567e9fe06270
Create Date: 2025-10-03 12:10:51.065067

"""

from typing import Sequence, Union

import sqlalchemy as sa

from alembic import op

# revision identifiers, used by Alembic.
revision: str = "3bc3c031fbe4"
down_revision: Union[str, None] = "567e9fe06270"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_index("ix_agents_project_id", "agents", ["project_id"], unique=False)
    op.create_index("ix_messages_run_id", "messages", ["run_id"], unique=False)
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index("ix_messages_run_id", table_name="messages")
    op.drop_index("ix_agents_project_id", table_name="agents")
    # ### end Alembic commands ###
