"""add various indexes

Revision ID: 57bcea83af3f
Revises: 5973fd8b8c60
Create Date: 2025-09-19 10:58:19.658106

"""

from typing import Sequence, Union

import sqlalchemy as sa

from alembic import op

# revision identifiers, used by Alembic.
revision: str = "57bcea83af3f"
down_revision: Union[str, None] = "5973fd8b8c60"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_index("ix_block_hidden", "block", ["hidden"], unique=False)
    op.create_index("ix_block_is_template", "block", ["is_template"], unique=False)
    op.create_index("ix_block_org_project_template", "block", ["organization_id", "project_id", "is_template"], unique=False)
    op.create_index("ix_block_organization_id", "block", ["organization_id"], unique=False)
    op.create_index("ix_block_project_id", "block", ["project_id"], unique=False)
    op.create_index("ix_jobs_user_id", "jobs", ["user_id"], unique=False)
    op.create_index("ix_steps_job_id", "steps", ["job_id"], unique=False)
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index("ix_steps_job_id", table_name="steps")
    op.drop_index("ix_jobs_user_id", table_name="jobs")
    op.drop_index("ix_block_project_id", table_name="block")
    op.drop_index("ix_block_organization_id", table_name="block")
    op.drop_index("ix_block_org_project_template", table_name="block")
    op.drop_index("ix_block_is_template", table_name="block")
    op.drop_index("ix_block_hidden", table_name="block")
    # ### end Alembic commands ###
