"""Common domain components for the enterprise blog system."""

from .base_classes import (
    AggregateRoot,
    BusinessRule,
    BusinessRuleViolationException,
    DomainEvent,
    DomainException,
    Entity,
    EntityId,
    ValueObject,
)
from .events import (
    CategoryCreatedEvent,
    CommentAddedEvent,
    CommentApprovedEvent,
    CommentRejectedEvent,
    OrganizationCreatedEvent,
    OrganizationSubscriptionChangedEvent,
    PostCreatedEvent,
    PostDeletedEvent,
    PostLikedEvent,
    PostPublishedEvent,
    PostSharedEvent,
    PostUnpublishedEvent,
    PostViewedEvent,
    TagCreatedEvent,
    UserActivatedEvent,
    UserDeactivatedEvent,
    UserRegisteredEvent,
    UserRoleChangedEvent,
)
from .exceptions import (
    BusinessRuleViolationError,
    CommentModerationError,
    DuplicateEntityError,
    EntityNotFoundError,
    InsufficientPermissionsError,
    InvalidCredentialsError,
    InvalidPostStatusTransitionError,
    OrganizationLimitExceededError,
    PostPublishingError,
    SubscriptionTierError,
    UnauthorizedAccessError,
    UserDeactivationError,
    UserRegistrationError,
    ValidationError,
)

__all__ = [
    # Base classes
    "AggregateRoot",
    "BusinessRule",
    # Exceptions
    "BusinessRuleViolationError",
    "BusinessRuleViolationException",
    # Events
    "CategoryCreatedEvent",
    "CommentAddedEvent",
    "CommentApprovedEvent",
    "CommentModerationError",
    "CommentRejectedEvent",
    "DomainEvent",
    "DomainException",
    "DuplicateEntityError",
    "Entity",
    "EntityId",
    "EntityNotFoundError",
    "InsufficientPermissionsError",
    "InvalidCredentialsError",
    "InvalidPostStatusTransitionError",
    "OrganizationCreatedEvent",
    "OrganizationLimitExceededError",
    "OrganizationSubscriptionChangedEvent",
    "PostCreatedEvent",
    "PostDeletedEvent",
    "PostLikedEvent",
    "PostPublishedEvent",
    "PostPublishingError",
    "PostSharedEvent",
    "PostUnpublishedEvent",
    "PostViewedEvent",
    "SubscriptionTierError",
    "TagCreatedEvent",
    "UnauthorizedAccessError",
    "UserActivatedEvent",
    "UserDeactivatedEvent",
    "UserDeactivationError",
    "UserRegisteredEvent",
    "UserRegistrationError",
    "UserRoleChangedEvent",
    "ValidationError",
    "ValueObject",
]
