-- Vector Search Example Schema
-- Demonstrates all six pgvector distance operators

-- Enable pgvector extension
CREATE EXTENSION IF NOT EXISTS vector;

-- Documents table with vector embeddings and binary hashes
CREATE TABLE documents (
    id UUID PRIMARY KEY DEFAULT gen_random_uuid(),
    title TEXT NOT NULL,
    content TEXT NOT NULL,
    embedding vector(384),  -- Text embedding (e.g., all-MiniLM-L6-v2)
    binary_hash bit(64),   -- Binary hash for Hamming/Jaccard (64-bit)
    category TEXT,
    created_at TIMESTAMP WITH TIME ZONE DEFAULT NOW()
);

-- Performance indexes
CREATE INDEX ON documents USING hnsw (embedding vector_cosine_ops);
CREATE INDEX ON documents (category);
CREATE INDEX ON documents (created_at);

-- Sample data with realistic embeddings and binary hashes
INSERT INTO documents (title, content, embedding, binary_hash, category) VALUES
(
  'Machine Learning Basics',
  'Introduction to machine learning concepts, algorithms, and applications in modern computing.',
  '[0.123, 0.456, 0.789, 0.234, 0.567, 0.890, 0.111, 0.222, 0.333, 0.444, 0.555, 0.666, 0.777, 0.888, 0.999, 0.101, 0.202, 0.303, 0.404, 0.505, 0.606, 0.707, 0.808, 0.909, 0.010, 0.111, 0.212, 0.313, 0.414, 0.515, 0.616, 0.717, 0.818, 0.919, 0.020, 0.121, 0.222, 0.323, 0.424, 0.525, 0.626, 0.727, 0.828, 0.929, 0.030, 0.131, 0.232, 0.333, 0.434, 0.535, 0.636, 0.737, 0.838, 0.939, 0.040, 0.141, 0.242, 0.343, 0.444, 0.545, 0.646, 0.747, 0.848, 0.949, 0.050, 0.151, 0.252, 0.353, 0.454, 0.555, 0.656, 0.757, 0.858, 0.959, 0.060, 0.161, 0.262, 0.363, 0.464, 0.565, 0.666, 0.767, 0.868, 0.969, 0.070, 0.171, 0.272, 0.373, 0.474, 0.575, 0.676, 0.777, 0.878, 0.979, 0.080, 0.181, 0.282, 0.383, 0.484, 0.585, 0.686, 0.787, 0.888, 0.989, 0.090, 0.191, 0.292, 0.393, 0.494, 0.595, 0.696, 0.797, 0.898, 0.999, 0.100, 0.201, 0.302, 0.403, 0.504, 0.605, 0.706, 0.807, 0.908, 0.009, 0.110, 0.211, 0.312, 0.413, 0.514, 0.615, 0.716, 0.817, 0.918, 0.019, 0.120, 0.221, 0.322, 0.423, 0.524, 0.625, 0.726, 0.827, 0.928, 0.029, 0.130, 0.231, 0.332, 0.433, 0.534, 0.635, 0.736, 0.837, 0.938, 0.039, 0.140, 0.241, 0.342, 0.443, 0.544, 0.645, 0.746, 0.847, 0.948, 0.049, 0.150, 0.251, 0.352, 0.453, 0.554, 0.655, 0.756, 0.857, 0.958, 0.059, 0.160, 0.261, 0.362, 0.463, 0.564, 0.665, 0.766, 0.867, 0.968, 0.069, 0.170, 0.271, 0.372, 0.473, 0.574, 0.675, 0.776, 0.877, 0.978, 0.079, 0.180, 0.281, 0.382, 0.483, 0.584, 0.685, 0.786, 0.887, 0.988, 0.089, 0.190, 0.291, 0.392, 0.493, 0.594, 0.695, 0.796, 0.897, 0.998, 0.099, 0.200, 0.301, 0.402, 0.503, 0.604, 0.705, 0.806, 0.907, 0.008, 0.109, 0.210, 0.311, 0.412, 0.513, 0.614, 0.715, 0.816, 0.917, 0.018, 0.119, 0.220, 0.321, 0.422, 0.523, 0.624, 0.725, 0.826, 0.927, 0.028, 0.129, 0.230, 0.331, 0.432, 0.533, 0.634, 0.735, 0.836, 0.937, 0.038, 0.139, 0.240, 0.341, 0.442, 0.543, 0.644, 0.745, 0.846, 0.947, 0.048, 0.149, 0.250, 0.351, 0.452, 0.553, 0.654, 0.755, 0.856, 0.957, 0.058, 0.159, 0.260, 0.361, 0.462, 0.563, 0.664, 0.765, 0.866, 0.967, 0.068, 0.169, 0.270, 0.371, 0.472, 0.573, 0.674, 0.775, 0.876, 0.977, 0.078, 0.179, 0.280, 0.381, 0.482, 0.583, 0.684, 0.785, 0.886, 0.987, 0.088, 0.189, 0.290, 0.391, 0.492, 0.593, 0.694, 0.795, 0.896, 0.997, 0.098, 0.199, 0.300, 0.401, 0.502, 0.603, 0.704, 0.805, 0.906, 0.007, 0.108, 0.209, 0.310, 0.411, 0.512, 0.613, 0.714, 0.815, 0.916, 0.017, 0.118, 0.219, 0.320, 0.421, 0.522, 0.623, 0.724, 0.825, 0.926, 0.027, 0.128, 0.229, 0.330, 0.431, 0.532, 0.633, 0.734, 0.835, 0.936, 0.037, 0.138, 0.239, 0.340, 0.441, 0.542, 0.643, 0.744, 0.845, 0.946, 0.047, 0.148, 0.249, 0.350, 0.451, 0.552, 0.653, 0.754, 0.855, 0.956, 0.057, 0.158, 0.259, 0.360, 0.461, 0.562, 0.663, 0.764, 0.865, 0.966, 0.067, 0.168, 0.269, 0.370, 0.471, 0.572, 0.673, 0.774, 0.875, 0.976, 0.077, 0.178, 0.279, 0.380, 0.481, 0.582, 0.683, 0.784, 0.885, 0.986, 0.087, 0.188, 0.289, 0.390, 0.491, 0.592, 0.693, 0.794, 0.895, 0.996, 0.097, 0.198, 0.299, 0.400, 0.501, 0.602, 0.703, 0.804, 0.905, 0.006]'::vector,
  B'1010101010101010101010101010101010101010101010101010101010101010',
  'technical'
),
(
  'Deep Learning Guide',
  'Advanced neural network techniques, transformers, and modern AI architectures.',
  '[0.234, 0.567, 0.890, 0.123, 0.456, 0.789, 0.222, 0.333, 0.444, 0.555, 0.666, 0.777, 0.888, 0.999, 0.101, 0.202, 0.303, 0.404, 0.505, 0.606, 0.707, 0.808, 0.909, 0.010, 0.111, 0.212, 0.313, 0.414, 0.515, 0.616, 0.717, 0.818, 0.919, 0.020, 0.121, 0.222, 0.323, 0.424, 0.525, 0.626, 0.727, 0.828, 0.929, 0.030, 0.131, 0.232, 0.333, 0.434, 0.535, 0.636, 0.737, 0.838, 0.939, 0.040, 0.141, 0.242, 0.343, 0.444, 0.545, 0.646, 0.747, 0.848, 0.949, 0.050, 0.151, 0.252, 0.353, 0.454, 0.555, 0.656, 0.757, 0.858, 0.959, 0.060, 0.161, 0.262, 0.363, 0.464, 0.565, 0.666, 0.767, 0.868, 0.969, 0.070, 0.171, 0.272, 0.373, 0.474, 0.575, 0.676, 0.777, 0.878, 0.979, 0.080, 0.181, 0.282, 0.383, 0.484, 0.585, 0.686, 0.787, 0.888, 0.989, 0.090, 0.191, 0.292, 0.393, 0.494, 0.595, 0.696, 0.797, 0.898, 0.999, 0.100, 0.201, 0.302, 0.403, 0.504, 0.605, 0.706, 0.807, 0.908, 0.009, 0.110, 0.211, 0.312, 0.413, 0.514, 0.615, 0.716, 0.817, 0.918, 0.019, 0.120, 0.221, 0.322, 0.423, 0.524, 0.625, 0.726, 0.827, 0.928, 0.029, 0.130, 0.231, 0.332, 0.433, 0.534, 0.635, 0.736, 0.837, 0.938, 0.039, 0.140, 0.241, 0.342, 0.443, 0.544, 0.645, 0.746, 0.847, 0.948, 0.049, 0.150, 0.251, 0.352, 0.453, 0.554, 0.655, 0.756, 0.857, 0.958, 0.059, 0.160, 0.261, 0.362, 0.463, 0.564, 0.665, 0.766, 0.867, 0.968, 0.069, 0.170, 0.271, 0.372, 0.473, 0.574, 0.675, 0.776, 0.877, 0.978, 0.079, 0.180, 0.281, 0.382, 0.483, 0.584, 0.685, 0.786, 0.887, 0.988, 0.089, 0.190, 0.291, 0.392, 0.493, 0.594, 0.695, 0.796, 0.897, 0.998, 0.099, 0.200, 0.301, 0.402, 0.503, 0.604, 0.705, 0.806, 0.907, 0.008, 0.109, 0.210, 0.311, 0.412, 0.513, 0.614, 0.715, 0.816, 0.917, 0.018, 0.119, 0.220, 0.321, 0.422, 0.523, 0.624, 0.725, 0.826, 0.927, 0.028, 0.129, 0.230, 0.331, 0.432, 0.533, 0.634, 0.735, 0.836, 0.937, 0.038, 0.139, 0.240, 0.341, 0.442, 0.543, 0.644, 0.745, 0.846, 0.947, 0.048, 0.149, 0.250, 0.351, 0.452, 0.553, 0.654, 0.755, 0.856, 0.957, 0.058, 0.159, 0.260, 0.361, 0.462, 0.563, 0.664, 0.765, 0.866, 0.967, 0.068, 0.169, 0.270, 0.371, 0.472, 0.573, 0.674, 0.775, 0.876, 0.977, 0.078, 0.179, 0.280, 0.381, 0.482, 0.583, 0.684, 0.785, 0.886, 0.987, 0.088, 0.189, 0.290, 0.391, 0.492, 0.593, 0.694, 0.795, 0.896, 0.997, 0.098, 0.199, 0.300, 0.401, 0.502, 0.603, 0.704, 0.805, 0.906, 0.007, 0.108, 0.209, 0.310, 0.411, 0.512, 0.613, 0.714, 0.815, 0.916, 0.017, 0.118, 0.219, 0.320, 0.421, 0.522, 0.623, 0.724, 0.825, 0.926, 0.027, 0.128, 0.229, 0.330, 0.431, 0.532, 0.633, 0.734, 0.835, 0.936, 0.037, 0.138, 0.239, 0.340, 0.441, 0.542, 0.643, 0.744, 0.845, 0.946, 0.047, 0.148, 0.249, 0.350, 0.451, 0.552, 0.653, 0.754, 0.855, 0.956, 0.057, 0.158, 0.259, 0.360, 0.461, 0.562, 0.663, 0.764, 0.865, 0.966, 0.067, 0.168, 0.269, 0.370, 0.471, 0.572, 0.673, 0.774, 0.875, 0.976, 0.077, 0.178, 0.279, 0.380, 0.481, 0.582, 0.683, 0.784, 0.885, 0.986, 0.087, 0.188, 0.289, 0.390, 0.491, 0.592, 0.693, 0.794, 0.895, 0.996, 0.097, 0.198, 0.299, 0.400, 0.501, 0.602, 0.703, 0.804, 0.905, 0.006]'::vector,
  B'1010101010101010101010101010101010101010101010101010101010101011',
  'technical'
),
(
  'Web Development Fundamentals',
  'HTML, CSS, JavaScript basics for building modern web applications.',
  '[0.345, 0.678, 0.901, 0.234, 0.567, 0.890, 0.333, 0.444, 0.555, 0.666, 0.777, 0.888, 0.999, 0.101, 0.202, 0.303, 0.404, 0.505, 0.606, 0.707, 0.808, 0.909, 0.010, 0.111, 0.212, 0.313, 0.414, 0.515, 0.616, 0.717, 0.818, 0.919, 0.020, 0.121, 0.222, 0.323, 0.424, 0.525, 0.626, 0.727, 0.828, 0.929, 0.030, 0.131, 0.232, 0.333, 0.434, 0.535, 0.636, 0.737, 0.838, 0.939, 0.040, 0.141, 0.242, 0.343, 0.444, 0.545, 0.646, 0.747, 0.848, 0.949, 0.050, 0.151, 0.252, 0.353, 0.454, 0.555, 0.656, 0.757, 0.858, 0.959, 0.060, 0.161, 0.262, 0.363, 0.464, 0.565, 0.666, 0.767, 0.868, 0.969, 0.070, 0.171, 0.272, 0.373, 0.474, 0.575, 0.676, 0.777, 0.878, 0.979, 0.080, 0.181, 0.282, 0.383, 0.484, 0.585, 0.686, 0.787, 0.888, 0.989, 0.090, 0.191, 0.292, 0.393, 0.494, 0.595, 0.696, 0.797, 0.898, 0.999, 0.100, 0.201, 0.302, 0.403, 0.504, 0.605, 0.706, 0.807, 0.908, 0.009, 0.110, 0.211, 0.312, 0.413, 0.514, 0.615, 0.716, 0.817, 0.918, 0.019, 0.120, 0.221, 0.322, 0.423, 0.524, 0.625, 0.726, 0.827, 0.928, 0.029, 0.130, 0.231, 0.332, 0.433, 0.534, 0.635, 0.736, 0.837, 0.938, 0.039, 0.140, 0.241, 0.342, 0.443, 0.544, 0.645, 0.746, 0.847, 0.948, 0.049, 0.150, 0.251, 0.352, 0.453, 0.554, 0.655, 0.756, 0.857, 0.958, 0.059, 0.160, 0.261, 0.362, 0.463, 0.564, 0.665, 0.766, 0.867, 0.968, 0.069, 0.170, 0.271, 0.372, 0.473, 0.574, 0.675, 0.776, 0.877, 0.978, 0.079, 0.180, 0.281, 0.382, 0.483, 0.584, 0.685, 0.786, 0.887, 0.988, 0.089, 0.190, 0.291, 0.392, 0.493, 0.594, 0.695, 0.796, 0.897, 0.998, 0.099, 0.200, 0.301, 0.402, 0.503, 0.604, 0.705, 0.806, 0.907, 0.008, 0.109, 0.210, 0.311, 0.412, 0.513, 0.614, 0.715, 0.816, 0.917, 0.018, 0.119, 0.220, 0.321, 0.422, 0.523, 0.624, 0.725, 0.826, 0.927, 0.028, 0.129, 0.230, 0.331, 0.432, 0.533, 0.634, 0.735, 0.836, 0.937, 0.038, 0.139, 0.240, 0.341, 0.442, 0.543, 0.644, 0.745, 0.846, 0.947, 0.048, 0.149, 0.250, 0.351, 0.452, 0.553, 0.654, 0.755, 0.856, 0.957, 0.058, 0.159, 0.260, 0.361, 0.462, 0.563, 0.664, 0.765, 0.866, 0.967, 0.068, 0.169, 0.270, 0.371, 0.472, 0.573, 0.674, 0.775, 0.876, 0.977, 0.078, 0.179, 0.280, 0.381, 0.482, 0.583, 0.684, 0.785, 0.886, 0.987, 0.088, 0.189, 0.290, 0.391, 0.492, 0.593, 0.694, 0.795, 0.896, 0.997, 0.098, 0.199, 0.300, 0.401, 0.502, 0.603, 0.704, 0.805, 0.906, 0.007, 0.108, 0.209, 0.310, 0.411, 0.512, 0.613, 0.714, 0.815, 0.916, 0.017, 0.118, 0.219, 0.320, 0.421, 0.522, 0.623, 0.724, 0.825, 0.926, 0.027, 0.128, 0.229, 0.330, 0.431, 0.532, 0.633, 0.734, 0.835, 0.936, 0.037, 0.138, 0.239, 0.340, 0.441, 0.542, 0.643, 0.744, 0.845, 0.946, 0.047, 0.148, 0.249, 0.350, 0.451, 0.552, 0.653, 0.754, 0.855, 0.956, 0.057, 0.158, 0.259, 0.360, 0.461, 0.562, 0.663, 0.764, 0.865, 0.966, 0.067, 0.168, 0.269, 0.370, 0.471, 0.572, 0.673, 0.774, 0.875, 0.976, 0.077, 0.178, 0.279, 0.380, 0.481, 0.582, 0.683, 0.784, 0.885, 0.986, 0.087, 0.188, 0.289, 0.390, 0.491, 0.592, 0.693, 0.794, 0.895, 0.996, 0.097, 0.198, 0.299, 0.400, 0.501, 0.602, 0.703, 0.804, 0.905, 0.006]'::vector,
  B'1100110011001100110011001100110011001100110011001100110011001100',
  'technical'
);</content>
</xai:function_call">\
<xai:function_call name="write">
<parameter name="filePath">examples/vector_search/main.py
