#!/bin/bash
# Commands to complete the FraiseQL v0.1.0a13 release

echo "=== FraiseQL v0.1.0a13 Release Commands ==="
echo ""
echo "1. Create and push the git tag:"
echo "   git tag v0.1.0a13"
echo "   git push origin main"
echo "   git push origin v0.1.0a13"
echo ""
echo "2. Create GitHub Release:"
echo "   - Go to: https://github.com/fraiseql/fraiseql/releases/new"
echo "   - Tag: v0.1.0a13"
echo "   - Title: FraiseQL v0.1.0a13 - Dual-Mode Repository"
echo "   - Copy content from RELEASE_NOTES_v0.1.0a13.md"
echo "   - Attach: dist/fraiseql-0.1.0a13-py3-none-any.whl"
echo "   - Attach: dist/fraiseql-0.1.0a13.tar.gz"
echo ""
echo "3. Publish to PyPI:"
echo "   twine upload dist/fraiseql-0.1.0a13*"
echo ""
echo "4. Verify installation:"
echo "   pip install --upgrade fraiseql==0.1.0a13"
echo ""
echo "Files ready for release:"
echo "   - dist/fraiseql-0.1.0a13-py3-none-any.whl (200KB)"
echo "   - dist/fraiseql-0.1.0a13.tar.gz (150KB)"
