'''
# cdk8s+ (cdk8s-plus)

### High level constructs for Kubernetes

![Stability:Stable](https://img.shields.io/badge/stability-stable-success)

| k8s version | npm (JS/TS)                                         | PyPI (Python)                                   | Maven (Java)                                                      | Go                                                              |
| ----------- | --------------------------------------------------- | ----------------------------------------------- | ----------------------------------------------------------------- | --------------------------------------------------------------- |
| 1.22.0      | [Link](https://www.npmjs.com/package/cdk8s-plus-22) | [Link](https://pypi.org/project/cdk8s-plus-22/) | [Link](https://search.maven.org/artifact/org.cdk8s/cdk8s-plus-22) | [Link](https://github.com/cdk8s-team/cdk8s-plus-go/tree/k8s.22) |
| 1.23.0      | [Link](https://www.npmjs.com/package/cdk8s-plus-23) | [Link](https://pypi.org/project/cdk8s-plus-23/) | [Link](https://search.maven.org/artifact/org.cdk8s/cdk8s-plus-23) | [Link](https://github.com/cdk8s-team/cdk8s-plus-go/tree/k8s.23) |
| 1.24.0      | [Link](https://www.npmjs.com/package/cdk8s-plus-24) | [Link](https://pypi.org/project/cdk8s-plus-24/) | [Link](https://search.maven.org/artifact/org.cdk8s/cdk8s-plus-24) | [Link](https://github.com/cdk8s-team/cdk8s-plus-go/tree/k8s.24) |

**cdk8s+** is a software development framework that provides high level
abstractions for authoring Kubernetes applications. Built on top of the auto
generated building blocks provided by [cdk8s](../cdk8s), this library includes a
hand crafted *construct* for each native kubernetes object, exposing richer
API's with reduced complexity.

## :books: Documentation

See [cdk8s.io](https://cdk8s.io/docs/latest/plus).

## :raised_hand: Contributing

If you'd like to add a new feature or fix a bug, please visit
[CONTRIBUTING.md](CONTRIBUTING.md)!

## :balance_scale: License

This project is distributed under the [Apache License, Version 2.0](./LICENSE).

This module is part of the [cdk8s project](https://github.com/cdk8s-team).
'''
import abc
import builtins
import datetime
import enum
import typing

import jsii
import publication
import typing_extensions

from typeguard import check_type

from ._jsii import *

import cdk8s as _cdk8s_d3d9af27
import constructs as _constructs_77d1e7e8


@jsii.data_type(
    jsii_type="cdk8s-plus-24.AddDirectoryOptions",
    jsii_struct_bases=[],
    name_mapping={"exclude": "exclude", "key_prefix": "keyPrefix"},
)
class AddDirectoryOptions:
    def __init__(
        self,
        *,
        exclude: typing.Optional[typing.Sequence[builtins.str]] = None,
        key_prefix: typing.Optional[builtins.str] = None,
    ) -> None:
        '''Options for ``configmap.addDirectory()``.

        :param exclude: Glob patterns to exclude when adding files. Default: - include all files
        :param key_prefix: A prefix to add to all keys in the config map. Default: ""
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__93941d91581ca0d0a515f4c7aa8d57f273b5848d9aa0799c8549c458602de50f)
            check_type(argname="argument exclude", value=exclude, expected_type=type_hints["exclude"])
            check_type(argname="argument key_prefix", value=key_prefix, expected_type=type_hints["key_prefix"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if exclude is not None:
            self._values["exclude"] = exclude
        if key_prefix is not None:
            self._values["key_prefix"] = key_prefix

    @builtins.property
    def exclude(self) -> typing.Optional[typing.List[builtins.str]]:
        '''Glob patterns to exclude when adding files.

        :default: - include all files
        '''
        result = self._values.get("exclude")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def key_prefix(self) -> typing.Optional[builtins.str]:
        '''A prefix to add to all keys in the config map.

        :default: ""
        '''
        result = self._values.get("key_prefix")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AddDirectoryOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.ApiResourceOptions",
    jsii_struct_bases=[],
    name_mapping={"api_group": "apiGroup", "resource_type": "resourceType"},
)
class ApiResourceOptions:
    def __init__(self, *, api_group: builtins.str, resource_type: builtins.str) -> None:
        '''Options for ``ApiResource``.

        :param api_group: The group portion of the API version (e.g. ``authorization.k8s.io``).
        :param resource_type: The name of the resource type as it appears in the relevant API endpoint.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e61f4b9912f91ef67d533943384ae3f4ced151ff214a3a540d36c670cff8dc61)
            check_type(argname="argument api_group", value=api_group, expected_type=type_hints["api_group"])
            check_type(argname="argument resource_type", value=resource_type, expected_type=type_hints["resource_type"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "api_group": api_group,
            "resource_type": resource_type,
        }

    @builtins.property
    def api_group(self) -> builtins.str:
        '''The group portion of the API version (e.g. ``authorization.k8s.io``).'''
        result = self._values.get("api_group")
        assert result is not None, "Required property 'api_group' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def resource_type(self) -> builtins.str:
        '''The name of the resource type as it appears in the relevant API endpoint.

        :see: https://kubernetes.io/docs/reference/access-authn-authz/rbac/#referring-to-resources

        Example::

            - "pods" or "pods/log"
        '''
        result = self._values.get("resource_type")
        assert result is not None, "Required property 'resource_type' is missing"
        return typing.cast(builtins.str, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiResourceOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.AwsElasticBlockStoreVolumeOptions",
    jsii_struct_bases=[],
    name_mapping={
        "fs_type": "fsType",
        "name": "name",
        "partition": "partition",
        "read_only": "readOnly",
    },
)
class AwsElasticBlockStoreVolumeOptions:
    def __init__(
        self,
        *,
        fs_type: typing.Optional[builtins.str] = None,
        name: typing.Optional[builtins.str] = None,
        partition: typing.Optional[jsii.Number] = None,
        read_only: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''Options of ``Volume.fromAwsElasticBlockStore``.

        :param fs_type: Filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Default: 'ext4'
        :param name: The volume name. Default: - auto-generated
        :param partition: The partition in the volume that you want to mount. If omitted, the default is to mount by volume name. Examples: For volume /dev/sda1, you specify the partition as "1". Similarly, the volume partition for /dev/sda is "0" (or you can leave the property empty). Default: - No partition.
        :param read_only: Specify "true" to force and set the ReadOnly property in VolumeMounts to "true". Default: false
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__7dd79aace78c14f463f879d81a7fa9bc18545309b36193817e6789172f80ddea)
            check_type(argname="argument fs_type", value=fs_type, expected_type=type_hints["fs_type"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
            check_type(argname="argument read_only", value=read_only, expected_type=type_hints["read_only"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if fs_type is not None:
            self._values["fs_type"] = fs_type
        if name is not None:
            self._values["name"] = name
        if partition is not None:
            self._values["partition"] = partition
        if read_only is not None:
            self._values["read_only"] = read_only

    @builtins.property
    def fs_type(self) -> typing.Optional[builtins.str]:
        '''Filesystem type of the volume that you want to mount.

        Tip: Ensure that the filesystem type is supported by the host operating system.

        :default: 'ext4'

        :see: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
        '''
        result = self._values.get("fs_type")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''The volume name.

        :default: - auto-generated
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def partition(self) -> typing.Optional[jsii.Number]:
        '''The partition in the volume that you want to mount.

        If omitted, the default is to mount by volume name.
        Examples: For volume /dev/sda1, you specify the partition as "1".
        Similarly, the volume partition for /dev/sda is "0" (or you can leave the property empty).

        :default: - No partition.
        '''
        result = self._values.get("partition")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def read_only(self) -> typing.Optional[builtins.bool]:
        '''Specify "true" to force and set the ReadOnly property in VolumeMounts to "true".

        :default: false

        :see: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
        '''
        result = self._values.get("read_only")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AwsElasticBlockStoreVolumeOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.enum(jsii_type="cdk8s-plus-24.AzureDiskPersistentVolumeCachingMode")
class AzureDiskPersistentVolumeCachingMode(enum.Enum):
    '''Azure disk caching modes.'''

    NONE = "NONE"
    '''None.'''
    READ_ONLY = "READ_ONLY"
    '''ReadOnly.'''
    READ_WRITE = "READ_WRITE"
    '''ReadWrite.'''


@jsii.enum(jsii_type="cdk8s-plus-24.AzureDiskPersistentVolumeKind")
class AzureDiskPersistentVolumeKind(enum.Enum):
    '''Azure Disk kinds.'''

    SHARED = "SHARED"
    '''Multiple blob disks per storage account.'''
    DEDICATED = "DEDICATED"
    '''Single blob disk per storage account.'''
    MANAGED = "MANAGED"
    '''Azure managed data disk.'''


@jsii.data_type(
    jsii_type="cdk8s-plus-24.AzureDiskVolumeOptions",
    jsii_struct_bases=[],
    name_mapping={
        "caching_mode": "cachingMode",
        "fs_type": "fsType",
        "kind": "kind",
        "name": "name",
        "read_only": "readOnly",
    },
)
class AzureDiskVolumeOptions:
    def __init__(
        self,
        *,
        caching_mode: typing.Optional[AzureDiskPersistentVolumeCachingMode] = None,
        fs_type: typing.Optional[builtins.str] = None,
        kind: typing.Optional[AzureDiskPersistentVolumeKind] = None,
        name: typing.Optional[builtins.str] = None,
        read_only: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''Options of ``Volume.fromAzureDisk``.

        :param caching_mode: Host Caching mode. Default: - AzureDiskPersistentVolumeCachingMode.NONE.
        :param fs_type: Filesystem type to mount. Must be a filesystem type supported by the host operating system. Default: 'ext4'
        :param kind: Kind of disk. Default: AzureDiskPersistentVolumeKind.SHARED
        :param name: The volume name. Default: - auto-generated
        :param read_only: Force the ReadOnly setting in VolumeMounts. Default: false
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__63315934a3fe8a572e1e161e94d5b11f2d812b688490d994d714dfc4e91df325)
            check_type(argname="argument caching_mode", value=caching_mode, expected_type=type_hints["caching_mode"])
            check_type(argname="argument fs_type", value=fs_type, expected_type=type_hints["fs_type"])
            check_type(argname="argument kind", value=kind, expected_type=type_hints["kind"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument read_only", value=read_only, expected_type=type_hints["read_only"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if caching_mode is not None:
            self._values["caching_mode"] = caching_mode
        if fs_type is not None:
            self._values["fs_type"] = fs_type
        if kind is not None:
            self._values["kind"] = kind
        if name is not None:
            self._values["name"] = name
        if read_only is not None:
            self._values["read_only"] = read_only

    @builtins.property
    def caching_mode(self) -> typing.Optional[AzureDiskPersistentVolumeCachingMode]:
        '''Host Caching mode.

        :default: - AzureDiskPersistentVolumeCachingMode.NONE.
        '''
        result = self._values.get("caching_mode")
        return typing.cast(typing.Optional[AzureDiskPersistentVolumeCachingMode], result)

    @builtins.property
    def fs_type(self) -> typing.Optional[builtins.str]:
        '''Filesystem type to mount.

        Must be a filesystem type supported by the host operating system.

        :default: 'ext4'
        '''
        result = self._values.get("fs_type")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def kind(self) -> typing.Optional[AzureDiskPersistentVolumeKind]:
        '''Kind of disk.

        :default: AzureDiskPersistentVolumeKind.SHARED
        '''
        result = self._values.get("kind")
        return typing.cast(typing.Optional[AzureDiskPersistentVolumeKind], result)

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''The volume name.

        :default: - auto-generated
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def read_only(self) -> typing.Optional[builtins.bool]:
        '''Force the ReadOnly setting in VolumeMounts.

        :default: false
        '''
        result = self._values.get("read_only")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AzureDiskVolumeOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.ClusterRolePolicyRule",
    jsii_struct_bases=[],
    name_mapping={"endpoints": "endpoints", "verbs": "verbs"},
)
class ClusterRolePolicyRule:
    def __init__(
        self,
        *,
        endpoints: typing.Sequence["IApiEndpoint"],
        verbs: typing.Sequence[builtins.str],
    ) -> None:
        '''Policy rule of a `ClusterRole.

        :param endpoints: Endpoints this rule applies to. Can be either api resources or non api resources.
        :param verbs: Verbs to allow. (e.g ['get', 'watch'])
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__487e6b9a5e3d6753cdacae3f1a4850e0ac3b3cf842c5e2076a286b0b6503862d)
            check_type(argname="argument endpoints", value=endpoints, expected_type=type_hints["endpoints"])
            check_type(argname="argument verbs", value=verbs, expected_type=type_hints["verbs"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "endpoints": endpoints,
            "verbs": verbs,
        }

    @builtins.property
    def endpoints(self) -> typing.List["IApiEndpoint"]:
        '''Endpoints this rule applies to.

        Can be either api resources
        or non api resources.
        '''
        result = self._values.get("endpoints")
        assert result is not None, "Required property 'endpoints' is missing"
        return typing.cast(typing.List["IApiEndpoint"], result)

    @builtins.property
    def verbs(self) -> typing.List[builtins.str]:
        '''Verbs to allow.

        (e.g ['get', 'watch'])
        '''
        result = self._values.get("verbs")
        assert result is not None, "Required property 'verbs' is missing"
        return typing.cast(typing.List[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ClusterRolePolicyRule(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.enum(jsii_type="cdk8s-plus-24.ConcurrencyPolicy")
class ConcurrencyPolicy(enum.Enum):
    '''Concurrency policy for CronJobs.'''

    ALLOW = "ALLOW"
    '''This policy allows to run job concurrently.'''
    FORBID = "FORBID"
    '''This policy does not allow to run job concurrently.

    It does not let a new job to be scheduled if the previous one is not finished yet.
    '''
    REPLACE = "REPLACE"
    '''This policy replaces the currently running job if a new job is being scheduled.'''


@jsii.data_type(
    jsii_type="cdk8s-plus-24.ConfigMapVolumeOptions",
    jsii_struct_bases=[],
    name_mapping={
        "default_mode": "defaultMode",
        "items": "items",
        "name": "name",
        "optional": "optional",
    },
)
class ConfigMapVolumeOptions:
    def __init__(
        self,
        *,
        default_mode: typing.Optional[jsii.Number] = None,
        items: typing.Optional[typing.Mapping[builtins.str, typing.Union["PathMapping", typing.Dict[builtins.str, typing.Any]]]] = None,
        name: typing.Optional[builtins.str] = None,
        optional: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''Options for the ConfigMap-based volume.

        :param default_mode: Mode bits to use on created files by default. Must be a value between 0 and 0777. Defaults to 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set. Default: 644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
        :param items: If unspecified, each key-value pair in the Data field of the referenced ConfigMap will be projected into the volume as a file whose name is the key and content is the value. If specified, the listed keys will be projected into the specified paths, and unlisted keys will not be present. If a key is specified which is not present in the ConfigMap, the volume setup will error unless it is marked optional. Paths must be relative and may not contain the '..' path or start with '..'. Default: - no mapping
        :param name: The volume name. Default: - auto-generated
        :param optional: Specify whether the ConfigMap or its keys must be defined. Default: - undocumented
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__dfaa6ca2c9cb391a3fbd9aed8c3e892dcdc5e205a9bb832c924b5c9bfb1483b0)
            check_type(argname="argument default_mode", value=default_mode, expected_type=type_hints["default_mode"])
            check_type(argname="argument items", value=items, expected_type=type_hints["items"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument optional", value=optional, expected_type=type_hints["optional"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if default_mode is not None:
            self._values["default_mode"] = default_mode
        if items is not None:
            self._values["items"] = items
        if name is not None:
            self._values["name"] = name
        if optional is not None:
            self._values["optional"] = optional

    @builtins.property
    def default_mode(self) -> typing.Optional[jsii.Number]:
        '''Mode bits to use on created files by default.

        Must be a value between 0 and
        0777. Defaults to 0644. Directories within the path are not affected by
        this setting. This might be in conflict with other options that affect the
        file mode, like fsGroup, and the result can be other mode bits set.

        :default:

        644. Directories within the path are not affected by this
        setting. This might be in conflict with other options that affect the file
        mode, like fsGroup, and the result can be other mode bits set.
        '''
        result = self._values.get("default_mode")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def items(self) -> typing.Optional[typing.Mapping[builtins.str, "PathMapping"]]:
        '''If unspecified, each key-value pair in the Data field of the referenced ConfigMap will be projected into the volume as a file whose name is the key and content is the value.

        If specified, the listed keys will be projected
        into the specified paths, and unlisted keys will not be present. If a key
        is specified which is not present in the ConfigMap, the volume setup will
        error unless it is marked optional. Paths must be relative and may not
        contain the '..' path or start with '..'.

        :default: - no mapping
        '''
        result = self._values.get("items")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, "PathMapping"]], result)

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''The volume name.

        :default: - auto-generated
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def optional(self) -> typing.Optional[builtins.bool]:
        '''Specify whether the ConfigMap or its keys must be defined.

        :default: - undocumented
        '''
        result = self._values.get("optional")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ConfigMapVolumeOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.enum(jsii_type="cdk8s-plus-24.ConnectionScheme")
class ConnectionScheme(enum.Enum):
    HTTP = "HTTP"
    '''Use HTTP request for connecting to host.'''
    HTTPS = "HTTPS"
    '''Use HTTPS request for connecting to host.'''


class Container(metaclass=jsii.JSIIMeta, jsii_type="cdk8s-plus-24.Container"):
    '''A single application container that you want to run within a pod.'''

    def __init__(
        self,
        *,
        image: builtins.str,
        args: typing.Optional[typing.Sequence[builtins.str]] = None,
        command: typing.Optional[typing.Sequence[builtins.str]] = None,
        env_from: typing.Optional[typing.Sequence["EnvFrom"]] = None,
        env_variables: typing.Optional[typing.Mapping[builtins.str, "EnvValue"]] = None,
        image_pull_policy: typing.Optional["ImagePullPolicy"] = None,
        lifecycle: typing.Optional[typing.Union["ContainerLifecycle", typing.Dict[builtins.str, typing.Any]]] = None,
        liveness: typing.Optional["Probe"] = None,
        name: typing.Optional[builtins.str] = None,
        port: typing.Optional[jsii.Number] = None,
        port_number: typing.Optional[jsii.Number] = None,
        ports: typing.Optional[typing.Sequence[typing.Union["ContainerPort", typing.Dict[builtins.str, typing.Any]]]] = None,
        readiness: typing.Optional["Probe"] = None,
        resources: typing.Optional[typing.Union["ContainerResources", typing.Dict[builtins.str, typing.Any]]] = None,
        security_context: typing.Optional[typing.Union["ContainerSecurityContextProps", typing.Dict[builtins.str, typing.Any]]] = None,
        startup: typing.Optional["Probe"] = None,
        volume_mounts: typing.Optional[typing.Sequence[typing.Union["VolumeMount", typing.Dict[builtins.str, typing.Any]]]] = None,
        working_dir: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param image: Docker image name.
        :param args: Arguments to the entrypoint. The docker image's CMD is used if ``command`` is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. Default: []
        :param command: Entrypoint array. Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell Default: - The docker image's ENTRYPOINT.
        :param env_from: List of sources to populate environment variables in the container. When a key exists in multiple sources, the value associated with the last source will take precedence. Values defined by the ``envVariables`` property with a duplicate key will take precedence. Default: - No sources.
        :param env_variables: Environment variables to set in the container. Default: - No environment variables.
        :param image_pull_policy: Image pull policy for this container. Default: ImagePullPolicy.ALWAYS
        :param lifecycle: Describes actions that the management system should take in response to container lifecycle events.
        :param liveness: Periodic probe of container liveness. Container will be restarted if the probe fails. Default: - no liveness probe is defined
        :param name: Name of the container specified as a DNS_LABEL. Each container in a pod must have a unique name (DNS_LABEL). Cannot be updated. Default: 'main'
        :param port: 
        :param port_number: Number of port to expose on the pod's IP address. This must be a valid port number, 0 < x < 65536. This is a convinience property if all you need a single TCP numbered port. In case more advanced configuartion is required, use the ``ports`` property. This port is added to the list of ports mentioned in the ``ports`` property. Default: - Only the ports mentiond in the ``ports`` property are exposed.
        :param ports: List of ports to expose from this container. Default: - Only the port mentioned in the ``portNumber`` property is exposed.
        :param readiness: Determines when the container is ready to serve traffic. Default: - no readiness probe is defined
        :param resources: Compute resources (CPU and memory requests and limits) required by the container. Default: cpu: request: 1000 millis limit: 1500 millis memory: request: 512 mebibytes limit: 2048 mebibytes
        :param security_context: SecurityContext defines the security options the container should be run with. If set, the fields override equivalent fields of the pod's security context. Default: ensureNonRoot: true privileged: false readOnlyRootFilesystem: true allowPrivilegeEscalation: false user: 25000 group: 26000
        :param startup: StartupProbe indicates that the Pod has successfully initialized. If specified, no other probes are executed until this completes successfully Default: - If a port is provided, then knocks on that port to determine when the container is ready for readiness and liveness probe checks. Otherwise, no startup probe is defined.
        :param volume_mounts: Pod volumes to mount into the container's filesystem. Cannot be updated.
        :param working_dir: Container's working directory. If not specified, the container runtime's default will be used, which might be configured in the container image. Cannot be updated. Default: - The container runtime's default.
        '''
        props = ContainerProps(
            image=image,
            args=args,
            command=command,
            env_from=env_from,
            env_variables=env_variables,
            image_pull_policy=image_pull_policy,
            lifecycle=lifecycle,
            liveness=liveness,
            name=name,
            port=port,
            port_number=port_number,
            ports=ports,
            readiness=readiness,
            resources=resources,
            security_context=security_context,
            startup=startup,
            volume_mounts=volume_mounts,
            working_dir=working_dir,
        )

        jsii.create(self.__class__, self, [props])

    @jsii.member(jsii_name="addPort")
    def add_port(
        self,
        *,
        number: jsii.Number,
        host_ip: typing.Optional[builtins.str] = None,
        host_port: typing.Optional[jsii.Number] = None,
        name: typing.Optional[builtins.str] = None,
        protocol: typing.Optional["Protocol"] = None,
    ) -> None:
        '''Add a port to expose from this container.

        :param number: Number of port to expose on the pod's IP address. This must be a valid port number, 0 < x < 65536.
        :param host_ip: What host IP to bind the external port to. Default: - 127.0.0.1.
        :param host_port: Number of port to expose on the host. If specified, this must be a valid port number, 0 < x < 65536. Most containers do not need this. Default: - auto generated by kubernetes and might change on restarts.
        :param name: If specified, this must be an IANA_SVC_NAME and unique within the pod. Each named port in a pod must have a unique name. Name for the port that can be referred to by services. Default: - port is not named.
        :param protocol: Protocol for port. Must be UDP, TCP, or SCTP. Defaults to "TCP". Default: Protocol.TCP
        '''
        port = ContainerPort(
            number=number,
            host_ip=host_ip,
            host_port=host_port,
            name=name,
            protocol=protocol,
        )

        return typing.cast(None, jsii.invoke(self, "addPort", [port]))

    @jsii.member(jsii_name="mount")
    def mount(
        self,
        path: builtins.str,
        storage: "IStorage",
        *,
        propagation: typing.Optional["MountPropagation"] = None,
        read_only: typing.Optional[builtins.bool] = None,
        sub_path: typing.Optional[builtins.str] = None,
        sub_path_expr: typing.Optional[builtins.str] = None,
    ) -> None:
        '''Mount a volume to a specific path so that it is accessible by the container.

        Every pod that is configured to use this container will autmoatically have access to the volume.

        :param path: - The desired path in the container.
        :param storage: - The storage to mount.
        :param propagation: Determines how mounts are propagated from the host to container and the other way around. When not set, MountPropagationNone is used. Mount propagation allows for sharing volumes mounted by a Container to other Containers in the same Pod, or even to other Pods on the same node. Default: MountPropagation.NONE
        :param read_only: Mounted read-only if true, read-write otherwise (false or unspecified). Defaults to false. Default: false
        :param sub_path: Path within the volume from which the container's volume should be mounted.). Default: "" the volume's root
        :param sub_path_expr: Expanded path within the volume from which the container's volume should be mounted. Behaves similarly to SubPath but environment variable references $(VAR_NAME) are expanded using the container's environment. Defaults to "" (volume's root). ``subPathExpr`` and ``subPath`` are mutually exclusive. Default: "" volume's root.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0becfd5840e20c83bd173b1ccddb4c5f7357e87364d77f275e2a8ff65a598c76)
            check_type(argname="argument path", value=path, expected_type=type_hints["path"])
            check_type(argname="argument storage", value=storage, expected_type=type_hints["storage"])
        options = MountOptions(
            propagation=propagation,
            read_only=read_only,
            sub_path=sub_path,
            sub_path_expr=sub_path_expr,
        )

        return typing.cast(None, jsii.invoke(self, "mount", [path, storage, options]))

    @builtins.property
    @jsii.member(jsii_name="env")
    def env(self) -> "Env":
        '''The environment of the container.'''
        return typing.cast("Env", jsii.get(self, "env"))

    @builtins.property
    @jsii.member(jsii_name="image")
    def image(self) -> builtins.str:
        '''The container image.'''
        return typing.cast(builtins.str, jsii.get(self, "image"))

    @builtins.property
    @jsii.member(jsii_name="imagePullPolicy")
    def image_pull_policy(self) -> "ImagePullPolicy":
        '''Image pull policy for this container.'''
        return typing.cast("ImagePullPolicy", jsii.get(self, "imagePullPolicy"))

    @builtins.property
    @jsii.member(jsii_name="mounts")
    def mounts(self) -> typing.List["VolumeMount"]:
        '''Volume mounts configured for this container.'''
        return typing.cast(typing.List["VolumeMount"], jsii.get(self, "mounts"))

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        '''The name of the container.'''
        return typing.cast(builtins.str, jsii.get(self, "name"))

    @builtins.property
    @jsii.member(jsii_name="ports")
    def ports(self) -> typing.List["ContainerPort"]:
        '''Ports exposed by this containers.

        Returns a copy, use ``addPort`` to modify.
        '''
        return typing.cast(typing.List["ContainerPort"], jsii.get(self, "ports"))

    @builtins.property
    @jsii.member(jsii_name="securityContext")
    def security_context(self) -> "ContainerSecurityContext":
        '''The security context of the container.'''
        return typing.cast("ContainerSecurityContext", jsii.get(self, "securityContext"))

    @builtins.property
    @jsii.member(jsii_name="args")
    def args(self) -> typing.Optional[typing.List[builtins.str]]:
        '''Arguments to the entrypoint.

        :return: a copy of the arguments array, cannot be modified.
        '''
        return typing.cast(typing.Optional[typing.List[builtins.str]], jsii.get(self, "args"))

    @builtins.property
    @jsii.member(jsii_name="command")
    def command(self) -> typing.Optional[typing.List[builtins.str]]:
        '''Entrypoint array (the command to execute when the container starts).

        :return: a copy of the entrypoint array, cannot be modified
        '''
        return typing.cast(typing.Optional[typing.List[builtins.str]], jsii.get(self, "command"))

    @builtins.property
    @jsii.member(jsii_name="port")
    def port(self) -> typing.Optional[jsii.Number]:
        '''
        :deprecated: - use ``portNumber``.

        :stability: deprecated
        '''
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "port"))

    @builtins.property
    @jsii.member(jsii_name="portNumber")
    def port_number(self) -> typing.Optional[jsii.Number]:
        '''The port number that was configured for this container.

        If undefined, either the container doesn't expose a port, or its
        port configuration is stored in the ``ports`` field.
        '''
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "portNumber"))

    @builtins.property
    @jsii.member(jsii_name="resources")
    def resources(self) -> typing.Optional["ContainerResources"]:
        '''Compute resources (CPU and memory requests and limits) required by the container.

        :see: https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/
        '''
        return typing.cast(typing.Optional["ContainerResources"], jsii.get(self, "resources"))

    @builtins.property
    @jsii.member(jsii_name="workingDir")
    def working_dir(self) -> typing.Optional[builtins.str]:
        '''The working directory inside the container.'''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "workingDir"))


@jsii.data_type(
    jsii_type="cdk8s-plus-24.ContainerLifecycle",
    jsii_struct_bases=[],
    name_mapping={"post_start": "postStart", "pre_stop": "preStop"},
)
class ContainerLifecycle:
    def __init__(
        self,
        *,
        post_start: typing.Optional["Handler"] = None,
        pre_stop: typing.Optional["Handler"] = None,
    ) -> None:
        '''Container lifecycle properties.

        :param post_start: This hook is executed immediately after a container is created. However, there is no guarantee that the hook will execute before the container ENTRYPOINT. Default: - No post start handler.
        :param pre_stop: This hook is called immediately before a container is terminated due to an API request or management event such as a liveness/startup probe failure, preemption, resource contention and others. A call to the PreStop hook fails if the container is already in a terminated or completed state and the hook must complete before the TERM signal to stop the container can be sent. The Pod's termination grace period countdown begins before the PreStop hook is executed, so regardless of the outcome of the handler, the container will eventually terminate within the Pod's termination grace period. No parameters are passed to the handler. Default: - No pre stop handler.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a6d71ab027725dd9cc5b10d4344941de31b80f07065704d73da958774a4fd1d9)
            check_type(argname="argument post_start", value=post_start, expected_type=type_hints["post_start"])
            check_type(argname="argument pre_stop", value=pre_stop, expected_type=type_hints["pre_stop"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if post_start is not None:
            self._values["post_start"] = post_start
        if pre_stop is not None:
            self._values["pre_stop"] = pre_stop

    @builtins.property
    def post_start(self) -> typing.Optional["Handler"]:
        '''This hook is executed immediately after a container is created.

        However,
        there is no guarantee that the hook will execute before the container ENTRYPOINT.

        :default: - No post start handler.
        '''
        result = self._values.get("post_start")
        return typing.cast(typing.Optional["Handler"], result)

    @builtins.property
    def pre_stop(self) -> typing.Optional["Handler"]:
        '''This hook is called immediately before a container is terminated due to an API request or management event such as a liveness/startup probe failure, preemption, resource contention and others.

        A call to the PreStop hook fails if the container is already in a terminated or completed state
        and the hook must complete before the TERM signal to stop the container can be sent.
        The Pod's termination grace period countdown begins before the PreStop hook is executed,
        so regardless of the outcome of the handler, the container will eventually terminate
        within the Pod's termination grace period. No parameters are passed to the handler.

        :default: - No pre stop handler.

        :see: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle/#pod-termination
        '''
        result = self._values.get("pre_stop")
        return typing.cast(typing.Optional["Handler"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ContainerLifecycle(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.ContainerOpts",
    jsii_struct_bases=[],
    name_mapping={
        "args": "args",
        "command": "command",
        "env_from": "envFrom",
        "env_variables": "envVariables",
        "image_pull_policy": "imagePullPolicy",
        "lifecycle": "lifecycle",
        "liveness": "liveness",
        "name": "name",
        "port": "port",
        "port_number": "portNumber",
        "ports": "ports",
        "readiness": "readiness",
        "resources": "resources",
        "security_context": "securityContext",
        "startup": "startup",
        "volume_mounts": "volumeMounts",
        "working_dir": "workingDir",
    },
)
class ContainerOpts:
    def __init__(
        self,
        *,
        args: typing.Optional[typing.Sequence[builtins.str]] = None,
        command: typing.Optional[typing.Sequence[builtins.str]] = None,
        env_from: typing.Optional[typing.Sequence["EnvFrom"]] = None,
        env_variables: typing.Optional[typing.Mapping[builtins.str, "EnvValue"]] = None,
        image_pull_policy: typing.Optional["ImagePullPolicy"] = None,
        lifecycle: typing.Optional[typing.Union[ContainerLifecycle, typing.Dict[builtins.str, typing.Any]]] = None,
        liveness: typing.Optional["Probe"] = None,
        name: typing.Optional[builtins.str] = None,
        port: typing.Optional[jsii.Number] = None,
        port_number: typing.Optional[jsii.Number] = None,
        ports: typing.Optional[typing.Sequence[typing.Union["ContainerPort", typing.Dict[builtins.str, typing.Any]]]] = None,
        readiness: typing.Optional["Probe"] = None,
        resources: typing.Optional[typing.Union["ContainerResources", typing.Dict[builtins.str, typing.Any]]] = None,
        security_context: typing.Optional[typing.Union["ContainerSecurityContextProps", typing.Dict[builtins.str, typing.Any]]] = None,
        startup: typing.Optional["Probe"] = None,
        volume_mounts: typing.Optional[typing.Sequence[typing.Union["VolumeMount", typing.Dict[builtins.str, typing.Any]]]] = None,
        working_dir: typing.Optional[builtins.str] = None,
    ) -> None:
        '''Optional properties of a container.

        :param args: Arguments to the entrypoint. The docker image's CMD is used if ``command`` is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. Default: []
        :param command: Entrypoint array. Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell Default: - The docker image's ENTRYPOINT.
        :param env_from: List of sources to populate environment variables in the container. When a key exists in multiple sources, the value associated with the last source will take precedence. Values defined by the ``envVariables`` property with a duplicate key will take precedence. Default: - No sources.
        :param env_variables: Environment variables to set in the container. Default: - No environment variables.
        :param image_pull_policy: Image pull policy for this container. Default: ImagePullPolicy.ALWAYS
        :param lifecycle: Describes actions that the management system should take in response to container lifecycle events.
        :param liveness: Periodic probe of container liveness. Container will be restarted if the probe fails. Default: - no liveness probe is defined
        :param name: Name of the container specified as a DNS_LABEL. Each container in a pod must have a unique name (DNS_LABEL). Cannot be updated. Default: 'main'
        :param port: 
        :param port_number: Number of port to expose on the pod's IP address. This must be a valid port number, 0 < x < 65536. This is a convinience property if all you need a single TCP numbered port. In case more advanced configuartion is required, use the ``ports`` property. This port is added to the list of ports mentioned in the ``ports`` property. Default: - Only the ports mentiond in the ``ports`` property are exposed.
        :param ports: List of ports to expose from this container. Default: - Only the port mentioned in the ``portNumber`` property is exposed.
        :param readiness: Determines when the container is ready to serve traffic. Default: - no readiness probe is defined
        :param resources: Compute resources (CPU and memory requests and limits) required by the container. Default: cpu: request: 1000 millis limit: 1500 millis memory: request: 512 mebibytes limit: 2048 mebibytes
        :param security_context: SecurityContext defines the security options the container should be run with. If set, the fields override equivalent fields of the pod's security context. Default: ensureNonRoot: true privileged: false readOnlyRootFilesystem: true allowPrivilegeEscalation: false user: 25000 group: 26000
        :param startup: StartupProbe indicates that the Pod has successfully initialized. If specified, no other probes are executed until this completes successfully Default: - If a port is provided, then knocks on that port to determine when the container is ready for readiness and liveness probe checks. Otherwise, no startup probe is defined.
        :param volume_mounts: Pod volumes to mount into the container's filesystem. Cannot be updated.
        :param working_dir: Container's working directory. If not specified, the container runtime's default will be used, which might be configured in the container image. Cannot be updated. Default: - The container runtime's default.
        '''
        if isinstance(lifecycle, dict):
            lifecycle = ContainerLifecycle(**lifecycle)
        if isinstance(resources, dict):
            resources = ContainerResources(**resources)
        if isinstance(security_context, dict):
            security_context = ContainerSecurityContextProps(**security_context)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6ba37264e8cb9ad706642769031712917bc326df21c0c190664fc3ff2306fe8b)
            check_type(argname="argument args", value=args, expected_type=type_hints["args"])
            check_type(argname="argument command", value=command, expected_type=type_hints["command"])
            check_type(argname="argument env_from", value=env_from, expected_type=type_hints["env_from"])
            check_type(argname="argument env_variables", value=env_variables, expected_type=type_hints["env_variables"])
            check_type(argname="argument image_pull_policy", value=image_pull_policy, expected_type=type_hints["image_pull_policy"])
            check_type(argname="argument lifecycle", value=lifecycle, expected_type=type_hints["lifecycle"])
            check_type(argname="argument liveness", value=liveness, expected_type=type_hints["liveness"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument port", value=port, expected_type=type_hints["port"])
            check_type(argname="argument port_number", value=port_number, expected_type=type_hints["port_number"])
            check_type(argname="argument ports", value=ports, expected_type=type_hints["ports"])
            check_type(argname="argument readiness", value=readiness, expected_type=type_hints["readiness"])
            check_type(argname="argument resources", value=resources, expected_type=type_hints["resources"])
            check_type(argname="argument security_context", value=security_context, expected_type=type_hints["security_context"])
            check_type(argname="argument startup", value=startup, expected_type=type_hints["startup"])
            check_type(argname="argument volume_mounts", value=volume_mounts, expected_type=type_hints["volume_mounts"])
            check_type(argname="argument working_dir", value=working_dir, expected_type=type_hints["working_dir"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if args is not None:
            self._values["args"] = args
        if command is not None:
            self._values["command"] = command
        if env_from is not None:
            self._values["env_from"] = env_from
        if env_variables is not None:
            self._values["env_variables"] = env_variables
        if image_pull_policy is not None:
            self._values["image_pull_policy"] = image_pull_policy
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if liveness is not None:
            self._values["liveness"] = liveness
        if name is not None:
            self._values["name"] = name
        if port is not None:
            self._values["port"] = port
        if port_number is not None:
            self._values["port_number"] = port_number
        if ports is not None:
            self._values["ports"] = ports
        if readiness is not None:
            self._values["readiness"] = readiness
        if resources is not None:
            self._values["resources"] = resources
        if security_context is not None:
            self._values["security_context"] = security_context
        if startup is not None:
            self._values["startup"] = startup
        if volume_mounts is not None:
            self._values["volume_mounts"] = volume_mounts
        if working_dir is not None:
            self._values["working_dir"] = working_dir

    @builtins.property
    def args(self) -> typing.Optional[typing.List[builtins.str]]:
        '''Arguments to the entrypoint. The docker image's CMD is used if ``command`` is not provided.

        Variable references $(VAR_NAME) are expanded using the container's
        environment. If a variable cannot be resolved, the reference in the input
        string will be unchanged. The $(VAR_NAME) syntax can be escaped with a
        double $$, ie: $$(VAR_NAME). Escaped references will never be expanded,
        regardless of whether the variable exists or not.

        Cannot be updated.

        :default: []

        :see: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
        '''
        result = self._values.get("args")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def command(self) -> typing.Optional[typing.List[builtins.str]]:
        '''Entrypoint array.

        Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment.
        If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME).
        Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated.
        More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell

        :default: - The docker image's ENTRYPOINT.
        '''
        result = self._values.get("command")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def env_from(self) -> typing.Optional[typing.List["EnvFrom"]]:
        '''List of sources to populate environment variables in the container.

        When a key exists in multiple sources, the value associated with
        the last source will take precedence. Values defined by the ``envVariables`` property
        with a duplicate key will take precedence.

        :default: - No sources.
        '''
        result = self._values.get("env_from")
        return typing.cast(typing.Optional[typing.List["EnvFrom"]], result)

    @builtins.property
    def env_variables(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, "EnvValue"]]:
        '''Environment variables to set in the container.

        :default: - No environment variables.
        '''
        result = self._values.get("env_variables")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, "EnvValue"]], result)

    @builtins.property
    def image_pull_policy(self) -> typing.Optional["ImagePullPolicy"]:
        '''Image pull policy for this container.

        :default: ImagePullPolicy.ALWAYS
        '''
        result = self._values.get("image_pull_policy")
        return typing.cast(typing.Optional["ImagePullPolicy"], result)

    @builtins.property
    def lifecycle(self) -> typing.Optional[ContainerLifecycle]:
        '''Describes actions that the management system should take in response to container lifecycle events.'''
        result = self._values.get("lifecycle")
        return typing.cast(typing.Optional[ContainerLifecycle], result)

    @builtins.property
    def liveness(self) -> typing.Optional["Probe"]:
        '''Periodic probe of container liveness.

        Container will be restarted if the probe fails.

        :default: - no liveness probe is defined
        '''
        result = self._values.get("liveness")
        return typing.cast(typing.Optional["Probe"], result)

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''Name of the container specified as a DNS_LABEL.

        Each container in a pod must have a unique name (DNS_LABEL). Cannot be updated.

        :default: 'main'
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def port(self) -> typing.Optional[jsii.Number]:
        '''
        :deprecated: - use ``portNumber``.

        :stability: deprecated
        '''
        result = self._values.get("port")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def port_number(self) -> typing.Optional[jsii.Number]:
        '''Number of port to expose on the pod's IP address.

        This must be a valid port number, 0 < x < 65536.

        This is a convinience property if all you need a single TCP numbered port.
        In case more advanced configuartion is required, use the ``ports`` property.

        This port is added to the list of ports mentioned in the ``ports`` property.

        :default: - Only the ports mentiond in the ``ports`` property are exposed.
        '''
        result = self._values.get("port_number")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def ports(self) -> typing.Optional[typing.List["ContainerPort"]]:
        '''List of ports to expose from this container.

        :default: - Only the port mentioned in the ``portNumber`` property is exposed.
        '''
        result = self._values.get("ports")
        return typing.cast(typing.Optional[typing.List["ContainerPort"]], result)

    @builtins.property
    def readiness(self) -> typing.Optional["Probe"]:
        '''Determines when the container is ready to serve traffic.

        :default: - no readiness probe is defined
        '''
        result = self._values.get("readiness")
        return typing.cast(typing.Optional["Probe"], result)

    @builtins.property
    def resources(self) -> typing.Optional["ContainerResources"]:
        '''Compute resources (CPU and memory requests and limits) required by the container.

        :default:

        cpu:
        request: 1000 millis
        limit: 1500 millis
        memory:
        request: 512 mebibytes
        limit: 2048 mebibytes

        :see: https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/
        '''
        result = self._values.get("resources")
        return typing.cast(typing.Optional["ContainerResources"], result)

    @builtins.property
    def security_context(self) -> typing.Optional["ContainerSecurityContextProps"]:
        '''SecurityContext defines the security options the container should be run with.

        If set, the fields override equivalent fields of the pod's security context.

        :default:

        ensureNonRoot: true
        privileged: false
        readOnlyRootFilesystem: true
        allowPrivilegeEscalation: false
        user: 25000
        group: 26000

        :see: https://kubernetes.io/docs/tasks/configure-pod-container/security-context/
        '''
        result = self._values.get("security_context")
        return typing.cast(typing.Optional["ContainerSecurityContextProps"], result)

    @builtins.property
    def startup(self) -> typing.Optional["Probe"]:
        '''StartupProbe indicates that the Pod has successfully initialized.

        If specified, no other probes are executed until this completes successfully

        :default:

        - If a port is provided, then knocks on that port
        to determine when the container is ready for readiness and
        liveness probe checks.
        Otherwise, no startup probe is defined.
        '''
        result = self._values.get("startup")
        return typing.cast(typing.Optional["Probe"], result)

    @builtins.property
    def volume_mounts(self) -> typing.Optional[typing.List["VolumeMount"]]:
        '''Pod volumes to mount into the container's filesystem.

        Cannot be updated.
        '''
        result = self._values.get("volume_mounts")
        return typing.cast(typing.Optional[typing.List["VolumeMount"]], result)

    @builtins.property
    def working_dir(self) -> typing.Optional[builtins.str]:
        '''Container's working directory.

        If not specified, the container runtime's default will be used, which might be configured in the container image. Cannot be updated.

        :default: - The container runtime's default.
        '''
        result = self._values.get("working_dir")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ContainerOpts(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.ContainerPort",
    jsii_struct_bases=[],
    name_mapping={
        "number": "number",
        "host_ip": "hostIp",
        "host_port": "hostPort",
        "name": "name",
        "protocol": "protocol",
    },
)
class ContainerPort:
    def __init__(
        self,
        *,
        number: jsii.Number,
        host_ip: typing.Optional[builtins.str] = None,
        host_port: typing.Optional[jsii.Number] = None,
        name: typing.Optional[builtins.str] = None,
        protocol: typing.Optional["Protocol"] = None,
    ) -> None:
        '''Represents a network port in a single container.

        :param number: Number of port to expose on the pod's IP address. This must be a valid port number, 0 < x < 65536.
        :param host_ip: What host IP to bind the external port to. Default: - 127.0.0.1.
        :param host_port: Number of port to expose on the host. If specified, this must be a valid port number, 0 < x < 65536. Most containers do not need this. Default: - auto generated by kubernetes and might change on restarts.
        :param name: If specified, this must be an IANA_SVC_NAME and unique within the pod. Each named port in a pod must have a unique name. Name for the port that can be referred to by services. Default: - port is not named.
        :param protocol: Protocol for port. Must be UDP, TCP, or SCTP. Defaults to "TCP". Default: Protocol.TCP
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8f0b9fd1a11a4d3841cbb67ee9f1c83f8a9771a47a2effe9c67d1ea522c7f530)
            check_type(argname="argument number", value=number, expected_type=type_hints["number"])
            check_type(argname="argument host_ip", value=host_ip, expected_type=type_hints["host_ip"])
            check_type(argname="argument host_port", value=host_port, expected_type=type_hints["host_port"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument protocol", value=protocol, expected_type=type_hints["protocol"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "number": number,
        }
        if host_ip is not None:
            self._values["host_ip"] = host_ip
        if host_port is not None:
            self._values["host_port"] = host_port
        if name is not None:
            self._values["name"] = name
        if protocol is not None:
            self._values["protocol"] = protocol

    @builtins.property
    def number(self) -> jsii.Number:
        '''Number of port to expose on the pod's IP address.

        This must be a valid port number, 0 < x < 65536.
        '''
        result = self._values.get("number")
        assert result is not None, "Required property 'number' is missing"
        return typing.cast(jsii.Number, result)

    @builtins.property
    def host_ip(self) -> typing.Optional[builtins.str]:
        '''What host IP to bind the external port to.

        :default: - 127.0.0.1.
        '''
        result = self._values.get("host_ip")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def host_port(self) -> typing.Optional[jsii.Number]:
        '''Number of port to expose on the host.

        If specified, this must be a valid port number, 0 < x < 65536.
        Most containers do not need this.

        :default: - auto generated by kubernetes and might change on restarts.
        '''
        result = self._values.get("host_port")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''If specified, this must be an IANA_SVC_NAME and unique within the pod.

        Each named port in a pod must have a unique name.
        Name for the port that can be referred to by services.

        :default: - port is not named.
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def protocol(self) -> typing.Optional["Protocol"]:
        '''Protocol for port.

        Must be UDP, TCP, or SCTP. Defaults to "TCP".

        :default: Protocol.TCP
        '''
        result = self._values.get("protocol")
        return typing.cast(typing.Optional["Protocol"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ContainerPort(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.ContainerProps",
    jsii_struct_bases=[ContainerOpts],
    name_mapping={
        "args": "args",
        "command": "command",
        "env_from": "envFrom",
        "env_variables": "envVariables",
        "image_pull_policy": "imagePullPolicy",
        "lifecycle": "lifecycle",
        "liveness": "liveness",
        "name": "name",
        "port": "port",
        "port_number": "portNumber",
        "ports": "ports",
        "readiness": "readiness",
        "resources": "resources",
        "security_context": "securityContext",
        "startup": "startup",
        "volume_mounts": "volumeMounts",
        "working_dir": "workingDir",
        "image": "image",
    },
)
class ContainerProps(ContainerOpts):
    def __init__(
        self,
        *,
        args: typing.Optional[typing.Sequence[builtins.str]] = None,
        command: typing.Optional[typing.Sequence[builtins.str]] = None,
        env_from: typing.Optional[typing.Sequence["EnvFrom"]] = None,
        env_variables: typing.Optional[typing.Mapping[builtins.str, "EnvValue"]] = None,
        image_pull_policy: typing.Optional["ImagePullPolicy"] = None,
        lifecycle: typing.Optional[typing.Union[ContainerLifecycle, typing.Dict[builtins.str, typing.Any]]] = None,
        liveness: typing.Optional["Probe"] = None,
        name: typing.Optional[builtins.str] = None,
        port: typing.Optional[jsii.Number] = None,
        port_number: typing.Optional[jsii.Number] = None,
        ports: typing.Optional[typing.Sequence[typing.Union[ContainerPort, typing.Dict[builtins.str, typing.Any]]]] = None,
        readiness: typing.Optional["Probe"] = None,
        resources: typing.Optional[typing.Union["ContainerResources", typing.Dict[builtins.str, typing.Any]]] = None,
        security_context: typing.Optional[typing.Union["ContainerSecurityContextProps", typing.Dict[builtins.str, typing.Any]]] = None,
        startup: typing.Optional["Probe"] = None,
        volume_mounts: typing.Optional[typing.Sequence[typing.Union["VolumeMount", typing.Dict[builtins.str, typing.Any]]]] = None,
        working_dir: typing.Optional[builtins.str] = None,
        image: builtins.str,
    ) -> None:
        '''Properties for creating a container.

        :param args: Arguments to the entrypoint. The docker image's CMD is used if ``command`` is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. Default: []
        :param command: Entrypoint array. Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell Default: - The docker image's ENTRYPOINT.
        :param env_from: List of sources to populate environment variables in the container. When a key exists in multiple sources, the value associated with the last source will take precedence. Values defined by the ``envVariables`` property with a duplicate key will take precedence. Default: - No sources.
        :param env_variables: Environment variables to set in the container. Default: - No environment variables.
        :param image_pull_policy: Image pull policy for this container. Default: ImagePullPolicy.ALWAYS
        :param lifecycle: Describes actions that the management system should take in response to container lifecycle events.
        :param liveness: Periodic probe of container liveness. Container will be restarted if the probe fails. Default: - no liveness probe is defined
        :param name: Name of the container specified as a DNS_LABEL. Each container in a pod must have a unique name (DNS_LABEL). Cannot be updated. Default: 'main'
        :param port: 
        :param port_number: Number of port to expose on the pod's IP address. This must be a valid port number, 0 < x < 65536. This is a convinience property if all you need a single TCP numbered port. In case more advanced configuartion is required, use the ``ports`` property. This port is added to the list of ports mentioned in the ``ports`` property. Default: - Only the ports mentiond in the ``ports`` property are exposed.
        :param ports: List of ports to expose from this container. Default: - Only the port mentioned in the ``portNumber`` property is exposed.
        :param readiness: Determines when the container is ready to serve traffic. Default: - no readiness probe is defined
        :param resources: Compute resources (CPU and memory requests and limits) required by the container. Default: cpu: request: 1000 millis limit: 1500 millis memory: request: 512 mebibytes limit: 2048 mebibytes
        :param security_context: SecurityContext defines the security options the container should be run with. If set, the fields override equivalent fields of the pod's security context. Default: ensureNonRoot: true privileged: false readOnlyRootFilesystem: true allowPrivilegeEscalation: false user: 25000 group: 26000
        :param startup: StartupProbe indicates that the Pod has successfully initialized. If specified, no other probes are executed until this completes successfully Default: - If a port is provided, then knocks on that port to determine when the container is ready for readiness and liveness probe checks. Otherwise, no startup probe is defined.
        :param volume_mounts: Pod volumes to mount into the container's filesystem. Cannot be updated.
        :param working_dir: Container's working directory. If not specified, the container runtime's default will be used, which might be configured in the container image. Cannot be updated. Default: - The container runtime's default.
        :param image: Docker image name.
        '''
        if isinstance(lifecycle, dict):
            lifecycle = ContainerLifecycle(**lifecycle)
        if isinstance(resources, dict):
            resources = ContainerResources(**resources)
        if isinstance(security_context, dict):
            security_context = ContainerSecurityContextProps(**security_context)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2699b60ff21cefcecb7275e8e05cf3a9de7c16b52d612e7a43d07fb02e52c20a)
            check_type(argname="argument args", value=args, expected_type=type_hints["args"])
            check_type(argname="argument command", value=command, expected_type=type_hints["command"])
            check_type(argname="argument env_from", value=env_from, expected_type=type_hints["env_from"])
            check_type(argname="argument env_variables", value=env_variables, expected_type=type_hints["env_variables"])
            check_type(argname="argument image_pull_policy", value=image_pull_policy, expected_type=type_hints["image_pull_policy"])
            check_type(argname="argument lifecycle", value=lifecycle, expected_type=type_hints["lifecycle"])
            check_type(argname="argument liveness", value=liveness, expected_type=type_hints["liveness"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument port", value=port, expected_type=type_hints["port"])
            check_type(argname="argument port_number", value=port_number, expected_type=type_hints["port_number"])
            check_type(argname="argument ports", value=ports, expected_type=type_hints["ports"])
            check_type(argname="argument readiness", value=readiness, expected_type=type_hints["readiness"])
            check_type(argname="argument resources", value=resources, expected_type=type_hints["resources"])
            check_type(argname="argument security_context", value=security_context, expected_type=type_hints["security_context"])
            check_type(argname="argument startup", value=startup, expected_type=type_hints["startup"])
            check_type(argname="argument volume_mounts", value=volume_mounts, expected_type=type_hints["volume_mounts"])
            check_type(argname="argument working_dir", value=working_dir, expected_type=type_hints["working_dir"])
            check_type(argname="argument image", value=image, expected_type=type_hints["image"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "image": image,
        }
        if args is not None:
            self._values["args"] = args
        if command is not None:
            self._values["command"] = command
        if env_from is not None:
            self._values["env_from"] = env_from
        if env_variables is not None:
            self._values["env_variables"] = env_variables
        if image_pull_policy is not None:
            self._values["image_pull_policy"] = image_pull_policy
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if liveness is not None:
            self._values["liveness"] = liveness
        if name is not None:
            self._values["name"] = name
        if port is not None:
            self._values["port"] = port
        if port_number is not None:
            self._values["port_number"] = port_number
        if ports is not None:
            self._values["ports"] = ports
        if readiness is not None:
            self._values["readiness"] = readiness
        if resources is not None:
            self._values["resources"] = resources
        if security_context is not None:
            self._values["security_context"] = security_context
        if startup is not None:
            self._values["startup"] = startup
        if volume_mounts is not None:
            self._values["volume_mounts"] = volume_mounts
        if working_dir is not None:
            self._values["working_dir"] = working_dir

    @builtins.property
    def args(self) -> typing.Optional[typing.List[builtins.str]]:
        '''Arguments to the entrypoint. The docker image's CMD is used if ``command`` is not provided.

        Variable references $(VAR_NAME) are expanded using the container's
        environment. If a variable cannot be resolved, the reference in the input
        string will be unchanged. The $(VAR_NAME) syntax can be escaped with a
        double $$, ie: $$(VAR_NAME). Escaped references will never be expanded,
        regardless of whether the variable exists or not.

        Cannot be updated.

        :default: []

        :see: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
        '''
        result = self._values.get("args")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def command(self) -> typing.Optional[typing.List[builtins.str]]:
        '''Entrypoint array.

        Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment.
        If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME).
        Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated.
        More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell

        :default: - The docker image's ENTRYPOINT.
        '''
        result = self._values.get("command")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def env_from(self) -> typing.Optional[typing.List["EnvFrom"]]:
        '''List of sources to populate environment variables in the container.

        When a key exists in multiple sources, the value associated with
        the last source will take precedence. Values defined by the ``envVariables`` property
        with a duplicate key will take precedence.

        :default: - No sources.
        '''
        result = self._values.get("env_from")
        return typing.cast(typing.Optional[typing.List["EnvFrom"]], result)

    @builtins.property
    def env_variables(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, "EnvValue"]]:
        '''Environment variables to set in the container.

        :default: - No environment variables.
        '''
        result = self._values.get("env_variables")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, "EnvValue"]], result)

    @builtins.property
    def image_pull_policy(self) -> typing.Optional["ImagePullPolicy"]:
        '''Image pull policy for this container.

        :default: ImagePullPolicy.ALWAYS
        '''
        result = self._values.get("image_pull_policy")
        return typing.cast(typing.Optional["ImagePullPolicy"], result)

    @builtins.property
    def lifecycle(self) -> typing.Optional[ContainerLifecycle]:
        '''Describes actions that the management system should take in response to container lifecycle events.'''
        result = self._values.get("lifecycle")
        return typing.cast(typing.Optional[ContainerLifecycle], result)

    @builtins.property
    def liveness(self) -> typing.Optional["Probe"]:
        '''Periodic probe of container liveness.

        Container will be restarted if the probe fails.

        :default: - no liveness probe is defined
        '''
        result = self._values.get("liveness")
        return typing.cast(typing.Optional["Probe"], result)

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''Name of the container specified as a DNS_LABEL.

        Each container in a pod must have a unique name (DNS_LABEL). Cannot be updated.

        :default: 'main'
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def port(self) -> typing.Optional[jsii.Number]:
        '''
        :deprecated: - use ``portNumber``.

        :stability: deprecated
        '''
        result = self._values.get("port")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def port_number(self) -> typing.Optional[jsii.Number]:
        '''Number of port to expose on the pod's IP address.

        This must be a valid port number, 0 < x < 65536.

        This is a convinience property if all you need a single TCP numbered port.
        In case more advanced configuartion is required, use the ``ports`` property.

        This port is added to the list of ports mentioned in the ``ports`` property.

        :default: - Only the ports mentiond in the ``ports`` property are exposed.
        '''
        result = self._values.get("port_number")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def ports(self) -> typing.Optional[typing.List[ContainerPort]]:
        '''List of ports to expose from this container.

        :default: - Only the port mentioned in the ``portNumber`` property is exposed.
        '''
        result = self._values.get("ports")
        return typing.cast(typing.Optional[typing.List[ContainerPort]], result)

    @builtins.property
    def readiness(self) -> typing.Optional["Probe"]:
        '''Determines when the container is ready to serve traffic.

        :default: - no readiness probe is defined
        '''
        result = self._values.get("readiness")
        return typing.cast(typing.Optional["Probe"], result)

    @builtins.property
    def resources(self) -> typing.Optional["ContainerResources"]:
        '''Compute resources (CPU and memory requests and limits) required by the container.

        :default:

        cpu:
        request: 1000 millis
        limit: 1500 millis
        memory:
        request: 512 mebibytes
        limit: 2048 mebibytes

        :see: https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/
        '''
        result = self._values.get("resources")
        return typing.cast(typing.Optional["ContainerResources"], result)

    @builtins.property
    def security_context(self) -> typing.Optional["ContainerSecurityContextProps"]:
        '''SecurityContext defines the security options the container should be run with.

        If set, the fields override equivalent fields of the pod's security context.

        :default:

        ensureNonRoot: true
        privileged: false
        readOnlyRootFilesystem: true
        allowPrivilegeEscalation: false
        user: 25000
        group: 26000

        :see: https://kubernetes.io/docs/tasks/configure-pod-container/security-context/
        '''
        result = self._values.get("security_context")
        return typing.cast(typing.Optional["ContainerSecurityContextProps"], result)

    @builtins.property
    def startup(self) -> typing.Optional["Probe"]:
        '''StartupProbe indicates that the Pod has successfully initialized.

        If specified, no other probes are executed until this completes successfully

        :default:

        - If a port is provided, then knocks on that port
        to determine when the container is ready for readiness and
        liveness probe checks.
        Otherwise, no startup probe is defined.
        '''
        result = self._values.get("startup")
        return typing.cast(typing.Optional["Probe"], result)

    @builtins.property
    def volume_mounts(self) -> typing.Optional[typing.List["VolumeMount"]]:
        '''Pod volumes to mount into the container's filesystem.

        Cannot be updated.
        '''
        result = self._values.get("volume_mounts")
        return typing.cast(typing.Optional[typing.List["VolumeMount"]], result)

    @builtins.property
    def working_dir(self) -> typing.Optional[builtins.str]:
        '''Container's working directory.

        If not specified, the container runtime's default will be used, which might be configured in the container image. Cannot be updated.

        :default: - The container runtime's default.
        '''
        result = self._values.get("working_dir")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def image(self) -> builtins.str:
        '''Docker image name.'''
        result = self._values.get("image")
        assert result is not None, "Required property 'image' is missing"
        return typing.cast(builtins.str, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ContainerProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.ContainerResources",
    jsii_struct_bases=[],
    name_mapping={
        "cpu": "cpu",
        "ephemeral_storage": "ephemeralStorage",
        "memory": "memory",
    },
)
class ContainerResources:
    def __init__(
        self,
        *,
        cpu: typing.Optional[typing.Union["CpuResources", typing.Dict[builtins.str, typing.Any]]] = None,
        ephemeral_storage: typing.Optional[typing.Union["EphemeralStorageResources", typing.Dict[builtins.str, typing.Any]]] = None,
        memory: typing.Optional[typing.Union["MemoryResources", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''CPU and memory compute resources.

        :param cpu: 
        :param ephemeral_storage: 
        :param memory: 
        '''
        if isinstance(cpu, dict):
            cpu = CpuResources(**cpu)
        if isinstance(ephemeral_storage, dict):
            ephemeral_storage = EphemeralStorageResources(**ephemeral_storage)
        if isinstance(memory, dict):
            memory = MemoryResources(**memory)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9c1d53bb8f6f7e93fcada08268412853b9cdf94450a5dd56fdfc489b79034064)
            check_type(argname="argument cpu", value=cpu, expected_type=type_hints["cpu"])
            check_type(argname="argument ephemeral_storage", value=ephemeral_storage, expected_type=type_hints["ephemeral_storage"])
            check_type(argname="argument memory", value=memory, expected_type=type_hints["memory"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if cpu is not None:
            self._values["cpu"] = cpu
        if ephemeral_storage is not None:
            self._values["ephemeral_storage"] = ephemeral_storage
        if memory is not None:
            self._values["memory"] = memory

    @builtins.property
    def cpu(self) -> typing.Optional["CpuResources"]:
        result = self._values.get("cpu")
        return typing.cast(typing.Optional["CpuResources"], result)

    @builtins.property
    def ephemeral_storage(self) -> typing.Optional["EphemeralStorageResources"]:
        result = self._values.get("ephemeral_storage")
        return typing.cast(typing.Optional["EphemeralStorageResources"], result)

    @builtins.property
    def memory(self) -> typing.Optional["MemoryResources"]:
        result = self._values.get("memory")
        return typing.cast(typing.Optional["MemoryResources"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ContainerResources(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ContainerSecurityContext(
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-24.ContainerSecurityContext",
):
    '''Container security attributes and settings.'''

    def __init__(
        self,
        *,
        allow_privilege_escalation: typing.Optional[builtins.bool] = None,
        ensure_non_root: typing.Optional[builtins.bool] = None,
        group: typing.Optional[jsii.Number] = None,
        privileged: typing.Optional[builtins.bool] = None,
        read_only_root_filesystem: typing.Optional[builtins.bool] = None,
        user: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''
        :param allow_privilege_escalation: Whether a process can gain more privileges than its parent process. Default: false
        :param ensure_non_root: Indicates that the container must run as a non-root user. If true, the Kubelet will validate the image at runtime to ensure that it does not run as UID 0 (root) and fail to start the container if it does. Default: true
        :param group: The GID to run the entrypoint of the container process. Default: - 26000. An arbitrary number bigger than 9999 is selected here. This is so that the container is blocked to access host files even if somehow it manages to get access to host file system.
        :param privileged: Run container in privileged mode. Processes in privileged containers are essentially equivalent to root on the host. Default: false
        :param read_only_root_filesystem: Whether this container has a read-only root filesystem. Default: true
        :param user: The UID to run the entrypoint of the container process. Default: - 25000. An arbitrary number bigger than 9999 is selected here. This is so that the container is blocked to access host files even if somehow it manages to get access to host file system.
        '''
        props = ContainerSecurityContextProps(
            allow_privilege_escalation=allow_privilege_escalation,
            ensure_non_root=ensure_non_root,
            group=group,
            privileged=privileged,
            read_only_root_filesystem=read_only_root_filesystem,
            user=user,
        )

        jsii.create(self.__class__, self, [props])

    @builtins.property
    @jsii.member(jsii_name="ensureNonRoot")
    def ensure_non_root(self) -> builtins.bool:
        return typing.cast(builtins.bool, jsii.get(self, "ensureNonRoot"))

    @builtins.property
    @jsii.member(jsii_name="privileged")
    def privileged(self) -> builtins.bool:
        return typing.cast(builtins.bool, jsii.get(self, "privileged"))

    @builtins.property
    @jsii.member(jsii_name="readOnlyRootFilesystem")
    def read_only_root_filesystem(self) -> builtins.bool:
        return typing.cast(builtins.bool, jsii.get(self, "readOnlyRootFilesystem"))

    @builtins.property
    @jsii.member(jsii_name="allowPrivilegeEscalation")
    def allow_privilege_escalation(self) -> typing.Optional[builtins.bool]:
        return typing.cast(typing.Optional[builtins.bool], jsii.get(self, "allowPrivilegeEscalation"))

    @builtins.property
    @jsii.member(jsii_name="group")
    def group(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "group"))

    @builtins.property
    @jsii.member(jsii_name="user")
    def user(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "user"))


@jsii.data_type(
    jsii_type="cdk8s-plus-24.ContainerSecurityContextProps",
    jsii_struct_bases=[],
    name_mapping={
        "allow_privilege_escalation": "allowPrivilegeEscalation",
        "ensure_non_root": "ensureNonRoot",
        "group": "group",
        "privileged": "privileged",
        "read_only_root_filesystem": "readOnlyRootFilesystem",
        "user": "user",
    },
)
class ContainerSecurityContextProps:
    def __init__(
        self,
        *,
        allow_privilege_escalation: typing.Optional[builtins.bool] = None,
        ensure_non_root: typing.Optional[builtins.bool] = None,
        group: typing.Optional[jsii.Number] = None,
        privileged: typing.Optional[builtins.bool] = None,
        read_only_root_filesystem: typing.Optional[builtins.bool] = None,
        user: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''Properties for ``ContainerSecurityContext``.

        :param allow_privilege_escalation: Whether a process can gain more privileges than its parent process. Default: false
        :param ensure_non_root: Indicates that the container must run as a non-root user. If true, the Kubelet will validate the image at runtime to ensure that it does not run as UID 0 (root) and fail to start the container if it does. Default: true
        :param group: The GID to run the entrypoint of the container process. Default: - 26000. An arbitrary number bigger than 9999 is selected here. This is so that the container is blocked to access host files even if somehow it manages to get access to host file system.
        :param privileged: Run container in privileged mode. Processes in privileged containers are essentially equivalent to root on the host. Default: false
        :param read_only_root_filesystem: Whether this container has a read-only root filesystem. Default: true
        :param user: The UID to run the entrypoint of the container process. Default: - 25000. An arbitrary number bigger than 9999 is selected here. This is so that the container is blocked to access host files even if somehow it manages to get access to host file system.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__dff9c96f4fdeaf9abf697a3095d03a86794815ebe24e45b2f2a1d9fd056ccb5f)
            check_type(argname="argument allow_privilege_escalation", value=allow_privilege_escalation, expected_type=type_hints["allow_privilege_escalation"])
            check_type(argname="argument ensure_non_root", value=ensure_non_root, expected_type=type_hints["ensure_non_root"])
            check_type(argname="argument group", value=group, expected_type=type_hints["group"])
            check_type(argname="argument privileged", value=privileged, expected_type=type_hints["privileged"])
            check_type(argname="argument read_only_root_filesystem", value=read_only_root_filesystem, expected_type=type_hints["read_only_root_filesystem"])
            check_type(argname="argument user", value=user, expected_type=type_hints["user"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if allow_privilege_escalation is not None:
            self._values["allow_privilege_escalation"] = allow_privilege_escalation
        if ensure_non_root is not None:
            self._values["ensure_non_root"] = ensure_non_root
        if group is not None:
            self._values["group"] = group
        if privileged is not None:
            self._values["privileged"] = privileged
        if read_only_root_filesystem is not None:
            self._values["read_only_root_filesystem"] = read_only_root_filesystem
        if user is not None:
            self._values["user"] = user

    @builtins.property
    def allow_privilege_escalation(self) -> typing.Optional[builtins.bool]:
        '''Whether a process can gain more privileges than its parent process.

        :default: false
        '''
        result = self._values.get("allow_privilege_escalation")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def ensure_non_root(self) -> typing.Optional[builtins.bool]:
        '''Indicates that the container must run as a non-root user.

        If true, the Kubelet will validate the image at runtime to ensure that it does
        not run as UID 0 (root) and fail to start the container if it does.

        :default: true
        '''
        result = self._values.get("ensure_non_root")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def group(self) -> typing.Optional[jsii.Number]:
        '''The GID to run the entrypoint of the container process.

        :default:

        -
        26000. An arbitrary number bigger than 9999 is selected here.
        This is so that the container is blocked to access host files even if
        somehow it manages to get access to host file system.
        '''
        result = self._values.get("group")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def privileged(self) -> typing.Optional[builtins.bool]:
        '''Run container in privileged mode.

        Processes in privileged containers are essentially equivalent to root on the host.

        :default: false
        '''
        result = self._values.get("privileged")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def read_only_root_filesystem(self) -> typing.Optional[builtins.bool]:
        '''Whether this container has a read-only root filesystem.

        :default: true
        '''
        result = self._values.get("read_only_root_filesystem")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def user(self) -> typing.Optional[jsii.Number]:
        '''The UID to run the entrypoint of the container process.

        :default:

        -
        25000. An arbitrary number bigger than 9999 is selected here.
        This is so that the container is blocked to access host files even if
        somehow it manages to get access to host file system.
        '''
        result = self._values.get("user")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ContainerSecurityContextProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class Cpu(metaclass=jsii.JSIIMeta, jsii_type="cdk8s-plus-24.Cpu"):
    '''Represents the amount of CPU.

    The amount can be passed as millis or units.
    '''

    @jsii.member(jsii_name="millis")
    @builtins.classmethod
    def millis(cls, amount: jsii.Number) -> "Cpu":
        '''
        :param amount: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b42fb06337c68cedd2b8e471be0c96666e49e4f78222763bcf0ba56c47efdd8f)
            check_type(argname="argument amount", value=amount, expected_type=type_hints["amount"])
        return typing.cast("Cpu", jsii.sinvoke(cls, "millis", [amount]))

    @jsii.member(jsii_name="units")
    @builtins.classmethod
    def units(cls, amount: jsii.Number) -> "Cpu":
        '''
        :param amount: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ff4c7c6c8a7f3f7327d11df6132cd60bf88843fd4886e0dd276fdab382c1caa3)
            check_type(argname="argument amount", value=amount, expected_type=type_hints["amount"])
        return typing.cast("Cpu", jsii.sinvoke(cls, "units", [amount]))

    @builtins.property
    @jsii.member(jsii_name="amount")
    def amount(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "amount"))

    @amount.setter
    def amount(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__71a9873b688c2dbab4d6f405ad18e6f94fc96ff5a7ec0578bcd7a251be6172c9)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "amount", value)


@jsii.data_type(
    jsii_type="cdk8s-plus-24.CpuResources",
    jsii_struct_bases=[],
    name_mapping={"limit": "limit", "request": "request"},
)
class CpuResources:
    def __init__(
        self,
        *,
        limit: typing.Optional[Cpu] = None,
        request: typing.Optional[Cpu] = None,
    ) -> None:
        '''CPU request and limit.

        :param limit: 
        :param request: 
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1a90c03655efca89a9255e9b986e94d7ab7b740a74c6f44b0944e7bfeaae2c11)
            check_type(argname="argument limit", value=limit, expected_type=type_hints["limit"])
            check_type(argname="argument request", value=request, expected_type=type_hints["request"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if limit is not None:
            self._values["limit"] = limit
        if request is not None:
            self._values["request"] = request

    @builtins.property
    def limit(self) -> typing.Optional[Cpu]:
        result = self._values.get("limit")
        return typing.cast(typing.Optional[Cpu], result)

    @builtins.property
    def request(self) -> typing.Optional[Cpu]:
        result = self._values.get("request")
        return typing.cast(typing.Optional[Cpu], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CpuResources(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.CsiVolumeOptions",
    jsii_struct_bases=[],
    name_mapping={
        "attributes": "attributes",
        "fs_type": "fsType",
        "name": "name",
        "read_only": "readOnly",
    },
)
class CsiVolumeOptions:
    def __init__(
        self,
        *,
        attributes: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        fs_type: typing.Optional[builtins.str] = None,
        name: typing.Optional[builtins.str] = None,
        read_only: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''Options for the CSI driver based volume.

        :param attributes: Any driver-specific attributes to pass to the CSI volume builder. Default: - undefined
        :param fs_type: The filesystem type to mount. Ex. "ext4", "xfs", "ntfs". If not provided, the empty value is passed to the associated CSI driver, which will determine the default filesystem to apply. Default: - driver-dependent
        :param name: The volume name. Default: - auto-generated
        :param read_only: Whether the mounted volume should be read-only or not. Default: - false
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2c8dad68be42c44551248efd2c679aa7daa9dc2730809e1b5f6da7a2888058c3)
            check_type(argname="argument attributes", value=attributes, expected_type=type_hints["attributes"])
            check_type(argname="argument fs_type", value=fs_type, expected_type=type_hints["fs_type"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument read_only", value=read_only, expected_type=type_hints["read_only"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if attributes is not None:
            self._values["attributes"] = attributes
        if fs_type is not None:
            self._values["fs_type"] = fs_type
        if name is not None:
            self._values["name"] = name
        if read_only is not None:
            self._values["read_only"] = read_only

    @builtins.property
    def attributes(self) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        '''Any driver-specific attributes to pass to the CSI volume builder.

        :default: - undefined
        '''
        result = self._values.get("attributes")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, builtins.str]], result)

    @builtins.property
    def fs_type(self) -> typing.Optional[builtins.str]:
        '''The filesystem type to mount.

        Ex. "ext4", "xfs", "ntfs". If not provided,
        the empty value is passed to the associated CSI driver, which will
        determine the default filesystem to apply.

        :default: - driver-dependent
        '''
        result = self._values.get("fs_type")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''The volume name.

        :default: - auto-generated
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def read_only(self) -> typing.Optional[builtins.bool]:
        '''Whether the mounted volume should be read-only or not.

        :default: - false
        '''
        result = self._values.get("read_only")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CsiVolumeOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.DeploymentExposeViaServiceOptions",
    jsii_struct_bases=[],
    name_mapping={"name": "name", "ports": "ports", "service_type": "serviceType"},
)
class DeploymentExposeViaServiceOptions:
    def __init__(
        self,
        *,
        name: typing.Optional[builtins.str] = None,
        ports: typing.Optional[typing.Sequence[typing.Union["ServicePort", typing.Dict[builtins.str, typing.Any]]]] = None,
        service_type: typing.Optional["ServiceType"] = None,
    ) -> None:
        '''Options for ``Deployment.exposeViaService``.

        :param name: The name of the service to expose. If you'd like to expose the deployment multiple times, you must explicitly set a name starting from the second expose call. Default: - auto generated.
        :param ports: The ports that the service should bind to. Default: - extracted from the deployment.
        :param service_type: The type of the exposed service. Default: - ClusterIP.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a59b2851541aa042d1deac0596a2a5061850e21a2a379dae4829535fa5e1429e)
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument ports", value=ports, expected_type=type_hints["ports"])
            check_type(argname="argument service_type", value=service_type, expected_type=type_hints["service_type"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if name is not None:
            self._values["name"] = name
        if ports is not None:
            self._values["ports"] = ports
        if service_type is not None:
            self._values["service_type"] = service_type

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''The name of the service to expose.

        If you'd like to expose the deployment multiple times,
        you must explicitly set a name starting from the second expose call.

        :default: - auto generated.
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def ports(self) -> typing.Optional[typing.List["ServicePort"]]:
        '''The ports that the service should bind to.

        :default: - extracted from the deployment.
        '''
        result = self._values.get("ports")
        return typing.cast(typing.Optional[typing.List["ServicePort"]], result)

    @builtins.property
    def service_type(self) -> typing.Optional["ServiceType"]:
        '''The type of the exposed service.

        :default: - ClusterIP.
        '''
        result = self._values.get("service_type")
        return typing.cast(typing.Optional["ServiceType"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DeploymentExposeViaServiceOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DeploymentStrategy(
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-24.DeploymentStrategy",
):
    '''Deployment strategies.'''

    @jsii.member(jsii_name="recreate")
    @builtins.classmethod
    def recreate(cls) -> "DeploymentStrategy":
        '''All existing Pods are killed before new ones are created.

        :see: https://kubernetes.io/docs/concepts/workloads/controllers/deployment/#recreate-deployment
        '''
        return typing.cast("DeploymentStrategy", jsii.sinvoke(cls, "recreate", []))

    @jsii.member(jsii_name="rollingUpdate")
    @builtins.classmethod
    def rolling_update(
        cls,
        *,
        max_surge: typing.Optional["PercentOrAbsolute"] = None,
        max_unavailable: typing.Optional["PercentOrAbsolute"] = None,
    ) -> "DeploymentStrategy":
        '''
        :param max_surge: The maximum number of pods that can be scheduled above the desired number of pods. Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%). Absolute number is calculated from percentage by rounding up. This can not be 0 if ``maxUnavailable`` is 0. Example: when this is set to 30%, the new ReplicaSet can be scaled up immediately when the rolling update starts, such that the total number of old and new pods do not exceed 130% of desired pods. Once old pods have been killed, new ReplicaSet can be scaled up further, ensuring that total number of pods running at any time during the update is at most 130% of desired pods. Default: '25%'
        :param max_unavailable: The maximum number of pods that can be unavailable during the update. Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%). Absolute number is calculated from percentage by rounding down. This can not be 0 if ``maxSurge`` is 0. Example: when this is set to 30%, the old ReplicaSet can be scaled down to 70% of desired pods immediately when the rolling update starts. Once new pods are ready, old ReplicaSet can be scaled down further, followed by scaling up the new ReplicaSet, ensuring that the total number of pods available at all times during the update is at least 70% of desired pods. Default: '25%'
        '''
        options = DeploymentStrategyRollingUpdateOptions(
            max_surge=max_surge, max_unavailable=max_unavailable
        )

        return typing.cast("DeploymentStrategy", jsii.sinvoke(cls, "rollingUpdate", [options]))


@jsii.data_type(
    jsii_type="cdk8s-plus-24.DeploymentStrategyRollingUpdateOptions",
    jsii_struct_bases=[],
    name_mapping={"max_surge": "maxSurge", "max_unavailable": "maxUnavailable"},
)
class DeploymentStrategyRollingUpdateOptions:
    def __init__(
        self,
        *,
        max_surge: typing.Optional["PercentOrAbsolute"] = None,
        max_unavailable: typing.Optional["PercentOrAbsolute"] = None,
    ) -> None:
        '''Options for ``DeploymentStrategy.rollingUpdate``.

        :param max_surge: The maximum number of pods that can be scheduled above the desired number of pods. Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%). Absolute number is calculated from percentage by rounding up. This can not be 0 if ``maxUnavailable`` is 0. Example: when this is set to 30%, the new ReplicaSet can be scaled up immediately when the rolling update starts, such that the total number of old and new pods do not exceed 130% of desired pods. Once old pods have been killed, new ReplicaSet can be scaled up further, ensuring that total number of pods running at any time during the update is at most 130% of desired pods. Default: '25%'
        :param max_unavailable: The maximum number of pods that can be unavailable during the update. Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%). Absolute number is calculated from percentage by rounding down. This can not be 0 if ``maxSurge`` is 0. Example: when this is set to 30%, the old ReplicaSet can be scaled down to 70% of desired pods immediately when the rolling update starts. Once new pods are ready, old ReplicaSet can be scaled down further, followed by scaling up the new ReplicaSet, ensuring that the total number of pods available at all times during the update is at least 70% of desired pods. Default: '25%'
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d0be017527eb5e2ccea2113f927e0483593b6f949dcbd8a48bbd8b1a3d623d54)
            check_type(argname="argument max_surge", value=max_surge, expected_type=type_hints["max_surge"])
            check_type(argname="argument max_unavailable", value=max_unavailable, expected_type=type_hints["max_unavailable"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if max_surge is not None:
            self._values["max_surge"] = max_surge
        if max_unavailable is not None:
            self._values["max_unavailable"] = max_unavailable

    @builtins.property
    def max_surge(self) -> typing.Optional["PercentOrAbsolute"]:
        '''The maximum number of pods that can be scheduled above the desired number of pods.

        Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%).
        Absolute number is calculated from percentage by rounding up.
        This can not be 0 if ``maxUnavailable`` is 0.

        Example: when this is set to 30%, the new ReplicaSet can be scaled up immediately when the rolling update
        starts, such that the total number of old and new pods do not exceed 130% of desired pods.
        Once old pods have been killed, new ReplicaSet can be scaled up further, ensuring that
        total number of pods running at any time during the update is at most 130% of desired pods.

        :default: '25%'
        '''
        result = self._values.get("max_surge")
        return typing.cast(typing.Optional["PercentOrAbsolute"], result)

    @builtins.property
    def max_unavailable(self) -> typing.Optional["PercentOrAbsolute"]:
        '''The maximum number of pods that can be unavailable during the update.

        Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%).
        Absolute number is calculated from percentage by rounding down.
        This can not be 0 if ``maxSurge`` is 0.

        Example: when this is set to 30%, the old ReplicaSet can be scaled down to 70% of desired
        pods immediately when the rolling update starts. Once new pods are ready, old ReplicaSet can
        be scaled down further, followed by scaling up the new ReplicaSet, ensuring that the total
        number of pods available at all times during the update is at least 70% of desired pods.

        :default: '25%'
        '''
        result = self._values.get("max_unavailable")
        return typing.cast(typing.Optional["PercentOrAbsolute"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DeploymentStrategyRollingUpdateOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.DnsOption",
    jsii_struct_bases=[],
    name_mapping={"name": "name", "value": "value"},
)
class DnsOption:
    def __init__(
        self,
        *,
        name: builtins.str,
        value: typing.Optional[builtins.str] = None,
    ) -> None:
        '''Custom DNS option.

        :param name: Option name.
        :param value: Option value. Default: - No value.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__544e1ef0bf13dcca899c3f61ec25b1ceafdeb6acdba7edccdb39fef4aad576d6)
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "name": name,
        }
        if value is not None:
            self._values["value"] = value

    @builtins.property
    def name(self) -> builtins.str:
        '''Option name.'''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def value(self) -> typing.Optional[builtins.str]:
        '''Option value.

        :default: - No value.
        '''
        result = self._values.get("value")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DnsOption(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.enum(jsii_type="cdk8s-plus-24.DnsPolicy")
class DnsPolicy(enum.Enum):
    '''Pod DNS policies.'''

    CLUSTER_FIRST = "CLUSTER_FIRST"
    '''Any DNS query that does not match the configured cluster domain suffix, such as "www.kubernetes.io", is forwarded to the upstream nameserver inherited from the node. Cluster administrators may have extra stub-domain and upstream DNS servers configured.'''
    CLUSTER_FIRST_WITH_HOST_NET = "CLUSTER_FIRST_WITH_HOST_NET"
    '''For Pods running with hostNetwork, you should explicitly set its DNS policy "ClusterFirstWithHostNet".'''
    DEFAULT = "DEFAULT"
    '''The Pod inherits the name resolution configuration from the node that the pods run on.'''
    NONE = "NONE"
    '''It allows a Pod to ignore DNS settings from the Kubernetes environment.

    All DNS settings are supposed to be provided using the dnsConfig
    field in the Pod Spec.
    '''


@jsii.enum(jsii_type="cdk8s-plus-24.EmptyDirMedium")
class EmptyDirMedium(enum.Enum):
    '''The medium on which to store the volume.'''

    DEFAULT = "DEFAULT"
    '''The default volume of the backing node.'''
    MEMORY = "MEMORY"
    '''Mount a tmpfs (RAM-backed filesystem) for you instead.

    While tmpfs is very
    fast, be aware that unlike disks, tmpfs is cleared on node reboot and any
    files you write will count against your Container's memory limit.
    '''


@jsii.data_type(
    jsii_type="cdk8s-plus-24.EmptyDirVolumeOptions",
    jsii_struct_bases=[],
    name_mapping={"medium": "medium", "size_limit": "sizeLimit"},
)
class EmptyDirVolumeOptions:
    def __init__(
        self,
        *,
        medium: typing.Optional[EmptyDirMedium] = None,
        size_limit: typing.Optional[_cdk8s_d3d9af27.Size] = None,
    ) -> None:
        '''Options for volumes populated with an empty directory.

        :param medium: By default, emptyDir volumes are stored on whatever medium is backing the node - that might be disk or SSD or network storage, depending on your environment. However, you can set the emptyDir.medium field to ``EmptyDirMedium.MEMORY`` to tell Kubernetes to mount a tmpfs (RAM-backed filesystem) for you instead. While tmpfs is very fast, be aware that unlike disks, tmpfs is cleared on node reboot and any files you write will count against your Container's memory limit. Default: EmptyDirMedium.DEFAULT
        :param size_limit: Total amount of local storage required for this EmptyDir volume. The size limit is also applicable for memory medium. The maximum usage on memory medium EmptyDir would be the minimum value between the SizeLimit specified here and the sum of memory limits of all containers in a pod. Default: - limit is undefined
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__02ad99d197192a1441eb8bf10eb4527ef10388f5a81dbcda758c7bee02c7c90e)
            check_type(argname="argument medium", value=medium, expected_type=type_hints["medium"])
            check_type(argname="argument size_limit", value=size_limit, expected_type=type_hints["size_limit"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if medium is not None:
            self._values["medium"] = medium
        if size_limit is not None:
            self._values["size_limit"] = size_limit

    @builtins.property
    def medium(self) -> typing.Optional[EmptyDirMedium]:
        '''By default, emptyDir volumes are stored on whatever medium is backing the node - that might be disk or SSD or network storage, depending on your environment.

        However, you can set the emptyDir.medium field to
        ``EmptyDirMedium.MEMORY`` to tell Kubernetes to mount a tmpfs (RAM-backed
        filesystem) for you instead. While tmpfs is very fast, be aware that unlike
        disks, tmpfs is cleared on node reboot and any files you write will count
        against your Container's memory limit.

        :default: EmptyDirMedium.DEFAULT
        '''
        result = self._values.get("medium")
        return typing.cast(typing.Optional[EmptyDirMedium], result)

    @builtins.property
    def size_limit(self) -> typing.Optional[_cdk8s_d3d9af27.Size]:
        '''Total amount of local storage required for this EmptyDir volume.

        The size
        limit is also applicable for memory medium. The maximum usage on memory
        medium EmptyDir would be the minimum value between the SizeLimit specified
        here and the sum of memory limits of all containers in a pod.

        :default: - limit is undefined
        '''
        result = self._values.get("size_limit")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Size], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "EmptyDirVolumeOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class Env(metaclass=jsii.JSIIMeta, jsii_type="cdk8s-plus-24.Env"):
    '''Container environment variables.'''

    def __init__(
        self,
        sources: typing.Sequence["EnvFrom"],
        variables: typing.Mapping[builtins.str, "EnvValue"],
    ) -> None:
        '''
        :param sources: -
        :param variables: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__348d047f6a2b2d13f9b878d0502514adf0fe7e303071dd067396ed753a9b32b7)
            check_type(argname="argument sources", value=sources, expected_type=type_hints["sources"])
            check_type(argname="argument variables", value=variables, expected_type=type_hints["variables"])
        jsii.create(self.__class__, self, [sources, variables])

    @jsii.member(jsii_name="fromConfigMap")
    @builtins.classmethod
    def from_config_map(
        cls,
        config_map: "IConfigMap",
        prefix: typing.Optional[builtins.str] = None,
    ) -> "EnvFrom":
        '''Selects a ConfigMap to populate the environment variables with.

        The contents of the target ConfigMap's Data field will represent
        the key-value pairs as environment variables.

        :param config_map: -
        :param prefix: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__128abe0cc7c066800a614a22504428d38378a9c8955b4c3c5b5c93705fcd029c)
            check_type(argname="argument config_map", value=config_map, expected_type=type_hints["config_map"])
            check_type(argname="argument prefix", value=prefix, expected_type=type_hints["prefix"])
        return typing.cast("EnvFrom", jsii.sinvoke(cls, "fromConfigMap", [config_map, prefix]))

    @jsii.member(jsii_name="fromSecret")
    @builtins.classmethod
    def from_secret(cls, secr: "ISecret") -> "EnvFrom":
        '''Selects a Secret to populate the environment variables with.

        The contents of the target Secret's Data field will represent
        the key-value pairs as environment variables.

        :param secr: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1b1213e61c4bd3ac736c556f88be5942966706fdbac0dae3475bb5b32298d3f9)
            check_type(argname="argument secr", value=secr, expected_type=type_hints["secr"])
        return typing.cast("EnvFrom", jsii.sinvoke(cls, "fromSecret", [secr]))

    @jsii.member(jsii_name="addVariable")
    def add_variable(self, name: builtins.str, value: "EnvValue") -> None:
        '''Add a single variable by name and value.

        The variable value can come from various dynamic sources such a secrets of config maps.
        Use ``EnvValue.fromXXX`` to select sources.

        :param name: -
        :param value: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e1d0e4e65cc14dadc7bf21f4abd13e1f3293ab1b56b3f5f7f39b9c2555972602)
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(None, jsii.invoke(self, "addVariable", [name, value]))

    @jsii.member(jsii_name="copyFrom")
    def copy_from(self, from_: "EnvFrom") -> None:
        '''Add a collection of variables by copying from another source.

        Use ``Env.fromXXX`` functions to select sources.

        :param from_: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__71bf0c209b1b48bae3ae3dad0957fe7152e22a2152b8212d229e6cb5dd4eae23)
            check_type(argname="argument from_", value=from_, expected_type=type_hints["from_"])
        return typing.cast(None, jsii.invoke(self, "copyFrom", [from_]))

    @builtins.property
    @jsii.member(jsii_name="sources")
    def sources(self) -> typing.List["EnvFrom"]:
        '''The list of sources used to populate the container environment, in addition to the ``variables``.

        Returns a copy. To add a source use ``container.env.copyFrom()``.
        '''
        return typing.cast(typing.List["EnvFrom"], jsii.get(self, "sources"))

    @builtins.property
    @jsii.member(jsii_name="variables")
    def variables(self) -> typing.Mapping[builtins.str, "EnvValue"]:
        '''The environment variables for this container.

        Returns a copy. To add environment variables use ``container.env.addVariable()``.
        '''
        return typing.cast(typing.Mapping[builtins.str, "EnvValue"], jsii.get(self, "variables"))


@jsii.enum(jsii_type="cdk8s-plus-24.EnvFieldPaths")
class EnvFieldPaths(enum.Enum):
    POD_NAME = "POD_NAME"
    '''The name of the pod.'''
    POD_NAMESPACE = "POD_NAMESPACE"
    '''The namespace of the pod.'''
    POD_UID = "POD_UID"
    '''The uid of the pod.'''
    POD_LABEL = "POD_LABEL"
    '''The labels of the pod.'''
    POD_ANNOTATION = "POD_ANNOTATION"
    '''The annotations of the pod.'''
    POD_IP = "POD_IP"
    '''The ipAddress of the pod.'''
    SERVICE_ACCOUNT_NAME = "SERVICE_ACCOUNT_NAME"
    '''The service account name of the pod.'''
    NODE_NAME = "NODE_NAME"
    '''The name of the node.'''
    NODE_IP = "NODE_IP"
    '''The ipAddress of the node.'''
    POD_IPS = "POD_IPS"
    '''The ipAddresess of the pod.'''


class EnvFrom(metaclass=jsii.JSIIMeta, jsii_type="cdk8s-plus-24.EnvFrom"):
    '''A collection of env variables defined in other resources.'''

    def __init__(
        self,
        config_map: typing.Optional["IConfigMap"] = None,
        prefix: typing.Optional[builtins.str] = None,
        sec: typing.Optional["ISecret"] = None,
    ) -> None:
        '''
        :param config_map: -
        :param prefix: -
        :param sec: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3fcc4c5a37203ca5c6855f4778db2e3bacba751ab4d2b3b76c45c62ac647e53a)
            check_type(argname="argument config_map", value=config_map, expected_type=type_hints["config_map"])
            check_type(argname="argument prefix", value=prefix, expected_type=type_hints["prefix"])
            check_type(argname="argument sec", value=sec, expected_type=type_hints["sec"])
        jsii.create(self.__class__, self, [config_map, prefix, sec])


class EnvValue(metaclass=jsii.JSIIMeta, jsii_type="cdk8s-plus-24.EnvValue"):
    '''Utility class for creating reading env values from various sources.'''

    @jsii.member(jsii_name="fromConfigMap")
    @builtins.classmethod
    def from_config_map(
        cls,
        config_map: "IConfigMap",
        key: builtins.str,
        *,
        optional: typing.Optional[builtins.bool] = None,
    ) -> "EnvValue":
        '''Create a value by reading a specific key inside a config map.

        :param config_map: - The config map.
        :param key: - The key to extract the value from.
        :param optional: Specify whether the ConfigMap or its key must be defined. Default: false
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__499c8c5afc9273acabb32bc741b2d4fb7f4304d7b4ccb8bfea19ef1b216227f8)
            check_type(argname="argument config_map", value=config_map, expected_type=type_hints["config_map"])
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
        options = EnvValueFromConfigMapOptions(optional=optional)

        return typing.cast("EnvValue", jsii.sinvoke(cls, "fromConfigMap", [config_map, key, options]))

    @jsii.member(jsii_name="fromFieldRef")
    @builtins.classmethod
    def from_field_ref(
        cls,
        field_path: EnvFieldPaths,
        *,
        api_version: typing.Optional[builtins.str] = None,
        key: typing.Optional[builtins.str] = None,
    ) -> "EnvValue":
        '''Create a value from a field reference.

        :param field_path: : The field reference.
        :param api_version: Version of the schema the FieldPath is written in terms of.
        :param key: The key to select the pod label or annotation.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__383b784317ac7e2939f7d8354e4a39392793dcbb6d8f696f32421e513fedd483)
            check_type(argname="argument field_path", value=field_path, expected_type=type_hints["field_path"])
        options = EnvValueFromFieldRefOptions(api_version=api_version, key=key)

        return typing.cast("EnvValue", jsii.sinvoke(cls, "fromFieldRef", [field_path, options]))

    @jsii.member(jsii_name="fromProcess")
    @builtins.classmethod
    def from_process(
        cls,
        key: builtins.str,
        *,
        required: typing.Optional[builtins.bool] = None,
    ) -> "EnvValue":
        '''Create a value from a key in the current process environment.

        :param key: - The key to read.
        :param required: Specify whether the key must exist in the environment. If this is set to true, and the key does not exist, an error will thrown. Default: false
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5c39d61e5bb821b553cff503bb54ec63da5a099de6cd804e44204c1c0b02a514)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
        options = EnvValueFromProcessOptions(required=required)

        return typing.cast("EnvValue", jsii.sinvoke(cls, "fromProcess", [key, options]))

    @jsii.member(jsii_name="fromResource")
    @builtins.classmethod
    def from_resource(
        cls,
        resource: "ResourceFieldPaths",
        *,
        container: typing.Optional[Container] = None,
        divisor: typing.Optional[builtins.str] = None,
    ) -> "EnvValue":
        '''Create a value from a resource.

        :param resource: : Resource to select the value from.
        :param container: The container to select the value from.
        :param divisor: The output format of the exposed resource.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__39be78299ed8b74f5012b20804e3af6599d5d45e50249f5c75a588e6686d51ac)
            check_type(argname="argument resource", value=resource, expected_type=type_hints["resource"])
        options = EnvValueFromResourceOptions(container=container, divisor=divisor)

        return typing.cast("EnvValue", jsii.sinvoke(cls, "fromResource", [resource, options]))

    @jsii.member(jsii_name="fromSecretValue")
    @builtins.classmethod
    def from_secret_value(
        cls,
        secret_value: typing.Union["SecretValue", typing.Dict[builtins.str, typing.Any]],
        *,
        optional: typing.Optional[builtins.bool] = None,
    ) -> "EnvValue":
        '''Defines an environment value from a secret JSON value.

        :param secret_value: The secret value (secrent + key).
        :param optional: Specify whether the Secret or its key must be defined. Default: false
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__75bc5223abacca597193516ba864e70db1c9df745b42acaca691afe7e397cf39)
            check_type(argname="argument secret_value", value=secret_value, expected_type=type_hints["secret_value"])
        options = EnvValueFromSecretOptions(optional=optional)

        return typing.cast("EnvValue", jsii.sinvoke(cls, "fromSecretValue", [secret_value, options]))

    @jsii.member(jsii_name="fromValue")
    @builtins.classmethod
    def from_value(cls, value: builtins.str) -> "EnvValue":
        '''Create a value from the given argument.

        :param value: - The value.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9430d2ce5764998007e1158a2e9e0e3f8d6f7adb474e17250588602bc3d5b7f8)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast("EnvValue", jsii.sinvoke(cls, "fromValue", [value]))

    @builtins.property
    @jsii.member(jsii_name="value")
    def value(self) -> typing.Any:
        return typing.cast(typing.Any, jsii.get(self, "value"))

    @builtins.property
    @jsii.member(jsii_name="valueFrom")
    def value_from(self) -> typing.Any:
        return typing.cast(typing.Any, jsii.get(self, "valueFrom"))


@jsii.data_type(
    jsii_type="cdk8s-plus-24.EnvValueFromConfigMapOptions",
    jsii_struct_bases=[],
    name_mapping={"optional": "optional"},
)
class EnvValueFromConfigMapOptions:
    def __init__(self, *, optional: typing.Optional[builtins.bool] = None) -> None:
        '''Options to specify an envionment variable value from a ConfigMap key.

        :param optional: Specify whether the ConfigMap or its key must be defined. Default: false
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b887998e4fbb868633a86556bfae4a1afef5df5672c7b4a4dc151fa877ef7e96)
            check_type(argname="argument optional", value=optional, expected_type=type_hints["optional"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if optional is not None:
            self._values["optional"] = optional

    @builtins.property
    def optional(self) -> typing.Optional[builtins.bool]:
        '''Specify whether the ConfigMap or its key must be defined.

        :default: false
        '''
        result = self._values.get("optional")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "EnvValueFromConfigMapOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.EnvValueFromFieldRefOptions",
    jsii_struct_bases=[],
    name_mapping={"api_version": "apiVersion", "key": "key"},
)
class EnvValueFromFieldRefOptions:
    def __init__(
        self,
        *,
        api_version: typing.Optional[builtins.str] = None,
        key: typing.Optional[builtins.str] = None,
    ) -> None:
        '''Options to specify an environment variable value from a field reference.

        :param api_version: Version of the schema the FieldPath is written in terms of.
        :param key: The key to select the pod label or annotation.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__37ad8d335b1fcfde6ea18b6953a47a86c8e124fd979d85cd489ad39c5948530f)
            check_type(argname="argument api_version", value=api_version, expected_type=type_hints["api_version"])
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if api_version is not None:
            self._values["api_version"] = api_version
        if key is not None:
            self._values["key"] = key

    @builtins.property
    def api_version(self) -> typing.Optional[builtins.str]:
        '''Version of the schema the FieldPath is written in terms of.'''
        result = self._values.get("api_version")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def key(self) -> typing.Optional[builtins.str]:
        '''The key to select the pod label or annotation.'''
        result = self._values.get("key")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "EnvValueFromFieldRefOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.EnvValueFromProcessOptions",
    jsii_struct_bases=[],
    name_mapping={"required": "required"},
)
class EnvValueFromProcessOptions:
    def __init__(self, *, required: typing.Optional[builtins.bool] = None) -> None:
        '''Options to specify an environment variable value from the process environment.

        :param required: Specify whether the key must exist in the environment. If this is set to true, and the key does not exist, an error will thrown. Default: false
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__28b1a377a92289eb9c5ae52783a1764785a8b9f5374d7b39d0bc13fb0a50129a)
            check_type(argname="argument required", value=required, expected_type=type_hints["required"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if required is not None:
            self._values["required"] = required

    @builtins.property
    def required(self) -> typing.Optional[builtins.bool]:
        '''Specify whether the key must exist in the environment.

        If this is set to true, and the key does not exist, an error will thrown.

        :default: false
        '''
        result = self._values.get("required")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "EnvValueFromProcessOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.EnvValueFromResourceOptions",
    jsii_struct_bases=[],
    name_mapping={"container": "container", "divisor": "divisor"},
)
class EnvValueFromResourceOptions:
    def __init__(
        self,
        *,
        container: typing.Optional[Container] = None,
        divisor: typing.Optional[builtins.str] = None,
    ) -> None:
        '''Options to specify an environment variable value from a resource.

        :param container: The container to select the value from.
        :param divisor: The output format of the exposed resource.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__18d7b8e66766388ca70763438a16fb2ae2a48e98c5f87e57f9f3b6727d9b9e52)
            check_type(argname="argument container", value=container, expected_type=type_hints["container"])
            check_type(argname="argument divisor", value=divisor, expected_type=type_hints["divisor"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if container is not None:
            self._values["container"] = container
        if divisor is not None:
            self._values["divisor"] = divisor

    @builtins.property
    def container(self) -> typing.Optional[Container]:
        '''The container to select the value from.'''
        result = self._values.get("container")
        return typing.cast(typing.Optional[Container], result)

    @builtins.property
    def divisor(self) -> typing.Optional[builtins.str]:
        '''The output format of the exposed resource.'''
        result = self._values.get("divisor")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "EnvValueFromResourceOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.EnvValueFromSecretOptions",
    jsii_struct_bases=[],
    name_mapping={"optional": "optional"},
)
class EnvValueFromSecretOptions:
    def __init__(self, *, optional: typing.Optional[builtins.bool] = None) -> None:
        '''Options to specify an environment variable value from a Secret.

        :param optional: Specify whether the Secret or its key must be defined. Default: false
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d041fc9ee7c4e3cb96d45933b94a6a59c76be802712d68a448dcdaaf796e49cd)
            check_type(argname="argument optional", value=optional, expected_type=type_hints["optional"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if optional is not None:
            self._values["optional"] = optional

    @builtins.property
    def optional(self) -> typing.Optional[builtins.bool]:
        '''Specify whether the Secret or its key must be defined.

        :default: false
        '''
        result = self._values.get("optional")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "EnvValueFromSecretOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.EphemeralStorageResources",
    jsii_struct_bases=[],
    name_mapping={"limit": "limit", "request": "request"},
)
class EphemeralStorageResources:
    def __init__(
        self,
        *,
        limit: typing.Optional[_cdk8s_d3d9af27.Size] = None,
        request: typing.Optional[_cdk8s_d3d9af27.Size] = None,
    ) -> None:
        '''Emphemeral storage request and limit.

        :param limit: 
        :param request: 
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__946097bd4859cc70ad49e791293224aace52f937ee5d63d72bc08db24e0922ad)
            check_type(argname="argument limit", value=limit, expected_type=type_hints["limit"])
            check_type(argname="argument request", value=request, expected_type=type_hints["request"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if limit is not None:
            self._values["limit"] = limit
        if request is not None:
            self._values["request"] = request

    @builtins.property
    def limit(self) -> typing.Optional[_cdk8s_d3d9af27.Size]:
        result = self._values.get("limit")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Size], result)

    @builtins.property
    def request(self) -> typing.Optional[_cdk8s_d3d9af27.Size]:
        result = self._values.get("request")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Size], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "EphemeralStorageResources(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.ExposeServiceViaIngressOptions",
    jsii_struct_bases=[],
    name_mapping={"ingress": "ingress", "path_type": "pathType"},
)
class ExposeServiceViaIngressOptions:
    def __init__(
        self,
        *,
        ingress: typing.Optional["Ingress"] = None,
        path_type: typing.Optional["HttpIngressPathType"] = None,
    ) -> None:
        '''Options for exposing a service using an ingress.

        :param ingress: The ingress to add rules to. Default: - An ingress will be automatically created.
        :param path_type: The type of the path. Default: HttpIngressPathType.PREFIX
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__29942993dfbd24df9521657f0cd5b563d3ee88c013e7de41883670f935fe218e)
            check_type(argname="argument ingress", value=ingress, expected_type=type_hints["ingress"])
            check_type(argname="argument path_type", value=path_type, expected_type=type_hints["path_type"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if ingress is not None:
            self._values["ingress"] = ingress
        if path_type is not None:
            self._values["path_type"] = path_type

    @builtins.property
    def ingress(self) -> typing.Optional["Ingress"]:
        '''The ingress to add rules to.

        :default: - An ingress will be automatically created.
        '''
        result = self._values.get("ingress")
        return typing.cast(typing.Optional["Ingress"], result)

    @builtins.property
    def path_type(self) -> typing.Optional["HttpIngressPathType"]:
        '''The type of the path.

        :default: HttpIngressPathType.PREFIX
        '''
        result = self._values.get("path_type")
        return typing.cast(typing.Optional["HttpIngressPathType"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ExposeServiceViaIngressOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.FromServiceAccountNameOptions",
    jsii_struct_bases=[],
    name_mapping={"namespace_name": "namespaceName"},
)
class FromServiceAccountNameOptions:
    def __init__(self, *, namespace_name: typing.Optional[builtins.str] = None) -> None:
        '''
        :param namespace_name: The name of the namespace the service account belongs to. Default: "default"
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__95acfabf93dce2237ff3b4a5539c94358053aab0cd4f78ab29699f197b180630)
            check_type(argname="argument namespace_name", value=namespace_name, expected_type=type_hints["namespace_name"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if namespace_name is not None:
            self._values["namespace_name"] = namespace_name

    @builtins.property
    def namespace_name(self) -> typing.Optional[builtins.str]:
        '''The name of the namespace the service account belongs to.

        :default: "default"
        '''
        result = self._values.get("namespace_name")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "FromServiceAccountNameOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.enum(jsii_type="cdk8s-plus-24.FsGroupChangePolicy")
class FsGroupChangePolicy(enum.Enum):
    ON_ROOT_MISMATCH = "ON_ROOT_MISMATCH"
    '''Only change permissions and ownership if permission and ownership of root directory does not match with expected permissions of the volume.

    This could help shorten the time it takes to change ownership and permission of a volume
    '''
    ALWAYS = "ALWAYS"
    '''Always change permission and ownership of the volume when volume is mounted.'''


@jsii.data_type(
    jsii_type="cdk8s-plus-24.GCEPersistentDiskVolumeOptions",
    jsii_struct_bases=[],
    name_mapping={
        "fs_type": "fsType",
        "name": "name",
        "partition": "partition",
        "read_only": "readOnly",
    },
)
class GCEPersistentDiskVolumeOptions:
    def __init__(
        self,
        *,
        fs_type: typing.Optional[builtins.str] = None,
        name: typing.Optional[builtins.str] = None,
        partition: typing.Optional[jsii.Number] = None,
        read_only: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''Options of ``Volume.fromGcePersistentDisk``.

        :param fs_type: Filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Default: 'ext4'
        :param name: The volume name. Default: - auto-generated
        :param partition: The partition in the volume that you want to mount. If omitted, the default is to mount by volume name. Examples: For volume /dev/sda1, you specify the partition as "1". Similarly, the volume partition for /dev/sda is "0" (or you can leave the property empty). Default: - No partition.
        :param read_only: Specify "true" to force and set the ReadOnly property in VolumeMounts to "true". Default: false
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__570773e2d3a17dc2a90734e4e0b9a00912cd36f85f97b90649eb7b0b87b16101)
            check_type(argname="argument fs_type", value=fs_type, expected_type=type_hints["fs_type"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
            check_type(argname="argument read_only", value=read_only, expected_type=type_hints["read_only"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if fs_type is not None:
            self._values["fs_type"] = fs_type
        if name is not None:
            self._values["name"] = name
        if partition is not None:
            self._values["partition"] = partition
        if read_only is not None:
            self._values["read_only"] = read_only

    @builtins.property
    def fs_type(self) -> typing.Optional[builtins.str]:
        '''Filesystem type of the volume that you want to mount.

        Tip: Ensure that the filesystem type is supported by the host operating system.

        :default: 'ext4'

        :see: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
        '''
        result = self._values.get("fs_type")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''The volume name.

        :default: - auto-generated
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def partition(self) -> typing.Optional[jsii.Number]:
        '''The partition in the volume that you want to mount.

        If omitted, the default is to mount by volume name.
        Examples: For volume /dev/sda1, you specify the partition as "1".
        Similarly, the volume partition for /dev/sda is "0" (or you can leave the property empty).

        :default: - No partition.
        '''
        result = self._values.get("partition")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def read_only(self) -> typing.Optional[builtins.bool]:
        '''Specify "true" to force and set the ReadOnly property in VolumeMounts to "true".

        :default: false

        :see: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
        '''
        result = self._values.get("read_only")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "GCEPersistentDiskVolumeOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class Handler(metaclass=jsii.JSIIMeta, jsii_type="cdk8s-plus-24.Handler"):
    '''Defines a specific action that should be taken.'''

    @jsii.member(jsii_name="fromCommand")
    @builtins.classmethod
    def from_command(cls, command: typing.Sequence[builtins.str]) -> "Handler":
        '''Defines a handler based on a command which is executed within the container.

        :param command: The command to execute.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b157baaa3cdd85ae98cd061ead6c6317e92ec6a29f254b1a3526edf8e86fcefc)
            check_type(argname="argument command", value=command, expected_type=type_hints["command"])
        return typing.cast("Handler", jsii.sinvoke(cls, "fromCommand", [command]))

    @jsii.member(jsii_name="fromHttpGet")
    @builtins.classmethod
    def from_http_get(
        cls,
        path: builtins.str,
        *,
        port: typing.Optional[jsii.Number] = None,
    ) -> "Handler":
        '''Defines a handler based on an HTTP GET request to the IP address of the container.

        :param path: The URL path to hit.
        :param port: The TCP port to use when sending the GET request. Default: - defaults to ``container.port``.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4079598647ed7c1cbc319d397ef520f925a4ca23253f767dcaebde534f09c484)
            check_type(argname="argument path", value=path, expected_type=type_hints["path"])
        options = HandlerFromHttpGetOptions(port=port)

        return typing.cast("Handler", jsii.sinvoke(cls, "fromHttpGet", [path, options]))

    @jsii.member(jsii_name="fromTcpSocket")
    @builtins.classmethod
    def from_tcp_socket(
        cls,
        *,
        host: typing.Optional[builtins.str] = None,
        port: typing.Optional[jsii.Number] = None,
    ) -> "Handler":
        '''Defines a handler based opening a connection to a TCP socket on the container.

        :param host: The host name to connect to on the container. Default: - defaults to the pod IP
        :param port: The TCP port to connect to on the container. Default: - defaults to ``container.port``.
        '''
        options = HandlerFromTcpSocketOptions(host=host, port=port)

        return typing.cast("Handler", jsii.sinvoke(cls, "fromTcpSocket", [options]))


@jsii.data_type(
    jsii_type="cdk8s-plus-24.HandlerFromHttpGetOptions",
    jsii_struct_bases=[],
    name_mapping={"port": "port"},
)
class HandlerFromHttpGetOptions:
    def __init__(self, *, port: typing.Optional[jsii.Number] = None) -> None:
        '''Options for ``Handler.fromHttpGet``.

        :param port: The TCP port to use when sending the GET request. Default: - defaults to ``container.port``.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__bd1a2bfe05ea25d623ce29ebd3a4d0fb1ad32e53a7dbbcedc2aa1449f103eba4)
            check_type(argname="argument port", value=port, expected_type=type_hints["port"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if port is not None:
            self._values["port"] = port

    @builtins.property
    def port(self) -> typing.Optional[jsii.Number]:
        '''The TCP port to use when sending the GET request.

        :default: - defaults to ``container.port``.
        '''
        result = self._values.get("port")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "HandlerFromHttpGetOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.HandlerFromTcpSocketOptions",
    jsii_struct_bases=[],
    name_mapping={"host": "host", "port": "port"},
)
class HandlerFromTcpSocketOptions:
    def __init__(
        self,
        *,
        host: typing.Optional[builtins.str] = None,
        port: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''Options for ``Handler.fromTcpSocket``.

        :param host: The host name to connect to on the container. Default: - defaults to the pod IP
        :param port: The TCP port to connect to on the container. Default: - defaults to ``container.port``.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__aa5d5acf9b7d5961b883a738e1d5095fef7c57172afd31ebb4086c6658be81f4)
            check_type(argname="argument host", value=host, expected_type=type_hints["host"])
            check_type(argname="argument port", value=port, expected_type=type_hints["port"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if host is not None:
            self._values["host"] = host
        if port is not None:
            self._values["port"] = port

    @builtins.property
    def host(self) -> typing.Optional[builtins.str]:
        '''The host name to connect to on the container.

        :default: - defaults to the pod IP
        '''
        result = self._values.get("host")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def port(self) -> typing.Optional[jsii.Number]:
        '''The TCP port to connect to on the container.

        :default: - defaults to ``container.port``.
        '''
        result = self._values.get("port")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "HandlerFromTcpSocketOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.HostAlias",
    jsii_struct_bases=[],
    name_mapping={"hostnames": "hostnames", "ip": "ip"},
)
class HostAlias:
    def __init__(
        self,
        *,
        hostnames: typing.Sequence[builtins.str],
        ip: builtins.str,
    ) -> None:
        '''HostAlias holds the mapping between IP and hostnames that will be injected as an entry in the pod's /etc/hosts file.

        :param hostnames: Hostnames for the chosen IP address.
        :param ip: IP address of the host file entry.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__39f6500eed59d473b52ee0bd50da980c9cb45b6d58133b09e86e1ddf5ec01ef3)
            check_type(argname="argument hostnames", value=hostnames, expected_type=type_hints["hostnames"])
            check_type(argname="argument ip", value=ip, expected_type=type_hints["ip"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "hostnames": hostnames,
            "ip": ip,
        }

    @builtins.property
    def hostnames(self) -> typing.List[builtins.str]:
        '''Hostnames for the chosen IP address.'''
        result = self._values.get("hostnames")
        assert result is not None, "Required property 'hostnames' is missing"
        return typing.cast(typing.List[builtins.str], result)

    @builtins.property
    def ip(self) -> builtins.str:
        '''IP address of the host file entry.'''
        result = self._values.get("ip")
        assert result is not None, "Required property 'ip' is missing"
        return typing.cast(builtins.str, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "HostAlias(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.HostPathVolumeOptions",
    jsii_struct_bases=[],
    name_mapping={"path": "path", "type": "type"},
)
class HostPathVolumeOptions:
    def __init__(
        self,
        *,
        path: builtins.str,
        type: typing.Optional["HostPathVolumeType"] = None,
    ) -> None:
        '''Options for a HostPathVolume-based volume.

        :param path: The path of the directory on the host.
        :param type: The expected type of the path found on the host. Default: HostPathVolumeType.DEFAULT
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d77927c7b6ff27ab1a757f5f6e281670a009abce794f396ae81438743a20eedf)
            check_type(argname="argument path", value=path, expected_type=type_hints["path"])
            check_type(argname="argument type", value=type, expected_type=type_hints["type"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "path": path,
        }
        if type is not None:
            self._values["type"] = type

    @builtins.property
    def path(self) -> builtins.str:
        '''The path of the directory on the host.'''
        result = self._values.get("path")
        assert result is not None, "Required property 'path' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def type(self) -> typing.Optional["HostPathVolumeType"]:
        '''The expected type of the path found on the host.

        :default: HostPathVolumeType.DEFAULT
        '''
        result = self._values.get("type")
        return typing.cast(typing.Optional["HostPathVolumeType"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "HostPathVolumeOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.enum(jsii_type="cdk8s-plus-24.HostPathVolumeType")
class HostPathVolumeType(enum.Enum):
    '''Host path types.'''

    DEFAULT = "DEFAULT"
    '''Empty string (default) is for backward compatibility, which means that no checks will be performed before mounting the hostPath volume.'''
    DIRECTORY_OR_CREATE = "DIRECTORY_OR_CREATE"
    '''If nothing exists at the given path, an empty directory will be created there as needed with permission set to 0755, having the same group and ownership with Kubelet.'''
    DIRECTORY = "DIRECTORY"
    '''A directory must exist at the given path.'''
    FILE_OR_CREATE = "FILE_OR_CREATE"
    '''If nothing exists at the given path, an empty file will be created there as needed with permission set to 0644, having the same group and ownership with Kubelet.'''
    FILE = "FILE"
    '''A file must exist at the given path.'''
    SOCKET = "SOCKET"
    '''A UNIX socket must exist at the given path.'''
    CHAR_DEVICE = "CHAR_DEVICE"
    '''A character device must exist at the given path.'''
    BLOCK_DEVICE = "BLOCK_DEVICE"
    '''A block device must exist at the given path.'''


@jsii.enum(jsii_type="cdk8s-plus-24.HttpIngressPathType")
class HttpIngressPathType(enum.Enum):
    '''Specify how the path is matched against request paths.

    :see: https://kubernetes.io/docs/concepts/services-networking/ingress/#path-types
    '''

    PREFIX = "PREFIX"
    '''Matches the URL path exactly.'''
    EXACT = "EXACT"
    '''Matches based on a URL path prefix split by '/'.'''
    IMPLEMENTATION_SPECIFIC = "IMPLEMENTATION_SPECIFIC"
    '''Matching is specified by the underlying IngressClass.'''


@jsii.interface(jsii_type="cdk8s-plus-24.IApiEndpoint")
class IApiEndpoint(typing_extensions.Protocol):
    '''An API Endpoint can either be a resource descriptor (e.g /pods) or a non resource url (e.g /healthz). It must be one or the other, and not both.'''

    @jsii.member(jsii_name="asApiResource")
    def as_api_resource(self) -> typing.Optional["IApiResource"]:
        '''Return the IApiResource this object represents.'''
        ...

    @jsii.member(jsii_name="asNonApiResource")
    def as_non_api_resource(self) -> typing.Optional[builtins.str]:
        '''Return the non resource url this object represents.'''
        ...


class _IApiEndpointProxy:
    '''An API Endpoint can either be a resource descriptor (e.g /pods) or a non resource url (e.g /healthz). It must be one or the other, and not both.'''

    __jsii_type__: typing.ClassVar[str] = "cdk8s-plus-24.IApiEndpoint"

    @jsii.member(jsii_name="asApiResource")
    def as_api_resource(self) -> typing.Optional["IApiResource"]:
        '''Return the IApiResource this object represents.'''
        return typing.cast(typing.Optional["IApiResource"], jsii.invoke(self, "asApiResource", []))

    @jsii.member(jsii_name="asNonApiResource")
    def as_non_api_resource(self) -> typing.Optional[builtins.str]:
        '''Return the non resource url this object represents.'''
        return typing.cast(typing.Optional[builtins.str], jsii.invoke(self, "asNonApiResource", []))

# Adding a "__jsii_proxy_class__(): typing.Type" function to the interface
typing.cast(typing.Any, IApiEndpoint).__jsii_proxy_class__ = lambda : _IApiEndpointProxy


@jsii.interface(jsii_type="cdk8s-plus-24.IApiResource")
class IApiResource(typing_extensions.Protocol):
    '''Represents a resource or collection of resources.'''

    @builtins.property
    @jsii.member(jsii_name="apiGroup")
    def api_group(self) -> builtins.str:
        '''The group portion of the API version (e.g. ``authorization.k8s.io``).'''
        ...

    @builtins.property
    @jsii.member(jsii_name="resourceType")
    def resource_type(self) -> builtins.str:
        '''The name of a resource type as it appears in the relevant API endpoint.

        :see: https://kubernetes.io/docs/reference/access-authn-authz/rbac/#referring-to-resources

        Example::

            - "pods" or "pods/log"
        '''
        ...

    @builtins.property
    @jsii.member(jsii_name="resourceName")
    def resource_name(self) -> typing.Optional[builtins.str]:
        '''The unique, namespace-global, name of an object inside the Kubernetes cluster.

        If this is omitted, the ApiResource should represent all objects of the given type.
        '''
        ...


class _IApiResourceProxy:
    '''Represents a resource or collection of resources.'''

    __jsii_type__: typing.ClassVar[str] = "cdk8s-plus-24.IApiResource"

    @builtins.property
    @jsii.member(jsii_name="apiGroup")
    def api_group(self) -> builtins.str:
        '''The group portion of the API version (e.g. ``authorization.k8s.io``).'''
        return typing.cast(builtins.str, jsii.get(self, "apiGroup"))

    @builtins.property
    @jsii.member(jsii_name="resourceType")
    def resource_type(self) -> builtins.str:
        '''The name of a resource type as it appears in the relevant API endpoint.

        :see: https://kubernetes.io/docs/reference/access-authn-authz/rbac/#referring-to-resources

        Example::

            - "pods" or "pods/log"
        '''
        return typing.cast(builtins.str, jsii.get(self, "resourceType"))

    @builtins.property
    @jsii.member(jsii_name="resourceName")
    def resource_name(self) -> typing.Optional[builtins.str]:
        '''The unique, namespace-global, name of an object inside the Kubernetes cluster.

        If this is omitted, the ApiResource should represent all objects of the given type.
        '''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "resourceName"))

# Adding a "__jsii_proxy_class__(): typing.Type" function to the interface
typing.cast(typing.Any, IApiResource).__jsii_proxy_class__ = lambda : _IApiResourceProxy


@jsii.interface(jsii_type="cdk8s-plus-24.INamespaceSelector")
class INamespaceSelector(_constructs_77d1e7e8.IConstruct, typing_extensions.Protocol):
    '''Represents an object that can select namespaces.'''

    @jsii.member(jsii_name="toNamespaceSelectorConfig")
    def to_namespace_selector_config(self) -> "NamespaceSelectorConfig":
        '''Return the configuration of this selector.'''
        ...


class _INamespaceSelectorProxy(
    jsii.proxy_for(_constructs_77d1e7e8.IConstruct), # type: ignore[misc]
):
    '''Represents an object that can select namespaces.'''

    __jsii_type__: typing.ClassVar[str] = "cdk8s-plus-24.INamespaceSelector"

    @jsii.member(jsii_name="toNamespaceSelectorConfig")
    def to_namespace_selector_config(self) -> "NamespaceSelectorConfig":
        '''Return the configuration of this selector.'''
        return typing.cast("NamespaceSelectorConfig", jsii.invoke(self, "toNamespaceSelectorConfig", []))

# Adding a "__jsii_proxy_class__(): typing.Type" function to the interface
typing.cast(typing.Any, INamespaceSelector).__jsii_proxy_class__ = lambda : _INamespaceSelectorProxy


@jsii.interface(jsii_type="cdk8s-plus-24.INetworkPolicyPeer")
class INetworkPolicyPeer(_constructs_77d1e7e8.IConstruct, typing_extensions.Protocol):
    '''Describes a peer to allow traffic to/from.'''

    @jsii.member(jsii_name="toNetworkPolicyPeerConfig")
    def to_network_policy_peer_config(self) -> "NetworkPolicyPeerConfig":
        '''Return the configuration of this peer.'''
        ...

    @jsii.member(jsii_name="toPodSelector")
    def to_pod_selector(self) -> typing.Optional["IPodSelector"]:
        '''Convert the peer into a pod selector, if possible.'''
        ...


class _INetworkPolicyPeerProxy(
    jsii.proxy_for(_constructs_77d1e7e8.IConstruct), # type: ignore[misc]
):
    '''Describes a peer to allow traffic to/from.'''

    __jsii_type__: typing.ClassVar[str] = "cdk8s-plus-24.INetworkPolicyPeer"

    @jsii.member(jsii_name="toNetworkPolicyPeerConfig")
    def to_network_policy_peer_config(self) -> "NetworkPolicyPeerConfig":
        '''Return the configuration of this peer.'''
        return typing.cast("NetworkPolicyPeerConfig", jsii.invoke(self, "toNetworkPolicyPeerConfig", []))

    @jsii.member(jsii_name="toPodSelector")
    def to_pod_selector(self) -> typing.Optional["IPodSelector"]:
        '''Convert the peer into a pod selector, if possible.'''
        return typing.cast(typing.Optional["IPodSelector"], jsii.invoke(self, "toPodSelector", []))

# Adding a "__jsii_proxy_class__(): typing.Type" function to the interface
typing.cast(typing.Any, INetworkPolicyPeer).__jsii_proxy_class__ = lambda : _INetworkPolicyPeerProxy


@jsii.interface(jsii_type="cdk8s-plus-24.IPodSelector")
class IPodSelector(_constructs_77d1e7e8.IConstruct, typing_extensions.Protocol):
    '''Represents an object that can select pods.'''

    @jsii.member(jsii_name="toPodSelectorConfig")
    def to_pod_selector_config(self) -> "PodSelectorConfig":
        '''Return the configuration of this selector.'''
        ...


class _IPodSelectorProxy(
    jsii.proxy_for(_constructs_77d1e7e8.IConstruct), # type: ignore[misc]
):
    '''Represents an object that can select pods.'''

    __jsii_type__: typing.ClassVar[str] = "cdk8s-plus-24.IPodSelector"

    @jsii.member(jsii_name="toPodSelectorConfig")
    def to_pod_selector_config(self) -> "PodSelectorConfig":
        '''Return the configuration of this selector.'''
        return typing.cast("PodSelectorConfig", jsii.invoke(self, "toPodSelectorConfig", []))

# Adding a "__jsii_proxy_class__(): typing.Type" function to the interface
typing.cast(typing.Any, IPodSelector).__jsii_proxy_class__ = lambda : _IPodSelectorProxy


@jsii.interface(jsii_type="cdk8s-plus-24.IResource")
class IResource(
    _constructs_77d1e7e8.IConstruct,
    IApiResource,
    typing_extensions.Protocol,
):
    '''Represents a resource.'''

    @builtins.property
    @jsii.member(jsii_name="apiVersion")
    def api_version(self) -> builtins.str:
        '''The object's API version (e.g. "authorization.k8s.io/v1").'''
        ...

    @builtins.property
    @jsii.member(jsii_name="kind")
    def kind(self) -> builtins.str:
        '''The object kind (e.g. "Deployment").'''
        ...

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        '''The Kubernetes name of this resource.'''
        ...


class _IResourceProxy(
    jsii.proxy_for(_constructs_77d1e7e8.IConstruct), # type: ignore[misc]
    jsii.proxy_for(IApiResource), # type: ignore[misc]
):
    '''Represents a resource.'''

    __jsii_type__: typing.ClassVar[str] = "cdk8s-plus-24.IResource"

    @builtins.property
    @jsii.member(jsii_name="apiVersion")
    def api_version(self) -> builtins.str:
        '''The object's API version (e.g. "authorization.k8s.io/v1").'''
        return typing.cast(builtins.str, jsii.get(self, "apiVersion"))

    @builtins.property
    @jsii.member(jsii_name="kind")
    def kind(self) -> builtins.str:
        '''The object kind (e.g. "Deployment").'''
        return typing.cast(builtins.str, jsii.get(self, "kind"))

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        '''The Kubernetes name of this resource.'''
        return typing.cast(builtins.str, jsii.get(self, "name"))

# Adding a "__jsii_proxy_class__(): typing.Type" function to the interface
typing.cast(typing.Any, IResource).__jsii_proxy_class__ = lambda : _IResourceProxy


@jsii.interface(jsii_type="cdk8s-plus-24.IRole")
class IRole(IResource, typing_extensions.Protocol):
    '''A reference to any Role or ClusterRole.'''

    pass


class _IRoleProxy(
    jsii.proxy_for(IResource), # type: ignore[misc]
):
    '''A reference to any Role or ClusterRole.'''

    __jsii_type__: typing.ClassVar[str] = "cdk8s-plus-24.IRole"
    pass

# Adding a "__jsii_proxy_class__(): typing.Type" function to the interface
typing.cast(typing.Any, IRole).__jsii_proxy_class__ = lambda : _IRoleProxy


@jsii.interface(jsii_type="cdk8s-plus-24.IScalable")
class IScalable(typing_extensions.Protocol):
    '''Represents a scalable workload.'''

    @builtins.property
    @jsii.member(jsii_name="hasAutoscaler")
    def has_autoscaler(self) -> builtins.bool:
        '''If this is a target of an autoscaler.'''
        ...

    @has_autoscaler.setter
    def has_autoscaler(self, value: builtins.bool) -> None:
        ...

    @jsii.member(jsii_name="markHasAutoscaler")
    def mark_has_autoscaler(self) -> None:
        '''Called on all IScalable targets when they are associated with an autoscaler.'''
        ...

    @jsii.member(jsii_name="toScalingTarget")
    def to_scaling_target(self) -> "ScalingTarget":
        '''Return the target spec properties of this Scalable.'''
        ...


class _IScalableProxy:
    '''Represents a scalable workload.'''

    __jsii_type__: typing.ClassVar[str] = "cdk8s-plus-24.IScalable"

    @builtins.property
    @jsii.member(jsii_name="hasAutoscaler")
    def has_autoscaler(self) -> builtins.bool:
        '''If this is a target of an autoscaler.'''
        return typing.cast(builtins.bool, jsii.get(self, "hasAutoscaler"))

    @has_autoscaler.setter
    def has_autoscaler(self, value: builtins.bool) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__61f075f6e99626555c44b99353bb2b8b511dabea4f22862479abc0682a58512e)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "hasAutoscaler", value)

    @jsii.member(jsii_name="markHasAutoscaler")
    def mark_has_autoscaler(self) -> None:
        '''Called on all IScalable targets when they are associated with an autoscaler.'''
        return typing.cast(None, jsii.invoke(self, "markHasAutoscaler", []))

    @jsii.member(jsii_name="toScalingTarget")
    def to_scaling_target(self) -> "ScalingTarget":
        '''Return the target spec properties of this Scalable.'''
        return typing.cast("ScalingTarget", jsii.invoke(self, "toScalingTarget", []))

# Adding a "__jsii_proxy_class__(): typing.Type" function to the interface
typing.cast(typing.Any, IScalable).__jsii_proxy_class__ = lambda : _IScalableProxy


@jsii.interface(jsii_type="cdk8s-plus-24.ISecret")
class ISecret(IResource, typing_extensions.Protocol):
    @jsii.member(jsii_name="envValue")
    def env_value(
        self,
        key: builtins.str,
        *,
        optional: typing.Optional[builtins.bool] = None,
    ) -> EnvValue:
        '''Returns EnvValue object from a secret's key.

        :param key: Secret's key.
        :param optional: Specify whether the Secret or its key must be defined. Default: false
        '''
        ...


class _ISecretProxy(
    jsii.proxy_for(IResource), # type: ignore[misc]
):
    __jsii_type__: typing.ClassVar[str] = "cdk8s-plus-24.ISecret"

    @jsii.member(jsii_name="envValue")
    def env_value(
        self,
        key: builtins.str,
        *,
        optional: typing.Optional[builtins.bool] = None,
    ) -> EnvValue:
        '''Returns EnvValue object from a secret's key.

        :param key: Secret's key.
        :param optional: Specify whether the Secret or its key must be defined. Default: false
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__72d8e3375703812fd9d28714a92c9dbaedf2f65fa3c6dba33377524d15d679df)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
        options = EnvValueFromSecretOptions(optional=optional)

        return typing.cast(EnvValue, jsii.invoke(self, "envValue", [key, options]))

# Adding a "__jsii_proxy_class__(): typing.Type" function to the interface
typing.cast(typing.Any, ISecret).__jsii_proxy_class__ = lambda : _ISecretProxy


@jsii.interface(jsii_type="cdk8s-plus-24.IStorage")
class IStorage(_constructs_77d1e7e8.IConstruct, typing_extensions.Protocol):
    '''Represents a piece of storage in the cluster.'''

    @jsii.member(jsii_name="asVolume")
    def as_volume(self) -> "Volume":
        '''Convert the piece of storage into a concrete volume.'''
        ...


class _IStorageProxy(
    jsii.proxy_for(_constructs_77d1e7e8.IConstruct), # type: ignore[misc]
):
    '''Represents a piece of storage in the cluster.'''

    __jsii_type__: typing.ClassVar[str] = "cdk8s-plus-24.IStorage"

    @jsii.member(jsii_name="asVolume")
    def as_volume(self) -> "Volume":
        '''Convert the piece of storage into a concrete volume.'''
        return typing.cast("Volume", jsii.invoke(self, "asVolume", []))

# Adding a "__jsii_proxy_class__(): typing.Type" function to the interface
typing.cast(typing.Any, IStorage).__jsii_proxy_class__ = lambda : _IStorageProxy


@jsii.interface(jsii_type="cdk8s-plus-24.ISubject")
class ISubject(_constructs_77d1e7e8.IConstruct, typing_extensions.Protocol):
    '''Represents an object that can be used as a role binding subject.'''

    @jsii.member(jsii_name="toSubjectConfiguration")
    def to_subject_configuration(self) -> "SubjectConfiguration":
        '''Return the subject configuration.'''
        ...


class _ISubjectProxy(
    jsii.proxy_for(_constructs_77d1e7e8.IConstruct), # type: ignore[misc]
):
    '''Represents an object that can be used as a role binding subject.'''

    __jsii_type__: typing.ClassVar[str] = "cdk8s-plus-24.ISubject"

    @jsii.member(jsii_name="toSubjectConfiguration")
    def to_subject_configuration(self) -> "SubjectConfiguration":
        '''Return the subject configuration.'''
        return typing.cast("SubjectConfiguration", jsii.invoke(self, "toSubjectConfiguration", []))

# Adding a "__jsii_proxy_class__(): typing.Type" function to the interface
typing.cast(typing.Any, ISubject).__jsii_proxy_class__ = lambda : _ISubjectProxy


@jsii.enum(jsii_type="cdk8s-plus-24.ImagePullPolicy")
class ImagePullPolicy(enum.Enum):
    ALWAYS = "ALWAYS"
    '''Every time the kubelet launches a container, the kubelet queries the container image registry to resolve the name to an image digest.

    If the kubelet has a container image with that exact
    digest cached locally, the kubelet uses its cached image; otherwise, the kubelet downloads
    (pulls) the image with the resolved digest, and uses that image to launch the container.

    Default is Always if ImagePullPolicy is omitted and either the image tag is :latest or
    the image tag is omitted.
    '''
    IF_NOT_PRESENT = "IF_NOT_PRESENT"
    '''The image is pulled only if it is not already present locally.

    Default is IfNotPresent if ImagePullPolicy is omitted and the image tag is present but
    not :latest
    '''
    NEVER = "NEVER"
    '''The image is assumed to exist locally.

    No attempt is made to pull the image.
    '''


class IngressBackend(metaclass=jsii.JSIIMeta, jsii_type="cdk8s-plus-24.IngressBackend"):
    '''The backend for an ingress path.'''

    @jsii.member(jsii_name="fromResource")
    @builtins.classmethod
    def from_resource(cls, resource: IResource) -> "IngressBackend":
        '''A Resource backend is an ObjectRef to another Kubernetes resource within the same namespace as the Ingress object.

        A common usage for a Resource backend is to ingress data to an object
        storage backend with static assets.

        :param resource: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f980ccbb8266a9c5c52b2dddd1a75de2c2baf3e788f6132ef733fabb9d70d419)
            check_type(argname="argument resource", value=resource, expected_type=type_hints["resource"])
        return typing.cast("IngressBackend", jsii.sinvoke(cls, "fromResource", [resource]))

    @jsii.member(jsii_name="fromService")
    @builtins.classmethod
    def from_service(
        cls,
        serv: "Service",
        *,
        port: typing.Optional[jsii.Number] = None,
    ) -> "IngressBackend":
        '''A Kubernetes ``Service`` to use as the backend for this path.

        :param serv: The service object.
        :param port: The port to use to access the service. - This option will fail if the service does not expose any ports. - If the service exposes multiple ports, this option must be specified. - If the service exposes a single port, this option is optional and if specified, it must be the same port exposed by the service. Default: - if the service exposes a single port, this port will be used.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1c2be242e35df913450e52debce7161a776703e6a3f77257cf66296984e6283b)
            check_type(argname="argument serv", value=serv, expected_type=type_hints["serv"])
        options = ServiceIngressBackendOptions(port=port)

        return typing.cast("IngressBackend", jsii.sinvoke(cls, "fromService", [serv, options]))


@jsii.data_type(
    jsii_type="cdk8s-plus-24.IngressRule",
    jsii_struct_bases=[],
    name_mapping={
        "backend": "backend",
        "host": "host",
        "path": "path",
        "path_type": "pathType",
    },
)
class IngressRule:
    def __init__(
        self,
        *,
        backend: IngressBackend,
        host: typing.Optional[builtins.str] = None,
        path: typing.Optional[builtins.str] = None,
        path_type: typing.Optional[HttpIngressPathType] = None,
    ) -> None:
        '''Represents the rules mapping the paths under a specified host to the related backend services.

        Incoming requests are first evaluated for a host match,
        then routed to the backend associated with the matching path.

        :param backend: Backend defines the referenced service endpoint to which the traffic will be forwarded to.
        :param host: Host is the fully qualified domain name of a network host, as defined by RFC 3986. Note the following deviations from the "host" part of the URI as defined in the RFC: 1. IPs are not allowed. Currently an IngressRuleValue can only apply to the IP in the Spec of the parent Ingress. 2. The ``:`` delimiter is not respected because ports are not allowed. Currently the port of an Ingress is implicitly :80 for http and :443 for https. Both these may change in the future. Incoming requests are matched against the host before the IngressRuleValue. Default: - If the host is unspecified, the Ingress routes all traffic based on the specified IngressRuleValue.
        :param path: Path is an extended POSIX regex as defined by IEEE Std 1003.1, (i.e this follows the egrep/unix syntax, not the perl syntax) matched against the path of an incoming request. Currently it can contain characters disallowed from the conventional "path" part of a URL as defined by RFC 3986. Paths must begin with a '/'. Default: - If unspecified, the path defaults to a catch all sending traffic to the backend.
        :param path_type: Specify how the path is matched against request paths. By default, path types will be matched by prefix.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9d61cce0780bb44e77be64dbac2a11fad8e57bb22f1bf6b5fcf6ee125f3c9284)
            check_type(argname="argument backend", value=backend, expected_type=type_hints["backend"])
            check_type(argname="argument host", value=host, expected_type=type_hints["host"])
            check_type(argname="argument path", value=path, expected_type=type_hints["path"])
            check_type(argname="argument path_type", value=path_type, expected_type=type_hints["path_type"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "backend": backend,
        }
        if host is not None:
            self._values["host"] = host
        if path is not None:
            self._values["path"] = path
        if path_type is not None:
            self._values["path_type"] = path_type

    @builtins.property
    def backend(self) -> IngressBackend:
        '''Backend defines the referenced service endpoint to which the traffic will be forwarded to.'''
        result = self._values.get("backend")
        assert result is not None, "Required property 'backend' is missing"
        return typing.cast(IngressBackend, result)

    @builtins.property
    def host(self) -> typing.Optional[builtins.str]:
        '''Host is the fully qualified domain name of a network host, as defined by RFC 3986.

        Note the following deviations from the "host" part of the URI as
        defined in the RFC: 1. IPs are not allowed. Currently an IngressRuleValue
        can only apply to the IP in the Spec of the parent Ingress. 2. The ``:``
        delimiter is not respected because ports are not allowed. Currently the
        port of an Ingress is implicitly :80 for http and :443 for https. Both
        these may change in the future. Incoming requests are matched against the
        host before the IngressRuleValue.

        :default:

        - If the host is unspecified, the Ingress routes all traffic based
        on the specified IngressRuleValue.
        '''
        result = self._values.get("host")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def path(self) -> typing.Optional[builtins.str]:
        '''Path is an extended POSIX regex as defined by IEEE Std 1003.1, (i.e this follows the egrep/unix syntax, not the perl syntax) matched against the path of an incoming request. Currently it can contain characters disallowed from the conventional "path" part of a URL as defined by RFC 3986. Paths must begin with a '/'.

        :default:

        - If unspecified, the path defaults to a catch all sending traffic
        to the backend.
        '''
        result = self._values.get("path")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def path_type(self) -> typing.Optional[HttpIngressPathType]:
        '''Specify how the path is matched against request paths.

        By default, path
        types will be matched by prefix.

        :see: https://kubernetes.io/docs/concepts/services-networking/ingress/#path-types
        '''
        result = self._values.get("path_type")
        return typing.cast(typing.Optional[HttpIngressPathType], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "IngressRule(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.IngressTls",
    jsii_struct_bases=[],
    name_mapping={"hosts": "hosts", "secret": "secret"},
)
class IngressTls:
    def __init__(
        self,
        *,
        hosts: typing.Optional[typing.Sequence[builtins.str]] = None,
        secret: typing.Optional[ISecret] = None,
    ) -> None:
        '''Represents the TLS configuration mapping that is passed to the ingress controller for SSL termination.

        :param hosts: Hosts are a list of hosts included in the TLS certificate. The values in this list must match the name/s used in the TLS Secret. Default: - If unspecified, it defaults to the wildcard host setting for the loadbalancer controller fulfilling this Ingress.
        :param secret: Secret is the secret that contains the certificate and key used to terminate SSL traffic on 443. If the SNI host in a listener conflicts with the "Host" header field used by an IngressRule, the SNI host is used for termination and value of the Host header is used for routing. Default: - If unspecified, it allows SSL routing based on SNI hostname.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__28469dd145b36f27d7dc99e0f6c32673124748a8aa44963c504f335b5f63c189)
            check_type(argname="argument hosts", value=hosts, expected_type=type_hints["hosts"])
            check_type(argname="argument secret", value=secret, expected_type=type_hints["secret"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if hosts is not None:
            self._values["hosts"] = hosts
        if secret is not None:
            self._values["secret"] = secret

    @builtins.property
    def hosts(self) -> typing.Optional[typing.List[builtins.str]]:
        '''Hosts are a list of hosts included in the TLS certificate.

        The values in
        this list must match the name/s used in the TLS Secret.

        :default:

        - If unspecified, it defaults to the wildcard host setting for
        the loadbalancer controller fulfilling this Ingress.
        '''
        result = self._values.get("hosts")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def secret(self) -> typing.Optional[ISecret]:
        '''Secret is the secret that contains the certificate and key used to terminate SSL traffic on 443.

        If the SNI host in a listener conflicts with
        the "Host" header field used by an IngressRule, the SNI host is used for
        termination and value of the Host header is used for routing.

        :default: - If unspecified, it allows SSL routing based on SNI hostname.
        '''
        result = self._values.get("secret")
        return typing.cast(typing.Optional[ISecret], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "IngressTls(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class LabelExpression(
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-24.LabelExpression",
):
    '''Represents a query that can be performed against resources with labels.'''

    @jsii.member(jsii_name="doesNotExist")
    @builtins.classmethod
    def does_not_exist(cls, key: builtins.str) -> "LabelExpression":
        '''Requires label ``key`` to not exist.

        :param key: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f283044a6748e8e6e9fe519ac031bb67097281d2a81ab5fede372a9e8e96b30b)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
        return typing.cast("LabelExpression", jsii.sinvoke(cls, "doesNotExist", [key]))

    @jsii.member(jsii_name="exists")
    @builtins.classmethod
    def exists(cls, key: builtins.str) -> "LabelExpression":
        '''Requires label ``key`` to exist.

        :param key: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d42555103ce07b771c5667c5cab96d59336c864a8388dde6c32d865cc0389e84)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
        return typing.cast("LabelExpression", jsii.sinvoke(cls, "exists", [key]))

    @jsii.member(jsii_name="in")
    @builtins.classmethod
    def in_(
        cls,
        key: builtins.str,
        values: typing.Sequence[builtins.str],
    ) -> "LabelExpression":
        '''Requires value of label ``key`` to be one of ``values``.

        :param key: -
        :param values: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a4eb13437127c6df26f87501efab75d4136ce6cc6383301e873f0667576f9f26)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument values", value=values, expected_type=type_hints["values"])
        return typing.cast("LabelExpression", jsii.sinvoke(cls, "in", [key, values]))

    @jsii.member(jsii_name="notIn")
    @builtins.classmethod
    def not_in(
        cls,
        key: builtins.str,
        values: typing.Sequence[builtins.str],
    ) -> "LabelExpression":
        '''Requires value of label ``key`` to be none of ``values``.

        :param key: -
        :param values: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a2f8777b9ddc0c422a5cf513db433758205af27dd6731a1260b2d5c25c67ef65)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument values", value=values, expected_type=type_hints["values"])
        return typing.cast("LabelExpression", jsii.sinvoke(cls, "notIn", [key, values]))

    @builtins.property
    @jsii.member(jsii_name="key")
    def key(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "key"))

    @builtins.property
    @jsii.member(jsii_name="operator")
    def operator(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "operator"))

    @builtins.property
    @jsii.member(jsii_name="values")
    def values(self) -> typing.Optional[typing.List[builtins.str]]:
        return typing.cast(typing.Optional[typing.List[builtins.str]], jsii.get(self, "values"))


class LabelSelector(metaclass=jsii.JSIIMeta, jsii_type="cdk8s-plus-24.LabelSelector"):
    '''Match a resource by labels.'''

    @jsii.member(jsii_name="of")
    @builtins.classmethod
    def of(
        cls,
        *,
        expressions: typing.Optional[typing.Sequence[LabelExpression]] = None,
        labels: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
    ) -> "LabelSelector":
        '''
        :param expressions: Expression based label matchers.
        :param labels: Strict label matchers.
        '''
        options = LabelSelectorOptions(expressions=expressions, labels=labels)

        return typing.cast("LabelSelector", jsii.sinvoke(cls, "of", [options]))

    @jsii.member(jsii_name="isEmpty")
    def is_empty(self) -> builtins.bool:
        return typing.cast(builtins.bool, jsii.invoke(self, "isEmpty", []))


@jsii.data_type(
    jsii_type="cdk8s-plus-24.LabelSelectorOptions",
    jsii_struct_bases=[],
    name_mapping={"expressions": "expressions", "labels": "labels"},
)
class LabelSelectorOptions:
    def __init__(
        self,
        *,
        expressions: typing.Optional[typing.Sequence[LabelExpression]] = None,
        labels: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
    ) -> None:
        '''Options for ``LabelSelector.of``.

        :param expressions: Expression based label matchers.
        :param labels: Strict label matchers.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__22ffe668957a8fa629dd5d21bf93c5f80990c0787e2bc65932982f068bacd6ba)
            check_type(argname="argument expressions", value=expressions, expected_type=type_hints["expressions"])
            check_type(argname="argument labels", value=labels, expected_type=type_hints["labels"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if expressions is not None:
            self._values["expressions"] = expressions
        if labels is not None:
            self._values["labels"] = labels

    @builtins.property
    def expressions(self) -> typing.Optional[typing.List[LabelExpression]]:
        '''Expression based label matchers.'''
        result = self._values.get("expressions")
        return typing.cast(typing.Optional[typing.List[LabelExpression]], result)

    @builtins.property
    def labels(self) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        '''Strict label matchers.'''
        result = self._values.get("labels")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "LabelSelectorOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.LabelSelectorRequirement",
    jsii_struct_bases=[],
    name_mapping={"key": "key", "operator": "operator", "values": "values"},
)
class LabelSelectorRequirement:
    def __init__(
        self,
        *,
        key: builtins.str,
        operator: builtins.str,
        values: typing.Optional[typing.Sequence[builtins.str]] = None,
    ) -> None:
        '''A label selector requirement is a selector that contains values, a key, and an operator that relates the key and values.

        :param key: The label key that the selector applies to.
        :param operator: Represents a key's relationship to a set of values.
        :param values: An array of string values. If the operator is In or NotIn, the values array must be non-empty. If the operator is Exists or DoesNotExist, the values array must be empty. This array is replaced during a strategic merge patch.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c795a839817ffd67daa74ac4bd2b45c63a60fd84fcd4307ee1988e6119caa37f)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
            check_type(argname="argument values", value=values, expected_type=type_hints["values"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "key": key,
            "operator": operator,
        }
        if values is not None:
            self._values["values"] = values

    @builtins.property
    def key(self) -> builtins.str:
        '''The label key that the selector applies to.'''
        result = self._values.get("key")
        assert result is not None, "Required property 'key' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def operator(self) -> builtins.str:
        '''Represents a key's relationship to a set of values.'''
        result = self._values.get("operator")
        assert result is not None, "Required property 'operator' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def values(self) -> typing.Optional[typing.List[builtins.str]]:
        '''An array of string values.

        If the operator is In or NotIn, the values array
        must be non-empty. If the operator is Exists or DoesNotExist,
        the values array must be empty. This array is replaced during a strategic merge patch.
        '''
        result = self._values.get("values")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "LabelSelectorRequirement(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class LabeledNode(metaclass=jsii.JSIIMeta, jsii_type="cdk8s-plus-24.LabeledNode"):
    '''A node that is matched by label selectors.'''

    def __init__(self, label_selector: typing.Sequence["NodeLabelQuery"]) -> None:
        '''
        :param label_selector: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c94794b4950eea1789480a463090cd3e097e356a6084af8bf121b1a3848727d3)
            check_type(argname="argument label_selector", value=label_selector, expected_type=type_hints["label_selector"])
        jsii.create(self.__class__, self, [label_selector])

    @builtins.property
    @jsii.member(jsii_name="labelSelector")
    def label_selector(self) -> typing.List["NodeLabelQuery"]:
        return typing.cast(typing.List["NodeLabelQuery"], jsii.get(self, "labelSelector"))


@jsii.data_type(
    jsii_type="cdk8s-plus-24.MemoryResources",
    jsii_struct_bases=[],
    name_mapping={"limit": "limit", "request": "request"},
)
class MemoryResources:
    def __init__(
        self,
        *,
        limit: typing.Optional[_cdk8s_d3d9af27.Size] = None,
        request: typing.Optional[_cdk8s_d3d9af27.Size] = None,
    ) -> None:
        '''Memory request and limit.

        :param limit: 
        :param request: 
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__262e3a8d494277549461405de4c6e55b55bae9ce87e65ca1357a3c3eb0388b11)
            check_type(argname="argument limit", value=limit, expected_type=type_hints["limit"])
            check_type(argname="argument request", value=request, expected_type=type_hints["request"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if limit is not None:
            self._values["limit"] = limit
        if request is not None:
            self._values["request"] = request

    @builtins.property
    def limit(self) -> typing.Optional[_cdk8s_d3d9af27.Size]:
        result = self._values.get("limit")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Size], result)

    @builtins.property
    def request(self) -> typing.Optional[_cdk8s_d3d9af27.Size]:
        result = self._values.get("request")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Size], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "MemoryResources(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class Metric(metaclass=jsii.JSIIMeta, jsii_type="cdk8s-plus-24.Metric"):
    '''A metric condition that HorizontalPodAutoscaler's scale on.'''

    @jsii.member(jsii_name="containerCpu")
    @builtins.classmethod
    def container_cpu(cls, *, container: Container, target: "MetricTarget") -> "Metric":
        '''Metric that tracks the CPU of a container.

        This metric
        will be tracked across all pods of the current scale target.

        :param container: Container where the metric can be found.
        :param target: Target metric value that will trigger scaling.
        '''
        options = MetricContainerResourceOptions(container=container, target=target)

        return typing.cast("Metric", jsii.sinvoke(cls, "containerCpu", [options]))

    @jsii.member(jsii_name="containerEphemeralStorage")
    @builtins.classmethod
    def container_ephemeral_storage(
        cls,
        *,
        container: Container,
        target: "MetricTarget",
    ) -> "Metric":
        '''Metric that tracks the local ephemeral storage of a container.

        This metric
        will be tracked across all pods of the current scale target.

        :param container: Container where the metric can be found.
        :param target: Target metric value that will trigger scaling.
        '''
        options = MetricContainerResourceOptions(container=container, target=target)

        return typing.cast("Metric", jsii.sinvoke(cls, "containerEphemeralStorage", [options]))

    @jsii.member(jsii_name="containerMemory")
    @builtins.classmethod
    def container_memory(
        cls,
        *,
        container: Container,
        target: "MetricTarget",
    ) -> "Metric":
        '''Metric that tracks the Memory of a container.

        This metric
        will be tracked across all pods of the current scale target.

        :param container: Container where the metric can be found.
        :param target: Target metric value that will trigger scaling.
        '''
        options = MetricContainerResourceOptions(container=container, target=target)

        return typing.cast("Metric", jsii.sinvoke(cls, "containerMemory", [options]))

    @jsii.member(jsii_name="containerStorage")
    @builtins.classmethod
    def container_storage(
        cls,
        *,
        container: Container,
        target: "MetricTarget",
    ) -> "Metric":
        '''Metric that tracks the volume size of a container.

        This metric
        will be tracked across all pods of the current scale target.

        :param container: Container where the metric can be found.
        :param target: Target metric value that will trigger scaling.
        '''
        options = MetricContainerResourceOptions(container=container, target=target)

        return typing.cast("Metric", jsii.sinvoke(cls, "containerStorage", [options]))

    @jsii.member(jsii_name="external")
    @builtins.classmethod
    def external(
        cls,
        *,
        name: builtins.str,
        target: "MetricTarget",
        label_selector: typing.Optional[LabelSelector] = None,
    ) -> "Metric":
        '''A global metric that is not associated with any Kubernetes object.

        Allows for autoscaling based on information coming from components running outside of
        the cluster.

        Use case:

        - Scale up when the length of an SQS queue is greater than 10 messages.
        - Scale down when an outside load balancer's queries are less than 10000 per second.

        :param name: The name of the metric to scale on.
        :param target: The target metric value that will trigger scaling.
        :param label_selector: A selector to find a metric by label. When set, it is passed as an additional parameter to the metrics server for more specific metrics scoping. Default: - Just the metric 'name' will be used to gather metrics.
        '''
        options = MetricOptions(
            name=name, target=target, label_selector=label_selector
        )

        return typing.cast("Metric", jsii.sinvoke(cls, "external", [options]))

    @jsii.member(jsii_name="object")
    @builtins.classmethod
    def object(
        cls,
        *,
        object: IResource,
        name: builtins.str,
        target: "MetricTarget",
        label_selector: typing.Optional[LabelSelector] = None,
    ) -> "Metric":
        '''Metric that describes a metric of a kubernetes object.

        Use case:

        - Scale on a Kubernetes Ingress's hits-per-second metric.

        :param object: Resource where the metric can be found.
        :param name: The name of the metric to scale on.
        :param target: The target metric value that will trigger scaling.
        :param label_selector: A selector to find a metric by label. When set, it is passed as an additional parameter to the metrics server for more specific metrics scoping. Default: - Just the metric 'name' will be used to gather metrics.
        '''
        options = MetricObjectOptions(
            object=object, name=name, target=target, label_selector=label_selector
        )

        return typing.cast("Metric", jsii.sinvoke(cls, "object", [options]))

    @jsii.member(jsii_name="pods")
    @builtins.classmethod
    def pods(
        cls,
        *,
        name: builtins.str,
        target: "MetricTarget",
        label_selector: typing.Optional[LabelSelector] = None,
    ) -> "Metric":
        '''A pod metric that will be averaged across all pods of the current scale target.

        Use case:

        - Average CPU utilization across all pods
        - Transactions processed per second across all pods

        :param name: The name of the metric to scale on.
        :param target: The target metric value that will trigger scaling.
        :param label_selector: A selector to find a metric by label. When set, it is passed as an additional parameter to the metrics server for more specific metrics scoping. Default: - Just the metric 'name' will be used to gather metrics.
        '''
        options = MetricOptions(
            name=name, target=target, label_selector=label_selector
        )

        return typing.cast("Metric", jsii.sinvoke(cls, "pods", [options]))

    @jsii.member(jsii_name="resourceCpu")
    @builtins.classmethod
    def resource_cpu(cls, target: "MetricTarget") -> "Metric":
        '''Tracks the available CPU of the pods in a target.

        Note: Since the resource usages of all the containers are summed up the total
        pod utilization may not accurately represent the individual container resource
        usage. This could lead to situations where a single container might be running
        with high usage and the HPA will not scale out because the overall pod usage
        is still within acceptable limits.

        Use case:

        - Scale up when CPU is above 40%.

        :param target: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3a92caae2e7953aa0c4733e688089a1bf93754d85dcfdc5fb9cbeed3c24ad6a6)
            check_type(argname="argument target", value=target, expected_type=type_hints["target"])
        return typing.cast("Metric", jsii.sinvoke(cls, "resourceCpu", [target]))

    @jsii.member(jsii_name="resourceEphemeralStorage")
    @builtins.classmethod
    def resource_ephemeral_storage(cls, target: "MetricTarget") -> "Metric":
        '''Tracks the available Ephemeral Storage of the pods in a target.

        Note: Since the resource usages of all the containers are summed up the total
        pod utilization may not accurately represent the individual container resource
        usage. This could lead to situations where a single container might be running
        with high usage and the HPA will not scale out because the overall pod usage
        is still within acceptable limits.

        :param target: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__781cf8e10adbe78dbc317ad8e9d58877fe087197965f80a42409b0316f69b647)
            check_type(argname="argument target", value=target, expected_type=type_hints["target"])
        return typing.cast("Metric", jsii.sinvoke(cls, "resourceEphemeralStorage", [target]))

    @jsii.member(jsii_name="resourceMemory")
    @builtins.classmethod
    def resource_memory(cls, target: "MetricTarget") -> "Metric":
        '''Tracks the available Memory of the pods in a target.

        Note: Since the resource usages of all the containers are summed up the total
        pod utilization may not accurately represent the individual container resource
        usage. This could lead to situations where a single container might be running
        with high usage and the HPA will not scale out because the overall pod usage
        is still within acceptable limits.

        Use case:

        - Scale up when Memory is above 512MB.

        :param target: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d38a9d4332d585b5ad944d44681aec86c477a9b75c2986a6334f2b35aa4ffc67)
            check_type(argname="argument target", value=target, expected_type=type_hints["target"])
        return typing.cast("Metric", jsii.sinvoke(cls, "resourceMemory", [target]))

    @jsii.member(jsii_name="resourceStorage")
    @builtins.classmethod
    def resource_storage(cls, target: "MetricTarget") -> "Metric":
        '''Tracks the available Storage of the pods in a target.

        Note: Since the resource usages of all the containers are summed up the total
        pod utilization may not accurately represent the individual container resource
        usage. This could lead to situations where a single container might be running
        with high usage and the HPA will not scale out because the overall pod usage
        is still within acceptable limits.

        :param target: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f04e90388cf3c5f913bc9687f1e28778331c4353ea73d42c1ed61dbce9b32655)
            check_type(argname="argument target", value=target, expected_type=type_hints["target"])
        return typing.cast("Metric", jsii.sinvoke(cls, "resourceStorage", [target]))

    @builtins.property
    @jsii.member(jsii_name="type")
    def type(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "type"))


@jsii.data_type(
    jsii_type="cdk8s-plus-24.MetricContainerResourceOptions",
    jsii_struct_bases=[],
    name_mapping={"container": "container", "target": "target"},
)
class MetricContainerResourceOptions:
    def __init__(self, *, container: Container, target: "MetricTarget") -> None:
        '''Options for ``Metric.containerResource()``.

        :param container: Container where the metric can be found.
        :param target: Target metric value that will trigger scaling.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c47726a930e56a6a33cee4d96707bce939a338a0e0bac87a508472a6c4b341b4)
            check_type(argname="argument container", value=container, expected_type=type_hints["container"])
            check_type(argname="argument target", value=target, expected_type=type_hints["target"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "container": container,
            "target": target,
        }

    @builtins.property
    def container(self) -> Container:
        '''Container where the metric can be found.'''
        result = self._values.get("container")
        assert result is not None, "Required property 'container' is missing"
        return typing.cast(Container, result)

    @builtins.property
    def target(self) -> "MetricTarget":
        '''Target metric value that will trigger scaling.'''
        result = self._values.get("target")
        assert result is not None, "Required property 'target' is missing"
        return typing.cast("MetricTarget", result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "MetricContainerResourceOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.MetricOptions",
    jsii_struct_bases=[],
    name_mapping={
        "name": "name",
        "target": "target",
        "label_selector": "labelSelector",
    },
)
class MetricOptions:
    def __init__(
        self,
        *,
        name: builtins.str,
        target: "MetricTarget",
        label_selector: typing.Optional[LabelSelector] = None,
    ) -> None:
        '''Base options for a Metric.

        :param name: The name of the metric to scale on.
        :param target: The target metric value that will trigger scaling.
        :param label_selector: A selector to find a metric by label. When set, it is passed as an additional parameter to the metrics server for more specific metrics scoping. Default: - Just the metric 'name' will be used to gather metrics.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c8a028d9d4ba366bef80918903aa0dbdb7da3f66d3c5e0676e59d341a66841dc)
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument target", value=target, expected_type=type_hints["target"])
            check_type(argname="argument label_selector", value=label_selector, expected_type=type_hints["label_selector"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "name": name,
            "target": target,
        }
        if label_selector is not None:
            self._values["label_selector"] = label_selector

    @builtins.property
    def name(self) -> builtins.str:
        '''The name of the metric to scale on.'''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def target(self) -> "MetricTarget":
        '''The target metric value that will trigger scaling.'''
        result = self._values.get("target")
        assert result is not None, "Required property 'target' is missing"
        return typing.cast("MetricTarget", result)

    @builtins.property
    def label_selector(self) -> typing.Optional[LabelSelector]:
        '''A selector to find a metric by label.

        When set, it is passed as an additional parameter to the metrics server
        for more specific metrics scoping.

        :default: - Just the metric 'name' will be used to gather metrics.
        '''
        result = self._values.get("label_selector")
        return typing.cast(typing.Optional[LabelSelector], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "MetricOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class MetricTarget(metaclass=jsii.JSIIMeta, jsii_type="cdk8s-plus-24.MetricTarget"):
    '''A metric condition that will trigger scaling behavior when satisfied.

    Example::

        MetricTarget.averageUtilization(70); // 70% average utilization
    '''

    @jsii.member(jsii_name="averageUtilization")
    @builtins.classmethod
    def average_utilization(cls, average_utilization: jsii.Number) -> "MetricTarget":
        '''Target a percentage value across all relevant pods.

        :param average_utilization: The percentage of the utilization metric. e.g. ``50`` for 50%.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__80b7fb4a9d00ae0b6953b931f88610c7e07f498800aafd66794828246db1d60d)
            check_type(argname="argument average_utilization", value=average_utilization, expected_type=type_hints["average_utilization"])
        return typing.cast("MetricTarget", jsii.sinvoke(cls, "averageUtilization", [average_utilization]))

    @jsii.member(jsii_name="averageValue")
    @builtins.classmethod
    def average_value(cls, average_value: jsii.Number) -> "MetricTarget":
        '''Target the average value across all relevant pods.

        :param average_value: The average metric value.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d3adde87cf0c9fad6ac7f6cc0422bdc602a56fc9636fa3ecd9e7ce1fbfcd3962)
            check_type(argname="argument average_value", value=average_value, expected_type=type_hints["average_value"])
        return typing.cast("MetricTarget", jsii.sinvoke(cls, "averageValue", [average_value]))

    @jsii.member(jsii_name="value")
    @builtins.classmethod
    def value(cls, value: jsii.Number) -> "MetricTarget":
        '''Target a specific target value.

        :param value: The target value.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__af6c16252a4afc31b74f322f25fb154072fab8e59856709f500dacf15ded0cd0)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast("MetricTarget", jsii.sinvoke(cls, "value", [value]))


@jsii.data_type(
    jsii_type="cdk8s-plus-24.MountOptions",
    jsii_struct_bases=[],
    name_mapping={
        "propagation": "propagation",
        "read_only": "readOnly",
        "sub_path": "subPath",
        "sub_path_expr": "subPathExpr",
    },
)
class MountOptions:
    def __init__(
        self,
        *,
        propagation: typing.Optional["MountPropagation"] = None,
        read_only: typing.Optional[builtins.bool] = None,
        sub_path: typing.Optional[builtins.str] = None,
        sub_path_expr: typing.Optional[builtins.str] = None,
    ) -> None:
        '''Options for mounts.

        :param propagation: Determines how mounts are propagated from the host to container and the other way around. When not set, MountPropagationNone is used. Mount propagation allows for sharing volumes mounted by a Container to other Containers in the same Pod, or even to other Pods on the same node. Default: MountPropagation.NONE
        :param read_only: Mounted read-only if true, read-write otherwise (false or unspecified). Defaults to false. Default: false
        :param sub_path: Path within the volume from which the container's volume should be mounted.). Default: "" the volume's root
        :param sub_path_expr: Expanded path within the volume from which the container's volume should be mounted. Behaves similarly to SubPath but environment variable references $(VAR_NAME) are expanded using the container's environment. Defaults to "" (volume's root). ``subPathExpr`` and ``subPath`` are mutually exclusive. Default: "" volume's root.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1e4a64d72517fd53f644fc493c33d7efa49d43d9dc897de3d29f40765eabb6a3)
            check_type(argname="argument propagation", value=propagation, expected_type=type_hints["propagation"])
            check_type(argname="argument read_only", value=read_only, expected_type=type_hints["read_only"])
            check_type(argname="argument sub_path", value=sub_path, expected_type=type_hints["sub_path"])
            check_type(argname="argument sub_path_expr", value=sub_path_expr, expected_type=type_hints["sub_path_expr"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if propagation is not None:
            self._values["propagation"] = propagation
        if read_only is not None:
            self._values["read_only"] = read_only
        if sub_path is not None:
            self._values["sub_path"] = sub_path
        if sub_path_expr is not None:
            self._values["sub_path_expr"] = sub_path_expr

    @builtins.property
    def propagation(self) -> typing.Optional["MountPropagation"]:
        '''Determines how mounts are propagated from the host to container and the other way around.

        When not set, MountPropagationNone is used.

        Mount propagation allows for sharing volumes mounted by a Container to
        other Containers in the same Pod, or even to other Pods on the same node.

        :default: MountPropagation.NONE
        '''
        result = self._values.get("propagation")
        return typing.cast(typing.Optional["MountPropagation"], result)

    @builtins.property
    def read_only(self) -> typing.Optional[builtins.bool]:
        '''Mounted read-only if true, read-write otherwise (false or unspecified).

        Defaults to false.

        :default: false
        '''
        result = self._values.get("read_only")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def sub_path(self) -> typing.Optional[builtins.str]:
        '''Path within the volume from which the container's volume should be mounted.).

        :default: "" the volume's root
        '''
        result = self._values.get("sub_path")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def sub_path_expr(self) -> typing.Optional[builtins.str]:
        '''Expanded path within the volume from which the container's volume should be mounted.

        Behaves similarly to SubPath but environment variable references
        $(VAR_NAME) are expanded using the container's environment. Defaults to ""
        (volume's root).

        ``subPathExpr`` and ``subPath`` are mutually exclusive.

        :default: "" volume's root.
        '''
        result = self._values.get("sub_path_expr")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "MountOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.enum(jsii_type="cdk8s-plus-24.MountPropagation")
class MountPropagation(enum.Enum):
    NONE = "NONE"
    '''This volume mount will not receive any subsequent mounts that are mounted to this volume or any of its subdirectories by the host.

    In similar
    fashion, no mounts created by the Container will be visible on the host.

    This is the default mode.

    This mode is equal to ``private`` mount propagation as described in the Linux
    kernel documentation
    '''
    HOST_TO_CONTAINER = "HOST_TO_CONTAINER"
    '''This volume mount will receive all subsequent mounts that are mounted to this volume or any of its subdirectories.

    In other words, if the host mounts anything inside the volume mount, the
    Container will see it mounted there.

    Similarly, if any Pod with Bidirectional mount propagation to the same
    volume mounts anything there, the Container with HostToContainer mount
    propagation will see it.

    This mode is equal to ``rslave`` mount propagation as described in the Linux
    kernel documentation
    '''
    BIDIRECTIONAL = "BIDIRECTIONAL"
    '''This volume mount behaves the same the HostToContainer mount.

    In addition,
    all volume mounts created by the Container will be propagated back to the
    host and to all Containers of all Pods that use the same volume

    A typical use case for this mode is a Pod with a FlexVolume or CSI driver
    or a Pod that needs to mount something on the host using a hostPath volume.

    This mode is equal to ``rshared`` mount propagation as described in the Linux
    kernel documentation

    Caution: Bidirectional mount propagation can be dangerous. It can damage
    the host operating system and therefore it is allowed only in privileged
    Containers. Familiarity with Linux kernel behavior is strongly recommended.
    In addition, any volume mounts created by Containers in Pods must be
    destroyed (unmounted) by the Containers on termination.
    '''


class NamedNode(metaclass=jsii.JSIIMeta, jsii_type="cdk8s-plus-24.NamedNode"):
    '''A node that is matched by its name.'''

    def __init__(self, name: builtins.str) -> None:
        '''
        :param name: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__89c198222ba41ceb19991b4ea2cd4619e5fa4a3ea248e812e23f6b883af4eb9e)
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
        jsii.create(self.__class__, self, [name])

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "name"))


@jsii.data_type(
    jsii_type="cdk8s-plus-24.NamespaceSelectorConfig",
    jsii_struct_bases=[],
    name_mapping={"label_selector": "labelSelector", "names": "names"},
)
class NamespaceSelectorConfig:
    def __init__(
        self,
        *,
        label_selector: typing.Optional[LabelSelector] = None,
        names: typing.Optional[typing.Sequence[builtins.str]] = None,
    ) -> None:
        '''Configuration for selecting namespaces.

        :param label_selector: A selector to select namespaces by labels.
        :param names: A list of names to select namespaces by names.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__7c139600d6587d1f90ba3a05166b46fc3b237d60adeab53b0f64d30064b85243)
            check_type(argname="argument label_selector", value=label_selector, expected_type=type_hints["label_selector"])
            check_type(argname="argument names", value=names, expected_type=type_hints["names"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if label_selector is not None:
            self._values["label_selector"] = label_selector
        if names is not None:
            self._values["names"] = names

    @builtins.property
    def label_selector(self) -> typing.Optional[LabelSelector]:
        '''A selector to select namespaces by labels.'''
        result = self._values.get("label_selector")
        return typing.cast(typing.Optional[LabelSelector], result)

    @builtins.property
    def names(self) -> typing.Optional[typing.List[builtins.str]]:
        '''A list of names to select namespaces by names.'''
        result = self._values.get("names")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "NamespaceSelectorConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(INamespaceSelector, INetworkPolicyPeer)
class Namespaces(
    _constructs_77d1e7e8.Construct,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-24.Namespaces",
):
    '''Represents a group of namespaces.'''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        expressions: typing.Optional[typing.Sequence[LabelExpression]] = None,
        names: typing.Optional[typing.Sequence[builtins.str]] = None,
        labels: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param expressions: -
        :param names: -
        :param labels: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__db5c743e859205ad52cd9708cb16bf0a41e20b73d535144a3bab804e16e080ce)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
            check_type(argname="argument expressions", value=expressions, expected_type=type_hints["expressions"])
            check_type(argname="argument names", value=names, expected_type=type_hints["names"])
            check_type(argname="argument labels", value=labels, expected_type=type_hints["labels"])
        jsii.create(self.__class__, self, [scope, id, expressions, names, labels])

    @jsii.member(jsii_name="all")
    @builtins.classmethod
    def all(
        cls,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
    ) -> "Namespaces":
        '''Select all namespaces.

        :param scope: -
        :param id: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1c2f7cd434bb29c65f9458ac7ea6ad471302bcdce4dd31c68663c5349bdab5af)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        return typing.cast("Namespaces", jsii.sinvoke(cls, "all", [scope, id]))

    @jsii.member(jsii_name="select")
    @builtins.classmethod
    def select(
        cls,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        expressions: typing.Optional[typing.Sequence[LabelExpression]] = None,
        labels: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        names: typing.Optional[typing.Sequence[builtins.str]] = None,
    ) -> "Namespaces":
        '''Select specific namespaces.

        :param scope: -
        :param id: -
        :param expressions: Namespaces must satisfy these selectors. The selectors query labels, just like the ``labels`` property, but they provide a more advanced matching mechanism. Default: - no selector requirements.
        :param labels: Labels the namespaces must have. This is equivalent to using an 'Is' selector. Default: - no strict labels requirements.
        :param names: Namespaces names must be one of these. Default: - no name requirements.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__870fa48a7c83ed3e2583d8de6a660e3e5c1b7532d9fb9fe442c55a55c1fe0ebd)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        options = NamespacesSelectOptions(
            expressions=expressions, labels=labels, names=names
        )

        return typing.cast("Namespaces", jsii.sinvoke(cls, "select", [scope, id, options]))

    @jsii.member(jsii_name="toNamespaceSelectorConfig")
    def to_namespace_selector_config(self) -> NamespaceSelectorConfig:
        '''Return the configuration of this selector.

        :see: INamespaceSelector.toNamespaceSelectorConfig()
        '''
        return typing.cast(NamespaceSelectorConfig, jsii.invoke(self, "toNamespaceSelectorConfig", []))

    @jsii.member(jsii_name="toNetworkPolicyPeerConfig")
    def to_network_policy_peer_config(self) -> "NetworkPolicyPeerConfig":
        '''Return the configuration of this peer.

        :see: INetworkPolicyPeer.toNetworkPolicyPeerConfig()
        '''
        return typing.cast("NetworkPolicyPeerConfig", jsii.invoke(self, "toNetworkPolicyPeerConfig", []))

    @jsii.member(jsii_name="toPodSelector")
    def to_pod_selector(self) -> typing.Optional[IPodSelector]:
        '''Convert the peer into a pod selector, if possible.

        :see: INetworkPolicyPeer.toPodSelector()
        '''
        return typing.cast(typing.Optional[IPodSelector], jsii.invoke(self, "toPodSelector", []))


@jsii.data_type(
    jsii_type="cdk8s-plus-24.NamespacesSelectOptions",
    jsii_struct_bases=[],
    name_mapping={"expressions": "expressions", "labels": "labels", "names": "names"},
)
class NamespacesSelectOptions:
    def __init__(
        self,
        *,
        expressions: typing.Optional[typing.Sequence[LabelExpression]] = None,
        labels: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        names: typing.Optional[typing.Sequence[builtins.str]] = None,
    ) -> None:
        '''Options for ``Namespaces.select``.

        :param expressions: Namespaces must satisfy these selectors. The selectors query labels, just like the ``labels`` property, but they provide a more advanced matching mechanism. Default: - no selector requirements.
        :param labels: Labels the namespaces must have. This is equivalent to using an 'Is' selector. Default: - no strict labels requirements.
        :param names: Namespaces names must be one of these. Default: - no name requirements.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__abbad827cf3297e2db66b7c476548cf289f3a4f1a2ec9e3536e996dd0e7747e9)
            check_type(argname="argument expressions", value=expressions, expected_type=type_hints["expressions"])
            check_type(argname="argument labels", value=labels, expected_type=type_hints["labels"])
            check_type(argname="argument names", value=names, expected_type=type_hints["names"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if expressions is not None:
            self._values["expressions"] = expressions
        if labels is not None:
            self._values["labels"] = labels
        if names is not None:
            self._values["names"] = names

    @builtins.property
    def expressions(self) -> typing.Optional[typing.List[LabelExpression]]:
        '''Namespaces must satisfy these selectors.

        The selectors query labels, just like the ``labels`` property, but they
        provide a more advanced matching mechanism.

        :default: - no selector requirements.
        '''
        result = self._values.get("expressions")
        return typing.cast(typing.Optional[typing.List[LabelExpression]], result)

    @builtins.property
    def labels(self) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        '''Labels the namespaces must have.

        This is equivalent to using an 'Is' selector.

        :default: - no strict labels requirements.
        '''
        result = self._values.get("labels")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, builtins.str]], result)

    @builtins.property
    def names(self) -> typing.Optional[typing.List[builtins.str]]:
        '''Namespaces names must be one of these.

        :default: - no name requirements.
        '''
        result = self._values.get("names")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "NamespacesSelectOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.NetworkPolicyAddEgressRuleOptions",
    jsii_struct_bases=[],
    name_mapping={"ports": "ports"},
)
class NetworkPolicyAddEgressRuleOptions:
    def __init__(
        self,
        *,
        ports: typing.Optional[typing.Sequence["NetworkPolicyPort"]] = None,
    ) -> None:
        '''Options for ``NetworkPolicy.addEgressRule``.

        :param ports: Ports the rule should allow outgoing traffic to. Default: - If the peer is a managed pod, take its ports. Otherwise, all ports are allowed.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__cb4bfec705088dbd77bf9ee76455597d33f22c626ed6cb69d07ffc28ad1e7a85)
            check_type(argname="argument ports", value=ports, expected_type=type_hints["ports"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if ports is not None:
            self._values["ports"] = ports

    @builtins.property
    def ports(self) -> typing.Optional[typing.List["NetworkPolicyPort"]]:
        '''Ports the rule should allow outgoing traffic to.

        :default: - If the peer is a managed pod, take its ports. Otherwise, all ports are allowed.
        '''
        result = self._values.get("ports")
        return typing.cast(typing.Optional[typing.List["NetworkPolicyPort"]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "NetworkPolicyAddEgressRuleOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(INetworkPolicyPeer)
class NetworkPolicyIpBlock(
    _constructs_77d1e7e8.Construct,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-24.NetworkPolicyIpBlock",
):
    '''Describes a particular CIDR (Ex.

    "192.168.1.1/24","2001:db9::/64") that is
    allowed to the pods matched by a network policy selector.
    The except entry describes CIDRs that should not be included within this rule.
    '''

    @jsii.member(jsii_name="anyIpv4")
    @builtins.classmethod
    def any_ipv4(
        cls,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
    ) -> "NetworkPolicyIpBlock":
        '''Any IPv4 address.

        :param scope: -
        :param id: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8e8909e34b7a492cda274e47e9e52a3854c89d46bfb1009d267754b457d85745)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        return typing.cast("NetworkPolicyIpBlock", jsii.sinvoke(cls, "anyIpv4", [scope, id]))

    @jsii.member(jsii_name="anyIpv6")
    @builtins.classmethod
    def any_ipv6(
        cls,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
    ) -> "NetworkPolicyIpBlock":
        '''Any IPv6 address.

        :param scope: -
        :param id: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__bea64e88673c1eae440e63296d6fc226a5483e6a42f89f12518267bd1b4e4dc4)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        return typing.cast("NetworkPolicyIpBlock", jsii.sinvoke(cls, "anyIpv6", [scope, id]))

    @jsii.member(jsii_name="ipv4")
    @builtins.classmethod
    def ipv4(
        cls,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        cidr_ip: builtins.str,
        except_: typing.Optional[typing.Sequence[builtins.str]] = None,
    ) -> "NetworkPolicyIpBlock":
        '''Create an IPv4 peer from a CIDR.

        :param scope: -
        :param id: -
        :param cidr_ip: -
        :param except_: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__041c2087e644010e580cffe62b92bf6f112a650b028b9f302fca3ffdb5f734ba)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
            check_type(argname="argument cidr_ip", value=cidr_ip, expected_type=type_hints["cidr_ip"])
            check_type(argname="argument except_", value=except_, expected_type=type_hints["except_"])
        return typing.cast("NetworkPolicyIpBlock", jsii.sinvoke(cls, "ipv4", [scope, id, cidr_ip, except_]))

    @jsii.member(jsii_name="ipv6")
    @builtins.classmethod
    def ipv6(
        cls,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        cidr_ip: builtins.str,
        except_: typing.Optional[typing.Sequence[builtins.str]] = None,
    ) -> "NetworkPolicyIpBlock":
        '''Create an IPv6 peer from a CIDR.

        :param scope: -
        :param id: -
        :param cidr_ip: -
        :param except_: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__29f9f7dd292c27492be5af315a3bd088edf82bc66515482adf4fb7f4828d05ad)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
            check_type(argname="argument cidr_ip", value=cidr_ip, expected_type=type_hints["cidr_ip"])
            check_type(argname="argument except_", value=except_, expected_type=type_hints["except_"])
        return typing.cast("NetworkPolicyIpBlock", jsii.sinvoke(cls, "ipv6", [scope, id, cidr_ip, except_]))

    @jsii.member(jsii_name="toNetworkPolicyPeerConfig")
    def to_network_policy_peer_config(self) -> "NetworkPolicyPeerConfig":
        '''Return the configuration of this peer.

        :see: INetworkPolicyPeer.toNetworkPolicyPeerConfig()
        '''
        return typing.cast("NetworkPolicyPeerConfig", jsii.invoke(self, "toNetworkPolicyPeerConfig", []))

    @jsii.member(jsii_name="toPodSelector")
    def to_pod_selector(self) -> typing.Optional[IPodSelector]:
        '''Convert the peer into a pod selector, if possible.

        :see: INetworkPolicyPeer.toPodSelector()
        '''
        return typing.cast(typing.Optional[IPodSelector], jsii.invoke(self, "toPodSelector", []))

    @builtins.property
    @jsii.member(jsii_name="cidr")
    def cidr(self) -> builtins.str:
        '''A string representing the IP Block Valid examples are "192.168.1.1/24" or "2001:db9::/64".'''
        return typing.cast(builtins.str, jsii.get(self, "cidr"))

    @builtins.property
    @jsii.member(jsii_name="except")
    def except_(self) -> typing.Optional[typing.List[builtins.str]]:
        '''A slice of CIDRs that should not be included within an IP Block Valid examples are "192.168.1.1/24" or "2001:db9::/64". Except values will be rejected if they are outside the CIDR range.'''
        return typing.cast(typing.Optional[typing.List[builtins.str]], jsii.get(self, "except"))


@jsii.data_type(
    jsii_type="cdk8s-plus-24.NetworkPolicyPeerConfig",
    jsii_struct_bases=[],
    name_mapping={"ip_block": "ipBlock", "pod_selector": "podSelector"},
)
class NetworkPolicyPeerConfig:
    def __init__(
        self,
        *,
        ip_block: typing.Optional[NetworkPolicyIpBlock] = None,
        pod_selector: typing.Optional[typing.Union["PodSelectorConfig", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Configuration for network peers.

        A peer can either by an ip block, or a selection of pods, not both.

        :param ip_block: The ip block this peer represents.
        :param pod_selector: The pod selector this peer represents.
        '''
        if isinstance(pod_selector, dict):
            pod_selector = PodSelectorConfig(**pod_selector)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6f06c3897f407747f4e1f7df34e9efe0322962c24d5c8778a6d7976353cb2ba7)
            check_type(argname="argument ip_block", value=ip_block, expected_type=type_hints["ip_block"])
            check_type(argname="argument pod_selector", value=pod_selector, expected_type=type_hints["pod_selector"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if ip_block is not None:
            self._values["ip_block"] = ip_block
        if pod_selector is not None:
            self._values["pod_selector"] = pod_selector

    @builtins.property
    def ip_block(self) -> typing.Optional[NetworkPolicyIpBlock]:
        '''The ip block this peer represents.'''
        result = self._values.get("ip_block")
        return typing.cast(typing.Optional[NetworkPolicyIpBlock], result)

    @builtins.property
    def pod_selector(self) -> typing.Optional["PodSelectorConfig"]:
        '''The pod selector this peer represents.'''
        result = self._values.get("pod_selector")
        return typing.cast(typing.Optional["PodSelectorConfig"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "NetworkPolicyPeerConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class NetworkPolicyPort(
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-24.NetworkPolicyPort",
):
    '''Describes a port to allow traffic on.'''

    @jsii.member(jsii_name="allTcp")
    @builtins.classmethod
    def all_tcp(cls) -> "NetworkPolicyPort":
        '''Any TCP traffic.'''
        return typing.cast("NetworkPolicyPort", jsii.sinvoke(cls, "allTcp", []))

    @jsii.member(jsii_name="allUdp")
    @builtins.classmethod
    def all_udp(cls) -> "NetworkPolicyPort":
        '''Any UDP traffic.'''
        return typing.cast("NetworkPolicyPort", jsii.sinvoke(cls, "allUdp", []))

    @jsii.member(jsii_name="of")
    @builtins.classmethod
    def of(
        cls,
        *,
        end_port: typing.Optional[jsii.Number] = None,
        port: typing.Optional[jsii.Number] = None,
        protocol: typing.Optional["NetworkProtocol"] = None,
    ) -> "NetworkPolicyPort":
        '''Custom port configuration.

        :param end_port: End port (relative to ``port``). Only applies if ``port`` is defined. Use this to specify a port range, rather that a specific one. Default: - not a port range.
        :param port: Specific port number. Default: - all ports are allowed.
        :param protocol: Protocol. Default: NetworkProtocol.TCP
        '''
        props = NetworkPolicyPortProps(end_port=end_port, port=port, protocol=protocol)

        return typing.cast("NetworkPolicyPort", jsii.sinvoke(cls, "of", [props]))

    @jsii.member(jsii_name="tcp")
    @builtins.classmethod
    def tcp(cls, port: jsii.Number) -> "NetworkPolicyPort":
        '''Distinct TCP ports.

        :param port: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6e163c0f5ac76aea0844bd08445235936ac06e47a0d95e4046cff389c978bdb0)
            check_type(argname="argument port", value=port, expected_type=type_hints["port"])
        return typing.cast("NetworkPolicyPort", jsii.sinvoke(cls, "tcp", [port]))

    @jsii.member(jsii_name="tcpRange")
    @builtins.classmethod
    def tcp_range(
        cls,
        start_port: jsii.Number,
        end_port: jsii.Number,
    ) -> "NetworkPolicyPort":
        '''A TCP port range.

        :param start_port: -
        :param end_port: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e7c854ff65eb496ad54ec009df0699e194e891dde450ff9416a384ae705de01a)
            check_type(argname="argument start_port", value=start_port, expected_type=type_hints["start_port"])
            check_type(argname="argument end_port", value=end_port, expected_type=type_hints["end_port"])
        return typing.cast("NetworkPolicyPort", jsii.sinvoke(cls, "tcpRange", [start_port, end_port]))

    @jsii.member(jsii_name="udp")
    @builtins.classmethod
    def udp(cls, port: jsii.Number) -> "NetworkPolicyPort":
        '''Distinct UDP ports.

        :param port: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d73b5fdfdf69a0ad0e507e2f6fee815b61787da15c9f626121c48166d217ccdb)
            check_type(argname="argument port", value=port, expected_type=type_hints["port"])
        return typing.cast("NetworkPolicyPort", jsii.sinvoke(cls, "udp", [port]))

    @jsii.member(jsii_name="udpRange")
    @builtins.classmethod
    def udp_range(
        cls,
        start_port: jsii.Number,
        end_port: jsii.Number,
    ) -> "NetworkPolicyPort":
        '''A UDP port range.

        :param start_port: -
        :param end_port: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ff5122fea09f3ead0004631ca57f2da677a91bc268032fae2067456279a0572f)
            check_type(argname="argument start_port", value=start_port, expected_type=type_hints["start_port"])
            check_type(argname="argument end_port", value=end_port, expected_type=type_hints["end_port"])
        return typing.cast("NetworkPolicyPort", jsii.sinvoke(cls, "udpRange", [start_port, end_port]))


@jsii.data_type(
    jsii_type="cdk8s-plus-24.NetworkPolicyPortProps",
    jsii_struct_bases=[],
    name_mapping={"end_port": "endPort", "port": "port", "protocol": "protocol"},
)
class NetworkPolicyPortProps:
    def __init__(
        self,
        *,
        end_port: typing.Optional[jsii.Number] = None,
        port: typing.Optional[jsii.Number] = None,
        protocol: typing.Optional["NetworkProtocol"] = None,
    ) -> None:
        '''Properties for ``NetworkPolicyPort``.

        :param end_port: End port (relative to ``port``). Only applies if ``port`` is defined. Use this to specify a port range, rather that a specific one. Default: - not a port range.
        :param port: Specific port number. Default: - all ports are allowed.
        :param protocol: Protocol. Default: NetworkProtocol.TCP
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__bdaa6c89d44add53a52c168af86c87827c0d5c00bf69545390002520908d5dd1)
            check_type(argname="argument end_port", value=end_port, expected_type=type_hints["end_port"])
            check_type(argname="argument port", value=port, expected_type=type_hints["port"])
            check_type(argname="argument protocol", value=protocol, expected_type=type_hints["protocol"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if end_port is not None:
            self._values["end_port"] = end_port
        if port is not None:
            self._values["port"] = port
        if protocol is not None:
            self._values["protocol"] = protocol

    @builtins.property
    def end_port(self) -> typing.Optional[jsii.Number]:
        '''End port (relative to ``port``).

        Only applies if ``port`` is defined.
        Use this to specify a port range, rather that a specific one.

        :default: - not a port range.
        '''
        result = self._values.get("end_port")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def port(self) -> typing.Optional[jsii.Number]:
        '''Specific port number.

        :default: - all ports are allowed.
        '''
        result = self._values.get("port")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def protocol(self) -> typing.Optional["NetworkProtocol"]:
        '''Protocol.

        :default: NetworkProtocol.TCP
        '''
        result = self._values.get("protocol")
        return typing.cast(typing.Optional["NetworkProtocol"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "NetworkPolicyPortProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.NetworkPolicyRule",
    jsii_struct_bases=[],
    name_mapping={"peer": "peer", "ports": "ports"},
)
class NetworkPolicyRule:
    def __init__(
        self,
        *,
        peer: INetworkPolicyPeer,
        ports: typing.Optional[typing.Sequence[NetworkPolicyPort]] = None,
    ) -> None:
        '''Describes a rule allowing traffic from / to pods matched by a network policy selector.

        :param peer: Peer this rule interacts with.
        :param ports: The ports of the rule. Default: - traffic is allowed on all ports.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__17c95c1ea05ad87588a961ae8daaa9b582a7fa85a16075be257837784ccf31a4)
            check_type(argname="argument peer", value=peer, expected_type=type_hints["peer"])
            check_type(argname="argument ports", value=ports, expected_type=type_hints["ports"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "peer": peer,
        }
        if ports is not None:
            self._values["ports"] = ports

    @builtins.property
    def peer(self) -> INetworkPolicyPeer:
        '''Peer this rule interacts with.'''
        result = self._values.get("peer")
        assert result is not None, "Required property 'peer' is missing"
        return typing.cast(INetworkPolicyPeer, result)

    @builtins.property
    def ports(self) -> typing.Optional[typing.List[NetworkPolicyPort]]:
        '''The ports of the rule.

        :default: - traffic is allowed on all ports.
        '''
        result = self._values.get("ports")
        return typing.cast(typing.Optional[typing.List[NetworkPolicyPort]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "NetworkPolicyRule(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.NetworkPolicyTraffic",
    jsii_struct_bases=[],
    name_mapping={"default": "default", "rules": "rules"},
)
class NetworkPolicyTraffic:
    def __init__(
        self,
        *,
        default: typing.Optional["NetworkPolicyTrafficDefault"] = None,
        rules: typing.Optional[typing.Sequence[typing.Union[NetworkPolicyRule, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Describes how the network policy should configure egress / ingress traffic.

        :param default: Specifies the default behavior of the policy when no rules are defined. Default: - unset, the policy does not change the behavior.
        :param rules: List of rules to be applied to the selected pods. If empty, the behavior of the policy is dictated by the ``default`` property. Default: - no rules
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3390ab909d57014b3b127ba85c8c912f5031b8f1f88226a4aac7fd1a7625e1c6)
            check_type(argname="argument default", value=default, expected_type=type_hints["default"])
            check_type(argname="argument rules", value=rules, expected_type=type_hints["rules"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if default is not None:
            self._values["default"] = default
        if rules is not None:
            self._values["rules"] = rules

    @builtins.property
    def default(self) -> typing.Optional["NetworkPolicyTrafficDefault"]:
        '''Specifies the default behavior of the policy when no rules are defined.

        :default: - unset, the policy does not change the behavior.
        '''
        result = self._values.get("default")
        return typing.cast(typing.Optional["NetworkPolicyTrafficDefault"], result)

    @builtins.property
    def rules(self) -> typing.Optional[typing.List[NetworkPolicyRule]]:
        '''List of rules to be applied to the selected pods.

        If empty, the behavior of the policy is dictated by the ``default`` property.

        :default: - no rules
        '''
        result = self._values.get("rules")
        return typing.cast(typing.Optional[typing.List[NetworkPolicyRule]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "NetworkPolicyTraffic(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.enum(jsii_type="cdk8s-plus-24.NetworkPolicyTrafficDefault")
class NetworkPolicyTrafficDefault(enum.Enum):
    '''Default behaviors of network traffic in policies.'''

    DENY = "DENY"
    '''The policy denies all traffic.

    Since rules are additive, additional rules or policies can allow
    specific traffic.
    '''
    ALLOW = "ALLOW"
    '''The policy allows all traffic (either ingress or egress).

    Since rules are additive, no additional rule or policies can
    subsequently deny the traffic.
    '''


@jsii.enum(jsii_type="cdk8s-plus-24.NetworkProtocol")
class NetworkProtocol(enum.Enum):
    '''Network protocols.'''

    TCP = "TCP"
    '''TCP.'''
    UDP = "UDP"
    '''UDP.'''
    SCTP = "SCTP"
    '''SCTP.'''


class Node(metaclass=jsii.JSIIMeta, jsii_type="cdk8s-plus-24.Node"):
    '''Represents a node in the cluster.'''

    def __init__(self) -> None:
        jsii.create(self.__class__, self, [])

    @jsii.member(jsii_name="labeled")
    @builtins.classmethod
    def labeled(cls, *label_selector: "NodeLabelQuery") -> LabeledNode:
        '''Match a node by its labels.

        :param label_selector: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ad58833c1a691f3d8773a465fdb1b4a7625bb3caebcbc4bb6b0568a903c131a3)
            check_type(argname="argument label_selector", value=label_selector, expected_type=typing.Tuple[type_hints["label_selector"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast(LabeledNode, jsii.sinvoke(cls, "labeled", [*label_selector]))

    @jsii.member(jsii_name="named")
    @builtins.classmethod
    def named(cls, node_name: builtins.str) -> NamedNode:
        '''Match a node by its name.

        :param node_name: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2e095567c763a17d936387a5a20eb1fbdc34468859247bf163c6ebc419d30584)
            check_type(argname="argument node_name", value=node_name, expected_type=type_hints["node_name"])
        return typing.cast(NamedNode, jsii.sinvoke(cls, "named", [node_name]))

    @jsii.member(jsii_name="tainted")
    @builtins.classmethod
    def tainted(cls, *taint_selector: "NodeTaintQuery") -> "TaintedNode":
        '''Match a node by its taints.

        :param taint_selector: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__7f83a1394fb871d0ddd8d1ab98ba9c477114fbb20c3459e78f8c8b20539dafca)
            check_type(argname="argument taint_selector", value=taint_selector, expected_type=typing.Tuple[type_hints["taint_selector"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast("TaintedNode", jsii.sinvoke(cls, "tainted", [*taint_selector]))


class NodeLabelQuery(metaclass=jsii.JSIIMeta, jsii_type="cdk8s-plus-24.NodeLabelQuery"):
    '''Represents a query that can be performed against nodes with labels.'''

    @jsii.member(jsii_name="doesNotExist")
    @builtins.classmethod
    def does_not_exist(cls, key: builtins.str) -> "NodeLabelQuery":
        '''Requires label ``key`` to not exist.

        :param key: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__92375e845418d44e1422c35d39d7f99967f1850d26e6d6b9d4a54edcc0ba16ec)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
        return typing.cast("NodeLabelQuery", jsii.sinvoke(cls, "doesNotExist", [key]))

    @jsii.member(jsii_name="exists")
    @builtins.classmethod
    def exists(cls, key: builtins.str) -> "NodeLabelQuery":
        '''Requires label ``key`` to exist.

        :param key: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__28e93c940acb5d889d010b90ed2a94d820072e159368f32500720970a8eaf664)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
        return typing.cast("NodeLabelQuery", jsii.sinvoke(cls, "exists", [key]))

    @jsii.member(jsii_name="gt")
    @builtins.classmethod
    def gt(
        cls,
        key: builtins.str,
        values: typing.Sequence[builtins.str],
    ) -> "NodeLabelQuery":
        '''Requires value of label ``key`` to greater than all elements in ``values``.

        :param key: -
        :param values: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1769af3ed098b2974d633f2dc48e575db6954478280c0564393319aebb0aac19)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument values", value=values, expected_type=type_hints["values"])
        return typing.cast("NodeLabelQuery", jsii.sinvoke(cls, "gt", [key, values]))

    @jsii.member(jsii_name="in")
    @builtins.classmethod
    def in_(
        cls,
        key: builtins.str,
        values: typing.Sequence[builtins.str],
    ) -> "NodeLabelQuery":
        '''Requires value of label ``key`` to be one of ``values``.

        :param key: -
        :param values: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a878b596c4acee0e59373fa2d09a158d60093cc024b6e4410ffb508dccfd9155)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument values", value=values, expected_type=type_hints["values"])
        return typing.cast("NodeLabelQuery", jsii.sinvoke(cls, "in", [key, values]))

    @jsii.member(jsii_name="is")
    @builtins.classmethod
    def is_(cls, key: builtins.str, value: builtins.str) -> "NodeLabelQuery":
        '''Requires value of label ``key`` to equal ``value``.

        :param key: -
        :param value: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__fc3a7a2b2650250d32525a35fe16871e66e6e6769618cf9a8964c9d68438e9c4)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast("NodeLabelQuery", jsii.sinvoke(cls, "is", [key, value]))

    @jsii.member(jsii_name="lt")
    @builtins.classmethod
    def lt(
        cls,
        key: builtins.str,
        values: typing.Sequence[builtins.str],
    ) -> "NodeLabelQuery":
        '''Requires value of label ``key`` to less than all elements in ``values``.

        :param key: -
        :param values: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__10db1b729c7324e4523c9361a56aa4ab8fcf9c3dd749de3e7bddeffaa30efb4a)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument values", value=values, expected_type=type_hints["values"])
        return typing.cast("NodeLabelQuery", jsii.sinvoke(cls, "lt", [key, values]))

    @jsii.member(jsii_name="notIn")
    @builtins.classmethod
    def not_in(
        cls,
        key: builtins.str,
        values: typing.Sequence[builtins.str],
    ) -> "NodeLabelQuery":
        '''Requires value of label ``key`` to be none of ``values``.

        :param key: -
        :param values: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4525be914dff7bcda905fdd547121284cf53f93b830035421d7f91a2a96cb172)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument values", value=values, expected_type=type_hints["values"])
        return typing.cast("NodeLabelQuery", jsii.sinvoke(cls, "notIn", [key, values]))


class NodeTaintQuery(metaclass=jsii.JSIIMeta, jsii_type="cdk8s-plus-24.NodeTaintQuery"):
    '''Taint queries that can be perfomed against nodes.'''

    @jsii.member(jsii_name="any")
    @builtins.classmethod
    def any(cls) -> "NodeTaintQuery":
        '''Matches any taint.'''
        return typing.cast("NodeTaintQuery", jsii.sinvoke(cls, "any", []))

    @jsii.member(jsii_name="exists")
    @builtins.classmethod
    def exists(
        cls,
        key: builtins.str,
        *,
        effect: typing.Optional["TaintEffect"] = None,
        evict_after: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
    ) -> "NodeTaintQuery":
        '''Matches a tain with any value of a specific key.

        :param key: -
        :param effect: The taint effect to match. Default: - all effects are matched.
        :param evict_after: How much time should a pod that tolerates the ``NO_EXECUTE`` effect be bound to the node. Only applies for the ``NO_EXECUTE`` effect. Default: - bound forever.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__54e0f4539412ea6ee3dd6a68e91f7086b71cce2540ab6a8567afda8e6a2c8bde)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
        options = NodeTaintQueryOptions(effect=effect, evict_after=evict_after)

        return typing.cast("NodeTaintQuery", jsii.sinvoke(cls, "exists", [key, options]))

    @jsii.member(jsii_name="is")
    @builtins.classmethod
    def is_(
        cls,
        key: builtins.str,
        value: builtins.str,
        *,
        effect: typing.Optional["TaintEffect"] = None,
        evict_after: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
    ) -> "NodeTaintQuery":
        '''Matches a taint with a specific key and value.

        :param key: -
        :param value: -
        :param effect: The taint effect to match. Default: - all effects are matched.
        :param evict_after: How much time should a pod that tolerates the ``NO_EXECUTE`` effect be bound to the node. Only applies for the ``NO_EXECUTE`` effect. Default: - bound forever.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8477fd46b2b07cb8c23593a3165d2a259974e8dbe4e84513ed6db56261d271b1)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        options = NodeTaintQueryOptions(effect=effect, evict_after=evict_after)

        return typing.cast("NodeTaintQuery", jsii.sinvoke(cls, "is", [key, value, options]))


@jsii.data_type(
    jsii_type="cdk8s-plus-24.NodeTaintQueryOptions",
    jsii_struct_bases=[],
    name_mapping={"effect": "effect", "evict_after": "evictAfter"},
)
class NodeTaintQueryOptions:
    def __init__(
        self,
        *,
        effect: typing.Optional["TaintEffect"] = None,
        evict_after: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
    ) -> None:
        '''Options for ``NodeTaintQuery``.

        :param effect: The taint effect to match. Default: - all effects are matched.
        :param evict_after: How much time should a pod that tolerates the ``NO_EXECUTE`` effect be bound to the node. Only applies for the ``NO_EXECUTE`` effect. Default: - bound forever.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__875993a14480d7f321c9ac3ee2b38139925972b4a33879ed276fd98aa77ada9e)
            check_type(argname="argument effect", value=effect, expected_type=type_hints["effect"])
            check_type(argname="argument evict_after", value=evict_after, expected_type=type_hints["evict_after"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if effect is not None:
            self._values["effect"] = effect
        if evict_after is not None:
            self._values["evict_after"] = evict_after

    @builtins.property
    def effect(self) -> typing.Optional["TaintEffect"]:
        '''The taint effect to match.

        :default: - all effects are matched.
        '''
        result = self._values.get("effect")
        return typing.cast(typing.Optional["TaintEffect"], result)

    @builtins.property
    def evict_after(self) -> typing.Optional[_cdk8s_d3d9af27.Duration]:
        '''How much time should a pod that tolerates the ``NO_EXECUTE`` effect be bound to the node.

        Only applies for the ``NO_EXECUTE`` effect.

        :default: - bound forever.
        '''
        result = self._values.get("evict_after")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Duration], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "NodeTaintQueryOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(IApiEndpoint)
class NonApiResource(metaclass=jsii.JSIIMeta, jsii_type="cdk8s-plus-24.NonApiResource"):
    '''Factory for creating non api resources.'''

    @jsii.member(jsii_name="of")
    @builtins.classmethod
    def of(cls, url: builtins.str) -> "NonApiResource":
        '''
        :param url: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f6426b448cadebe8a3a94bce4d5b16a3ba40c16ea237692f17043bad5e22d2d9)
            check_type(argname="argument url", value=url, expected_type=type_hints["url"])
        return typing.cast("NonApiResource", jsii.sinvoke(cls, "of", [url]))

    @jsii.member(jsii_name="asApiResource")
    def as_api_resource(self) -> typing.Optional[IApiResource]:
        '''Return the IApiResource this object represents.'''
        return typing.cast(typing.Optional[IApiResource], jsii.invoke(self, "asApiResource", []))

    @jsii.member(jsii_name="asNonApiResource")
    def as_non_api_resource(self) -> typing.Optional[builtins.str]:
        '''Return the non resource url this object represents.'''
        return typing.cast(typing.Optional[builtins.str], jsii.invoke(self, "asNonApiResource", []))


@jsii.data_type(
    jsii_type="cdk8s-plus-24.PathMapping",
    jsii_struct_bases=[],
    name_mapping={"path": "path", "mode": "mode"},
)
class PathMapping:
    def __init__(
        self,
        *,
        path: builtins.str,
        mode: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''Maps a string key to a path within a volume.

        :param path: The relative path of the file to map the key to. May not be an absolute path. May not contain the path element '..'. May not start with the string '..'.
        :param mode: Optional: mode bits to use on this file, must be a value between 0 and 0777. If not specified, the volume defaultMode will be used. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9bd10bcf02d8ceb85ae1d9ec5ed83a8060017af2db50592e51f613e80ee8f4f8)
            check_type(argname="argument path", value=path, expected_type=type_hints["path"])
            check_type(argname="argument mode", value=mode, expected_type=type_hints["mode"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "path": path,
        }
        if mode is not None:
            self._values["mode"] = mode

    @builtins.property
    def path(self) -> builtins.str:
        '''The relative path of the file to map the key to.

        May not be an absolute
        path. May not contain the path element '..'. May not start with the string
        '..'.
        '''
        result = self._values.get("path")
        assert result is not None, "Required property 'path' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def mode(self) -> typing.Optional[jsii.Number]:
        '''Optional: mode bits to use on this file, must be a value between 0 and 0777.

        If not specified, the volume defaultMode will be used. This might be
        in conflict with other options that affect the file mode, like fsGroup, and
        the result can be other mode bits set.
        '''
        result = self._values.get("mode")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "PathMapping(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class PercentOrAbsolute(
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-24.PercentOrAbsolute",
):
    '''Union like class repsenting either a ration in percents or an absolute number.'''

    @jsii.member(jsii_name="absolute")
    @builtins.classmethod
    def absolute(cls, num: jsii.Number) -> "PercentOrAbsolute":
        '''Absolute number.

        :param num: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d82b8e3bd5a7f11e20724970c072b3b1274e7000de2a554c9169b6ebcaca0a01)
            check_type(argname="argument num", value=num, expected_type=type_hints["num"])
        return typing.cast("PercentOrAbsolute", jsii.sinvoke(cls, "absolute", [num]))

    @jsii.member(jsii_name="percent")
    @builtins.classmethod
    def percent(cls, percent: jsii.Number) -> "PercentOrAbsolute":
        '''Percent ratio.

        :param percent: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__127f852cbd189e2ac0be1e89c07756ed7327ea1079ccddc21add935712ec4fd6)
            check_type(argname="argument percent", value=percent, expected_type=type_hints["percent"])
        return typing.cast("PercentOrAbsolute", jsii.sinvoke(cls, "percent", [percent]))

    @jsii.member(jsii_name="isZero")
    def is_zero(self) -> builtins.bool:
        return typing.cast(builtins.bool, jsii.invoke(self, "isZero", []))

    @builtins.property
    @jsii.member(jsii_name="value")
    def value(self) -> typing.Any:
        return typing.cast(typing.Any, jsii.get(self, "value"))


@jsii.enum(jsii_type="cdk8s-plus-24.PersistentVolumeAccessMode")
class PersistentVolumeAccessMode(enum.Enum):
    '''Access Modes.'''

    READ_WRITE_ONCE = "READ_WRITE_ONCE"
    '''The volume can be mounted as read-write by a single node.

    ReadWriteOnce access mode still can allow multiple pods to access
    the volume when the pods are running on the same node.
    '''
    READ_ONLY_MANY = "READ_ONLY_MANY"
    '''The volume can be mounted as read-only by many nodes.'''
    READ_WRITE_MANY = "READ_WRITE_MANY"
    '''The volume can be mounted as read-write by many nodes.'''
    READ_WRITE_ONCE_POD = "READ_WRITE_ONCE_POD"
    '''The volume can be mounted as read-write by a single Pod.

    Use ReadWriteOncePod access mode if you want to ensure that
    only one pod across whole cluster can read that PVC or write to it.
    This is only supported for CSI volumes and Kubernetes version 1.22+.
    '''


@jsii.data_type(
    jsii_type="cdk8s-plus-24.PersistentVolumeClaimVolumeOptions",
    jsii_struct_bases=[],
    name_mapping={"name": "name", "read_only": "readOnly"},
)
class PersistentVolumeClaimVolumeOptions:
    def __init__(
        self,
        *,
        name: typing.Optional[builtins.str] = None,
        read_only: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''Options for a PersistentVolumeClaim-based volume.

        :param name: The volume name. Default: - Derived from the PVC name.
        :param read_only: Will force the ReadOnly setting in VolumeMounts. Default: false
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b6a4b925282586aebd610e38da794acc5a8d131450974f59859dfe150d270af0)
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument read_only", value=read_only, expected_type=type_hints["read_only"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if name is not None:
            self._values["name"] = name
        if read_only is not None:
            self._values["read_only"] = read_only

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''The volume name.

        :default: - Derived from the PVC name.
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def read_only(self) -> typing.Optional[builtins.bool]:
        '''Will force the ReadOnly setting in VolumeMounts.

        :default: false
        '''
        result = self._values.get("read_only")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "PersistentVolumeClaimVolumeOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.enum(jsii_type="cdk8s-plus-24.PersistentVolumeMode")
class PersistentVolumeMode(enum.Enum):
    '''Volume Modes.'''

    FILE_SYSTEM = "FILE_SYSTEM"
    '''Volume is ounted into Pods into a directory.

    If the volume is backed by a block device and the device is empty,
    Kubernetes creates a filesystem on the device before mounting it
    for the first time.
    '''
    BLOCK = "BLOCK"
    '''Use a volume as a raw block device.

    Such volume is presented into a Pod as a block device,
    without any filesystem on it. This mode is useful to provide a Pod the fastest possible way
    to access a volume, without any filesystem layer between the Pod
    and the volume. On the other hand, the application running in
    the Pod must know how to handle a raw block device
    '''


@jsii.enum(jsii_type="cdk8s-plus-24.PersistentVolumeReclaimPolicy")
class PersistentVolumeReclaimPolicy(enum.Enum):
    '''Reclaim Policies.'''

    RETAIN = "RETAIN"
    '''The Retain reclaim policy allows for manual reclamation of the resource.

    When the PersistentVolumeClaim is deleted, the PersistentVolume still exists and the
    volume is considered "released". But it is not yet available for another claim
    because the previous claimant's data remains on the volume.
    An administrator can manually reclaim the volume with the following steps:

    1. Delete the PersistentVolume. The associated storage asset in external
       infrastructure (such as an AWS EBS, GCE PD, Azure Disk, or Cinder volume) still exists after the PV is deleted.
    2. Manually clean up the data on the associated storage asset accordingly.
    3. Manually delete the associated storage asset.

    If you want to reuse the same storage asset, create a new PersistentVolume
    with the same storage asset definition.
    '''
    DELETE = "DELETE"
    '''For volume plugins that support the Delete reclaim policy, deletion removes both the PersistentVolume object from Kubernetes, as well as the associated storage asset in the external infrastructure, such as an AWS EBS, GCE PD, Azure Disk, or Cinder volume.

    Volumes that were dynamically provisioned inherit the reclaim policy of their StorageClass, which defaults to Delete.
    The administrator should configure the StorageClass according to users' expectations; otherwise,
    the PV must be edited or patched after it is created
    '''


class PodConnections(metaclass=jsii.JSIIMeta, jsii_type="cdk8s-plus-24.PodConnections"):
    '''Controls network isolation rules for inter-pod communication.'''

    def __init__(self, instance: "AbstractPod") -> None:
        '''
        :param instance: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2e0610bec31015f0b5dbaa9c2865ad60069c12da63cec3b0023e210db941503f)
            check_type(argname="argument instance", value=instance, expected_type=type_hints["instance"])
        jsii.create(self.__class__, self, [instance])

    @jsii.member(jsii_name="allowFrom")
    def allow_from(
        self,
        peer: INetworkPolicyPeer,
        *,
        isolation: typing.Optional["PodConnectionsIsolation"] = None,
        ports: typing.Optional[typing.Sequence[NetworkPolicyPort]] = None,
    ) -> None:
        '''Allow network traffic from the peer to this pod.

        By default, this will create an ingress network policy for this pod, and an egress
        network policy for the peer. This is required if both sides are already isolated.
        Use ``options.isolation`` to control this behavior.

        :param peer: -
        :param isolation: Which isolation should be applied to establish the connection. Default: - unset, isolates both the pod and the peer.
        :param ports: Ports to allow incoming traffic to. Default: - The pod ports.

        Example::

            // create only an egress policy that selects the 'web' pod to allow outgoing traffic
            // to the 'redis' pod. this requires the 'redis' pod to not be isolated for ingress.
            redis.connections.allowFrom(web, { isolation: Isolation.PEER })
            
            // create only an ingress policy that selects the 'redis' peer to allow incoming traffic
            // from the 'web' pod. this requires the 'web' pod to not be isolated for egress.
            redis.connections.allowFrom(web, { isolation: Isolation.POD })
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__84149e1d7264b0ecac368473a97c125a8b98617102a55165dec15cdca4c89fad)
            check_type(argname="argument peer", value=peer, expected_type=type_hints["peer"])
        options = PodConnectionsAllowFromOptions(isolation=isolation, ports=ports)

        return typing.cast(None, jsii.invoke(self, "allowFrom", [peer, options]))

    @jsii.member(jsii_name="allowTo")
    def allow_to(
        self,
        peer: INetworkPolicyPeer,
        *,
        isolation: typing.Optional["PodConnectionsIsolation"] = None,
        ports: typing.Optional[typing.Sequence[NetworkPolicyPort]] = None,
    ) -> None:
        '''Allow network traffic from this pod to the peer.

        By default, this will create an egress network policy for this pod, and an ingress
        network policy for the peer. This is required if both sides are already isolated.
        Use ``options.isolation`` to control this behavior.

        :param peer: -
        :param isolation: Which isolation should be applied to establish the connection. Default: - unset, isolates both the pod and the peer.
        :param ports: Ports to allow outgoing traffic to. Default: - If the peer is a managed pod, take its ports. Otherwise, all ports are allowed.

        Example::

            // create only an egress policy that selects the 'web' pod to allow outgoing traffic
            // to the 'redis' pod. this requires the 'redis' pod to not be isolated for ingress.
            web.connections.allowTo(redis, { isolation: Isolation.POD })
            
            // create only an ingress policy that selects the 'redis' peer to allow incoming traffic
            // from the 'web' pod. this requires the 'web' pod to not be isolated for egress.
            web.connections.allowTo(redis, { isolation: Isolation.PEER })
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__dd39230b8fbca19917c605362435401540095750e72dada95388af633620cdc6)
            check_type(argname="argument peer", value=peer, expected_type=type_hints["peer"])
        options = PodConnectionsAllowToOptions(isolation=isolation, ports=ports)

        return typing.cast(None, jsii.invoke(self, "allowTo", [peer, options]))

    @jsii.member(jsii_name="isolate")
    def isolate(self) -> None:
        '''Sets the default network policy for Pod/Workload to have all egress and ingress connections as disabled.'''
        return typing.cast(None, jsii.invoke(self, "isolate", []))

    @builtins.property
    @jsii.member(jsii_name="instance")
    def _instance(self) -> "AbstractPod":
        return typing.cast("AbstractPod", jsii.get(self, "instance"))


@jsii.data_type(
    jsii_type="cdk8s-plus-24.PodConnectionsAllowFromOptions",
    jsii_struct_bases=[],
    name_mapping={"isolation": "isolation", "ports": "ports"},
)
class PodConnectionsAllowFromOptions:
    def __init__(
        self,
        *,
        isolation: typing.Optional["PodConnectionsIsolation"] = None,
        ports: typing.Optional[typing.Sequence[NetworkPolicyPort]] = None,
    ) -> None:
        '''Options for ``PodConnections.allowFrom``.

        :param isolation: Which isolation should be applied to establish the connection. Default: - unset, isolates both the pod and the peer.
        :param ports: Ports to allow incoming traffic to. Default: - The pod ports.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__99ecd1736709402ee2d0b65b0d6667073f4ca3f6a9609ed58d9bf80445d7c68c)
            check_type(argname="argument isolation", value=isolation, expected_type=type_hints["isolation"])
            check_type(argname="argument ports", value=ports, expected_type=type_hints["ports"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if isolation is not None:
            self._values["isolation"] = isolation
        if ports is not None:
            self._values["ports"] = ports

    @builtins.property
    def isolation(self) -> typing.Optional["PodConnectionsIsolation"]:
        '''Which isolation should be applied to establish the connection.

        :default: - unset, isolates both the pod and the peer.
        '''
        result = self._values.get("isolation")
        return typing.cast(typing.Optional["PodConnectionsIsolation"], result)

    @builtins.property
    def ports(self) -> typing.Optional[typing.List[NetworkPolicyPort]]:
        '''Ports to allow incoming traffic to.

        :default: - The pod ports.
        '''
        result = self._values.get("ports")
        return typing.cast(typing.Optional[typing.List[NetworkPolicyPort]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "PodConnectionsAllowFromOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.PodConnectionsAllowToOptions",
    jsii_struct_bases=[],
    name_mapping={"isolation": "isolation", "ports": "ports"},
)
class PodConnectionsAllowToOptions:
    def __init__(
        self,
        *,
        isolation: typing.Optional["PodConnectionsIsolation"] = None,
        ports: typing.Optional[typing.Sequence[NetworkPolicyPort]] = None,
    ) -> None:
        '''Options for ``PodConnections.allowTo``.

        :param isolation: Which isolation should be applied to establish the connection. Default: - unset, isolates both the pod and the peer.
        :param ports: Ports to allow outgoing traffic to. Default: - If the peer is a managed pod, take its ports. Otherwise, all ports are allowed.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4c61b725a3c46701615d806515c80954363c979e553d7f9b5073e3b131c3a354)
            check_type(argname="argument isolation", value=isolation, expected_type=type_hints["isolation"])
            check_type(argname="argument ports", value=ports, expected_type=type_hints["ports"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if isolation is not None:
            self._values["isolation"] = isolation
        if ports is not None:
            self._values["ports"] = ports

    @builtins.property
    def isolation(self) -> typing.Optional["PodConnectionsIsolation"]:
        '''Which isolation should be applied to establish the connection.

        :default: - unset, isolates both the pod and the peer.
        '''
        result = self._values.get("isolation")
        return typing.cast(typing.Optional["PodConnectionsIsolation"], result)

    @builtins.property
    def ports(self) -> typing.Optional[typing.List[NetworkPolicyPort]]:
        '''Ports to allow outgoing traffic to.

        :default: - If the peer is a managed pod, take its ports. Otherwise, all ports are allowed.
        '''
        result = self._values.get("ports")
        return typing.cast(typing.Optional[typing.List[NetworkPolicyPort]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "PodConnectionsAllowToOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.enum(jsii_type="cdk8s-plus-24.PodConnectionsIsolation")
class PodConnectionsIsolation(enum.Enum):
    '''Isolation determines which policies are created when allowing connections from a a pod / workload to peers.'''

    POD = "POD"
    '''Only creates network policies that select the pod.'''
    PEER = "PEER"
    '''Only creates network policies that select the peer.'''


class PodDns(metaclass=jsii.JSIIMeta, jsii_type="cdk8s-plus-24.PodDns"):
    '''Holds dns settings of the pod.'''

    def __init__(
        self,
        *,
        hostname: typing.Optional[builtins.str] = None,
        hostname_as_fqdn: typing.Optional[builtins.bool] = None,
        nameservers: typing.Optional[typing.Sequence[builtins.str]] = None,
        options: typing.Optional[typing.Sequence[typing.Union[DnsOption, typing.Dict[builtins.str, typing.Any]]]] = None,
        policy: typing.Optional[DnsPolicy] = None,
        searches: typing.Optional[typing.Sequence[builtins.str]] = None,
        subdomain: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param hostname: Specifies the hostname of the Pod. Default: - Set to a system-defined value.
        :param hostname_as_fqdn: If true the pod's hostname will be configured as the pod's FQDN, rather than the leaf name (the default). In Linux containers, this means setting the FQDN in the hostname field of the kernel (the nodename field of struct utsname). In Windows containers, this means setting the registry value of hostname for the registry key HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Services\\Tcpip\\Parameters to FQDN. If a pod does not have FQDN, this has no effect. Default: false
        :param nameservers: A list of IP addresses that will be used as DNS servers for the Pod. There can be at most 3 IP addresses specified. When the policy is set to "NONE", the list must contain at least one IP address, otherwise this property is optional. The servers listed will be combined to the base nameservers generated from the specified DNS policy with duplicate addresses removed.
        :param options: List of objects where each object may have a name property (required) and a value property (optional). The contents in this property will be merged to the options generated from the specified DNS policy. Duplicate entries are removed.
        :param policy: Set DNS policy for the pod. If policy is set to ``None``, other configuration must be supplied. Default: DnsPolicy.CLUSTER_FIRST
        :param searches: A list of DNS search domains for hostname lookup in the Pod. When specified, the provided list will be merged into the base search domain names generated from the chosen DNS policy. Duplicate domain names are removed. Kubernetes allows for at most 6 search domains.
        :param subdomain: If specified, the fully qualified Pod hostname will be "...svc.". Default: - No subdomain.
        '''
        props = PodDnsProps(
            hostname=hostname,
            hostname_as_fqdn=hostname_as_fqdn,
            nameservers=nameservers,
            options=options,
            policy=policy,
            searches=searches,
            subdomain=subdomain,
        )

        jsii.create(self.__class__, self, [props])

    @jsii.member(jsii_name="addNameserver")
    def add_nameserver(self, *nameservers: builtins.str) -> None:
        '''Add a nameserver.

        :param nameservers: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__50154b307087beb0fe89a253801b9c6e0465494faabd4debf8da7e6cfe461525)
            check_type(argname="argument nameservers", value=nameservers, expected_type=typing.Tuple[type_hints["nameservers"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast(None, jsii.invoke(self, "addNameserver", [*nameservers]))

    @jsii.member(jsii_name="addOption")
    def add_option(self, *options: DnsOption) -> None:
        '''Add a custom option.

        :param options: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__55ef728167d7594036d2dbc3b7d1a9d928496733db389f1e86bdbc6a50478724)
            check_type(argname="argument options", value=options, expected_type=typing.Tuple[type_hints["options"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast(None, jsii.invoke(self, "addOption", [*options]))

    @jsii.member(jsii_name="addSearch")
    def add_search(self, *searches: builtins.str) -> None:
        '''Add a search domain.

        :param searches: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__eaa608df5f8a2a93ed44d72ade8976e006003134e8b8f11a4ae82ac3ce97de86)
            check_type(argname="argument searches", value=searches, expected_type=typing.Tuple[type_hints["searches"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast(None, jsii.invoke(self, "addSearch", [*searches]))

    @builtins.property
    @jsii.member(jsii_name="hostnameAsFQDN")
    def hostname_as_fqdn(self) -> builtins.bool:
        '''Whether or not the pods hostname is set to its FQDN.'''
        return typing.cast(builtins.bool, jsii.get(self, "hostnameAsFQDN"))

    @builtins.property
    @jsii.member(jsii_name="nameservers")
    def nameservers(self) -> typing.List[builtins.str]:
        '''Nameservers defined for this pod.'''
        return typing.cast(typing.List[builtins.str], jsii.get(self, "nameservers"))

    @builtins.property
    @jsii.member(jsii_name="options")
    def options(self) -> typing.List[DnsOption]:
        '''Custom dns options defined for this pod.'''
        return typing.cast(typing.List[DnsOption], jsii.get(self, "options"))

    @builtins.property
    @jsii.member(jsii_name="policy")
    def policy(self) -> DnsPolicy:
        '''The DNS policy of this pod.'''
        return typing.cast(DnsPolicy, jsii.get(self, "policy"))

    @builtins.property
    @jsii.member(jsii_name="searches")
    def searches(self) -> typing.List[builtins.str]:
        '''Search domains defined for this pod.'''
        return typing.cast(typing.List[builtins.str], jsii.get(self, "searches"))

    @builtins.property
    @jsii.member(jsii_name="hostname")
    def hostname(self) -> typing.Optional[builtins.str]:
        '''The configured hostname of the pod.

        Undefined means its set to a system-defined value.
        '''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "hostname"))

    @builtins.property
    @jsii.member(jsii_name="subdomain")
    def subdomain(self) -> typing.Optional[builtins.str]:
        '''The configured subdomain of the pod.'''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "subdomain"))


@jsii.data_type(
    jsii_type="cdk8s-plus-24.PodDnsProps",
    jsii_struct_bases=[],
    name_mapping={
        "hostname": "hostname",
        "hostname_as_fqdn": "hostnameAsFQDN",
        "nameservers": "nameservers",
        "options": "options",
        "policy": "policy",
        "searches": "searches",
        "subdomain": "subdomain",
    },
)
class PodDnsProps:
    def __init__(
        self,
        *,
        hostname: typing.Optional[builtins.str] = None,
        hostname_as_fqdn: typing.Optional[builtins.bool] = None,
        nameservers: typing.Optional[typing.Sequence[builtins.str]] = None,
        options: typing.Optional[typing.Sequence[typing.Union[DnsOption, typing.Dict[builtins.str, typing.Any]]]] = None,
        policy: typing.Optional[DnsPolicy] = None,
        searches: typing.Optional[typing.Sequence[builtins.str]] = None,
        subdomain: typing.Optional[builtins.str] = None,
    ) -> None:
        '''Properties for ``PodDns``.

        :param hostname: Specifies the hostname of the Pod. Default: - Set to a system-defined value.
        :param hostname_as_fqdn: If true the pod's hostname will be configured as the pod's FQDN, rather than the leaf name (the default). In Linux containers, this means setting the FQDN in the hostname field of the kernel (the nodename field of struct utsname). In Windows containers, this means setting the registry value of hostname for the registry key HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Services\\Tcpip\\Parameters to FQDN. If a pod does not have FQDN, this has no effect. Default: false
        :param nameservers: A list of IP addresses that will be used as DNS servers for the Pod. There can be at most 3 IP addresses specified. When the policy is set to "NONE", the list must contain at least one IP address, otherwise this property is optional. The servers listed will be combined to the base nameservers generated from the specified DNS policy with duplicate addresses removed.
        :param options: List of objects where each object may have a name property (required) and a value property (optional). The contents in this property will be merged to the options generated from the specified DNS policy. Duplicate entries are removed.
        :param policy: Set DNS policy for the pod. If policy is set to ``None``, other configuration must be supplied. Default: DnsPolicy.CLUSTER_FIRST
        :param searches: A list of DNS search domains for hostname lookup in the Pod. When specified, the provided list will be merged into the base search domain names generated from the chosen DNS policy. Duplicate domain names are removed. Kubernetes allows for at most 6 search domains.
        :param subdomain: If specified, the fully qualified Pod hostname will be "...svc.". Default: - No subdomain.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1c0d843127c4a0e845900c7a4df4a0f05f91f939c989b71171552c2c73e5d933)
            check_type(argname="argument hostname", value=hostname, expected_type=type_hints["hostname"])
            check_type(argname="argument hostname_as_fqdn", value=hostname_as_fqdn, expected_type=type_hints["hostname_as_fqdn"])
            check_type(argname="argument nameservers", value=nameservers, expected_type=type_hints["nameservers"])
            check_type(argname="argument options", value=options, expected_type=type_hints["options"])
            check_type(argname="argument policy", value=policy, expected_type=type_hints["policy"])
            check_type(argname="argument searches", value=searches, expected_type=type_hints["searches"])
            check_type(argname="argument subdomain", value=subdomain, expected_type=type_hints["subdomain"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if hostname is not None:
            self._values["hostname"] = hostname
        if hostname_as_fqdn is not None:
            self._values["hostname_as_fqdn"] = hostname_as_fqdn
        if nameservers is not None:
            self._values["nameservers"] = nameservers
        if options is not None:
            self._values["options"] = options
        if policy is not None:
            self._values["policy"] = policy
        if searches is not None:
            self._values["searches"] = searches
        if subdomain is not None:
            self._values["subdomain"] = subdomain

    @builtins.property
    def hostname(self) -> typing.Optional[builtins.str]:
        '''Specifies the hostname of the Pod.

        :default: - Set to a system-defined value.
        '''
        result = self._values.get("hostname")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def hostname_as_fqdn(self) -> typing.Optional[builtins.bool]:
        '''If true the pod's hostname will be configured as the pod's FQDN, rather than the leaf name (the default).

        In Linux containers, this means setting the FQDN in the hostname field of the kernel (the nodename field of struct utsname).
        In Windows containers, this means setting the registry value of hostname for the registry
        key HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Services\\Tcpip\\Parameters to FQDN.
        If a pod does not have FQDN, this has no effect.

        :default: false
        '''
        result = self._values.get("hostname_as_fqdn")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def nameservers(self) -> typing.Optional[typing.List[builtins.str]]:
        '''A list of IP addresses that will be used as DNS servers for the Pod.

        There can be at most 3 IP addresses specified.
        When the policy is set to "NONE", the list must contain at least one IP address,
        otherwise this property is optional.
        The servers listed will be combined to the base nameservers generated from
        the specified DNS policy with duplicate addresses removed.
        '''
        result = self._values.get("nameservers")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def options(self) -> typing.Optional[typing.List[DnsOption]]:
        '''List of objects where each object may have a name property (required) and a value property (optional).

        The contents in this property
        will be merged to the options generated from the specified DNS policy.
        Duplicate entries are removed.
        '''
        result = self._values.get("options")
        return typing.cast(typing.Optional[typing.List[DnsOption]], result)

    @builtins.property
    def policy(self) -> typing.Optional[DnsPolicy]:
        '''Set DNS policy for the pod.

        If policy is set to ``None``, other configuration must be supplied.

        :default: DnsPolicy.CLUSTER_FIRST
        '''
        result = self._values.get("policy")
        return typing.cast(typing.Optional[DnsPolicy], result)

    @builtins.property
    def searches(self) -> typing.Optional[typing.List[builtins.str]]:
        '''A list of DNS search domains for hostname lookup in the Pod.

        When specified, the provided list will be merged into the base
        search domain names generated from the chosen DNS policy.
        Duplicate domain names are removed.

        Kubernetes allows for at most 6 search domains.
        '''
        result = self._values.get("searches")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def subdomain(self) -> typing.Optional[builtins.str]:
        '''If specified, the fully qualified Pod hostname will be "...svc.".

        :default: - No subdomain.
        '''
        result = self._values.get("subdomain")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "PodDnsProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.enum(jsii_type="cdk8s-plus-24.PodManagementPolicy")
class PodManagementPolicy(enum.Enum):
    '''Controls how pods are created during initial scale up, when replacing pods on nodes, or when scaling down.

    The default policy is ``OrderedReady``, where pods are created in increasing order
    (pod-0, then pod-1, etc) and the controller will wait until each pod is ready before
    continuing. When scaling down, the pods are removed in the opposite order.

    The alternative policy is ``Parallel`` which will create pods in parallel to match the
    desired scale without waiting, and on scale down will delete all pods at once.
    '''

    ORDERED_READY = "ORDERED_READY"
    PARALLEL = "PARALLEL"


class PodScheduling(metaclass=jsii.JSIIMeta, jsii_type="cdk8s-plus-24.PodScheduling"):
    '''Controls the pod scheduling strategy.'''

    def __init__(self, instance: "AbstractPod") -> None:
        '''
        :param instance: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c3489d5cb37b3a26e34965d1eefa7fed1405f5019607cc5ee15b60f59eb779fd)
            check_type(argname="argument instance", value=instance, expected_type=type_hints["instance"])
        jsii.create(self.__class__, self, [instance])

    @jsii.member(jsii_name="assign")
    def assign(self, node: NamedNode) -> None:
        '''Assign this pod a specific node by name.

        The scheduler ignores the Pod, and the kubelet on the named node
        tries to place the Pod on that node. Overrules any affinity rules of the pod.

        Some limitations of static assignment are:

        - If the named node does not exist, the Pod will not run, and in some
          cases may be automatically deleted.
        - If the named node does not have the resources to accommodate the Pod,
          the Pod will fail and its reason will indicate why, for example OutOfmemory or OutOfcpu.
        - Node names in cloud environments are not always predictable or stable.

        Will throw is the pod is already assigned to named node.

        Under the hood, this method utilizes the ``nodeName`` property.

        :param node: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ac3bd57416eb958504016aa1d2c9a1bcfef396677e9197a52403e13ae1caf33a)
            check_type(argname="argument node", value=node, expected_type=type_hints["node"])
        return typing.cast(None, jsii.invoke(self, "assign", [node]))

    @jsii.member(jsii_name="attract")
    def attract(
        self,
        node: LabeledNode,
        *,
        weight: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''Attract this pod to a node matched by selectors. You can select a node by using ``Node.labeled()``.

        Attracting to multiple nodes (i.e invoking this method multiple times) acts as
        an OR condition, meaning the pod will be assigned to either one of the nodes.

        Under the hood, this method utilizes the ``nodeAffinity`` property.

        :param node: -
        :param weight: Indicates the attraction is optional (soft), with this weight score. Default: - no weight. assignment is assumed to be required (hard).

        :see: https://kubernetes.io/docs/concepts/scheduling-eviction/assign-pod-node/#node-affinity
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__481e6e5e6d521948d351e56d6b7a9085863044632d5bf76bd6692d56118b8552)
            check_type(argname="argument node", value=node, expected_type=type_hints["node"])
        options = PodSchedulingAttractOptions(weight=weight)

        return typing.cast(None, jsii.invoke(self, "attract", [node, options]))

    @jsii.member(jsii_name="colocate")
    def colocate(
        self,
        selector: IPodSelector,
        *,
        topology: typing.Optional["Topology"] = None,
        weight: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''Co-locate this pod with a scheduling selection.

        A selection can be one of:

        - An instance of a ``Pod``.
        - An instance of a ``Workload`` (e.g ``Deployment``, ``StatefulSet``).
        - An un-managed pod that can be selected via ``Pods.select()``.

        Co-locating with multiple selections ((i.e invoking this method multiple times)) acts as
        an AND condition. meaning the pod will be assigned to a node that satisfies all
        selections (i.e runs at least one pod that satisifies each selection).

        Under the hood, this method utilizes the ``podAffinity`` property.

        :param selector: -
        :param topology: Which topology to coloate on. Default: - Topology.HOSTNAME
        :param weight: Indicates the co-location is optional (soft), with this weight score. Default: - no weight. co-location is assumed to be required (hard).

        :see: https://kubernetes.io/docs/concepts/scheduling-eviction/assign-pod-node/#inter-pod-affinity-and-anti-affinity
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__66cf9a72f9fdf9cb04b9e2d60fe6b0dd500100c42c5339117fbd6bd1be478936)
            check_type(argname="argument selector", value=selector, expected_type=type_hints["selector"])
        options = PodSchedulingColocateOptions(topology=topology, weight=weight)

        return typing.cast(None, jsii.invoke(self, "colocate", [selector, options]))

    @jsii.member(jsii_name="separate")
    def separate(
        self,
        selector: IPodSelector,
        *,
        topology: typing.Optional["Topology"] = None,
        weight: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''Seperate this pod from a scheduling selection.

        A selection can be one of:

        - An instance of a ``Pod``.
        - An instance of a ``Workload`` (e.g ``Deployment``, ``StatefulSet``).
        - An un-managed pod that can be selected via ``Pods.select()``.

        Seperating from multiple selections acts as an AND condition. meaning the pod
        will not be assigned to a node that satisfies all selections (i.e runs at least one pod that satisifies each selection).

        Under the hood, this method utilizes the ``podAntiAffinity`` property.

        :param selector: -
        :param topology: Which topology to separate on. Default: - Topology.HOSTNAME
        :param weight: Indicates the separation is optional (soft), with this weight score. Default: - no weight. separation is assumed to be required (hard).

        :see: https://kubernetes.io/docs/concepts/scheduling-eviction/assign-pod-node/#inter-pod-affinity-and-anti-affinity
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a097890ce94fc4a998a39129de9a32858fd9e11a9b544d94e1c3b560278c43d5)
            check_type(argname="argument selector", value=selector, expected_type=type_hints["selector"])
        options = PodSchedulingSeparateOptions(topology=topology, weight=weight)

        return typing.cast(None, jsii.invoke(self, "separate", [selector, options]))

    @jsii.member(jsii_name="tolerate")
    def tolerate(self, node: "TaintedNode") -> None:
        '''Allow this pod to tolerate taints matching these tolerations.

        You can put multiple taints on the same node and multiple tolerations on the same pod.
        The way Kubernetes processes multiple taints and tolerations is like a filter: start with
        all of a node's taints, then ignore the ones for which the pod has a matching toleration;
        the remaining un-ignored taints have the indicated effects on the pod. In particular:

        - if there is at least one un-ignored taint with effect NoSchedule then Kubernetes will
          not schedule the pod onto that node
        - if there is no un-ignored taint with effect NoSchedule but there is at least one un-ignored
          taint with effect PreferNoSchedule then Kubernetes will try to not schedule the pod onto the node
        - if there is at least one un-ignored taint with effect NoExecute then the pod will be evicted from
          the node (if it is already running on the node), and will not be scheduled onto the node (if it is
          not yet running on the node).

        Under the hood, this method utilizes the ``tolerations`` property.

        :param node: -

        :see: https://kubernetes.io/docs/concepts/scheduling-eviction/taint-and-toleration/
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__eed34151db9d573e5cbbe0564268e238cbb1bc8749156834b19f6bcca502e75e)
            check_type(argname="argument node", value=node, expected_type=type_hints["node"])
        return typing.cast(None, jsii.invoke(self, "tolerate", [node]))

    @builtins.property
    @jsii.member(jsii_name="instance")
    def _instance(self) -> "AbstractPod":
        return typing.cast("AbstractPod", jsii.get(self, "instance"))


@jsii.data_type(
    jsii_type="cdk8s-plus-24.PodSchedulingAttractOptions",
    jsii_struct_bases=[],
    name_mapping={"weight": "weight"},
)
class PodSchedulingAttractOptions:
    def __init__(self, *, weight: typing.Optional[jsii.Number] = None) -> None:
        '''Options for ``PodScheduling.attract``.

        :param weight: Indicates the attraction is optional (soft), with this weight score. Default: - no weight. assignment is assumed to be required (hard).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3853ba517cac480acf68defd60d3bff1ae7a8e7c88517575be414832b193504b)
            check_type(argname="argument weight", value=weight, expected_type=type_hints["weight"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if weight is not None:
            self._values["weight"] = weight

    @builtins.property
    def weight(self) -> typing.Optional[jsii.Number]:
        '''Indicates the attraction is optional (soft), with this weight score.

        :default: - no weight. assignment is assumed to be required (hard).
        '''
        result = self._values.get("weight")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "PodSchedulingAttractOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.PodSchedulingColocateOptions",
    jsii_struct_bases=[],
    name_mapping={"topology": "topology", "weight": "weight"},
)
class PodSchedulingColocateOptions:
    def __init__(
        self,
        *,
        topology: typing.Optional["Topology"] = None,
        weight: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''Options for ``PodScheduling.colocate``.

        :param topology: Which topology to coloate on. Default: - Topology.HOSTNAME
        :param weight: Indicates the co-location is optional (soft), with this weight score. Default: - no weight. co-location is assumed to be required (hard).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f62eb8d2ae17cb64432d73e3fe3a810281a0ccc735cb114db4aa468cb32d93ab)
            check_type(argname="argument topology", value=topology, expected_type=type_hints["topology"])
            check_type(argname="argument weight", value=weight, expected_type=type_hints["weight"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if topology is not None:
            self._values["topology"] = topology
        if weight is not None:
            self._values["weight"] = weight

    @builtins.property
    def topology(self) -> typing.Optional["Topology"]:
        '''Which topology to coloate on.

        :default: - Topology.HOSTNAME
        '''
        result = self._values.get("topology")
        return typing.cast(typing.Optional["Topology"], result)

    @builtins.property
    def weight(self) -> typing.Optional[jsii.Number]:
        '''Indicates the co-location is optional (soft), with this weight score.

        :default: - no weight. co-location is assumed to be required (hard).
        '''
        result = self._values.get("weight")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "PodSchedulingColocateOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.PodSchedulingSeparateOptions",
    jsii_struct_bases=[],
    name_mapping={"topology": "topology", "weight": "weight"},
)
class PodSchedulingSeparateOptions:
    def __init__(
        self,
        *,
        topology: typing.Optional["Topology"] = None,
        weight: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''Options for ``PodScheduling.separate``.

        :param topology: Which topology to separate on. Default: - Topology.HOSTNAME
        :param weight: Indicates the separation is optional (soft), with this weight score. Default: - no weight. separation is assumed to be required (hard).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8a10bfbf47097848978d685a624ecf051996671f30503401ec07d1507b7cd0f9)
            check_type(argname="argument topology", value=topology, expected_type=type_hints["topology"])
            check_type(argname="argument weight", value=weight, expected_type=type_hints["weight"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if topology is not None:
            self._values["topology"] = topology
        if weight is not None:
            self._values["weight"] = weight

    @builtins.property
    def topology(self) -> typing.Optional["Topology"]:
        '''Which topology to separate on.

        :default: - Topology.HOSTNAME
        '''
        result = self._values.get("topology")
        return typing.cast(typing.Optional["Topology"], result)

    @builtins.property
    def weight(self) -> typing.Optional[jsii.Number]:
        '''Indicates the separation is optional (soft), with this weight score.

        :default: - no weight. separation is assumed to be required (hard).
        '''
        result = self._values.get("weight")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "PodSchedulingSeparateOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class PodSecurityContext(
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-24.PodSecurityContext",
):
    '''Holds pod-level security attributes and common container settings.'''

    def __init__(
        self,
        *,
        ensure_non_root: typing.Optional[builtins.bool] = None,
        fs_group: typing.Optional[jsii.Number] = None,
        fs_group_change_policy: typing.Optional[FsGroupChangePolicy] = None,
        group: typing.Optional[jsii.Number] = None,
        sysctls: typing.Optional[typing.Sequence[typing.Union["Sysctl", typing.Dict[builtins.str, typing.Any]]]] = None,
        user: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''
        :param ensure_non_root: Indicates that the container must run as a non-root user. If true, the Kubelet will validate the image at runtime to ensure that it does not run as UID 0 (root) and fail to start the container if it does. Default: true
        :param fs_group: Modify the ownership and permissions of pod volumes to this GID. Default: - Volume ownership is not changed.
        :param fs_group_change_policy: Defines behavior of changing ownership and permission of the volume before being exposed inside Pod. This field will only apply to volume types which support fsGroup based ownership(and permissions). It will have no effect on ephemeral volume types such as: secret, configmaps and emptydir. Default: FsGroupChangePolicy.ALWAYS
        :param group: The GID to run the entrypoint of the container process. Default: - Group configured by container runtime
        :param sysctls: Sysctls hold a list of namespaced sysctls used for the pod. Pods with unsupported sysctls (by the container runtime) might fail to launch. Default: - No sysctls
        :param user: The UID to run the entrypoint of the container process. Default: - User specified in image metadata
        '''
        props = PodSecurityContextProps(
            ensure_non_root=ensure_non_root,
            fs_group=fs_group,
            fs_group_change_policy=fs_group_change_policy,
            group=group,
            sysctls=sysctls,
            user=user,
        )

        jsii.create(self.__class__, self, [props])

    @builtins.property
    @jsii.member(jsii_name="ensureNonRoot")
    def ensure_non_root(self) -> builtins.bool:
        return typing.cast(builtins.bool, jsii.get(self, "ensureNonRoot"))

    @builtins.property
    @jsii.member(jsii_name="fsGroupChangePolicy")
    def fs_group_change_policy(self) -> FsGroupChangePolicy:
        return typing.cast(FsGroupChangePolicy, jsii.get(self, "fsGroupChangePolicy"))

    @builtins.property
    @jsii.member(jsii_name="sysctls")
    def sysctls(self) -> typing.List["Sysctl"]:
        return typing.cast(typing.List["Sysctl"], jsii.get(self, "sysctls"))

    @builtins.property
    @jsii.member(jsii_name="fsGroup")
    def fs_group(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "fsGroup"))

    @builtins.property
    @jsii.member(jsii_name="group")
    def group(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "group"))

    @builtins.property
    @jsii.member(jsii_name="user")
    def user(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "user"))


@jsii.data_type(
    jsii_type="cdk8s-plus-24.PodSecurityContextProps",
    jsii_struct_bases=[],
    name_mapping={
        "ensure_non_root": "ensureNonRoot",
        "fs_group": "fsGroup",
        "fs_group_change_policy": "fsGroupChangePolicy",
        "group": "group",
        "sysctls": "sysctls",
        "user": "user",
    },
)
class PodSecurityContextProps:
    def __init__(
        self,
        *,
        ensure_non_root: typing.Optional[builtins.bool] = None,
        fs_group: typing.Optional[jsii.Number] = None,
        fs_group_change_policy: typing.Optional[FsGroupChangePolicy] = None,
        group: typing.Optional[jsii.Number] = None,
        sysctls: typing.Optional[typing.Sequence[typing.Union["Sysctl", typing.Dict[builtins.str, typing.Any]]]] = None,
        user: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''Properties for ``PodSecurityContext``.

        :param ensure_non_root: Indicates that the container must run as a non-root user. If true, the Kubelet will validate the image at runtime to ensure that it does not run as UID 0 (root) and fail to start the container if it does. Default: true
        :param fs_group: Modify the ownership and permissions of pod volumes to this GID. Default: - Volume ownership is not changed.
        :param fs_group_change_policy: Defines behavior of changing ownership and permission of the volume before being exposed inside Pod. This field will only apply to volume types which support fsGroup based ownership(and permissions). It will have no effect on ephemeral volume types such as: secret, configmaps and emptydir. Default: FsGroupChangePolicy.ALWAYS
        :param group: The GID to run the entrypoint of the container process. Default: - Group configured by container runtime
        :param sysctls: Sysctls hold a list of namespaced sysctls used for the pod. Pods with unsupported sysctls (by the container runtime) might fail to launch. Default: - No sysctls
        :param user: The UID to run the entrypoint of the container process. Default: - User specified in image metadata
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3e5b03101f4e58efddc740b92e3713b2b20108a7f8103aa75289ae1e1e9832c2)
            check_type(argname="argument ensure_non_root", value=ensure_non_root, expected_type=type_hints["ensure_non_root"])
            check_type(argname="argument fs_group", value=fs_group, expected_type=type_hints["fs_group"])
            check_type(argname="argument fs_group_change_policy", value=fs_group_change_policy, expected_type=type_hints["fs_group_change_policy"])
            check_type(argname="argument group", value=group, expected_type=type_hints["group"])
            check_type(argname="argument sysctls", value=sysctls, expected_type=type_hints["sysctls"])
            check_type(argname="argument user", value=user, expected_type=type_hints["user"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if ensure_non_root is not None:
            self._values["ensure_non_root"] = ensure_non_root
        if fs_group is not None:
            self._values["fs_group"] = fs_group
        if fs_group_change_policy is not None:
            self._values["fs_group_change_policy"] = fs_group_change_policy
        if group is not None:
            self._values["group"] = group
        if sysctls is not None:
            self._values["sysctls"] = sysctls
        if user is not None:
            self._values["user"] = user

    @builtins.property
    def ensure_non_root(self) -> typing.Optional[builtins.bool]:
        '''Indicates that the container must run as a non-root user.

        If true, the Kubelet will validate the image at runtime to ensure that it does
        not run as UID 0 (root) and fail to start the container if it does.

        :default: true
        '''
        result = self._values.get("ensure_non_root")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def fs_group(self) -> typing.Optional[jsii.Number]:
        '''Modify the ownership and permissions of pod volumes to this GID.

        :default: - Volume ownership is not changed.
        '''
        result = self._values.get("fs_group")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def fs_group_change_policy(self) -> typing.Optional[FsGroupChangePolicy]:
        '''Defines behavior of changing ownership and permission of the volume before being exposed inside Pod.

        This field will only apply to volume types which support fsGroup based ownership(and permissions).
        It will have no effect on ephemeral volume types such as: secret, configmaps and emptydir.

        :default: FsGroupChangePolicy.ALWAYS
        '''
        result = self._values.get("fs_group_change_policy")
        return typing.cast(typing.Optional[FsGroupChangePolicy], result)

    @builtins.property
    def group(self) -> typing.Optional[jsii.Number]:
        '''The GID to run the entrypoint of the container process.

        :default: - Group configured by container runtime
        '''
        result = self._values.get("group")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def sysctls(self) -> typing.Optional[typing.List["Sysctl"]]:
        '''Sysctls hold a list of namespaced sysctls used for the pod.

        Pods with unsupported sysctls (by the container runtime) might fail to launch.

        :default: - No sysctls
        '''
        result = self._values.get("sysctls")
        return typing.cast(typing.Optional[typing.List["Sysctl"]], result)

    @builtins.property
    def user(self) -> typing.Optional[jsii.Number]:
        '''The UID to run the entrypoint of the container process.

        :default: - User specified in image metadata
        '''
        result = self._values.get("user")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "PodSecurityContextProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.PodSelectorConfig",
    jsii_struct_bases=[],
    name_mapping={"label_selector": "labelSelector", "namespaces": "namespaces"},
)
class PodSelectorConfig:
    def __init__(
        self,
        *,
        label_selector: LabelSelector,
        namespaces: typing.Optional[typing.Union[NamespaceSelectorConfig, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Configuration for selecting pods, optionally in particular namespaces.

        :param label_selector: A selector to select pods by labels.
        :param namespaces: Configuration for selecting which namepsaces are the pods allowed to be in.
        '''
        if isinstance(namespaces, dict):
            namespaces = NamespaceSelectorConfig(**namespaces)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__55e245a4a1de7177103c951cc387f06e16b291b67b8d8a83746cc80e0df7a108)
            check_type(argname="argument label_selector", value=label_selector, expected_type=type_hints["label_selector"])
            check_type(argname="argument namespaces", value=namespaces, expected_type=type_hints["namespaces"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "label_selector": label_selector,
        }
        if namespaces is not None:
            self._values["namespaces"] = namespaces

    @builtins.property
    def label_selector(self) -> LabelSelector:
        '''A selector to select pods by labels.'''
        result = self._values.get("label_selector")
        assert result is not None, "Required property 'label_selector' is missing"
        return typing.cast(LabelSelector, result)

    @builtins.property
    def namespaces(self) -> typing.Optional[NamespaceSelectorConfig]:
        '''Configuration for selecting which namepsaces are the pods allowed to be in.'''
        result = self._values.get("namespaces")
        return typing.cast(typing.Optional[NamespaceSelectorConfig], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "PodSelectorConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(IPodSelector)
class Pods(
    _constructs_77d1e7e8.Construct,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-24.Pods",
):
    '''Represents a group of pods.'''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        expressions: typing.Optional[typing.Sequence[LabelExpression]] = None,
        labels: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        namespaces: typing.Optional[INamespaceSelector] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param expressions: -
        :param labels: -
        :param namespaces: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__319ecd4e24eebdedb4e6a77df6e3485274dec62d2f8d8114a3fec7c0eded28b0)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
            check_type(argname="argument expressions", value=expressions, expected_type=type_hints["expressions"])
            check_type(argname="argument labels", value=labels, expected_type=type_hints["labels"])
            check_type(argname="argument namespaces", value=namespaces, expected_type=type_hints["namespaces"])
        jsii.create(self.__class__, self, [scope, id, expressions, labels, namespaces])

    @jsii.member(jsii_name="all")
    @builtins.classmethod
    def all(
        cls,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        namespaces: typing.Optional[Namespaces] = None,
    ) -> "Pods":
        '''Select all pods.

        :param scope: -
        :param id: -
        :param namespaces: Namespaces the pods are allowed to be in. Use ``Namespaces.all()`` to allow all namespaces. Default: - unset, implies the namespace of the resource this selection is used in.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__98ea27586ab5b10dec685bf40a8a869a2237f20db089a923df66cc2e2ca4480e)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        options = PodsAllOptions(namespaces=namespaces)

        return typing.cast("Pods", jsii.sinvoke(cls, "all", [scope, id, options]))

    @jsii.member(jsii_name="select")
    @builtins.classmethod
    def select(
        cls,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        expressions: typing.Optional[typing.Sequence[LabelExpression]] = None,
        labels: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        namespaces: typing.Optional[Namespaces] = None,
    ) -> "Pods":
        '''Select pods in the cluster with various selectors.

        :param scope: -
        :param id: -
        :param expressions: Expressions the pods must satisify. Default: - no expressions requirements.
        :param labels: Labels the pods must have. Default: - no strict labels requirements.
        :param namespaces: Namespaces the pods are allowed to be in. Use ``Namespaces.all()`` to allow all namespaces. Default: - unset, implies the namespace of the resource this selection is used in.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0eb0a073cd16f078ba06f3f9adcdec117fd8a18833d1aee464ac0667812bb28f)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        options = PodsSelectOptions(
            expressions=expressions, labels=labels, namespaces=namespaces
        )

        return typing.cast("Pods", jsii.sinvoke(cls, "select", [scope, id, options]))

    @jsii.member(jsii_name="toNetworkPolicyPeerConfig")
    def to_network_policy_peer_config(self) -> NetworkPolicyPeerConfig:
        '''
        :see: INetworkPolicyPeer.toNetworkPolicyPeerConfig()
        '''
        return typing.cast(NetworkPolicyPeerConfig, jsii.invoke(self, "toNetworkPolicyPeerConfig", []))

    @jsii.member(jsii_name="toPodSelector")
    def to_pod_selector(self) -> typing.Optional[IPodSelector]:
        '''
        :see: INetworkPolicyPeer.toPodSelector()
        '''
        return typing.cast(typing.Optional[IPodSelector], jsii.invoke(self, "toPodSelector", []))

    @jsii.member(jsii_name="toPodSelectorConfig")
    def to_pod_selector_config(self) -> PodSelectorConfig:
        '''Return the configuration of this selector.

        :see: IPodSelector.toPodSelectorConfig()
        '''
        return typing.cast(PodSelectorConfig, jsii.invoke(self, "toPodSelectorConfig", []))


@jsii.data_type(
    jsii_type="cdk8s-plus-24.PodsAllOptions",
    jsii_struct_bases=[],
    name_mapping={"namespaces": "namespaces"},
)
class PodsAllOptions:
    def __init__(self, *, namespaces: typing.Optional[Namespaces] = None) -> None:
        '''Options for ``Pods.all``.

        :param namespaces: Namespaces the pods are allowed to be in. Use ``Namespaces.all()`` to allow all namespaces. Default: - unset, implies the namespace of the resource this selection is used in.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__88a1ad0ef08e302866f7665d1ff2bac1dd8fe4eb67e0e0399d6d898916693517)
            check_type(argname="argument namespaces", value=namespaces, expected_type=type_hints["namespaces"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if namespaces is not None:
            self._values["namespaces"] = namespaces

    @builtins.property
    def namespaces(self) -> typing.Optional[Namespaces]:
        '''Namespaces the pods are allowed to be in.

        Use ``Namespaces.all()`` to allow all namespaces.

        :default: - unset, implies the namespace of the resource this selection is used in.
        '''
        result = self._values.get("namespaces")
        return typing.cast(typing.Optional[Namespaces], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "PodsAllOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.PodsSelectOptions",
    jsii_struct_bases=[],
    name_mapping={
        "expressions": "expressions",
        "labels": "labels",
        "namespaces": "namespaces",
    },
)
class PodsSelectOptions:
    def __init__(
        self,
        *,
        expressions: typing.Optional[typing.Sequence[LabelExpression]] = None,
        labels: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        namespaces: typing.Optional[Namespaces] = None,
    ) -> None:
        '''Options for ``Pods.select``.

        :param expressions: Expressions the pods must satisify. Default: - no expressions requirements.
        :param labels: Labels the pods must have. Default: - no strict labels requirements.
        :param namespaces: Namespaces the pods are allowed to be in. Use ``Namespaces.all()`` to allow all namespaces. Default: - unset, implies the namespace of the resource this selection is used in.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e8f40d235df894759b712c77a84a26b4ed6e13f08dfb2741a575693f789b799c)
            check_type(argname="argument expressions", value=expressions, expected_type=type_hints["expressions"])
            check_type(argname="argument labels", value=labels, expected_type=type_hints["labels"])
            check_type(argname="argument namespaces", value=namespaces, expected_type=type_hints["namespaces"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if expressions is not None:
            self._values["expressions"] = expressions
        if labels is not None:
            self._values["labels"] = labels
        if namespaces is not None:
            self._values["namespaces"] = namespaces

    @builtins.property
    def expressions(self) -> typing.Optional[typing.List[LabelExpression]]:
        '''Expressions the pods must satisify.

        :default: - no expressions requirements.
        '''
        result = self._values.get("expressions")
        return typing.cast(typing.Optional[typing.List[LabelExpression]], result)

    @builtins.property
    def labels(self) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        '''Labels the pods must have.

        :default: - no strict labels requirements.
        '''
        result = self._values.get("labels")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, builtins.str]], result)

    @builtins.property
    def namespaces(self) -> typing.Optional[Namespaces]:
        '''Namespaces the pods are allowed to be in.

        Use ``Namespaces.all()`` to allow all namespaces.

        :default: - unset, implies the namespace of the resource this selection is used in.
        '''
        result = self._values.get("namespaces")
        return typing.cast(typing.Optional[Namespaces], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "PodsSelectOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class Probe(metaclass=jsii.JSIIMeta, jsii_type="cdk8s-plus-24.Probe"):
    '''Probe describes a health check to be performed against a container to determine whether it is alive or ready to receive traffic.'''

    @jsii.member(jsii_name="fromCommand")
    @builtins.classmethod
    def from_command(
        cls,
        command: typing.Sequence[builtins.str],
        *,
        failure_threshold: typing.Optional[jsii.Number] = None,
        initial_delay_seconds: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        period_seconds: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        success_threshold: typing.Optional[jsii.Number] = None,
        timeout_seconds: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
    ) -> "Probe":
        '''Defines a probe based on a command which is executed within the container.

        :param command: The command to execute.
        :param failure_threshold: Minimum consecutive failures for the probe to be considered failed after having succeeded. Defaults to 3. Minimum value is 1. Default: 3
        :param initial_delay_seconds: Number of seconds after the container has started before liveness probes are initiated. Default: - immediate
        :param period_seconds: How often (in seconds) to perform the probe. Default to 10 seconds. Minimum value is 1. Default: Duration.seconds(10) Minimum value is 1.
        :param success_threshold: Minimum consecutive successes for the probe to be considered successful after having failed. Defaults to 1. Must be 1 for liveness and startup. Minimum value is 1. Default: 1 Must be 1 for liveness and startup. Minimum value is 1.
        :param timeout_seconds: Number of seconds after which the probe times out. Defaults to 1 second. Minimum value is 1. Default: Duration.seconds(1)
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ad6cbd45e25cea60251a8000d6697beaf319be3a65dc5a590fb909cd9f702cf5)
            check_type(argname="argument command", value=command, expected_type=type_hints["command"])
        options = CommandProbeOptions(
            failure_threshold=failure_threshold,
            initial_delay_seconds=initial_delay_seconds,
            period_seconds=period_seconds,
            success_threshold=success_threshold,
            timeout_seconds=timeout_seconds,
        )

        return typing.cast("Probe", jsii.sinvoke(cls, "fromCommand", [command, options]))

    @jsii.member(jsii_name="fromHttpGet")
    @builtins.classmethod
    def from_http_get(
        cls,
        path: builtins.str,
        *,
        port: typing.Optional[jsii.Number] = None,
        scheme: typing.Optional[ConnectionScheme] = None,
        failure_threshold: typing.Optional[jsii.Number] = None,
        initial_delay_seconds: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        period_seconds: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        success_threshold: typing.Optional[jsii.Number] = None,
        timeout_seconds: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
    ) -> "Probe":
        '''Defines a probe based on an HTTP GET request to the IP address of the container.

        :param path: The URL path to hit.
        :param port: The TCP port to use when sending the GET request. Default: - defaults to ``container.port``.
        :param scheme: Scheme to use for connecting to the host (HTTP or HTTPS). Default: ConnectionScheme.HTTP
        :param failure_threshold: Minimum consecutive failures for the probe to be considered failed after having succeeded. Defaults to 3. Minimum value is 1. Default: 3
        :param initial_delay_seconds: Number of seconds after the container has started before liveness probes are initiated. Default: - immediate
        :param period_seconds: How often (in seconds) to perform the probe. Default to 10 seconds. Minimum value is 1. Default: Duration.seconds(10) Minimum value is 1.
        :param success_threshold: Minimum consecutive successes for the probe to be considered successful after having failed. Defaults to 1. Must be 1 for liveness and startup. Minimum value is 1. Default: 1 Must be 1 for liveness and startup. Minimum value is 1.
        :param timeout_seconds: Number of seconds after which the probe times out. Defaults to 1 second. Minimum value is 1. Default: Duration.seconds(1)
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b3b169d29f78e986676009dbfa026440893c4d14cd83df842320c7f9f168d3e1)
            check_type(argname="argument path", value=path, expected_type=type_hints["path"])
        options = HttpGetProbeOptions(
            port=port,
            scheme=scheme,
            failure_threshold=failure_threshold,
            initial_delay_seconds=initial_delay_seconds,
            period_seconds=period_seconds,
            success_threshold=success_threshold,
            timeout_seconds=timeout_seconds,
        )

        return typing.cast("Probe", jsii.sinvoke(cls, "fromHttpGet", [path, options]))

    @jsii.member(jsii_name="fromTcpSocket")
    @builtins.classmethod
    def from_tcp_socket(
        cls,
        *,
        host: typing.Optional[builtins.str] = None,
        port: typing.Optional[jsii.Number] = None,
        failure_threshold: typing.Optional[jsii.Number] = None,
        initial_delay_seconds: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        period_seconds: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        success_threshold: typing.Optional[jsii.Number] = None,
        timeout_seconds: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
    ) -> "Probe":
        '''Defines a probe based opening a connection to a TCP socket on the container.

        :param host: The host name to connect to on the container. Default: - defaults to the pod IP
        :param port: The TCP port to connect to on the container. Default: - defaults to ``container.port``.
        :param failure_threshold: Minimum consecutive failures for the probe to be considered failed after having succeeded. Defaults to 3. Minimum value is 1. Default: 3
        :param initial_delay_seconds: Number of seconds after the container has started before liveness probes are initiated. Default: - immediate
        :param period_seconds: How often (in seconds) to perform the probe. Default to 10 seconds. Minimum value is 1. Default: Duration.seconds(10) Minimum value is 1.
        :param success_threshold: Minimum consecutive successes for the probe to be considered successful after having failed. Defaults to 1. Must be 1 for liveness and startup. Minimum value is 1. Default: 1 Must be 1 for liveness and startup. Minimum value is 1.
        :param timeout_seconds: Number of seconds after which the probe times out. Defaults to 1 second. Minimum value is 1. Default: Duration.seconds(1)
        '''
        options = TcpSocketProbeOptions(
            host=host,
            port=port,
            failure_threshold=failure_threshold,
            initial_delay_seconds=initial_delay_seconds,
            period_seconds=period_seconds,
            success_threshold=success_threshold,
            timeout_seconds=timeout_seconds,
        )

        return typing.cast("Probe", jsii.sinvoke(cls, "fromTcpSocket", [options]))


@jsii.data_type(
    jsii_type="cdk8s-plus-24.ProbeOptions",
    jsii_struct_bases=[],
    name_mapping={
        "failure_threshold": "failureThreshold",
        "initial_delay_seconds": "initialDelaySeconds",
        "period_seconds": "periodSeconds",
        "success_threshold": "successThreshold",
        "timeout_seconds": "timeoutSeconds",
    },
)
class ProbeOptions:
    def __init__(
        self,
        *,
        failure_threshold: typing.Optional[jsii.Number] = None,
        initial_delay_seconds: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        period_seconds: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        success_threshold: typing.Optional[jsii.Number] = None,
        timeout_seconds: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
    ) -> None:
        '''Probe options.

        :param failure_threshold: Minimum consecutive failures for the probe to be considered failed after having succeeded. Defaults to 3. Minimum value is 1. Default: 3
        :param initial_delay_seconds: Number of seconds after the container has started before liveness probes are initiated. Default: - immediate
        :param period_seconds: How often (in seconds) to perform the probe. Default to 10 seconds. Minimum value is 1. Default: Duration.seconds(10) Minimum value is 1.
        :param success_threshold: Minimum consecutive successes for the probe to be considered successful after having failed. Defaults to 1. Must be 1 for liveness and startup. Minimum value is 1. Default: 1 Must be 1 for liveness and startup. Minimum value is 1.
        :param timeout_seconds: Number of seconds after which the probe times out. Defaults to 1 second. Minimum value is 1. Default: Duration.seconds(1)
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c9cb204399436e1436bbbb7dfce263b5e85a987ab81c0888d0331dd4feb44648)
            check_type(argname="argument failure_threshold", value=failure_threshold, expected_type=type_hints["failure_threshold"])
            check_type(argname="argument initial_delay_seconds", value=initial_delay_seconds, expected_type=type_hints["initial_delay_seconds"])
            check_type(argname="argument period_seconds", value=period_seconds, expected_type=type_hints["period_seconds"])
            check_type(argname="argument success_threshold", value=success_threshold, expected_type=type_hints["success_threshold"])
            check_type(argname="argument timeout_seconds", value=timeout_seconds, expected_type=type_hints["timeout_seconds"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if failure_threshold is not None:
            self._values["failure_threshold"] = failure_threshold
        if initial_delay_seconds is not None:
            self._values["initial_delay_seconds"] = initial_delay_seconds
        if period_seconds is not None:
            self._values["period_seconds"] = period_seconds
        if success_threshold is not None:
            self._values["success_threshold"] = success_threshold
        if timeout_seconds is not None:
            self._values["timeout_seconds"] = timeout_seconds

    @builtins.property
    def failure_threshold(self) -> typing.Optional[jsii.Number]:
        '''Minimum consecutive failures for the probe to be considered failed after having succeeded.

        Defaults to 3. Minimum value is 1.

        :default: 3
        '''
        result = self._values.get("failure_threshold")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def initial_delay_seconds(self) -> typing.Optional[_cdk8s_d3d9af27.Duration]:
        '''Number of seconds after the container has started before liveness probes are initiated.

        :default: - immediate

        :see: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        '''
        result = self._values.get("initial_delay_seconds")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Duration], result)

    @builtins.property
    def period_seconds(self) -> typing.Optional[_cdk8s_d3d9af27.Duration]:
        '''How often (in seconds) to perform the probe.

        Default to 10 seconds. Minimum value is 1.

        :default: Duration.seconds(10) Minimum value is 1.
        '''
        result = self._values.get("period_seconds")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Duration], result)

    @builtins.property
    def success_threshold(self) -> typing.Optional[jsii.Number]:
        '''Minimum consecutive successes for the probe to be considered successful after having failed. Defaults to 1.

        Must be 1 for liveness and startup. Minimum value is 1.

        :default: 1 Must be 1 for liveness and startup. Minimum value is 1.
        '''
        result = self._values.get("success_threshold")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def timeout_seconds(self) -> typing.Optional[_cdk8s_d3d9af27.Duration]:
        '''Number of seconds after which the probe times out.

        Defaults to 1 second. Minimum value is 1.

        :default: Duration.seconds(1)

        :see: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        '''
        result = self._values.get("timeout_seconds")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Duration], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ProbeOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.enum(jsii_type="cdk8s-plus-24.Protocol")
class Protocol(enum.Enum):
    '''Network protocols.'''

    TCP = "TCP"
    '''TCP.'''
    UDP = "UDP"
    '''UDP.'''
    SCTP = "SCTP"
    '''SCTP.'''


class Replicas(metaclass=jsii.JSIIMeta, jsii_type="cdk8s-plus-24.Replicas"):
    '''The amount of replicas that will change.'''

    @jsii.member(jsii_name="absolute")
    @builtins.classmethod
    def absolute(cls, value: jsii.Number) -> "Replicas":
        '''Changes the pods by a percentage of the it's current value.

        :param value: The amount of change to apply. Must be greater than 0.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4104e99f41b48f3dec2570d06b34bf368b29a6ba25f497b81de9b71f2d59be91)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast("Replicas", jsii.sinvoke(cls, "absolute", [value]))

    @jsii.member(jsii_name="percent")
    @builtins.classmethod
    def percent(cls, value: jsii.Number) -> "Replicas":
        '''Changes the pods by a percentage of the it's current value.

        :param value: The percentage of change to apply. Must be greater than 0.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__7c8807f9ec963b59908e0ef0aef4e42b3bb335e91381599aafb8ff1dfe88f7bd)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast("Replicas", jsii.sinvoke(cls, "percent", [value]))


@jsii.implements(IResource, IApiResource, IApiEndpoint)
class Resource(
    _constructs_77d1e7e8.Construct,
    metaclass=jsii.JSIIAbstractClass,
    jsii_type="cdk8s-plus-24.Resource",
):
    '''Base class for all Kubernetes objects in stdk8s.

    Represents a single
    resource.
    '''

    def __init__(self, scope: _constructs_77d1e7e8.Construct, id: builtins.str) -> None:
        '''
        :param scope: -
        :param id: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d44c253e368a41a2d35aec556ec797607153f13f2ced1f5df690370259ebe737)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        jsii.create(self.__class__, self, [scope, id])

    @jsii.member(jsii_name="asApiResource")
    def as_api_resource(self) -> typing.Optional[IApiResource]:
        '''Return the IApiResource this object represents.'''
        return typing.cast(typing.Optional[IApiResource], jsii.invoke(self, "asApiResource", []))

    @jsii.member(jsii_name="asNonApiResource")
    def as_non_api_resource(self) -> typing.Optional[builtins.str]:
        '''Return the non resource url this object represents.'''
        return typing.cast(typing.Optional[builtins.str], jsii.invoke(self, "asNonApiResource", []))

    @builtins.property
    @jsii.member(jsii_name="apiGroup")
    def api_group(self) -> builtins.str:
        '''The group portion of the API version (e.g. "authorization.k8s.io").'''
        return typing.cast(builtins.str, jsii.get(self, "apiGroup"))

    @builtins.property
    @jsii.member(jsii_name="apiObject")
    @abc.abstractmethod
    def _api_object(self) -> _cdk8s_d3d9af27.ApiObject:
        '''The underlying cdk8s API object.'''
        ...

    @builtins.property
    @jsii.member(jsii_name="apiVersion")
    def api_version(self) -> builtins.str:
        '''The object's API version (e.g. "authorization.k8s.io/v1").'''
        return typing.cast(builtins.str, jsii.get(self, "apiVersion"))

    @builtins.property
    @jsii.member(jsii_name="kind")
    def kind(self) -> builtins.str:
        '''The object kind (e.g. "Deployment").'''
        return typing.cast(builtins.str, jsii.get(self, "kind"))

    @builtins.property
    @jsii.member(jsii_name="metadata")
    def metadata(self) -> _cdk8s_d3d9af27.ApiObjectMetadataDefinition:
        return typing.cast(_cdk8s_d3d9af27.ApiObjectMetadataDefinition, jsii.get(self, "metadata"))

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        '''The name of this API object.'''
        return typing.cast(builtins.str, jsii.get(self, "name"))

    @builtins.property
    @jsii.member(jsii_name="permissions")
    def permissions(self) -> "ResourcePermissions":
        return typing.cast("ResourcePermissions", jsii.get(self, "permissions"))

    @builtins.property
    @jsii.member(jsii_name="resourceType")
    @abc.abstractmethod
    def resource_type(self) -> builtins.str:
        '''The name of a resource type as it appears in the relevant API endpoint.'''
        ...

    @builtins.property
    @jsii.member(jsii_name="resourceName")
    def resource_name(self) -> typing.Optional[builtins.str]:
        '''The unique, namespace-global, name of an object inside the Kubernetes cluster.

        If this is omitted, the ApiResource should represent all objects of the given type.
        '''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "resourceName"))


class _ResourceProxy(Resource):
    @builtins.property
    @jsii.member(jsii_name="apiObject")
    def _api_object(self) -> _cdk8s_d3d9af27.ApiObject:
        '''The underlying cdk8s API object.'''
        return typing.cast(_cdk8s_d3d9af27.ApiObject, jsii.get(self, "apiObject"))

    @builtins.property
    @jsii.member(jsii_name="resourceType")
    def resource_type(self) -> builtins.str:
        '''The name of a resource type as it appears in the relevant API endpoint.'''
        return typing.cast(builtins.str, jsii.get(self, "resourceType"))

# Adding a "__jsii_proxy_class__(): typing.Type" function to the abstract class
typing.cast(typing.Any, Resource).__jsii_proxy_class__ = lambda : _ResourceProxy


@jsii.enum(jsii_type="cdk8s-plus-24.ResourceFieldPaths")
class ResourceFieldPaths(enum.Enum):
    CPU_LIMIT = "CPU_LIMIT"
    '''CPU limit of the container.'''
    MEMORY_LIMIT = "MEMORY_LIMIT"
    '''Memory limit of the container.'''
    CPU_REQUEST = "CPU_REQUEST"
    '''CPU request of the container.'''
    MEMORY_REQUEST = "MEMORY_REQUEST"
    '''Memory request of the container.'''
    STORAGE_LIMIT = "STORAGE_LIMIT"
    '''Ephemeral storage limit of the container.'''
    STORAGE_REQUEST = "STORAGE_REQUEST"
    '''Ephemeral storage request of the container.'''


class ResourcePermissions(
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-24.ResourcePermissions",
):
    '''Controls permissions for operations on resources.'''

    def __init__(self, instance: Resource) -> None:
        '''
        :param instance: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__938b39c9e704950d6881d5a9d0816fe19edcef12c03527065c607c9e197c51ab)
            check_type(argname="argument instance", value=instance, expected_type=type_hints["instance"])
        jsii.create(self.__class__, self, [instance])

    @jsii.member(jsii_name="grantRead")
    def grant_read(self, *subjects: ISubject) -> "RoleBinding":
        '''Grants the list of subjects permissions to read this resource.

        :param subjects: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__27f3bee29c6fc6ad31eff67eb833fa189e38da6745d5a525b0a4ff033047b6a4)
            check_type(argname="argument subjects", value=subjects, expected_type=typing.Tuple[type_hints["subjects"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast("RoleBinding", jsii.invoke(self, "grantRead", [*subjects]))

    @jsii.member(jsii_name="grantReadWrite")
    def grant_read_write(self, *subjects: ISubject) -> "RoleBinding":
        '''Grants the list of subjects permissions to read and write this resource.

        :param subjects: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a8b5aa7e93cca01004bff510168e454bdd77c7a4de5b7416d39261621ba77296)
            check_type(argname="argument subjects", value=subjects, expected_type=typing.Tuple[type_hints["subjects"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast("RoleBinding", jsii.invoke(self, "grantReadWrite", [*subjects]))

    @builtins.property
    @jsii.member(jsii_name="instance")
    def _instance(self) -> Resource:
        return typing.cast(Resource, jsii.get(self, "instance"))


@jsii.data_type(
    jsii_type="cdk8s-plus-24.ResourceProps",
    jsii_struct_bases=[],
    name_mapping={"metadata": "metadata"},
)
class ResourceProps:
    def __init__(
        self,
        *,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Initialization properties for resources.

        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        '''
        if isinstance(metadata, dict):
            metadata = _cdk8s_d3d9af27.ApiObjectMetadata(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9dbab97b3a7001220aa12d669ee752c2a22ce02e50d12015038c16442a38d1f3)
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def metadata(self) -> typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata]:
        '''Metadata that all persisted resources must have, which includes all objects users must create.'''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ResourceProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.enum(jsii_type="cdk8s-plus-24.RestartPolicy")
class RestartPolicy(enum.Enum):
    '''Restart policy for all containers within the pod.'''

    ALWAYS = "ALWAYS"
    '''Always restart the pod after it exits.'''
    ON_FAILURE = "ON_FAILURE"
    '''Only restart if the pod exits with a non-zero exit code.'''
    NEVER = "NEVER"
    '''Never restart the pod.'''


@jsii.implements(IRole)
class Role(Resource, metaclass=jsii.JSIIMeta, jsii_type="cdk8s-plus-24.Role"):
    '''Role is a namespaced, logical grouping of PolicyRules that can be referenced as a unit by a RoleBinding.'''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        rules: typing.Optional[typing.Sequence[typing.Union["RolePolicyRule", typing.Dict[builtins.str, typing.Any]]]] = None,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param rules: A list of rules the role should allow. Default: []
        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__38c83893dbdd9060192bc8164d0584df452d9ab9d13ffe2bfe515d640ef5c94f)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = RoleProps(rules=rules, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="fromRoleName")
    @builtins.classmethod
    def from_role_name(
        cls,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        name: builtins.str,
    ) -> IRole:
        '''Imports a role from the cluster as a reference.

        :param scope: -
        :param id: -
        :param name: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c61f8f3ed035ac6698a24ab9def38717aa26acc8584fd817c0a5863b8612bcb5)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
        return typing.cast(IRole, jsii.sinvoke(cls, "fromRoleName", [scope, id, name]))

    @jsii.member(jsii_name="allow")
    def allow(
        self,
        verbs: typing.Sequence[builtins.str],
        *resources: IApiResource,
    ) -> None:
        '''Add permission to perform a list of HTTP verbs on a collection of resources.

        :param verbs: -
        :param resources: The resource(s) to apply to.

        :see: https://kubernetes.io/docs/reference/access-authn-authz/authorization/#determine-the-request-verb
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__7e61baa3a096500a0ee18931682bace367ef0dd45a4e32d6f0e55f3b02b751e1)
            check_type(argname="argument verbs", value=verbs, expected_type=type_hints["verbs"])
            check_type(argname="argument resources", value=resources, expected_type=typing.Tuple[type_hints["resources"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast(None, jsii.invoke(self, "allow", [verbs, *resources]))

    @jsii.member(jsii_name="allowCreate")
    def allow_create(self, *resources: IApiResource) -> None:
        '''Add "create" permission for the resources.

        :param resources: The resource(s) to apply to.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d88e38f93422aa05aecc92ba219e75fb1475f371a848cc7466ea776ff7be04e1)
            check_type(argname="argument resources", value=resources, expected_type=typing.Tuple[type_hints["resources"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast(None, jsii.invoke(self, "allowCreate", [*resources]))

    @jsii.member(jsii_name="allowDelete")
    def allow_delete(self, *resources: IApiResource) -> None:
        '''Add "delete" permission for the resources.

        :param resources: The resource(s) to apply to.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4236324e2dae2b0cbe172f7d20e3807338c13ca846d9af463a0e99f339c811b0)
            check_type(argname="argument resources", value=resources, expected_type=typing.Tuple[type_hints["resources"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast(None, jsii.invoke(self, "allowDelete", [*resources]))

    @jsii.member(jsii_name="allowDeleteCollection")
    def allow_delete_collection(self, *resources: IApiResource) -> None:
        '''Add "deletecollection" permission for the resources.

        :param resources: The resource(s) to apply to.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e1ea809f91f53082dd29fc457b98fe4379cd746918147e70e02c341ea16181f2)
            check_type(argname="argument resources", value=resources, expected_type=typing.Tuple[type_hints["resources"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast(None, jsii.invoke(self, "allowDeleteCollection", [*resources]))

    @jsii.member(jsii_name="allowGet")
    def allow_get(self, *resources: IApiResource) -> None:
        '''Add "get" permission for the resources.

        :param resources: The resource(s) to apply to.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2f438d0a83dba6451bb5911c967ef42a14486cc47e064da431cb6a33e5559515)
            check_type(argname="argument resources", value=resources, expected_type=typing.Tuple[type_hints["resources"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast(None, jsii.invoke(self, "allowGet", [*resources]))

    @jsii.member(jsii_name="allowList")
    def allow_list(self, *resources: IApiResource) -> None:
        '''Add "list" permission for the resources.

        :param resources: The resource(s) to apply to.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__620157234cbfc7a159c9d6fca4e796ffca60736bd4e4f9ab7bcc6dd672c51c83)
            check_type(argname="argument resources", value=resources, expected_type=typing.Tuple[type_hints["resources"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast(None, jsii.invoke(self, "allowList", [*resources]))

    @jsii.member(jsii_name="allowPatch")
    def allow_patch(self, *resources: IApiResource) -> None:
        '''Add "patch" permission for the resources.

        :param resources: The resource(s) to apply to.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__fad8517cfb216e6a410b795b870c740c50397d7ae21226b02d5a65a4a56e025f)
            check_type(argname="argument resources", value=resources, expected_type=typing.Tuple[type_hints["resources"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast(None, jsii.invoke(self, "allowPatch", [*resources]))

    @jsii.member(jsii_name="allowRead")
    def allow_read(self, *resources: IApiResource) -> None:
        '''Add "get", "list", and "watch" permissions for the resources.

        :param resources: The resource(s) to apply to.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__142b19b5dc40810d1cb3bdfc4eed997cf4bcdc281b9e0d88030d1ebe85bc2c38)
            check_type(argname="argument resources", value=resources, expected_type=typing.Tuple[type_hints["resources"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast(None, jsii.invoke(self, "allowRead", [*resources]))

    @jsii.member(jsii_name="allowReadWrite")
    def allow_read_write(self, *resources: IApiResource) -> None:
        '''Add "get", "list", "watch", "create", "update", "patch", "delete", and "deletecollection" permissions for the resources.

        :param resources: The resource(s) to apply to.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0e23c82e7f5d7ee4081e271b17ded2f79126af339ac82e4addcc3a34aac62a2f)
            check_type(argname="argument resources", value=resources, expected_type=typing.Tuple[type_hints["resources"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast(None, jsii.invoke(self, "allowReadWrite", [*resources]))

    @jsii.member(jsii_name="allowUpdate")
    def allow_update(self, *resources: IApiResource) -> None:
        '''Add "update" permission for the resources.

        :param resources: The resource(s) to apply to.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__efe57470f4e3996bf9a61da9f563e4fa20a425d85c7ed32400ccc150cae75a5c)
            check_type(argname="argument resources", value=resources, expected_type=typing.Tuple[type_hints["resources"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast(None, jsii.invoke(self, "allowUpdate", [*resources]))

    @jsii.member(jsii_name="allowWatch")
    def allow_watch(self, *resources: IApiResource) -> None:
        '''Add "watch" permission for the resources.

        :param resources: The resource(s) to apply to.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__52f125122b161d5d99bc5422eb786f17cd352b1b8d347d35a517b9ba9cbc762b)
            check_type(argname="argument resources", value=resources, expected_type=typing.Tuple[type_hints["resources"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast(None, jsii.invoke(self, "allowWatch", [*resources]))

    @jsii.member(jsii_name="bind")
    def bind(self, *subjects: ISubject) -> "RoleBinding":
        '''Create a RoleBinding that binds the permissions in this Role to a list of subjects, that will only apply this role's namespace.

        :param subjects: a list of subjects to bind to.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f9aaa8efd0d9d5752dbfda059b4ab4123c81618409d4d13a8c8e49d5493cffd6)
            check_type(argname="argument subjects", value=subjects, expected_type=typing.Tuple[type_hints["subjects"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast("RoleBinding", jsii.invoke(self, "bind", [*subjects]))

    @builtins.property
    @jsii.member(jsii_name="apiObject")
    def _api_object(self) -> _cdk8s_d3d9af27.ApiObject:
        '''The underlying cdk8s API object.

        :see: base.Resource.apiObject
        '''
        return typing.cast(_cdk8s_d3d9af27.ApiObject, jsii.get(self, "apiObject"))

    @builtins.property
    @jsii.member(jsii_name="resourceType")
    def resource_type(self) -> builtins.str:
        '''The name of a resource type as it appears in the relevant API endpoint.'''
        return typing.cast(builtins.str, jsii.get(self, "resourceType"))

    @builtins.property
    @jsii.member(jsii_name="rules")
    def rules(self) -> typing.List["RolePolicyRule"]:
        '''Rules associaated with this Role.

        Returns a copy, use ``allow`` to add rules.
        '''
        return typing.cast(typing.List["RolePolicyRule"], jsii.get(self, "rules"))


class RoleBinding(
    Resource,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-24.RoleBinding",
):
    '''A RoleBinding grants permissions within a specific namespace to a user or set of users.'''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        role: IRole,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param role: The role to bind to. A RoleBinding can reference a Role or a ClusterRole.
        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__235e4976bf05e8f4f65859f3f9b980ffa4067411f3bb8507a9db35759fe503a8)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = RoleBindingProps(role=role, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="addSubjects")
    def add_subjects(self, *subjects: ISubject) -> None:
        '''Adds a subject to the role.

        :param subjects: The subjects to add.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__112ecbff81ad52e459a5716dd316e19f495179cf4b66d64b403f7f23ea6c73e1)
            check_type(argname="argument subjects", value=subjects, expected_type=typing.Tuple[type_hints["subjects"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast(None, jsii.invoke(self, "addSubjects", [*subjects]))

    @builtins.property
    @jsii.member(jsii_name="apiObject")
    def _api_object(self) -> _cdk8s_d3d9af27.ApiObject:
        '''The underlying cdk8s API object.

        :see: base.Resource.apiObject
        '''
        return typing.cast(_cdk8s_d3d9af27.ApiObject, jsii.get(self, "apiObject"))

    @builtins.property
    @jsii.member(jsii_name="resourceType")
    def resource_type(self) -> builtins.str:
        '''The name of a resource type as it appears in the relevant API endpoint.'''
        return typing.cast(builtins.str, jsii.get(self, "resourceType"))

    @builtins.property
    @jsii.member(jsii_name="role")
    def role(self) -> IRole:
        return typing.cast(IRole, jsii.get(self, "role"))

    @builtins.property
    @jsii.member(jsii_name="subjects")
    def subjects(self) -> typing.List[ISubject]:
        return typing.cast(typing.List[ISubject], jsii.get(self, "subjects"))


@jsii.data_type(
    jsii_type="cdk8s-plus-24.RoleBindingProps",
    jsii_struct_bases=[ResourceProps],
    name_mapping={"metadata": "metadata", "role": "role"},
)
class RoleBindingProps(ResourceProps):
    def __init__(
        self,
        *,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        role: IRole,
    ) -> None:
        '''Properties for ``RoleBinding``.

        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        :param role: The role to bind to. A RoleBinding can reference a Role or a ClusterRole.
        '''
        if isinstance(metadata, dict):
            metadata = _cdk8s_d3d9af27.ApiObjectMetadata(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__51867ca42ba9983b9dddb605bbc9117ae46e178844470a9ce03962797e520e66)
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument role", value=role, expected_type=type_hints["role"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "role": role,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def metadata(self) -> typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata]:
        '''Metadata that all persisted resources must have, which includes all objects users must create.'''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata], result)

    @builtins.property
    def role(self) -> IRole:
        '''The role to bind to.

        A RoleBinding can reference a Role or a ClusterRole.
        '''
        result = self._values.get("role")
        assert result is not None, "Required property 'role' is missing"
        return typing.cast(IRole, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "RoleBindingProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.RolePolicyRule",
    jsii_struct_bases=[],
    name_mapping={"resources": "resources", "verbs": "verbs"},
)
class RolePolicyRule:
    def __init__(
        self,
        *,
        resources: typing.Sequence[IApiResource],
        verbs: typing.Sequence[builtins.str],
    ) -> None:
        '''Policy rule of a `Role.

        :param resources: Resources this rule applies to.
        :param verbs: Verbs to allow. (e.g ['get', 'watch'])
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__371dbfc26dab2e2366ee37085ed3a18a504b8dade50b6678622151b88e5746b5)
            check_type(argname="argument resources", value=resources, expected_type=type_hints["resources"])
            check_type(argname="argument verbs", value=verbs, expected_type=type_hints["verbs"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "resources": resources,
            "verbs": verbs,
        }

    @builtins.property
    def resources(self) -> typing.List[IApiResource]:
        '''Resources this rule applies to.'''
        result = self._values.get("resources")
        assert result is not None, "Required property 'resources' is missing"
        return typing.cast(typing.List[IApiResource], result)

    @builtins.property
    def verbs(self) -> typing.List[builtins.str]:
        '''Verbs to allow.

        (e.g ['get', 'watch'])
        '''
        result = self._values.get("verbs")
        assert result is not None, "Required property 'verbs' is missing"
        return typing.cast(typing.List[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "RolePolicyRule(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.RoleProps",
    jsii_struct_bases=[ResourceProps],
    name_mapping={"metadata": "metadata", "rules": "rules"},
)
class RoleProps(ResourceProps):
    def __init__(
        self,
        *,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        rules: typing.Optional[typing.Sequence[typing.Union[RolePolicyRule, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Properties for ``Role``.

        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        :param rules: A list of rules the role should allow. Default: []
        '''
        if isinstance(metadata, dict):
            metadata = _cdk8s_d3d9af27.ApiObjectMetadata(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__228e9ff0731eebc72f1d3ce1294f15de096ee0460dc552e388990b61a38f1318)
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument rules", value=rules, expected_type=type_hints["rules"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if metadata is not None:
            self._values["metadata"] = metadata
        if rules is not None:
            self._values["rules"] = rules

    @builtins.property
    def metadata(self) -> typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata]:
        '''Metadata that all persisted resources must have, which includes all objects users must create.'''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata], result)

    @builtins.property
    def rules(self) -> typing.Optional[typing.List[RolePolicyRule]]:
        '''A list of rules the role should allow.

        :default: []
        '''
        result = self._values.get("rules")
        return typing.cast(typing.Optional[typing.List[RolePolicyRule]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "RoleProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.ScalingPolicy",
    jsii_struct_bases=[],
    name_mapping={"replicas": "replicas", "duration": "duration"},
)
class ScalingPolicy:
    def __init__(
        self,
        *,
        replicas: Replicas,
        duration: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
    ) -> None:
        '''
        :param replicas: The type and quantity of replicas to change.
        :param duration: The amount of time the scaling policy has to continue scaling before the target metric must be revalidated. Must be greater than 0 seconds and no longer than 30 minutes. Default: - 15 seconds
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__fee22757394a49164cb41486a88ddedae5cafccf0748d1dcb770112d07a4a299)
            check_type(argname="argument replicas", value=replicas, expected_type=type_hints["replicas"])
            check_type(argname="argument duration", value=duration, expected_type=type_hints["duration"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "replicas": replicas,
        }
        if duration is not None:
            self._values["duration"] = duration

    @builtins.property
    def replicas(self) -> Replicas:
        '''The type and quantity of replicas to change.'''
        result = self._values.get("replicas")
        assert result is not None, "Required property 'replicas' is missing"
        return typing.cast(Replicas, result)

    @builtins.property
    def duration(self) -> typing.Optional[_cdk8s_d3d9af27.Duration]:
        '''The amount of time the scaling policy has to continue scaling before the target metric must be revalidated.

        Must be greater than 0 seconds and no longer than 30 minutes.

        :default: - 15 seconds
        '''
        result = self._values.get("duration")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Duration], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ScalingPolicy(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.ScalingRules",
    jsii_struct_bases=[],
    name_mapping={
        "policies": "policies",
        "stabilization_window": "stabilizationWindow",
        "strategy": "strategy",
    },
)
class ScalingRules:
    def __init__(
        self,
        *,
        policies: typing.Optional[typing.Sequence[typing.Union[ScalingPolicy, typing.Dict[builtins.str, typing.Any]]]] = None,
        stabilization_window: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        strategy: typing.Optional["ScalingStrategy"] = None,
    ) -> None:
        '''Defines the scaling behavior for one direction.

        :param policies: The scaling policies. Default: - Scale up - Increase no more than 4 pods per 60 seconds - Double the number of pods per 60 seconds - Scale down - Decrease to minReplica count
        :param stabilization_window: Defines the window of past metrics that the autoscaler should consider when calculating wether or not autoscaling should occur. Minimum duration is 1 second, max is 1 hour. Default: - On scale down no stabilization is performed. - On scale up stabilization is performed for 5 minutes.
        :param strategy: The strategy to use when scaling. Default: MAX_CHANGE
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__363753648b5afc79599523927e651b96f3734c4b02e45b5b944c8c3a01adb798)
            check_type(argname="argument policies", value=policies, expected_type=type_hints["policies"])
            check_type(argname="argument stabilization_window", value=stabilization_window, expected_type=type_hints["stabilization_window"])
            check_type(argname="argument strategy", value=strategy, expected_type=type_hints["strategy"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if policies is not None:
            self._values["policies"] = policies
        if stabilization_window is not None:
            self._values["stabilization_window"] = stabilization_window
        if strategy is not None:
            self._values["strategy"] = strategy

    @builtins.property
    def policies(self) -> typing.Optional[typing.List[ScalingPolicy]]:
        '''The scaling policies.

        :default:

        - Scale up

        - Increase no more than 4 pods per 60 seconds
        - Double the number of pods per 60 seconds

        - Scale down

        - Decrease to minReplica count
        '''
        result = self._values.get("policies")
        return typing.cast(typing.Optional[typing.List[ScalingPolicy]], result)

    @builtins.property
    def stabilization_window(self) -> typing.Optional[_cdk8s_d3d9af27.Duration]:
        '''Defines the window of past metrics that the autoscaler should consider when calculating wether or not autoscaling should occur.

        Minimum duration is 1 second, max is 1 hour.

        :default:

        - On scale down no stabilization is performed.
        - On scale up stabilization is performed for 5 minutes.

        Example::

            stabilizationWindow: Duration.minutes(30)
            // Autoscaler considers the last 30 minutes of metrics when deciding whether to scale.
        '''
        result = self._values.get("stabilization_window")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Duration], result)

    @builtins.property
    def strategy(self) -> typing.Optional["ScalingStrategy"]:
        '''The strategy to use when scaling.

        :default: MAX_CHANGE
        '''
        result = self._values.get("strategy")
        return typing.cast(typing.Optional["ScalingStrategy"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ScalingRules(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.enum(jsii_type="cdk8s-plus-24.ScalingStrategy")
class ScalingStrategy(enum.Enum):
    MAX_CHANGE = "MAX_CHANGE"
    '''Use the policy that provisions the most changes.'''
    MIN_CHANGE = "MIN_CHANGE"
    '''Use the policy that provisions the least amount of changes.'''
    DISABLED = "DISABLED"
    '''(deprecated) Disables scaling in this direction.

    :deprecated: - Omit the ScalingRule instead

    :stability: deprecated
    '''


@jsii.data_type(
    jsii_type="cdk8s-plus-24.ScalingTarget",
    jsii_struct_bases=[],
    name_mapping={
        "api_version": "apiVersion",
        "containers": "containers",
        "kind": "kind",
        "name": "name",
        "replicas": "replicas",
    },
)
class ScalingTarget:
    def __init__(
        self,
        *,
        api_version: builtins.str,
        containers: typing.Sequence[Container],
        kind: builtins.str,
        name: builtins.str,
        replicas: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''Properties used to configure the target of an Autoscaler.

        :param api_version: The object's API version (e.g. "authorization.k8s.io/v1").
        :param containers: Container definitions associated with the target.
        :param kind: The object kind (e.g. "Deployment").
        :param name: The Kubernetes name of this resource.
        :param replicas: The fixed number of replicas defined on the target. This is used for validation purposes as Scalable targets should not have a fixed number of replicas.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b588ce3cfff93e696b93dc5461597a39e7ba1f33f9296deb5d8ac33b4664ea3d)
            check_type(argname="argument api_version", value=api_version, expected_type=type_hints["api_version"])
            check_type(argname="argument containers", value=containers, expected_type=type_hints["containers"])
            check_type(argname="argument kind", value=kind, expected_type=type_hints["kind"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument replicas", value=replicas, expected_type=type_hints["replicas"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "api_version": api_version,
            "containers": containers,
            "kind": kind,
            "name": name,
        }
        if replicas is not None:
            self._values["replicas"] = replicas

    @builtins.property
    def api_version(self) -> builtins.str:
        '''The object's API version (e.g. "authorization.k8s.io/v1").'''
        result = self._values.get("api_version")
        assert result is not None, "Required property 'api_version' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def containers(self) -> typing.List[Container]:
        '''Container definitions associated with the target.'''
        result = self._values.get("containers")
        assert result is not None, "Required property 'containers' is missing"
        return typing.cast(typing.List[Container], result)

    @builtins.property
    def kind(self) -> builtins.str:
        '''The object kind (e.g. "Deployment").'''
        result = self._values.get("kind")
        assert result is not None, "Required property 'kind' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def name(self) -> builtins.str:
        '''The Kubernetes name of this resource.'''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def replicas(self) -> typing.Optional[jsii.Number]:
        '''The fixed number of replicas defined on the target.

        This is used
        for validation purposes as Scalable targets should not have a
        fixed number of replicas.
        '''
        result = self._values.get("replicas")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ScalingTarget(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(ISecret)
class Secret(Resource, metaclass=jsii.JSIIMeta, jsii_type="cdk8s-plus-24.Secret"):
    '''Kubernetes Secrets let you store and manage sensitive information, such as passwords, OAuth tokens, and ssh keys.

    Storing confidential information in a
    Secret is safer and more flexible than putting it verbatim in a Pod
    definition or in a container image.

    :see: https://kubernetes.io/docs/concepts/configuration/secret
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        string_data: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        type: typing.Optional[builtins.str] = None,
        immutable: typing.Optional[builtins.bool] = None,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param string_data: stringData allows specifying non-binary secret data in string form. It is provided as a write-only convenience method. All keys and values are merged into the data field on write, overwriting any existing values. It is never output when reading from the API.
        :param type: Optional type associated with the secret. Used to facilitate programmatic handling of secret data by various controllers. Default: undefined - Don't set a type.
        :param immutable: If set to true, ensures that data stored in the Secret cannot be updated (only object metadata can be modified). If not set to true, the field can be modified at any time. Default: false
        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__00d48a9e423cd7e266ba4389f686a54b62ca457a2d2028aa477471a79a17af2e)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = SecretProps(
            string_data=string_data, type=type, immutable=immutable, metadata=metadata
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="fromSecretName")
    @builtins.classmethod
    def from_secret_name(
        cls,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        name: builtins.str,
    ) -> ISecret:
        '''Imports a secret from the cluster as a reference.

        :param scope: -
        :param id: -
        :param name: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1302af7da2d6d1ee6d7d823d6e2f18cf32d419fbe0fdd8cc84841906a11843a1)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
        return typing.cast(ISecret, jsii.sinvoke(cls, "fromSecretName", [scope, id, name]))

    @jsii.member(jsii_name="addStringData")
    def add_string_data(self, key: builtins.str, value: builtins.str) -> None:
        '''Adds a string data field to the secert.

        :param key: Key.
        :param value: Value.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ae9d38ac2fd74e82f5324c65b4347bf250bf43a616ebc3b25968658ea25e20de)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(None, jsii.invoke(self, "addStringData", [key, value]))

    @jsii.member(jsii_name="envValue")
    def env_value(
        self,
        key: builtins.str,
        *,
        optional: typing.Optional[builtins.bool] = None,
    ) -> EnvValue:
        '''Returns EnvValue object from a secret's key.

        :param key: -
        :param optional: Specify whether the Secret or its key must be defined. Default: false
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0f5c785be6e140331e129d37e17a30788c148a6a5d0546f5270228bbe9ea8d53)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
        options = EnvValueFromSecretOptions(optional=optional)

        return typing.cast(EnvValue, jsii.invoke(self, "envValue", [key, options]))

    @jsii.member(jsii_name="getStringData")
    def get_string_data(self, key: builtins.str) -> typing.Optional[builtins.str]:
        '''Gets a string data by key or undefined.

        :param key: Key.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__33ebb026596076abc88c98bd319bbcff3fdcc92493dabe8e14240d4e88571b35)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
        return typing.cast(typing.Optional[builtins.str], jsii.invoke(self, "getStringData", [key]))

    @builtins.property
    @jsii.member(jsii_name="apiObject")
    def _api_object(self) -> _cdk8s_d3d9af27.ApiObject:
        '''The underlying cdk8s API object.

        :see: base.Resource.apiObject
        '''
        return typing.cast(_cdk8s_d3d9af27.ApiObject, jsii.get(self, "apiObject"))

    @builtins.property
    @jsii.member(jsii_name="immutable")
    def immutable(self) -> builtins.bool:
        '''Whether or not the secret is immutable.'''
        return typing.cast(builtins.bool, jsii.get(self, "immutable"))

    @builtins.property
    @jsii.member(jsii_name="resourceType")
    def resource_type(self) -> builtins.str:
        '''The name of a resource type as it appears in the relevant API endpoint.'''
        return typing.cast(builtins.str, jsii.get(self, "resourceType"))


@jsii.data_type(
    jsii_type="cdk8s-plus-24.SecretValue",
    jsii_struct_bases=[],
    name_mapping={"key": "key", "secret": "secret"},
)
class SecretValue:
    def __init__(self, *, key: builtins.str, secret: ISecret) -> None:
        '''Represents a specific value in JSON secret.

        :param key: The JSON key.
        :param secret: The secret.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c8e92ae3ca9e418a7a968b19fd042e34f8b98384db899982ce683d3cbfc4cdf3)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument secret", value=secret, expected_type=type_hints["secret"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "key": key,
            "secret": secret,
        }

    @builtins.property
    def key(self) -> builtins.str:
        '''The JSON key.'''
        result = self._values.get("key")
        assert result is not None, "Required property 'key' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def secret(self) -> ISecret:
        '''The secret.'''
        result = self._values.get("secret")
        assert result is not None, "Required property 'secret' is missing"
        return typing.cast(ISecret, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "SecretValue(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.SecretVolumeOptions",
    jsii_struct_bases=[],
    name_mapping={
        "default_mode": "defaultMode",
        "items": "items",
        "name": "name",
        "optional": "optional",
    },
)
class SecretVolumeOptions:
    def __init__(
        self,
        *,
        default_mode: typing.Optional[jsii.Number] = None,
        items: typing.Optional[typing.Mapping[builtins.str, typing.Union[PathMapping, typing.Dict[builtins.str, typing.Any]]]] = None,
        name: typing.Optional[builtins.str] = None,
        optional: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''Options for the Secret-based volume.

        :param default_mode: Mode bits to use on created files by default. Must be a value between 0 and 0777. Defaults to 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set. Default: 644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
        :param items: If unspecified, each key-value pair in the Data field of the referenced secret will be projected into the volume as a file whose name is the key and content is the value. If specified, the listed keys will be projected into the specified paths, and unlisted keys will not be present. If a key is specified which is not present in the secret, the volume setup will error unless it is marked optional. Paths must be relative and may not contain the '..' path or start with '..'. Default: - no mapping
        :param name: The volume name. Default: - auto-generated
        :param optional: Specify whether the secret or its keys must be defined. Default: - undocumented
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__acdd67900e3e4c6c13312d1a6f7e62908f335c4b28f3fc1cc735add8b070799c)
            check_type(argname="argument default_mode", value=default_mode, expected_type=type_hints["default_mode"])
            check_type(argname="argument items", value=items, expected_type=type_hints["items"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument optional", value=optional, expected_type=type_hints["optional"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if default_mode is not None:
            self._values["default_mode"] = default_mode
        if items is not None:
            self._values["items"] = items
        if name is not None:
            self._values["name"] = name
        if optional is not None:
            self._values["optional"] = optional

    @builtins.property
    def default_mode(self) -> typing.Optional[jsii.Number]:
        '''Mode bits to use on created files by default.

        Must be a value between 0 and
        0777. Defaults to 0644. Directories within the path are not affected by
        this setting. This might be in conflict with other options that affect the
        file mode, like fsGroup, and the result can be other mode bits set.

        :default:

        644. Directories within the path are not affected by this
        setting. This might be in conflict with other options that affect the file
        mode, like fsGroup, and the result can be other mode bits set.
        '''
        result = self._values.get("default_mode")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def items(self) -> typing.Optional[typing.Mapping[builtins.str, PathMapping]]:
        '''If unspecified, each key-value pair in the Data field of the referenced secret will be projected into the volume as a file whose name is the key and content is the value.

        If specified, the listed keys will be projected
        into the specified paths, and unlisted keys will not be present. If a key
        is specified which is not present in the secret, the volume setup will
        error unless it is marked optional. Paths must be relative and may not
        contain the '..' path or start with '..'.

        :default: - no mapping
        '''
        result = self._values.get("items")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, PathMapping]], result)

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''The volume name.

        :default: - auto-generated
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def optional(self) -> typing.Optional[builtins.bool]:
        '''Specify whether the secret or its keys must be defined.

        :default: - undocumented
        '''
        result = self._values.get("optional")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "SecretVolumeOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class Service(Resource, metaclass=jsii.JSIIMeta, jsii_type="cdk8s-plus-24.Service"):
    '''An abstract way to expose an application running on a set of Pods as a network service.

    With Kubernetes you don't need to modify your application to use an unfamiliar service discovery mechanism.
    Kubernetes gives Pods their own IP addresses and a single DNS name for a set of Pods, and can load-balance across them.

    For example, consider a stateless image-processing backend which is running with 3 replicas. Those replicas are fungible—frontends do not care which backend they use.
    While the actual Pods that compose the backend set may change, the frontend clients should not need to be aware of that,
    nor should they need to keep track of the set of backends themselves.
    The Service abstraction enables this decoupling.

    If you're able to use Kubernetes APIs for service discovery in your application, you can query the API server for Endpoints,
    that get updated whenever the set of Pods in a Service changes. For non-native applications, Kubernetes offers ways to place a network port
    or load balancer in between your application and the backend Pods.
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        cluster_ip: typing.Optional[builtins.str] = None,
        external_i_ps: typing.Optional[typing.Sequence[builtins.str]] = None,
        external_name: typing.Optional[builtins.str] = None,
        load_balancer_source_ranges: typing.Optional[typing.Sequence[builtins.str]] = None,
        ports: typing.Optional[typing.Sequence[typing.Union["ServicePort", typing.Dict[builtins.str, typing.Any]]]] = None,
        selector: typing.Optional[IPodSelector] = None,
        type: typing.Optional["ServiceType"] = None,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param cluster_ip: The IP address of the service and is usually assigned randomly by the master. If an address is specified manually and is not in use by others, it will be allocated to the service; otherwise, creation of the service will fail. This field can not be changed through updates. Valid values are "None", empty string (""), or a valid IP address. "None" can be specified for headless services when proxying is not required. Only applies to types ClusterIP, NodePort, and LoadBalancer. Ignored if type is ExternalName. Default: - Automatically assigned.
        :param external_i_ps: A list of IP addresses for which nodes in the cluster will also accept traffic for this service. These IPs are not managed by Kubernetes. The user is responsible for ensuring that traffic arrives at a node with this IP. A common example is external load-balancers that are not part of the Kubernetes system. Default: - No external IPs.
        :param external_name: The externalName to be used when ServiceType.EXTERNAL_NAME is set. Default: - No external name.
        :param load_balancer_source_ranges: A list of CIDR IP addresses, if specified and supported by the platform, will restrict traffic through the cloud-provider load-balancer to the specified client IPs. More info: https://kubernetes.io/docs/tasks/access-application-cluster/configure-cloud-provider-firewall/
        :param ports: The ports this service binds to. If the selector of the service is a managed pod / workload, its ports will are automatically extracted and used as the default value. Otherwise, no ports are bound. Default: - either the selector ports, or none.
        :param selector: Which pods should the service select and route to. You can pass one of the following: - An instance of ``Pod`` or any workload resource (e.g ``Deployment``, ``StatefulSet``, ...) - Pods selected by the ``Pods.select`` function. Note that in this case only labels can be specified. Default: - unset, the service is assumed to have an external process managing its endpoints, which Kubernetes will not modify.
        :param type: Determines how the Service is exposed. More info: https://kubernetes.io/docs/concepts/services-networking/service/#publishing-services-service-types Default: ServiceType.ClusterIP
        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__759becccf01c9e846ee67b171317507d8c2d285c2a9b10e5807440e5ec883649)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = ServiceProps(
            cluster_ip=cluster_ip,
            external_i_ps=external_i_ps,
            external_name=external_name,
            load_balancer_source_ranges=load_balancer_source_ranges,
            ports=ports,
            selector=selector,
            type=type,
            metadata=metadata,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="bind")
    def bind(
        self,
        port: jsii.Number,
        *,
        name: typing.Optional[builtins.str] = None,
        node_port: typing.Optional[jsii.Number] = None,
        protocol: typing.Optional[Protocol] = None,
        target_port: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''Configure a port the service will bind to.

        This method can be called multiple times.

        :param port: The port definition.
        :param name: The name of this port within the service. This must be a DNS_LABEL. All ports within a ServiceSpec must have unique names. This maps to the 'Name' field in EndpointPort objects. Optional if only one ServicePort is defined on this service.
        :param node_port: The port on each node on which this service is exposed when type=NodePort or LoadBalancer. Usually assigned by the system. If specified, it will be allocated to the service if unused or else creation of the service will fail. Default is to auto-allocate a port if the ServiceType of this Service requires one. Default: - auto-allocate a port if the ServiceType of this Service requires one.
        :param protocol: The IP protocol for this port. Supports "TCP", "UDP", and "SCTP". Default is TCP. Default: Protocol.TCP
        :param target_port: The port number the service will redirect to. Default: - The value of ``port`` will be used.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d2a78729e1cf97537166c2fdf569d4742da647e8a5f7cb175c05e68651c34472)
            check_type(argname="argument port", value=port, expected_type=type_hints["port"])
        options = ServiceBindOptions(
            name=name, node_port=node_port, protocol=protocol, target_port=target_port
        )

        return typing.cast(None, jsii.invoke(self, "bind", [port, options]))

    @jsii.member(jsii_name="exposeViaIngress")
    def expose_via_ingress(
        self,
        path: builtins.str,
        *,
        ingress: typing.Optional["Ingress"] = None,
        path_type: typing.Optional[HttpIngressPathType] = None,
    ) -> "Ingress":
        '''Expose a service via an ingress using the specified path.

        :param path: The path to expose the service under.
        :param ingress: The ingress to add rules to. Default: - An ingress will be automatically created.
        :param path_type: The type of the path. Default: HttpIngressPathType.PREFIX

        :return: The ``Ingress`` resource that was used.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__fdf66d30ddd4b166bdebcac9e15b960ff78f578d5ebc0c18b49479775873878f)
            check_type(argname="argument path", value=path, expected_type=type_hints["path"])
        options = ExposeServiceViaIngressOptions(ingress=ingress, path_type=path_type)

        return typing.cast("Ingress", jsii.invoke(self, "exposeViaIngress", [path, options]))

    @jsii.member(jsii_name="select")
    def select(self, selector: IPodSelector) -> None:
        '''Require this service to select pods matching the selector.

        Note that invoking this method multiple times acts as an AND operator
        on the resulting labels.

        :param selector: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__79240f7be5c13148ff2fce0f2ad189d5f63218c9cae318179bd77d7f1d68f9a2)
            check_type(argname="argument selector", value=selector, expected_type=type_hints["selector"])
        return typing.cast(None, jsii.invoke(self, "select", [selector]))

    @jsii.member(jsii_name="selectLabel")
    def select_label(self, key: builtins.str, value: builtins.str) -> None:
        '''Require this service to select pods with this label.

        Note that invoking this method multiple times acts as an AND operator
        on the resulting labels.

        :param key: -
        :param value: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__45f77e9e178957b803bb61e8cf1a8517e32e9dd8c05d96a5b1ed67ec767b188a)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(None, jsii.invoke(self, "selectLabel", [key, value]))

    @builtins.property
    @jsii.member(jsii_name="apiObject")
    def _api_object(self) -> _cdk8s_d3d9af27.ApiObject:
        '''The underlying cdk8s API object.

        :see: base.Resource.apiObject
        '''
        return typing.cast(_cdk8s_d3d9af27.ApiObject, jsii.get(self, "apiObject"))

    @builtins.property
    @jsii.member(jsii_name="port")
    def port(self) -> jsii.Number:
        '''Return the first port of the service.'''
        return typing.cast(jsii.Number, jsii.get(self, "port"))

    @builtins.property
    @jsii.member(jsii_name="ports")
    def ports(self) -> typing.List["ServicePort"]:
        '''Ports for this service.

        Use ``bind()`` to bind additional service ports.
        '''
        return typing.cast(typing.List["ServicePort"], jsii.get(self, "ports"))

    @builtins.property
    @jsii.member(jsii_name="resourceType")
    def resource_type(self) -> builtins.str:
        '''The name of a resource type as it appears in the relevant API endpoint.'''
        return typing.cast(builtins.str, jsii.get(self, "resourceType"))

    @builtins.property
    @jsii.member(jsii_name="type")
    def type(self) -> "ServiceType":
        '''Determines how the Service is exposed.'''
        return typing.cast("ServiceType", jsii.get(self, "type"))

    @builtins.property
    @jsii.member(jsii_name="clusterIP")
    def cluster_ip(self) -> typing.Optional[builtins.str]:
        '''The IP address of the service and is usually assigned randomly by the master.'''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "clusterIP"))

    @builtins.property
    @jsii.member(jsii_name="externalName")
    def external_name(self) -> typing.Optional[builtins.str]:
        '''The externalName to be used for EXTERNAL_NAME types.'''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "externalName"))


@jsii.data_type(
    jsii_type="cdk8s-plus-24.ServiceAccountProps",
    jsii_struct_bases=[ResourceProps],
    name_mapping={
        "metadata": "metadata",
        "automount_token": "automountToken",
        "secrets": "secrets",
    },
)
class ServiceAccountProps(ResourceProps):
    def __init__(
        self,
        *,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        automount_token: typing.Optional[builtins.bool] = None,
        secrets: typing.Optional[typing.Sequence[ISecret]] = None,
    ) -> None:
        '''Properties for initialization of ``ServiceAccount``.

        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        :param automount_token: Indicates whether pods running as this service account should have an API token automatically mounted. Can be overridden at the pod level. Default: false
        :param secrets: List of secrets allowed to be used by pods running using this ServiceAccount.
        '''
        if isinstance(metadata, dict):
            metadata = _cdk8s_d3d9af27.ApiObjectMetadata(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4ad911316de935fe1d00241194f760e07b13379726753fc7d1911da01ebf7907)
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument automount_token", value=automount_token, expected_type=type_hints["automount_token"])
            check_type(argname="argument secrets", value=secrets, expected_type=type_hints["secrets"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if metadata is not None:
            self._values["metadata"] = metadata
        if automount_token is not None:
            self._values["automount_token"] = automount_token
        if secrets is not None:
            self._values["secrets"] = secrets

    @builtins.property
    def metadata(self) -> typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata]:
        '''Metadata that all persisted resources must have, which includes all objects users must create.'''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata], result)

    @builtins.property
    def automount_token(self) -> typing.Optional[builtins.bool]:
        '''Indicates whether pods running as this service account should have an API token automatically mounted.

        Can be overridden at the pod level.

        :default: false

        :see: https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/#use-the-default-service-account-to-access-the-api-server
        '''
        result = self._values.get("automount_token")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def secrets(self) -> typing.Optional[typing.List[ISecret]]:
        '''List of secrets allowed to be used by pods running using this ServiceAccount.

        :see: https://kubernetes.io/docs/concepts/configuration/secret
        '''
        result = self._values.get("secrets")
        return typing.cast(typing.Optional[typing.List[ISecret]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ServiceAccountProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ServiceAccountTokenSecret(
    Secret,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-24.ServiceAccountTokenSecret",
):
    '''Create a secret for a service account token.

    :see: https://kubernetes.io/docs/concepts/configuration/secret/#service-account-token-secrets
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        service_account: "IServiceAccount",
        immutable: typing.Optional[builtins.bool] = None,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param service_account: The service account to store a secret for.
        :param immutable: If set to true, ensures that data stored in the Secret cannot be updated (only object metadata can be modified). If not set to true, the field can be modified at any time. Default: false
        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__46e346636b0928220e2bf5fad92ffe5b098d71328fb91cbff58c7bb4a9a4969a)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = ServiceAccountTokenSecretProps(
            service_account=service_account, immutable=immutable, metadata=metadata
        )

        jsii.create(self.__class__, self, [scope, id, props])


@jsii.data_type(
    jsii_type="cdk8s-plus-24.ServiceBindOptions",
    jsii_struct_bases=[],
    name_mapping={
        "name": "name",
        "node_port": "nodePort",
        "protocol": "protocol",
        "target_port": "targetPort",
    },
)
class ServiceBindOptions:
    def __init__(
        self,
        *,
        name: typing.Optional[builtins.str] = None,
        node_port: typing.Optional[jsii.Number] = None,
        protocol: typing.Optional[Protocol] = None,
        target_port: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''Options for ``Service.bind``.

        :param name: The name of this port within the service. This must be a DNS_LABEL. All ports within a ServiceSpec must have unique names. This maps to the 'Name' field in EndpointPort objects. Optional if only one ServicePort is defined on this service.
        :param node_port: The port on each node on which this service is exposed when type=NodePort or LoadBalancer. Usually assigned by the system. If specified, it will be allocated to the service if unused or else creation of the service will fail. Default is to auto-allocate a port if the ServiceType of this Service requires one. Default: - auto-allocate a port if the ServiceType of this Service requires one.
        :param protocol: The IP protocol for this port. Supports "TCP", "UDP", and "SCTP". Default is TCP. Default: Protocol.TCP
        :param target_port: The port number the service will redirect to. Default: - The value of ``port`` will be used.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f032000130ee79f9894994bda15dd84e5e34c119ad134890650cc23d6b897add)
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument node_port", value=node_port, expected_type=type_hints["node_port"])
            check_type(argname="argument protocol", value=protocol, expected_type=type_hints["protocol"])
            check_type(argname="argument target_port", value=target_port, expected_type=type_hints["target_port"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if name is not None:
            self._values["name"] = name
        if node_port is not None:
            self._values["node_port"] = node_port
        if protocol is not None:
            self._values["protocol"] = protocol
        if target_port is not None:
            self._values["target_port"] = target_port

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''The name of this port within the service.

        This must be a DNS_LABEL. All
        ports within a ServiceSpec must have unique names. This maps to the 'Name'
        field in EndpointPort objects. Optional if only one ServicePort is defined
        on this service.
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def node_port(self) -> typing.Optional[jsii.Number]:
        '''The port on each node on which this service is exposed when type=NodePort or LoadBalancer.

        Usually assigned by the system. If specified, it will be
        allocated to the service if unused or else creation of the service will
        fail. Default is to auto-allocate a port if the ServiceType of this Service
        requires one.

        :default: - auto-allocate a port if the ServiceType of this Service requires one.

        :see: https://kubernetes.io/docs/concepts/services-networking/service/#type-nodeport
        '''
        result = self._values.get("node_port")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def protocol(self) -> typing.Optional[Protocol]:
        '''The IP protocol for this port.

        Supports "TCP", "UDP", and "SCTP". Default is TCP.

        :default: Protocol.TCP
        '''
        result = self._values.get("protocol")
        return typing.cast(typing.Optional[Protocol], result)

    @builtins.property
    def target_port(self) -> typing.Optional[jsii.Number]:
        '''The port number the service will redirect to.

        :default: - The value of ``port`` will be used.
        '''
        result = self._values.get("target_port")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ServiceBindOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.ServiceIngressBackendOptions",
    jsii_struct_bases=[],
    name_mapping={"port": "port"},
)
class ServiceIngressBackendOptions:
    def __init__(self, *, port: typing.Optional[jsii.Number] = None) -> None:
        '''Options for setting up backends for ingress rules.

        :param port: The port to use to access the service. - This option will fail if the service does not expose any ports. - If the service exposes multiple ports, this option must be specified. - If the service exposes a single port, this option is optional and if specified, it must be the same port exposed by the service. Default: - if the service exposes a single port, this port will be used.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9e4b61477f36068b629f9406a5d5b3efd492f5bd4df7a1288e6cf7e299db44e4)
            check_type(argname="argument port", value=port, expected_type=type_hints["port"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if port is not None:
            self._values["port"] = port

    @builtins.property
    def port(self) -> typing.Optional[jsii.Number]:
        '''The port to use to access the service.

        - This option will fail if the service does not expose any ports.
        - If the service exposes multiple ports, this option must be specified.
        - If the service exposes a single port, this option is optional and if
          specified, it must be the same port exposed by the service.

        :default: - if the service exposes a single port, this port will be used.
        '''
        result = self._values.get("port")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ServiceIngressBackendOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.ServicePort",
    jsii_struct_bases=[ServiceBindOptions],
    name_mapping={
        "name": "name",
        "node_port": "nodePort",
        "protocol": "protocol",
        "target_port": "targetPort",
        "port": "port",
    },
)
class ServicePort(ServiceBindOptions):
    def __init__(
        self,
        *,
        name: typing.Optional[builtins.str] = None,
        node_port: typing.Optional[jsii.Number] = None,
        protocol: typing.Optional[Protocol] = None,
        target_port: typing.Optional[jsii.Number] = None,
        port: jsii.Number,
    ) -> None:
        '''Definition of a service port.

        :param name: The name of this port within the service. This must be a DNS_LABEL. All ports within a ServiceSpec must have unique names. This maps to the 'Name' field in EndpointPort objects. Optional if only one ServicePort is defined on this service.
        :param node_port: The port on each node on which this service is exposed when type=NodePort or LoadBalancer. Usually assigned by the system. If specified, it will be allocated to the service if unused or else creation of the service will fail. Default is to auto-allocate a port if the ServiceType of this Service requires one. Default: - auto-allocate a port if the ServiceType of this Service requires one.
        :param protocol: The IP protocol for this port. Supports "TCP", "UDP", and "SCTP". Default is TCP. Default: Protocol.TCP
        :param target_port: The port number the service will redirect to. Default: - The value of ``port`` will be used.
        :param port: The port number the service will bind to.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2b0537b5abf68baf0ba2972e7af6a07cc1d063b699b96d44814e4975ebd78a3e)
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument node_port", value=node_port, expected_type=type_hints["node_port"])
            check_type(argname="argument protocol", value=protocol, expected_type=type_hints["protocol"])
            check_type(argname="argument target_port", value=target_port, expected_type=type_hints["target_port"])
            check_type(argname="argument port", value=port, expected_type=type_hints["port"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "port": port,
        }
        if name is not None:
            self._values["name"] = name
        if node_port is not None:
            self._values["node_port"] = node_port
        if protocol is not None:
            self._values["protocol"] = protocol
        if target_port is not None:
            self._values["target_port"] = target_port

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''The name of this port within the service.

        This must be a DNS_LABEL. All
        ports within a ServiceSpec must have unique names. This maps to the 'Name'
        field in EndpointPort objects. Optional if only one ServicePort is defined
        on this service.
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def node_port(self) -> typing.Optional[jsii.Number]:
        '''The port on each node on which this service is exposed when type=NodePort or LoadBalancer.

        Usually assigned by the system. If specified, it will be
        allocated to the service if unused or else creation of the service will
        fail. Default is to auto-allocate a port if the ServiceType of this Service
        requires one.

        :default: - auto-allocate a port if the ServiceType of this Service requires one.

        :see: https://kubernetes.io/docs/concepts/services-networking/service/#type-nodeport
        '''
        result = self._values.get("node_port")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def protocol(self) -> typing.Optional[Protocol]:
        '''The IP protocol for this port.

        Supports "TCP", "UDP", and "SCTP". Default is TCP.

        :default: Protocol.TCP
        '''
        result = self._values.get("protocol")
        return typing.cast(typing.Optional[Protocol], result)

    @builtins.property
    def target_port(self) -> typing.Optional[jsii.Number]:
        '''The port number the service will redirect to.

        :default: - The value of ``port`` will be used.
        '''
        result = self._values.get("target_port")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def port(self) -> jsii.Number:
        '''The port number the service will bind to.'''
        result = self._values.get("port")
        assert result is not None, "Required property 'port' is missing"
        return typing.cast(jsii.Number, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ServicePort(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.ServiceProps",
    jsii_struct_bases=[ResourceProps],
    name_mapping={
        "metadata": "metadata",
        "cluster_ip": "clusterIP",
        "external_i_ps": "externalIPs",
        "external_name": "externalName",
        "load_balancer_source_ranges": "loadBalancerSourceRanges",
        "ports": "ports",
        "selector": "selector",
        "type": "type",
    },
)
class ServiceProps(ResourceProps):
    def __init__(
        self,
        *,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        cluster_ip: typing.Optional[builtins.str] = None,
        external_i_ps: typing.Optional[typing.Sequence[builtins.str]] = None,
        external_name: typing.Optional[builtins.str] = None,
        load_balancer_source_ranges: typing.Optional[typing.Sequence[builtins.str]] = None,
        ports: typing.Optional[typing.Sequence[typing.Union[ServicePort, typing.Dict[builtins.str, typing.Any]]]] = None,
        selector: typing.Optional[IPodSelector] = None,
        type: typing.Optional["ServiceType"] = None,
    ) -> None:
        '''Properties for ``Service``.

        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        :param cluster_ip: The IP address of the service and is usually assigned randomly by the master. If an address is specified manually and is not in use by others, it will be allocated to the service; otherwise, creation of the service will fail. This field can not be changed through updates. Valid values are "None", empty string (""), or a valid IP address. "None" can be specified for headless services when proxying is not required. Only applies to types ClusterIP, NodePort, and LoadBalancer. Ignored if type is ExternalName. Default: - Automatically assigned.
        :param external_i_ps: A list of IP addresses for which nodes in the cluster will also accept traffic for this service. These IPs are not managed by Kubernetes. The user is responsible for ensuring that traffic arrives at a node with this IP. A common example is external load-balancers that are not part of the Kubernetes system. Default: - No external IPs.
        :param external_name: The externalName to be used when ServiceType.EXTERNAL_NAME is set. Default: - No external name.
        :param load_balancer_source_ranges: A list of CIDR IP addresses, if specified and supported by the platform, will restrict traffic through the cloud-provider load-balancer to the specified client IPs. More info: https://kubernetes.io/docs/tasks/access-application-cluster/configure-cloud-provider-firewall/
        :param ports: The ports this service binds to. If the selector of the service is a managed pod / workload, its ports will are automatically extracted and used as the default value. Otherwise, no ports are bound. Default: - either the selector ports, or none.
        :param selector: Which pods should the service select and route to. You can pass one of the following: - An instance of ``Pod`` or any workload resource (e.g ``Deployment``, ``StatefulSet``, ...) - Pods selected by the ``Pods.select`` function. Note that in this case only labels can be specified. Default: - unset, the service is assumed to have an external process managing its endpoints, which Kubernetes will not modify.
        :param type: Determines how the Service is exposed. More info: https://kubernetes.io/docs/concepts/services-networking/service/#publishing-services-service-types Default: ServiceType.ClusterIP
        '''
        if isinstance(metadata, dict):
            metadata = _cdk8s_d3d9af27.ApiObjectMetadata(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f62c004f32685d6334d403fc15da8b9bbb91059ebc4dbaf25d8b2141957dc1c8)
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument cluster_ip", value=cluster_ip, expected_type=type_hints["cluster_ip"])
            check_type(argname="argument external_i_ps", value=external_i_ps, expected_type=type_hints["external_i_ps"])
            check_type(argname="argument external_name", value=external_name, expected_type=type_hints["external_name"])
            check_type(argname="argument load_balancer_source_ranges", value=load_balancer_source_ranges, expected_type=type_hints["load_balancer_source_ranges"])
            check_type(argname="argument ports", value=ports, expected_type=type_hints["ports"])
            check_type(argname="argument selector", value=selector, expected_type=type_hints["selector"])
            check_type(argname="argument type", value=type, expected_type=type_hints["type"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if metadata is not None:
            self._values["metadata"] = metadata
        if cluster_ip is not None:
            self._values["cluster_ip"] = cluster_ip
        if external_i_ps is not None:
            self._values["external_i_ps"] = external_i_ps
        if external_name is not None:
            self._values["external_name"] = external_name
        if load_balancer_source_ranges is not None:
            self._values["load_balancer_source_ranges"] = load_balancer_source_ranges
        if ports is not None:
            self._values["ports"] = ports
        if selector is not None:
            self._values["selector"] = selector
        if type is not None:
            self._values["type"] = type

    @builtins.property
    def metadata(self) -> typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata]:
        '''Metadata that all persisted resources must have, which includes all objects users must create.'''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata], result)

    @builtins.property
    def cluster_ip(self) -> typing.Optional[builtins.str]:
        '''The IP address of the service and is usually assigned randomly by the master.

        If an address is specified manually and is not in use by others, it
        will be allocated to the service; otherwise, creation of the service will
        fail. This field can not be changed through updates. Valid values are
        "None", empty string (""), or a valid IP address. "None" can be specified
        for headless services when proxying is not required. Only applies to types
        ClusterIP, NodePort, and LoadBalancer. Ignored if type is ExternalName.

        :default: - Automatically assigned.

        :see: https://kubernetes.io/docs/concepts/services-networking/service/#virtual-ips-and-service-proxies
        '''
        result = self._values.get("cluster_ip")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def external_i_ps(self) -> typing.Optional[typing.List[builtins.str]]:
        '''A list of IP addresses for which nodes in the cluster will also accept traffic for this service.

        These IPs are not managed by Kubernetes. The user
        is responsible for ensuring that traffic arrives at a node with this IP. A
        common example is external load-balancers that are not part of the
        Kubernetes system.

        :default: - No external IPs.
        '''
        result = self._values.get("external_i_ps")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def external_name(self) -> typing.Optional[builtins.str]:
        '''The externalName to be used when ServiceType.EXTERNAL_NAME is set.

        :default: - No external name.
        '''
        result = self._values.get("external_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def load_balancer_source_ranges(self) -> typing.Optional[typing.List[builtins.str]]:
        '''A list of CIDR IP addresses, if specified and supported by the platform, will restrict traffic through the cloud-provider load-balancer to the specified client IPs.

        More info: https://kubernetes.io/docs/tasks/access-application-cluster/configure-cloud-provider-firewall/
        '''
        result = self._values.get("load_balancer_source_ranges")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def ports(self) -> typing.Optional[typing.List[ServicePort]]:
        '''The ports this service binds to.

        If the selector of the service is a managed pod / workload,
        its ports will are automatically extracted and used as the default value.
        Otherwise, no ports are bound.

        :default: - either the selector ports, or none.
        '''
        result = self._values.get("ports")
        return typing.cast(typing.Optional[typing.List[ServicePort]], result)

    @builtins.property
    def selector(self) -> typing.Optional[IPodSelector]:
        '''Which pods should the service select and route to.

        You can pass one of the following:

        - An instance of ``Pod`` or any workload resource (e.g ``Deployment``, ``StatefulSet``, ...)
        - Pods selected by the ``Pods.select`` function. Note that in this case only labels can be specified.

        :default:

        - unset, the service is assumed to have an external process managing
        its endpoints, which Kubernetes will not modify.

        Example::

            // select the pods of a specific deployment
            const backend = new kplus.Deployment(this, 'Backend', ...);
            new kplus.Service(this, 'Service', { selector: backend });
            
            // select all pods labeled with the `tier=backend` label
            const backend = kplus.Pod.labeled({ tier: 'backend' });
            new kplus.Service(this, 'Service', { selector: backend });
        '''
        result = self._values.get("selector")
        return typing.cast(typing.Optional[IPodSelector], result)

    @builtins.property
    def type(self) -> typing.Optional["ServiceType"]:
        '''Determines how the Service is exposed.

        More info: https://kubernetes.io/docs/concepts/services-networking/service/#publishing-services-service-types

        :default: ServiceType.ClusterIP
        '''
        result = self._values.get("type")
        return typing.cast(typing.Optional["ServiceType"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ServiceProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.enum(jsii_type="cdk8s-plus-24.ServiceType")
class ServiceType(enum.Enum):
    '''For some parts of your application (for example, frontends) you may want to expose a Service onto an external IP address, that's outside of your cluster.

    Kubernetes ServiceTypes allow you to specify what kind of Service you want.
    The default is ClusterIP.
    '''

    CLUSTER_IP = "CLUSTER_IP"
    '''Exposes the Service on a cluster-internal IP.

    Choosing this value makes the Service only reachable from within the cluster.
    This is the default ServiceType
    '''
    NODE_PORT = "NODE_PORT"
    '''Exposes the Service on each Node's IP at a static port (the NodePort).

    A ClusterIP Service, to which the NodePort Service routes, is automatically created.
    You'll be able to contact the NodePort Service, from outside the cluster,
    by requesting :.
    '''
    LOAD_BALANCER = "LOAD_BALANCER"
    '''Exposes the Service externally using a cloud provider's load balancer.

    NodePort and ClusterIP Services, to which the external load balancer routes,
    are automatically created.
    '''
    EXTERNAL_NAME = "EXTERNAL_NAME"
    '''Maps the Service to the contents of the externalName field (e.g. foo.bar.example.com), by returning a CNAME record with its value. No proxying of any kind is set up.

    .. epigraph::

       Note: You need either kube-dns version 1.7 or CoreDNS version 0.0.8 or higher to use the ExternalName type.
    '''


class SshAuthSecret(
    Secret,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-24.SshAuthSecret",
):
    '''Create a secret for ssh authentication.

    :see: https://kubernetes.io/docs/concepts/configuration/secret/#ssh-authentication-secrets
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        ssh_private_key: builtins.str,
        immutable: typing.Optional[builtins.bool] = None,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param ssh_private_key: The SSH private key to use.
        :param immutable: If set to true, ensures that data stored in the Secret cannot be updated (only object metadata can be modified). If not set to true, the field can be modified at any time. Default: false
        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d612f9a65b7b117e300dfec20360cdf5f1ae7cf877855916a28c0660a073fe66)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = SshAuthSecretProps(
            ssh_private_key=ssh_private_key, immutable=immutable, metadata=metadata
        )

        jsii.create(self.__class__, self, [scope, id, props])


class StatefulSetUpdateStrategy(
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-24.StatefulSetUpdateStrategy",
):
    '''StatefulSet update strategies.'''

    @jsii.member(jsii_name="onDelete")
    @builtins.classmethod
    def on_delete(cls) -> "StatefulSetUpdateStrategy":
        '''The controller will not automatically update the Pods in a StatefulSet.

        Users must manually delete Pods to cause the controller to create new Pods
        that reflect modifications.
        '''
        return typing.cast("StatefulSetUpdateStrategy", jsii.sinvoke(cls, "onDelete", []))

    @jsii.member(jsii_name="rollingUpdate")
    @builtins.classmethod
    def rolling_update(
        cls,
        *,
        partition: typing.Optional[jsii.Number] = None,
    ) -> "StatefulSetUpdateStrategy":
        '''The controller will delete and recreate each Pod in the StatefulSet.

        It will proceed in the same order as Pod termination (from the largest ordinal to the smallest),
        updating each Pod one at a time. The Kubernetes control plane waits until an updated
        Pod is Running and Ready prior to updating its predecessor.

        :param partition: If specified, all Pods with an ordinal that is greater than or equal to the partition will be updated when the StatefulSet's .spec.template is updated. All Pods with an ordinal that is less than the partition will not be updated, and, even if they are deleted, they will be recreated at the previous version. If the partition is greater than replicas, updates to the pod template will not be propagated to Pods. In most cases you will not need to use a partition, but they are useful if you want to stage an update, roll out a canary, or perform a phased roll out. Default: 0
        '''
        options = StatefulSetUpdateStrategyRollingUpdateOptions(partition=partition)

        return typing.cast("StatefulSetUpdateStrategy", jsii.sinvoke(cls, "rollingUpdate", [options]))


@jsii.data_type(
    jsii_type="cdk8s-plus-24.StatefulSetUpdateStrategyRollingUpdateOptions",
    jsii_struct_bases=[],
    name_mapping={"partition": "partition"},
)
class StatefulSetUpdateStrategyRollingUpdateOptions:
    def __init__(self, *, partition: typing.Optional[jsii.Number] = None) -> None:
        '''Options for ``StatefulSetUpdateStrategy.rollingUpdate``.

        :param partition: If specified, all Pods with an ordinal that is greater than or equal to the partition will be updated when the StatefulSet's .spec.template is updated. All Pods with an ordinal that is less than the partition will not be updated, and, even if they are deleted, they will be recreated at the previous version. If the partition is greater than replicas, updates to the pod template will not be propagated to Pods. In most cases you will not need to use a partition, but they are useful if you want to stage an update, roll out a canary, or perform a phased roll out. Default: 0
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d32aaa269ea4b98be8ac8d194e18398712aa76a2780ad3f88255967f75761a17)
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if partition is not None:
            self._values["partition"] = partition

    @builtins.property
    def partition(self) -> typing.Optional[jsii.Number]:
        '''If specified, all Pods with an ordinal that is greater than or equal to the partition will be updated when the StatefulSet's .spec.template is updated. All Pods with an ordinal that is less than the partition will not be updated, and, even if they are deleted, they will be recreated at the previous version.

        If the partition is greater than replicas, updates to the pod template will not be propagated to Pods.
        In most cases you will not need to use a partition, but they are useful if you want to stage an
        update, roll out a canary, or perform a phased roll out.

        :default: 0

        :see: https://kubernetes.io/docs/concepts/workloads/controllers/statefulset/#partitions
        '''
        result = self._values.get("partition")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "StatefulSetUpdateStrategyRollingUpdateOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.SubjectConfiguration",
    jsii_struct_bases=[],
    name_mapping={
        "kind": "kind",
        "name": "name",
        "api_group": "apiGroup",
        "namespace": "namespace",
    },
)
class SubjectConfiguration:
    def __init__(
        self,
        *,
        kind: builtins.str,
        name: builtins.str,
        api_group: typing.Optional[builtins.str] = None,
        namespace: typing.Optional[builtins.str] = None,
    ) -> None:
        '''Subject contains a reference to the object or user identities a role binding applies to.

        This can either hold a direct API object reference, or a value
        for non-objects such as user and group names.

        :param kind: Kind of object being referenced. Values defined by this API group are "User", "Group", and "ServiceAccount". If the Authorizer does not recognized the kind value, the Authorizer should report an error.
        :param name: Name of the object being referenced.
        :param api_group: APIGroup holds the API group of the referenced subject. Defaults to "" for ServiceAccount subjects. Defaults to "rbac.authorization.k8s.io" for User and Group subjects.
        :param namespace: Namespace of the referenced object. If the object kind is non-namespace, such as "User" or "Group", and this value is not empty the Authorizer should report an error.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__bab49097c2bed96ae21fa23b49f7a5abb654447e0b18c600abfc0e9074c9389f)
            check_type(argname="argument kind", value=kind, expected_type=type_hints["kind"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument api_group", value=api_group, expected_type=type_hints["api_group"])
            check_type(argname="argument namespace", value=namespace, expected_type=type_hints["namespace"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "kind": kind,
            "name": name,
        }
        if api_group is not None:
            self._values["api_group"] = api_group
        if namespace is not None:
            self._values["namespace"] = namespace

    @builtins.property
    def kind(self) -> builtins.str:
        '''Kind of object being referenced.

        Values defined by this API group are
        "User", "Group", and "ServiceAccount". If the Authorizer does not
        recognized the kind value, the Authorizer should report an error.
        '''
        result = self._values.get("kind")
        assert result is not None, "Required property 'kind' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def name(self) -> builtins.str:
        '''Name of the object being referenced.'''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def api_group(self) -> typing.Optional[builtins.str]:
        '''APIGroup holds the API group of the referenced subject.

        Defaults to "" for
        ServiceAccount subjects. Defaults to "rbac.authorization.k8s.io" for User
        and Group subjects.
        '''
        result = self._values.get("api_group")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def namespace(self) -> typing.Optional[builtins.str]:
        '''Namespace of the referenced object.

        If the object kind is non-namespace,
        such as "User" or "Group", and this value is not empty the Authorizer
        should report an error.
        '''
        result = self._values.get("namespace")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "SubjectConfiguration(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.Sysctl",
    jsii_struct_bases=[],
    name_mapping={"name": "name", "value": "value"},
)
class Sysctl:
    def __init__(self, *, name: builtins.str, value: builtins.str) -> None:
        '''Sysctl defines a kernel parameter to be set.

        :param name: Name of a property to set.
        :param value: Value of a property to set.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a7957e6b50e1eb8957763eafe72bd52b8e00522ff4f60d5a66a3bf0f5626a48f)
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "name": name,
            "value": value,
        }

    @builtins.property
    def name(self) -> builtins.str:
        '''Name of a property to set.'''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def value(self) -> builtins.str:
        '''Value of a property to set.'''
        result = self._values.get("value")
        assert result is not None, "Required property 'value' is missing"
        return typing.cast(builtins.str, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "Sysctl(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.enum(jsii_type="cdk8s-plus-24.TaintEffect")
class TaintEffect(enum.Enum):
    '''Taint effects.'''

    NO_SCHEDULE = "NO_SCHEDULE"
    '''This means that no pod will be able to schedule onto the node unless it has a matching toleration.'''
    PREFER_NO_SCHEDULE = "PREFER_NO_SCHEDULE"
    '''This is a "preference" or "soft" version of ``NO_SCHEDULE`` -- the system will try to avoid placing a pod that does not tolerate the taint on the node, but it is not required.'''
    NO_EXECUTE = "NO_EXECUTE"
    '''This affects pods that are already running on the node as follows:.

    - Pods that do not tolerate the taint are evicted immediately.
    - Pods that tolerate the taint without specifying ``duration`` remain bound forever.
    - Pods that tolerate the taint with a specified ``duration`` remain bound for
      the specified amount of time.
    '''


class TaintedNode(metaclass=jsii.JSIIMeta, jsii_type="cdk8s-plus-24.TaintedNode"):
    '''A node that is matched by taint selectors.'''

    def __init__(self, taint_selector: typing.Sequence[NodeTaintQuery]) -> None:
        '''
        :param taint_selector: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ee77248585be7ad1e086bfed426ddfb28d34d1ade9ed7f3fba4ef87921cd644a)
            check_type(argname="argument taint_selector", value=taint_selector, expected_type=type_hints["taint_selector"])
        jsii.create(self.__class__, self, [taint_selector])

    @builtins.property
    @jsii.member(jsii_name="taintSelector")
    def taint_selector(self) -> typing.List[NodeTaintQuery]:
        return typing.cast(typing.List[NodeTaintQuery], jsii.get(self, "taintSelector"))


@jsii.data_type(
    jsii_type="cdk8s-plus-24.TcpSocketProbeOptions",
    jsii_struct_bases=[ProbeOptions],
    name_mapping={
        "failure_threshold": "failureThreshold",
        "initial_delay_seconds": "initialDelaySeconds",
        "period_seconds": "periodSeconds",
        "success_threshold": "successThreshold",
        "timeout_seconds": "timeoutSeconds",
        "host": "host",
        "port": "port",
    },
)
class TcpSocketProbeOptions(ProbeOptions):
    def __init__(
        self,
        *,
        failure_threshold: typing.Optional[jsii.Number] = None,
        initial_delay_seconds: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        period_seconds: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        success_threshold: typing.Optional[jsii.Number] = None,
        timeout_seconds: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        host: typing.Optional[builtins.str] = None,
        port: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''Options for ``Probe.fromTcpSocket()``.

        :param failure_threshold: Minimum consecutive failures for the probe to be considered failed after having succeeded. Defaults to 3. Minimum value is 1. Default: 3
        :param initial_delay_seconds: Number of seconds after the container has started before liveness probes are initiated. Default: - immediate
        :param period_seconds: How often (in seconds) to perform the probe. Default to 10 seconds. Minimum value is 1. Default: Duration.seconds(10) Minimum value is 1.
        :param success_threshold: Minimum consecutive successes for the probe to be considered successful after having failed. Defaults to 1. Must be 1 for liveness and startup. Minimum value is 1. Default: 1 Must be 1 for liveness and startup. Minimum value is 1.
        :param timeout_seconds: Number of seconds after which the probe times out. Defaults to 1 second. Minimum value is 1. Default: Duration.seconds(1)
        :param host: The host name to connect to on the container. Default: - defaults to the pod IP
        :param port: The TCP port to connect to on the container. Default: - defaults to ``container.port``.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9379441ec8e003866395961d737dcad3fce4486e7a467c4843ae6e1980fad5b0)
            check_type(argname="argument failure_threshold", value=failure_threshold, expected_type=type_hints["failure_threshold"])
            check_type(argname="argument initial_delay_seconds", value=initial_delay_seconds, expected_type=type_hints["initial_delay_seconds"])
            check_type(argname="argument period_seconds", value=period_seconds, expected_type=type_hints["period_seconds"])
            check_type(argname="argument success_threshold", value=success_threshold, expected_type=type_hints["success_threshold"])
            check_type(argname="argument timeout_seconds", value=timeout_seconds, expected_type=type_hints["timeout_seconds"])
            check_type(argname="argument host", value=host, expected_type=type_hints["host"])
            check_type(argname="argument port", value=port, expected_type=type_hints["port"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if failure_threshold is not None:
            self._values["failure_threshold"] = failure_threshold
        if initial_delay_seconds is not None:
            self._values["initial_delay_seconds"] = initial_delay_seconds
        if period_seconds is not None:
            self._values["period_seconds"] = period_seconds
        if success_threshold is not None:
            self._values["success_threshold"] = success_threshold
        if timeout_seconds is not None:
            self._values["timeout_seconds"] = timeout_seconds
        if host is not None:
            self._values["host"] = host
        if port is not None:
            self._values["port"] = port

    @builtins.property
    def failure_threshold(self) -> typing.Optional[jsii.Number]:
        '''Minimum consecutive failures for the probe to be considered failed after having succeeded.

        Defaults to 3. Minimum value is 1.

        :default: 3
        '''
        result = self._values.get("failure_threshold")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def initial_delay_seconds(self) -> typing.Optional[_cdk8s_d3d9af27.Duration]:
        '''Number of seconds after the container has started before liveness probes are initiated.

        :default: - immediate

        :see: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        '''
        result = self._values.get("initial_delay_seconds")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Duration], result)

    @builtins.property
    def period_seconds(self) -> typing.Optional[_cdk8s_d3d9af27.Duration]:
        '''How often (in seconds) to perform the probe.

        Default to 10 seconds. Minimum value is 1.

        :default: Duration.seconds(10) Minimum value is 1.
        '''
        result = self._values.get("period_seconds")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Duration], result)

    @builtins.property
    def success_threshold(self) -> typing.Optional[jsii.Number]:
        '''Minimum consecutive successes for the probe to be considered successful after having failed. Defaults to 1.

        Must be 1 for liveness and startup. Minimum value is 1.

        :default: 1 Must be 1 for liveness and startup. Minimum value is 1.
        '''
        result = self._values.get("success_threshold")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def timeout_seconds(self) -> typing.Optional[_cdk8s_d3d9af27.Duration]:
        '''Number of seconds after which the probe times out.

        Defaults to 1 second. Minimum value is 1.

        :default: Duration.seconds(1)

        :see: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        '''
        result = self._values.get("timeout_seconds")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Duration], result)

    @builtins.property
    def host(self) -> typing.Optional[builtins.str]:
        '''The host name to connect to on the container.

        :default: - defaults to the pod IP
        '''
        result = self._values.get("host")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def port(self) -> typing.Optional[jsii.Number]:
        '''The TCP port to connect to on the container.

        :default: - defaults to ``container.port``.
        '''
        result = self._values.get("port")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TcpSocketProbeOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class TlsSecret(Secret, metaclass=jsii.JSIIMeta, jsii_type="cdk8s-plus-24.TlsSecret"):
    '''Create a secret for storing a TLS certificate and its associated key.

    :see: https://kubernetes.io/docs/concepts/configuration/secret/#tls-secrets
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        tls_cert: builtins.str,
        tls_key: builtins.str,
        immutable: typing.Optional[builtins.bool] = None,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param tls_cert: The TLS cert.
        :param tls_key: The TLS key.
        :param immutable: If set to true, ensures that data stored in the Secret cannot be updated (only object metadata can be modified). If not set to true, the field can be modified at any time. Default: false
        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5ef04793a8db8617629fc07ceaa3a6fb5c46e3c9ac8942847d177e9067da0f3c)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = TlsSecretProps(
            tls_cert=tls_cert, tls_key=tls_key, immutable=immutable, metadata=metadata
        )

        jsii.create(self.__class__, self, [scope, id, props])


class Topology(metaclass=jsii.JSIIMeta, jsii_type="cdk8s-plus-24.Topology"):
    '''Available topology domains.'''

    @jsii.member(jsii_name="custom")
    @builtins.classmethod
    def custom(cls, key: builtins.str) -> "Topology":
        '''Custom key for the node label that the system uses to denote the topology domain.

        :param key: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__46c781fa290a271755af38b40d5c03a3dd575b1338383d68bfd5f113386b0040)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
        return typing.cast("Topology", jsii.sinvoke(cls, "custom", [key]))

    @jsii.python.classproperty
    @jsii.member(jsii_name="HOSTNAME")
    def HOSTNAME(cls) -> "Topology":
        '''A hostname represents a single node in the cluster.

        :see: https://kubernetes.io/docs/reference/labels-annotations-taints/#kubernetesiohostname
        '''
        return typing.cast("Topology", jsii.sget(cls, "HOSTNAME"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="REGION")
    def REGION(cls) -> "Topology":
        '''A region represents a larger domain, made up of one or more zones.

        It is uncommon
        for Kubernetes clusters to span multiple regions. While the exact definition of a
        zone or region is left to infrastructure implementations, common properties of a region
        include higher network latency between them than within them, non-zero cost for network
        traffic between them, and failure independence from other zones or regions.

        For example, nodes within a region might share power infrastructure (e.g. a UPS or generator), but
        nodes in different regions typically would not.

        :see: https://kubernetes.io/docs/reference/labels-annotations-taints/#topologykubernetesioregion
        '''
        return typing.cast("Topology", jsii.sget(cls, "REGION"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="ZONE")
    def ZONE(cls) -> "Topology":
        '''A zone represents a logical failure domain.

        It is common for Kubernetes clusters to
        span multiple zones for increased availability. While the exact definition of a zone is
        left to infrastructure implementations, common properties of a zone include very low
        network latency within a zone, no-cost network traffic within a zone, and failure
        independence from other zones. For example, nodes within a zone might share a network
        switch, but nodes in different zones should not.

        :see: https://kubernetes.io/docs/reference/labels-annotations-taints/#topologykubernetesiozone
        '''
        return typing.cast("Topology", jsii.sget(cls, "ZONE"))

    @builtins.property
    @jsii.member(jsii_name="key")
    def key(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "key"))


@jsii.implements(ISubject)
class User(
    _constructs_77d1e7e8.Construct,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-24.User",
):
    '''Represents a user.'''

    @jsii.member(jsii_name="fromName")
    @builtins.classmethod
    def from_name(
        cls,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        name: builtins.str,
    ) -> "User":
        '''Reference a user in the cluster by name.

        :param scope: -
        :param id: -
        :param name: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2f86b7b060d13a0e52e0dee5f03932cd4e4cf86cf5667170250150bfb070175d)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
        return typing.cast("User", jsii.sinvoke(cls, "fromName", [scope, id, name]))

    @jsii.member(jsii_name="toSubjectConfiguration")
    def to_subject_configuration(self) -> SubjectConfiguration:
        '''Return the subject configuration.

        :see: ISubect.toSubjectConfiguration()
        '''
        return typing.cast(SubjectConfiguration, jsii.invoke(self, "toSubjectConfiguration", []))

    @builtins.property
    @jsii.member(jsii_name="kind")
    def kind(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "kind"))

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "name"))

    @builtins.property
    @jsii.member(jsii_name="apiGroup")
    def api_group(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "apiGroup"))


@jsii.implements(IStorage)
class Volume(
    _constructs_77d1e7e8.Construct,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-24.Volume",
):
    '''Volume represents a named volume in a pod that may be accessed by any container in the pod.

    Docker also has a concept of volumes, though it is somewhat looser and less
    managed. In Docker, a volume is simply a directory on disk or in another
    Container. Lifetimes are not managed and until very recently there were only
    local-disk-backed volumes. Docker now provides volume drivers, but the
    functionality is very limited for now (e.g. as of Docker 1.7 only one volume
    driver is allowed per Container and there is no way to pass parameters to
    volumes).

    A Kubernetes volume, on the other hand, has an explicit lifetime - the same
    as the Pod that encloses it. Consequently, a volume outlives any Containers
    that run within the Pod, and data is preserved across Container restarts. Of
    course, when a Pod ceases to exist, the volume will cease to exist, too.
    Perhaps more importantly than this, Kubernetes supports many types of
    volumes, and a Pod can use any number of them simultaneously.

    At its core, a volume is just a directory, possibly with some data in it,
    which is accessible to the Containers in a Pod. How that directory comes to
    be, the medium that backs it, and the contents of it are determined by the
    particular volume type used.

    To use a volume, a Pod specifies what volumes to provide for the Pod (the
    .spec.volumes field) and where to mount those into Containers (the
    .spec.containers[*].volumeMounts field).

    A process in a container sees a filesystem view composed from their Docker
    image and volumes. The Docker image is at the root of the filesystem
    hierarchy, and any volumes are mounted at the specified paths within the
    image. Volumes can not mount onto other volumes
    '''

    @jsii.member(jsii_name="fromAwsElasticBlockStore")
    @builtins.classmethod
    def from_aws_elastic_block_store(
        cls,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        volume_id: builtins.str,
        *,
        fs_type: typing.Optional[builtins.str] = None,
        name: typing.Optional[builtins.str] = None,
        partition: typing.Optional[jsii.Number] = None,
        read_only: typing.Optional[builtins.bool] = None,
    ) -> "Volume":
        '''Mounts an Amazon Web Services (AWS) EBS volume into your pod.

        Unlike emptyDir, which is erased when a pod is removed, the contents of an EBS volume are
        persisted and the volume is unmounted. This means that an EBS volume can be pre-populated with data,
        and that data can be shared between pods.

        There are some restrictions when using an awsElasticBlockStore volume:

        - the nodes on which pods are running must be AWS EC2 instances.
        - those instances need to be in the same region and availability zone as the EBS volume.
        - EBS only supports a single EC2 instance mounting a volume.

        :param scope: -
        :param id: -
        :param volume_id: -
        :param fs_type: Filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Default: 'ext4'
        :param name: The volume name. Default: - auto-generated
        :param partition: The partition in the volume that you want to mount. If omitted, the default is to mount by volume name. Examples: For volume /dev/sda1, you specify the partition as "1". Similarly, the volume partition for /dev/sda is "0" (or you can leave the property empty). Default: - No partition.
        :param read_only: Specify "true" to force and set the ReadOnly property in VolumeMounts to "true". Default: false
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__680d148953879e587c6214e732dec6c45fa60da9e727b00425332febb6c0e750)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
            check_type(argname="argument volume_id", value=volume_id, expected_type=type_hints["volume_id"])
        options = AwsElasticBlockStoreVolumeOptions(
            fs_type=fs_type, name=name, partition=partition, read_only=read_only
        )

        return typing.cast("Volume", jsii.sinvoke(cls, "fromAwsElasticBlockStore", [scope, id, volume_id, options]))

    @jsii.member(jsii_name="fromAzureDisk")
    @builtins.classmethod
    def from_azure_disk(
        cls,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        disk_name: builtins.str,
        disk_uri: builtins.str,
        *,
        caching_mode: typing.Optional[AzureDiskPersistentVolumeCachingMode] = None,
        fs_type: typing.Optional[builtins.str] = None,
        kind: typing.Optional[AzureDiskPersistentVolumeKind] = None,
        name: typing.Optional[builtins.str] = None,
        read_only: typing.Optional[builtins.bool] = None,
    ) -> "Volume":
        '''Mounts a Microsoft Azure Data Disk into a pod.

        :param scope: -
        :param id: -
        :param disk_name: -
        :param disk_uri: -
        :param caching_mode: Host Caching mode. Default: - AzureDiskPersistentVolumeCachingMode.NONE.
        :param fs_type: Filesystem type to mount. Must be a filesystem type supported by the host operating system. Default: 'ext4'
        :param kind: Kind of disk. Default: AzureDiskPersistentVolumeKind.SHARED
        :param name: The volume name. Default: - auto-generated
        :param read_only: Force the ReadOnly setting in VolumeMounts. Default: false
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2cd216ee9af14d9798244c04cea8d546660b13e51f5554140f62859e61d4bb85)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
            check_type(argname="argument disk_name", value=disk_name, expected_type=type_hints["disk_name"])
            check_type(argname="argument disk_uri", value=disk_uri, expected_type=type_hints["disk_uri"])
        options = AzureDiskVolumeOptions(
            caching_mode=caching_mode,
            fs_type=fs_type,
            kind=kind,
            name=name,
            read_only=read_only,
        )

        return typing.cast("Volume", jsii.sinvoke(cls, "fromAzureDisk", [scope, id, disk_name, disk_uri, options]))

    @jsii.member(jsii_name="fromConfigMap")
    @builtins.classmethod
    def from_config_map(
        cls,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        config_map: "IConfigMap",
        *,
        default_mode: typing.Optional[jsii.Number] = None,
        items: typing.Optional[typing.Mapping[builtins.str, typing.Union[PathMapping, typing.Dict[builtins.str, typing.Any]]]] = None,
        name: typing.Optional[builtins.str] = None,
        optional: typing.Optional[builtins.bool] = None,
    ) -> "Volume":
        '''Populate the volume from a ConfigMap.

        The configMap resource provides a way to inject configuration data into
        Pods. The data stored in a ConfigMap object can be referenced in a volume
        of type configMap and then consumed by containerized applications running
        in a Pod.

        When referencing a configMap object, you can simply provide its name in the
        volume to reference it. You can also customize the path to use for a
        specific entry in the ConfigMap.

        :param scope: -
        :param id: -
        :param config_map: The config map to use to populate the volume.
        :param default_mode: Mode bits to use on created files by default. Must be a value between 0 and 0777. Defaults to 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set. Default: 644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
        :param items: If unspecified, each key-value pair in the Data field of the referenced ConfigMap will be projected into the volume as a file whose name is the key and content is the value. If specified, the listed keys will be projected into the specified paths, and unlisted keys will not be present. If a key is specified which is not present in the ConfigMap, the volume setup will error unless it is marked optional. Paths must be relative and may not contain the '..' path or start with '..'. Default: - no mapping
        :param name: The volume name. Default: - auto-generated
        :param optional: Specify whether the ConfigMap or its keys must be defined. Default: - undocumented
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__828332c80fb996159e90aaf6f85cb7af67fbd14e2601c12aa06ffa579644defc)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
            check_type(argname="argument config_map", value=config_map, expected_type=type_hints["config_map"])
        options = ConfigMapVolumeOptions(
            default_mode=default_mode, items=items, name=name, optional=optional
        )

        return typing.cast("Volume", jsii.sinvoke(cls, "fromConfigMap", [scope, id, config_map, options]))

    @jsii.member(jsii_name="fromCsi")
    @builtins.classmethod
    def from_csi(
        cls,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        driver: builtins.str,
        *,
        attributes: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        fs_type: typing.Optional[builtins.str] = None,
        name: typing.Optional[builtins.str] = None,
        read_only: typing.Optional[builtins.bool] = None,
    ) -> "Volume":
        '''Populate the volume from a CSI driver, for example the Secrets Store CSI Driver: https://secrets-store-csi-driver.sigs.k8s.io/introduction.html. Which in turn needs an associated provider to source the secrets, such as the AWS Secrets Manager and Systems Manager Parameter Store provider: https://aws.github.io/secrets-store-csi-driver-provider-aws/.

        :param scope: -
        :param id: -
        :param driver: The name of the CSI driver to use to populate the volume.
        :param attributes: Any driver-specific attributes to pass to the CSI volume builder. Default: - undefined
        :param fs_type: The filesystem type to mount. Ex. "ext4", "xfs", "ntfs". If not provided, the empty value is passed to the associated CSI driver, which will determine the default filesystem to apply. Default: - driver-dependent
        :param name: The volume name. Default: - auto-generated
        :param read_only: Whether the mounted volume should be read-only or not. Default: - false
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__414a072c144773bb4262c13f5fbdfcc5838331dbe3f51afd4eb7690e54412d00)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
            check_type(argname="argument driver", value=driver, expected_type=type_hints["driver"])
        options = CsiVolumeOptions(
            attributes=attributes, fs_type=fs_type, name=name, read_only=read_only
        )

        return typing.cast("Volume", jsii.sinvoke(cls, "fromCsi", [scope, id, driver, options]))

    @jsii.member(jsii_name="fromEmptyDir")
    @builtins.classmethod
    def from_empty_dir(
        cls,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        name: builtins.str,
        *,
        medium: typing.Optional[EmptyDirMedium] = None,
        size_limit: typing.Optional[_cdk8s_d3d9af27.Size] = None,
    ) -> "Volume":
        '''An emptyDir volume is first created when a Pod is assigned to a Node, and exists as long as that Pod is running on that node.

        As the name says, it is
        initially empty. Containers in the Pod can all read and write the same
        files in the emptyDir volume, though that volume can be mounted at the same
        or different paths in each Container. When a Pod is removed from a node for
        any reason, the data in the emptyDir is deleted forever.

        :param scope: -
        :param id: -
        :param name: -
        :param medium: By default, emptyDir volumes are stored on whatever medium is backing the node - that might be disk or SSD or network storage, depending on your environment. However, you can set the emptyDir.medium field to ``EmptyDirMedium.MEMORY`` to tell Kubernetes to mount a tmpfs (RAM-backed filesystem) for you instead. While tmpfs is very fast, be aware that unlike disks, tmpfs is cleared on node reboot and any files you write will count against your Container's memory limit. Default: EmptyDirMedium.DEFAULT
        :param size_limit: Total amount of local storage required for this EmptyDir volume. The size limit is also applicable for memory medium. The maximum usage on memory medium EmptyDir would be the minimum value between the SizeLimit specified here and the sum of memory limits of all containers in a pod. Default: - limit is undefined

        :see: http://kubernetes.io/docs/user-guide/volumes#emptydir
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__00e2a861b6d23d753c8cf1fd6072b193d049d05374fff8bb0d840e1f990ca375)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
        options = EmptyDirVolumeOptions(medium=medium, size_limit=size_limit)

        return typing.cast("Volume", jsii.sinvoke(cls, "fromEmptyDir", [scope, id, name, options]))

    @jsii.member(jsii_name="fromGcePersistentDisk")
    @builtins.classmethod
    def from_gce_persistent_disk(
        cls,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        pd_name: builtins.str,
        *,
        fs_type: typing.Optional[builtins.str] = None,
        name: typing.Optional[builtins.str] = None,
        partition: typing.Optional[jsii.Number] = None,
        read_only: typing.Optional[builtins.bool] = None,
    ) -> "Volume":
        '''Mounts a Google Compute Engine (GCE) persistent disk (PD) into your Pod.

        Unlike emptyDir, which is erased when a pod is removed, the contents of a PD are
        preserved and the volume is merely unmounted. This means that a PD can be pre-populated
        with data, and that data can be shared between pods.

        There are some restrictions when using a gcePersistentDisk:

        - the nodes on which Pods are running must be GCE VMs
        - those VMs need to be in the same GCE project and zone as the persistent disk

        :param scope: -
        :param id: -
        :param pd_name: -
        :param fs_type: Filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Default: 'ext4'
        :param name: The volume name. Default: - auto-generated
        :param partition: The partition in the volume that you want to mount. If omitted, the default is to mount by volume name. Examples: For volume /dev/sda1, you specify the partition as "1". Similarly, the volume partition for /dev/sda is "0" (or you can leave the property empty). Default: - No partition.
        :param read_only: Specify "true" to force and set the ReadOnly property in VolumeMounts to "true". Default: false
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__03109538612ba6883bdd69aebfffb7f207ea748706435e32e979640b2058dc76)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
            check_type(argname="argument pd_name", value=pd_name, expected_type=type_hints["pd_name"])
        options = GCEPersistentDiskVolumeOptions(
            fs_type=fs_type, name=name, partition=partition, read_only=read_only
        )

        return typing.cast("Volume", jsii.sinvoke(cls, "fromGcePersistentDisk", [scope, id, pd_name, options]))

    @jsii.member(jsii_name="fromHostPath")
    @builtins.classmethod
    def from_host_path(
        cls,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        name: builtins.str,
        *,
        path: builtins.str,
        type: typing.Optional[HostPathVolumeType] = None,
    ) -> "Volume":
        '''Used to mount a file or directory from the host node's filesystem into a Pod.

        This is not something that most Pods will need, but it offers a powerful
        escape hatch for some applications.

        :param scope: -
        :param id: -
        :param name: -
        :param path: The path of the directory on the host.
        :param type: The expected type of the path found on the host. Default: HostPathVolumeType.DEFAULT

        :see: https://kubernetes.io/docs/concepts/storage/volumes/#hostpath
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c4b8237f99b25791b06dbd01d539e69015b2efbb2911ede2bc417a21a0bbf2a5)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
        options = HostPathVolumeOptions(path=path, type=type)

        return typing.cast("Volume", jsii.sinvoke(cls, "fromHostPath", [scope, id, name, options]))

    @jsii.member(jsii_name="fromPersistentVolumeClaim")
    @builtins.classmethod
    def from_persistent_volume_claim(
        cls,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        claim: "IPersistentVolumeClaim",
        *,
        name: typing.Optional[builtins.str] = None,
        read_only: typing.Optional[builtins.bool] = None,
    ) -> "Volume":
        '''Used to mount a PersistentVolume into a Pod.

        PersistentVolumeClaims are a way for users to "claim" durable storage (such as a GCE PersistentDisk or an iSCSI volume)
        without knowing the details of the particular cloud environment.

        :param scope: -
        :param id: -
        :param claim: -
        :param name: The volume name. Default: - Derived from the PVC name.
        :param read_only: Will force the ReadOnly setting in VolumeMounts. Default: false

        :see: https://kubernetes.io/docs/concepts/storage/persistent-volumes/
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e1874d6be68bf404040041d035e87887ac84fd0cc52d4eaf82c4030393d17635)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
            check_type(argname="argument claim", value=claim, expected_type=type_hints["claim"])
        options = PersistentVolumeClaimVolumeOptions(name=name, read_only=read_only)

        return typing.cast("Volume", jsii.sinvoke(cls, "fromPersistentVolumeClaim", [scope, id, claim, options]))

    @jsii.member(jsii_name="fromSecret")
    @builtins.classmethod
    def from_secret(
        cls,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        secr: ISecret,
        *,
        default_mode: typing.Optional[jsii.Number] = None,
        items: typing.Optional[typing.Mapping[builtins.str, typing.Union[PathMapping, typing.Dict[builtins.str, typing.Any]]]] = None,
        name: typing.Optional[builtins.str] = None,
        optional: typing.Optional[builtins.bool] = None,
    ) -> "Volume":
        '''Populate the volume from a Secret.

        A secret volume is used to pass sensitive information, such as passwords, to Pods.
        You can store secrets in the Kubernetes API and mount them as files for use by pods
        without coupling to Kubernetes directly.

        secret volumes are backed by tmpfs (a RAM-backed filesystem)
        so they are never written to non-volatile storage.

        :param scope: -
        :param id: -
        :param secr: The secret to use to populate the volume.
        :param default_mode: Mode bits to use on created files by default. Must be a value between 0 and 0777. Defaults to 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set. Default: 644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
        :param items: If unspecified, each key-value pair in the Data field of the referenced secret will be projected into the volume as a file whose name is the key and content is the value. If specified, the listed keys will be projected into the specified paths, and unlisted keys will not be present. If a key is specified which is not present in the secret, the volume setup will error unless it is marked optional. Paths must be relative and may not contain the '..' path or start with '..'. Default: - no mapping
        :param name: The volume name. Default: - auto-generated
        :param optional: Specify whether the secret or its keys must be defined. Default: - undocumented

        :see: https://kubernetes.io/docs/concepts/storage/volumes/#secret
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__71cd731fbedbbb9bc2253f9a6f3f78f73bf971f5201df06acacc810f16db9c05)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
            check_type(argname="argument secr", value=secr, expected_type=type_hints["secr"])
        options = SecretVolumeOptions(
            default_mode=default_mode, items=items, name=name, optional=optional
        )

        return typing.cast("Volume", jsii.sinvoke(cls, "fromSecret", [scope, id, secr, options]))

    @jsii.member(jsii_name="asVolume")
    def as_volume(self) -> "Volume":
        '''Convert the piece of storage into a concrete volume.'''
        return typing.cast("Volume", jsii.invoke(self, "asVolume", []))

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "name"))


@jsii.data_type(
    jsii_type="cdk8s-plus-24.VolumeMount",
    jsii_struct_bases=[MountOptions],
    name_mapping={
        "propagation": "propagation",
        "read_only": "readOnly",
        "sub_path": "subPath",
        "sub_path_expr": "subPathExpr",
        "path": "path",
        "volume": "volume",
    },
)
class VolumeMount(MountOptions):
    def __init__(
        self,
        *,
        propagation: typing.Optional[MountPropagation] = None,
        read_only: typing.Optional[builtins.bool] = None,
        sub_path: typing.Optional[builtins.str] = None,
        sub_path_expr: typing.Optional[builtins.str] = None,
        path: builtins.str,
        volume: Volume,
    ) -> None:
        '''Mount a volume from the pod to the container.

        :param propagation: Determines how mounts are propagated from the host to container and the other way around. When not set, MountPropagationNone is used. Mount propagation allows for sharing volumes mounted by a Container to other Containers in the same Pod, or even to other Pods on the same node. Default: MountPropagation.NONE
        :param read_only: Mounted read-only if true, read-write otherwise (false or unspecified). Defaults to false. Default: false
        :param sub_path: Path within the volume from which the container's volume should be mounted.). Default: "" the volume's root
        :param sub_path_expr: Expanded path within the volume from which the container's volume should be mounted. Behaves similarly to SubPath but environment variable references $(VAR_NAME) are expanded using the container's environment. Defaults to "" (volume's root). ``subPathExpr`` and ``subPath`` are mutually exclusive. Default: "" volume's root.
        :param path: Path within the container at which the volume should be mounted. Must not contain ':'.
        :param volume: The volume to mount.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3f3993c533d923de4add33920cdd0bf60956a8fe3fbd4b51a867b4b858c91501)
            check_type(argname="argument propagation", value=propagation, expected_type=type_hints["propagation"])
            check_type(argname="argument read_only", value=read_only, expected_type=type_hints["read_only"])
            check_type(argname="argument sub_path", value=sub_path, expected_type=type_hints["sub_path"])
            check_type(argname="argument sub_path_expr", value=sub_path_expr, expected_type=type_hints["sub_path_expr"])
            check_type(argname="argument path", value=path, expected_type=type_hints["path"])
            check_type(argname="argument volume", value=volume, expected_type=type_hints["volume"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "path": path,
            "volume": volume,
        }
        if propagation is not None:
            self._values["propagation"] = propagation
        if read_only is not None:
            self._values["read_only"] = read_only
        if sub_path is not None:
            self._values["sub_path"] = sub_path
        if sub_path_expr is not None:
            self._values["sub_path_expr"] = sub_path_expr

    @builtins.property
    def propagation(self) -> typing.Optional[MountPropagation]:
        '''Determines how mounts are propagated from the host to container and the other way around.

        When not set, MountPropagationNone is used.

        Mount propagation allows for sharing volumes mounted by a Container to
        other Containers in the same Pod, or even to other Pods on the same node.

        :default: MountPropagation.NONE
        '''
        result = self._values.get("propagation")
        return typing.cast(typing.Optional[MountPropagation], result)

    @builtins.property
    def read_only(self) -> typing.Optional[builtins.bool]:
        '''Mounted read-only if true, read-write otherwise (false or unspecified).

        Defaults to false.

        :default: false
        '''
        result = self._values.get("read_only")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def sub_path(self) -> typing.Optional[builtins.str]:
        '''Path within the volume from which the container's volume should be mounted.).

        :default: "" the volume's root
        '''
        result = self._values.get("sub_path")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def sub_path_expr(self) -> typing.Optional[builtins.str]:
        '''Expanded path within the volume from which the container's volume should be mounted.

        Behaves similarly to SubPath but environment variable references
        $(VAR_NAME) are expanded using the container's environment. Defaults to ""
        (volume's root).

        ``subPathExpr`` and ``subPath`` are mutually exclusive.

        :default: "" volume's root.
        '''
        result = self._values.get("sub_path_expr")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def path(self) -> builtins.str:
        '''Path within the container at which the volume should be mounted.

        Must not
        contain ':'.
        '''
        result = self._values.get("path")
        assert result is not None, "Required property 'path' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def volume(self) -> Volume:
        '''The volume to mount.'''
        result = self._values.get("volume")
        assert result is not None, "Required property 'volume' is missing"
        return typing.cast(Volume, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "VolumeMount(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class WorkloadScheduling(
    PodScheduling,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-24.WorkloadScheduling",
):
    '''Controls the pod scheduling strategy of this workload.

    It offers some additional API's on top of the core pod scheduling.
    '''

    def __init__(self, instance: "AbstractPod") -> None:
        '''
        :param instance: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__fc88c4ec73ec6d1141af956e674b1fb3d0115ba0e42413ff3d57ea1a73c295f6)
            check_type(argname="argument instance", value=instance, expected_type=type_hints["instance"])
        jsii.create(self.__class__, self, [instance])

    @jsii.member(jsii_name="spread")
    def spread(
        self,
        *,
        topology: typing.Optional[Topology] = None,
        weight: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''Spread the pods in this workload by the topology key.

        A spread is a separation of the pod from itself and is used to
        balance out pod replicas across a given topology.

        :param topology: Which topology to spread on. Default: - Topology.HOSTNAME
        :param weight: Indicates the spread is optional, with this weight score. Default: - no weight. spread is assumed to be required.
        '''
        options = WorkloadSchedulingSpreadOptions(topology=topology, weight=weight)

        return typing.cast(None, jsii.invoke(self, "spread", [options]))


@jsii.data_type(
    jsii_type="cdk8s-plus-24.WorkloadSchedulingSpreadOptions",
    jsii_struct_bases=[],
    name_mapping={"topology": "topology", "weight": "weight"},
)
class WorkloadSchedulingSpreadOptions:
    def __init__(
        self,
        *,
        topology: typing.Optional[Topology] = None,
        weight: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''Options for ``WorkloadScheduling.spread``.

        :param topology: Which topology to spread on. Default: - Topology.HOSTNAME
        :param weight: Indicates the spread is optional, with this weight score. Default: - no weight. spread is assumed to be required.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__caa43e4dfb9dabe201adf8637ec01cd66569c0246dc721a328f60a84a2980b38)
            check_type(argname="argument topology", value=topology, expected_type=type_hints["topology"])
            check_type(argname="argument weight", value=weight, expected_type=type_hints["weight"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if topology is not None:
            self._values["topology"] = topology
        if weight is not None:
            self._values["weight"] = weight

    @builtins.property
    def topology(self) -> typing.Optional[Topology]:
        '''Which topology to spread on.

        :default: - Topology.HOSTNAME
        '''
        result = self._values.get("topology")
        return typing.cast(typing.Optional[Topology], result)

    @builtins.property
    def weight(self) -> typing.Optional[jsii.Number]:
        '''Indicates the spread is optional, with this weight score.

        :default: - no weight. spread is assumed to be required.
        '''
        result = self._values.get("weight")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "WorkloadSchedulingSpreadOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(IPodSelector, INetworkPolicyPeer, ISubject)
class AbstractPod(
    Resource,
    metaclass=jsii.JSIIAbstractClass,
    jsii_type="cdk8s-plus-24.AbstractPod",
):
    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        automount_service_account_token: typing.Optional[builtins.bool] = None,
        containers: typing.Optional[typing.Sequence[typing.Union[ContainerProps, typing.Dict[builtins.str, typing.Any]]]] = None,
        dns: typing.Optional[typing.Union[PodDnsProps, typing.Dict[builtins.str, typing.Any]]] = None,
        docker_registry_auth: typing.Optional[ISecret] = None,
        host_aliases: typing.Optional[typing.Sequence[typing.Union[HostAlias, typing.Dict[builtins.str, typing.Any]]]] = None,
        host_network: typing.Optional[builtins.bool] = None,
        init_containers: typing.Optional[typing.Sequence[typing.Union[ContainerProps, typing.Dict[builtins.str, typing.Any]]]] = None,
        isolate: typing.Optional[builtins.bool] = None,
        restart_policy: typing.Optional[RestartPolicy] = None,
        security_context: typing.Optional[typing.Union[PodSecurityContextProps, typing.Dict[builtins.str, typing.Any]]] = None,
        service_account: typing.Optional["IServiceAccount"] = None,
        termination_grace_period: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        volumes: typing.Optional[typing.Sequence[Volume]] = None,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param automount_service_account_token: Indicates whether a service account token should be automatically mounted. Default: false
        :param containers: List of containers belonging to the pod. Containers cannot currently be added or removed. There must be at least one container in a Pod. You can add additionnal containers using ``podSpec.addContainer()`` Default: - No containers. Note that a pod spec must include at least one container.
        :param dns: DNS settings for the pod. Default: policy: DnsPolicy.CLUSTER_FIRST hostnameAsFQDN: false
        :param docker_registry_auth: A secret containing docker credentials for authenticating to a registry. Default: - No auth. Images are assumed to be publicly available.
        :param host_aliases: HostAlias holds the mapping between IP and hostnames that will be injected as an entry in the pod's hosts file.
        :param host_network: Host network for the pod. Default: false
        :param init_containers: List of initialization containers belonging to the pod. Init containers are executed in order prior to containers being started. If any init container fails, the pod is considered to have failed and is handled according to its restartPolicy. The name for an init container or normal container must be unique among all containers. Init containers may not have Lifecycle actions, Readiness probes, Liveness probes, or Startup probes. The resourceRequirements of an init container are taken into account during scheduling by finding the highest request/limit for each resource type, and then using the max of of that value or the sum of the normal containers. Limits are applied to init containers in a similar fashion. Init containers cannot currently be added ,removed or updated. Default: - No init containers.
        :param isolate: Isolates the pod. This will prevent any ingress or egress connections to / from this pod. You can however allow explicit connections post instantiation by using the ``.connections`` property. Default: false
        :param restart_policy: Restart policy for all containers within the pod. Default: RestartPolicy.ALWAYS
        :param security_context: SecurityContext holds pod-level security attributes and common container settings. Default: fsGroupChangePolicy: FsGroupChangePolicy.FsGroupChangePolicy.ALWAYS ensureNonRoot: true
        :param service_account: A service account provides an identity for processes that run in a Pod. When you (a human) access the cluster (for example, using kubectl), you are authenticated by the apiserver as a particular User Account (currently this is usually admin, unless your cluster administrator has customized your cluster). Processes in containers inside pods can also contact the apiserver. When they do, they are authenticated as a particular Service Account (for example, default). Default: - No service account.
        :param termination_grace_period: Grace period until the pod is terminated. Default: Duration.seconds(30)
        :param volumes: List of volumes that can be mounted by containers belonging to the pod. You can also add volumes later using ``podSpec.addVolume()`` Default: - No volumes.
        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a6a47a654b1cacd0de7310ce43c11d92e36b0e05ee1964b8ad214b980cd96daf)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = AbstractPodProps(
            automount_service_account_token=automount_service_account_token,
            containers=containers,
            dns=dns,
            docker_registry_auth=docker_registry_auth,
            host_aliases=host_aliases,
            host_network=host_network,
            init_containers=init_containers,
            isolate=isolate,
            restart_policy=restart_policy,
            security_context=security_context,
            service_account=service_account,
            termination_grace_period=termination_grace_period,
            volumes=volumes,
            metadata=metadata,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="addContainer")
    def add_container(
        self,
        *,
        image: builtins.str,
        args: typing.Optional[typing.Sequence[builtins.str]] = None,
        command: typing.Optional[typing.Sequence[builtins.str]] = None,
        env_from: typing.Optional[typing.Sequence[EnvFrom]] = None,
        env_variables: typing.Optional[typing.Mapping[builtins.str, EnvValue]] = None,
        image_pull_policy: typing.Optional[ImagePullPolicy] = None,
        lifecycle: typing.Optional[typing.Union[ContainerLifecycle, typing.Dict[builtins.str, typing.Any]]] = None,
        liveness: typing.Optional[Probe] = None,
        name: typing.Optional[builtins.str] = None,
        port: typing.Optional[jsii.Number] = None,
        port_number: typing.Optional[jsii.Number] = None,
        ports: typing.Optional[typing.Sequence[typing.Union[ContainerPort, typing.Dict[builtins.str, typing.Any]]]] = None,
        readiness: typing.Optional[Probe] = None,
        resources: typing.Optional[typing.Union[ContainerResources, typing.Dict[builtins.str, typing.Any]]] = None,
        security_context: typing.Optional[typing.Union[ContainerSecurityContextProps, typing.Dict[builtins.str, typing.Any]]] = None,
        startup: typing.Optional[Probe] = None,
        volume_mounts: typing.Optional[typing.Sequence[typing.Union[VolumeMount, typing.Dict[builtins.str, typing.Any]]]] = None,
        working_dir: typing.Optional[builtins.str] = None,
    ) -> Container:
        '''
        :param image: Docker image name.
        :param args: Arguments to the entrypoint. The docker image's CMD is used if ``command`` is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. Default: []
        :param command: Entrypoint array. Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell Default: - The docker image's ENTRYPOINT.
        :param env_from: List of sources to populate environment variables in the container. When a key exists in multiple sources, the value associated with the last source will take precedence. Values defined by the ``envVariables`` property with a duplicate key will take precedence. Default: - No sources.
        :param env_variables: Environment variables to set in the container. Default: - No environment variables.
        :param image_pull_policy: Image pull policy for this container. Default: ImagePullPolicy.ALWAYS
        :param lifecycle: Describes actions that the management system should take in response to container lifecycle events.
        :param liveness: Periodic probe of container liveness. Container will be restarted if the probe fails. Default: - no liveness probe is defined
        :param name: Name of the container specified as a DNS_LABEL. Each container in a pod must have a unique name (DNS_LABEL). Cannot be updated. Default: 'main'
        :param port: 
        :param port_number: Number of port to expose on the pod's IP address. This must be a valid port number, 0 < x < 65536. This is a convinience property if all you need a single TCP numbered port. In case more advanced configuartion is required, use the ``ports`` property. This port is added to the list of ports mentioned in the ``ports`` property. Default: - Only the ports mentiond in the ``ports`` property are exposed.
        :param ports: List of ports to expose from this container. Default: - Only the port mentioned in the ``portNumber`` property is exposed.
        :param readiness: Determines when the container is ready to serve traffic. Default: - no readiness probe is defined
        :param resources: Compute resources (CPU and memory requests and limits) required by the container. Default: cpu: request: 1000 millis limit: 1500 millis memory: request: 512 mebibytes limit: 2048 mebibytes
        :param security_context: SecurityContext defines the security options the container should be run with. If set, the fields override equivalent fields of the pod's security context. Default: ensureNonRoot: true privileged: false readOnlyRootFilesystem: true allowPrivilegeEscalation: false user: 25000 group: 26000
        :param startup: StartupProbe indicates that the Pod has successfully initialized. If specified, no other probes are executed until this completes successfully Default: - If a port is provided, then knocks on that port to determine when the container is ready for readiness and liveness probe checks. Otherwise, no startup probe is defined.
        :param volume_mounts: Pod volumes to mount into the container's filesystem. Cannot be updated.
        :param working_dir: Container's working directory. If not specified, the container runtime's default will be used, which might be configured in the container image. Cannot be updated. Default: - The container runtime's default.
        '''
        cont = ContainerProps(
            image=image,
            args=args,
            command=command,
            env_from=env_from,
            env_variables=env_variables,
            image_pull_policy=image_pull_policy,
            lifecycle=lifecycle,
            liveness=liveness,
            name=name,
            port=port,
            port_number=port_number,
            ports=ports,
            readiness=readiness,
            resources=resources,
            security_context=security_context,
            startup=startup,
            volume_mounts=volume_mounts,
            working_dir=working_dir,
        )

        return typing.cast(Container, jsii.invoke(self, "addContainer", [cont]))

    @jsii.member(jsii_name="addHostAlias")
    def add_host_alias(
        self,
        *,
        hostnames: typing.Sequence[builtins.str],
        ip: builtins.str,
    ) -> None:
        '''
        :param hostnames: Hostnames for the chosen IP address.
        :param ip: IP address of the host file entry.
        '''
        host_alias = HostAlias(hostnames=hostnames, ip=ip)

        return typing.cast(None, jsii.invoke(self, "addHostAlias", [host_alias]))

    @jsii.member(jsii_name="addInitContainer")
    def add_init_container(
        self,
        *,
        image: builtins.str,
        args: typing.Optional[typing.Sequence[builtins.str]] = None,
        command: typing.Optional[typing.Sequence[builtins.str]] = None,
        env_from: typing.Optional[typing.Sequence[EnvFrom]] = None,
        env_variables: typing.Optional[typing.Mapping[builtins.str, EnvValue]] = None,
        image_pull_policy: typing.Optional[ImagePullPolicy] = None,
        lifecycle: typing.Optional[typing.Union[ContainerLifecycle, typing.Dict[builtins.str, typing.Any]]] = None,
        liveness: typing.Optional[Probe] = None,
        name: typing.Optional[builtins.str] = None,
        port: typing.Optional[jsii.Number] = None,
        port_number: typing.Optional[jsii.Number] = None,
        ports: typing.Optional[typing.Sequence[typing.Union[ContainerPort, typing.Dict[builtins.str, typing.Any]]]] = None,
        readiness: typing.Optional[Probe] = None,
        resources: typing.Optional[typing.Union[ContainerResources, typing.Dict[builtins.str, typing.Any]]] = None,
        security_context: typing.Optional[typing.Union[ContainerSecurityContextProps, typing.Dict[builtins.str, typing.Any]]] = None,
        startup: typing.Optional[Probe] = None,
        volume_mounts: typing.Optional[typing.Sequence[typing.Union[VolumeMount, typing.Dict[builtins.str, typing.Any]]]] = None,
        working_dir: typing.Optional[builtins.str] = None,
    ) -> Container:
        '''
        :param image: Docker image name.
        :param args: Arguments to the entrypoint. The docker image's CMD is used if ``command`` is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. Default: []
        :param command: Entrypoint array. Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell Default: - The docker image's ENTRYPOINT.
        :param env_from: List of sources to populate environment variables in the container. When a key exists in multiple sources, the value associated with the last source will take precedence. Values defined by the ``envVariables`` property with a duplicate key will take precedence. Default: - No sources.
        :param env_variables: Environment variables to set in the container. Default: - No environment variables.
        :param image_pull_policy: Image pull policy for this container. Default: ImagePullPolicy.ALWAYS
        :param lifecycle: Describes actions that the management system should take in response to container lifecycle events.
        :param liveness: Periodic probe of container liveness. Container will be restarted if the probe fails. Default: - no liveness probe is defined
        :param name: Name of the container specified as a DNS_LABEL. Each container in a pod must have a unique name (DNS_LABEL). Cannot be updated. Default: 'main'
        :param port: 
        :param port_number: Number of port to expose on the pod's IP address. This must be a valid port number, 0 < x < 65536. This is a convinience property if all you need a single TCP numbered port. In case more advanced configuartion is required, use the ``ports`` property. This port is added to the list of ports mentioned in the ``ports`` property. Default: - Only the ports mentiond in the ``ports`` property are exposed.
        :param ports: List of ports to expose from this container. Default: - Only the port mentioned in the ``portNumber`` property is exposed.
        :param readiness: Determines when the container is ready to serve traffic. Default: - no readiness probe is defined
        :param resources: Compute resources (CPU and memory requests and limits) required by the container. Default: cpu: request: 1000 millis limit: 1500 millis memory: request: 512 mebibytes limit: 2048 mebibytes
        :param security_context: SecurityContext defines the security options the container should be run with. If set, the fields override equivalent fields of the pod's security context. Default: ensureNonRoot: true privileged: false readOnlyRootFilesystem: true allowPrivilegeEscalation: false user: 25000 group: 26000
        :param startup: StartupProbe indicates that the Pod has successfully initialized. If specified, no other probes are executed until this completes successfully Default: - If a port is provided, then knocks on that port to determine when the container is ready for readiness and liveness probe checks. Otherwise, no startup probe is defined.
        :param volume_mounts: Pod volumes to mount into the container's filesystem. Cannot be updated.
        :param working_dir: Container's working directory. If not specified, the container runtime's default will be used, which might be configured in the container image. Cannot be updated. Default: - The container runtime's default.
        '''
        cont = ContainerProps(
            image=image,
            args=args,
            command=command,
            env_from=env_from,
            env_variables=env_variables,
            image_pull_policy=image_pull_policy,
            lifecycle=lifecycle,
            liveness=liveness,
            name=name,
            port=port,
            port_number=port_number,
            ports=ports,
            readiness=readiness,
            resources=resources,
            security_context=security_context,
            startup=startup,
            volume_mounts=volume_mounts,
            working_dir=working_dir,
        )

        return typing.cast(Container, jsii.invoke(self, "addInitContainer", [cont]))

    @jsii.member(jsii_name="addVolume")
    def add_volume(self, vol: Volume) -> None:
        '''
        :param vol: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__cdf2146cbd55f2e7db927c650c9cf33cc44c093950b0e7b0c2c1c61a9905871d)
            check_type(argname="argument vol", value=vol, expected_type=type_hints["vol"])
        return typing.cast(None, jsii.invoke(self, "addVolume", [vol]))

    @jsii.member(jsii_name="attachContainer")
    def attach_container(self, cont: Container) -> None:
        '''
        :param cont: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__03abc74c3ba0c32808cf7edb90fd1c4ec639a353adc5ffa644582de196df559c)
            check_type(argname="argument cont", value=cont, expected_type=type_hints["cont"])
        return typing.cast(None, jsii.invoke(self, "attachContainer", [cont]))

    @jsii.member(jsii_name="toNetworkPolicyPeerConfig")
    def to_network_policy_peer_config(self) -> NetworkPolicyPeerConfig:
        '''Return the configuration of this peer.

        :see: INetworkPolicyPeer.toNetworkPolicyPeerConfig()
        '''
        return typing.cast(NetworkPolicyPeerConfig, jsii.invoke(self, "toNetworkPolicyPeerConfig", []))

    @jsii.member(jsii_name="toPodSelector")
    def to_pod_selector(self) -> typing.Optional[IPodSelector]:
        '''Convert the peer into a pod selector, if possible.

        :see: INetworkPolicyPeer.toPodSelector()
        '''
        return typing.cast(typing.Optional[IPodSelector], jsii.invoke(self, "toPodSelector", []))

    @jsii.member(jsii_name="toPodSelectorConfig")
    def to_pod_selector_config(self) -> PodSelectorConfig:
        '''Return the configuration of this selector.

        :see: IPodSelector.toPodSelectorConfig()
        '''
        return typing.cast(PodSelectorConfig, jsii.invoke(self, "toPodSelectorConfig", []))

    @jsii.member(jsii_name="toSubjectConfiguration")
    def to_subject_configuration(self) -> SubjectConfiguration:
        '''Return the subject configuration.

        :see: ISubect.toSubjectConfiguration()
        '''
        return typing.cast(SubjectConfiguration, jsii.invoke(self, "toSubjectConfiguration", []))

    @builtins.property
    @jsii.member(jsii_name="automountServiceAccountToken")
    def automount_service_account_token(self) -> builtins.bool:
        return typing.cast(builtins.bool, jsii.get(self, "automountServiceAccountToken"))

    @builtins.property
    @jsii.member(jsii_name="containers")
    def containers(self) -> typing.List[Container]:
        return typing.cast(typing.List[Container], jsii.get(self, "containers"))

    @builtins.property
    @jsii.member(jsii_name="dns")
    def dns(self) -> PodDns:
        return typing.cast(PodDns, jsii.get(self, "dns"))

    @builtins.property
    @jsii.member(jsii_name="hostAliases")
    def host_aliases(self) -> typing.List[HostAlias]:
        return typing.cast(typing.List[HostAlias], jsii.get(self, "hostAliases"))

    @builtins.property
    @jsii.member(jsii_name="initContainers")
    def init_containers(self) -> typing.List[Container]:
        return typing.cast(typing.List[Container], jsii.get(self, "initContainers"))

    @builtins.property
    @jsii.member(jsii_name="isolate")
    def _isolate(self) -> builtins.bool:
        return typing.cast(builtins.bool, jsii.get(self, "isolate"))

    @builtins.property
    @jsii.member(jsii_name="podMetadata")
    @abc.abstractmethod
    def pod_metadata(self) -> _cdk8s_d3d9af27.ApiObjectMetadataDefinition:
        ...

    @builtins.property
    @jsii.member(jsii_name="securityContext")
    def security_context(self) -> PodSecurityContext:
        return typing.cast(PodSecurityContext, jsii.get(self, "securityContext"))

    @builtins.property
    @jsii.member(jsii_name="volumes")
    def volumes(self) -> typing.List[Volume]:
        return typing.cast(typing.List[Volume], jsii.get(self, "volumes"))

    @builtins.property
    @jsii.member(jsii_name="dockerRegistryAuth")
    def docker_registry_auth(self) -> typing.Optional[ISecret]:
        return typing.cast(typing.Optional[ISecret], jsii.get(self, "dockerRegistryAuth"))

    @builtins.property
    @jsii.member(jsii_name="hostNetwork")
    def host_network(self) -> typing.Optional[builtins.bool]:
        return typing.cast(typing.Optional[builtins.bool], jsii.get(self, "hostNetwork"))

    @builtins.property
    @jsii.member(jsii_name="restartPolicy")
    def restart_policy(self) -> typing.Optional[RestartPolicy]:
        return typing.cast(typing.Optional[RestartPolicy], jsii.get(self, "restartPolicy"))

    @builtins.property
    @jsii.member(jsii_name="serviceAccount")
    def service_account(self) -> typing.Optional["IServiceAccount"]:
        return typing.cast(typing.Optional["IServiceAccount"], jsii.get(self, "serviceAccount"))

    @builtins.property
    @jsii.member(jsii_name="terminationGracePeriod")
    def termination_grace_period(self) -> typing.Optional[_cdk8s_d3d9af27.Duration]:
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Duration], jsii.get(self, "terminationGracePeriod"))


class _AbstractPodProxy(
    AbstractPod,
    jsii.proxy_for(Resource), # type: ignore[misc]
):
    @builtins.property
    @jsii.member(jsii_name="podMetadata")
    def pod_metadata(self) -> _cdk8s_d3d9af27.ApiObjectMetadataDefinition:
        return typing.cast(_cdk8s_d3d9af27.ApiObjectMetadataDefinition, jsii.get(self, "podMetadata"))

# Adding a "__jsii_proxy_class__(): typing.Type" function to the abstract class
typing.cast(typing.Any, AbstractPod).__jsii_proxy_class__ = lambda : _AbstractPodProxy


@jsii.data_type(
    jsii_type="cdk8s-plus-24.AbstractPodProps",
    jsii_struct_bases=[ResourceProps],
    name_mapping={
        "metadata": "metadata",
        "automount_service_account_token": "automountServiceAccountToken",
        "containers": "containers",
        "dns": "dns",
        "docker_registry_auth": "dockerRegistryAuth",
        "host_aliases": "hostAliases",
        "host_network": "hostNetwork",
        "init_containers": "initContainers",
        "isolate": "isolate",
        "restart_policy": "restartPolicy",
        "security_context": "securityContext",
        "service_account": "serviceAccount",
        "termination_grace_period": "terminationGracePeriod",
        "volumes": "volumes",
    },
)
class AbstractPodProps(ResourceProps):
    def __init__(
        self,
        *,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        automount_service_account_token: typing.Optional[builtins.bool] = None,
        containers: typing.Optional[typing.Sequence[typing.Union[ContainerProps, typing.Dict[builtins.str, typing.Any]]]] = None,
        dns: typing.Optional[typing.Union[PodDnsProps, typing.Dict[builtins.str, typing.Any]]] = None,
        docker_registry_auth: typing.Optional[ISecret] = None,
        host_aliases: typing.Optional[typing.Sequence[typing.Union[HostAlias, typing.Dict[builtins.str, typing.Any]]]] = None,
        host_network: typing.Optional[builtins.bool] = None,
        init_containers: typing.Optional[typing.Sequence[typing.Union[ContainerProps, typing.Dict[builtins.str, typing.Any]]]] = None,
        isolate: typing.Optional[builtins.bool] = None,
        restart_policy: typing.Optional[RestartPolicy] = None,
        security_context: typing.Optional[typing.Union[PodSecurityContextProps, typing.Dict[builtins.str, typing.Any]]] = None,
        service_account: typing.Optional["IServiceAccount"] = None,
        termination_grace_period: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        volumes: typing.Optional[typing.Sequence[Volume]] = None,
    ) -> None:
        '''Properties for ``AbstractPod``.

        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        :param automount_service_account_token: Indicates whether a service account token should be automatically mounted. Default: false
        :param containers: List of containers belonging to the pod. Containers cannot currently be added or removed. There must be at least one container in a Pod. You can add additionnal containers using ``podSpec.addContainer()`` Default: - No containers. Note that a pod spec must include at least one container.
        :param dns: DNS settings for the pod. Default: policy: DnsPolicy.CLUSTER_FIRST hostnameAsFQDN: false
        :param docker_registry_auth: A secret containing docker credentials for authenticating to a registry. Default: - No auth. Images are assumed to be publicly available.
        :param host_aliases: HostAlias holds the mapping between IP and hostnames that will be injected as an entry in the pod's hosts file.
        :param host_network: Host network for the pod. Default: false
        :param init_containers: List of initialization containers belonging to the pod. Init containers are executed in order prior to containers being started. If any init container fails, the pod is considered to have failed and is handled according to its restartPolicy. The name for an init container or normal container must be unique among all containers. Init containers may not have Lifecycle actions, Readiness probes, Liveness probes, or Startup probes. The resourceRequirements of an init container are taken into account during scheduling by finding the highest request/limit for each resource type, and then using the max of of that value or the sum of the normal containers. Limits are applied to init containers in a similar fashion. Init containers cannot currently be added ,removed or updated. Default: - No init containers.
        :param isolate: Isolates the pod. This will prevent any ingress or egress connections to / from this pod. You can however allow explicit connections post instantiation by using the ``.connections`` property. Default: false
        :param restart_policy: Restart policy for all containers within the pod. Default: RestartPolicy.ALWAYS
        :param security_context: SecurityContext holds pod-level security attributes and common container settings. Default: fsGroupChangePolicy: FsGroupChangePolicy.FsGroupChangePolicy.ALWAYS ensureNonRoot: true
        :param service_account: A service account provides an identity for processes that run in a Pod. When you (a human) access the cluster (for example, using kubectl), you are authenticated by the apiserver as a particular User Account (currently this is usually admin, unless your cluster administrator has customized your cluster). Processes in containers inside pods can also contact the apiserver. When they do, they are authenticated as a particular Service Account (for example, default). Default: - No service account.
        :param termination_grace_period: Grace period until the pod is terminated. Default: Duration.seconds(30)
        :param volumes: List of volumes that can be mounted by containers belonging to the pod. You can also add volumes later using ``podSpec.addVolume()`` Default: - No volumes.
        '''
        if isinstance(metadata, dict):
            metadata = _cdk8s_d3d9af27.ApiObjectMetadata(**metadata)
        if isinstance(dns, dict):
            dns = PodDnsProps(**dns)
        if isinstance(security_context, dict):
            security_context = PodSecurityContextProps(**security_context)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5d48fccfee5b9ae21d8a03c6d2a2da8a6eac369004270df667f56fc1a55c67ef)
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument automount_service_account_token", value=automount_service_account_token, expected_type=type_hints["automount_service_account_token"])
            check_type(argname="argument containers", value=containers, expected_type=type_hints["containers"])
            check_type(argname="argument dns", value=dns, expected_type=type_hints["dns"])
            check_type(argname="argument docker_registry_auth", value=docker_registry_auth, expected_type=type_hints["docker_registry_auth"])
            check_type(argname="argument host_aliases", value=host_aliases, expected_type=type_hints["host_aliases"])
            check_type(argname="argument host_network", value=host_network, expected_type=type_hints["host_network"])
            check_type(argname="argument init_containers", value=init_containers, expected_type=type_hints["init_containers"])
            check_type(argname="argument isolate", value=isolate, expected_type=type_hints["isolate"])
            check_type(argname="argument restart_policy", value=restart_policy, expected_type=type_hints["restart_policy"])
            check_type(argname="argument security_context", value=security_context, expected_type=type_hints["security_context"])
            check_type(argname="argument service_account", value=service_account, expected_type=type_hints["service_account"])
            check_type(argname="argument termination_grace_period", value=termination_grace_period, expected_type=type_hints["termination_grace_period"])
            check_type(argname="argument volumes", value=volumes, expected_type=type_hints["volumes"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if metadata is not None:
            self._values["metadata"] = metadata
        if automount_service_account_token is not None:
            self._values["automount_service_account_token"] = automount_service_account_token
        if containers is not None:
            self._values["containers"] = containers
        if dns is not None:
            self._values["dns"] = dns
        if docker_registry_auth is not None:
            self._values["docker_registry_auth"] = docker_registry_auth
        if host_aliases is not None:
            self._values["host_aliases"] = host_aliases
        if host_network is not None:
            self._values["host_network"] = host_network
        if init_containers is not None:
            self._values["init_containers"] = init_containers
        if isolate is not None:
            self._values["isolate"] = isolate
        if restart_policy is not None:
            self._values["restart_policy"] = restart_policy
        if security_context is not None:
            self._values["security_context"] = security_context
        if service_account is not None:
            self._values["service_account"] = service_account
        if termination_grace_period is not None:
            self._values["termination_grace_period"] = termination_grace_period
        if volumes is not None:
            self._values["volumes"] = volumes

    @builtins.property
    def metadata(self) -> typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata]:
        '''Metadata that all persisted resources must have, which includes all objects users must create.'''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata], result)

    @builtins.property
    def automount_service_account_token(self) -> typing.Optional[builtins.bool]:
        '''Indicates whether a service account token should be automatically mounted.

        :default: false

        :see: https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/#use-the-default-service-account-to-access-the-api-server
        '''
        result = self._values.get("automount_service_account_token")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def containers(self) -> typing.Optional[typing.List[ContainerProps]]:
        '''List of containers belonging to the pod.

        Containers cannot currently be
        added or removed. There must be at least one container in a Pod.

        You can add additionnal containers using ``podSpec.addContainer()``

        :default: - No containers. Note that a pod spec must include at least one container.
        '''
        result = self._values.get("containers")
        return typing.cast(typing.Optional[typing.List[ContainerProps]], result)

    @builtins.property
    def dns(self) -> typing.Optional[PodDnsProps]:
        '''DNS settings for the pod.

        :default:

        policy: DnsPolicy.CLUSTER_FIRST
        hostnameAsFQDN: false

        :see: https://kubernetes.io/docs/concepts/services-networking/dns-pod-service/
        '''
        result = self._values.get("dns")
        return typing.cast(typing.Optional[PodDnsProps], result)

    @builtins.property
    def docker_registry_auth(self) -> typing.Optional[ISecret]:
        '''A secret containing docker credentials for authenticating to a registry.

        :default: - No auth. Images are assumed to be publicly available.
        '''
        result = self._values.get("docker_registry_auth")
        return typing.cast(typing.Optional[ISecret], result)

    @builtins.property
    def host_aliases(self) -> typing.Optional[typing.List[HostAlias]]:
        '''HostAlias holds the mapping between IP and hostnames that will be injected as an entry in the pod's hosts file.

        :schema: io.k8s.api.core.v1.HostAlias
        '''
        result = self._values.get("host_aliases")
        return typing.cast(typing.Optional[typing.List[HostAlias]], result)

    @builtins.property
    def host_network(self) -> typing.Optional[builtins.bool]:
        '''Host network for the pod.

        :default: false
        '''
        result = self._values.get("host_network")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def init_containers(self) -> typing.Optional[typing.List[ContainerProps]]:
        '''List of initialization containers belonging to the pod.

        Init containers are executed in order prior to containers being started.
        If any init container fails, the pod is considered to have failed and is handled according to its restartPolicy.
        The name for an init container or normal container must be unique among all containers.
        Init containers may not have Lifecycle actions, Readiness probes, Liveness probes, or Startup probes.
        The resourceRequirements of an init container are taken into account during scheduling by finding the highest request/limit
        for each resource type, and then using the max of of that value or the sum of the normal containers.
        Limits are applied to init containers in a similar fashion.

        Init containers cannot currently be added ,removed or updated.

        :default: - No init containers.

        :see: https://kubernetes.io/docs/concepts/workloads/pods/init-containers/
        '''
        result = self._values.get("init_containers")
        return typing.cast(typing.Optional[typing.List[ContainerProps]], result)

    @builtins.property
    def isolate(self) -> typing.Optional[builtins.bool]:
        '''Isolates the pod.

        This will prevent any ingress or egress connections to / from this pod.
        You can however allow explicit connections post instantiation by using the ``.connections`` property.

        :default: false
        '''
        result = self._values.get("isolate")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def restart_policy(self) -> typing.Optional[RestartPolicy]:
        '''Restart policy for all containers within the pod.

        :default: RestartPolicy.ALWAYS

        :see: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle/#restart-policy
        '''
        result = self._values.get("restart_policy")
        return typing.cast(typing.Optional[RestartPolicy], result)

    @builtins.property
    def security_context(self) -> typing.Optional[PodSecurityContextProps]:
        '''SecurityContext holds pod-level security attributes and common container settings.

        :default:

        fsGroupChangePolicy: FsGroupChangePolicy.FsGroupChangePolicy.ALWAYS
        ensureNonRoot: true
        '''
        result = self._values.get("security_context")
        return typing.cast(typing.Optional[PodSecurityContextProps], result)

    @builtins.property
    def service_account(self) -> typing.Optional["IServiceAccount"]:
        '''A service account provides an identity for processes that run in a Pod.

        When you (a human) access the cluster (for example, using kubectl), you are
        authenticated by the apiserver as a particular User Account (currently this
        is usually admin, unless your cluster administrator has customized your
        cluster). Processes in containers inside pods can also contact the
        apiserver. When they do, they are authenticated as a particular Service
        Account (for example, default).

        :default: - No service account.

        :see: https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/
        '''
        result = self._values.get("service_account")
        return typing.cast(typing.Optional["IServiceAccount"], result)

    @builtins.property
    def termination_grace_period(self) -> typing.Optional[_cdk8s_d3d9af27.Duration]:
        '''Grace period until the pod is terminated.

        :default: Duration.seconds(30)
        '''
        result = self._values.get("termination_grace_period")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Duration], result)

    @builtins.property
    def volumes(self) -> typing.Optional[typing.List[Volume]]:
        '''List of volumes that can be mounted by containers belonging to the pod.

        You can also add volumes later using ``podSpec.addVolume()``

        :default: - No volumes.

        :see: https://kubernetes.io/docs/concepts/storage/volumes
        '''
        result = self._values.get("volumes")
        return typing.cast(typing.Optional[typing.List[Volume]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AbstractPodProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.AddDeploymentOptions",
    jsii_struct_bases=[ServiceBindOptions],
    name_mapping={
        "name": "name",
        "node_port": "nodePort",
        "protocol": "protocol",
        "target_port": "targetPort",
        "port": "port",
    },
)
class AddDeploymentOptions(ServiceBindOptions):
    def __init__(
        self,
        *,
        name: typing.Optional[builtins.str] = None,
        node_port: typing.Optional[jsii.Number] = None,
        protocol: typing.Optional[Protocol] = None,
        target_port: typing.Optional[jsii.Number] = None,
        port: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''Options to add a deployment to a service.

        :param name: The name of this port within the service. This must be a DNS_LABEL. All ports within a ServiceSpec must have unique names. This maps to the 'Name' field in EndpointPort objects. Optional if only one ServicePort is defined on this service.
        :param node_port: The port on each node on which this service is exposed when type=NodePort or LoadBalancer. Usually assigned by the system. If specified, it will be allocated to the service if unused or else creation of the service will fail. Default is to auto-allocate a port if the ServiceType of this Service requires one. Default: - auto-allocate a port if the ServiceType of this Service requires one.
        :param protocol: The IP protocol for this port. Supports "TCP", "UDP", and "SCTP". Default is TCP. Default: Protocol.TCP
        :param target_port: The port number the service will redirect to. Default: - The value of ``port`` will be used.
        :param port: The port number the service will bind to. Default: - Copied from the first container of the deployment.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6aab0ccb633fcb5309d4ddc3bfaab03758d9e2e85f6632cb5a76fdc6ba6eb5f5)
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument node_port", value=node_port, expected_type=type_hints["node_port"])
            check_type(argname="argument protocol", value=protocol, expected_type=type_hints["protocol"])
            check_type(argname="argument target_port", value=target_port, expected_type=type_hints["target_port"])
            check_type(argname="argument port", value=port, expected_type=type_hints["port"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if name is not None:
            self._values["name"] = name
        if node_port is not None:
            self._values["node_port"] = node_port
        if protocol is not None:
            self._values["protocol"] = protocol
        if target_port is not None:
            self._values["target_port"] = target_port
        if port is not None:
            self._values["port"] = port

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''The name of this port within the service.

        This must be a DNS_LABEL. All
        ports within a ServiceSpec must have unique names. This maps to the 'Name'
        field in EndpointPort objects. Optional if only one ServicePort is defined
        on this service.
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def node_port(self) -> typing.Optional[jsii.Number]:
        '''The port on each node on which this service is exposed when type=NodePort or LoadBalancer.

        Usually assigned by the system. If specified, it will be
        allocated to the service if unused or else creation of the service will
        fail. Default is to auto-allocate a port if the ServiceType of this Service
        requires one.

        :default: - auto-allocate a port if the ServiceType of this Service requires one.

        :see: https://kubernetes.io/docs/concepts/services-networking/service/#type-nodeport
        '''
        result = self._values.get("node_port")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def protocol(self) -> typing.Optional[Protocol]:
        '''The IP protocol for this port.

        Supports "TCP", "UDP", and "SCTP". Default is TCP.

        :default: Protocol.TCP
        '''
        result = self._values.get("protocol")
        return typing.cast(typing.Optional[Protocol], result)

    @builtins.property
    def target_port(self) -> typing.Optional[jsii.Number]:
        '''The port number the service will redirect to.

        :default: - The value of ``port`` will be used.
        '''
        result = self._values.get("target_port")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def port(self) -> typing.Optional[jsii.Number]:
        '''The port number the service will bind to.

        :default: - Copied from the first container of the deployment.
        '''
        result = self._values.get("port")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AddDeploymentOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(IApiResource, IApiEndpoint)
class ApiResource(metaclass=jsii.JSIIMeta, jsii_type="cdk8s-plus-24.ApiResource"):
    '''Represents information about an API resource type.'''

    @jsii.member(jsii_name="custom")
    @builtins.classmethod
    def custom(
        cls,
        *,
        api_group: builtins.str,
        resource_type: builtins.str,
    ) -> "ApiResource":
        '''API resource information for a custom resource type.

        :param api_group: The group portion of the API version (e.g. ``authorization.k8s.io``).
        :param resource_type: The name of the resource type as it appears in the relevant API endpoint.
        '''
        options = ApiResourceOptions(api_group=api_group, resource_type=resource_type)

        return typing.cast("ApiResource", jsii.sinvoke(cls, "custom", [options]))

    @jsii.member(jsii_name="asApiResource")
    def as_api_resource(self) -> typing.Optional[IApiResource]:
        '''Return the IApiResource this object represents.'''
        return typing.cast(typing.Optional[IApiResource], jsii.invoke(self, "asApiResource", []))

    @jsii.member(jsii_name="asNonApiResource")
    def as_non_api_resource(self) -> typing.Optional[builtins.str]:
        '''Return the non resource url this object represents.'''
        return typing.cast(typing.Optional[builtins.str], jsii.invoke(self, "asNonApiResource", []))

    @jsii.python.classproperty
    @jsii.member(jsii_name="API_SERVICES")
    def API_SERVICES(cls) -> "ApiResource":
        '''API resource information for APIService.'''
        return typing.cast("ApiResource", jsii.sget(cls, "API_SERVICES"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="BINDINGS")
    def BINDINGS(cls) -> "ApiResource":
        '''API resource information for Binding.'''
        return typing.cast("ApiResource", jsii.sget(cls, "BINDINGS"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="CERTIFICATE_SIGNING_REQUESTS")
    def CERTIFICATE_SIGNING_REQUESTS(cls) -> "ApiResource":
        '''API resource information for CertificateSigningRequest.'''
        return typing.cast("ApiResource", jsii.sget(cls, "CERTIFICATE_SIGNING_REQUESTS"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="CLUSTER_ROLE_BINDINGS")
    def CLUSTER_ROLE_BINDINGS(cls) -> "ApiResource":
        '''API resource information for ClusterRoleBinding.'''
        return typing.cast("ApiResource", jsii.sget(cls, "CLUSTER_ROLE_BINDINGS"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="CLUSTER_ROLES")
    def CLUSTER_ROLES(cls) -> "ApiResource":
        '''API resource information for ClusterRole.'''
        return typing.cast("ApiResource", jsii.sget(cls, "CLUSTER_ROLES"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="COMPONENT_STATUSES")
    def COMPONENT_STATUSES(cls) -> "ApiResource":
        '''API resource information for ComponentStatus.'''
        return typing.cast("ApiResource", jsii.sget(cls, "COMPONENT_STATUSES"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="CONFIG_MAPS")
    def CONFIG_MAPS(cls) -> "ApiResource":
        '''API resource information for ConfigMap.'''
        return typing.cast("ApiResource", jsii.sget(cls, "CONFIG_MAPS"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="CONTROLLER_REVISIONS")
    def CONTROLLER_REVISIONS(cls) -> "ApiResource":
        '''API resource information for ControllerRevision.'''
        return typing.cast("ApiResource", jsii.sget(cls, "CONTROLLER_REVISIONS"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="CRON_JOBS")
    def CRON_JOBS(cls) -> "ApiResource":
        '''API resource information for CronJob.'''
        return typing.cast("ApiResource", jsii.sget(cls, "CRON_JOBS"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="CSI_DRIVERS")
    def CSI_DRIVERS(cls) -> "ApiResource":
        '''API resource information for CSIDriver.'''
        return typing.cast("ApiResource", jsii.sget(cls, "CSI_DRIVERS"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="CSI_NODES")
    def CSI_NODES(cls) -> "ApiResource":
        '''API resource information for CSINode.'''
        return typing.cast("ApiResource", jsii.sget(cls, "CSI_NODES"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="CSI_STORAGE_CAPACITIES")
    def CSI_STORAGE_CAPACITIES(cls) -> "ApiResource":
        '''API resource information for CSIStorageCapacity.'''
        return typing.cast("ApiResource", jsii.sget(cls, "CSI_STORAGE_CAPACITIES"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="CUSTOM_RESOURCE_DEFINITIONS")
    def CUSTOM_RESOURCE_DEFINITIONS(cls) -> "ApiResource":
        '''API resource information for CustomResourceDefinition.'''
        return typing.cast("ApiResource", jsii.sget(cls, "CUSTOM_RESOURCE_DEFINITIONS"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="DAEMON_SETS")
    def DAEMON_SETS(cls) -> "ApiResource":
        '''API resource information for DaemonSet.'''
        return typing.cast("ApiResource", jsii.sget(cls, "DAEMON_SETS"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="DEPLOYMENTS")
    def DEPLOYMENTS(cls) -> "ApiResource":
        '''API resource information for Deployment.'''
        return typing.cast("ApiResource", jsii.sget(cls, "DEPLOYMENTS"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="ENDPOINT_SLICES")
    def ENDPOINT_SLICES(cls) -> "ApiResource":
        '''API resource information for EndpointSlice.'''
        return typing.cast("ApiResource", jsii.sget(cls, "ENDPOINT_SLICES"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="ENDPOINTS")
    def ENDPOINTS(cls) -> "ApiResource":
        '''API resource information for Endpoints.'''
        return typing.cast("ApiResource", jsii.sget(cls, "ENDPOINTS"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="EVENTS")
    def EVENTS(cls) -> "ApiResource":
        '''API resource information for Event.'''
        return typing.cast("ApiResource", jsii.sget(cls, "EVENTS"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="FLOW_SCHEMAS")
    def FLOW_SCHEMAS(cls) -> "ApiResource":
        '''API resource information for FlowSchema.'''
        return typing.cast("ApiResource", jsii.sget(cls, "FLOW_SCHEMAS"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="HORIZONTAL_POD_AUTOSCALERS")
    def HORIZONTAL_POD_AUTOSCALERS(cls) -> "ApiResource":
        '''API resource information for HorizontalPodAutoscaler.'''
        return typing.cast("ApiResource", jsii.sget(cls, "HORIZONTAL_POD_AUTOSCALERS"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="INGRESS_CLASSES")
    def INGRESS_CLASSES(cls) -> "ApiResource":
        '''API resource information for IngressClass.'''
        return typing.cast("ApiResource", jsii.sget(cls, "INGRESS_CLASSES"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="INGRESSES")
    def INGRESSES(cls) -> "ApiResource":
        '''API resource information for Ingress.'''
        return typing.cast("ApiResource", jsii.sget(cls, "INGRESSES"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="JOBS")
    def JOBS(cls) -> "ApiResource":
        '''API resource information for Job.'''
        return typing.cast("ApiResource", jsii.sget(cls, "JOBS"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="LEASES")
    def LEASES(cls) -> "ApiResource":
        '''API resource information for Lease.'''
        return typing.cast("ApiResource", jsii.sget(cls, "LEASES"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="LIMIT_RANGES")
    def LIMIT_RANGES(cls) -> "ApiResource":
        '''API resource information for LimitRange.'''
        return typing.cast("ApiResource", jsii.sget(cls, "LIMIT_RANGES"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="LOCAL_SUBJECT_ACCESS_REVIEWS")
    def LOCAL_SUBJECT_ACCESS_REVIEWS(cls) -> "ApiResource":
        '''API resource information for LocalSubjectAccessReview.'''
        return typing.cast("ApiResource", jsii.sget(cls, "LOCAL_SUBJECT_ACCESS_REVIEWS"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="MUTATING_WEBHOOK_CONFIGURATIONS")
    def MUTATING_WEBHOOK_CONFIGURATIONS(cls) -> "ApiResource":
        '''API resource information for MutatingWebhookConfiguration.'''
        return typing.cast("ApiResource", jsii.sget(cls, "MUTATING_WEBHOOK_CONFIGURATIONS"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="NAMESPACES")
    def NAMESPACES(cls) -> "ApiResource":
        '''API resource information for Namespace.'''
        return typing.cast("ApiResource", jsii.sget(cls, "NAMESPACES"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="NETWORK_POLICIES")
    def NETWORK_POLICIES(cls) -> "ApiResource":
        '''API resource information for NetworkPolicy.'''
        return typing.cast("ApiResource", jsii.sget(cls, "NETWORK_POLICIES"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="NODES")
    def NODES(cls) -> "ApiResource":
        '''API resource information for Node.'''
        return typing.cast("ApiResource", jsii.sget(cls, "NODES"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="PERSISTENT_VOLUME_CLAIMS")
    def PERSISTENT_VOLUME_CLAIMS(cls) -> "ApiResource":
        '''API resource information for PersistentVolumeClaim.'''
        return typing.cast("ApiResource", jsii.sget(cls, "PERSISTENT_VOLUME_CLAIMS"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="PERSISTENT_VOLUMES")
    def PERSISTENT_VOLUMES(cls) -> "ApiResource":
        '''API resource information for PersistentVolume.'''
        return typing.cast("ApiResource", jsii.sget(cls, "PERSISTENT_VOLUMES"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="POD_DISRUPTION_BUDGETS")
    def POD_DISRUPTION_BUDGETS(cls) -> "ApiResource":
        '''API resource information for PodDisruptionBudget.'''
        return typing.cast("ApiResource", jsii.sget(cls, "POD_DISRUPTION_BUDGETS"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="POD_SECURITY_POLICIES")
    def POD_SECURITY_POLICIES(cls) -> "ApiResource":
        '''API resource information for PodSecurityPolicy.'''
        return typing.cast("ApiResource", jsii.sget(cls, "POD_SECURITY_POLICIES"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="POD_TEMPLATES")
    def POD_TEMPLATES(cls) -> "ApiResource":
        '''API resource information for PodTemplate.'''
        return typing.cast("ApiResource", jsii.sget(cls, "POD_TEMPLATES"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="PODS")
    def PODS(cls) -> "ApiResource":
        '''API resource information for Pod.'''
        return typing.cast("ApiResource", jsii.sget(cls, "PODS"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="PRIORITY_CLASSES")
    def PRIORITY_CLASSES(cls) -> "ApiResource":
        '''API resource information for PriorityClass.'''
        return typing.cast("ApiResource", jsii.sget(cls, "PRIORITY_CLASSES"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="PRIORITY_LEVEL_CONFIGURATIONS")
    def PRIORITY_LEVEL_CONFIGURATIONS(cls) -> "ApiResource":
        '''API resource information for PriorityLevelConfiguration.'''
        return typing.cast("ApiResource", jsii.sget(cls, "PRIORITY_LEVEL_CONFIGURATIONS"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="REPLICA_SETS")
    def REPLICA_SETS(cls) -> "ApiResource":
        '''API resource information for ReplicaSet.'''
        return typing.cast("ApiResource", jsii.sget(cls, "REPLICA_SETS"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="REPLICATION_CONTROLLERS")
    def REPLICATION_CONTROLLERS(cls) -> "ApiResource":
        '''API resource information for ReplicationController.'''
        return typing.cast("ApiResource", jsii.sget(cls, "REPLICATION_CONTROLLERS"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="RESOURCE_QUOTAS")
    def RESOURCE_QUOTAS(cls) -> "ApiResource":
        '''API resource information for ResourceQuota.'''
        return typing.cast("ApiResource", jsii.sget(cls, "RESOURCE_QUOTAS"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="ROLE_BINDINGS")
    def ROLE_BINDINGS(cls) -> "ApiResource":
        '''API resource information for RoleBinding.'''
        return typing.cast("ApiResource", jsii.sget(cls, "ROLE_BINDINGS"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="ROLES")
    def ROLES(cls) -> "ApiResource":
        '''API resource information for Role.'''
        return typing.cast("ApiResource", jsii.sget(cls, "ROLES"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="RUNTIME_CLASSES")
    def RUNTIME_CLASSES(cls) -> "ApiResource":
        '''API resource information for RuntimeClass.'''
        return typing.cast("ApiResource", jsii.sget(cls, "RUNTIME_CLASSES"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="SECRETS")
    def SECRETS(cls) -> "ApiResource":
        '''API resource information for Secret.'''
        return typing.cast("ApiResource", jsii.sget(cls, "SECRETS"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="SELF_SUBJECT_ACCESS_REVIEWS")
    def SELF_SUBJECT_ACCESS_REVIEWS(cls) -> "ApiResource":
        '''API resource information for SelfSubjectAccessReview.'''
        return typing.cast("ApiResource", jsii.sget(cls, "SELF_SUBJECT_ACCESS_REVIEWS"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="SELF_SUBJECT_RULES_REVIEWS")
    def SELF_SUBJECT_RULES_REVIEWS(cls) -> "ApiResource":
        '''API resource information for SelfSubjectRulesReview.'''
        return typing.cast("ApiResource", jsii.sget(cls, "SELF_SUBJECT_RULES_REVIEWS"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="SERVICE_ACCOUNTS")
    def SERVICE_ACCOUNTS(cls) -> "ApiResource":
        '''API resource information for ServiceAccount.'''
        return typing.cast("ApiResource", jsii.sget(cls, "SERVICE_ACCOUNTS"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="SERVICES")
    def SERVICES(cls) -> "ApiResource":
        '''API resource information for Service.'''
        return typing.cast("ApiResource", jsii.sget(cls, "SERVICES"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="STATEFUL_SETS")
    def STATEFUL_SETS(cls) -> "ApiResource":
        '''API resource information for StatefulSet.'''
        return typing.cast("ApiResource", jsii.sget(cls, "STATEFUL_SETS"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="STORAGE_CLASSES")
    def STORAGE_CLASSES(cls) -> "ApiResource":
        '''API resource information for StorageClass.'''
        return typing.cast("ApiResource", jsii.sget(cls, "STORAGE_CLASSES"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="SUBJECT_ACCESS_REVIEWS")
    def SUBJECT_ACCESS_REVIEWS(cls) -> "ApiResource":
        '''API resource information for SubjectAccessReview.'''
        return typing.cast("ApiResource", jsii.sget(cls, "SUBJECT_ACCESS_REVIEWS"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="TOKEN_REVIEWS")
    def TOKEN_REVIEWS(cls) -> "ApiResource":
        '''API resource information for TokenReview.'''
        return typing.cast("ApiResource", jsii.sget(cls, "TOKEN_REVIEWS"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="VALIDATING_WEBHOOK_CONFIGURATIONS")
    def VALIDATING_WEBHOOK_CONFIGURATIONS(cls) -> "ApiResource":
        '''API resource information for ValidatingWebhookConfiguration.'''
        return typing.cast("ApiResource", jsii.sget(cls, "VALIDATING_WEBHOOK_CONFIGURATIONS"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="VOLUME_ATTACHMENTS")
    def VOLUME_ATTACHMENTS(cls) -> "ApiResource":
        '''API resource information for VolumeAttachment.'''
        return typing.cast("ApiResource", jsii.sget(cls, "VOLUME_ATTACHMENTS"))

    @builtins.property
    @jsii.member(jsii_name="apiGroup")
    def api_group(self) -> builtins.str:
        '''The group portion of the API version (e.g. ``authorization.k8s.io``).'''
        return typing.cast(builtins.str, jsii.get(self, "apiGroup"))

    @builtins.property
    @jsii.member(jsii_name="resourceType")
    def resource_type(self) -> builtins.str:
        '''The name of the resource type as it appears in the relevant API endpoint.

        :see: https://kubernetes.io/docs/reference/access-authn-authz/rbac/#referring-to-resources

        Example::

            - "pods" or "pods/log"
        '''
        return typing.cast(builtins.str, jsii.get(self, "resourceType"))


class BasicAuthSecret(
    Secret,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-24.BasicAuthSecret",
):
    '''Create a secret for basic authentication.

    :see: https://kubernetes.io/docs/concepts/configuration/secret/#basic-authentication-secret
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        password: builtins.str,
        username: builtins.str,
        immutable: typing.Optional[builtins.bool] = None,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param password: The password or token for authentication.
        :param username: The user name for authentication.
        :param immutable: If set to true, ensures that data stored in the Secret cannot be updated (only object metadata can be modified). If not set to true, the field can be modified at any time. Default: false
        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__80b5617accbe68cece227467d090d246100d0f437d2994426f8c5e89794356c9)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = BasicAuthSecretProps(
            password=password,
            username=username,
            immutable=immutable,
            metadata=metadata,
        )

        jsii.create(self.__class__, self, [scope, id, props])


class ClusterRoleBinding(
    Resource,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-24.ClusterRoleBinding",
):
    '''A ClusterRoleBinding grants permissions cluster-wide to a user or set of users.'''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        role: "IClusterRole",
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param role: The role to bind to.
        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__31d5cd6074950885e0fa65f623e0d16348520364640e94ac11ae3a09cc7f7fe9)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = ClusterRoleBindingProps(role=role, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="addSubjects")
    def add_subjects(self, *subjects: ISubject) -> None:
        '''Adds a subject to the role.

        :param subjects: The subjects to add.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ed407784b7f0fcec99c2112ca38922d5a415006c30a70e3f35e0cf768a8d3113)
            check_type(argname="argument subjects", value=subjects, expected_type=typing.Tuple[type_hints["subjects"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast(None, jsii.invoke(self, "addSubjects", [*subjects]))

    @builtins.property
    @jsii.member(jsii_name="apiObject")
    def _api_object(self) -> _cdk8s_d3d9af27.ApiObject:
        '''The underlying cdk8s API object.

        :see: base.Resource.apiObject
        '''
        return typing.cast(_cdk8s_d3d9af27.ApiObject, jsii.get(self, "apiObject"))

    @builtins.property
    @jsii.member(jsii_name="resourceType")
    def resource_type(self) -> builtins.str:
        '''The name of a resource type as it appears in the relevant API endpoint.'''
        return typing.cast(builtins.str, jsii.get(self, "resourceType"))

    @builtins.property
    @jsii.member(jsii_name="role")
    def role(self) -> "IClusterRole":
        return typing.cast("IClusterRole", jsii.get(self, "role"))

    @builtins.property
    @jsii.member(jsii_name="subjects")
    def subjects(self) -> typing.List[ISubject]:
        return typing.cast(typing.List[ISubject], jsii.get(self, "subjects"))


@jsii.data_type(
    jsii_type="cdk8s-plus-24.ClusterRoleBindingProps",
    jsii_struct_bases=[ResourceProps],
    name_mapping={"metadata": "metadata", "role": "role"},
)
class ClusterRoleBindingProps(ResourceProps):
    def __init__(
        self,
        *,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        role: "IClusterRole",
    ) -> None:
        '''Properties for ``ClusterRoleBinding``.

        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        :param role: The role to bind to.
        '''
        if isinstance(metadata, dict):
            metadata = _cdk8s_d3d9af27.ApiObjectMetadata(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__028fb6cf93d4ca7d9bdefbbfa9699da6102df47b4dc9fbb33d381e7a271f5d71)
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument role", value=role, expected_type=type_hints["role"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "role": role,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def metadata(self) -> typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata]:
        '''Metadata that all persisted resources must have, which includes all objects users must create.'''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata], result)

    @builtins.property
    def role(self) -> "IClusterRole":
        '''The role to bind to.'''
        result = self._values.get("role")
        assert result is not None, "Required property 'role' is missing"
        return typing.cast("IClusterRole", result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ClusterRoleBindingProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.ClusterRoleProps",
    jsii_struct_bases=[ResourceProps],
    name_mapping={
        "metadata": "metadata",
        "aggregation_labels": "aggregationLabels",
        "rules": "rules",
    },
)
class ClusterRoleProps(ResourceProps):
    def __init__(
        self,
        *,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        aggregation_labels: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        rules: typing.Optional[typing.Sequence[typing.Union[ClusterRolePolicyRule, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Properties for ``ClusterRole``.

        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        :param aggregation_labels: Specify labels that should be used to locate ClusterRoles, whose rules will be automatically filled into this ClusterRole's rules.
        :param rules: A list of rules the role should allow. Default: []
        '''
        if isinstance(metadata, dict):
            metadata = _cdk8s_d3d9af27.ApiObjectMetadata(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d7e47226e42c49f638c2de6dcafc1ca6e317769d3f3a8080dc65cfd115c9adaa)
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument aggregation_labels", value=aggregation_labels, expected_type=type_hints["aggregation_labels"])
            check_type(argname="argument rules", value=rules, expected_type=type_hints["rules"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if metadata is not None:
            self._values["metadata"] = metadata
        if aggregation_labels is not None:
            self._values["aggregation_labels"] = aggregation_labels
        if rules is not None:
            self._values["rules"] = rules

    @builtins.property
    def metadata(self) -> typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata]:
        '''Metadata that all persisted resources must have, which includes all objects users must create.'''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata], result)

    @builtins.property
    def aggregation_labels(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        '''Specify labels that should be used to locate ClusterRoles, whose rules will be automatically filled into this ClusterRole's rules.'''
        result = self._values.get("aggregation_labels")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, builtins.str]], result)

    @builtins.property
    def rules(self) -> typing.Optional[typing.List[ClusterRolePolicyRule]]:
        '''A list of rules the role should allow.

        :default: []
        '''
        result = self._values.get("rules")
        return typing.cast(typing.Optional[typing.List[ClusterRolePolicyRule]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ClusterRoleProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.CommandProbeOptions",
    jsii_struct_bases=[ProbeOptions],
    name_mapping={
        "failure_threshold": "failureThreshold",
        "initial_delay_seconds": "initialDelaySeconds",
        "period_seconds": "periodSeconds",
        "success_threshold": "successThreshold",
        "timeout_seconds": "timeoutSeconds",
    },
)
class CommandProbeOptions(ProbeOptions):
    def __init__(
        self,
        *,
        failure_threshold: typing.Optional[jsii.Number] = None,
        initial_delay_seconds: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        period_seconds: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        success_threshold: typing.Optional[jsii.Number] = None,
        timeout_seconds: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
    ) -> None:
        '''Options for ``Probe.fromCommand()``.

        :param failure_threshold: Minimum consecutive failures for the probe to be considered failed after having succeeded. Defaults to 3. Minimum value is 1. Default: 3
        :param initial_delay_seconds: Number of seconds after the container has started before liveness probes are initiated. Default: - immediate
        :param period_seconds: How often (in seconds) to perform the probe. Default to 10 seconds. Minimum value is 1. Default: Duration.seconds(10) Minimum value is 1.
        :param success_threshold: Minimum consecutive successes for the probe to be considered successful after having failed. Defaults to 1. Must be 1 for liveness and startup. Minimum value is 1. Default: 1 Must be 1 for liveness and startup. Minimum value is 1.
        :param timeout_seconds: Number of seconds after which the probe times out. Defaults to 1 second. Minimum value is 1. Default: Duration.seconds(1)
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__32d2a0f46130015d1fe99eb7d9aa183588e65a5e56a627e2e269a7ebae26807e)
            check_type(argname="argument failure_threshold", value=failure_threshold, expected_type=type_hints["failure_threshold"])
            check_type(argname="argument initial_delay_seconds", value=initial_delay_seconds, expected_type=type_hints["initial_delay_seconds"])
            check_type(argname="argument period_seconds", value=period_seconds, expected_type=type_hints["period_seconds"])
            check_type(argname="argument success_threshold", value=success_threshold, expected_type=type_hints["success_threshold"])
            check_type(argname="argument timeout_seconds", value=timeout_seconds, expected_type=type_hints["timeout_seconds"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if failure_threshold is not None:
            self._values["failure_threshold"] = failure_threshold
        if initial_delay_seconds is not None:
            self._values["initial_delay_seconds"] = initial_delay_seconds
        if period_seconds is not None:
            self._values["period_seconds"] = period_seconds
        if success_threshold is not None:
            self._values["success_threshold"] = success_threshold
        if timeout_seconds is not None:
            self._values["timeout_seconds"] = timeout_seconds

    @builtins.property
    def failure_threshold(self) -> typing.Optional[jsii.Number]:
        '''Minimum consecutive failures for the probe to be considered failed after having succeeded.

        Defaults to 3. Minimum value is 1.

        :default: 3
        '''
        result = self._values.get("failure_threshold")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def initial_delay_seconds(self) -> typing.Optional[_cdk8s_d3d9af27.Duration]:
        '''Number of seconds after the container has started before liveness probes are initiated.

        :default: - immediate

        :see: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        '''
        result = self._values.get("initial_delay_seconds")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Duration], result)

    @builtins.property
    def period_seconds(self) -> typing.Optional[_cdk8s_d3d9af27.Duration]:
        '''How often (in seconds) to perform the probe.

        Default to 10 seconds. Minimum value is 1.

        :default: Duration.seconds(10) Minimum value is 1.
        '''
        result = self._values.get("period_seconds")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Duration], result)

    @builtins.property
    def success_threshold(self) -> typing.Optional[jsii.Number]:
        '''Minimum consecutive successes for the probe to be considered successful after having failed. Defaults to 1.

        Must be 1 for liveness and startup. Minimum value is 1.

        :default: 1 Must be 1 for liveness and startup. Minimum value is 1.
        '''
        result = self._values.get("success_threshold")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def timeout_seconds(self) -> typing.Optional[_cdk8s_d3d9af27.Duration]:
        '''Number of seconds after which the probe times out.

        Defaults to 1 second. Minimum value is 1.

        :default: Duration.seconds(1)

        :see: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        '''
        result = self._values.get("timeout_seconds")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Duration], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CommandProbeOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.CommonSecretProps",
    jsii_struct_bases=[ResourceProps],
    name_mapping={"metadata": "metadata", "immutable": "immutable"},
)
class CommonSecretProps(ResourceProps):
    def __init__(
        self,
        *,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        immutable: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''Common properties for ``Secret``.

        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        :param immutable: If set to true, ensures that data stored in the Secret cannot be updated (only object metadata can be modified). If not set to true, the field can be modified at any time. Default: false
        '''
        if isinstance(metadata, dict):
            metadata = _cdk8s_d3d9af27.ApiObjectMetadata(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d93058ea224880c7d59e836ea9925e7edbf9173fa513aa5f7ca22ae45ad756aa)
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument immutable", value=immutable, expected_type=type_hints["immutable"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if metadata is not None:
            self._values["metadata"] = metadata
        if immutable is not None:
            self._values["immutable"] = immutable

    @builtins.property
    def metadata(self) -> typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata]:
        '''Metadata that all persisted resources must have, which includes all objects users must create.'''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata], result)

    @builtins.property
    def immutable(self) -> typing.Optional[builtins.bool]:
        '''If set to true, ensures that data stored in the Secret cannot be updated (only object metadata can be modified).

        If not set to true, the field can be modified at any time.

        :default: false
        '''
        result = self._values.get("immutable")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CommonSecretProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.ConfigMapProps",
    jsii_struct_bases=[ResourceProps],
    name_mapping={
        "metadata": "metadata",
        "binary_data": "binaryData",
        "data": "data",
        "immutable": "immutable",
    },
)
class ConfigMapProps(ResourceProps):
    def __init__(
        self,
        *,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        binary_data: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        data: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        immutable: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''Properties for initialization of ``ConfigMap``.

        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        :param binary_data: BinaryData contains the binary data. Each key must consist of alphanumeric characters, '-', '_' or '.'. BinaryData can contain byte sequences that are not in the UTF-8 range. The keys stored in BinaryData must not overlap with the ones in the Data field, this is enforced during validation process. You can also add binary data using ``configMap.addBinaryData()``.
        :param data: Data contains the configuration data. Each key must consist of alphanumeric characters, '-', '_' or '.'. Values with non-UTF-8 byte sequences must use the BinaryData field. The keys stored in Data must not overlap with the keys in the BinaryData field, this is enforced during validation process. You can also add data using ``configMap.addData()``.
        :param immutable: If set to true, ensures that data stored in the ConfigMap cannot be updated (only object metadata can be modified). If not set to true, the field can be modified at any time. Default: false
        '''
        if isinstance(metadata, dict):
            metadata = _cdk8s_d3d9af27.ApiObjectMetadata(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3da5f32c8d8de64befec50d9c85e59e01ef0b06bd08ffba371aab4e26ccdb29d)
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument binary_data", value=binary_data, expected_type=type_hints["binary_data"])
            check_type(argname="argument data", value=data, expected_type=type_hints["data"])
            check_type(argname="argument immutable", value=immutable, expected_type=type_hints["immutable"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if metadata is not None:
            self._values["metadata"] = metadata
        if binary_data is not None:
            self._values["binary_data"] = binary_data
        if data is not None:
            self._values["data"] = data
        if immutable is not None:
            self._values["immutable"] = immutable

    @builtins.property
    def metadata(self) -> typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata]:
        '''Metadata that all persisted resources must have, which includes all objects users must create.'''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata], result)

    @builtins.property
    def binary_data(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        '''BinaryData contains the binary data.

        Each key must consist of alphanumeric characters, '-', '_' or '.'.
        BinaryData can contain byte sequences that are not in the UTF-8 range. The
        keys stored in BinaryData must not overlap with the ones in the Data field,
        this is enforced during validation process.

        You can also add binary data using ``configMap.addBinaryData()``.
        '''
        result = self._values.get("binary_data")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, builtins.str]], result)

    @builtins.property
    def data(self) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        '''Data contains the configuration data.

        Each key must consist of alphanumeric characters, '-', '_' or '.'. Values
        with non-UTF-8 byte sequences must use the BinaryData field. The keys
        stored in Data must not overlap with the keys in the BinaryData field, this
        is enforced during validation process.

        You can also add data using ``configMap.addData()``.
        '''
        result = self._values.get("data")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, builtins.str]], result)

    @builtins.property
    def immutable(self) -> typing.Optional[builtins.bool]:
        '''If set to true, ensures that data stored in the ConfigMap cannot be updated (only object metadata can be modified).

        If not set to true, the field can be modified at any time.

        :default: false
        '''
        result = self._values.get("immutable")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ConfigMapProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DockerConfigSecret(
    Secret,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-24.DockerConfigSecret",
):
    '''Create a secret for storing credentials for accessing a container image registry.

    :see: https://kubernetes.io/docs/concepts/configuration/secret/#docker-config-secrets
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        data: typing.Mapping[builtins.str, typing.Any],
        immutable: typing.Optional[builtins.bool] = None,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param data: JSON content to provide for the ``~/.docker/config.json`` file. This will be stringified and inserted as stringData.
        :param immutable: If set to true, ensures that data stored in the Secret cannot be updated (only object metadata can be modified). If not set to true, the field can be modified at any time. Default: false
        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d2a7ea6d9f8ca7f40948e96da275095b278bcd2d8e1c60de9451d68f18bd25cf)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = DockerConfigSecretProps(
            data=data, immutable=immutable, metadata=metadata
        )

        jsii.create(self.__class__, self, [scope, id, props])


@jsii.data_type(
    jsii_type="cdk8s-plus-24.DockerConfigSecretProps",
    jsii_struct_bases=[CommonSecretProps],
    name_mapping={"metadata": "metadata", "immutable": "immutable", "data": "data"},
)
class DockerConfigSecretProps(CommonSecretProps):
    def __init__(
        self,
        *,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        immutable: typing.Optional[builtins.bool] = None,
        data: typing.Mapping[builtins.str, typing.Any],
    ) -> None:
        '''Options for ``DockerConfigSecret``.

        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        :param immutable: If set to true, ensures that data stored in the Secret cannot be updated (only object metadata can be modified). If not set to true, the field can be modified at any time. Default: false
        :param data: JSON content to provide for the ``~/.docker/config.json`` file. This will be stringified and inserted as stringData.
        '''
        if isinstance(metadata, dict):
            metadata = _cdk8s_d3d9af27.ApiObjectMetadata(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b35d7ce00c810e89bebb220727009cb468c0b43b57bd1b886bb47498e5c2f05c)
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument immutable", value=immutable, expected_type=type_hints["immutable"])
            check_type(argname="argument data", value=data, expected_type=type_hints["data"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "data": data,
        }
        if metadata is not None:
            self._values["metadata"] = metadata
        if immutable is not None:
            self._values["immutable"] = immutable

    @builtins.property
    def metadata(self) -> typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata]:
        '''Metadata that all persisted resources must have, which includes all objects users must create.'''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata], result)

    @builtins.property
    def immutable(self) -> typing.Optional[builtins.bool]:
        '''If set to true, ensures that data stored in the Secret cannot be updated (only object metadata can be modified).

        If not set to true, the field can be modified at any time.

        :default: false
        '''
        result = self._values.get("immutable")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def data(self) -> typing.Mapping[builtins.str, typing.Any]:
        '''JSON content to provide for the ``~/.docker/config.json`` file. This will be stringified and inserted as stringData.

        :see: https://docs.docker.com/engine/reference/commandline/cli/#sample-configuration-file
        '''
        result = self._values.get("data")
        assert result is not None, "Required property 'data' is missing"
        return typing.cast(typing.Mapping[builtins.str, typing.Any], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DockerConfigSecretProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.ExposeDeploymentViaIngressOptions",
    jsii_struct_bases=[
        DeploymentExposeViaServiceOptions, ExposeServiceViaIngressOptions
    ],
    name_mapping={
        "name": "name",
        "ports": "ports",
        "service_type": "serviceType",
        "ingress": "ingress",
        "path_type": "pathType",
    },
)
class ExposeDeploymentViaIngressOptions(
    DeploymentExposeViaServiceOptions,
    ExposeServiceViaIngressOptions,
):
    def __init__(
        self,
        *,
        name: typing.Optional[builtins.str] = None,
        ports: typing.Optional[typing.Sequence[typing.Union[ServicePort, typing.Dict[builtins.str, typing.Any]]]] = None,
        service_type: typing.Optional[ServiceType] = None,
        ingress: typing.Optional["Ingress"] = None,
        path_type: typing.Optional[HttpIngressPathType] = None,
    ) -> None:
        '''Options for exposing a deployment via an ingress.

        :param name: The name of the service to expose. If you'd like to expose the deployment multiple times, you must explicitly set a name starting from the second expose call. Default: - auto generated.
        :param ports: The ports that the service should bind to. Default: - extracted from the deployment.
        :param service_type: The type of the exposed service. Default: - ClusterIP.
        :param ingress: The ingress to add rules to. Default: - An ingress will be automatically created.
        :param path_type: The type of the path. Default: HttpIngressPathType.PREFIX
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f124295657db7ed178c48aaa360121b33bdf376efe250b8adf237c3ec2f9274b)
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument ports", value=ports, expected_type=type_hints["ports"])
            check_type(argname="argument service_type", value=service_type, expected_type=type_hints["service_type"])
            check_type(argname="argument ingress", value=ingress, expected_type=type_hints["ingress"])
            check_type(argname="argument path_type", value=path_type, expected_type=type_hints["path_type"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if name is not None:
            self._values["name"] = name
        if ports is not None:
            self._values["ports"] = ports
        if service_type is not None:
            self._values["service_type"] = service_type
        if ingress is not None:
            self._values["ingress"] = ingress
        if path_type is not None:
            self._values["path_type"] = path_type

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''The name of the service to expose.

        If you'd like to expose the deployment multiple times,
        you must explicitly set a name starting from the second expose call.

        :default: - auto generated.
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def ports(self) -> typing.Optional[typing.List[ServicePort]]:
        '''The ports that the service should bind to.

        :default: - extracted from the deployment.
        '''
        result = self._values.get("ports")
        return typing.cast(typing.Optional[typing.List[ServicePort]], result)

    @builtins.property
    def service_type(self) -> typing.Optional[ServiceType]:
        '''The type of the exposed service.

        :default: - ClusterIP.
        '''
        result = self._values.get("service_type")
        return typing.cast(typing.Optional[ServiceType], result)

    @builtins.property
    def ingress(self) -> typing.Optional["Ingress"]:
        '''The ingress to add rules to.

        :default: - An ingress will be automatically created.
        '''
        result = self._values.get("ingress")
        return typing.cast(typing.Optional["Ingress"], result)

    @builtins.property
    def path_type(self) -> typing.Optional[HttpIngressPathType]:
        '''The type of the path.

        :default: HttpIngressPathType.PREFIX
        '''
        result = self._values.get("path_type")
        return typing.cast(typing.Optional[HttpIngressPathType], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ExposeDeploymentViaIngressOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(ISubject)
class Group(
    _constructs_77d1e7e8.Construct,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-24.Group",
):
    '''Represents a group.'''

    @jsii.member(jsii_name="fromName")
    @builtins.classmethod
    def from_name(
        cls,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        name: builtins.str,
    ) -> "Group":
        '''Reference a group by name.

        :param scope: -
        :param id: -
        :param name: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9dd7c91354233133cd4cddfa1bc87181c41430dc6a348c0ef6f2a1cbb257250c)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
        return typing.cast("Group", jsii.sinvoke(cls, "fromName", [scope, id, name]))

    @jsii.member(jsii_name="toSubjectConfiguration")
    def to_subject_configuration(self) -> SubjectConfiguration:
        '''Return the subject configuration.

        :see: ISubect.toSubjectConfiguration()
        '''
        return typing.cast(SubjectConfiguration, jsii.invoke(self, "toSubjectConfiguration", []))

    @builtins.property
    @jsii.member(jsii_name="kind")
    def kind(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "kind"))

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "name"))

    @builtins.property
    @jsii.member(jsii_name="apiGroup")
    def api_group(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "apiGroup"))


class HorizontalPodAutoscaler(
    Resource,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-24.HorizontalPodAutoscaler",
):
    '''A HorizontalPodAutoscaler scales a workload up or down in response to a metric change.

    This allows your services to scale up when demand is high and scale down
    when they are no longer needed.

    Typical use cases for HorizontalPodAutoscaler:

    - When Memory usage is above 70%, scale up the number of replicas to meet the demand.
    - When CPU usage is below 30%, scale down the number of replicas to save resources.
    - When a service is experiencing a spike in traffic, scale up the number of replicas
      to meet the demand. Then, when the traffic subsides, scale down the number of
      replicas to save resources.

    The autoscaler uses the following algorithm to determine the number of replicas to scale:

    ``desiredReplicas = ceil[currentReplicas * ( currentMetricValue / desiredMetricValue )]``

    HorizontalPodAutoscaler's can be used to with any ``Scalable`` workload:

    - Deployment
    - StatefulSet

    **Targets that already have a replica count defined:**

    Remove any replica counts from the target resource before associating with a
    HorizontalPodAutoscaler. If this isn't done, then any time a change to that object is applied,
    Kubernetes will scale the current number of Pods to the value of the target.replicas key. This
    may not be desired and could lead to unexpected behavior.

    :see: https://kubernetes.io/docs/tasks/run-application/horizontal-pod-autoscale/#implicit-maintenance-mode-deactivation

    Example::

        const backend = new kplus.Deployment(this, 'Backend', ...);
        
        const hpa = new kplus.HorizontalPodAutoscaler(chart, 'Hpa', {
         target: backend,
         maxReplicas: 10,
         scaleUp: {
           policies: [
             {
               replicas: kplus.Replicas.absolute(3),
               duration: Duration.minutes(5),
             },
           ],
         },
        });
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        max_replicas: jsii.Number,
        target: IScalable,
        metrics: typing.Optional[typing.Sequence[Metric]] = None,
        min_replicas: typing.Optional[jsii.Number] = None,
        scale_down: typing.Optional[typing.Union[ScalingRules, typing.Dict[builtins.str, typing.Any]]] = None,
        scale_up: typing.Optional[typing.Union[ScalingRules, typing.Dict[builtins.str, typing.Any]]] = None,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param max_replicas: The maximum number of replicas that can be scaled up to.
        :param target: The workload to scale up or down. Scalable workload types: - Deployment - StatefulSet
        :param metrics: The metric conditions that trigger a scale up or scale down. Default: - If metrics are not provided, then the target resource constraints (e.g. cpu limit) will be used as scaling metrics.
        :param min_replicas: The minimum number of replicas that can be scaled down to. Can be set to 0 if the alpha feature gate ``HPAScaleToZero`` is enabled and at least one Object or External metric is configured. Default: 1
        :param scale_down: The scaling behavior when scaling down. Default: - Scale down to minReplica count with a 5 minute stabilization window.
        :param scale_up: The scaling behavior when scaling up. Default: - Is the higher of: - Increase no more than 4 pods per 60 seconds - Double the number of pods per 60 seconds
        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__626347159e5778fe7440f77471937b41fe5915b97d4c84e100b1447e183a4671)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = HorizontalPodAutoscalerProps(
            max_replicas=max_replicas,
            target=target,
            metrics=metrics,
            min_replicas=min_replicas,
            scale_down=scale_down,
            scale_up=scale_up,
            metadata=metadata,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @builtins.property
    @jsii.member(jsii_name="apiObject")
    def _api_object(self) -> _cdk8s_d3d9af27.ApiObject:
        '''The underlying cdk8s API object.

        :see: base.Resource.apiObject
        '''
        return typing.cast(_cdk8s_d3d9af27.ApiObject, jsii.get(self, "apiObject"))

    @builtins.property
    @jsii.member(jsii_name="maxReplicas")
    def max_replicas(self) -> jsii.Number:
        '''The maximum number of replicas that can be scaled up to.'''
        return typing.cast(jsii.Number, jsii.get(self, "maxReplicas"))

    @builtins.property
    @jsii.member(jsii_name="minReplicas")
    def min_replicas(self) -> jsii.Number:
        '''The minimum number of replicas that can be scaled down to.'''
        return typing.cast(jsii.Number, jsii.get(self, "minReplicas"))

    @builtins.property
    @jsii.member(jsii_name="resourceType")
    def resource_type(self) -> builtins.str:
        '''The name of a resource type as it appears in the relevant API endpoint.'''
        return typing.cast(builtins.str, jsii.get(self, "resourceType"))

    @builtins.property
    @jsii.member(jsii_name="scaleDown")
    def scale_down(self) -> ScalingRules:
        '''The scaling behavior when scaling down.'''
        return typing.cast(ScalingRules, jsii.get(self, "scaleDown"))

    @builtins.property
    @jsii.member(jsii_name="scaleUp")
    def scale_up(self) -> ScalingRules:
        '''The scaling behavior when scaling up.'''
        return typing.cast(ScalingRules, jsii.get(self, "scaleUp"))

    @builtins.property
    @jsii.member(jsii_name="target")
    def target(self) -> IScalable:
        '''The workload to scale up or down.'''
        return typing.cast(IScalable, jsii.get(self, "target"))

    @builtins.property
    @jsii.member(jsii_name="metrics")
    def metrics(self) -> typing.Optional[typing.List[Metric]]:
        '''The metric conditions that trigger a scale up or scale down.'''
        return typing.cast(typing.Optional[typing.List[Metric]], jsii.get(self, "metrics"))


@jsii.data_type(
    jsii_type="cdk8s-plus-24.HorizontalPodAutoscalerProps",
    jsii_struct_bases=[ResourceProps],
    name_mapping={
        "metadata": "metadata",
        "max_replicas": "maxReplicas",
        "target": "target",
        "metrics": "metrics",
        "min_replicas": "minReplicas",
        "scale_down": "scaleDown",
        "scale_up": "scaleUp",
    },
)
class HorizontalPodAutoscalerProps(ResourceProps):
    def __init__(
        self,
        *,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        max_replicas: jsii.Number,
        target: IScalable,
        metrics: typing.Optional[typing.Sequence[Metric]] = None,
        min_replicas: typing.Optional[jsii.Number] = None,
        scale_down: typing.Optional[typing.Union[ScalingRules, typing.Dict[builtins.str, typing.Any]]] = None,
        scale_up: typing.Optional[typing.Union[ScalingRules, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Properties for HorizontalPodAutoscaler.

        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        :param max_replicas: The maximum number of replicas that can be scaled up to.
        :param target: The workload to scale up or down. Scalable workload types: - Deployment - StatefulSet
        :param metrics: The metric conditions that trigger a scale up or scale down. Default: - If metrics are not provided, then the target resource constraints (e.g. cpu limit) will be used as scaling metrics.
        :param min_replicas: The minimum number of replicas that can be scaled down to. Can be set to 0 if the alpha feature gate ``HPAScaleToZero`` is enabled and at least one Object or External metric is configured. Default: 1
        :param scale_down: The scaling behavior when scaling down. Default: - Scale down to minReplica count with a 5 minute stabilization window.
        :param scale_up: The scaling behavior when scaling up. Default: - Is the higher of: - Increase no more than 4 pods per 60 seconds - Double the number of pods per 60 seconds
        '''
        if isinstance(metadata, dict):
            metadata = _cdk8s_d3d9af27.ApiObjectMetadata(**metadata)
        if isinstance(scale_down, dict):
            scale_down = ScalingRules(**scale_down)
        if isinstance(scale_up, dict):
            scale_up = ScalingRules(**scale_up)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c133dc97cc9d2c7b6121b0fe7b34ea332437ccf86c30b9039671eb87aa13eb75)
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument max_replicas", value=max_replicas, expected_type=type_hints["max_replicas"])
            check_type(argname="argument target", value=target, expected_type=type_hints["target"])
            check_type(argname="argument metrics", value=metrics, expected_type=type_hints["metrics"])
            check_type(argname="argument min_replicas", value=min_replicas, expected_type=type_hints["min_replicas"])
            check_type(argname="argument scale_down", value=scale_down, expected_type=type_hints["scale_down"])
            check_type(argname="argument scale_up", value=scale_up, expected_type=type_hints["scale_up"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "max_replicas": max_replicas,
            "target": target,
        }
        if metadata is not None:
            self._values["metadata"] = metadata
        if metrics is not None:
            self._values["metrics"] = metrics
        if min_replicas is not None:
            self._values["min_replicas"] = min_replicas
        if scale_down is not None:
            self._values["scale_down"] = scale_down
        if scale_up is not None:
            self._values["scale_up"] = scale_up

    @builtins.property
    def metadata(self) -> typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata]:
        '''Metadata that all persisted resources must have, which includes all objects users must create.'''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata], result)

    @builtins.property
    def max_replicas(self) -> jsii.Number:
        '''The maximum number of replicas that can be scaled up to.'''
        result = self._values.get("max_replicas")
        assert result is not None, "Required property 'max_replicas' is missing"
        return typing.cast(jsii.Number, result)

    @builtins.property
    def target(self) -> IScalable:
        '''The workload to scale up or down.

        Scalable workload types:

        - Deployment
        - StatefulSet
        '''
        result = self._values.get("target")
        assert result is not None, "Required property 'target' is missing"
        return typing.cast(IScalable, result)

    @builtins.property
    def metrics(self) -> typing.Optional[typing.List[Metric]]:
        '''The metric conditions that trigger a scale up or scale down.

        :default:

        - If metrics are not provided, then the target resource
        constraints (e.g. cpu limit) will be used as scaling metrics.
        '''
        result = self._values.get("metrics")
        return typing.cast(typing.Optional[typing.List[Metric]], result)

    @builtins.property
    def min_replicas(self) -> typing.Optional[jsii.Number]:
        '''The minimum number of replicas that can be scaled down to.

        Can be set to 0 if the alpha feature gate ``HPAScaleToZero`` is enabled and
        at least one Object or External metric is configured.

        :default: 1
        '''
        result = self._values.get("min_replicas")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def scale_down(self) -> typing.Optional[ScalingRules]:
        '''The scaling behavior when scaling down.

        :default: - Scale down to minReplica count with a 5 minute stabilization window.
        '''
        result = self._values.get("scale_down")
        return typing.cast(typing.Optional[ScalingRules], result)

    @builtins.property
    def scale_up(self) -> typing.Optional[ScalingRules]:
        '''The scaling behavior when scaling up.

        :default:

        - Is the higher of:

        - Increase no more than 4 pods per 60 seconds
        - Double the number of pods per 60 seconds
        '''
        result = self._values.get("scale_up")
        return typing.cast(typing.Optional[ScalingRules], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "HorizontalPodAutoscalerProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.HttpGetProbeOptions",
    jsii_struct_bases=[ProbeOptions],
    name_mapping={
        "failure_threshold": "failureThreshold",
        "initial_delay_seconds": "initialDelaySeconds",
        "period_seconds": "periodSeconds",
        "success_threshold": "successThreshold",
        "timeout_seconds": "timeoutSeconds",
        "port": "port",
        "scheme": "scheme",
    },
)
class HttpGetProbeOptions(ProbeOptions):
    def __init__(
        self,
        *,
        failure_threshold: typing.Optional[jsii.Number] = None,
        initial_delay_seconds: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        period_seconds: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        success_threshold: typing.Optional[jsii.Number] = None,
        timeout_seconds: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        port: typing.Optional[jsii.Number] = None,
        scheme: typing.Optional[ConnectionScheme] = None,
    ) -> None:
        '''Options for ``Probe.fromHttpGet()``.

        :param failure_threshold: Minimum consecutive failures for the probe to be considered failed after having succeeded. Defaults to 3. Minimum value is 1. Default: 3
        :param initial_delay_seconds: Number of seconds after the container has started before liveness probes are initiated. Default: - immediate
        :param period_seconds: How often (in seconds) to perform the probe. Default to 10 seconds. Minimum value is 1. Default: Duration.seconds(10) Minimum value is 1.
        :param success_threshold: Minimum consecutive successes for the probe to be considered successful after having failed. Defaults to 1. Must be 1 for liveness and startup. Minimum value is 1. Default: 1 Must be 1 for liveness and startup. Minimum value is 1.
        :param timeout_seconds: Number of seconds after which the probe times out. Defaults to 1 second. Minimum value is 1. Default: Duration.seconds(1)
        :param port: The TCP port to use when sending the GET request. Default: - defaults to ``container.port``.
        :param scheme: Scheme to use for connecting to the host (HTTP or HTTPS). Default: ConnectionScheme.HTTP
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f57edf22e403a6eec0f9745ffc717583695a03241d5eb9f0030c716eea8ec068)
            check_type(argname="argument failure_threshold", value=failure_threshold, expected_type=type_hints["failure_threshold"])
            check_type(argname="argument initial_delay_seconds", value=initial_delay_seconds, expected_type=type_hints["initial_delay_seconds"])
            check_type(argname="argument period_seconds", value=period_seconds, expected_type=type_hints["period_seconds"])
            check_type(argname="argument success_threshold", value=success_threshold, expected_type=type_hints["success_threshold"])
            check_type(argname="argument timeout_seconds", value=timeout_seconds, expected_type=type_hints["timeout_seconds"])
            check_type(argname="argument port", value=port, expected_type=type_hints["port"])
            check_type(argname="argument scheme", value=scheme, expected_type=type_hints["scheme"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if failure_threshold is not None:
            self._values["failure_threshold"] = failure_threshold
        if initial_delay_seconds is not None:
            self._values["initial_delay_seconds"] = initial_delay_seconds
        if period_seconds is not None:
            self._values["period_seconds"] = period_seconds
        if success_threshold is not None:
            self._values["success_threshold"] = success_threshold
        if timeout_seconds is not None:
            self._values["timeout_seconds"] = timeout_seconds
        if port is not None:
            self._values["port"] = port
        if scheme is not None:
            self._values["scheme"] = scheme

    @builtins.property
    def failure_threshold(self) -> typing.Optional[jsii.Number]:
        '''Minimum consecutive failures for the probe to be considered failed after having succeeded.

        Defaults to 3. Minimum value is 1.

        :default: 3
        '''
        result = self._values.get("failure_threshold")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def initial_delay_seconds(self) -> typing.Optional[_cdk8s_d3d9af27.Duration]:
        '''Number of seconds after the container has started before liveness probes are initiated.

        :default: - immediate

        :see: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        '''
        result = self._values.get("initial_delay_seconds")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Duration], result)

    @builtins.property
    def period_seconds(self) -> typing.Optional[_cdk8s_d3d9af27.Duration]:
        '''How often (in seconds) to perform the probe.

        Default to 10 seconds. Minimum value is 1.

        :default: Duration.seconds(10) Minimum value is 1.
        '''
        result = self._values.get("period_seconds")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Duration], result)

    @builtins.property
    def success_threshold(self) -> typing.Optional[jsii.Number]:
        '''Minimum consecutive successes for the probe to be considered successful after having failed. Defaults to 1.

        Must be 1 for liveness and startup. Minimum value is 1.

        :default: 1 Must be 1 for liveness and startup. Minimum value is 1.
        '''
        result = self._values.get("success_threshold")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def timeout_seconds(self) -> typing.Optional[_cdk8s_d3d9af27.Duration]:
        '''Number of seconds after which the probe times out.

        Defaults to 1 second. Minimum value is 1.

        :default: Duration.seconds(1)

        :see: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        '''
        result = self._values.get("timeout_seconds")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Duration], result)

    @builtins.property
    def port(self) -> typing.Optional[jsii.Number]:
        '''The TCP port to use when sending the GET request.

        :default: - defaults to ``container.port``.
        '''
        result = self._values.get("port")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def scheme(self) -> typing.Optional[ConnectionScheme]:
        '''Scheme to use for connecting to the host (HTTP or HTTPS).

        :default: ConnectionScheme.HTTP
        '''
        result = self._values.get("scheme")
        return typing.cast(typing.Optional[ConnectionScheme], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "HttpGetProbeOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.interface(jsii_type="cdk8s-plus-24.IClusterRole")
class IClusterRole(IResource, typing_extensions.Protocol):
    '''Represents a cluster-level role.'''

    pass


class _IClusterRoleProxy(
    jsii.proxy_for(IResource), # type: ignore[misc]
):
    '''Represents a cluster-level role.'''

    __jsii_type__: typing.ClassVar[str] = "cdk8s-plus-24.IClusterRole"
    pass

# Adding a "__jsii_proxy_class__(): typing.Type" function to the interface
typing.cast(typing.Any, IClusterRole).__jsii_proxy_class__ = lambda : _IClusterRoleProxy


@jsii.interface(jsii_type="cdk8s-plus-24.IConfigMap")
class IConfigMap(IResource, typing_extensions.Protocol):
    '''Represents a config map.'''

    pass


class _IConfigMapProxy(
    jsii.proxy_for(IResource), # type: ignore[misc]
):
    '''Represents a config map.'''

    __jsii_type__: typing.ClassVar[str] = "cdk8s-plus-24.IConfigMap"
    pass

# Adding a "__jsii_proxy_class__(): typing.Type" function to the interface
typing.cast(typing.Any, IConfigMap).__jsii_proxy_class__ = lambda : _IConfigMapProxy


@jsii.interface(jsii_type="cdk8s-plus-24.IPersistentVolume")
class IPersistentVolume(IResource, typing_extensions.Protocol):
    '''Contract of a ``PersistentVolumeClaim``.'''

    pass


class _IPersistentVolumeProxy(
    jsii.proxy_for(IResource), # type: ignore[misc]
):
    '''Contract of a ``PersistentVolumeClaim``.'''

    __jsii_type__: typing.ClassVar[str] = "cdk8s-plus-24.IPersistentVolume"
    pass

# Adding a "__jsii_proxy_class__(): typing.Type" function to the interface
typing.cast(typing.Any, IPersistentVolume).__jsii_proxy_class__ = lambda : _IPersistentVolumeProxy


@jsii.interface(jsii_type="cdk8s-plus-24.IPersistentVolumeClaim")
class IPersistentVolumeClaim(IResource, typing_extensions.Protocol):
    '''Contract of a ``PersistentVolumeClaim``.'''

    pass


class _IPersistentVolumeClaimProxy(
    jsii.proxy_for(IResource), # type: ignore[misc]
):
    '''Contract of a ``PersistentVolumeClaim``.'''

    __jsii_type__: typing.ClassVar[str] = "cdk8s-plus-24.IPersistentVolumeClaim"
    pass

# Adding a "__jsii_proxy_class__(): typing.Type" function to the interface
typing.cast(typing.Any, IPersistentVolumeClaim).__jsii_proxy_class__ = lambda : _IPersistentVolumeClaimProxy


@jsii.interface(jsii_type="cdk8s-plus-24.IServiceAccount")
class IServiceAccount(IResource, ISubject, typing_extensions.Protocol):
    pass


class _IServiceAccountProxy(
    jsii.proxy_for(IResource), # type: ignore[misc]
    jsii.proxy_for(ISubject), # type: ignore[misc]
):
    __jsii_type__: typing.ClassVar[str] = "cdk8s-plus-24.IServiceAccount"
    pass

# Adding a "__jsii_proxy_class__(): typing.Type" function to the interface
typing.cast(typing.Any, IServiceAccount).__jsii_proxy_class__ = lambda : _IServiceAccountProxy


class Ingress(Resource, metaclass=jsii.JSIIMeta, jsii_type="cdk8s-plus-24.Ingress"):
    '''Ingress is a collection of rules that allow inbound connections to reach the endpoints defined by a backend.

    An Ingress can be configured to give services
    externally-reachable urls, load balance traffic, terminate SSL, offer name
    based virtual hosting etc.
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        default_backend: typing.Optional[IngressBackend] = None,
        rules: typing.Optional[typing.Sequence[typing.Union[IngressRule, typing.Dict[builtins.str, typing.Any]]]] = None,
        tls: typing.Optional[typing.Sequence[typing.Union[IngressTls, typing.Dict[builtins.str, typing.Any]]]] = None,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param default_backend: The default backend services requests that do not match any rule. Using this option or the ``addDefaultBackend()`` method is equivalent to adding a rule with both ``path`` and ``host`` undefined.
        :param rules: Routing rules for this ingress. Each rule must define an ``IngressBackend`` that will receive the requests that match this rule. If both ``host`` and ``path`` are not specifiec, this backend will be used as the default backend of the ingress. You can also add rules later using ``addRule()``, ``addHostRule()``, ``addDefaultBackend()`` and ``addHostDefaultBackend()``.
        :param tls: TLS settings for this ingress. Using this option tells the ingress controller to expose a TLS endpoint. Currently the Ingress only supports a single TLS port, 443. If multiple members of this list specify different hosts, they will be multiplexed on the same port according to the hostname specified through the SNI TLS extension, if the ingress controller fulfilling the ingress supports SNI.
        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8820f41ff9f12b17ba1c0a849c1f1c566fe71616b8207af0d09a3e7a6954e5c0)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = IngressProps(
            default_backend=default_backend, rules=rules, tls=tls, metadata=metadata
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="addDefaultBackend")
    def add_default_backend(self, backend: IngressBackend) -> None:
        '''Defines the default backend for this ingress.

        A default backend capable of
        servicing requests that don't match any rule.

        :param backend: The backend to use for requests that do not match any rule.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ba4cfdc410256a5745bf1363e40f7d061b3d56d729beca94430703b559144dc6)
            check_type(argname="argument backend", value=backend, expected_type=type_hints["backend"])
        return typing.cast(None, jsii.invoke(self, "addDefaultBackend", [backend]))

    @jsii.member(jsii_name="addHostDefaultBackend")
    def add_host_default_backend(
        self,
        host: builtins.str,
        backend: IngressBackend,
    ) -> None:
        '''Specify a default backend for a specific host name.

        This backend will be used as a catch-all for requests
        targeted to this host name (the ``Host`` header matches this value).

        :param host: The host name to match.
        :param backend: The backend to route to.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__86a8dc979b88d91621b5de2cfb4d6abf402122d6da76243330e81d9a354eabca)
            check_type(argname="argument host", value=host, expected_type=type_hints["host"])
            check_type(argname="argument backend", value=backend, expected_type=type_hints["backend"])
        return typing.cast(None, jsii.invoke(self, "addHostDefaultBackend", [host, backend]))

    @jsii.member(jsii_name="addHostRule")
    def add_host_rule(
        self,
        host: builtins.str,
        path: builtins.str,
        backend: IngressBackend,
        path_type: typing.Optional[HttpIngressPathType] = None,
    ) -> None:
        '''Adds an ingress rule applied to requests to a specific host and a specific HTTP path (the ``Host`` header matches this value).

        :param host: The host name.
        :param path: The HTTP path.
        :param backend: The backend to route requests to.
        :param path_type: How the path is matched against request paths.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__41c3d421633d87215d5728b9dea9bac67e2290eb4a28f3e4f7bef6c8aeddfb55)
            check_type(argname="argument host", value=host, expected_type=type_hints["host"])
            check_type(argname="argument path", value=path, expected_type=type_hints["path"])
            check_type(argname="argument backend", value=backend, expected_type=type_hints["backend"])
            check_type(argname="argument path_type", value=path_type, expected_type=type_hints["path_type"])
        return typing.cast(None, jsii.invoke(self, "addHostRule", [host, path, backend, path_type]))

    @jsii.member(jsii_name="addRule")
    def add_rule(
        self,
        path: builtins.str,
        backend: IngressBackend,
        path_type: typing.Optional[HttpIngressPathType] = None,
    ) -> None:
        '''Adds an ingress rule applied to requests sent to a specific HTTP path.

        :param path: The HTTP path.
        :param backend: The backend to route requests to.
        :param path_type: How the path is matched against request paths.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e51c6bee508a7b7c871337c87a7921558786f88bb729b833e3987f04c82bca54)
            check_type(argname="argument path", value=path, expected_type=type_hints["path"])
            check_type(argname="argument backend", value=backend, expected_type=type_hints["backend"])
            check_type(argname="argument path_type", value=path_type, expected_type=type_hints["path_type"])
        return typing.cast(None, jsii.invoke(self, "addRule", [path, backend, path_type]))

    @jsii.member(jsii_name="addRules")
    def add_rules(self, *rules: IngressRule) -> None:
        '''Adds rules to this ingress.

        :param rules: The rules to add.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d6d46d58a2209b5f4a863d40761177c91769af58dd300cb02eb75c5bef6edcd1)
            check_type(argname="argument rules", value=rules, expected_type=typing.Tuple[type_hints["rules"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast(None, jsii.invoke(self, "addRules", [*rules]))

    @jsii.member(jsii_name="addTls")
    def add_tls(
        self,
        tls: typing.Sequence[typing.Union[IngressTls, typing.Dict[builtins.str, typing.Any]]],
    ) -> None:
        '''
        :param tls: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9bbb5ea8a491b74765dca15763cbd751397b9f7864c4ed3743bbaedd751efd1e)
            check_type(argname="argument tls", value=tls, expected_type=type_hints["tls"])
        return typing.cast(None, jsii.invoke(self, "addTls", [tls]))

    @builtins.property
    @jsii.member(jsii_name="apiObject")
    def _api_object(self) -> _cdk8s_d3d9af27.ApiObject:
        '''The underlying cdk8s API object.

        :see: base.Resource.apiObject
        '''
        return typing.cast(_cdk8s_d3d9af27.ApiObject, jsii.get(self, "apiObject"))

    @builtins.property
    @jsii.member(jsii_name="resourceType")
    def resource_type(self) -> builtins.str:
        '''The name of a resource type as it appears in the relevant API endpoint.'''
        return typing.cast(builtins.str, jsii.get(self, "resourceType"))


@jsii.data_type(
    jsii_type="cdk8s-plus-24.IngressProps",
    jsii_struct_bases=[ResourceProps],
    name_mapping={
        "metadata": "metadata",
        "default_backend": "defaultBackend",
        "rules": "rules",
        "tls": "tls",
    },
)
class IngressProps(ResourceProps):
    def __init__(
        self,
        *,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        default_backend: typing.Optional[IngressBackend] = None,
        rules: typing.Optional[typing.Sequence[typing.Union[IngressRule, typing.Dict[builtins.str, typing.Any]]]] = None,
        tls: typing.Optional[typing.Sequence[typing.Union[IngressTls, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Properties for ``Ingress``.

        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        :param default_backend: The default backend services requests that do not match any rule. Using this option or the ``addDefaultBackend()`` method is equivalent to adding a rule with both ``path`` and ``host`` undefined.
        :param rules: Routing rules for this ingress. Each rule must define an ``IngressBackend`` that will receive the requests that match this rule. If both ``host`` and ``path`` are not specifiec, this backend will be used as the default backend of the ingress. You can also add rules later using ``addRule()``, ``addHostRule()``, ``addDefaultBackend()`` and ``addHostDefaultBackend()``.
        :param tls: TLS settings for this ingress. Using this option tells the ingress controller to expose a TLS endpoint. Currently the Ingress only supports a single TLS port, 443. If multiple members of this list specify different hosts, they will be multiplexed on the same port according to the hostname specified through the SNI TLS extension, if the ingress controller fulfilling the ingress supports SNI.
        '''
        if isinstance(metadata, dict):
            metadata = _cdk8s_d3d9af27.ApiObjectMetadata(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c19cb76365c837184bc7af873e325b10b1fa6687429001cdc6c51edc28e8e3a5)
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument default_backend", value=default_backend, expected_type=type_hints["default_backend"])
            check_type(argname="argument rules", value=rules, expected_type=type_hints["rules"])
            check_type(argname="argument tls", value=tls, expected_type=type_hints["tls"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if metadata is not None:
            self._values["metadata"] = metadata
        if default_backend is not None:
            self._values["default_backend"] = default_backend
        if rules is not None:
            self._values["rules"] = rules
        if tls is not None:
            self._values["tls"] = tls

    @builtins.property
    def metadata(self) -> typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata]:
        '''Metadata that all persisted resources must have, which includes all objects users must create.'''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata], result)

    @builtins.property
    def default_backend(self) -> typing.Optional[IngressBackend]:
        '''The default backend services requests that do not match any rule.

        Using this option or the ``addDefaultBackend()`` method is equivalent to
        adding a rule with both ``path`` and ``host`` undefined.
        '''
        result = self._values.get("default_backend")
        return typing.cast(typing.Optional[IngressBackend], result)

    @builtins.property
    def rules(self) -> typing.Optional[typing.List[IngressRule]]:
        '''Routing rules for this ingress.

        Each rule must define an ``IngressBackend`` that will receive the requests
        that match this rule. If both ``host`` and ``path`` are not specifiec, this
        backend will be used as the default backend of the ingress.

        You can also add rules later using ``addRule()``, ``addHostRule()``,
        ``addDefaultBackend()`` and ``addHostDefaultBackend()``.
        '''
        result = self._values.get("rules")
        return typing.cast(typing.Optional[typing.List[IngressRule]], result)

    @builtins.property
    def tls(self) -> typing.Optional[typing.List[IngressTls]]:
        '''TLS settings for this ingress.

        Using this option tells the ingress controller to expose a TLS endpoint.
        Currently the Ingress only supports a single TLS port, 443. If multiple
        members of this list specify different hosts, they will be multiplexed on
        the same port according to the hostname specified through the SNI TLS
        extension, if the ingress controller fulfilling the ingress supports SNI.
        '''
        result = self._values.get("tls")
        return typing.cast(typing.Optional[typing.List[IngressTls]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "IngressProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.MetricObjectOptions",
    jsii_struct_bases=[MetricOptions],
    name_mapping={
        "name": "name",
        "target": "target",
        "label_selector": "labelSelector",
        "object": "object",
    },
)
class MetricObjectOptions(MetricOptions):
    def __init__(
        self,
        *,
        name: builtins.str,
        target: MetricTarget,
        label_selector: typing.Optional[LabelSelector] = None,
        object: IResource,
    ) -> None:
        '''Options for ``Metric.object()``.

        :param name: The name of the metric to scale on.
        :param target: The target metric value that will trigger scaling.
        :param label_selector: A selector to find a metric by label. When set, it is passed as an additional parameter to the metrics server for more specific metrics scoping. Default: - Just the metric 'name' will be used to gather metrics.
        :param object: Resource where the metric can be found.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5f004ee74918de21eaccf1fa16f21185594ccf36f7cf3269f6e809d4aee471af)
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument target", value=target, expected_type=type_hints["target"])
            check_type(argname="argument label_selector", value=label_selector, expected_type=type_hints["label_selector"])
            check_type(argname="argument object", value=object, expected_type=type_hints["object"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "name": name,
            "target": target,
            "object": object,
        }
        if label_selector is not None:
            self._values["label_selector"] = label_selector

    @builtins.property
    def name(self) -> builtins.str:
        '''The name of the metric to scale on.'''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def target(self) -> MetricTarget:
        '''The target metric value that will trigger scaling.'''
        result = self._values.get("target")
        assert result is not None, "Required property 'target' is missing"
        return typing.cast(MetricTarget, result)

    @builtins.property
    def label_selector(self) -> typing.Optional[LabelSelector]:
        '''A selector to find a metric by label.

        When set, it is passed as an additional parameter to the metrics server
        for more specific metrics scoping.

        :default: - Just the metric 'name' will be used to gather metrics.
        '''
        result = self._values.get("label_selector")
        return typing.cast(typing.Optional[LabelSelector], result)

    @builtins.property
    def object(self) -> IResource:
        '''Resource where the metric can be found.'''
        result = self._values.get("object")
        assert result is not None, "Required property 'object' is missing"
        return typing.cast(IResource, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "MetricObjectOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(INamespaceSelector, INetworkPolicyPeer)
class Namespace(Resource, metaclass=jsii.JSIIMeta, jsii_type="cdk8s-plus-24.Namespace"):
    '''In Kubernetes, namespaces provides a mechanism for isolating groups of resources within a single cluster.

    Names of resources need to be unique within a namespace, but not across namespaces.
    Namespace-based scoping is applicable only for namespaced objects (e.g. Deployments, Services, etc) and
    not for cluster-wide objects (e.g. StorageClass, Nodes, PersistentVolumes, etc).
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__99db30f3646940fa087762d4eb0e9cb5f846a30faa43a6e32fdeca6cefe09fe6)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = NamespaceProps(metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="toNamespaceSelectorConfig")
    def to_namespace_selector_config(self) -> NamespaceSelectorConfig:
        '''Return the configuration of this selector.

        :see: INamespaceSelector.toNamespaceSelectorConfig()
        '''
        return typing.cast(NamespaceSelectorConfig, jsii.invoke(self, "toNamespaceSelectorConfig", []))

    @jsii.member(jsii_name="toNetworkPolicyPeerConfig")
    def to_network_policy_peer_config(self) -> NetworkPolicyPeerConfig:
        '''Return the configuration of this peer.

        :see: INetworkPolicyPeer.toNetworkPolicyPeerConfig()
        '''
        return typing.cast(NetworkPolicyPeerConfig, jsii.invoke(self, "toNetworkPolicyPeerConfig", []))

    @jsii.member(jsii_name="toPodSelector")
    def to_pod_selector(self) -> typing.Optional[IPodSelector]:
        '''Convert the peer into a pod selector, if possible.

        :see: INetworkPolicyPeer.toPodSelector()
        '''
        return typing.cast(typing.Optional[IPodSelector], jsii.invoke(self, "toPodSelector", []))

    @jsii.python.classproperty
    @jsii.member(jsii_name="NAME_LABEL")
    def NAME_LABEL(cls) -> builtins.str:
        '''
        :see: https://kubernetes.io/docs/concepts/overview/working-with-objects/namespaces/#automatic-labelling
        '''
        return typing.cast(builtins.str, jsii.sget(cls, "NAME_LABEL"))

    @builtins.property
    @jsii.member(jsii_name="apiObject")
    def _api_object(self) -> _cdk8s_d3d9af27.ApiObject:
        '''The underlying cdk8s API object.

        :see: base.Resource.apiObject
        '''
        return typing.cast(_cdk8s_d3d9af27.ApiObject, jsii.get(self, "apiObject"))

    @builtins.property
    @jsii.member(jsii_name="resourceType")
    def resource_type(self) -> builtins.str:
        '''The name of a resource type as it appears in the relevant API endpoint.'''
        return typing.cast(builtins.str, jsii.get(self, "resourceType"))


@jsii.data_type(
    jsii_type="cdk8s-plus-24.NamespaceProps",
    jsii_struct_bases=[ResourceProps],
    name_mapping={"metadata": "metadata"},
)
class NamespaceProps(ResourceProps):
    def __init__(
        self,
        *,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Properties for ``Namespace``.

        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        '''
        if isinstance(metadata, dict):
            metadata = _cdk8s_d3d9af27.ApiObjectMetadata(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8ba6b75b5755a65d672452a7d722509b603cf6ce7196e3b5234dbc7d1ec48753)
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def metadata(self) -> typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata]:
        '''Metadata that all persisted resources must have, which includes all objects users must create.'''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "NamespaceProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class NetworkPolicy(
    Resource,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-24.NetworkPolicy",
):
    '''Control traffic flow at the IP address or port level (OSI layer 3 or 4), network policies are an application-centric construct which allow you to specify how a pod is allowed to communicate with various network peers.

    - Outgoing traffic is allowed if there are no network policies selecting
      the pod (and cluster policy otherwise allows the traffic),
      OR if the traffic matches at least one egress rule across all of the
      network policies that select the pod.
    - Incoming traffic is allowed to a pod if there are no network policies
      selecting the pod (and cluster policy otherwise allows the traffic),
      OR if the traffic source is the pod's local node,
      OR if the traffic matches at least one ingress rule across all of
      the network policies that select the pod.

    Network policies do not conflict; they are additive.
    If any policy or policies apply to a given pod for a given
    direction, the connections allowed in that direction from
    that pod is the union of what the applicable policies allow.
    Thus, order of evaluation does not affect the policy result.

    For a connection from a source pod to a destination pod to be allowed,
    both the egress policy on the source pod and the ingress policy on the
    destination pod need to allow the connection.
    If either side does not allow the connection, it will not happen.

    :see: https://kubernetes.io/docs/concepts/services-networking/network-policies/#networkpolicy-resource
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        egress: typing.Optional[typing.Union[NetworkPolicyTraffic, typing.Dict[builtins.str, typing.Any]]] = None,
        ingress: typing.Optional[typing.Union[NetworkPolicyTraffic, typing.Dict[builtins.str, typing.Any]]] = None,
        selector: typing.Optional[IPodSelector] = None,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param egress: Egress traffic configuration. Default: - the policy doesn't change egress behavior of the pods it selects.
        :param ingress: Ingress traffic configuration. Default: - the policy doesn't change ingress behavior of the pods it selects.
        :param selector: Which pods does this policy object applies to. This can either be a single pod / workload, or a grouping of pods selected via the ``Pods.select`` function. Rules is applied to any pods selected by this property. Multiple network policies can select the same set of pods. In this case, the rules for each are combined additively. Note that Default: - will select all pods in the namespace of the policy.
        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d54c9ece39fbf51adaeea3832c61c8575f25f67fea21833aefa3e761a8e431da)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = NetworkPolicyProps(
            egress=egress, ingress=ingress, selector=selector, metadata=metadata
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="addEgressRule")
    def add_egress_rule(
        self,
        peer: INetworkPolicyPeer,
        ports: typing.Optional[typing.Sequence[NetworkPolicyPort]] = None,
    ) -> None:
        '''Allow outgoing traffic to the peer.

        If ports are not passed, traffic will be allowed on all ports.

        :param peer: -
        :param ports: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a85df3458c4e89ebe46f305942d94da4e62c45f04dcb5978e8c1a3167c32ad54)
            check_type(argname="argument peer", value=peer, expected_type=type_hints["peer"])
            check_type(argname="argument ports", value=ports, expected_type=type_hints["ports"])
        return typing.cast(None, jsii.invoke(self, "addEgressRule", [peer, ports]))

    @jsii.member(jsii_name="addIngressRule")
    def add_ingress_rule(
        self,
        peer: INetworkPolicyPeer,
        ports: typing.Optional[typing.Sequence[NetworkPolicyPort]] = None,
    ) -> None:
        '''Allow incoming traffic from the peer.

        If ports are not passed, traffic will be allowed on all ports.

        :param peer: -
        :param ports: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__befbd376d73f1ef70d5e318ae9f16e25e77e3b62c13a693bfd1d9d1e3fab0423)
            check_type(argname="argument peer", value=peer, expected_type=type_hints["peer"])
            check_type(argname="argument ports", value=ports, expected_type=type_hints["ports"])
        return typing.cast(None, jsii.invoke(self, "addIngressRule", [peer, ports]))

    @builtins.property
    @jsii.member(jsii_name="apiObject")
    def _api_object(self) -> _cdk8s_d3d9af27.ApiObject:
        '''The underlying cdk8s API object.

        :see: base.Resource.apiObject
        '''
        return typing.cast(_cdk8s_d3d9af27.ApiObject, jsii.get(self, "apiObject"))

    @builtins.property
    @jsii.member(jsii_name="resourceType")
    def resource_type(self) -> builtins.str:
        '''The name of a resource type as it appears in the relevant API endpoint.'''
        return typing.cast(builtins.str, jsii.get(self, "resourceType"))


@jsii.data_type(
    jsii_type="cdk8s-plus-24.NetworkPolicyProps",
    jsii_struct_bases=[ResourceProps],
    name_mapping={
        "metadata": "metadata",
        "egress": "egress",
        "ingress": "ingress",
        "selector": "selector",
    },
)
class NetworkPolicyProps(ResourceProps):
    def __init__(
        self,
        *,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        egress: typing.Optional[typing.Union[NetworkPolicyTraffic, typing.Dict[builtins.str, typing.Any]]] = None,
        ingress: typing.Optional[typing.Union[NetworkPolicyTraffic, typing.Dict[builtins.str, typing.Any]]] = None,
        selector: typing.Optional[IPodSelector] = None,
    ) -> None:
        '''Properties for ``NetworkPolicy``.

        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        :param egress: Egress traffic configuration. Default: - the policy doesn't change egress behavior of the pods it selects.
        :param ingress: Ingress traffic configuration. Default: - the policy doesn't change ingress behavior of the pods it selects.
        :param selector: Which pods does this policy object applies to. This can either be a single pod / workload, or a grouping of pods selected via the ``Pods.select`` function. Rules is applied to any pods selected by this property. Multiple network policies can select the same set of pods. In this case, the rules for each are combined additively. Note that Default: - will select all pods in the namespace of the policy.
        '''
        if isinstance(metadata, dict):
            metadata = _cdk8s_d3d9af27.ApiObjectMetadata(**metadata)
        if isinstance(egress, dict):
            egress = NetworkPolicyTraffic(**egress)
        if isinstance(ingress, dict):
            ingress = NetworkPolicyTraffic(**ingress)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__7643359876ccd161535a5a9d5b6293beb6f696c6441f787533390949aa95425e)
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument egress", value=egress, expected_type=type_hints["egress"])
            check_type(argname="argument ingress", value=ingress, expected_type=type_hints["ingress"])
            check_type(argname="argument selector", value=selector, expected_type=type_hints["selector"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if metadata is not None:
            self._values["metadata"] = metadata
        if egress is not None:
            self._values["egress"] = egress
        if ingress is not None:
            self._values["ingress"] = ingress
        if selector is not None:
            self._values["selector"] = selector

    @builtins.property
    def metadata(self) -> typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata]:
        '''Metadata that all persisted resources must have, which includes all objects users must create.'''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata], result)

    @builtins.property
    def egress(self) -> typing.Optional[NetworkPolicyTraffic]:
        '''Egress traffic configuration.

        :default: - the policy doesn't change egress behavior of the pods it selects.
        '''
        result = self._values.get("egress")
        return typing.cast(typing.Optional[NetworkPolicyTraffic], result)

    @builtins.property
    def ingress(self) -> typing.Optional[NetworkPolicyTraffic]:
        '''Ingress traffic configuration.

        :default: - the policy doesn't change ingress behavior of the pods it selects.
        '''
        result = self._values.get("ingress")
        return typing.cast(typing.Optional[NetworkPolicyTraffic], result)

    @builtins.property
    def selector(self) -> typing.Optional[IPodSelector]:
        '''Which pods does this policy object applies to.

        This can either be a single pod / workload, or a grouping of pods selected
        via the ``Pods.select`` function. Rules is applied to any pods selected by this property.
        Multiple network policies can select the same set of pods.
        In this case, the rules for each are combined additively.

        Note that

        :default: - will select all pods in the namespace of the policy.
        '''
        result = self._values.get("selector")
        return typing.cast(typing.Optional[IPodSelector], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "NetworkPolicyProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(IPersistentVolume, IStorage)
class PersistentVolume(
    Resource,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-24.PersistentVolume",
):
    '''A PersistentVolume (PV) is a piece of storage in the cluster that has been provisioned by an administrator or dynamically provisioned using Storage Classes.

    It is a resource in the cluster just like a node is a cluster resource.
    PVs are volume plugins like Volumes, but have a lifecycle independent of any
    individual Pod that uses the PV. This API object captures the details of the
    implementation of the storage, be that NFS, iSCSI, or a
    cloud-provider-specific storage system.
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        access_modes: typing.Optional[typing.Sequence[PersistentVolumeAccessMode]] = None,
        claim: typing.Optional[IPersistentVolumeClaim] = None,
        mount_options: typing.Optional[typing.Sequence[builtins.str]] = None,
        reclaim_policy: typing.Optional[PersistentVolumeReclaimPolicy] = None,
        storage: typing.Optional[_cdk8s_d3d9af27.Size] = None,
        storage_class_name: typing.Optional[builtins.str] = None,
        volume_mode: typing.Optional[PersistentVolumeMode] = None,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param access_modes: Contains all ways the volume can be mounted. Default: - No access modes.
        :param claim: Part of a bi-directional binding between PersistentVolume and PersistentVolumeClaim. Expected to be non-nil when bound. Default: - Not bound to a specific claim.
        :param mount_options: A list of mount options, e.g. ["ro", "soft"]. Not validated - mount will simply fail if one is invalid. Default: - No options.
        :param reclaim_policy: When a user is done with their volume, they can delete the PVC objects from the API that allows reclamation of the resource. The reclaim policy tells the cluster what to do with the volume after it has been released of its claim. Default: PersistentVolumeReclaimPolicy.RETAIN
        :param storage: What is the storage capacity of this volume. Default: - No specified.
        :param storage_class_name: Name of StorageClass to which this persistent volume belongs. Default: - Volume does not belong to any storage class.
        :param volume_mode: Defines what type of volume is required by the claim. Default: VolumeMode.FILE_SYSTEM
        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e35ef8370254bd7a1b86d4fee5bc7d17db62905d3934c5d4751fd22e063dfb98)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = PersistentVolumeProps(
            access_modes=access_modes,
            claim=claim,
            mount_options=mount_options,
            reclaim_policy=reclaim_policy,
            storage=storage,
            storage_class_name=storage_class_name,
            volume_mode=volume_mode,
            metadata=metadata,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="fromPersistentVolumeName")
    @builtins.classmethod
    def from_persistent_volume_name(
        cls,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        volume_name: builtins.str,
    ) -> IPersistentVolume:
        '''Imports a pv from the cluster as a reference.

        :param scope: -
        :param id: -
        :param volume_name: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6cc9c0e2ab67e2d7c20f7b696a108bb614b919c00dd5c4c43c0609e6efaf3346)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
            check_type(argname="argument volume_name", value=volume_name, expected_type=type_hints["volume_name"])
        return typing.cast(IPersistentVolume, jsii.sinvoke(cls, "fromPersistentVolumeName", [scope, id, volume_name]))

    @jsii.member(jsii_name="asVolume")
    def as_volume(self) -> Volume:
        '''Convert the piece of storage into a concrete volume.'''
        return typing.cast(Volume, jsii.invoke(self, "asVolume", []))

    @jsii.member(jsii_name="bind")
    def bind(self, claim: IPersistentVolumeClaim) -> None:
        '''Bind a volume to a specific claim.

        Note that you must also bind the claim to the volume.

        :param claim: The PVC to bind to.

        :see: https://kubernetes.io/docs/concepts/storage/persistent-volumes/#binding
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__803f9657799d02848139e1fdf38d5d308ffa6695b8930cbf01cd5655d2aa586b)
            check_type(argname="argument claim", value=claim, expected_type=type_hints["claim"])
        return typing.cast(None, jsii.invoke(self, "bind", [claim]))

    @jsii.member(jsii_name="reserve")
    def reserve(self) -> "PersistentVolumeClaim":
        '''Reserve a ``PersistentVolume`` by creating a ``PersistentVolumeClaim`` that is wired to claim this volume.

        Note that this method will throw in case the volume is already claimed.

        :see: https://kubernetes.io/docs/concepts/storage/persistent-volumes/#reserving-a-persistentvolume
        '''
        return typing.cast("PersistentVolumeClaim", jsii.invoke(self, "reserve", []))

    @builtins.property
    @jsii.member(jsii_name="apiObject")
    def _api_object(self) -> _cdk8s_d3d9af27.ApiObject:
        '''The underlying cdk8s API object.

        :see: base.Resource.apiObject
        '''
        return typing.cast(_cdk8s_d3d9af27.ApiObject, jsii.get(self, "apiObject"))

    @builtins.property
    @jsii.member(jsii_name="mode")
    def mode(self) -> PersistentVolumeMode:
        '''Volume mode of this volume.'''
        return typing.cast(PersistentVolumeMode, jsii.get(self, "mode"))

    @builtins.property
    @jsii.member(jsii_name="reclaimPolicy")
    def reclaim_policy(self) -> PersistentVolumeReclaimPolicy:
        '''Reclaim policy of this volume.'''
        return typing.cast(PersistentVolumeReclaimPolicy, jsii.get(self, "reclaimPolicy"))

    @builtins.property
    @jsii.member(jsii_name="resourceType")
    def resource_type(self) -> builtins.str:
        '''The name of a resource type as it appears in the relevant API endpoint.'''
        return typing.cast(builtins.str, jsii.get(self, "resourceType"))

    @builtins.property
    @jsii.member(jsii_name="accessModes")
    def access_modes(self) -> typing.Optional[typing.List[PersistentVolumeAccessMode]]:
        '''Access modes requirement of this claim.'''
        return typing.cast(typing.Optional[typing.List[PersistentVolumeAccessMode]], jsii.get(self, "accessModes"))

    @builtins.property
    @jsii.member(jsii_name="claim")
    def claim(self) -> typing.Optional[IPersistentVolumeClaim]:
        '''PVC this volume is bound to.

        Undefined means this volume is not yet
        claimed by any PVC.
        '''
        return typing.cast(typing.Optional[IPersistentVolumeClaim], jsii.get(self, "claim"))

    @builtins.property
    @jsii.member(jsii_name="mountOptions")
    def mount_options(self) -> typing.Optional[typing.List[builtins.str]]:
        '''Mount options of this volume.'''
        return typing.cast(typing.Optional[typing.List[builtins.str]], jsii.get(self, "mountOptions"))

    @builtins.property
    @jsii.member(jsii_name="storage")
    def storage(self) -> typing.Optional[_cdk8s_d3d9af27.Size]:
        '''Storage size of this volume.'''
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Size], jsii.get(self, "storage"))

    @builtins.property
    @jsii.member(jsii_name="storageClassName")
    def storage_class_name(self) -> typing.Optional[builtins.str]:
        '''Storage class this volume belongs to.'''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "storageClassName"))


@jsii.implements(IPersistentVolumeClaim)
class PersistentVolumeClaim(
    Resource,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-24.PersistentVolumeClaim",
):
    '''A PersistentVolumeClaim (PVC) is a request for storage by a user.

    It is similar to a Pod. Pods consume node resources and PVCs consume PV resources.
    Pods can request specific levels of resources (CPU and Memory).
    Claims can request specific size and access modes
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        access_modes: typing.Optional[typing.Sequence[PersistentVolumeAccessMode]] = None,
        storage: typing.Optional[_cdk8s_d3d9af27.Size] = None,
        storage_class_name: typing.Optional[builtins.str] = None,
        volume: typing.Optional[IPersistentVolume] = None,
        volume_mode: typing.Optional[PersistentVolumeMode] = None,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param access_modes: Contains the access modes the volume should support. Default: - No access modes requirement.
        :param storage: Minimum storage size the volume should have. Default: - No storage requirement.
        :param storage_class_name: Name of the StorageClass required by the claim. When this property is not set, the behavior is as follows:. - If the admission plugin is turned on, the storage class marked as default will be used. - If the admission plugin is turned off, the pvc can only be bound to volumes without a storage class. Default: - Not set.
        :param volume: The PersistentVolume backing this claim. The control plane still checks that storage class, access modes, and requested storage size on the volume are valid. Note that in order to guarantee a proper binding, the volume should also define a ``claimRef`` referring to this claim. Otherwise, the volume may be claimed be other pvc's before it gets a chance to bind to this one. If the volume is managed (i.e not imported), you can use ``pv.claim()`` to easily create a bi-directional bounded claim. Default: - No specific volume binding.
        :param volume_mode: Defines what type of volume is required by the claim. Default: VolumeMode.FILE_SYSTEM
        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3abfe7534ec3dd836824901e48813aac7d2331031ff5a484178f4e5bf50d0cf7)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = PersistentVolumeClaimProps(
            access_modes=access_modes,
            storage=storage,
            storage_class_name=storage_class_name,
            volume=volume,
            volume_mode=volume_mode,
            metadata=metadata,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="fromClaimName")
    @builtins.classmethod
    def from_claim_name(
        cls,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        claim_name: builtins.str,
    ) -> IPersistentVolumeClaim:
        '''Imports a pvc from the cluster as a reference.

        :param scope: -
        :param id: -
        :param claim_name: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__834a7805fa9b712bc7b1b91b24134ecfd146f52f8e29eb955919c88996b0e807)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
            check_type(argname="argument claim_name", value=claim_name, expected_type=type_hints["claim_name"])
        return typing.cast(IPersistentVolumeClaim, jsii.sinvoke(cls, "fromClaimName", [scope, id, claim_name]))

    @jsii.member(jsii_name="bind")
    def bind(self, vol: IPersistentVolume) -> None:
        '''Bind a claim to a specific volume.

        Note that you must also bind the volume to the claim.

        :param vol: The PV to bind to.

        :see: https://kubernetes.io/docs/concepts/storage/persistent-volumes/#binding
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c54e41ebc18bc9685809efe7ef3065a518b74b293dd21f00de4c7c53ab47531d)
            check_type(argname="argument vol", value=vol, expected_type=type_hints["vol"])
        return typing.cast(None, jsii.invoke(self, "bind", [vol]))

    @builtins.property
    @jsii.member(jsii_name="apiObject")
    def _api_object(self) -> _cdk8s_d3d9af27.ApiObject:
        '''The underlying cdk8s API object.

        :see: base.Resource.apiObject
        '''
        return typing.cast(_cdk8s_d3d9af27.ApiObject, jsii.get(self, "apiObject"))

    @builtins.property
    @jsii.member(jsii_name="resourceType")
    def resource_type(self) -> builtins.str:
        '''The name of a resource type as it appears in the relevant API endpoint.'''
        return typing.cast(builtins.str, jsii.get(self, "resourceType"))

    @builtins.property
    @jsii.member(jsii_name="volumeMode")
    def volume_mode(self) -> PersistentVolumeMode:
        '''Volume mode requirement of this claim.'''
        return typing.cast(PersistentVolumeMode, jsii.get(self, "volumeMode"))

    @builtins.property
    @jsii.member(jsii_name="accessModes")
    def access_modes(self) -> typing.Optional[typing.List[PersistentVolumeAccessMode]]:
        '''Access modes requirement of this claim.'''
        return typing.cast(typing.Optional[typing.List[PersistentVolumeAccessMode]], jsii.get(self, "accessModes"))

    @builtins.property
    @jsii.member(jsii_name="storage")
    def storage(self) -> typing.Optional[_cdk8s_d3d9af27.Size]:
        '''Storage requirement of this claim.'''
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Size], jsii.get(self, "storage"))

    @builtins.property
    @jsii.member(jsii_name="storageClassName")
    def storage_class_name(self) -> typing.Optional[builtins.str]:
        '''Storage class requirment of this claim.'''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "storageClassName"))

    @builtins.property
    @jsii.member(jsii_name="volume")
    def volume(self) -> typing.Optional[IPersistentVolume]:
        '''PV this claim is bound to.

        Undefined means the claim is not bound
        to any specific volume.
        '''
        return typing.cast(typing.Optional[IPersistentVolume], jsii.get(self, "volume"))


@jsii.data_type(
    jsii_type="cdk8s-plus-24.PersistentVolumeClaimProps",
    jsii_struct_bases=[ResourceProps],
    name_mapping={
        "metadata": "metadata",
        "access_modes": "accessModes",
        "storage": "storage",
        "storage_class_name": "storageClassName",
        "volume": "volume",
        "volume_mode": "volumeMode",
    },
)
class PersistentVolumeClaimProps(ResourceProps):
    def __init__(
        self,
        *,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        access_modes: typing.Optional[typing.Sequence[PersistentVolumeAccessMode]] = None,
        storage: typing.Optional[_cdk8s_d3d9af27.Size] = None,
        storage_class_name: typing.Optional[builtins.str] = None,
        volume: typing.Optional[IPersistentVolume] = None,
        volume_mode: typing.Optional[PersistentVolumeMode] = None,
    ) -> None:
        '''Properties for ``PersistentVolumeClaim``.

        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        :param access_modes: Contains the access modes the volume should support. Default: - No access modes requirement.
        :param storage: Minimum storage size the volume should have. Default: - No storage requirement.
        :param storage_class_name: Name of the StorageClass required by the claim. When this property is not set, the behavior is as follows:. - If the admission plugin is turned on, the storage class marked as default will be used. - If the admission plugin is turned off, the pvc can only be bound to volumes without a storage class. Default: - Not set.
        :param volume: The PersistentVolume backing this claim. The control plane still checks that storage class, access modes, and requested storage size on the volume are valid. Note that in order to guarantee a proper binding, the volume should also define a ``claimRef`` referring to this claim. Otherwise, the volume may be claimed be other pvc's before it gets a chance to bind to this one. If the volume is managed (i.e not imported), you can use ``pv.claim()`` to easily create a bi-directional bounded claim. Default: - No specific volume binding.
        :param volume_mode: Defines what type of volume is required by the claim. Default: VolumeMode.FILE_SYSTEM
        '''
        if isinstance(metadata, dict):
            metadata = _cdk8s_d3d9af27.ApiObjectMetadata(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c58f0f8882d78b9f852aff7ea51a564f2aae6e025d2ac9faf0aa390cc5ef237e)
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument access_modes", value=access_modes, expected_type=type_hints["access_modes"])
            check_type(argname="argument storage", value=storage, expected_type=type_hints["storage"])
            check_type(argname="argument storage_class_name", value=storage_class_name, expected_type=type_hints["storage_class_name"])
            check_type(argname="argument volume", value=volume, expected_type=type_hints["volume"])
            check_type(argname="argument volume_mode", value=volume_mode, expected_type=type_hints["volume_mode"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if metadata is not None:
            self._values["metadata"] = metadata
        if access_modes is not None:
            self._values["access_modes"] = access_modes
        if storage is not None:
            self._values["storage"] = storage
        if storage_class_name is not None:
            self._values["storage_class_name"] = storage_class_name
        if volume is not None:
            self._values["volume"] = volume
        if volume_mode is not None:
            self._values["volume_mode"] = volume_mode

    @builtins.property
    def metadata(self) -> typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata]:
        '''Metadata that all persisted resources must have, which includes all objects users must create.'''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata], result)

    @builtins.property
    def access_modes(self) -> typing.Optional[typing.List[PersistentVolumeAccessMode]]:
        '''Contains the access modes the volume should support.

        :default: - No access modes requirement.

        :see: https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes-1
        '''
        result = self._values.get("access_modes")
        return typing.cast(typing.Optional[typing.List[PersistentVolumeAccessMode]], result)

    @builtins.property
    def storage(self) -> typing.Optional[_cdk8s_d3d9af27.Size]:
        '''Minimum storage size the volume should have.

        :default: - No storage requirement.

        :see: https://kubernetes.io/docs/concepts/storage/persistent-volumes#resources
        '''
        result = self._values.get("storage")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Size], result)

    @builtins.property
    def storage_class_name(self) -> typing.Optional[builtins.str]:
        '''Name of the StorageClass required by the claim. When this property is not set, the behavior is as follows:.

        - If the admission plugin is turned on, the storage class marked as default will be used.
        - If the admission plugin is turned off, the pvc can only be bound to volumes without a storage class.

        :default: - Not set.

        :see: https://kubernetes.io/docs/concepts/storage/persistent-volumes#class-1
        '''
        result = self._values.get("storage_class_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def volume(self) -> typing.Optional[IPersistentVolume]:
        '''The PersistentVolume backing this claim.

        The control plane still checks that storage class, access modes,
        and requested storage size on the volume are valid.

        Note that in order to guarantee a proper binding, the volume should
        also define a ``claimRef`` referring to this claim. Otherwise, the volume may be
        claimed be other pvc's before it gets a chance to bind to this one.

        If the volume is managed (i.e not imported), you can use ``pv.claim()`` to easily
        create a bi-directional bounded claim.

        :default: - No specific volume binding.

        :see: https://kubernetes.io/docs/concepts/storage/persistent-volumes/#binding.
        '''
        result = self._values.get("volume")
        return typing.cast(typing.Optional[IPersistentVolume], result)

    @builtins.property
    def volume_mode(self) -> typing.Optional[PersistentVolumeMode]:
        '''Defines what type of volume is required by the claim.

        :default: VolumeMode.FILE_SYSTEM
        '''
        result = self._values.get("volume_mode")
        return typing.cast(typing.Optional[PersistentVolumeMode], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "PersistentVolumeClaimProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.PersistentVolumeProps",
    jsii_struct_bases=[ResourceProps],
    name_mapping={
        "metadata": "metadata",
        "access_modes": "accessModes",
        "claim": "claim",
        "mount_options": "mountOptions",
        "reclaim_policy": "reclaimPolicy",
        "storage": "storage",
        "storage_class_name": "storageClassName",
        "volume_mode": "volumeMode",
    },
)
class PersistentVolumeProps(ResourceProps):
    def __init__(
        self,
        *,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        access_modes: typing.Optional[typing.Sequence[PersistentVolumeAccessMode]] = None,
        claim: typing.Optional[IPersistentVolumeClaim] = None,
        mount_options: typing.Optional[typing.Sequence[builtins.str]] = None,
        reclaim_policy: typing.Optional[PersistentVolumeReclaimPolicy] = None,
        storage: typing.Optional[_cdk8s_d3d9af27.Size] = None,
        storage_class_name: typing.Optional[builtins.str] = None,
        volume_mode: typing.Optional[PersistentVolumeMode] = None,
    ) -> None:
        '''Properties for ``PersistentVolume``.

        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        :param access_modes: Contains all ways the volume can be mounted. Default: - No access modes.
        :param claim: Part of a bi-directional binding between PersistentVolume and PersistentVolumeClaim. Expected to be non-nil when bound. Default: - Not bound to a specific claim.
        :param mount_options: A list of mount options, e.g. ["ro", "soft"]. Not validated - mount will simply fail if one is invalid. Default: - No options.
        :param reclaim_policy: When a user is done with their volume, they can delete the PVC objects from the API that allows reclamation of the resource. The reclaim policy tells the cluster what to do with the volume after it has been released of its claim. Default: PersistentVolumeReclaimPolicy.RETAIN
        :param storage: What is the storage capacity of this volume. Default: - No specified.
        :param storage_class_name: Name of StorageClass to which this persistent volume belongs. Default: - Volume does not belong to any storage class.
        :param volume_mode: Defines what type of volume is required by the claim. Default: VolumeMode.FILE_SYSTEM
        '''
        if isinstance(metadata, dict):
            metadata = _cdk8s_d3d9af27.ApiObjectMetadata(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__489c92766616ffe6558afa0921ce48f8049bc9a3e532dc0cf337f8210c363e1e)
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument access_modes", value=access_modes, expected_type=type_hints["access_modes"])
            check_type(argname="argument claim", value=claim, expected_type=type_hints["claim"])
            check_type(argname="argument mount_options", value=mount_options, expected_type=type_hints["mount_options"])
            check_type(argname="argument reclaim_policy", value=reclaim_policy, expected_type=type_hints["reclaim_policy"])
            check_type(argname="argument storage", value=storage, expected_type=type_hints["storage"])
            check_type(argname="argument storage_class_name", value=storage_class_name, expected_type=type_hints["storage_class_name"])
            check_type(argname="argument volume_mode", value=volume_mode, expected_type=type_hints["volume_mode"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if metadata is not None:
            self._values["metadata"] = metadata
        if access_modes is not None:
            self._values["access_modes"] = access_modes
        if claim is not None:
            self._values["claim"] = claim
        if mount_options is not None:
            self._values["mount_options"] = mount_options
        if reclaim_policy is not None:
            self._values["reclaim_policy"] = reclaim_policy
        if storage is not None:
            self._values["storage"] = storage
        if storage_class_name is not None:
            self._values["storage_class_name"] = storage_class_name
        if volume_mode is not None:
            self._values["volume_mode"] = volume_mode

    @builtins.property
    def metadata(self) -> typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata]:
        '''Metadata that all persisted resources must have, which includes all objects users must create.'''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata], result)

    @builtins.property
    def access_modes(self) -> typing.Optional[typing.List[PersistentVolumeAccessMode]]:
        '''Contains all ways the volume can be mounted.

        :default: - No access modes.

        :see: https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes
        '''
        result = self._values.get("access_modes")
        return typing.cast(typing.Optional[typing.List[PersistentVolumeAccessMode]], result)

    @builtins.property
    def claim(self) -> typing.Optional[IPersistentVolumeClaim]:
        '''Part of a bi-directional binding between PersistentVolume and PersistentVolumeClaim.

        Expected to be non-nil when bound.

        :default: - Not bound to a specific claim.

        :see: https://kubernetes.io/docs/concepts/storage/persistent-volumes#binding
        '''
        result = self._values.get("claim")
        return typing.cast(typing.Optional[IPersistentVolumeClaim], result)

    @builtins.property
    def mount_options(self) -> typing.Optional[typing.List[builtins.str]]:
        '''A list of mount options, e.g. ["ro", "soft"]. Not validated - mount will simply fail if one is invalid.

        :default: - No options.

        :see: https://kubernetes.io/docs/concepts/storage/persistent-volumes/#mount-options
        '''
        result = self._values.get("mount_options")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def reclaim_policy(self) -> typing.Optional[PersistentVolumeReclaimPolicy]:
        '''When a user is done with their volume, they can delete the PVC objects from the API that allows reclamation of the resource.

        The reclaim policy tells the cluster what to do with
        the volume after it has been released of its claim.

        :default: PersistentVolumeReclaimPolicy.RETAIN

        :see: https://kubernetes.io/docs/concepts/storage/persistent-volumes#reclaiming
        '''
        result = self._values.get("reclaim_policy")
        return typing.cast(typing.Optional[PersistentVolumeReclaimPolicy], result)

    @builtins.property
    def storage(self) -> typing.Optional[_cdk8s_d3d9af27.Size]:
        '''What is the storage capacity of this volume.

        :default: - No specified.

        :see: https://kubernetes.io/docs/concepts/storage/persistent-volumes#resources
        '''
        result = self._values.get("storage")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Size], result)

    @builtins.property
    def storage_class_name(self) -> typing.Optional[builtins.str]:
        '''Name of StorageClass to which this persistent volume belongs.

        :default: - Volume does not belong to any storage class.
        '''
        result = self._values.get("storage_class_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def volume_mode(self) -> typing.Optional[PersistentVolumeMode]:
        '''Defines what type of volume is required by the claim.

        :default: VolumeMode.FILE_SYSTEM
        '''
        result = self._values.get("volume_mode")
        return typing.cast(typing.Optional[PersistentVolumeMode], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "PersistentVolumeProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class Pod(AbstractPod, metaclass=jsii.JSIIMeta, jsii_type="cdk8s-plus-24.Pod"):
    '''Pod is a collection of containers that can run on a host.

    This resource is
    created by clients and scheduled onto hosts.
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        automount_service_account_token: typing.Optional[builtins.bool] = None,
        containers: typing.Optional[typing.Sequence[typing.Union[ContainerProps, typing.Dict[builtins.str, typing.Any]]]] = None,
        dns: typing.Optional[typing.Union[PodDnsProps, typing.Dict[builtins.str, typing.Any]]] = None,
        docker_registry_auth: typing.Optional[ISecret] = None,
        host_aliases: typing.Optional[typing.Sequence[typing.Union[HostAlias, typing.Dict[builtins.str, typing.Any]]]] = None,
        host_network: typing.Optional[builtins.bool] = None,
        init_containers: typing.Optional[typing.Sequence[typing.Union[ContainerProps, typing.Dict[builtins.str, typing.Any]]]] = None,
        isolate: typing.Optional[builtins.bool] = None,
        restart_policy: typing.Optional[RestartPolicy] = None,
        security_context: typing.Optional[typing.Union[PodSecurityContextProps, typing.Dict[builtins.str, typing.Any]]] = None,
        service_account: typing.Optional[IServiceAccount] = None,
        termination_grace_period: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        volumes: typing.Optional[typing.Sequence[Volume]] = None,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param automount_service_account_token: Indicates whether a service account token should be automatically mounted. Default: false
        :param containers: List of containers belonging to the pod. Containers cannot currently be added or removed. There must be at least one container in a Pod. You can add additionnal containers using ``podSpec.addContainer()`` Default: - No containers. Note that a pod spec must include at least one container.
        :param dns: DNS settings for the pod. Default: policy: DnsPolicy.CLUSTER_FIRST hostnameAsFQDN: false
        :param docker_registry_auth: A secret containing docker credentials for authenticating to a registry. Default: - No auth. Images are assumed to be publicly available.
        :param host_aliases: HostAlias holds the mapping between IP and hostnames that will be injected as an entry in the pod's hosts file.
        :param host_network: Host network for the pod. Default: false
        :param init_containers: List of initialization containers belonging to the pod. Init containers are executed in order prior to containers being started. If any init container fails, the pod is considered to have failed and is handled according to its restartPolicy. The name for an init container or normal container must be unique among all containers. Init containers may not have Lifecycle actions, Readiness probes, Liveness probes, or Startup probes. The resourceRequirements of an init container are taken into account during scheduling by finding the highest request/limit for each resource type, and then using the max of of that value or the sum of the normal containers. Limits are applied to init containers in a similar fashion. Init containers cannot currently be added ,removed or updated. Default: - No init containers.
        :param isolate: Isolates the pod. This will prevent any ingress or egress connections to / from this pod. You can however allow explicit connections post instantiation by using the ``.connections`` property. Default: false
        :param restart_policy: Restart policy for all containers within the pod. Default: RestartPolicy.ALWAYS
        :param security_context: SecurityContext holds pod-level security attributes and common container settings. Default: fsGroupChangePolicy: FsGroupChangePolicy.FsGroupChangePolicy.ALWAYS ensureNonRoot: true
        :param service_account: A service account provides an identity for processes that run in a Pod. When you (a human) access the cluster (for example, using kubectl), you are authenticated by the apiserver as a particular User Account (currently this is usually admin, unless your cluster administrator has customized your cluster). Processes in containers inside pods can also contact the apiserver. When they do, they are authenticated as a particular Service Account (for example, default). Default: - No service account.
        :param termination_grace_period: Grace period until the pod is terminated. Default: Duration.seconds(30)
        :param volumes: List of volumes that can be mounted by containers belonging to the pod. You can also add volumes later using ``podSpec.addVolume()`` Default: - No volumes.
        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__7485f8fefdadfcb874e4efc4f18711d6a03b3c968f4c42f01c924772e4080b58)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = PodProps(
            automount_service_account_token=automount_service_account_token,
            containers=containers,
            dns=dns,
            docker_registry_auth=docker_registry_auth,
            host_aliases=host_aliases,
            host_network=host_network,
            init_containers=init_containers,
            isolate=isolate,
            restart_policy=restart_policy,
            security_context=security_context,
            service_account=service_account,
            termination_grace_period=termination_grace_period,
            volumes=volumes,
            metadata=metadata,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.python.classproperty
    @jsii.member(jsii_name="ADDRESS_LABEL")
    def ADDRESS_LABEL(cls) -> builtins.str:
        '''This label is autoamtically added by cdk8s to any pod.

        It provides
        a unique and stable identifier for the pod.
        '''
        return typing.cast(builtins.str, jsii.sget(cls, "ADDRESS_LABEL"))

    @builtins.property
    @jsii.member(jsii_name="apiObject")
    def _api_object(self) -> _cdk8s_d3d9af27.ApiObject:
        '''The underlying cdk8s API object.

        :see: base.Resource.apiObject
        '''
        return typing.cast(_cdk8s_d3d9af27.ApiObject, jsii.get(self, "apiObject"))

    @builtins.property
    @jsii.member(jsii_name="connections")
    def connections(self) -> PodConnections:
        return typing.cast(PodConnections, jsii.get(self, "connections"))

    @builtins.property
    @jsii.member(jsii_name="podMetadata")
    def pod_metadata(self) -> _cdk8s_d3d9af27.ApiObjectMetadataDefinition:
        return typing.cast(_cdk8s_d3d9af27.ApiObjectMetadataDefinition, jsii.get(self, "podMetadata"))

    @builtins.property
    @jsii.member(jsii_name="resourceType")
    def resource_type(self) -> builtins.str:
        '''The name of a resource type as it appears in the relevant API endpoint.'''
        return typing.cast(builtins.str, jsii.get(self, "resourceType"))

    @builtins.property
    @jsii.member(jsii_name="scheduling")
    def scheduling(self) -> PodScheduling:
        return typing.cast(PodScheduling, jsii.get(self, "scheduling"))


@jsii.data_type(
    jsii_type="cdk8s-plus-24.PodProps",
    jsii_struct_bases=[AbstractPodProps],
    name_mapping={
        "metadata": "metadata",
        "automount_service_account_token": "automountServiceAccountToken",
        "containers": "containers",
        "dns": "dns",
        "docker_registry_auth": "dockerRegistryAuth",
        "host_aliases": "hostAliases",
        "host_network": "hostNetwork",
        "init_containers": "initContainers",
        "isolate": "isolate",
        "restart_policy": "restartPolicy",
        "security_context": "securityContext",
        "service_account": "serviceAccount",
        "termination_grace_period": "terminationGracePeriod",
        "volumes": "volumes",
    },
)
class PodProps(AbstractPodProps):
    def __init__(
        self,
        *,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        automount_service_account_token: typing.Optional[builtins.bool] = None,
        containers: typing.Optional[typing.Sequence[typing.Union[ContainerProps, typing.Dict[builtins.str, typing.Any]]]] = None,
        dns: typing.Optional[typing.Union[PodDnsProps, typing.Dict[builtins.str, typing.Any]]] = None,
        docker_registry_auth: typing.Optional[ISecret] = None,
        host_aliases: typing.Optional[typing.Sequence[typing.Union[HostAlias, typing.Dict[builtins.str, typing.Any]]]] = None,
        host_network: typing.Optional[builtins.bool] = None,
        init_containers: typing.Optional[typing.Sequence[typing.Union[ContainerProps, typing.Dict[builtins.str, typing.Any]]]] = None,
        isolate: typing.Optional[builtins.bool] = None,
        restart_policy: typing.Optional[RestartPolicy] = None,
        security_context: typing.Optional[typing.Union[PodSecurityContextProps, typing.Dict[builtins.str, typing.Any]]] = None,
        service_account: typing.Optional[IServiceAccount] = None,
        termination_grace_period: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        volumes: typing.Optional[typing.Sequence[Volume]] = None,
    ) -> None:
        '''Properties for ``Pod``.

        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        :param automount_service_account_token: Indicates whether a service account token should be automatically mounted. Default: false
        :param containers: List of containers belonging to the pod. Containers cannot currently be added or removed. There must be at least one container in a Pod. You can add additionnal containers using ``podSpec.addContainer()`` Default: - No containers. Note that a pod spec must include at least one container.
        :param dns: DNS settings for the pod. Default: policy: DnsPolicy.CLUSTER_FIRST hostnameAsFQDN: false
        :param docker_registry_auth: A secret containing docker credentials for authenticating to a registry. Default: - No auth. Images are assumed to be publicly available.
        :param host_aliases: HostAlias holds the mapping between IP and hostnames that will be injected as an entry in the pod's hosts file.
        :param host_network: Host network for the pod. Default: false
        :param init_containers: List of initialization containers belonging to the pod. Init containers are executed in order prior to containers being started. If any init container fails, the pod is considered to have failed and is handled according to its restartPolicy. The name for an init container or normal container must be unique among all containers. Init containers may not have Lifecycle actions, Readiness probes, Liveness probes, or Startup probes. The resourceRequirements of an init container are taken into account during scheduling by finding the highest request/limit for each resource type, and then using the max of of that value or the sum of the normal containers. Limits are applied to init containers in a similar fashion. Init containers cannot currently be added ,removed or updated. Default: - No init containers.
        :param isolate: Isolates the pod. This will prevent any ingress or egress connections to / from this pod. You can however allow explicit connections post instantiation by using the ``.connections`` property. Default: false
        :param restart_policy: Restart policy for all containers within the pod. Default: RestartPolicy.ALWAYS
        :param security_context: SecurityContext holds pod-level security attributes and common container settings. Default: fsGroupChangePolicy: FsGroupChangePolicy.FsGroupChangePolicy.ALWAYS ensureNonRoot: true
        :param service_account: A service account provides an identity for processes that run in a Pod. When you (a human) access the cluster (for example, using kubectl), you are authenticated by the apiserver as a particular User Account (currently this is usually admin, unless your cluster administrator has customized your cluster). Processes in containers inside pods can also contact the apiserver. When they do, they are authenticated as a particular Service Account (for example, default). Default: - No service account.
        :param termination_grace_period: Grace period until the pod is terminated. Default: Duration.seconds(30)
        :param volumes: List of volumes that can be mounted by containers belonging to the pod. You can also add volumes later using ``podSpec.addVolume()`` Default: - No volumes.
        '''
        if isinstance(metadata, dict):
            metadata = _cdk8s_d3d9af27.ApiObjectMetadata(**metadata)
        if isinstance(dns, dict):
            dns = PodDnsProps(**dns)
        if isinstance(security_context, dict):
            security_context = PodSecurityContextProps(**security_context)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3472b92fe28acc638200ccd8334d5f3e4f92ab758530115e53dc4f6756aecc3d)
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument automount_service_account_token", value=automount_service_account_token, expected_type=type_hints["automount_service_account_token"])
            check_type(argname="argument containers", value=containers, expected_type=type_hints["containers"])
            check_type(argname="argument dns", value=dns, expected_type=type_hints["dns"])
            check_type(argname="argument docker_registry_auth", value=docker_registry_auth, expected_type=type_hints["docker_registry_auth"])
            check_type(argname="argument host_aliases", value=host_aliases, expected_type=type_hints["host_aliases"])
            check_type(argname="argument host_network", value=host_network, expected_type=type_hints["host_network"])
            check_type(argname="argument init_containers", value=init_containers, expected_type=type_hints["init_containers"])
            check_type(argname="argument isolate", value=isolate, expected_type=type_hints["isolate"])
            check_type(argname="argument restart_policy", value=restart_policy, expected_type=type_hints["restart_policy"])
            check_type(argname="argument security_context", value=security_context, expected_type=type_hints["security_context"])
            check_type(argname="argument service_account", value=service_account, expected_type=type_hints["service_account"])
            check_type(argname="argument termination_grace_period", value=termination_grace_period, expected_type=type_hints["termination_grace_period"])
            check_type(argname="argument volumes", value=volumes, expected_type=type_hints["volumes"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if metadata is not None:
            self._values["metadata"] = metadata
        if automount_service_account_token is not None:
            self._values["automount_service_account_token"] = automount_service_account_token
        if containers is not None:
            self._values["containers"] = containers
        if dns is not None:
            self._values["dns"] = dns
        if docker_registry_auth is not None:
            self._values["docker_registry_auth"] = docker_registry_auth
        if host_aliases is not None:
            self._values["host_aliases"] = host_aliases
        if host_network is not None:
            self._values["host_network"] = host_network
        if init_containers is not None:
            self._values["init_containers"] = init_containers
        if isolate is not None:
            self._values["isolate"] = isolate
        if restart_policy is not None:
            self._values["restart_policy"] = restart_policy
        if security_context is not None:
            self._values["security_context"] = security_context
        if service_account is not None:
            self._values["service_account"] = service_account
        if termination_grace_period is not None:
            self._values["termination_grace_period"] = termination_grace_period
        if volumes is not None:
            self._values["volumes"] = volumes

    @builtins.property
    def metadata(self) -> typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata]:
        '''Metadata that all persisted resources must have, which includes all objects users must create.'''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata], result)

    @builtins.property
    def automount_service_account_token(self) -> typing.Optional[builtins.bool]:
        '''Indicates whether a service account token should be automatically mounted.

        :default: false

        :see: https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/#use-the-default-service-account-to-access-the-api-server
        '''
        result = self._values.get("automount_service_account_token")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def containers(self) -> typing.Optional[typing.List[ContainerProps]]:
        '''List of containers belonging to the pod.

        Containers cannot currently be
        added or removed. There must be at least one container in a Pod.

        You can add additionnal containers using ``podSpec.addContainer()``

        :default: - No containers. Note that a pod spec must include at least one container.
        '''
        result = self._values.get("containers")
        return typing.cast(typing.Optional[typing.List[ContainerProps]], result)

    @builtins.property
    def dns(self) -> typing.Optional[PodDnsProps]:
        '''DNS settings for the pod.

        :default:

        policy: DnsPolicy.CLUSTER_FIRST
        hostnameAsFQDN: false

        :see: https://kubernetes.io/docs/concepts/services-networking/dns-pod-service/
        '''
        result = self._values.get("dns")
        return typing.cast(typing.Optional[PodDnsProps], result)

    @builtins.property
    def docker_registry_auth(self) -> typing.Optional[ISecret]:
        '''A secret containing docker credentials for authenticating to a registry.

        :default: - No auth. Images are assumed to be publicly available.
        '''
        result = self._values.get("docker_registry_auth")
        return typing.cast(typing.Optional[ISecret], result)

    @builtins.property
    def host_aliases(self) -> typing.Optional[typing.List[HostAlias]]:
        '''HostAlias holds the mapping between IP and hostnames that will be injected as an entry in the pod's hosts file.

        :schema: io.k8s.api.core.v1.HostAlias
        '''
        result = self._values.get("host_aliases")
        return typing.cast(typing.Optional[typing.List[HostAlias]], result)

    @builtins.property
    def host_network(self) -> typing.Optional[builtins.bool]:
        '''Host network for the pod.

        :default: false
        '''
        result = self._values.get("host_network")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def init_containers(self) -> typing.Optional[typing.List[ContainerProps]]:
        '''List of initialization containers belonging to the pod.

        Init containers are executed in order prior to containers being started.
        If any init container fails, the pod is considered to have failed and is handled according to its restartPolicy.
        The name for an init container or normal container must be unique among all containers.
        Init containers may not have Lifecycle actions, Readiness probes, Liveness probes, or Startup probes.
        The resourceRequirements of an init container are taken into account during scheduling by finding the highest request/limit
        for each resource type, and then using the max of of that value or the sum of the normal containers.
        Limits are applied to init containers in a similar fashion.

        Init containers cannot currently be added ,removed or updated.

        :default: - No init containers.

        :see: https://kubernetes.io/docs/concepts/workloads/pods/init-containers/
        '''
        result = self._values.get("init_containers")
        return typing.cast(typing.Optional[typing.List[ContainerProps]], result)

    @builtins.property
    def isolate(self) -> typing.Optional[builtins.bool]:
        '''Isolates the pod.

        This will prevent any ingress or egress connections to / from this pod.
        You can however allow explicit connections post instantiation by using the ``.connections`` property.

        :default: false
        '''
        result = self._values.get("isolate")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def restart_policy(self) -> typing.Optional[RestartPolicy]:
        '''Restart policy for all containers within the pod.

        :default: RestartPolicy.ALWAYS

        :see: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle/#restart-policy
        '''
        result = self._values.get("restart_policy")
        return typing.cast(typing.Optional[RestartPolicy], result)

    @builtins.property
    def security_context(self) -> typing.Optional[PodSecurityContextProps]:
        '''SecurityContext holds pod-level security attributes and common container settings.

        :default:

        fsGroupChangePolicy: FsGroupChangePolicy.FsGroupChangePolicy.ALWAYS
        ensureNonRoot: true
        '''
        result = self._values.get("security_context")
        return typing.cast(typing.Optional[PodSecurityContextProps], result)

    @builtins.property
    def service_account(self) -> typing.Optional[IServiceAccount]:
        '''A service account provides an identity for processes that run in a Pod.

        When you (a human) access the cluster (for example, using kubectl), you are
        authenticated by the apiserver as a particular User Account (currently this
        is usually admin, unless your cluster administrator has customized your
        cluster). Processes in containers inside pods can also contact the
        apiserver. When they do, they are authenticated as a particular Service
        Account (for example, default).

        :default: - No service account.

        :see: https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/
        '''
        result = self._values.get("service_account")
        return typing.cast(typing.Optional[IServiceAccount], result)

    @builtins.property
    def termination_grace_period(self) -> typing.Optional[_cdk8s_d3d9af27.Duration]:
        '''Grace period until the pod is terminated.

        :default: Duration.seconds(30)
        '''
        result = self._values.get("termination_grace_period")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Duration], result)

    @builtins.property
    def volumes(self) -> typing.Optional[typing.List[Volume]]:
        '''List of volumes that can be mounted by containers belonging to the pod.

        You can also add volumes later using ``podSpec.addVolume()``

        :default: - No volumes.

        :see: https://kubernetes.io/docs/concepts/storage/volumes
        '''
        result = self._values.get("volumes")
        return typing.cast(typing.Optional[typing.List[Volume]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "PodProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.SecretProps",
    jsii_struct_bases=[CommonSecretProps],
    name_mapping={
        "metadata": "metadata",
        "immutable": "immutable",
        "string_data": "stringData",
        "type": "type",
    },
)
class SecretProps(CommonSecretProps):
    def __init__(
        self,
        *,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        immutable: typing.Optional[builtins.bool] = None,
        string_data: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        type: typing.Optional[builtins.str] = None,
    ) -> None:
        '''Options for ``Secret``.

        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        :param immutable: If set to true, ensures that data stored in the Secret cannot be updated (only object metadata can be modified). If not set to true, the field can be modified at any time. Default: false
        :param string_data: stringData allows specifying non-binary secret data in string form. It is provided as a write-only convenience method. All keys and values are merged into the data field on write, overwriting any existing values. It is never output when reading from the API.
        :param type: Optional type associated with the secret. Used to facilitate programmatic handling of secret data by various controllers. Default: undefined - Don't set a type.
        '''
        if isinstance(metadata, dict):
            metadata = _cdk8s_d3d9af27.ApiObjectMetadata(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5d9c3678ac25a0c4a29be55acfc261db1dc923f1f56b5143fc3222fcb27cf3f2)
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument immutable", value=immutable, expected_type=type_hints["immutable"])
            check_type(argname="argument string_data", value=string_data, expected_type=type_hints["string_data"])
            check_type(argname="argument type", value=type, expected_type=type_hints["type"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if metadata is not None:
            self._values["metadata"] = metadata
        if immutable is not None:
            self._values["immutable"] = immutable
        if string_data is not None:
            self._values["string_data"] = string_data
        if type is not None:
            self._values["type"] = type

    @builtins.property
    def metadata(self) -> typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata]:
        '''Metadata that all persisted resources must have, which includes all objects users must create.'''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata], result)

    @builtins.property
    def immutable(self) -> typing.Optional[builtins.bool]:
        '''If set to true, ensures that data stored in the Secret cannot be updated (only object metadata can be modified).

        If not set to true, the field can be modified at any time.

        :default: false
        '''
        result = self._values.get("immutable")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def string_data(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        '''stringData allows specifying non-binary secret data in string form.

        It is
        provided as a write-only convenience method. All keys and values are merged
        into the data field on write, overwriting any existing values. It is never
        output when reading from the API.
        '''
        result = self._values.get("string_data")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, builtins.str]], result)

    @builtins.property
    def type(self) -> typing.Optional[builtins.str]:
        '''Optional type associated with the secret.

        Used to facilitate programmatic
        handling of secret data by various controllers.

        :default: undefined - Don't set a type.
        '''
        result = self._values.get("type")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "SecretProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(IServiceAccount, ISubject)
class ServiceAccount(
    Resource,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-24.ServiceAccount",
):
    '''A service account provides an identity for processes that run in a Pod.

    When you (a human) access the cluster (for example, using kubectl), you are
    authenticated by the apiserver as a particular User Account (currently this
    is usually admin, unless your cluster administrator has customized your
    cluster). Processes in containers inside pods can also contact the apiserver.
    When they do, they are authenticated as a particular Service Account (for
    example, default).

    :see: https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        automount_token: typing.Optional[builtins.bool] = None,
        secrets: typing.Optional[typing.Sequence[ISecret]] = None,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param automount_token: Indicates whether pods running as this service account should have an API token automatically mounted. Can be overridden at the pod level. Default: false
        :param secrets: List of secrets allowed to be used by pods running using this ServiceAccount.
        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b504c6568e181dc1b912567bdf66fcaa4668bacf381c071e7e7f310317ebbec4)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = ServiceAccountProps(
            automount_token=automount_token, secrets=secrets, metadata=metadata
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="fromServiceAccountName")
    @builtins.classmethod
    def from_service_account_name(
        cls,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        name: builtins.str,
        *,
        namespace_name: typing.Optional[builtins.str] = None,
    ) -> IServiceAccount:
        '''Imports a service account from the cluster as a reference.

        :param scope: -
        :param id: -
        :param name: The name of the service account resource.
        :param namespace_name: The name of the namespace the service account belongs to. Default: "default"
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2e90ec5e88a86b0c7554a8c23ca3b0aead7666fc8abfac288e856c5d7dedace3)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
        options = FromServiceAccountNameOptions(namespace_name=namespace_name)

        return typing.cast(IServiceAccount, jsii.sinvoke(cls, "fromServiceAccountName", [scope, id, name, options]))

    @jsii.member(jsii_name="addSecret")
    def add_secret(self, secr: ISecret) -> None:
        '''Allow a secret to be accessed by pods using this service account.

        :param secr: The secret.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__495c1dce3698a3d30db30ba3cea7f304fa86e32cbdd5d096dbfffe6c962151c3)
            check_type(argname="argument secr", value=secr, expected_type=type_hints["secr"])
        return typing.cast(None, jsii.invoke(self, "addSecret", [secr]))

    @jsii.member(jsii_name="toSubjectConfiguration")
    def to_subject_configuration(self) -> SubjectConfiguration:
        '''Return the subject configuration.

        :see: ISubect.toSubjectConfiguration()
        '''
        return typing.cast(SubjectConfiguration, jsii.invoke(self, "toSubjectConfiguration", []))

    @builtins.property
    @jsii.member(jsii_name="apiObject")
    def _api_object(self) -> _cdk8s_d3d9af27.ApiObject:
        '''The underlying cdk8s API object.

        :see: base.Resource.apiObject
        '''
        return typing.cast(_cdk8s_d3d9af27.ApiObject, jsii.get(self, "apiObject"))

    @builtins.property
    @jsii.member(jsii_name="automountToken")
    def automount_token(self) -> builtins.bool:
        '''Whether or not a token is automatically mounted for this service account.'''
        return typing.cast(builtins.bool, jsii.get(self, "automountToken"))

    @builtins.property
    @jsii.member(jsii_name="resourceType")
    def resource_type(self) -> builtins.str:
        '''The name of a resource type as it appears in the relevant API endpoint.'''
        return typing.cast(builtins.str, jsii.get(self, "resourceType"))

    @builtins.property
    @jsii.member(jsii_name="secrets")
    def secrets(self) -> typing.List[ISecret]:
        '''List of secrets allowed to be used by pods running using this service account.

        Returns a copy. To add a secret, use ``addSecret()``.
        '''
        return typing.cast(typing.List[ISecret], jsii.get(self, "secrets"))


@jsii.data_type(
    jsii_type="cdk8s-plus-24.ServiceAccountTokenSecretProps",
    jsii_struct_bases=[CommonSecretProps],
    name_mapping={
        "metadata": "metadata",
        "immutable": "immutable",
        "service_account": "serviceAccount",
    },
)
class ServiceAccountTokenSecretProps(CommonSecretProps):
    def __init__(
        self,
        *,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        immutable: typing.Optional[builtins.bool] = None,
        service_account: IServiceAccount,
    ) -> None:
        '''Options for ``ServiceAccountTokenSecret``.

        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        :param immutable: If set to true, ensures that data stored in the Secret cannot be updated (only object metadata can be modified). If not set to true, the field can be modified at any time. Default: false
        :param service_account: The service account to store a secret for.
        '''
        if isinstance(metadata, dict):
            metadata = _cdk8s_d3d9af27.ApiObjectMetadata(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b080df240f8943ac12dc829f8955fbe3b73f27f2042306216093af95ccbc269d)
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument immutable", value=immutable, expected_type=type_hints["immutable"])
            check_type(argname="argument service_account", value=service_account, expected_type=type_hints["service_account"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "service_account": service_account,
        }
        if metadata is not None:
            self._values["metadata"] = metadata
        if immutable is not None:
            self._values["immutable"] = immutable

    @builtins.property
    def metadata(self) -> typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata]:
        '''Metadata that all persisted resources must have, which includes all objects users must create.'''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata], result)

    @builtins.property
    def immutable(self) -> typing.Optional[builtins.bool]:
        '''If set to true, ensures that data stored in the Secret cannot be updated (only object metadata can be modified).

        If not set to true, the field can be modified at any time.

        :default: false
        '''
        result = self._values.get("immutable")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def service_account(self) -> IServiceAccount:
        '''The service account to store a secret for.'''
        result = self._values.get("service_account")
        assert result is not None, "Required property 'service_account' is missing"
        return typing.cast(IServiceAccount, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ServiceAccountTokenSecretProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.SshAuthSecretProps",
    jsii_struct_bases=[CommonSecretProps],
    name_mapping={
        "metadata": "metadata",
        "immutable": "immutable",
        "ssh_private_key": "sshPrivateKey",
    },
)
class SshAuthSecretProps(CommonSecretProps):
    def __init__(
        self,
        *,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        immutable: typing.Optional[builtins.bool] = None,
        ssh_private_key: builtins.str,
    ) -> None:
        '''Options for ``SshAuthSecret``.

        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        :param immutable: If set to true, ensures that data stored in the Secret cannot be updated (only object metadata can be modified). If not set to true, the field can be modified at any time. Default: false
        :param ssh_private_key: The SSH private key to use.
        '''
        if isinstance(metadata, dict):
            metadata = _cdk8s_d3d9af27.ApiObjectMetadata(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__93846ffcfaa6f3a1c5407a422379c704d23c676b21d08a8adad98102fabb9a95)
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument immutable", value=immutable, expected_type=type_hints["immutable"])
            check_type(argname="argument ssh_private_key", value=ssh_private_key, expected_type=type_hints["ssh_private_key"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "ssh_private_key": ssh_private_key,
        }
        if metadata is not None:
            self._values["metadata"] = metadata
        if immutable is not None:
            self._values["immutable"] = immutable

    @builtins.property
    def metadata(self) -> typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata]:
        '''Metadata that all persisted resources must have, which includes all objects users must create.'''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata], result)

    @builtins.property
    def immutable(self) -> typing.Optional[builtins.bool]:
        '''If set to true, ensures that data stored in the Secret cannot be updated (only object metadata can be modified).

        If not set to true, the field can be modified at any time.

        :default: false
        '''
        result = self._values.get("immutable")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def ssh_private_key(self) -> builtins.str:
        '''The SSH private key to use.'''
        result = self._values.get("ssh_private_key")
        assert result is not None, "Required property 'ssh_private_key' is missing"
        return typing.cast(builtins.str, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "SshAuthSecretProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.TlsSecretProps",
    jsii_struct_bases=[CommonSecretProps],
    name_mapping={
        "metadata": "metadata",
        "immutable": "immutable",
        "tls_cert": "tlsCert",
        "tls_key": "tlsKey",
    },
)
class TlsSecretProps(CommonSecretProps):
    def __init__(
        self,
        *,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        immutable: typing.Optional[builtins.bool] = None,
        tls_cert: builtins.str,
        tls_key: builtins.str,
    ) -> None:
        '''Options for ``TlsSecret``.

        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        :param immutable: If set to true, ensures that data stored in the Secret cannot be updated (only object metadata can be modified). If not set to true, the field can be modified at any time. Default: false
        :param tls_cert: The TLS cert.
        :param tls_key: The TLS key.
        '''
        if isinstance(metadata, dict):
            metadata = _cdk8s_d3d9af27.ApiObjectMetadata(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1973cd87b5209c9e9638f17120f15b78e3c0a84b3909ce035fed6de34e2088fa)
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument immutable", value=immutable, expected_type=type_hints["immutable"])
            check_type(argname="argument tls_cert", value=tls_cert, expected_type=type_hints["tls_cert"])
            check_type(argname="argument tls_key", value=tls_key, expected_type=type_hints["tls_key"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "tls_cert": tls_cert,
            "tls_key": tls_key,
        }
        if metadata is not None:
            self._values["metadata"] = metadata
        if immutable is not None:
            self._values["immutable"] = immutable

    @builtins.property
    def metadata(self) -> typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata]:
        '''Metadata that all persisted resources must have, which includes all objects users must create.'''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata], result)

    @builtins.property
    def immutable(self) -> typing.Optional[builtins.bool]:
        '''If set to true, ensures that data stored in the Secret cannot be updated (only object metadata can be modified).

        If not set to true, the field can be modified at any time.

        :default: false
        '''
        result = self._values.get("immutable")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def tls_cert(self) -> builtins.str:
        '''The TLS cert.'''
        result = self._values.get("tls_cert")
        assert result is not None, "Required property 'tls_cert' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def tls_key(self) -> builtins.str:
        '''The TLS key.'''
        result = self._values.get("tls_key")
        assert result is not None, "Required property 'tls_key' is missing"
        return typing.cast(builtins.str, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TlsSecretProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class Workload(
    AbstractPod,
    metaclass=jsii.JSIIAbstractClass,
    jsii_type="cdk8s-plus-24.Workload",
):
    '''A workload is an application running on Kubernetes.

    Whether your workload is a single
    component or several that work together, on Kubernetes you run it inside a set of pods.
    In Kubernetes, a Pod represents a set of running containers on your cluster.
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        pod_metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        select: typing.Optional[builtins.bool] = None,
        spread: typing.Optional[builtins.bool] = None,
        automount_service_account_token: typing.Optional[builtins.bool] = None,
        containers: typing.Optional[typing.Sequence[typing.Union[ContainerProps, typing.Dict[builtins.str, typing.Any]]]] = None,
        dns: typing.Optional[typing.Union[PodDnsProps, typing.Dict[builtins.str, typing.Any]]] = None,
        docker_registry_auth: typing.Optional[ISecret] = None,
        host_aliases: typing.Optional[typing.Sequence[typing.Union[HostAlias, typing.Dict[builtins.str, typing.Any]]]] = None,
        host_network: typing.Optional[builtins.bool] = None,
        init_containers: typing.Optional[typing.Sequence[typing.Union[ContainerProps, typing.Dict[builtins.str, typing.Any]]]] = None,
        isolate: typing.Optional[builtins.bool] = None,
        restart_policy: typing.Optional[RestartPolicy] = None,
        security_context: typing.Optional[typing.Union[PodSecurityContextProps, typing.Dict[builtins.str, typing.Any]]] = None,
        service_account: typing.Optional[IServiceAccount] = None,
        termination_grace_period: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        volumes: typing.Optional[typing.Sequence[Volume]] = None,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param pod_metadata: The pod metadata of this workload.
        :param select: Automatically allocates a pod label selector for this workload and add it to the pod metadata. This ensures this workload manages pods created by its pod template. Default: true
        :param spread: Automatically spread pods across hostname and zones. Default: false
        :param automount_service_account_token: Indicates whether a service account token should be automatically mounted. Default: false
        :param containers: List of containers belonging to the pod. Containers cannot currently be added or removed. There must be at least one container in a Pod. You can add additionnal containers using ``podSpec.addContainer()`` Default: - No containers. Note that a pod spec must include at least one container.
        :param dns: DNS settings for the pod. Default: policy: DnsPolicy.CLUSTER_FIRST hostnameAsFQDN: false
        :param docker_registry_auth: A secret containing docker credentials for authenticating to a registry. Default: - No auth. Images are assumed to be publicly available.
        :param host_aliases: HostAlias holds the mapping between IP and hostnames that will be injected as an entry in the pod's hosts file.
        :param host_network: Host network for the pod. Default: false
        :param init_containers: List of initialization containers belonging to the pod. Init containers are executed in order prior to containers being started. If any init container fails, the pod is considered to have failed and is handled according to its restartPolicy. The name for an init container or normal container must be unique among all containers. Init containers may not have Lifecycle actions, Readiness probes, Liveness probes, or Startup probes. The resourceRequirements of an init container are taken into account during scheduling by finding the highest request/limit for each resource type, and then using the max of of that value or the sum of the normal containers. Limits are applied to init containers in a similar fashion. Init containers cannot currently be added ,removed or updated. Default: - No init containers.
        :param isolate: Isolates the pod. This will prevent any ingress or egress connections to / from this pod. You can however allow explicit connections post instantiation by using the ``.connections`` property. Default: false
        :param restart_policy: Restart policy for all containers within the pod. Default: RestartPolicy.ALWAYS
        :param security_context: SecurityContext holds pod-level security attributes and common container settings. Default: fsGroupChangePolicy: FsGroupChangePolicy.FsGroupChangePolicy.ALWAYS ensureNonRoot: true
        :param service_account: A service account provides an identity for processes that run in a Pod. When you (a human) access the cluster (for example, using kubectl), you are authenticated by the apiserver as a particular User Account (currently this is usually admin, unless your cluster administrator has customized your cluster). Processes in containers inside pods can also contact the apiserver. When they do, they are authenticated as a particular Service Account (for example, default). Default: - No service account.
        :param termination_grace_period: Grace period until the pod is terminated. Default: Duration.seconds(30)
        :param volumes: List of volumes that can be mounted by containers belonging to the pod. You can also add volumes later using ``podSpec.addVolume()`` Default: - No volumes.
        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ca3d378e4a0004b08feb5913c6193b2e19a1bb35e4e305ae77d59454fc094677)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = WorkloadProps(
            pod_metadata=pod_metadata,
            select=select,
            spread=spread,
            automount_service_account_token=automount_service_account_token,
            containers=containers,
            dns=dns,
            docker_registry_auth=docker_registry_auth,
            host_aliases=host_aliases,
            host_network=host_network,
            init_containers=init_containers,
            isolate=isolate,
            restart_policy=restart_policy,
            security_context=security_context,
            service_account=service_account,
            termination_grace_period=termination_grace_period,
            volumes=volumes,
            metadata=metadata,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="select")
    def select(self, *selectors: LabelSelector) -> None:
        '''Configure selectors for this workload.

        :param selectors: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__7984f408892a59d3851eea1e949c3c771322077525f3334ff548ef91e4be0799)
            check_type(argname="argument selectors", value=selectors, expected_type=typing.Tuple[type_hints["selectors"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast(None, jsii.invoke(self, "select", [*selectors]))

    @builtins.property
    @jsii.member(jsii_name="connections")
    def connections(self) -> PodConnections:
        return typing.cast(PodConnections, jsii.get(self, "connections"))

    @builtins.property
    @jsii.member(jsii_name="matchExpressions")
    def match_expressions(self) -> typing.List[LabelSelectorRequirement]:
        '''The expression matchers this workload will use in order to select pods.

        Returns a a copy. Use ``select()`` to add expression matchers.
        '''
        return typing.cast(typing.List[LabelSelectorRequirement], jsii.get(self, "matchExpressions"))

    @builtins.property
    @jsii.member(jsii_name="matchLabels")
    def match_labels(self) -> typing.Mapping[builtins.str, builtins.str]:
        '''The label matchers this workload will use in order to select pods.

        Returns a a copy. Use ``select()`` to add label matchers.
        '''
        return typing.cast(typing.Mapping[builtins.str, builtins.str], jsii.get(self, "matchLabels"))

    @builtins.property
    @jsii.member(jsii_name="podMetadata")
    def pod_metadata(self) -> _cdk8s_d3d9af27.ApiObjectMetadataDefinition:
        '''The metadata of pods in this workload.'''
        return typing.cast(_cdk8s_d3d9af27.ApiObjectMetadataDefinition, jsii.get(self, "podMetadata"))

    @builtins.property
    @jsii.member(jsii_name="scheduling")
    def scheduling(self) -> WorkloadScheduling:
        return typing.cast(WorkloadScheduling, jsii.get(self, "scheduling"))


class _WorkloadProxy(
    Workload,
    jsii.proxy_for(AbstractPod), # type: ignore[misc]
):
    pass

# Adding a "__jsii_proxy_class__(): typing.Type" function to the abstract class
typing.cast(typing.Any, Workload).__jsii_proxy_class__ = lambda : _WorkloadProxy


@jsii.data_type(
    jsii_type="cdk8s-plus-24.WorkloadProps",
    jsii_struct_bases=[AbstractPodProps],
    name_mapping={
        "metadata": "metadata",
        "automount_service_account_token": "automountServiceAccountToken",
        "containers": "containers",
        "dns": "dns",
        "docker_registry_auth": "dockerRegistryAuth",
        "host_aliases": "hostAliases",
        "host_network": "hostNetwork",
        "init_containers": "initContainers",
        "isolate": "isolate",
        "restart_policy": "restartPolicy",
        "security_context": "securityContext",
        "service_account": "serviceAccount",
        "termination_grace_period": "terminationGracePeriod",
        "volumes": "volumes",
        "pod_metadata": "podMetadata",
        "select": "select",
        "spread": "spread",
    },
)
class WorkloadProps(AbstractPodProps):
    def __init__(
        self,
        *,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        automount_service_account_token: typing.Optional[builtins.bool] = None,
        containers: typing.Optional[typing.Sequence[typing.Union[ContainerProps, typing.Dict[builtins.str, typing.Any]]]] = None,
        dns: typing.Optional[typing.Union[PodDnsProps, typing.Dict[builtins.str, typing.Any]]] = None,
        docker_registry_auth: typing.Optional[ISecret] = None,
        host_aliases: typing.Optional[typing.Sequence[typing.Union[HostAlias, typing.Dict[builtins.str, typing.Any]]]] = None,
        host_network: typing.Optional[builtins.bool] = None,
        init_containers: typing.Optional[typing.Sequence[typing.Union[ContainerProps, typing.Dict[builtins.str, typing.Any]]]] = None,
        isolate: typing.Optional[builtins.bool] = None,
        restart_policy: typing.Optional[RestartPolicy] = None,
        security_context: typing.Optional[typing.Union[PodSecurityContextProps, typing.Dict[builtins.str, typing.Any]]] = None,
        service_account: typing.Optional[IServiceAccount] = None,
        termination_grace_period: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        volumes: typing.Optional[typing.Sequence[Volume]] = None,
        pod_metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        select: typing.Optional[builtins.bool] = None,
        spread: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''Properties for ``Workload``.

        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        :param automount_service_account_token: Indicates whether a service account token should be automatically mounted. Default: false
        :param containers: List of containers belonging to the pod. Containers cannot currently be added or removed. There must be at least one container in a Pod. You can add additionnal containers using ``podSpec.addContainer()`` Default: - No containers. Note that a pod spec must include at least one container.
        :param dns: DNS settings for the pod. Default: policy: DnsPolicy.CLUSTER_FIRST hostnameAsFQDN: false
        :param docker_registry_auth: A secret containing docker credentials for authenticating to a registry. Default: - No auth. Images are assumed to be publicly available.
        :param host_aliases: HostAlias holds the mapping between IP and hostnames that will be injected as an entry in the pod's hosts file.
        :param host_network: Host network for the pod. Default: false
        :param init_containers: List of initialization containers belonging to the pod. Init containers are executed in order prior to containers being started. If any init container fails, the pod is considered to have failed and is handled according to its restartPolicy. The name for an init container or normal container must be unique among all containers. Init containers may not have Lifecycle actions, Readiness probes, Liveness probes, or Startup probes. The resourceRequirements of an init container are taken into account during scheduling by finding the highest request/limit for each resource type, and then using the max of of that value or the sum of the normal containers. Limits are applied to init containers in a similar fashion. Init containers cannot currently be added ,removed or updated. Default: - No init containers.
        :param isolate: Isolates the pod. This will prevent any ingress or egress connections to / from this pod. You can however allow explicit connections post instantiation by using the ``.connections`` property. Default: false
        :param restart_policy: Restart policy for all containers within the pod. Default: RestartPolicy.ALWAYS
        :param security_context: SecurityContext holds pod-level security attributes and common container settings. Default: fsGroupChangePolicy: FsGroupChangePolicy.FsGroupChangePolicy.ALWAYS ensureNonRoot: true
        :param service_account: A service account provides an identity for processes that run in a Pod. When you (a human) access the cluster (for example, using kubectl), you are authenticated by the apiserver as a particular User Account (currently this is usually admin, unless your cluster administrator has customized your cluster). Processes in containers inside pods can also contact the apiserver. When they do, they are authenticated as a particular Service Account (for example, default). Default: - No service account.
        :param termination_grace_period: Grace period until the pod is terminated. Default: Duration.seconds(30)
        :param volumes: List of volumes that can be mounted by containers belonging to the pod. You can also add volumes later using ``podSpec.addVolume()`` Default: - No volumes.
        :param pod_metadata: The pod metadata of this workload.
        :param select: Automatically allocates a pod label selector for this workload and add it to the pod metadata. This ensures this workload manages pods created by its pod template. Default: true
        :param spread: Automatically spread pods across hostname and zones. Default: false
        '''
        if isinstance(metadata, dict):
            metadata = _cdk8s_d3d9af27.ApiObjectMetadata(**metadata)
        if isinstance(dns, dict):
            dns = PodDnsProps(**dns)
        if isinstance(security_context, dict):
            security_context = PodSecurityContextProps(**security_context)
        if isinstance(pod_metadata, dict):
            pod_metadata = _cdk8s_d3d9af27.ApiObjectMetadata(**pod_metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2169afa5eeafbb7e9742e7ce1b7e9e7ad437756997ac69f0cfb9d40b063bccf5)
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument automount_service_account_token", value=automount_service_account_token, expected_type=type_hints["automount_service_account_token"])
            check_type(argname="argument containers", value=containers, expected_type=type_hints["containers"])
            check_type(argname="argument dns", value=dns, expected_type=type_hints["dns"])
            check_type(argname="argument docker_registry_auth", value=docker_registry_auth, expected_type=type_hints["docker_registry_auth"])
            check_type(argname="argument host_aliases", value=host_aliases, expected_type=type_hints["host_aliases"])
            check_type(argname="argument host_network", value=host_network, expected_type=type_hints["host_network"])
            check_type(argname="argument init_containers", value=init_containers, expected_type=type_hints["init_containers"])
            check_type(argname="argument isolate", value=isolate, expected_type=type_hints["isolate"])
            check_type(argname="argument restart_policy", value=restart_policy, expected_type=type_hints["restart_policy"])
            check_type(argname="argument security_context", value=security_context, expected_type=type_hints["security_context"])
            check_type(argname="argument service_account", value=service_account, expected_type=type_hints["service_account"])
            check_type(argname="argument termination_grace_period", value=termination_grace_period, expected_type=type_hints["termination_grace_period"])
            check_type(argname="argument volumes", value=volumes, expected_type=type_hints["volumes"])
            check_type(argname="argument pod_metadata", value=pod_metadata, expected_type=type_hints["pod_metadata"])
            check_type(argname="argument select", value=select, expected_type=type_hints["select"])
            check_type(argname="argument spread", value=spread, expected_type=type_hints["spread"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if metadata is not None:
            self._values["metadata"] = metadata
        if automount_service_account_token is not None:
            self._values["automount_service_account_token"] = automount_service_account_token
        if containers is not None:
            self._values["containers"] = containers
        if dns is not None:
            self._values["dns"] = dns
        if docker_registry_auth is not None:
            self._values["docker_registry_auth"] = docker_registry_auth
        if host_aliases is not None:
            self._values["host_aliases"] = host_aliases
        if host_network is not None:
            self._values["host_network"] = host_network
        if init_containers is not None:
            self._values["init_containers"] = init_containers
        if isolate is not None:
            self._values["isolate"] = isolate
        if restart_policy is not None:
            self._values["restart_policy"] = restart_policy
        if security_context is not None:
            self._values["security_context"] = security_context
        if service_account is not None:
            self._values["service_account"] = service_account
        if termination_grace_period is not None:
            self._values["termination_grace_period"] = termination_grace_period
        if volumes is not None:
            self._values["volumes"] = volumes
        if pod_metadata is not None:
            self._values["pod_metadata"] = pod_metadata
        if select is not None:
            self._values["select"] = select
        if spread is not None:
            self._values["spread"] = spread

    @builtins.property
    def metadata(self) -> typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata]:
        '''Metadata that all persisted resources must have, which includes all objects users must create.'''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata], result)

    @builtins.property
    def automount_service_account_token(self) -> typing.Optional[builtins.bool]:
        '''Indicates whether a service account token should be automatically mounted.

        :default: false

        :see: https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/#use-the-default-service-account-to-access-the-api-server
        '''
        result = self._values.get("automount_service_account_token")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def containers(self) -> typing.Optional[typing.List[ContainerProps]]:
        '''List of containers belonging to the pod.

        Containers cannot currently be
        added or removed. There must be at least one container in a Pod.

        You can add additionnal containers using ``podSpec.addContainer()``

        :default: - No containers. Note that a pod spec must include at least one container.
        '''
        result = self._values.get("containers")
        return typing.cast(typing.Optional[typing.List[ContainerProps]], result)

    @builtins.property
    def dns(self) -> typing.Optional[PodDnsProps]:
        '''DNS settings for the pod.

        :default:

        policy: DnsPolicy.CLUSTER_FIRST
        hostnameAsFQDN: false

        :see: https://kubernetes.io/docs/concepts/services-networking/dns-pod-service/
        '''
        result = self._values.get("dns")
        return typing.cast(typing.Optional[PodDnsProps], result)

    @builtins.property
    def docker_registry_auth(self) -> typing.Optional[ISecret]:
        '''A secret containing docker credentials for authenticating to a registry.

        :default: - No auth. Images are assumed to be publicly available.
        '''
        result = self._values.get("docker_registry_auth")
        return typing.cast(typing.Optional[ISecret], result)

    @builtins.property
    def host_aliases(self) -> typing.Optional[typing.List[HostAlias]]:
        '''HostAlias holds the mapping between IP and hostnames that will be injected as an entry in the pod's hosts file.

        :schema: io.k8s.api.core.v1.HostAlias
        '''
        result = self._values.get("host_aliases")
        return typing.cast(typing.Optional[typing.List[HostAlias]], result)

    @builtins.property
    def host_network(self) -> typing.Optional[builtins.bool]:
        '''Host network for the pod.

        :default: false
        '''
        result = self._values.get("host_network")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def init_containers(self) -> typing.Optional[typing.List[ContainerProps]]:
        '''List of initialization containers belonging to the pod.

        Init containers are executed in order prior to containers being started.
        If any init container fails, the pod is considered to have failed and is handled according to its restartPolicy.
        The name for an init container or normal container must be unique among all containers.
        Init containers may not have Lifecycle actions, Readiness probes, Liveness probes, or Startup probes.
        The resourceRequirements of an init container are taken into account during scheduling by finding the highest request/limit
        for each resource type, and then using the max of of that value or the sum of the normal containers.
        Limits are applied to init containers in a similar fashion.

        Init containers cannot currently be added ,removed or updated.

        :default: - No init containers.

        :see: https://kubernetes.io/docs/concepts/workloads/pods/init-containers/
        '''
        result = self._values.get("init_containers")
        return typing.cast(typing.Optional[typing.List[ContainerProps]], result)

    @builtins.property
    def isolate(self) -> typing.Optional[builtins.bool]:
        '''Isolates the pod.

        This will prevent any ingress or egress connections to / from this pod.
        You can however allow explicit connections post instantiation by using the ``.connections`` property.

        :default: false
        '''
        result = self._values.get("isolate")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def restart_policy(self) -> typing.Optional[RestartPolicy]:
        '''Restart policy for all containers within the pod.

        :default: RestartPolicy.ALWAYS

        :see: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle/#restart-policy
        '''
        result = self._values.get("restart_policy")
        return typing.cast(typing.Optional[RestartPolicy], result)

    @builtins.property
    def security_context(self) -> typing.Optional[PodSecurityContextProps]:
        '''SecurityContext holds pod-level security attributes and common container settings.

        :default:

        fsGroupChangePolicy: FsGroupChangePolicy.FsGroupChangePolicy.ALWAYS
        ensureNonRoot: true
        '''
        result = self._values.get("security_context")
        return typing.cast(typing.Optional[PodSecurityContextProps], result)

    @builtins.property
    def service_account(self) -> typing.Optional[IServiceAccount]:
        '''A service account provides an identity for processes that run in a Pod.

        When you (a human) access the cluster (for example, using kubectl), you are
        authenticated by the apiserver as a particular User Account (currently this
        is usually admin, unless your cluster administrator has customized your
        cluster). Processes in containers inside pods can also contact the
        apiserver. When they do, they are authenticated as a particular Service
        Account (for example, default).

        :default: - No service account.

        :see: https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/
        '''
        result = self._values.get("service_account")
        return typing.cast(typing.Optional[IServiceAccount], result)

    @builtins.property
    def termination_grace_period(self) -> typing.Optional[_cdk8s_d3d9af27.Duration]:
        '''Grace period until the pod is terminated.

        :default: Duration.seconds(30)
        '''
        result = self._values.get("termination_grace_period")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Duration], result)

    @builtins.property
    def volumes(self) -> typing.Optional[typing.List[Volume]]:
        '''List of volumes that can be mounted by containers belonging to the pod.

        You can also add volumes later using ``podSpec.addVolume()``

        :default: - No volumes.

        :see: https://kubernetes.io/docs/concepts/storage/volumes
        '''
        result = self._values.get("volumes")
        return typing.cast(typing.Optional[typing.List[Volume]], result)

    @builtins.property
    def pod_metadata(self) -> typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata]:
        '''The pod metadata of this workload.'''
        result = self._values.get("pod_metadata")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata], result)

    @builtins.property
    def select(self) -> typing.Optional[builtins.bool]:
        '''Automatically allocates a pod label selector for this workload and add it to the pod metadata.

        This ensures this workload manages pods created by
        its pod template.

        :default: true
        '''
        result = self._values.get("select")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def spread(self) -> typing.Optional[builtins.bool]:
        '''Automatically spread pods across hostname and zones.

        :default: false

        :see: https://kubernetes.io/docs/concepts/scheduling-eviction/topology-spread-constraints/#internal-default-constraints
        '''
        result = self._values.get("spread")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "WorkloadProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class AwsElasticBlockStorePersistentVolume(
    PersistentVolume,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-24.AwsElasticBlockStorePersistentVolume",
):
    '''Represents an AWS Disk resource that is attached to a kubelet's host machine and then exposed to the pod.

    :see: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        volume_id: builtins.str,
        fs_type: typing.Optional[builtins.str] = None,
        partition: typing.Optional[jsii.Number] = None,
        read_only: typing.Optional[builtins.bool] = None,
        access_modes: typing.Optional[typing.Sequence[PersistentVolumeAccessMode]] = None,
        claim: typing.Optional[IPersistentVolumeClaim] = None,
        mount_options: typing.Optional[typing.Sequence[builtins.str]] = None,
        reclaim_policy: typing.Optional[PersistentVolumeReclaimPolicy] = None,
        storage: typing.Optional[_cdk8s_d3d9af27.Size] = None,
        storage_class_name: typing.Optional[builtins.str] = None,
        volume_mode: typing.Optional[PersistentVolumeMode] = None,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param volume_id: Unique ID of the persistent disk resource in AWS (Amazon EBS volume). More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
        :param fs_type: Filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Default: 'ext4'
        :param partition: The partition in the volume that you want to mount. If omitted, the default is to mount by volume name. Examples: For volume /dev/sda1, you specify the partition as "1". Similarly, the volume partition for /dev/sda is "0" (or you can leave the property empty). Default: - No partition.
        :param read_only: Specify "true" to force and set the ReadOnly property in VolumeMounts to "true". Default: false
        :param access_modes: Contains all ways the volume can be mounted. Default: - No access modes.
        :param claim: Part of a bi-directional binding between PersistentVolume and PersistentVolumeClaim. Expected to be non-nil when bound. Default: - Not bound to a specific claim.
        :param mount_options: A list of mount options, e.g. ["ro", "soft"]. Not validated - mount will simply fail if one is invalid. Default: - No options.
        :param reclaim_policy: When a user is done with their volume, they can delete the PVC objects from the API that allows reclamation of the resource. The reclaim policy tells the cluster what to do with the volume after it has been released of its claim. Default: PersistentVolumeReclaimPolicy.RETAIN
        :param storage: What is the storage capacity of this volume. Default: - No specified.
        :param storage_class_name: Name of StorageClass to which this persistent volume belongs. Default: - Volume does not belong to any storage class.
        :param volume_mode: Defines what type of volume is required by the claim. Default: VolumeMode.FILE_SYSTEM
        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__24dddb6cd94ae603c5f335cd88fbfcdb6fc449b64b4d0c5b8b9561a15ae38c69)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = AwsElasticBlockStorePersistentVolumeProps(
            volume_id=volume_id,
            fs_type=fs_type,
            partition=partition,
            read_only=read_only,
            access_modes=access_modes,
            claim=claim,
            mount_options=mount_options,
            reclaim_policy=reclaim_policy,
            storage=storage,
            storage_class_name=storage_class_name,
            volume_mode=volume_mode,
            metadata=metadata,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @builtins.property
    @jsii.member(jsii_name="fsType")
    def fs_type(self) -> builtins.str:
        '''File system type of this volume.'''
        return typing.cast(builtins.str, jsii.get(self, "fsType"))

    @builtins.property
    @jsii.member(jsii_name="readOnly")
    def read_only(self) -> builtins.bool:
        '''Whether or not it is mounted as a read-only volume.'''
        return typing.cast(builtins.bool, jsii.get(self, "readOnly"))

    @builtins.property
    @jsii.member(jsii_name="volumeId")
    def volume_id(self) -> builtins.str:
        '''Volume id of this volume.'''
        return typing.cast(builtins.str, jsii.get(self, "volumeId"))

    @builtins.property
    @jsii.member(jsii_name="partition")
    def partition(self) -> typing.Optional[jsii.Number]:
        '''Partition of this volume.'''
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "partition"))


@jsii.data_type(
    jsii_type="cdk8s-plus-24.AwsElasticBlockStorePersistentVolumeProps",
    jsii_struct_bases=[PersistentVolumeProps],
    name_mapping={
        "metadata": "metadata",
        "access_modes": "accessModes",
        "claim": "claim",
        "mount_options": "mountOptions",
        "reclaim_policy": "reclaimPolicy",
        "storage": "storage",
        "storage_class_name": "storageClassName",
        "volume_mode": "volumeMode",
        "volume_id": "volumeId",
        "fs_type": "fsType",
        "partition": "partition",
        "read_only": "readOnly",
    },
)
class AwsElasticBlockStorePersistentVolumeProps(PersistentVolumeProps):
    def __init__(
        self,
        *,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        access_modes: typing.Optional[typing.Sequence[PersistentVolumeAccessMode]] = None,
        claim: typing.Optional[IPersistentVolumeClaim] = None,
        mount_options: typing.Optional[typing.Sequence[builtins.str]] = None,
        reclaim_policy: typing.Optional[PersistentVolumeReclaimPolicy] = None,
        storage: typing.Optional[_cdk8s_d3d9af27.Size] = None,
        storage_class_name: typing.Optional[builtins.str] = None,
        volume_mode: typing.Optional[PersistentVolumeMode] = None,
        volume_id: builtins.str,
        fs_type: typing.Optional[builtins.str] = None,
        partition: typing.Optional[jsii.Number] = None,
        read_only: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''Properties for ``AwsElasticBlockStorePersistentVolume``.

        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        :param access_modes: Contains all ways the volume can be mounted. Default: - No access modes.
        :param claim: Part of a bi-directional binding between PersistentVolume and PersistentVolumeClaim. Expected to be non-nil when bound. Default: - Not bound to a specific claim.
        :param mount_options: A list of mount options, e.g. ["ro", "soft"]. Not validated - mount will simply fail if one is invalid. Default: - No options.
        :param reclaim_policy: When a user is done with their volume, they can delete the PVC objects from the API that allows reclamation of the resource. The reclaim policy tells the cluster what to do with the volume after it has been released of its claim. Default: PersistentVolumeReclaimPolicy.RETAIN
        :param storage: What is the storage capacity of this volume. Default: - No specified.
        :param storage_class_name: Name of StorageClass to which this persistent volume belongs. Default: - Volume does not belong to any storage class.
        :param volume_mode: Defines what type of volume is required by the claim. Default: VolumeMode.FILE_SYSTEM
        :param volume_id: Unique ID of the persistent disk resource in AWS (Amazon EBS volume). More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
        :param fs_type: Filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Default: 'ext4'
        :param partition: The partition in the volume that you want to mount. If omitted, the default is to mount by volume name. Examples: For volume /dev/sda1, you specify the partition as "1". Similarly, the volume partition for /dev/sda is "0" (or you can leave the property empty). Default: - No partition.
        :param read_only: Specify "true" to force and set the ReadOnly property in VolumeMounts to "true". Default: false
        '''
        if isinstance(metadata, dict):
            metadata = _cdk8s_d3d9af27.ApiObjectMetadata(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b8161fabff519931078b5d342b5094b2df161068c18a46bc01ce57722c774ede)
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument access_modes", value=access_modes, expected_type=type_hints["access_modes"])
            check_type(argname="argument claim", value=claim, expected_type=type_hints["claim"])
            check_type(argname="argument mount_options", value=mount_options, expected_type=type_hints["mount_options"])
            check_type(argname="argument reclaim_policy", value=reclaim_policy, expected_type=type_hints["reclaim_policy"])
            check_type(argname="argument storage", value=storage, expected_type=type_hints["storage"])
            check_type(argname="argument storage_class_name", value=storage_class_name, expected_type=type_hints["storage_class_name"])
            check_type(argname="argument volume_mode", value=volume_mode, expected_type=type_hints["volume_mode"])
            check_type(argname="argument volume_id", value=volume_id, expected_type=type_hints["volume_id"])
            check_type(argname="argument fs_type", value=fs_type, expected_type=type_hints["fs_type"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
            check_type(argname="argument read_only", value=read_only, expected_type=type_hints["read_only"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "volume_id": volume_id,
        }
        if metadata is not None:
            self._values["metadata"] = metadata
        if access_modes is not None:
            self._values["access_modes"] = access_modes
        if claim is not None:
            self._values["claim"] = claim
        if mount_options is not None:
            self._values["mount_options"] = mount_options
        if reclaim_policy is not None:
            self._values["reclaim_policy"] = reclaim_policy
        if storage is not None:
            self._values["storage"] = storage
        if storage_class_name is not None:
            self._values["storage_class_name"] = storage_class_name
        if volume_mode is not None:
            self._values["volume_mode"] = volume_mode
        if fs_type is not None:
            self._values["fs_type"] = fs_type
        if partition is not None:
            self._values["partition"] = partition
        if read_only is not None:
            self._values["read_only"] = read_only

    @builtins.property
    def metadata(self) -> typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata]:
        '''Metadata that all persisted resources must have, which includes all objects users must create.'''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata], result)

    @builtins.property
    def access_modes(self) -> typing.Optional[typing.List[PersistentVolumeAccessMode]]:
        '''Contains all ways the volume can be mounted.

        :default: - No access modes.

        :see: https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes
        '''
        result = self._values.get("access_modes")
        return typing.cast(typing.Optional[typing.List[PersistentVolumeAccessMode]], result)

    @builtins.property
    def claim(self) -> typing.Optional[IPersistentVolumeClaim]:
        '''Part of a bi-directional binding between PersistentVolume and PersistentVolumeClaim.

        Expected to be non-nil when bound.

        :default: - Not bound to a specific claim.

        :see: https://kubernetes.io/docs/concepts/storage/persistent-volumes#binding
        '''
        result = self._values.get("claim")
        return typing.cast(typing.Optional[IPersistentVolumeClaim], result)

    @builtins.property
    def mount_options(self) -> typing.Optional[typing.List[builtins.str]]:
        '''A list of mount options, e.g. ["ro", "soft"]. Not validated - mount will simply fail if one is invalid.

        :default: - No options.

        :see: https://kubernetes.io/docs/concepts/storage/persistent-volumes/#mount-options
        '''
        result = self._values.get("mount_options")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def reclaim_policy(self) -> typing.Optional[PersistentVolumeReclaimPolicy]:
        '''When a user is done with their volume, they can delete the PVC objects from the API that allows reclamation of the resource.

        The reclaim policy tells the cluster what to do with
        the volume after it has been released of its claim.

        :default: PersistentVolumeReclaimPolicy.RETAIN

        :see: https://kubernetes.io/docs/concepts/storage/persistent-volumes#reclaiming
        '''
        result = self._values.get("reclaim_policy")
        return typing.cast(typing.Optional[PersistentVolumeReclaimPolicy], result)

    @builtins.property
    def storage(self) -> typing.Optional[_cdk8s_d3d9af27.Size]:
        '''What is the storage capacity of this volume.

        :default: - No specified.

        :see: https://kubernetes.io/docs/concepts/storage/persistent-volumes#resources
        '''
        result = self._values.get("storage")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Size], result)

    @builtins.property
    def storage_class_name(self) -> typing.Optional[builtins.str]:
        '''Name of StorageClass to which this persistent volume belongs.

        :default: - Volume does not belong to any storage class.
        '''
        result = self._values.get("storage_class_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def volume_mode(self) -> typing.Optional[PersistentVolumeMode]:
        '''Defines what type of volume is required by the claim.

        :default: VolumeMode.FILE_SYSTEM
        '''
        result = self._values.get("volume_mode")
        return typing.cast(typing.Optional[PersistentVolumeMode], result)

    @builtins.property
    def volume_id(self) -> builtins.str:
        '''Unique ID of the persistent disk resource in AWS (Amazon EBS volume).

        More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore

        :see: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
        '''
        result = self._values.get("volume_id")
        assert result is not None, "Required property 'volume_id' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def fs_type(self) -> typing.Optional[builtins.str]:
        '''Filesystem type of the volume that you want to mount.

        Tip: Ensure that the filesystem type is supported by the host operating system.

        :default: 'ext4'

        :see: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
        '''
        result = self._values.get("fs_type")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def partition(self) -> typing.Optional[jsii.Number]:
        '''The partition in the volume that you want to mount.

        If omitted, the default is to mount by volume name.
        Examples: For volume /dev/sda1, you specify the partition as "1".
        Similarly, the volume partition for /dev/sda is "0" (or you can leave the property empty).

        :default: - No partition.
        '''
        result = self._values.get("partition")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def read_only(self) -> typing.Optional[builtins.bool]:
        '''Specify "true" to force and set the ReadOnly property in VolumeMounts to "true".

        :default: false

        :see: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
        '''
        result = self._values.get("read_only")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AwsElasticBlockStorePersistentVolumeProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class AzureDiskPersistentVolume(
    PersistentVolume,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-24.AzureDiskPersistentVolume",
):
    '''AzureDisk represents an Azure Data Disk mount on the host and bind mount to the pod.'''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        disk_name: builtins.str,
        disk_uri: builtins.str,
        caching_mode: typing.Optional[AzureDiskPersistentVolumeCachingMode] = None,
        fs_type: typing.Optional[builtins.str] = None,
        kind: typing.Optional[AzureDiskPersistentVolumeKind] = None,
        read_only: typing.Optional[builtins.bool] = None,
        access_modes: typing.Optional[typing.Sequence[PersistentVolumeAccessMode]] = None,
        claim: typing.Optional[IPersistentVolumeClaim] = None,
        mount_options: typing.Optional[typing.Sequence[builtins.str]] = None,
        reclaim_policy: typing.Optional[PersistentVolumeReclaimPolicy] = None,
        storage: typing.Optional[_cdk8s_d3d9af27.Size] = None,
        storage_class_name: typing.Optional[builtins.str] = None,
        volume_mode: typing.Optional[PersistentVolumeMode] = None,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param disk_name: The Name of the data disk in the blob storage.
        :param disk_uri: The URI the data disk in the blob storage.
        :param caching_mode: Host Caching mode. Default: - AzureDiskPersistentVolumeCachingMode.NONE.
        :param fs_type: Filesystem type to mount. Must be a filesystem type supported by the host operating system. Default: 'ext4'
        :param kind: Kind of disk. Default: AzureDiskPersistentVolumeKind.SHARED
        :param read_only: Force the ReadOnly setting in VolumeMounts. Default: false
        :param access_modes: Contains all ways the volume can be mounted. Default: - No access modes.
        :param claim: Part of a bi-directional binding between PersistentVolume and PersistentVolumeClaim. Expected to be non-nil when bound. Default: - Not bound to a specific claim.
        :param mount_options: A list of mount options, e.g. ["ro", "soft"]. Not validated - mount will simply fail if one is invalid. Default: - No options.
        :param reclaim_policy: When a user is done with their volume, they can delete the PVC objects from the API that allows reclamation of the resource. The reclaim policy tells the cluster what to do with the volume after it has been released of its claim. Default: PersistentVolumeReclaimPolicy.RETAIN
        :param storage: What is the storage capacity of this volume. Default: - No specified.
        :param storage_class_name: Name of StorageClass to which this persistent volume belongs. Default: - Volume does not belong to any storage class.
        :param volume_mode: Defines what type of volume is required by the claim. Default: VolumeMode.FILE_SYSTEM
        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b76018a6d6e2403042d5372c627bd6fc48862fd694be1f2ce07d2af87904e360)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = AzureDiskPersistentVolumeProps(
            disk_name=disk_name,
            disk_uri=disk_uri,
            caching_mode=caching_mode,
            fs_type=fs_type,
            kind=kind,
            read_only=read_only,
            access_modes=access_modes,
            claim=claim,
            mount_options=mount_options,
            reclaim_policy=reclaim_policy,
            storage=storage,
            storage_class_name=storage_class_name,
            volume_mode=volume_mode,
            metadata=metadata,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @builtins.property
    @jsii.member(jsii_name="azureKind")
    def azure_kind(self) -> AzureDiskPersistentVolumeKind:
        '''Azure kind of this volume.'''
        return typing.cast(AzureDiskPersistentVolumeKind, jsii.get(self, "azureKind"))

    @builtins.property
    @jsii.member(jsii_name="cachingMode")
    def caching_mode(self) -> AzureDiskPersistentVolumeCachingMode:
        '''Caching mode of this volume.'''
        return typing.cast(AzureDiskPersistentVolumeCachingMode, jsii.get(self, "cachingMode"))

    @builtins.property
    @jsii.member(jsii_name="diskName")
    def disk_name(self) -> builtins.str:
        '''Disk name of this volume.'''
        return typing.cast(builtins.str, jsii.get(self, "diskName"))

    @builtins.property
    @jsii.member(jsii_name="diskUri")
    def disk_uri(self) -> builtins.str:
        '''Disk URI of this volume.'''
        return typing.cast(builtins.str, jsii.get(self, "diskUri"))

    @builtins.property
    @jsii.member(jsii_name="fsType")
    def fs_type(self) -> builtins.str:
        '''File system type of this volume.'''
        return typing.cast(builtins.str, jsii.get(self, "fsType"))

    @builtins.property
    @jsii.member(jsii_name="readOnly")
    def read_only(self) -> builtins.bool:
        '''Whether or not it is mounted as a read-only volume.'''
        return typing.cast(builtins.bool, jsii.get(self, "readOnly"))


@jsii.data_type(
    jsii_type="cdk8s-plus-24.AzureDiskPersistentVolumeProps",
    jsii_struct_bases=[PersistentVolumeProps],
    name_mapping={
        "metadata": "metadata",
        "access_modes": "accessModes",
        "claim": "claim",
        "mount_options": "mountOptions",
        "reclaim_policy": "reclaimPolicy",
        "storage": "storage",
        "storage_class_name": "storageClassName",
        "volume_mode": "volumeMode",
        "disk_name": "diskName",
        "disk_uri": "diskUri",
        "caching_mode": "cachingMode",
        "fs_type": "fsType",
        "kind": "kind",
        "read_only": "readOnly",
    },
)
class AzureDiskPersistentVolumeProps(PersistentVolumeProps):
    def __init__(
        self,
        *,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        access_modes: typing.Optional[typing.Sequence[PersistentVolumeAccessMode]] = None,
        claim: typing.Optional[IPersistentVolumeClaim] = None,
        mount_options: typing.Optional[typing.Sequence[builtins.str]] = None,
        reclaim_policy: typing.Optional[PersistentVolumeReclaimPolicy] = None,
        storage: typing.Optional[_cdk8s_d3d9af27.Size] = None,
        storage_class_name: typing.Optional[builtins.str] = None,
        volume_mode: typing.Optional[PersistentVolumeMode] = None,
        disk_name: builtins.str,
        disk_uri: builtins.str,
        caching_mode: typing.Optional[AzureDiskPersistentVolumeCachingMode] = None,
        fs_type: typing.Optional[builtins.str] = None,
        kind: typing.Optional[AzureDiskPersistentVolumeKind] = None,
        read_only: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''Properties for ``AzureDiskPersistentVolume``.

        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        :param access_modes: Contains all ways the volume can be mounted. Default: - No access modes.
        :param claim: Part of a bi-directional binding between PersistentVolume and PersistentVolumeClaim. Expected to be non-nil when bound. Default: - Not bound to a specific claim.
        :param mount_options: A list of mount options, e.g. ["ro", "soft"]. Not validated - mount will simply fail if one is invalid. Default: - No options.
        :param reclaim_policy: When a user is done with their volume, they can delete the PVC objects from the API that allows reclamation of the resource. The reclaim policy tells the cluster what to do with the volume after it has been released of its claim. Default: PersistentVolumeReclaimPolicy.RETAIN
        :param storage: What is the storage capacity of this volume. Default: - No specified.
        :param storage_class_name: Name of StorageClass to which this persistent volume belongs. Default: - Volume does not belong to any storage class.
        :param volume_mode: Defines what type of volume is required by the claim. Default: VolumeMode.FILE_SYSTEM
        :param disk_name: The Name of the data disk in the blob storage.
        :param disk_uri: The URI the data disk in the blob storage.
        :param caching_mode: Host Caching mode. Default: - AzureDiskPersistentVolumeCachingMode.NONE.
        :param fs_type: Filesystem type to mount. Must be a filesystem type supported by the host operating system. Default: 'ext4'
        :param kind: Kind of disk. Default: AzureDiskPersistentVolumeKind.SHARED
        :param read_only: Force the ReadOnly setting in VolumeMounts. Default: false
        '''
        if isinstance(metadata, dict):
            metadata = _cdk8s_d3d9af27.ApiObjectMetadata(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3177e1b6b8a5e9799ff56e6b0dab0af960bda902d4df169feabdfa3564004c17)
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument access_modes", value=access_modes, expected_type=type_hints["access_modes"])
            check_type(argname="argument claim", value=claim, expected_type=type_hints["claim"])
            check_type(argname="argument mount_options", value=mount_options, expected_type=type_hints["mount_options"])
            check_type(argname="argument reclaim_policy", value=reclaim_policy, expected_type=type_hints["reclaim_policy"])
            check_type(argname="argument storage", value=storage, expected_type=type_hints["storage"])
            check_type(argname="argument storage_class_name", value=storage_class_name, expected_type=type_hints["storage_class_name"])
            check_type(argname="argument volume_mode", value=volume_mode, expected_type=type_hints["volume_mode"])
            check_type(argname="argument disk_name", value=disk_name, expected_type=type_hints["disk_name"])
            check_type(argname="argument disk_uri", value=disk_uri, expected_type=type_hints["disk_uri"])
            check_type(argname="argument caching_mode", value=caching_mode, expected_type=type_hints["caching_mode"])
            check_type(argname="argument fs_type", value=fs_type, expected_type=type_hints["fs_type"])
            check_type(argname="argument kind", value=kind, expected_type=type_hints["kind"])
            check_type(argname="argument read_only", value=read_only, expected_type=type_hints["read_only"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "disk_name": disk_name,
            "disk_uri": disk_uri,
        }
        if metadata is not None:
            self._values["metadata"] = metadata
        if access_modes is not None:
            self._values["access_modes"] = access_modes
        if claim is not None:
            self._values["claim"] = claim
        if mount_options is not None:
            self._values["mount_options"] = mount_options
        if reclaim_policy is not None:
            self._values["reclaim_policy"] = reclaim_policy
        if storage is not None:
            self._values["storage"] = storage
        if storage_class_name is not None:
            self._values["storage_class_name"] = storage_class_name
        if volume_mode is not None:
            self._values["volume_mode"] = volume_mode
        if caching_mode is not None:
            self._values["caching_mode"] = caching_mode
        if fs_type is not None:
            self._values["fs_type"] = fs_type
        if kind is not None:
            self._values["kind"] = kind
        if read_only is not None:
            self._values["read_only"] = read_only

    @builtins.property
    def metadata(self) -> typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata]:
        '''Metadata that all persisted resources must have, which includes all objects users must create.'''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata], result)

    @builtins.property
    def access_modes(self) -> typing.Optional[typing.List[PersistentVolumeAccessMode]]:
        '''Contains all ways the volume can be mounted.

        :default: - No access modes.

        :see: https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes
        '''
        result = self._values.get("access_modes")
        return typing.cast(typing.Optional[typing.List[PersistentVolumeAccessMode]], result)

    @builtins.property
    def claim(self) -> typing.Optional[IPersistentVolumeClaim]:
        '''Part of a bi-directional binding between PersistentVolume and PersistentVolumeClaim.

        Expected to be non-nil when bound.

        :default: - Not bound to a specific claim.

        :see: https://kubernetes.io/docs/concepts/storage/persistent-volumes#binding
        '''
        result = self._values.get("claim")
        return typing.cast(typing.Optional[IPersistentVolumeClaim], result)

    @builtins.property
    def mount_options(self) -> typing.Optional[typing.List[builtins.str]]:
        '''A list of mount options, e.g. ["ro", "soft"]. Not validated - mount will simply fail if one is invalid.

        :default: - No options.

        :see: https://kubernetes.io/docs/concepts/storage/persistent-volumes/#mount-options
        '''
        result = self._values.get("mount_options")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def reclaim_policy(self) -> typing.Optional[PersistentVolumeReclaimPolicy]:
        '''When a user is done with their volume, they can delete the PVC objects from the API that allows reclamation of the resource.

        The reclaim policy tells the cluster what to do with
        the volume after it has been released of its claim.

        :default: PersistentVolumeReclaimPolicy.RETAIN

        :see: https://kubernetes.io/docs/concepts/storage/persistent-volumes#reclaiming
        '''
        result = self._values.get("reclaim_policy")
        return typing.cast(typing.Optional[PersistentVolumeReclaimPolicy], result)

    @builtins.property
    def storage(self) -> typing.Optional[_cdk8s_d3d9af27.Size]:
        '''What is the storage capacity of this volume.

        :default: - No specified.

        :see: https://kubernetes.io/docs/concepts/storage/persistent-volumes#resources
        '''
        result = self._values.get("storage")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Size], result)

    @builtins.property
    def storage_class_name(self) -> typing.Optional[builtins.str]:
        '''Name of StorageClass to which this persistent volume belongs.

        :default: - Volume does not belong to any storage class.
        '''
        result = self._values.get("storage_class_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def volume_mode(self) -> typing.Optional[PersistentVolumeMode]:
        '''Defines what type of volume is required by the claim.

        :default: VolumeMode.FILE_SYSTEM
        '''
        result = self._values.get("volume_mode")
        return typing.cast(typing.Optional[PersistentVolumeMode], result)

    @builtins.property
    def disk_name(self) -> builtins.str:
        '''The Name of the data disk in the blob storage.'''
        result = self._values.get("disk_name")
        assert result is not None, "Required property 'disk_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def disk_uri(self) -> builtins.str:
        '''The URI the data disk in the blob storage.'''
        result = self._values.get("disk_uri")
        assert result is not None, "Required property 'disk_uri' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def caching_mode(self) -> typing.Optional[AzureDiskPersistentVolumeCachingMode]:
        '''Host Caching mode.

        :default: - AzureDiskPersistentVolumeCachingMode.NONE.
        '''
        result = self._values.get("caching_mode")
        return typing.cast(typing.Optional[AzureDiskPersistentVolumeCachingMode], result)

    @builtins.property
    def fs_type(self) -> typing.Optional[builtins.str]:
        '''Filesystem type to mount.

        Must be a filesystem type supported by the host operating system.

        :default: 'ext4'
        '''
        result = self._values.get("fs_type")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def kind(self) -> typing.Optional[AzureDiskPersistentVolumeKind]:
        '''Kind of disk.

        :default: AzureDiskPersistentVolumeKind.SHARED
        '''
        result = self._values.get("kind")
        return typing.cast(typing.Optional[AzureDiskPersistentVolumeKind], result)

    @builtins.property
    def read_only(self) -> typing.Optional[builtins.bool]:
        '''Force the ReadOnly setting in VolumeMounts.

        :default: false
        '''
        result = self._values.get("read_only")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AzureDiskPersistentVolumeProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-24.BasicAuthSecretProps",
    jsii_struct_bases=[CommonSecretProps],
    name_mapping={
        "metadata": "metadata",
        "immutable": "immutable",
        "password": "password",
        "username": "username",
    },
)
class BasicAuthSecretProps(CommonSecretProps):
    def __init__(
        self,
        *,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        immutable: typing.Optional[builtins.bool] = None,
        password: builtins.str,
        username: builtins.str,
    ) -> None:
        '''Options for ``BasicAuthSecret``.

        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        :param immutable: If set to true, ensures that data stored in the Secret cannot be updated (only object metadata can be modified). If not set to true, the field can be modified at any time. Default: false
        :param password: The password or token for authentication.
        :param username: The user name for authentication.
        '''
        if isinstance(metadata, dict):
            metadata = _cdk8s_d3d9af27.ApiObjectMetadata(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__441f9f326aaa2bb73f9cf13aa4992bedb24c08f11bb564834339703f6e8e53fd)
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument immutable", value=immutable, expected_type=type_hints["immutable"])
            check_type(argname="argument password", value=password, expected_type=type_hints["password"])
            check_type(argname="argument username", value=username, expected_type=type_hints["username"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "password": password,
            "username": username,
        }
        if metadata is not None:
            self._values["metadata"] = metadata
        if immutable is not None:
            self._values["immutable"] = immutable

    @builtins.property
    def metadata(self) -> typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata]:
        '''Metadata that all persisted resources must have, which includes all objects users must create.'''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata], result)

    @builtins.property
    def immutable(self) -> typing.Optional[builtins.bool]:
        '''If set to true, ensures that data stored in the Secret cannot be updated (only object metadata can be modified).

        If not set to true, the field can be modified at any time.

        :default: false
        '''
        result = self._values.get("immutable")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def password(self) -> builtins.str:
        '''The password or token for authentication.'''
        result = self._values.get("password")
        assert result is not None, "Required property 'password' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def username(self) -> builtins.str:
        '''The user name for authentication.'''
        result = self._values.get("username")
        assert result is not None, "Required property 'username' is missing"
        return typing.cast(builtins.str, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "BasicAuthSecretProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(IClusterRole, IRole)
class ClusterRole(
    Resource,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-24.ClusterRole",
):
    '''ClusterRole is a cluster level, logical grouping of PolicyRules that can be referenced as a unit by a RoleBinding or ClusterRoleBinding.'''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        aggregation_labels: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        rules: typing.Optional[typing.Sequence[typing.Union[ClusterRolePolicyRule, typing.Dict[builtins.str, typing.Any]]]] = None,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param aggregation_labels: Specify labels that should be used to locate ClusterRoles, whose rules will be automatically filled into this ClusterRole's rules.
        :param rules: A list of rules the role should allow. Default: []
        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9a4f80ab1bd35b0e35c9af16c9b39ab7b774099b4faba4c6b02424cd3c8579fc)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = ClusterRoleProps(
            aggregation_labels=aggregation_labels, rules=rules, metadata=metadata
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="fromClusterRoleName")
    @builtins.classmethod
    def from_cluster_role_name(
        cls,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        name: builtins.str,
    ) -> IClusterRole:
        '''Imports a role from the cluster as a reference.

        :param scope: -
        :param id: -
        :param name: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__031aeb9a79ba0c73fff1a5ee1c64af196ad26cfc8e1a7c13f67c129125bff7b4)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
        return typing.cast(IClusterRole, jsii.sinvoke(cls, "fromClusterRoleName", [scope, id, name]))

    @jsii.member(jsii_name="aggregate")
    def aggregate(self, key: builtins.str, value: builtins.str) -> None:
        '''Aggregate rules from roles matching this label selector.

        :param key: -
        :param value: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__cbcccfdda017deedd8b0855789e2ca3b13ef41447cf0a25009b7a908871de330)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(None, jsii.invoke(self, "aggregate", [key, value]))

    @jsii.member(jsii_name="allow")
    def allow(
        self,
        verbs: typing.Sequence[builtins.str],
        *endpoints: IApiEndpoint,
    ) -> None:
        '''Add permission to perform a list of HTTP verbs on a collection of resources.

        :param verbs: -
        :param endpoints: The endpoints(s) to apply to.

        :see: https://kubernetes.io/docs/reference/access-authn-authz/authorization/#determine-the-request-verb
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__64ca0f8f74affa0c97433d7600759addb044b41993d4f66a8ea550251bacccaa)
            check_type(argname="argument verbs", value=verbs, expected_type=type_hints["verbs"])
            check_type(argname="argument endpoints", value=endpoints, expected_type=typing.Tuple[type_hints["endpoints"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast(None, jsii.invoke(self, "allow", [verbs, *endpoints]))

    @jsii.member(jsii_name="allowCreate")
    def allow_create(self, *endpoints: IApiEndpoint) -> None:
        '''Add "create" permission for the resources.

        :param endpoints: The resource(s) to apply to.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f97c41744619e7366d09d3e6c2db8e602c12538786c10105100b9ef361239409)
            check_type(argname="argument endpoints", value=endpoints, expected_type=typing.Tuple[type_hints["endpoints"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast(None, jsii.invoke(self, "allowCreate", [*endpoints]))

    @jsii.member(jsii_name="allowDelete")
    def allow_delete(self, *endpoints: IApiEndpoint) -> None:
        '''Add "delete" permission for the resources.

        :param endpoints: The resource(s) to apply to.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__16442c79a0ef82036c91f9941c1469c3bd87c74a12c85d3ba3f11244ffd7a78b)
            check_type(argname="argument endpoints", value=endpoints, expected_type=typing.Tuple[type_hints["endpoints"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast(None, jsii.invoke(self, "allowDelete", [*endpoints]))

    @jsii.member(jsii_name="allowDeleteCollection")
    def allow_delete_collection(self, *endpoints: IApiEndpoint) -> None:
        '''Add "deletecollection" permission for the resources.

        :param endpoints: The resource(s) to apply to.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e825b006f311c69b3f03ec8c5d1affe8a0b27afbbe1e3e25aa676d2ade55e88b)
            check_type(argname="argument endpoints", value=endpoints, expected_type=typing.Tuple[type_hints["endpoints"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast(None, jsii.invoke(self, "allowDeleteCollection", [*endpoints]))

    @jsii.member(jsii_name="allowGet")
    def allow_get(self, *endpoints: IApiEndpoint) -> None:
        '''Add "get" permission for the resources.

        :param endpoints: The resource(s) to apply to.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__738f1a21f48d394129efcae22ff3f61c392c9f66e3e9fb0785d3bc44cfef565c)
            check_type(argname="argument endpoints", value=endpoints, expected_type=typing.Tuple[type_hints["endpoints"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast(None, jsii.invoke(self, "allowGet", [*endpoints]))

    @jsii.member(jsii_name="allowList")
    def allow_list(self, *endpoints: IApiEndpoint) -> None:
        '''Add "list" permission for the resources.

        :param endpoints: The resource(s) to apply to.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2e2894d2f3d39c4ef2b60b372cf0db62607a4c72e4865f89a06877addfcb2568)
            check_type(argname="argument endpoints", value=endpoints, expected_type=typing.Tuple[type_hints["endpoints"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast(None, jsii.invoke(self, "allowList", [*endpoints]))

    @jsii.member(jsii_name="allowPatch")
    def allow_patch(self, *endpoints: IApiEndpoint) -> None:
        '''Add "patch" permission for the resources.

        :param endpoints: The resource(s) to apply to.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3e80df351b011059ed3b89c137c125f378f4ff6303fb64c2a356165dc2a85c03)
            check_type(argname="argument endpoints", value=endpoints, expected_type=typing.Tuple[type_hints["endpoints"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast(None, jsii.invoke(self, "allowPatch", [*endpoints]))

    @jsii.member(jsii_name="allowRead")
    def allow_read(self, *endpoints: IApiEndpoint) -> None:
        '''Add "get", "list", and "watch" permissions for the resources.

        :param endpoints: The resource(s) to apply to.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__90ca79bf38c5a49837157f70bc7ed65221c814ce1b1bc3aec7864de9ae5c96b0)
            check_type(argname="argument endpoints", value=endpoints, expected_type=typing.Tuple[type_hints["endpoints"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast(None, jsii.invoke(self, "allowRead", [*endpoints]))

    @jsii.member(jsii_name="allowReadWrite")
    def allow_read_write(self, *endpoints: IApiEndpoint) -> None:
        '''Add "get", "list", "watch", "create", "update", "patch", "delete", and "deletecollection" permissions for the resources.

        :param endpoints: The resource(s) to apply to.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__18cd5ad011982ca8901b96942941541a734eefd9f7a3ed4254c103c96c33a539)
            check_type(argname="argument endpoints", value=endpoints, expected_type=typing.Tuple[type_hints["endpoints"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast(None, jsii.invoke(self, "allowReadWrite", [*endpoints]))

    @jsii.member(jsii_name="allowUpdate")
    def allow_update(self, *endpoints: IApiEndpoint) -> None:
        '''Add "update" permission for the resources.

        :param endpoints: The resource(s) to apply to.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1110e8cbc383c6b9ba37604784f15035e84ab66069b76926ecb44cafb8723f90)
            check_type(argname="argument endpoints", value=endpoints, expected_type=typing.Tuple[type_hints["endpoints"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast(None, jsii.invoke(self, "allowUpdate", [*endpoints]))

    @jsii.member(jsii_name="allowWatch")
    def allow_watch(self, *endpoints: IApiEndpoint) -> None:
        '''Add "watch" permission for the resources.

        :param endpoints: The resource(s) to apply to.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c84be147bba135a4d64a563d45c6c45f1569da7a1067fd18c815d9ab6229c061)
            check_type(argname="argument endpoints", value=endpoints, expected_type=typing.Tuple[type_hints["endpoints"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast(None, jsii.invoke(self, "allowWatch", [*endpoints]))

    @jsii.member(jsii_name="bind")
    def bind(self, *subjects: ISubject) -> ClusterRoleBinding:
        '''Create a ClusterRoleBinding that binds the permissions in this ClusterRole to a list of subjects, without namespace restrictions.

        :param subjects: a list of subjects to bind to.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1eb9a508dd77068973eef025d563c6dd1741e6a57c9acc8aef7fa1af9f0e259e)
            check_type(argname="argument subjects", value=subjects, expected_type=typing.Tuple[type_hints["subjects"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast(ClusterRoleBinding, jsii.invoke(self, "bind", [*subjects]))

    @jsii.member(jsii_name="bindInNamespace")
    def bind_in_namespace(
        self,
        namespace: builtins.str,
        *subjects: ISubject,
    ) -> RoleBinding:
        '''Create a RoleBinding that binds the permissions in this ClusterRole to a list of subjects, that will only apply to the given namespace.

        :param namespace: the namespace to limit permissions to.
        :param subjects: a list of subjects to bind to.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1953c0d0315c8cb7e3d47c66165b09900637e691d83aa14e767333574a8edb0f)
            check_type(argname="argument namespace", value=namespace, expected_type=type_hints["namespace"])
            check_type(argname="argument subjects", value=subjects, expected_type=typing.Tuple[type_hints["subjects"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast(RoleBinding, jsii.invoke(self, "bindInNamespace", [namespace, *subjects]))

    @jsii.member(jsii_name="combine")
    def combine(self, rol: "ClusterRole") -> None:
        '''Combines the rules of the argument ClusterRole into this ClusterRole using aggregation labels.

        :param rol: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__083a792347e7d22838d15db90bfc975cc17985e390843d6a1d2faf0ed54d4f8a)
            check_type(argname="argument rol", value=rol, expected_type=type_hints["rol"])
        return typing.cast(None, jsii.invoke(self, "combine", [rol]))

    @builtins.property
    @jsii.member(jsii_name="apiObject")
    def _api_object(self) -> _cdk8s_d3d9af27.ApiObject:
        '''The underlying cdk8s API object.

        :see: base.Resource.apiObject
        '''
        return typing.cast(_cdk8s_d3d9af27.ApiObject, jsii.get(self, "apiObject"))

    @builtins.property
    @jsii.member(jsii_name="resourceType")
    def resource_type(self) -> builtins.str:
        '''The name of a resource type as it appears in the relevant API endpoint.'''
        return typing.cast(builtins.str, jsii.get(self, "resourceType"))

    @builtins.property
    @jsii.member(jsii_name="rules")
    def rules(self) -> typing.List[ClusterRolePolicyRule]:
        '''Rules associaated with this Role.

        Returns a copy, use ``allow`` to add rules.
        '''
        return typing.cast(typing.List[ClusterRolePolicyRule], jsii.get(self, "rules"))


@jsii.implements(IConfigMap)
class ConfigMap(Resource, metaclass=jsii.JSIIMeta, jsii_type="cdk8s-plus-24.ConfigMap"):
    '''ConfigMap holds configuration data for pods to consume.'''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        binary_data: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        data: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        immutable: typing.Optional[builtins.bool] = None,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param binary_data: BinaryData contains the binary data. Each key must consist of alphanumeric characters, '-', '_' or '.'. BinaryData can contain byte sequences that are not in the UTF-8 range. The keys stored in BinaryData must not overlap with the ones in the Data field, this is enforced during validation process. You can also add binary data using ``configMap.addBinaryData()``.
        :param data: Data contains the configuration data. Each key must consist of alphanumeric characters, '-', '_' or '.'. Values with non-UTF-8 byte sequences must use the BinaryData field. The keys stored in Data must not overlap with the keys in the BinaryData field, this is enforced during validation process. You can also add data using ``configMap.addData()``.
        :param immutable: If set to true, ensures that data stored in the ConfigMap cannot be updated (only object metadata can be modified). If not set to true, the field can be modified at any time. Default: false
        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f7dc30051b4d97262e6028cbb71b3532acebff83ecec22ae7d79797315beae12)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = ConfigMapProps(
            binary_data=binary_data, data=data, immutable=immutable, metadata=metadata
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="fromConfigMapName")
    @builtins.classmethod
    def from_config_map_name(
        cls,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        name: builtins.str,
    ) -> IConfigMap:
        '''Represents a ConfigMap created elsewhere.

        :param scope: -
        :param id: -
        :param name: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__fc6aa6f0ffbeffc20a80f354f7c5a3cdda0a8a8386399b9703018a74321cdd1d)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
        return typing.cast(IConfigMap, jsii.sinvoke(cls, "fromConfigMapName", [scope, id, name]))

    @jsii.member(jsii_name="addBinaryData")
    def add_binary_data(self, key: builtins.str, value: builtins.str) -> None:
        '''Adds a binary data entry to the config map.

        BinaryData can contain byte
        sequences that are not in the UTF-8 range.

        :param key: The key.
        :param value: The value.

        :throws: if there is either a ``data`` or ``binaryData`` entry with the same key
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2b4d606513bea57536d8cc1b42dcd04c4f78bfee7d88abaae62d565b80beeeb0)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(None, jsii.invoke(self, "addBinaryData", [key, value]))

    @jsii.member(jsii_name="addData")
    def add_data(self, key: builtins.str, value: builtins.str) -> None:
        '''Adds a data entry to the config map.

        :param key: The key.
        :param value: The value.

        :throws: if there is either a ``data`` or ``binaryData`` entry with the same key
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0c819f8bbb64f4f71c9be67c865e4e9187ca203c0dcc70a3ae0d9224c433bd55)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(None, jsii.invoke(self, "addData", [key, value]))

    @jsii.member(jsii_name="addDirectory")
    def add_directory(
        self,
        local_dir: builtins.str,
        *,
        exclude: typing.Optional[typing.Sequence[builtins.str]] = None,
        key_prefix: typing.Optional[builtins.str] = None,
    ) -> None:
        '''Adds a directory to the ConfigMap.

        :param local_dir: A path to a local directory.
        :param exclude: Glob patterns to exclude when adding files. Default: - include all files
        :param key_prefix: A prefix to add to all keys in the config map. Default: ""
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0cbe13c91a2ba0251308ce07928e28966487bad4af8bb5ad145457653696b217)
            check_type(argname="argument local_dir", value=local_dir, expected_type=type_hints["local_dir"])
        options = AddDirectoryOptions(exclude=exclude, key_prefix=key_prefix)

        return typing.cast(None, jsii.invoke(self, "addDirectory", [local_dir, options]))

    @jsii.member(jsii_name="addFile")
    def add_file(
        self,
        local_file: builtins.str,
        key: typing.Optional[builtins.str] = None,
    ) -> None:
        '''Adds a file to the ConfigMap.

        :param local_file: The path to the local file.
        :param key: The ConfigMap key (default to the file name).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__09c68d9be1e124d6a315de7e07bea97140a323d43b12968edf8966fff59a5328)
            check_type(argname="argument local_file", value=local_file, expected_type=type_hints["local_file"])
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
        return typing.cast(None, jsii.invoke(self, "addFile", [local_file, key]))

    @builtins.property
    @jsii.member(jsii_name="apiObject")
    def _api_object(self) -> _cdk8s_d3d9af27.ApiObject:
        '''The underlying cdk8s API object.

        :see: base.Resource.apiObject
        '''
        return typing.cast(_cdk8s_d3d9af27.ApiObject, jsii.get(self, "apiObject"))

    @builtins.property
    @jsii.member(jsii_name="binaryData")
    def binary_data(self) -> typing.Mapping[builtins.str, builtins.str]:
        '''The binary data associated with this config map.

        Returns a copy. To add data records, use ``addBinaryData()`` or ``addData()``.
        '''
        return typing.cast(typing.Mapping[builtins.str, builtins.str], jsii.get(self, "binaryData"))

    @builtins.property
    @jsii.member(jsii_name="data")
    def data(self) -> typing.Mapping[builtins.str, builtins.str]:
        '''The data associated with this config map.

        Returns an copy. To add data records, use ``addData()`` or ``addBinaryData()``.
        '''
        return typing.cast(typing.Mapping[builtins.str, builtins.str], jsii.get(self, "data"))

    @builtins.property
    @jsii.member(jsii_name="immutable")
    def immutable(self) -> builtins.bool:
        '''Whether or not this config map is immutable.'''
        return typing.cast(builtins.bool, jsii.get(self, "immutable"))

    @builtins.property
    @jsii.member(jsii_name="resourceType")
    def resource_type(self) -> builtins.str:
        '''The name of a resource type as it appears in the relevant API endpoint.'''
        return typing.cast(builtins.str, jsii.get(self, "resourceType"))


class CronJob(Workload, metaclass=jsii.JSIIMeta, jsii_type="cdk8s-plus-24.CronJob"):
    '''A CronJob is responsible for creating a Job and scheduling it based on provided cron schedule.

    This helps running Jobs in a recurring manner.
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        schedule: _cdk8s_d3d9af27.Cron,
        concurrency_policy: typing.Optional[ConcurrencyPolicy] = None,
        failed_jobs_retained: typing.Optional[jsii.Number] = None,
        starting_deadline: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        successful_jobs_retained: typing.Optional[jsii.Number] = None,
        suspend: typing.Optional[builtins.bool] = None,
        time_zone: typing.Optional[builtins.str] = None,
        active_deadline: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        backoff_limit: typing.Optional[jsii.Number] = None,
        ttl_after_finished: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        pod_metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        select: typing.Optional[builtins.bool] = None,
        spread: typing.Optional[builtins.bool] = None,
        automount_service_account_token: typing.Optional[builtins.bool] = None,
        containers: typing.Optional[typing.Sequence[typing.Union[ContainerProps, typing.Dict[builtins.str, typing.Any]]]] = None,
        dns: typing.Optional[typing.Union[PodDnsProps, typing.Dict[builtins.str, typing.Any]]] = None,
        docker_registry_auth: typing.Optional[ISecret] = None,
        host_aliases: typing.Optional[typing.Sequence[typing.Union[HostAlias, typing.Dict[builtins.str, typing.Any]]]] = None,
        host_network: typing.Optional[builtins.bool] = None,
        init_containers: typing.Optional[typing.Sequence[typing.Union[ContainerProps, typing.Dict[builtins.str, typing.Any]]]] = None,
        isolate: typing.Optional[builtins.bool] = None,
        restart_policy: typing.Optional[RestartPolicy] = None,
        security_context: typing.Optional[typing.Union[PodSecurityContextProps, typing.Dict[builtins.str, typing.Any]]] = None,
        service_account: typing.Optional[IServiceAccount] = None,
        termination_grace_period: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        volumes: typing.Optional[typing.Sequence[Volume]] = None,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param schedule: Specifies the time in which the job would run again. This is defined as a cron expression in the CronJob resource.
        :param concurrency_policy: Specifies the concurrency policy for the job. Default: ConcurrencyPolicy.Forbid
        :param failed_jobs_retained: Specifies the number of failed jobs history retained. This would retain the Job and the associated Pod resource and can be useful for debugging. Default: 1
        :param starting_deadline: Kubernetes attempts to start cron jobs at its schedule time, but this is not guaranteed. This deadline specifies how much time can pass after a schedule point, for which kubernetes can still start the job. For example, if this is set to 100 seconds, kubernetes is allowed to start the job at a maximum 100 seconds after the scheduled time. Note that the Kubernetes CronJobController checks for things every 10 seconds, for this reason, a deadline below 10 seconds is not allowed, as it may cause your job to never be scheduled. In addition, kubernetes will stop scheduling jobs if more than 100 schedules were missed (for any reason). This property also controls what time interval should kubernetes consider when counting for missed schedules. For example, suppose a CronJob is set to schedule a new Job every one minute beginning at 08:30:00, and its ``startingDeadline`` field is not set. If the CronJob controller happens to be down from 08:29:00 to 10:21:00, the job will not start as the number of missed jobs which missed their schedule is greater than 100. However, if ``startingDeadline`` is set to 200 seconds, kubernetes will only count 3 missed schedules, and thus start a new execution at 10:22:00. Default: Duration.seconds(10)
        :param successful_jobs_retained: Specifies the number of successful jobs history retained. This would retain the Job and the associated Pod resource and can be useful for debugging. Default: 3
        :param suspend: Specifies if the cron job should be suspended. Only applies to future executions, current ones are remained untouched. Default: false
        :param time_zone: Specifies the timezone for the job. This helps aligining the schedule to follow the specified timezone. Default: - Timezone of kube-controller-manager process.
        :param active_deadline: Specifies the duration the job may be active before the system tries to terminate it. Default: - If unset, then there is no deadline.
        :param backoff_limit: Specifies the number of retries before marking this job failed. Default: - If not set, system defaults to 6.
        :param ttl_after_finished: Limits the lifetime of a Job that has finished execution (either Complete or Failed). If this field is set, after the Job finishes, it is eligible to be automatically deleted. When the Job is being deleted, its lifecycle guarantees (e.g. finalizers) will be honored. If this field is set to zero, the Job becomes eligible to be deleted immediately after it finishes. This field is alpha-level and is only honored by servers that enable the ``TTLAfterFinished`` feature. Default: - If this field is unset, the Job won't be automatically deleted.
        :param pod_metadata: The pod metadata of this workload.
        :param select: Automatically allocates a pod label selector for this workload and add it to the pod metadata. This ensures this workload manages pods created by its pod template. Default: true
        :param spread: Automatically spread pods across hostname and zones. Default: false
        :param automount_service_account_token: Indicates whether a service account token should be automatically mounted. Default: false
        :param containers: List of containers belonging to the pod. Containers cannot currently be added or removed. There must be at least one container in a Pod. You can add additionnal containers using ``podSpec.addContainer()`` Default: - No containers. Note that a pod spec must include at least one container.
        :param dns: DNS settings for the pod. Default: policy: DnsPolicy.CLUSTER_FIRST hostnameAsFQDN: false
        :param docker_registry_auth: A secret containing docker credentials for authenticating to a registry. Default: - No auth. Images are assumed to be publicly available.
        :param host_aliases: HostAlias holds the mapping between IP and hostnames that will be injected as an entry in the pod's hosts file.
        :param host_network: Host network for the pod. Default: false
        :param init_containers: List of initialization containers belonging to the pod. Init containers are executed in order prior to containers being started. If any init container fails, the pod is considered to have failed and is handled according to its restartPolicy. The name for an init container or normal container must be unique among all containers. Init containers may not have Lifecycle actions, Readiness probes, Liveness probes, or Startup probes. The resourceRequirements of an init container are taken into account during scheduling by finding the highest request/limit for each resource type, and then using the max of of that value or the sum of the normal containers. Limits are applied to init containers in a similar fashion. Init containers cannot currently be added ,removed or updated. Default: - No init containers.
        :param isolate: Isolates the pod. This will prevent any ingress or egress connections to / from this pod. You can however allow explicit connections post instantiation by using the ``.connections`` property. Default: false
        :param restart_policy: Restart policy for all containers within the pod. Default: RestartPolicy.ALWAYS
        :param security_context: SecurityContext holds pod-level security attributes and common container settings. Default: fsGroupChangePolicy: FsGroupChangePolicy.FsGroupChangePolicy.ALWAYS ensureNonRoot: true
        :param service_account: A service account provides an identity for processes that run in a Pod. When you (a human) access the cluster (for example, using kubectl), you are authenticated by the apiserver as a particular User Account (currently this is usually admin, unless your cluster administrator has customized your cluster). Processes in containers inside pods can also contact the apiserver. When they do, they are authenticated as a particular Service Account (for example, default). Default: - No service account.
        :param termination_grace_period: Grace period until the pod is terminated. Default: Duration.seconds(30)
        :param volumes: List of volumes that can be mounted by containers belonging to the pod. You can also add volumes later using ``podSpec.addVolume()`` Default: - No volumes.
        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c641b26e3f4464ca415806514a20ef7e5b7aa6c5d790fd7b47067b2f00e61c4e)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = CronJobProps(
            schedule=schedule,
            concurrency_policy=concurrency_policy,
            failed_jobs_retained=failed_jobs_retained,
            starting_deadline=starting_deadline,
            successful_jobs_retained=successful_jobs_retained,
            suspend=suspend,
            time_zone=time_zone,
            active_deadline=active_deadline,
            backoff_limit=backoff_limit,
            ttl_after_finished=ttl_after_finished,
            pod_metadata=pod_metadata,
            select=select,
            spread=spread,
            automount_service_account_token=automount_service_account_token,
            containers=containers,
            dns=dns,
            docker_registry_auth=docker_registry_auth,
            host_aliases=host_aliases,
            host_network=host_network,
            init_containers=init_containers,
            isolate=isolate,
            restart_policy=restart_policy,
            security_context=security_context,
            service_account=service_account,
            termination_grace_period=termination_grace_period,
            volumes=volumes,
            metadata=metadata,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @builtins.property
    @jsii.member(jsii_name="apiObject")
    def _api_object(self) -> _cdk8s_d3d9af27.ApiObject:
        '''The underlying cdk8s API object.

        :see: base.Resource.apiObject
        '''
        return typing.cast(_cdk8s_d3d9af27.ApiObject, jsii.get(self, "apiObject"))

    @builtins.property
    @jsii.member(jsii_name="concurrencyPolicy")
    def concurrency_policy(self) -> builtins.str:
        '''The policy used by this cron job to determine the concurrency mode in which to schedule jobs.'''
        return typing.cast(builtins.str, jsii.get(self, "concurrencyPolicy"))

    @builtins.property
    @jsii.member(jsii_name="failedJobsRetained")
    def failed_jobs_retained(self) -> jsii.Number:
        '''The number of failed jobs retained by this cron job.'''
        return typing.cast(jsii.Number, jsii.get(self, "failedJobsRetained"))

    @builtins.property
    @jsii.member(jsii_name="resourceType")
    def resource_type(self) -> builtins.str:
        '''Represents the resource type.'''
        return typing.cast(builtins.str, jsii.get(self, "resourceType"))

    @builtins.property
    @jsii.member(jsii_name="schedule")
    def schedule(self) -> _cdk8s_d3d9af27.Cron:
        '''The schedule this cron job is scheduled to run in.'''
        return typing.cast(_cdk8s_d3d9af27.Cron, jsii.get(self, "schedule"))

    @builtins.property
    @jsii.member(jsii_name="startingDeadline")
    def starting_deadline(self) -> _cdk8s_d3d9af27.Duration:
        '''The time by which the running cron job needs to schedule the next job execution.

        The job is considered as failed if it misses this deadline.
        '''
        return typing.cast(_cdk8s_d3d9af27.Duration, jsii.get(self, "startingDeadline"))

    @builtins.property
    @jsii.member(jsii_name="successfulJobsRetained")
    def successful_jobs_retained(self) -> jsii.Number:
        '''The number of successful jobs retained by this cron job.'''
        return typing.cast(jsii.Number, jsii.get(self, "successfulJobsRetained"))

    @builtins.property
    @jsii.member(jsii_name="suspend")
    def suspend(self) -> builtins.bool:
        '''Whether or not the cron job is currently suspended or not.'''
        return typing.cast(builtins.bool, jsii.get(self, "suspend"))

    @builtins.property
    @jsii.member(jsii_name="timeZone")
    def time_zone(self) -> typing.Optional[builtins.str]:
        '''The timezone which this cron job would follow to schedule jobs.'''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "timeZone"))


class DaemonSet(Workload, metaclass=jsii.JSIIMeta, jsii_type="cdk8s-plus-24.DaemonSet"):
    '''A DaemonSet ensures that all (or some) Nodes run a copy of a Pod.

    As nodes are added to the cluster, Pods are added to them.
    As nodes are removed from the cluster, those Pods are garbage collected.
    Deleting a DaemonSet will clean up the Pods it created.

    Some typical uses of a DaemonSet are:

    - running a cluster storage daemon on every node
    - running a logs collection daemon on every node
    - running a node monitoring daemon on every node

    In a simple case, one DaemonSet, covering all nodes, would be used for each type of daemon.
    A more complex setup might use multiple DaemonSets for a single type of daemon,
    but with different flags and/or different memory and cpu requests for different hardware types.
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        min_ready_seconds: typing.Optional[jsii.Number] = None,
        pod_metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        select: typing.Optional[builtins.bool] = None,
        spread: typing.Optional[builtins.bool] = None,
        automount_service_account_token: typing.Optional[builtins.bool] = None,
        containers: typing.Optional[typing.Sequence[typing.Union[ContainerProps, typing.Dict[builtins.str, typing.Any]]]] = None,
        dns: typing.Optional[typing.Union[PodDnsProps, typing.Dict[builtins.str, typing.Any]]] = None,
        docker_registry_auth: typing.Optional[ISecret] = None,
        host_aliases: typing.Optional[typing.Sequence[typing.Union[HostAlias, typing.Dict[builtins.str, typing.Any]]]] = None,
        host_network: typing.Optional[builtins.bool] = None,
        init_containers: typing.Optional[typing.Sequence[typing.Union[ContainerProps, typing.Dict[builtins.str, typing.Any]]]] = None,
        isolate: typing.Optional[builtins.bool] = None,
        restart_policy: typing.Optional[RestartPolicy] = None,
        security_context: typing.Optional[typing.Union[PodSecurityContextProps, typing.Dict[builtins.str, typing.Any]]] = None,
        service_account: typing.Optional[IServiceAccount] = None,
        termination_grace_period: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        volumes: typing.Optional[typing.Sequence[Volume]] = None,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param min_ready_seconds: Minimum number of seconds for which a newly created pod should be ready without any of its container crashing, for it to be considered available. Default: 0
        :param pod_metadata: The pod metadata of this workload.
        :param select: Automatically allocates a pod label selector for this workload and add it to the pod metadata. This ensures this workload manages pods created by its pod template. Default: true
        :param spread: Automatically spread pods across hostname and zones. Default: false
        :param automount_service_account_token: Indicates whether a service account token should be automatically mounted. Default: false
        :param containers: List of containers belonging to the pod. Containers cannot currently be added or removed. There must be at least one container in a Pod. You can add additionnal containers using ``podSpec.addContainer()`` Default: - No containers. Note that a pod spec must include at least one container.
        :param dns: DNS settings for the pod. Default: policy: DnsPolicy.CLUSTER_FIRST hostnameAsFQDN: false
        :param docker_registry_auth: A secret containing docker credentials for authenticating to a registry. Default: - No auth. Images are assumed to be publicly available.
        :param host_aliases: HostAlias holds the mapping between IP and hostnames that will be injected as an entry in the pod's hosts file.
        :param host_network: Host network for the pod. Default: false
        :param init_containers: List of initialization containers belonging to the pod. Init containers are executed in order prior to containers being started. If any init container fails, the pod is considered to have failed and is handled according to its restartPolicy. The name for an init container or normal container must be unique among all containers. Init containers may not have Lifecycle actions, Readiness probes, Liveness probes, or Startup probes. The resourceRequirements of an init container are taken into account during scheduling by finding the highest request/limit for each resource type, and then using the max of of that value or the sum of the normal containers. Limits are applied to init containers in a similar fashion. Init containers cannot currently be added ,removed or updated. Default: - No init containers.
        :param isolate: Isolates the pod. This will prevent any ingress or egress connections to / from this pod. You can however allow explicit connections post instantiation by using the ``.connections`` property. Default: false
        :param restart_policy: Restart policy for all containers within the pod. Default: RestartPolicy.ALWAYS
        :param security_context: SecurityContext holds pod-level security attributes and common container settings. Default: fsGroupChangePolicy: FsGroupChangePolicy.FsGroupChangePolicy.ALWAYS ensureNonRoot: true
        :param service_account: A service account provides an identity for processes that run in a Pod. When you (a human) access the cluster (for example, using kubectl), you are authenticated by the apiserver as a particular User Account (currently this is usually admin, unless your cluster administrator has customized your cluster). Processes in containers inside pods can also contact the apiserver. When they do, they are authenticated as a particular Service Account (for example, default). Default: - No service account.
        :param termination_grace_period: Grace period until the pod is terminated. Default: Duration.seconds(30)
        :param volumes: List of volumes that can be mounted by containers belonging to the pod. You can also add volumes later using ``podSpec.addVolume()`` Default: - No volumes.
        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__977e4f0b5b96ceeab27f0aa069865609b19d2ab3dd02e3e25365f9c67a68af05)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = DaemonSetProps(
            min_ready_seconds=min_ready_seconds,
            pod_metadata=pod_metadata,
            select=select,
            spread=spread,
            automount_service_account_token=automount_service_account_token,
            containers=containers,
            dns=dns,
            docker_registry_auth=docker_registry_auth,
            host_aliases=host_aliases,
            host_network=host_network,
            init_containers=init_containers,
            isolate=isolate,
            restart_policy=restart_policy,
            security_context=security_context,
            service_account=service_account,
            termination_grace_period=termination_grace_period,
            volumes=volumes,
            metadata=metadata,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @builtins.property
    @jsii.member(jsii_name="apiObject")
    def _api_object(self) -> _cdk8s_d3d9af27.ApiObject:
        '''The underlying cdk8s API object.

        :see: base.Resource.apiObject
        '''
        return typing.cast(_cdk8s_d3d9af27.ApiObject, jsii.get(self, "apiObject"))

    @builtins.property
    @jsii.member(jsii_name="minReadySeconds")
    def min_ready_seconds(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "minReadySeconds"))

    @builtins.property
    @jsii.member(jsii_name="resourceType")
    def resource_type(self) -> builtins.str:
        '''The name of a resource type as it appears in the relevant API endpoint.'''
        return typing.cast(builtins.str, jsii.get(self, "resourceType"))


@jsii.data_type(
    jsii_type="cdk8s-plus-24.DaemonSetProps",
    jsii_struct_bases=[WorkloadProps],
    name_mapping={
        "metadata": "metadata",
        "automount_service_account_token": "automountServiceAccountToken",
        "containers": "containers",
        "dns": "dns",
        "docker_registry_auth": "dockerRegistryAuth",
        "host_aliases": "hostAliases",
        "host_network": "hostNetwork",
        "init_containers": "initContainers",
        "isolate": "isolate",
        "restart_policy": "restartPolicy",
        "security_context": "securityContext",
        "service_account": "serviceAccount",
        "termination_grace_period": "terminationGracePeriod",
        "volumes": "volumes",
        "pod_metadata": "podMetadata",
        "select": "select",
        "spread": "spread",
        "min_ready_seconds": "minReadySeconds",
    },
)
class DaemonSetProps(WorkloadProps):
    def __init__(
        self,
        *,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        automount_service_account_token: typing.Optional[builtins.bool] = None,
        containers: typing.Optional[typing.Sequence[typing.Union[ContainerProps, typing.Dict[builtins.str, typing.Any]]]] = None,
        dns: typing.Optional[typing.Union[PodDnsProps, typing.Dict[builtins.str, typing.Any]]] = None,
        docker_registry_auth: typing.Optional[ISecret] = None,
        host_aliases: typing.Optional[typing.Sequence[typing.Union[HostAlias, typing.Dict[builtins.str, typing.Any]]]] = None,
        host_network: typing.Optional[builtins.bool] = None,
        init_containers: typing.Optional[typing.Sequence[typing.Union[ContainerProps, typing.Dict[builtins.str, typing.Any]]]] = None,
        isolate: typing.Optional[builtins.bool] = None,
        restart_policy: typing.Optional[RestartPolicy] = None,
        security_context: typing.Optional[typing.Union[PodSecurityContextProps, typing.Dict[builtins.str, typing.Any]]] = None,
        service_account: typing.Optional[IServiceAccount] = None,
        termination_grace_period: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        volumes: typing.Optional[typing.Sequence[Volume]] = None,
        pod_metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        select: typing.Optional[builtins.bool] = None,
        spread: typing.Optional[builtins.bool] = None,
        min_ready_seconds: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''Properties for ``DaemonSet``.

        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        :param automount_service_account_token: Indicates whether a service account token should be automatically mounted. Default: false
        :param containers: List of containers belonging to the pod. Containers cannot currently be added or removed. There must be at least one container in a Pod. You can add additionnal containers using ``podSpec.addContainer()`` Default: - No containers. Note that a pod spec must include at least one container.
        :param dns: DNS settings for the pod. Default: policy: DnsPolicy.CLUSTER_FIRST hostnameAsFQDN: false
        :param docker_registry_auth: A secret containing docker credentials for authenticating to a registry. Default: - No auth. Images are assumed to be publicly available.
        :param host_aliases: HostAlias holds the mapping between IP and hostnames that will be injected as an entry in the pod's hosts file.
        :param host_network: Host network for the pod. Default: false
        :param init_containers: List of initialization containers belonging to the pod. Init containers are executed in order prior to containers being started. If any init container fails, the pod is considered to have failed and is handled according to its restartPolicy. The name for an init container or normal container must be unique among all containers. Init containers may not have Lifecycle actions, Readiness probes, Liveness probes, or Startup probes. The resourceRequirements of an init container are taken into account during scheduling by finding the highest request/limit for each resource type, and then using the max of of that value or the sum of the normal containers. Limits are applied to init containers in a similar fashion. Init containers cannot currently be added ,removed or updated. Default: - No init containers.
        :param isolate: Isolates the pod. This will prevent any ingress or egress connections to / from this pod. You can however allow explicit connections post instantiation by using the ``.connections`` property. Default: false
        :param restart_policy: Restart policy for all containers within the pod. Default: RestartPolicy.ALWAYS
        :param security_context: SecurityContext holds pod-level security attributes and common container settings. Default: fsGroupChangePolicy: FsGroupChangePolicy.FsGroupChangePolicy.ALWAYS ensureNonRoot: true
        :param service_account: A service account provides an identity for processes that run in a Pod. When you (a human) access the cluster (for example, using kubectl), you are authenticated by the apiserver as a particular User Account (currently this is usually admin, unless your cluster administrator has customized your cluster). Processes in containers inside pods can also contact the apiserver. When they do, they are authenticated as a particular Service Account (for example, default). Default: - No service account.
        :param termination_grace_period: Grace period until the pod is terminated. Default: Duration.seconds(30)
        :param volumes: List of volumes that can be mounted by containers belonging to the pod. You can also add volumes later using ``podSpec.addVolume()`` Default: - No volumes.
        :param pod_metadata: The pod metadata of this workload.
        :param select: Automatically allocates a pod label selector for this workload and add it to the pod metadata. This ensures this workload manages pods created by its pod template. Default: true
        :param spread: Automatically spread pods across hostname and zones. Default: false
        :param min_ready_seconds: Minimum number of seconds for which a newly created pod should be ready without any of its container crashing, for it to be considered available. Default: 0
        '''
        if isinstance(metadata, dict):
            metadata = _cdk8s_d3d9af27.ApiObjectMetadata(**metadata)
        if isinstance(dns, dict):
            dns = PodDnsProps(**dns)
        if isinstance(security_context, dict):
            security_context = PodSecurityContextProps(**security_context)
        if isinstance(pod_metadata, dict):
            pod_metadata = _cdk8s_d3d9af27.ApiObjectMetadata(**pod_metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b5528f2070f06e5445280a54fe214853d74955abe492c4fd78fdd579106d91aa)
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument automount_service_account_token", value=automount_service_account_token, expected_type=type_hints["automount_service_account_token"])
            check_type(argname="argument containers", value=containers, expected_type=type_hints["containers"])
            check_type(argname="argument dns", value=dns, expected_type=type_hints["dns"])
            check_type(argname="argument docker_registry_auth", value=docker_registry_auth, expected_type=type_hints["docker_registry_auth"])
            check_type(argname="argument host_aliases", value=host_aliases, expected_type=type_hints["host_aliases"])
            check_type(argname="argument host_network", value=host_network, expected_type=type_hints["host_network"])
            check_type(argname="argument init_containers", value=init_containers, expected_type=type_hints["init_containers"])
            check_type(argname="argument isolate", value=isolate, expected_type=type_hints["isolate"])
            check_type(argname="argument restart_policy", value=restart_policy, expected_type=type_hints["restart_policy"])
            check_type(argname="argument security_context", value=security_context, expected_type=type_hints["security_context"])
            check_type(argname="argument service_account", value=service_account, expected_type=type_hints["service_account"])
            check_type(argname="argument termination_grace_period", value=termination_grace_period, expected_type=type_hints["termination_grace_period"])
            check_type(argname="argument volumes", value=volumes, expected_type=type_hints["volumes"])
            check_type(argname="argument pod_metadata", value=pod_metadata, expected_type=type_hints["pod_metadata"])
            check_type(argname="argument select", value=select, expected_type=type_hints["select"])
            check_type(argname="argument spread", value=spread, expected_type=type_hints["spread"])
            check_type(argname="argument min_ready_seconds", value=min_ready_seconds, expected_type=type_hints["min_ready_seconds"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if metadata is not None:
            self._values["metadata"] = metadata
        if automount_service_account_token is not None:
            self._values["automount_service_account_token"] = automount_service_account_token
        if containers is not None:
            self._values["containers"] = containers
        if dns is not None:
            self._values["dns"] = dns
        if docker_registry_auth is not None:
            self._values["docker_registry_auth"] = docker_registry_auth
        if host_aliases is not None:
            self._values["host_aliases"] = host_aliases
        if host_network is not None:
            self._values["host_network"] = host_network
        if init_containers is not None:
            self._values["init_containers"] = init_containers
        if isolate is not None:
            self._values["isolate"] = isolate
        if restart_policy is not None:
            self._values["restart_policy"] = restart_policy
        if security_context is not None:
            self._values["security_context"] = security_context
        if service_account is not None:
            self._values["service_account"] = service_account
        if termination_grace_period is not None:
            self._values["termination_grace_period"] = termination_grace_period
        if volumes is not None:
            self._values["volumes"] = volumes
        if pod_metadata is not None:
            self._values["pod_metadata"] = pod_metadata
        if select is not None:
            self._values["select"] = select
        if spread is not None:
            self._values["spread"] = spread
        if min_ready_seconds is not None:
            self._values["min_ready_seconds"] = min_ready_seconds

    @builtins.property
    def metadata(self) -> typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata]:
        '''Metadata that all persisted resources must have, which includes all objects users must create.'''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata], result)

    @builtins.property
    def automount_service_account_token(self) -> typing.Optional[builtins.bool]:
        '''Indicates whether a service account token should be automatically mounted.

        :default: false

        :see: https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/#use-the-default-service-account-to-access-the-api-server
        '''
        result = self._values.get("automount_service_account_token")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def containers(self) -> typing.Optional[typing.List[ContainerProps]]:
        '''List of containers belonging to the pod.

        Containers cannot currently be
        added or removed. There must be at least one container in a Pod.

        You can add additionnal containers using ``podSpec.addContainer()``

        :default: - No containers. Note that a pod spec must include at least one container.
        '''
        result = self._values.get("containers")
        return typing.cast(typing.Optional[typing.List[ContainerProps]], result)

    @builtins.property
    def dns(self) -> typing.Optional[PodDnsProps]:
        '''DNS settings for the pod.

        :default:

        policy: DnsPolicy.CLUSTER_FIRST
        hostnameAsFQDN: false

        :see: https://kubernetes.io/docs/concepts/services-networking/dns-pod-service/
        '''
        result = self._values.get("dns")
        return typing.cast(typing.Optional[PodDnsProps], result)

    @builtins.property
    def docker_registry_auth(self) -> typing.Optional[ISecret]:
        '''A secret containing docker credentials for authenticating to a registry.

        :default: - No auth. Images are assumed to be publicly available.
        '''
        result = self._values.get("docker_registry_auth")
        return typing.cast(typing.Optional[ISecret], result)

    @builtins.property
    def host_aliases(self) -> typing.Optional[typing.List[HostAlias]]:
        '''HostAlias holds the mapping between IP and hostnames that will be injected as an entry in the pod's hosts file.

        :schema: io.k8s.api.core.v1.HostAlias
        '''
        result = self._values.get("host_aliases")
        return typing.cast(typing.Optional[typing.List[HostAlias]], result)

    @builtins.property
    def host_network(self) -> typing.Optional[builtins.bool]:
        '''Host network for the pod.

        :default: false
        '''
        result = self._values.get("host_network")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def init_containers(self) -> typing.Optional[typing.List[ContainerProps]]:
        '''List of initialization containers belonging to the pod.

        Init containers are executed in order prior to containers being started.
        If any init container fails, the pod is considered to have failed and is handled according to its restartPolicy.
        The name for an init container or normal container must be unique among all containers.
        Init containers may not have Lifecycle actions, Readiness probes, Liveness probes, or Startup probes.
        The resourceRequirements of an init container are taken into account during scheduling by finding the highest request/limit
        for each resource type, and then using the max of of that value or the sum of the normal containers.
        Limits are applied to init containers in a similar fashion.

        Init containers cannot currently be added ,removed or updated.

        :default: - No init containers.

        :see: https://kubernetes.io/docs/concepts/workloads/pods/init-containers/
        '''
        result = self._values.get("init_containers")
        return typing.cast(typing.Optional[typing.List[ContainerProps]], result)

    @builtins.property
    def isolate(self) -> typing.Optional[builtins.bool]:
        '''Isolates the pod.

        This will prevent any ingress or egress connections to / from this pod.
        You can however allow explicit connections post instantiation by using the ``.connections`` property.

        :default: false
        '''
        result = self._values.get("isolate")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def restart_policy(self) -> typing.Optional[RestartPolicy]:
        '''Restart policy for all containers within the pod.

        :default: RestartPolicy.ALWAYS

        :see: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle/#restart-policy
        '''
        result = self._values.get("restart_policy")
        return typing.cast(typing.Optional[RestartPolicy], result)

    @builtins.property
    def security_context(self) -> typing.Optional[PodSecurityContextProps]:
        '''SecurityContext holds pod-level security attributes and common container settings.

        :default:

        fsGroupChangePolicy: FsGroupChangePolicy.FsGroupChangePolicy.ALWAYS
        ensureNonRoot: true
        '''
        result = self._values.get("security_context")
        return typing.cast(typing.Optional[PodSecurityContextProps], result)

    @builtins.property
    def service_account(self) -> typing.Optional[IServiceAccount]:
        '''A service account provides an identity for processes that run in a Pod.

        When you (a human) access the cluster (for example, using kubectl), you are
        authenticated by the apiserver as a particular User Account (currently this
        is usually admin, unless your cluster administrator has customized your
        cluster). Processes in containers inside pods can also contact the
        apiserver. When they do, they are authenticated as a particular Service
        Account (for example, default).

        :default: - No service account.

        :see: https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/
        '''
        result = self._values.get("service_account")
        return typing.cast(typing.Optional[IServiceAccount], result)

    @builtins.property
    def termination_grace_period(self) -> typing.Optional[_cdk8s_d3d9af27.Duration]:
        '''Grace period until the pod is terminated.

        :default: Duration.seconds(30)
        '''
        result = self._values.get("termination_grace_period")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Duration], result)

    @builtins.property
    def volumes(self) -> typing.Optional[typing.List[Volume]]:
        '''List of volumes that can be mounted by containers belonging to the pod.

        You can also add volumes later using ``podSpec.addVolume()``

        :default: - No volumes.

        :see: https://kubernetes.io/docs/concepts/storage/volumes
        '''
        result = self._values.get("volumes")
        return typing.cast(typing.Optional[typing.List[Volume]], result)

    @builtins.property
    def pod_metadata(self) -> typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata]:
        '''The pod metadata of this workload.'''
        result = self._values.get("pod_metadata")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata], result)

    @builtins.property
    def select(self) -> typing.Optional[builtins.bool]:
        '''Automatically allocates a pod label selector for this workload and add it to the pod metadata.

        This ensures this workload manages pods created by
        its pod template.

        :default: true
        '''
        result = self._values.get("select")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def spread(self) -> typing.Optional[builtins.bool]:
        '''Automatically spread pods across hostname and zones.

        :default: false

        :see: https://kubernetes.io/docs/concepts/scheduling-eviction/topology-spread-constraints/#internal-default-constraints
        '''
        result = self._values.get("spread")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def min_ready_seconds(self) -> typing.Optional[jsii.Number]:
        '''Minimum number of seconds for which a newly created pod should be ready without any of its container crashing, for it to be considered available.

        :default: 0
        '''
        result = self._values.get("min_ready_seconds")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DaemonSetProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(IScalable)
class Deployment(
    Workload,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-24.Deployment",
):
    '''A Deployment provides declarative updates for Pods and ReplicaSets.

    You describe a desired state in a Deployment, and the Deployment Controller changes the actual
    state to the desired state at a controlled rate. You can define Deployments to create new ReplicaSets, or to remove
    existing Deployments and adopt all their resources with new Deployments.
    .. epigraph::

       Note: Do not manage ReplicaSets owned by a Deployment. Consider opening an issue in the main Kubernetes repository if your use case is not covered below.

    Use Case

    The following are typical use cases for Deployments:

    - Create a Deployment to rollout a ReplicaSet. The ReplicaSet creates Pods in the background.
      Check the status of the rollout to see if it succeeds or not.
    - Declare the new state of the Pods by updating the PodTemplateSpec of the Deployment.
      A new ReplicaSet is created and the Deployment manages moving the Pods from the old ReplicaSet to the new one at a controlled rate.
      Each new ReplicaSet updates the revision of the Deployment.
    - Rollback to an earlier Deployment revision if the current state of the Deployment is not stable.
      Each rollback updates the revision of the Deployment.
    - Scale up the Deployment to facilitate more load.
    - Pause the Deployment to apply multiple fixes to its PodTemplateSpec and then resume it to start a new rollout.
    - Use the status of the Deployment as an indicator that a rollout has stuck.
    - Clean up older ReplicaSets that you don't need anymore.
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        min_ready: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        progress_deadline: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        replicas: typing.Optional[jsii.Number] = None,
        strategy: typing.Optional[DeploymentStrategy] = None,
        pod_metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        select: typing.Optional[builtins.bool] = None,
        spread: typing.Optional[builtins.bool] = None,
        automount_service_account_token: typing.Optional[builtins.bool] = None,
        containers: typing.Optional[typing.Sequence[typing.Union[ContainerProps, typing.Dict[builtins.str, typing.Any]]]] = None,
        dns: typing.Optional[typing.Union[PodDnsProps, typing.Dict[builtins.str, typing.Any]]] = None,
        docker_registry_auth: typing.Optional[ISecret] = None,
        host_aliases: typing.Optional[typing.Sequence[typing.Union[HostAlias, typing.Dict[builtins.str, typing.Any]]]] = None,
        host_network: typing.Optional[builtins.bool] = None,
        init_containers: typing.Optional[typing.Sequence[typing.Union[ContainerProps, typing.Dict[builtins.str, typing.Any]]]] = None,
        isolate: typing.Optional[builtins.bool] = None,
        restart_policy: typing.Optional[RestartPolicy] = None,
        security_context: typing.Optional[typing.Union[PodSecurityContextProps, typing.Dict[builtins.str, typing.Any]]] = None,
        service_account: typing.Optional[IServiceAccount] = None,
        termination_grace_period: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        volumes: typing.Optional[typing.Sequence[Volume]] = None,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param min_ready: Minimum duration for which a newly created pod should be ready without any of its container crashing, for it to be considered available. Zero means the pod will be considered available as soon as it is ready. Default: Duration.seconds(0)
        :param progress_deadline: The maximum duration for a deployment to make progress before it is considered to be failed. The deployment controller will continue to process failed deployments and a condition with a ProgressDeadlineExceeded reason will be surfaced in the deployment status. Note that progress will not be estimated during the time a deployment is paused. Default: Duration.seconds(600)
        :param replicas: Number of desired pods. Default: 2
        :param strategy: Specifies the strategy used to replace old Pods by new ones. Default: - RollingUpdate with maxSurge and maxUnavailable set to 25%.
        :param pod_metadata: The pod metadata of this workload.
        :param select: Automatically allocates a pod label selector for this workload and add it to the pod metadata. This ensures this workload manages pods created by its pod template. Default: true
        :param spread: Automatically spread pods across hostname and zones. Default: false
        :param automount_service_account_token: Indicates whether a service account token should be automatically mounted. Default: false
        :param containers: List of containers belonging to the pod. Containers cannot currently be added or removed. There must be at least one container in a Pod. You can add additionnal containers using ``podSpec.addContainer()`` Default: - No containers. Note that a pod spec must include at least one container.
        :param dns: DNS settings for the pod. Default: policy: DnsPolicy.CLUSTER_FIRST hostnameAsFQDN: false
        :param docker_registry_auth: A secret containing docker credentials for authenticating to a registry. Default: - No auth. Images are assumed to be publicly available.
        :param host_aliases: HostAlias holds the mapping between IP and hostnames that will be injected as an entry in the pod's hosts file.
        :param host_network: Host network for the pod. Default: false
        :param init_containers: List of initialization containers belonging to the pod. Init containers are executed in order prior to containers being started. If any init container fails, the pod is considered to have failed and is handled according to its restartPolicy. The name for an init container or normal container must be unique among all containers. Init containers may not have Lifecycle actions, Readiness probes, Liveness probes, or Startup probes. The resourceRequirements of an init container are taken into account during scheduling by finding the highest request/limit for each resource type, and then using the max of of that value or the sum of the normal containers. Limits are applied to init containers in a similar fashion. Init containers cannot currently be added ,removed or updated. Default: - No init containers.
        :param isolate: Isolates the pod. This will prevent any ingress or egress connections to / from this pod. You can however allow explicit connections post instantiation by using the ``.connections`` property. Default: false
        :param restart_policy: Restart policy for all containers within the pod. Default: RestartPolicy.ALWAYS
        :param security_context: SecurityContext holds pod-level security attributes and common container settings. Default: fsGroupChangePolicy: FsGroupChangePolicy.FsGroupChangePolicy.ALWAYS ensureNonRoot: true
        :param service_account: A service account provides an identity for processes that run in a Pod. When you (a human) access the cluster (for example, using kubectl), you are authenticated by the apiserver as a particular User Account (currently this is usually admin, unless your cluster administrator has customized your cluster). Processes in containers inside pods can also contact the apiserver. When they do, they are authenticated as a particular Service Account (for example, default). Default: - No service account.
        :param termination_grace_period: Grace period until the pod is terminated. Default: Duration.seconds(30)
        :param volumes: List of volumes that can be mounted by containers belonging to the pod. You can also add volumes later using ``podSpec.addVolume()`` Default: - No volumes.
        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__60a529fd9bde8b941762858ef572977fe41a7bed72472cb3501453c19587a104)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = DeploymentProps(
            min_ready=min_ready,
            progress_deadline=progress_deadline,
            replicas=replicas,
            strategy=strategy,
            pod_metadata=pod_metadata,
            select=select,
            spread=spread,
            automount_service_account_token=automount_service_account_token,
            containers=containers,
            dns=dns,
            docker_registry_auth=docker_registry_auth,
            host_aliases=host_aliases,
            host_network=host_network,
            init_containers=init_containers,
            isolate=isolate,
            restart_policy=restart_policy,
            security_context=security_context,
            service_account=service_account,
            termination_grace_period=termination_grace_period,
            volumes=volumes,
            metadata=metadata,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="exposeViaIngress")
    def expose_via_ingress(
        self,
        path: builtins.str,
        *,
        name: typing.Optional[builtins.str] = None,
        ports: typing.Optional[typing.Sequence[typing.Union[ServicePort, typing.Dict[builtins.str, typing.Any]]]] = None,
        service_type: typing.Optional[ServiceType] = None,
        ingress: typing.Optional[Ingress] = None,
        path_type: typing.Optional[HttpIngressPathType] = None,
    ) -> Ingress:
        '''Expose a deployment via an ingress.

        This will first expose the deployment with a service, and then expose the service via an ingress.

        :param path: The ingress path to register under.
        :param name: The name of the service to expose. If you'd like to expose the deployment multiple times, you must explicitly set a name starting from the second expose call. Default: - auto generated.
        :param ports: The ports that the service should bind to. Default: - extracted from the deployment.
        :param service_type: The type of the exposed service. Default: - ClusterIP.
        :param ingress: The ingress to add rules to. Default: - An ingress will be automatically created.
        :param path_type: The type of the path. Default: HttpIngressPathType.PREFIX
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e8beb2a73a13ada8c9e92aeeeea63dde3a4e04c1343303c509a1c0ac70c71598)
            check_type(argname="argument path", value=path, expected_type=type_hints["path"])
        options = ExposeDeploymentViaIngressOptions(
            name=name,
            ports=ports,
            service_type=service_type,
            ingress=ingress,
            path_type=path_type,
        )

        return typing.cast(Ingress, jsii.invoke(self, "exposeViaIngress", [path, options]))

    @jsii.member(jsii_name="exposeViaService")
    def expose_via_service(
        self,
        *,
        name: typing.Optional[builtins.str] = None,
        ports: typing.Optional[typing.Sequence[typing.Union[ServicePort, typing.Dict[builtins.str, typing.Any]]]] = None,
        service_type: typing.Optional[ServiceType] = None,
    ) -> Service:
        '''Expose a deployment via a service.

        This is equivalent to running ``kubectl expose deployment <deployment-name>``.

        :param name: The name of the service to expose. If you'd like to expose the deployment multiple times, you must explicitly set a name starting from the second expose call. Default: - auto generated.
        :param ports: The ports that the service should bind to. Default: - extracted from the deployment.
        :param service_type: The type of the exposed service. Default: - ClusterIP.
        '''
        options = DeploymentExposeViaServiceOptions(
            name=name, ports=ports, service_type=service_type
        )

        return typing.cast(Service, jsii.invoke(self, "exposeViaService", [options]))

    @jsii.member(jsii_name="markHasAutoscaler")
    def mark_has_autoscaler(self) -> None:
        '''Called on all IScalable targets when they are associated with an autoscaler.

        :see: IScalable.markHasAutoscaler()
        '''
        return typing.cast(None, jsii.invoke(self, "markHasAutoscaler", []))

    @jsii.member(jsii_name="toScalingTarget")
    def to_scaling_target(self) -> ScalingTarget:
        '''Return the target spec properties of this Scalable.

        :see: IScalable.toScalingTarget()
        '''
        return typing.cast(ScalingTarget, jsii.invoke(self, "toScalingTarget", []))

    @builtins.property
    @jsii.member(jsii_name="apiObject")
    def _api_object(self) -> _cdk8s_d3d9af27.ApiObject:
        '''The underlying cdk8s API object.

        :see: base.Resource.apiObject
        '''
        return typing.cast(_cdk8s_d3d9af27.ApiObject, jsii.get(self, "apiObject"))

    @builtins.property
    @jsii.member(jsii_name="minReady")
    def min_ready(self) -> _cdk8s_d3d9af27.Duration:
        '''Minimum duration for which a newly created pod should be ready without any of its container crashing, for it to be considered available.'''
        return typing.cast(_cdk8s_d3d9af27.Duration, jsii.get(self, "minReady"))

    @builtins.property
    @jsii.member(jsii_name="progressDeadline")
    def progress_deadline(self) -> _cdk8s_d3d9af27.Duration:
        '''The maximum duration for a deployment to make progress before it is considered to be failed.'''
        return typing.cast(_cdk8s_d3d9af27.Duration, jsii.get(self, "progressDeadline"))

    @builtins.property
    @jsii.member(jsii_name="resourceType")
    def resource_type(self) -> builtins.str:
        '''The name of a resource type as it appears in the relevant API endpoint.'''
        return typing.cast(builtins.str, jsii.get(self, "resourceType"))

    @builtins.property
    @jsii.member(jsii_name="strategy")
    def strategy(self) -> DeploymentStrategy:
        return typing.cast(DeploymentStrategy, jsii.get(self, "strategy"))

    @builtins.property
    @jsii.member(jsii_name="replicas")
    def replicas(self) -> typing.Optional[jsii.Number]:
        '''Number of desired pods.'''
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "replicas"))

    @builtins.property
    @jsii.member(jsii_name="hasAutoscaler")
    def has_autoscaler(self) -> builtins.bool:
        '''If this is a target of an autoscaler.'''
        return typing.cast(builtins.bool, jsii.get(self, "hasAutoscaler"))

    @has_autoscaler.setter
    def has_autoscaler(self, value: builtins.bool) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__bafad2acb161e63f1a244953adb81e43b8bf75577aeefa89fd3e2a5d423e856a)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "hasAutoscaler", value)


@jsii.data_type(
    jsii_type="cdk8s-plus-24.DeploymentProps",
    jsii_struct_bases=[WorkloadProps],
    name_mapping={
        "metadata": "metadata",
        "automount_service_account_token": "automountServiceAccountToken",
        "containers": "containers",
        "dns": "dns",
        "docker_registry_auth": "dockerRegistryAuth",
        "host_aliases": "hostAliases",
        "host_network": "hostNetwork",
        "init_containers": "initContainers",
        "isolate": "isolate",
        "restart_policy": "restartPolicy",
        "security_context": "securityContext",
        "service_account": "serviceAccount",
        "termination_grace_period": "terminationGracePeriod",
        "volumes": "volumes",
        "pod_metadata": "podMetadata",
        "select": "select",
        "spread": "spread",
        "min_ready": "minReady",
        "progress_deadline": "progressDeadline",
        "replicas": "replicas",
        "strategy": "strategy",
    },
)
class DeploymentProps(WorkloadProps):
    def __init__(
        self,
        *,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        automount_service_account_token: typing.Optional[builtins.bool] = None,
        containers: typing.Optional[typing.Sequence[typing.Union[ContainerProps, typing.Dict[builtins.str, typing.Any]]]] = None,
        dns: typing.Optional[typing.Union[PodDnsProps, typing.Dict[builtins.str, typing.Any]]] = None,
        docker_registry_auth: typing.Optional[ISecret] = None,
        host_aliases: typing.Optional[typing.Sequence[typing.Union[HostAlias, typing.Dict[builtins.str, typing.Any]]]] = None,
        host_network: typing.Optional[builtins.bool] = None,
        init_containers: typing.Optional[typing.Sequence[typing.Union[ContainerProps, typing.Dict[builtins.str, typing.Any]]]] = None,
        isolate: typing.Optional[builtins.bool] = None,
        restart_policy: typing.Optional[RestartPolicy] = None,
        security_context: typing.Optional[typing.Union[PodSecurityContextProps, typing.Dict[builtins.str, typing.Any]]] = None,
        service_account: typing.Optional[IServiceAccount] = None,
        termination_grace_period: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        volumes: typing.Optional[typing.Sequence[Volume]] = None,
        pod_metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        select: typing.Optional[builtins.bool] = None,
        spread: typing.Optional[builtins.bool] = None,
        min_ready: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        progress_deadline: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        replicas: typing.Optional[jsii.Number] = None,
        strategy: typing.Optional[DeploymentStrategy] = None,
    ) -> None:
        '''Properties for ``Deployment``.

        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        :param automount_service_account_token: Indicates whether a service account token should be automatically mounted. Default: false
        :param containers: List of containers belonging to the pod. Containers cannot currently be added or removed. There must be at least one container in a Pod. You can add additionnal containers using ``podSpec.addContainer()`` Default: - No containers. Note that a pod spec must include at least one container.
        :param dns: DNS settings for the pod. Default: policy: DnsPolicy.CLUSTER_FIRST hostnameAsFQDN: false
        :param docker_registry_auth: A secret containing docker credentials for authenticating to a registry. Default: - No auth. Images are assumed to be publicly available.
        :param host_aliases: HostAlias holds the mapping between IP and hostnames that will be injected as an entry in the pod's hosts file.
        :param host_network: Host network for the pod. Default: false
        :param init_containers: List of initialization containers belonging to the pod. Init containers are executed in order prior to containers being started. If any init container fails, the pod is considered to have failed and is handled according to its restartPolicy. The name for an init container or normal container must be unique among all containers. Init containers may not have Lifecycle actions, Readiness probes, Liveness probes, or Startup probes. The resourceRequirements of an init container are taken into account during scheduling by finding the highest request/limit for each resource type, and then using the max of of that value or the sum of the normal containers. Limits are applied to init containers in a similar fashion. Init containers cannot currently be added ,removed or updated. Default: - No init containers.
        :param isolate: Isolates the pod. This will prevent any ingress or egress connections to / from this pod. You can however allow explicit connections post instantiation by using the ``.connections`` property. Default: false
        :param restart_policy: Restart policy for all containers within the pod. Default: RestartPolicy.ALWAYS
        :param security_context: SecurityContext holds pod-level security attributes and common container settings. Default: fsGroupChangePolicy: FsGroupChangePolicy.FsGroupChangePolicy.ALWAYS ensureNonRoot: true
        :param service_account: A service account provides an identity for processes that run in a Pod. When you (a human) access the cluster (for example, using kubectl), you are authenticated by the apiserver as a particular User Account (currently this is usually admin, unless your cluster administrator has customized your cluster). Processes in containers inside pods can also contact the apiserver. When they do, they are authenticated as a particular Service Account (for example, default). Default: - No service account.
        :param termination_grace_period: Grace period until the pod is terminated. Default: Duration.seconds(30)
        :param volumes: List of volumes that can be mounted by containers belonging to the pod. You can also add volumes later using ``podSpec.addVolume()`` Default: - No volumes.
        :param pod_metadata: The pod metadata of this workload.
        :param select: Automatically allocates a pod label selector for this workload and add it to the pod metadata. This ensures this workload manages pods created by its pod template. Default: true
        :param spread: Automatically spread pods across hostname and zones. Default: false
        :param min_ready: Minimum duration for which a newly created pod should be ready without any of its container crashing, for it to be considered available. Zero means the pod will be considered available as soon as it is ready. Default: Duration.seconds(0)
        :param progress_deadline: The maximum duration for a deployment to make progress before it is considered to be failed. The deployment controller will continue to process failed deployments and a condition with a ProgressDeadlineExceeded reason will be surfaced in the deployment status. Note that progress will not be estimated during the time a deployment is paused. Default: Duration.seconds(600)
        :param replicas: Number of desired pods. Default: 2
        :param strategy: Specifies the strategy used to replace old Pods by new ones. Default: - RollingUpdate with maxSurge and maxUnavailable set to 25%.
        '''
        if isinstance(metadata, dict):
            metadata = _cdk8s_d3d9af27.ApiObjectMetadata(**metadata)
        if isinstance(dns, dict):
            dns = PodDnsProps(**dns)
        if isinstance(security_context, dict):
            security_context = PodSecurityContextProps(**security_context)
        if isinstance(pod_metadata, dict):
            pod_metadata = _cdk8s_d3d9af27.ApiObjectMetadata(**pod_metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__83ea870321903f72cdbe51f8b005cbbaf901f1a4b608d473f6ff9723a48a83cc)
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument automount_service_account_token", value=automount_service_account_token, expected_type=type_hints["automount_service_account_token"])
            check_type(argname="argument containers", value=containers, expected_type=type_hints["containers"])
            check_type(argname="argument dns", value=dns, expected_type=type_hints["dns"])
            check_type(argname="argument docker_registry_auth", value=docker_registry_auth, expected_type=type_hints["docker_registry_auth"])
            check_type(argname="argument host_aliases", value=host_aliases, expected_type=type_hints["host_aliases"])
            check_type(argname="argument host_network", value=host_network, expected_type=type_hints["host_network"])
            check_type(argname="argument init_containers", value=init_containers, expected_type=type_hints["init_containers"])
            check_type(argname="argument isolate", value=isolate, expected_type=type_hints["isolate"])
            check_type(argname="argument restart_policy", value=restart_policy, expected_type=type_hints["restart_policy"])
            check_type(argname="argument security_context", value=security_context, expected_type=type_hints["security_context"])
            check_type(argname="argument service_account", value=service_account, expected_type=type_hints["service_account"])
            check_type(argname="argument termination_grace_period", value=termination_grace_period, expected_type=type_hints["termination_grace_period"])
            check_type(argname="argument volumes", value=volumes, expected_type=type_hints["volumes"])
            check_type(argname="argument pod_metadata", value=pod_metadata, expected_type=type_hints["pod_metadata"])
            check_type(argname="argument select", value=select, expected_type=type_hints["select"])
            check_type(argname="argument spread", value=spread, expected_type=type_hints["spread"])
            check_type(argname="argument min_ready", value=min_ready, expected_type=type_hints["min_ready"])
            check_type(argname="argument progress_deadline", value=progress_deadline, expected_type=type_hints["progress_deadline"])
            check_type(argname="argument replicas", value=replicas, expected_type=type_hints["replicas"])
            check_type(argname="argument strategy", value=strategy, expected_type=type_hints["strategy"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if metadata is not None:
            self._values["metadata"] = metadata
        if automount_service_account_token is not None:
            self._values["automount_service_account_token"] = automount_service_account_token
        if containers is not None:
            self._values["containers"] = containers
        if dns is not None:
            self._values["dns"] = dns
        if docker_registry_auth is not None:
            self._values["docker_registry_auth"] = docker_registry_auth
        if host_aliases is not None:
            self._values["host_aliases"] = host_aliases
        if host_network is not None:
            self._values["host_network"] = host_network
        if init_containers is not None:
            self._values["init_containers"] = init_containers
        if isolate is not None:
            self._values["isolate"] = isolate
        if restart_policy is not None:
            self._values["restart_policy"] = restart_policy
        if security_context is not None:
            self._values["security_context"] = security_context
        if service_account is not None:
            self._values["service_account"] = service_account
        if termination_grace_period is not None:
            self._values["termination_grace_period"] = termination_grace_period
        if volumes is not None:
            self._values["volumes"] = volumes
        if pod_metadata is not None:
            self._values["pod_metadata"] = pod_metadata
        if select is not None:
            self._values["select"] = select
        if spread is not None:
            self._values["spread"] = spread
        if min_ready is not None:
            self._values["min_ready"] = min_ready
        if progress_deadline is not None:
            self._values["progress_deadline"] = progress_deadline
        if replicas is not None:
            self._values["replicas"] = replicas
        if strategy is not None:
            self._values["strategy"] = strategy

    @builtins.property
    def metadata(self) -> typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata]:
        '''Metadata that all persisted resources must have, which includes all objects users must create.'''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata], result)

    @builtins.property
    def automount_service_account_token(self) -> typing.Optional[builtins.bool]:
        '''Indicates whether a service account token should be automatically mounted.

        :default: false

        :see: https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/#use-the-default-service-account-to-access-the-api-server
        '''
        result = self._values.get("automount_service_account_token")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def containers(self) -> typing.Optional[typing.List[ContainerProps]]:
        '''List of containers belonging to the pod.

        Containers cannot currently be
        added or removed. There must be at least one container in a Pod.

        You can add additionnal containers using ``podSpec.addContainer()``

        :default: - No containers. Note that a pod spec must include at least one container.
        '''
        result = self._values.get("containers")
        return typing.cast(typing.Optional[typing.List[ContainerProps]], result)

    @builtins.property
    def dns(self) -> typing.Optional[PodDnsProps]:
        '''DNS settings for the pod.

        :default:

        policy: DnsPolicy.CLUSTER_FIRST
        hostnameAsFQDN: false

        :see: https://kubernetes.io/docs/concepts/services-networking/dns-pod-service/
        '''
        result = self._values.get("dns")
        return typing.cast(typing.Optional[PodDnsProps], result)

    @builtins.property
    def docker_registry_auth(self) -> typing.Optional[ISecret]:
        '''A secret containing docker credentials for authenticating to a registry.

        :default: - No auth. Images are assumed to be publicly available.
        '''
        result = self._values.get("docker_registry_auth")
        return typing.cast(typing.Optional[ISecret], result)

    @builtins.property
    def host_aliases(self) -> typing.Optional[typing.List[HostAlias]]:
        '''HostAlias holds the mapping between IP and hostnames that will be injected as an entry in the pod's hosts file.

        :schema: io.k8s.api.core.v1.HostAlias
        '''
        result = self._values.get("host_aliases")
        return typing.cast(typing.Optional[typing.List[HostAlias]], result)

    @builtins.property
    def host_network(self) -> typing.Optional[builtins.bool]:
        '''Host network for the pod.

        :default: false
        '''
        result = self._values.get("host_network")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def init_containers(self) -> typing.Optional[typing.List[ContainerProps]]:
        '''List of initialization containers belonging to the pod.

        Init containers are executed in order prior to containers being started.
        If any init container fails, the pod is considered to have failed and is handled according to its restartPolicy.
        The name for an init container or normal container must be unique among all containers.
        Init containers may not have Lifecycle actions, Readiness probes, Liveness probes, or Startup probes.
        The resourceRequirements of an init container are taken into account during scheduling by finding the highest request/limit
        for each resource type, and then using the max of of that value or the sum of the normal containers.
        Limits are applied to init containers in a similar fashion.

        Init containers cannot currently be added ,removed or updated.

        :default: - No init containers.

        :see: https://kubernetes.io/docs/concepts/workloads/pods/init-containers/
        '''
        result = self._values.get("init_containers")
        return typing.cast(typing.Optional[typing.List[ContainerProps]], result)

    @builtins.property
    def isolate(self) -> typing.Optional[builtins.bool]:
        '''Isolates the pod.

        This will prevent any ingress or egress connections to / from this pod.
        You can however allow explicit connections post instantiation by using the ``.connections`` property.

        :default: false
        '''
        result = self._values.get("isolate")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def restart_policy(self) -> typing.Optional[RestartPolicy]:
        '''Restart policy for all containers within the pod.

        :default: RestartPolicy.ALWAYS

        :see: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle/#restart-policy
        '''
        result = self._values.get("restart_policy")
        return typing.cast(typing.Optional[RestartPolicy], result)

    @builtins.property
    def security_context(self) -> typing.Optional[PodSecurityContextProps]:
        '''SecurityContext holds pod-level security attributes and common container settings.

        :default:

        fsGroupChangePolicy: FsGroupChangePolicy.FsGroupChangePolicy.ALWAYS
        ensureNonRoot: true
        '''
        result = self._values.get("security_context")
        return typing.cast(typing.Optional[PodSecurityContextProps], result)

    @builtins.property
    def service_account(self) -> typing.Optional[IServiceAccount]:
        '''A service account provides an identity for processes that run in a Pod.

        When you (a human) access the cluster (for example, using kubectl), you are
        authenticated by the apiserver as a particular User Account (currently this
        is usually admin, unless your cluster administrator has customized your
        cluster). Processes in containers inside pods can also contact the
        apiserver. When they do, they are authenticated as a particular Service
        Account (for example, default).

        :default: - No service account.

        :see: https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/
        '''
        result = self._values.get("service_account")
        return typing.cast(typing.Optional[IServiceAccount], result)

    @builtins.property
    def termination_grace_period(self) -> typing.Optional[_cdk8s_d3d9af27.Duration]:
        '''Grace period until the pod is terminated.

        :default: Duration.seconds(30)
        '''
        result = self._values.get("termination_grace_period")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Duration], result)

    @builtins.property
    def volumes(self) -> typing.Optional[typing.List[Volume]]:
        '''List of volumes that can be mounted by containers belonging to the pod.

        You can also add volumes later using ``podSpec.addVolume()``

        :default: - No volumes.

        :see: https://kubernetes.io/docs/concepts/storage/volumes
        '''
        result = self._values.get("volumes")
        return typing.cast(typing.Optional[typing.List[Volume]], result)

    @builtins.property
    def pod_metadata(self) -> typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata]:
        '''The pod metadata of this workload.'''
        result = self._values.get("pod_metadata")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata], result)

    @builtins.property
    def select(self) -> typing.Optional[builtins.bool]:
        '''Automatically allocates a pod label selector for this workload and add it to the pod metadata.

        This ensures this workload manages pods created by
        its pod template.

        :default: true
        '''
        result = self._values.get("select")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def spread(self) -> typing.Optional[builtins.bool]:
        '''Automatically spread pods across hostname and zones.

        :default: false

        :see: https://kubernetes.io/docs/concepts/scheduling-eviction/topology-spread-constraints/#internal-default-constraints
        '''
        result = self._values.get("spread")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def min_ready(self) -> typing.Optional[_cdk8s_d3d9af27.Duration]:
        '''Minimum duration for which a newly created pod should be ready without any of its container crashing, for it to be considered available.

        Zero means the pod will be considered available as soon as it is ready.

        :default: Duration.seconds(0)

        :see: https://kubernetes.io/docs/concepts/workloads/controllers/deployment/#min-ready-seconds
        '''
        result = self._values.get("min_ready")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Duration], result)

    @builtins.property
    def progress_deadline(self) -> typing.Optional[_cdk8s_d3d9af27.Duration]:
        '''The maximum duration for a deployment to make progress before it is considered to be failed.

        The deployment controller will continue
        to process failed deployments and a condition with a ProgressDeadlineExceeded
        reason will be surfaced in the deployment status.

        Note that progress will not be estimated during the time a deployment is paused.

        :default: Duration.seconds(600)

        :see: https://kubernetes.io/docs/concepts/workloads/controllers/deployment/#progress-deadline-seconds
        '''
        result = self._values.get("progress_deadline")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Duration], result)

    @builtins.property
    def replicas(self) -> typing.Optional[jsii.Number]:
        '''Number of desired pods.

        :default: 2
        '''
        result = self._values.get("replicas")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def strategy(self) -> typing.Optional[DeploymentStrategy]:
        '''Specifies the strategy used to replace old Pods by new ones.

        :default: - RollingUpdate with maxSurge and maxUnavailable set to 25%.
        '''
        result = self._values.get("strategy")
        return typing.cast(typing.Optional[DeploymentStrategy], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DeploymentProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class GCEPersistentDiskPersistentVolume(
    PersistentVolume,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-24.GCEPersistentDiskPersistentVolume",
):
    '''GCEPersistentDisk represents a GCE Disk resource that is attached to a kubelet's host machine and then exposed to the pod.

    Provisioned by an admin.

    :see: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        pd_name: builtins.str,
        fs_type: typing.Optional[builtins.str] = None,
        partition: typing.Optional[jsii.Number] = None,
        read_only: typing.Optional[builtins.bool] = None,
        access_modes: typing.Optional[typing.Sequence[PersistentVolumeAccessMode]] = None,
        claim: typing.Optional[IPersistentVolumeClaim] = None,
        mount_options: typing.Optional[typing.Sequence[builtins.str]] = None,
        reclaim_policy: typing.Optional[PersistentVolumeReclaimPolicy] = None,
        storage: typing.Optional[_cdk8s_d3d9af27.Size] = None,
        storage_class_name: typing.Optional[builtins.str] = None,
        volume_mode: typing.Optional[PersistentVolumeMode] = None,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param pd_name: Unique name of the PD resource in GCE. Used to identify the disk in GCE.
        :param fs_type: Filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Default: 'ext4'
        :param partition: The partition in the volume that you want to mount. If omitted, the default is to mount by volume name. Examples: For volume /dev/sda1, you specify the partition as "1". Similarly, the volume partition for /dev/sda is "0" (or you can leave the property empty). Default: - No partition.
        :param read_only: Specify "true" to force and set the ReadOnly property in VolumeMounts to "true". Default: false
        :param access_modes: Contains all ways the volume can be mounted. Default: - No access modes.
        :param claim: Part of a bi-directional binding between PersistentVolume and PersistentVolumeClaim. Expected to be non-nil when bound. Default: - Not bound to a specific claim.
        :param mount_options: A list of mount options, e.g. ["ro", "soft"]. Not validated - mount will simply fail if one is invalid. Default: - No options.
        :param reclaim_policy: When a user is done with their volume, they can delete the PVC objects from the API that allows reclamation of the resource. The reclaim policy tells the cluster what to do with the volume after it has been released of its claim. Default: PersistentVolumeReclaimPolicy.RETAIN
        :param storage: What is the storage capacity of this volume. Default: - No specified.
        :param storage_class_name: Name of StorageClass to which this persistent volume belongs. Default: - Volume does not belong to any storage class.
        :param volume_mode: Defines what type of volume is required by the claim. Default: VolumeMode.FILE_SYSTEM
        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__641a1c1af9dc2bc5573b57fe11d8173e6909a20d082b5c8a183b4278c116f2ee)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = GCEPersistentDiskPersistentVolumeProps(
            pd_name=pd_name,
            fs_type=fs_type,
            partition=partition,
            read_only=read_only,
            access_modes=access_modes,
            claim=claim,
            mount_options=mount_options,
            reclaim_policy=reclaim_policy,
            storage=storage,
            storage_class_name=storage_class_name,
            volume_mode=volume_mode,
            metadata=metadata,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @builtins.property
    @jsii.member(jsii_name="fsType")
    def fs_type(self) -> builtins.str:
        '''File system type of this volume.'''
        return typing.cast(builtins.str, jsii.get(self, "fsType"))

    @builtins.property
    @jsii.member(jsii_name="pdName")
    def pd_name(self) -> builtins.str:
        '''PD resource in GCE of this volume.'''
        return typing.cast(builtins.str, jsii.get(self, "pdName"))

    @builtins.property
    @jsii.member(jsii_name="readOnly")
    def read_only(self) -> builtins.bool:
        '''Whether or not it is mounted as a read-only volume.'''
        return typing.cast(builtins.bool, jsii.get(self, "readOnly"))

    @builtins.property
    @jsii.member(jsii_name="partition")
    def partition(self) -> typing.Optional[jsii.Number]:
        '''Partition of this volume.'''
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "partition"))


@jsii.data_type(
    jsii_type="cdk8s-plus-24.GCEPersistentDiskPersistentVolumeProps",
    jsii_struct_bases=[PersistentVolumeProps],
    name_mapping={
        "metadata": "metadata",
        "access_modes": "accessModes",
        "claim": "claim",
        "mount_options": "mountOptions",
        "reclaim_policy": "reclaimPolicy",
        "storage": "storage",
        "storage_class_name": "storageClassName",
        "volume_mode": "volumeMode",
        "pd_name": "pdName",
        "fs_type": "fsType",
        "partition": "partition",
        "read_only": "readOnly",
    },
)
class GCEPersistentDiskPersistentVolumeProps(PersistentVolumeProps):
    def __init__(
        self,
        *,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        access_modes: typing.Optional[typing.Sequence[PersistentVolumeAccessMode]] = None,
        claim: typing.Optional[IPersistentVolumeClaim] = None,
        mount_options: typing.Optional[typing.Sequence[builtins.str]] = None,
        reclaim_policy: typing.Optional[PersistentVolumeReclaimPolicy] = None,
        storage: typing.Optional[_cdk8s_d3d9af27.Size] = None,
        storage_class_name: typing.Optional[builtins.str] = None,
        volume_mode: typing.Optional[PersistentVolumeMode] = None,
        pd_name: builtins.str,
        fs_type: typing.Optional[builtins.str] = None,
        partition: typing.Optional[jsii.Number] = None,
        read_only: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''Properties for ``GCEPersistentDiskPersistentVolume``.

        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        :param access_modes: Contains all ways the volume can be mounted. Default: - No access modes.
        :param claim: Part of a bi-directional binding between PersistentVolume and PersistentVolumeClaim. Expected to be non-nil when bound. Default: - Not bound to a specific claim.
        :param mount_options: A list of mount options, e.g. ["ro", "soft"]. Not validated - mount will simply fail if one is invalid. Default: - No options.
        :param reclaim_policy: When a user is done with their volume, they can delete the PVC objects from the API that allows reclamation of the resource. The reclaim policy tells the cluster what to do with the volume after it has been released of its claim. Default: PersistentVolumeReclaimPolicy.RETAIN
        :param storage: What is the storage capacity of this volume. Default: - No specified.
        :param storage_class_name: Name of StorageClass to which this persistent volume belongs. Default: - Volume does not belong to any storage class.
        :param volume_mode: Defines what type of volume is required by the claim. Default: VolumeMode.FILE_SYSTEM
        :param pd_name: Unique name of the PD resource in GCE. Used to identify the disk in GCE.
        :param fs_type: Filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Default: 'ext4'
        :param partition: The partition in the volume that you want to mount. If omitted, the default is to mount by volume name. Examples: For volume /dev/sda1, you specify the partition as "1". Similarly, the volume partition for /dev/sda is "0" (or you can leave the property empty). Default: - No partition.
        :param read_only: Specify "true" to force and set the ReadOnly property in VolumeMounts to "true". Default: false
        '''
        if isinstance(metadata, dict):
            metadata = _cdk8s_d3d9af27.ApiObjectMetadata(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__00dd2749efc93a0a347ce25be9d4417707f2ad131d20b4feabc4db58221de6cc)
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument access_modes", value=access_modes, expected_type=type_hints["access_modes"])
            check_type(argname="argument claim", value=claim, expected_type=type_hints["claim"])
            check_type(argname="argument mount_options", value=mount_options, expected_type=type_hints["mount_options"])
            check_type(argname="argument reclaim_policy", value=reclaim_policy, expected_type=type_hints["reclaim_policy"])
            check_type(argname="argument storage", value=storage, expected_type=type_hints["storage"])
            check_type(argname="argument storage_class_name", value=storage_class_name, expected_type=type_hints["storage_class_name"])
            check_type(argname="argument volume_mode", value=volume_mode, expected_type=type_hints["volume_mode"])
            check_type(argname="argument pd_name", value=pd_name, expected_type=type_hints["pd_name"])
            check_type(argname="argument fs_type", value=fs_type, expected_type=type_hints["fs_type"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
            check_type(argname="argument read_only", value=read_only, expected_type=type_hints["read_only"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "pd_name": pd_name,
        }
        if metadata is not None:
            self._values["metadata"] = metadata
        if access_modes is not None:
            self._values["access_modes"] = access_modes
        if claim is not None:
            self._values["claim"] = claim
        if mount_options is not None:
            self._values["mount_options"] = mount_options
        if reclaim_policy is not None:
            self._values["reclaim_policy"] = reclaim_policy
        if storage is not None:
            self._values["storage"] = storage
        if storage_class_name is not None:
            self._values["storage_class_name"] = storage_class_name
        if volume_mode is not None:
            self._values["volume_mode"] = volume_mode
        if fs_type is not None:
            self._values["fs_type"] = fs_type
        if partition is not None:
            self._values["partition"] = partition
        if read_only is not None:
            self._values["read_only"] = read_only

    @builtins.property
    def metadata(self) -> typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata]:
        '''Metadata that all persisted resources must have, which includes all objects users must create.'''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata], result)

    @builtins.property
    def access_modes(self) -> typing.Optional[typing.List[PersistentVolumeAccessMode]]:
        '''Contains all ways the volume can be mounted.

        :default: - No access modes.

        :see: https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes
        '''
        result = self._values.get("access_modes")
        return typing.cast(typing.Optional[typing.List[PersistentVolumeAccessMode]], result)

    @builtins.property
    def claim(self) -> typing.Optional[IPersistentVolumeClaim]:
        '''Part of a bi-directional binding between PersistentVolume and PersistentVolumeClaim.

        Expected to be non-nil when bound.

        :default: - Not bound to a specific claim.

        :see: https://kubernetes.io/docs/concepts/storage/persistent-volumes#binding
        '''
        result = self._values.get("claim")
        return typing.cast(typing.Optional[IPersistentVolumeClaim], result)

    @builtins.property
    def mount_options(self) -> typing.Optional[typing.List[builtins.str]]:
        '''A list of mount options, e.g. ["ro", "soft"]. Not validated - mount will simply fail if one is invalid.

        :default: - No options.

        :see: https://kubernetes.io/docs/concepts/storage/persistent-volumes/#mount-options
        '''
        result = self._values.get("mount_options")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def reclaim_policy(self) -> typing.Optional[PersistentVolumeReclaimPolicy]:
        '''When a user is done with their volume, they can delete the PVC objects from the API that allows reclamation of the resource.

        The reclaim policy tells the cluster what to do with
        the volume after it has been released of its claim.

        :default: PersistentVolumeReclaimPolicy.RETAIN

        :see: https://kubernetes.io/docs/concepts/storage/persistent-volumes#reclaiming
        '''
        result = self._values.get("reclaim_policy")
        return typing.cast(typing.Optional[PersistentVolumeReclaimPolicy], result)

    @builtins.property
    def storage(self) -> typing.Optional[_cdk8s_d3d9af27.Size]:
        '''What is the storage capacity of this volume.

        :default: - No specified.

        :see: https://kubernetes.io/docs/concepts/storage/persistent-volumes#resources
        '''
        result = self._values.get("storage")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Size], result)

    @builtins.property
    def storage_class_name(self) -> typing.Optional[builtins.str]:
        '''Name of StorageClass to which this persistent volume belongs.

        :default: - Volume does not belong to any storage class.
        '''
        result = self._values.get("storage_class_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def volume_mode(self) -> typing.Optional[PersistentVolumeMode]:
        '''Defines what type of volume is required by the claim.

        :default: VolumeMode.FILE_SYSTEM
        '''
        result = self._values.get("volume_mode")
        return typing.cast(typing.Optional[PersistentVolumeMode], result)

    @builtins.property
    def pd_name(self) -> builtins.str:
        '''Unique name of the PD resource in GCE.

        Used to identify the disk in GCE.

        :see: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk
        '''
        result = self._values.get("pd_name")
        assert result is not None, "Required property 'pd_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def fs_type(self) -> typing.Optional[builtins.str]:
        '''Filesystem type of the volume that you want to mount.

        Tip: Ensure that the filesystem type is supported by the host operating system.

        :default: 'ext4'

        :see: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
        '''
        result = self._values.get("fs_type")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def partition(self) -> typing.Optional[jsii.Number]:
        '''The partition in the volume that you want to mount.

        If omitted, the default is to mount by volume name.
        Examples: For volume /dev/sda1, you specify the partition as "1".
        Similarly, the volume partition for /dev/sda is "0" (or you can leave the property empty).

        :default: - No partition.
        '''
        result = self._values.get("partition")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def read_only(self) -> typing.Optional[builtins.bool]:
        '''Specify "true" to force and set the ReadOnly property in VolumeMounts to "true".

        :default: false

        :see: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
        '''
        result = self._values.get("read_only")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "GCEPersistentDiskPersistentVolumeProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class Job(Workload, metaclass=jsii.JSIIMeta, jsii_type="cdk8s-plus-24.Job"):
    '''A Job creates one or more Pods and ensures that a specified number of them successfully terminate.

    As pods successfully complete,
    the Job tracks the successful completions. When a specified number of successful completions is reached, the task (ie, Job) is complete.
    Deleting a Job will clean up the Pods it created. A simple case is to create one Job object in order to reliably run one Pod to completion.
    The Job object will start a new Pod if the first Pod fails or is deleted (for example due to a node hardware failure or a node reboot).
    You can also use a Job to run multiple Pods in parallel.
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        active_deadline: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        backoff_limit: typing.Optional[jsii.Number] = None,
        ttl_after_finished: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        pod_metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        select: typing.Optional[builtins.bool] = None,
        spread: typing.Optional[builtins.bool] = None,
        automount_service_account_token: typing.Optional[builtins.bool] = None,
        containers: typing.Optional[typing.Sequence[typing.Union[ContainerProps, typing.Dict[builtins.str, typing.Any]]]] = None,
        dns: typing.Optional[typing.Union[PodDnsProps, typing.Dict[builtins.str, typing.Any]]] = None,
        docker_registry_auth: typing.Optional[ISecret] = None,
        host_aliases: typing.Optional[typing.Sequence[typing.Union[HostAlias, typing.Dict[builtins.str, typing.Any]]]] = None,
        host_network: typing.Optional[builtins.bool] = None,
        init_containers: typing.Optional[typing.Sequence[typing.Union[ContainerProps, typing.Dict[builtins.str, typing.Any]]]] = None,
        isolate: typing.Optional[builtins.bool] = None,
        restart_policy: typing.Optional[RestartPolicy] = None,
        security_context: typing.Optional[typing.Union[PodSecurityContextProps, typing.Dict[builtins.str, typing.Any]]] = None,
        service_account: typing.Optional[IServiceAccount] = None,
        termination_grace_period: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        volumes: typing.Optional[typing.Sequence[Volume]] = None,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param active_deadline: Specifies the duration the job may be active before the system tries to terminate it. Default: - If unset, then there is no deadline.
        :param backoff_limit: Specifies the number of retries before marking this job failed. Default: - If not set, system defaults to 6.
        :param ttl_after_finished: Limits the lifetime of a Job that has finished execution (either Complete or Failed). If this field is set, after the Job finishes, it is eligible to be automatically deleted. When the Job is being deleted, its lifecycle guarantees (e.g. finalizers) will be honored. If this field is set to zero, the Job becomes eligible to be deleted immediately after it finishes. This field is alpha-level and is only honored by servers that enable the ``TTLAfterFinished`` feature. Default: - If this field is unset, the Job won't be automatically deleted.
        :param pod_metadata: The pod metadata of this workload.
        :param select: Automatically allocates a pod label selector for this workload and add it to the pod metadata. This ensures this workload manages pods created by its pod template. Default: true
        :param spread: Automatically spread pods across hostname and zones. Default: false
        :param automount_service_account_token: Indicates whether a service account token should be automatically mounted. Default: false
        :param containers: List of containers belonging to the pod. Containers cannot currently be added or removed. There must be at least one container in a Pod. You can add additionnal containers using ``podSpec.addContainer()`` Default: - No containers. Note that a pod spec must include at least one container.
        :param dns: DNS settings for the pod. Default: policy: DnsPolicy.CLUSTER_FIRST hostnameAsFQDN: false
        :param docker_registry_auth: A secret containing docker credentials for authenticating to a registry. Default: - No auth. Images are assumed to be publicly available.
        :param host_aliases: HostAlias holds the mapping between IP and hostnames that will be injected as an entry in the pod's hosts file.
        :param host_network: Host network for the pod. Default: false
        :param init_containers: List of initialization containers belonging to the pod. Init containers are executed in order prior to containers being started. If any init container fails, the pod is considered to have failed and is handled according to its restartPolicy. The name for an init container or normal container must be unique among all containers. Init containers may not have Lifecycle actions, Readiness probes, Liveness probes, or Startup probes. The resourceRequirements of an init container are taken into account during scheduling by finding the highest request/limit for each resource type, and then using the max of of that value or the sum of the normal containers. Limits are applied to init containers in a similar fashion. Init containers cannot currently be added ,removed or updated. Default: - No init containers.
        :param isolate: Isolates the pod. This will prevent any ingress or egress connections to / from this pod. You can however allow explicit connections post instantiation by using the ``.connections`` property. Default: false
        :param restart_policy: Restart policy for all containers within the pod. Default: RestartPolicy.ALWAYS
        :param security_context: SecurityContext holds pod-level security attributes and common container settings. Default: fsGroupChangePolicy: FsGroupChangePolicy.FsGroupChangePolicy.ALWAYS ensureNonRoot: true
        :param service_account: A service account provides an identity for processes that run in a Pod. When you (a human) access the cluster (for example, using kubectl), you are authenticated by the apiserver as a particular User Account (currently this is usually admin, unless your cluster administrator has customized your cluster). Processes in containers inside pods can also contact the apiserver. When they do, they are authenticated as a particular Service Account (for example, default). Default: - No service account.
        :param termination_grace_period: Grace period until the pod is terminated. Default: Duration.seconds(30)
        :param volumes: List of volumes that can be mounted by containers belonging to the pod. You can also add volumes later using ``podSpec.addVolume()`` Default: - No volumes.
        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__388588ec26974e9894f49cd0fe00e1056a3ad6154693fde6539f1663c084cf63)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = JobProps(
            active_deadline=active_deadline,
            backoff_limit=backoff_limit,
            ttl_after_finished=ttl_after_finished,
            pod_metadata=pod_metadata,
            select=select,
            spread=spread,
            automount_service_account_token=automount_service_account_token,
            containers=containers,
            dns=dns,
            docker_registry_auth=docker_registry_auth,
            host_aliases=host_aliases,
            host_network=host_network,
            init_containers=init_containers,
            isolate=isolate,
            restart_policy=restart_policy,
            security_context=security_context,
            service_account=service_account,
            termination_grace_period=termination_grace_period,
            volumes=volumes,
            metadata=metadata,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @builtins.property
    @jsii.member(jsii_name="apiObject")
    def _api_object(self) -> _cdk8s_d3d9af27.ApiObject:
        '''The underlying cdk8s API object.

        :see: base.Resource.apiObject
        '''
        return typing.cast(_cdk8s_d3d9af27.ApiObject, jsii.get(self, "apiObject"))

    @builtins.property
    @jsii.member(jsii_name="resourceType")
    def resource_type(self) -> builtins.str:
        '''The name of a resource type as it appears in the relevant API endpoint.'''
        return typing.cast(builtins.str, jsii.get(self, "resourceType"))

    @builtins.property
    @jsii.member(jsii_name="activeDeadline")
    def active_deadline(self) -> typing.Optional[_cdk8s_d3d9af27.Duration]:
        '''Duration before job is terminated.

        If undefined, there is no deadline.
        '''
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Duration], jsii.get(self, "activeDeadline"))

    @builtins.property
    @jsii.member(jsii_name="backoffLimit")
    def backoff_limit(self) -> typing.Optional[jsii.Number]:
        '''Number of retries before marking failed.'''
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "backoffLimit"))

    @builtins.property
    @jsii.member(jsii_name="ttlAfterFinished")
    def ttl_after_finished(self) -> typing.Optional[_cdk8s_d3d9af27.Duration]:
        '''TTL before the job is deleted after it is finished.'''
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Duration], jsii.get(self, "ttlAfterFinished"))


@jsii.data_type(
    jsii_type="cdk8s-plus-24.JobProps",
    jsii_struct_bases=[WorkloadProps],
    name_mapping={
        "metadata": "metadata",
        "automount_service_account_token": "automountServiceAccountToken",
        "containers": "containers",
        "dns": "dns",
        "docker_registry_auth": "dockerRegistryAuth",
        "host_aliases": "hostAliases",
        "host_network": "hostNetwork",
        "init_containers": "initContainers",
        "isolate": "isolate",
        "restart_policy": "restartPolicy",
        "security_context": "securityContext",
        "service_account": "serviceAccount",
        "termination_grace_period": "terminationGracePeriod",
        "volumes": "volumes",
        "pod_metadata": "podMetadata",
        "select": "select",
        "spread": "spread",
        "active_deadline": "activeDeadline",
        "backoff_limit": "backoffLimit",
        "ttl_after_finished": "ttlAfterFinished",
    },
)
class JobProps(WorkloadProps):
    def __init__(
        self,
        *,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        automount_service_account_token: typing.Optional[builtins.bool] = None,
        containers: typing.Optional[typing.Sequence[typing.Union[ContainerProps, typing.Dict[builtins.str, typing.Any]]]] = None,
        dns: typing.Optional[typing.Union[PodDnsProps, typing.Dict[builtins.str, typing.Any]]] = None,
        docker_registry_auth: typing.Optional[ISecret] = None,
        host_aliases: typing.Optional[typing.Sequence[typing.Union[HostAlias, typing.Dict[builtins.str, typing.Any]]]] = None,
        host_network: typing.Optional[builtins.bool] = None,
        init_containers: typing.Optional[typing.Sequence[typing.Union[ContainerProps, typing.Dict[builtins.str, typing.Any]]]] = None,
        isolate: typing.Optional[builtins.bool] = None,
        restart_policy: typing.Optional[RestartPolicy] = None,
        security_context: typing.Optional[typing.Union[PodSecurityContextProps, typing.Dict[builtins.str, typing.Any]]] = None,
        service_account: typing.Optional[IServiceAccount] = None,
        termination_grace_period: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        volumes: typing.Optional[typing.Sequence[Volume]] = None,
        pod_metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        select: typing.Optional[builtins.bool] = None,
        spread: typing.Optional[builtins.bool] = None,
        active_deadline: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        backoff_limit: typing.Optional[jsii.Number] = None,
        ttl_after_finished: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
    ) -> None:
        '''Properties for ``Job``.

        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        :param automount_service_account_token: Indicates whether a service account token should be automatically mounted. Default: false
        :param containers: List of containers belonging to the pod. Containers cannot currently be added or removed. There must be at least one container in a Pod. You can add additionnal containers using ``podSpec.addContainer()`` Default: - No containers. Note that a pod spec must include at least one container.
        :param dns: DNS settings for the pod. Default: policy: DnsPolicy.CLUSTER_FIRST hostnameAsFQDN: false
        :param docker_registry_auth: A secret containing docker credentials for authenticating to a registry. Default: - No auth. Images are assumed to be publicly available.
        :param host_aliases: HostAlias holds the mapping between IP and hostnames that will be injected as an entry in the pod's hosts file.
        :param host_network: Host network for the pod. Default: false
        :param init_containers: List of initialization containers belonging to the pod. Init containers are executed in order prior to containers being started. If any init container fails, the pod is considered to have failed and is handled according to its restartPolicy. The name for an init container or normal container must be unique among all containers. Init containers may not have Lifecycle actions, Readiness probes, Liveness probes, or Startup probes. The resourceRequirements of an init container are taken into account during scheduling by finding the highest request/limit for each resource type, and then using the max of of that value or the sum of the normal containers. Limits are applied to init containers in a similar fashion. Init containers cannot currently be added ,removed or updated. Default: - No init containers.
        :param isolate: Isolates the pod. This will prevent any ingress or egress connections to / from this pod. You can however allow explicit connections post instantiation by using the ``.connections`` property. Default: false
        :param restart_policy: Restart policy for all containers within the pod. Default: RestartPolicy.ALWAYS
        :param security_context: SecurityContext holds pod-level security attributes and common container settings. Default: fsGroupChangePolicy: FsGroupChangePolicy.FsGroupChangePolicy.ALWAYS ensureNonRoot: true
        :param service_account: A service account provides an identity for processes that run in a Pod. When you (a human) access the cluster (for example, using kubectl), you are authenticated by the apiserver as a particular User Account (currently this is usually admin, unless your cluster administrator has customized your cluster). Processes in containers inside pods can also contact the apiserver. When they do, they are authenticated as a particular Service Account (for example, default). Default: - No service account.
        :param termination_grace_period: Grace period until the pod is terminated. Default: Duration.seconds(30)
        :param volumes: List of volumes that can be mounted by containers belonging to the pod. You can also add volumes later using ``podSpec.addVolume()`` Default: - No volumes.
        :param pod_metadata: The pod metadata of this workload.
        :param select: Automatically allocates a pod label selector for this workload and add it to the pod metadata. This ensures this workload manages pods created by its pod template. Default: true
        :param spread: Automatically spread pods across hostname and zones. Default: false
        :param active_deadline: Specifies the duration the job may be active before the system tries to terminate it. Default: - If unset, then there is no deadline.
        :param backoff_limit: Specifies the number of retries before marking this job failed. Default: - If not set, system defaults to 6.
        :param ttl_after_finished: Limits the lifetime of a Job that has finished execution (either Complete or Failed). If this field is set, after the Job finishes, it is eligible to be automatically deleted. When the Job is being deleted, its lifecycle guarantees (e.g. finalizers) will be honored. If this field is set to zero, the Job becomes eligible to be deleted immediately after it finishes. This field is alpha-level and is only honored by servers that enable the ``TTLAfterFinished`` feature. Default: - If this field is unset, the Job won't be automatically deleted.
        '''
        if isinstance(metadata, dict):
            metadata = _cdk8s_d3d9af27.ApiObjectMetadata(**metadata)
        if isinstance(dns, dict):
            dns = PodDnsProps(**dns)
        if isinstance(security_context, dict):
            security_context = PodSecurityContextProps(**security_context)
        if isinstance(pod_metadata, dict):
            pod_metadata = _cdk8s_d3d9af27.ApiObjectMetadata(**pod_metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0855f91a9864f5e525466272fc38d82dde848590637b06b6903a72ffc64490ab)
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument automount_service_account_token", value=automount_service_account_token, expected_type=type_hints["automount_service_account_token"])
            check_type(argname="argument containers", value=containers, expected_type=type_hints["containers"])
            check_type(argname="argument dns", value=dns, expected_type=type_hints["dns"])
            check_type(argname="argument docker_registry_auth", value=docker_registry_auth, expected_type=type_hints["docker_registry_auth"])
            check_type(argname="argument host_aliases", value=host_aliases, expected_type=type_hints["host_aliases"])
            check_type(argname="argument host_network", value=host_network, expected_type=type_hints["host_network"])
            check_type(argname="argument init_containers", value=init_containers, expected_type=type_hints["init_containers"])
            check_type(argname="argument isolate", value=isolate, expected_type=type_hints["isolate"])
            check_type(argname="argument restart_policy", value=restart_policy, expected_type=type_hints["restart_policy"])
            check_type(argname="argument security_context", value=security_context, expected_type=type_hints["security_context"])
            check_type(argname="argument service_account", value=service_account, expected_type=type_hints["service_account"])
            check_type(argname="argument termination_grace_period", value=termination_grace_period, expected_type=type_hints["termination_grace_period"])
            check_type(argname="argument volumes", value=volumes, expected_type=type_hints["volumes"])
            check_type(argname="argument pod_metadata", value=pod_metadata, expected_type=type_hints["pod_metadata"])
            check_type(argname="argument select", value=select, expected_type=type_hints["select"])
            check_type(argname="argument spread", value=spread, expected_type=type_hints["spread"])
            check_type(argname="argument active_deadline", value=active_deadline, expected_type=type_hints["active_deadline"])
            check_type(argname="argument backoff_limit", value=backoff_limit, expected_type=type_hints["backoff_limit"])
            check_type(argname="argument ttl_after_finished", value=ttl_after_finished, expected_type=type_hints["ttl_after_finished"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if metadata is not None:
            self._values["metadata"] = metadata
        if automount_service_account_token is not None:
            self._values["automount_service_account_token"] = automount_service_account_token
        if containers is not None:
            self._values["containers"] = containers
        if dns is not None:
            self._values["dns"] = dns
        if docker_registry_auth is not None:
            self._values["docker_registry_auth"] = docker_registry_auth
        if host_aliases is not None:
            self._values["host_aliases"] = host_aliases
        if host_network is not None:
            self._values["host_network"] = host_network
        if init_containers is not None:
            self._values["init_containers"] = init_containers
        if isolate is not None:
            self._values["isolate"] = isolate
        if restart_policy is not None:
            self._values["restart_policy"] = restart_policy
        if security_context is not None:
            self._values["security_context"] = security_context
        if service_account is not None:
            self._values["service_account"] = service_account
        if termination_grace_period is not None:
            self._values["termination_grace_period"] = termination_grace_period
        if volumes is not None:
            self._values["volumes"] = volumes
        if pod_metadata is not None:
            self._values["pod_metadata"] = pod_metadata
        if select is not None:
            self._values["select"] = select
        if spread is not None:
            self._values["spread"] = spread
        if active_deadline is not None:
            self._values["active_deadline"] = active_deadline
        if backoff_limit is not None:
            self._values["backoff_limit"] = backoff_limit
        if ttl_after_finished is not None:
            self._values["ttl_after_finished"] = ttl_after_finished

    @builtins.property
    def metadata(self) -> typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata]:
        '''Metadata that all persisted resources must have, which includes all objects users must create.'''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata], result)

    @builtins.property
    def automount_service_account_token(self) -> typing.Optional[builtins.bool]:
        '''Indicates whether a service account token should be automatically mounted.

        :default: false

        :see: https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/#use-the-default-service-account-to-access-the-api-server
        '''
        result = self._values.get("automount_service_account_token")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def containers(self) -> typing.Optional[typing.List[ContainerProps]]:
        '''List of containers belonging to the pod.

        Containers cannot currently be
        added or removed. There must be at least one container in a Pod.

        You can add additionnal containers using ``podSpec.addContainer()``

        :default: - No containers. Note that a pod spec must include at least one container.
        '''
        result = self._values.get("containers")
        return typing.cast(typing.Optional[typing.List[ContainerProps]], result)

    @builtins.property
    def dns(self) -> typing.Optional[PodDnsProps]:
        '''DNS settings for the pod.

        :default:

        policy: DnsPolicy.CLUSTER_FIRST
        hostnameAsFQDN: false

        :see: https://kubernetes.io/docs/concepts/services-networking/dns-pod-service/
        '''
        result = self._values.get("dns")
        return typing.cast(typing.Optional[PodDnsProps], result)

    @builtins.property
    def docker_registry_auth(self) -> typing.Optional[ISecret]:
        '''A secret containing docker credentials for authenticating to a registry.

        :default: - No auth. Images are assumed to be publicly available.
        '''
        result = self._values.get("docker_registry_auth")
        return typing.cast(typing.Optional[ISecret], result)

    @builtins.property
    def host_aliases(self) -> typing.Optional[typing.List[HostAlias]]:
        '''HostAlias holds the mapping between IP and hostnames that will be injected as an entry in the pod's hosts file.

        :schema: io.k8s.api.core.v1.HostAlias
        '''
        result = self._values.get("host_aliases")
        return typing.cast(typing.Optional[typing.List[HostAlias]], result)

    @builtins.property
    def host_network(self) -> typing.Optional[builtins.bool]:
        '''Host network for the pod.

        :default: false
        '''
        result = self._values.get("host_network")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def init_containers(self) -> typing.Optional[typing.List[ContainerProps]]:
        '''List of initialization containers belonging to the pod.

        Init containers are executed in order prior to containers being started.
        If any init container fails, the pod is considered to have failed and is handled according to its restartPolicy.
        The name for an init container or normal container must be unique among all containers.
        Init containers may not have Lifecycle actions, Readiness probes, Liveness probes, or Startup probes.
        The resourceRequirements of an init container are taken into account during scheduling by finding the highest request/limit
        for each resource type, and then using the max of of that value or the sum of the normal containers.
        Limits are applied to init containers in a similar fashion.

        Init containers cannot currently be added ,removed or updated.

        :default: - No init containers.

        :see: https://kubernetes.io/docs/concepts/workloads/pods/init-containers/
        '''
        result = self._values.get("init_containers")
        return typing.cast(typing.Optional[typing.List[ContainerProps]], result)

    @builtins.property
    def isolate(self) -> typing.Optional[builtins.bool]:
        '''Isolates the pod.

        This will prevent any ingress or egress connections to / from this pod.
        You can however allow explicit connections post instantiation by using the ``.connections`` property.

        :default: false
        '''
        result = self._values.get("isolate")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def restart_policy(self) -> typing.Optional[RestartPolicy]:
        '''Restart policy for all containers within the pod.

        :default: RestartPolicy.ALWAYS

        :see: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle/#restart-policy
        '''
        result = self._values.get("restart_policy")
        return typing.cast(typing.Optional[RestartPolicy], result)

    @builtins.property
    def security_context(self) -> typing.Optional[PodSecurityContextProps]:
        '''SecurityContext holds pod-level security attributes and common container settings.

        :default:

        fsGroupChangePolicy: FsGroupChangePolicy.FsGroupChangePolicy.ALWAYS
        ensureNonRoot: true
        '''
        result = self._values.get("security_context")
        return typing.cast(typing.Optional[PodSecurityContextProps], result)

    @builtins.property
    def service_account(self) -> typing.Optional[IServiceAccount]:
        '''A service account provides an identity for processes that run in a Pod.

        When you (a human) access the cluster (for example, using kubectl), you are
        authenticated by the apiserver as a particular User Account (currently this
        is usually admin, unless your cluster administrator has customized your
        cluster). Processes in containers inside pods can also contact the
        apiserver. When they do, they are authenticated as a particular Service
        Account (for example, default).

        :default: - No service account.

        :see: https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/
        '''
        result = self._values.get("service_account")
        return typing.cast(typing.Optional[IServiceAccount], result)

    @builtins.property
    def termination_grace_period(self) -> typing.Optional[_cdk8s_d3d9af27.Duration]:
        '''Grace period until the pod is terminated.

        :default: Duration.seconds(30)
        '''
        result = self._values.get("termination_grace_period")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Duration], result)

    @builtins.property
    def volumes(self) -> typing.Optional[typing.List[Volume]]:
        '''List of volumes that can be mounted by containers belonging to the pod.

        You can also add volumes later using ``podSpec.addVolume()``

        :default: - No volumes.

        :see: https://kubernetes.io/docs/concepts/storage/volumes
        '''
        result = self._values.get("volumes")
        return typing.cast(typing.Optional[typing.List[Volume]], result)

    @builtins.property
    def pod_metadata(self) -> typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata]:
        '''The pod metadata of this workload.'''
        result = self._values.get("pod_metadata")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata], result)

    @builtins.property
    def select(self) -> typing.Optional[builtins.bool]:
        '''Automatically allocates a pod label selector for this workload and add it to the pod metadata.

        This ensures this workload manages pods created by
        its pod template.

        :default: true
        '''
        result = self._values.get("select")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def spread(self) -> typing.Optional[builtins.bool]:
        '''Automatically spread pods across hostname and zones.

        :default: false

        :see: https://kubernetes.io/docs/concepts/scheduling-eviction/topology-spread-constraints/#internal-default-constraints
        '''
        result = self._values.get("spread")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def active_deadline(self) -> typing.Optional[_cdk8s_d3d9af27.Duration]:
        '''Specifies the duration the job may be active before the system tries to terminate it.

        :default: - If unset, then there is no deadline.
        '''
        result = self._values.get("active_deadline")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Duration], result)

    @builtins.property
    def backoff_limit(self) -> typing.Optional[jsii.Number]:
        '''Specifies the number of retries before marking this job failed.

        :default: - If not set, system defaults to 6.
        '''
        result = self._values.get("backoff_limit")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def ttl_after_finished(self) -> typing.Optional[_cdk8s_d3d9af27.Duration]:
        '''Limits the lifetime of a Job that has finished execution (either Complete or Failed).

        If this field is set, after the Job finishes, it is eligible to
        be automatically deleted. When the Job is being deleted, its lifecycle
        guarantees (e.g. finalizers) will be honored. If this field is set to zero,
        the Job becomes eligible to be deleted immediately after it finishes. This
        field is alpha-level and is only honored by servers that enable the
        ``TTLAfterFinished`` feature.

        :default: - If this field is unset, the Job won't be automatically deleted.
        '''
        result = self._values.get("ttl_after_finished")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Duration], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "JobProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(IScalable)
class StatefulSet(
    Workload,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-24.StatefulSet",
):
    '''StatefulSet is the workload API object used to manage stateful applications.

    Manages the deployment and scaling of a set of Pods, and provides guarantees
    about the ordering and uniqueness of these Pods.

    Like a Deployment, a StatefulSet manages Pods that are based on an identical
    container spec. Unlike a Deployment, a StatefulSet maintains a sticky identity
    for each of their Pods. These pods are created from the same spec, but are not
    interchangeable: each has a persistent identifier that it maintains across any
    rescheduling.

    If you want to use storage volumes to provide persistence for your workload, you
    can use a StatefulSet as part of the solution. Although individual Pods in a StatefulSet
    are susceptible to failure, the persistent Pod identifiers make it easier to match existing
    volumes to the new Pods that replace any that have failed.


    Using StatefulSets

    StatefulSets are valuable for applications that require one or more of the following.

    - Stable, unique network identifiers.
    - Stable, persistent storage.
    - Ordered, graceful deployment and scaling.
    - Ordered, automated rolling updates.
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        min_ready: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        pod_management_policy: typing.Optional[PodManagementPolicy] = None,
        replicas: typing.Optional[jsii.Number] = None,
        service: typing.Optional[Service] = None,
        strategy: typing.Optional[StatefulSetUpdateStrategy] = None,
        pod_metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        select: typing.Optional[builtins.bool] = None,
        spread: typing.Optional[builtins.bool] = None,
        automount_service_account_token: typing.Optional[builtins.bool] = None,
        containers: typing.Optional[typing.Sequence[typing.Union[ContainerProps, typing.Dict[builtins.str, typing.Any]]]] = None,
        dns: typing.Optional[typing.Union[PodDnsProps, typing.Dict[builtins.str, typing.Any]]] = None,
        docker_registry_auth: typing.Optional[ISecret] = None,
        host_aliases: typing.Optional[typing.Sequence[typing.Union[HostAlias, typing.Dict[builtins.str, typing.Any]]]] = None,
        host_network: typing.Optional[builtins.bool] = None,
        init_containers: typing.Optional[typing.Sequence[typing.Union[ContainerProps, typing.Dict[builtins.str, typing.Any]]]] = None,
        isolate: typing.Optional[builtins.bool] = None,
        restart_policy: typing.Optional[RestartPolicy] = None,
        security_context: typing.Optional[typing.Union[PodSecurityContextProps, typing.Dict[builtins.str, typing.Any]]] = None,
        service_account: typing.Optional[IServiceAccount] = None,
        termination_grace_period: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        volumes: typing.Optional[typing.Sequence[Volume]] = None,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param min_ready: Minimum duration for which a newly created pod should be ready without any of its container crashing, for it to be considered available. Zero means the pod will be considered available as soon as it is ready. This is an alpha field and requires enabling StatefulSetMinReadySeconds feature gate. Default: Duration.seconds(0)
        :param pod_management_policy: Pod management policy to use for this statefulset. Default: PodManagementPolicy.ORDERED_READY
        :param replicas: Number of desired pods. Default: 1
        :param service: Service to associate with the statefulset. Default: - A new headless service will be created.
        :param strategy: Indicates the StatefulSetUpdateStrategy that will be employed to update Pods in the StatefulSet when a revision is made to Template. Default: - RollingUpdate with partition set to 0
        :param pod_metadata: The pod metadata of this workload.
        :param select: Automatically allocates a pod label selector for this workload and add it to the pod metadata. This ensures this workload manages pods created by its pod template. Default: true
        :param spread: Automatically spread pods across hostname and zones. Default: false
        :param automount_service_account_token: Indicates whether a service account token should be automatically mounted. Default: false
        :param containers: List of containers belonging to the pod. Containers cannot currently be added or removed. There must be at least one container in a Pod. You can add additionnal containers using ``podSpec.addContainer()`` Default: - No containers. Note that a pod spec must include at least one container.
        :param dns: DNS settings for the pod. Default: policy: DnsPolicy.CLUSTER_FIRST hostnameAsFQDN: false
        :param docker_registry_auth: A secret containing docker credentials for authenticating to a registry. Default: - No auth. Images are assumed to be publicly available.
        :param host_aliases: HostAlias holds the mapping between IP and hostnames that will be injected as an entry in the pod's hosts file.
        :param host_network: Host network for the pod. Default: false
        :param init_containers: List of initialization containers belonging to the pod. Init containers are executed in order prior to containers being started. If any init container fails, the pod is considered to have failed and is handled according to its restartPolicy. The name for an init container or normal container must be unique among all containers. Init containers may not have Lifecycle actions, Readiness probes, Liveness probes, or Startup probes. The resourceRequirements of an init container are taken into account during scheduling by finding the highest request/limit for each resource type, and then using the max of of that value or the sum of the normal containers. Limits are applied to init containers in a similar fashion. Init containers cannot currently be added ,removed or updated. Default: - No init containers.
        :param isolate: Isolates the pod. This will prevent any ingress or egress connections to / from this pod. You can however allow explicit connections post instantiation by using the ``.connections`` property. Default: false
        :param restart_policy: Restart policy for all containers within the pod. Default: RestartPolicy.ALWAYS
        :param security_context: SecurityContext holds pod-level security attributes and common container settings. Default: fsGroupChangePolicy: FsGroupChangePolicy.FsGroupChangePolicy.ALWAYS ensureNonRoot: true
        :param service_account: A service account provides an identity for processes that run in a Pod. When you (a human) access the cluster (for example, using kubectl), you are authenticated by the apiserver as a particular User Account (currently this is usually admin, unless your cluster administrator has customized your cluster). Processes in containers inside pods can also contact the apiserver. When they do, they are authenticated as a particular Service Account (for example, default). Default: - No service account.
        :param termination_grace_period: Grace period until the pod is terminated. Default: Duration.seconds(30)
        :param volumes: List of volumes that can be mounted by containers belonging to the pod. You can also add volumes later using ``podSpec.addVolume()`` Default: - No volumes.
        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9712778ab6d0dc95e9ba1a8a8227d275af0891cad4c745c4c148e50952e7c5f3)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = StatefulSetProps(
            min_ready=min_ready,
            pod_management_policy=pod_management_policy,
            replicas=replicas,
            service=service,
            strategy=strategy,
            pod_metadata=pod_metadata,
            select=select,
            spread=spread,
            automount_service_account_token=automount_service_account_token,
            containers=containers,
            dns=dns,
            docker_registry_auth=docker_registry_auth,
            host_aliases=host_aliases,
            host_network=host_network,
            init_containers=init_containers,
            isolate=isolate,
            restart_policy=restart_policy,
            security_context=security_context,
            service_account=service_account,
            termination_grace_period=termination_grace_period,
            volumes=volumes,
            metadata=metadata,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="markHasAutoscaler")
    def mark_has_autoscaler(self) -> None:
        '''Called on all IScalable targets when they are associated with an autoscaler.

        :see: IScalable.markHasAutoscaler()
        '''
        return typing.cast(None, jsii.invoke(self, "markHasAutoscaler", []))

    @jsii.member(jsii_name="toScalingTarget")
    def to_scaling_target(self) -> ScalingTarget:
        '''Return the target spec properties of this Scalable.

        :see: IScalable.toScalingTarget()
        '''
        return typing.cast(ScalingTarget, jsii.invoke(self, "toScalingTarget", []))

    @builtins.property
    @jsii.member(jsii_name="apiObject")
    def _api_object(self) -> _cdk8s_d3d9af27.ApiObject:
        '''The underlying cdk8s API object.

        :see: base.Resource.apiObject
        '''
        return typing.cast(_cdk8s_d3d9af27.ApiObject, jsii.get(self, "apiObject"))

    @builtins.property
    @jsii.member(jsii_name="minReady")
    def min_ready(self) -> _cdk8s_d3d9af27.Duration:
        '''Minimum duration for which a newly created pod should be ready without any of its container crashing, for it to be considered available.'''
        return typing.cast(_cdk8s_d3d9af27.Duration, jsii.get(self, "minReady"))

    @builtins.property
    @jsii.member(jsii_name="podManagementPolicy")
    def pod_management_policy(self) -> PodManagementPolicy:
        '''Management policy to use for the set.'''
        return typing.cast(PodManagementPolicy, jsii.get(self, "podManagementPolicy"))

    @builtins.property
    @jsii.member(jsii_name="resourceType")
    def resource_type(self) -> builtins.str:
        '''The name of a resource type as it appears in the relevant API endpoint.'''
        return typing.cast(builtins.str, jsii.get(self, "resourceType"))

    @builtins.property
    @jsii.member(jsii_name="service")
    def service(self) -> Service:
        return typing.cast(Service, jsii.get(self, "service"))

    @builtins.property
    @jsii.member(jsii_name="strategy")
    def strategy(self) -> StatefulSetUpdateStrategy:
        '''The update startegy of this stateful set.'''
        return typing.cast(StatefulSetUpdateStrategy, jsii.get(self, "strategy"))

    @builtins.property
    @jsii.member(jsii_name="replicas")
    def replicas(self) -> typing.Optional[jsii.Number]:
        '''Number of desired pods.'''
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "replicas"))

    @builtins.property
    @jsii.member(jsii_name="hasAutoscaler")
    def has_autoscaler(self) -> builtins.bool:
        '''If this is a target of an autoscaler.'''
        return typing.cast(builtins.bool, jsii.get(self, "hasAutoscaler"))

    @has_autoscaler.setter
    def has_autoscaler(self, value: builtins.bool) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3028359caf57641b0908bbeefd0a632e0b2be61b67b387198ba98adcadc2501e)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "hasAutoscaler", value)


@jsii.data_type(
    jsii_type="cdk8s-plus-24.StatefulSetProps",
    jsii_struct_bases=[WorkloadProps],
    name_mapping={
        "metadata": "metadata",
        "automount_service_account_token": "automountServiceAccountToken",
        "containers": "containers",
        "dns": "dns",
        "docker_registry_auth": "dockerRegistryAuth",
        "host_aliases": "hostAliases",
        "host_network": "hostNetwork",
        "init_containers": "initContainers",
        "isolate": "isolate",
        "restart_policy": "restartPolicy",
        "security_context": "securityContext",
        "service_account": "serviceAccount",
        "termination_grace_period": "terminationGracePeriod",
        "volumes": "volumes",
        "pod_metadata": "podMetadata",
        "select": "select",
        "spread": "spread",
        "min_ready": "minReady",
        "pod_management_policy": "podManagementPolicy",
        "replicas": "replicas",
        "service": "service",
        "strategy": "strategy",
    },
)
class StatefulSetProps(WorkloadProps):
    def __init__(
        self,
        *,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        automount_service_account_token: typing.Optional[builtins.bool] = None,
        containers: typing.Optional[typing.Sequence[typing.Union[ContainerProps, typing.Dict[builtins.str, typing.Any]]]] = None,
        dns: typing.Optional[typing.Union[PodDnsProps, typing.Dict[builtins.str, typing.Any]]] = None,
        docker_registry_auth: typing.Optional[ISecret] = None,
        host_aliases: typing.Optional[typing.Sequence[typing.Union[HostAlias, typing.Dict[builtins.str, typing.Any]]]] = None,
        host_network: typing.Optional[builtins.bool] = None,
        init_containers: typing.Optional[typing.Sequence[typing.Union[ContainerProps, typing.Dict[builtins.str, typing.Any]]]] = None,
        isolate: typing.Optional[builtins.bool] = None,
        restart_policy: typing.Optional[RestartPolicy] = None,
        security_context: typing.Optional[typing.Union[PodSecurityContextProps, typing.Dict[builtins.str, typing.Any]]] = None,
        service_account: typing.Optional[IServiceAccount] = None,
        termination_grace_period: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        volumes: typing.Optional[typing.Sequence[Volume]] = None,
        pod_metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        select: typing.Optional[builtins.bool] = None,
        spread: typing.Optional[builtins.bool] = None,
        min_ready: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        pod_management_policy: typing.Optional[PodManagementPolicy] = None,
        replicas: typing.Optional[jsii.Number] = None,
        service: typing.Optional[Service] = None,
        strategy: typing.Optional[StatefulSetUpdateStrategy] = None,
    ) -> None:
        '''Properties for initialization of ``StatefulSet``.

        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        :param automount_service_account_token: Indicates whether a service account token should be automatically mounted. Default: false
        :param containers: List of containers belonging to the pod. Containers cannot currently be added or removed. There must be at least one container in a Pod. You can add additionnal containers using ``podSpec.addContainer()`` Default: - No containers. Note that a pod spec must include at least one container.
        :param dns: DNS settings for the pod. Default: policy: DnsPolicy.CLUSTER_FIRST hostnameAsFQDN: false
        :param docker_registry_auth: A secret containing docker credentials for authenticating to a registry. Default: - No auth. Images are assumed to be publicly available.
        :param host_aliases: HostAlias holds the mapping between IP and hostnames that will be injected as an entry in the pod's hosts file.
        :param host_network: Host network for the pod. Default: false
        :param init_containers: List of initialization containers belonging to the pod. Init containers are executed in order prior to containers being started. If any init container fails, the pod is considered to have failed and is handled according to its restartPolicy. The name for an init container or normal container must be unique among all containers. Init containers may not have Lifecycle actions, Readiness probes, Liveness probes, or Startup probes. The resourceRequirements of an init container are taken into account during scheduling by finding the highest request/limit for each resource type, and then using the max of of that value or the sum of the normal containers. Limits are applied to init containers in a similar fashion. Init containers cannot currently be added ,removed or updated. Default: - No init containers.
        :param isolate: Isolates the pod. This will prevent any ingress or egress connections to / from this pod. You can however allow explicit connections post instantiation by using the ``.connections`` property. Default: false
        :param restart_policy: Restart policy for all containers within the pod. Default: RestartPolicy.ALWAYS
        :param security_context: SecurityContext holds pod-level security attributes and common container settings. Default: fsGroupChangePolicy: FsGroupChangePolicy.FsGroupChangePolicy.ALWAYS ensureNonRoot: true
        :param service_account: A service account provides an identity for processes that run in a Pod. When you (a human) access the cluster (for example, using kubectl), you are authenticated by the apiserver as a particular User Account (currently this is usually admin, unless your cluster administrator has customized your cluster). Processes in containers inside pods can also contact the apiserver. When they do, they are authenticated as a particular Service Account (for example, default). Default: - No service account.
        :param termination_grace_period: Grace period until the pod is terminated. Default: Duration.seconds(30)
        :param volumes: List of volumes that can be mounted by containers belonging to the pod. You can also add volumes later using ``podSpec.addVolume()`` Default: - No volumes.
        :param pod_metadata: The pod metadata of this workload.
        :param select: Automatically allocates a pod label selector for this workload and add it to the pod metadata. This ensures this workload manages pods created by its pod template. Default: true
        :param spread: Automatically spread pods across hostname and zones. Default: false
        :param min_ready: Minimum duration for which a newly created pod should be ready without any of its container crashing, for it to be considered available. Zero means the pod will be considered available as soon as it is ready. This is an alpha field and requires enabling StatefulSetMinReadySeconds feature gate. Default: Duration.seconds(0)
        :param pod_management_policy: Pod management policy to use for this statefulset. Default: PodManagementPolicy.ORDERED_READY
        :param replicas: Number of desired pods. Default: 1
        :param service: Service to associate with the statefulset. Default: - A new headless service will be created.
        :param strategy: Indicates the StatefulSetUpdateStrategy that will be employed to update Pods in the StatefulSet when a revision is made to Template. Default: - RollingUpdate with partition set to 0
        '''
        if isinstance(metadata, dict):
            metadata = _cdk8s_d3d9af27.ApiObjectMetadata(**metadata)
        if isinstance(dns, dict):
            dns = PodDnsProps(**dns)
        if isinstance(security_context, dict):
            security_context = PodSecurityContextProps(**security_context)
        if isinstance(pod_metadata, dict):
            pod_metadata = _cdk8s_d3d9af27.ApiObjectMetadata(**pod_metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c993760bf2766b9fcb5f9dcf043a472617ef32a1c2fc15262d3af3b2fc305f61)
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument automount_service_account_token", value=automount_service_account_token, expected_type=type_hints["automount_service_account_token"])
            check_type(argname="argument containers", value=containers, expected_type=type_hints["containers"])
            check_type(argname="argument dns", value=dns, expected_type=type_hints["dns"])
            check_type(argname="argument docker_registry_auth", value=docker_registry_auth, expected_type=type_hints["docker_registry_auth"])
            check_type(argname="argument host_aliases", value=host_aliases, expected_type=type_hints["host_aliases"])
            check_type(argname="argument host_network", value=host_network, expected_type=type_hints["host_network"])
            check_type(argname="argument init_containers", value=init_containers, expected_type=type_hints["init_containers"])
            check_type(argname="argument isolate", value=isolate, expected_type=type_hints["isolate"])
            check_type(argname="argument restart_policy", value=restart_policy, expected_type=type_hints["restart_policy"])
            check_type(argname="argument security_context", value=security_context, expected_type=type_hints["security_context"])
            check_type(argname="argument service_account", value=service_account, expected_type=type_hints["service_account"])
            check_type(argname="argument termination_grace_period", value=termination_grace_period, expected_type=type_hints["termination_grace_period"])
            check_type(argname="argument volumes", value=volumes, expected_type=type_hints["volumes"])
            check_type(argname="argument pod_metadata", value=pod_metadata, expected_type=type_hints["pod_metadata"])
            check_type(argname="argument select", value=select, expected_type=type_hints["select"])
            check_type(argname="argument spread", value=spread, expected_type=type_hints["spread"])
            check_type(argname="argument min_ready", value=min_ready, expected_type=type_hints["min_ready"])
            check_type(argname="argument pod_management_policy", value=pod_management_policy, expected_type=type_hints["pod_management_policy"])
            check_type(argname="argument replicas", value=replicas, expected_type=type_hints["replicas"])
            check_type(argname="argument service", value=service, expected_type=type_hints["service"])
            check_type(argname="argument strategy", value=strategy, expected_type=type_hints["strategy"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if metadata is not None:
            self._values["metadata"] = metadata
        if automount_service_account_token is not None:
            self._values["automount_service_account_token"] = automount_service_account_token
        if containers is not None:
            self._values["containers"] = containers
        if dns is not None:
            self._values["dns"] = dns
        if docker_registry_auth is not None:
            self._values["docker_registry_auth"] = docker_registry_auth
        if host_aliases is not None:
            self._values["host_aliases"] = host_aliases
        if host_network is not None:
            self._values["host_network"] = host_network
        if init_containers is not None:
            self._values["init_containers"] = init_containers
        if isolate is not None:
            self._values["isolate"] = isolate
        if restart_policy is not None:
            self._values["restart_policy"] = restart_policy
        if security_context is not None:
            self._values["security_context"] = security_context
        if service_account is not None:
            self._values["service_account"] = service_account
        if termination_grace_period is not None:
            self._values["termination_grace_period"] = termination_grace_period
        if volumes is not None:
            self._values["volumes"] = volumes
        if pod_metadata is not None:
            self._values["pod_metadata"] = pod_metadata
        if select is not None:
            self._values["select"] = select
        if spread is not None:
            self._values["spread"] = spread
        if min_ready is not None:
            self._values["min_ready"] = min_ready
        if pod_management_policy is not None:
            self._values["pod_management_policy"] = pod_management_policy
        if replicas is not None:
            self._values["replicas"] = replicas
        if service is not None:
            self._values["service"] = service
        if strategy is not None:
            self._values["strategy"] = strategy

    @builtins.property
    def metadata(self) -> typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata]:
        '''Metadata that all persisted resources must have, which includes all objects users must create.'''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata], result)

    @builtins.property
    def automount_service_account_token(self) -> typing.Optional[builtins.bool]:
        '''Indicates whether a service account token should be automatically mounted.

        :default: false

        :see: https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/#use-the-default-service-account-to-access-the-api-server
        '''
        result = self._values.get("automount_service_account_token")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def containers(self) -> typing.Optional[typing.List[ContainerProps]]:
        '''List of containers belonging to the pod.

        Containers cannot currently be
        added or removed. There must be at least one container in a Pod.

        You can add additionnal containers using ``podSpec.addContainer()``

        :default: - No containers. Note that a pod spec must include at least one container.
        '''
        result = self._values.get("containers")
        return typing.cast(typing.Optional[typing.List[ContainerProps]], result)

    @builtins.property
    def dns(self) -> typing.Optional[PodDnsProps]:
        '''DNS settings for the pod.

        :default:

        policy: DnsPolicy.CLUSTER_FIRST
        hostnameAsFQDN: false

        :see: https://kubernetes.io/docs/concepts/services-networking/dns-pod-service/
        '''
        result = self._values.get("dns")
        return typing.cast(typing.Optional[PodDnsProps], result)

    @builtins.property
    def docker_registry_auth(self) -> typing.Optional[ISecret]:
        '''A secret containing docker credentials for authenticating to a registry.

        :default: - No auth. Images are assumed to be publicly available.
        '''
        result = self._values.get("docker_registry_auth")
        return typing.cast(typing.Optional[ISecret], result)

    @builtins.property
    def host_aliases(self) -> typing.Optional[typing.List[HostAlias]]:
        '''HostAlias holds the mapping between IP and hostnames that will be injected as an entry in the pod's hosts file.

        :schema: io.k8s.api.core.v1.HostAlias
        '''
        result = self._values.get("host_aliases")
        return typing.cast(typing.Optional[typing.List[HostAlias]], result)

    @builtins.property
    def host_network(self) -> typing.Optional[builtins.bool]:
        '''Host network for the pod.

        :default: false
        '''
        result = self._values.get("host_network")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def init_containers(self) -> typing.Optional[typing.List[ContainerProps]]:
        '''List of initialization containers belonging to the pod.

        Init containers a