"""WCG - Watch Commits for Git.

Automated GitHub commit summarization with LLM integration.
"""

__version__ = "0.3.0"

from .config import Config, ConfigManager, LLMConfig, RepositoryConfig
from .github_client import GitHubClient, CommitInfo
from .summarizer import CommitSummarizer
from .notifier import WebhookNotifier
from .storage import SummaryStorage
from .scheduler import CommitWatcher, setup_logging

__all__ = [
    'Config',
    'ConfigManager',
    'LLMConfig',
    'RepositoryConfig',
    'GitHubClient',
    'CommitInfo',
    'CommitSummarizer',
    'WebhookNotifier',
    'SummaryStorage',
    'CommitWatcher',
    'setup_logging',
]
