# UNIT 6, LESSON 9

## The Distributive Property, Part 1

###### Grade 6

### 9.1 Warm-up 5 mins

# Math Talk: Ways to Multiply

#### Standards Alignment

##### Building On 
##### Building Toward

### Instructional Routines

- MLR 8: Discussion Supports
- Math Talk

### Materials

- None

### Activity Narrative

This Math Talk focuses on multiplication of multi-digit numbers. It encourages students to think about decomposition of numbers by place value to rely on what they know about properties of operations to mentally solve problems. The strategies elicited here will be helpful in upcoming activities and lessons as students build on their informal understanding of the distributive property to generate and justify equivalent expressions.

Students must be precise in their word choice and use of language when describing how they may decompose numbers, how they multiply, and the sums or differences they create to find the product (MP6).

### Launch

Tell students to close their books or devices (or to keep them closed). Reveal one problem at a time. For each problem:

- Give students quiet think time, and ask them to give a signal when they have an answer and a strategy.
- Invite students to share their strategies, and record and display their responses for all to see.
- Use the questions in the Activity Synthesis to involve more students in the conversation before moving to the next problem.
### Student Task Statement

Find the value of each product mentally:

- 5 x 102
- 5 x 98
- 5 x 999
- 5 x 0.999

### Student Response


### Activity Synthesis

To involve more students in the conversation, consider asking:

- “Who can restate __'s reasoning in a different way?”
- “Did anyone use the same strategy but would explain it differently?”
- “Did anyone solve the problem in a different way?”
- “Does anyone want to add on to __'s strategy?”
- “Do you agree or disagree? Why?”
- “What connections to previous problems do you see?”

Once students have had a chance to share a few different ways of reasoning about each product, focus on explanations using the distributive property and record the steps of reasoning for all to see. For example, when students find 5 x 98 by thinking of 98 as 100 - 2, record:

5 x 98

5 x (100 - 2)

5 x 100 - 5 x 2

500 - 10

490

Explain to students that the strategies that involve decomposing one factor as a sum or difference of numbers and then multiplying each part by the other factor demonstrate the distributive property of multiplication. In the shown example, we are “distributing” the multiplication of 5 to the 100 and the 2. Applying the distributive property allows us to write an expression that is equivalent to a given expression but is easier to calculate. Let students know that they will spend the next few lessons deepening their understanding of this property.

### 9.2 Activity 10 mins

# Ways to Represent Area of a Rectangle

#### Standards Alignment

##### Building On 
##### Building Toward

### Materials

- None

### Activity Narrative

The purpose of this activity is to remind students of the rectangular diagrams they worked with in a previous unit to represent multiplication. Students use the structure of the diagram to make sense of equivalent expressions and revisit their understanding of the distributive property. They are also introduced to the convention that multiplication happens before addition or subtraction. For example, the expression 6 * (3 + 2) equals 30, because we first multiply and then add the 6. If we want the sum to be carried out before the product, we need to use parentheses like 6 * (3 + 2).

### Launch

Give students 3–4 minutes of quiet think time, followed by a whole-class discussion.

##### MLR 8 Discussion Supports

- Display sentence frames to support students when they explain their strategy. For example, “First, I __ because ...” or “I noticed __ so I ...”. Some students may benefit from the opportunity to rehearse what they will say with a partner before they share with the whole class.

##### Advances:
- Speaking, Representing
- Supports accessibility for: Language, Memory, Conceptual Processing

### Student Task Statement


### Student Response


### Activity Synthesis

Invite students to share the expressions that they believe represent the area of each rectangle and ask them to explain their reasoning.

Students may incorrectly conclude that 6 * 3 + 2 represents the area of the large outer rectangle in Figure A. This is a good opportunity to introduce a convention. Explain that when we have multiplication and addition in the same expression, it is the convention that the multiplication is done first. So, 6 * 3 + 2 equals 20. This means that the expression 6 * 3 + 2 doesn’t represent the area of the whole rectangle, which we know to be 30 square units.

Tell students that if we want the addition to be done first, we need to use parentheses in the expression. Display 6 * (3 + 2) and show that it equals 30. Therefore, 6 * (3 + 2) represents the area of the large rectangle.

Applying the distributive property of multiplication, we can write 6 * (3 + 2) as 6 * 3 + 6 * 2 and know that they are equivalent. By using the rectangle, we can see that 6 * (3 + 2) represents the same area as 6 * 3 + 6 * 2, so the two expressions have the same value.

Show students that 6 * (3 + 2) can also be written as 6(3 + 2). Explain that just like a number next to a variable means multiplication, a number next to parentheses means multiplication. In other words, just like 6x means 6 * x, the expression 6(3 + 2) means 6 * (3 + 2).

Consider adding “distributive property” and equations that illustrate the property to the display started in a previous lesson.

### 9.3 Activity 20 mins

# Distributive Practice

#### Standards Alignment

##### Building Toward

### Instructional Routines

- MLR 2: Collect and Display

### Materials

- None
### Activity Narrative

In this activity, students practice using the distributive property to create equivalent numerical expressions. Students need to look for and make use of the structure of the expressions and the structure of the table to create equivalent sums or differences when starting with a product, and equivalent products when starting with a sum or difference (MP7).

The expressions were chosen to also elicit familiar strategies for multiplying numbers, such as by decomposing one or more factors by place value or by benchmark fractions.

Students must also reason in the other direction—write a given addition or subtraction expression as a sum or difference of two products. By the time they arrive at the expressions in the last two rows, students may have noticed that the two numbers in column 4 are results of multiplication of two pairs of numbers that share a common factor. Recognition of this structure allows students to look for a common factor for 100 and 70, and for 40 and 6.

Note that there is more than one way to rewrite the expression in the last two rows because each pair of numbers shares several common factors, but the resulting expressions are equivalent. In a subsequent unit, students will explicitly study the idea of a greatest common factor.

### Launch

Give students 1–2 minutes to read the table and then invite them to share some observations and any questions that come to mind. Students may notice that the expressions in the first row represent a strategy for finding the product in the Warm-up. Remind them that all the expressions in that row are equivalent.

If no students noticed that all expressions in each column have the same structure, draw their attention to this idea. Ask students to describe the structure that they see in each column.

Tell students that they are to complete each row in a table with expressions that are equivalent to the given expression, and to apply the distributive property (or another property) as needed.

Arrange students in groups of 2. Give students 6–8 minutes of quiet work time and then a few minutes to share their responses with their partner, followed by a whole-class discussion.

##### Collect and Display

- This activity uses the Collect and Display math language routine to advance conversing and reading as students clarify, build on, or make connections to mathematical language.
- Access for English Learners
- Use Collect and Display to direct attention to words collected and displayed from an earlier lesson. Invite students to borrow language from the display as needed, and update it throughout the lesson. Useful words and phrases to highlight for this activity include "equivalent," "sum," "difference," "product," and "factor."
- Supports accessibility for: Organization, Attention

### Student Task Statement

Complete the table. If you get stuck, consider skipping an entry and coming back to it, or drawing a diagram of two rectangles that share a side.

| Column 1  | Column 2      | Column 3              | Column 4        | Value |
|-----------|----------------|-----------------------|------------------|-------|
| 5 x 98    | 5(100 - 2)    | 5 x 100 - 5 x 2       | 500 - 10         | 490   |
| 33 x 12   | 33(10 + 2)    |                       |                  |       |
|           |                | 3 x 10 - 3 x 4       | 30 - 12          |       |
|           | 100(0.4 + 0.06) |                       |                  |       |
|           |                | 8/2 + 8/4            |                  |       |
|           |                |                       | 100 + 70         |       |
|           |                |                       | 40 - 16          |       |

### Student Response


### Building on Student Thinking

Students might understand how to write a given product of a number and a sum, such as in column 2, as a sum of two products, such as in column 3, but they might be unsure how to reason in reverse and write an expression such as in column 3 as a product of a number and difference. Likewise, they might move from column 3 to column 4 with ease but be unsure how to reason the other way around.

Ask students to observe how the expressions in column 2 and column 3 (or column 3 and column 4) are alike and how they are different. As needed, invite them to refer to the rectangular diagrams they have seen, draw a diagram of a partitioned rectangle to represent the expressions in column 3 and column 4 for one of their completed rows, and make connections between the expressions and the diagram. Then urge them to draw another rectangle to represent the expressions in those columns for the row they are working on.

##### Are You Ready for More?

### Activity Synthesis

Invite students to share the strategies and reasoning they used to complete the table. Include students who took advantage of the structure of the expressions in each column and those who used diagrams of partitioned rectangles. To help make students’ reasoning explicit, discuss questions such as:

- “How did you use the expression in column 3 to write an expression for column 4 (or column 2)?”
- “How did you use the expression in column 4 to write an expression in column 3? How did you figure out what numbers to use?”
- “Did you notice any pattern in your reasoning as you move from column to column, or as you write equivalent expressions?”

### Lesson Synthesis

The purpose of this discussion is to help students use their informal understanding of the distributive property to make sense of the more formal definition and notation for the distributive property.

Remind students that when multiplying two factors, we often think of one of the factors as being composed of two or more numbers, either by addition or subtraction. For example, in the Warm-up, we thought of 102 as 100 + 2 and 98 as 100 - 2 to make it easier to find 5 x 102 and 5 x 98.

Explain that the distributive property is a statement or rule that describes something about multiplication that students have observed and used for some time.

It says that we can multiply a factor and an addition (or a subtraction) expression by “distributing” the multiplication to each number in the expression, and then adding (or subtracting) the products. Doing this will not change the result of the original multiplication.

Display 33 x 12 for all to see and discuss this example:

To compute 33 x 12, we can think of the 12 as the sum of 10 and 2 and write: 

33 x (10 + 2)

Then we can “distribute” the multiplication of 33 to 10 and 2 by writing: 

33 x 10 + 33 x 2.

These two expressions, 33 x (10 + 2) and 33 x 10 + 33 x 2, are equivalent.

By the distributive property, we can also rewrite an expression like 4 x 7 - 4 x 2 as 4 x (7 - 2), because we know that the subtraction expression 4 x 7 - 4 x 2 is a result of multiplying 4 and each number in 7 - 2, so the two expressions are equivalent.

Tell students that they will continue to explore the distributive property of multiplication in upcoming lessons.

### Lesson Summary

When we need to do mental calculations, we often come up with ways to make the calculation easier to do mentally.

Suppose we are grocery shopping and need to know how much it will cost to buy 5 cans of beans at 79 cents a can. We may calculate mentally in this way:

5 x 79

5 x (70 + 9)

5 x 70 + 5 x 9

350 + 45

395

When we think, “79 is the same as 70 + 9. I can just multiply 5 x 70 and 5 x 9 and add the products together” we are using the distributive property.

In general, when we multiply two factors, we can break up one of the factors into parts, multiply each part by the other factor, and then add the products. The result will be the same as the product of the two original factors. When we break up one of the factors and multiply the parts we are using the distributive property of multiplication.

The distributive property also works with subtraction. Here is another way to find 5 x 79:

5 x 79

5 x (80 - 1)

5 x 80 - 5 x 1

400 - 5

395