# mypy-boto3-ecr

[![PyPI - mypy-boto3-ecr](https://img.shields.io/pypi/v/mypy-boto3-ecr.svg?color=blue)](https://pypi.org/project/mypy-boto3-ecr)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-ecr.svg?color=blue)](https://pypi.org/project/mypy-boto3-ecr)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.ECR 1.16.58](https://boto3.amazonaws.com/v1/documentation/api/1.16.58/reference/services/ecr.html#ECR) service
compatible with
[VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright)
and other tools.

Generated by [mypy-boto3-buider 4.3.1](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-ecr](#mypy-boto3-ecr)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Waiters annotations](#waiters-annotations)
    - [Service Resource annotations](#service-resource-annotations)
    - [Other resources annotations](#other-resources-annotations)
    - [Collections annotations](#collections-annotations)
    - [Typed dictionations](#typed-dictionations)

## How to install

Install `boto3-stubs` for `ECR` service.

```bash
python -m pip install boto3-stubs[ecr]
```

## Usage

### VSCode

- Install [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[ecr]` in your environment: `python -m pip install 'boto3-stubs[ecr]'`

Both type checking and auto-complete should work for `ECR` service.
No explicit type annotations required, write your `boto3` code as usual.

### PyCharm

- Install `boto-stubs[ecr]` in your environment: `python -m pip install 'boto3-stubs[ecr]'`

Both type checking and auto-complete should work for `ECR` service.
No explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed `boto3-stubs` submodules.

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything should work.

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[ecr]` in your environment: `python -m pip install 'boto3-stubs[ecr]'`
- Run `mypy` as usual

Type checking should work for `ECR` service.
No explicit type annotations required, write your `boto3` code as usual.

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[ecr]` in your environment: `python -m pip install 'boto3-stubs[ecr]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `ECR` service.
No explicit type annotations required, write your `boto3` code as usual.

## Explicit type annotations

### Client annotations

`ECRClient` provides annotations for `boto3.client("ecr")`.

```python
import boto3

from mypy_boto3_ecr import ECRClient

client: ECRClient = boto3.client("ecr")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: ECRClient = session.client("ecr")
```

### Paginators annotations

`mypy_boto3_ecr.paginator` module contains type annotations for all paginators.

```python
from mypy_boto3_ecr import ECRClient
from mypy_boto3_ecr.paginator import (
    DescribeImageScanFindingsPaginator,
    DescribeImagesPaginator,
    DescribeRepositoriesPaginator,
    GetLifecyclePolicyPreviewPaginator,
    ListImagesPaginator,
)

client: ECRClient = boto3.client("ecr")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
describe_image_scan_findings_paginator: DescribeImageScanFindingsPaginator = client.get_paginator("describe_image_scan_findings")
describe_images_paginator: DescribeImagesPaginator = client.get_paginator("describe_images")
describe_repositories_paginator: DescribeRepositoriesPaginator = client.get_paginator("describe_repositories")
get_lifecycle_policy_preview_paginator: GetLifecyclePolicyPreviewPaginator = client.get_paginator("get_lifecycle_policy_preview")
list_images_paginator: ListImagesPaginator = client.get_paginator("list_images")
```


### Waiters annotations

`mypy_boto3_ecr.waiter` module contains type annotations for all waiters.

```python
from mypy_boto3_ecr import ECRClient
from mypy_boto3_ecr.waiter import ImageScanCompleteWaiter, LifecyclePolicyPreviewCompleteWaiter

client: ECRClient = boto3.client("ecr")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
image_scan_complete_waiter: ImageScanCompleteWaiter = client.get_waiter("image_scan_complete")
lifecycle_policy_preview_complete_waiter: LifecyclePolicyPreviewCompleteWaiter = client.get_waiter("lifecycle_policy_preview_complete")
```





### Typed dictionations

`mypy_boto3_ecr.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_ecr.type_defs import (
    AttributeTypeDef,
    AuthorizationDataTypeDef,
    BatchCheckLayerAvailabilityResponseTypeDef,
    BatchDeleteImageResponseTypeDef,
    BatchGetImageResponseTypeDef,
    CompleteLayerUploadResponseTypeDef,
    CreateRepositoryResponseTypeDef,
    DeleteLifecyclePolicyResponseTypeDef,
    DeleteRegistryPolicyResponseTypeDef,
    DeleteRepositoryPolicyResponseTypeDef,
    DeleteRepositoryResponseTypeDef,
    DescribeImageScanFindingsResponseTypeDef,
    DescribeImagesFilterTypeDef,
    DescribeImagesResponseTypeDef,
    DescribeRegistryResponseTypeDef,
    DescribeRepositoriesResponseTypeDef,
    EncryptionConfigurationTypeDef,
    GetAuthorizationTokenResponseTypeDef,
    GetDownloadUrlForLayerResponseTypeDef,
    GetLifecyclePolicyPreviewResponseTypeDef,
    GetLifecyclePolicyResponseTypeDef,
    GetRegistryPolicyResponseTypeDef,
    GetRepositoryPolicyResponseTypeDef,
    ImageDetailTypeDef,
    ImageFailureTypeDef,
    ImageIdentifierTypeDef,
    ImageScanFindingsSummaryTypeDef,
    ImageScanFindingsTypeDef,
    ImageScanFindingTypeDef,
    ImageScanningConfigurationTypeDef,
    ImageScanStatusTypeDef,
    ImageTypeDef,
    InitiateLayerUploadResponseTypeDef,
    LayerFailureTypeDef,
    LayerTypeDef,
    LifecyclePolicyPreviewFilterTypeDef,
    LifecyclePolicyPreviewResultTypeDef,
    LifecyclePolicyPreviewSummaryTypeDef,
    LifecyclePolicyRuleActionTypeDef,
    ListImagesFilterTypeDef,
    ListImagesResponseTypeDef,
    ListTagsForResourceResponseTypeDef,
    PaginatorConfigTypeDef,
    PutImageResponseTypeDef,
    PutImageScanningConfigurationResponseTypeDef,
    PutImageTagMutabilityResponseTypeDef,
    PutLifecyclePolicyResponseTypeDef,
    PutRegistryPolicyResponseTypeDef,
    PutReplicationConfigurationResponseTypeDef,
    ReplicationConfigurationTypeDef,
    ReplicationDestinationTypeDef,
    ReplicationRuleTypeDef,
    RepositoryTypeDef,
    SetRepositoryPolicyResponseTypeDef,
    StartImageScanResponseTypeDef,
    StartLifecyclePolicyPreviewResponseTypeDef,
    TagTypeDef,
    UploadLayerPartResponseTypeDef,
    WaiterConfigTypeDef,
)

def get_structure() -> AttributeTypeDef:
    return {
      ...
    }
```
