import argparse
import sys

from vcs2l.commands.command import Command, simple_main
from vcs2l.streams import set_streams


class DiffCommand(Command):
    command = 'diff'
    help = 'Show changes in the working tree'

    def __init__(self, args):
        super(DiffCommand, self).__init__(args)
        self.context = args.context


def get_parser():
    parser = argparse.ArgumentParser(
        description='Show changes in the working tree', prog='vcs diff'
    )
    group = parser.add_argument_group('"diff" command parameters')
    group.add_argument(
        '--context',
        metavar='N',
        type=int,
        help='Generate diffs with <n> lines of context',
    )
    return parser


def main(args=None, stdout=None, stderr=None):
    set_streams(stdout=stdout, stderr=stderr)
    parser = get_parser()
    return simple_main(parser, DiffCommand, args)


if __name__ == '__main__':
    sys.exit(main())
