# Famous Coach Questions and Expert Frameworks

## Introduction

This document compiles powerful questioning frameworks from renowned coaches, thought leaders, and productivity experts. These questions represent tested approaches from practitioners with extensive real-world application and documented success across diverse populations, optimized for voice journaling implementation.

## See also

- `../reference/OPENING_QUESTIONS.md` - Implementation of default openers and embedded example questions
- `../reference/DIALOGUE_FLOW.md` - Question progression strategies in conversational sessions
- `DAILY_REFLECTION_QUESTIONS.md` - Daily practice frameworks and present moment awareness
- `ANNUAL_QUARTERLY_REVIEW_QUESTIONS.md` - Long-term reflection and planning questions
- `COACHING_FRAMEWORKS_EVIDENCE.md` - Research evidence on coaching questions and effectiveness studies
- `VALUES_SELF_DISCOVERY_QUESTIONS.md` - Identity exploration and values clarification questions
- `STRUCTURED_REFLECTION_VS_RUMINATION.md` - Research on productive vs. unproductive questioning patterns

## Tim Ferriss Question Frameworks

### The 17 Questions That Changed My Life

Tim Ferriss's collection of life-changing questions, derived from extensive experimentation and documented results:

**Fear and Risk Assessment**:
- "What are the worst things that could happen if you pursue this?"
- "What would it look like if you only worked 2 hours per week on this?"
- "What would you do if you couldn't pitch your product directly?"
- "What if you did the opposite for 48 hours?"

**Resource and Constraint Questions**:
- "What would you do if you had 10 times more resources? What if you had 10 times fewer?"
- "What would this look like if it were easy?"
- "How can you use constraints to your advantage?"

**Perspective and Priority Questions**:
- "What would you do if you knew you couldn't fail?"
- "What would you attempt if you knew no one would judge you for it?"
- "If you could only work 2 hours per week on your business, what would you do?"
- "What advice would you give to your 20-year-old self?"

**Implementation and Testing**:
- "What experiment could you run this week to test this assumption?"
- "What would need to be true for this to work?"
- "How might we make this measurable?"

### Tim Ferriss Fear-Setting Framework

**Step 1: Define (What are you afraid of?)**:
- "What are the worst-case scenarios if you take this action?"
- "What would the temporary impacts be?"
- "What would the permanent impacts be?"
- "How likely is each outcome on a scale of 1-10?"

**Step 2: Prevent (How can you minimize risk?)**:
- "What steps could you take to prevent or minimize each outcome?"
- "What skills could you learn to reduce the probability?"
- "Who could you talk to for advice or help?"

**Step 3: Repair (How can you recover?)**:
- "If the worst-case scenario happened, how could you recover?"
- "Who could help you get back on track?"
- "What resources would you need to bounce back?"
- "How have others recovered from similar setbacks?"

**Voice Journaling Implementation**: Use as a complete 15-20 minute framework for major decision-making sessions.

## Tony Robbins Question Frameworks

### Problem-Solving Framework

Tony Robbins' systematic approach to reframing challenges:

1. "What is great about this problem?"
2. "What is not perfect yet?"
3. "What am I willing to do to make it the way I want it?"
4. "What am I willing to no longer do to make it the way I want it?"
5. "How can I enjoy the process while doing what's necessary?"

**Implementation Notes**:
- Designed to shift from victim to empowered mindset
- Questions progress from acceptance to action
- Emphasizes enjoyment and process over outcome fixation

### Quality Questions for Better Life

**Morning Empowerment Questions**:
- "What am I happy about in my life now?"
- "What am I excited about in my life now?"
- "What am I proud about in my life now?"
- "What am I grateful for in my life now?"
- "What am I enjoying most in my life right now?"
- "What am I committed to in my life right now?"
- "Who do I love? Who loves me?"

**Evening Reflection Questions**:
- "What have I given today?"
- "What did I learn today?"
- "How has today added to the quality of my life?"
- "How can I use today as an investment in my future?"

## Marshall Goldsmith Leadership Questions

### Leadership and Personal Development

**Self-Improvement Focus**:
- "How can I get better?" (vs. "How do you feel about me?")
- "Is it worth it?" (before making critical comments)
- "What can I do differently in the future?"
- "How might we approach this differently?"

**Feedback and Growth Questions**:
- "What should I keep doing?"
- "What should I start doing?"
- "What should I stop doing?"
- "How can I be a better leader/partner/friend?"

**Before Critical Conversations**:
- "Will this comment help us move forward?"
- "Is this worth the potential damage to our relationship?"
- "What outcome am I trying to achieve with this feedback?"

**Implementation for Voice Journaling**:
- Use before difficult conversations or decisions
- Apply weekly for relationship and leadership development
- Focus on forward-looking improvement rather than past criticism

## Martha Beck Wayfinder Questions

### Core Wayfinder Inquiry Method

**Life Navigation Questions**:
- "How the hell did you get here?"
- "What the hell are you going to do now?"
- "What does your body wisdom tell you about this decision?"
- "What would it look like to follow your North Star on this?"

**Body Wisdom Integration**:
- "What physical sensations arise when you think about this choice?"
- "Where in your body do you feel expansion vs. contraction?"
- "What does your gut instinct tell you about this direction?"

**Authentic Self Questions**:
- "What would you do if you trusted yourself completely?"
- "What feels like freedom to you right now?"
- "What would love do in this situation?"
- "How can you honor your true nature in this decision?"

### Four Technologies of Magic Framework

**Wordlessness**: "What do you know without thinking?"
**Oneness**: "How are you connected to this situation?"
**Imagination**: "What wants to be created through you?"
**Forming**: "What small step can you take toward this vision?"

## Arthur Brooks Failure Journal Questions

### Failure as Growth Opportunity

**Learning from Setbacks**:
- "What did I learn from this failure in the last 30 days?"
- "What good has come from this negative experience?"
- "How has this setback contributed to my growth?"
- "What strengths did I discover through this challenge?"

**Reframing Questions**:
- "How is this failure actually a gift?"
- "What would I tell a friend experiencing this same setback?"
- "What opportunities might emerge from this situation?"
- "How will this experience serve me in the future?"

**Integration and Forward Movement**:
- "What would I do differently if I faced this situation again?"
- "What support or resources would have helped me succeed?"
- "How can I use this experience to help others?"
- "What am I grateful for about this experience?"

**Research Foundation**: Arthur Brooks' framework is based on research showing that actively processing failure reduces shame and increases resilience compared to gratitude journaling alone.

## Jerry Colonna Radical Self-Inquiry Questions

### Core Self-Inquiry Framework

Jerry Colonna's approach to radical self-inquiry and leadership development:

**The Complicity Question**:
- "How am I complicit in creating the conditions I say I don't want?"
- "What am I not saying that needs to be said?"
- "What am I saying that's not being heard?"
- "What's being said that I'm not hearing?"

**Leadership and Authenticity**:
- "How have I been complicit in creating the conditions I say I don't want?"
- "What mask am I wearing? What's behind the mask?"
- "In what ways do I deplete myself and run myself into the ground?"
- "Where am I running from and where to?"

**Shadow Work Questions**:
- "What parts of myself do I need to kill off to become who I'm meant to be?"
- "How is the way I'm working, working against me?"
- "What story from my childhood am I still living out?"
- "What am I unwilling to feel?"

**Values and Purpose**:
- "What does success look like for me?"
- "Why do I do what I do? What is it all for?"
- "What would I do if I weren't afraid?"
- "How much is enough? When will I know I have enough?"

### Organizational and Team Questions

**System Dynamics**:
- "What's the story that no one is telling?"
- "What conversation are we not having that we should be having?"
- "How are we recreating the very problems we're trying to solve?"
- "What would need to be true for this to work?"

**Implementation Notes**:
- These questions often surface deep discomfort and require psychological safety
- Best used with adequate time for processing (20-30 minutes minimum)
- May trigger defensive responses initially; patience and self-compassion essential
- Particularly effective for addressing recurring patterns and systemic issues

## Jeff Bezos Life Reflection Questions

### Long-term Perspective Framework

Adapted from Bezos's 12-question framework for regret minimization:

**Legacy and Impact Questions**:
- "How can you wield your gifts like superpowers to do good?"
- "What story are you building with your choices?"
- "When you're 80, what choices will you be proud of?"
- "What would you regret not trying?"

**Risk and Opportunity Assessment**:
- "What would you do if you knew you had nothing to lose?"
- "What opportunities are you passing up out of fear?"
- "How can you increase your odds of success while minimizing regret?"

**Values and Authenticity**:
- "What unique gifts do you have that you're not fully using?"
- "How can you make decisions from your authentic self rather than external expectations?"
- "What would you choose if no one else would ever know about your decision?"

## Implementation Strategies for Voice Journaling

### Framework Selection Guidelines

**Session Purpose Matching**:
- **Major decisions**: Use Tim Ferriss fear-setting framework
- **Daily challenges**: Apply Tony Robbins problem-solving questions
- **Relationship issues**: Employ Marshall Goldsmith feedback questions
- **Life direction**: Utilize Martha Beck Wayfinder questions
- **Processing setbacks**: Apply Arthur Brooks failure journal approach
- **Recurring patterns**: Use Jerry Colonna radical self-inquiry questions
- **Long-term planning**: Use Jeff Bezos regret minimization framework

### Session Structure Recommendations

**Single Framework Deep Dive (20-30 minutes)**:
1. **Context setting** (2-3 minutes): Establish the situation or challenge
2. **Framework application** (15-20 minutes): Work through complete question set
3. **Integration and next steps** (3-5 minutes): Summarize insights and commitments

**Mixed Framework Approach (15 minutes)**:
1. **Opening question** (2 minutes): Standard "What's on your mind?"
2. **Expert question selection** (10 minutes): Choose 2-3 relevant questions from appropriate framework
3. **Closure** (3 minutes): Integration and forward focus

### Customization and Adaptation

**Personal Style Matching**:
- **Analytical types**: Tim Ferriss systematic approaches
- **Emotional processors**: Martha Beck body wisdom questions
- **Action-oriented**: Tony Robbins reframing questions
- **Relationship-focused**: Marshall Goldsmith interpersonal questions
- **Growth-minded**: Arthur Brooks failure integration questions
- **Pattern-breakers**: Jerry Colonna radical self-inquiry questions

**Cultural Sensitivity**:
- Adapt direct questioning style for indirect communication cultures
- Modify individual-focused questions for collectivist perspectives
- Respect varying comfort levels with emotional expression
- Adjust language formality based on cultural expectations

## Quality Assurance and Effectiveness

### Effectiveness Indicators

**Positive Engagement Signs**:
- Spontaneous insights or "aha" moments during sessions
- Increased emotional clarity and reduced confusion
- Concrete action steps emerging from reflection
- Growing comfort with challenging questions over time

**Framework Adjustment Needs**:
- Repetitive answers without new insights
- Emotional overwhelm or shutdown responses
- Avoidance of certain question types
- Lack of practical application or follow-through

### Integration Best Practices

**Follow-Through Support**:
- Document key insights and commitments from expert framework sessions
- Schedule check-ins on action items identified through questioning
- Use simpler daily questions to reinforce insights from deeper sessions
- Connect framework insights to ongoing reflection themes

**Progressive Development**:
- Start with gentler frameworks (Martha Beck, daily practices)
- Build up to more intensive approaches (Tim Ferriss fear-setting)
- Allow users to request specific frameworks based on current needs
- Rotate frameworks to prevent habituation and maintain freshness

## References

### Expert Framework Sources

1. **Tim Ferriss Questions**:
   - Ferriss, Tim. "17 Questions That Changed My Life." https://tim.blog/wp-content/uploads/2020/01/17-Questions-That-Changed-My-Life.pdf
   - "Testing The 'Impossible': 17 Questions That Changed My Life." Tim Ferriss Blog. https://tim.blog/2016/12/07/testing-the-impossible-17-questions-that-changed-my-life/

2. **Tony Robbins Coaching Methods**:
   - "100 lessons from Tony Robbins' Unleash The Power Within (UPW)." CXIA Group. https://www.cxia.com/blog/100-lessons-from-tony-robbins-unleash-the-power-within-upw-7934h
   - "How to Ask Questions and Better Yourself Every Day." Tony Robbins. https://www.tonyrobbins.com/mind-meaning/ask-better-questions/

3. **Marshall Goldsmith Leadership Questions**:
   - "What Got You Here Won't Get You There by Marshall Goldsmith." James Clear. https://jamesclear.com/book-summaries/what-got-you-here-wont-get-you-there
   - "What Got You Here Won't Get You There-Marshall Goldsmith-Book summary." New Age Leadership. https://newageleadership.com/what-got-you-here-wont-get-you-there-marshall-goldsmith-book-summary/

4. **Jeff Bezos Reflection Framework**:
   - "Jeff Bezos Says Asking These 12 Questions Now Will Make You Proud of the Life You've Built Later." Inc. https://www.inc.com/scott-mautz/jeff-bezos-says-asking-these-12-questions-now-will-make-you-proud-of-life-youve-built-later.html
   - "Billionaire Jeff Bezos: To live a happy life with no regrets by age 80, ask yourself these 12 questions." CNBC. https://www.cnbc.com/2019/04/05/amazon-billionaire-ceo-jeff-bezos-ask-yourself-these-12-questions-to-live-a-long-happy-life.html

5. **Arthur Brooks Failure Journal**:
   - Brooks, Arthur C. "Overcoming a Fear of Failure." Arthur C. Brooks. https://arthurbrooks.com/news/podcast/overcoming-a-fear-of-failure
   - "Here's What Happiness Expert Says is Better than Gratitude Journaling." Medium. https://medium.com/@ginarancano/heres-what-happiness-expert-says-is-better-than-gratitude-journaling-aebe38f571ae

6. **Martha Beck Methodologies**:
   - Beck, Martha. "Finding Your Way in a Wild New World" - Core Wayfinder principles and body wisdom techniques

7. **Jerry Colonna Radical Self-Inquiry**:
   - Colonna, Jerry. "Reboot: Leadership and the Art of Growing Up." HarperOne, 2019.
   - "The Power of Radical Self-Inquiry." Reboot.io. https://www.reboot.io/episode/the-power-of-radical-self-inquiry/
   - "Jerry Colonna on The Tim Ferriss Show." https://tim.blog/2019/08/05/jerry-colonna/