# gjdutils

A comprehensive toolkit for highly effective AI-assisted programming, containing three complementary resource sets:

## 🤖 AI-Assisted Programming Templates

**[docs/](docs/)** - Battle-tested workflows and instructions for AI development

A complete collection of templates, modes, and processes for working effectively with AI coding assistants like Claude Code and Cursor. These have been refined through real-world usage and provide:

- **Structured workflows** for planning, implementing, and maintaining code
- **Specialized modes** for different types of development work (sounding board, detective, surgeon)
- **Documentation practices** that scale with your project
- **Git workflows** optimized for AI collaboration

**Quick start**: See [docs/WORKFLOW.md](docs/WORKFLOW.md) for the complete development workflow.

## 🐍 Python Utilities

**[src/gjdutils/](src/gjdutils/)** - Production-ready Python utilities and tools

A curated collection of Python utilities for common development tasks including:

- Data science helpers and collection utilities
- LLM integration tools (Claude, OpenAI)
- File processing and automation scripts
- Development workflow tools

**Quick start**: `pip install gjdutils` (see [src/gjdutils/README.md](src/gjdutils/README.md))

## ⚒️ TypeScript Utilities

**[src/ts/](src/ts/)** - Cross-platform TypeScript tools and CLI utilities

A collection of battle-tested TypeScript utilities ported from real-world development workflows:

- **CLI tools** for date generation, conversation extraction, and code analysis
- **Git worktree sync** scripts for managing parallel development branches
- **LLM critique tools** for automated planning document review
- **Development utilities** like line counting and file processing

**Quick start**: See [src/ts/README.md](src/ts/README.md) for installation and usage examples

## Why gjdutils?

All components are designed around the principle of **making AI-assisted development more effective**:

- The **templates** provide the structure and process for working with AI assistants
- The **Python utilities** handle data science and LLM integration tasks
- The **TypeScript utilities** provide cross-platform development workflow tools

Whether you're building prototypes or production systems, gjdutils helps you work faster and more reliably with AI assistance.

## License

MIT License - see [LICENSE](LICENSE) for details.