# gjdutils Documentation

This documentation collection provides templates and workflows for highly effective AI-assisted programming, developed June 2025.

## Quick Start

- **[WORKFLOW.md](WORKFLOW.md)** - Complete workflow for AI-assisted development using Claude Code or Cursor

## Documentation Structure

### 📋 [instructions/](instructions/)
Commands, modes, and processes for AI-assisted development:
- **Modes**: `SOUNDING_BOARD_MODE.md`, `SCIENTIST_DETECTIVE_MODE.md`, `SURGEON_MODE.md`
- **Planning**: `WRITE_PLANNING_DOC.md`, `DO_PLANNING_DOC.md`, `CRITIQUE_OF_PLANNING_DOC.md`
- **Documentation**: `WRITE_EVERGREEN_DOC.md`, `WRITE_DEEP_DIVE_AS_DOC.md`
- **Maintenance**: `UPDATE_HOUSEKEEPING_DOCUMENTATION.md`, `DEBRIEF_PROGRESS.md`
- **Development**: `CODING_PRINCIPLES.md`, `GIT_COMMITS.md`

### 📚 [reference/](reference/)
gjdutils-specific reference documentation:
- **Development**: `TESTING_PYTHON.md`, `CODING_SHELL_SCRIPTS.md`
- **Organization**: `DOCUMENTATION_ORGANISATION.md`

## About gjdutils

This is part of the [gjdutils project](../README.md) - a collection of:
1. AI-assisted programming workflows (this documentation)
2. Python utilities and scripts ([src/gjdutils/](../src/gjdutils/))
3. TypeScript CLI tools and development utilities ([src/ts/](../src/ts/))

These templates have been battle-tested in real development projects and are designed to work with both Claude Code and Cursor.