Perform a technical audit/review.

- If a feature/area/question/file has been mentioned, use that to guide your investigation.
- If a planning doc has been mentioned, check whether recent changes (e.g. recent related Git commits, and also uncommitted changes) implement the planning doc correctly.
- Look for bugs, gotchas, potential problems
- Is there anything you would refactor (e.g. too-large files/functions, near-duplicated code that could be reused), or architectural best practices we should use?
- Anything else you notice that could be improved?
- Zoom out to consider whether the overall strategy/approach is sound.

For background, read relevant docs if they exist (they may have different names), e.g.:
- `README.md`
- `PRODUCT_VISION_FEATURES.md`
- `CODING_PRINCIPLES_GUIDELINES.md`
- `docs/instructions/WRITE_EVERGREEN_DOC.md`
- `docs/instructions/WRITE_PLANNING_DOC.md`
- and any other relevant docs

Don't make changes. Just investigate, discuss.

Output:
- Prioritise recommendations based on a combination of ease and value.
- Indicate how important each finding is and why, whether there's an obvious fix or multiple options, and how complex/risky you expect it to be.

Ultrathink.
