# Critique of Planning Document

Read this planning document, and all relevant code & documentation.

Review progress, evaluate the approach taken so far, and what's proposed for the next stages. Evaluate the proposal thoroughly. Has it adequately characterised/understood the problem? Will its solution address it? Focus especially on things that seem to be causing problems, or that you think could become a problem in the future. Are there things that haven't been considered, potential problems/concerns, anything inconsistent or unclear? Is there a better way? In general try to help make sure that our plan is as good as it can be.

Explore, investigate, search the web, ask for clarification, discuss, critique, make proposals.

If the user has asked you to, update the planning document (e.g. with an Appendix "Critique of planning doc"). But don't make any changes to the code beyond that critique.

## Evaluation Framework

### Problem Understanding
- Is the problem clearly defined and well-understood?
- Are the root causes identified correctly?
- Are we solving the right problem, or just symptoms?
- What assumptions are being made, and are they valid?

### Solution Approach
- Does the proposed solution adequately address the problem?
- Are there simpler approaches that would achieve the same goals?
- What are the trade-offs and have they been considered?
- Are there alternative approaches worth exploring?

### Technical Implementation
- Is the technical approach sound and well-architected?
- Are there potential scalability, maintainability, or performance issues?
- What technical risks or complexity hasn't been addressed?
- Are the dependencies and integrations well-understood?

### Scope and Priorities
- Is the scope appropriate for the problem size?
- Are the priorities aligned with business/project value?
- What could be deferred or simplified without significant impact?
- Are there quick wins that could be prioritized?

### Risk Assessment
- What could go wrong with this approach?
- What external dependencies or unknowns exist?
- How will success be measured?
- What's the fallback plan if this approach doesn't work?

### Resource and Timeline
- Are the time estimates realistic?
- What skills or resources are needed that might not be available?
- Are there blockers or dependencies that could delay progress?
- What's the minimum viable version of this plan?

## Research and Investigation

- Search for similar problems and solutions in the industry
- Investigate relevant libraries, frameworks, or tools
- Look for case studies or best practices
- Check for recent developments that might change the approach

## Critique Output

Structure your critique to be constructive and actionable:

1. **Strengths** - What's working well in the current plan
2. **Concerns** - Specific issues or risks you've identified
3. **Alternatives** - Different approaches worth considering
4. **Recommendations** - Specific changes or improvements to make
5. **Questions** - Areas that need clarification or further investigation

Remember: The goal is to strengthen the plan, not just find problems. Focus on making the plan as robust and effective as possible.