# Documentation organisation

## References

- `../README.md`
- `../instructions/WRITE_EVERGREEN_DOC.md`


## Evergreen documentation Reference

(Written based on `../instructions/WRITE_EVERGREEN_DOC.md`)

Available evergreen documentation in `docs/` - here are the most useful gjdutils templates.

Coding & infrastructure:
- `../instructions/CODING_PRINCIPLES.md` - Outlines development principles prioritising simplicity, readability, debugging, and rapid prototyping for early-stage development
- `CODING_SHELL_SCRIPTS.md` - Guidelines for writing shell scripts and command-line utilities
- `TESTING_PYTHON.md` - Testing approach documentation covering Python test framework setup, test structure, and coverage


Docs, modes, and admin:
- `../instructions/GIT_COMMITS.md` - Guidelines for Git commit best practices including batching changes, message format, and handling concurrent changes
- `../instructions/SOUNDING_BOARD_MODE.md` - Instructions for collaborative discussion mode emphasising asking questions and suggesting alternatives rather than immediate implementation
- `../instructions/SCIENTIST_DETECTIVE_MODE.md` - Methodical investigation approach for complex debugging and analysis
- `../instructions/SURGEON_MODE.md` - Precise, minimal-change approach for critical fixes
- `../instructions/WRITE_EVERGREEN_DOC.md` - Guidelines for writing evergreen documentation including structure, cross-references, status indicators, and maintenance practices
- `../instructions/WRITE_PLANNING_DOC.md` - Guide for writing planning/project management documents with file naming conventions, structure, and stage-based action plans
- `../instructions/UPDATE_HOUSEKEEPING_DOCUMENTATION.md` - Process for keeping project documentation up-to-date including review steps, update patterns, and quality checklist
- `../instructions/DEBRIEF_PROGRESS.md` - Process for reviewing and documenting project progress and decisions
- `../instructions/RESEARCH_POTENTIAL_LIBRARY_CHANGES_GOTCHAS.md` - Guide for researching and evaluating new libraries and dependencies

## Planning docs

(Written based on `../instructions/WRITE_PLANNING_DOC.md`)

Recent planning decisions & progress-tracking of major features: `planning/*.md` (project-specific location)
