# Configuration file for the Sphinx documentation builder.
#
# For a full list of options, see
# https://www.sphinx-doc.org/en/master/usage/configuration.html

# -- Project information ---------------------------------------------------------------

project = "sdmx"
copyright = "2014–%Y sdmx1 developers"
author = "sdmx1 developers"


# -- General configuration -------------------------------------------------------------

# Sphinx extension module names
extensions = [
    "sphinx.ext.autodoc",
    "sphinx.ext.autosummary",
    "sphinx.ext.extlinks",
    "sphinx.ext.intersphinx",
    "sphinx.ext.linkcode",
    "sphinx.ext.napoleon",
    "sphinx.ext.todo",
    "IPython.sphinxext.ipython_console_highlighting",
    "IPython.sphinxext.ipython_directive",
]

nitpicky = True

rst_prolog = """
.. role:: py(code)
   :language: python
.. role:: xml(code)
   :language: xml
"""

# -- Options for HTML output -----------------------------------------------------------

GH_URL = "https://github.com/khaeru/sdmx"

html_theme = "furo"

html_theme_options = dict(
    footer_icons=[
        {
            "name": "GitHub",
            "url": GH_URL,
            "html": """
                <svg stroke="currentColor" fill="currentColor" stroke-width="0" viewBox="0 0 16 16">
                    <path fill-rule="evenodd" d="M8 0C3.58 0 0 3.58 0 8c0 3.54 2.29 6.53 5.47 7.59.4.07.55-.17.55-.38 0-.19-.01-.82-.01-1.49-2.01.37-2.53-.49-2.69-.94-.09-.23-.48-.94-.82-1.13-.28-.15-.68-.52-.01-.53.63-.01 1.08.58 1.23.82.72 1.21 1.87.87 2.33.66.07-.52.28-.87.51-1.07-1.78-.2-3.64-.89-3.64-3.95 0-.87.31-1.59.82-2.15-.08-.2-.36-1.02.08-2.12 0 0 .67-.21 2.2.82.64-.18 1.32-.27 2-.27.68 0 1.36.09 2 .27 1.53-1.04 2.2-.82 2.2-.82.44 1.1.16 1.92.08 2.12.51.56.82 1.27.82 2.15 0 3.07-1.87 3.75-3.65 3.95.29.25.54.73.54 1.48 0 1.07-.01 1.93-.01 2.2 0 .21.15.46.55.38A8.013 8.013 0 0 0 16 8c0-4.42-3.58-8-8-8z"></path>
                </svg>
            """,
            "class": "",
        },
    ],
    top_of_page_buttons=["view", "edit"],
    source_repository=GH_URL,
    source_branch="main",
    source_directory="doc/",
)

html_title = "sdmx1"

# -- Options for sphinx.ext.extlinks ---------------------------------------------------

extlinks = {
    "issue": ("https://github.com/khaeru/sdmx/issues/%s", "#%s"),
    "pull": ("https://github.com/khaeru/sdmx/pull/%s", "PR #%s"),
    "gh-user": ("https://github.com/%s", "@%s"),
}


# -- Options for sphinx.ext.intersphinx ------------------------------------------------

intersphinx_mapping = {
    "np": ("https://numpy.org/doc/stable/", None),
    "packaging": ("https://packaging.pypa.io/en/stable", None),
    "pd": ("https://pandas.pydata.org/pandas-docs/stable/", None),
    "py": ("https://docs.python.org/3/", None),
    "requests": ("https://requests.readthedocs.io/en/latest/", None),
    "requests-cache": ("https://requests-cache.readthedocs.io/en/latest/", None),
}

# -- Options for sphinx.ext.linkcode ---------------------------------------------------

LINKCODE_ALIAS = {
    "sdmx/testing": "sdmx/testing/__init__",
}


def linkcode_resolve(domain, info):
    if domain != "py" or not info["module"]:
        return None
    filename = info["module"].replace(".", "/")
    filename = LINKCODE_ALIAS.get(filename, filename)
    return f"https://github.com/khaeru/sdmx/tree/main/{filename}.py"


# -- Options for sphinx.ext.napoleon ---------------------------------------------------

napoleon_preprocess_types = True

# -- Options for sphinx.ext.todo -------------------------------------------------------

# If True, todo and todolist produce output, else they produce nothing
todo_include_todos = True

# -- Options for IPython.sphinxext.ipython_directive -----------------------------------

# Specify if the embedded Sphinx shell should import Matplotlib and set the backend
ipython_mplbackend = ""

# -- Dynamic configuration


def setup(app):
    from importlib import import_module
    from pathlib import Path

    # Update files containing lists of classes
    for mod in "common", "v21", "v30":
        # prefix = f"{mod}." if mod != "common" else ""
        prefix = f"{mod}."
        path = Path(__file__).parent.joinpath("api", f"model-{mod}-list.rst")
        with open(path, "w") as f:
            f.write(".. This file is auto-generated by doc/conf.py.\n\n")
            f.writelines(
                f":obj:`~.{prefix}{name}`\n"
                for name in sorted(import_module(f"sdmx.model.{mod}").__all__)
            )
