---
name: analyze-design
allowed-tools: ['*']
description: Comprehensive circuit analysis - power, routing, and optimization suggestions
argument-hint: [analysis type: power/routing/optimize/all]
---

Perform comprehensive circuit analysis and optimization: **$ARGUMENTS**

🔍 **Design Analysis Options:**

**Power Analysis (`/analyze-design power`):**
- Component power consumption assessment  
- Voltage rail requirements and current demands
- Optimal regulator topology recommendations
- Thermal analysis and protection circuits
- Manufacturing-ready power supply design

**Routing Analysis (`/analyze-design routing`):**
- Signal integrity analysis for high-speed nets
- EMI/EMC considerations and mitigation
- Layer stack recommendations for PCB design  
- Differential pair routing guidelines
- Ground plane and power distribution optimization

**Design Optimization (`/analyze-design optimize`):**
- Performance enhancement opportunities
- Cost reduction through component alternatives
- Reliability improvements and protection measures
- Manufacturing optimization (DFM analysis)
- Future-proofing recommendations

**Complete Analysis (`/analyze-design all`):**
- Full circuit analysis across all domains
- Integrated recommendations considering all constraints
- Prioritized improvement suggestions with impact analysis

**🤖 AI Analysis Process:**
1. **Circuit Scan**: Analyze existing circuit-synth code and component selection
2. **Specialized Expertise**: Deploy domain-specific agents (power-expert, signal-integrity)
3. **Manufacturing Integration**: Verify component availability and constraints
4. **Optimization Engine**: Generate ranked improvement suggestions
5. **Implementation Guide**: Provide specific circuit-synth code changes

**📊 Output Format:**
- **Assessment Summary**: Key findings and metrics
- **Prioritized Recommendations**: Ranked by impact and effort
- **Implementation Plan**: Specific changes with circuit-synth code
- **Verification Steps**: How to validate improvements
- **Alternative Options**: Multiple solutions with trade-off analysis

Use specialized agents to provide professional-grade circuit analysis with actionable, manufacturing-ready recommendations.